       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04220.                                         
COB303 DATE-WRITTEN.  FEB 03 2009.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL DB2 STORED PROCEDURE USED TO          *        
      *  INSERT INTO, UPDATE AND DELETE FROM CSS_XFORMER_TEST AND      *        
      *  CSS_EQUIPMENT. CALLED BY METER INVENTORY.                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/03/09  HB42149    INITIAL VERSION.                         *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04220'.
MSQ017     COPY MFASQLM.
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04220 STARTS HERE'.                  
                                                                        
       01 WS-COUNTER-FIELDS.                                            
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05 PROGRAM-NAME            PIC X(08)      VALUE 'CSR04220'.  
           05 WS-UPDATE-IND           PIC X(01)      VALUE SPACES.      
              88 WS-INSERT                           VALUE 'I'.         
              88 WS-DELETE                           VALUE 'D'.         
              88 WS-UPDATE                           VALUE 'U'.         
           05 WS-SERIAL-NO            PIC X(11)      VALUE SPACES.      
           05 WS-XFORMER-NO           PIC X(09)      VALUE SPACES.      
           05 WS-CURRENT-TRANSFORMER  PIC X(02)      VALUE 'CT'.        
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01 WS-SWITCHES.                                                  
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_EQUIPMENT  - EQ                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_INSTR_XFORMER,IX                                          *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBINXFOR                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_XFORMER_SPEC, XS                                          *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBXSSPEC                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * CSS_XFORMER_TEST, XT                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBXFORM                                                   
           END-EXEC.                                                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01 PARM-UPDATE-IND         PIC X(01).                            
       01 PARM-XFORMER-NO         PIC X(09).                            
       01 PARM-DATE-TEST          PIC X(10).                            
       01 PARM-TIME-TEST          PIC X(8).                             
       01 PARM-CODE-TEST-TYPE     PIC X(01).                            
       01 PARM-CODE-UTIL-TYPE     PIC X(01).                            
       01 PARM-CODE-REPAIR        PIC X(01).                            
       01 PARM-COMPANY-NO         PIC X(02).                            
       01 PARM-REPAIR-DESC        PIC X(44).                            
       01 PARM-CODE-TEST-LOC      PIC X(01).                            
       01 PARM-CODE-TEST-RESULT   PIC X(01).                            
       01 PARM-EQ-TESTER-ID       PIC X(05).                            
COB305 01 PARM-ACCURACY-CLASS-LL        PIC S9(2)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
COB305 01 PARM-ACCURACY-CLASS-FL        PIC S9(2)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
COB305 01 PARM-PH-ANG-ERR-ACCU-LL        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
COB305 01 PARM-PH-ANG-ERR-ACCU-FL        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
COB305 01 PARM-RCF-ACCU-LL        PIC S9(1)V9(5) USAGE COMP-3 VALUE 0.          
COB305 01 PARM-RCF-ACCU-FL        PIC S9(1)V9(5) USAGE COMP-3 VALUE 0.          
       01 PARM-BURDEN-ACCU-LL     PIC X(03).                            
       01 PARM-BURDEN-ACCU-FL     PIC X(03).                            
COB305 01 PARM-AMP-VOLT-ACCU-LL        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
COB305 01 PARM-AMP-VOLT-ACCU-FL        PIC S9(3)V9(2) USAGE COMP-3 
COB305       VALUE 0.          
       01 PARM-SERIAL-NO          PIC X(11).                            
                                                                        
       PROCEDURE DIVISION USING  PARM-UPDATE-IND                        
                                 PARM-XFORMER-NO                        
                                 PARM-DATE-TEST                         
                                 PARM-TIME-TEST                         
                                 PARM-CODE-TEST-TYPE                    
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-CODE-REPAIR                       
                                 PARM-COMPANY-NO                        
                                 PARM-REPAIR-DESC                       
                                 PARM-CODE-TEST-LOC                     
                                 PARM-CODE-TEST-RESULT                  
                                 PARM-EQ-TESTER-ID                      
                                 PARM-ACCURACY-CLASS-LL                 
                                 PARM-ACCURACY-CLASS-FL                 
                                 PARM-PH-ANG-ERR-ACCU-LL                
                                 PARM-PH-ANG-ERR-ACCU-FL                
                                 PARM-RCF-ACCU-LL                       
                                 PARM-RCF-ACCU-FL                       
                                 PARM-BURDEN-ACCU-LL                    
                                 PARM-BURDEN-ACCU-FL                    
                                 PARM-AMP-VOLT-ACCU-LL                  
                                 PARM-AMP-VOLT-ACCU-FL                  
                                 PARM-SERIAL-NO.                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                SELECT                                                  
                   :S-RETURN-CODE  AS RETURN_CODE                       
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*         SELECT                                                          
MFA-TR*            :S-RETURN-CODE  AS RETURN_CODE                               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS                        
                                         THRU 1200-EXIT.                
                                                                        
           MOVE PARM-UPDATE-IND          TO WS-UPDATE-IND.              
           MOVE PARM-XFORMER-NO          TO XT-XFORMER-NO               
                                            EQ-DEVICE-NO                
                                            IX-XFORMER-NO.              
           MOVE PARM-DATE-TEST           TO XT-DATE-TEST.               
           MOVE PARM-TIME-TEST           TO XT-TIME-TEST.               
           MOVE PARM-CODE-TEST-TYPE      TO XT-CODE-TEST-TYPE.          
           MOVE PARM-CODE-UTIL-TYPE      TO XT-CODE-UTIL-TYPE           
                                            EQ-CODE-UTIL-TYPE           
                                            IX-CODE-UTIL-TYPE.          
           MOVE PARM-CODE-REPAIR         TO XT-CODE-REPAIR.             
           MOVE PARM-COMPANY-NO          TO XT-COMPANY-NO               
                                            EQ-COMPANY-NO               
                                            IX-COMPANY-NO.              
           MOVE PARM-REPAIR-DESC         TO XT-REPAIR-DESC.             
           MOVE PARM-CODE-TEST-LOC       TO XT-CODE-TEST-LOC.           
           MOVE PARM-CODE-TEST-RESULT    TO XT-CODE-TEST-RESULT.        
           MOVE PARM-EQ-TESTER-ID        TO XT-EQ-TESTER-ID.            
           MOVE PARM-ACCURACY-CLASS-LL   TO XT-ACCURACY-CLASS-LL.       
           MOVE PARM-ACCURACY-CLASS-FL   TO XT-ACCURACY-CLASS-FL.       
           MOVE PARM-PH-ANG-ERR-ACCU-LL  TO XT-PH-ANG-ERR-ACCU-LL.      
           MOVE PARM-PH-ANG-ERR-ACCU-FL  TO XT-PH-ANG-ERR-ACCU-FL.      
           MOVE PARM-RCF-ACCU-LL         TO XT-RCF-ACCU-LL.             
           MOVE PARM-RCF-ACCU-FL         TO XT-RCF-ACCU-FL.             
           MOVE PARM-AMP-VOLT-ACCU-LL    TO XT-AMP-VOLT-ACCU-LL.        
           MOVE PARM-AMP-VOLT-ACCU-FL    TO XT-AMP-VOLT-ACCU-FL.        
           MOVE PARM-BURDEN-ACCU-LL      TO XT-BURDEN-ACCU-LL.          
           MOVE PARM-BURDEN-ACCU-FL      TO XT-BURDEN-ACCU-FL.          
           MOVE PARM-SERIAL-NO           TO WS-SERIAL-NO.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF   PARM-UPDATE-IND NOT EQUAL ('I' AND 'U' AND 'D')         
             OR PARM-XFORMER-NO EQUAL SPACES                            
              MOVE 9998                       TO WS-ACTIVE-RETURN-CODE  
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '1200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'VALIDATE'                 TO ABEND-FUNCTION         
              MOVE 'N/A'                      TO TABLE-1                
              MOVE 'PARM-UPDATE-IND'          TO TABLE-ELEMENT-1        
              MOVE 'PARM-XFORMER-NO'          TO TABLE-ELEMENT-2        
              MOVE PARM-UPDATE-IND            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-XFORMER-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF   PARM-DATE-TEST EQUAL SPACES                             
             OR PARM-TIME-TEST EQUAL SPACES                             
             OR PARM-CODE-UTIL-TYPE EQUAL SPACES                        
             OR PARM-COMPANY-NO EQUAL SPACES                            
             MOVE 9998                       TO WS-ACTIVE-RETURN-CODE   
             MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
             MOVE '1200'                     TO ACTIVE-PARAGRAPH        
             MOVE 'VALIDATE'                 TO ABEND-FUNCTION          
             MOVE 'N/A'                      TO TABLE-1                 
             MOVE 'PARM-DATE-TEST'           TO TABLE-ELEMENT-1         
             MOVE 'PARM-TIME-TEST'           TO TABLE-ELEMENT-2         
             MOVE 'PARM-CODE-UTIL-TYPE'      TO TABLE-ELEMENT-3         
             MOVE 'PARM-COMPANY-NO'          TO TABLE-ELEMENT-4         
             MOVE PARM-DATE-TEST             TO HOSTVAR-ELEMENT-1       
             MOVE PARM-TIME-TEST             TO HOSTVAR-ELEMENT-2       
             MOVE PARM-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-3       
             MOVE PARM-COMPANY-NO            TO HOSTVAR-ELEMENT-4       
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            PERFORM 7160-GET-CURRENT-DATE         THRU 7160-EXIT.       
            PERFORM 7040-SELECT-SERIAL-NO         THRU 7040-EXIT.       
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               AND EQ-SERIAL-NO EQUAL WS-SERIAL-NO                      
                   CONTINUE                                             
            ELSE                                                        
                ADD +1 TO CTR-ROWS                                      
                IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE 5100 TO WS-ACTIVE-RETURN-CODE                   
                ELSE                                                    
                   MOVE 5200 TO WS-ACTIVE-RETURN-CODE                   
                END-IF                                                  
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
            END-IF                                                      
                                                                        
           PERFORM 7050-SELECT-XFORMER-TYPE-CD   THRU 7050-EXIT         
            IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
              MOVE 5100 TO WS-ACTIVE-RETURN-CODE                        
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
            END-IF                                                      
                                                                        
            EVALUATE TRUE                                               
             WHEN WS-INSERT                                             
               PERFORM 8000-INSERT-XFORMER-TEST   THRU 8000-EXIT        
                                                                        
             WHEN WS-DELETE                                             
               PERFORM 8200-DEL-XFORMER-TEST      THRU 8200-EXIT        
                                                                        
             WHEN WS-UPDATE                                             
               PERFORM 8300-UPDATE-XFORMER-TEST   THRU 8300-EXIT        
            END-EVALUATE                                                
                                                                        
            PERFORM 8100-UPDATE-EQUIPMENT         THRU 8100-EXIT        
                                                                        
            ADD +1 TO CTR-ROWS                                          
            MOVE RS-RETURN-CODE                   TO S-RETURN-CODE.     
                                                                        
       2000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *7040-SELECT-SERIAL-NO.         QUERY3                           *        
      ******************************************************************        
       7040-SELECT-SERIAL-NO.                                           
            EXEC SQL                                                    
              SELECT SERIAL_NO                                          
              INTO  :EQ-SERIAL-NO                                       
              FROM  CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                      
             WHERE  EQ.COMPANY_NO     = :EQ-COMPANY-NO                  
               AND  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
               AND  EQ.DEVICE_NO      = :EQ-DEVICE-NO                   
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT SERIAL_NO                                                  
MFA-TR*       INTO  :EQ-SERIAL-NO                                               
MFA-TR*       FROM  CSS_EQUIPMENT EQ                                            
MFA-TR*      WHERE  EQ.COMPANY_NO     = :EQ-COMPANY-NO                          
MFA-TR*        AND  EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                      
MFA-TR*        AND  EQ.DEVICE_NO      = :EQ-DEVICE-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             CONTINUE                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE '7040'                TO ACTIVE-PARAGRAPH            
              MOVE 'CSS_EQUIPMENT'       TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'XFORMER-NO'          TO TABLE-ELEMENT-3             
              MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      *7050-SELECT-XFORMER-TYPE-CD    QUERY4                           *        
      ******************************************************************        
       7050-SELECT-XFORMER-TYPE-CD.                                     
           EXEC SQL                                                     
             SELECT  XFORMER_TYPE_CD                                    
               INTO  :IX-XFORMER-TYPE-CD                                
               FROM  CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                 
              WHERE  IX.COMPANY_NO       = :IX-COMPANY-NO               
                AND  IX.XFORMER_NO       = :IX-XFORMER-NO               
                AND  IX.CODE_UTIL_TYPE   = :IX-CODE-UTIL-TYPE           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  XFORMER_TYPE_CD                                            
MFA-TR*        INTO  :IX-XFORMER-TYPE-CD                                        
MFA-TR*        FROM  CSS_INSTR_XFORMER IX                                       
MFA-TR*       WHERE  IX.COMPANY_NO       = :IX-COMPANY-NO                       
MFA-TR*         AND  IX.XFORMER_NO       = :IX-XFORMER-NO                       
MFA-TR*         AND  IX.CODE_UTIL_TYPE   = :IX-CODE-UTIL-TYPE                   
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE '7050'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'CSS_INSTR_XFORMER'    TO TABLE-1                 
                 MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1         
                 MOVE 'XFORMER_NO'           TO TABLE-ELEMENT-2         
                 MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3         
                 MOVE IX-COMPANY-NO          TO HOSTVAR-ELEMENT-1       
                 MOVE IX-XFORMER-NO          TO HOSTVAR-ELEMENT-2       
                 MOVE IX-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3       
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT        
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *************************************************************             
      * 7160-GET-CURRENT-DATE                                                   
      *************************************************************             
      *                                                                         
       7160-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :EQ-DATE-LAST-TRAN                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :EQ-DATE-LAST-TRAN      = CURRENT DATE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7160'                TO ACTIVE-PARAGRAPH            
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *8000-INSERT A RECORD INTO CSS_XFORMER_TEST   QUERY1             *        
      ******************************************************************        
       8000-INSERT-XFORMER-TEST.                                        
           EXEC SQL                                                     
             INSERT  INTO CSS_XFORMER_TEST                              
                     ( XFORMER_NO                                       
                      ,DATE_TEST                                        
                      ,TIME_TEST                                        
                      ,CODE_TEST_TYPE                                   
                      ,CODE_UTIL_TYPE                                   
                      ,CODE_REPAIR                                      
                      ,REPAIR_DESC                                      
                      ,CODE_TEST_LOC                                    
                      ,CODE_TEST_RESULT                                 
                      ,EQ_TESTER_ID                                     
                      ,ACCURACY_CLASS_LL                                
                      ,ACCURACY_CLASS_FL                                
                      ,PH_ANG_ERR_ACCU_LL                               
                      ,PH_ANG_ERR_ACCU_FL                               
                      ,RCF_ACCU_LL                                      
                      ,RCF_ACCU_FL                                      
                      ,BURDEN_ACCU_LL                                   
                      ,BURDEN_ACCU_FL                                   
                      ,AMP_VOLT_ACCU_LL                                 
                      ,AMP_VOLT_ACCU_FL                                 
                      ,COMPANY_NO)                                      
             VALUES ( :XT-XFORMER-NO                                    
                     ,IIF(TRY_CONVERT(DATE, :XT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :XT-DATE-TEST
              ) <> 0) OR (LEN(:XT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :XT-DATE-TEST
              ), CONVERT(DATE, :XT-DATE-TEST) )                                
                     ,CIS.CHAR2TIME(:XT-TIME-TEST)                              
                     ,:XT-CODE-TEST-TYPE                                
                     ,:XT-CODE-UTIL-TYPE                                
                     ,:XT-CODE-REPAIR                                   
                     ,:XT-REPAIR-DESC                                   
                     ,:XT-CODE-TEST-LOC                                 
                     ,:XT-CODE-TEST-RESULT                              
                     ,:XT-EQ-TESTER-ID                                  
                     ,:XT-ACCURACY-CLASS-LL                             
                     ,:XT-ACCURACY-CLASS-FL                             
                     ,:XT-PH-ANG-ERR-ACCU-LL                            
                     ,:XT-PH-ANG-ERR-ACCU-FL                            
                     ,:XT-RCF-ACCU-LL                                   
                     ,:XT-RCF-ACCU-FL                                   
                     ,:XT-BURDEN-ACCU-LL                                
                     ,:XT-BURDEN-ACCU-FL                                
                     ,:XT-AMP-VOLT-ACCU-LL                              
                     ,:XT-AMP-VOLT-ACCU-FL                              
                     ,:XT-COMPANY-NO )                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT  INTO CSS_XFORMER_TEST                                      
MFA-TR*              ( XFORMER_NO                                               
MFA-TR*               ,DATE_TEST                                                
MFA-TR*               ,TIME_TEST                                                
MFA-TR*               ,CODE_TEST_TYPE                                           
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,CODE_REPAIR                                              
MFA-TR*               ,REPAIR_DESC                                              
MFA-TR*               ,CODE_TEST_LOC                                            
MFA-TR*               ,CODE_TEST_RESULT                                         
MFA-TR*               ,EQ_TESTER_ID                                             
MFA-TR*               ,ACCURACY_CLASS_LL                                        
MFA-TR*               ,ACCURACY_CLASS_FL                                        
MFA-TR*               ,PH_ANG_ERR_ACCU_LL                                       
MFA-TR*               ,PH_ANG_ERR_ACCU_FL                                       
MFA-TR*               ,RCF_ACCU_LL                                              
MFA-TR*               ,RCF_ACCU_FL                                              
MFA-TR*               ,BURDEN_ACCU_LL                                           
MFA-TR*               ,BURDEN_ACCU_FL                                           
MFA-TR*               ,AMP_VOLT_ACCU_LL                                         
MFA-TR*               ,AMP_VOLT_ACCU_FL                                         
MFA-TR*               ,COMPANY_NO)                                              
MFA-TR*      VALUES ( :XT-XFORMER-NO                                            
MFA-TR*              ,:XT-DATE-TEST                                             
MFA-TR*              ,:XT-TIME-TEST                                             
MFA-TR*              ,:XT-CODE-TEST-TYPE                                        
MFA-TR*              ,:XT-CODE-UTIL-TYPE                                        
MFA-TR*              ,:XT-CODE-REPAIR                                           
MFA-TR*              ,:XT-REPAIR-DESC                                           
MFA-TR*              ,:XT-CODE-TEST-LOC                                         
MFA-TR*              ,:XT-CODE-TEST-RESULT                                      
MFA-TR*              ,:XT-EQ-TESTER-ID                                          
MFA-TR*              ,:XT-ACCURACY-CLASS-LL                                     
MFA-TR*              ,:XT-ACCURACY-CLASS-FL                                     
MFA-TR*              ,:XT-PH-ANG-ERR-ACCU-LL                                    
MFA-TR*              ,:XT-PH-ANG-ERR-ACCU-FL                                    
MFA-TR*              ,:XT-RCF-ACCU-LL                                           
MFA-TR*              ,:XT-RCF-ACCU-FL                                           
MFA-TR*              ,:XT-BURDEN-ACCU-LL                                        
MFA-TR*              ,:XT-BURDEN-ACCU-FL                                        
MFA-TR*              ,:XT-AMP-VOLT-ACCU-LL                                      
MFA-TR*              ,:XT-AMP-VOLT-ACCU-FL                                      
MFA-TR*              ,:XT-COMPANY-NO )                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
             MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
             MOVE '8000'                     TO ACTIVE-PARAGRAPH        
             MOVE 'INSERT'                   TO ABEND-FUNCTION          
             MOVE 'CSS_XFORMER_TEST'         TO TABLE-1                 
             MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1         
             MOVE 'XFORMER_NO'               TO TABLE-ELEMENT-2         
             MOVE 'DATE_TEST'                TO TABLE-ELEMENT-3         
             MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4         
             MOVE XT-COMPANY-NO              TO HOSTVAR-ELEMENT-1       
             MOVE XT-XFORMER-NO              TO HOSTVAR-ELEMENT-2       
             MOVE XT-DATE-TEST               TO HOSTVAR-ELEMENT-3       
             MOVE XT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4       
             PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT            
             PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
             EXIT.                                                      
      ******************************************************************        
      *8100-UPDATE THE EQUIP TABLE FOR LAST TRANS DATE QUERY2          *        
      ******************************************************************        
       8100-UPDATE-EQUIPMENT.                                           
           EXEC SQL                                                     
             UPDATE  EQ                                    
                SET  DATE_LAST_TRAN = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )                
             FROM CSS_EQUIPMENT EQ
              WHERE  COMPANY_NO     = :EQ-COMPANY-NO                    
                AND  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                AND  DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  CSS_EQUIPMENT EQ                                           
MFA-TR*         SET  DATE_LAST_TRAN = :EQ-DATE-LAST-TRAN                        
MFA-TR*       WHERE  COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*         AND  CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*         AND  DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             CONTINUE                                                   
           ELSE                                                         
             MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
             MOVE '8100'                     TO ACTIVE-PARAGRAPH        
             MOVE 'UPDATE'                   TO ABEND-FUNCTION          
             MOVE 'CSS_EQUIPMENT'            TO TABLE-1                 
             MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1         
             MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2         
             MOVE 'DEVICE_NO'                TO TABLE-ELEMENT-3         
      *                                                                         
             MOVE EQ-COMPANY-NO              TO HOSTVAR-ELEMENT-1       
             MOVE EQ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2       
             MOVE EQ-DEVICE-NO               TO HOSTVAR-ELEMENT-3       
             PERFORM 9900-SQL-ERROR-ROUTINE THRU  9900-EXIT             
             PERFORM 9999-END-PROGRAM       THRU  9999-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
             EXIT.                                                      
      ******************************************************************        
      *8200-DELETE THE RECORD IN CSS_XFORMER_TEST QUERY5                        
      ******************************************************************        
       8200-DEL-XFORMER-TEST.                                           
           EXEC SQL                                                     
               DELETE FROM  CSS_XFORMER_TEST                            
                WHERE  COMPANY_NO       = :XT-COMPANY-NO                
                  AND  CODE_UTIL_TYPE   = :XT-CODE-UTIL-TYPE            
                  AND  XFORMER_NO       = :XT-XFORMER-NO                
                  AND  DATE_TEST        = IIF(TRY_CONVERT(DATE, 
                                                          :XT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :XT-DATE-TEST
              ) <> 0) OR (LEN(:XT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :XT-DATE-TEST
              ), CONVERT(DATE, :XT-DATE-TEST) )                 
                  AND  TIME_TEST        = CIS.CHAR2TIME(:XT-TIME-TEST)          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM  CSS_XFORMER_TEST                                    
MFA-TR*         WHERE  COMPANY_NO       = :XT-COMPANY-NO                        
MFA-TR*           AND  CODE_UTIL_TYPE   = :XT-CODE-UTIL-TYPE                    
MFA-TR*           AND  XFORMER_NO       = :XT-XFORMER-NO                        
MFA-TR*           AND  DATE_TEST        = :XT-DATE-TEST                         
MFA-TR*           AND  TIME_TEST        = :XT-TIME-TEST                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '8200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'DELETE'               TO ABEND-FUNCTION            
               MOVE 'CSS_XFORMER_TEST'     TO TABLE-1                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE 'XFORMER_NO'           TO TABLE-ELEMENT-3           
               MOVE 'DATE-TEST'            TO TABLE-ELEMENT-4           
               MOVE XT-COMPANY-NO          TO HOSTVAR-ELEMENT-1         
               MOVE XT-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2         
               MOVE XT-XFORMER-NO          TO HOSTVAR-ELEMENT-3         
               MOVE XT-DATE-TEST           TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
              EXIT.                                                     
      ******************************************************************        
      *8300-UPDATE THE RECORD IN CSS_XFORMER_TEST QUERY6                        
      ******************************************************************        
       8300-UPDATE-XFORMER-TEST.                                        
           EXEC SQL                                                     
               UPDATE  CSS_XFORMER_TEST                                 
                  SET  CODE_TEST_TYPE     = :XT-CODE-TEST-TYPE          
                      ,CODE_REPAIR        = :XT-CODE-REPAIR             
                      ,REPAIR_DESC        = :XT-REPAIR-DESC             
                      ,EQ_TESTER_ID       = :XT-EQ-TESTER-ID            
                      ,ACCURACY_CLASS_FL  = :XT-ACCURACY-CLASS-FL       
                      ,ACCURACY_CLASS_LL  = :XT-ACCURACY-CLASS-LL       
                      ,PH_ANG_ERR_ACCU_FL = :XT-PH-ANG-ERR-ACCU-FL      
                      ,PH_ANG_ERR_ACCU_LL = :XT-PH-ANG-ERR-ACCU-LL      
                      ,RCF_ACCU_FL        = :XT-RCF-ACCU-FL             
                      ,RCF_ACCU_LL        = :XT-RCF-ACCU-LL             
                      ,BURDEN_ACCU_FL     = :XT-BURDEN-ACCU-FL          
                      ,BURDEN_ACCU_LL     = :XT-BURDEN-ACCU-LL          
                      ,AMP_VOLT_ACCU_FL   = :XT-AMP-VOLT-ACCU-FL        
                      ,AMP_VOLT_ACCU_LL   = :XT-AMP-VOLT-ACCU-LL        
               WHERE  COMPANY_NO     = :XT-COMPANY-NO                   
                 AND  CODE_UTIL_TYPE = :XT-CODE-UTIL-TYPE               
                 AND  XFORMER_NO     = :XT-XFORMER-NO                   
                 AND  DATE_TEST      = IIF(TRY_CONVERT(DATE, 
                                                          :XT-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :XT-DATE-TEST
              ) <> 0) OR (LEN(:XT-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :XT-DATE-TEST
              ), CONVERT(DATE, :XT-DATE-TEST) )                    
                 AND  TIME_TEST      = CIS.CHAR2TIME(:XT-TIME-TEST)             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE  CSS_XFORMER_TEST                                         
MFA-TR*           SET  CODE_TEST_TYPE     = :XT-CODE-TEST-TYPE                  
MFA-TR*               ,CODE_REPAIR        = :XT-CODE-REPAIR                     
MFA-TR*               ,REPAIR_DESC        = :XT-REPAIR-DESC                     
MFA-TR*               ,EQ_TESTER_ID       = :XT-EQ-TESTER-ID                    
MFA-TR*               ,ACCURACY_CLASS_FL  = :XT-ACCURACY-CLASS-FL               
MFA-TR*               ,ACCURACY_CLASS_LL  = :XT-ACCURACY-CLASS-LL               
MFA-TR*               ,PH_ANG_ERR_ACCU_FL = :XT-PH-ANG-ERR-ACCU-FL              
MFA-TR*               ,PH_ANG_ERR_ACCU_LL = :XT-PH-ANG-ERR-ACCU-LL              
MFA-TR*               ,RCF_ACCU_FL        = :XT-RCF-ACCU-FL                     
MFA-TR*               ,RCF_ACCU_LL        = :XT-RCF-ACCU-LL                     
MFA-TR*               ,BURDEN_ACCU_FL     = :XT-BURDEN-ACCU-FL                  
MFA-TR*               ,BURDEN_ACCU_LL     = :XT-BURDEN-ACCU-LL                  
MFA-TR*               ,AMP_VOLT_ACCU_FL   = :XT-AMP-VOLT-ACCU-FL                
MFA-TR*               ,AMP_VOLT_ACCU_LL   = :XT-AMP-VOLT-ACCU-LL                
MFA-TR*        WHERE  COMPANY_NO     = :XT-COMPANY-NO                           
MFA-TR*          AND  CODE_UTIL_TYPE = :XT-CODE-UTIL-TYPE                       
MFA-TR*          AND  XFORMER_NO     = :XT-XFORMER-NO                           
MFA-TR*          AND  DATE_TEST      = :XT-DATE-TEST                            
MFA-TR*          AND  TIME_TEST      = :XT-TIME-TEST                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             MOVE PROGRAM-NAME           TO ABEND-PROGRAM               
             MOVE '8300'                 TO ACTIVE-PARAGRAPH            
             MOVE 'UPDATE'               TO ABEND-FUNCTION              
             MOVE 'CSS_XFORMER_TEST'     TO TABLE-1                     
             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1             
             MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2             
             MOVE 'XFORMER_NO'           TO TABLE-ELEMENT-3             
             MOVE 'DATE_TEST'            TO TABLE-ELEMENT-4             
             MOVE XT-COMPANY-NO          TO HOSTVAR-ELEMENT-1           
             MOVE XT-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2           
             MOVE XT-XFORMER-NO          TO HOSTVAR-ELEMENT-3           
             MOVE XT-DATE-TEST           TO HOSTVAR-ELEMENT-4           
             PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT            
             PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
              EXIT.                                                     
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                               
      ****************************************************************          
                                                                        
            EXEC SQL                                                            
              INCLUDE CPDSP300                                                  
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE                                                 *        
      * 9000-SEND-ERROR-RESULT                                         *        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
             END-EXEC.                                                          
