       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04219.                                         
COB303 DATE-WRITTEN.  JAN 27 2009.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC       *        
      *  MOVEMENT AND TRANSFER SCREENS                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/22/08  SJ94244    PROCEDURE ORIGINALLY CODED.              *        
C14744*  10/17/09  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *        
P00462*  02/3/11SB40505    FIX ERROR FOUND DURING SMARTSYNCH TEST               
A01649*  02/27/12  SS95855    CATER FOR NEW LOCATION CODE - N          *        
      *                       ( N - NOT INVENTORIED )                  *        
A05136*  12/22/14  AS7C117    ADDED LOGIC TO UPDATE CSS_ELEC_METER     *        
A05136*            ACT008     TABLE AFTER INSERTING ROW INTO THE TABLE *        
A05136*                       CSS_ELEC_MTR_TEST                        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04219'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04219 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05 CTR-ROWS                  PIC S9(9) COMP VALUE 1.         
                                                                        
       01  WS-MISC-VARIABLES.                                           
           05 WS-SPACE                  PIC X(01)  VALUE ' '.           
                                                                        
       01  WS-DATE-TIMESTAMP.                                           
           05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.         
           05 WS-CURRENT-TIME           PIC X(08) VALUE SPACES.         
           05 WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.         
           05 WS-DATE-MOVE              PIC X(10) VALUE SPACES.         
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-LOCATION-INVENTORY     PIC X(01) VALUE 'A'.            
A01649     05 WS-NOT-INVENTORIED        PIC X(01) VALUE 'N'.            
           05 WS-LOCATION-RETIRE        PIC X(01) VALUE 'I'.            
           05 WS-LOCATION-METER-SHOP    PIC X(01) VALUE 'B'.            
           05 WS-LOCATION-UNKNOWN       PIC X(01) VALUE 'U'.            
           05 WS-LOCATION-EMPLOYEE      PIC X(01) VALUE 'C'.            
           05 WS-LOCATION-AT-CUSTOMER   PIC X(01) VALUE 'J'.            
           05 WS-LOCATION-ATTACHED      PIC X(01) VALUE 'K'.            
           05 WS-LOCATION-OLD-ACCT      PIC X(01) VALUE 'X'.            
           05 WS-DEVICE-TYPE-METER      PIC X(01) VALUE 'M'.            
           05 WS-DEFAULT-TIME-PERIOD    PIC S9(4) USAGE COMP VALUE 0.   
           05 WS-DEFAULT-CAP-TYPE       PIC X(01) VALUE 'A'.            
           05 WS-DEFAULT-TEST-RESULT    PIC X(01) VALUE 'A'.            
           05 WS-MOVEMENT               PIC X(01) VALUE 'M'.            
           05 WS-TRANSFER               PIC X(01) VALUE 'T'.            
                                                                        
       01  WS-NULL-IND.                                                 
           05 WS-EQ-DATE-DIS-OF-NULL    PIC S9(04) COMP VALUE 0.        
           05 WS-LX-DATE-LAST-MOVE-NULL PIC S9(04) COMP VALUE 0.        
           05 WS-LX-DATE-LAST-TRAN-NULL PIC S9(04) COMP VALUE 0.        
           05 WS-EQ-DATE-LAST-MOVE-NULL PIC S9(04) COMP VALUE 0.        
           05 WS-EQ-DATE-LAST-TRAN-NULL PIC S9(04) COMP VALUE 0.        
           05 WS-LX-MTR-STORAGE-NULL    PIC S9(04) COMP VALUE 0.        
                                                                        
       01  WS-INPUT-MISC.                                               
           05 PROGRAM-NAME              PIC X(08) VALUE 'CSR04219'.     
           05 WS-IN-CALL-TYPE           PIC X(01) VALUE SPACES.         
           05 WS-IN-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.         
           05 WS-IN-COMPANY-NO          PIC X(02) VALUE SPACES.         
           05 WS-IN-DEVICE-NO           PIC X(09) VALUE SPACES.         
           05 WS-IN-SERIAL-NO           PIC X(11) VALUE SPACES.         
           05 WS-IN-MOVE-DATE           PIC X(10) VALUE SPACES.         
           05 WS-IN-EQUIP-LOC-ID        PIC X(01) VALUE SPACES.         
           05 WS-IN-MSF-CD              PIC X(03) VALUE SPACES.         
C14744     05 WS-IN-TRANSIT-EMP-ID      PIC X(07) VALUE SPACES.         
                                                                        
      ********************'THIS IS THE ROW RETURN AREA'*****************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.  
           05  RS-ADDITIONAL-MSG        PIC X(30)  VALUE SPACES.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) USAGE COMP VALUE 0.  
           05  S-ADDITIONAL-MSG         PIC X(30) VALUE SPACES          
                                                  JUSTIFIED RIGHT.      
       01  WS-FLAGS.                                                    
           05  WS-EQUIPMENT-EXISTS      PIC X(01) VALUE 'N'.            
               88 EQUIPMENT-EXISTS                VALUE 'Y'.            
           05  WS-METER-ATTCH-EXISTS    PIC X(01) VALUE 'N'.            
               88 METER-ATTCH-EXISTS              VALUE 'Y'.            
           05  WS-MTR-ATT-TYPE-EXISTS   PIC X(01) VALUE 'N'.            
               88 MTR-ATT-TYPE-EXISTS             VALUE 'Y'.            
                                                                        
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT - EQ                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
A05136*                                                                         
A05136******************************************************************        
A05136* CSS_ELEC_METER    - EM                                         *        
A05136******************************************************************        
A05136     EXEC SQL                                                             
A05136        INCLUDE TBELMTR                                                   
A05136     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_MTR_TEST - ET                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATTCHMTS - LX                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATT_MOVE - MP                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQMOVE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_ATT_TEST - LY                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_ATT_TYPE - N5                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST - MV                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS - MA                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    METER_ATTCH CURSOR FOR SELECTING THE ATTACHED CODE          *        
      *    AND DEVICE NUMBER                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE METER_ATTCH CURSOR FOR                            
              SELECT MA.HOW_ATTACHED_CD                                 
                    ,MA.DEVICE_NO                                       
                    ,LX.DATE_LAST_MOVE                                  
                    ,LX.CODE_ATT_TYPE                                   
                    ,LX.COMPANY_NO                                      
                    ,LX.MTR_STORAGE_FAC_CD                              
                    ,LX.EQUIP_LOC_ID                                    
C14744              ,LX.IN_TRANSIT_EMP_ID                               
                 FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)               
                    ,CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                
               WHERE MA.METER_NO        = :MA-METER-NO                  
                 AND MA.COMPANY_NO      = :MA-COMPANY-NO                
                 AND MA.CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE            
                 AND MA.DEVICE_NO       = LX.DEVICE_NO                  
                 AND MA.CODE_UTIL_TYPE  = LX.CODE_UTIL_TYPE             
                 AND MA.COMPANY_NO      = LX.COMPANY_NO                 
               ORDER BY MA.CODE_ATT_TYPE                                
                       ,MA.DEVICE_NO                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER_ATTCH CURSOR FOR                                    
MFA-TR*       SELECT MA.HOW_ATTACHED_CD                                         
MFA-TR*             ,MA.DEVICE_NO                                               
MFA-TR*             ,LX.DATE_LAST_MOVE                                          
MFA-TR*             ,LX.CODE_ATT_TYPE                                           
MFA-TR*             ,LX.COMPANY_NO                                              
MFA-TR*             ,LX.MTR_STORAGE_FAC_CD                                      
MFA-TR*             ,LX.EQUIP_LOC_ID                                            
MFA-TR*             ,LX.IN_TRANSIT_EMP_ID                                       
MFA-TR*          FROM CSS_METER_ATTCHMTS MA                                     
MFA-TR*             ,CSS_EQUIP_ATTCHMTS LX                                      
MFA-TR*        WHERE MA.METER_NO        = :MA-METER-NO                          
MFA-TR*          AND MA.COMPANY_NO      = :MA-COMPANY-NO                        
MFA-TR*          AND MA.CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE                    
MFA-TR*          AND MA.DEVICE_NO       = LX.DEVICE_NO                          
MFA-TR*          AND MA.CODE_UTIL_TYPE  = LX.CODE_UTIL_TYPE                     
MFA-TR*          AND MA.COMPANY_NO      = LX.COMPANY_NO                         
MFA-TR*        ORDER BY MA.CODE_ATT_TYPE                                        
MFA-TR*                ,MA.DEVICE_NO                                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-CALL-TYPE                PIC X(01).                      
       01 PARM-CODE-UTIL-TYPE           PIC X(01).                      
       01 PARM-COMPANY-NO               PIC X(02).                      
       01 PARM-DEVICE-NO                PIC X(09).                      
       01 PARM-SERIAL-NO                PIC X(11).                      
       01 PARM-MOVE-DATE                PIC X(10).                      
       01 PARM-EQUIP-LOC-ID             PIC X(01).                      
       01 PARM-MSF-CD                   PIC X(03).                      
C14744 01 PARM-IN-TRANSIT-EMP-ID        PIC X(07).                      
      *                                                                         
                                                                        
       PROCEDURE DIVISION USING  PARM-CALL-TYPE                         
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-COMPANY-NO                        
                                 PARM-DEVICE-NO                         
                                 PARM-SERIAL-NO                         
                                 PARM-MOVE-DATE                         
                                 PARM-EQUIP-LOC-ID                      
                                 PARM-MSF-CD                            
C14744                           PARM-IN-TRANSIT-EMP-ID.                
                                                                        
      ******************************************************************        
      *0000-MAINLINE                                                   *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100-INITIALIZE                                                 *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                     :S-RETURN-CODE     AS RETURN_CODE                  
                    ,:S-ADDITIONAL-MSG  AS ADDITIONAL_MESSAGE           
                FROM                                                    
                     CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*              :S-RETURN-CODE     AS RETURN_CODE                          
MFA-TR*             ,:S-ADDITIONAL-MSG  AS ADDITIONAL_MESSAGE                   
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           PERFORM 7000-SELECT-CURR-DATE-AND-TIME THRU 7000-EXIT.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *1000-PROCESS-INPUT                                              *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS  THRU 1200-EXIT.       
           MOVE PARM-CALL-TYPE        TO WS-IN-CALL-TYPE.               
           MOVE PARM-CODE-UTIL-TYPE   TO WS-IN-CODE-UTIL-TYPE.          
           MOVE PARM-COMPANY-NO       TO WS-IN-COMPANY-NO.              
           MOVE PARM-DEVICE-NO        TO WS-IN-DEVICE-NO.               
           MOVE PARM-SERIAL-NO        TO WS-IN-SERIAL-NO.               
           MOVE PARM-MOVE-DATE        TO WS-IN-MOVE-DATE.               
           MOVE PARM-EQUIP-LOC-ID     TO WS-IN-EQUIP-LOC-ID.            
           MOVE PARM-MSF-CD           TO WS-IN-MSF-CD.                  
C14744     MOVE PARM-IN-TRANSIT-EMP-ID TO WS-IN-TRANSIT-EMP-ID.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE NOT = 'E' OR                          
              PARM-COMPANY-NO     = SPACES  OR                          
              PARM-DEVICE-NO      = SPACES                              
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-2          
              MOVE 'PARM-DEVICE-NO'         TO TABLE-ELEMENT-3          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-2        
              MOVE PARM-DEVICE-NO           TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000-PROCESS-OUTPUT                                             *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE WS-IN-CALL-TYPE                                     
                                                                        
              WHEN WS-MOVEMENT                                          
                 PERFORM 2100-METER-MOVEMENT   THRU 2100-EXIT           
                                                                        
              WHEN WS-TRANSFER                                          
                 PERFORM 2200-TRANSFER-METERS  THRU 2200-EXIT           
                                                                        
              WHEN OTHER                                                
                 MOVE 9999                  TO WS-ACTIVE-RETURN-CODE    
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '2000'                TO ACTIVE-PARAGRAPH         
                 MOVE 'EVALUATE'            TO ABEND-FUNCTION           
                 MOVE 'WS-IN-CALL-TYPE'     TO TABLE-1                  
                 MOVE WS-IN-CALL-TYPE       TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
                                                                        
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
           MOVE RS-ADDITIONAL-MSG        TO S-ADDITIONAL-MSG.           
           ADD +1                        TO CTR-ROWS.                   
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2100-METER-MOVEMENT                                             *        
      ******************************************************************        
       2100-METER-MOVEMENT.                                             
                                                                        
           IF WS-IN-EQUIP-LOC-ID = 'I'                                  
                                                                        
              MOVE WS-IN-DEVICE-NO       TO MA-METER-NO                 
              MOVE WS-IN-COMPANY-NO      TO MA-COMPANY-NO               
              MOVE WS-IN-CODE-UTIL-TYPE  TO MA-CODE-UTIL-TYPE           
                                                                        
              PERFORM 7150-CHECK-MTR-ATTCH-TYPE    THRU 7150-EXIT       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 5100               TO  RS-RETURN-CODE             
                 PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT      
                 PERFORM 9999-END-PROGRAM          THRU 9999-EXIT       
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 2300-VALIDATION-PROCESS   THRU 2300-EXIT.            
                                                                        
           PERFORM 2400-UPDATE-PROCESS       THRU 2400-EXIT.            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2200-TRANSFER-METERS                                            *        
      ******************************************************************        
       2200-TRANSFER-METERS.                                            
                                                                        
           MOVE WS-IN-DEVICE-NO      TO EQ-DEVICE-NO                    
           MOVE WS-IN-CODE-UTIL-TYPE TO EQ-CODE-UTIL-TYPE               
           MOVE WS-IN-COMPANY-NO     TO EQ-COMPANY-NO                   
                                                                        
           PERFORM 7220-CHECK-EQUIP-EXIST         THRU 7220-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 6200   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           END-IF.                                                      
                                                                        
           IF WS-IN-EQUIP-LOC-ID = 'I'                                  
                MOVE WS-IN-DEVICE-NO         TO MA-METER-NO             
                MOVE WS-IN-CODE-UTIL-TYPE    TO MA-CODE-UTIL-TYPE       
                MOVE WS-IN-COMPANY-NO        TO MA-COMPANY-NO           
                PERFORM 7140-CHECK-MTR-ATTCH-EXISTS THRU 7140-EXIT      
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   MOVE 5100   TO  RS-RETURN-CODE                       
                   PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT     
                   PERFORM 9999-END-PROGRAM         THRU 9999-EXIT      
                END-IF                                                  
           END-IF.                                                      
                                                                        
           PERFORM 2300-VALIDATION-PROCESS        THRU 2300-EXIT.       
                                                                        
           PERFORM 2700-UPDATE-EQUIPMENT-DETAILS  THRU 2700-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2300-VALIDATION-PROCESS                                         *        
      ******************************************************************        
       2300-VALIDATION-PROCESS.                                         
                                                                        
           MOVE WS-IN-DEVICE-NO       TO EQ-DEVICE-NO.                  
           MOVE WS-IN-COMPANY-NO      TO EQ-COMPANY-NO.                 
           MOVE WS-IN-CODE-UTIL-TYPE  TO EQ-CODE-UTIL-TYPE.             
           PERFORM 7310-SELECT-LOCAL-OFFICE        THRU 7310-EXIT.      
                                                                        
           IF WS-IN-SERIAL-NO NOT = EQ-SERIAL-NO                        
              MOVE 5200               TO RS-RETURN-CODE                 
              PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT      
              PERFORM 9999-END-PROGRAM             THRU 9999-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-IN-CALL-TYPE = 'M'                                     
              PERFORM 2500-CHECK-INVALID-MOVEMENT  THRU 2500-EXIT       
           ELSE                                                         
              PERFORM 2600-CHECK-MOVEMENT-WITH-MSG THRU 2600-EXIT       
           END-IF.                                                      
                                                                        
           EVALUATE EQ-CODE-CRNT-LOC                                    
                                                                        
              WHEN WS-LOCATION-INVENTORY                                
A01649        WHEN WS-NOT-INVENTORIED                                   
                 PERFORM 2310-PROCESS-LCTN-INVNTRY                      
                                                         THRU 2310-EXIT 
              WHEN WS-LOCATION-METER-SHOP                               
                 PERFORM 2320-PROCESS-LCTN-MTR-SHOP                     
                                                         THRU 2320-EXIT 
              WHEN WS-LOCATION-EMPLOYEE                                 
                 PERFORM 2330-PROCESS-LCTN-EMPLOYEE      THRU 2330-EXIT 
                                                                        
              WHEN WS-LOCATION-RETIRE                                   
                 PERFORM 2340-PROCESS-LCTN-RETIRE        THRU 2340-EXIT 
                                                                        
              WHEN WS-LOCATION-UNKNOWN                                  
                 PERFORM 2350-PROCESS-LCTN-UNKNOWN       THRU 2350-EXIT 
                                                                        
              WHEN WS-LOCATION-OLD-ACCT                                 
                 PERFORM 2360-PROCESS-LCTN-OLD-ACCT      THRU 2360-EXIT 
                                                                        
              WHEN OTHER                                                
                 MOVE 5800   TO  RS-RETURN-CODE                         
                 PERFORM 2000A-MOVE-RESULT               THRU 2000A-EXIT
                 PERFORM 9999-END-PROGRAM                THRU 9999-EXIT 
                                                                        
           END-EVALUATE.                                                
                                                                        
           IF WS-IN-MOVE-DATE > WS-CURRENT-DATE                         
              MOVE 5900   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT
              PERFORM 9999-END-PROGRAM                   THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
           IF WS-IN-MOVE-DATE < EQ-DATE-LAST-MOVE                       
              MOVE 6000   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT
              PERFORM 9999-END-PROGRAM                   THRU 9999-EXIT 
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2310-PROCESS-LCTN-INVNTRY                                       *        
      ******************************************************************        
       2310-PROCESS-LCTN-INVNTRY.                                       
                                                                        
           EVALUATE WS-IN-EQUIP-LOC-ID                                  
                                                                        
              WHEN WS-LOCATION-INVENTORY                                
A01649           IF EQ-CODE-CRNT-LOC NOT = WS-NOT-INVENTORIED           
                    IF EQ-LOCAL-OFFICE = WS-IN-MSF-CD                   
                       MOVE 5600         TO  RS-RETURN-CODE             
                       PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT       
                       PERFORM 9999-END-PROGRAM   THRU 9999-EXIT        
                    END-IF                                              
A01649           END-IF                                                 
                                                                        
A01649        WHEN WS-NOT-INVENTORIED                                   
              WHEN WS-LOCATION-METER-SHOP                               
              WHEN WS-LOCATION-UNKNOWN                                  
              WHEN WS-LOCATION-EMPLOYEE                                 
              WHEN WS-LOCATION-RETIRE                                   
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 IF WS-IN-CALL-TYPE = 'T'                               
                    MOVE EQ-LOCAL-OFFICE TO  RS-ADDITIONAL-MSG          
                    MOVE 5800            TO  RS-RETURN-CODE             
                    PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT          
                    PERFORM 9999-END-PROGRAM   THRU 9999-EXIT           
                 END-IF                                                 
                                                                        
           END-EVALUATE.                                                
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2320-PROCESS-LCTN-MTR-SHOP                                      *        
      ******************************************************************        
       2320-PROCESS-LCTN-MTR-SHOP.                                      
                                                                        
           EVALUATE WS-IN-EQUIP-LOC-ID                                  
                                                                        
              WHEN WS-LOCATION-METER-SHOP                               
                 IF EQ-LOCAL-OFFICE = WS-IN-MSF-CD                      
                   MOVE 5600            TO  RS-RETURN-CODE              
                   PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT    
                   PERFORM 9999-END-PROGRAM          THRU 9999-EXIT     
                 END-IF                                                 
                                                                        
              WHEN WS-LOCATION-INVENTORY                                
A01649        WHEN WS-NOT-INVENTORIED                                   
              WHEN WS-LOCATION-EMPLOYEE                                 
              WHEN WS-LOCATION-UNKNOWN                                  
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                IF WS-IN-CALL-TYPE = 'T'                                
                   MOVE EQ-LOCAL-OFFICE TO  RS-ADDITIONAL-MSG           
                   MOVE 5800            TO  RS-RETURN-CODE              
                   PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT       
                   PERFORM 9999-END-PROGRAM       THRU 9999-EXIT        
                END-IF                                                  
                                                                        
           END-EVALUATE.                                                
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2330-PROCESS-LCTN-EMPLOYEE                                      *        
      ******************************************************************        
       2330-PROCESS-LCTN-EMPLOYEE.                                      
                                                                        
           EVALUATE WS-IN-EQUIP-LOC-ID                                  
                                                                        
              WHEN WS-LOCATION-UNKNOWN                                  
                CONTINUE                                                
                                                                        
              WHEN OTHER                                                
                 IF WS-IN-CALL-TYPE = 'T'                               
                    MOVE EQ-LOCAL-OFFICE TO  RS-ADDITIONAL-MSG          
                    MOVE 5800            TO  RS-RETURN-CODE             
                    PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT      
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
                 END-IF                                                 
                                                                        
           END-EVALUATE.                                                
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2340-PROCESS-LCTN-RETIRE                                        *        
      ******************************************************************        
       2340-PROCESS-LCTN-RETIRE.                                        
                                                                        
           EVALUATE WS-IN-EQUIP-LOC-ID                                  
              WHEN WS-LOCATION-METER-SHOP                               
                 IF EQ-LOCAL-OFFICE NOT = WS-IN-MSF-CD                  
                    MOVE 5700          TO  RS-RETURN-CODE               
                    PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT    
                    PERFORM 9999-END-PROGRAM         THRU 9999-EXIT     
                 END-IF                                                 
                                                                        
              WHEN WS-LOCATION-UNKNOWN                                  
              WHEN WS-LOCATION-INVENTORY                                
A01649        WHEN WS-NOT-INVENTORIED                                   
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 IF WS-IN-CALL-TYPE = 'T'                               
                    MOVE EQ-LOCAL-OFFICE TO  RS-ADDITIONAL-MSG          
                    MOVE 5800            TO  RS-RETURN-CODE             
                    PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT     
                    PERFORM 9999-END-PROGRAM        THRU 9999-EXIT      
                 END-IF                                                 
           END-EVALUATE.                                                
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2350-PROCESS-LCTN-UNKNOWN                                       *        
      ******************************************************************        
       2350-PROCESS-LCTN-UNKNOWN.                                       
                                                                        
           EVALUATE WS-IN-EQUIP-LOC-ID                                  
              WHEN WS-LOCATION-INVENTORY                                
A01649        WHEN WS-NOT-INVENTORIED                                   
              WHEN WS-LOCATION-METER-SHOP                               
              WHEN WS-LOCATION-EMPLOYEE                                 
              WHEN WS-LOCATION-RETIRE                                   
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE 5800          TO  RS-RETURN-CODE                  
                 PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
           END-EVALUATE.                                                
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2360-PROCESS-LCTN-OLD-ACCT                                      *        
      ******************************************************************        
       2360-PROCESS-LCTN-OLD-ACCT.                                      
                                                                        
           EVALUATE WS-IN-EQUIP-LOC-ID                                  
              WHEN WS-LOCATION-EMPLOYEE                                 
              WHEN WS-LOCATION-UNKNOWN                                  
              WHEN WS-LOCATION-RETIRE                                   
              WHEN WS-LOCATION-INVENTORY                                
A01649        WHEN WS-NOT-INVENTORIED                                   
              WHEN WS-LOCATION-METER-SHOP                               
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE 5800          TO  RS-RETURN-CODE                  
                 PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
           END-EVALUATE.                                                
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2400-UPDATE-PROCESS                                             *        
      ******************************************************************        
       2400-UPDATE-PROCESS.                                             
                                                                        
           MOVE WS-DEVICE-TYPE-METER   TO  MV-CODE-DEVICE-TYPE.         
           MOVE WS-IN-CODE-UTIL-TYPE   TO  MV-CODE-UTIL-TYPE.           
           MOVE WS-IN-DEVICE-NO        TO  MV-DEVICE-NO.                
           MOVE EQ-DATE-LAST-MOVE      TO  MV-DATE-MOVE.                
           MOVE EQ-LOCAL-OFFICE        TO  MV-LOCAL-OFFICE.             
           MOVE WS-IN-COMPANY-NO       TO  MV-COMPANY-NO.               
           MOVE EQ-CRNT-LOC-NO         TO  MV-LOC-NO.                   
           MOVE WS-CURRENT-TIMESTAMP   TO  MV-MOVE-NO.                  
           MOVE EQ-CODE-CRNT-LOC       TO  MV-CODE-CRNT-LOC.            
C14744     MOVE EQ-IN-TRANSIT-EMP-ID   TO  MV-IN-TRANSIT-EMP-ID.        
                                                                        
           PERFORM 8410-INSERT-MOVEMENT-HIST       THRU 8410-EXIT.      
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
                                                                        
              MOVE WS-DEVICE-TYPE-METER   TO EQ-EQUIP-TYPE-CD           
              MOVE WS-IN-MOVE-DATE        TO EQ-DATE-DISPOSED-OF        
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1                  TO WS-EQ-DATE-DIS-OF-NULL     
                                             WS-EQ-DATE-LAST-MOVE-NULL  
              END-IF                                                    
                                                                        
              MOVE WS-IN-DEVICE-NO        TO EQ-DEVICE-NO               
              MOVE WS-IN-CODE-UTIL-TYPE   TO EQ-CODE-UTIL-TYPE          
              MOVE WS-IN-COMPANY-NO       TO EQ-COMPANY-NO              
              MOVE WS-IN-MOVE-DATE        TO EQ-DATE-LAST-MOVE          
              MOVE WS-CURRENT-DATE        TO EQ-DATE-LAST-TRAN          
              MOVE WS-IN-EQUIP-LOC-ID     TO EQ-CODE-CRNT-LOC           
              MOVE WS-IN-MSF-CD           TO EQ-LOCAL-OFFICE            
C14744        MOVE WS-IN-TRANSIT-EMP-ID   TO EQ-IN-TRANSIT-EMP-ID       
                                                                        
              PERFORM 8420-UPDATE-EQUIPMENT        THRU 8420-EXIT       
                                                                        
              INITIALIZE DCLCSS-ELEC-MTR-TEST                           
                                                                        
              MOVE '99999'                TO ET-EQ-TESTER-ID            
              MOVE SPACES                 TO ET-REPAIR-DESC             
              MOVE 'I'                    TO ET-CODE-TEST-TYPE          
              MOVE WS-DEFAULT-TEST-RESULT TO ET-CODE-TEST-RESULT        
              MOVE 'A'                    TO ET-CODE-TEST-LOC           
              MOVE 'R'                    TO ET-CODE-REPAIR             
              MOVE WS-DEFAULT-CAP-TYPE    TO ET-CODE-CAP-TYPE           
              MOVE WS-DEFAULT-TIME-PERIOD TO ET-CODE-TIME-PERIOD        
              MOVE WS-CURRENT-TIME        TO ET-TIME-TEST               
              MOVE WS-CURRENT-DATE        TO ET-DATE-TEST               
              MOVE WS-IN-DEVICE-NO        TO ET-METER-NO                
              MOVE 'E'                    TO ET-CODE-UTIL-TYPE          
              MOVE WS-IN-COMPANY-NO       TO ET-COMPANY-NO              
                                                                        
              PERFORM 8430-INSERT-ELEC-MTR-TEST    THRU 8430-EXIT       
A05136        MOVE ET-CODE-UTIL-TYPE             TO EM-CODE-UTIL-TYPE   
A05136        MOVE ET-METER-NO                   TO EM-METER-NO         
A05136        MOVE ET-DATE-TEST                  TO EM-DATE-LAST-TESTED 
A05136        MOVE ET-COMPANY-NO                 TO EM-COMPANY-NO       
A05136        PERFORM 8435-UPDATE-ELEC-METER       THRU 8435-EXIT       
                                                                        
              MOVE WS-IN-DEVICE-NO        TO MA-METER-NO                
              MOVE WS-IN-COMPANY-NO       TO MA-COMPANY-NO              
              MOVE WS-IN-CODE-UTIL-TYPE   TO MA-CODE-UTIL-TYPE          
                                                                        
              PERFORM 7110-OPEN-METER-ATTCH-CURSOR THRU 7110-EXIT       
              PERFORM 7120-FETCH-METER-ATTCH-CURSOR       THRU 7120-EXIT
              PERFORM 2410-PROCESS-MTR-ATTCH-CURSOR       THRU 2410-EXIT
                          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND       
              PERFORM 7130-CLOSE-METER-ATTCH-CURSOR       THRU 7130-EXIT
           ELSE                                                         
              MOVE WS-DEVICE-TYPE-METER TO EQ-EQUIP-TYPE-CD             
              MOVE WS-IN-DEVICE-NO      TO EQ-DEVICE-NO                 
              MOVE WS-IN-CODE-UTIL-TYPE TO EQ-CODE-UTIL-TYPE            
              MOVE WS-IN-COMPANY-NO     TO EQ-COMPANY-NO                
              MOVE WS-IN-MOVE-DATE      TO EQ-DATE-LAST-MOVE            
C14744        MOVE WS-IN-TRANSIT-EMP-ID  TO EQ-IN-TRANSIT-EMP-ID        
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1 TO WS-EQ-DATE-LAST-MOVE-NULL                   
              END-IF                                                    
                                                                        
              MOVE WS-IN-EQUIP-LOC-ID   TO EQ-CODE-CRNT-LOC             
              MOVE WS-CURRENT-DATE      TO EQ-DATE-LAST-TRAN            
              MOVE WS-IN-MSF-CD         TO EQ-LOCAL-OFFICE              
                                                                        
              PERFORM 8440-UPDATE-CSS-EQUIP               THRU 8440-EXIT
                                                                        
              MOVE WS-IN-DEVICE-NO      TO MA-METER-NO                  
              MOVE WS-IN-COMPANY-NO     TO MA-COMPANY-NO                
              MOVE WS-IN-CODE-UTIL-TYPE TO MA-CODE-UTIL-TYPE            
                                                                        
              PERFORM 7110-OPEN-METER-ATTCH-CURSOR        THRU 7110-EXIT
              PERFORM 7120-FETCH-METER-ATTCH-CURSOR       THRU 7120-EXIT
              PERFORM 2410-PROCESS-MTR-ATTCH-CURSOR       THRU 2410-EXIT
                          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND       
              PERFORM 7130-CLOSE-METER-ATTCH-CURSOR       THRU 7130-EXIT
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2410-PROCESS-MTR-ATTCH-CURSOR                                   *        
      ******************************************************************        
       2410-PROCESS-MTR-ATTCH-CURSOR.                                   
                                                                        
           MOVE MA-DEVICE-NO             TO LX-DEVICE-NO.               
                                                                        
           IF WS-LX-DATE-LAST-MOVE-NULL = -1                            
              MOVE '1900-01-01'          TO WS-DATE-MOVE                
           ELSE                                                         
              MOVE LX-DATE-LAST-MOVE     TO WS-DATE-MOVE                
           END-IF                                                       
                                                                        
           MOVE LX-DEVICE-NO             TO MP-DEVICE-NO                
           MOVE LX-CODE-ATT-TYPE         TO MP-CODE-ATT-TYPE            
           MOVE LX-COMPANY-NO            TO MP-COMPANY-NO               
           MOVE WS-IN-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE           
           MOVE WS-DATE-MOVE             TO MP-DATE-MOVE                
           MOVE WS-CURRENT-TIMESTAMP     TO MP-MOVE-NO                  
           MOVE LX-MTR-STORAGE-FAC-CD    TO MP-MTR-STORAGE-FAC-CD       
           MOVE LX-EQUIP-LOC-ID          TO MP-EQUIP-LOC-ID             
           MOVE WS-IN-DEVICE-NO          TO MP-METER-NO                 
C14744     MOVE WS-IN-TRANSIT-EMP-ID     TO MP-IN-TRANSIT-EMP-ID        
                                                                        
           PERFORM 8450-INSERT-EQUIP-ATT-MOVE      THRU 8450-EXIT       
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
              MOVE 'I'                   TO LX-EQUIP-LOC-ID             
           ELSE                                                         
              MOVE 'K'                   TO LX-EQUIP-LOC-ID             
           END-IF                                                       
                                                                        
                                                                        
           MOVE WS-IN-MOVE-DATE          TO LX-DATE-LAST-MOVE           
                                                                        
           IF WS-IN-MOVE-DATE = SPACES                                  
              MOVE -1 TO WS-LX-DATE-LAST-MOVE-NULL                      
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-DATE          TO LX-DATE-LAST-TRAN           
           MOVE WS-IN-MSF-CD             TO LX-MTR-STORAGE-FAC-CD       
                                                                        
           IF WS-IN-MSF-CD = SPACES                                     
              MOVE -1 TO WS-LX-MTR-STORAGE-NULL                         
           END-IF                                                       
                                                                        
           MOVE WS-IN-COMPANY-NO         TO LX-COMPANY-NO               
                                                                        
           PERFORM 8460-UPDATE-EQUIP-ATTCHMTS      THRU 8460-EXIT       
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
              MOVE WS-IN-COMPANY-NO      TO LY-COMPANY-NO               
              MOVE WS-IN-CODE-UTIL-TYPE  TO LY-CODE-UTIL-TYPE           
              MOVE LX-CODE-ATT-TYPE      TO LY-CODE-ATT-TYPE            
              MOVE LX-DEVICE-NO          TO LY-DEVICE-NO                
              MOVE WS-CURRENT-DATE       TO LY-DATE-TEST                
              MOVE WS-CURRENT-TIME       TO LY-TIME-TEST                
              MOVE SPACES                TO LY-REPAIR-DESC              
              PERFORM 8470-INSERT-EQUIP-ATT-TEST   THRU 8470-EXIT       
           END-IF                                                       
                                                                        
           PERFORM 7120-FETCH-METER-ATTCH-CURSOR   THRU 7120-EXIT.      
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2500-CHECK-INVALID-MOVEMENT                                     *        
      ******************************************************************        
       2500-CHECK-INVALID-MOVEMENT.                                     
                                                                        
           IF EQ-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER                
              MOVE 5300   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-AT-CUSTOMER              
               OR WS-IN-EQUIP-LOC-ID = WS-LOCATION-ATTACHED             
              MOVE 5400   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           IF EQ-CODE-CRNT-LOC = WS-IN-EQUIP-LOC-ID                     
               AND EQ-LOCAL-OFFICE = WS-IN-MSF-CD                       
              MOVE 5500   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2600-CHECK-MOVEMENT-WITH-MSG                                    *        
      ******************************************************************        
       2600-CHECK-MOVEMENT-WITH-MSG.                                    
                                                                        
           IF EQ-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER                
              MOVE EQ-CRNT-LOC-NO  TO  RS-ADDITIONAL-MSG                
              MOVE 5300   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
           IF EQ-CODE-CRNT-LOC = WS-LOCATION-ATTACHED                   
              MOVE 5400   TO  RS-RETURN-CODE                            
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2700-UPDATE-EQUIPMENT-DETAILS.                                  *        
      ******************************************************************        
       2700-UPDATE-EQUIPMENT-DETAILS.                                   
                                                                        
           MOVE WS-DEVICE-TYPE-METER       TO  MV-CODE-DEVICE-TYPE.     
           MOVE WS-IN-CODE-UTIL-TYPE       TO  MV-CODE-UTIL-TYPE.       
           MOVE WS-IN-DEVICE-NO            TO  MV-DEVICE-NO.            
           MOVE EQ-DATE-LAST-MOVE          TO  MV-DATE-MOVE.            
           MOVE EQ-LOCAL-OFFICE            TO  MV-LOCAL-OFFICE.         
           MOVE WS-IN-COMPANY-NO           TO  MV-COMPANY-NO.           
           MOVE EQ-CRNT-LOC-NO             TO  MV-LOC-NO.               
           MOVE WS-CURRENT-TIMESTAMP       TO  MV-MOVE-NO.              
           MOVE EQ-CODE-CRNT-LOC           TO  MV-CODE-CRNT-LOC.        
C14744     MOVE EQ-IN-TRANSIT-EMP-ID       TO  MV-IN-TRANSIT-EMP-ID.    
                                                                        
           PERFORM 8410-INSERT-MOVEMENT-HIST       THRU 8410-EXIT.      
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
              MOVE WS-DEVICE-TYPE-METER    TO EQ-EQUIP-TYPE-CD          
              MOVE WS-IN-MOVE-DATE         TO EQ-DATE-DISPOSED-OF       
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1                   TO WS-EQ-DATE-DIS-OF-NULL    
                                              WS-EQ-DATE-LAST-MOVE-NULL 
              END-IF                                                    
                                                                        
              MOVE WS-IN-DEVICE-NO      TO EQ-DEVICE-NO                 
              MOVE WS-IN-CODE-UTIL-TYPE TO EQ-CODE-UTIL-TYPE            
              MOVE WS-IN-COMPANY-NO     TO EQ-COMPANY-NO                
              MOVE WS-IN-MOVE-DATE      TO EQ-DATE-LAST-MOVE            
              MOVE WS-CURRENT-DATE      TO EQ-DATE-LAST-TRAN            
              MOVE WS-IN-EQUIP-LOC-ID   TO EQ-CODE-CRNT-LOC             
              MOVE WS-IN-MSF-CD         TO EQ-LOCAL-OFFICE              
C14744        MOVE WS-IN-TRANSIT-EMP-ID TO EQ-IN-TRANSIT-EMP-ID         
                                                                        
              PERFORM 8420-UPDATE-EQUIPMENT        THRU 8420-EXIT       
                                                                        
           ELSE                                                         
                                                                        
              MOVE WS-DEVICE-TYPE-METER TO EQ-EQUIP-TYPE-CD             
              MOVE WS-IN-DEVICE-NO      TO EQ-DEVICE-NO                 
              MOVE WS-IN-CODE-UTIL-TYPE TO EQ-CODE-UTIL-TYPE            
              MOVE WS-IN-COMPANY-NO     TO EQ-COMPANY-NO                
              MOVE WS-IN-MOVE-DATE      TO EQ-DATE-LAST-MOVE            
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1 TO WS-EQ-DATE-LAST-MOVE-NULL                   
              END-IF                                                    
                                                                        
              MOVE WS-CURRENT-DATE      TO EQ-DATE-LAST-TRAN            
              MOVE WS-IN-EQUIP-LOC-ID   TO EQ-CODE-CRNT-LOC             
              MOVE WS-IN-MSF-CD         TO EQ-LOCAL-OFFICE              
C14744        MOVE WS-IN-TRANSIT-EMP-ID TO EQ-IN-TRANSIT-EMP-ID         
                                                                        
              PERFORM 8440-UPDATE-CSS-EQUIP        THRU 8440-EXIT       
                                                                        
           END-IF.                                                      
                                                                        
           MOVE WS-IN-DEVICE-NO         TO MA-METER-NO.                 
           MOVE WS-IN-COMPANY-NO        TO MA-COMPANY-NO.               
           MOVE WS-IN-CODE-UTIL-TYPE    TO MA-CODE-UTIL-TYPE.           
                                                                        
           PERFORM 7110-OPEN-METER-ATTCH-CURSOR         THRU 7110-EXIT. 
           PERFORM 7120-FETCH-METER-ATTCH-CURSOR        THRU 7120-EXIT. 
           PERFORM 2710-PROCESS-MTR-ATTCH-CURSOR        THRU 2710-EXIT  
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
           PERFORM 7130-CLOSE-METER-ATTCH-CURSOR        THRU 7130-EXIT. 
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2710-PROCESS-MTR-ATTCH-CURSOR                                   *        
      ******************************************************************        
       2710-PROCESS-MTR-ATTCH-CURSOR.                                   
                                                                        
           MOVE MA-DEVICE-NO             TO LX-DEVICE-NO.               
                                                                        
           IF WS-IN-EQUIP-LOC-ID = WS-LOCATION-RETIRE                   
              IF WS-LX-DATE-LAST-MOVE-NULL = -1                         
                 MOVE '1900-01-01'          TO WS-DATE-MOVE             
              ELSE                                                      
                 MOVE LX-DATE-LAST-MOVE     TO WS-DATE-MOVE             
              END-IF                                                    
                                                                        
              MOVE LX-DEVICE-NO             TO MP-DEVICE-NO             
              MOVE LX-CODE-ATT-TYPE         TO MP-CODE-ATT-TYPE         
              MOVE LX-COMPANY-NO            TO MP-COMPANY-NO            
              MOVE WS-IN-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE        
              MOVE WS-DATE-MOVE             TO MP-DATE-MOVE             
              MOVE WS-CURRENT-TIMESTAMP     TO MP-MOVE-NO               
              MOVE LX-MTR-STORAGE-FAC-CD    TO MP-MTR-STORAGE-FAC-CD    
              MOVE LX-EQUIP-LOC-ID          TO MP-EQUIP-LOC-ID          
              MOVE WS-IN-DEVICE-NO          TO MP-METER-NO              
C14744        MOVE WS-IN-TRANSIT-EMP-ID     TO MP-IN-TRANSIT-EMP-ID     
                                                                        
              PERFORM 8450-INSERT-EQUIP-ATT-MOVE      THRU 8450-EXIT    
                                                                        
              MOVE 'I'                      TO LX-EQUIP-LOC-ID          
              MOVE WS-IN-MOVE-DATE          TO LX-DATE-LAST-MOVE        
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1 TO WS-LX-DATE-LAST-MOVE-NULL                   
              END-IF                                                    
                                                                        
              MOVE WS-CURRENT-DATE          TO LX-DATE-LAST-TRAN        
              MOVE WS-IN-MSF-CD             TO LX-MTR-STORAGE-FAC-CD    
                                                                        
              IF WS-IN-MSF-CD = SPACES                                  
                 MOVE -1 TO WS-LX-MTR-STORAGE-NULL                      
              END-IF                                                    
                                                                        
              MOVE WS-IN-COMPANY-NO         TO LX-COMPANY-NO            
C14744        MOVE WS-IN-TRANSIT-EMP-ID     TO LX-IN-TRANSIT-EMP-ID     
                                                                        
              PERFORM 8460-UPDATE-EQUIP-ATTCHMTS      THRU 8460-EXIT    
                                                                        
              MOVE WS-IN-COMPANY-NO         TO LY-COMPANY-NO            
              MOVE WS-IN-CODE-UTIL-TYPE     TO LY-CODE-UTIL-TYPE        
              MOVE LX-CODE-ATT-TYPE         TO LY-CODE-ATT-TYPE         
              MOVE LX-DEVICE-NO             TO LY-DEVICE-NO             
              MOVE WS-CURRENT-DATE          TO LY-DATE-TEST             
              MOVE WS-CURRENT-TIMESTAMP     TO LY-TIME-TEST             
              MOVE SPACES                   TO LY-REPAIR-DESC           
                                                                        
              PERFORM 8470-INSERT-EQUIP-ATT-TEST      THRU 8470-EXIT    
                                                                        
           ELSE                                                         
                                                                        
              IF WS-LX-DATE-LAST-MOVE-NULL = -1                         
                 MOVE '1900-01-01'       TO WS-DATE-MOVE                
              ELSE                                                      
                 MOVE LX-DATE-LAST-MOVE  TO WS-DATE-MOVE                
              END-IF                                                    
                                                                        
              MOVE LX-DEVICE-NO          TO MP-DEVICE-NO                
              MOVE LX-CODE-ATT-TYPE      TO MP-CODE-ATT-TYPE            
              MOVE LX-COMPANY-NO         TO MP-COMPANY-NO               
              MOVE WS-IN-CODE-UTIL-TYPE  TO MP-CODE-UTIL-TYPE           
              MOVE WS-DATE-MOVE          TO MP-DATE-MOVE                
              MOVE WS-CURRENT-TIMESTAMP  TO MP-MOVE-NO                  
              MOVE LX-MTR-STORAGE-FAC-CD TO MP-MTR-STORAGE-FAC-CD       
              MOVE LX-EQUIP-LOC-ID       TO MP-EQUIP-LOC-ID             
              MOVE WS-IN-DEVICE-NO       TO MP-METER-NO                 
C14744        MOVE WS-IN-TRANSIT-EMP-ID  TO MP-IN-TRANSIT-EMP-ID        
                                                                        
              PERFORM 8450-INSERT-EQUIP-ATT-MOVE      THRU 8450-EXIT    
                                                                        
              MOVE 'K'                   TO LX-EQUIP-LOC-ID             
              MOVE WS-IN-MOVE-DATE       TO LX-DATE-LAST-MOVE           
                                                                        
              IF WS-IN-MOVE-DATE = SPACES                               
                 MOVE -1 TO WS-LX-DATE-LAST-MOVE-NULL                   
              END-IF                                                    
                                                                        
              MOVE WS-CURRENT-DATE       TO LX-DATE-LAST-TRAN           
              MOVE WS-IN-MSF-CD          TO LX-MTR-STORAGE-FAC-CD       
                                                                        
              IF WS-IN-MSF-CD = SPACES                                  
                 MOVE -1 TO WS-LX-MTR-STORAGE-NULL                      
              END-IF                                                    
                                                                        
              MOVE WS-IN-COMPANY-NO      TO LX-COMPANY-NO               
C14744        MOVE WS-IN-TRANSIT-EMP-ID  TO LX-IN-TRANSIT-EMP-ID        
                                                                        
              PERFORM 8460-UPDATE-EQUIP-ATTCHMTS      THRU 8460-EXIT    
           END-IF.                                                      
                                                                        
           PERFORM 7120-FETCH-METER-ATTCH-CURSOR      THRU 7120-EXIT.   
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7000-SELECT-CURR-DATE-AND-TIME                                  *        
      ******************************************************************        
       7000-SELECT-CURR-DATE-AND-TIME.                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIME,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-CURRENT-TIME      = CURRENT TIME                          
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7000'             TO ACTIVE-PARAGRAPH              
               MOVE 'SET'              TO ABEND-FUNCTION                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7110-OPEN-METER-ATTCH-CURSOR                                    *        
      ******************************************************************        
       7110-OPEN-METER-ATTCH-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN METER_ATTCH                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7110'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'METER_ATTCH'        TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7120-FETCH-METER-ATTCH-CURSOR.                                  *        
      ******************************************************************        
       7120-FETCH-METER-ATTCH-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH METER_ATTCH                                         
               INTO :MA-HOW-ATTACHED-CD                                 
                   ,:MA-DEVICE-NO                                       
                   ,:LX-DATE-LAST-MOVE :WS-LX-DATE-LAST-MOVE-NULL        
                   ,:LX-CODE-ATT-TYPE                                   
                   ,:LX-COMPANY-NO                                      
                   ,:LX-MTR-STORAGE-FAC-CD :WS-LX-MTR-STORAGE-NULL       
                   ,:LX-EQUIP-LOC-ID                                    
C14744             ,:LX-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'METER_ATTCH'        TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7130-CLOSE-METER-ATTCH-CURSOR                                   *        
      ******************************************************************        
       7130-CLOSE-METER-ATTCH-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE METER_ATTCH                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7130'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'METER_ATTCH'        TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7140-CHECK-MTR-ATTCH-EXISTS                                     *        
      ******************************************************************        
       7140-CHECK-MTR-ATTCH-EXISTS.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-METER-ATTCH-EXISTS                             
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                    ,CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                  
               WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE              
                 AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE               
                 AND N5.DEVICE_TYPE_CD = 'A'                            
                 AND MA.METER_NO       = :MA-METER-NO                   
                 AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             
                 AND MA.COMPANY_NO     = :MA-COMPANY-NO                 
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-METER-ATTCH-EXISTS                                     
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                                      
MFA-TR*             ,CSS_MTR_ATT_TYPE N5                                        
MFA-TR*        WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE                      
MFA-TR*          AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE                       
MFA-TR*          AND N5.DEVICE_TYPE_CD = 'A'                                    
MFA-TR*          AND MA.METER_NO       = :MA-METER-NO                           
MFA-TR*          AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                     
MFA-TR*          AND MA.COMPANY_NO     = :MA-COMPANY-NO                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7140                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7140'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7150-CHECK-MTR-ATTCH-TYPE                                       *        
      ******************************************************************        
       7150-CHECK-MTR-ATTCH-TYPE.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MTR-ATT-TYPE-EXISTS                            
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
               WHERE MA.METER_NO         = :MA-METER-NO                 
                 AND MA.COMPANY_NO       = :MA-COMPANY-NO               
                 AND MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE           
                 AND MA.HOW_ATTACHED_CD  <> 'I'                         
                 AND EXISTS                                             
                    (SELECT 1                                           
                        FROM CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)          
                       WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE      
                         AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE       
                         AND N5.CODE_DEVICE_TYPE = 'Q')                 
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MTR-ATT-TYPE-EXISTS                                    
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                                      
MFA-TR*        WHERE MA.METER_NO         = :MA-METER-NO                         
MFA-TR*          AND MA.COMPANY_NO       = :MA-COMPANY-NO                       
MFA-TR*          AND MA.CODE_UTIL_TYPE   = :MA-CODE-UTIL-TYPE                   
MFA-TR*          AND MA.HOW_ATTACHED_CD  <> 'I'                                 
MFA-TR*          AND EXISTS                                                     
MFA-TR*             (SELECT 1                                                   
MFA-TR*                 FROM CSS_MTR_ATT_TYPE N5                                
MFA-TR*                WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE              
MFA-TR*                  AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE               
MFA-TR*                  AND N5.CODE_DEVICE_TYPE = 'Q')                         
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7150'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7220-CHECK-EQUIP-EXIST.                                         *        
      ******************************************************************        
       7220-CHECK-EQUIP-EXIST.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-EQUIPMENT-EXISTS                               
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-EQUIPMENT-EXISTS                                       
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7220'               TO ACTIVE-PARAGRAPH             
              MOVE 'VALIDATE'           TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *7310-SELECT-LOCAL-OFFICE                                        *        
      ******************************************************************        
       7310-SELECT-LOCAL-OFFICE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE                                       
                    ,CODE_CRNT_LOC                                      
                    ,SERIAL_NO                                          
                    ,CRNT_LOC_NO                                        
                    ,DATE_LAST_MOVE                                     
                    ,EQUIP_COMMENTS_TX                                  
C14744              ,IN_TRANSIT_EMP_ID                                  
                INTO :EQ-LOCAL-OFFICE                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-SERIAL-NO                                      
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-DATE-LAST-MOVE :WS-EQ-DATE-LAST-MOVE-NULL      
                    ,:EQ-EQUIP-COMMENTS-TX                              
C14744              ,:EQ-IN-TRANSIT-EMP-ID                              
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE                                               
MFA-TR*             ,CODE_CRNT_LOC                                              
MFA-TR*             ,SERIAL_NO                                                  
MFA-TR*             ,CRNT_LOC_NO                                                
MFA-TR*             ,DATE_LAST_MOVE                                             
MFA-TR*             ,EQUIP_COMMENTS_TX                                          
MFA-TR*             ,IN_TRANSIT_EMP_ID                                          
MFA-TR*         INTO :EQ-LOCAL-OFFICE                                           
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                          
MFA-TR*             ,:EQ-SERIAL-NO                                              
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,:EQ-DATE-LAST-MOVE :WS-EQ-DATE-LAST-MOVE-NULL              
MFA-TR*             ,:EQ-EQUIP-COMMENTS-TX                                      
MFA-TR*             ,:EQ-IN-TRANSIT-EMP-ID                                      
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7310                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7310'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8410-INSERT-MOVEMENT-HIST                                       *        
      ******************************************************************        
       8410-INSERT-MOVEMENT-HIST.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MOVEMENT_HIST                             
              (                                                         
                CODE_DEVICE_TYPE                                        
               ,CODE_UTIL_TYPE                                          
               ,DEVICE_NO                                               
               ,DATE_MOVE                                               
               ,LOCAL_OFFICE                                            
               ,COMPANY_NO                                              
               ,LOC_NO                                                  
               ,MOVE_NO                                                 
               ,CODE_CRNT_LOC                                           
C14744         ,IN_TRANSIT_EMP_ID                                       
              )                                                         
              VALUES                                                    
              (                                                         
                :MV-CODE-DEVICE-TYPE                                    
               ,:MV-CODE-UTIL-TYPE                                      
               ,:MV-DEVICE-NO                                           
               ,IIF(TRY_CONVERT(DATE, :MV-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MV-DATE-MOVE
              ) <> 0) OR (LEN(:MV-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MV-DATE-MOVE
              ), CONVERT(DATE, :MV-DATE-MOVE) )                                
               ,:MV-LOCAL-OFFICE                                        
               ,:MV-COMPANY-NO                                          
               ,:MV-LOC-NO                                              
               ,CIS.CHAR2TIMESTAMP(:MV-MOVE-NO)                                 
               ,:MV-CODE-CRNT-LOC                                       
C14744         ,:MV-IN-TRANSIT-EMP-ID                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MOVEMENT_HIST                                     
MFA-TR*       (                                                                 
MFA-TR*         CODE_DEVICE_TYPE                                                
MFA-TR*        ,CODE_UTIL_TYPE                                                  
MFA-TR*        ,DEVICE_NO                                                       
MFA-TR*        ,DATE_MOVE                                                       
MFA-TR*        ,LOCAL_OFFICE                                                    
MFA-TR*        ,COMPANY_NO                                                      
MFA-TR*        ,LOC_NO                                                          
MFA-TR*        ,MOVE_NO                                                         
MFA-TR*        ,CODE_CRNT_LOC                                                   
MFA-TR*        ,IN_TRANSIT_EMP_ID                                               
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*         :MV-CODE-DEVICE-TYPE                                            
MFA-TR*        ,:MV-CODE-UTIL-TYPE                                              
MFA-TR*        ,:MV-DEVICE-NO                                                   
MFA-TR*        ,:MV-DATE-MOVE                                                   
MFA-TR*        ,:MV-LOCAL-OFFICE                                                
MFA-TR*        ,:MV-COMPANY-NO                                                  
MFA-TR*        ,:MV-LOC-NO                                                      
MFA-TR*        ,:MV-MOVE-NO                                                     
MFA-TR*        ,:MV-CODE-CRNT-LOC                                               
MFA-TR*        ,:MV-IN-TRANSIT-EMP-ID                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8410'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_MOVEMENT_HIST'  TO TABLE-1                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-2              
              MOVE 'DATE_MOVE'          TO TABLE-ELEMENT-3              
              MOVE 'MOVE_NO'            TO TABLE-ELEMENT-4              
              MOVE MV-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE MV-DEVICE-NO         TO HOSTVAR-ELEMENT-2            
              MOVE MV-DATE-MOVE         TO HOSTVAR-ELEMENT-3            
              MOVE MV-MOVE-NO           TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8420-UPDATE-EQUIPMENT                                           *        
      ******************************************************************        
       8420-UPDATE-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET                                                    
                     CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                
                    ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC              
                    ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE               
                    ,DATE_LAST_TRAN    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) )     
                    ,DATE_LAST_MOVE    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) )     
                    ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX          
                    ,DATE_DISPOSED_OF  = IIF(TRY_CONVERT(DATE, 
                                                  :EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                                :WS-EQ-DATE-DIS-OF-NULL
              ) )        
C14744              ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID          
               WHERE COMPANY_NO        = :EQ-COMPANY-NO                 
                 AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             
                 AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD              
                 AND DEVICE_NO         = :EQ-DEVICE-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIPMENT                                              
MFA-TR*          SET                                                            
MFA-TR*              CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                        
MFA-TR*             ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                      
MFA-TR*             ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                       
MFA-TR*             ,DATE_LAST_TRAN    = :EQ-DATE-LAST-TRAN                     
MFA-TR*                                  :WS-EQ-DATE-LAST-TRAN-NULL             
MFA-TR*             ,DATE_LAST_MOVE    = :EQ-DATE-LAST-MOVE                     
MFA-TR*                                  :WS-EQ-DATE-LAST-MOVE-NULL             
MFA-TR*             ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX                  
MFA-TR*             ,DATE_DISPOSED_OF  = :EQ-DATE-DISPOSED-OF                   
MFA-TR*                                  :WS-EQ-DATE-DIS-OF-NULL                
MFA-TR*             ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID                  
MFA-TR*        WHERE COMPANY_NO        = :EQ-COMPANY-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD                      
MFA-TR*          AND DEVICE_NO         = :EQ-DEVICE-NO                          
MFA-TR*        QUERYNO 8420                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8420'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'EQUIP_TYPE_CD'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-EQUIP-TYPE-CD     TO HOSTVAR-ELEMENT-3            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8430-INSERT-ELEC-MTR-TEST                                       *        
      ******************************************************************        
       8430-INSERT-ELEC-MTR-TEST.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ELEC_MTR_TEST                             
              (                                                         
                COMPANY_NO                                              
               ,CODE_UTIL_TYPE                                          
               ,METER_NO                                                
               ,DATE_TEST                                               
               ,TIME_TEST                                               
               ,CODE_TIME_PERIOD                                        
               ,CODE_CAP_TYPE                                           
               ,CODE_REPAIR                                             
               ,CODE_TEST_LOC                                           
               ,CODE_TEST_RESULT                                        
               ,TEST_BENCH_ID                                           
               ,CODE_TEST_TYPE                                          
               ,IN_CONSTANT                                             
               ,READ_AF                                                 
               ,DEM_READ_AF                                             
               ,LIGHT_LOAD_ACCU_AF                                      
               ,LIGHT_LOAD_ACCU_AL                                      
               ,READ_AL                                                 
               ,DEM_READ_AL                                             
               ,POWER_FCTR_ACCU_AF                                      
               ,POWER_FCTR_ACCU_AL                                      
               ,REPAIR_DESC                                             
               ,EQ_TESTER_ID                                            
               ,FULL_LOAD_ACCU_AF                                       
               ,FULL_LOAD_ACCU_AL                                       
              )                                                         
              VALUES                                                    
              (                                                         
                :ET-COMPANY-NO                                          
               ,:ET-CODE-UTIL-TYPE                                      
               ,:ET-METER-NO                                            
               ,IIF(TRY_CONVERT(DATE, :ET-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :ET-DATE-TEST
              ) <> 0) OR (LEN(:ET-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :ET-DATE-TEST
              ), CONVERT(DATE, :ET-DATE-TEST) )                                
               ,CIS.CHAR2TIME(:ET-TIME-TEST)                                    
               ,:ET-CODE-TIME-PERIOD                                    
               ,:ET-CODE-CAP-TYPE                                       
               ,:ET-CODE-REPAIR                                         
               ,:ET-CODE-TEST-LOC                                       
               ,:ET-CODE-TEST-RESULT                                    
               ,:ET-TEST-BENCH-ID                                       
               ,:ET-CODE-TEST-TYPE                                      
               ,:ET-IN-CONSTANT                                         
               ,:ET-READ-AF                                             
               ,:ET-DEM-READ-AF                                         
               ,:ET-LIGHT-LOAD-ACCU-AF                                  
               ,:ET-LIGHT-LOAD-ACCU-AL                                  
               ,:ET-READ-AL                                             
               ,:ET-DEM-READ-AL                                         
               ,:ET-POWER-FCTR-ACCU-AF                                  
               ,:ET-POWER-FCTR-ACCU-AL                                  
               ,:ET-REPAIR-DESC                                         
               ,:ET-EQ-TESTER-ID                                        
               ,:ET-FULL-LOAD-ACCU-AF                                   
               ,:ET-FULL-LOAD-ACCU-AL                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ELEC_MTR_TEST                                     
MFA-TR*       (                                                                 
MFA-TR*         COMPANY_NO                                                      
MFA-TR*        ,CODE_UTIL_TYPE                                                  
MFA-TR*        ,METER_NO                                                        
MFA-TR*        ,DATE_TEST                                                       
MFA-TR*        ,TIME_TEST                                                       
MFA-TR*        ,CODE_TIME_PERIOD                                                
MFA-TR*        ,CODE_CAP_TYPE                                                   
MFA-TR*        ,CODE_REPAIR                                                     
MFA-TR*        ,CODE_TEST_LOC                                                   
MFA-TR*        ,CODE_TEST_RESULT                                                
MFA-TR*        ,TEST_BENCH_ID                                                   
MFA-TR*        ,CODE_TEST_TYPE                                                  
MFA-TR*        ,IN_CONSTANT                                                     
MFA-TR*        ,READ_AF                                                         
MFA-TR*        ,DEM_READ_AF                                                     
MFA-TR*        ,LIGHT_LOAD_ACCU_AF                                              
MFA-TR*        ,LIGHT_LOAD_ACCU_AL                                              
MFA-TR*        ,READ_AL                                                         
MFA-TR*        ,DEM_READ_AL                                                     
MFA-TR*        ,POWER_FCTR_ACCU_AF                                              
MFA-TR*        ,POWER_FCTR_ACCU_AL                                              
MFA-TR*        ,REPAIR_DESC                                                     
MFA-TR*        ,EQ_TESTER_ID                                                    
MFA-TR*        ,FULL_LOAD_ACCU_AF                                               
MFA-TR*        ,FULL_LOAD_ACCU_AL                                               
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*         :ET-COMPANY-NO                                                  
MFA-TR*        ,:ET-CODE-UTIL-TYPE                                              
MFA-TR*        ,:ET-METER-NO                                                    
MFA-TR*        ,:ET-DATE-TEST                                                   
MFA-TR*        ,:ET-TIME-TEST                                                   
MFA-TR*        ,:ET-CODE-TIME-PERIOD                                            
MFA-TR*        ,:ET-CODE-CAP-TYPE                                               
MFA-TR*        ,:ET-CODE-REPAIR                                                 
MFA-TR*        ,:ET-CODE-TEST-LOC                                               
MFA-TR*        ,:ET-CODE-TEST-RESULT                                            
MFA-TR*        ,:ET-TEST-BENCH-ID                                               
MFA-TR*        ,:ET-CODE-TEST-TYPE                                              
MFA-TR*        ,:ET-IN-CONSTANT                                                 
MFA-TR*        ,:ET-READ-AF                                                     
MFA-TR*        ,:ET-DEM-READ-AF                                                 
MFA-TR*        ,:ET-LIGHT-LOAD-ACCU-AF                                          
MFA-TR*        ,:ET-LIGHT-LOAD-ACCU-AL                                          
MFA-TR*        ,:ET-READ-AL                                                     
MFA-TR*        ,:ET-DEM-READ-AL                                                 
MFA-TR*        ,:ET-POWER-FCTR-ACCU-AF                                          
MFA-TR*        ,:ET-POWER-FCTR-ACCU-AL                                          
MFA-TR*        ,:ET-REPAIR-DESC                                                 
MFA-TR*        ,:ET-EQ-TESTER-ID                                                
MFA-TR*        ,:ET-FULL-LOAD-ACCU-AF                                           
MFA-TR*        ,:ET-FULL-LOAD-ACCU-AL                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8430'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ELEC_MTR_TEST'  TO TABLE-1                      
              MOVE 'DATE_TEST'          TO TABLE-ELEMENT-1              
              MOVE 'TIME_TEST'          TO TABLE-ELEMENT-2              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-3              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-4              
              MOVE ET-DATE-TEST         TO HOSTVAR-ELEMENT-1            
              MOVE ET-TIME-TEST         TO HOSTVAR-ELEMENT-2            
              MOVE ET-COMPANY-NO        TO HOSTVAR-ELEMENT-3            
              MOVE ET-METER-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05136 8435-UPDATE-ELEC-METER.                                          
A05136*                                                                         
A05136     EXEC SQL                                                     
A05136         UPDATE CSS_ELEC_METER                                    
A05136            SET DATE_LAST_TESTED = IIF(TRY_CONVERT(DATE, 
                                                   :EM-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :EM-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:EM-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:EM-DATE-LAST-TESTED
              ), CONVERT(DATE, :EM-DATE-LAST-TESTED) )           
A05136          WHERE CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE             
A05136            AND COMPANY_NO       = :EM-COMPANY-NO                 
A05136            AND METER_NO         = :EM-METER-NO                   
A05136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ELEC_METER                                            
MFA-TR*           SET DATE_LAST_TESTED = :EM-DATE-LAST-TESTED                   
MFA-TR*         WHERE CODE_UTIL_TYPE   = :EM-CODE-UTIL-TYPE                     
MFA-TR*           AND COMPANY_NO       = :EM-COMPANY-NO                         
MFA-TR*           AND METER_NO         = :EM-METER-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05136*                                                                         
A05136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05136                                                                  
A05136     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136        CONTINUE                                                  
A05136     ELSE                                                         
A05136        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
A05136        MOVE '8435'               TO ACTIVE-PARAGRAPH             
A05136        MOVE 'UPDATE'             TO ABEND-FUNCTION               
A05136        MOVE 'CSS_ELEC_METER   '  TO TABLE-1                      
A05136        MOVE 'DATE_LAST_TESTED'   TO TABLE-ELEMENT-1              
A05136        MOVE 'CODE_UTIL_TYPE  '   TO TABLE-ELEMENT-2              
A05136        MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-3              
A05136        MOVE 'METER_NO'           TO TABLE-ELEMENT-4              
A05136        MOVE EM-DATE-LAST-TESTED  TO HOSTVAR-ELEMENT-1            
A05136        MOVE EM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
A05136        MOVE EM-COMPANY-NO        TO HOSTVAR-ELEMENT-3            
A05136        MOVE EM-METER-NO          TO HOSTVAR-ELEMENT-4            
A05136        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A05136        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A05136     END-IF.                                                      
A05136*                                                                         
A05136 8435-EXIT.                                                       
A05136     EXIT.                                                        
      ******************************************************************        
      *8440-UPDATE-CSS-EQUIP                                           *        
      ******************************************************************        
       8440-UPDATE-CSS-EQUIP.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET                                                    
                     CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                
                    ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC              
                    ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE               
                    ,DATE_LAST_TRAN    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                             :WS-EQ-DATE-LAST-TRAN-NULL
              ) )     
                    ,DATE_LAST_MOVE    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                             :WS-EQ-DATE-LAST-MOVE-NULL
              ) )     
                    ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX          
C14744              ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID          
               WHERE COMPANY_NO        = :EQ-COMPANY-NO                 
                 AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             
                 AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD              
                 AND DEVICE_NO         = :EQ-DEVICE-NO                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIPMENT                                              
MFA-TR*          SET                                                            
MFA-TR*              CRNT_LOC_NO       = :EQ-CRNT-LOC-NO                        
MFA-TR*             ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                      
MFA-TR*             ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                       
MFA-TR*             ,DATE_LAST_TRAN    = :EQ-DATE-LAST-TRAN                     
MFA-TR*                                  :WS-EQ-DATE-LAST-TRAN-NULL             
MFA-TR*             ,DATE_LAST_MOVE    = :EQ-DATE-LAST-MOVE                     
MFA-TR*                                  :WS-EQ-DATE-LAST-MOVE-NULL             
MFA-TR*             ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX                  
MFA-TR*             ,IN_TRANSIT_EMP_ID = :EQ-IN-TRANSIT-EMP-ID                  
MFA-TR*        WHERE COMPANY_NO        = :EQ-COMPANY-NO                         
MFA-TR*          AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD                      
MFA-TR*          AND DEVICE_NO         = :EQ-DEVICE-NO                          
MFA-TR*        QUERYNO 8440                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8440'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'EQUIP_TYPE_CD'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-EQUIP-TYPE-CD     TO HOSTVAR-ELEMENT-3            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8450-INSERT-EQUIP-ATT-MOVE                                      *        
      ******************************************************************        
       8450-INSERT-EQUIP-ATT-MOVE.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATT_MOVE                            
              (                                                         
                DEVICE_NO                                               
               ,CODE_ATT_TYPE                                           
               ,COMPANY_NO                                              
               ,CODE_UTIL_TYPE                                          
               ,DATE_MOVE                                               
               ,MOVE_NO                                                 
               ,MTR_STORAGE_FAC_CD                                      
               ,EQUIP_LOC_ID                                            
               ,METER_NO                                                
C14744         ,IN_TRANSIT_EMP_ID                                       
              )                                                         
              VALUES                                                    
              (                                                         
                :MP-DEVICE-NO                                           
               ,:MP-CODE-ATT-TYPE                                       
               ,:MP-COMPANY-NO                                          
               ,:MP-CODE-UTIL-TYPE                                      
               ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
               ,CIS.CHAR2TIMESTAMP(:MP-MOVE-NO)                                 
               ,:MP-MTR-STORAGE-FAC-CD                                  
               ,:MP-EQUIP-LOC-ID                                        
               ,:MP-METER-NO                                            
C14744         ,:MP-IN-TRANSIT-EMP-ID                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EQUIP_ATT_MOVE                                    
MFA-TR*       (                                                                 
MFA-TR*         DEVICE_NO                                                       
MFA-TR*        ,CODE_ATT_TYPE                                                   
MFA-TR*        ,COMPANY_NO                                                      
MFA-TR*        ,CODE_UTIL_TYPE                                                  
MFA-TR*        ,DATE_MOVE                                                       
MFA-TR*        ,MOVE_NO                                                         
MFA-TR*        ,MTR_STORAGE_FAC_CD                                              
MFA-TR*        ,EQUIP_LOC_ID                                                    
MFA-TR*        ,METER_NO                                                        
MFA-TR*        ,IN_TRANSIT_EMP_ID                                               
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*         :MP-DEVICE-NO                                                   
MFA-TR*        ,:MP-CODE-ATT-TYPE                                               
MFA-TR*        ,:MP-COMPANY-NO                                                  
MFA-TR*        ,:MP-CODE-UTIL-TYPE                                              
MFA-TR*        ,:MP-DATE-MOVE                                                   
MFA-TR*        ,:MP-MOVE-NO                                                     
MFA-TR*        ,:MP-MTR-STORAGE-FAC-CD                                          
MFA-TR*        ,:MP-EQUIP-LOC-ID                                                
MFA-TR*        ,:MP-METER-NO                                                    
MFA-TR*        ,:MP-IN-TRANSIT-EMP-ID                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8450'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATT_MOVE' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'DATE_MOVE'          TO TABLE-ELEMENT-2              
              MOVE 'MOVE_NO'            TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MP-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MP-DATE-MOVE         TO HOSTVAR-ELEMENT-2            
              MOVE MP-MOVE-NO           TO HOSTVAR-ELEMENT-3            
              MOVE MP-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8460-UPDATE-EQUIP-ATTCHMTS                                      *        
      ******************************************************************        
       8460-UPDATE-EQUIP-ATTCHMTS.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIP_ATTCHMTS                                 
                 SET                                                    
                     DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                             :WS-LX-DATE-LAST-MOVE-NULL
              ) )    
                    ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                             :WS-LX-DATE-LAST-TRAN-NULL
              ) )    
                    ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD 
                                          :WS-LX-MTR-STORAGE-NULL       
                    ,EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID              
C14744              ,IN_TRANSIT_EMP_ID  = :LX-IN-TRANSIT-EMP-ID         
               WHERE DEVICE_NO          = :LX-DEVICE-NO                 
                 AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE             
                 AND COMPANY_NO         = :LX-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = 'E'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_EQUIP_ATTCHMTS                                         
MFA-TR*          SET                                                            
MFA-TR*              DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE                    
MFA-TR*                                   :WS-LX-DATE-LAST-MOVE-NULL            
MFA-TR*             ,DATE_LAST_TRAN     = :LX-DATE-LAST-TRAN                    
MFA-TR*                                   :WS-LX-DATE-LAST-TRAN-NULL            
MFA-TR*             ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD                
MFA-TR*                                   :WS-LX-MTR-STORAGE-NULL               
MFA-TR*             ,EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID                      
MFA-TR*             ,IN_TRANSIT_EMP_ID  = :LX-IN-TRANSIT-EMP-ID                 
MFA-TR*        WHERE DEVICE_NO          = :LX-DEVICE-NO                         
MFA-TR*          AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE                     
MFA-TR*          AND COMPANY_NO         = :LX-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*        QUERYNO 8460                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8460'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-3              
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8470-INSERT-EQUIP-ATT-TEST                                      *        
      ******************************************************************        
       8470-INSERT-EQUIP-ATT-TEST.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATT_TEST                            
              (                                                         
                COMPANY_NO                                              
               ,CODE_UTIL_TYPE                                          
               ,CODE_ATT_TYPE                                           
               ,DEVICE_NO                                               
               ,DATE_TEST                                               
               ,TIME_TEST                                               
               ,CODE_TEST_TYPE                                          
               ,CODE_REPAIR                                             
               ,REPAIR_DESC                                             
              )                                                         
              VALUES                                                    
              (                                                         
                :LY-COMPANY-NO                                          
               ,:LY-CODE-UTIL-TYPE                                      
               ,:LY-CODE-ATT-TYPE                                       
               ,:LY-DEVICE-NO                                           
               ,IIF(TRY_CONVERT(DATE, :LY-DATE-TEST
              ) IS NULL OR (PATINDEX('%.%', :LY-DATE-TEST
              ) <> 0) OR (LEN(:LY-DATE-TEST) <> 10), CIS.CHAR2DATE(
                                                          :LY-DATE-TEST
              ), CONVERT(DATE, :LY-DATE-TEST) )                                
               ,CIS.CHAR2TIME(:LY-TIME-TEST)                                    
               ,'A'                                                     
               ,'R'                                                     
               ,:LY-REPAIR-DESC                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_EQUIP_ATT_TEST                                    
MFA-TR*       (                                                                 
MFA-TR*         COMPANY_NO                                                      
MFA-TR*        ,CODE_UTIL_TYPE                                                  
MFA-TR*        ,CODE_ATT_TYPE                                                   
MFA-TR*        ,DEVICE_NO                                                       
MFA-TR*        ,DATE_TEST                                                       
MFA-TR*        ,TIME_TEST                                                       
MFA-TR*        ,CODE_TEST_TYPE                                                  
MFA-TR*        ,CODE_REPAIR                                                     
MFA-TR*        ,REPAIR_DESC                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*         :LY-COMPANY-NO                                                  
MFA-TR*        ,:LY-CODE-UTIL-TYPE                                              
MFA-TR*        ,:LY-CODE-ATT-TYPE                                               
MFA-TR*        ,:LY-DEVICE-NO                                                   
MFA-TR*        ,:LY-DATE-TEST                                                   
MFA-TR*        ,:LY-TIME-TEST                                                   
MFA-TR*        ,'A'                                                             
MFA-TR*        ,'R'                                                             
MFA-TR*        ,:LY-REPAIR-DESC                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8470'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATT_TEST' TO TABLE-1                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'DATE_TEST'          TO TABLE-ELEMENT-2              
              MOVE 'TIME_TEST'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE LY-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE LY-DATE-TEST         TO HOSTVAR-ELEMENT-2            
              MOVE LY-TIME-TEST         TO HOSTVAR-ELEMENT-3            
              MOVE LY-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900- ERROR HANDLING INCLUDE                                  *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE                                                *         
      * 9000-SEND-ERROR-RESULT                                        *         
      * 9999-END-PROGRAM                                              *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
