       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04218.                                         
COB303 DATE-WRITTEN.  JAN 12 2009.                                      
       DATE-COMPILED.                                                   
      *                                                                 00000500
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      *                                                                *00001000
      ******************************************************************00001100
      *                 P R O G R A M  S U M M A R Y                   *00001200
      *                                                                *00001300
      *  SELECT SP CALLED BY METER INVENTORY SYSTEM FOR ALL MOVEMENT   *00001400
      *  SCREENS TO DISPLAY MOVEMENT HISTORY AND RETIEVES THE CURRENT  *00001500
      *  METER LOCATION AND ALL THE MOVEMENTS ASSOCIATED WITH METER    *00001600
      *                                                                *00001700
      ******************************************************************00001800
      *                                                                *00001900
      *                     PROGRAM MODIFICATION LOG                   *00002000
      *                                                                *00002100
      *    DATE    INITIALS   COMMENTS                                 *00002200
      *  --------  --------   ---------------------------------------  *00002300
      *  01/12/09  MH94819    INITIAL VERSION.                         *00002400
C14744*  10/17/09  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *        
A05136*  03/18/15  DB41297    ADD PREMISE-NO                           *        
      *                                                                *00002500
      ******************************************************************00002600
      ******************************************************************00002700
      *                                                                *00002800
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00002900
      *                                                                *00003000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003100
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00003200
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00003300
      *  3000 - 4999  NOT USED                                         *00003400
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00003500
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00003600
      *  7000 - 7999  INPUT MODULES                                    *00003700
      *  8000 - 8999  OUTPUT MODULES                                   *00003800
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00003900
      *                                                                *00004000
      ******************************************************************00004100
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04218'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04218 STARTS HERE'.                  
                                                                        
      ******************************************************************00005000
      * WORK AREAS                                                     *00005100
      ******************************************************************00005200
                                                                        
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04218'.     
           05  WS-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.         
           05  WS-COMPANY-NO           PIC X(02)  VALUE SPACES.         
           05  WS-DEVICE-NO            PIC X(12)  VALUE SPACES.         
           05  WS-METER-NO             PIC X(09)  VALUE SPACES.         
           05  WS-CODE-ATT-TYPE        PIC X(02)  VALUE SPACES.         
           05  WS-CODE-CRNT-LOC        PIC X(01)  VALUE SPACES.         
           05  WS-LOC-DESC-UNKNOWN     PIC X(07)  VALUE 'UNKNOWN'.      
           05  WS-DEVICE-TYPE-METER    PIC X(01)  VALUE 'M'.            
           05  WS-LOC-AT-CUSTOMER      PIC X(01)  VALUE 'J'.            
           05  WS-LOC-ATTACHED         PIC X(01)  VALUE 'K'.            
           05  WS-LOC-OLD-ACCT         PIC X(01)  VALUE 'X'.            
           05  WS-LOC-EMPLOYEE         PIC X(01)  VALUE 'C'.            
           05  WS-LOC-OLD-ACT          PIC X(12)  VALUE 'OLD ACCT NBR'. 
           05  WS-DEVICE-TYPE-XFORMER  PIC X(01)  VALUE 'T'.            
           05  WS-MOVEMNT-ROW-TYPE     PIC X(01)  VALUE SPACES.         
           05  WS-LOCAL-OFFICE         PIC X(03)  VALUE SPACES.         
           05  WS-MSF-DETAIL           PIC X(116) VALUE SPACES.         
C14744     05  WS-IN-TRANSIT-EMP-ID    PIC X(07)  VALUE SPACES.         
           05  WS-DATE-MOVE-IND        PIC S9(4)  COMP.                 
           05  WS-CODE-CRNT-LOC-IND    PIC S9(4)  COMP.                 
           05  WS-LOC-NO-IND           PIC S9(4)  COMP.                 
           05  WS-EQUIP-LOC-DESC-IND   PIC S9(4)  COMP VALUE 0.         
           05  WS-DATE-LAST-MOVE-IND   PIC S9(4)  COMP VALUE 0.         
           05  WS-METER-NO-IND         PIC S9(4)  COMP VALUE 0.         
           05  WS-MTR-STOR-FAC-CD-IND  PIC S9(4)  COMP VALUE 0.         
           05  WS-MTR-STOR-FAC-TX-IND  PIC S9(4)  COMP VALUE 0.         
           05  WS-BLOCK                PIC X(01)  VALUE SPACES.         
           05  WS-COLON                PIC X(02)  VALUE ': '.           
           05  WS-HYPEN                PIC X(01)  VALUE '-'.            
           05  WS-HYPEN2               PIC X(03)  VALUE ' - '.          
           05  WS-LOC-NO               PIC X(10)  VALUE SPACES.         
           05  WS-ROW-COUNT1           PIC S9(9)  COMP VALUE 0.         
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X        OCCURS 117 TIMES                 
                                       INDEXED BY WS-ADD-SUB.           
                   15  FILLER          PIC X.                           
           05  WS-LENGTH               PIC S9(4).                       
           05  WS-MAX-SZ               PIC S9(4).                       
           05  WS-FROM.                                                 
               10  WS-FROM-X           OCCURS 51 TIMES PIC X.           
           05  WS-LOW.                                                  
               10  WS-LOW-X            OCCURS 51 TIMES PIC X.           
           05  WS-HIGH.                                                 
               10  WS-HIGH-X           OCCURS 51 TIMES PIC X.           
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
                                                                        
      ************************THIS IS THE ROW RETURN AREA***************00010500
      *                                                                 00010600
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-MOVEMNT-ROW-TYPE     PIC X(01)  VALUE SPACES.         
           05  RS-EQUIP-LOC-DESC       PIC X(25)  VALUE SPACES.         
           05  RS-MSF-DETAIL           PIC X(117) VALUE SPACES.         
           05  RS-DATE-MOVE            PIC X(10)  VALUE SPACES.         
           05  RS-EQUIP-LOC-ID         PIC X(01)  VALUE SPACES.         
           05  RS-HOW-ATTACHED-CD      PIC X(01)  VALUE SPACES.         
           05  RS-METER-NO             PIC X(09)  VALUE SPACES.         
           05  RS-CODE-CRNT-LOC        PIC X(01)  VALUE SPACES.         
           05  RS-LAST-READ-VALUE      PIC S9(12)V9(3) USAGE COMP-3     
                                                             VALUE 0.   
C14744     05  RS-IN-TRANSIT-EMP-ID    PIC X(07)  VALUE SPACES.         
A05136     05  RS-PREMISE-NO           PIC S9(10) COMP-3 VALUE 0.       
      *                                                                 00011900
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-MOVEMNT-ROW-TYPE      PIC X(01)  VALUE SPACES.         
           05  S-EQUIP-LOC-DESC        PIC X(25)  VALUE SPACES.         
           05  S-MSF-DETAIL            PIC X(117) VALUE SPACES.         
           05  S-DATE-MOVE             PIC X(10)  VALUE SPACES.         
           05  S-EQUIP-LOC-ID          PIC X(01)  VALUE SPACES.         
           05  S-HOW-ATTACHED-CD       PIC X(01)  VALUE SPACES.         
           05  S-METER-NO              PIC X(09)  VALUE SPACES.         
           05  S-CODE-CRNT-LOC         PIC X(01)  VALUE SPACES.         
           05  S-LAST-READ-VALUE       PIC S9(12)V9(3) USAGE COMP-3     
                                                             VALUE 0.   
C14744     05  S-IN-TRANSIT-EMP-ID     PIC X(07)  VALUE SPACES.         
A05136     05  S-PREMISE-NO            PIC S9(10) COMP-3 VALUE 0.       
                                                                        
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
                                                                        
      ******************************************************************00014600
      * DB2 INCLUDES                                                   *00014700
      ******************************************************************00014800
           EXEC SQL                                                     00014900
              INCLUDE SQLCA                                             00015000
           END-EXEC.                                                    00015100
                                                                        
      *                                                                 00015210
      ******************************************************************00015220
      * CSS_ADDR_FORMATTED, DY                                         *00015230
      ******************************************************************00015240
           EXEC SQL                                                     00015250
              INCLUDE TBADRFMT                                          00015260
           END-EXEC.                                                    00015270
                                                                        
      ******************************************************************00015300
      * CSS_EQUIPMENT, EQ                                              *00015400
      ******************************************************************00015500
           EXEC SQL                                                     00015600
              INCLUDE TBEQUIP                                           00015700
           END-EXEC.                                                    00015800
      *                                                                 00015810
      ******************************************************************00015820
      * CSS_EQUIP_ATTCHMTS, LX                                         *00015830
      ******************************************************************00015840
           EXEC SQL                                                     00015850
              INCLUDE TBEQATTH                                          00015860
           END-EXEC.                                                    00015870
      *                                                                 00015880
      ******************************************************************00015890
      * CSS_EQUIP_ATT_MOVE , MP                                        *00015891
      ******************************************************************00015892
           EXEC SQL                                                     00015893
              INCLUDE TBEQMOVE                                          00015894
           END-EXEC.                                                    00015895
      *                                                                 00015900
      ******************************************************************00016000
      * CSS_EQUIP_LOCATION, M6                                         *00016100
      ******************************************************************00016200
           EXEC SQL                                                     00016300
              INCLUDE TBEQLOC                                           00016400
           END-EXEC.                                                    00016500
      *                                                                 00016510
      ******************************************************************00016520
      * CSS_METER_ATTCHMTS, MA                                         *00016530
      ******************************************************************00016540
           EXEC SQL                                                     00016550
              INCLUDE TBMTRATT                                          00016560
           END-EXEC.                                                    00016570
      *                                                                 00016600
      ******************************************************************00016700
      * CSS_MOVEMENT_HIST, MV                                          *00016800
      ******************************************************************00016900
           EXEC SQL                                                     00017000
              INCLUDE TBMVHIST                                          00017100
           END-EXEC.                                                    00017200
      *                                                                 00017300
      ******************************************************************00017400
      * CSS_MTR_STORGE_FAC, W9                                         *00017500
      ******************************************************************00017600
           EXEC SQL                                                     00017700
              INCLUDE TBMTRFAC                                          00017800
           END-EXEC.                                                    00017900
      *                                                                 00018700
      ******************************************************************00018800
      * CSS_PREMISE, PR                                                *00018900
      ******************************************************************00019000
           EXEC SQL                                                     00019100
              INCLUDE TBPREM                                            00019200
           END-EXEC.                                                    00019300
      *                                                                 00019400
      ******************************************************************00019500
      * CSS_ZIP_CODE, A4                                               *00019600
      ******************************************************************00019700
           EXEC SQL                                                     00019800
              INCLUDE TBZIPCD                                           00019900
           END-EXEC.                                                    00020000
      *                                                                 00019400
      ******************************************************************00019500
      * CSS_CNSMPTN_HIST CX                                            *00019600
      ******************************************************************00019700
           EXEC SQL                                                     00019800
              INCLUDE TBCNSMP                                           00019900
           END-EXEC.                                                    00020000
                                                                        
      ******************************************************************00022400
      *    COBOL WORKING STORAGE COPY BOOKS                            *00022500
      ******************************************************************00022600
                                                                        
           COPY CWS00303.                                               00022800
                                                                        
           EXEC SQL                                                     00023000
              INCLUDE CWSX0010                                          00023100
           END-EXEC.                                                    00023200
                                                                        
                                                                        
      ******************************************************************00023500
      * CURSOR DECLARATIONS                                            *00023600
      * MAIN CURSOR FOR BLOCKS B,C AND D                               *00023700
      * MOVEMENT DETAILS                                               *00023800
      ******************************************************************00023900
           EXEC SQL                                                     
               DECLARE CURSOR1 CURSOR FOR                               
               SELECT MV.DATE_MOVE                                      
                     ,EQUIP_LOC_DESC                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), MV.MOVE_NO
           , 121), ' ', '-'), ':', '.') MOVE_NO                                
                     ,MV.LOCAL_OFFICE                                   
                     ,MV.LOC_NO                                         
                     ,MV.CODE_CRNT_LOC                                  
                     ,MV.LAST_READ_VALUE                                
C14744               ,MV.IN_TRANSIT_EMP_ID                              
                FROM CSS_MOVEMENT_HIST MV WITH(READUNCOMMITTED)                 
                LEFT OUTER JOIN CSS_EQUIP_LOCATION M6
                           WITH(READUNCOMMITTED)                   
                  ON MV.CODE_CRNT_LOC    = M6.EQUIP_LOC_ID              
                 AND MV.CODE_UTIL_TYPE   = M6.CODE_UTIL_TYPE            
                 AND MV.COMPANY_NO       = M6.COMPANY_NO                
               WHERE MV.COMPANY_NO       = :MV-COMPANY-NO               
                 AND MV.CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE         
                 AND MV.CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE           
                 AND MV.DEVICE_NO        = :MV-DEVICE-NO                
               ORDER BY MV.DATE_MOVE DESC                               
                       ,MOVE_NO DESC                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     00024000
MFA-TR*        DECLARE CURSOR1 CURSOR FOR                               00024100
MFA-TR*        SELECT MV.DATE_MOVE                                      00024200
MFA-TR*              ,EQUIP_LOC_DESC                                    00024300
MFA-TR*              ,MV.MOVE_NO                                        00024400
MFA-TR*              ,MV.LOCAL_OFFICE                                   00024500
MFA-TR*              ,MV.LOC_NO                                         00024600
MFA-TR*              ,MV.CODE_CRNT_LOC                                  00024700
MFA-TR*              ,MV.LAST_READ_VALUE                                00024800
MFA-TR*              ,MV.IN_TRANSIT_EMP_ID                              00024800
MFA-TR*         FROM CSS_MOVEMENT_HIST MV                               00024900
MFA-TR*         LEFT OUTER JOIN CSS_EQUIP_LOCATION M6                   00025000
MFA-TR*           ON MV.CODE_CRNT_LOC    = M6.EQUIP_LOC_ID              00025100
MFA-TR*          AND MV.CODE_UTIL_TYPE   = M6.CODE_UTIL_TYPE            00025200
MFA-TR*          AND MV.COMPANY_NO       = M6.COMPANY_NO                00025300
MFA-TR*        WHERE MV.COMPANY_NO       = :MV-COMPANY-NO               00025400
MFA-TR*          AND MV.CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE         00025500
MFA-TR*          AND MV.CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE           00025600
MFA-TR*          AND MV.DEVICE_NO        = :MV-DEVICE-NO                00025700
MFA-TR*        ORDER BY MV.DATE_MOVE DESC                               00025800
MFA-TR*                ,MV.MOVE_NO DESC                                 00025900
MFA-TR*        WITH UR                                                  00026000
MFA-TR*    END-EXEC.                                                    00026100
      *                                                                 00026200
      ******************************************************************00026300
      * MAIN CURSOR FOR BLOCK  E                                       *00026400
      ******************************************************************00026500
           EXEC SQL                                                     
               DECLARE ATCH_CURSOR CURSOR FOR                           
               SELECT TOP(1) EQ.CODE_CRNT_LOC,
              EQ.LOCAL_OFFICE,
              EQ.CRNT_LOC_NO,
              MA.HOW_ATTACHED_CD,
              MA.METER_NO,
              EQ.IN_TRANSIT_EMP_ID                              
               FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
                   ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                      
               WHERE MA.METER_NO       = EQ.DEVICE_NO                   
                 AND MA.COMPANY_NO     = EQ.COMPANY_NO                  
                 AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              
                 AND MA.DEVICE_NO      = :MA-DEVICE-NO                  
                 AND MA.COMPANY_NO     = :MA-COMPANY-NO                 
                 AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             
                 AND MA.CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00026600
MFA-TR*        DECLARE ATCH_CURSOR CURSOR FOR                           00026700
MFA-TR*        SELECT EQ.CODE_CRNT_LOC                                  00026800
MFA-TR*              ,EQ.LOCAL_OFFICE                                   00026900
MFA-TR*              ,EQ.CRNT_LOC_NO                                    00027000
MFA-TR*              ,MA.HOW_ATTACHED_CD                                00027100
MFA-TR*              ,MA.METER_NO                                       00027200
MFA-TR*              ,EQ.IN_TRANSIT_EMP_ID                              00027200
MFA-TR*        FROM CSS_METER_ATTCHMTS MA                               00027300
MFA-TR*            ,CSS_EQUIPMENT EQ                                    00027400
MFA-TR*        WHERE MA.METER_NO       = EQ.DEVICE_NO                   00027500
MFA-TR*          AND MA.COMPANY_NO     = EQ.COMPANY_NO                  00027600
MFA-TR*          AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              00027700
MFA-TR*          AND MA.DEVICE_NO      = :MA-DEVICE-NO                  00027800
MFA-TR*          AND MA.COMPANY_NO     = :MA-COMPANY-NO                 00027900
MFA-TR*          AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             00028000
MFA-TR*          AND MA.CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE              00028100
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             00028200
MFA-TR*    END-EXEC.                                                    00028300
      *                                                                 00028400
      ******************************************************************00028500
      * MAIN CURSOR FOR BLOCK  F                                       *00028600
      ******************************************************************00028700
           EXEC SQL                                                     
               DECLARE MOV_CURSOR CURSOR FOR                            
               SELECT  MP.DATE_MOVE                                     
                      ,M6.EQUIP_LOC_DESC                                
                      ,MP.EQUIP_LOC_ID                                  
                      ,MP.METER_NO                                      
                      ,W9.MTR_STORAGE_FAC_CD                            
                      ,W9.MTR_STORAGE_FAC_TX                            
C14744                ,MP.IN_TRANSIT_EMP_ID                             
               FROM CSS_EQUIP_ATT_MOVE  MP WITH(READUNCOMMITTED)                
               LEFT OUTER JOIN CSS_EQUIP_LOCATION M6
                           WITH(READUNCOMMITTED)                    
                 ON MP.EQUIP_LOC_ID       = M6.EQUIP_LOC_ID             
                AND MP.COMPANY_NO         = M6.COMPANY_NO               
                AND MP.CODE_UTIL_TYPE     = M6.CODE_UTIL_TYPE           
               LEFT OUTER JOIN CSS_MTR_STORGE_FAC  W9
                           WITH(READUNCOMMITTED)                   
                 ON W9.MTR_STORAGE_FAC_CD = MP.MTR_STORAGE_FAC_CD       
                AND W9.COMPANY_NO         = MP.COMPANY_NO               
                AND W9.CODE_UTIL_TYPE     = MP.CODE_UTIL_TYPE           
               LEFT OUTER JOIN CSS_METER_ATTCHMTS MA
                           WITH(READUNCOMMITTED)                    
                 ON MA.COMPANY_NO         = MP.COMPANY_NO               
                AND MA.CODE_UTIL_TYPE     = MP.CODE_UTIL_TYPE           
                AND MA.CODE_ATT_TYPE      = MP.CODE_ATT_TYPE            
                AND MA.DEVICE_NO          = MP.DEVICE_NO                
              WHERE MP.COMPANY_NO        = :MP-COMPANY-NO               
                AND MP.CODE_UTIL_TYPE    = :MP-CODE-UTIL-TYPE           
                AND MP.CODE_ATT_TYPE     = :MP-CODE-ATT-TYPE            
                AND MP.DEVICE_NO         = :MP-DEVICE-NO                
                ORDER BY MP.DATE_MOVE DESC                              
                        ,MP.MOVE_NO DESC                                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00028800
MFA-TR*        DECLARE MOV_CURSOR CURSOR FOR                            00028900
MFA-TR*        SELECT  MP.DATE_MOVE                                     00029000
MFA-TR*               ,M6.EQUIP_LOC_DESC                                00029100
MFA-TR*               ,MP.EQUIP_LOC_ID                                  00029200
MFA-TR*               ,MP.METER_NO                                      00029300
MFA-TR*               ,W9.MTR_STORAGE_FAC_CD                            00029400
MFA-TR*               ,W9.MTR_STORAGE_FAC_TX                            00029500
MFA-TR*               ,MP.IN_TRANSIT_EMP_ID                             00029500
MFA-TR*        FROM CSS_EQUIP_ATT_MOVE  MP                              00029600
MFA-TR*        LEFT OUTER JOIN CSS_EQUIP_LOCATION M6                    00029700
MFA-TR*          ON MP.EQUIP_LOC_ID       = M6.EQUIP_LOC_ID             00029800
MFA-TR*         AND MP.COMPANY_NO         = M6.COMPANY_NO               00029900
MFA-TR*         AND MP.CODE_UTIL_TYPE     = M6.CODE_UTIL_TYPE           00030000
MFA-TR*        LEFT OUTER JOIN CSS_MTR_STORGE_FAC  W9                   00030100
MFA-TR*          ON W9.MTR_STORAGE_FAC_CD = MP.MTR_STORAGE_FAC_CD       00030200
MFA-TR*         AND W9.COMPANY_NO         = MP.COMPANY_NO               00030300
MFA-TR*         AND W9.CODE_UTIL_TYPE     = MP.CODE_UTIL_TYPE           00030400
MFA-TR*        LEFT OUTER JOIN CSS_METER_ATTCHMTS MA                    00030500
MFA-TR*          ON MA.COMPANY_NO         = MP.COMPANY_NO               00030600
MFA-TR*         AND MA.CODE_UTIL_TYPE     = MP.CODE_UTIL_TYPE           00030700
MFA-TR*         AND MA.CODE_ATT_TYPE      = MP.CODE_ATT_TYPE            00030800
MFA-TR*         AND MA.DEVICE_NO          = MP.DEVICE_NO                00030900
MFA-TR*       WHERE MP.COMPANY_NO        = :MP-COMPANY-NO               00031000
MFA-TR*         AND MP.CODE_UTIL_TYPE    = :MP-CODE-UTIL-TYPE           00031100
MFA-TR*         AND MP.CODE_ATT_TYPE     = :MP-CODE-ATT-TYPE            00031200
MFA-TR*         AND MP.DEVICE_NO         = :MP-DEVICE-NO                00031300
MFA-TR*         ORDER BY MP.DATE_MOVE DESC                              00031400
MFA-TR*                 ,MP.MOVE_NO DESC                                00031500
MFA-TR*         WITH UR                                                 00031600
MFA-TR*    END-EXEC.                                                    00031700
                                                                        
                                                                        
                                                                        
      ******************************************************************00032100
      *    CURSOR DECLARATIONS                                         *00032200
      *    FOR FINAL RETURN                                            *00032300
      ******************************************************************00032400
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING     
              FOR                                                       
              SELECT                                                    
                  RETURN_CODE                                           
                 ,MOVEMNT_ROW_TYPE                                      
                 ,EQUIP_LOC_DESC                                        
                 ,MSF_DETAIL                                            
                 ,DATE_MOVE                                             
                 ,EQUIP_LOC_ID                                          
                 ,HOW_ATTACHED_CD                                       
                 ,METER_NO                                              
                 ,CODE_CRNT_LOC                                         
                 ,LAST_READ_VALUE                                       
C14744           ,IN_TRANSIT_EMP_ID                                     
A05136           ,PREMISE_NO                                            
              FROM #CSR04218_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00032500
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING     00032600
MFA-TR*       FOR                                                       00032700
MFA-TR*       SELECT                                                    00032800
MFA-TR*           RETURN_CODE                                           00032900
MFA-TR*          ,MOVEMNT_ROW_TYPE                                      00033000
MFA-TR*          ,EQUIP_LOC_DESC                                        00033100
MFA-TR*          ,MSF_DETAIL                                            00033200
MFA-TR*          ,DATE_MOVE                                             00033300
MFA-TR*          ,EQUIP_LOC_ID                                          00033400
MFA-TR*          ,HOW_ATTACHED_CD                                       00033500
MFA-TR*          ,METER_NO                                              00033600
MFA-TR*          ,CODE_CRNT_LOC                                         00033700
MFA-TR*          ,LAST_READ_VALUE                                       00033800
MFA-TR*          ,IN_TRANSIT_EMP_ID                                     00033800
MFA-TR*          ,PREMISE_NO                                            00033800
MFA-TR*       FROM SESSION.CSR04218_R1                                  00033900
MFA-TR*    END-EXEC.                                                    00034000
      *                                                                 00034100
HPCCDM*EJECT                                                            00034200
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                 00034500
       01 PARM-EQUIPMENT-TYPE     PIC X(01).                            
       01 PARM-CODE-UTIL-TYPE     PIC X(01).                            
       01 PARM-COMPANY-NO         PIC X(02).                            
       01 PARM-DEVICE-NO          PIC X(12).                            
       01 PARM-METER-NO           PIC X(09).                            
       01 PARM-CODE-ATT-TYPE      PIC X(02).                            
      *                                                                 00035200
       PROCEDURE DIVISION USING  PARM-EQUIPMENT-TYPE                    
                                ,PARM-CODE-UTIL-TYPE                    
                                ,PARM-COMPANY-NO                        
                                ,PARM-DEVICE-NO                         
                                ,PARM-METER-NO                          
                                ,PARM-CODE-ATT-TYPE.                    
                                                                        
                                                                        
                                                                        
      ******************************************************************00036200
      * 0000-MAINLINE                                                  *00036300
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00036400
      ******************************************************************00036500
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00037500
      ******************************************************************00037600
      * 0100-INITIALIZE                                                *00037700
      *                                                                *00037800
      ******************************************************************00037900
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00039100
      ******************************************************************00039200
      * 0100A-DECLARE-GTT                                              *00039300
      ******************************************************************00039400
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04218_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04218_R1
              (                                                         
                RETURN_CODE             INT                         
               ,MOVEMNT_ROW_TYPE CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,EQUIP_LOC_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,MSF_DETAIL CHAR(116)  COLLATE LATIN1_GENERAL_100_BIN2           
               ,DATE_MOVE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,EQUIP_LOC_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
               ,HOW_ATTACHED_CD CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2              
               ,CODE_CRNT_LOC CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,LAST_READ_VALUE         DECIMAL(15,3)                   
C14744         ,IN_TRANSIT_EMP_ID CHAR(07)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
A05136         ,PREMISE_NO              DECIMAL(10,0)                   
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '0100A'              TO ACTIVE-PARAGRAPH          
                 MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04218_R1'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************00043800
      * 1000-PROCESS-INPUT                                             *00043900
      *                                                                *00044000
      ******************************************************************00044100
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-CODE-UTIL-TYPE      TO WS-CODE-UTIL-TYPE.          
           MOVE PARM-COMPANY-NO          TO WS-COMPANY-NO.              
           MOVE PARM-DEVICE-NO           TO WS-DEVICE-NO.               
           MOVE PARM-METER-NO            TO WS-METER-NO.                
           MOVE PARM-CODE-ATT-TYPE       TO WS-CODE-ATT-TYPE.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00045400
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *00045500
      ******************************************************************00045600
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE     = SPACES OR                       
              PARM-COMPANY-NO         = SPACES OR                       
              PARM-EQUIPMENT-TYPE     = SPACES                          
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-2          
              MOVE 'PARM-EQUIPMENT-TYPE'    TO TABLE-ELEMENT-3          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-2        
              MOVE PARM-EQUIPMENT-TYPE      TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00048600
      * 2000-PROCESS-OUTPUT.                                           *00048700
      *                                                                *00048800
      ******************************************************************00048900
       2000-PROCESS-OUTPUT.                                             
           IF PARM-EQUIPMENT-TYPE  = 'X' OR 'E' OR 'G' OR 'A'           
              MOVE  'C'                              TO                 
                                                  WS-MOVEMNT-ROW-TYPE   
              IF PARM-EQUIPMENT-TYPE  = 'X' OR 'E' OR 'G'               
                 PERFORM 2100-PROCESS-EQUIPMENT      THRU 2100-EXIT     
                                                                        
                 EVALUATE  PARM-EQUIPMENT-TYPE                          
                    WHEN  'E'                                           
                       MOVE    'B'                TO   WS-BLOCK         
                    WHEN  'G'                                           
                       MOVE    'C'                TO   WS-BLOCK         
                    WHEN  'X'                                           
                       MOVE    'D'                TO   WS-BLOCK         
                 END-EVALUATE                                           
                 MOVE  'H'                        TO WS-MOVEMNT-ROW-TYPE
                 PERFORM 2200-PROCESS-MOV-HIST    THRU 2200-EXIT        
              ELSE                                                      
                 PERFORM 2300-PROCESS-MTR-ATCH    THRU 2300-EXIT        
                 MOVE  'H'                        TO WS-MOVEMNT-ROW-TYPE
                 PERFORM 2400-PROCESS-EQ-ATT-MOVE THRU 2400-EXIT        
              END-IF                                                    
                                                                        
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00051600
      *2000A-MOVE-RESULT                                               *00051700
      ******************************************************************00051800
       2000A-MOVE-RESULT.                                               
           MOVE   RS-RETURN-CODE             TO   S-RETURN-CODE.        
           MOVE   RS-MOVEMNT-ROW-TYPE        TO   S-MOVEMNT-ROW-TYPE.   
           MOVE   RS-EQUIP-LOC-DESC          TO   S-EQUIP-LOC-DESC.     
           MOVE   RS-MSF-DETAIL              TO   S-MSF-DETAIL.         
           MOVE   RS-DATE-MOVE               TO   S-DATE-MOVE.          
           MOVE   RS-EQUIP-LOC-ID            TO   S-EQUIP-LOC-ID.       
           MOVE   RS-HOW-ATTACHED-CD         TO   S-HOW-ATTACHED-CD.    
           MOVE   RS-METER-NO                TO   S-METER-NO.           
           MOVE   RS-CODE-CRNT-LOC           TO   S-CODE-CRNT-LOC.      
           MOVE   RS-LAST-READ-VALUE         TO   S-LAST-READ-VALUE.    
C14744     MOVE   RS-IN-TRANSIT-EMP-ID       TO   S-IN-TRANSIT-EMP-ID.  
A05136     MOVE   RS-PREMISE-NO              TO   S-PREMISE-NO.         
       2000A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************00053200
      *2100-PROCESS-EQUIPMENT                                          *00053300
      ******************************************************************00053400
       2100-PROCESS-EQUIPMENT.                                          
           MOVE 0                             TO RS-LAST-READ-VALUE.    
                                                                        
           MOVE  'C'                          TO WS-MOVEMNT-ROW-TYPE.   
           MOVE  WS-CODE-UTIL-TYPE            TO EQ-CODE-UTIL-TYPE      
                                                    M6-CODE-UTIL-TYPE.  
           MOVE  WS-COMPANY-NO                TO EQ-COMPANY-NO          
                                                    M6-COMPANY-NO.      
           MOVE  WS-METER-NO                  TO EQ-DEVICE-NO           
           PERFORM  7000-SELECT-EQUIPMENT     THRU 7000-EXIT            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05136        MOVE 0 TO PR-PREMISE-NO                                   
              MOVE  EQ-CODE-CRNT-LOC             TO WS-CODE-CRNT-LOC    
                                                    M6-EQUIP-LOC-ID     
                                                                        
              PERFORM 7020-SELECT-EQUIP-LOC      THRU 7020-EXIT         
              MOVE M6-EQUIP-LOC-DESC             TO RS-EQUIP-LOC-DESC   
C14744        MOVE EQ-IN-TRANSIT-EMP-ID                                 
C14744                                     TO RS-IN-TRANSIT-EMP-ID      
              EVALUATE WS-CODE-CRNT-LOC                                 
                 WHEN SPACES                                            
                    MOVE SPACES                  TO RS-MSF-DETAIL       
                    MOVE WS-LOC-DESC-UNKNOWN     TO RS-EQUIP-LOC-DESC   
                 WHEN WS-LOC-AT-CUSTOMER                                
                    MOVE EQ-CRNT-LOC-NO          TO PR-PREMISE-NO       
A05136                                              RS-PREMISE-NO       
                    PERFORM 7040-SELECT-ADDRESS  THRU 7040-EXIT         
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 2740-BUILD-ADDRESS-STRING                
                                                 THRU 2740-EXIT         
                       MOVE    WS-ADDRESS        TO RS-MSF-DETAIL       
                    ELSE                                                
                       MOVE  WS-LOC-DESC-UNKNOWN TO RS-MSF-DETAIL       
                    END-IF                                              
                 WHEN WS-LOC-ATTACHED                                   
                    MOVE EQ-CRNT-LOC-NO          TO PR-PREMISE-NO       
A05136                                              RS-PREMISE-NO       
                    PERFORM 7040-SELECT-ADDRESS  THRU 7040-EXIT         
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       PERFORM 2740-BUILD-ADDRESS-STRING                
                                                 THRU 2740-EXIT         
                       MOVE    WS-ADDRESS        TO RS-MSF-DETAIL       
                    ELSE                                                
                       MOVE EQ-LOCAL-OFFICE    TO W9-MTR-STORAGE-FAC-CD 
                                                  WS-LOCAL-OFFICE       
                       PERFORM 2730-LOC-OTHER  THRU 2730-EXIT           
                    END-IF                                              
                 WHEN OTHER                                             
                    MOVE EQ-LOCAL-OFFICE       TO W9-MTR-STORAGE-FAC-CD 
                                                   WS-LOCAL-OFFICE      
                    PERFORM 2730-LOC-OTHER     THRU 2730-EXIT           
              END-EVALUATE                                              
              MOVE EQ-DATE-LAST-MOVE             TO RS-DATE-MOVE        
              MOVE EQ-CODE-CRNT-LOC              TO RS-CODE-CRNT-LOC    
                                                    RS-EQUIP-LOC-ID     
           END-IF.                                                      
           MOVE  'C'                           TO RS-MOVEMNT-ROW-TYPE.  
           MOVE WS-ACTIVE-RETURN-CODE          TO RS-RETURN-CODE.       
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00059300
      *2200-PROCESS-MOV-HIST                                           *00059400
      ******************************************************************00059500
       2200-PROCESS-MOV-HIST.                                           
           IF WS-BLOCK = 'D' THEN                                       
              MOVE WS-DEVICE-TYPE-XFORMER      TO MV-CODE-DEVICE-TYPE   
           ELSE                                                         
              MOVE WS-DEVICE-TYPE-METER        TO MV-CODE-DEVICE-TYPE   
           END-IF.                                                      
           MOVE WS-COMPANY-NO                  TO MV-COMPANY-NO.        
           MOVE WS-CODE-UTIL-TYPE              TO MV-CODE-UTIL-TYPE.    
           MOVE WS-METER-NO                    TO MV-DEVICE-NO.         
           MOVE  0                             TO WS-ROW-COUNT1         
                                                  WS-DATE-MOVE-IND      
                                                  WS-CODE-CRNT-LOC-IND  
                                                  WS-EQUIP-LOC-DESC-IND.
           PERFORM 7200-OPEN-CURSOR1           THRU 7200-EXIT.          
           PERFORM 7210-FETCH-CURSOR1          THRU 7210-EXIT.          
           PERFORM 2210-PROCESS-CURSOR1        THRU 2210-EXIT           
                        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
           IF WS-ROW-COUNT1  = 0                                        
              INITIALIZE         TDS-RETURN-FIELDS                      
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE  'H'                        TO RS-MOVEMNT-ROW-TYPE   
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
           PERFORM 7220-CLOSE-CURSOR1          THRU 7220-EXIT.          
       2200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00062300
      * 2210-PROCESS-CURSOR1                                           *00062400
      ******************************************************************00062500
       2210-PROCESS-CURSOR1.                                            
           INITIALIZE         TDS-RETURN-FIELDS.                        
           MOVE   0                            TO WS-LOC-NO-IND.        
           MOVE  'H'                           TO RS-MOVEMNT-ROW-TYPE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE  1                          TO WS-ROW-COUNT1         
              IF WS-BLOCK = 'B'                                         
                 PERFORM 2220-CODE-CRNT-VAL    THRU 2220-EXIT           
              END-IF                                                    
                                                                        
              IF WS-BLOCK = 'C'                                         
                 PERFORM 2230-LOC-AT-CUST      THRU 2230-EXIT           
              END-IF                                                    
                                                                        
              IF WS-BLOCK = 'D'                                         
                 PERFORM 2240-PROCESS-LOC-ATCH  THRU 2240-EXIT          
              END-IF                                                    
              MOVE   0                         TO WS-ACTIVE-RETURN-CODE 
                                                                        
           END-IF.                                                      
           PERFORM 7210-FETCH-CURSOR1          THRU 7210-EXIT.          
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00064900
      ******************************************************************00065000
      * 2220-CODE-CRNT-VAL                                            * 00065100
      ******************************************************************00065200
       2220-CODE-CRNT-VAL.                                              
                                                                        
           MOVE MV-CODE-CRNT-LOC                   TO WS-CODE-CRNT-LOC. 
           MOVE M6-EQUIP-LOC-DESC                  TO RS-EQUIP-LOC-DESC.
           EVALUATE WS-CODE-CRNT-LOC                                    
              WHEN SPACES                                               
                 MOVE SPACES                       TO RS-MSF-DETAIL     
                                                      RS-EQUIP-LOC-DESC 
              WHEN WS-LOC-AT-CUSTOMER                                   
                 MOVE MV-LOC-NO                       TO PR-PREMISE-NO  
A05136                                                   RS-PREMISE-NO  
                 PERFORM 7040-SELECT-ADDRESS          THRU 7040-EXIT    
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2740-BUILD-ADDRESS-STRING THRU 2740-EXIT    
                    MOVE    WS-ADDRESS                TO RS-MSF-DETAIL  
                 ELSE                                                   
                    MOVE  WS-LOC-DESC-UNKNOWN         TO RS-MSF-DETAIL  
                 END-IF                                                 
              WHEN WS-LOC-ATTACHED                                      
                 MOVE MV-LOC-NO                TO PR-PREMISE-NO         
A05136                                            RS-PREMISE-NO         
                 PERFORM 7040-SELECT-ADDRESS   THRU 7040-EXIT           
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2740-BUILD-ADDRESS-STRING                   
                                               THRU 2740-EXIT           
                    MOVE    WS-ADDRESS         TO RS-MSF-DETAIL         
                 ELSE                                                   
                    MOVE MV-LOCAL-OFFICE       TO W9-MTR-STORAGE-FAC-CD 
                                                  WS-LOCAL-OFFICE       
                    PERFORM 2730-LOC-OTHER     THRU 2730-EXIT           
                 END-IF                                                 
              WHEN WS-LOC-OLD-ACCT                                      
                 PERFORM  2720-LOC-OLD-ACCT  THRU 2720-EXIT             
              WHEN  '1'                                                 
                 CONTINUE                                               
              WHEN  '2'                                                 
                 CONTINUE                                               
              WHEN  '3'                                                 
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE MV-LOCAL-OFFICE          TO W9-MTR-STORAGE-FAC-CD 
                                                  WS-LOCAL-OFFICE       
                 PERFORM 2730-LOC-OTHER        THRU 2730-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE MV-DATE-MOVE                      TO RS-DATE-MOVE.      
           MOVE MV-CODE-CRNT-LOC                  TO RS-CODE-CRNT-LOC.  
           MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE.    
           MOVE MV-LAST-READ-VALUE                TO RS-LAST-READ-VALUE.
C14744     MOVE MV-IN-TRANSIT-EMP-ID                                    
C14744                                      TO RS-IN-TRANSIT-EMP-ID.    
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00070400
      ******************************************************************00070500
      * 2230-LOC-AT-CUST                                               *00070600
      ******************************************************************00070700
       2230-LOC-AT-CUST.                                                
                                                                        
           MOVE MV-CODE-CRNT-LOC                   TO WS-CODE-CRNT-LOC. 
           MOVE M6-EQUIP-LOC-DESC                  TO RS-EQUIP-LOC-DESC.
           EVALUATE WS-CODE-CRNT-LOC                                    
              WHEN SPACES                                               
                 MOVE SPACES                       TO RS-MSF-DETAIL     
                                                      RS-EQUIP-LOC-DESC 
              WHEN WS-LOC-AT-CUSTOMER                                   
                 MOVE MV-LOC-NO                       TO PR-PREMISE-NO  
A05136                                                   RS-PREMISE-NO  
                 PERFORM 7040-SELECT-ADDRESS          THRU 7040-EXIT    
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2740-BUILD-ADDRESS-STRING THRU 2740-EXIT    
                    MOVE    WS-ADDRESS                TO RS-MSF-DETAIL  
                 ELSE                                                   
                    MOVE  WS-LOC-DESC-UNKNOWN         TO RS-MSF-DETAIL  
                 END-IF                                                 
C14744*       WHEN WS-LOC-EMPLOYEE                                      00072500
C14744*          MOVE MV-LOC-NO                       TO WS-LOC-NO      00072600
C14744*          MOVE WS-LOC-NO                       TO RS-MSF-DETAIL  00072700
              WHEN WS-LOC-OLD-ACCT                                      
                 PERFORM  2720-LOC-OLD-ACCT           THRU 2720-EXIT    
              WHEN  '1'                                                 
                 CONTINUE                                               
              WHEN  '2'                                                 
                 CONTINUE                                               
              WHEN  '3'                                                 
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 MOVE MV-LOCAL-OFFICE          TO W9-MTR-STORAGE-FAC-CD 
                                                  WS-LOCAL-OFFICE       
                 PERFORM 2730-LOC-OTHER        THRU 2730-EXIT           
           END-EVALUATE.                                                
           MOVE MV-DATE-MOVE                      TO RS-DATE-MOVE.      
           MOVE MV-CODE-CRNT-LOC                  TO RS-CODE-CRNT-LOC.  
           MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE.    
           MOVE MV-LAST-READ-VALUE                TO RS-LAST-READ-VALUE.
C14744     MOVE MV-IN-TRANSIT-EMP-ID                                    
C14744                                      TO RS-IN-TRANSIT-EMP-ID.    
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00075100
      ******************************************************************00075200
      * 2240-PROCESS-LOC-ATCH                                          *00075300
      ******************************************************************00075400
       2240-PROCESS-LOC-ATCH.                                           
                                                                        
           MOVE MV-CODE-CRNT-LOC                   TO WS-CODE-CRNT-LOC. 
           MOVE M6-EQUIP-LOC-DESC                  TO RS-EQUIP-LOC-DESC.
           EVALUATE WS-CODE-CRNT-LOC                                    
              WHEN SPACES                                               
                 MOVE SPACES                       TO RS-MSF-DETAIL     
                                                      RS-EQUIP-LOC-DESC 
              WHEN WS-LOC-ATTACHED                                      
                 MOVE MV-LOC-NO                       TO PR-PREMISE-NO  
A05136                                                   RS-PREMISE-NO  
                 PERFORM 7040-SELECT-ADDRESS          THRU 7040-EXIT    
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2740-BUILD-ADDRESS-STRING THRU 2740-EXIT    
                    MOVE    WS-ADDRESS                TO RS-MSF-DETAIL  
                 ELSE                                                   
                    MOVE  WS-LOC-DESC-UNKNOWN         TO RS-MSF-DETAIL  
                 END-IF                                                 
              WHEN WS-LOC-OLD-ACCT                                      
                 PERFORM  2720-LOC-OLD-ACCT           THRU 2720-EXIT    
              WHEN  '1'                                                 
                 CONTINUE                                               
              WHEN  '2'                                                 
                 CONTINUE                                               
              WHEN  '3'                                                 
                 CONTINUE                                               
                                                                        
              WHEN OTHER                                                
                 MOVE MV-LOCAL-OFFICE          TO W9-MTR-STORAGE-FAC-CD 
                                                  WS-LOCAL-OFFICE       
                 PERFORM 2730-LOC-OTHER        THRU 2730-EXIT           
           END-EVALUATE.                                                
           MOVE MV-DATE-MOVE                      TO RS-DATE-MOVE.      
           MOVE MV-CODE-CRNT-LOC                  TO RS-CODE-CRNT-LOC.  
           MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE.    
           MOVE MV-LAST-READ-VALUE                TO RS-LAST-READ-VALUE.
C14744     MOVE MV-IN-TRANSIT-EMP-ID                                    
C14744                                      TO RS-IN-TRANSIT-EMP-ID.    
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
           PERFORM 8100-SEND-RESULT               THRU 8100-EXIT.       
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00079500
      ******************************************************************00079600
      * 2300-PROCESS-MTR-ATCH                                          *00079700
      ******************************************************************00079800
       2300-PROCESS-MTR-ATCH.                                           
           INITIALIZE         TDS-RETURN-FIELDS.                        
           MOVE WS-COMPANY-NO                   TO LX-COMPANY-NO        
                                                   M6-COMPANY-NO        
                                                   MA-COMPANY-NO.       
           MOVE WS-CODE-UTIL-TYPE               TO LX-CODE-UTIL-TYPE    
                                                   M6-CODE-UTIL-TYPE    
                                                   MA-CODE-UTIL-TYPE.   
           MOVE WS-CODE-ATT-TYPE                TO LX-CODE-ATT-TYPE     
                                                   MA-CODE-ATT-TYPE.    
           MOVE WS-DEVICE-NO                    TO LX-DEVICE-NO         
                                                   MA-DEVICE-NO.        
           MOVE    0                    TO   WS-MTR-STOR-FAC-CD-IND.    
           PERFORM 7330-SELECT-EQUIP-ATCH       THRU 7330-EXIT.         
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL AND              
              WS-MTR-STOR-FAC-CD-IND = 0                                
              MOVE WS-CODE-UTIL-TYPE           TO W9-CODE-UTIL-TYPE     
              MOVE WS-COMPANY-NO               TO W9-COMPANY-NO         
              MOVE LX-MTR-STORAGE-FAC-CD       TO W9-MTR-STORAGE-FAC-CD 
              PERFORM 7050-SELECT-STOR-FAC-TX  THRU  7050-EXIT          
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N/A'                    TO W9-MTR-STORAGE-FAC-CD 
                 MOVE 'N/A'                    TO W9-MTR-STORAGE-FAC-TX 
              END-IF                                                    
           ELSE                                                         
              IF WS-MTR-STOR-FAC-CD-IND = -1                            
                 MOVE 'N/A'                    TO W9-MTR-STORAGE-FAC-CD 
                 MOVE 'N/A'                    TO W9-MTR-STORAGE-FAC-TX 
              END-IF                                                    
           END-IF.                                                      
           MOVE LX-EQUIP-LOC-ID                 TO M6-EQUIP-LOC-ID.     
           PERFORM 7020-SELECT-EQUIP-LOC        THRU 7020-EXIT.         
           MOVE     M6-EQUIP-LOC-DESC           TO RS-EQUIP-LOC-DESC.   
           MOVE LX-DATE-LAST-MOVE               TO RS-DATE-MOVE.        
C14744     MOVE LX-IN-TRANSIT-EMP-ID                                    
C14744                                      TO RS-IN-TRANSIT-EMP-ID.    
           PERFORM 7300-OPEN-ATCH-CURSOR        THRU 7300-EXIT.         
           PERFORM 7310-FETCH-ATCH-CURSOR       THRU 7310-EXIT.         
           PERFORM 2310-PROCESS-ATCH-CURSOR     THRU 2310-EXIT          
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
           PERFORM  7320-CLOSE-ATCH-CURSOR      THRU 7320-EXIT.         
           IF WS-ROW-COUNT1  = 0                                        
              MOVE 0                            TO RS-RETURN-CODE       
              MOVE  'C'                         TO RS-MOVEMNT-ROW-TYPE  
              MOVE SPACES                       TO RS-CODE-CRNT-LOC     
              MOVE LX-EQUIP-LOC-ID              TO RS-EQUIP-LOC-ID      
              MOVE SPACES                       TO RS-HOW-ATTACHED-CD   
              MOVE SPACES                       TO RS-METER-NO          
              STRING W9-MTR-STORAGE-FAC-CD, WS-HYPEN2,                  
                     W9-MTR-STORAGE-FAC-TX                              
              DELIMITED BY SIZE  INTO RS-MSF-DETAIL                     
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00099527
      ******************************************************************00099528
      * 2310-PROCESS-ATCH-CURSOR                                       *00099529
      ******************************************************************00099530
       2310-PROCESS-ATCH-CURSOR.                                        
           MOVE        0                       TO WS-CODE-CRNT-LOC-IND. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE        1                    TO WS-ROW-COUNT1         
              IF WS-CODE-CRNT-LOC-IND  = -1                             
                 CONTINUE                                               
              ELSE                                                      
                 MOVE EQ-CODE-CRNT-LOC              TO WS-CODE-CRNT-LOC 
                 EVALUATE WS-CODE-CRNT-LOC                              
                    WHEN WS-LOC-AT-CUSTOMER                             
                       MOVE EQ-CRNT-LOC-NO          TO PR-PREMISE-NO    
A05136                                                 RS-PREMISE-NO    
                       PERFORM 7040-SELECT-ADDRESS  THRU 7040-EXIT      
                       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
                          PERFORM 2740-BUILD-ADDRESS-STRING             
                                                    THRU 2740-EXIT      
                          MOVE WS-ADDRESS           TO RS-MSF-DETAIL    
                       END-IF                                           
                    WHEN WS-LOC-ATTACHED                                
                       MOVE EQ-CRNT-LOC-NO          TO PR-PREMISE-NO    
A05136                                                 RS-PREMISE-NO    
                       PERFORM 7040-SELECT-ADDRESS                      
                                                    THRU 7040-EXIT      
                       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
                          PERFORM 2740-BUILD-ADDRESS-STRING             
                                                    THRU 2740-EXIT      
                          MOVE WS-ADDRESS           TO RS-MSF-DETAIL    
                       END-IF                                           
                    WHEN OTHER                                          
                       STRING W9-MTR-STORAGE-FAC-CD, WS-HYPEN2,         
                              W9-MTR-STORAGE-FAC-TX                     
                       DELIMITED BY SIZE  INTO RS-MSF-DETAIL            
                 END-EVALUATE                                           
              END-IF                                                    
              MOVE   0                         TO WS-ACTIVE-RETURN-CODE 
              MOVE  'C'                        TO RS-MOVEMNT-ROW-TYPE   
              MOVE EQ-CODE-CRNT-LOC            TO RS-CODE-CRNT-LOC      
              MOVE LX-EQUIP-LOC-ID             TO RS-EQUIP-LOC-ID       
              MOVE MA-HOW-ATTACHED-CD          TO RS-HOW-ATTACHED-CD    
              MOVE MA-METER-NO                 TO RS-METER-NO           
C14744        MOVE LX-IN-TRANSIT-EMP-ID                                 
C14744                                      TO RS-IN-TRANSIT-EMP-ID     
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
           PERFORM 7310-FETCH-ATCH-CURSOR      THRU 7310-EXIT.          
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00099577
      ******************************************************************00099578
      * 2400-PROCESS-EQ-ATT-MOVE                                       *00099579
      ******************************************************************00099580
       2400-PROCESS-EQ-ATT-MOVE.                                        
           MOVE WS-COMPANY-NO                      TO MP-COMPANY-NO.    
                                                                        
           MOVE WS-CODE-UTIL-TYPE                  TO MP-CODE-UTIL-TYPE.
                                                                        
           MOVE WS-CODE-ATT-TYPE              TO MP-CODE-ATT-TYPE.      
           MOVE WS-DEVICE-NO                  TO MP-DEVICE-NO.          
           MOVE   0                           TO WS-ROW-COUNT1          
                                                 WS-EQUIP-LOC-DESC-IND  
                                                 WS-METER-NO-IND        
                                                 WS-MTR-STOR-FAC-CD-IND 
                                                 WS-MTR-STOR-FAC-TX-IND.
                                                                        
           PERFORM 7400-OPEN-MOV-CURSOR            THRU 7400-EXIT.      
           PERFORM 7410-FETCH-MOV-CURSOR           THRU 7410-EXIT.      
           PERFORM 2410-PROCESS-MOV-CURSOR         THRU 2410-EXIT       
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
           IF WS-ROW-COUNT1  = 0                                        
              INITIALIZE         TDS-RETURN-FIELDS                      
              MOVE WS-ACTIVE-RETURN-CODE          TO RS-RETURN-CODE     
              MOVE  'H'                           TO RS-MOVEMNT-ROW-TYPE
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF.                                                      
           PERFORM  7420-CLOSE-MOV-CURSOR          THRU 7420-EXIT.      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00099610
      * 2410-PROCESS-MOV-CURSOR                                        *00099611
      ******************************************************************00099612
       2410-PROCESS-MOV-CURSOR.                                         
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-EQUIP-LOC-DESC-IND = -1                             
                 MOVE 0          TO  WS-EQUIP-LOC-DESC-IND              
                 MOVE 'UNKNOWN'  TO  M6-EQUIP-LOC-DESC                  
              END-IF                                                    
              IF WS-METER-NO-IND  = -1                                  
                 MOVE 0          TO  WS-METER-NO-IND                    
                 MOVE SPACES     TO  MA-METER-NO                        
              END-IF                                                    
              IF WS-MTR-STOR-FAC-CD-IND = -1                            
                 MOVE 0          TO  WS-MTR-STOR-FAC-CD-IND             
                 MOVE 'N/A'      TO  W9-MTR-STORAGE-FAC-CD              
              END-IF                                                    
              IF WS-MTR-STOR-FAC-TX-IND = -1                            
                 MOVE 0          TO  WS-MTR-STOR-FAC-TX-IND             
                 MOVE 'N/A'      TO  W9-MTR-STORAGE-FAC-TX              
              END-IF                                                    
              STRING W9-MTR-STORAGE-FAC-CD, WS-HYPEN2,                  
                     W9-MTR-STORAGE-FAC-TX                              
              DELIMITED BY SIZE  INTO WS-MSF-DETAIL                     
              MOVE   1                         TO WS-ROW-COUNT1         
              MOVE  'H'                        TO RS-MOVEMNT-ROW-TYPE   
              MOVE  MP-DATE-MOVE               TO RS-DATE-MOVE          
              MOVE  SPACES                     TO RS-CODE-CRNT-LOC      
              MOVE  M6-EQUIP-LOC-DESC          TO RS-EQUIP-LOC-DESC     
              MOVE  MP-EQUIP-LOC-ID            TO RS-EQUIP-LOC-ID       
              MOVE  SPACES                     TO RS-HOW-ATTACHED-CD    
              MOVE  MA-METER-NO                TO RS-METER-NO           
              MOVE  WS-MSF-DETAIL              TO RS-MSF-DETAIL         
              MOVE   0                         TO WS-ACTIVE-RETURN-CODE 
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
           INITIALIZE WS-MSF-DETAIL.                                    
           PERFORM 7410-FETCH-MOV-CURSOR      THRU 7410-EXIT.           
      *                                                                 00099653
       2410-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00099656
      *2720-LOC-OLD-ACCT.                                              *00099657
      * IF CODE-CRNT-LOC IS 'X'                                        *00099658
      ******************************************************************00099659
       2720-LOC-OLD-ACCT.                                               
           MOVE MV-LOC-NO                            TO WS-LOC-NO.      
           IF WS-LOC-NO-IND  = -1                                       
              MOVE SPACES                            TO WS-LOC-NO       
           END-IF.                                                      
           IF MV-LOC-NO  = 0   OR WS-LOC-NO-IND  = -1                   
              STRING WS-LOC-OLD-ACT,  WS-COLON,                         
                     WS-LOC-DESC-UNKNOWN                                
              DELIMITED BY SIZE  INTO RS-MSF-DETAIL                     
           ELSE                                                         
              STRING WS-LOC-OLD-ACT, WS-COLON                           
                    , WS-LOC-NO                                         
              DELIMITED BY SIZE  INTO RS-MSF-DETAIL                     
           END-IF.                                                      
                                                                        
       2720-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00099677
      *2730-LOC-OTHER.                                                 *00099678
      *WHEN CODE-CRNT-LOC IS NOT SATISFY ANY CASE                      *00099679
      ******************************************************************00099680
       2730-LOC-OTHER.                                                  
           MOVE WS-CODE-UTIL-TYPE              TO W9-CODE-UTIL-TYPE.    
           MOVE WS-COMPANY-NO                  TO W9-COMPANY-NO.        
           PERFORM 7050-SELECT-STOR-FAC-TX     THRU  7050-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              STRING WS-LOCAL-OFFICE, WS-HYPEN2,                        
                     W9-MTR-STORAGE-FAC-TX                              
              DELIMITED BY SIZE  INTO RS-MSF-DETAIL                     
           ELSE                                                         
              MOVE  WS-LOC-DESC-UNKNOWN        TO RS-MSF-DETAIL         
           END-IF.                                                      
       2730-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00099694
      *2740-BUILD-ADDRESS-STRING.                                      *00099700
      ******************************************************************00099800
       2740-BUILD-ADDRESS-STRING.                                       
           MOVE SPACE                             TO WS-ADDRESS.        
           SET WS-ADD-SUB                         TO 1.                 
                                                                        
           IF DY-HOUSE-NO          NOT = SPACE                          
              MOVE DY-HOUSE-NO                    TO WS-FROM            
              MOVE LENGTH OF DY-HOUSE-NO          TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF                                                       
                                                                        
           IF DY-ADDR-PREFIX-1     NOT = SPACE                          
              MOVE DY-ADDR-PREFIX-1               TO WS-FROM            
              MOVE LENGTH OF DY-ADDR-PREFIX-1     TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF                                                       
                                                                        
           IF DY-ADDR-PREFIX-2     NOT = SPACE                          
              MOVE DY-ADDR-PREFIX-2               TO WS-FROM            
              MOVE LENGTH OF DY-ADDR-PREFIX-2     TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF                                                       
                                                                        
           IF DY-STREET-NAME       NOT = SPACE                          
              MOVE DY-STREET-NAME                 TO WS-FROM            
              MOVE LENGTH OF DY-STREET-NAME       TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF                                                       
                                                                        
           IF DY-STREET-SUFFIX     NOT = SPACE                          
              MOVE DY-STREET-SUFFIX               TO WS-FROM            
              MOVE LENGTH OF DY-STREET-SUFFIX     TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF                                                       
                                                                        
           IF DY-STREET-LOCATION-1 NOT = SPACE                          
              MOVE DY-STREET-LOCATION-1           TO WS-FROM            
              MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF                                                       
                                                                        
           IF DY-STREET-LOCATION-2 NOT = SPACE                          
              MOVE DY-STREET-LOCATION-2           TO WS-FROM            
              MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF.                                                      
                                                                        
           IF A4-TOWN              NOT = SPACE                          
              MOVE  A4-TOWN                       TO WS-FROM            
              MOVE LENGTH OF A4-TOWN              TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF.                                                      
                                                                        
           IF A4-STATE             NOT = SPACE                          
              MOVE  A4-STATE                      TO WS-FROM            
              MOVE LENGTH OF A4-STATE             TO WS-MAX-SZ          
              PERFORM 2750-ACCUMULATE-ADDRESS     THRU 2750-EXIT        
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE          NOT = SPACE                          
              MOVE DY-ZIP-CODE                TO WS-FROM                
              MOVE LENGTH OF DY-ZIP-CODE      TO WS-MAX-SZ              
              PERFORM 2750-ACCUMULATE-ADDRESS THRU 2750-EXIT            
           END-IF.                                                      
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR   NOT = SPACE                       
              MOVE WS-HYPEN                           TO WS-FROM        
              MOVE LENGTH OF WS-HYPEN                 TO WS-MAX-SZ      
              PERFORM 2750-ACCUMULATE-ADDRESS         THRU 2750-EXIT    
              MOVE DY-ZIP-CODE-PLUS-FOUR              TO WS-FROM        
              MOVE LENGTH OF DY-ZIP-CODE-PLUS-FOUR    TO WS-MAX-SZ      
              PERFORM 2750-ACCUMULATE-ADDRESS         THRU 2750-EXIT    
           END-IF.                                                      
                                                                        
       2740-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00107400
      *2750-ACCUMULATE-ADDRESS                                         *00107500
      *TO TRIM VALUES OF ALL ADDRESS VARIABLES                         *00107600
      * AND SHOW ADDRESS VARIABLES IN GIVEN FORMAT                     *00107700
      ******************************************************************00107800
       2750-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH                               
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2750-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00109900
      *7000-SELECT-EQUIPMENT                                           *00110000
      ******************************************************************00110100
       7000-SELECT-EQUIPMENT.                                           
           EXEC SQL                                                     
               SELECT CODE_CRNT_LOC                                     
                     ,DATE_LAST_MOVE                                    
                     ,CRNT_LOC_NO                                       
                     ,LOCAL_OFFICE                                      
C14744               ,IN_TRANSIT_EMP_ID                                 
               INTO  :EQ-CODE-CRNT-LOC                                  
                    ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND           
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EQ-LOCAL-OFFICE                                   
C14744              ,:EQ-IN-TRANSIT-EMP-ID                              
               FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                         
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00110300
MFA-TR*        SELECT CODE_CRNT_LOC                                     00110400
MFA-TR*              ,DATE_LAST_MOVE                                    00110500
MFA-TR*              ,CRNT_LOC_NO                                       00110600
MFA-TR*              ,LOCAL_OFFICE                                      00110700
MFA-TR*              ,IN_TRANSIT_EMP_ID                                 00110700
MFA-TR*        INTO  :EQ-CODE-CRNT-LOC                                  00110800
MFA-TR*             ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-IND           00110900
MFA-TR*             ,:EQ-CRNT-LOC-NO                                    00111000
MFA-TR*             ,:EQ-LOCAL-OFFICE                                   00111100
MFA-TR*             ,:EQ-IN-TRANSIT-EMP-ID                              00111100
MFA-TR*        FROM CSS_EQUIPMENT                                       00111200
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                    00111300
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                00111400
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                     00111500
MFA-TR*        WITH UR                                                  00111600
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                    00111700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DATE-LAST-MOVE-IND = -1                             
                 MOVE 0                 TO WS-DATE-LAST-MOVE-IND        
                 MOVE 'N/A'             TO EQ-DATE-LAST-MOVE            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00114200
      ******************************************************************00114300
      *7020-SELECT-EQUIP-LOC.                                          *00114400
      ******************************************************************00114500
       7020-SELECT-EQUIP-LOC.                                           
           EXEC SQL                                                     
               SELECT EQUIP_LOC_ID                                      
                      ,EQUIP_LOC_DESC                                   
               INTO  :M6-EQUIP-LOC-ID                                   
                    ,:M6-EQUIP-LOC-DESC                                 
               FROM CSS_EQUIP_LOCATION WITH(READUNCOMMITTED)                    
               WHERE EQUIP_LOC_ID   = :M6-EQUIP-LOC-ID                  
                 AND COMPANY_NO     = :M6-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :M6-CODE-UTIL-TYPE                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00114700
MFA-TR*        SELECT EQUIP_LOC_ID                                      00114800
MFA-TR*               ,EQUIP_LOC_DESC                                   00114900
MFA-TR*        INTO  :M6-EQUIP-LOC-ID                                   00115000
MFA-TR*             ,:M6-EQUIP-LOC-DESC                                 00115100
MFA-TR*        FROM CSS_EQUIP_LOCATION                                  00115200
MFA-TR*        WHERE EQUIP_LOC_ID   = :M6-EQUIP-LOC-ID                  00115300
MFA-TR*          AND COMPANY_NO     = :M6-COMPANY-NO                    00115400
MFA-TR*          AND CODE_UTIL_TYPE = :M6-CODE-UTIL-TYPE                00115500
MFA-TR*        WITH UR                                                  00115600
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                    00115700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_LOCATION' TO TABLE-1                      
              MOVE 'CODE-UTIL-TYPE'     TO TABLE-ELEMENT-1              
              MOVE 'COMPANY-NO'         TO TABLE-ELEMENT-2              
              MOVE 'EQUIP-LOC-ID'       TO TABLE-ELEMENT-3              
              MOVE M6-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1            
              MOVE M6-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE M6-EQUIP-LOC-ID      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00117900
      *7040-SELECT-ADDRESS.                                            *00118000
      ******************************************************************00118100
       7040-SELECT-ADDRESS.                                             
           EXEC SQL                                                     
               SELECT DY.ADDR_PREFIX_1                                  
                     ,DY.ADDR_PREFIX_2                                  
                     ,DY.HOUSE_NO                                       
                     ,DY.STREET_LOCATION_1                              
                     ,DY.STREET_LOCATION_2                              
                     ,DY.STREET_NAME                                    
                     ,DY.STREET_SUFFIX                                  
                     ,DY.ZIP_CODE                                       
                     ,DY.ZIP_CODE_PLUS_FOUR                             
                     ,A4.STATE                                          
                     ,A4.TOWN                                           
               INTO  :DY-ADDR-PREFIX-1                                  
                    ,:DY-ADDR-PREFIX-2                                  
                    ,:DY-HOUSE-NO                                       
                    ,:DY-STREET-LOCATION-1                              
                    ,:DY-STREET-LOCATION-2                              
                    ,:DY-STREET-NAME                                    
                    ,:DY-STREET-SUFFIX                                  
                    ,:DY-ZIP-CODE                                       
                    ,:DY-ZIP-CODE-PLUS-FOUR                             
                    ,:A4-STATE                                          
                    ,:A4-TOWN                                           
               FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                 
                   ,CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                       
                   ,CSS_PREMISE  PR WITH(READUNCOMMITTED)                       
               WHERE DY.ZIP_CODE       = A4.ZIP_CODE                    
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                 AND DY.ADDRESS_ID     = PR.ADDRESS_ID                  
                 AND PR.PREMISE_NO     = :PR-PREMISE-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00118300
MFA-TR*        SELECT DY.ADDR_PREFIX_1                                  00118400
MFA-TR*              ,DY.ADDR_PREFIX_2                                  00118500
MFA-TR*              ,DY.HOUSE_NO                                       00118600
MFA-TR*              ,DY.STREET_LOCATION_1                              00118700
MFA-TR*              ,DY.STREET_LOCATION_2                              00118800
MFA-TR*              ,DY.STREET_NAME                                    00118900
MFA-TR*              ,DY.STREET_SUFFIX                                  00119000
MFA-TR*              ,DY.ZIP_CODE                                       00119100
MFA-TR*              ,DY.ZIP_CODE_PLUS_FOUR                             00119200
MFA-TR*              ,A4.STATE                                          00119300
MFA-TR*              ,A4.TOWN                                           00119400
MFA-TR*        INTO  :DY-ADDR-PREFIX-1                                  00119500
MFA-TR*             ,:DY-ADDR-PREFIX-2                                  00119600
MFA-TR*             ,:DY-HOUSE-NO                                       00119700
MFA-TR*             ,:DY-STREET-LOCATION-1                              00119800
MFA-TR*             ,:DY-STREET-LOCATION-2                              00119900
MFA-TR*             ,:DY-STREET-NAME                                    00120000
MFA-TR*             ,:DY-STREET-SUFFIX                                  00120100
MFA-TR*             ,:DY-ZIP-CODE                                       00120200
MFA-TR*             ,:DY-ZIP-CODE-PLUS-FOUR                             00120300
MFA-TR*             ,:A4-STATE                                          00120400
MFA-TR*             ,:A4-TOWN                                           00120500
MFA-TR*        FROM CSS_ADDR_FORMATTED DY                               00120600
MFA-TR*            ,CSS_ZIP_CODE A4                                     00120700
MFA-TR*            ,CSS_PREMISE  PR                                     00120800
MFA-TR*        WHERE DY.ZIP_CODE       = A4.ZIP_CODE                    00120900
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              00121000
MFA-TR*          AND DY.ADDRESS_ID     = PR.ADDRESS_ID                  00121100
MFA-TR*          AND PR.PREMISE_NO     = :PR-PREMISE-NO                 00121200
MFA-TR*        WITH UR                                                  00121300
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                    00121400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7040'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'CSS_PREMISE'        TO TABLE-2                      
              MOVE 'CSS_ZIP_CODE'       TO TABLE-3                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00123400
      ******************************************************************00123500
      *7050-SELECT-STOR-FAC-TX                                         *00123600
      ******************************************************************00123700
       7050-SELECT-STOR-FAC-TX.                                         
           EXEC SQL                                                     
               SELECT MTR_STORAGE_FAC_TX                                
               INTO  :W9-MTR-STORAGE-FAC-TX                             
               FROM  CSS_MTR_STORGE_FAC WITH(READUNCOMMITTED)                   
               WHERE CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE            
                 AND COMPANY_NO         = :W9-COMPANY-NO                
                 AND MTR_STORAGE_FAC_CD = :W9-MTR-STORAGE-FAC-CD        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00123900
MFA-TR*        SELECT MTR_STORAGE_FAC_TX                                00124000
MFA-TR*        INTO  :W9-MTR-STORAGE-FAC-TX                             00124100
MFA-TR*        FROM  CSS_MTR_STORGE_FAC                                 00124200
MFA-TR*        WHERE CODE_UTIL_TYPE     = :W9-CODE-UTIL-TYPE            00124300
MFA-TR*          AND COMPANY_NO         = :W9-COMPANY-NO                00124400
MFA-TR*          AND MTR_STORAGE_FAC_CD = :W9-MTR-STORAGE-FAC-CD        00124500
MFA-TR*        WITH UR                                                  00124600
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                    00124700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7050'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_MTR_STORGE_FAC'   TO TABLE-1                    
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1            
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-2            
              MOVE 'MTR_STORAGE_FAC_CD'   TO TABLE-ELEMENT-3            
              MOVE W9-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1          
              MOVE W9-COMPANY-NO          TO HOSTVAR-ELEMENT-2          
              MOVE W9-MTR-STORAGE-FAC-CD  TO HOSTVAR-ELEMENT-3          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00126900
      * 7200-OPEN-CURSOR1                                              *00127000
      ******************************************************************00127100
       7200-OPEN-CURSOR1.                                               
                                                                        
           EXEC SQL                                                     
              OPEN CURSOR1                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_MOVEMENT_HIST'  TO TABLE-1                      
              MOVE 'CSS_EQUIP_LOCATION' TO TABLE-2                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_DEVICE_TYPE'   TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MV-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MV-CODE-DEVICE-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE MV-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MV-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00130200
      *                                                                 00130300
      ******************************************************************00130400
      * 7210-FETCH-CURSOR1                                             *00130500
      ******************************************************************00130600
       7210-FETCH-CURSOR1.                                              
                                                                        
           EXEC SQL                                                     
              FETCH CURSOR1                                             
               INTO :MV-DATE-MOVE :WS-DATE-MOVE-IND                      
                   ,:M6-EQUIP-LOC-DESC :WS-EQUIP-LOC-DESC-IND            
                   ,:MV-MOVE-NO                                         
                   ,:MV-LOCAL-OFFICE                                    
                   ,:MV-LOC-NO :WS-LOC-NO-IND                            
                   ,:MV-CODE-CRNT-LOC :WS-CODE-CRNT-LOC-IND              
                   ,:MV-LAST-READ-VALUE                                 
C14744             ,:MV-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DATE-MOVE-IND = -1                                  
                 MOVE 0          TO  WS-DATE-MOVE-IND                   
                 MOVE 'N/A'      TO  MV-DATE-MOVE                       
              END-IF                                                    
              IF WS-EQUIP-LOC-DESC-IND = -1                             
                 MOVE 0          TO  WS-EQUIP-LOC-DESC-IND              
                 MOVE 'UNKNOWN'  TO  M6-EQUIP-LOC-DESC                  
              END-IF                                                    
              IF WS-CODE-CRNT-LOC-IND = -1                              
                 MOVE 0          TO  WS-CODE-CRNT-LOC-IND               
                 MOVE SPACES     TO  MV-CODE-CRNT-LOC                   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7210'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_MOVEMENT_HIST'  TO TABLE-1                      
              MOVE 'CSS_EQUIP_LOCATION' TO TABLE-2                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_DEVICE_TYPE'   TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MV-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MV-CODE-DEVICE-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE MV-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MV-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00135500
      ******************************************************************00135600
      * 7220-CLOSE-CURSOR1                                             *00135700
      ******************************************************************00135800
       7220-CLOSE-CURSOR1.                                              
                                                                        
           EXEC SQL                                                     
              CLOSE CURSOR1                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7220'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_MOVEMENT_HIST'  TO TABLE-1                      
              MOVE 'CSS_EQUIP_LOCATION' TO TABLE-2                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_DEVICE_TYPE'   TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MV-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MV-CODE-DEVICE-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE MV-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MV-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00138900
      ******************************************************************00139000
      * 7300-OPEN-ATCH-CURSOR.                                          00139100
      ******************************************************************00139200
       7300-OPEN-ATCH-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN ATCH_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MA-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00142300
      ******************************************************************00142400
      * 7310-FETCH-ATCH-CURSOR.                                         00142500
      ******************************************************************00142600
       7310-FETCH-ATCH-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH ATCH_CURSOR                                         
               INTO :EQ-CODE-CRNT-LOC :WS-CODE-CRNT-LOC-IND              
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:MA-HOW-ATTACHED-CD                                 
                   ,:MA-METER-NO                                        
C14744             ,:EQ-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7310'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MA-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00146200
      ******************************************************************00146300
      *7320-CLOSE-ATCH-CURSOR                                          *00146400
      ******************************************************************00146500
       7320-CLOSE-ATCH-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ATCH_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7320'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MA-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00149400
      ******************************************************************00149500
      *7330-SELECT-EQUIP-ATCH                                          *00149600
      ******************************************************************00149700
       7330-SELECT-EQUIP-ATCH.                                          
                                                                        
           EXEC SQL                                                     
               SELECT DATE_LAST_MOVE                                    
                     ,EQUIP_LOC_ID                                      
                     ,MTR_STORAGE_FAC_CD                                
C14744               ,IN_TRANSIT_EMP_ID                                 
               INTO  :LX-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND           
                    ,:LX-EQUIP-LOC-ID                                   
                    ,:LX-MTR-STORAGE-FAC-CD :WS-MTR-STOR-FAC-CD-IND      
C14744              ,:LX-IN-TRANSIT-EMP-ID                              
               FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                    
               WHERE COMPANY_NO     = :LX-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                
                 AND CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE                 
                 AND DEVICE_NO      = :LX-DEVICE-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00150000
MFA-TR*        SELECT DATE_LAST_MOVE                                    00150100
MFA-TR*              ,EQUIP_LOC_ID                                      00150200
MFA-TR*              ,MTR_STORAGE_FAC_CD                                00150210
MFA-TR*              ,IN_TRANSIT_EMP_ID                                 00150210
MFA-TR*        INTO  :LX-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-IND           00150300
MFA-TR*             ,:LX-EQUIP-LOC-ID                                   00150400
MFA-TR*             ,:LX-MTR-STORAGE-FAC-CD:WS-MTR-STOR-FAC-CD-IND      00150410
MFA-TR*             ,:LX-IN-TRANSIT-EMP-ID                                      
MFA-TR*        FROM CSS_EQUIP_ATTCHMTS                                  00150500
MFA-TR*        WHERE COMPANY_NO     = :LX-COMPANY-NO                    00150600
MFA-TR*          AND CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                00150700
MFA-TR*          AND CODE_ATT_TYPE  = :LX-CODE-ATT-TYPE                 00150800
MFA-TR*          AND DEVICE_NO      = :LX-DEVICE-NO                     00150900
MFA-TR*        WITH UR                                                  00151000
MFA-TR*        QUERYNO 7330                                                     
MFA-TR*    END-EXEC.                                                    00151100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
                                                                        
              IF WS-DATE-LAST-MOVE-IND = -1                             
                 MOVE 0                 TO WS-DATE-LAST-MOVE-IND        
                 MOVE 'N/A'             TO LX-DATE-LAST-MOVE            
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7330'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-3            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00153800
      ******************************************************************00153900
      * 7400-OPEN-MOV-CURSOR.                                           00154000
      ******************************************************************00154100
       7400-OPEN-MOV-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN MOV_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATT_MOVE' TO TABLE-1                      
              MOVE 'CSS_MTR_STORGE_FAC' TO TABLE-2                      
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-3                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MP-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MP-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MP-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-3            
              MOVE MP-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00157300
      ******************************************************************00157400
      * 7410-FETCH-MOV-CURSOR.                                          00157500
      ******************************************************************00157600
       7410-FETCH-MOV-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              FETCH MOV_CURSOR                                          
               INTO :MP-DATE-MOVE                                       
                   ,:M6-EQUIP-LOC-DESC :WS-EQUIP-LOC-DESC-IND            
                   ,:MP-EQUIP-LOC-ID                                    
                   ,:MA-METER-NO :WS-METER-NO-IND                        
                   ,:W9-MTR-STORAGE-FAC-CD :WS-MTR-STOR-FAC-CD-IND       
                   ,:W9-MTR-STORAGE-FAC-TX :WS-MTR-STOR-FAC-TX-IND       
C14744             ,:MP-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7410'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATT_MOVE' TO TABLE-1                      
              MOVE 'CSS_MTR_STORGE_FAC' TO TABLE-2                      
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-3                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MP-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MP-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MP-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-3            
              MOVE MP-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00161400
      ******************************************************************00161500
      *7420-CLOSE-ATCH-CURSOR                                          *00161600
      ******************************************************************00161700
       7420-CLOSE-MOV-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE MOV_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7420'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATT_MOVE' TO TABLE-1                      
              MOVE 'CSS_MTR_STORGE_FAC' TO TABLE-2                      
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-3                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MP-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MP-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MP-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-3            
              MOVE MP-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00164900
      * 8000A-DELETE-GTT-ROWS.                                         *00165000
      ******************************************************************00165100
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04218_R1                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00165800
MFA-TR*       DELETE FROM SESSION.CSR04218_R1                           00165900
MFA-TR*    END-EXEC.                                                    00166000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8000A'              TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSR04218_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00168900
      ******************************************************************00169000
      * 8100-SEND-RESULT.                                              *00169100
      ******************************************************************00169200
       8100-SEND-RESULT.                                                
      *                                                                 00169400
           EXEC SQL                                                     
              INSERT INTO #CSR04218_R1                           
              (                                                         
                  RETURN_CODE                                           
                 ,MOVEMNT_ROW_TYPE                                      
                 ,EQUIP_LOC_DESC                                        
                 ,MSF_DETAIL                                            
                 ,DATE_MOVE                                             
                 ,EQUIP_LOC_ID                                          
                 ,HOW_ATTACHED_CD                                       
                 ,METER_NO                                              
                 ,CODE_CRNT_LOC                                         
                 ,LAST_READ_VALUE                                       
C14744           ,IN_TRANSIT_EMP_ID                                     
A05136           ,PREMISE_NO                                            
               )                                                        
              VALUES                                                    
              (                                                         
                  :S-RETURN-CODE                                        
                 ,:S-MOVEMNT-ROW-TYPE                                   
                 ,:S-EQUIP-LOC-DESC                                     
                 ,:S-MSF-DETAIL                                         
                 ,:S-DATE-MOVE                                          
                 ,:S-EQUIP-LOC-ID                                       
                 ,:S-HOW-ATTACHED-CD                                    
                 ,:S-METER-NO                                           
                 ,:S-CODE-CRNT-LOC                                      
                 ,:S-LAST-READ-VALUE                                    
C14744           ,:S-IN-TRANSIT-EMP-ID                                  
A05136           ,:S-PREMISE-NO                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00169500
MFA-TR*       INSERT INTO SESSION.CSR04218_R1                           00169600
MFA-TR*       (                                                         00169700
MFA-TR*           RETURN_CODE                                           00169800
MFA-TR*          ,MOVEMNT_ROW_TYPE                                      00169900
MFA-TR*          ,EQUIP_LOC_DESC                                        00170000
MFA-TR*          ,MSF_DETAIL                                            00170100
MFA-TR*          ,DATE_MOVE                                             00170200
MFA-TR*          ,EQUIP_LOC_ID                                          00170300
MFA-TR*          ,HOW_ATTACHED_CD                                       00170400
MFA-TR*          ,METER_NO                                              00170500
MFA-TR*          ,CODE_CRNT_LOC                                         00170600
MFA-TR*          ,LAST_READ_VALUE                                       00170700
MFA-TR*          ,IN_TRANSIT_EMP_ID                                     00170700
MFA-TR*          ,PREMISE_NO                                            00170700
MFA-TR*        )                                                        00170800
MFA-TR*       VALUES                                                    00170900
MFA-TR*       (                                                         00171000
MFA-TR*           :S-RETURN-CODE                                        00171100
MFA-TR*          ,:S-MOVEMNT-ROW-TYPE                                   00171200
MFA-TR*          ,:S-EQUIP-LOC-DESC                                     00171300
MFA-TR*          ,:S-MSF-DETAIL                                         00171400
MFA-TR*          ,:S-DATE-MOVE                                          00171500
MFA-TR*          ,:S-EQUIP-LOC-ID                                       00171600
MFA-TR*          ,:S-HOW-ATTACHED-CD                                    00171700
MFA-TR*          ,:S-METER-NO                                           00171800
MFA-TR*          ,:S-CODE-CRNT-LOC                                      00171900
MFA-TR*          ,:S-LAST-READ-VALUE                                    00172000
MFA-TR*          ,:S-IN-TRANSIT-EMP-ID                                  00172000
MFA-TR*          ,:S-PREMISE-NO                                         00172000
MFA-TR*       )                                                         00172100
MFA-TR*    END-EXEC.                                                    00172200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04218_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00174010
      ******************************************************************00174020
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00174030
      ******************************************************************00174040
           EXEC SQL                                                     00174050
              INCLUDE CPDSP300                                          00174060
           END-EXEC.                                                    00174070
      *                                                                 00174100
           EXEC SQL                                                     00174200
               INCLUDE CPD00320                                         00174300
           END-EXEC.                                                    00174400
