       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR04217.                                           
COB303 DATE-WRITTEN. DEC 31, 2008.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      ******************************************************************00090000
      *                 P R O G R A M  S U M M A R Y                   *00100000
      *                                                                *00110000
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR GAS            *00120000
      *  ATTACHMENTS SCREEN                                            *00130000
      *                                                                *00140000
      ******************************************************************00150000
      *                                                                *00160000
      *                     PROGRAM MODIFICATION LOG                   *00170000
      *                                                                *00180000
      *    DATE    INITIALS   COMMENTS                                 *00190000
      *  --------  --------   ---------------------------------------  *00200000
      *  12/31/08   SJ94244   INITIAL VERSION.                         *00210000
A00631*  12/11/09   SJ97149   INSERTING ATTACHMENT TYPE/DEVICE-NO IN   *00210000
A00631*             ACT6320   THE TRANS HIST TABLE INSTEAD OF METER-NO *00220000
A0063A*  04/27/10   SJ97149   EXPAND DELETE ATTACHMENT AND ADD         *        
A0063A*             ACT6322   ATTACHMENT FUNCTIONALITIES IN THE PARA   *        
A0063A*                       2600-INSRT-ONE-ATTACHMENT                *        
A0631B*  06/16/10   SJ97149   ADDING EQUIP_ATTACH_DT FOR THE UPDATE SQL*        
A0631B*             ACT6324   FOR TABLE CSS_EQUIP_ATTCHMTS             *        
A0631B*                       AND ADDING QUERY NOS                     *        
A02790*  10/18/2010 SB40505   ADD IN TRANSIT AS VALID LOCATION         *        
      ******************************************************************00230000
      ******************************************************************00240000
      *                                                                *00250000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00260000
      *                                                                *00270000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00280000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00290000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00300000
      *  3000 - 4999  NOT USED                                         *00310000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00320000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00330000
      *  7000 - 7999  INPUT MODULES                                    *00340000
      *  8000 - 8999  OUTPUT MODULES                                   *00350000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00360000
      *                                                                *00370000
      ******************************************************************00380000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04217'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                                   PIC X(40) VALUE    
          'WORKING STORAGE FOR CSR04217 STARTS HERE'.                   
                                                                        
      ******************************************************************00470000
      *    WORK AREAS                                                  *00480000
      ******************************************************************00490000
                                                                        
       01 WS-COUNTER-FIELDS.                                            
          05 CTR-ROWS                  PIC S9(9) COMP VALUE 0.          
      *                                                                 00530000
       01 WS-MISC.                                                      
          05 PROGRAM-NAME              PIC X(08) VALUE 'CSR04217'.      
          05 WS-CODE-UTIL-TYPE         PIC X(01).                       
          05 WS-METER-NO               PIC X(09).                       
          05 WS-METER-NO-TEMP          PIC X(09).                       
          05 WS-COMPANY-NO             PIC X(02).                       
          05 WS-DEVICE-NO              PIC X(12).                       
A0063A    05 WS-DEVICE-NO-NEW          PIC X(12).                       
          05 WS-DATE-LAST-TESTED       PIC X(10).                       
          05 WS-TEST-SCHED-CD          PIC X(01).                       
          05 WS-LOC-ID                 PIC X(01).                       
          05 WS-HOW-ATTACHED-CD        PIC X(01).                       
          05 WS-CODE-ATT-TYPE          PIC X(02).                       
          05 WS-CODE-MAKE              PIC X(02).                       
          05 WS-CODE-DEVICE-TYPE       PIC X(01).                       
          05 WS-OLD-DEVICE-NO          PIC X(12).                       
          05 WS-OLD-CODE-ATT-TYPE      PIC X(02).                       
          05 WS-CHK-CONST-FL           PIC X(01).                       
          05 WS-CODE-ATTACHMENTS       PIC X(06).                       
          05 WS-ALLOW-CONSTANT-FL      PIC X(01).                       
          05 WS-USER-ID                PIC X(07).                       
          05 WS-APPL-PROGRAM-ID        PIC X(09).                       
          05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.          
          05 WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.          
          05 WS-DATE-LAST-MOVE         PIC X(10) VALUE SPACES.          
          05 WS-EQUIP-LOC-ID           PIC X(01) VALUE SPACES.          
          05 WS-TRANS-COMMENT          PIC X(48) VALUE SPACES.          
          05 WS-SPACE                  PIC X(01) VALUE ' '.             
          05 WS-COLON                  PIC X(01) VALUE ':'.             
          05 WS-DEL-FLAG               PIC X(01) VALUE 'N'.             
          05 WS-METER-ATTCH-FL         PIC X(01) VALUE SPACES.          
      *                                                                 00860000
       01 WS-MNT-TRANS-HIST.                                            
          05 WS-COMMENT                PIC X(210).                      
                                                                        
       01 WS-MNT-TRANS-DET.                                             
          05 WS-CODE-TRAN-TYPE         PIC X(01) VALUE 'F'.             
          05 WS-TRAN-APPL-NO           PIC S9(04) USAGE COMP.           
          05 WS-TRANS-HIST-SEQ-NO      PIC X(26) VALUE SPACES.          
          05 WS-TABLE-ID               PIC X(02).                       
          05 WS-COLUMN-DESC            PIC X(15) VALUE                  
                                               'ATT TYPE-DEVICE'.       
          05 WS-CHG-COLUMN-VALUE-TEXT  PIC X(255).                      
          05 WS-CHG-COLUMN-VALUE-LEN   PIC S9(4) USAGE COMP.            
          05 WS-PRV-COLUMN-VALUE-TEXT  PIC X(255).                      
          05 WS-PRV-COLUMN-VALUE-LEN   PIC S9(4) USAGE COMP.            
                                                                        
       01 WS-FLAGS.                                                     
          05 WS-MTR-ATTCH-TEST-EXISTS  PIC X(01) VALUE 'N'.             
             88 MTR-ATTCH-TEST-EXISTS            VALUE 'Y'.             
          05 WS-MTR-ATTYPE-TEST-EXISTS PIC X(01) VALUE 'N'.             
             88 MTR-ATTYPE-TEST-EXISTS           VALUE 'Y'.             
          05 WS-AMR-ATTACHMENT-EXISTS  PIC X(01) VALUE 'N'.             
             88 AMR-ATTACHMENT-EXISTS            VALUE 'Y'.             
          05 WS-FIRST-TIME-FL          PIC X(01) VALUE 'Y'.             
             88 WS-FIRST-TIME                    VALUE 'Y'.             
          05 WS-END-OF-ROW             PIC X(01) VALUE 'N'.             
             88 END-OF-ROW                       VALUE 'Y'.             
A0063A    05 WS-PROCESS-SWITCH         PIC X(01) VALUE ' '.             
A0063A       88 NORMAL-PROCESS                   VALUE ' '.             
A0063A       88 ADD-AND-DELETE                   VALUE 'Y'.             
      *                                                                 01150000
       01 WS-NULL-IND.                                                  
          05 WS-DATE-LAST-TESTED-IND   PIC S9(04) COMP VALUE 0.         
          05 WS-DATE-LAST-MOVE-IND     PIC S9(04) COMP VALUE 0.         
A0631B    05 WS-EQUIP-ATTACH-DT-IND    PIC S9(04) COMP VALUE 0.         
      *                                                                 01190000
       01 WS-LITERALS.                                                  
          05 WS-LOCATION-ATTACHED      PIC X(01) VALUE 'K'.             
          05 WS-LOCATION-CUSTOMER      PIC X(01) VALUE 'J'.             
          05 WS-ATT-TYPE-ERT           PIC X(02) VALUE 'IT'.            
                                                                        
      *                                                                 01300000
      ******************'THIS IS THE ROW RETURN AREA'*******************01310000
                                                                        
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE            PIC S9(09) USAGE COMP VALUE 0.   
          05 RS-DEVICE-MTR-NO          PIC X(09)  VALUE SPACES.         
          05 RS-TRANS-HIST-SEQ-NO      PIC X(26) VALUE SPACES.          
      *                                                                 01370000
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(09) USAGE COMP VALUE 0.   
          05 S-DEVICE-MTR-NO           PIC X(09)  VALUE SPACES.         
          05 S-TRANS-HIST-SEQ-NO       PIC X(26) VALUE SPACES.          
      *                                                                 01420000
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW              PIC X(01) VALUE 'Y'.             
             88 SEND-DONE-ERROR                  VALUE 'N'.             
             88 SEND-DONE-OK                     VALUE 'Y'.             
          05 WS-UPDATE-IND-SW          PIC X(01) VALUE SPACES.          
             88 WS-DEL-ALL-T                     VALUE 'T'.             
             88 WS-ADD-A                         VALUE 'A'.             
             88 WS-DEL-ONE-D                     VALUE 'D'.             
             88 WS-UPD-ONE-U                     VALUE 'U'.             
             88 WS-INS-ONE-I                     VALUE 'I'.             
                                                                        
      ******************************************************************01480000
      *    DB2 INCLUDES                                                *01490000
      ******************************************************************01500000
      *                                                                 01510000
           EXEC SQL                                                     01520000
              INCLUDE SQLCA                                             01530000
           END-EXEC.                                                    01540000
      *                                                                 01550000
      ******************************************************************02190000
      * CSS_ACCOUNT - AT                                               *02200000
      ******************************************************************02210000
           EXEC SQL                                                     02220000
              INCLUDE TBACCT                                            02230000
           END-EXEC.                                                    02240000
      *                                                                 02250000
      ******************************************************************02120000
      * CSS_CUST_PREM_HIST - CH                                        *02130000
      ******************************************************************02140000
           EXEC SQL                                                     02150000
              INCLUDE TBCSTPRM                                          02160000
           END-EXEC.                                                    02170000
      *                                                                 02180000
      ******************************************************************01700000
      * CSS_EQUIP_ATT_MOVE - MP                                        *01710000
      ******************************************************************01720000
           EXEC SQL                                                     01730000
              INCLUDE TBEQMOVE                                          01740000
           END-EXEC.                                                    01750000
      *                                                                 01760000
      ******************************************************************01840000
      * CSS_EQUIPMENT - EQ                                             *01850000
      ******************************************************************01860000
           EXEC SQL                                                     01870000
              INCLUDE TBEQUIP                                           01880000
           END-EXEC.                                                    01890000
      *                                                                 01900000
      ******************************************************************01980000
      * CSS_EQUIP_ATTCHMTS - LX                                        *01990000
      ******************************************************************02000000
           EXEC SQL                                                     02010000
              INCLUDE TBEQATTH                                          02020000
           END-EXEC.                                                    02030000
      *                                                                 02040000
      ******************************************************************01910000
      * CSS_GAS_METER - GM                                             *01920000
      ******************************************************************01930000
           EXEC SQL                                                     01940000
              INCLUDE TBGASMTR                                          01950000
           END-EXEC.                                                    01960000
      *                                                                 01970000
      ******************************************************************02260000
      * CSS_GAS_METER_SIZE - M5                                        *02270000
      ******************************************************************02280000
           EXEC SQL                                                     02290000
              INCLUDE TBGASMSZ                                          02300000
           END-EXEC.                                                    02310000
      *                                                                 02320000
      ******************************************************************02050000
      * CSS_METER_ATTCHMTS - MA                                         02060000
      ******************************************************************02070000
           EXEC SQL                                                     02080000
              INCLUDE TBMTRATT                                          02090000
           END-EXEC.                                                    02100000
      *                                                                 02110000
      ******************************************************************02330000
      * CSS_MTR_ATT_TYPE - N5                                          *02340000
      ******************************************************************02350000
           EXEC SQL                                                     02360000
              INCLUDE TBMTRATP                                          02370000
           END-EXEC.                                                    02380000
      *                                                                 02390000
      ******************************************************************01560000
      * CSS_MT_TRN_HST_DET - MI                                        *01570000
      ******************************************************************01580000
           EXEC SQL                                                     01590000
              INCLUDE TBMNHDT                                           01600000
           END-EXEC.                                                    01610000
      *                                                                 01620000
      ******************************************************************01630000
      * CSS_MNT_TRANS_HIST - MH                                        *01640000
      ******************************************************************01650000
           EXEC SQL                                                     01660000
              INCLUDE TBMNHIST                                          01670000
           END-EXEC.                                                    01680000
      *                                                                 01690000
      ******************************************************************01770000
      * CSS_USER_PROFILE - PF                                          *01780000
      ******************************************************************01790000
           EXEC SQL                                                     01800000
              INCLUDE TBUSRPRF                                          01810000
           END-EXEC.                                                    01820000
      *                                                                 01830000
      ******************************************************************02400000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02410000
      ******************************************************************02420000
                                                                        
           COPY CWS00303.                                               02440000
                                                                        
           EXEC SQL                                                     02460000
              INCLUDE CWSX0010                                          02470000
           END-EXEC.                                                    02480000
      *                                                                 02490000
      ******************************************************************02500000
      *  CURSOR DECLARATIONS                                           *02510000
      ******************************************************************02520000
           EXEC SQL                                                     
              DECLARE ATCH_CURSOR CURSOR FOR                            
              SELECT MA.CODE_UTIL_TYPE                                  
                    ,MA.METER_NO                                        
                    ,MA.CODE_DEVICE_TYPE                                
                    ,MA.DEVICE_NO                                       
                    ,MA.CODE_ATT_TYPE                                   
                    ,MA.CT_PT_RATIO                                     
                    ,MA.COMPANY_NO                                      
                    ,MA.CODE_MAKE                                       
                    ,MA.DATE_LAST_TESTED                                
                    ,MA.TEST_SCHED_CD                                   
                    ,EQ.LOCAL_OFFICE                                    
                    ,EQ.SERIAL_NO                                       
                    ,EQ.CODE_CRNT_LOC                                   
                    ,MA.HOW_ATTACHED_CD                                 
                    ,EQ.CRNT_LOC_NO                                     
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                    ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
               WHERE MA.METER_NO       = EQ.DEVICE_NO                   
                 AND MA.COMPANY_NO     = EQ.COMPANY_NO                  
                 AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              
                 AND MA.METER_NO       = :MA-METER-NO                   
                 AND MA.COMPANY_NO     = :MA-COMPANY-NO                 
                 AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             
               ORDER BY                                                 
                     MA.CODE_ATT_TYPE                                   
                    ,MA.DEVICE_NO                                       
               FOR READ ONLY                                    
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02530000
MFA-TR*       DECLARE ATCH_CURSOR CURSOR FOR                            02540000
MFA-TR*       SELECT MA.CODE_UTIL_TYPE                                  02550000
MFA-TR*             ,MA.METER_NO                                        02560000
MFA-TR*             ,MA.CODE_DEVICE_TYPE                                02570000
MFA-TR*             ,MA.DEVICE_NO                                       02580000
MFA-TR*             ,MA.CODE_ATT_TYPE                                   02590000
MFA-TR*             ,MA.CT_PT_RATIO                                     02600000
MFA-TR*             ,MA.COMPANY_NO                                      02610000
MFA-TR*             ,MA.CODE_MAKE                                       02620000
MFA-TR*             ,MA.DATE_LAST_TESTED                                02630000
MFA-TR*             ,MA.TEST_SCHED_CD                                   02640000
MFA-TR*             ,EQ.LOCAL_OFFICE                                    02650000
MFA-TR*             ,EQ.SERIAL_NO                                       02660000
MFA-TR*             ,EQ.CODE_CRNT_LOC                                   02670000
MFA-TR*             ,MA.HOW_ATTACHED_CD                                 02680000
MFA-TR*             ,EQ.CRNT_LOC_NO                                     02690000
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                              02700000
MFA-TR*             ,CSS_EQUIPMENT EQ                                   02710000
MFA-TR*        WHERE MA.METER_NO       = EQ.DEVICE_NO                   02720000
MFA-TR*          AND MA.COMPANY_NO     = EQ.COMPANY_NO                  02730000
MFA-TR*          AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              02740000
MFA-TR*          AND MA.METER_NO       = :MA-METER-NO                   02750000
MFA-TR*          AND MA.COMPANY_NO     = :MA-COMPANY-NO                 02760000
MFA-TR*          AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             02770000
MFA-TR*        ORDER BY                                                 02780000
MFA-TR*              MA.CODE_ATT_TYPE                                   02790000
MFA-TR*             ,MA.DEVICE_NO                                       02800000
MFA-TR*        FOR FETCH ONLY WITH UR                                   02810003
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                    02820000
      *                                                                 02830000
       LINKAGE SECTION.                                                 
      *                                                                 02850000
       01 PARM-UPDATE-IND                PIC X(01).                     
       01 PARM-CODE-UTIL-TYPE            PIC X(01).                     
       01 PARM-METER-NO                  PIC X(09).                     
       01 PARM-COMPANY-NO                PIC X(02).                     
       01 PARM-DEVICE-NO                 PIC X(12).                     
       01 PARM-DATE-LAST-TESTED          PIC X(10).                     
       01 PARM-TEST-SCHED-CD             PIC X(01).                     
       01 PARM-HOW-ATTACHED-CD           PIC X(01).                     
       01 PARM-CODE-ATT-TYPE             PIC X(02).                     
       01 PARM-CODE-MAKE                 PIC X(02).                     
       01 PARM-CODE-DEVICE-TYPE          PIC X(01).                     
       01 PARM-OLD-DEVICE-NO             PIC X(12).                     
       01 PARM-OLD-CODE-ATT-TYPE         PIC X(02).                     
       01 PARM-CHK-CONST-FL              PIC X(01).                     
       01 PARM-USER-ID                   PIC X(07).                     
       01 PARM-ALLOW-CONSTANT-FL         PIC X(01).                     
       01 PARM-CODE-ATTACHMENTS          PIC X(06).                     
       01 PARM-TRANS-HIST-SEQ-NO         PIC X(26).                     
       01 PARM-TRAN-APPL-NO              PIC S9(04) USAGE COMP.         
       01 PARM-APPL-PROGRAM-ID           PIC X(09).                     
      *                                                                 03060000
       PROCEDURE DIVISION USING                                         
                                PARM-UPDATE-IND                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-METER-NO                           
                                PARM-COMPANY-NO                         
                                PARM-DEVICE-NO                          
                                PARM-DATE-LAST-TESTED                   
                                PARM-TEST-SCHED-CD                      
                                PARM-HOW-ATTACHED-CD                    
                                PARM-CODE-ATT-TYPE                      
                                PARM-CODE-MAKE                          
                                PARM-CODE-DEVICE-TYPE                   
                                PARM-OLD-DEVICE-NO                      
                                PARM-OLD-CODE-ATT-TYPE                  
                                PARM-CHK-CONST-FL                       
                                PARM-USER-ID                            
                                PARM-ALLOW-CONSTANT-FL                  
                                PARM-CODE-ATTACHMENTS                   
                                PARM-TRANS-HIST-SEQ-NO                  
                                PARM-TRAN-APPL-NO                       
                                PARM-APPL-PROGRAM-ID.                   
      *                                                                 03280000
      ******************************************************************03290000
      * 0000-MAINLINE                                                  *03300000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03310000
      ******************************************************************03320000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03440000
      * 0100-INITIALIZE                                                *03450000
      ******************************************************************03460000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 03520000
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                  :S-RETURN-CODE       AS RETURN_CODE                   
                 ,:S-DEVICE-MTR-NO     AS DEVICE_MTR_NO                 
                 ,:S-TRANS-HIST-SEQ-NO AS TRANS_HIST_SEQ_NO             
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     03530000
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         03540000
MFA-TR*       SELECT                                                    03550000
MFA-TR*           :S-RETURN-CODE       AS RETURN_CODE                   03560000
MFA-TR*          ,:S-DEVICE-MTR-NO     AS DEVICE_MTR_NO                 03570000
MFA-TR*          ,:S-TRANS-HIST-SEQ-NO AS TRANS_HIST_SEQ_NO             03580000
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                     03590000
MFA-TR*    END-EXEC.                                                    03600000
                                                                        
           PERFORM 7000-SELECT-CURR-DATE-AND-TIME THRU 7000-EXIT.       
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03660000
      ******************************************************************03670000
      * 1000-PROCESS-INPUT                                             *03680000
      ******************************************************************03690000
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS  THRU 1200-EXIT.       
           MOVE PARM-UPDATE-IND        TO WS-UPDATE-IND-SW.             
           MOVE PARM-CODE-UTIL-TYPE    TO MA-CODE-UTIL-TYPE             
                                          GM-CODE-UTIL-TYPE             
                                          WS-CODE-UTIL-TYPE.            
           MOVE PARM-METER-NO          TO MA-METER-NO                   
                                          GM-METER-NO                   
                                          WS-METER-NO.                  
           MOVE PARM-COMPANY-NO        TO MA-COMPANY-NO                 
                                          GM-COMPANY-NO                 
                                          WS-COMPANY-NO.                
           MOVE PARM-DEVICE-NO         TO MA-DEVICE-NO                  
                                          WS-DEVICE-NO.                 
           MOVE PARM-DATE-LAST-TESTED  TO MA-DATE-LAST-TESTED           
                                          WS-DATE-LAST-TESTED.          
           MOVE PARM-TEST-SCHED-CD     TO MA-TEST-SCHED-CD              
                                          WS-TEST-SCHED-CD.             
           MOVE PARM-HOW-ATTACHED-CD   TO MA-HOW-ATTACHED-CD            
                                          WS-HOW-ATTACHED-CD.           
           MOVE PARM-CODE-ATT-TYPE     TO MA-CODE-ATT-TYPE              
                                          WS-CODE-ATT-TYPE.             
           MOVE PARM-CODE-MAKE         TO WS-CODE-MAKE.                 
           MOVE PARM-CODE-DEVICE-TYPE  TO WS-CODE-DEVICE-TYPE.          
           MOVE PARM-OLD-DEVICE-NO     TO WS-OLD-DEVICE-NO.             
           MOVE PARM-OLD-CODE-ATT-TYPE TO WS-OLD-CODE-ATT-TYPE.         
           MOVE PARM-CHK-CONST-FL      TO WS-CHK-CONST-FL.              
           MOVE PARM-USER-ID           TO WS-USER-ID.                   
           MOVE PARM-ALLOW-CONSTANT-FL TO WS-ALLOW-CONSTANT-FL.         
           MOVE PARM-CODE-ATTACHMENTS  TO WS-CODE-ATTACHMENTS.          
           MOVE PARM-TRANS-HIST-SEQ-NO TO WS-TRANS-HIST-SEQ-NO.         
           MOVE PARM-TRAN-APPL-NO      TO WS-TRAN-APPL-NO.              
           MOVE PARM-APPL-PROGRAM-ID   TO WS-APPL-PROGRAM-ID.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04060000
      ******************************************************************04070000
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *04080000
      ******************************************************************04090000
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE NOT = 'G'    OR                       
              PARM-COMPANY-NO         = SPACES OR                       
              PARM-METER-NO           = SPACES OR                       
              PARM-UPDATE-IND         = SPACES                          
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-2          
              MOVE 'PARM-METER-NO'          TO TABLE-ELEMENT-3          
              MOVE 'PARM-UPDATE-IND'        TO TABLE-ELEMENT-4          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-2        
              MOVE PARM-METER-NO            TO HOSTVAR-ELEMENT-3        
              MOVE PARM-UPDATE-IND          TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04380000
      ******************************************************************04390000
      * 2000-PROCESS-OUTPUT.                                           *04400000
      ******************************************************************04410000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-BUILD-RESULT    THRU 2100-EXIT.                 
           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04490000
      ******************************************************************04500000
      * 2000A-MOVE-RESULT.                                             *04510000
      ******************************************************************04520000
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE          TO S-RETURN-CODE.               
           MOVE RS-DEVICE-MTR-NO        TO S-DEVICE-MTR-NO.             
           MOVE RS-TRANS-HIST-SEQ-NO    TO S-TRANS-HIST-SEQ-NO.         
           ADD +1                       TO CTR-ROWS.                    
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04620000
      ******************************************************************04630000
      * 2100-BUILD-RESULT.                                             *04640000
      ******************************************************************04650000
       2100-BUILD-RESULT.                                               
      *                                                                 04670000
           EVALUATE TRUE                                                
              WHEN WS-DEL-ALL-T                                         
                 PERFORM 2200-DEL-ALL-ATTACHMENT   THRU 2200-EXIT       
              WHEN WS-ADD-A                                             
                 PERFORM 2300-ADD-ATTACHMENT       THRU 2300-EXIT       
              WHEN WS-DEL-ONE-D                                         
                 PERFORM 2400-DEL-ONE-ATTACHMENT   THRU 2400-EXIT       
              WHEN WS-UPD-ONE-U                                         
                 PERFORM 2500-UPD-ONE-ATTACHMENT   THRU 2500-EXIT       
              WHEN WS-INS-ONE-I                                         
                 PERFORM 2600-INSRT-ONE-ATTACHMENT THRU 2600-EXIT       
              WHEN OTHER                                                
                 MOVE 9999                     TO WS-ACTIVE-RETURN-CODE 
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE '2100'                   TO ACTIVE-PARAGRAPH      
                 MOVE 'EVALUATE'               TO ABEND-FUNCTION        
                 MOVE 'N/A'                    TO TABLE-1               
                 MOVE 'WS-UPDATE-IND-SW'       TO TABLE-ELEMENT-1       
                 MOVE WS-UPDATE-IND-SW         TO HOSTVAR-ELEMENT-1     
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04950000
      ******************************************************************04960000
      * 2200-DEL-ALL-ATTACHMENT                                        *04970000
      ******************************************************************04980000
       2200-DEL-ALL-ATTACHMENT.                                         
                                                                        
           PERFORM 7110-GET-ATCH-COUNT           THRU 7110-EXIT.        
                                                                        
           IF WS-METER-ATTCH-FL = 'Y'                                   
              MOVE 5100                     TO RS-RETURN-CODE           
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
           END-IF                                                       
                                                                        
           PERFORM 7120-OPEN-ATCH-CURSOR         THRU 7120-EXIT.        
           PERFORM 2210-PROCESS-ATCH-CURSOR      THRU 2210-EXIT         
                                                 UNTIL END-OF-ROW.      
           PERFORM 7140-CLOSE-ATCH-CURSOR        THRU 7140-EXIT.        
           IF WS-DEL-FLAG = 'Y'                                         
              MOVE WS-COMPANY-NO            TO EQ-COMPANY-NO            
              MOVE WS-CODE-UTIL-TYPE        TO EQ-CODE-UTIL-TYPE        
              MOVE WS-METER-NO              TO EQ-DEVICE-NO             
              MOVE WS-CURRENT-DATE          TO EQ-DATE-LAST-TRAN        
              PERFORM 8120-UPDATE-LAST-TRAN      THRU 8120-EXIT         
                                                                        
              PERFORM 7100-GET-ALW-CNT-FLAG      THRU 7100-EXIT         
                                                                        
              IF M5-ALLOW-CONSTANT-FL  = 'Y'                            
                 MOVE M5-ALLOW-CONSTANT-FL  TO GM-ALLOW-CONSTANT-FL     
              ELSE                                                      
                 MOVE 'N'                   TO GM-ALLOW-CONSTANT-FL     
              END-IF                                                    
                                                                        
              MOVE 'NN'                     TO GM-CODE-ATTACHMENTS      
                                                                        
              PERFORM 8135-UPDATE-GAS-MTR-CNT-FL THRU 8135-EXIT         
      *       ADDED THE FOLLOWING CODE PER SUE'S RECOMMENDATION.                
              PERFORM 7240-CHECK-FOR-MTR-ATTTYPE  THRU 7240-EXIT        
                                                                        
              IF MTR-ATTYPE-TEST-EXISTS                                 
                 MOVE '00'                  TO GM-PROGRAM-ID            
                 PERFORM 8130-UPDATE-GAS-MTR-PRM-ID    THRU 8130-EXIT   
              ELSE                                                      
                 MOVE '01'                  TO GM-PROGRAM-ID            
                 PERFORM 8130-UPDATE-GAS-MTR-PRM-ID    THRU 8130-EXIT   
              END-IF                                                    
                                                                        
      *      ADDED ABOVE CODE PER SUE'S RECOMMENDATION.                         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05290000
      * 2210-PROCESS-ATCH-CURSOR.                                      *05300000
      ******************************************************************05310000
       2210-PROCESS-ATCH-CURSOR.                                        
      *                                                                 05330000
           PERFORM 7130-FETCH-ATCH-CURSOR     THRU 7130-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DATE-LAST-TESTED-IND = -1                           
                 MOVE SPACES                  TO MA-DATE-LAST-TESTED    
              END-IF                                                    
                                                                        
              PERFORM 2220-PROCESS-DELETE     THRU 2220-EXIT            
           ELSE                                                         
              SET END-OF-ROW                  TO TRUE                   
           END-IF.                                                      
      *                                                                 05460000
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05490000
      ******************************************************************05600000
      * 2220-PROCESS-DELETE.                                           *05610000
      ******************************************************************05620000
       2220-PROCESS-DELETE.                                             
                                                                        
           IF MA-HOW-ATTACHED-CD = 'I'                                  
              MOVE 5100                        TO RS-RETURN-CODE        
              PERFORM 2000A-MOVE-RESULT               THRU 2000A-EXIT   
              PERFORM 9999-END-PROGRAM                THRU 9999-EXIT    
           ELSE                                                         
              IF EQ-CODE-CRNT-LOC  = WS-LOCATION-CUSTOMER OR            
                                     WS-LOCATION-ATTACHED               
                 MOVE EQ-CRNT-LOC-NO           TO CH-PREMISE-NO         
                                                                        
                 IF WS-FIRST-TIME                                       
                    PERFORM 7200-GET-ACCOUNT-DET      THRU 7200-EXIT    
                    MOVE 'N' TO WS-FIRST-TIME-FL                        
                 END-IF                                                 
                                                                        
                 PERFORM  2700-MTR-TRANS-HIST-DELETE  THRU 2700-EXIT    
              END-IF                                                    
                                                                        
              PERFORM 8220-DELETE-GAS-MTR-ATCH        THRU 8220-EXIT    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE MA-DEVICE-NO             TO LX-DEVICE-NO          
                 MOVE WS-CODE-UTIL-TYPE        TO LX-CODE-UTIL-TYPE     
                 MOVE WS-COMPANY-NO            TO LX-COMPANY-NO         
                                                                        
                 PERFORM  7215-SEL-EQUP-ATCH          THRU 7215-EXIT    
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                                                                        
                    IF WS-DATE-LAST-MOVE-IND  = -1                      
                       MOVE '1900-01-01'       TO LX-DATE-LAST-MOVE     
                    END-IF                                              
                                                                        
                    MOVE LX-DEVICE-NO          TO MP-DEVICE-NO          
                    MOVE LX-CODE-ATT-TYPE      TO MP-CODE-ATT-TYPE      
                    MOVE LX-COMPANY-NO         TO MP-COMPANY-NO         
                    MOVE LX-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE     
                    MOVE LX-DATE-LAST-MOVE     TO MP-DATE-MOVE          
                    MOVE WS-CURRENT-TIMESTAMP  TO MP-MOVE-NO            
                    MOVE LX-MTR-STORAGE-FAC-CD TO MP-MTR-STORAGE-FAC-CD 
                    MOVE LX-EQUIP-LOC-ID       TO MP-EQUIP-LOC-ID       
                    MOVE WS-METER-NO           TO MP-METER-NO           
                                                                        
                    PERFORM  8200-INSERT-EQP-ATT-MOVE THRU 8200-EXIT    
                    IF EQ-CODE-CRNT-LOC  =  'B'                         
                       MOVE   'B'              TO LX-EQUIP-LOC-ID       
                    ELSE                                                
                       MOVE   'A'              TO LX-EQUIP-LOC-ID       
                    END-IF                                              
                    MOVE WS-CURRENT-DATE       TO LX-DATE-LAST-MOVE     
                                                  LX-DATE-LAST-TRAN     
A0631B              MOVE SPACES                TO LX-EQUIP-ATTACH-DT    
A0631B              MOVE -1                    TO WS-EQUIP-ATTACH-DT-IND
                    PERFORM 8110-UPDATE-EQUP-ATCH     THRU 8110-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06190000
      ******************************************************************06800000
      * 2300-ADD-ATTACHMENT.                                           *06810000
      ******************************************************************06820000
       2300-ADD-ATTACHMENT.                                             
                                                                        
           IF PARM-DATE-LAST-TESTED  = SPACES                           
              MOVE -1                       TO WS-DATE-LAST-TESTED-IND  
           ELSE                                                         
              MOVE WS-DATE-LAST-TESTED      TO MA-DATE-LAST-TESTED      
           END-IF                                                       
                                                                        
           MOVE WS-COMPANY-NO               TO MA-COMPANY-NO            
                                               LX-COMPANY-NO            
                                               EQ-COMPANY-NO            
                                               GM-COMPANY-NO            
           MOVE WS-CODE-UTIL-TYPE           TO MA-CODE-UTIL-TYPE        
                                               LX-CODE-UTIL-TYPE        
                                               EQ-CODE-UTIL-TYPE        
                                               GM-CODE-UTIL-TYPE        
           MOVE WS-METER-NO                 TO MA-METER-NO              
                                               GM-METER-NO              
                                               MP-METER-NO              
                                               EQ-DEVICE-NO             
           MOVE WS-CODE-DEVICE-TYPE         TO MA-CODE-DEVICE-TYPE      
           MOVE WS-DEVICE-NO                TO MA-DEVICE-NO             
                                               LX-DEVICE-NO             
           MOVE WS-CODE-ATT-TYPE            TO MA-CODE-ATT-TYPE         
           MOVE WS-CODE-MAKE                TO MA-CODE-MAKE             
           MOVE WS-DATE-LAST-TESTED         TO MA-DATE-LAST-TESTED      
           MOVE WS-TEST-SCHED-CD            TO MA-TEST-SCHED-CD         
           MOVE WS-HOW-ATTACHED-CD          TO MA-HOW-ATTACHED-CD       
                                                                        
           PERFORM  2350-PROCESS-BASIC-VALIDATION  THRU 2350-EXIT.      
                                                                        
           PERFORM  8300-INSERT-MTR-ATTACHMNT      THRU 8300-EXIT.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
                                                                        
              PERFORM 7215-SEL-EQUP-ATCH           THRU 7215-EXIT       
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                                                                        
                 IF WS-DATE-LAST-MOVE-IND  = -1                         
                    MOVE '1900-01-01'       TO LX-DATE-LAST-MOVE        
                 END-IF                                                 
                                                                        
                 MOVE LX-DEVICE-NO          TO MP-DEVICE-NO             
                 MOVE LX-CODE-ATT-TYPE      TO MP-CODE-ATT-TYPE         
                 MOVE LX-COMPANY-NO         TO MP-COMPANY-NO            
                 MOVE LX-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE        
                 MOVE LX-DATE-LAST-MOVE     TO MP-DATE-MOVE             
                 MOVE WS-CURRENT-TIMESTAMP  TO MP-MOVE-NO               
                 MOVE LX-MTR-STORAGE-FAC-CD TO MP-MTR-STORAGE-FAC-CD    
                 MOVE LX-EQUIP-LOC-ID       TO MP-EQUIP-LOC-ID          
                                                                        
                 PERFORM  8200-INSERT-EQP-ATT-MOVE THRU 8200-EXIT       
                                                                        
                 MOVE 'K'                   TO WS-LOC-ID                
                 MOVE WS-LOC-ID             TO LX-EQUIP-LOC-ID          
                 MOVE WS-CURRENT-DATE       TO LX-DATE-LAST-MOVE        
                                               LX-DATE-LAST-TRAN        
A0631B                                         LX-EQUIP-ATTACH-DT       
A0631B           MOVE ZEROS                 TO WS-EQUIP-ATTACH-DT-IND   
                 PERFORM 8110-UPDATE-EQUP-ATCH     THRU 8110-EXIT       
              END-IF                                                    
                                                                        
              MOVE WS-CURRENT-DATE          TO EQ-DATE-LAST-TRAN        
                                                                        
              PERFORM 8120-UPDATE-LAST-TRAN        THRU 8120-EXIT       
                                                                        
              MOVE WS-ALLOW-CONSTANT-FL     TO GM-ALLOW-CONSTANT-FL     
              MOVE WS-CODE-ATTACHMENTS      TO GM-CODE-ATTACHMENTS      
              PERFORM 8135-UPDATE-GAS-MTR-CNT-FL   THRU 8135-EXIT       
                                                                        
              PERFORM 7270-SELCT-LOCAL-OFFICE      THRU 7270-EXIT       
                                                                        
              IF EQ-CODE-CRNT-LOC = WS-LOCATION-ATTACHED OR             
                                WS-LOCATION-CUSTOMER                    
                 MOVE EQ-CRNT-LOC-NO        TO CH-PREMISE-NO            
                 PERFORM  7200-GET-ACCOUNT-DET  THRU 7200-EXIT          
                                                                        
                 PERFORM  2800-MTR-TRANS-HIST-ADD   THRU 2800-EXIT      
              END-IF                                                    
                                                                        
A0063A        IF NORMAL-PROCESS                                         
A0063A           PERFORM 7240-CHECK-FOR-MTR-ATTTYPE  THRU 7240-EXIT     
A0063A                                                                  
A0063A           IF MTR-ATTYPE-TEST-EXISTS                              
A0063A              MOVE '00'                  TO GM-PROGRAM-ID         
A0063A              PERFORM 8130-UPDATE-GAS-MTR-PRM-ID THRU 8130-EXIT   
A0063A           ELSE                                                   
A0063A              MOVE '01'                  TO GM-PROGRAM-ID         
A0063A              PERFORM 8130-UPDATE-GAS-MTR-PRM-ID THRU 8130-EXIT   
A0063A           END-IF                                                 
A0063A         END-IF                                                   
                                                                        
      *       PERFORM  7140-CLOSE-ATCH-CURSOR          THRU 7140-EXIT   07720000
      *       ADDED ABOVE CODE PER SUE'S RECOMMENDATION.                        
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07770000
      ******************************************************************06200000
      * 2350-PROCESS-BASIC-VALIDATION.                                 *06210000
      ******************************************************************06220000
       2350-PROCESS-BASIC-VALIDATION.                                   
                                                                        
           PERFORM 7230-CHECK-FOR-MTR-ATTCHMT  THRU 7230-EXIT.          
           IF MTR-ATTCH-TEST-EXISTS                                     
              MOVE    5200                 TO RS-RETURN-CODE            
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7240-CHECK-FOR-MTR-ATTTYPE  THRU 7240-EXIT.          
                                                                        
           IF MTR-ATTYPE-TEST-EXISTS                                    
              SET AMR-ATTACHMENT-EXISTS    TO  TRUE                     
           END-IF.                                                      
                                                                        
           IF WS-CODE-ATT-TYPE = WS-ATT-TYPE-ERT                        
              MOVE WS-ATT-TYPE-ERT         TO MA-CODE-ATT-TYPE          
                                                                        
              PERFORM 7250-SELCT-METER-NO      THRU 7250-EXIT           
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE    5300              TO RS-RETURN-CODE            
                 MOVE    WS-METER-NO-TEMP  TO RS-DEVICE-MTR-NO          
                 PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              ELSE                                                      
                 MOVE WS-DEVICE-NO         TO LX-DEVICE-NO              
                 MOVE WS-CODE-ATT-TYPE     TO LX-CODE-ATT-TYPE          
                 MOVE WS-COMPANY-NO        TO LX-COMPANY-NO             
                 MOVE WS-CODE-UTIL-TYPE    TO LX-CODE-UTIL-TYPE         
                                                                        
                 PERFORM 7260-SELCT-EQUIP-LOC-ID  THRU 7260-EXIT        
A02790           IF WS-EQUIP-LOC-ID  NOT = 'A' AND 'B' AND 'C'          
                    MOVE    5400           TO RS-RETURN-CODE            
                    PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT          
                    PERFORM 9999-END-PROGRAM   THRU 9999-EXIT           
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF AMR-ATTACHMENT-EXISTS                                  
                 MOVE    5500              TO RS-RETURN-CODE            
                 PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06790000
      ******************************************************************07780000
      * 2400-DEL-ONE-ATTACHMENT.                                       *07790000
      ******************************************************************07800000
       2400-DEL-ONE-ATTACHMENT.                                         
                                                                        
           PERFORM 8220-DELETE-GAS-MTR-ATCH        THRU 8220-EXIT.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             MOVE WS-COMPANY-NO             TO EQ-COMPANY-NO            
                                            LX-COMPANY-NO               
             MOVE WS-CODE-UTIL-TYPE         TO EQ-CODE-UTIL-TYPE        
                                            LX-CODE-UTIL-TYPE           
             MOVE WS-METER-NO               TO EQ-DEVICE-NO             
                                            MP-METER-NO                 
             MOVE WS-DEVICE-NO              TO LX-DEVICE-NO             
                                                                        
             PERFORM 7270-SELCT-LOCAL-OFFICE      THRU 7270-EXIT        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               PERFORM  7215-SEL-EQUP-ATCH  THRU 7215-EXIT              
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                                                                        
                 IF WS-DATE-LAST-MOVE-IND  = -1                         
                    MOVE '1900-01-01'       TO LX-DATE-LAST-MOVE        
                 END-IF                                                 
                                                                        
                 MOVE LX-DATE-LAST-MOVE     TO WS-DATE-LAST-MOVE        
                 MOVE LX-DEVICE-NO          TO MP-DEVICE-NO             
                 MOVE LX-CODE-ATT-TYPE      TO MP-CODE-ATT-TYPE         
                 MOVE LX-COMPANY-NO         TO MP-COMPANY-NO            
                 MOVE LX-CODE-UTIL-TYPE     TO MP-CODE-UTIL-TYPE        
                 MOVE LX-DATE-LAST-MOVE     TO MP-DATE-MOVE             
                 MOVE WS-CURRENT-TIMESTAMP  TO MP-MOVE-NO               
                 MOVE LX-MTR-STORAGE-FAC-CD TO MP-MTR-STORAGE-FAC-CD    
                 MOVE LX-EQUIP-LOC-ID       TO MP-EQUIP-LOC-ID          
                                                                        
                 PERFORM  8200-INSERT-EQP-ATT-MOVE   THRU 8200-EXIT     
                                                                        
                 IF EQ-CODE-CRNT-LOC  =  'B'                            
                    MOVE   'B'              TO WS-EQUIP-LOC-ID          
                 ELSE                                                   
                    MOVE   'A'              TO WS-EQUIP-LOC-ID          
                 END-IF                                                 
                                                                        
                 MOVE WS-EQUIP-LOC-ID       TO LX-EQUIP-LOC-ID          
                 MOVE WS-CURRENT-DATE       TO LX-DATE-LAST-MOVE        
                                               LX-DATE-LAST-TRAN        
A0631B           MOVE SPACES                TO LX-EQUIP-ATTACH-DT       
A0631B           MOVE -1                    TO WS-EQUIP-ATTACH-DT-IND   
                 PERFORM 8110-UPDATE-EQUP-ATCH       THRU 8110-EXIT     
               END-IF                                                   
                                                                        
A0063A         IF NORMAL-PROCESS                                        
A0063A            IF EQ-CODE-CRNT-LOC = WS-LOCATION-ATTACHED OR         
A0063A                               WS-LOCATION-CUSTOMER               
A0063A               MOVE EQ-CRNT-LOC-NO        TO CH-PREMISE-NO        
A0063A               PERFORM  7200-GET-ACCOUNT-DET THRU 7200-EXIT       
A0063A               PERFORM  2700-MTR-TRANS-HIST-DELETE THRU 2700-EXIT 
A0063A            END-IF                                                
A0063A         END-IF                                                   
             ELSE                                                       
               MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
               PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
               PERFORM 9999-END-PROGRAM      THRU 9999-EXIT             
             END-IF                                                     
                                                                        
             MOVE WS-CURRENT-DATE          TO EQ-DATE-LAST-TRAN         
                                                                        
             PERFORM 8120-UPDATE-LAST-TRAN   THRU 8120-EXIT             
                                                                        
             IF WS-CHK-CONST-FL = 'Y'                                   
               PERFORM 7100-GET-ALW-CNT-FLAG THRU 7100-EXIT             
               MOVE M5-ALLOW-CONSTANT-FL  TO GM-ALLOW-CONSTANT-FL       
             ELSE                                                       
               MOVE WS-ALLOW-CONSTANT-FL  TO GM-ALLOW-CONSTANT-FL       
             END-IF                                                     
                                                                        
             MOVE WS-CODE-ATTACHMENTS     TO GM-CODE-ATTACHMENTS        
                                                                        
             PERFORM 8135-UPDATE-GAS-MTR-CNT-FL  THRU 8135-EXIT         
      *      ADDED THE FOLLOWING CODE PER SUE'S RECOMMENDATION.                 
A0063A       IF NORMAL-PROCESS                                          
A0063A          PERFORM 7240-CHECK-FOR-MTR-ATTTYPE  THRU 7240-EXIT      
A0063A                                                                  
A0063A          IF MTR-ATTYPE-TEST-EXISTS                               
A0063A             MOVE '00'                  TO GM-PROGRAM-ID          
A0063A             PERFORM 8130-UPDATE-GAS-MTR-PRM-ID THRU 8130-EXIT    
A0063A          ELSE                                                    
A0063A             MOVE '01'                  TO GM-PROGRAM-ID          
A0063A             PERFORM 8130-UPDATE-GAS-MTR-PRM-ID THRU 8130-EXIT    
A0063A          END-IF                                                  
A0063A       END-IF                                                     
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08490000
      ******************************************************************08500000
      * 2500-UPD-ONE-ATTACHMENT.                                       *08510000
      ******************************************************************08520000
       2500-UPD-ONE-ATTACHMENT.                                         
                                                                        
           IF PARM-DATE-LAST-TESTED = SPACES                            
              MOVE -1                  TO WS-DATE-LAST-TESTED-IND       
           ELSE                                                         
              MOVE WS-DATE-LAST-TESTED TO MA-DATE-LAST-TESTED           
           END-IF                                                       
                                                                        
           MOVE WS-CODE-MAKE           TO MA-CODE-MAKE.                 
           MOVE WS-TEST-SCHED-CD       TO MA-TEST-SCHED-CD.             
           MOVE WS-HOW-ATTACHED-CD     TO MA-HOW-ATTACHED-CD.           
           MOVE WS-COMPANY-NO          TO MA-COMPANY-NO                 
                                          EQ-COMPANY-NO                 
                                          GM-COMPANY-NO.                
           MOVE WS-CODE-UTIL-TYPE      TO MA-CODE-UTIL-TYPE             
                                          EQ-CODE-UTIL-TYPE             
                                          GM-CODE-UTIL-TYPE.            
           MOVE WS-METER-NO            TO MA-METER-NO                   
                                          GM-METER-NO                   
                                          EQ-DEVICE-NO.                 
           MOVE WS-DEVICE-NO           TO MA-DEVICE-NO.                 
           MOVE WS-CODE-ATT-TYPE       TO MA-CODE-ATT-TYPE.             
                                                                        
           PERFORM 8140-UPDATE-MTR-ATCH       THRU 8140-EXIT            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF                                                       
                                                                        
           MOVE WS-CURRENT-DATE        TO EQ-DATE-LAST-TRAN             
                                                                        
           PERFORM 8120-UPDATE-LAST-TRAN      THRU 8120-EXIT            
                                                                        
           MOVE WS-ALLOW-CONSTANT-FL   TO GM-ALLOW-CONSTANT-FL          
           MOVE WS-CODE-ATTACHMENTS    TO GM-CODE-ATTACHMENTS           
                                                                        
           PERFORM 8135-UPDATE-GAS-MTR-CNT-FL THRU 8135-EXIT.           
      *    ADDED THE FOLLOWING CODE PER SUE'S RECOMMENDATION.                   
           PERFORM 7240-CHECK-FOR-MTR-ATTTYPE  THRU 7240-EXIT.          
                                                                        
           IF MTR-ATTYPE-TEST-EXISTS                                    
               MOVE '00'                  TO GM-PROGRAM-ID              
               PERFORM 8130-UPDATE-GAS-MTR-PRM-ID    THRU 8130-EXIT     
           ELSE                                                         
               MOVE '01'                  TO GM-PROGRAM-ID              
               PERFORM 8130-UPDATE-GAS-MTR-PRM-ID    THRU 8130-EXIT     
           END-IF.                                                      
                                                                        
      *    ADDED ABOVE CODE PER SUE'S RECOMMENDATION.                           
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08900000
      ******************************************************************08910000
      * 2600-INSRT-ONE-ATTACHMNT.                                      *08920000
      ******************************************************************08930000
       2600-INSRT-ONE-ATTACHMENT.                                       
                                                                        
A0063A     SET ADD-AND-DELETE          TO TRUE.                         
           IF PARM-DATE-LAST-TESTED  = SPACES                           
              MOVE -1                  TO WS-DATE-LAST-TESTED-IND       
           ELSE                                                         
              MOVE WS-DATE-LAST-TESTED TO MA-DATE-LAST-TESTED           
           END-IF                                                       
                                                                        
           MOVE WS-COMPANY-NO          TO MA-COMPANY-NO                 
                                          EQ-COMPANY-NO                 
                                          GM-COMPANY-NO.                
           MOVE WS-CODE-UTIL-TYPE      TO MA-CODE-UTIL-TYPE             
                                          EQ-CODE-UTIL-TYPE             
                                          GM-CODE-UTIL-TYPE.            
           MOVE WS-METER-NO            TO MA-METER-NO                   
                                          GM-METER-NO                   
                                          EQ-DEVICE-NO.                 
           MOVE WS-OLD-CODE-ATT-TYPE   TO MA-CODE-ATT-TYPE.             
           MOVE WS-OLD-DEVICE-NO       TO MA-DEVICE-NO                  
A0063A                                    WS-DEVICE-NO.                 
A0063A     PERFORM 2400-DEL-ONE-ATTACHMENT   THRU 2400-EXIT.            
                                                                        
A0063A     MOVE PARM-DEVICE-NO               TO WS-DEVICE-NO.           
A0063A                                                                  
A0063A     MOVE WS-DEVICE-NO                 TO WS-DEVICE-NO-NEW.       
A0063A     PERFORM 7040-FORMAT-DEVICE-NUMBER THRU 7040-EXIT.            
A0063A     MOVE WS-DEVICE-NO-NEW             TO WS-DEVICE-NO.           
                                                                        
A0063A     PERFORM 2300-ADD-ATTACHMENT       THRU 2300-EXIT.            
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09350000
      ***************************************************************** 09360000
      * 2700-MTR-TRANS-HIST-DELETE.                                   * 09370000
      ***************************************************************** 09380000
       2700-MTR-TRANS-HIST-DELETE.                                      
                                                                        
           MOVE '2700'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 7210-GET-RESP-AREA        THRU 7210-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                        
              MOVE SPACES                    TO  PF-RESP-AREA-ID        
           END-IF                                                       
                                                                        
                                                                        
           STRING  MA-CODE-ATT-TYPE,                                    
                   MA-DEVICE-NO                                         
           DELIMITED BY WS-SPACE  INTO WS-PRV-COLUMN-VALUE-TEXT.        
           MOVE 15                           TO                         
                                           WS-PRV-COLUMN-VALUE-LEN.     
           MOVE  9                           TO                         
                                           WS-CHG-COLUMN-VALUE-LEN.     
           MOVE  '*DELETED*'                 TO                         
                                           WS-CHG-COLUMN-VALUE-TEXT.    
           MOVE 'DELETED GAS METER ATTACHMENT FOR THE EQUIPMENT'        
                                             TO  WS-TRANS-COMMENT.      
           STRING  WS-TRANS-COMMENT, WS-COLON,                          
                   WS-METER-NO                                          
           DELIMITED BY SIZE INTO WS-COMMENT.                           
                                                                        
           PERFORM 5000-SET-MNT-TRANS-VARS      THRU 5000-EXIT.         
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09681003
      ***************************************************************** 09690000
      * 2800-MTR-TRANS-HIST-ADD.                                      * 09700000
      ***************************************************************** 09710000
       2800-MTR-TRANS-HIST-ADD.                                         
                                                                        
           MOVE '2800'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7210-GET-RESP-AREA           THRU 7210-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                        
              MOVE SPACES              TO  PF-RESP-AREA-ID              
           END-IF                                                       
                                                                        
                                                                        
A0063A     IF NORMAL-PROCESS                                            
A0063A        MOVE '*NEW*'                TO WS-PRV-COLUMN-VALUE-TEXT   
A0063A        MOVE  5                     TO WS-PRV-COLUMN-VALUE-LEN    
A0063A     ELSE                                                         
A0063A        MOVE  15                    TO WS-PRV-COLUMN-VALUE-LEN    
A0063A        STRING  WS-OLD-CODE-ATT-TYPE,                             
A0063A                WS-OLD-DEVICE-NO DELIMITED BY SPACE               
A0063A                INTO WS-PRV-COLUMN-VALUE-TEXT                     
A0063A     END-IF.                                                      
A00631     MOVE 15                     TO WS-CHG-COLUMN-VALUE-LEN.      
A00631     STRING  MA-CODE-ATT-TYPE,                                    
A00631             MA-DEVICE-NO                                         
A00631     DELIMITED BY WS-SPACE  INTO WS-CHG-COLUMN-VALUE-TEXT.        
A0063A     IF NORMAL-PROCESS                                            
A0063A        MOVE 'ADDED NEW GAS METER ATTACHMENT FOR THE EQUIPMENT'   
A0063A                                 TO WS-TRANS-COMMENT              
A0063A     ELSE                                                         
A0063A        MOVE 'REPLACED ATTACHMENT FOR THE EQUIPMENT'              
A0063A                                 TO WS-TRANS-COMMENT              
A0063A     END-IF.                                                      
           STRING  WS-TRANS-COMMENT, WS-COLON, WS-METER-NO              
           DELIMITED BY SIZE INTO WS-COMMENT.                           
                                                                        
           PERFORM 5000-SET-MNT-TRANS-VARS      THRU 5000-EXIT.         
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09960000
      ***************************************************************** 09970000
      *5000-SET-MNT-TRANS-VARS                                        * 09980000
      *THIS MODULE SETS TRANS HISTORY AND TRANS DETAIL RECORDS DURING * 09990000
      *  DELETION OF METER ATTACHMENT                                 * 10000000
      ***************************************************************** 10010000
       5000-SET-MNT-TRANS-VARS.                                         
                                                                        
           MOVE '5000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           IF WS-TRANS-HIST-SEQ-NO > SPACES                             
              MOVE WS-TRANS-HIST-SEQ-NO     TO MH-TRANS-HIST-SEQ-NO     
           ELSE                                                         
              MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO     
                                               WS-TRANS-HIST-SEQ-NO     
              MOVE MH-TRANS-HIST-SEQ-NO     TO RS-TRANS-HIST-SEQ-NO     
              MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS            
              MOVE WS-CODE-TRAN-TYPE        TO MH-CODE-TRAN-TYPE        
              MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID          
              MOVE CH-ACCOUNT-NO            TO MH-ACCOUNT-NO            
              MOVE AT-CUSTOMER-NO           TO MH-CUSTOMER-NO           
              MOVE EQ-CRNT-LOC-NO           TO MH-PREMISE-NO            
              MOVE WS-USER-ID               TO MH-USER-ID               
              MOVE WS-APPL-PROGRAM-ID       TO MH-APPL-PROGRAM-ID       
              MOVE WS-COMMENT               TO MH-TRAN-COMMENT-TEXT     
              MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                       
                                            TO MH-TRAN-COMMENT-LEN      
           END-IF                                                       
                                                                        
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
           IF WS-TRAN-APPL-NO <= 1                                      
              MOVE +1                       TO WS-TRAN-APPL-NO          
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
                                                                        
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
           ADD +1                           TO WS-TRAN-APPL-NO.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10370000
      ******************************************************************10500000
      * 6530-LOAD-MNT-TRANS-HIST.                                      *10510000
      ******************************************************************10520000
                                                                        
           EXEC SQL                                                     10540000
              INCLUDE CPD00067                                          10550000
           END-EXEC.                                                    10560000
                                                                        
      ******************************************************************10580000
      * 7000-SELECT-CURR-DATE-AND-TIME                                 *10590000
      ******************************************************************10600000
       7000-SELECT-CURR-DATE-AND-TIME.                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10630000
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                  10640000
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             10640000
MFA-TR*    END-EXEC.                                                    10650000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7000'             TO ACTIVE-PARAGRAPH               
              MOVE 'SET'              TO ABEND-FUNCTION                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10810000
A0063A*================================================================*        
A0063A 7040-FORMAT-DEVICE-NUMBER.                                       
A0063A*================================================================*        
A0063A*                                                                         
A0063A     EXEC SQL                                                     
A0063A          SELECT
              CIS.SUBSTR3('000000000000',1 ,                           
A0063A            (12 - DATALENGTH(RTRIM(LTRIM(:WS-DEVICE-NO-NEW))))) + 
           RTRIM(LTRIM(:WS-DEVICE-NO-NEW))
            INTO
              :WS-DEVICE-NO-NEW              
A0063A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DEVICE-NO-NEW =                                         
MFA-TR*             SUBSTR('000000000000',1 ,                                   
MFA-TR*           (12 - LENGTH(RTRIM(LTRIM(:WS-DEVICE-NO-NEW)))))               
MFA-TR*                 || RTRIM(LTRIM(:WS-DEVICE-NO-NEW))                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A0063A*                                                                         
A0063A     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A0063A*                                                                         
A0063A     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A0063A         CONTINUE                                                 
A0063A     ELSE                                                         
A0063A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A0063A        MOVE '7040'                TO ACTIVE-PARAGRAPH            
A0063A        MOVE 'SET'                 TO ABEND-FUNCTION              
A0063A        MOVE 'WS-DEVICE-NO-NEW'    TO TABLE-ELEMENT-1             
A0063A        MOVE WS-DEVICE-NO-NEW      TO HOSTVAR-ELEMENT-1           
A0063A        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A0063A        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A0063A     END-IF.                                                      
A0063A*                                                                         
A0063A 7040-EXIT.                                                       
A0063A     EXIT.                                                        
A0063A*                                                                         
      *                                                                 10810000
      ******************************************************************11060000
      * 7100-GET-ALW-CNT-FLAG.                                         *11070000
      ******************************************************************11080000
       7100-GET-ALW-CNT-FLAG.                                           
                                                                        
           EXEC SQL                                                     
              SELECT M5.ALLOW_CONSTANT_FL                               
                INTO :M5-ALLOW-CONSTANT-FL                              
                FROM CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
                    ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
               WHERE M5.METER_SIZE_ID  = GM.METER_SIZE_ID               
                 AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE             
                 AND GM.METER_NO       = :GM-METER-NO                   
                 AND GM.COMPANY_NO     = :GM-COMPANY-NO                 
                                                                 
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11110000
MFA-TR*       SELECT M5.ALLOW_CONSTANT_FL                               11120000
MFA-TR*         INTO :M5-ALLOW-CONSTANT-FL                              11130000
MFA-TR*         FROM CSS_GAS_METER_SIZE M5                              11140000
MFA-TR*             ,CSS_GAS_METER GM                                   11150000
MFA-TR*        WHERE M5.METER_SIZE_ID  = GM.METER_SIZE_ID               11160000
MFA-TR*          AND GM.CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE             11170000
MFA-TR*          AND GM.METER_NO       = :GM-METER-NO                   11180000
MFA-TR*          AND GM.COMPANY_NO     = :GM-COMPANY-NO                 11190000
MFA-TR*        WITH UR                                                  11200000
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    11210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_GAS_METER'       TO TABLE-1                     
              MOVE 'CSS_GAS_METER_SIZE'  TO TABLE-2                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'METER_NO'            TO TABLE-ELEMENT-3             
              MOVE GM-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1           
              MOVE GM-METER-NO           TO HOSTVAR-ELEMENT-2           
              MOVE GM-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11450000
      ******************************************************************11460000
      * 7110-GET-ATCH-COUNT.                                           *11470000
      ******************************************************************11480000
       7110-GET-ATCH-COUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-METER-ATTCH-FL                                 
                FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE METER_NO        = :MA-METER-NO                     
                 AND COMPANY_NO      = :MA-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE               
                 AND HOW_ATTACHED_CD = 'I'                              
                                                                 
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11510000
MFA-TR*       SELECT 'Y'                                                11520000
MFA-TR*         INTO :WS-METER-ATTCH-FL                                 11530000
MFA-TR*         FROM CSS_METER_ATTCHMTS                                 11540000
MFA-TR*        WHERE METER_NO        = :MA-METER-NO                     11550000
MFA-TR*          AND COMPANY_NO      = :MA-COMPANY-NO                   11560000
MFA-TR*          AND CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE               11570000
MFA-TR*          AND HOW_ATTACHED_CD = 'I'                              11580000
MFA-TR*         WITH UR                                                 11590000
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                    11600000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7110'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11830000
      ******************************************************************11840000
      *7120-OPEN-ATCH-CURSOR.                                          *11850000
      ******************************************************************11860000
       7120-OPEN-ATCH-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN ATCH_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12150000
      ******************************************************************12160000
      * 7130-FETCH-ATCH-CURSOR.                                        *12170000
      ******************************************************************12180000
       7130-FETCH-ATCH-CURSOR.                                          
      *                                                                 12200000
           EXEC SQL                                                     
              FETCH ATCH_CURSOR                                         
               INTO :MA-CODE-UTIL-TYPE                                  
                   ,:MA-METER-NO                                        
                   ,:MA-CODE-DEVICE-TYPE                                
                   ,:MA-DEVICE-NO                                       
                   ,:MA-CODE-ATT-TYPE                                   
                   ,:MA-CT-PT-RATIO                                     
                   ,:MA-COMPANY-NO                                      
                   ,:MA-CODE-MAKE                                       
                   ,:MA-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND       
                   ,:MA-TEST-SCHED-CD                                   
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:MA-HOW-ATTACHED-CD                                 
                   ,:EQ-CRNT-LOC-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7130'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12620000
      ******************************************************************12630000
      *7140-CLOSE-ATCH-CURSOR                                          *12640000
      ******************************************************************12650000
       7140-CLOSE-ATCH-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE ATCH_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7140'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12940000
      ******************************************************************12950000
      * 7200-GET-ACCOUNT-DET.                                          *12960000
      ******************************************************************12970000
       7200-GET-ACCOUNT-DET.                                            
                                                                        
           INITIALIZE CH-ACCOUNT-NO                                     
                      AT-CUSTOMER-NO                                    
                      AT-LOCAL-OFFICE.                                  
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CH.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.LOCAL_OFFICE                                    
                INTO :CH-ACCOUNT-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-LOCAL-OFFICE                                   
                FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                
                    ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE CH.ACCOUNT_NO = AT.ACCOUNT_NO                      
                 AND CH.PREMISE_NO = :CH-PREMISE-NO                     
               ORDER BY CH.DATE_UTIL_SVC_STRT DESC                      
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13000000
MFA-TR*       SELECT CH.ACCOUNT_NO                                      13010000
MFA-TR*             ,AT.CUSTOMER_NO                                     13020000
MFA-TR*             ,AT.LOCAL_OFFICE                                    13030000
MFA-TR*         INTO :CH-ACCOUNT-NO                                     13040000
MFA-TR*             ,:AT-CUSTOMER-NO                                    13050000
MFA-TR*             ,:AT-LOCAL-OFFICE                                   13060000
MFA-TR*         FROM CSS_CUST_PREM_HIST CH                              13070000
MFA-TR*             ,CSS_ACCOUNT AT                                     13080000
MFA-TR*        WHERE CH.ACCOUNT_NO = AT.ACCOUNT_NO                      13090000
MFA-TR*          AND CH.PREMISE_NO = :CH-PREMISE-NO                     13100000
MFA-TR*        ORDER BY CH.DATE_UTIL_SVC_STRT DESC                      13110000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             13120000
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                    13130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-1                    
              MOVE 'CSS_ACCOUNT'          TO TABLE-2                    
              MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1            
              MOVE CH-PREMISE-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13330000
      ******************************************************************13340000
      * 7210-GET-RESP-AREA                                             *13350000
      ******************************************************************13360000
       7210-GET-RESP-AREA.                                              
                                                                        
           MOVE WS-USER-ID             TO PF-USER-ID.                   
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PF-USER-ID                              
                                                                 
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13410000
MFA-TR*       SELECT RESP_AREA_ID                                       13420000
MFA-TR*         INTO :PF-RESP-AREA-ID                                   13430000
MFA-TR*         FROM CSS_USER_PROFILE                                   13440000
MFA-TR*        WHERE USER_ID = :PF-USER-ID                              13450000
MFA-TR*         WITH UR                                                 13460000
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                    13470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_USER_PROFILE'  TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE PF-USER-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13660000
      ******************************************************************13670000
      * 7215-SEL-EQUP-ATCH.                                            *13680000
      ******************************************************************13690000
       7215-SEL-EQUP-ATCH.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DATE_LAST_MOVE,
              DEVICE_NO,
              CODE_ATT_TYPE,
              COMPANY_NO,
              CODE_UTIL_TYPE,
              MTR_STORAGE_FAC_CD,
              EQUIP_LOC_ID                                       
                INTO :LX-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND           
                    ,:LX-DEVICE-NO                                      
                    ,:LX-CODE-ATT-TYPE                                  
                    ,:LX-COMPANY-NO                                     
                    ,:LX-CODE-UTIL-TYPE                                 
                    ,:LX-MTR-STORAGE-FAC-CD                             
                    ,:LX-EQUIP-LOC-ID                                   
                FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE DEVICE_NO      =:LX-DEVICE-NO                      
                 AND CODE_UTIL_TYPE =:LX-CODE-UTIL-TYPE                 
                 AND COMPANY_NO     =:LX-COMPANY-NO                     
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13720000
MFA-TR*       SELECT DATE_LAST_MOVE                                     13730000
MFA-TR*             ,DEVICE_NO                                          13740000
MFA-TR*             ,CODE_ATT_TYPE                                      13750000
MFA-TR*             ,COMPANY_NO                                         13760000
MFA-TR*             ,CODE_UTIL_TYPE                                     13770000
MFA-TR*             ,MTR_STORAGE_FAC_CD                                 13780000
MFA-TR*             ,EQUIP_LOC_ID                                       13790000
MFA-TR*         INTO :LX-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-IND           13800000
MFA-TR*             ,:LX-DEVICE-NO                                      13810000
MFA-TR*             ,:LX-CODE-ATT-TYPE                                  13820000
MFA-TR*             ,:LX-COMPANY-NO                                     13830000
MFA-TR*             ,:LX-CODE-UTIL-TYPE                                 13840000
MFA-TR*             ,:LX-MTR-STORAGE-FAC-CD                             13850000
MFA-TR*             ,:LX-EQUIP-LOC-ID                                   13860000
MFA-TR*         FROM CSS_EQUIP_ATTCHMTS                                 13870000
MFA-TR*        WHERE DEVICE_NO      =:LX-DEVICE-NO                      13880000
MFA-TR*          AND CODE_UTIL_TYPE =:LX-CODE-UTIL-TYPE                 13890000
MFA-TR*          AND COMPANY_NO     =:LX-COMPANY-NO                     13900000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             13910000
MFA-TR*        QUERYNO 7215                                                     
MFA-TR*    END-EXEC.                                                    13920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7215'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                     
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-1           
              MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7215-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14180000
      ******************************************************************14190000
      * 7230-CHECK-FOR-MTR-ATTCHMT.                                    *14200000
      ******************************************************************14210000
       7230-CHECK-FOR-MTR-ATTCHMT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MTR-ATTCH-TEST-EXISTS                          
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                    ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
               WHERE MA.METER_NO       = EQ.DEVICE_NO                   
                 AND MA.COMPANY_NO     = EQ.COMPANY_NO                  
                 AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              
                 AND MA.METER_NO       = :MA-METER-NO                   
                 AND MA.COMPANY_NO     = :MA-COMPANY-NO                 
                 AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             
                 AND MA.DEVICE_NO      = :MA-DEVICE-NO                  
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14240000
MFA-TR*       SELECT 'Y'                                                14250000
MFA-TR*         INTO :WS-MTR-ATTCH-TEST-EXISTS                          14260000
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                              14270000
MFA-TR*             ,CSS_EQUIPMENT EQ                                   14280000
MFA-TR*        WHERE MA.METER_NO       = EQ.DEVICE_NO                   14290000
MFA-TR*          AND MA.COMPANY_NO     = EQ.COMPANY_NO                  14300000
MFA-TR*          AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              14310000
MFA-TR*          AND MA.METER_NO       = :MA-METER-NO                   14320000
MFA-TR*          AND MA.COMPANY_NO     = :MA-COMPANY-NO                 14330000
MFA-TR*          AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             14340000
MFA-TR*          AND MA.DEVICE_NO      = :MA-DEVICE-NO                  14350000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             14360000
MFA-TR*        QUERYNO 7230                                                     
MFA-TR*    END-EXEC.                                                    14370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7230'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14630000
      ******************************************************************14640000
      * 7240-CHECK-FOR-MTR-ATTTYPE                                     *14650000
      ******************************************************************14660000
       7240-CHECK-FOR-MTR-ATTTYPE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-MTR-ATTYPE-TEST-EXISTS                         
                FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                
                    ,CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                  
               WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE              
                 AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE               
                 AND N5.DEVICE_TYPE_CD = 'A'                            
                 AND MA.METER_NO       = :MA-METER-NO                   
                 AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             
                 AND MA.COMPANY_NO     = :MA-COMPANY-NO                 
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14690000
MFA-TR*       SELECT 'Y'                                                14700000
MFA-TR*         INTO :WS-MTR-ATTYPE-TEST-EXISTS                         14710000
MFA-TR*         FROM CSS_METER_ATTCHMTS MA                              14720000
MFA-TR*             ,CSS_MTR_ATT_TYPE N5                                14730000
MFA-TR*        WHERE MA.CODE_UTIL_TYPE = N5.CODE_UTIL_TYPE              14740000
MFA-TR*          AND MA.CODE_ATT_TYPE  = N5.CODE_ATT_TYPE               14750000
MFA-TR*          AND N5.DEVICE_TYPE_CD = 'A'                            14760000
MFA-TR*          AND MA.METER_NO       = :MA-METER-NO                   14770000
MFA-TR*          AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE             14780000
MFA-TR*          AND MA.COMPANY_NO     = :MA-COMPANY-NO                 14790000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             14810000
MFA-TR*        QUERYNO 7240                                                     
MFA-TR*    END-EXEC.                                                    14820000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7240'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_MTR_ATT_TYPE'   TO TABLE-2                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15080000
      ******************************************************************15090000
      * 7250-SELCT-METER-NO.                                           *15100000
      ******************************************************************15110000
       7250-SELCT-METER-NO.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO                                           
                INTO :WS-METER-NO-TEMP                                  
                FROM CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                   
               WHERE DEVICE_NO      = :MA-DEVICE-NO                     
                 AND COMPANY_NO     = :MA-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                
                 AND CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE                 
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15140000
MFA-TR*       SELECT METER_NO                                           15150000
MFA-TR*         INTO :WS-METER-NO-TEMP                                  15160000
MFA-TR*         FROM CSS_METER_ATTCHMTS                                 15170000
MFA-TR*        WHERE DEVICE_NO      = :MA-DEVICE-NO                     15180000
MFA-TR*          AND COMPANY_NO     = :MA-COMPANY-NO                    15190000
MFA-TR*          AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                15200000
MFA-TR*          AND CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE                 15210000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             15220000
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                    15230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7250'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE MA-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15480000
      ******************************************************************15490000
      * 7260-SELCT-EQUIP-LOC-ID                                        *15500000
      ******************************************************************15510000
       7260-SELCT-EQUIP-LOC-ID.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) EQUIP_LOC_ID                                       
                INTO :WS-EQUIP-LOC-ID                                   
                FROM CSS_EQUIP_ATTCHMTS WITH(READUNCOMMITTED)                   
A02790         WHERE EQUIP_LOC_ID    IN ('A','B','C')                   
                 AND DEVICE_NO       = :LX-DEVICE-NO                    
                 AND CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                
                 AND COMPANY_NO      = :LX-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE               
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15540000
MFA-TR*       SELECT EQUIP_LOC_ID                                       15550000
MFA-TR*         INTO :WS-EQUIP-LOC-ID                                   15560000
MFA-TR*         FROM CSS_EQUIP_ATTCHMTS                                 15570000
MFA-TR*        WHERE EQUIP_LOC_ID    IN ('A','B','C')                   15580000
MFA-TR*          AND DEVICE_NO       = :LX-DEVICE-NO                    15590000
MFA-TR*          AND CODE_ATT_TYPE   = :LX-CODE-ATT-TYPE                15600000
MFA-TR*          AND COMPANY_NO      = :LX-COMPANY-NO                   15610000
MFA-TR*          AND CODE_UTIL_TYPE  = :LX-CODE-UTIL-TYPE               15620000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             15630000
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                    15640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7260'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_ATT_TYPE'      TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              MOVE LX-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15890000
      ******************************************************************15900000
      * 7270-SELCT-LOCAL-OFFICE                                        *15910000
      ******************************************************************15920000
       7270-SELCT-LOCAL-OFFICE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) LOCAL_OFFICE,
              CODE_CRNT_LOC,
              CRNT_LOC_NO                                        
                INTO :EQ-LOCAL-OFFICE                                   
                    ,:EQ-CODE-CRNT-LOC                                  
                    ,:EQ-CRNT-LOC-NO                                    
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                                             
A0631B                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15950000
MFA-TR*       SELECT                                                    15960000
MFA-TR*              LOCAL_OFFICE                                       15970000
MFA-TR*             ,CODE_CRNT_LOC                                      15980000
MFA-TR*             ,CRNT_LOC_NO                                        15990000
MFA-TR*         INTO :EQ-LOCAL-OFFICE                                   16000000
MFA-TR*             ,:EQ-CODE-CRNT-LOC                                  16010000
MFA-TR*             ,:EQ-CRNT-LOC-NO                                    16020000
MFA-TR*         FROM CSS_EQUIPMENT                                      16030000
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                    16040000
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                16050000
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                     16060000
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             16070000
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                    16080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7270'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3              
              MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16310000
      ******************************************************************16320000
      * 8110-UPDATE-EQUP-ATCH.                                         *16330000
      ******************************************************************16340000
       8110-UPDATE-EQUP-ATCH.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIP_ATTCHMTS                                 
                 SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID              
                    ,DATE_LAST_MOVE     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE) )            
                    ,DATE_LAST_TRAN     = IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN) )            
                    ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD        
A0631B              ,EQUIP_ATTACH_DT    = IIF(TRY_CONVERT(DATE, 
                                                   :LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) <> 0) OR (LEN(:LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) <> 10), CIS.CHAR2DATE(:LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ), CONVERT(DATE, :LX-EQUIP-ATTACH-DT 
                                                :WS-EQUIP-ATTACH-DT-IND
              ) )       
               WHERE DEVICE_NO          = :LX-DEVICE-NO                 
                 AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE             
                 AND COMPANY_NO         = :LX-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16370000
MFA-TR*       UPDATE CSS_EQUIP_ATTCHMTS                                 16380000
MFA-TR*          SET EQUIP_LOC_ID       = :LX-EQUIP-LOC-ID              16390000
MFA-TR*             ,DATE_LAST_MOVE     = :LX-DATE-LAST-MOVE            16400000
MFA-TR*             ,DATE_LAST_TRAN     = :LX-DATE-LAST-TRAN            16410000
MFA-TR*             ,MTR_STORAGE_FAC_CD = :LX-MTR-STORAGE-FAC-CD        16420000
MFA-TR*             ,EQUIP_ATTACH_DT    = :LX-EQUIP-ATTACH-DT           16420000
MFA-TR*                                   :WS-EQUIP-ATTACH-DT-IND       16420000
MFA-TR*        WHERE DEVICE_NO          = :LX-DEVICE-NO                 16430000
MFA-TR*          AND CODE_ATT_TYPE      = :LX-CODE-ATT-TYPE             16440000
MFA-TR*          AND COMPANY_NO         = :LX-COMPANY-NO                16450000
MFA-TR*          AND CODE_UTIL_TYPE     = :LX-CODE-UTIL-TYPE            16460000
MFA-TR*    END-EXEC.                                                    16470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8110'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                     
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1             
              MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-4             
              MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-1           
              MOVE LX-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2           
              MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16720000
      ******************************************************************16730000
      * 8120-UPDATE-LAST-TRAN.                                         *16740000
      ******************************************************************16750000
       8120-UPDATE-LAST-TRAN.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET DATE_LAST_TRAN = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )                
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16780000
MFA-TR*       UPDATE CSS_EQUIPMENT                                      16790000
MFA-TR*          SET DATE_LAST_TRAN = :EQ-DATE-LAST-TRAN                16800000
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                    16810000
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                16820000
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                     16830000
MFA-TR*    END-EXEC.                                                    16840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8120'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_EQUIPMENT'     TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'DEVICE_NO'         TO TABLE-ELEMENT-3               
              MOVE EQ-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE EQ-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE EQ-DEVICE-NO        TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17070000
      ******************************************************************17080000
      * 8130-UPDATE-GAS-MTR-PRM-ID                                     *17090000
      ******************************************************************17100000
       8130-UPDATE-GAS-MTR-PRM-ID.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_GAS_METER                                      
                 SET PROGRAM_ID      = :GM-PROGRAM-ID                   
               WHERE COMPANY_NO      = :GM-COMPANY-NO                   
                 AND CODE_UTIL_TYPE  = :GM-CODE-UTIL-TYPE               
                 AND METER_NO        = :GM-METER-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8130'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_GAS_METER'     TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'METER_NO'          TO TABLE-ELEMENT-3               
              MOVE GM-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE GM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE GM-METER-NO         TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17420000
      ******************************************************************17430000
      * 8135-UPDATE-GAS-MTR-CNT-FL                                     *17440000
      ******************************************************************17450000
       8135-UPDATE-GAS-MTR-CNT-FL.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_GAS_METER                                      
                 SET ALLOW_CONSTANT_FL  = :GM-ALLOW-CONSTANT-FL         
                    ,CODE_ATTACHMENTS   = :GM-CODE-ATTACHMENTS          
               WHERE COMPANY_NO         = :GM-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :GM-CODE-UTIL-TYPE            
                 AND METER_NO           = :GM-METER-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '8135'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_GAS_METER'     TO TABLE-1                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE 'METER_NO'          TO TABLE-ELEMENT-3               
              MOVE GM-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE GM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              MOVE GM-METER-NO         TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8135-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17771001
      ******************************************************************17780000
      * 8140-UPDATE-MTR-ATCH                                           *17790000
      ******************************************************************17800000
       8140-UPDATE-MTR-ATCH.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_METER_ATTCHMTS                                 
                 SET CODE_MAKE           = :MA-CODE-MAKE                
                    ,DATE_LAST_TESTED    = IIF(TRY_CONVERT(DATE, 
                                                  :MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) )     
                    ,TEST_SCHED_CD       = :MA-TEST-SCHED-CD            
                    ,HOW_ATTACHED_CD     = :MA-HOW-ATTACHED-CD          
               WHERE COMPANY_NO          = :MA-COMPANY-NO               
                 AND CODE_UTIL_TYPE      = :MA-CODE-UTIL-TYPE           
                 AND METER_NO            = :MA-METER-NO                 
                 AND DEVICE_NO           = :MA-DEVICE-NO                
                 AND CODE_ATT_TYPE       = :MA-CODE-ATT-TYPE            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17830000
MFA-TR*       UPDATE CSS_METER_ATTCHMTS                                 17840001
MFA-TR*          SET CODE_MAKE           = :MA-CODE-MAKE                17850001
MFA-TR*             ,DATE_LAST_TESTED    = :MA-DATE-LAST-TESTED         17860001
MFA-TR*                                    :WS-DATE-LAST-TESTED-IND     17870001
MFA-TR*             ,TEST_SCHED_CD       = :MA-TEST-SCHED-CD            17880001
MFA-TR*             ,HOW_ATTACHED_CD     = :MA-HOW-ATTACHED-CD          17890001
MFA-TR*        WHERE COMPANY_NO          = :MA-COMPANY-NO               17900001
MFA-TR*          AND CODE_UTIL_TYPE      = :MA-CODE-UTIL-TYPE           17910001
MFA-TR*          AND METER_NO            = :MA-METER-NO                 17920001
MFA-TR*          AND DEVICE_NO           = :MA-DEVICE-NO                17930001
MFA-TR*          AND CODE_ATT_TYPE       = :MA-CODE-ATT-TYPE            17940001
MFA-TR*    END-EXEC.                                                    17950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '8140'                 TO ACTIVE-PARAGRAPH           
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE 'CSS_METER_ATTCHMTS'   TO TABLE-1                    
              MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2            
              MOVE 'METER_NO'             TO TABLE-ELEMENT-3            
              MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-4            
              MOVE MA-COMPANY-NO          TO HOSTVAR-ELEMENT-1          
              MOVE MA-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2          
              MOVE MA-METER-NO            TO HOSTVAR-ELEMENT-3          
              MOVE MA-DEVICE-NO           TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18171000
      ******************************************************************18180000
      * 8200-INSERT-EQP-ATT-MOVE.                                      *18190000
      ******************************************************************18200000
       8200-INSERT-EQP-ATT-MOVE.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATT_MOVE                            
              (                                                         
                  DEVICE_NO                                             
                 ,CODE_ATT_TYPE                                         
                 ,COMPANY_NO                                            
                 ,CODE_UTIL_TYPE                                        
                 ,DATE_MOVE                                             
                 ,MOVE_NO                                               
                 ,MTR_STORAGE_FAC_CD                                    
                 ,EQUIP_LOC_ID                                          
                 ,METER_NO                                              
              )                                                         
              VALUES                                                    
              (                                                         
                  :MP-DEVICE-NO                                         
                 ,:MP-CODE-ATT-TYPE                                     
                 ,:MP-COMPANY-NO                                        
                 ,:MP-CODE-UTIL-TYPE                                    
                 ,IIF(TRY_CONVERT(DATE, :MP-DATE-MOVE
              ) IS NULL OR (PATINDEX('%.%', :MP-DATE-MOVE
              ) <> 0) OR (LEN(:MP-DATE-MOVE) <> 10), CIS.CHAR2DATE(
                                                          :MP-DATE-MOVE
              ), CONVERT(DATE, :MP-DATE-MOVE) )                                
                 ,CIS.CHAR2TIMESTAMP(:MP-MOVE-NO)                               
                 ,:MP-MTR-STORAGE-FAC-CD                                
                 ,:MP-EQUIP-LOC-ID                                      
                 ,:MP-METER-NO                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18230000
MFA-TR*       INSERT INTO CSS_EQUIP_ATT_MOVE                            18240000
MFA-TR*       (                                                         18250000
MFA-TR*           DEVICE_NO                                             18260000
MFA-TR*          ,CODE_ATT_TYPE                                         18270000
MFA-TR*          ,COMPANY_NO                                            18280000
MFA-TR*          ,CODE_UTIL_TYPE                                        18290000
MFA-TR*          ,DATE_MOVE                                             18300000
MFA-TR*          ,MOVE_NO                                               18310000
MFA-TR*          ,MTR_STORAGE_FAC_CD                                    18320000
MFA-TR*          ,EQUIP_LOC_ID                                          18330000
MFA-TR*          ,METER_NO                                              18340000
MFA-TR*       )                                                         18350000
MFA-TR*       VALUES                                                    18360000
MFA-TR*       (                                                         18370000
MFA-TR*           :MP-DEVICE-NO                                         18380000
MFA-TR*          ,:MP-CODE-ATT-TYPE                                     18390000
MFA-TR*          ,:MP-COMPANY-NO                                        18400000
MFA-TR*          ,:MP-CODE-UTIL-TYPE                                    18410000
MFA-TR*          ,:MP-DATE-MOVE                                         18420000
MFA-TR*          ,:MP-MOVE-NO                                           18430000
MFA-TR*          ,:MP-MTR-STORAGE-FAC-CD                                18440000
MFA-TR*          ,:MP-EQUIP-LOC-ID                                      18450000
MFA-TR*          ,:MP-METER-NO                                          18460000
MFA-TR*       )                                                         18470000
MFA-TR*    END-EXEC.                                                    18480000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATT_MOVE'  TO TABLE-1                     
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1             
              MOVE 'CODE_ATT_TYPE'       TO TABLE-ELEMENT-2             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE 'DATE_MOVE'           TO TABLE-ELEMENT-4             
              MOVE MP-DEVICE-NO          TO HOSTVAR-ELEMENT-1           
              MOVE MP-CODE-ATT-TYPE      TO HOSTVAR-ELEMENT-2           
              MOVE MP-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3           
              MOVE MP-DATE-MOVE          TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18730000
      ******************************************************************18740000
      * 8220-DELETE-GAS-MTR-ATCH                                       *18750000
      ******************************************************************18760000
       8220-DELETE-GAS-MTR-ATCH.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_METER_ATTCHMTS                            
               WHERE COMPANY_NO     = :MA-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                
                 AND METER_NO       = :MA-METER-NO                      
                 AND DEVICE_NO      = :MA-DEVICE-NO                     
                 AND CODE_ATT_TYPE  = :MA-CODE-ATT-TYPE                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                     TO WS-DEL-FLAG               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '8220'               TO ACTIVE-PARAGRAPH          
                 MOVE 'DELETE'             TO ABEND-FUNCTION            
                 MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                   
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1           
                 MOVE 'METER_NO'           TO TABLE-ELEMENT-2           
                 MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3           
                 MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-2         
                 MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19180000
      ******************************************************************19190000
      * 8300-INSERT-MTR-ATTACHMNT                                      *19200000
      ******************************************************************19210000
       8300-INSERT-MTR-ATTACHMNT.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_METER_ATTCHMTS                            
              (                                                         
                 COMPANY_NO                                             
                ,CODE_UTIL_TYPE                                         
                ,METER_NO                                               
                ,CODE_DEVICE_TYPE                                       
                ,DEVICE_NO                                              
                ,CODE_ATT_TYPE                                          
                ,CODE_MAKE                                              
                ,DATE_LAST_TESTED                                       
                ,TEST_SCHED_CD                                          
                ,HOW_ATTACHED_CD                                        
              )                                                         
              VALUES                                                    
              (                                                         
                 :MA-COMPANY-NO                                         
                ,:MA-CODE-UTIL-TYPE                                     
                ,:MA-METER-NO                                           
                ,:MA-CODE-DEVICE-TYPE                                   
                ,:MA-DEVICE-NO                                          
                ,:MA-CODE-ATT-TYPE                                      
                ,:MA-CODE-MAKE                                          
                ,IIF(TRY_CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                       :WS-DATE-LAST-TESTED-IND
              ) IS NULL OR (PATINDEX('%.%', :MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) <> 0) OR (LEN(:MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) <> 10), CIS.CHAR2DATE(:MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ), CONVERT(DATE, :MA-DATE-LAST-TESTED 
                                               :WS-DATE-LAST-TESTED-IND
              ) )          
                ,:MA-TEST-SCHED-CD                                      
                ,:MA-HOW-ATTACHED-CD                                    
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     19240000
MFA-TR*       INSERT INTO CSS_METER_ATTCHMTS                            19250000
MFA-TR*       (                                                         19260000
MFA-TR*          COMPANY_NO                                             19270000
MFA-TR*         ,CODE_UTIL_TYPE                                         19280000
MFA-TR*         ,METER_NO                                               19290000
MFA-TR*         ,CODE_DEVICE_TYPE                                       19300000
MFA-TR*         ,DEVICE_NO                                              19310000
MFA-TR*         ,CODE_ATT_TYPE                                          19320000
MFA-TR*         ,CODE_MAKE                                              19330000
MFA-TR*         ,DATE_LAST_TESTED                                       19340000
MFA-TR*         ,TEST_SCHED_CD                                          19350000
MFA-TR*         ,HOW_ATTACHED_CD                                        19360000
MFA-TR*       )                                                         19370000
MFA-TR*       VALUES                                                    19380000
MFA-TR*       (                                                         19390000
MFA-TR*          :MA-COMPANY-NO                                         19400000
MFA-TR*         ,:MA-CODE-UTIL-TYPE                                     19410000
MFA-TR*         ,:MA-METER-NO                                           19420000
MFA-TR*         ,:MA-CODE-DEVICE-TYPE                                   19430000
MFA-TR*         ,:MA-DEVICE-NO                                          19440000
MFA-TR*         ,:MA-CODE-ATT-TYPE                                      19450000
MFA-TR*         ,:MA-CODE-MAKE                                          19460000
MFA-TR*         ,:MA-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND          19470000
MFA-TR*         ,:MA-TEST-SCHED-CD                                      19480000
MFA-TR*         ,:MA-HOW-ATTACHED-CD                                    19490000
MFA-TR*        )                                                        19500000
MFA-TR*    END-EXEC.                                                    19510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'METER_NO'           TO TABLE-ELEMENT-3              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-3            
              MOVE MA-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19760000
      ***************************************************************** 19770000
      * 9900-ERROR HANDLING INCLUDE                                   * 19780000
      ***************************************************************** 19790000
           EXEC SQL                                                     19800000
              INCLUDE CPDSP300                                          19810000
           END-EXEC.                                                    19820000
      *                                                                 19830000
      ***************************************************************** 19840000
      * 9000-SEND-ERROR-RESULT                                        * 19850000
      * 9999-END-PROGRAM                                              * 19860000
      ***************************************************************** 19870000
                                                                        
           EXEC SQL                                                     19890000
              INCLUDE CPD00321                                          19900000
           END-EXEC.                                                    19910000
      *                                                                 19920000
