       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04216.                                         
COB303 DATE-WRITTEN.  DEC 29 2008.                                      
       DATE-COMPILED.                                                   
      *                                                                 00000500
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      *                                                                *00001000
      ******************************************************************00001100
      *                 P R O G R A M  S U M M A R Y                   *00001200
      *                                                                *00001300
      * UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC AND    *00001400
      * GAS TEST STATISTICS SCREENS TO UPDATE, INSERT OR DELETE        *00001500
      * TEST HISTORY                                                   *00001600
      *                                                                *00001700
      ******************************************************************00001800
      *                                                                *00001900
      *                     PROGRAM MODIFICATION LOG                   *00002000
      *                                                                *00002100
      *    DATE    INITIALS   COMMENTS                                 *00002200
      *  --------  --------   ---------------------------------------  *00002300
      *  12/29/08  MH94819    INITIAL VERSION.                         *00002400
      *                                                                *00002500
      ******************************************************************00002600
      ******************************************************************00002700
      *                                                                *00002800
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00002900
      *                                                                *00003000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003100
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00003200
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00003300
      *  3000 - 4999  NOT USED                                         *00003400
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00003500
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00003600
      *  7000 - 7999  INPUT MODULES                                    *00003700
      *  8000 - 8999  OUTPUT MODULES                                   *00003800
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00003900
      *                                                                *00004000
      ******************************************************************00004100
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04216'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04216 STARTS HERE'.                  
                                                                        
      ******************************************************************00005000
      * WORK AREAS                                                     *00005100
      ******************************************************************00005200
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04216'.      
           05  WS-UPDATE-IND           PIC X(01) VALUE 'I'.             
               88 WS-INS-IND                     VALUE 'I'.             
               88 WS-UPD-IND                     VALUE 'U'.             
               88 WS-DEL-IND                     VALUE 'D'.             
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      **************************THIS IS THE ROW RETURN AREA*************00006100
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
                                                                        
      ******************************************************************00007100
      * DB2 INCLUDES                                                   *00007200
      ******************************************************************00007300
           EXEC SQL                                                     00007400
              INCLUDE SQLCA                                             00007500
           END-EXEC.                                                    00007600
                                                                        
      ******************************************************************00007800
      * CSS_MTR_TEST_HIST, MQ                                          *00007900
      ******************************************************************00008000
           EXEC SQL                                                     00008100
              INCLUDE TBMTRTST                                          00008200
           END-EXEC.                                                    00008300
                                                                        
      ******************************************************************00008500
      * COBOL WORKING STORAGE COPY BOOKS                               *00008600
      ******************************************************************00008700
                                                                        
           COPY CWS00303.                                               00008900
                                                                        
           EXEC SQL                                                     00009100
              INCLUDE CWSX0010                                          00009200
           END-EXEC.                                                    00009300
                                                                        
HPCCDM*EJECT                                                            00010600
                                                                        
       LINKAGE SECTION.                                                 
                                                                        
       01 PARM-UPDATE-IND              PIC X(01).                       
       01 PARM-STATUS-CD               PIC X(01).                       
COB305 01 PARM-SAMPL-CORRECTV-PCT        PIC S9(3)V USAGE COMP-3 
COB305       VALUE 0.        
COB305 01 PARM-SAMPL-OVERAGE-PCT        PIC S9(3)V USAGE COMP-3 VALUE 0.        
COB305 01 PARM-INITIAL-RANDM-SEED        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.        
       01 PARM-COMPANY-NO              PIC X(02).                       
       01 PARM-CODE-UTIL-TYPE          PIC X(01).                       
       01 PARM-TEST-YEAR               PIC S9(04)  USAGE COMP.          
       01 PARM-TEST-SCHED-CD           PIC X(01).                       
       01 PARM-MTR-TEST-GRP-CD         PIC X(02).                       
                                                                        
       PROCEDURE DIVISION USING PARM-UPDATE-IND                         
                                PARM-STATUS-CD                          
                                PARM-SAMPL-CORRECTV-PCT                 
                                PARM-SAMPL-OVERAGE-PCT                  
                                PARM-INITIAL-RANDM-SEED                 
                                PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-TEST-YEAR                          
                                PARM-TEST-SCHED-CD                      
                                PARM-MTR-TEST-GRP-CD.                   
                                                                        
      ******************************************************************00013200
      * 0000-MAINLINE                                                  *00013300
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00013400
      ******************************************************************00013500
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00014500
      ******************************************************************00014600
      * 0100-INITIALIZE                                                *00014700
      *                                                                *00014800
      ******************************************************************00014900
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE     AS RETURN_CODE                 
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     00015550
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00015560
MFA-TR*        SELECT :S-RETURN-CODE     AS RETURN_CODE                 00015570
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                    00015580
MFA-TR*    END-EXEC.                                                    00015590
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00015900
      * 1000-PROCESS-INPUT                                             *00016000
      *                                                                *00016100
      ******************************************************************00016200
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-UPDATE-IND                TO WS-UPDATE-IND.        
           MOVE PARM-STATUS-CD                 TO MQ-STATUS-CD.         
           MOVE PARM-SAMPL-CORRECTV-PCT        TO MQ-SAMPL-CORRECTV-PCT.
           MOVE PARM-SAMPL-OVERAGE-PCT         TO MQ-SAMPL-OVERAGE-PCT. 
           MOVE PARM-INITIAL-RANDM-SEED        TO MQ-INITIAL-RANDM-SEED.
           MOVE PARM-COMPANY-NO                TO MQ-COMPANY-NO.        
           MOVE PARM-CODE-UTIL-TYPE            TO MQ-CODE-UTIL-TYPE.    
           MOVE PARM-TEST-YEAR                 TO MQ-TEST-YEAR.         
           MOVE PARM-TEST-SCHED-CD             TO MQ-TEST-SCHED-CD.     
           MOVE PARM-MTR-TEST-GRP-CD           TO MQ-MTR-TEST-GRP-CD.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00018000
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *00018100
      ******************************************************************00018200
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
           IF PARM-CODE-UTIL-TYPE  = SPACES OR                          
              PARM-COMPANY-NO      = SPACES OR                          
              PARM-UPDATE-IND      = SPACES OR                          
              PARM-TEST-SCHED-CD   = SPACES OR                          
              PARM-STATUS-CD       = SPACES OR                          
              PARM-TEST-YEAR       = 0                                  
                                                                        
              MOVE 9998                   TO WS-ACTIVE-RETURN-CODE      
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '1200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'VALIDATE'             TO ABEND-FUNCTION             
              MOVE 'N/A'                  TO TABLE-1                    
              MOVE 'PARM-CODE-UTIL-TYPE'  TO TABLE-ELEMENT-1            
              MOVE 'PARM-TEST-YEAR'       TO TABLE-ELEMENT-2            
              MOVE 'PARM-TEST-SCHED-CD'   TO TABLE-ELEMENT-3            
              MOVE 'PARM-STATUS-CD'       TO TABLE-ELEMENT-4            
              MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1          
              MOVE PARM-TEST-YEAR         TO HOSTVAR-ELEMENT-2          
              MOVE PARM-TEST-SCHED-CD     TO HOSTVAR-ELEMENT-3          
              MOVE PARM-STATUS-CD         TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                .                                                       
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00021100
      * 2000-PROCESS-OUTPUT.                                           *00021200
      ******************************************************************00021300
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-INS-IND                                           
                 PERFORM 8150-INSERT-MTR-TESTHIST THRU 8150-EXIT        
              WHEN WS-DEL-IND                                           
                 PERFORM 8300-DELETE-MTR-TESTHIST THRU 8300-EXIT        
              WHEN WS-UPD-IND                                           
                 PERFORM 8200-UPDATE-MTR-TESTHIST THRU 8200-EXIT        
              WHEN OTHER                                                
                 MOVE 9999                     TO WS-ACTIVE-RETURN-CODE 
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE '2000'                   TO ACTIVE-PARAGRAPH      
                 MOVE 'EVALUATE'               TO ABEND-FUNCTION        
                 MOVE 'N/A'                    TO TABLE-1               
                 MOVE 'WS-UPDATE-IND'          TO TABLE-ELEMENT-1       
                 MOVE WS-UPDATE-IND            TO HOSTVAR-ELEMENT-1     
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
           END-EVALUATE.                                                
           ADD 1                              TO CTR-ROWS.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00023700
      * 8150-INSERT-MTR-TESTHIST                                       *00023800
      ******************************************************************00023900
       8150-INSERT-MTR-TESTHIST.                                        
                                                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MTR_TEST_HIST                             
              (                                                         
                 CODE_UTIL_TYPE                                         
                ,TEST_YEAR                                              
                ,TEST_SCHED_CD                                          
                ,MTR_TEST_GRP_CD                                        
                ,STATUS_CD                                              
                ,SAMPL_CORRECTV_PCT                                     
                ,SAMPL_OVERAGE_PCT                                      
                ,INITIAL_RANDM_SEED                                     
                ,COMPANY_NO                                             
              )                                                         
              VALUES                                                    
              (                                                         
                 :MQ-CODE-UTIL-TYPE                                     
                ,:MQ-TEST-YEAR                                          
                ,:MQ-TEST-SCHED-CD                                      
                ,:MQ-MTR-TEST-GRP-CD                                    
                ,:MQ-STATUS-CD                                          
                ,:MQ-SAMPL-CORRECTV-PCT                                 
                ,:MQ-SAMPL-OVERAGE-PCT                                  
                ,:MQ-INITIAL-RANDM-SEED                                 
                ,:MQ-COMPANY-NO                                         
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8150'                      TO ACTIVE-PARAGRAPH      
              MOVE 'INSERT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_MTR_TEST_HIST'         TO TABLE-1               
              MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-1       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-2       
              MOVE 'TEST_SCHED_CD'             TO TABLE-ELEMENT-3       
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-4       
              MOVE MQ-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-1     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-SCHED-CD            TO HOSTVAR-ELEMENT-3     
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00029400
      ******************************************************************00029500
      * 8200-UPDATE-MTR-TESTHIST                                       *00029600
      ******************************************************************00029700
       8200-UPDATE-MTR-TESTHIST.                                        
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MTR_TEST_HIST                                  
              SET STATUS_CD          = :MQ-STATUS-CD                    
                 ,SAMPL_CORRECTV_PCT = :MQ-SAMPL-CORRECTV-PCT           
                 ,SAMPL_OVERAGE_PCT  = :MQ-SAMPL-OVERAGE-PCT            
                 ,INITIAL_RANDM_SEED = :MQ-INITIAL-RANDM-SEED           
              WHERE COMPANY_NO       = :MQ-COMPANY-NO                   
                AND CODE_UTIL_TYPE   = :MQ-CODE-UTIL-TYPE               
                AND TEST_YEAR        = :MQ-TEST-YEAR                    
                AND TEST_SCHED_CD    = :MQ-TEST-SCHED-CD                
                AND MTR_TEST_GRP_CD  = :MQ-MTR-TEST-GRP-CD              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'UPDATE'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_MTR_TEST_HIST'         TO TABLE-1               
              MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-1       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-2       
              MOVE 'TEST_SCHED_CD'             TO TABLE-ELEMENT-3       
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-4       
              MOVE MQ-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-1     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-SCHED-CD            TO HOSTVAR-ELEMENT-3     
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00034300
      * 8300-DELETE-MTR-TESTHIST                                       *00034400
      ******************************************************************00034500
       8300-DELETE-MTR-TESTHIST.                                        
                                                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_MTR_TEST_HIST                             
              WHERE COMPANY_NO      = :MQ-COMPANY-NO                    
                AND CODE_UTIL_TYPE  = :MQ-CODE-UTIL-TYPE                
                AND TEST_YEAR       = :MQ-TEST-YEAR                     
                AND TEST_SCHED_CD   = :MQ-TEST-SCHED-CD                 
                AND MTR_TEST_GRP_CD = :MQ-MTR-TEST-GRP-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '8300'                      TO ACTIVE-PARAGRAPH      
              MOVE 'DELETE'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_MTR_TEST_HIST'         TO TABLE-1               
              MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-1       
              MOVE 'TEST_YEAR'                 TO TABLE-ELEMENT-2       
              MOVE 'TEST_SCHED_CD'             TO TABLE-ELEMENT-3       
              MOVE 'MTR_TEST_GRP_CD'           TO TABLE-ELEMENT-4       
              MOVE MQ-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-1     
              MOVE MQ-TEST-YEAR                TO HOSTVAR-ELEMENT-2     
              MOVE MQ-TEST-SCHED-CD            TO HOSTVAR-ELEMENT-3     
              MOVE MQ-MTR-TEST-GRP-CD          TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00038400
      ******************************************************************00038500
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00038600
      ******************************************************************00038700
           EXEC SQL                                                     00038800
              INCLUDE CPDSP300                                          00038900
           END-EXEC.                                                    00039000
      *                                                                 00039100
                                                                        
           EXEC SQL                                                     00039800
               INCLUDE CPD00321                                         00039900
           END-EXEC.                                                    00040000
      *                                                                 00040100
