       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04213.                                          
COB303 DATE-WRITTEN.      SEPTEMBER 17, 2008.                           
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  DETERMINE ACCOUNT REGISTRATION TERMS AND CONDITIONS FOR WEB.  *        
      *  STATUS CODE VALUES ARE:                                       *        
      *       100       CUSTOMER HAS NO ACCOUNTS                       *        
      *       200       CUSTOMER HAS ONLY NON-UTILITY ACCOUNT(S)       *        
      *       300       NO CURRENT ACCOUNT AT PREMISE FOR PENDING ONLY *        
P00836*       400       CUSTOMER HAS ONLY SERVICECARE ACCOUNT(S)       *        
      *       500       CUSTOMER CANNOT REGISTER VIA WEB               *        
      *       999       UNDETERMINED ERROR                             *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/17/08    FMB      NEW PROGRAM.                                      
P00422*  06/11/10    FMB      RETURN LANDLORD AND CREDIT WORTHY FLAGS.          
A04753*  11/04/13    FMB      SEB CUSTOMER WITH A PENDING ACCOUNT               
A04753*                       CREATED WITHIN PAST 90 DAYS MAY REGISTER.         
A04753*                       WRITE OFF RULES ARE SAME AS PROFILE AND           
A04753*                       SEB NEW/CLOSED (CSR04492).                        
P00836*  12/10/14    FMB      CUSTOMERS WITH ONLY SERVICECARE ACCOUNTS          
P00836*                       MAY NOT REGISTER. CUSTOMERS WITH ONLY             
P00836*                       NON-UTILITY ACCOUNTS (NOT SERVICECARE)            
P00836*                       MAY REGISTER.                                     
P00836*  03/11/14    FMB      MATCH RULES WITH WEB ACCOUNT LISTING.             
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04213'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
            'WORKING STORAGE FOR CSR04213 STARTS HERE'.                 
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
P00422     EXEC SQL                                                             
P00422        INCLUDE TBLNDLRD                                                  
P00422     END-EXEC.                                                            
                                                                        
A04753     EXEC SQL                                                             
A04753        INCLUDE TBFINLWO                                                  
A04753     END-EXEC.                                                            
                                                                        
A04753     EXEC SQL                                                             
A04753          INCLUDE TBCOLHST                                                
A04753     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04213_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-FORM-FL              PIC X(01) VALUE SPACES.          
           05  RS-NAME-FORMAT-FL       PIC X(01) VALUE SPACES.          
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACES.          
           05  RS-MIDDLE-NAME          PIC X(15) VALUE SPACES.          
           05  RS-LAST-NAME            PIC X(40) VALUE SPACES.          
           05  RS-BUSINESS-NAME        PIC X(70) VALUE SPACES.          
P00422     05  RS-PROP-MGR-FL          PIC X(01) VALUE SPACES.          
P00422     05  RS-REVERT-ELIG-FL       PIC X(01) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-FORM-FL              PIC X(01) VALUE SPACES.           
           05  S-NAME-FORMAT-FL       PIC X(01) VALUE SPACES.           
           05  S-FIRST-NAME           PIC X(15) VALUE SPACES.           
           05  S-MIDDLE-NAME          PIC X(15) VALUE SPACES.           
           05  S-LAST-NAME            PIC X(40) VALUE SPACES.           
           05  S-BUSINESS-NAME        PIC X(70) VALUE SPACES.           
P00422     05  S-PROP-MGR-FL          PIC X(01) VALUE SPACES.           
P00422     05  S-REVERT-ELIG-FL       PIC X(01) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-DATE-30       PIC X(10) VALUE SPACES.         
A04753     05  WS-CURRENT-DATE-90       PIC X(10) VALUE SPACES.         
P00836     05  WS-CURRENT-DATE-16       PIC X(10) VALUE SPACES.         
           05  WS-WO-CUTOFF-DT-01       PIC X(10) VALUE SPACES.         
           05  WS-WO-CUTOFF-DT-26       PIC X(10) VALUE SPACES.         
           05  WS-WO-CUTOFF-DT          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04213'.     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES                       
               WS-CUSTOMER-NO-CHAR      PIC 9(10).                      
           05  WS-NAME-FORMAT-FL        PIC X(01) VALUE ' '.            
           05  WS-CURRENT-ACCOUNT-FL    PIC X(01) VALUE 'N'.            
           05  WS-INDUSTRIAL-FL         PIC X(01) VALUE 'N'.            
           05  WS-PENDING-COUNT         PIC S9(4) COMP VALUE 0.         
           05  WS-NON-PENDING-COUNT     PIC S9(4) COMP VALUE 0.         
           05  WS-RESIDENTIAL-COUNT     PIC S9(4) COMP VALUE 0.         
           05  WS-COMMERCIAL-COUNT      PIC S9(4) COMP VALUE 0.         
           05  WS-NON-UTILITY-COUNT     PIC S9(4) COMP VALUE 0.         
P00836     05  WS-SERVICECARE-COUNT     PIC S9(4) COMP VALUE 0.         
           05  WS-OTHER-COUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-REGISTRATION-FL       PIC X(01) VALUE 'N'.            
           05  WS-NULL-FINAL-DT         PIC S9(04) COMP VALUE ZERO.     
A04753     05  WS-NULL-CREATE-DT        PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-CHG-AMT          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CHARGES-FOUND         PIC X(01)  VALUE 'N'.           
A04753     05  WS-COLLECT-CONTACT-FL    PIC X(01) VALUE 'N'.            
           05  WS-DATABASE               PIC 9(01) VALUE 0.             
               88 CSR-DATABASE                     VALUE 1.             
               88 SEB-DATABASE                     VALUE 2.             
                                                                        
       01  WS-TABLES.                                                   
           05  WS-PREMISE-TABLE         OCCURS 100 TIMES                
                                        INDEXED BY T1-INDEX.            
               10  WS-PREMISE-NO        PIC 9(10) VALUE 0.              
               10  WS-ACCOUNT-NO        PIC 9(13) VALUE 0.              
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
            EXEC SQL                                                    
                DECLARE ACCT_CURSOR CURSOR FOR                          
                    SELECT ACCOUNT_NO,                                  
                           PREMISE_NO,                                  
                           ACCOUNT_TYPE_CODE,                           
                           CODE_ACCT_STAT,                              
                           TOTAL_AR_BALANCE,                            
                           REPLACE(REPLACE(CONVERT(CHAR(26), 
           ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,        
P00422                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,          
                           COMPANY_NO,                                  
P00836                     LOCAL_OFFICE,                                
P00836                     BANKRUPTCY_IND,                              
P00836                     JUDGEMENT_IND                                
                      FROM CSS_ACCOUNT                                  
                     WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                
                     ORDER BY CODE_ACCT_STAT                            
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE ACCT_CURSOR CURSOR FOR                                  
MFA-TR*             SELECT ACCOUNT_NO,                                          
MFA-TR*                    PREMISE_NO,                                          
MFA-TR*                    ACCOUNT_TYPE_CODE,                                   
MFA-TR*                    CODE_ACCT_STAT,                                      
MFA-TR*                    TOTAL_AR_BALANCE,                                    
MFA-TR*                    ACCT_FINALED_DT,                                     
MFA-TR*                    ACCT_CREATE_DT,                                      
MFA-TR*                    COMPANY_NO,                                          
MFA-TR*                    LOCAL_OFFICE,                                        
MFA-TR*                    BANKRUPTCY_IND,                                      
MFA-TR*                    JUDGEMENT_IND                                        
MFA-TR*               FROM CSS_ACCOUNT                                          
MFA-TR*              WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                        
MFA-TR*              ORDER BY CODE_ACCT_STAT                                    
MFA-TR*              QUERYNO 7100                                               
MFA-TR*     END-EXEC.                                                           
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -30, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-CURRENT-DATE-30                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 30 DAYS)                       
MFA-TR*          INTO :WS-CURRENT-DATE-30                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04753     EXEC SQL                                                     
A04753         SELECT
              DATEADD( DAY, -90, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-CURRENT-DATE-90                               
A04753     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 90 DAYS)                       
MFA-TR*          INTO :WS-CURRENT-DATE-90                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836     EXEC SQL                                                     
P00836         SELECT
              DATEADD( MONTH, -16, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-CURRENT-DATE-16                               
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 16 MONTHS)                     
MFA-TR*          INTO :WS-CURRENT-DATE-16                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-WO-CUTOFF-DT-01                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 6 YEARS)                       
MFA-TR*          INTO :WS-WO-CUTOFF-DT-01                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
P00836         SELECT
              DATEADD( YEAR, -6, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-WO-CUTOFF-DT-26                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 6 YEARS)                       
MFA-TR*          INTO :WS-WO-CUTOFF-DT-26                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE     AS RETURN_CODE,                
                      :S-STATUS-CODE     AS STATUS_CODE,                
                      :S-FORM-FL         AS FORM_FL,                    
                      :S-NAME-FORMAT-FL  AS NAME_FORMAT_FL,             
                      :S-FIRST-NAME      AS FIRST_NAME,                 
                      :S-MIDDLE-NAME     AS MIDDLE_NAME,                
                      :S-LAST-NAME       AS LAST_NAME,                  
                      :S-BUSINESS-NAME   AS BUSINESS_NAME,              
P00422                :S-PROP-MGR-FL     AS PROP_MGR_FL,                
P00422                :S-REVERT-ELIG-FL  AS REVERT_ELIG_FL              
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE     AS RETURN_CODE,                        
MFA-TR*               :S-STATUS-CODE     AS STATUS_CODE,                        
MFA-TR*               :S-FORM-FL         AS FORM_FL,                            
MFA-TR*               :S-NAME-FORMAT-FL  AS NAME_FORMAT_FL,                     
MFA-TR*               :S-FIRST-NAME      AS FIRST_NAME,                         
MFA-TR*               :S-MIDDLE-NAME     AS MIDDLE_NAME,                        
MFA-TR*               :S-LAST-NAME       AS LAST_NAME,                          
MFA-TR*               :S-BUSINESS-NAME   AS BUSINESS_NAME,                      
MFA-TR*               :S-PROP-MGR-FL     AS PROP_MGR_FL,                        
MFA-TR*               :S-REVERT-ELIG-FL  AS REVERT_ELIG_FL                      
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           SET T1-INDEX TO 1.                                           
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO AT-CUSTOMER-NO                    
                                      CU-CUSTOMER-NO.                   
           MOVE 'N' TO WS-REGISTRATION-FL.                              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-NAME THRU 7000-EXIT.                        
P00422     PERFORM 7050-GET-LANDLORD THRU 7050-EXIT.                    
           PERFORM 7100-OPEN-CURSOR THRU 7100-EXIT.                     
           PERFORM 3000-PROCESS-ACCOUNTS THRU 3000-EXIT.                
           PERFORM 7200-CLOSE-CURSOR THRU 7200-EXIT.                    
                                                                        
           IF WS-PENDING-COUNT = 0 AND WS-NON-PENDING-COUNT = 0         
               MOVE +100 TO RS-STATUS-CODE                              
           ELSE                                                         
               IF WS-PENDING-COUNT > 0 AND                              
                  WS-NON-PENDING-COUNT = 0 AND                          
A04753            CSR-DATABASE                                          
                    MOVE 0 TO WS-RESIDENTIAL-COUNT                      
                              WS-COMMERCIAL-COUNT                       
                              WS-NON-UTILITY-COUNT                      
                              WS-OTHER-COUNT                            
                    MOVE 'N' TO WS-CURRENT-ACCOUNT-FL                   
                    PERFORM 3100-ONLY-PENDING-ACCOUNTS THRU 3100-EXIT   
                        VARYING T1-INDEX FROM 1 BY 1 UNTIL              
                        T1-INDEX > 100 OR WS-PREMISE-NO (T1-INDEX) = 0  
                    PERFORM 3150-CURRENT-ACCOUNTS THRU 3150-EXIT        
                        VARYING T1-INDEX FROM 1 BY 1 UNTIL              
                        T1-INDEX > 100 OR WS-PREMISE-NO (T1-INDEX) = 0  
                    IF WS-CURRENT-ACCOUNT-FL = 'N'                      
                        MOVE +300 TO RS-STATUS-CODE                     
                    ELSE                                                
                        PERFORM 3200-DETERMINE-FORM THRU 3200-EXIT      
                    END-IF                                              
               ELSE                                                     
                   PERFORM 3200-DETERMINE-FORM THRU 3200-EXIT
               END-IF
           END-IF.          
                                                                        
                                                                        
           IF WS-REGISTRATION-FL = 'N'                                  
               MOVE +500 TO RS-STATUS-CODE                              
               EVALUATE WS-NAME-FORMAT-FL                               
                   WHEN 'I'                                             
                       MOVE '1' TO RS-FORM-FL                           
                   WHEN OTHER                                           
                       MOVE '2' TO RS-FORM-FL                           
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF RS-STATUS-CODE = 0 AND                                    
              RS-FORM-FL = ' '                                          
                  MOVE +999 TO RS-STATUS-CODE
           END-IF.                          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE     TO S-RETURN-CODE.                  
             MOVE RS-STATUS-CODE     TO S-STATUS-CODE.                  
             MOVE RS-FORM-FL         TO S-FORM-FL.                      
             MOVE RS-NAME-FORMAT-FL  TO S-NAME-FORMAT-FL.               
             MOVE RS-FIRST-NAME      TO S-FIRST-NAME.                   
             MOVE RS-MIDDLE-NAME     TO S-MIDDLE-NAME.                  
             MOVE RS-LAST-NAME       TO S-LAST-NAME.                    
             MOVE RS-BUSINESS-NAME   TO S-BUSINESS-NAME.                
P00422       MOVE RS-PROP-MGR-FL     TO S-PROP-MGR-FL.                  
P00422       MOVE RS-REVERT-ELIG-FL  TO S-REVERT-ELIG-FL.               
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       3000-PROCESS-ACCOUNTS.                                           
                                                                        
           EXEC SQL                                                     
               FETCH ACCT_CURSOR                                        
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-PREMISE-NO,                                     
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-ACCT-FINALED-DT :WS-NULL-FINAL-DT,               
A04753              :AT-ACCT-CREATE-DT :WS-NULL-CREATE-DT,               
                    :AT-COMPANY-NO,                                     
P00836              :AT-LOCAL-OFFICE,                                   
P00836              :AT-BANKRUPTCY-IND,                                 
P00836              :AT-JUDGEMENT-IND                                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-FINAL-DT < 0                              
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
A04753             IF WS-NULL-CREATE-DT < 0                             
A04753                 MOVE SPACES TO AT-ACCT-CREATE-DT                 
A04753             END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 3000-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '3000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                   ABEND-TABLES         
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'P'                                                 
                   ADD 1 TO WS-PENDING-COUNT                            
                   MOVE AT-PREMISE-NO TO WS-PREMISE-NO (T1-INDEX)       
                   SET T1-INDEX UP BY 1                                 
               WHEN OTHER                                               
                   ADD 1 TO WS-NON-PENDING-COUNT                        
           END-EVALUATE.                                                
                                                                        
           EVALUATE AT-ACCOUNT-TYPE-CODE                                
               WHEN 'N'                                                 
P00836             IF AT-LOCAL-OFFICE = '301' OR '303'                  
P00836                 ADD 1 TO WS-SERVICECARE-COUNT                    
P00836             ELSE                                                 
                       ADD 1 TO WS-NON-UTILITY-COUNT                    
P00836             END-IF                                               
               WHEN 'R'                                                 
                   ADD 1 TO WS-RESIDENTIAL-COUNT                        
               WHEN 'C'                                                 
                   ADD 1 TO WS-COMMERCIAL-COUNT                         
               WHEN OTHER                                               
                   IF AT-ACCOUNT-TYPE-CODE = 'I'                        
                       MOVE 'Y' TO WS-INDUSTRIAL-FL                     
                   END-IF                                               
                   ADD 1 TO WS-OTHER-COUNT                              
           END-EVALUATE.                                                
                                                                        
           MOVE ZEROS                      TO WS-DATABASE.              
           MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
           MOVE AT-COMPANY-NO              TO C8-COMPANY-NO.            
           PERFORM 7800-GET-DELINQ-VALUE   THRU 7800-EXIT.              
           MOVE C8-DELINQ-VALUE            TO WS-DATABASE.              
                                                                        
           IF WS-REGISTRATION-FL = 'N'                                  
               IF CSR-DATABASE                                          
                   PERFORM 3300-REGISTRATION-ALLOWED-CSR THRU 3300-EXIT 
               ELSE                                                     
                   PERFORM 3400-REGISTRATION-ALLOWED-SEB THRU 3400-EXIT
               END-IF
           END-IF.
                                                                        
           GO TO 3000-PROCESS-ACCOUNTS.                                 
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3100-ONLY-PENDING-ACCOUNTS.                                      
                                                                        
           MOVE WS-PREMISE-NO (T1-INDEX) TO WS-CPD99-PREMISE-NO.        
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO WS-ACCOUNT-NO (T1-INDEX).        
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3150-CURRENT-ACCOUNTS.                                           
                                                                        
           IF WS-ACCOUNT-NO (T1-INDEX) > 0                              
               MOVE 'Y' TO WS-CURRENT-ACCOUNT-FL                        
               MOVE WS-ACCOUNT-NO (T1-INDEX) TO AT-ACCOUNT-NO           
               PERFORM 7300-SELECT-ACCOUNT THRU 7300-EXIT
           END-IF.              
                                                                        
       3150-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3200-DETERMINE-FORM.                                             
                                                                        
           IF WS-OTHER-COUNT > 0                                        
               IF WS-INDUSTRIAL-FL = 'Y'                                
                   MOVE '3' TO RS-FORM-FL                               
               ELSE                                                     
                   MOVE '2' TO RS-FORM-FL
               END-IF
           END-IF.                              
                                                                        
P00836*    IF WS-NON-UTILITY-COUNT > 0 AND                                      
P00836*       WS-RESIDENTIAL-COUNT = 0 AND                                      
P00836*       WS-COMMERCIAL-COUNT = 0 AND                                       
P00836*       WS-OTHER-COUNT = 0                                                
P00836*           MOVE +200 TO RS-STATUS-CODE.                                  
P00836     IF WS-SERVICECARE-COUNT > 0 AND                              
P00836        WS-RESIDENTIAL-COUNT = 0 AND                              
P00836        WS-COMMERCIAL-COUNT = 0 AND                               
P00836        WS-OTHER-COUNT = 0                                        
P00836            MOVE +400 TO RS-STATUS-CODE
           END-IF.                          
           IF (WS-COMMERCIAL-COUNT > 0 OR                               
               WS-RESIDENTIAL-COUNT > 0 OR                              
               WS-NON-UTILITY-COUNT > 0) AND                            
               WS-OTHER-COUNT = 0                                       
                   EVALUATE WS-NAME-FORMAT-FL                           
                       WHEN 'I'                                         
                           MOVE '1' TO RS-FORM-FL                       
                       WHEN OTHER                                       
                           MOVE '2' TO RS-FORM-FL                       
                   END-EVALUATE
           END-IF.                                        
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3300-REGISTRATION-ALLOWED-CSR.                                   
                                                                        
           EVALUATE AT-CODE-ACCT-STAT                                   
               WHEN 'P'                                                 
                   PERFORM 7400-SELECT-ORDERS THRU 7400-EXIT            
               WHEN 'A'                                                 
                   MOVE 'Y' TO WS-REGISTRATION-FL                       
               WHEN 'B'                                                 
                   IF AT-TOTAL-AR-BALANCE NOT = 0                       
                       MOVE 'Y' TO WS-REGISTRATION-FL                   
                   ELSE                                                 
P00836                 IF AT-ACCT-FINALED-DT > WS-CURRENT-DATE-16       
                           MOVE 'Y' TO WS-REGISTRATION-FL               
                       END-IF                                           
                   END-IF                                               
               WHEN 'S'                                                 
                   IF AT-COMPANY-NO = '01'                              
                       MOVE WS-WO-CUTOFF-DT-01 TO WS-WO-CUTOFF-DT       
                   ELSE                                                 
                       MOVE WS-WO-CUTOFF-DT-26 TO WS-WO-CUTOFF-DT       
                   END-IF                                               
                   PERFORM 7500-WRITE-OFF-CHECK THRU 7500-EXIT          
P00836             IF CO-AMT-TRANS NOT = 0.00                           
P00836                 PERFORM 7900-SELECT-FINAL-WO THRU 7900-EXIT      
P00836                 IF (FW-COLLECT-STATUS-CD = 'D' OR 'E') OR        
P00836                     AT-BANKRUPTCY-IND = 'B' OR                   
P00836                     AT-JUDGEMENT-IND = 'J'                       
P00836                         MOVE 'N' TO WS-REGISTRATION-FL           
P00836                 ELSE                                             
P00836                     MOVE 'Y' TO WS-REGISTRATION-FL               
P00836                 END-IF                                           
P00836             ELSE                                                 
P00836                 IF AT-ACCT-FINALED-DT(1:10) >=                   
P00836                    WS-CURRENT-DATE-16                            
P00836                        MOVE 'Y' TO WS-REGISTRATION-FL            
P00836                 END-IF                                           
P00836             END-IF                                               
           END-EVALUATE.                                                
                                                                        
       3300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3400-REGISTRATION-ALLOWED-SEB.                                   
                                                                        
           EVALUATE AT-CODE-ACCT-STAT                                   
A04753         WHEN 'P'                                                 
A04753             IF AT-ACCT-CREATE-DT > WS-CURRENT-DATE-90            
A04753                 MOVE 'Y' TO WS-REGISTRATION-FL                   
A04753             END-IF                                               
               WHEN 'A'                                                 
                   MOVE 'Y' TO WS-REGISTRATION-FL                       
               WHEN 'B'                                                 
                   IF AT-TOTAL-AR-BALANCE NOT = 0                       
                       MOVE 'Y' TO WS-REGISTRATION-FL                   
                   ELSE                                                 
P00836                 IF AT-ACCT-FINALED-DT > WS-CURRENT-DATE-16       
                           MOVE 'Y' TO WS-REGISTRATION-FL               
                       END-IF                                           
                   END-IF                                               
A04753         WHEN 'S'                                                 
A04753             MOVE '1900-01-01' TO WS-WO-CUTOFF-DT                 
A04753             PERFORM 7500-WRITE-OFF-CHECK THRU 7500-EXIT          
P00836             IF CO-AMT-TRANS NOT = 0.00                           
A04753                 PERFORM 7900-SELECT-FINAL-WO THRU 7900-EXIT      
P00836                 IF (FW-COLLECT-STATUS-CD = 'D' OR 'E') OR        
P00836                     AT-BANKRUPTCY-IND = 'B' OR                   
P00836                     AT-JUDGEMENT-IND = 'J'                       
A04753                         MOVE 'N' TO WS-REGISTRATION-FL           
A04753                 ELSE                                             
A04753                     MOVE 'Y' TO WS-REGISTRATION-FL               
A04753                 END-IF                                           
P00836             ELSE                                                 
P00836                 IF AT-ACCT-FINALED-DT(1:10) >=                   
P00836                    WS-CURRENT-DATE-16                            
P00836                        MOVE 'Y' TO WS-REGISTRATION-FL            
P00836                 END-IF                                           
A04753             END-IF                                               
           END-EVALUATE.                                                
                                                                        
       3400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              FULL_NAME,
              NAME_FORMAT,
              LANDLORD_REVERT_FL                                
                 INTO :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT,                                  
                      :CU-LANDLORD-REVERT-FL                            
                 FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LANDLORD_REVERT_FL                                        
MFA-TR*          INTO :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT,                                          
MFA-TR*               :CU-LANDLORD-REVERT-FL                                    
MFA-TR*          FROM CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE DQ-NAME-FORMAT TO RS-NAME-FORMAT-FL             
                                          WS-NAME-FORMAT-FL             
                   MOVE DQ-FIRST-NAME TO RS-FIRST-NAME                  
                   MOVE DQ-MIDDLE-NAME TO RS-MIDDLE-NAME                
                   MOVE DQ-LAST-NAME TO RS-LAST-NAME                    
                   MOVE DQ-FULL-NAME TO RS-BUSINESS-NAME                
                   MOVE CU-LANDLORD-REVERT-FL TO RS-REVERT-ELIG-FL      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUSTOMER'     TO TABLE-1                   
                   MOVE 'CSS_NAME'         TO TABLE-2                   
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00422 7050-GET-LANDLORD.                                               
P00422                                                                  
P00422     EXEC SQL                                                     
P00422         SELECT TOP(1) CUSTOMER_NO                                       
P00422           INTO :SI-CUSTOMER-NO                                   
P00422           FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
P00422          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
P00422                                           
P00422                                                           
P00422                                                      
P00422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00422                                                                  
P00422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00422                                                                  
P00422     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00422         WHEN SUCCESSFUL-CALL                                     
P00422             MOVE 'Y' TO RS-PROP-MGR-FL                           
P00422         WHEN NOT-FOUND                                           
P00422             MOVE 'N' TO RS-PROP-MGR-FL                           
P00422         WHEN OTHER                                               
P00422             MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
P00422             MOVE '7050 '            TO ACTIVE-PARAGRAPH          
P00422             MOVE 'SELECT'           TO ABEND-FUNCTION            
P00422             MOVE SPACES             TO ABEND-SQL-PREDICATES      
P00422                                        ABEND-TABLES              
P00422             MOVE 'CSS_LANDLORD'     TO TABLE-1                   
P00422             MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
P00422             MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
P00422             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00422             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00422     END-EVALUATE.                                                
P00422                                                                  
P00422 7050-EXIT.                                                       
P00422     EXIT.                                                        
                                                                        
       7100-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN ACCT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT_CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_TYPE_CODE,
              LOCAL_OFFICE                                      
                 INTO :AT-ACCOUNT-TYPE-CODE,                            
P00836                :AT-LOCAL-OFFICE                                  
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_TYPE_CODE,                                        
MFA-TR*               LOCAL_OFFICE                                              
MFA-TR*          INTO :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   EVALUATE AT-ACCOUNT-TYPE-CODE                        
                       WHEN 'N'                                         
P00836                     IF AT-LOCAL-OFFICE = '301' OR '303'          
P00836                         ADD 1 TO WS-SERVICECARE-COUNT            
P00836                     ELSE                                         
                               ADD 1 TO WS-NON-UTILITY-COUNT            
P00836                     END-IF                                       
                       WHEN 'R'                                         
                           ADD 1 TO WS-RESIDENTIAL-COUNT                
                       WHEN 'C'                                         
                           ADD 1 TO WS-COMMERCIAL-COUNT                 
                       WHEN OTHER                                       
                           ADD 1 TO WS-OTHER-COUNT                      
                   END-EVALUATE                                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7300'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-ORDERS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND (ORDER_TYPE_CD LIKE 'CC%'                         
                   OR ORDER_TYPE_CD = 'NC001')                          
                  AND ORDER_STATE_CD NOT IN ('C')                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND (ORDER_TYPE_CD LIKE 'CC%'                                 
MFA-TR*            OR ORDER_TYPE_CD = 'NC001')                                  
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C')                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-REGISTRATION-FL                       
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7400'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-WRITE-OFF-CHECK.                                            
                                                                        
           MOVE 'N' TO WS-CHARGES-FOUND.                                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :CO-AMT-TRANS :WS-NULL-CHG-AMT                     
                 FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND DATE_OF_CHG_OFF > IIF(TRY_CONVERT(DATE, 
                                                       :WS-WO-CUTOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WO-CUTOFF-DT
              ) <> 0) OR (LEN(:WS-WO-CUTOFF-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-WO-CUTOFF-DT
              ), CONVERT(DATE, :WS-WO-CUTOFF-DT) )                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-CHG-AMT                             
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND DATE_OF_CHG_OFF > :WS-WO-CUTOFF-DT                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-CHG-AMT < 0                               
                       MOVE 0.0 TO CO-AMT-TRANS                         
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO CO-AMT-TRANS                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7500'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CHRG_OFF'     TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF CO-AMT-TRANS > 0                                          
               MOVE 'Y' TO WS-REGISTRATION-FL
           END-IF.                          
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7800-GET-DELINQ-VALUE.                                           
                                                                        
           MOVE '7800'                       TO ACTIVE-PARAGRAPH.       
              EXEC SQL                                                  
                 SELECT  DELINQ_VALUE                                   
                   INTO :C8-DELINQ-VALUE                                
                   FROM  CSS_DELINQUENCY                                
                  WHERE  DELINQ_CD  = :C8-DELINQ-CD                     
                    AND  COMPANY_NO = :C8-COMPANY-NO                    
                                                            
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT  DELINQ_VALUE                                           
MFA-TR*            INTO :C8-DELINQ-VALUE                                        
MFA-TR*            FROM  CSS_DELINQUENCY                                        
MFA-TR*           WHERE  DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*             AND  COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_VALUE'             TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04753 7900-SELECT-FINAL-WO.                                            
A04753                                                                  
A04753     EXEC SQL                                                     
A04753        SELECT TOP(1) COLLECT_STATUS_CD                                 
A04753          INTO :FW-COLLECT-STATUS-CD                              
A04753          FROM  CSS_FINAL_WO WITH(READUNCOMMITTED)                        
A04753         WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
A04753                                           
A04753                                                           
A04753                                                      
A04753     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  COLLECT_STATUS_CD                                         
MFA-TR*         INTO :FW-COLLECT-STATUS-CD                                      
MFA-TR*         FROM  CSS_FINAL_WO                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7900                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04753                                                                  
A04753     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04753     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04753         WHEN SUCCESSFUL-CALL                                     
A04753             CONTINUE                                             
A04753         WHEN NOT-FOUND                                           
A04753             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A04753         WHEN OTHER                                               
A04753             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A04753             MOVE '7900'           TO ACTIVE-PARAGRAPH            
A04753             MOVE 'SELECT'         TO ABEND-FUNCTION              
A04753             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A04753                                      ABEND-TABLES                
A04753             MOVE 'CSS_FINAL_WO'   TO TABLE-1                     
A04753             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
A04753             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
A04753             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A04753             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A04753     END-EVALUATE.                                                
A04753                                                                  
A04753 7900-EXIT.                                                       
A04753     EXIT.                                                        
                                                                        
A04753 7910-COLLECT-CONTACT.                                            
A04753                                                                  
A04753     EXEC SQL                                                     
A04753         SELECT TOP(1) ACCOUNT_NO                                        
A04753           INTO :HC-ACCOUNT-NO                                    
A04753           FROM CSS_COLLECT_HIST WITH(READUNCOMMITTED)                    
A04753          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A04753            AND FUTURE_WORK_DT IS NOT NULL                        
A04753            AND CALL_TYPE_CD IN ('A', 'M')                        
A04753                                           
A04753                                                           
A04753                                                      
A04753     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :HC-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_COLLECT_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND FUTURE_WORK_DT IS NOT NULL                                
MFA-TR*           AND CALL_TYPE_CD IN ('A', 'M')                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04753                                                                  
A04753     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
A04753                                                                  
A04753     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04753         WHEN SUCCESSFUL-CALL                                     
A04753             MOVE 'Y' TO WS-COLLECT-CONTACT-FL                    
A04753         WHEN NOT-FOUND                                           
A04753             MOVE 'N' TO WS-COLLECT-CONTACT-FL                    
A04753             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A04753         WHEN OTHER                                               
A04753             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
A04753             MOVE '7910'               TO ACTIVE-PARAGRAPH        
A04753             MOVE 'SELECT'             TO ABEND-FUNCTION          
A04753             MOVE 'CSS_COLLECT_HIST'   TO TABLE-1                 
A04753             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
A04753             MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
A04753             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A04753             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A04753     END-EVALUATE.                                                
A04753                                                                  
A04753 7910-EXIT.                                                       
A04753     EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
