       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04202.                                         
COB303 DATE-WRITTEN. NOV 27, 2008.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS CALLED FROM METER INVENTORY APPLICATIONS.     *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC       *        
      *  ADD, UPDATE, AND DELETE SCREENS                                        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/27/08   VY95550   INITIAL VERSION.                         *        
P00251*  03/24/10   SS95855  Net Metering                              *        
P00251*                      Synch REG_ID_NO and CODE_CAP_TYPE with    *        
P00251*                      CSS_MTR_RD_FMT table.                     *        
P00251*  05/05/10   SS95855  READ_FMT_CSR Cursor modified to return    *        
      *                      one row for Same register(Normal & Co-gen)*        
P00447*  09/13/10  SB40505    ADD CSS_ELEC_CL_SPEC FOR CONSTANT DEFAULT*        
P00447*                       IF CT_METER_FL = 'Y' THEN 0 ELSE 1       *        
P00462*  01/25/11  SB40505    remove mfr dt                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04202'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04202 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-COUNTER-FIELDS.                                           
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  WS-WORK-FIELDS.                                              
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-NULL-IND.                                                 
           05 WS-LAST-MOVE-NULL-IND    PIC S9(4) COMP.                  
           05 WS-LAST-TRAN-NULL-IND    PIC S9(4) COMP.                  
           05 WS-PURCHASED-NULL-IND    PIC S9(4) COMP.                  
           05 WS-WAR-EXP-DT-NULL-IND   PIC S9(4) COMP.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04202'.      
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CAP-SUB              PIC 9(03) VALUE 1.               
           05  WS-TMP-CAP-INFO         PIC X(31) VALUE SPACES.          
           05  WS-TANS-COMM-TMP.                                        
               10  WS-TRNS-COMMENT-TX1 PIC X(41) VALUE                  
                 "ADDED NEW CAPABILITY FOR ELECTRIC METER: ".           
               10  WS-TRNS-METER-NO    PIC X(09) VALUE SPACES.          
               10  WS-TRNS-COMMENT-TX2 PIC X(06) VALUE " TYPE ".        
               10  WS-TRNS-CODE-CAP-DESC                                
                                       PIC X(03) VALUE SPACES.          
           05  WS-FULL-SCALE           PIC 9(09).                       
           05  WS-FULL-SCALE-RED       REDEFINES WS-FULL-SCALE          
                                       PIC 99999V9999.                  
           05  WS-CONSTANT             PIC 9(09).                       
           05  WS-CONSTANT-RED         REDEFINES WS-CONSTANT            
                                       PIC 999999V999.                  
           05  WS-CHG-COMM-TXT.                                         
               10  WS-CHG-COMM-TXT1    PIC X(09) VALUE "CONSTANT ".     
               10  WS-CHG-CONSTANT     PIC ZZZZZ9.9(3).                 
               10  WS-CHG-COMM-TXT2    PIC X(13) VALUE " TOTAL DIALS ". 
               10  WS-CHG-NO-DIALS     PIC 9(04) VALUE 0.               
               10  WS-CHG-COMM-TXT3    PIC X(12) VALUE " READ DIALS ".  
               10  WS-CHG-NO-READ-DIALS                                 
                                       PIC 9(04) VALUE 0.               
           05  WS-MTR-CAP-TABLE.                                        
               10  WS-MTR-CAP-TAB OCCURS 6 TIMES.                       
                   15  WS-MTR-CAP-INFO PIC X(31).                       
                                                                        
P00251     05  WS-PREV-REG-ID-NO       PIC S9(4)    COMP VALUE +0.      
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-UPDATE-IND-SW        PIC X(01) VALUE ' '.             
               88  WS-UPDATE-U                   VALUE 'U'.             
               88  WS-DELETE-D                   VALUE 'D'.             
               88  WS-INSERT-I                   VALUE 'I'.             
           05  WS-METER-EXISTS         PIC X(01) VALUE 'N'.             
               88 METER-EXISTS                   VALUE 'Y'.             
           05  WS-EQUIP-EXISTS         PIC X(01) VALUE 'N'.             
               88 EQUIP-EXISTS                   VALUE 'Y'.             
           05  WS-ATTACHMTS-EXISTS     PIC X(01) VALUE 'N'.             
               88 ATTACHMTS-EXISTS               VALUE 'Y'.             
           05  WS-MOVE-HIST-EXISTS     PIC X(01) VALUE 'N'.             
               88 MOVE-HIST-EXISTS               VALUE 'Y'.             
           05  WS-MTR-TEST-EXISTS      PIC X(01) VALUE 'N'.             
               88 MTR-TEST-EXISTS                VALUE 'Y'.             
P00251     05  WS-END-OF-REGISTERS     PIC X(01) VALUE ' '.             
P00251         88 END-OF-REGISTERS               VALUE 'Y'.             
      *                                                                         
       01  WS-SQLSTATE                 PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-LOCATION-AT-CUSTOMER PIC X(1) VALUE 'J'.              
           05  WS-LOCATION-ATTACHED    PIC X(1) VALUE 'K'.              
P00251     05  WS-ONE                  PIC 9(1) VALUE 1.                
P00447     05  WS-ZERO                 PIC 9(1) VALUE 0.                
P00251     05  WS-YES                  PIC X(1) VALUE 'Y'.              
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIPMENT, EQ                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_METER, EM                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MTR_CAP, MC                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_MTR_SPEC, U5                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRSP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_EQUIP_MAKE, M2                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQMAKE                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_METER_ATTCHMTS, MA                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MOVEMENT_HIST, MV                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMVHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ELEC_MTR_TEST, ET                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_CUST_PREM_HIST, CH                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ACCOUNT, AT                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MNT_TRANS_HIST, MH                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_MT_TRN_HST_DET, MI                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
P00251******************************************************************        
P00251* CSS_METER_PGM, O8                                              *        
P00251******************************************************************        
P00251     EXEC SQL                                                             
P00251        INCLUDE TBMTRPGM                                                  
P00251     END-EXEC.                                                            
P00251*                                                                         
P00251******************************************************************        
P00251* CSS_MTR_RD_FMT, OA                                             *        
P00251******************************************************************        
P00251     EXEC SQL                                                             
P00251        INCLUDE TBRDFMT                                                   
P00251     END-EXEC.                                                            
P00251*                                                                         
P00251******************************************************************        
P00251* CSS_ELEC_CL_SPEC, U0                                           *        
P00251******************************************************************        
P00251     EXEC SQL                                                             
P00251         INCLUDE TBELCLSP                                                 
P00251     END-EXEC.                                                            
P00251*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
P00251*----------------------------------------------------------------*        
P00251* Cursor to get REG_ID_NO and CODE_CAP_TYPE from CSS_MTR_RD_FMT           
P00251* Cursor modified to remove duplicates for the same register.             
P00251*----------------------------------------------------------------*        
P00251     EXEC SQL                                                     
P00251         DECLARE READ_FMT_CSR CURSOR FOR                          
P00251             SELECT MAX(OA.CODE_CAP_TYPE)                         
P00251                   ,OA.REG_ID_NO                                  
P00251                   ,MAX(OA.NO_READ_DIGITS)                        
P00251                   ,MAX(OA.MTR_RD_DISP_CD)                        
P00251             FROM   CSS_MTR_RD_FMT OA WITH(READUNCOMMITTED)               
P00251             WHERE OA.CODE_UTIL_TYPE   =  :OA-CODE-UTIL-TYPE      
P00251             AND OA.DIGTL_MTR_TYPE     =  :OA-DIGTL-MTR-TYPE      
P00251             AND OA.PROGRAM_ID         =  :OA-PROGRAM-ID          
P00251             AND OA.MTR_READ_SOURCE_CD =  :OA-MTR-READ-SOURCE-CD  
P00251             AND OA.REMOTE_READ_IND    =  :OA-REMOTE-READ-IND     
P00251             AND OA.CODE_TOU_SEASN     =  'C'                     
P00251             AND OA.SO_REGISTER_CD     <> 'S'                     
P00251             GROUP BY OA.REG_ID_NO                                
P00251             ORDER BY OA.REG_ID_NO                                
P00251             FOR READ ONLY                                
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE READ_FMT_CSR CURSOR FOR                                  
MFA-TR*            SELECT MAX(OA.CODE_CAP_TYPE)                                 
MFA-TR*                  ,OA.REG_ID_NO                                          
MFA-TR*                  ,MAX(OA.NO_READ_DIGITS)                                
MFA-TR*                  ,MAX(OA.MTR_RD_DISP_CD)                                
MFA-TR*            FROM   CSS_MTR_RD_FMT OA                                     
MFA-TR*            WHERE OA.CODE_UTIL_TYPE   =  :OA-CODE-UTIL-TYPE              
MFA-TR*            AND OA.DIGTL_MTR_TYPE     =  :OA-DIGTL-MTR-TYPE              
MFA-TR*            AND OA.PROGRAM_ID         =  :OA-PROGRAM-ID                  
MFA-TR*            AND OA.MTR_READ_SOURCE_CD =  :OA-MTR-READ-SOURCE-CD          
MFA-TR*            AND OA.REMOTE_READ_IND    =  :OA-REMOTE-READ-IND             
MFA-TR*            AND OA.CODE_TOU_SEASN     =  'C'                             
MFA-TR*            AND OA.SO_REGISTER_CD     <> 'S'                             
MFA-TR*            GROUP BY OA.REG_ID_NO                                        
MFA-TR*            ORDER BY OA.REG_ID_NO                                        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7160                                                 
MFA-TR*    END-EXEC.                                                            
P00251*                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-UPDATE-IND             PIC X(01).                       
COB305 01 PARM-AMPS        PIC S9(2)V9(1) USAGE COMP-3 VALUE 0.     
       01  PARM-CODE-ATTACHMENTS       PIC X(06).                       
       01  PARM-CODE-CRNT-LOC          PIC X(01).                       
       01  PARM-CODE-GEAR-REDUCTN      PIC X(01).                       
       01  PARM-CODE-MAKE              PIC X(02).                       
       01  PARM-CODE-METER-TYPE        PIC X(01).                       
       01  PARM-CODE-UTIL-TYPE         PIC X(01).                       
       01  PARM-COMPANY-NO             PIC X(02).                       
       01  PARM-DATE-LAST-MOVE         PIC X(10).                       
       01  PARM-DATE-LAST-TRAN         PIC X(10).                       
       01  PARM-DATE-PURCHASED         PIC X(10).                       
       01  PARM-DEVICE-TYPE-CD         PIC X(01).                       
       01  PARM-DIGTL-MTR-TYPE         PIC X(03).                       
       01  PARM-ELEC-MTR-CLASS-CD      PIC X(02).                       
       01  PARM-ELEC-MTR-SPEC-CD       PIC X(03).                       
       01  PARM-EQUIP-COMMENTS-TX      PIC X(255).                      
       01  PARM-EQUIP-TYPE-CD          PIC X(01).                       
       01  PARM-IDR-MEMORY-SIZE        PIC X(02).                       
COB305 01 PARM-KH-OR-KE        PIC S9(05)V9(4) COMP-3 VALUE 0.          
       01  PARM-LOCAL-OFFICE           PIC X(03).                       
       01  PARM-METER-NO               PIC X(09).                       
       01  PARM-MTR-CONNECT-TYP-ID     PIC X(10).                       
       01  PARM-NO-PHASES              PIC X(01).                       
       01  PARM-NO-WIRES               PIC X(01).                       
       01  PARM-PALETTE-NO             PIC X(04).                       
       01  PARM-PROGRAM-ID             PIC X(02).                       
COB305 01 PARM-PULSES-PER-REV        PIC S9(01)V9(3) COMP-3 VALUE 0.          
       01  PARM-REG-LOWER-FRACTION     PIC S9(4) COMP.                  
       01  PARM-REG-NO                 PIC S9(9) COMP.                  
       01  PARM-REG-UPPER-FRACTION     PIC S9(4) COMP.                  
       01  PARM-SERIAL-NO              PIC X(11).                       
       01  PARM-SOLID-ST-DIP-SET       PIC S9(4) COMP.                  
       01  PARM-TEST-SCHED-CD          PIC X(01).                       
       01  PARM-TOU-RATE-IND           PIC S9(4) COMP.                  
       01  PARM-VOLTAGE                PIC S9(4) COMP.                  
       01  PARM-WARRANTY-EXP-DT        PIC X(10).                       
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-MTR-CAP-INFO-01        PIC X(31).                       
       01  PARM-MTR-CAP-INFO-02        PIC X(31).                       
       01  PARM-MTR-CAP-INFO-03        PIC X(31).                       
       01  PARM-MTR-CAP-INFO-04        PIC X(31).                       
       01  PARM-MTR-CAP-INFO-05        PIC X(31).                       
       01  PARM-MTR-CAP-INFO-06        PIC X(31).                       
      *                                                                         
       PROCEDURE DIVISION USING   PARM-UPDATE-IND                       
                                , PARM-AMPS                             
                                , PARM-CODE-ATTACHMENTS                 
                                , PARM-CODE-CRNT-LOC                    
                                , PARM-CODE-GEAR-REDUCTN                
                                , PARM-CODE-MAKE                        
                                , PARM-CODE-METER-TYPE                  
                                , PARM-CODE-UTIL-TYPE                   
                                , PARM-COMPANY-NO                       
                                , PARM-DATE-LAST-MOVE                   
                                , PARM-DATE-LAST-TRAN                   
                                , PARM-DATE-PURCHASED                   
                                , PARM-DEVICE-TYPE-CD                   
                                , PARM-DIGTL-MTR-TYPE                   
                                , PARM-ELEC-MTR-CLASS-CD                
                                , PARM-ELEC-MTR-SPEC-CD                 
                                , PARM-EQUIP-COMMENTS-TX                
                                , PARM-EQUIP-TYPE-CD                    
                                , PARM-IDR-MEMORY-SIZE                  
                                , PARM-KH-OR-KE                         
                                , PARM-LOCAL-OFFICE                     
                                , PARM-METER-NO                         
                                , PARM-MTR-CONNECT-TYP-ID               
                                , PARM-NO-PHASES                        
                                , PARM-NO-WIRES                         
                                , PARM-PALETTE-NO                       
                                , PARM-PROGRAM-ID                       
                                , PARM-PULSES-PER-REV                   
                                , PARM-REG-LOWER-FRACTION               
                                , PARM-REG-NO                           
                                , PARM-REG-UPPER-FRACTION               
                                , PARM-SERIAL-NO                        
                                , PARM-SOLID-ST-DIP-SET                 
                                , PARM-TEST-SCHED-CD                    
                                , PARM-TOU-RATE-IND                     
                                , PARM-VOLTAGE                          
                                , PARM-WARRANTY-EXP-DT                  
                                , PARM-USER-ID                          
                                , PARM-MTR-CAP-INFO-01                  
                                , PARM-MTR-CAP-INFO-02                  
                                , PARM-MTR-CAP-INFO-03                  
                                , PARM-MTR-CAP-INFO-04                  
                                , PARM-MTR-CAP-INFO-05                  
                                , PARM-MTR-CAP-INFO-06.                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                  :S-RETURN-CODE AS RETURN_CODE                         
              FROM                                                      
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*           :S-RETURN-CODE AS RETURN_CODE                                 
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           PERFORM 7100-SELECT-CURR-DATE    THRU 7100-EXIT              
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-UPDATE-IND             TO WS-UPDATE-IND-SW         
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS                        
                                            THRU 1200-EXIT              
           MOVE PARM-AMPS                   TO EM-AMPS                  
           MOVE PARM-CODE-ATTACHMENTS       TO EM-CODE-ATTACHMENTS      
           MOVE PARM-CODE-CRNT-LOC          TO EQ-CODE-CRNT-LOC         
           MOVE PARM-CODE-GEAR-REDUCTN      TO EM-CODE-GEAR-REDUCTN     
           MOVE PARM-CODE-MAKE              TO EQ-CODE-MAKE             
           MOVE PARM-CODE-METER-TYPE        TO EM-CODE-METER-TYPE       
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO EM-CODE-UTIL-TYPE        
                                               EQ-CODE-UTIL-TYPE        
                                               MA-CODE-UTIL-TYPE        
                                               MV-CODE-UTIL-TYPE        
                                               ET-CODE-UTIL-TYPE        
                                               MC-CODE-UTIL-TYPE        
P00251                                         OA-CODE-UTIL-TYPE        
P00251                                         O8-CODE-UTIL-TYPE.       
                                                                        
           MOVE PARM-COMPANY-NO             TO EM-COMPANY-NO            
                                               EQ-COMPANY-NO            
                                               MA-COMPANY-NO            
                                               MV-COMPANY-NO            
                                               ET-COMPANY-NO            
                                               MC-COMPANY-NO            
                                                                        
           PERFORM 1100-PROCESS-NULL-INPUTS THRU 1100-EXIT              
                                                                        
           MOVE PARM-DEVICE-TYPE-CD         TO EM-DEVICE-TYPE-CD        
                                               MV-CODE-DEVICE-TYPE      
           MOVE PARM-DIGTL-MTR-TYPE         TO EM-DIGTL-MTR-TYPE        
P00251                                         O8-DIGTL-MTR-TYPE        
P00251                                         OA-DIGTL-MTR-TYPE.       
           MOVE PARM-ELEC-MTR-CLASS-CD      TO EM-ELEC-MTR-CLASS-CD     
P00251                                         U0-ELEC-MTR-CLASS-CD.    
           MOVE PARM-ELEC-MTR-SPEC-CD       TO EM-ELEC-MTR-SPEC-CD      
                                               U5-ELEC-MTR-SPEC-CD      
P00251                                         U0-ELEC-MTR-SPEC-CD.     
                                                                        
           MOVE PARM-EQUIP-COMMENTS-TX      TO EQ-EQUIP-COMMENTS-TX-TEXT
           MOVE LENGTH OF PARM-EQUIP-COMMENTS-TX                        
                                            TO EQ-EQUIP-COMMENTS-TX-LEN 
                                                                        
           MOVE PARM-EQUIP-TYPE-CD          TO EQ-EQUIP-TYPE-CD         
           MOVE PARM-IDR-MEMORY-SIZE        TO EM-IDR-MEMORY-SIZE       
           MOVE PARM-KH-OR-KE               TO EM-KH-OR-KE              
           MOVE PARM-LOCAL-OFFICE           TO EQ-LOCAL-OFFICE          
           MOVE PARM-METER-NO               TO EM-METER-NO              
                                               MA-METER-NO              
                                               ET-METER-NO              
                                               MC-METER-NO              
                                               EQ-DEVICE-NO             
                                               MV-DEVICE-NO             
                                                                        
           MOVE PARM-MTR-CONNECT-TYP-ID     TO EM-MTR-CONNECT-TYP-ID    
           MOVE PARM-NO-PHASES              TO EM-NO-PHASES             
           MOVE PARM-NO-WIRES               TO EM-NO-WIRES              
           MOVE PARM-PALETTE-NO             TO EQ-PALETTE-NO            
           MOVE PARM-PROGRAM-ID             TO EM-PROGRAM-ID            
P00251                                         O8-PROGRAM-ID            
P00251                                         OA-PROGRAM-ID.           
           MOVE PARM-PULSES-PER-REV         TO EM-PULSES-PER-REV        
           MOVE PARM-REG-LOWER-FRACTION     TO EM-REG-LOWER-FRACTION    
           MOVE PARM-REG-UPPER-FRACTION     TO EM-REG-UPPER-FRACTION    
           MOVE PARM-REG-NO                 TO EM-REG-NO                
           MOVE PARM-SERIAL-NO              TO EQ-SERIAL-NO             
           MOVE PARM-SOLID-ST-DIP-SET       TO EM-SOLID-ST-DIP-SET      
           MOVE PARM-TEST-SCHED-CD          TO EM-TEST-SCHED-CD         
           MOVE PARM-TOU-RATE-IND           TO EM-TOU-RATE-IND          
           MOVE PARM-VOLTAGE                TO EM-VOLTAGE               
           MOVE PARM-MTR-CAP-INFO-01        TO WS-MTR-CAP-INFO(1)       
           MOVE PARM-MTR-CAP-INFO-02        TO WS-MTR-CAP-INFO(2)       
           MOVE PARM-MTR-CAP-INFO-03        TO WS-MTR-CAP-INFO(3)       
           MOVE PARM-MTR-CAP-INFO-04        TO WS-MTR-CAP-INFO(4)       
           MOVE PARM-MTR-CAP-INFO-05        TO WS-MTR-CAP-INFO(5)       
           MOVE PARM-MTR-CAP-INFO-06        TO WS-MTR-CAP-INFO(6)       
                                                                        
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1100-PROCESS-NULL-INPUTS.                                      *        
      ******************************************************************        
       1100-PROCESS-NULL-INPUTS.                                        
                                                                        
           IF PARM-DATE-LAST-MOVE = SPACES                              
              MOVE -1                       TO WS-LAST-MOVE-NULL-IND    
           ELSE                                                         
              MOVE 0                        TO WS-LAST-MOVE-NULL-IND    
              MOVE PARM-DATE-LAST-MOVE      TO EQ-DATE-LAST-MOVE        
           END-IF                                                       
                                                                        
           IF PARM-DATE-LAST-TRAN = SPACES                              
              MOVE -1                       TO WS-LAST-TRAN-NULL-IND    
           ELSE                                                         
              MOVE 0                        TO WS-LAST-TRAN-NULL-IND    
              MOVE PARM-DATE-LAST-TRAN      TO EQ-DATE-LAST-TRAN        
           END-IF                                                       
                                                                        
           IF PARM-DATE-PURCHASED = SPACES                              
              MOVE -1                       TO WS-PURCHASED-NULL-IND    
           ELSE                                                         
              MOVE 0                        TO WS-PURCHASED-NULL-IND    
              MOVE PARM-DATE-PURCHASED      TO EQ-DATE-PURCHASED        
           END-IF                                                       
                                                                        
           IF PARM-WARRANTY-EXP-DT = SPACES                             
              MOVE -1                       TO WS-WAR-EXP-DT-NULL-IND   
           ELSE                                                         
              MOVE 0                        TO WS-WAR-EXP-DT-NULL-IND   
              MOVE PARM-WARRANTY-EXP-DT     TO EQ-WARRANTY-EXP-DT       
           END-IF                                                       
                                                                        
           .                                                            
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-COMPANY-NO     = SPACES OR                           
              PARM-CODE-UTIL-TYPE = SPACES OR                           
              ( NOT WS-INSERT-I AND NOT WS-UPDATE-U AND                 
                NOT WS-DELETE-D )                                       
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'N/A'                    TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-2          
              MOVE 'PARM-UPDATE-IND'        TO TABLE-ELEMENT-3          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2        
              MOVE PARM-UPDATE-IND          TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH         
                                                                        
           PERFORM 2100-BUILD-RESULT        THRU 2100-EXIT              
           PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT             
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-BUILD-RESULT.                                             *        
      ******************************************************************        
       2100-BUILD-RESULT.                                               
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-INSERT-I                                          
                 PERFORM 2200-INSERT-PROCESS THRU 2200-EXIT             
              WHEN WS-DELETE-D                                          
                 PERFORM 2300-DELETE-PROCESS THRU 2300-EXIT             
              WHEN WS-UPDATE-U                                          
                 PERFORM 2400-UPDATE-PROCESS THRU 2400-EXIT             
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-INSERT-PROCESS.                                           *        
      ******************************************************************        
       2200-INSERT-PROCESS.                                             
                                                                        
           PERFORM 7200-CHECK-METER-EXIST   THRU 7200-EXIT.             
                                                                        
           IF METER-EXISTS                                              
              MOVE    5100                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 7220-CHECK-EQUIP-EXIST   THRU 7220-EXIT.             
                                                                        
           IF EQUIP-EXISTS                                              
              MOVE    5200                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 7260-CHECK-MTR-ID-EXIST  THRU 7260-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              U5-METER-SIZE-ID  NOT = SPACES                            
              MOVE U5-METER-SIZE-ID         TO EM-METER-SIZE-ID         
           ELSE                                                         
              MOVE    5400                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 8200-INSERT-EQUIPMENT    THRU 8200-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
              PERFORM 8220-INSERT-METER     THRU 8220-EXIT              
                                                                        
P00251        PERFORM 7190-SELECT-FULL-SCALE                            
P00251                                      THRU 7190-EXIT              
P00251        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00251           MOVE 5600                  TO S-RETURN-CODE            
P00251           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
P00251           PERFORM 9000-SEND-ERROR-RESULT                         
P00251                                      THRU 9000-EXIT              
P00251           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT              
P00251        END-IF                                                    
P00251                                                                  
P00251        MOVE U0-FULL-SCALE            TO MC-FULL-SCALE            
P00447                                                                  
P00447        IF U0-CT-METER-FL = 'Y' THEN                              
P00447           MOVE WS-ZERO               TO MC-CONSTANT              
P00447        ELSE                                                      
P00447           MOVE WS-ONE                TO MC-CONSTANT              
P00447        END-IF                                                    
P00251                                                                  
P00251        PERFORM 7150-SELECT-METER-PGM                             
P00251                                      THRU 7150-EXIT              
P00251        MOVE O8-DFLT-REMOTE-RD-IND    TO OA-REMOTE-READ-IND       
P00251        MOVE O8-DEF-RD-SOURCE-CD      TO OA-MTR-READ-SOURCE-CD    
P00251                                                                  
P00251        PERFORM 7160-OPEN-READ-FMT-CSR                            
P00251                                      THRU 7160-EXIT              
P00251        MOVE SPACE                    TO WS-END-OF-REGISTERS      
P00251        PERFORM 7170-FETCH-READ-FMT-CSR                           
P00251                                      THRU 7170-EXIT              
P00251        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
P00251           PERFORM UNTIL END-OF-REGISTERS                         
P00251             IF OA-REG-ID-NO > 0 AND                              
P00251                OA-REG-ID-NO NOT = WS-PREV-REG-ID-NO              
P00251                MOVE OA-CODE-CAP-TYPE       TO MC-CODE-CAP-TYPE   
P00251                MOVE OA-REG-ID-NO           TO MC-REG-ID-NO       
P00251                MOVE OA-NO-READ-DIGITS      TO MC-NO-READ-DIALS   
P00251                                               MC-NO-DIALS        
P00251                MOVE OA-MTR-RD-DISP-CD      TO MC-REG-MEASURES-CD 
P00251                PERFORM 8240-INSERT-MTR-CAP THRU 8240-EXIT        
P00251             END-IF                                               
P00251             PERFORM 7170-FETCH-READ-FMT-CSR THRU 7170-EXIT       
P00251           END-PERFORM                                            
P00251        ELSE                                                      
P00251           MOVE 5500                        TO S-RETURN-CODE      
P00251           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT        
P00251           PERFORM 9000-SEND-ERROR-RESULT                         
P00251                                            THRU 9000-EXIT        
P00251           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
P00251        END-IF                                                    
P00251                                                                  
P00251        PERFORM 7180-CLOSE-READ-FMT-CSR THRU 7180-EXIT            
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-DELETE-PROCESS.                                           *        
      ******************************************************************        
       2300-DELETE-PROCESS.                                             
                                                                        
           PERFORM 7300-CHECK-MTR-LOCATION  THRU 7300-EXIT              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF (EQ-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER OR         
                                     WS-LOCATION-ATTACHED)              
                 MOVE    5100               TO S-RETURN-CODE            
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
                 PERFORM 9999-END-PROGRAM   THRU 9999-EXIT              
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7320-CHECK-ATTACHMTS     THRU 7320-EXIT              
                                                                        
           IF ATTACHMTS-EXISTS                                          
              MOVE    5200                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF                                                       
                                                                        
           PERFORM 7340-CHECK-MOVE-HIST     THRU 7340-EXIT              
                                                                        
           IF MOVE-HIST-EXISTS                                          
              MOVE    5300                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF                                                       
                                                                        
           PERFORM 7360-CHECK-MTR-TEST      THRU 7360-EXIT              
                                                                        
           IF MTR-TEST-EXISTS                                           
              MOVE    5400                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF                                                       
                                                                        
           PERFORM 8300-DELETE-METER        THRU 8300-EXIT              
           PERFORM 8320-DELETE-MTRCAP       THRU 8320-EXIT              
           PERFORM 8340-DELETE-EQUIPMNT     THRU 8340-EXIT              
                                                                        
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-UPDATE-PROCESS.                                           *        
      ******************************************************************        
      *                                                                         
       2400-UPDATE-PROCESS.                                             
                                                                        
           PERFORM 7260-CHECK-MTR-ID-EXIST  THRU 7260-EXIT              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
              U5-METER-SIZE-ID  NOT = SPACES                            
              MOVE U5-METER-SIZE-ID         TO EM-METER-SIZE-ID         
           ELSE                                                         
              MOVE    5400                  TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF                                                       
                                                                        
           PERFORM 7400-SELECT-EQUIP-DETAIL THRU 7400-EXIT              
           IF EM-DATE-LAST-TESTED = SPACES                              
              MOVE WS-CURRENT-DATE          TO EM-DATE-LAST-TESTED      
           END-IF                                                       
                                                                        
           PERFORM 8400-UPDATE-EQUIPMNT     THRU 8400-EXIT              
           PERFORM 8420-UPDATE-METER        THRU 8420-EXIT              
           PERFORM 8320-DELETE-MTRCAP       THRU 8320-EXIT              
                                                                        
P00251     PERFORM 7190-SELECT-FULL-SCALE   THRU 7190-EXIT              
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
P00251        MOVE 5600                     TO S-RETURN-CODE            
P00251        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
P00251        PERFORM 9000-SEND-ERROR-RESULT                            
P00251                                      THRU 9000-EXIT              
P00251        PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
P00251     END-IF                                                       
P00251                                                                  
P00251     MOVE U0-FULL-SCALE               TO MC-FULL-SCALE            
P00251                                                                  
P00251     PERFORM 7150-SELECT-METER-PGM    THRU 7150-EXIT.             
P00251     MOVE O8-DFLT-REMOTE-RD-IND       TO OA-REMOTE-READ-IND.      
P00251     MOVE O8-DEF-RD-SOURCE-CD         TO OA-MTR-READ-SOURCE-CD.   
P00251                                                                  
P00251     PERFORM 7160-OPEN-READ-FMT-CSR   THRU 7160-EXIT.             
P00251     MOVE SPACE                       TO WS-END-OF-REGISTERS.     
P00251     PERFORM 7170-FETCH-READ-FMT-CSR  THRU 7170-EXIT.             
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00251        PERFORM UNTIL END-OF-REGISTERS                            
P00251           PERFORM 5000-SET-METER-CAP THRU 5000-EXIT              
P00251        END-PERFORM                                               
P00251     ELSE                                                         
P00251        MOVE 5500                     TO S-RETURN-CODE            
P00251        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
P00251        PERFORM 9000-SEND-ERROR-RESULT                            
P00251                                      THRU 9000-EXIT              
P00251        PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
P00251     END-IF.                                                      
P00251                                                                  
P00251     PERFORM 7180-CLOSE-READ-FMT-CSR  THRU 7180-EXIT.             
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-SET-METER-CAP.                                            *        
      ******************************************************************        
       5000-SET-METER-CAP.                                              
                                                                        
P00251     IF OA-REG-ID-NO > 0 AND                                      
P00251        OA-REG-ID-NO NOT = WS-PREV-REG-ID-NO                      
P00251                                                                  
P00251        MOVE OA-CODE-CAP-TYPE        TO MC-CODE-CAP-TYPE          
P00251        MOVE OA-REG-ID-NO            TO MC-REG-ID-NO              
P00251        MOVE OA-NO-READ-DIGITS       TO MC-NO-READ-DIALS          
P00251                                        MC-NO-DIALS               
P00251        MOVE OA-MTR-RD-DISP-CD       TO MC-REG-MEASURES-CD        
P00251                                                                  
P00251        MOVE WS-MTR-CAP-INFO(1)      TO WS-TMP-CAP-INFO           
P00251        MOVE WS-TMP-CAP-INFO(10:9)   TO WS-CONSTANT               
P00251        MOVE WS-CONSTANT-RED         TO MC-CONSTANT               
P00251                                                                  
P00251        PERFORM 8240-INSERT-MTR-CAP THRU 8240-EXIT                
P00251                                                                  
P00251        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
P00251           EQ-CODE-CRNT-LOC = WS-LOCATION-AT-CUSTOMER             
P00251                                                                  
P00251           MOVE EQ-CRNT-LOC-NO       TO CH-PREMISE-NO             
P00251           PERFORM 7410-SELECT-ACCOUNT-DETAIL                     
P00251                                     THRU 7410-EXIT               
P00251           PERFORM 5120-SET-TRANS-HIST THRU 5120-EXIT             
P00251           PERFORM 6530-LOAD-MNT-TRANS-HIST                       
P00251                                     THRU 6530-EXIT               
P00251        END-IF                                                    
P00251                                                                  
P00251     END-IF.                                                      
P00251                                                                  
P00251     PERFORM 7170-FETCH-READ-FMT-CSR THRU 7170-EXIT.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5120-SET-TRANS-HIST.                                           *        
      ******************************************************************        
      *                                                                         
       5120-SET-TRANS-HIST.                                             
                                                                        
           PERFORM 7100-SELECT-CURR-DATE     THRU 7100-EXIT             
      ** DATA FOR CSS_MNT_TRANS_HIST                                            
           MOVE WS-CURRENT-TIMESTAMP         TO MH-TRANS-HIST-SEQ-NO    
           MOVE WS-CURRENT-DATE              TO MH-DATE-TRANS           
           MOVE 'F'                          TO MH-CODE-TRAN-TYPE       
           MOVE 293                          TO MH-RESP-AREA-ID         
           MOVE CH-ACCOUNT-NO                TO MH-ACCOUNT-NO           
           MOVE AT-CUSTOMER-NO               TO MH-CUSTOMER-NO          
           MOVE EQ-CRNT-LOC-NO               TO MH-PREMISE-NO           
           MOVE PARM-USER-ID                 TO MH-USER-ID              
P00251     MOVE PROGRAM-NAME                 TO MH-APPL-PROGRAM-ID      
           MOVE +0                           TO MH-ENTITY-KEY-DESC-LEN  
           MOVE SPACES                       TO MH-ENTITY-KEY-DESC-TEXT 
                                                                        
           MOVE EM-METER-NO                  TO WS-TRNS-METER-NO        
                                                                        
           EVALUATE MC-CODE-CAP-TYPE                                    
               WHEN 'A'                                                 
                   MOVE 'KWH'                TO WS-TRNS-CODE-CAP-DESC   
               WHEN 'B'                                                 
                   MOVE 'KW'                 TO WS-TRNS-CODE-CAP-DESC   
               WHEN 'C'                                                 
                   MOVE 'KVR'                TO WS-TRNS-CODE-CAP-DESC   
               WHEN 'D'                                                 
                   MOVE 'QHR'                TO WS-TRNS-CODE-CAP-DESC   
               WHEN 'E'                                                 
                   MOVE 'KVA'                TO WS-TRNS-CODE-CAP-DESC   
               WHEN OTHER                                               
                   MOVE SPACES               TO WS-TRNS-CODE-CAP-DESC   
           END-EVALUATE                                                 
                                                                        
           MOVE WS-TANS-COMM-TMP             TO MH-TRAN-COMMENT-TEXT    
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                             TO MH-TRAN-COMMENT-LEN     
                                                                        
      ** DATA FOR CSS_MT_TRN_HST_DET                                            
           MOVE WS-CURRENT-TIMESTAMP         TO MI-TRANS-HIST-SEQ-NO    
           MOVE 1                            TO MI-TRAN-APPL-NO         
           MOVE 'CAPABILITY'                 TO MI-COLUMN-DESC          
           MOVE SPACES                       TO MI-TABLE-ID             
           MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
                                                                        
           MOVE MC-CONSTANT                  TO WS-CHG-CONSTANT         
           MOVE MC-NO-DIALS                  TO WS-CHG-NO-DIALS         
           MOVE MC-NO-READ-DIALS             TO WS-CHG-NO-READ-DIALS    
                                                                        
           MOVE WS-CHG-COMM-TXT              TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN.
                                                                        
       5120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-CURR-DATE.                                         *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-CURR-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CHECK-METER-EXIST.                                        *        
      ******************************************************************        
       7200-CHECK-METER-EXIST.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-METER-EXISTS                                   
                FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                       
               WHERE COMPANY_NO     = :EM-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                
                 AND METER_NO       = :EM-METER-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-METER-EXISTS                                           
MFA-TR*         FROM CSS_ELEC_METER                                             
MFA-TR*        WHERE COMPANY_NO     = :EM-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                        
MFA-TR*          AND METER_NO       = :EM-METER-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_METER'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EM-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7220-CHECK-EQUIP-EXIST.                                        *        
      ******************************************************************        
       7220-CHECK-EQUIP-EXIST.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-EQUIP-EXISTS                                   
                FROM CSS_EQUIPMENT WITH(READUNCOMMITTED)                        
               WHERE COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-EQUIP-EXISTS                                           
MFA-TR*         FROM CSS_EQUIPMENT                                              
MFA-TR*        WHERE COMPANY_NO     = :EQ-COMPANY-NO                            
MFA-TR*          AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                        
MFA-TR*          AND DEVICE_NO      = :EQ-DEVICE-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7260-CHECK-MTR-ID-EXIST.                                       *        
      ******************************************************************        
       7260-CHECK-MTR-ID-EXIST.                                         
                                                                        
           EXEC SQL                                                     
              SELECT U5.METER_SIZE_ID                                   
                INTO :U5-METER-SIZE-ID                                  
                FROM CSS_ELEC_MTR_SPEC U5 WITH(READUNCOMMITTED)                 
               WHERE U5.ELEC_MTR_SPEC_CD = :U5-ELEC-MTR-SPEC-CD         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT U5.METER_SIZE_ID                                           
MFA-TR*         INTO :U5-METER-SIZE-ID                                          
MFA-TR*         FROM CSS_ELEC_MTR_SPEC U5                                       
MFA-TR*        WHERE U5.ELEC_MTR_SPEC_CD = :U5-ELEC-MTR-SPEC-CD                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7260'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ELEC_MTR_SPEC'     TO TABLE-1                  
               MOVE 'CSS_EQUIP_MAKE'        TO TABLE-2                  
               MOVE 'ELEC_MTR_SPEC_CD'      TO TABLE-ELEMENT-1          
               MOVE U5-ELEC-MTR-SPEC-CD     TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CHECK-MTR-LOCATION.                                       *        
      ******************************************************************        
       7300-CHECK-MTR-LOCATION.                                         
                                                                        
           EXEC SQL                                                     
              SELECT EQ.CODE_CRNT_LOC                                   
                INTO :EQ-CODE-CRNT-LOC                                  
                FROM CSS_EQUIPMENT  AS EQ WITH(READUNCOMMITTED)                 
               WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                 
                 AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE             
                 AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQ.CODE_CRNT_LOC                                           
MFA-TR*         INTO :EQ-CODE-CRNT-LOC                                          
MFA-TR*         FROM CSS_EQUIPMENT  AS EQ                                       
MFA-TR*        WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                         
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7300'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_EQUIPMENT'        TO TABLE-1                   
               MOVE 'CSS_ELEC_METER'       TO TABLE-2                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-3           
               MOVE EQ-COMPANY-NO          TO HOSTVAR-ELEMENT-1         
               MOVE EQ-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2         
               MOVE EQ-DEVICE-NO           TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-CHECK-ATTACHMTS.                                          *        
      ******************************************************************        
       7320-CHECK-ATTACHMTS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                 :WS-ATTACHMTS-EXISTS                                   
              FROM                                                      
                  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                   
              WHERE                                                     
                  MA.METER_NO       = :MA-METER-NO                      
              AND MA.COMPANY_NO     = :MA-COMPANY-NO                    
              AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          'Y'                                                            
MFA-TR*       INTO                                                              
MFA-TR*          :WS-ATTACHMTS-EXISTS                                           
MFA-TR*       FROM                                                              
MFA-TR*           CSS_METER_ATTCHMTS MA                                         
MFA-TR*       WHERE                                                             
MFA-TR*           MA.METER_NO       = :MA-METER-NO                              
MFA-TR*       AND MA.COMPANY_NO     = :MA-COMPANY-NO                            
MFA-TR*       AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE                        
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7320'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_METER_ATTCHMTS'                                
                                           TO TABLE-1                   
               MOVE 'METER_NO'             TO TABLE-ELEMENT-1           
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-2           
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3           
               MOVE MA-METER-NO            TO HOSTVAR-ELEMENT-1         
               MOVE MA-COMPANY-NO          TO HOSTVAR-ELEMENT-2         
               MOVE MA-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7340-CHECK-MOVE-HIST.                                          *        
      ******************************************************************        
       7340-CHECK-MOVE-HIST.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                  :WS-MOVE-HIST-EXISTS                                  
              FROM                                                      
                  CSS_MOVEMENT_HIST MV WITH(READUNCOMMITTED)                    
              WHERE                                                     
                  MV.COMPANY_NO       = :MV-COMPANY-NO                  
              AND MV.CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE            
              AND MV.CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE              
              AND MV.DEVICE_NO        = :MV-DEVICE-NO                   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           'Y'                                                           
MFA-TR*       INTO                                                              
MFA-TR*           :WS-MOVE-HIST-EXISTS                                          
MFA-TR*       FROM                                                              
MFA-TR*           CSS_MOVEMENT_HIST MV                                          
MFA-TR*       WHERE                                                             
MFA-TR*           MV.COMPANY_NO       = :MV-COMPANY-NO                          
MFA-TR*       AND MV.CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE                    
MFA-TR*       AND MV.CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE                      
MFA-TR*       AND MV.DEVICE_NO        = :MV-DEVICE-NO                           
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7340'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_MOVEMENT_HIST'    TO TABLE-1                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'CODE_DEVICE_TYPE'     TO TABLE-ELEMENT-2           
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-3           
               MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-4           
               MOVE MV-COMPANY-NO          TO HOSTVAR-ELEMENT-1         
               MOVE MV-CODE-DEVICE-TYPE    TO HOSTVAR-ELEMENT-2         
               MOVE MV-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-3         
               MOVE MV-DEVICE-NO           TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7360-CHECK-MTR-TEST.                                           *        
      ******************************************************************        
       7360-CHECK-MTR-TEST.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                  :WS-MTR-TEST-EXISTS                                   
              FROM                                                      
                  CSS_ELEC_MTR_TEST ET WITH(READUNCOMMITTED)                    
              WHERE                                                     
                  ET.COMPANY_NO       = :ET-COMPANY-NO                  
              AND ET.CODE_UTIL_TYPE   = :ET-CODE-UTIL-TYPE              
              AND ET.METER_NO         = :ET-METER-NO                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           'Y'                                                           
MFA-TR*       INTO                                                              
MFA-TR*           :WS-MTR-TEST-EXISTS                                           
MFA-TR*       FROM                                                              
MFA-TR*           CSS_ELEC_MTR_TEST ET                                          
MFA-TR*       WHERE                                                             
MFA-TR*           ET.COMPANY_NO       = :ET-COMPANY-NO                          
MFA-TR*       AND ET.CODE_UTIL_TYPE   = :ET-CODE-UTIL-TYPE                      
MFA-TR*       AND ET.METER_NO         = :ET-METER-NO                            
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7360'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_MOVEMENT_HIST'    TO TABLE-1                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE 'METER_NO'             TO TABLE-ELEMENT-3           
               MOVE ET-COMPANY-NO          TO HOSTVAR-ELEMENT-1         
               MOVE ET-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2         
               MOVE ET-METER-NO            TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-SELECT-EQUIP-DETAIL.                                      *        
      ******************************************************************        
       7400-SELECT-EQUIP-DETAIL.                                        
                                                                        
           MOVE ZERO                        TO WS-LAST-MOVE-NULL-IND    
                                                                        
           EXEC SQL                                                     
              SELECT EQ.LOCAL_OFFICE                                    
                    ,EQ.CRNT_LOC_NO                                     
                    ,EM.CODE_ATTACHMENTS                                
                    ,EM.DATE_LAST_TESTED                                
                                                                        
                INTO :EQ-LOCAL-OFFICE                                   
                    ,:EQ-CRNT-LOC-NO                                    
                    ,:EM-CODE-ATTACHMENTS                               
                    ,:EM-DATE-LAST-TESTED :WS-LAST-MOVE-NULL-IND         
                FROM     CSS_EQUIPMENT  AS EQ WITH(READUNCOMMITTED)             
              INNER JOIN CSS_ELEC_METER AS EM WITH(READUNCOMMITTED)             
                     ON (EM.COMPANY_NO     = EQ.COMPANY_NO              
                     AND EM.METER_NO       = EQ.DEVICE_NO               
                     AND EQ.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE)         
               WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                 
                 AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE             
                 AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EQ.LOCAL_OFFICE                                            
MFA-TR*             ,EQ.CRNT_LOC_NO                                             
MFA-TR*             ,EM.CODE_ATTACHMENTS                                        
MFA-TR*             ,EM.DATE_LAST_TESTED                                        
MFA-TR*                                                                         
MFA-TR*         INTO :EQ-LOCAL-OFFICE                                           
MFA-TR*             ,:EQ-CRNT-LOC-NO                                            
MFA-TR*             ,:EM-CODE-ATTACHMENTS                                       
MFA-TR*             ,:EM-DATE-LAST-TESTED:WS-LAST-MOVE-NULL-IND                 
MFA-TR*         FROM     CSS_EQUIPMENT  AS EQ                                   
MFA-TR*       INNER JOIN CSS_ELEC_METER AS EM                                   
MFA-TR*              ON (EM.COMPANY_NO     = EQ.COMPANY_NO                      
MFA-TR*              AND EM.METER_NO       = EQ.DEVICE_NO                       
MFA-TR*              AND EQ.CODE_UTIL_TYPE = EM.CODE_UTIL_TYPE)                 
MFA-TR*        WHERE EQ.COMPANY_NO     = :EQ-COMPANY-NO                         
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-LAST-MOVE-NULL-IND = -1                             
                 MOVE SPACES               TO EM-DATE-LAST-TESTED       
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7400'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_EQUIPMENT'        TO TABLE-1                   
               MOVE 'CSS_ELEC_METER'       TO TABLE-2                   
               MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1           
               MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2           
               MOVE 'DEVICE_NO'            TO TABLE-ELEMENT-3           
               MOVE EQ-COMPANY-NO          TO HOSTVAR-ELEMENT-1         
               MOVE EQ-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2         
               MOVE EQ-DEVICE-NO           TO HOSTVAR-ELEMENT-3         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7410-SELECT-ACCOUNT-DETAIL.                                    *        
      ******************************************************************        
      *                                                                         
       7410-SELECT-ACCOUNT-DETAIL.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CH.ACCOUNT_NO,
              AT.CUSTOMER_NO                                    
                 INTO :CH-ACCOUNT-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                 FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)               
                     ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE CH.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND CH.PREMISE_NO = :CH-PREMISE-NO                    
                ORDER BY CH.DATE_UTIL_SVC_STRT DESC                     
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CH.ACCOUNT_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*          INTO :CH-ACCOUNT-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_CUST_PREM_HIST CH                                     
MFA-TR*              ,CSS_ACCOUNT AT                                            
MFA-TR*         WHERE CH.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND CH.PREMISE_NO = :CH-PREMISE-NO                            
MFA-TR*         ORDER BY CH.DATE_UTIL_SVC_STRT DESC                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7410'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_CUST_PREM_HIST'    TO TABLE-1                  
               MOVE 'CSS_ACCOUNT'           TO TABLE-2                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE CH-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF                                                      
           .                                                            
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00251******************************************************************        
P00251* 7150-SELECT-METER-PGM                                          *        
P00251******************************************************************        
P00251*                                                                         
P00251 7150-SELECT-METER-PGM.                                           
P00251     EXEC SQL                                                     
P00251         SELECT O8.DEF_RD_SOURCE_CD                               
P00251               ,O8.DFLT_REMOTE_RD_IND                             
P00251           INTO :O8-DEF-RD-SOURCE-CD                              
P00251               ,:O8-DFLT-REMOTE-RD-IND                            
P00251           FROM  CSS_METER_PGM O8 WITH(READUNCOMMITTED)                   
P00251          WHERE  CODE_UTIL_TYPE = :O8-CODE-UTIL-TYPE              
P00251            AND  DIGTL_MTR_TYPE = :O8-DIGTL-MTR-TYPE              
P00251            AND  PROGRAM_ID     = :O8-PROGRAM-ID                  
P00251                                                           
P00251                                                      
P00251     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT O8.DEF_RD_SOURCE_CD                                       
MFA-TR*              ,O8.DFLT_REMOTE_RD_IND                                     
MFA-TR*          INTO :O8-DEF-RD-SOURCE-CD                                      
MFA-TR*              ,:O8-DFLT-REMOTE-RD-IND                                    
MFA-TR*          FROM  CSS_METER_PGM O8                                         
MFA-TR*         WHERE  CODE_UTIL_TYPE = :O8-CODE-UTIL-TYPE                      
MFA-TR*           AND  DIGTL_MTR_TYPE = :O8-DIGTL-MTR-TYPE                      
MFA-TR*           AND  PROGRAM_ID     = :O8-PROGRAM-ID                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00251                                                                  
P00251     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
P00251         NEXT SENTENCE                                            
P00251     ELSE                                                         
P00251         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00251         MOVE '7150'                  TO ACTIVE-PARAGRAPH         
P00251         MOVE 'SELECT'                TO ABEND-FUNCTION           
P00251         MOVE 'CSS_METER_PGM'         TO TABLE-1                  
P00251         MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-1          
P00251         MOVE O8-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1        
P00251         MOVE 'DIGTL_MTR_TYPE'        TO TABLE-ELEMENT-2          
P00251         MOVE O8-DIGTL-MTR-TYPE       TO HOSTVAR-ELEMENT-2        
P00251         MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-3          
P00251         MOVE O8-PROGRAM-ID           TO HOSTVAR-ELEMENT-3        
P00251         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00251         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251                                                                  
P00251 7150-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
P00251*===============================================================*         
P00251 7160-OPEN-READ-FMT-CSR.                                          
P00251*===============================================================*         
P00251*                                                                         
P00251                                                                  
P00251     EXEC SQL                                                     
P00251         OPEN READ_FMT_CSR                                        
P00251     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00251         MOVE '7160'                  TO ACTIVE-PARAGRAPH         
P00251         MOVE 'OPEN'                  TO ABEND-FUNCTION           
P00251         MOVE 'CSS_MTR_RD_FMT'        TO TABLE-1                  
P00251         MOVE 'DIGTL_MTR_TYPE'        TO TABLE-ELEMENT-1          
P00251         MOVE OA-DIGTL-MTR-TYPE       TO HOSTVAR-ELEMENT-1        
P00251         MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-2          
P00251         MOVE OA-PROGRAM-ID           TO HOSTVAR-ELEMENT-2        
P00251         MOVE 'MTR_READ_SOURCE_CD'    TO TABLE-ELEMENT-3          
P00251         MOVE OA-MTR-READ-SOURCE-CD   TO HOSTVAR-ELEMENT-3        
P00251         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00251         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251                                                                  
P00251 7160-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
P00251*===============================================================*         
P00251 7170-FETCH-READ-FMT-CSR.                                         
P00251*===============================================================*         
P00251*                                                                         
P00251     EXEC SQL                                                     
P00251         FETCH READ_FMT_CSR                                       
P00251          INTO :OA-CODE-CAP-TYPE                                  
P00251              ,:OA-REG-ID-NO                                      
P00251              ,:OA-NO-READ-DIGITS                                 
P00251              ,:OA-MTR-RD-DISP-CD                                 
P00251     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00251        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00251           MOVE 'Y'                   TO WS-END-OF-REGISTERS      
P00251        END-IF                                                    
P00251     ELSE                                                         
P00251         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00251         MOVE '7170'                  TO ACTIVE-PARAGRAPH         
P00251         MOVE 'OPEN'                  TO ABEND-FUNCTION           
P00251         MOVE 'CSS_MTR_RD_FMT'        TO TABLE-1                  
P00251         MOVE 'DIGTL_MTR_TYPE'        TO TABLE-ELEMENT-1          
P00251         MOVE OA-DIGTL-MTR-TYPE       TO HOSTVAR-ELEMENT-1        
P00251         MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-2          
P00251         MOVE OA-PROGRAM-ID           TO HOSTVAR-ELEMENT-2        
P00251         MOVE 'MTR_READ_SOURCE_CD'    TO TABLE-ELEMENT-3          
P00251         MOVE OA-MTR-READ-SOURCE-CD   TO HOSTVAR-ELEMENT-3        
P00251         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00251         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251                                                                  
P00251 7170-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
P00251*===============================================================*         
P00251 7180-CLOSE-READ-FMT-CSR.                                         
P00251*===============================================================*         
P00251*                                                                         
P00251     EXEC SQL                                                     
P00251         CLOSE READ_FMT_CSR                                       
P00251     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00251         MOVE '7180'                  TO ACTIVE-PARAGRAPH         
P00251         MOVE 'OPEN'                  TO ABEND-FUNCTION           
P00251         MOVE 'CSS_MTR_RD_FMT'        TO TABLE-1                  
P00251         MOVE 'DIGTL_MTR_TYPE'        TO TABLE-ELEMENT-1          
P00251         MOVE OA-DIGTL-MTR-TYPE       TO HOSTVAR-ELEMENT-1        
P00251         MOVE 'PROGRAM_ID'            TO TABLE-ELEMENT-2          
P00251         MOVE OA-PROGRAM-ID           TO HOSTVAR-ELEMENT-2        
P00251         MOVE 'MTR_READ_SOURCE_CD'    TO TABLE-ELEMENT-3          
P00251         MOVE OA-MTR-READ-SOURCE-CD   TO HOSTVAR-ELEMENT-3        
P00251         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00251         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251                                                                  
P00251 7180-EXIT.                                                       
P00251     EXIT.                                                        
P00251*                                                                         
P00251******************************************************************        
P00251*7190-SELECT-FULL-SCALE.                                         *        
P00251******************************************************************        
P00251*                                                                         
P00251 7190-SELECT-FULL-SCALE.                                          
P00251                                                                  
P00251     EXEC SQL                                                     
P00251         SELECT  FULL_SCALE                                       
P00447                ,CT_METER_FL                                      
P00251         INTO   :U0-FULL-SCALE                                    
P00447               ,:U0-CT-METER-FL                                   
P00251         FROM   CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                    
P00251         WHERE  ELEC_MTR_CLASS_CD  = :U0-ELEC-MTR-CLASS-CD        
P00251           AND  ELEC_MTR_SPEC_CD   = :U0-ELEC-MTR-SPEC-CD         
P00251                                                           
P00251                                                      
P00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FULL_SCALE                                               
MFA-TR*               ,CT_METER_FL                                              
MFA-TR*        INTO   :U0-FULL-SCALE                                            
MFA-TR*              ,:U0-CT-METER-FL                                           
MFA-TR*        FROM   CSS_ELEC_CL_SPEC                                          
MFA-TR*        WHERE  ELEC_MTR_CLASS_CD  = :U0-ELEC-MTR-CLASS-CD                
MFA-TR*          AND  ELEC_MTR_SPEC_CD   = :U0-ELEC-MTR-SPEC-CD                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7190                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00251                                                                  
P00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00251                                                                  
P00251     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00251        CONTINUE                                                  
P00251     ELSE                                                         
P00251         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
P00251         MOVE '7190'                  TO ACTIVE-PARAGRAPH         
P00251         MOVE 'SELECT'                TO ABEND-FUNCTION           
P00251         MOVE 'CSS_ELEC_CL_SPEC'      TO TABLE-1                  
P00251         MOVE 'ELEC-MTR-CLASS-CD'     TO TABLE-ELEMENT-1          
P00251         MOVE U0-ELEC-MTR-CLASS-CD    TO HOSTVAR-ELEMENT-1        
P00251         MOVE 'ELEC-MTR-SPEC-CD'      TO TABLE-ELEMENT-2          
P00251         MOVE U0-ELEC-MTR-SPEC-CD     TO HOSTVAR-ELEMENT-2        
P00251         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00251         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00251     END-IF.                                                      
P00251                                                                  
P00251 7190-EXIT.                                                       
P00251     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
                                                                        
             ADD +1                         TO CTR-ROWS.                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-INSERT-EQUIPMENT.                                         *        
      ******************************************************************        
       8200-INSERT-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIPMENT                                
               (                                                        
                   CODE_UTIL_TYPE                                       
                  ,DEVICE_NO                                            
                  ,CODE_MAKE                                            
                  ,EQUIP_TYPE_CD                                        
                  ,DATE_PURCHASED                                       
                  ,SERIAL_NO                                            
                  ,CODE_CRNT_LOC                                        
                  ,LOCAL_OFFICE                                         
                  ,PALETTE_NO                                           
                  ,EQUIP_COMMENTS_TX                                    
                  ,COMPANY_NO                                           
                  ,WARRANTY_EXP_DT                                      
                  ,DATE_LAST_MOVE                                       
                  ,DATE_LAST_TRAN                                       
               )                                                        
               VALUES                                                   
               (                                                        
                   :EQ-CODE-UTIL-TYPE                                   
                  ,:EQ-DEVICE-NO                                        
                  ,:EQ-CODE-MAKE                                        
                  ,:EQ-EQUIP-TYPE-CD                                    
                  ,IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                         :WS-PURCHASED-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED :WS-PURCHASED-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ) )             
                  ,:EQ-SERIAL-NO                                        
                  ,:EQ-CODE-CRNT-LOC                                    
                  ,:EQ-LOCAL-OFFICE                                     
                  ,:EQ-PALETTE-NO                                       
                  ,:EQ-EQUIP-COMMENTS-TX                                
                  ,:EQ-COMPANY-NO                                       
                  ,IIF(TRY_CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                         :WS-WAR-EXP-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) )           
                  ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                         :WS-LAST-MOVE-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE 
                                                 :WS-LAST-MOVE-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE :WS-LAST-MOVE-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE 
                                                 :WS-LAST-MOVE-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE 
                                                 :WS-LAST-MOVE-NULL-IND
              ) )             
                  ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                         :WS-LAST-TRAN-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN 
                                                 :WS-LAST-TRAN-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN :WS-LAST-TRAN-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN 
                                                 :WS-LAST-TRAN-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN 
                                                 :WS-LAST-TRAN-NULL-IND
              ) )             
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIPMENT                                        
MFA-TR*        (                                                                
MFA-TR*            CODE_UTIL_TYPE                                               
MFA-TR*           ,DEVICE_NO                                                    
MFA-TR*           ,CODE_MAKE                                                    
MFA-TR*           ,EQUIP_TYPE_CD                                                
MFA-TR*           ,DATE_PURCHASED                                               
MFA-TR*           ,SERIAL_NO                                                    
MFA-TR*           ,CODE_CRNT_LOC                                                
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,PALETTE_NO                                                   
MFA-TR*           ,EQUIP_COMMENTS_TX                                            
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,WARRANTY_EXP_DT                                              
MFA-TR*           ,DATE_LAST_MOVE                                               
MFA-TR*           ,DATE_LAST_TRAN                                               
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*            :EQ-CODE-UTIL-TYPE                                           
MFA-TR*           ,:EQ-DEVICE-NO                                                
MFA-TR*           ,:EQ-CODE-MAKE                                                
MFA-TR*           ,:EQ-EQUIP-TYPE-CD                                            
MFA-TR*           ,:EQ-DATE-PURCHASED:WS-PURCHASED-NULL-IND                     
MFA-TR*           ,:EQ-SERIAL-NO                                                
MFA-TR*           ,:EQ-CODE-CRNT-LOC                                            
MFA-TR*           ,:EQ-LOCAL-OFFICE                                             
MFA-TR*           ,:EQ-PALETTE-NO                                               
MFA-TR*           ,:EQ-EQUIP-COMMENTS-TX                                        
MFA-TR*           ,:EQ-COMPANY-NO                                               
MFA-TR*           ,:EQ-WARRANTY-EXP-DT:WS-WAR-EXP-DT-NULL-IND                   
MFA-TR*           ,:EQ-DATE-LAST-MOVE:WS-LAST-MOVE-NULL-IND                     
MFA-TR*           ,:EQ-DATE-LAST-TRAN:WS-LAST-TRAN-NULL-IND                     
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8220-INSERT-METER.                                             *        
      ******************************************************************        
       8220-INSERT-METER.                                               
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ELEC_METER                               
               (                                                        
                   AMPS                                                 
                  ,CODE_GEAR_REDUCTN                                    
                  ,KH_OR_KE                                             
                  ,NO_WIRES                                             
                  ,NO_PHASES                                            
                  ,REG_NO                                               
                  ,REG_UPPER_FRACTION                                   
                  ,REG_LOWER_FRACTION                                   
                  ,SOLID_ST_DIP_SET                                     
                  ,VOLTAGE                                              
                  ,PULSES_PER_REV                                       
                  ,CODE_ATTACHMENTS                                     
                  ,CODE_METER_TYPE                                      
                  ,METER_SIZE_ID                                        
                  ,MTR_CONNECT_TYP_ID                                   
                  ,TEST_SCHED_CD                                        
                  ,METER_NO                                             
                  ,CODE_UTIL_TYPE                                       
                  ,TOU_RATE_IND                                         
                  ,IDR_MEMORY_SIZE                                      
                  ,DIGTL_MTR_TYPE                                       
                  ,PROGRAM_ID                                           
                  ,DEVICE_TYPE_CD                                       
                  ,ELEC_MTR_CLASS_CD                                    
                  ,ELEC_MTR_SPEC_CD                                     
                  ,COMPANY_NO                                           
               )                                                        
               VALUES                                                   
               (                                                        
                   :EM-AMPS                                             
                  ,:EM-CODE-GEAR-REDUCTN                                
                  ,:EM-KH-OR-KE                                         
                  ,:EM-NO-WIRES                                         
                  ,:EM-NO-PHASES                                        
                  ,:EM-REG-NO                                           
                  ,:EM-REG-UPPER-FRACTION                               
                  ,:EM-REG-LOWER-FRACTION                               
                  ,:EM-SOLID-ST-DIP-SET                                 
                  ,:EM-VOLTAGE                                          
                  ,:EM-PULSES-PER-REV                                   
                  ,:EM-CODE-ATTACHMENTS                                 
                  ,:EM-CODE-METER-TYPE                                  
                  ,:EM-METER-SIZE-ID                                    
                  ,:EM-MTR-CONNECT-TYP-ID                               
                  ,:EM-TEST-SCHED-CD                                    
                  ,:EM-METER-NO                                         
                  ,:EM-CODE-UTIL-TYPE                                   
                  ,:EM-TOU-RATE-IND                                     
                  ,:EM-IDR-MEMORY-SIZE                                  
                  ,:EM-DIGTL-MTR-TYPE                                   
                  ,:EM-PROGRAM-ID                                       
                  ,:EM-DEVICE-TYPE-CD                                   
                  ,:EM-ELEC-MTR-CLASS-CD                                
                  ,:EM-ELEC-MTR-SPEC-CD                                 
                  ,:EM-COMPANY-NO                                       
               )                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ELEC_METER'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EM-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8240-INSERT-MTR-CAP.                                           *        
      ******************************************************************        
       8240-INSERT-MTR-CAP.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_CAP                                  
               (                                                        
                   FULL_SCALE                                           
                  ,CONSTANT                                             
                  ,CODE_CAP_TYPE                                        
                  ,NO_DIALS                                             
                  ,NO_READ_DIALS                                        
                  ,CODE_UTIL_TYPE                                       
                  ,METER_NO                                             
                  ,REG_ID_NO                                            
                  ,COMPANY_NO                                           
P00251            ,REG_MEASURES_CD                                      
               )                                                        
               VALUES                                                   
               (                                                        
                   :MC-FULL-SCALE                                       
                  ,:MC-CONSTANT                                         
                  ,:MC-CODE-CAP-TYPE                                    
                  ,:MC-NO-DIALS                                         
                  ,:MC-NO-READ-DIALS                                    
                  ,:MC-CODE-UTIL-TYPE                                   
                  ,:MC-METER-NO                                         
                  ,:MC-REG-ID-NO                                        
                  ,:MC-COMPANY-NO                                       
P00251            ,:MC-REG-MEASURES-CD                                  
               )                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8240'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MTR_CAP'           TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE 'REG_ID_NO'             TO TABLE-ELEMENT-4          
               MOVE MC-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MC-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MC-METER-NO             TO HOSTVAR-ELEMENT-3        
               MOVE MC-REG-ID-NO            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-DELETE-METER.                                             *        
      ******************************************************************        
       8300-DELETE-METER.                                               
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ELEC_METER                               
               WHERE                                                    
                   COMPANY_NO     = :EM-COMPANY-NO                      
               AND CODE_UTIL_TYPE = :EM-CODE-UTIL-TYPE                  
               AND METER_NO       = :EM-METER-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
P00251         MOVE 'CSS_ELEC_METER'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EM-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8320-DELETE-MTRCAP.                                            *        
      ******************************************************************        
       8320-DELETE-MTRCAP.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_MTR_CAP                                  
               WHERE                                                    
                   COMPANY_NO     = :MC-COMPANY-NO                      
               AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE                  
               AND METER_NO       = :MC-METER-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8320'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_MTR_CAP'           TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE MC-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE MC-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE MC-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8340-DELETE-EQUIPMNT.                                          *        
      ******************************************************************        
       8340-DELETE-EQUIPMNT.                                            
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_EQUIPMENT                                
               WHERE                                                    
                   COMPANY_NO     = :EQ-COMPANY-NO                      
               AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                  
               AND DEVICE_NO      = :EQ-DEVICE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8340'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
P00251         MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-UPDATE-EQUIPMNT.                                          *        
      ******************************************************************        
       8400-UPDATE-EQUIPMNT.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EQUIPMENT                                     
               SET                                                      
                    CODE_MAKE         = :EQ-CODE-MAKE                   
                   ,EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD               
                   ,DATE_PURCHASED    = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED :WS-PURCHASED-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-PURCHASED 
                                                 :WS-PURCHASED-NULL-IND
              ) )          
                   ,SERIAL_NO         = :EQ-SERIAL-NO                   
                   ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC               
                   ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                
                   ,PALETTE_NO        = :EQ-PALETTE-NO                  
                   ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX           
                   ,WARRANTY_EXP_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                                :WS-WAR-EXP-DT-NULL-IND
              ) )         
                WHERE                                                   
                    COMPANY_NO        = :EQ-COMPANY-NO                  
                AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE              
                AND DEVICE_NO         = :EQ-DEVICE-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EQUIPMENT                                             
MFA-TR*        SET                                                              
MFA-TR*             CODE_MAKE         = :EQ-CODE-MAKE                           
MFA-TR*            ,EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD                       
MFA-TR*            ,DATE_PURCHASED    = :EQ-DATE-PURCHASED                      
MFA-TR*                                 :WS-PURCHASED-NULL-IND                  
MFA-TR*            ,SERIAL_NO         = :EQ-SERIAL-NO                           
MFA-TR*            ,CODE_CRNT_LOC     = :EQ-CODE-CRNT-LOC                       
MFA-TR*            ,LOCAL_OFFICE      = :EQ-LOCAL-OFFICE                        
MFA-TR*            ,PALETTE_NO        = :EQ-PALETTE-NO                          
MFA-TR*            ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX                   
MFA-TR*            ,WARRANTY_EXP_DT   = :EQ-WARRANTY-EXP-DT                     
MFA-TR*                                 :WS-WAR-EXP-DT-NULL-IND                 
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO        = :EQ-COMPANY-NO                          
MFA-TR*         AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE                      
MFA-TR*         AND DEVICE_NO         = :EQ-DEVICE-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-3          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8420-UPDATE-METER.                                             *        
      ******************************************************************        
       8420-UPDATE-METER.                                               
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ELEC_METER                                    
               SET                                                      
                    AMPS               = :EM-AMPS                       
                   ,KH_OR_KE           = :EM-KH-OR-KE                   
                   ,NO_WIRES           = :EM-NO-WIRES                   
                   ,NO_PHASES          = :EM-NO-PHASES                  
                   ,REG_NO             = :EM-REG-NO                     
                   ,REG_UPPER_FRACTION = :EM-REG-UPPER-FRACTION         
                   ,REG_LOWER_FRACTION = :EM-REG-LOWER-FRACTION         
                   ,VOLTAGE            = :EM-VOLTAGE                    
                   ,PULSES_PER_REV     = :EM-PULSES-PER-REV             
                   ,CODE_ATTACHMENTS   = :EM-CODE-ATTACHMENTS           
                   ,CODE_METER_TYPE    = :EM-CODE-METER-TYPE            
                   ,METER_SIZE_ID      = :EM-METER-SIZE-ID              
                   ,DATE_LAST_TESTED   = IIF(TRY_CONVERT(DATE, 
                                                   :EM-DATE-LAST-TESTED
              ) IS NULL OR (PATINDEX('%.%', :EM-DATE-LAST-TESTED
              ) <> 0) OR (LEN(:EM-DATE-LAST-TESTED
              ) <> 10), CIS.CHAR2DATE(:EM-DATE-LAST-TESTED
              ), CONVERT(DATE, :EM-DATE-LAST-TESTED) )           
                   ,MTR_CONNECT_TYP_ID = :EM-MTR-CONNECT-TYP-ID         
                   ,TEST_SCHED_CD      = :EM-TEST-SCHED-CD              
                   ,IDR_MEMORY_SIZE    = :EM-IDR-MEMORY-SIZE            
                   ,TOU_RATE_IND       = :EM-TOU-RATE-IND               
                   ,DIGTL_MTR_TYPE     = :EM-DIGTL-MTR-TYPE             
                   ,PROGRAM_ID         = :EM-PROGRAM-ID                 
                   ,ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD          
                   ,ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD           
                WHERE                                                   
                    COMPANY_NO         = :EM-COMPANY-NO                 
                AND CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE             
                AND METER_NO           = :EM-METER-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ELEC_METER                                            
MFA-TR*        SET                                                              
MFA-TR*             AMPS               = :EM-AMPS                               
MFA-TR*            ,KH_OR_KE           = :EM-KH-OR-KE                           
MFA-TR*            ,NO_WIRES           = :EM-NO-WIRES                           
MFA-TR*            ,NO_PHASES          = :EM-NO-PHASES                          
MFA-TR*            ,REG_NO             = :EM-REG-NO                             
MFA-TR*            ,REG_UPPER_FRACTION = :EM-REG-UPPER-FRACTION                 
MFA-TR*            ,REG_LOWER_FRACTION = :EM-REG-LOWER-FRACTION                 
MFA-TR*            ,VOLTAGE            = :EM-VOLTAGE                            
MFA-TR*            ,PULSES_PER_REV     = :EM-PULSES-PER-REV                     
MFA-TR*            ,CODE_ATTACHMENTS   = :EM-CODE-ATTACHMENTS                   
MFA-TR*            ,CODE_METER_TYPE    = :EM-CODE-METER-TYPE                    
MFA-TR*            ,METER_SIZE_ID      = :EM-METER-SIZE-ID                      
MFA-TR*            ,DATE_LAST_TESTED   = :EM-DATE-LAST-TESTED                   
MFA-TR*            ,MTR_CONNECT_TYP_ID = :EM-MTR-CONNECT-TYP-ID                 
MFA-TR*            ,TEST_SCHED_CD      = :EM-TEST-SCHED-CD                      
MFA-TR*            ,IDR_MEMORY_SIZE    = :EM-IDR-MEMORY-SIZE                    
MFA-TR*            ,TOU_RATE_IND       = :EM-TOU-RATE-IND                       
MFA-TR*            ,DIGTL_MTR_TYPE     = :EM-DIGTL-MTR-TYPE                     
MFA-TR*            ,PROGRAM_ID         = :EM-PROGRAM-ID                         
MFA-TR*            ,ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD                  
MFA-TR*            ,ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD                   
MFA-TR*         WHERE                                                           
MFA-TR*             COMPANY_NO         = :EM-COMPANY-NO                         
MFA-TR*         AND CODE_UTIL_TYPE     = :EM-CODE-UTIL-TYPE                     
MFA-TR*         AND METER_NO           = :EM-METER-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8420'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ELEC_METER'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'METER_NO'              TO TABLE-ELEMENT-3          
               MOVE EM-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EM-METER-NO             TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT                                        *         
      * 9999-END-PROGRAM                                              *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
