       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04201.                                         
COB303 DATE-WRITTEN.  FEB 11 2009.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050005
      ******************************************************************00060005
      *                                                                *00070005
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080005
      *                                                                *00090005
      *                                                                *00100005
      ******************************************************************00110005
      *                 P R O G R A M  S U M M A R Y                   *00120005
      *                                                                *00130005
      *  UPDATE SP CALLED BY METER INVENTORY SYSTEM WHICH UPDATES,     *00140005
      *  ADDS OR DELETES TRANSFORMER.                                  *00150005
      *                                                                *00160005
      ******************************************************************00170005
      *                                                                *00180005
      *                     PROGRAM MODIFICATION LOG                   *00190005
      *                                                                *00200005
      *    DATE    INITIALS   COMMENTS                                 *00210005
      *  --------  --------   ---------------------------------------  *00220005
      *  02/11/09  MH94819    INITIAL VERSION.                         *00230005
      *                                                                *00240005
      ******************************************************************00250005
      ******************************************************************00260005
      *                                                                *00270005
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00280005
      *                                                                *00290005
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00300005
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00310005
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00320005
      *  3000 - 4999  NOT USED                                         *00330005
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00340005
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00350005
      *  7000 - 7999  INPUT MODULES                                    *00360005
      *  8000 - 8999  OUTPUT MODULES                                   *00370005
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00380005
      *                                                                *00390005
      ******************************************************************00400005
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04201'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04201 STARTS HERE'.                  
                                                                        
      ******************************************************************01140005
      * WORK AREAS                                                     *01150005
      ******************************************************************01160005
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-SELECT-VAL             PIC X(01)  VALUE SPACES.       
           05  WS-TRIAL-TEXT             PIC X(255) VALUE SPACES.       
           05  WS-SQLSTATE               PIC X(05)  VALUE SPACES.       
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-EQ-MFR-DT-IND          PIC S9(04) COMP VALUE 0.       
                                                                        
       01  WS-PROGRAM.                                                  
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04201'.      
                                                                        
       01  WS-INPUT.                                                    
           05  WS-IN-UPDATE-IND        PIC X(01) VALUE SPACES.          
               88 WS-INS-IND                     VALUE 'I'.             
               88 WS-UPD-IND                     VALUE 'U'.             
               88 WS-DEL-IND                     VALUE 'D'.             
           05  WS-IN-BIL-RATING-CD       PIC X(08)  VALUE SPACES.       
           05  WS-IN-BURDEN-QT           PIC X(08)  VALUE SPACES.       
           05  WS-IN-CODE-CRNT-LOC       PIC X(01)  VALUE SPACES.       
           05  WS-IN-CODE-MAKE           PIC X(02)  VALUE SPACES.       
           05  WS-IN-CODE-UTIL-TYPE      PIC X(01)  VALUE SPACES.       
           05  WS-IN-COMPANY-NO          PIC X(02)  VALUE SPACES.       
           05  WS-IN-CONNECTION-TYPE     PIC X(01)  VALUE SPACES.       
           05  WS-IN-DATE-LAST-MOVE      PIC X(10)  VALUE SPACES.       
           05  WS-IN-DATE-LAST-TRAN      PIC X(10)  VALUE SPACES.       
           05  WS-IN-DATE-PURCHASED      PIC X(10)  VALUE SPACES.       
           05  WS-IN-DEVICE-NO           PIC X(09)  VALUE SPACES.       
           05  WS-IN-DEVICE-TYPE-CD      PIC X(01)  VALUE SPACES.       
           05  WS-IN-DIELECTRIC-GAL      PIC S9(4)V9(1) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-EQUIP-TYPE-CD       PIC X(01)  VALUE SPACES.       
           05  WS-IN-LOCAL-OFFICE        PIC X(03)  VALUE SPACES.       
           05  WS-IN-MFR-DT              PIC X(10)  VALUE SPACES.       
           05  WS-IN-PCB-LAB-TST-REF-NO  PIC X(12)  VALUE SPACES.       
           05  WS-IN-PPM-PCB             PIC S9(4)  USAGE COMP          
                                                    VALUE 0.            
           05  WS-IN-RATE-FACTOR         PIC S9(1)V9(1) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-RTO-LOWER-FRACTION  PIC S9(4)  USAGE COMP          
                                                    VALUE 0.            
           05  WS-IN-RTO-UPPER-FRACTION  PIC S9(5)V9(1) USAGE COMP-3    
                                                    VALUE 0.            
           05  WS-IN-SERIAL-NO           PIC X(11)  VALUE SPACES.       
           05  WS-IN-VOLTAGE-CLASS       PIC X(08)  VALUE SPACES.       
           05  WS-IN-WARRANTY-EXP-DT     PIC X(10)  VALUE SPACES.       
           05  WS-IN-XFORMER-CLASS-CD    PIC X(02)  VALUE SPACES.       
           05  WS-IN-XFORMER-SIZE-ID     PIC X(08)  VALUE SPACES.       
           05  WS-IN-XFORMER-SPEC-CD     PIC X(03)  VALUE SPACES.       
           05  WS-IN-XFORMER-TYPE-CD     PIC X(02)  VALUE SPACES.       
           05  WS-IN-EQUIP-COMMENTS-TX.                                 
               49 WS-IN-EQUIP-COMMENTS-TX-LEN                           
                                         PIC S9(4) USAGE COMP VALUE 0.  
               49 WS-IN-EQUIP-COMMENTS-TX-TEXT                          
                                         PIC X(255) VALUE SPACES.       
                                                                        
                                                                        
     *******************************THIS IS THE ROW RETURN AREA******** 01810005
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) USAGE COMP VALUE 0. 
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-CONST-FLAG             PIC X(01) VALUE 'N'.           
               88 WS-CONST-CHANGED                 VALUE 'Y'.           
               88 WS-CONST-NOCHANGED               VALUE 'N'.           
                                                                        
      ******************************************************************02150006
      * DB2 INCLUDES                                                   *02150007
      ******************************************************************02150008
           EXEC SQL                                                     02150009
              INCLUDE SQLCA                                             02150010
           END-EXEC.                                                    02150020
                                                                        
      ******************************************************************02150040
      * CSS_EQUIPMENT  - EQ                                            *02150050
      ******************************************************************02150060
           EXEC SQL                                                     02150070
              INCLUDE TBEQUIP                                           02150080
           END-EXEC.                                                    02150090
                                                                        
      *                                                                *02150200
      ******************************************************************02150300
      * CSS_INSTR_XFORMER  - IX                                         02150400
      ******************************************************************02150500
           EXEC SQL                                                     02150600
              INCLUDE TBINXFOR                                          02150700
           END-EXEC.                                                    02150800
                                                                        
      *                                                                *02151000
      ******************************************************************02151100
      * CSS_METER_ATTCHMTS   - MA                                       02151200
      ******************************************************************02151300
           EXEC SQL                                                     02151400
              INCLUDE TBMTRATT                                          02151500
           END-EXEC.                                                    02151600
                                                                        
      *                                                                *02151800
      ******************************************************************02152700
      *CSS_MOVEMENT_HIST   - MV                                        *02152800
      ******************************************************************02152900
           EXEC SQL                                                     02153000
              INCLUDE TBMVHIST                                          02153100
           END-EXEC.                                                    02153200
      *                                                                 02153300
      ******************************************************************02151900
      * CSS_XFORMER_TEST  - XT                                          02152000
      ******************************************************************02152100
           EXEC SQL                                                     02152200
              INCLUDE TBXFORM                                           02152300
           END-EXEC.                                                    02152400
                                                                        
      *                                                                *02152600
      ******************************************************************02153310
      * COBOL WORKING STORAGE COPY BOOKS                              * 02153400
      ******************************************************************02153500
                                                                        
           COPY CWSSP001.                                               02153700
           COPY CWS00303.                                               02153800
                                                                        
           EXEC SQL                                                     02154000
              INCLUDE CWSX0010                                          02154100
           END-EXEC.                                                    02154200
                                                                        
                                                                        
      *                                                                 02170005
HPCCDM*EJECT                                                            02180005
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                 02210005
                                                                        
       01  PARM-IN-UPDATE-IND          PIC X(01).                       
       01  PARM-IN-BIL-RATING-CD       PIC X(08).                       
       01  PARM-IN-BURDEN-QT           PIC X(08).                       
       01  PARM-IN-CODE-CRNT-LOC       PIC X(01).                       
       01  PARM-IN-CODE-MAKE           PIC X(02).                       
       01  PARM-IN-CODE-UTIL-TYPE      PIC X(01).                       
       01  PARM-IN-COMPANY-NO          PIC X(02).                       
       01  PARM-IN-CONNECTION-TYPE     PIC X(01).                       
       01  PARM-IN-DATE-LAST-MOVE      PIC X(10).                       
       01  PARM-IN-DATE-LAST-TRAN      PIC X(10).                       
       01  PARM-IN-DATE-PURCHASED      PIC X(10).                       
       01  PARM-IN-DEVICE-NO           PIC X(09).                       
       01  PARM-IN-DEVICE-TYPE-CD      PIC X(01).                       
COB305 01 PARM-IN-DIELECTRIC-GAL        PIC S9(4)V9(1) USAGE COMP-3 
COB305       VALUE 0.     
       01  PARM-IN-EQUIP-TYPE-CD       PIC X(01).                       
       01  PARM-IN-LOCAL-OFFICE        PIC X(03).                       
       01  PARM-IN-MFR-DT              PIC X(10).                       
       01  PARM-IN-PCB-LAB-TST-REF-NO  PIC X(12).                       
       01  PARM-IN-PPM-PCB             PIC S9(4)  USAGE COMP.           
COB305 01 PARM-IN-RATE-FACTOR        PIC S9(1)V9(1) USAGE COMP-3 
COB305       VALUE 0.     
       01  PARM-IN-RTO-LOWER-FRACTION  PIC S9(4)  USAGE COMP.           
COB305 01 PARM-IN-RTO-UPPER-FRACTION        PIC S9(5)V9(1) USAGE COMP-3 
COB305       VALUE 0.     
       01  PARM-IN-SERIAL-NO           PIC X(11).                       
       01  PARM-IN-VOLTAGE-CLASS       PIC X(08).                       
       01  PARM-IN-WARRANTY-EXP-DT     PIC X(10).                       
       01  PARM-IN-XFORMER-CLASS-CD    PIC X(02).                       
       01  PARM-IN-XFORMER-SIZE-ID     PIC X(08).                       
       01  PARM-IN-XFORMER-SPEC-CD     PIC X(03).                       
       01  PARM-IN-XFORMER-TYPE-CD     PIC X(02).                       
       01  PARM-IN-EQUIP-COMMENTS-TX   PIC X(255).                      
                                                                        
       PROCEDURE DIVISION USING  PARM-IN-UPDATE-IND                     
                                ,PARM-IN-BIL-RATING-CD                  
                                ,PARM-IN-BURDEN-QT                      
                                ,PARM-IN-CODE-CRNT-LOC                  
                                ,PARM-IN-CODE-MAKE                      
                                ,PARM-IN-CODE-UTIL-TYPE                 
                                ,PARM-IN-COMPANY-NO                     
                                ,PARM-IN-CONNECTION-TYPE                
                                ,PARM-IN-DATE-LAST-MOVE                 
                                ,PARM-IN-DATE-LAST-TRAN                 
                                ,PARM-IN-DATE-PURCHASED                 
                                ,PARM-IN-DEVICE-NO                      
                                ,PARM-IN-DEVICE-TYPE-CD                 
                                ,PARM-IN-DIELECTRIC-GAL                 
                                ,PARM-IN-EQUIP-TYPE-CD                  
                                ,PARM-IN-LOCAL-OFFICE                   
                                ,PARM-IN-MFR-DT                         
                                ,PARM-IN-PCB-LAB-TST-REF-NO             
                                ,PARM-IN-PPM-PCB                        
                                ,PARM-IN-RATE-FACTOR                    
                                ,PARM-IN-RTO-LOWER-FRACTION             
                                ,PARM-IN-RTO-UPPER-FRACTION             
                                ,PARM-IN-SERIAL-NO                      
                                ,PARM-IN-VOLTAGE-CLASS                  
                                ,PARM-IN-WARRANTY-EXP-DT                
                                ,PARM-IN-XFORMER-CLASS-CD               
                                ,PARM-IN-XFORMER-SIZE-ID                
                                ,PARM-IN-XFORMER-SPEC-CD                
                                ,PARM-IN-XFORMER-TYPE-CD                
                                ,PARM-IN-EQUIP-COMMENTS-TX.             
                                                                        
      ******************************************************************02910005
      * 0000-MAINLINE                                                  *02920005
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02930005
      ******************************************************************02940005
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03050005
      * 0100-INITIALIZE                                                *03060005
      *                                                                *03070005
      ******************************************************************03080005
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE     AS RETURN_CODE                      
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     03150005
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         03160005
MFA-TR*       SELECT                                                    03170005
MFA-TR*          :S-RETURN-CODE     AS RETURN_CODE                      03180005
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                     03190005
MFA-TR*    END-EXEC.                                                    03200005
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03250005
      * 1000-PROCESS-INPUT                                             *03260005
      *                                                                *03270005
      ******************************************************************03280005
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
                                                                        
           MOVE PARM-IN-UPDATE-IND         TO WS-IN-UPDATE-IND.         
           MOVE PARM-IN-BIL-RATING-CD      TO WS-IN-BIL-RATING-CD.      
           MOVE PARM-IN-BURDEN-QT          TO WS-IN-BURDEN-QT.          
           MOVE PARM-IN-CODE-CRNT-LOC      TO WS-IN-CODE-CRNT-LOC.      
           MOVE PARM-IN-CODE-MAKE          TO WS-IN-CODE-MAKE.          
           MOVE PARM-IN-CODE-UTIL-TYPE     TO WS-IN-CODE-UTIL-TYPE.     
           MOVE PARM-IN-COMPANY-NO         TO WS-IN-COMPANY-NO.         
           MOVE PARM-IN-CONNECTION-TYPE    TO WS-IN-CONNECTION-TYPE.    
           MOVE PARM-IN-DATE-LAST-MOVE     TO WS-IN-DATE-LAST-MOVE.     
           MOVE PARM-IN-DATE-LAST-TRAN     TO WS-IN-DATE-LAST-TRAN.     
           MOVE PARM-IN-DATE-PURCHASED     TO WS-IN-DATE-PURCHASED.     
           MOVE PARM-IN-DEVICE-NO          TO WS-IN-DEVICE-NO.          
           MOVE PARM-IN-DEVICE-TYPE-CD     TO WS-IN-DEVICE-TYPE-CD.     
           MOVE PARM-IN-DIELECTRIC-GAL     TO WS-IN-DIELECTRIC-GAL.     
           MOVE PARM-IN-EQUIP-TYPE-CD      TO WS-IN-EQUIP-TYPE-CD.      
           MOVE PARM-IN-LOCAL-OFFICE       TO WS-IN-LOCAL-OFFICE.       
           MOVE PARM-IN-MFR-DT             TO WS-IN-MFR-DT.             
           MOVE PARM-IN-PCB-LAB-TST-REF-NO TO WS-IN-PCB-LAB-TST-REF-NO. 
           MOVE PARM-IN-PPM-PCB            TO WS-IN-PPM-PCB.            
           MOVE PARM-IN-RATE-FACTOR        TO WS-IN-RATE-FACTOR.        
           MOVE PARM-IN-RTO-LOWER-FRACTION TO WS-IN-RTO-LOWER-FRACTION. 
           MOVE PARM-IN-RTO-UPPER-FRACTION TO WS-IN-RTO-UPPER-FRACTION. 
           MOVE PARM-IN-SERIAL-NO          TO WS-IN-SERIAL-NO.          
           MOVE PARM-IN-VOLTAGE-CLASS      TO WS-IN-VOLTAGE-CLASS.      
           MOVE PARM-IN-WARRANTY-EXP-DT    TO WS-IN-WARRANTY-EXP-DT.    
           MOVE PARM-IN-XFORMER-CLASS-CD   TO WS-IN-XFORMER-CLASS-CD.   
           MOVE PARM-IN-XFORMER-SIZE-ID    TO WS-IN-XFORMER-SIZE-ID.    
           MOVE PARM-IN-XFORMER-SPEC-CD    TO WS-IN-XFORMER-SPEC-CD.    
           MOVE PARM-IN-XFORMER-TYPE-CD    TO WS-IN-XFORMER-TYPE-CD.    
                                                                        
           IF PARM-IN-EQUIP-COMMENTS-TX > SPACES                        
              PERFORM 1000A-CALCULATE-LENGTH       THRU 1000A-EXIT      
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03660005
      * 1000A-CALCULATE-LENGTH                                         *03670012
      *                                                                *03680005
      ******************************************************************03690005
       1000A-CALCULATE-LENGTH.                                          
           MOVE PARM-IN-EQUIP-COMMENTS-TX TO WS-TRIAL-TEXT.             
           UNSTRING WS-TRIAL-TEXT DELIMITED BY '  ' INTO                
                    WS-IN-EQUIP-COMMENTS-TX-TEXT                        
                    COUNT IN WS-IN-EQUIP-COMMENTS-TX-LEN.               
                                                                        
       1000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-IN-CODE-UTIL-TYPE = SPACES OR                        
              PARM-IN-COMPANY-NO     = SPACES OR                        
              PARM-IN-UPDATE-IND     = SPACES OR                        
              PARM-IN-DEVICE-NO      = SPACES                           
              MOVE 9998                        TO WS-ACTIVE-RETURN-CODE 
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '1200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'VALIDATE'                  TO ABEND-FUNCTION        
              MOVE 'N/A'                       TO TABLE-1               
              MOVE 'PARM-IN-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1       
              MOVE 'PARM-IN-COMPANY-NO'        TO TABLE-ELEMENT-2       
              MOVE 'PARM-IN-UPDATE-IND'        TO TABLE-ELEMENT-3       
              MOVE 'PARM-IN-DEVICE-NO'         TO TABLE-ELEMENT-4       
              MOVE PARM-IN-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1     
              MOVE PARM-IN-COMPANY-NO          TO HOSTVAR-ELEMENT-2     
              MOVE PARM-IN-UPDATE-IND          TO HOSTVAR-ELEMENT-3     
              MOVE PARM-IN-DEVICE-NO           TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03703050
      ******************************************************************03704012
      * 2000-PROCESS-OUTPUT.                                           *03705012
      *                                                                *03706012
      ******************************************************************03707012
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-INS-IND                                           
                 PERFORM 2100-PROCESS-INSERT     THRU 2100-EXIT         
              WHEN WS-DEL-IND                                           
                 PERFORM 2200-PROCESS-DELETE     THRU 2200-EXIT         
              WHEN WS-UPD-IND                                           
                 PERFORM 2300-PROCESS-UPDATE     THRU 2300-EXIT         
              WHEN OTHER                                                
                 ADD 1     TO CTR-ROWS                                  
                 MOVE 5000 TO S-RETURN-CODE                             
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03860005
      ******************************************************************03870005
      *2100-PROCESS-INSERT                                             *03880005
      ******************************************************************03890005
       2100-PROCESS-INSERT.                                             
                                                                        
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE   TO EQ-CODE-UTIL-TYPE.            
           MOVE WS-IN-DEVICE-NO        TO EQ-DEVICE-NO.                 
           MOVE WS-IN-CODE-MAKE        TO EQ-CODE-MAKE.                 
           MOVE WS-IN-EQUIP-TYPE-CD    TO EQ-EQUIP-TYPE-CD.             
           MOVE WS-IN-DATE-PURCHASED   TO EQ-DATE-PURCHASED.            
           MOVE WS-IN-SERIAL-NO        TO EQ-SERIAL-NO.                 
           MOVE WS-IN-CODE-CRNT-LOC    TO EQ-CODE-CRNT-LOC.             
           MOVE WS-IN-COMPANY-NO       TO EQ-COMPANY-NO.                
           MOVE WS-IN-WARRANTY-EXP-DT  TO EQ-WARRANTY-EXP-DT.           
           MOVE WS-IN-MFR-DT           TO EQ-MFR-DT.                    
           IF EQ-MFR-DT IS EQUAL TO SPACES                              
              MOVE -1                  TO WS-EQ-MFR-DT-IND              
           ELSE                                                         
              MOVE 0                   TO WS-EQ-MFR-DT-IND              
           END-IF.                                                      
           MOVE WS-IN-LOCAL-OFFICE     TO EQ-LOCAL-OFFICE.              
           MOVE WS-IN-DATE-LAST-TRAN   TO EQ-DATE-LAST-TRAN.            
           MOVE WS-IN-DATE-LAST-MOVE   TO EQ-DATE-LAST-MOVE.            
           PERFORM 8100-INSERT-CSS-EQUIPMENT    THRU 8100-EXIT.         
                                                                        
           MOVE WS-IN-CODE-UTIL-TYPE     TO IX-CODE-UTIL-TYPE.          
           MOVE WS-IN-DEVICE-NO          TO IX-XFORMER-NO.              
           MOVE WS-IN-DEVICE-TYPE-CD     TO IX-DEVICE-TYPE-CD.          
           MOVE WS-IN-BIL-RATING-CD      TO IX-BIL-RATING-CD.           
           MOVE WS-IN-BURDEN-QT          TO IX-BURDEN-QT.               
           MOVE WS-IN-VOLTAGE-CLASS      TO IX-VOLTAGE-CLASS.           
           MOVE WS-IN-RTO-UPPER-FRACTION TO IX-RTO-UPPER-FRACTION.      
           MOVE WS-IN-RTO-LOWER-FRACTION TO IX-RTO-LOWER-FRACTION.      
           MOVE WS-IN-XFORMER-TYPE-CD    TO IX-XFORMER-TYPE-CD.         
           MOVE WS-IN-XFORMER-SIZE-ID    TO IX-XFORMER-SIZE-ID.         
           MOVE WS-IN-XFORMER-SPEC-CD    TO IX-XFORMER-SPEC-CD.         
           MOVE WS-IN-XFORMER-CLASS-CD   TO IX-XFORMER-CLASS-CD.        
           MOVE WS-IN-RATE-FACTOR        TO IX-RATE-FACTOR.             
           MOVE WS-IN-CONNECTION-TYPE    TO IX-CONNECTION-TYPE.         
           MOVE WS-IN-DIELECTRIC-GAL     TO IX-DIELECTRIC-GAL.          
           MOVE WS-IN-PCB-LAB-TST-REF-NO TO IX-PCB-LAB-TST-REF-NO.      
           MOVE WS-IN-PPM-PCB            TO IX-PPM-PCB.                 
           MOVE WS-IN-COMPANY-NO         TO IX-COMPANY-NO.              
           PERFORM 8200-INSERT-CSS-INSTR-XFMR  THRU 8200-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04400005
      *2200-PROCESS-DELETE                                             *04410005
      ******************************************************************04420005
       2200-PROCESS-DELETE.                                             
                                                                        
           MOVE WS-IN-COMPANY-NO           TO MA-COMPANY-NO             
                                              XT-COMPANY-NO             
                                              IX-COMPANY-NO             
                                              EQ-COMPANY-NO             
                                              MV-COMPANY-NO.            
      *                                                                         
           MOVE 'E'                        TO MA-CODE-UTIL-TYPE.        
           MOVE WS-IN-CODE-UTIL-TYPE       TO XT-CODE-UTIL-TYPE         
                                              IX-CODE-UTIL-TYPE         
                                              EQ-CODE-UTIL-TYPE         
                                              MV-CODE-UTIL-TYPE.        
      *                                                                         
           MOVE WS-IN-DEVICE-NO            TO MA-DEVICE-NO              
                                              EQ-DEVICE-NO              
                                              MV-DEVICE-NO              
                                              XT-XFORMER-NO             
                                              IX-XFORMER-NO.            
           PERFORM 7100-SELECT-1-METER-ATTCHMTS THRU 7100-EXIT.         
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD 1     TO CTR-ROWS                                   
                MOVE 5100 TO S-RETURN-CODE                              
                PERFORM 9999-END-PROGRAM          THRU 9999-EXIT        
             END-IF.                                                    
                                                                        
           PERFORM 7200-SELECT-1-XFORMER-TEST   THRU 7200-EXIT.         
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD 1     TO CTR-ROWS                                   
                MOVE 5200 TO S-RETURN-CODE                              
                PERFORM 9999-END-PROGRAM       THRU 9999-EXIT           
             END-IF.                                                    
                                                                        
           MOVE 'X'                        TO MV-CODE-DEVICE-TYPE.      
           PERFORM 7300-SELECT-1-TBMVHIST-LOC      THRU 7300-EXIT.      
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD 1     TO CTR-ROWS                                   
                MOVE 5300 TO S-RETURN-CODE                              
                PERFORM 9999-END-PROGRAM       THRU 9999-EXIT           
             END-IF.                                                    
                                                                        
           MOVE WS-IN-DEVICE-TYPE-CD       TO IX-DEVICE-TYPE-CD.        
           PERFORM 8300-DELETE-INSTR-XFORMER       THRU 8300-EXIT.      
                                                                        
           PERFORM 8400-DELETE-CSS-EQUIPMENT       THRU 8400-EXIT.      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04980005
      *2300-PROCESS-UPDATE                                             *04990005
      ******************************************************************05000005
       2300-PROCESS-UPDATE.                                             
                                                                        
           MOVE WS-IN-CODE-MAKE            TO EQ-CODE-MAKE              
           MOVE WS-IN-DATE-PURCHASED       TO EQ-DATE-PURCHASED         
           MOVE WS-IN-SERIAL-NO            TO EQ-SERIAL-NO              
           MOVE WS-IN-EQUIP-COMMENTS-TX    TO EQ-EQUIP-COMMENTS-TX      
           MOVE WS-IN-WARRANTY-EXP-DT      TO EQ-WARRANTY-EXP-DT        
           MOVE WS-IN-MFR-DT               TO EQ-MFR-DT                 
           IF EQ-MFR-DT IS EQUAL TO SPACES                              
              MOVE -1                  TO WS-EQ-MFR-DT-IND              
           ELSE                                                         
              MOVE 0                   TO WS-EQ-MFR-DT-IND              
           END-IF                                                       
           MOVE WS-IN-COMPANY-NO           TO EQ-COMPANY-NO             
           MOVE WS-IN-DEVICE-NO            TO EQ-DEVICE-NO              
           MOVE WS-IN-EQUIP-TYPE-CD        TO EQ-EQUIP-TYPE-CD          
           MOVE WS-IN-CODE-UTIL-TYPE       TO EQ-CODE-UTIL-TYPE         
           PERFORM 8500-UPDATE-CSS-EQUIPMENT       THRU 8500-EXIT.      
                                                                        
           MOVE WS-IN-BURDEN-QT          TO IX-BURDEN-QT.               
           MOVE WS-IN-RTO-UPPER-FRACTION TO IX-RTO-UPPER-FRACTION.      
           MOVE WS-IN-RTO-LOWER-FRACTION TO IX-RTO-LOWER-FRACTION.      
           MOVE WS-IN-XFORMER-SPEC-CD    TO IX-XFORMER-SPEC-CD.         
           MOVE WS-IN-XFORMER-CLASS-CD   TO IX-XFORMER-CLASS-CD.        
           MOVE WS-IN-RATE-FACTOR        TO IX-RATE-FACTOR.             
           MOVE WS-IN-CONNECTION-TYPE    TO IX-CONNECTION-TYPE.         
           MOVE WS-IN-XFORMER-TYPE-CD    TO IX-XFORMER-TYPE-CD.         
           MOVE WS-IN-XFORMER-SIZE-ID    TO IX-XFORMER-SIZE-ID.         
           MOVE WS-IN-BIL-RATING-CD      TO IX-BIL-RATING-CD.           
           MOVE WS-IN-VOLTAGE-CLASS      TO IX-VOLTAGE-CLASS.           
           MOVE WS-IN-DIELECTRIC-GAL     TO IX-DIELECTRIC-GAL.          
           MOVE WS-IN-PCB-LAB-TST-REF-NO TO IX-PCB-LAB-TST-REF-NO.      
           MOVE WS-IN-PPM-PCB            TO IX-PPM-PCB.                 
           MOVE WS-IN-COMPANY-NO         TO IX-COMPANY-NO.              
           MOVE WS-IN-CODE-UTIL-TYPE     TO IX-CODE-UTIL-TYPE.          
           MOVE WS-IN-DEVICE-NO          TO IX-XFORMER-NO.              
           MOVE WS-IN-DEVICE-TYPE-CD     TO IX-DEVICE-TYPE-CD.          
           PERFORM 8600-UPDATE-INSTR-XFORMER       THRU 8600-EXIT.      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************05470005
      *7100-SELECT-1-METER-ATTCHMTS -  QUERY3                          *05480005
      ******************************************************************05490005
       7100-SELECT-1-METER-ATTCHMTS.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO                                                   
                      :WS-SELECT-VAL                                    
                 FROM                                                   
                      CSS_METER_ATTCHMTS WITH(READUNCOMMITTED)                  
                WHERE                                                   
                      COMPANY_NO      = :MA-COMPANY-NO                  
                  AND CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE              
                  AND DEVICE_NO       = :MA-DEVICE-NO                   
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05520005
MFA-TR*        SELECT 'Y'                                               05530010
MFA-TR*          INTO                                                   05530020
MFA-TR*               :WS-SELECT-VAL                                    05540005
MFA-TR*          FROM                                                   05540006
MFA-TR*               CSS_METER_ATTCHMTS                                05550005
MFA-TR*         WHERE                                                   05560005
MFA-TR*               COMPANY_NO      = :MA-COMPANY-NO                  05570005
MFA-TR*           AND CODE_UTIL_TYPE  = :MA-CODE-UTIL-TYPE              05580005
MFA-TR*           AND DEVICE_NO       = :MA-DEVICE-NO                   05590005
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            05601010
MFA-TR*    END-EXEC.                                                    05610005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_METER_ATTCHMTS'    TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE MA-COMPANY-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MA-DEVICE-NO            TO HOSTVAR-ELEMENT-2         
              MOVE MA-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05660005
      *7200-SELECT-1-XFORMER-TEST   - QUERY4                           *05670005
      ******************************************************************05680005
       7200-SELECT-1-XFORMER-TEST.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO                                                   
                      :WS-SELECT-VAL                                    
                 FROM                                                   
                      CSS_XFORMER_TEST WITH(READUNCOMMITTED)                    
                WHERE                                                   
                      COMPANY_NO      = :XT-COMPANY-NO                  
                  AND CODE_UTIL_TYPE  = :XT-CODE-UTIL-TYPE              
                  AND XFORMER_NO      = :XT-XFORMER-NO                  
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05710005
MFA-TR*        SELECT 'Y'                                               05720010
MFA-TR*          INTO                                                   05720020
MFA-TR*               :WS-SELECT-VAL                                    05730005
MFA-TR*          FROM                                                   05730006
MFA-TR*               CSS_XFORMER_TEST                                  05740005
MFA-TR*         WHERE                                                   05750005
MFA-TR*               COMPANY_NO      = :XT-COMPANY-NO                  05760005
MFA-TR*           AND CODE_UTIL_TYPE  = :XT-CODE-UTIL-TYPE              05770005
MFA-TR*           AND XFORMER_NO      = :XT-XFORMER-NO                  05780005
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            05791010
MFA-TR*    END-EXEC.                                                    05800005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_XFORMER_TEST'      TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'XFORMER_NO'            TO TABLE-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
              MOVE XT-COMPANY-NO           TO HOSTVAR-ELEMENT-1         
              MOVE XT-XFORMER-NO           TO HOSTVAR-ELEMENT-2         
              MOVE XT-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05850005
      *7300-SELECT-1-TBMVHIST-LOC     - QUERY5                         *05860005
      ******************************************************************05870005
       7300-SELECT-1-TBMVHIST-LOC.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO                                                   
                      :WS-SELECT-VAL                                    
                 FROM                                                   
                      CSS_MOVEMENT_HIST MV WITH(READUNCOMMITTED)                
                WHERE                                                   
                      MV.COMPANY_NO       = :MV-COMPANY-NO              
                  AND MV.CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE        
                  AND MV.CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE          
                  AND MV.DEVICE_NO        = :MV-DEVICE-NO               
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05890005
MFA-TR*        SELECT 'Y'                                               05900010
MFA-TR*          INTO                                                   05900020
MFA-TR*               :WS-SELECT-VAL                                    05910005
MFA-TR*          FROM                                                   05910006
MFA-TR*               CSS_MOVEMENT_HIST MV                              05920005
MFA-TR*         WHERE                                                   05970005
MFA-TR*               MV.COMPANY_NO       = :MV-COMPANY-NO              05980005
MFA-TR*           AND MV.CODE_DEVICE_TYPE = :MV-CODE-DEVICE-TYPE        05990005
MFA-TR*           AND MV.CODE_UTIL_TYPE   = :MV-CODE-UTIL-TYPE          06000005
MFA-TR*           AND MV.DEVICE_NO        = :MV-DEVICE-NO               06010005
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            06021010
MFA-TR*    END-EXEC.                                                    06030005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7300'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_MOVEMENT_HIST'     TO TABLE-1                   
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1           
              MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-2           
              MOVE 'CODE_DEVICE_TYPE'      TO TABLE-ELEMENT-3           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-4           
              MOVE MV-COMPANY-NO           TO HOSTVAR-ELEMENT-1         
              MOVE MV-DEVICE-NO            TO HOSTVAR-ELEMENT-2         
              MOVE MV-CODE-DEVICE-TYPE     TO HOSTVAR-ELEMENT-3         
              MOVE MV-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06090005
      * 8100-INSERT-CSS-EQUIPMENT     - QUERY1                         *06100005
      ******************************************************************06110005
       8100-INSERT-CSS-EQUIPMENT.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIPMENT                                 
              (                                                         
                  CODE_UTIL_TYPE                                        
                 ,DEVICE_NO                                             
                 ,CODE_MAKE                                             
                 ,EQUIP_TYPE_CD                                         
                 ,DATE_PURCHASED                                        
                 ,SERIAL_NO                                             
                 ,CODE_CRNT_LOC                                         
                 ,COMPANY_NO                                            
                 ,WARRANTY_EXP_DT                                       
                 ,MFR_DT                                                
                 ,LOCAL_OFFICE                                          
                 ,DATE_LAST_TRAN                                        
                 ,DATE_LAST_MOVE                                        
               )                                                        
               VALUES                                                   
               (                                                        
                  :EQ-CODE-UTIL-TYPE                                    
                 ,:EQ-DEVICE-NO                                         
                 ,:EQ-CODE-MAKE                                         
                 ,:EQ-EQUIP-TYPE-CD                                     
                 ,IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED
              ), CONVERT(DATE, :EQ-DATE-PURCHASED) )                           
                 ,:EQ-SERIAL-NO                                         
                 ,:EQ-CODE-CRNT-LOC                                     
                 ,:EQ-COMPANY-NO                                        
                 ,IIF(TRY_CONVERT(DATE, :EQ-WARRANTY-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT) )                          
                 ,IIF(TRY_CONVERT(DATE, :EQ-MFR-DT :WS-EQ-MFR-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-MFR-DT 
                                                      :WS-EQ-MFR-DT-IND
              ) <> 0) OR (LEN(:EQ-MFR-DT :WS-EQ-MFR-DT-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-MFR-DT :WS-EQ-MFR-DT-IND
              ), CONVERT(DATE, :EQ-MFR-DT :WS-EQ-MFR-DT-IND) )                 
                 ,:EQ-LOCAL-OFFICE                                      
                 ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-TRAN
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-TRAN
              ) <> 0) OR (LEN(:EQ-DATE-LAST-TRAN
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-TRAN
              ), CONVERT(DATE, :EQ-DATE-LAST-TRAN) )                           
                 ,IIF(TRY_CONVERT(DATE, :EQ-DATE-LAST-MOVE
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-LAST-MOVE
              ) <> 0) OR (LEN(:EQ-DATE-LAST-MOVE
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-LAST-MOVE
              ), CONVERT(DATE, :EQ-DATE-LAST-MOVE) )                           
               )                                                        
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06140005
MFA-TR*       INSERT INTO CSS_EQUIPMENT                                 06150005
MFA-TR*       (                                                         06160005
MFA-TR*           CODE_UTIL_TYPE                                        06170005
MFA-TR*          ,DEVICE_NO                                             06180005
MFA-TR*          ,CODE_MAKE                                             06190005
MFA-TR*          ,EQUIP_TYPE_CD                                         06200005
MFA-TR*          ,DATE_PURCHASED                                        06210005
MFA-TR*          ,SERIAL_NO                                             06220005
MFA-TR*          ,CODE_CRNT_LOC                                         06230005
MFA-TR*          ,COMPANY_NO                                            06240005
MFA-TR*          ,WARRANTY_EXP_DT                                       06250005
MFA-TR*          ,MFR_DT                                                06260005
MFA-TR*          ,LOCAL_OFFICE                                          06270005
MFA-TR*          ,DATE_LAST_TRAN                                        06280005
MFA-TR*          ,DATE_LAST_MOVE                                        06290005
MFA-TR*        )                                                        06300005
MFA-TR*        VALUES                                                   06310005
MFA-TR*        (                                                        06320005
MFA-TR*           :EQ-CODE-UTIL-TYPE                                    06330005
MFA-TR*          ,:EQ-DEVICE-NO                                         06340005
MFA-TR*          ,:EQ-CODE-MAKE                                         06350005
MFA-TR*          ,:EQ-EQUIP-TYPE-CD                                     06360005
MFA-TR*          ,:EQ-DATE-PURCHASED                                    06370005
MFA-TR*          ,:EQ-SERIAL-NO                                         06380005
MFA-TR*          ,:EQ-CODE-CRNT-LOC                                     06390005
MFA-TR*          ,:EQ-COMPANY-NO                                        06400005
MFA-TR*          ,:EQ-WARRANTY-EXP-DT                                   06410005
MFA-TR*          ,:EQ-MFR-DT:WS-EQ-MFR-DT-IND                           06420005
MFA-TR*          ,:EQ-LOCAL-OFFICE                                      06430005
MFA-TR*          ,:EQ-DATE-LAST-TRAN                                    06440005
MFA-TR*          ,:EQ-DATE-LAST-MOVE                                    06450005
MFA-TR*        )                                                        06460005
MFA-TR*     END-EXEC.                                                   06470005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.       
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-2          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3          
               MOVE 'CODE_MAKE'             TO TABLE-ELEMENT-4          
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-2        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3        
               MOVE EQ-CODE-MAKE            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               IF WS-ACTIVE-RETURN-CODE = -803                          
                  MOVE 5400                 TO S-RETURN-CODE            
               END-IF                                                   
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************06520005
      * 8200-INSERT-CSS-INSTR-XFMR      - QUERY2                       *06530005
      ******************************************************************06540005
       8200-INSERT-CSS-INSTR-XFMR.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_INSTR_XFORMER                             
              (                                                         
                  CODE_UTIL_TYPE                                        
                 ,XFORMER_NO                                            
                 ,DEVICE_TYPE_CD                                        
                 ,BIL_RATING_CD                                         
                 ,BURDEN_QT                                             
                 ,VOLTAGE_CLASS                                         
                 ,RTO_UPPER_FRACTION                                    
                 ,RTO_LOWER_FRACTION                                    
                 ,XFORMER_TYPE_CD                                       
                 ,XFORMER_SIZE_ID                                       
                 ,XFORMER_SPEC_CD                                       
                 ,XFORMER_CLASS_CD                                      
                 ,RATE_FACTOR                                           
                 ,CONNECTION_TYPE                                       
                 ,DIELECTRIC_GAL                                        
                 ,PCB_LAB_TST_REF_NO                                    
                 ,PPM_PCB                                               
                 ,COMPANY_NO                                            
               )                                                        
               VALUES                                                   
               (                                                        
                  :IX-CODE-UTIL-TYPE                                    
                 ,:IX-XFORMER-NO                                        
                 ,:IX-DEVICE-TYPE-CD                                    
                 ,:IX-BIL-RATING-CD                                     
                 ,:IX-BURDEN-QT                                         
                 ,:IX-VOLTAGE-CLASS                                     
                 ,:IX-RTO-UPPER-FRACTION                                
                 ,:IX-RTO-LOWER-FRACTION                                
                 ,:IX-XFORMER-TYPE-CD                                   
                 ,:IX-XFORMER-SIZE-ID                                   
                 ,:IX-XFORMER-SPEC-CD                                   
                 ,:IX-XFORMER-CLASS-CD                                  
                 ,:IX-RATE-FACTOR                                       
                 ,:IX-CONNECTION-TYPE                                   
                 ,:IX-DIELECTRIC-GAL                                    
                 ,:IX-PCB-LAB-TST-REF-NO                                
                 ,:IX-PPM-PCB                                           
                 ,:IX-COMPANY-NO                                        
               )                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'INSERT'                TO ABEND-FUNCTION            
              MOVE 'CSS_INSTR_XFORMER'     TO TABLE-1                   
              MOVE 'XFORMER_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE 'XFORMER_TYPE_CD'       TO TABLE-ELEMENT-4           
              MOVE IX-XFORMER-NO           TO HOSTVAR-ELEMENT-1         
              MOVE IX-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE IX-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              MOVE IX-XFORMER-TYPE-CD      TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              IF WS-ACTIVE-RETURN-CODE = -803                           
                 MOVE 5500                 TO S-RETURN-CODE             
              END-IF                                                    
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           ADD 1  TO CTR-ROWS.                                          
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07270005
      * 8300-DELETE-INSTR-XFORMER     - QUERY6                         *07280005
      ******************************************************************07290005
       8300-DELETE-INSTR-XFORMER.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_INSTR_XFORMER                             
               WHERE                                                    
                     COMPANY_NO     = :IX-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :IX-CODE-UTIL-TYPE                
                 AND XFORMER_NO     = :IX-XFORMER-NO                    
                 AND DEVICE_TYPE_CD = :IX-DEVICE-TYPE-CD                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8300'                  TO ACTIVE-PARAGRAPH          
              MOVE 'DELETE'                TO ABEND-FUNCTION            
              MOVE 'CSS_INSTR_XFORMER'     TO TABLE-1                   
              MOVE 'XFORMER_NO'            TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE 'DEVICE_TYPE_CD'        TO TABLE-ELEMENT-4           
              MOVE IX-XFORMER-NO           TO HOSTVAR-ELEMENT-1         
              MOVE IX-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE IX-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              MOVE IX-DEVICE-TYPE-CD       TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07440005
      * 8400-DELETE-CSS-EQUIPMENT     - QUERY7                         *07450005
      ******************************************************************07460005
       8400-DELETE-CSS-EQUIPMENT.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_EQUIPMENT                                 
               WHERE                                                    
                     COMPANY_NO     = :EQ-COMPANY-NO                    
                 AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                
                 AND DEVICE_NO      = :EQ-DEVICE-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_EQUIPMENT'         TO TABLE-1                  
               MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3          
               MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-1        
               MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07790005
      * 8500-UPDATE-CSS-EQUIPMENT   - QUERY8                           *07800005
      ******************************************************************07810005
       8500-UPDATE-CSS-EQUIPMENT.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_EQUIPMENT                                      
                 SET                                                    
                     CODE_MAKE         = :EQ-CODE-MAKE                  
                    ,DATE_PURCHASED    = IIF(TRY_CONVERT(DATE, 
                                                     :EQ-DATE-PURCHASED
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED
              ), CONVERT(DATE, :EQ-DATE-PURCHASED) )             
                    ,SERIAL_NO         = :EQ-SERIAL-NO                  
                    ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX          
                    ,WARRANTY_EXP_DT   = IIF(TRY_CONVERT(DATE, 
                                                    :EQ-WARRANTY-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT) )            
                    ,MFR_DT            = IIF(TRY_CONVERT(DATE, 
                                                            :EQ-MFR-DT 
                                                      :WS-EQ-MFR-DT-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-MFR-DT 
                                                      :WS-EQ-MFR-DT-IND
              ) <> 0) OR (LEN(:EQ-MFR-DT :WS-EQ-MFR-DT-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-MFR-DT :WS-EQ-MFR-DT-IND
              ), CONVERT(DATE, :EQ-MFR-DT :WS-EQ-MFR-DT-IND) )    
               WHERE                                                    
                     COMPANY_NO        = :EQ-COMPANY-NO                 
                 AND DEVICE_NO         = :EQ-DEVICE-NO                  
                 AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD              
                 AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     07840005
MFA-TR*       UPDATE CSS_EQUIPMENT                                      07850005
MFA-TR*          SET                                                    07850006
MFA-TR*              CODE_MAKE         = :EQ-CODE-MAKE                  07860005
MFA-TR*             ,DATE_PURCHASED    = :EQ-DATE-PURCHASED             07870005
MFA-TR*             ,SERIAL_NO         = :EQ-SERIAL-NO                  07880005
MFA-TR*             ,EQUIP_COMMENTS_TX = :EQ-EQUIP-COMMENTS-TX          07890005
MFA-TR*             ,WARRANTY_EXP_DT   = :EQ-WARRANTY-EXP-DT            07900005
MFA-TR*             ,MFR_DT            = :EQ-MFR-DT:WS-EQ-MFR-DT-IND    07910005
MFA-TR*        WHERE                                                    07920005
MFA-TR*              COMPANY_NO        = :EQ-COMPANY-NO                 07930005
MFA-TR*          AND DEVICE_NO         = :EQ-DEVICE-NO                  07940005
MFA-TR*          AND EQUIP_TYPE_CD     = :EQ-EQUIP-TYPE-CD              07950005
MFA-TR*          AND CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE             07960005
MFA-TR*    END-EXEC.                                                    07970005

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8500'                  TO ACTIVE-PARAGRAPH          
              MOVE 'UPDATE'                TO ABEND-FUNCTION            
              MOVE 'CSS_EQUIPMENT'         TO TABLE-1                   
              MOVE 'DEVICE_NO'             TO TABLE-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2           
              MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-3           
              MOVE 'EQUIP_TYPE_CD'         TO TABLE-ELEMENT-4           
              MOVE EQ-DEVICE-NO            TO HOSTVAR-ELEMENT-1         
              MOVE EQ-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2         
              MOVE EQ-COMPANY-NO           TO HOSTVAR-ELEMENT-3         
              MOVE EQ-EQUIP-TYPE-CD        TO HOSTVAR-ELEMENT-4         
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08020005
      * 8600-UPDATE-INSTR-XFORMER       - QUERY9                       *08030005
      ******************************************************************08040005
       8600-UPDATE-INSTR-XFORMER.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_INSTR_XFORMER                                  
                 SET                                                    
                     BURDEN_QT          = :IX-BURDEN-QT                 
                    ,RTO_UPPER_FRACTION = :IX-RTO-UPPER-FRACTION        
                    ,RTO_LOWER_FRACTION = :IX-RTO-LOWER-FRACTION        
                    ,XFORMER_SPEC_CD    = :IX-XFORMER-SPEC-CD           
                    ,XFORMER_CLASS_CD   = :IX-XFORMER-CLASS-CD          
                    ,RATE_FACTOR        = :IX-RATE-FACTOR               
                    ,CONNECTION_TYPE    = :IX-CONNECTION-TYPE           
                    ,XFORMER_TYPE_CD    = :IX-XFORMER-TYPE-CD           
                    ,XFORMER_SIZE_ID    = :IX-XFORMER-SIZE-ID           
                    ,BIL_RATING_CD      = :IX-BIL-RATING-CD             
                    ,VOLTAGE_CLASS      = :IX-VOLTAGE-CLASS             
                    ,DIELECTRIC_GAL     = :IX-DIELECTRIC-GAL            
                    ,PCB_LAB_TST_REF_NO = :IX-PCB-LAB-TST-REF-NO        
                    ,PPM_PCB            = :IX-PPM-PCB                   
               WHERE                                                    
                     COMPANY_NO         = :IX-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :IX-CODE-UTIL-TYPE            
                 AND XFORMER_NO         = :IX-XFORMER-NO                
                 AND DEVICE_TYPE_CD     = :IX-DEVICE-TYPE-CD            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_INSTR_XFORMER'     TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'XFORMER_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'DEVICE_TYPE_CD'        TO TABLE-ELEMENT-3          
               MOVE IX-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               MOVE IX-XFORMER-NO           TO HOSTVAR-ELEMENT-2        
               MOVE IX-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3        
               MOVE IX-DEVICE-TYPE-CD       TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08550005
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     * 08560005
      ***************************************************************** 08570005
           EXEC SQL                                                     08580005
              INCLUDE CPDSP300                                          08590005
           END-EXEC.                                                    08600005
                                                                        
      ***************************************************************** 08620005
      * 8900-SEND-DONE                                                * 08630005
      * 9000-SEND-ERROR-RESULT                                        * 08640005
      * 9999-END-PROGRAM                                              * 08650005
      ***************************************************************** 08660005
           EXEC SQL                                                     08670005
              INCLUDE CPD00321                                          08680005
           END-EXEC.                                                    08690005
