       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04200.                                         
COB303 DATE-WRITTEN.  DEC 15 2008.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00100000
      ******************************************************************00110000
      *                 P R O G R A M  S U M M A R Y                   *00120000
      *                                                                *00130000
      * UPDATE SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC        *00140002
      * AND GAS ATTACHMENT UPDATE, ADD  AND DELETE SCREENS WHICH       *00150002
      * UPDATE, ADD  AND DELETE EQUIPMENT ATTACHMENTS DETAILS          *00160000
      *                                                                *00160100
      ******************************************************************00170000
      *                                                                *00180000
      *                     PROGRAM MODIFICATION LOG                   *00190000
      *                                                                *00200000
      *    DATE    INITIALS   COMMENTS                                 *00210000
      *  --------  --------   ---------------------------------------  *00220000
      *  12/15/08  MH94819    INITIAL VERSION.                         *00230000
      *  12/06/10  SB40505    ADD SERIAL NO FOR SMART SYNCH 00462      *00230000
      *                                                                *00240000
      ******************************************************************00250000
      ******************************************************************00260000
      *                                                                *00270000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00280000
      *                                                                *00290000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00300000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00310000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00320000
      *  3000 - 4999  NOT USED                                         *00330000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00340000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00350000
      *  7000 - 7999  INPUT MODULES                                    *00360000
      *  8000 - 8999  OUTPUT MODULES                                   *00370000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00380000
      *                                                                *00390000
      ******************************************************************00400000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04200'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04200 STARTS HERE'.                  
                                                                        
      ******************************************************************00750000
      * WORK AREAS                                                     *00760000
      ******************************************************************00770000
      **************************PARM FIELDS*****************************00780005
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'CSR04200'.     
           05  WS-UPDATE-IND           PIC X(01)  VALUE 'I'.            
               88 WS-INS-IND                      VALUE 'I'.            
               88 WS-UPD-IND                      VALUE 'U'.            
               88 WS-DEL-IND                      VALUE 'D'.            
           05  WS-NULL                 PIC S9(4)  COMP VALUE -1.        
           05  WS-NULL-IND-1           PIC S9(04) COMP.                 
           05  WS-NULL-IND-2           PIC S9(04) COMP.                 
           05  WS-NULL-IND-3           PIC S9(04) COMP.                 
           05  WS-NULL-IND-4           PIC S9(04) COMP.                 
           05  WS-NULL-IND-5           PIC S9(04) COMP.                 
           05  WS-NULL-IND-6           PIC S9(04) COMP.                 
           05  WS-NULL-IND-7           PIC S9(04) COMP.                 
                                                                        
      *************** THIS IS THE ROW RETURN AREA **********************01060005
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
      ******************************************************************01390100
      * DB2 INCLUDES                                                   *01390200
      ******************************************************************01390300
           EXEC SQL                                                     01390400
              INCLUDE SQLCA                                             01390500
           END-EXEC.                                                    01390600
                                                                        
      ******************************************************************01390800
      * CSS_EQUIP_ATTCHMTS, LX                                         *01390900
      ******************************************************************01391000
           EXEC SQL                                                     01391100
              INCLUDE TBEQATTH                                          01391200
           END-EXEC.                                                    01391300
                                                                        
      ******************************************************************01391500
      * COBOL WORKING STORAGE COPY BOOKS                               *01391600
      ******************************************************************01391700
                                                                        
           COPY CWS00303.                                               01391900
                                                                        
           EXEC SQL                                                     01392100
              INCLUDE CWSX0010                                          01392200
           END-EXEC.                                                    01392300
                                                                        
      ******************************************************************01400000
      * CURSOR DECLARATIONS                                            *01410000
      *    FOR FINAL RETURN                                            *01420000
      ******************************************************************01430000
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE     AS RETURN_CODE                 
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     01440005
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        01450005
MFA-TR*        SELECT :S-RETURN-CODE     AS RETURN_CODE                 01460005
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                    01470005
MFA-TR*    END-EXEC.                                                    01480005
      *                                                                 01490000
HPCCDM*EJECT                                                            01500000
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                 01530000
       01 PARM-UPDATE-IND         PIC X(01).                            
       01 PARM-COMPANY-NO         PIC X(02).                            
       01 PARM-CODE-UTIL-TYPE     PIC X(01).                            
       01 PARM-CODE-ATT-TYPE      PIC X(02).                            
       01 PARM-DEVICE-NO          PIC X(12).                            
       01 PARM-EQUIP-LOC-ID       PIC X(01).                            
       01 PARM-MTR-STORAGE-FAC-CD PIC X(03).                            
       01 PARM-CODE-MAKE          PIC X(02).                            
       01 PARM-TEST-SCHED-CD      PIC X(01).                            
       01 PARM-VERSION-CD         PIC X(03).                            
       01 PARM-DATE-LAST-MOVE     PIC X(10).                            
       01 PARM-DATE-LAST-TESTED   PIC X(10).                            
       01 PARM-DATE-LAST-TRAN     PIC X(10).                            
       01 PARM-DATE-PURCHASED     PIC X(10).                            
       01 PARM-WARRANTY-EXP-DT    PIC X(10).                            
       01 PARM-DATE-OBSOLETE      PIC X(10).                            
       01 PARM-DATE-DISPOSED-OF   PIC X(10).                            
P00462 01 PARM-SERIAL-NO          PIC X(25).                            
      *                                                                 01710000
       PROCEDURE DIVISION USING PARM-UPDATE-IND                         
                                PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-CODE-ATT-TYPE                      
                                PARM-DEVICE-NO                          
                                PARM-EQUIP-LOC-ID                       
                                PARM-MTR-STORAGE-FAC-CD                 
                                PARM-CODE-MAKE                          
                                PARM-TEST-SCHED-CD                      
                                PARM-VERSION-CD                         
                                PARM-DATE-LAST-MOVE                     
                                PARM-DATE-LAST-TESTED                   
                                PARM-DATE-LAST-TRAN                     
                                PARM-DATE-PURCHASED                     
                                PARM-WARRANTY-EXP-DT                    
                                PARM-DATE-OBSOLETE                      
                                PARM-DATE-DISPOSED-OF                   
P00462                          PARM-SERIAL-NO.                         
      ******************************************************************01890000
      * 0000-MAINLINE                                                  *01900000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01910000
      ******************************************************************01920000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02020000
      ******************************************************************02030000
      * 0100-INITIALIZE                                                *02040000
      *                                                                *02050000
      ******************************************************************02060000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02160000
      * 1000-PROCESS-INPUT                                             *02170000
      *                                                                *02180000
      ******************************************************************02190000
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE  PARM-UPDATE-IND         TO WS-UPDATE-IND.              
           MOVE  PARM-COMPANY-NO         TO LX-COMPANY-NO.              
           MOVE  PARM-CODE-UTIL-TYPE     TO LX-CODE-UTIL-TYPE.          
           MOVE  PARM-CODE-ATT-TYPE      TO LX-CODE-ATT-TYPE.           
           MOVE  PARM-DEVICE-NO          TO LX-DEVICE-NO.               
           MOVE  PARM-EQUIP-LOC-ID       TO LX-EQUIP-LOC-ID.            
           MOVE  PARM-MTR-STORAGE-FAC-CD TO LX-MTR-STORAGE-FAC-CD.      
           MOVE  PARM-CODE-MAKE          TO LX-CODE-MAKE.               
           MOVE  PARM-TEST-SCHED-CD      TO LX-TEST-SCHED-CD.           
           MOVE  PARM-VERSION-CD         TO LX-VERSION-CD.              
           MOVE  PARM-DATE-LAST-MOVE     TO LX-DATE-LAST-MOVE.          
           MOVE  PARM-DATE-LAST-TESTED   TO LX-DATE-LAST-TESTED.        
           MOVE  PARM-DATE-LAST-TRAN     TO LX-DATE-LAST-TRAN.          
           MOVE  PARM-DATE-PURCHASED     TO LX-DATE-PURCHASED.          
           MOVE  PARM-WARRANTY-EXP-DT    TO LX-WARRANTY-EXP-DT.         
           MOVE  PARM-DATE-OBSOLETE      TO LX-DATE-OBSOLETE.           
           MOVE  PARM-DATE-DISPOSED-OF   TO LX-DATE-DISPOSED-OF.        
P00462     MOVE  PARM-SERIAL-NO          TO LX-SERIAL-NO.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02420100
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *02420200
      ******************************************************************02420300
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
           IF PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-UPDATE-IND     = SPACES OR                           
              PARM-COMPANY-NO     = SPACES OR                           
              PARM-CODE-ATT-TYPE  = SPACES OR                           
              PARM-DEVICE-NO      = SPACES                              
                                                                        
              MOVE 9998                   TO WS-ACTIVE-RETURN-CODE      
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '1200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'VALIDATE'             TO ABEND-FUNCTION             
              MOVE 'N/A'                  TO TABLE-1                    
              MOVE 'PARM-CODE-UTIL-TYPE'  TO TABLE-ELEMENT-1            
              MOVE 'PARM-COMPANY-NO'      TO TABLE-ELEMENT-2            
              MOVE 'PARM-CODE-ATT-TYPE'   TO TABLE-ELEMENT-3            
              MOVE 'PARM-DEVICE-NO'       TO TABLE-ELEMENT-4            
              MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1          
              MOVE PARM-COMPANY-NO        TO HOSTVAR-ELEMENT-2          
              MOVE PARM-CODE-ATT-TYPE     TO HOSTVAR-ELEMENT-3          
              MOVE PARM-DEVICE-NO         TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                .                                                       
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02430000
      * 2000-PROCESS-OUTPUT.                                           *02440000
      *                                                                *02450000
      ******************************************************************02460000
       2000-PROCESS-OUTPUT.                                             
           MOVE   0        TO WS-NULL-IND-1                             
                              WS-NULL-IND-2                             
                              WS-NULL-IND-3                             
                              WS-NULL-IND-4                             
                              WS-NULL-IND-5                             
                              WS-NULL-IND-6                             
                              WS-NULL-IND-7.                            
                                                                        
           IF LX-DATE-LAST-MOVE   = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-1                             
           END-IF.                                                      
                                                                        
           IF LX-DATE-LAST-TESTED = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-2                             
           END-IF.                                                      
                                                                        
           IF LX-DATE-LAST-TRAN   = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-3                             
           END-IF.                                                      
                                                                        
           IF LX-WARRANTY-EXP-DT  = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-4                             
           END-IF.                                                      
                                                                        
           IF LX-DATE-OBSOLETE    = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-5                             
           END-IF.                                                      
                                                                        
           IF LX-DATE-DISPOSED-OF = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-6                             
           END-IF.                                                      
                                                                        
           IF LX-DATE-PURCHASED   = SPACES                              
              MOVE WS-NULL TO WS-NULL-IND-7                             
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
              WHEN WS-INS-IND                                           
                 PERFORM 8150-INSERT-ATTCHMTS      THRU 8150-EXIT       
              WHEN WS-DEL-IND                                           
                 PERFORM 8300-DELETE-EQIP-ATCHMTS  THRU 8300-EXIT       
              WHEN WS-UPD-IND                                           
                 PERFORM 8200-UPDATE-EQIP-ATCHMTS  THRU 8200-EXIT       
              WHEN OTHER                                                
                 MOVE 9999                     TO WS-ACTIVE-RETURN-CODE 
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE '2000'                   TO ACTIVE-PARAGRAPH      
                 MOVE 'EVALUATE'               TO ABEND-FUNCTION        
                 MOVE 'N/A'                    TO TABLE-1               
                 MOVE 'WS-UPDATE-IND'          TO TABLE-ELEMENT-1       
                 MOVE WS-UPDATE-IND            TO HOSTVAR-ELEMENT-1     
                 PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT       
                 PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT       
           END-EVALUATE.                                                
           ADD 1                              TO CTR-ROWS.              
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02850000
      ******************************************************************02950000
      * 8150-INSERT-ATTCHMTS                                           *02960000
      ******************************************************************02970000
       8150-INSERT-ATTCHMTS.                                            
           MOVE '8150'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_EQUIP_ATTCHMTS                            
              (                                                         
                   DEVICE_NO                                            
                  ,CODE_ATT_TYPE                                        
                  ,COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,EQUIP_LOC_ID                                         
                  ,MTR_STORAGE_FAC_CD                                   
                  ,CODE_MAKE                                            
                  ,TEST_SCHED_CD                                        
                  ,VERSION_CD                                           
                  ,DATE_LAST_MOVE                                       
                  ,DATE_LAST_TESTED                                     
                  ,DATE_LAST_TRAN                                       
                  ,DATE_PURCHASED                                       
                  ,WARRANTY_EXP_DT                                      
                  ,DATE_OBSOLETE                                        
                  ,DATE_DISPOSED_OF                                     
                  ,SERIAL_NO                                            
              )                                                         
              VALUES                                                    
              (                                                         
                  :LX-DEVICE-NO                                         
                 ,:LX-CODE-ATT-TYPE                                     
                 ,:LX-COMPANY-NO                                        
                 ,:LX-CODE-UTIL-TYPE                                    
                 ,:LX-EQUIP-LOC-ID                                      
                 ,:LX-MTR-STORAGE-FAC-CD                                
                 ,:LX-CODE-MAKE                                         
                 ,:LX-TEST-SCHED-CD                                     
                 ,:LX-VERSION-CD                                        
                 ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-MOVE 
                                        :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE :WS-NULL-IND-1
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE :WS-NULL-IND-1) )            
                 ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TESTED 
                                        :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED :WS-NULL-IND-2) )          
                 ,IIF(TRY_CONVERT(DATE, :LX-DATE-LAST-TRAN 
                                        :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN :WS-NULL-IND-3
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN :WS-NULL-IND-3) )            
                 ,IIF(TRY_CONVERT(DATE, :LX-DATE-PURCHASED 
                                        :WS-NULL-IND-7
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-PURCHASED 
                                                         :WS-NULL-IND-7
              ) <> 0) OR (LEN(:LX-DATE-PURCHASED :WS-NULL-IND-7
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-PURCHASED :WS-NULL-IND-7
              ), CONVERT(DATE, :LX-DATE-PURCHASED :WS-NULL-IND-7) )            
                 ,IIF(TRY_CONVERT(DATE, :LX-WARRANTY-EXP-DT 
                                        :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :LX-WARRANTY-EXP-DT 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:LX-WARRANTY-EXP-DT :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:LX-WARRANTY-EXP-DT 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :LX-WARRANTY-EXP-DT :WS-NULL-IND-4) )           
                 ,IIF(TRY_CONVERT(DATE, :LX-DATE-OBSOLETE :WS-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-OBSOLETE 
                                                         :WS-NULL-IND-5
              ) <> 0) OR (LEN(:LX-DATE-OBSOLETE :WS-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-OBSOLETE :WS-NULL-IND-5
              ), CONVERT(DATE, :LX-DATE-OBSOLETE :WS-NULL-IND-5) )             
                 ,IIF(TRY_CONVERT(DATE, :LX-DATE-DISPOSED-OF 
                                        :WS-NULL-IND-6
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-DISPOSED-OF 
                                                         :WS-NULL-IND-6
              ) <> 0) OR (LEN(:LX-DATE-DISPOSED-OF :WS-NULL-IND-6
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-DISPOSED-OF 
                                                         :WS-NULL-IND-6
              ), CONVERT(DATE, :LX-DATE-DISPOSED-OF :WS-NULL-IND-6) )          
                 ,:LX-SERIAL-NO                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03010000
MFA-TR*       INSERT INTO CSS_EQUIP_ATTCHMTS                            03020000
MFA-TR*       (                                                         03020100
MFA-TR*            DEVICE_NO                                            03030000
MFA-TR*           ,CODE_ATT_TYPE                                        03040000
MFA-TR*           ,COMPANY_NO                                           03050000
MFA-TR*           ,CODE_UTIL_TYPE                                       03060000
MFA-TR*           ,EQUIP_LOC_ID                                         03070000
MFA-TR*           ,MTR_STORAGE_FAC_CD                                   03080000
MFA-TR*           ,CODE_MAKE                                            03090000
MFA-TR*           ,TEST_SCHED_CD                                        03100000
MFA-TR*           ,VERSION_CD                                           03110000
MFA-TR*           ,DATE_LAST_MOVE                                       03120000
MFA-TR*           ,DATE_LAST_TESTED                                     03130000
MFA-TR*           ,DATE_LAST_TRAN                                       03140000
MFA-TR*           ,DATE_PURCHASED                                       03150000
MFA-TR*           ,WARRANTY_EXP_DT                                      03160000
MFA-TR*           ,DATE_OBSOLETE                                        03170000
MFA-TR*           ,DATE_DISPOSED_OF                                     03180000
MFA-TR*           ,SERIAL_NO                                            03180000
MFA-TR*       )                                                         03190000
MFA-TR*       VALUES                                                    03200000
MFA-TR*       (                                                         03200100
MFA-TR*           :LX-DEVICE-NO                                         03210000
MFA-TR*          ,:LX-CODE-ATT-TYPE                                     03220000
MFA-TR*          ,:LX-COMPANY-NO                                        03230000
MFA-TR*          ,:LX-CODE-UTIL-TYPE                                    03240000
MFA-TR*          ,:LX-EQUIP-LOC-ID                                      03250000
MFA-TR*          ,:LX-MTR-STORAGE-FAC-CD                                03260000
MFA-TR*          ,:LX-CODE-MAKE                                         03270000
MFA-TR*          ,:LX-TEST-SCHED-CD                                     03280000
MFA-TR*          ,:LX-VERSION-CD                                        03290000
MFA-TR*          ,:LX-DATE-LAST-MOVE:WS-NULL-IND-1                      03300000
MFA-TR*          ,:LX-DATE-LAST-TESTED:WS-NULL-IND-2                    03310000
MFA-TR*          ,:LX-DATE-LAST-TRAN:WS-NULL-IND-3                      03320000
MFA-TR*          ,:LX-DATE-PURCHASED:WS-NULL-IND-7                      03330000
MFA-TR*          ,:LX-WARRANTY-EXP-DT:WS-NULL-IND-4                     03340000
MFA-TR*          ,:LX-DATE-OBSOLETE:WS-NULL-IND-5                       03350000
MFA-TR*          ,:LX-DATE-DISPOSED-OF:WS-NULL-IND-6                    03360000
MFA-TR*          ,:LX-SERIAL-NO                                         03360000
MFA-TR*       )                                                         03370000
MFA-TR*    END-EXEC.                                                    03380000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = -803                           
                 MOVE 5200                     TO S-RETURN-CODE         
                 ADD 1                         TO CTR-ROWS              
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              ELSE                                                      
                 MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
                 MOVE 'INSERT'                 TO ABEND-FUNCTION        
                 MOVE 'CSS_EQUIP_ATTCHMTS'     TO TABLE-1               
                 MOVE 'DEVICE_NO'              TO TABLE-ELEMENT-1       
                 MOVE 'CODE_ATT_TYPE'          TO TABLE-ELEMENT-2       
                 MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3       
                 MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-4       
                 MOVE LX-DEVICE-NO             TO HOSTVAR-ELEMENT-1     
                 MOVE LX-CODE-ATT-TYPE         TO HOSTVAR-ELEMENT-2     
                 MOVE LX-COMPANY-NO            TO HOSTVAR-ELEMENT-3     
                 MOVE LX-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-4     
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03710000
      ******************************************************************03720000
      * 8200-UPDATE-EQIP-ATCHMTS                                       *03730000
      ******************************************************************03740000
       8200-UPDATE-EQIP-ATCHMTS.                                        
           MOVE '8200'                        TO ACTIVE-PARAGRAPH.      
           EXEC SQL                                                     
              UPDATE CSS_EQUIP_ATTCHMTS                                 
                 SET                                                    
                    CODE_MAKE        =:LX-CODE-MAKE                     
                   ,TEST_SCHED_CD    =:LX-TEST-SCHED-CD                 
                   ,VERSION_CD       =:LX-VERSION-CD                    
                   ,DATE_LAST_MOVE   =IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-MOVE 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-MOVE 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:LX-DATE-LAST-MOVE :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-MOVE :WS-NULL-IND-1
              ), CONVERT(DATE, :LX-DATE-LAST-MOVE :WS-NULL-IND-1) )  
                   ,DATE_LAST_TESTED =IIF(TRY_CONVERT(DATE, 
                                                  :LX-DATE-LAST-TESTED 
                                                         :WS-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TESTED 
                                                         :WS-NULL-IND-2
              ) <> 0) OR (LEN(:LX-DATE-LAST-TESTED :WS-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TESTED 
                                                         :WS-NULL-IND-2
              ), CONVERT(DATE, :LX-DATE-LAST-TESTED :WS-NULL-IND-2) )
                   ,DATE_LAST_TRAN   =IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-LAST-TRAN 
                                                         :WS-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-LAST-TRAN 
                                                         :WS-NULL-IND-3
              ) <> 0) OR (LEN(:LX-DATE-LAST-TRAN :WS-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-LAST-TRAN :WS-NULL-IND-3
              ), CONVERT(DATE, :LX-DATE-LAST-TRAN :WS-NULL-IND-3) )  
                   ,DATE_PURCHASED   =IIF(TRY_CONVERT(DATE, 
                                                    :LX-DATE-PURCHASED 
                                                         :WS-NULL-IND-7
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-PURCHASED 
                                                         :WS-NULL-IND-7
              ) <> 0) OR (LEN(:LX-DATE-PURCHASED :WS-NULL-IND-7
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-PURCHASED :WS-NULL-IND-7
              ), CONVERT(DATE, :LX-DATE-PURCHASED :WS-NULL-IND-7) )  
                   ,WARRANTY_EXP_DT  =IIF(TRY_CONVERT(DATE, 
                                                   :LX-WARRANTY-EXP-DT 
                                                         :WS-NULL-IND-4
              ) IS NULL OR (PATINDEX('%.%', :LX-WARRANTY-EXP-DT 
                                                         :WS-NULL-IND-4
              ) <> 0) OR (LEN(:LX-WARRANTY-EXP-DT :WS-NULL-IND-4
              ) <> 10), CIS.CHAR2DATE(:LX-WARRANTY-EXP-DT 
                                                         :WS-NULL-IND-4
              ), CONVERT(DATE, :LX-WARRANTY-EXP-DT :WS-NULL-IND-4) ) 
                   ,DATE_OBSOLETE    =IIF(TRY_CONVERT(DATE, 
                                                     :LX-DATE-OBSOLETE 
                                                         :WS-NULL-IND-5
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-OBSOLETE 
                                                         :WS-NULL-IND-5
              ) <> 0) OR (LEN(:LX-DATE-OBSOLETE :WS-NULL-IND-5
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-OBSOLETE :WS-NULL-IND-5
              ), CONVERT(DATE, :LX-DATE-OBSOLETE :WS-NULL-IND-5) )   
                   ,DATE_DISPOSED_OF =IIF(TRY_CONVERT(DATE, 
                                                  :LX-DATE-DISPOSED-OF 
                                                         :WS-NULL-IND-6
              ) IS NULL OR (PATINDEX('%.%', :LX-DATE-DISPOSED-OF 
                                                         :WS-NULL-IND-6
              ) <> 0) OR (LEN(:LX-DATE-DISPOSED-OF :WS-NULL-IND-6
              ) <> 10), CIS.CHAR2DATE(:LX-DATE-DISPOSED-OF 
                                                         :WS-NULL-IND-6
              ), CONVERT(DATE, :LX-DATE-DISPOSED-OF :WS-NULL-IND-6) )
                   ,SERIAL_NO        =:LX-SERIAL-NO                     
               WHERE                                                    
                     COMPANY_NO      =:LX-COMPANY-NO                    
                 AND CODE_UTIL_TYPE  =:LX-CODE-UTIL-TYPE                
                 AND CODE_ATT_TYPE   =:LX-CODE-ATT-TYPE                 
                 AND DEVICE_NO       =:LX-DEVICE-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03770000
MFA-TR*       UPDATE CSS_EQUIP_ATTCHMTS                                 03780000
MFA-TR*          SET                                                    03780100
MFA-TR*             CODE_MAKE        =:LX-CODE-MAKE                     03790000
MFA-TR*            ,TEST_SCHED_CD    =:LX-TEST-SCHED-CD                 03800000
MFA-TR*            ,VERSION_CD       =:LX-VERSION-CD                    03810000
MFA-TR*            ,DATE_LAST_MOVE   =:LX-DATE-LAST-MOVE:WS-NULL-IND-1  03820000
MFA-TR*            ,DATE_LAST_TESTED =:LX-DATE-LAST-TESTED:WS-NULL-IND-203830000
MFA-TR*            ,DATE_LAST_TRAN   =:LX-DATE-LAST-TRAN:WS-NULL-IND-3  03840000
MFA-TR*            ,DATE_PURCHASED   =:LX-DATE-PURCHASED:WS-NULL-IND-7  03850000
MFA-TR*            ,WARRANTY_EXP_DT  =:LX-WARRANTY-EXP-DT:WS-NULL-IND-4 03860000
MFA-TR*            ,DATE_OBSOLETE    =:LX-DATE-OBSOLETE:WS-NULL-IND-5   03870000
MFA-TR*            ,DATE_DISPOSED_OF =:LX-DATE-DISPOSED-OF:WS-NULL-IND-603880000
MFA-TR*            ,SERIAL_NO        =:LX-SERIAL-NO                     03880000
MFA-TR*        WHERE                                                    03880100
MFA-TR*              COMPANY_NO      =:LX-COMPANY-NO                    03890000
MFA-TR*          AND CODE_UTIL_TYPE  =:LX-CODE-UTIL-TYPE                03900000
MFA-TR*          AND CODE_ATT_TYPE   =:LX-CODE-ATT-TYPE                 03910000
MFA-TR*          AND DEVICE_NO       =:LX-DEVICE-NO                     03920000
MFA-TR*    END-EXEC.                                                    03930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_EQUIP_ATTCHMTS'       TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'CODE_ATT_TYPE'            TO TABLE-ELEMENT-3        
              MOVE 'DEVICE_NO'                TO TABLE-ELEMENT-4        
              MOVE LX-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE LX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE LX-CODE-ATT-TYPE           TO HOSTVAR-ELEMENT-3      
              MOVE LX-DEVICE-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04250000
      * 8300-DELETE-EQIP-ATCHMTS                                       *04260000
      ******************************************************************04270000
       8300-DELETE-EQIP-ATCHMTS.                                        
                                                                        
           MOVE '8300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_EQUIP_ATTCHMTS                          
                 WHERE                                                  
                       COMPANY_NO     =:LX-COMPANY-NO                   
                   AND CODE_UTIL_TYPE =:LX-CODE-UTIL-TYPE               
                   AND CODE_ATT_TYPE  =:LX-CODE-ATT-TYPE                
                   AND DEVICE_NO      =:LX-DEVICE-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_EQUIP_ATTCHMTS'       TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'CODE_ATT_TYPE'            TO TABLE-ELEMENT-3        
              MOVE 'DEVICE_NO'                TO TABLE-ELEMENT-4        
              MOVE LX-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE LX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE LX-CODE-ATT-TYPE           TO HOSTVAR-ELEMENT-3      
              MOVE LX-DEVICE-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04670000
      ******************************************************************04680000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *04690000
      ******************************************************************04700000
           EXEC SQL                                                     04710000
              INCLUDE CPDSP300                                          04720000
           END-EXEC.                                                    04730000
      *                                                                 04740000
           EXEC SQL                                                     04750000
               INCLUDE CPD00321                                         04760000
           END-EXEC.                                                    04770000
