       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04186.                                         
COB303 DATE-WRITTEN.  FEB 04 2009                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *                                                                *00142000
      ******************************************************************00143000
      *                 P R O G R A M  S U M M A R Y                   *00144000
      *                                                                *00145000
      *  SELECT SP CALLED BY METER INVENTORY SYSTEM FOR TRANSFORMER    *00145100
      *  INVENTORY SCREEN                                              *00145200
      *                                                                *00148000
      ******************************************************************00149000
      *                                                                *00150000
      *                     PROGRAM MODIFICATION LOG                   *00160000
      *                                                                *00170000
      *    DATE    INITIALS   COMMENTS                                 *00180000
      *  --------  --------   ---------------------------------------  *00190000
      *  02/04/09  MN90523    PROCEDURE ORIGINALLY CODED.              *00200000
      *                                                                *00200100
      ******************************************************************00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00250000
      *                                                                *00260000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00270000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00280000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00290000
      *  3000 - 4999  NOT USED                                         *00300000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00310000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00320000
      *  7000 - 7999  INPUT MODULES                                    *00330000
      *  8000 - 8999  OUTPUT MODULES                                   *00340000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00350000
      *                                                                *00360000
      ******************************************************************00370000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04186'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04186 STARTS HERE'.                  
                                                                        
      ******************************************************************00780000
      *    WORK AREAS                                                  *00790000
      ******************************************************************00800000
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04186'.      
                                                                        
       01  WORK-FIELDS.                                                 
           05 WS-RATIO-DISP             PIC X(12) VALUE SPACES.         
           05 WS-FILTER-FLAG            PIC S9(9) COMP VALUE 0.         
           05 WS-NO-FLILTER-FLAG        PIC S9(9) COMP VALUE 0.         
           05 WS-LOCAL-OFFICE-FLAG      PIC S9(9) COMP VALUE 2.         
           05 WS-CODE-CRNT-LOC-FLAG     PIC S9(9) COMP VALUE 4.         
           05 WS-XFORMER-TYPE-CD-FLAG   PIC S9(9) COMP VALUE 8.         
           05 WS-XFORMER-SPEC-CD-FLAG   PIC S9(9) COMP VALUE 16.        
           05 WS-ROW-COUNT              PIC S9(9) COMP VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
      ******************THIS IS THE ROW RETURN AREA******************** 01360000
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-XFORMER-NO              PIC X(09)  VALUE SPACES.       
           05  S-BIL-RATING-CD           PIC X(08)  VALUE SPACES.       
           05  S-BURDEN-QT               PIC X(08)  VALUE SPACES.       
           05  S-VOLTAGE-CLASS           PIC X(08)  VALUE SPACES.       
           05  S-RTO-UPPER-FRACTION      PIC S9(5)V9(1) USAGE COMP-3    
                                                    VALUE 0.            
           05  S-RTO-LOWER-FRACTION      PIC S9(4)  USAGE COMP          
                                                    VALUE 0.            
           05  S-RATIO-DISP              PIC X(12)  VALUE SPACES.       
           05  S-XFORMER-TYPE-CD         PIC X(02)  VALUE SPACES.       
           05  S-XFORMER-SIZE-ID         PIC X(08)  VALUE SPACES.       
           05  S-XFORMER-SPEC-CD         PIC X(03)  VALUE SPACES.       
           05  S-XFORMER-CLASS-CD        PIC X(02)  VALUE SPACES.       
           05  S-RATE-FACTOR             PIC S9(1)V9(1) USAGE COMP-3    
                                                    VALUE 0.            
           05  S-CONNECTION-TYPE         PIC X(01)  VALUE SPACES.       
           05  S-CODE-CRNT-LOC           PIC X(01)  VALUE SPACES.       
           05  S-CODE-MAKE               PIC X(02)  VALUE SPACES.       
           05  S-ROW-NUM                 PIC S9(09) COMP VALUE 0.       
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
      ******************************************************************00460000
      *    DB2 INCLUDES                                                *00470000
      ******************************************************************00480000
                                                                        
           EXEC SQL                                                     00500000
              INCLUDE SQLCA                                             00510000
           END-EXEC.                                                    00520000
                                                                        
      ******************************************************************00650100
      * CSS_EQUIPMENT - EQ                                             *00650200
      ******************************************************************00650201
           EXEC SQL                                                     00650202
              INCLUDE TBEQUIP                                           00650203
           END-EXEC.                                                    00650204
      *                                                                 00650205
      ******************************************************************00650206
      * CSS_INSTR_XFORMER - IX                                         *00650207
      ******************************************************************00650208
           EXEC SQL                                                     00650209
              INCLUDE TBINXFOR                                          00650210
           END-EXEC.                                                    00650220
      *                                                                 00650230
      ******************************************************************00650240
      *    COBOL WORKING STORAGE COPY BOOKS                            *00650250
      ******************************************************************00650260
                                                                        
           COPY CWS00303.                                               00650290
                                                                        
           EXEC SQL                                                     00650400
              INCLUDE CWSX0010                                          00650500
           END-EXEC.                                                    00650600
                                                                        
      *                                                                 01720500
      ***************************************************************   01720600
      * CURSOR DECLARATIONS                                             01720700
      ***************************************************************   01720800
      *                                                                 01724300
           EXEC SQL                                                     
             DECLARE LOCAL_OFF_FLTR_CUR CURSOR FOR                      
             SELECT TOP(1000) IX.XFORMER_NO,
              IX.BIL_RATING_CD,
              IX.BURDEN_QT,
              IX.VOLTAGE_CLASS,
              IX.RTO_UPPER_FRACTION,
              IX.RTO_LOWER_FRACTION,
              CIS.CONCAT(COALESCE(                                    
                      CAST(IX.RTO_UPPER_FRACTION AS VARCHAR(MAX)),'0'),         
                    CIS.CONCAT(':',COALESCE(                                
                      CAST(IX.RTO_LOWER_FRACTION AS VARCHAR(MAX)),'0')))        
                                          AS RATIO_DISP,
              IX.XFORMER_TYPE_CD,
              IX.XFORMER_SIZE_ID,
              IX.XFORMER_SPEC_CD,
              IX.XFORMER_CLASS_CD,
              IX.RATE_FACTOR,
              IX.CONNECTION_TYPE,
              EQ.CODE_CRNT_LOC,
              EQ.CODE_MAKE                                        
               FROM                                                     
                    CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                  
                   ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)                  
              WHERE                                                     
                    EQ.DEVICE_NO      = IX.XFORMER_NO                   
                AND EQ.COMPANY_NO     = IX.COMPANY_NO                   
                AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE               
                AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                  
                AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                AND EQ.LOCAL_OFFICE   = :EQ-LOCAL-OFFICE                
              ORDER BY                                                  
                    IX.XFORMER_NO                                       
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01724400
MFA-TR*      DECLARE LOCAL_OFF_FLTR_CUR CURSOR FOR                      01724500
MFA-TR*      SELECT                                                     01724600
MFA-TR*             IX.XFORMER_NO                                         017247
MFA-TR*            ,IX.BIL_RATING_CD                                      017248
MFA-TR*            ,IX.BURDEN_QT                                          017249
MFA-TR*            ,IX.VOLTAGE_CLASS                                      017250
MFA-TR*            ,IX.RTO_UPPER_FRACTION                                 017251
MFA-TR*            ,IX.RTO_LOWER_FRACTION                                 017252
MFA-TR*            ,CONCAT(COALESCE(                                      017253
MFA-TR*               VARCHAR(IX.RTO_UPPER_FRACTION),'0'),                017254
MFA-TR*             CONCAT(':',COALESCE(                                  017255
MFA-TR*               VARCHAR(IX.RTO_LOWER_FRACTION),'0')))               017256
MFA-TR*                                   AS RATIO_DISP                   017257
MFA-TR*            ,IX.XFORMER_TYPE_CD                                    017258
MFA-TR*            ,IX.XFORMER_SIZE_ID                                    017259
MFA-TR*            ,IX.XFORMER_SPEC_CD                                    017260
MFA-TR*            ,IX.XFORMER_CLASS_CD                                   017261
MFA-TR*            ,IX.RATE_FACTOR                                        017262
MFA-TR*            ,IX.CONNECTION_TYPE                                    017263
MFA-TR*            ,EQ.CODE_CRNT_LOC                                      017264
MFA-TR*            ,EQ.CODE_MAKE                                          017265
MFA-TR*        FROM                                                     01726600
MFA-TR*             CSS_INSTR_XFORMER IX                                  017267
MFA-TR*            ,CSS_EQUIPMENT     EQ                                  017268
MFA-TR*       WHERE                                                      0172690
MFA-TR*             EQ.DEVICE_NO      = IX.XFORMER_NO                      01727
MFA-TR*         AND EQ.COMPANY_NO     = IX.COMPANY_NO                      01727
MFA-TR*         AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE                  01727
MFA-TR*         AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                     01727
MFA-TR*         AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                 01727
MFA-TR*         AND EQ.LOCAL_OFFICE   = :EQ-LOCAL-OFFICE                   01727
MFA-TR*       ORDER BY                                                          
MFA-TR*             IX.XFORMER_NO                                               
MFA-TR*       FETCH FIRST 1000 ROWS ONLY                                        
MFA-TR*        WITH UR                                                   0172760
MFA-TR*    END-EXEC.                                                    01727700
                                                                        
           EXEC SQL                                                     
             DECLARE CRNT_LOC_FLTR_CUR CURSOR FOR                       
             SELECT TOP(1000) IX.XFORMER_NO,
              IX.BIL_RATING_CD,
              IX.BURDEN_QT,
              IX.VOLTAGE_CLASS,
              IX.RTO_UPPER_FRACTION,
              IX.RTO_LOWER_FRACTION,
              CIS.CONCAT(COALESCE(                                    
                      CAST(IX.RTO_UPPER_FRACTION AS VARCHAR(MAX)),'0'),         
                    CIS.CONCAT(':',COALESCE(                                
                      CAST(IX.RTO_LOWER_FRACTION AS VARCHAR(MAX)),'0')))        
                                          AS RATIO_DISP,
              IX.XFORMER_TYPE_CD,
              IX.XFORMER_SIZE_ID,
              IX.XFORMER_SPEC_CD,
              IX.XFORMER_CLASS_CD,
              IX.RATE_FACTOR,
              IX.CONNECTION_TYPE,
              EQ.CODE_CRNT_LOC,
              EQ.CODE_MAKE                                        
               FROM                                                     
                    CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                  
                   ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)                  
              WHERE                                                     
                    EQ.DEVICE_NO      = IX.XFORMER_NO                   
                AND EQ.COMPANY_NO     = IX.COMPANY_NO                   
                AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE               
                AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                  
                AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                AND EQ.CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC               
              ORDER BY                                                  
                    IX.XFORMER_NO                                       
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01727900
MFA-TR*      DECLARE CRNT_LOC_FLTR_CUR CURSOR FOR                       01728000
MFA-TR*      SELECT                                                     01728100
MFA-TR*             IX.XFORMER_NO                                         017282
MFA-TR*            ,IX.BIL_RATING_CD                                      017283
MFA-TR*            ,IX.BURDEN_QT                                          017284
MFA-TR*            ,IX.VOLTAGE_CLASS                                      017285
MFA-TR*            ,IX.RTO_UPPER_FRACTION                                 017286
MFA-TR*            ,IX.RTO_LOWER_FRACTION                                 017287
MFA-TR*            ,CONCAT(COALESCE(                                      017288
MFA-TR*               VARCHAR(IX.RTO_UPPER_FRACTION),'0'),                017289
MFA-TR*             CONCAT(':',COALESCE(                                  017290
MFA-TR*               VARCHAR(IX.RTO_LOWER_FRACTION),'0')))               017291
MFA-TR*                                   AS RATIO_DISP                   017292
MFA-TR*            ,IX.XFORMER_TYPE_CD                                    017293
MFA-TR*            ,IX.XFORMER_SIZE_ID                                    017294
MFA-TR*            ,IX.XFORMER_SPEC_CD                                    017295
MFA-TR*            ,IX.XFORMER_CLASS_CD                                   017296
MFA-TR*            ,IX.RATE_FACTOR                                        017297
MFA-TR*            ,IX.CONNECTION_TYPE                                    017298
MFA-TR*            ,EQ.CODE_CRNT_LOC                                      017299
MFA-TR*            ,EQ.CODE_MAKE                                          017300
MFA-TR*        FROM                                                       017301
MFA-TR*             CSS_INSTR_XFORMER IX                                  017302
MFA-TR*            ,CSS_EQUIPMENT     EQ                                  017303
MFA-TR*       WHERE                                                       017304
MFA-TR*             EQ.DEVICE_NO      = IX.XFORMER_NO                      01730
MFA-TR*         AND EQ.COMPANY_NO     = IX.COMPANY_NO                      01730
MFA-TR*         AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE                  01730
MFA-TR*         AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                     01730
MFA-TR*         AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                 01730
MFA-TR*         AND EQ.CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC                  01731
MFA-TR*       ORDER BY                                                          
MFA-TR*             IX.XFORMER_NO                                               
MFA-TR*       FETCH FIRST 1000 ROWS ONLY                                        
MFA-TR*        WITH UR                                                    017311
MFA-TR*    END-EXEC.                                                    01731200
                                                                        
           EXEC SQL                                                     
             DECLARE XFRM_TYP_FLTR_CUR CURSOR FOR                       
             SELECT TOP(1000) IX.XFORMER_NO,
              IX.BIL_RATING_CD,
              IX.BURDEN_QT,
              IX.VOLTAGE_CLASS,
              IX.RTO_UPPER_FRACTION,
              IX.RTO_LOWER_FRACTION,
              CIS.CONCAT(COALESCE(                                    
                      CAST(IX.RTO_UPPER_FRACTION AS VARCHAR(MAX)),'0'),         
                    CIS.CONCAT(':',COALESCE(                                
                      CAST(IX.RTO_LOWER_FRACTION AS VARCHAR(MAX)),'0')))        
                                          AS RATIO_DISP,
              IX.XFORMER_TYPE_CD,
              IX.XFORMER_SIZE_ID,
              IX.XFORMER_SPEC_CD,
              IX.XFORMER_CLASS_CD,
              IX.RATE_FACTOR,
              IX.CONNECTION_TYPE,
              EQ.CODE_CRNT_LOC,
              EQ.CODE_MAKE                                        
               FROM                                                     
                    CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                  
                   ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)                  
              WHERE                                                     
                    EQ.DEVICE_NO       = IX.XFORMER_NO                  
                AND EQ.COMPANY_NO      = IX.COMPANY_NO                  
                AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE              
                AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                 
                AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE             
                AND IX.XFORMER_TYPE_CD = :IX-XFORMER-TYPE-CD            
              ORDER BY                                                  
                    IX.XFORMER_NO                                       
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01731400
MFA-TR*      DECLARE XFRM_TYP_FLTR_CUR CURSOR FOR                       01731500
MFA-TR*      SELECT                                                     01731600
MFA-TR*             IX.XFORMER_NO                                         017317
MFA-TR*            ,IX.BIL_RATING_CD                                      017318
MFA-TR*            ,IX.BURDEN_QT                                          017319
MFA-TR*            ,IX.VOLTAGE_CLASS                                      017320
MFA-TR*            ,IX.RTO_UPPER_FRACTION                                 017321
MFA-TR*            ,IX.RTO_LOWER_FRACTION                                 017322
MFA-TR*            ,CONCAT(COALESCE(                                      017323
MFA-TR*               VARCHAR(IX.RTO_UPPER_FRACTION),'0'),                017324
MFA-TR*             CONCAT(':',COALESCE(                                  017325
MFA-TR*               VARCHAR(IX.RTO_LOWER_FRACTION),'0')))               017326
MFA-TR*                                   AS RATIO_DISP                   017327
MFA-TR*            ,IX.XFORMER_TYPE_CD                                    017328
MFA-TR*            ,IX.XFORMER_SIZE_ID                                    017329
MFA-TR*            ,IX.XFORMER_SPEC_CD                                    017330
MFA-TR*            ,IX.XFORMER_CLASS_CD                                   017331
MFA-TR*            ,IX.RATE_FACTOR                                        017332
MFA-TR*            ,IX.CONNECTION_TYPE                                    017333
MFA-TR*            ,EQ.CODE_CRNT_LOC                                      017334
MFA-TR*            ,EQ.CODE_MAKE                                          017335
MFA-TR*        FROM                                                       017336
MFA-TR*             CSS_INSTR_XFORMER IX                                  017337
MFA-TR*            ,CSS_EQUIPMENT     EQ                                  017338
MFA-TR*       WHERE                                                       017339
MFA-TR*             EQ.DEVICE_NO       = IX.XFORMER_NO                     01734
MFA-TR*         AND EQ.COMPANY_NO      = IX.COMPANY_NO                     01734
MFA-TR*         AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE                 01734
MFA-TR*         AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                    01734
MFA-TR*         AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                01734
MFA-TR*         AND IX.XFORMER_TYPE_CD = :IX-XFORMER-TYPE-CD               01734
MFA-TR*       ORDER BY                                                          
MFA-TR*             IX.XFORMER_NO                                               
MFA-TR*       FETCH FIRST 1000 ROWS ONLY                                        
MFA-TR*        WITH UR                                                    017346
MFA-TR*    END-EXEC.                                                    01734700
                                                                        
           EXEC SQL                                                     
             DECLARE XFRM_SPEC_FLTR_CUR CURSOR FOR                      
             SELECT TOP(1000) IX.XFORMER_NO,
              IX.BIL_RATING_CD,
              IX.BURDEN_QT,
              IX.VOLTAGE_CLASS,
              IX.RTO_UPPER_FRACTION,
              IX.RTO_LOWER_FRACTION,
              CIS.CONCAT(COALESCE(                                    
                      CAST(IX.RTO_UPPER_FRACTION AS VARCHAR(MAX)),'0'),         
                    CIS.CONCAT(':',COALESCE(                                
                      CAST(IX.RTO_LOWER_FRACTION AS VARCHAR(MAX)),'0')))        
                                          AS RATIO_DISP,
              IX.XFORMER_TYPE_CD,
              IX.XFORMER_SIZE_ID,
              IX.XFORMER_SPEC_CD,
              IX.XFORMER_CLASS_CD,
              IX.RATE_FACTOR,
              IX.CONNECTION_TYPE,
              EQ.CODE_CRNT_LOC,
              EQ.CODE_MAKE                                        
               FROM                                                     
                    CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                  
                   ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)                  
              WHERE                                                     
                    EQ.DEVICE_NO       = IX.XFORMER_NO                  
                AND EQ.COMPANY_NO      = IX.COMPANY_NO                  
                AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE              
                AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                 
                AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE             
                AND IX.XFORMER_SPEC_CD = :IX-XFORMER-SPEC-CD            
              ORDER BY                                                  
                    IX.XFORMER_NO                                       
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01734900
MFA-TR*      DECLARE XFRM_SPEC_FLTR_CUR CURSOR FOR                      01735000
MFA-TR*      SELECT                                                     01735100
MFA-TR*             IX.XFORMER_NO                                         017352
MFA-TR*            ,IX.BIL_RATING_CD                                      017353
MFA-TR*            ,IX.BURDEN_QT                                          017354
MFA-TR*            ,IX.VOLTAGE_CLASS                                      017355
MFA-TR*            ,IX.RTO_UPPER_FRACTION                                 017356
MFA-TR*            ,IX.RTO_LOWER_FRACTION                                 017357
MFA-TR*            ,CONCAT(COALESCE(                                      017358
MFA-TR*               VARCHAR(IX.RTO_UPPER_FRACTION),'0'),                017359
MFA-TR*             CONCAT(':',COALESCE(                                  017360
MFA-TR*               VARCHAR(IX.RTO_LOWER_FRACTION),'0')))               017361
MFA-TR*                                   AS RATIO_DISP                   017362
MFA-TR*            ,IX.XFORMER_TYPE_CD                                    017363
MFA-TR*            ,IX.XFORMER_SIZE_ID                                    017364
MFA-TR*            ,IX.XFORMER_SPEC_CD                                    017365
MFA-TR*            ,IX.XFORMER_CLASS_CD                                   017366
MFA-TR*            ,IX.RATE_FACTOR                                        017367
MFA-TR*            ,IX.CONNECTION_TYPE                                    017368
MFA-TR*            ,EQ.CODE_CRNT_LOC                                      017369
MFA-TR*            ,EQ.CODE_MAKE                                          017370
MFA-TR*        FROM                                                       017371
MFA-TR*             CSS_INSTR_XFORMER IX                                  017372
MFA-TR*            ,CSS_EQUIPMENT     EQ                                  017373
MFA-TR*       WHERE                                                       017374
MFA-TR*             EQ.DEVICE_NO       = IX.XFORMER_NO                     01737
MFA-TR*         AND EQ.COMPANY_NO      = IX.COMPANY_NO                     01737
MFA-TR*         AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE                 01737
MFA-TR*         AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                    01737
MFA-TR*         AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                01737
MFA-TR*         AND IX.XFORMER_SPEC_CD = :IX-XFORMER-SPEC-CD               01738
MFA-TR*       ORDER BY                                                          
MFA-TR*             IX.XFORMER_NO                                               
MFA-TR*       FETCH FIRST 1000 ROWS ONLY                                        
MFA-TR*        WITH UR                                                    017381
MFA-TR*    END-EXEC.                                                    01738200
                                                                        
           EXEC SQL                                                     
             DECLARE ALL_FLTR_CUR CURSOR FOR                            
             SELECT TOP(1000) IX.XFORMER_NO,
              IX.BIL_RATING_CD,
              IX.BURDEN_QT,
              IX.VOLTAGE_CLASS,
              IX.RTO_UPPER_FRACTION,
              IX.RTO_LOWER_FRACTION,
              CIS.CONCAT(COALESCE(                                    
                      CAST(IX.RTO_UPPER_FRACTION AS VARCHAR(MAX)),'0'),         
                    CIS.CONCAT(':',COALESCE(                                
                      CAST(IX.RTO_LOWER_FRACTION AS VARCHAR(MAX)),'0')))        
                                          AS RATIO_DISP,
              IX.XFORMER_TYPE_CD,
              IX.XFORMER_SIZE_ID,
              IX.XFORMER_SPEC_CD,
              IX.XFORMER_CLASS_CD,
              IX.RATE_FACTOR,
              IX.CONNECTION_TYPE,
              EQ.CODE_CRNT_LOC,
              EQ.CODE_MAKE                                        
               FROM                                                     
                    CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                  
                   ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)                  
              WHERE                                                     
                    EQ.DEVICE_NO       = IX.XFORMER_NO                  
                AND EQ.COMPANY_NO      = IX.COMPANY_NO                  
                AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE              
                AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                 
                AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE             
                AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC           
                AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE            
                AND IX.XFORMER_SPEC_CD LIKE :IX-XFORMER-SPEC-CD         
                AND IX.XFORMER_TYPE_CD LIKE :IX-XFORMER-TYPE-CD         
              ORDER BY                                                  
                    IX.XFORMER_NO                                       
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01738400
MFA-TR*      DECLARE ALL_FLTR_CUR CURSOR FOR                            01738500
MFA-TR*      SELECT                                                     01738600
MFA-TR*             IX.XFORMER_NO                                         017387
MFA-TR*            ,IX.BIL_RATING_CD                                      017388
MFA-TR*            ,IX.BURDEN_QT                                          017389
MFA-TR*            ,IX.VOLTAGE_CLASS                                      017390
MFA-TR*            ,IX.RTO_UPPER_FRACTION                                 017391
MFA-TR*            ,IX.RTO_LOWER_FRACTION                                 017392
MFA-TR*            ,CONCAT(COALESCE(                                      017393
MFA-TR*               VARCHAR(IX.RTO_UPPER_FRACTION),'0'),                017394
MFA-TR*             CONCAT(':',COALESCE(                                  017395
MFA-TR*               VARCHAR(IX.RTO_LOWER_FRACTION),'0')))               017396
MFA-TR*                                   AS RATIO_DISP                   017397
MFA-TR*            ,IX.XFORMER_TYPE_CD                                    017398
MFA-TR*            ,IX.XFORMER_SIZE_ID                                    017399
MFA-TR*            ,IX.XFORMER_SPEC_CD                                    017400
MFA-TR*            ,IX.XFORMER_CLASS_CD                                   017401
MFA-TR*            ,IX.RATE_FACTOR                                        017402
MFA-TR*            ,IX.CONNECTION_TYPE                                    017403
MFA-TR*            ,EQ.CODE_CRNT_LOC                                      017404
MFA-TR*            ,EQ.CODE_MAKE                                          017405
MFA-TR*        FROM                                                       017406
MFA-TR*             CSS_INSTR_XFORMER IX                                  017407
MFA-TR*            ,CSS_EQUIPMENT     EQ                                  017408
MFA-TR*       WHERE                                                       017409
MFA-TR*             EQ.DEVICE_NO       = IX.XFORMER_NO                     01741
MFA-TR*         AND EQ.COMPANY_NO      = IX.COMPANY_NO                     01741
MFA-TR*         AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE                 01741
MFA-TR*         AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                    01741
MFA-TR*         AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                01741
MFA-TR*         AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC              01741
MFA-TR*         AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE               01741
MFA-TR*         AND IX.XFORMER_SPEC_CD LIKE :IX-XFORMER-SPEC-CD            01741
MFA-TR*         AND IX.XFORMER_TYPE_CD LIKE :IX-XFORMER-TYPE-CD            01741
MFA-TR*       ORDER BY                                                          
MFA-TR*             IX.XFORMER_NO                                               
MFA-TR*       FETCH FIRST 1000 ROWS ONLY                                        
MFA-TR*        WITH UR                                                  01741900
MFA-TR*    END-EXEC.                                                    01742000
                                                                        
HPCCDM*EJECT                                                            01742002
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-COMPANY-NO           PIC X(02).                          
       01 PARM-CODE-UTIL-TYPE       PIC X(01).                          
       01 PARM-LOCAL-OFFICE         PIC X(03).                          
       01 PARM-CODE-CRNT-LOC        PIC X(03).                          
       01 PARM-XFORMER-TYPE-CD      PIC X(03).                          
       01 PARM-XFORMER-SPEC-CD      PIC X(03).                          
      *                                                                 01742011
       PROCEDURE DIVISION USING PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-LOCAL-OFFICE                       
                                PARM-CODE-CRNT-LOC                      
                                PARM-XFORMER-TYPE-CD                    
                                PARM-XFORMER-SPEC-CD.                   
                                                                        
      ******************************************************************01742019
      * 0000-MAINLINE                                                  *01742020
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01742030
      ******************************************************************01750000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01850000
      ******************************************************************01870000
      * 0100-INITIALIZE                                                *01880000
      *                                                                *01940000
      ******************************************************************01950000
      *                                                                 01950100
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
                               WITH ROWSET POSITIONING FOR              
             SELECT                                                     
                    RETURN_CODE                                         
                   ,[ROW_COUNT]                                           
                   ,XFORMER_NO                                          
                   ,BIL_RATING_CD                                       
                   ,BURDEN_QT                                           
                   ,VOLTAGE_CLASS                                       
                   ,RTO_UPPER_FRACTION                                  
                   ,RTO_LOWER_FRACTION                                  
                   ,RATIO_DISP                                          
                   ,XFORMER_TYPE_CD                                     
                   ,XFORMER_SIZE_ID                                     
                   ,XFORMER_SPEC_CD                                     
                   ,XFORMER_CLASS_CD                                    
                   ,RATE_FACTOR                                         
                   ,CONNECTION_TYPE                                     
                   ,CODE_CRNT_LOC                                       
                   ,CODE_MAKE                                           
                   ,ROW_NUM                                             
               FROM                                                     
                    #CSR04186_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     02010100
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                              02010200
MFA-TR*                        WITH ROWSET POSITIONING FOR              02010300
MFA-TR*      SELECT                                                     02010400
MFA-TR*             RETURN_CODE                                           02010 
MFA-TR*            ,ROW_COUNT                                             02010 
MFA-TR*            ,XFORMER_NO                                            02010 
MFA-TR*            ,BIL_RATING_CD                                         02010 
MFA-TR*            ,BURDEN_QT                                             02010 
MFA-TR*            ,VOLTAGE_CLASS                                         02011 
MFA-TR*            ,RTO_UPPER_FRACTION                                    02011 
MFA-TR*            ,RTO_LOWER_FRACTION                                    02011 
MFA-TR*            ,RATIO_DISP                                            02011 
MFA-TR*            ,XFORMER_TYPE_CD                                       02011 
MFA-TR*            ,XFORMER_SIZE_ID                                       02011 
MFA-TR*            ,XFORMER_SPEC_CD                                       02011 
MFA-TR*            ,XFORMER_CLASS_CD                                      02011 
MFA-TR*            ,RATE_FACTOR                                           02011 
MFA-TR*            ,CONNECTION_TYPE                                       02011 
MFA-TR*            ,CODE_CRNT_LOC                                         02012 
MFA-TR*            ,CODE_MAKE                                             02012 
MFA-TR*            ,ROW_NUM                                               02012 
MFA-TR*        FROM                                                        02012
MFA-TR*             SESSION.CSR04186_R1                                    02012
MFA-TR*    END-EXEC.                                                    02012500
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02510000
      ******************************************************************02510001
      * 0100A-DECLARE-GTT                                              *02510002
      ******************************************************************02510003
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04186_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04186_R1
              (                                                          
                 RETURN_CODE              INT                       
                ,[ROW_COUNT]                INT                       
                ,XFORMER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,BIL_RATING_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,BURDEN_QT CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2            
                ,VOLTAGE_CLASS CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,RTO_UPPER_FRACTION       DECIMAL(6,1)                  
                ,RTO_LOWER_FRACTION       SMALLINT                      
                ,RATIO_DISP CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,XFORMER_TYPE_CD CHAR(02)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                      
                ,XFORMER_SIZE_ID CHAR(08)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                      
                ,XFORMER_SPEC_CD CHAR(03)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                      
                ,XFORMER_CLASS_CD CHAR(02)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                      
                ,RATE_FACTOR              DECIMAL(2,1)                  
                ,CONNECTION_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                      
                ,CODE_CRNT_LOC CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,CODE_MAKE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
                ,ROW_NUM                  INT                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04186_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************02511027
      * 1000-PROCESS-INPUT                                             *02511028
      * %   SIGN IS SAME AS 'ALL'                                      *02511029
      ******************************************************************02511030
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS                        
                                          THRU 1200-EXIT                
                                                                        
           MOVE PARM-CODE-UTIL-TYPE       TO EQ-CODE-UTIL-TYPE          
           MOVE PARM-COMPANY-NO           TO EQ-COMPANY-NO              
                                                                        
           IF PARM-LOCAL-OFFICE NOT = '%%%'                             
            AND PARM-LOCAL-OFFICE > SPACES                              
              MOVE PARM-LOCAL-OFFICE      TO EQ-LOCAL-OFFICE            
              ADD WS-LOCAL-OFFICE-FLAG    TO WS-FILTER-FLAG             
           ELSE                                                         
              MOVE '%%%'                  TO EQ-LOCAL-OFFICE            
           END-IF                                                       
                                                                        
           IF PARM-CODE-CRNT-LOC NOT = '%%%'                            
            AND PARM-CODE-CRNT-LOC > SPACES                             
              MOVE PARM-CODE-CRNT-LOC     TO EQ-CODE-CRNT-LOC           
              ADD WS-CODE-CRNT-LOC-FLAG   TO WS-FILTER-FLAG             
           ELSE                                                         
              MOVE '%'                    TO EQ-CODE-CRNT-LOC           
           END-IF                                                       
                                                                        
           IF PARM-XFORMER-TYPE-CD NOT = '%%%'                          
            AND PARM-XFORMER-TYPE-CD > SPACES                           
              MOVE PARM-XFORMER-TYPE-CD   TO IX-XFORMER-TYPE-CD         
              ADD WS-XFORMER-TYPE-CD-FLAG TO WS-FILTER-FLAG             
           ELSE                                                         
              MOVE '%%'                   TO IX-XFORMER-TYPE-CD         
           END-IF                                                       
                                                                        
           IF PARM-XFORMER-SPEC-CD NOT = '%%%'                          
            AND PARM-XFORMER-SPEC-CD > SPACES                           
              MOVE PARM-XFORMER-SPEC-CD   TO IX-XFORMER-SPEC-CD         
              ADD WS-XFORMER-SPEC-CD-FLAG TO WS-FILTER-FLAG             
           ELSE                                                         
              MOVE '%%%'                  TO IX-XFORMER-SPEC-CD         
           END-IF.                                                      
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02800000
      ******************************************************************        
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-COMPANY-NO = SPACES                                  
              MOVE 9997                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATION'             TO ABEND-FUNCTION           
              MOVE 'PARM-COMPANY-NO'        TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                                                                        
           IF PARM-CODE-UTIL-TYPE = SPACES                              
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATION'             TO ABEND-FUNCTION           
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                                                                        
           .                                                            
      *                                                                 02800000
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02810000
      * 2000-PROCESS-OUTPUT.                                           *02820000
      *                                                                *02830000
      ******************************************************************02870000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE WS-FILTER-FLAG                                      
             WHEN WS-LOCAL-OFFICE-FLAG                                  
               PERFORM 2200-PROCESS-LOCAL-OFF-CUR                       
                                          THRU 2200-EXIT                
             WHEN WS-CODE-CRNT-LOC-FLAG                                 
               PERFORM 2300-PROCESS-CRNT-LOC-CUR                        
                                          THRU 2300-EXIT                
             WHEN WS-XFORMER-TYPE-CD-FLAG                               
               PERFORM 2400-PROCESS-XFRM-TYP-CUR                        
                                          THRU 2400-EXIT                
             WHEN WS-XFORMER-SPEC-CD-FLAG                               
               PERFORM 2500-PROCESS-XFRM-SPEC-CUR                       
                                          THRU 2500-EXIT                
             WHEN OTHER                                                 
               IF WS-FILTER-FLAG > WS-NO-FLILTER-FLAG                   
                  PERFORM 2600-PROCESS-ALL-CUR                          
                                          THRU 2600-EXIT                
               ELSE                                                     
                  MOVE 9999                  TO WS-ACTIVE-RETURN-CODE   
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '1200'                TO ACTIVE-PARAGRAPH        
                  MOVE 'VALIDATION'          TO ABEND-FUNCTION          
                  MOVE 'TYPE'                TO TABLE-1                 
                  MOVE 'NO FILTER FOUND'     TO TABLE-ELEMENT-1         
                  MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-EVALUATE.                                                
                                                                        
           IF CTR-ROWS > 0                                              
              PERFORM 8200-UPDATE-REC-COUNT   THRU 8200-EXIT            
           ELSE                                                         
              ADD +1                          TO CTR-ROWS               
              MOVE +100                       TO S-RETURN-CODE          
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02940100
      ******************************************************************02950000
      *2000A-MOVE-RESULT                                                02950100
      ******************************************************************02950200
      *                                                                 02950300
       2000A-MOVE-RESULT.                                               
      *                                                                 02950500
           ADD +1                        TO CTR-ROWS                    
           MOVE +0                       TO S-RETURN-CODE               
           MOVE IX-XFORMER-NO            TO S-XFORMER-NO                
           MOVE IX-BIL-RATING-CD         TO S-BIL-RATING-CD             
           MOVE IX-BURDEN-QT             TO S-BURDEN-QT                 
           MOVE IX-VOLTAGE-CLASS         TO S-VOLTAGE-CLASS             
           MOVE IX-RTO-UPPER-FRACTION    TO S-RTO-UPPER-FRACTION        
           MOVE IX-RTO-LOWER-FRACTION    TO S-RTO-LOWER-FRACTION        
           MOVE WS-RATIO-DISP            TO S-RATIO-DISP                
           MOVE IX-XFORMER-TYPE-CD       TO S-XFORMER-TYPE-CD           
           MOVE IX-XFORMER-SIZE-ID       TO S-XFORMER-SIZE-ID           
           MOVE IX-XFORMER-SPEC-CD       TO S-XFORMER-SPEC-CD           
           MOVE IX-XFORMER-CLASS-CD      TO S-XFORMER-CLASS-CD          
           MOVE IX-RATE-FACTOR           TO S-RATE-FACTOR               
           MOVE IX-CONNECTION-TYPE       TO S-CONNECTION-TYPE           
           MOVE EQ-CODE-CRNT-LOC         TO S-CODE-CRNT-LOC             
           MOVE EQ-CODE-MAKE             TO S-CODE-MAKE                 
           MOVE CTR-ROWS                 TO S-ROW-NUM.                  
      *                                                                 02952400
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04640000
      ******************************************************************05010002
      * 2200-PROCESS-LOCAL-OFF-CUR                                     *05010003
      ******************************************************************05010004
       2200-PROCESS-LOCAL-OFF-CUR.                                      
                                                                        
           PERFORM 7060-REC-CNT-LOCAL-OFF-FLTR   THRU 7060-EXIT.        
                                                                        
           PERFORM 7010-OPEN-LOCAL-OFF-FLTR-CUR  THRU 7010-EXIT.        
                                                                        
           PERFORM 7014-FETCH-LOCAL-OFF-FLTR-CUR THRU 7014-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              PERFORM 7014-FETCH-LOCAL-OFF-FLTR-CUR THRU 7014-EXIT      
           END-PERFORM                                                  
                                                                        
           PERFORM 7018-CLOSE-LOCAL-OFF-FLTR-CUR THRU 7018-EXIT.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05010084
      ******************************************************************05010085
      * 2300-PROCESS-CRNT-LOC-CUR                                      *05010086
      ******************************************************************05010087
       2300-PROCESS-CRNT-LOC-CUR.                                       
                                                                        
           PERFORM 7062-REC-CNT-CRNT-LOC-FLTR    THRU 7062-EXIT.        
                                                                        
           PERFORM 7020-OPEN-CRNT-LOC-FLTR-CUR   THRU 7020-EXIT.        
                                                                        
           PERFORM 7024-FETCH-CRNT-LOC-FLTR-CUR  THRU 7024-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              PERFORM 7024-FETCH-CRNT-LOC-FLTR-CUR THRU 7024-EXIT       
           END-PERFORM                                                  
                                                                        
           PERFORM 7028-CLOSE-CRNT-LOC-FLTR-CUR  THRU 7028-EXIT.        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05011004
      ******************************************************************05011005
      * 2400-PROCESS-XFRM-TYP-CUR                                      *05011006
      ******************************************************************05011007
       2400-PROCESS-XFRM-TYP-CUR.                                       
                                                                        
           PERFORM 7064-REC-CNT-XFRM-TYP-FLTR    THRU 7064-EXIT.        
                                                                        
           PERFORM 7030-OPEN-XFRM-TYP-FLTR-CUR   THRU 7030-EXIT.        
                                                                        
           PERFORM 7034-FETCH-XFRM-TYP-FLTR-CUR  THRU 7034-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              PERFORM 7034-FETCH-XFRM-TYP-FLTR-CUR THRU 7034-EXIT       
           END-PERFORM                                                  
                                                                        
           PERFORM 7038-CLOSE-XFRM-TYP-FLTR-CUR  THRU 7038-EXIT.        
                                                                        
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05011204
      ******************************************************************05011205
      * 2500-PROCESS-XFRM-SPEC-CUR                                     *05011206
      ******************************************************************05011207
       2500-PROCESS-XFRM-SPEC-CUR.                                      
                                                                        
           PERFORM 7066-REC-CNT-XFRM-SPEC-FLTR   THRU 7066-EXIT.        
                                                                        
           PERFORM 7040-OPEN-XFRM-SPEC-FLTR-CUR  THRU 7040-EXIT.        
                                                                        
           PERFORM 7044-FETCH-XFRM-SPEC-FLTR-CUR THRU 7044-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              PERFORM 7044-FETCH-XFRM-SPEC-FLTR-CUR THRU 7044-EXIT      
           END-PERFORM                                                  
                                                                        
           PERFORM 7048-CLOSE-XFRM-SPEC-FLTR-CUR THRU 7048-EXIT.        
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05011404
      ******************************************************************05011405
      * 2600-PROCESS-ALL-CUR                                           *05011406
      ******************************************************************05011407
       2600-PROCESS-ALL-CUR.                                            
                                                                        
           PERFORM 7068-REC-CNT-ALL-FLTR         THRU 7068-EXIT.        
                                                                        
           PERFORM 7050-OPEN-ALL-FLTR-CUR        THRU 7050-EXIT.        
                                                                        
           PERFORM 7054-FETCH-ALL-FLTR-CUR       THRU 7054-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              PERFORM 7054-FETCH-ALL-FLTR-CUR    THRU 7054-EXIT         
           END-PERFORM                                                  
                                                                        
           PERFORM 7058-CLOSE-ALL-FLTR-CUR       THRU 7058-EXIT.        
                                                                        
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05021300
      ******************************************************************05021400
      * 7010-OPEN-LOCAL-OFF-FLTR-CUR.                                  *05021500
      ******************************************************************05021600
      *                                                                 05021700
       7010-OPEN-LOCAL-OFF-FLTR-CUR.                                    
      *                                                                 05021900
            MOVE '7010'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN LOCAL_OFF_FLTR_CUR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'LOCAL_OFF_FLTR_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05024600
      ******************************************************************05024700
      * 7014-FETCH-LOCAL-OFF-FLTR-CUR.                                 *05024800
      ******************************************************************05024900
      *                                                                 05025000
       7014-FETCH-LOCAL-OFF-FLTR-CUR.                                   
      *                                                                 05025200
            MOVE '7014'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                      LOCAL_OFF_FLTR_CUR                                
                 INTO                                                   
                      :IX-XFORMER-NO                                    
                     ,:IX-BIL-RATING-CD                                 
                     ,:IX-BURDEN-QT                                     
                     ,:IX-VOLTAGE-CLASS                                 
                     ,:IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                     ,:WS-RATIO-DISP                                    
                     ,:IX-XFORMER-TYPE-CD                               
                     ,:IX-XFORMER-SIZE-ID                               
                     ,:IX-XFORMER-SPEC-CD                               
                     ,:IX-XFORMER-CLASS-CD                              
                     ,:IX-RATE-FACTOR                                   
                     ,:IX-CONNECTION-TYPE                               
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CODE-MAKE                                     
                                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'LOCAL_OFF_FLTR_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7014-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05029700
      ******************************************************************05029800
      * 7018-CLOSE-LOCAL-OFF-FLTR-CUR.                                 *05029900
      ******************************************************************05030000
      *                                                                 05030100
       7018-CLOSE-LOCAL-OFF-FLTR-CUR.                                   
      *                                                                 05030300
            MOVE '7018'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               CLOSE LOCAL_OFF_FLTR_CUR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'LOCAL_OFF_FLTR_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7018-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05033000
      *                                                                 05033100
      ******************************************************************05033200
      * 7020-OPEN-CRNT-LOC-FLTR-CUR.                                   *05033300
      ******************************************************************05033400
      *                                                                 05033500
       7020-OPEN-CRNT-LOC-FLTR-CUR.                                     
      *                                                                 05033700
            MOVE '7020'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN CRNT_LOC_FLTR_CUR                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'CRNT_LOC_FLTR_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05036400
      ******************************************************************05036500
      * 7024-FETCH-CRNT-LOC-FLTR-CUR.                                  *05036600
      ******************************************************************05036700
      *                                                                 05036800
       7024-FETCH-CRNT-LOC-FLTR-CUR.                                    
      *                                                                 05037000
            MOVE '7024'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                      CRNT_LOC_FLTR_CUR                                 
                 INTO                                                   
                      :IX-XFORMER-NO                                    
                     ,:IX-BIL-RATING-CD                                 
                     ,:IX-BURDEN-QT                                     
                     ,:IX-VOLTAGE-CLASS                                 
                     ,:IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                     ,:WS-RATIO-DISP                                    
                     ,:IX-XFORMER-TYPE-CD                               
                     ,:IX-XFORMER-SIZE-ID                               
                     ,:IX-XFORMER-SPEC-CD                               
                     ,:IX-XFORMER-CLASS-CD                              
                     ,:IX-RATE-FACTOR                                   
                     ,:IX-CONNECTION-TYPE                               
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CODE-MAKE                                     
                                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'CRNT_LOC_FLTR_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7024-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05041500
      ******************************************************************05041600
      * 7028-CLOSE-CRNT-LOC-FLTR-CUR.                                  *05041700
      ******************************************************************05041800
      *                                                                 05041900
       7028-CLOSE-CRNT-LOC-FLTR-CUR.                                    
      *                                                                 05042100
            MOVE '7028'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               CLOSE CRNT_LOC_FLTR_CUR                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'CRNT_LOC_FLTR_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7028-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05044800
      ******************************************************************05044900
      * 7030-OPEN-XFRM-TYP-FLTR-CUR.                                   *05045000
      ******************************************************************05045100
      *                                                                 05045200
       7030-OPEN-XFRM-TYP-FLTR-CUR.                                     
      *                                                                 05045400
            MOVE '7030'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN XFRM_TYP_FLTR_CUR                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'XFRM_TYP_FLTR_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_TYPE_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-TYPE-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05048100
      ******************************************************************05048200
      * 7034-FETCH-XFRM-TYP-FLTR-CUR.                                  *05048300
      ******************************************************************05048400
      *                                                                 05048500
       7034-FETCH-XFRM-TYP-FLTR-CUR.                                    
      *                                                                 05048700
            MOVE '7034'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                      XFRM_TYP_FLTR_CUR                                 
                INTO                                                    
                      :IX-XFORMER-NO                                    
                     ,:IX-BIL-RATING-CD                                 
                     ,:IX-BURDEN-QT                                     
                     ,:IX-VOLTAGE-CLASS                                 
                     ,:IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                     ,:WS-RATIO-DISP                                    
                     ,:IX-XFORMER-TYPE-CD                               
                     ,:IX-XFORMER-SIZE-ID                               
                     ,:IX-XFORMER-SPEC-CD                               
                     ,:IX-XFORMER-CLASS-CD                              
                     ,:IX-RATE-FACTOR                                   
                     ,:IX-CONNECTION-TYPE                               
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CODE-MAKE                                     
                                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'XFRM_TYP_FLTR_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_TYPE_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-TYPE-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7034-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05053200
      ******************************************************************05053300
      * 7038-CLOSE-XFRM-TYP-FLTR-CUR.                                  *05053400
      ******************************************************************05053500
      *                                                                 05053600
       7038-CLOSE-XFRM-TYP-FLTR-CUR.                                    
      *                                                                 05053800
            MOVE '7038'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               CLOSE XFRM_TYP_FLTR_CUR                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'XFRM_TYP_FLTR_CUR'   TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_TYPE_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-TYPE-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7038-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05056500
      *                                                                 05056600
      ******************************************************************05056700
      * 7040-OPEN-XFRM-SPEC-FLTR-CUR.                                  *05056800
      ******************************************************************05056900
      *                                                                 05057000
       7040-OPEN-XFRM-SPEC-FLTR-CUR.                                    
      *                                                                 05057200
            MOVE '7040'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN XFRM_SPEC_FLTR_CUR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'XFRM_SPEC_FLTR_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05059900
      ******************************************************************05060000
      * 7044-FETCH-XFRM-SPEC-FLTR-CUR.                                 *05060100
      ******************************************************************05060200
      *                                                                 05060300
       7044-FETCH-XFRM-SPEC-FLTR-CUR.                                   
      *                                                                 05060500
            MOVE '7044'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                      XFRM_SPEC_FLTR_CUR                                
                INTO                                                    
                      :IX-XFORMER-NO                                    
                     ,:IX-BIL-RATING-CD                                 
                     ,:IX-BURDEN-QT                                     
                     ,:IX-VOLTAGE-CLASS                                 
                     ,:IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                     ,:WS-RATIO-DISP                                    
                     ,:IX-XFORMER-TYPE-CD                               
                     ,:IX-XFORMER-SIZE-ID                               
                     ,:IX-XFORMER-SPEC-CD                               
                     ,:IX-XFORMER-CLASS-CD                              
                     ,:IX-RATE-FACTOR                                   
                     ,:IX-CONNECTION-TYPE                               
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CODE-MAKE                                     
                                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'XFRM_SPEC_FLTR_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7044-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05065000
      ******************************************************************05065100
      * 7048-CLOSE-XFRM-SPEC-FLTR-CUR.                                 *05065200
      ******************************************************************05065300
      *                                                                 05065400
       7048-CLOSE-XFRM-SPEC-FLTR-CUR.                                   
      *                                                                 05065600
            MOVE '7048'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               CLOSE XFRM_SPEC_FLTR_CUR                                 
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'XFRM_SPEC_FLTR_CUR'  TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7048-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05068300
      ******************************************************************05068400
      * 7050-OPEN-ALL-FLTR-CUR.                                        *05068500
      ******************************************************************05068600
      *                                                                 05068700
       7050-OPEN-ALL-FLTR-CUR.                                          
      *                                                                 05068900
            MOVE '7050'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                OPEN ALL_FLTR_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE 'ALL_FLTR_CUR'        TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05071600
      ******************************************************************05071700
      * 7054-FETCH-ALL-FLTR-CUR.                                       *05071800
      ******************************************************************05071900
      *                                                                 05072000
       7054-FETCH-ALL-FLTR-CUR.                                         
      *                                                                 05072200
            MOVE '7054'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                FETCH                                                   
                      ALL_FLTR_CUR                                      
                INTO                                                    
                      :IX-XFORMER-NO                                    
                     ,:IX-BIL-RATING-CD                                 
                     ,:IX-BURDEN-QT                                     
                     ,:IX-VOLTAGE-CLASS                                 
                     ,:IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                     ,:WS-RATIO-DISP                                    
                     ,:IX-XFORMER-TYPE-CD                               
                     ,:IX-XFORMER-SIZE-ID                               
                     ,:IX-XFORMER-SPEC-CD                               
                     ,:IX-XFORMER-CLASS-CD                              
                     ,:IX-RATE-FACTOR                                   
                     ,:IX-CONNECTION-TYPE                               
                     ,:EQ-CODE-CRNT-LOC                                 
                     ,:EQ-CODE-MAKE                                     
                                                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE 'ALL_FLTR_CUR'        TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7054-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05076700
      ******************************************************************05076800
      * 7058-CLOSE-ALL-FLTR-CUR.                                       *05076900
      ******************************************************************05077000
      *                                                                 05077100
       7058-CLOSE-ALL-FLTR-CUR.                                         
      *                                                                 05077300
            MOVE '7058'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
               CLOSE ALL_FLTR_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE 'ALL_FLTR_CUR'        TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7058-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05079901
      ******************************************************************05076800
      * 7060-REC-CNT-LOCAL-OFF-FLTR                                    *05076900
      ******************************************************************05077000
      *                                                                 05077100
       7060-REC-CNT-LOCAL-OFF-FLTR.                                     
      *                                                                 05077300
            MOVE '7060'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       COUNT(1)                                         
                  INTO                                                  
                       :WS-ROW-COUNT                                    
                  FROM                                                  
                       CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)               
                      ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       EQ.DEVICE_NO      = IX.XFORMER_NO                
                   AND EQ.COMPANY_NO     = IX.COMPANY_NO                
                   AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE            
                   AND EQ.COMPANY_NO     = :EQ-COMPANY-NO               
                   AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE           
                   AND EQ.LOCAL_OFFICE   = :EQ-LOCAL-OFFICE             
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    05077600
MFA-TR*         SELECT                                                     01724
MFA-TR*                COUNT(1)                                            01724
MFA-TR*           INTO                                                          
MFA-TR*                :WS-ROW-COUNT                                            
MFA-TR*           FROM                                                     01726
MFA-TR*                CSS_INSTR_XFORMER IX                                01726
MFA-TR*               ,CSS_EQUIPMENT     EQ                                01726
MFA-TR*          WHERE                                                     01726
MFA-TR*                EQ.DEVICE_NO      = IX.XFORMER_NO                      01
MFA-TR*            AND EQ.COMPANY_NO     = IX.COMPANY_NO                      01
MFA-TR*            AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE                  01
MFA-TR*            AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                     01
MFA-TR*            AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                 01
MFA-TR*            AND EQ.LOCAL_OFFICE   = :EQ-LOCAL-OFFICE                   01
MFA-TR*           WITH UR                                                     01
MFA-TR*     END-EXEC.                                                   05077800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05079901
      ******************************************************************05076800
      * 7062-REC-CNT-CRNT-LOC-FLTR                                     *05076900
      ******************************************************************05077000
      *                                                                 05077100
       7062-REC-CNT-CRNT-LOC-FLTR.                                      
      *                                                                 05077300
            MOVE '7062'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       COUNT(1)                                         
                  INTO                                                  
                       :WS-ROW-COUNT                                    
                  FROM                                                  
                       CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)               
                      ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       EQ.DEVICE_NO      = IX.XFORMER_NO                
                   AND EQ.COMPANY_NO     = IX.COMPANY_NO                
                   AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE            
                   AND EQ.COMPANY_NO     = :EQ-COMPANY-NO               
                   AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE           
                   AND EQ.CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC            
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    05077600
MFA-TR*         SELECT                                                     01728
MFA-TR*                COUNT(1)                                               01
MFA-TR*           INTO                                                       01 
MFA-TR*                :WS-ROW-COUNT                                         01 
MFA-TR*           FROM                                                       01 
MFA-TR*                CSS_INSTR_XFORMER IX                                  01 
MFA-TR*               ,CSS_EQUIPMENT     EQ                                  01 
MFA-TR*          WHERE                                                       01 
MFA-TR*                EQ.DEVICE_NO      = IX.XFORMER_NO                      0 
MFA-TR*            AND EQ.COMPANY_NO     = IX.COMPANY_NO                      0 
MFA-TR*            AND EQ.CODE_UTIL_TYPE = IX.CODE_UTIL_TYPE                  0 
MFA-TR*            AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                     0 
MFA-TR*            AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                 0 
MFA-TR*            AND EQ.CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC                  0 
MFA-TR*           WITH UR                                                     0 
MFA-TR*     END-EXEC.                                                   05077800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7062-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05079901
      ******************************************************************05076800
      * 7064-REC-CNT-XFRM-TYP-FLTR                                     *05076900
      ******************************************************************05077000
      *                                                                 05077100
       7064-REC-CNT-XFRM-TYP-FLTR.                                      
      *                                                                 05077300
            MOVE '7064'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       COUNT(1)                                         
                  INTO                                                  
                       :WS-ROW-COUNT                                    
                  FROM                                                  
                       CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)               
                      ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       EQ.DEVICE_NO       = IX.XFORMER_NO               
                   AND EQ.COMPANY_NO      = IX.COMPANY_NO               
                   AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE           
                   AND EQ.COMPANY_NO      = :EQ-COMPANY-NO              
                   AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE          
                   AND IX.XFORMER_TYPE_CD = :IX-XFORMER-TYPE-CD         
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    05077600
MFA-TR*         SELECT                                                     01731
MFA-TR*                COUNT(1)                                               01
MFA-TR*           INTO                                                        01
MFA-TR*                :WS-ROW-COUNT                                          01
MFA-TR*           FROM                                                        01
MFA-TR*                CSS_INSTR_XFORMER IX                                   01
MFA-TR*               ,CSS_EQUIPMENT     EQ                                   01
MFA-TR*          WHERE                                                        01
MFA-TR*                EQ.DEVICE_NO       = IX.XFORMER_NO                     01
MFA-TR*            AND EQ.COMPANY_NO      = IX.COMPANY_NO                     01
MFA-TR*            AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE                 01
MFA-TR*            AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                    01
MFA-TR*            AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                01
MFA-TR*            AND IX.XFORMER_TYPE_CD = :IX-XFORMER-TYPE-CD               01
MFA-TR*           WITH UR                                                     01
MFA-TR*     END-EXEC.                                                   05077800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_TYPE_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-TYPE-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7064-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05077100
      ******************************************************************05076800
      * 7066-REC-CNT-XFRM-SPEC-FLTR                                    *05076900
      ******************************************************************05077000
      *                                                                 05077100
       7066-REC-CNT-XFRM-SPEC-FLTR.                                     
      *                                                                 05077300
            MOVE '7066'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       COUNT(1)                                         
                  INTO                                                  
                       :WS-ROW-COUNT                                    
                  FROM                                                  
                       CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)               
                      ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       EQ.DEVICE_NO       = IX.XFORMER_NO               
                   AND EQ.COMPANY_NO      = IX.COMPANY_NO               
                   AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE           
                   AND EQ.COMPANY_NO      = :EQ-COMPANY-NO              
                   AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE          
                   AND IX.XFORMER_SPEC_CD = :IX-XFORMER-SPEC-CD         
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    05077600
MFA-TR*         SELECT                                                     01735
MFA-TR*                COUNT(1)                                               01
MFA-TR*           INTO                                                        01
MFA-TR*                :WS-ROW-COUNT                                          01
MFA-TR*           FROM                                                        01
MFA-TR*                CSS_INSTR_XFORMER IX                                   01
MFA-TR*               ,CSS_EQUIPMENT     EQ                                   01
MFA-TR*          WHERE                                                        01
MFA-TR*                EQ.DEVICE_NO       = IX.XFORMER_NO                     01
MFA-TR*            AND EQ.COMPANY_NO      = IX.COMPANY_NO                     01
MFA-TR*            AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE                 01
MFA-TR*            AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                    01
MFA-TR*            AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                01
MFA-TR*            AND IX.XFORMER_SPEC_CD = :IX-XFORMER-SPEC-CD               01
MFA-TR*           WITH UR                                                     01
MFA-TR*     END-EXEC.                                                   05077800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'XFORMER_SPEC_CD'     TO TABLE-ELEMENT-3            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE IX-XFORMER-SPEC-CD    TO HOSTVAR-ELEMENT-3          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7066-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05079901
      ******************************************************************05076800
      * 7068-REC-CNT-ALL-FLTR                                          *05076900
      ******************************************************************05077000
      *                                                                 05077100
       7068-REC-CNT-ALL-FLTR.                                           
      *                                                                 05077300
            MOVE '7068'                   TO ACTIVE-PARAGRAPH.          
                                                                        
            EXEC SQL                                                    
                SELECT                                                  
                       COUNT(1)                                         
                  INTO                                                  
                       :WS-ROW-COUNT                                    
                  FROM                                                  
                       CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)               
                      ,CSS_EQUIPMENT     EQ WITH(READUNCOMMITTED)               
                 WHERE                                                  
                       EQ.DEVICE_NO       = IX.XFORMER_NO               
                   AND EQ.COMPANY_NO      = IX.COMPANY_NO               
                   AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE           
                   AND EQ.COMPANY_NO      = :EQ-COMPANY-NO              
                   AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE          
                   AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC        
                   AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE         
                   AND IX.XFORMER_SPEC_CD LIKE :IX-XFORMER-SPEC-CD      
                   AND IX.XFORMER_TYPE_CD LIKE :IX-XFORMER-TYPE-CD      
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    05077600
MFA-TR*         SELECT                                                     01738
MFA-TR*                COUNT(1)                                               01
MFA-TR*           INTO                                                        01
MFA-TR*                :WS-ROW-COUNT                                          01
MFA-TR*           FROM                                                        01
MFA-TR*                CSS_INSTR_XFORMER IX                                   01
MFA-TR*               ,CSS_EQUIPMENT     EQ                                   01
MFA-TR*          WHERE                                                        01
MFA-TR*                EQ.DEVICE_NO       = IX.XFORMER_NO                     01
MFA-TR*            AND EQ.COMPANY_NO      = IX.COMPANY_NO                     01
MFA-TR*            AND EQ.CODE_UTIL_TYPE  = IX.CODE_UTIL_TYPE                 01
MFA-TR*            AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                    01
MFA-TR*            AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                01
MFA-TR*            AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC              01
MFA-TR*            AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE               01
MFA-TR*            AND IX.XFORMER_SPEC_CD LIKE :IX-XFORMER-SPEC-CD            01
MFA-TR*            AND IX.XFORMER_TYPE_CD LIKE :IX-XFORMER-TYPE-CD            01
MFA-TR*           WITH UR                                                     01
MFA-TR*     END-EXEC.                                                   05077800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_EQUIPMENT'       TO TABLE-1                    
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2            
               MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3            
               MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-4            
               MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
               MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2          
               MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3          
               MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-4          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7068-EXIT.                                                       
            EXIT.                                                       
      *                                                                 05079901
      ******************************************************************05079902
      * 8000A-DELETE-GTT-ROWS.                                         *05079903
      ******************************************************************05079904
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 05079906
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
                                                                        
      *                                                                 05079909
            EXEC SQL                                                    
                DELETE FROM #CSR04186_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    05079910
MFA-TR*         DELETE FROM SESSION.CSR04186_R1                         05079911
MFA-TR*     END-EXEC.                                                   05079912

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05079913
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 05079915
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04186_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 05079931
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 06420000
      ******************************************************************06420001
      * 8100-SEND-RESULT.                                              *06420002
      ******************************************************************06420003
       8100-SEND-RESULT.                                                
      *                                                                 06420005
           EXEC SQL                                                     
             INSERT INTO #CSR04186_R1                            
             (                                                          
                    RETURN_CODE                                         
                   ,XFORMER_NO                                          
                   ,BIL_RATING_CD                                       
                   ,BURDEN_QT                                           
                   ,VOLTAGE_CLASS                                       
                   ,RTO_UPPER_FRACTION                                  
                   ,RTO_LOWER_FRACTION                                  
                   ,RATIO_DISP                                          
                   ,XFORMER_TYPE_CD                                     
                   ,XFORMER_SIZE_ID                                     
                   ,XFORMER_SPEC_CD                                     
                   ,XFORMER_CLASS_CD                                    
                   ,RATE_FACTOR                                         
                   ,CONNECTION_TYPE                                     
                   ,CODE_CRNT_LOC                                       
                   ,CODE_MAKE                                           
                   ,ROW_NUM                                             
             )                                                          
             VALUES                                                     
             (                                                          
                    :S-RETURN-CODE                                      
                   ,:S-XFORMER-NO                                       
                   ,:S-BIL-RATING-CD                                    
                   ,:S-BURDEN-QT                                        
                   ,:S-VOLTAGE-CLASS                                    
                   ,:S-RTO-UPPER-FRACTION                               
                   ,:S-RTO-LOWER-FRACTION                               
                   ,:S-RATIO-DISP                                       
                   ,:S-XFORMER-TYPE-CD                                  
                   ,:S-XFORMER-SIZE-ID                                  
                   ,:S-XFORMER-SPEC-CD                                  
                   ,:S-XFORMER-CLASS-CD                                 
                   ,:S-RATE-FACTOR                                      
                   ,:S-CONNECTION-TYPE                                  
                   ,:S-CODE-CRNT-LOC                                    
                   ,:S-CODE-MAKE                                        
                   ,:S-ROW-NUM                                          
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     06420006
MFA-TR*      INSERT INTO SESSION.CSR04186_R1                            06420007
MFA-TR*      (                                                          06420008
MFA-TR*             RETURN_CODE                                           064200
MFA-TR*            ,XFORMER_NO                                            064200
MFA-TR*            ,BIL_RATING_CD                                         064200
MFA-TR*            ,BURDEN_QT                                             064200
MFA-TR*            ,VOLTAGE_CLASS                                         064200
MFA-TR*            ,RTO_UPPER_FRACTION                                    064200
MFA-TR*            ,RTO_LOWER_FRACTION                                    064200
MFA-TR*            ,RATIO_DISP                                            064200
MFA-TR*            ,XFORMER_TYPE_CD                                       064200
MFA-TR*            ,XFORMER_SIZE_ID                                       064200
MFA-TR*            ,XFORMER_SPEC_CD                                       064201
MFA-TR*            ,XFORMER_CLASS_CD                                      064202
MFA-TR*            ,RATE_FACTOR                                           064203
MFA-TR*            ,CONNECTION_TYPE                                       064204
MFA-TR*            ,CODE_CRNT_LOC                                         064205
MFA-TR*            ,CODE_MAKE                                             064206
MFA-TR*            ,ROW_NUM                                               064207
MFA-TR*      )                                                          06420800
MFA-TR*      VALUES                                                     06420900
MFA-TR*      (                                                          06421000
MFA-TR*             :S-RETURN-CODE                                         06421
MFA-TR*            ,:S-XFORMER-NO                                          06421
MFA-TR*            ,:S-BIL-RATING-CD                                       06421
MFA-TR*            ,:S-BURDEN-QT                                           06421
MFA-TR*            ,:S-VOLTAGE-CLASS                                       06421
MFA-TR*            ,:S-RTO-UPPER-FRACTION                                  06421
MFA-TR*            ,:S-RTO-LOWER-FRACTION                                  06421
MFA-TR*            ,:S-RATIO-DISP                                          06421
MFA-TR*            ,:S-XFORMER-TYPE-CD                                     06421
MFA-TR*            ,:S-XFORMER-SIZE-ID                                     06422
MFA-TR*            ,:S-XFORMER-SPEC-CD                                     06422
MFA-TR*            ,:S-XFORMER-CLASS-CD                                    06422
MFA-TR*            ,:S-RATE-FACTOR                                         06422
MFA-TR*            ,:S-CONNECTION-TYPE                                     06422
MFA-TR*            ,:S-CODE-CRNT-LOC                                       06422
MFA-TR*            ,:S-CODE-MAKE                                           06422
MFA-TR*            ,:S-ROW-NUM                                             06422
MFA-TR*      )                                                          06422800
MFA-TR*    END-EXEC.                                                    06422900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04186_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06422918
      ******************************************************************06422919
      * 8200-UPDATE-REC-COUNT                                          *06422920
      ******************************************************************06422930
       8200-UPDATE-REC-COUNT.                                           
                                                                        
            EXEC SQL                                                    
                 UPDATE                                                 
                        #CSR04186_R1                             
                    SET                                                 
                        [ROW_COUNT] = :WS-ROW-COUNT                       
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    06422933
MFA-TR*          UPDATE                                                 06422934
MFA-TR*                 SESSION.CSR04186_R1                             06422935
MFA-TR*             SET                                                 06422936
MFA-TR*                 ROW_COUNT = :WS-ROW-COUNT                       06422937
MFA-TR*       END-EXEC.                                                 06422938

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                 MOVE '8200'               TO ACTIVE-PARAGRAPH          
                 MOVE 'UPDATE'             TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR04186_R1'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF.                                                   
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06423805
      ******************************************************************06423806
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *06423807
      ******************************************************************06423808
                                                                        
           EXEC SQL                                                     06423810
              INCLUDE CPDSP300                                          06423820
           END-EXEC.                                                    06423821
                                                                        
      ******************************************************************06423823
      * 9999- END PROGRAM COPYLIB                                      *06423824
      ******************************************************************06423825
           EXEC SQL                                                     06423826
              INCLUDE CPD00320                                          06423827
           END-EXEC.                                                    06423828
                                                                        
