       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04185.                                         
COB303 DATE-WRITTEN.  DEC 05 2008.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  SELECT SP CALLED BY METER INVENTORY  SYSTEM FOR GAS           *        
      *  INVENTORY SCREENS.                                            *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES DETAILS OF GAS METER DEVICE          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/05/08  SJ94244    PROCEDURE ORIGINALLY CODED.              *        
C14744*  10/17/09  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04185'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04185 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04185'.      
           05  WS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
           05  WS-LOCAL-OFFICE         PIC X(03) VALUE SPACES.          
           05  WS-CODE-CRNT-LOC        PIC X(01) VALUE SPACES.          
           05  WS-METER-SIZE-ID        PIC X(08) VALUE SPACES.          
           05  WS-CODE-MAKE            PIC X(02) VALUE SPACES.          
           05  WS-CCF-CAP-PER-HR-NUM   PIC 9(09) VALUE 0.               
           05  WS-CCF-CAP-PER-HR       PIC X(09) VALUE SPACES.          
           05  WS-CCF-CAP-PER-HR-INT   PIC S9(09) USAGE COMP VALUE 0.   
           05  WS-CCF-CAP-PER-HR-RJT   PIC X(09) VALUE SPACES           
                                                 JUSTIFIED RIGHT.       
           05  WS-SERIAL-NO            PIC X(11) VALUE SPACES.          
C14744     05  WS-IN-TRANSIT-EMP-ID    PIC X(07) VALUE SPACES.          
                                                                        
       01  WS-NULL-IND.                                                 
           05 WS-GM-DATE-LAST-TESTED-NULL   PIC S9(04) COMP.            
           05 WS-EQ-DATE-LAST-TRAN-NULL     PIC S9(04) COMP.            
           05 WS-EQ-DATE-LAST-MOVE-NULL     PIC S9(04) COMP.            
                                                                        
      ********************** THIS IS THE ROW RETURN AREA ***************        
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-REC-COUNT            PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-METER-NO             PIC X(09)  VALUE SPACES.         
           05  RS-CODE-MAKE            PIC X(02)  VALUE SPACES.         
           05  RS-CCF-CAP-PER-HR       PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-MCF-CAP-PER-HR       PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-METER-SIZE-ID        PIC X(08)  VALUE SPACES.         
           05  RS-CODE-METER-TYPE      PIC X(01)  VALUE SPACES.         
           05  RS-MODEL-CD             PIC X(01)  VALUE SPACES.         
           05  RS-LAST-TEST-SEL-DT     PIC X(10)  VALUE SPACES.         
           05  RS-EQUIP-TYPE-CD        PIC X(01)  VALUE SPACES.         
           05  RS-SERIAL-NO            PIC X(11)  VALUE SPACES.         
           05  RS-CODE-CRNT-LOC        PIC X(01)  VALUE SPACES.         
           05  RS-DATE-LAST-TRAN       PIC X(10)  VALUE SPACES.         
           05  RS-DATE-LAST-MOVE       PIC X(10)  VALUE SPACES.         
           05  RS-METER-SIZE-DESC      PIC X(25)  VALUE SPACES.         
C14744     05  RS-IN-TRANSIT-EMP-ID    PIC X(07)  VALUE SPACES.         
           05  RS-ROW-NUM              PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-REC-COUNT             PIC S9(09) USAGE COMP VALUE 0.   
           05  S-METER-NO              PIC X(09)  VALUE SPACES.         
           05  S-CODE-MAKE             PIC X(02)  VALUE SPACES.         
           05  S-CCF-CAP-PER-HR        PIC S9(09) USAGE COMP VALUE 0.   
           05  S-MCF-CAP-PER-HR        PIC S9(09) USAGE COMP VALUE 0.   
           05  S-METER-SIZE-ID         PIC X(08)  VALUE SPACES.         
           05  S-CODE-METER-TYPE       PIC X(01)  VALUE SPACES.         
           05  S-MODEL-CD              PIC X(01)  VALUE SPACES.         
           05  S-LAST-TEST-SEL-DT      PIC X(10)  VALUE SPACES.         
           05  S-EQUIP-TYPE-CD         PIC X(01)  VALUE SPACES.         
           05  S-SERIAL-NO             PIC X(11)  VALUE SPACES.         
           05  S-CODE-CRNT-LOC         PIC X(01)  VALUE SPACES.         
           05  S-DATE-LAST-TRAN        PIC X(10)  VALUE SPACES.         
           05  S-DATE-LAST-MOVE        PIC X(10)  VALUE SPACES.         
           05  S-METER-SIZE-DESC       PIC X(25)  VALUE SPACES.         
C14744     05  S-IN-TRANSIT-EMP-ID     PIC X(07)  VALUE SPACES.         
           05  S-ROW-NUM               PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_EQUIPMENT - EQ                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_GAS_METER_SIZE - M5                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_GAS_METER - GM                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      *    FILTER WHEN THE PROCEDURE GETS ANY VALID INPUTS             *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE METER_FILTER CURSOR FOR                           
              SELECT TOP(1000) GM.METER_NO,
              EQ.CODE_MAKE,
              GM.CCF_CAP_PER_HR,
              GM.MCF_CAP_PER_HR,
              GM.METER_SIZE_ID,
              GM.CODE_METER_TYPE,
              GM.MODEL_CD,
              GM.DATE_LAST_TESTED,
              EQ.DATE_LAST_TRAN,
              EQ.DATE_LAST_MOVE,
              EQ.EQUIP_TYPE_CD,
              EQ.SERIAL_NO,
              EQ.CODE_CRNT_LOC,
              M5.METER_SIZE_DESC,
              EQ.IN_TRANSIT_EMP_ID                               
                FROM                                                    
                     CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE                                                    
                     EQ.COMPANY_NO      = GM.COMPANY_NO                 
                 AND EQ.DEVICE_NO       = GM.METER_NO                   
                 AND GM.CODE_UTIL_TYPE  = EQ.CODE_UTIL_TYPE             
                 AND M5.METER_SIZE_ID   = GM.METER_SIZE_ID              
                 AND M5.COMPANY_NO      = GM.COMPANY_NO                 
                 AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                
                 AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE            
                 AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE           
                 AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC          
                 AND GM.METER_SIZE_ID   LIKE :GM-METER-SIZE-ID          
                 AND EQ.CODE_MAKE       LIKE :EQ-CODE-MAKE              
                 AND EQ.SERIAL_NO       LIKE :EQ-SERIAL-NO              
C14744           AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID    
                 ORDER BY GM.METER_NO                                   
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER_FILTER CURSOR FOR                                   
MFA-TR*       SELECT                                                            
MFA-TR*              GM.METER_NO                                                
MFA-TR*             ,EQ.CODE_MAKE                                               
MFA-TR*             ,GM.CCF_CAP_PER_HR                                          
MFA-TR*             ,GM.MCF_CAP_PER_HR                                          
MFA-TR*             ,GM.METER_SIZE_ID                                           
MFA-TR*             ,GM.CODE_METER_TYPE                                         
MFA-TR*             ,GM.MODEL_CD                                                
MFA-TR*             ,GM.DATE_LAST_TESTED                                        
MFA-TR*             ,EQ.DATE_LAST_TRAN                                          
MFA-TR*             ,EQ.DATE_LAST_MOVE                                          
MFA-TR*             ,EQ.EQUIP_TYPE_CD                                           
MFA-TR*             ,EQ.SERIAL_NO                                               
MFA-TR*             ,EQ.CODE_CRNT_LOC                                           
MFA-TR*             ,M5.METER_SIZE_DESC                                         
MFA-TR*             ,EQ.IN_TRANSIT_EMP_ID                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIPMENT EQ                                           
MFA-TR*             ,CSS_GAS_METER GM                                           
MFA-TR*             ,CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE                                                            
MFA-TR*              EQ.COMPANY_NO      = GM.COMPANY_NO                         
MFA-TR*          AND EQ.DEVICE_NO       = GM.METER_NO                           
MFA-TR*          AND GM.CODE_UTIL_TYPE  = EQ.CODE_UTIL_TYPE                     
MFA-TR*          AND M5.METER_SIZE_ID   = GM.METER_SIZE_ID                      
MFA-TR*          AND M5.COMPANY_NO      = GM.COMPANY_NO                         
MFA-TR*          AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                        
MFA-TR*          AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                    
MFA-TR*          AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE                   
MFA-TR*          AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC                  
MFA-TR*          AND GM.METER_SIZE_ID   LIKE :GM-METER-SIZE-ID                  
MFA-TR*          AND EQ.CODE_MAKE       LIKE :EQ-CODE-MAKE                      
MFA-TR*          AND EQ.SERIAL_NO       LIKE :EQ-SERIAL-NO                      
MFA-TR*          AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID            
MFA-TR*          ORDER BY GM.METER_NO                                           
MFA-TR*          FETCH FIRST 1000 ROWS ONLY                                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS - METER_FILTER_CCF                      *        
      *    FILTER WHEN THE PROCEDURE GETS ANY VALID INPUTS FOR         *        
      *    CCF_CAP_PER_HR AND OTHER INPUT PARAMETER                    *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE METER_FILTER_CCF CURSOR FOR                       
              SELECT TOP(1000) GM.METER_NO,
              EQ.CODE_MAKE,
              GM.CCF_CAP_PER_HR,
              GM.MCF_CAP_PER_HR,
              GM.METER_SIZE_ID,
              GM.CODE_METER_TYPE,
              GM.MODEL_CD,
              GM.DATE_LAST_TESTED,
              EQ.DATE_LAST_TRAN,
              EQ.DATE_LAST_MOVE,
              EQ.EQUIP_TYPE_CD,
              EQ.SERIAL_NO,
              EQ.CODE_CRNT_LOC,
              M5.METER_SIZE_DESC,
              EQ.IN_TRANSIT_EMP_ID                               
                FROM                                                    
                     CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE                                                    
                     EQ.COMPANY_NO     = GM.COMPANY_NO                  
                 AND EQ.DEVICE_NO      = GM.METER_NO                    
                 AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              
                 AND M5.METER_SIZE_ID  = GM.METER_SIZE_ID               
                 AND M5.COMPANY_NO     = GM.COMPANY_NO                  
                 AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                 
                 AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE             
                 AND EQ.LOCAL_OFFICE   LIKE :EQ-LOCAL-OFFICE            
                 AND EQ.CODE_CRNT_LOC  LIKE :EQ-CODE-CRNT-LOC           
                 AND GM.METER_SIZE_ID  LIKE :GM-METER-SIZE-ID           
                 AND EQ.CODE_MAKE      LIKE :EQ-CODE-MAKE               
                 AND GM.CCF_CAP_PER_HR = :GM-CCF-CAP-PER-HR             
                 AND EQ.SERIAL_NO      LIKE :EQ-SERIAL-NO               
C14744           AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID    
                 ORDER BY GM.METER_NO                                   
                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER_FILTER_CCF CURSOR FOR                               
MFA-TR*       SELECT                                                            
MFA-TR*              GM.METER_NO                                                
MFA-TR*             ,EQ.CODE_MAKE                                               
MFA-TR*             ,GM.CCF_CAP_PER_HR                                          
MFA-TR*             ,GM.MCF_CAP_PER_HR                                          
MFA-TR*             ,GM.METER_SIZE_ID                                           
MFA-TR*             ,GM.CODE_METER_TYPE                                         
MFA-TR*             ,GM.MODEL_CD                                                
MFA-TR*             ,GM.DATE_LAST_TESTED                                        
MFA-TR*             ,EQ.DATE_LAST_TRAN                                          
MFA-TR*             ,EQ.DATE_LAST_MOVE                                          
MFA-TR*             ,EQ.EQUIP_TYPE_CD                                           
MFA-TR*             ,EQ.SERIAL_NO                                               
MFA-TR*             ,EQ.CODE_CRNT_LOC                                           
MFA-TR*             ,M5.METER_SIZE_DESC                                         
MFA-TR*             ,EQ.IN_TRANSIT_EMP_ID                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIPMENT EQ                                           
MFA-TR*             ,CSS_GAS_METER GM                                           
MFA-TR*             ,CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE                                                            
MFA-TR*              EQ.COMPANY_NO     = GM.COMPANY_NO                          
MFA-TR*          AND EQ.DEVICE_NO      = GM.METER_NO                            
MFA-TR*          AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                      
MFA-TR*          AND M5.METER_SIZE_ID  = GM.METER_SIZE_ID                       
MFA-TR*          AND M5.COMPANY_NO     = GM.COMPANY_NO                          
MFA-TR*          AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                         
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.LOCAL_OFFICE   LIKE :EQ-LOCAL-OFFICE                    
MFA-TR*          AND EQ.CODE_CRNT_LOC  LIKE :EQ-CODE-CRNT-LOC                   
MFA-TR*          AND GM.METER_SIZE_ID  LIKE :GM-METER-SIZE-ID                   
MFA-TR*          AND EQ.CODE_MAKE      LIKE :EQ-CODE-MAKE                       
MFA-TR*          AND GM.CCF_CAP_PER_HR = :GM-CCF-CAP-PER-HR                     
MFA-TR*          AND EQ.SERIAL_NO      LIKE :EQ-SERIAL-NO                       
MFA-TR*          AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID            
MFA-TR*          ORDER BY GM.METER_NO                                           
MFA-TR*          FETCH FIRST 1000 ROWS ONLY                                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      *    FOR FINAL RETURN                                            *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
                                WITH ROWSET POSITIONING FOR             
              SELECT                                                    
                  RETURN_CODE                                           
                 ,REC_COUNT                                             
                 ,METER_NO                                              
                 ,CODE_MAKE                                             
                 ,CCF_CAP_PER_HR                                        
                 ,MCF_CAP_PER_HR                                        
                 ,METER_SIZE_ID                                         
                 ,CODE_METER_TYPE                                       
                 ,MODEL_CD                                              
                 ,LAST_TEST_SEL_DT                                      
                 ,EQUIP_TYPE_CD                                         
                 ,SERIAL_NO                                             
                 ,CODE_CRNT_LOC                                         
                 ,DATE_LAST_TRAN                                        
                 ,DATE_LAST_MOVE                                        
                 ,METER_SIZE_DESC                                       
C14744           ,IN_TRANSIT_EMP_ID                                     
                 ,ROW_NUM                                               
              FROM #CSR04185_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*       SELECT                                                            
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,REC_COUNT                                                     
MFA-TR*          ,METER_NO                                                      
MFA-TR*          ,CODE_MAKE                                                     
MFA-TR*          ,CCF_CAP_PER_HR                                                
MFA-TR*          ,MCF_CAP_PER_HR                                                
MFA-TR*          ,METER_SIZE_ID                                                 
MFA-TR*          ,CODE_METER_TYPE                                               
MFA-TR*          ,MODEL_CD                                                      
MFA-TR*          ,LAST_TEST_SEL_DT                                              
MFA-TR*          ,EQUIP_TYPE_CD                                                 
MFA-TR*          ,SERIAL_NO                                                     
MFA-TR*          ,CODE_CRNT_LOC                                                 
MFA-TR*          ,DATE_LAST_TRAN                                                
MFA-TR*          ,DATE_LAST_MOVE                                                
MFA-TR*          ,METER_SIZE_DESC                                               
MFA-TR*          ,IN_TRANSIT_EMP_ID                                             
MFA-TR*          ,ROW_NUM                                                       
MFA-TR*       FROM SESSION.CSR04185_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-COMPANY-NO       PIC X(02).                              
       01 PARM-CODE-UTIL-TYPE   PIC X(01).                              
       01 PARM-LOCAL-OFFICE     PIC X(03).                              
       01 PARM-CODE-CRNT-LOC    PIC X(01).                              
       01 PARM-METER-SIZE-ID    PIC X(08).                              
       01 PARM-CODE-MAKE        PIC X(02).                              
       01 PARM-CCF-CAP-PER-HR   PIC X(09).                              
       01 PARM-SERIAL-NO        PIC X(11).                              
C14744 01 PARM-IN-TRANSIT-EMP-ID PIC X(07).                             
      *                                                                         
       PROCEDURE DIVISION USING PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-LOCAL-OFFICE                       
                                PARM-CODE-CRNT-LOC                      
                                PARM-METER-SIZE-ID                      
                                PARM-CODE-MAKE                          
                                PARM-CCF-CAP-PER-HR                     
                                PARM-SERIAL-NO                          
C14744                          PARM-IN-TRANSIT-EMP-ID.                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04185_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04185_R1
              (                                                         
                RETURN_CODE             INT                         
               ,REC_COUNT               INT                         
               ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2              
               ,CODE_MAKE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,CCF_CAP_PER_HR          INT                         
               ,MCF_CAP_PER_HR          INT                         
               ,METER_SIZE_ID CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,CODE_METER_TYPE CHAR(01)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,MODEL_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
               ,LAST_TEST_SEL_DT CHAR(10)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,EQUIP_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,SERIAL_NO CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,CODE_CRNT_LOC CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,DATE_LAST_TRAN CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,DATE_LAST_MOVE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,METER_SIZE_DESC CHAR(25)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
C14744         ,IN_TRANSIT_EMP_ID CHAR(07)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,ROW_NUM                 INT                         
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04185_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO.               
           MOVE PARM-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE.           
           MOVE PARM-LOCAL-OFFICE       TO WS-LOCAL-OFFICE.             
           MOVE PARM-CODE-CRNT-LOC      TO WS-CODE-CRNT-LOC.            
           MOVE PARM-METER-SIZE-ID      TO WS-METER-SIZE-ID.            
           MOVE PARM-CODE-MAKE          TO WS-CODE-MAKE.                
           MOVE PARM-CCF-CAP-PER-HR     TO WS-CCF-CAP-PER-HR.           
           MOVE PARM-SERIAL-NO          TO WS-SERIAL-NO.                
C14744     MOVE PARM-IN-TRANSIT-EMP-ID  TO WS-IN-TRANSIT-EMP-ID.        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS  THRU 1200-EXIT.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *1200-VALIDATE-INPUT-ARGUMENTS                                   *        
      ******************************************************************        
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE = SPACES                              
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF PARM-COMPANY-NO = SPACES                                  
              MOVE 9997                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'PARM-COMPANY-NO'        TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      * THE '%' REFERS TO 'ALL' IN THIS PARAGRAPH                      *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF (WS-CCF-CAP-PER-HR > SPACES) THEN                         
              UNSTRING WS-CCF-CAP-PER-HR DELIMITED BY SPACES            
              INTO WS-CCF-CAP-PER-HR-RJT                                
              INSPECT WS-CCF-CAP-PER-HR-RJT REPLACING LEADING           
              SPACES BY '0'                                             
              MOVE WS-CCF-CAP-PER-HR-RJT     TO WS-CCF-CAP-PER-HR       
           END-IF.                                                      
                                                                        
           IF (WS-LOCAL-OFFICE NOT = '%%%'       AND                    
               WS-LOCAL-OFFICE > SPACES                 ) OR            
              (WS-CODE-CRNT-LOC NOT = '%'        AND                    
               WS-CODE-CRNT-LOC > SPACES                ) OR            
              (WS-METER-SIZE-ID NOT = '%%%%%%%%' AND                    
               WS-METER-SIZE-ID > SPACES                ) OR            
              (WS-CODE-MAKE  NOT = '%%'          AND                    
               WS-CODE-MAKE > SPACES                    ) OR            
              (WS-CCF-CAP-PER-HR NOT = SPACES    AND                    
               WS-CCF-CAP-PER-HR IS NUMERIC             ) OR            
              (WS-SERIAL-NO NOT = '%%%%%%%%%%%'  AND                    
               WS-SERIAL-NO > SPACES                    ) OR            
C14744        (WS-IN-TRANSIT-EMP-ID NOT = '%%%%%%%'  AND                
C14744         WS-IN-TRANSIT-EMP-ID > SPACES            )               
              PERFORM 2100-PROCESS-FILTER      THRU 2100-EXIT           
           ELSE                                                         
              MOVE 9999                     TO WS-ACTIVE-RETURN-CODE    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'NO-FILTER-USED'         TO ABEND-FUNCTION           
              MOVE 'PARM-LOCAL-OFFICE'      TO TABLE-1                  
              MOVE 'PARM-LOCAL-OFFICE'      TO TABLE-ELEMENT-1          
              MOVE PARM-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-1        
              MOVE 'PARM-CODE-CRNT-LOC'     TO TABLE-2                  
              MOVE 'PARM-CODE-CRNT-LOC'     TO TABLE-ELEMENT-2          
              MOVE PARM-CODE-CRNT-LOC       TO HOSTVAR-ELEMENT-2        
              MOVE 'PARM-METER-SIZE-ID'     TO TABLE-3                  
              MOVE 'PARM-METER-SIZE-ID'     TO TABLE-ELEMENT-3          
              MOVE PARM-METER-SIZE-ID       TO HOSTVAR-ELEMENT-3        
              MOVE 'PARM-SERIAL-NO'         TO TABLE-4                  
              MOVE 'PARM-SERIAL-NO'         TO TABLE-ELEMENT-4          
              MOVE PARM-SERIAL-NO           TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT.                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
              MOVE RS-RETURN-CODE        TO S-RETURN-CODE.              
              MOVE RS-REC-COUNT          TO S-REC-COUNT.                
              MOVE RS-METER-NO           TO S-METER-NO.                 
              MOVE RS-CODE-MAKE          TO S-CODE-MAKE.                
              MOVE RS-CCF-CAP-PER-HR     TO S-CCF-CAP-PER-HR.           
              MOVE RS-MCF-CAP-PER-HR     TO S-MCF-CAP-PER-HR.           
              MOVE RS-METER-SIZE-ID      TO S-METER-SIZE-ID.            
              MOVE RS-CODE-METER-TYPE    TO S-CODE-METER-TYPE.          
              MOVE RS-MODEL-CD           TO S-MODEL-CD.                 
              MOVE RS-LAST-TEST-SEL-DT   TO S-LAST-TEST-SEL-DT.         
              MOVE RS-EQUIP-TYPE-CD      TO S-EQUIP-TYPE-CD.            
              MOVE RS-SERIAL-NO          TO S-SERIAL-NO.                
              MOVE RS-CODE-CRNT-LOC      TO S-CODE-CRNT-LOC.            
              MOVE RS-DATE-LAST-TRAN     TO S-DATE-LAST-TRAN.           
              MOVE RS-DATE-LAST-MOVE     TO S-DATE-LAST-MOVE.           
              MOVE RS-METER-SIZE-DESC    TO S-METER-SIZE-DESC.          
C14744        MOVE RS-IN-TRANSIT-EMP-ID  TO S-IN-TRANSIT-EMP-ID.        
              MOVE RS-ROW-NUM            TO S-ROW-NUM.                  
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-FILTER                                            *        
      * THE '%' REFERS TO 'ALL' IN THIS PARAGRAPH                      *        
      ******************************************************************        
       2100-PROCESS-FILTER.                                             
                                                                        
           MOVE WS-COMPANY-NO          TO EQ-COMPANY-NO.                
           MOVE WS-CODE-UTIL-TYPE      TO EQ-CODE-UTIL-TYPE.            
      *                                                                         
           IF WS-LOCAL-OFFICE = '%%%' OR                                
              WS-LOCAL-OFFICE = SPACES                                  
              MOVE '%%%'                  TO EQ-LOCAL-OFFICE            
           ELSE                                                         
              MOVE WS-LOCAL-OFFICE        TO EQ-LOCAL-OFFICE            
           END-IF.                                                      
      *                                                                         
           IF WS-CODE-CRNT-LOC = '%' OR                                 
              WS-CODE-CRNT-LOC = SPACE                                  
              MOVE '%'                    TO EQ-CODE-CRNT-LOC           
           ELSE                                                         
              MOVE WS-CODE-CRNT-LOC       TO EQ-CODE-CRNT-LOC           
           END-IF.                                                      
      *                                                                         
           IF WS-METER-SIZE-ID = '%%%%%%%%' OR                          
              WS-METER-SIZE-ID = SPACES                                 
              MOVE '%%%%%%%%'             TO GM-METER-SIZE-ID           
           ELSE                                                         
              MOVE WS-METER-SIZE-ID       TO GM-METER-SIZE-ID           
           END-IF.                                                      
      *                                                                         
           IF WS-CODE-MAKE = '%%' OR                                    
              WS-CODE-MAKE = SPACES                                     
              MOVE '%%'                   TO EQ-CODE-MAKE               
           ELSE                                                         
              MOVE WS-CODE-MAKE           TO EQ-CODE-MAKE               
           END-IF.                                                      
                                                                        
           IF WS-SERIAL-NO = '%%%%%%%%%%%' OR                           
              WS-SERIAL-NO = SPACES                                     
              MOVE '%%%%%%%%%%%'          TO EQ-SERIAL-NO               
           ELSE                                                         
              MOVE WS-SERIAL-NO           TO EQ-SERIAL-NO               
           END-IF.                                                      
      *                                                                         
C14744     IF WS-IN-TRANSIT-EMP-ID = '%%%%%%%%' OR                      
C14744        WS-IN-TRANSIT-EMP-ID = SPACES                             
C14744        MOVE '%%%%%%%'          TO EQ-IN-TRANSIT-EMP-ID           
C14744     ELSE                                                         
C14744        MOVE WS-IN-TRANSIT-EMP-ID   TO EQ-IN-TRANSIT-EMP-ID       
C14744     END-IF.                                                      
C14744*                                                                         
           IF ( WS-CCF-CAP-PER-HR  NOT = SPACES  AND                    
                WS-CCF-CAP-PER-HR IS NUMERIC )                          
              MOVE WS-CCF-CAP-PER-HR     TO WS-CCF-CAP-PER-HR-NUM       
              MOVE WS-CCF-CAP-PER-HR-NUM TO WS-CCF-CAP-PER-HR-INT       
              MOVE WS-CCF-CAP-PER-HR-INT TO GM-CCF-CAP-PER-HR           
                                                                        
              PERFORM 7260-GET-REC-CNT-MTR-FLTR-CCF THRU 7260-EXIT      
              PERFORM 7150-OPEN-METER-FILTER-CCF    THRU 7150-EXIT      
              PERFORM 2130-PROCESS-FETCH-FILTER-CCF THRU 2130-EXIT      
                         UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND        
              PERFORM 7170-CLOSE-METER-FILTER-CCF   THRU 7170-EXIT      
           ELSE                                                         
              PERFORM 7250-GET-REC-CNT-METER-FILTER THRU 7250-EXIT      
              PERFORM 7100-OPEN-METER-FILTER        THRU 7100-EXIT      
              PERFORM 2120-PROCESS-FETCH-FILTER     THRU 2120-EXIT      
                        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND         
              PERFORM 7140-CLOSE-METER-FILTER       THRU 7140-EXIT      
           END-IF.                                                      
                                                                        
           IF CTR-ROWS > 0                                              
              PERFORM 8200-UPDATE-REC-COUNT         THRU 8200-EXIT      
           ELSE                                                         
              ADD +1                     TO CTR-ROWS                    
              MOVE +100                  TO S-RETURN-CODE               
              PERFORM 8100-SEND-RESULT              THRU 8100-EXIT      
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-PROCESS-FETCH-FILTER                                      *        
      ******************************************************************        
       2120-PROCESS-FETCH-FILTER.                                       
      *                                                                         
           PERFORM 7120-FETCH-METER-FILTER     THRU 7120-EXIT           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                      TO RS-ROW-NUM                  
                                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE GM-METER-NO           TO RS-METER-NO                 
              MOVE EQ-CODE-MAKE          TO RS-CODE-MAKE                
              MOVE GM-CCF-CAP-PER-HR     TO RS-CCF-CAP-PER-HR           
              MOVE GM-MCF-CAP-PER-HR     TO RS-MCF-CAP-PER-HR           
              MOVE GM-METER-SIZE-ID      TO RS-METER-SIZE-ID            
              MOVE GM-CODE-METER-TYPE    TO RS-CODE-METER-TYPE          
              MOVE GM-MODEL-CD           TO RS-MODEL-CD                 
                                                                        
              IF WS-GM-DATE-LAST-TESTED-NULL = -1                       
                 MOVE 'N/A'              TO RS-LAST-TEST-SEL-DT         
                 MOVE 0                  TO WS-GM-DATE-LAST-TESTED-NULL 
              ELSE                                                      
                 MOVE GM-DATE-LAST-TESTED   TO RS-LAST-TEST-SEL-DT      
              END-IF                                                    
                                                                        
              MOVE EQ-EQUIP-TYPE-CD      TO RS-EQUIP-TYPE-CD            
              MOVE EQ-SERIAL-NO          TO RS-SERIAL-NO                
              MOVE EQ-CODE-CRNT-LOC      TO RS-CODE-CRNT-LOC            
C14744        MOVE EQ-IN-TRANSIT-EMP-ID  TO RS-IN-TRANSIT-EMP-ID        
                                                                        
              IF WS-EQ-DATE-LAST-TRAN-NULL = -1                         
                 MOVE 'N/A'              TO RS-DATE-LAST-TRAN           
                 MOVE 0                  TO WS-EQ-DATE-LAST-TRAN-NULL   
              ELSE                                                      
                 MOVE EQ-DATE-LAST-TRAN  TO RS-DATE-LAST-TRAN           
              END-IF                                                    
                                                                        
              IF WS-EQ-DATE-LAST-MOVE-NULL = -1                         
                 MOVE 'N/A'              TO RS-DATE-LAST-MOVE           
                 MOVE 0                  TO WS-EQ-DATE-LAST-MOVE-NULL   
              ELSE                                                      
                 MOVE EQ-DATE-LAST-MOVE  TO RS-DATE-LAST-MOVE           
              END-IF                                                    
                                                                        
              MOVE M5-METER-SIZE-DESC    TO RS-METER-SIZE-DESC          
                                                                        
              MOVE '2120'                TO ACTIVE-PARAGRAPH            
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
      *                                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2130-PROCESS-FETCH-FILTER-CCF                                  *        
      ******************************************************************        
       2130-PROCESS-FETCH-FILTER-CCF.                                   
      *                                                                         
           PERFORM 7160-FETCH-METER-FILTER-CCF THRU 7160-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                      TO RS-ROW-NUM                  
                                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE GM-METER-NO           TO RS-METER-NO                 
              MOVE EQ-CODE-MAKE          TO RS-CODE-MAKE                
              MOVE GM-CCF-CAP-PER-HR     TO RS-CCF-CAP-PER-HR           
              MOVE GM-MCF-CAP-PER-HR     TO RS-MCF-CAP-PER-HR           
              MOVE GM-METER-SIZE-ID      TO RS-METER-SIZE-ID            
              MOVE GM-CODE-METER-TYPE    TO RS-CODE-METER-TYPE          
              MOVE GM-MODEL-CD           TO RS-MODEL-CD                 
                                                                        
              IF WS-GM-DATE-LAST-TESTED-NULL = -1                       
                 MOVE 'N/A'              TO RS-LAST-TEST-SEL-DT         
                 MOVE 0                  TO WS-GM-DATE-LAST-TESTED-NULL 
              ELSE                                                      
                 MOVE GM-DATE-LAST-TESTED   TO RS-LAST-TEST-SEL-DT      
              END-IF                                                    
                                                                        
              MOVE EQ-EQUIP-TYPE-CD      TO RS-EQUIP-TYPE-CD            
              MOVE EQ-SERIAL-NO          TO RS-SERIAL-NO                
              MOVE EQ-CODE-CRNT-LOC      TO RS-CODE-CRNT-LOC            
C14744        MOVE EQ-IN-TRANSIT-EMP-ID  TO RS-IN-TRANSIT-EMP-ID        
                                                                        
              IF WS-EQ-DATE-LAST-TRAN-NULL = -1                         
                 MOVE 'N/A'              TO RS-DATE-LAST-TRAN           
                 MOVE 0                  TO WS-EQ-DATE-LAST-TRAN-NULL   
              ELSE                                                      
                 MOVE EQ-DATE-LAST-TRAN  TO RS-DATE-LAST-TRAN           
              END-IF                                                    
                                                                        
              IF WS-EQ-DATE-LAST-MOVE-NULL = -1                         
                 MOVE 'N/A'              TO RS-DATE-LAST-MOVE           
                 MOVE 0                  TO WS-EQ-DATE-LAST-MOVE-NULL   
              ELSE                                                      
                 MOVE EQ-DATE-LAST-MOVE  TO RS-DATE-LAST-MOVE           
              END-IF                                                    
                                                                        
              MOVE M5-METER-SIZE-DESC    TO RS-METER-SIZE-DESC          
              MOVE '2130'                TO ACTIVE-PARAGRAPH            
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
      *                                                                         
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-METER-FILTER                                         *        
      ******************************************************************        
       7100-OPEN-METER-FILTER.                                          
                                                                        
           EXEC SQL                                                     
              OPEN METER_FILTER                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'CSS_GAS_METER'      TO TABLE-2                      
              MOVE 'CSS_GAS_METER_SIZE' TO TABLE-3                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'SERIAL_NO'          TO TABLE-ELEMENT-2              
              MOVE 'CODE_MAKE'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE EQ-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE EQ-SERIAL-NO         TO HOSTVAR-ELEMENT-2            
              MOVE EQ-CODE-MAKE         TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-FETCH-METER-FILTER                                        *        
      ******************************************************************        
       7120-FETCH-METER-FILTER.                                         
                                                                        
           EXEC SQL                                                     
              FETCH METER_FILTER                                        
               INTO :GM-METER-NO                                        
                   ,:EQ-CODE-MAKE                                       
                   ,:GM-CCF-CAP-PER-HR                                  
                   ,:GM-MCF-CAP-PER-HR                                  
                   ,:GM-METER-SIZE-ID                                   
                   ,:GM-CODE-METER-TYPE                                 
                   ,:GM-MODEL-CD                                        
                   ,:GM-DATE-LAST-TESTED :WS-GM-DATE-LAST-TESTED-NULL   
                   ,:EQ-DATE-LAST-TRAN :WS-EQ-DATE-LAST-TRAN-NULL       
                   ,:EQ-DATE-LAST-MOVE :WS-EQ-DATE-LAST-MOVE-NULL       
                   ,:EQ-EQUIP-TYPE-CD                                   
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:M5-METER-SIZE-DESC                                 
C14744             ,:EQ-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'CSS_GAS_METER'      TO TABLE-2                      
              MOVE 'CSS_GAS_METER_SIZE' TO TABLE-3                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'SERIAL_NO'          TO TABLE-ELEMENT-2              
              MOVE 'CODE_MAKE'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE EQ-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE EQ-SERIAL-NO         TO HOSTVAR-ELEMENT-2            
              MOVE EQ-CODE-MAKE         TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7140-CLOSE-METER-FILTER                                        *        
      ******************************************************************        
       7140-CLOSE-METER-FILTER.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE METER_FILTER                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7140'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'CSS_GAS_METER'      TO TABLE-2                      
              MOVE 'CSS_GAS_METER_SIZE' TO TABLE-3                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'SERIAL_NO'          TO TABLE-ELEMENT-2              
              MOVE 'CODE_MAKE'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE EQ-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE EQ-SERIAL-NO         TO HOSTVAR-ELEMENT-2            
              MOVE EQ-CODE-MAKE         TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-OPEN-METER-FILTER-CCF                                     *        
      ******************************************************************        
       7150-OPEN-METER-FILTER-CCF.                                      
                                                                        
           EXEC SQL                                                     
              OPEN METER_FILTER_CCF                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7150'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'CSS_GAS_METER'      TO TABLE-2                      
              MOVE 'CSS_GAS_METER_SIZE' TO TABLE-3                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'SERIAL_NO'          TO TABLE-ELEMENT-2              
              MOVE 'CODE_MAKE'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE EQ-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE EQ-SERIAL-NO         TO HOSTVAR-ELEMENT-2            
              MOVE EQ-CODE-MAKE         TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7160-FETCH-METER-FILTER-CCF                                    *        
      ******************************************************************        
       7160-FETCH-METER-FILTER-CCF.                                     
                                                                        
           EXEC SQL                                                     
              FETCH METER_FILTER_CCF                                    
               INTO :GM-METER-NO                                        
                   ,:EQ-CODE-MAKE                                       
                   ,:GM-CCF-CAP-PER-HR                                  
                   ,:GM-MCF-CAP-PER-HR                                  
                   ,:GM-METER-SIZE-ID                                   
                   ,:GM-CODE-METER-TYPE                                 
                   ,:GM-MODEL-CD                                        
                   ,:GM-DATE-LAST-TESTED :WS-GM-DATE-LAST-TESTED-NULL   
                   ,:EQ-DATE-LAST-TRAN :WS-EQ-DATE-LAST-TRAN-NULL       
                   ,:EQ-DATE-LAST-MOVE :WS-EQ-DATE-LAST-MOVE-NULL       
                   ,:EQ-EQUIP-TYPE-CD                                   
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:M5-METER-SIZE-DESC                                 
C14744             ,:EQ-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7160'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'CSS_GAS_METER'      TO TABLE-2                      
              MOVE 'CSS_GAS_METER_SIZE' TO TABLE-3                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'SERIAL_NO'          TO TABLE-ELEMENT-2              
              MOVE 'CODE_MAKE'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE EQ-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE EQ-SERIAL-NO         TO HOSTVAR-ELEMENT-2            
              MOVE EQ-CODE-MAKE         TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-CLOSE-METER-FILTER-CCF                                    *        
      ******************************************************************        
       7170-CLOSE-METER-FILTER-CCF.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE METER_FILTER_CCF                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7170'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIPMENT'      TO TABLE-1                      
              MOVE 'CSS_GAS_METER'      TO TABLE-2                      
              MOVE 'CSS_GAS_METER_SIZE' TO TABLE-3                      
              MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1              
              MOVE 'SERIAL_NO'          TO TABLE-ELEMENT-2              
              MOVE 'CODE_MAKE'          TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE EQ-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1            
              MOVE EQ-SERIAL-NO         TO HOSTVAR-ELEMENT-2            
              MOVE EQ-CODE-MAKE         TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05076800
      *7250-GET-REC-CNT-METER-FILTER                                   *05076900
      ******************************************************************05077000
       7250-GET-REC-CNT-METER-FILTER.                                   
      *                                                                 05077300
           EXEC SQL                                                     
              SELECT                                                    
                     COUNT(1)                                           
                INTO                                                    
                     :WS-ROW-COUNT                                      
                FROM                                                    
                     CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE                                                    
                     EQ.COMPANY_NO      = GM.COMPANY_NO                 
                 AND EQ.DEVICE_NO       = GM.METER_NO                   
                 AND GM.CODE_UTIL_TYPE  = EQ.CODE_UTIL_TYPE             
                 AND M5.METER_SIZE_ID   = GM.METER_SIZE_ID              
                 AND M5.COMPANY_NO      = GM.COMPANY_NO                 
                 AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                
                 AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE            
                 AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE           
                 AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC          
                 AND GM.METER_SIZE_ID   LIKE :GM-METER-SIZE-ID          
                 AND EQ.CODE_MAKE       LIKE :EQ-CODE-MAKE              
                 AND EQ.SERIAL_NO       LIKE :EQ-SERIAL-NO              
C14744           AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              COUNT(1)                                                   
MFA-TR*         INTO                                                            
MFA-TR*              :WS-ROW-COUNT                                              
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIPMENT EQ                                           
MFA-TR*             ,CSS_GAS_METER GM                                           
MFA-TR*             ,CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE                                                            
MFA-TR*              EQ.COMPANY_NO      = GM.COMPANY_NO                         
MFA-TR*          AND EQ.DEVICE_NO       = GM.METER_NO                           
MFA-TR*          AND GM.CODE_UTIL_TYPE  = EQ.CODE_UTIL_TYPE                     
MFA-TR*          AND M5.METER_SIZE_ID   = GM.METER_SIZE_ID                      
MFA-TR*          AND M5.COMPANY_NO      = GM.COMPANY_NO                         
MFA-TR*          AND EQ.COMPANY_NO      = :EQ-COMPANY-NO                        
MFA-TR*          AND EQ.CODE_UTIL_TYPE  = :EQ-CODE-UTIL-TYPE                    
MFA-TR*          AND EQ.LOCAL_OFFICE    LIKE :EQ-LOCAL-OFFICE                   
MFA-TR*          AND EQ.CODE_CRNT_LOC   LIKE :EQ-CODE-CRNT-LOC                  
MFA-TR*          AND GM.METER_SIZE_ID   LIKE :GM-METER-SIZE-ID                  
MFA-TR*          AND EQ.CODE_MAKE       LIKE :EQ-CODE-MAKE                      
MFA-TR*          AND EQ.SERIAL_NO       LIKE :EQ-SERIAL-NO                      
MFA-TR*          AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7250                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIPMENT'       TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3             
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-4             
              MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3           
              MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05079901
      ******************************************************************05076800
      * 7260-GET-REC-CNT-MTR-FLTR-CCF                                  *05076900
      ******************************************************************05077000
       7260-GET-REC-CNT-MTR-FLTR-CCF.                                   
      *                                                                 05077300
           EXEC SQL                                                     
              SELECT                                                    
                     COUNT(1)                                           
                INTO                                                    
                     :WS-ROW-COUNT                                      
                FROM                                                    
                     CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER GM WITH(READUNCOMMITTED)                     
                    ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                
               WHERE                                                    
                     EQ.COMPANY_NO     = GM.COMPANY_NO                  
                 AND EQ.DEVICE_NO      = GM.METER_NO                    
                 AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              
                 AND M5.METER_SIZE_ID  = GM.METER_SIZE_ID               
                 AND M5.COMPANY_NO     = GM.COMPANY_NO                  
                 AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                 
                 AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE             
                 AND EQ.LOCAL_OFFICE   LIKE :EQ-LOCAL-OFFICE            
                 AND EQ.CODE_CRNT_LOC  LIKE :EQ-CODE-CRNT-LOC           
                 AND GM.METER_SIZE_ID  LIKE :GM-METER-SIZE-ID           
                 AND EQ.CODE_MAKE      LIKE :EQ-CODE-MAKE               
                 AND GM.CCF_CAP_PER_HR = :GM-CCF-CAP-PER-HR             
                 AND EQ.SERIAL_NO      LIKE :EQ-SERIAL-NO               
C14744           AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              COUNT(1)                                                   
MFA-TR*         INTO                                                            
MFA-TR*              :WS-ROW-COUNT                                              
MFA-TR*         FROM                                                            
MFA-TR*              CSS_EQUIPMENT EQ                                           
MFA-TR*             ,CSS_GAS_METER GM                                           
MFA-TR*             ,CSS_GAS_METER_SIZE M5                                      
MFA-TR*        WHERE                                                            
MFA-TR*              EQ.COMPANY_NO     = GM.COMPANY_NO                          
MFA-TR*          AND EQ.DEVICE_NO      = GM.METER_NO                            
MFA-TR*          AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE                      
MFA-TR*          AND M5.METER_SIZE_ID  = GM.METER_SIZE_ID                       
MFA-TR*          AND M5.COMPANY_NO     = GM.COMPANY_NO                          
MFA-TR*          AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                         
MFA-TR*          AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                     
MFA-TR*          AND EQ.LOCAL_OFFICE   LIKE :EQ-LOCAL-OFFICE                    
MFA-TR*          AND EQ.CODE_CRNT_LOC  LIKE :EQ-CODE-CRNT-LOC                   
MFA-TR*          AND GM.METER_SIZE_ID  LIKE :GM-METER-SIZE-ID                   
MFA-TR*          AND EQ.CODE_MAKE      LIKE :EQ-CODE-MAKE                       
MFA-TR*          AND GM.CCF_CAP_PER_HR = :GM-CCF-CAP-PER-HR                     
MFA-TR*          AND EQ.SERIAL_NO      LIKE :EQ-SERIAL-NO                       
MFA-TR*          AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7260                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7260'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIPMENT'       TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'CODE_CRNT_LOC'       TO TABLE-ELEMENT-3             
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-4             
              MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE EQ-CODE-CRNT-LOC      TO HOSTVAR-ELEMENT-3           
              MOVE EQ-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05079901
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
               DELETE FROM #CSR04185_R1                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DELETE FROM SESSION.CSR04185_R1                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04185_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04185_R1                           
              (                                                         
                  RETURN_CODE                                           
                 ,REC_COUNT                                             
                 ,METER_NO                                              
                 ,CODE_MAKE                                             
                 ,CCF_CAP_PER_HR                                        
                 ,MCF_CAP_PER_HR                                        
                 ,METER_SIZE_ID                                         
                 ,CODE_METER_TYPE                                       
                 ,MODEL_CD                                              
                 ,LAST_TEST_SEL_DT                                      
                 ,EQUIP_TYPE_CD                                         
                 ,SERIAL_NO                                             
                 ,CODE_CRNT_LOC                                         
                 ,DATE_LAST_TRAN                                        
                 ,DATE_LAST_MOVE                                        
                 ,METER_SIZE_DESC                                       
C14744           ,IN_TRANSIT_EMP_ID                                     
                 ,ROW_NUM                                               
              )                                                         
              VALUES                                                    
              (                                                         
                  :S-RETURN-CODE                                        
                 ,:S-REC-COUNT                                          
                 ,:S-METER-NO                                           
                 ,:S-CODE-MAKE                                          
                 ,:S-CCF-CAP-PER-HR                                     
                 ,:S-MCF-CAP-PER-HR                                     
                 ,:S-METER-SIZE-ID                                      
                 ,:S-CODE-METER-TYPE                                    
                 ,:S-MODEL-CD                                           
                 ,:S-LAST-TEST-SEL-DT                                   
                 ,:S-EQUIP-TYPE-CD                                      
                 ,:S-SERIAL-NO                                          
                 ,:S-CODE-CRNT-LOC                                      
                 ,:S-DATE-LAST-TRAN                                     
                 ,:S-DATE-LAST-MOVE                                     
                 ,:S-METER-SIZE-DESC                                    
C14744           ,:S-IN-TRANSIT-EMP-ID                                  
                 ,:S-ROW-NUM                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04185_R1                                   
MFA-TR*       (                                                                 
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,REC_COUNT                                                     
MFA-TR*          ,METER_NO                                                      
MFA-TR*          ,CODE_MAKE                                                     
MFA-TR*          ,CCF_CAP_PER_HR                                                
MFA-TR*          ,MCF_CAP_PER_HR                                                
MFA-TR*          ,METER_SIZE_ID                                                 
MFA-TR*          ,CODE_METER_TYPE                                               
MFA-TR*          ,MODEL_CD                                                      
MFA-TR*          ,LAST_TEST_SEL_DT                                              
MFA-TR*          ,EQUIP_TYPE_CD                                                 
MFA-TR*          ,SERIAL_NO                                                     
MFA-TR*          ,CODE_CRNT_LOC                                                 
MFA-TR*          ,DATE_LAST_TRAN                                                
MFA-TR*          ,DATE_LAST_MOVE                                                
MFA-TR*          ,METER_SIZE_DESC                                               
MFA-TR*          ,IN_TRANSIT_EMP_ID                                             
MFA-TR*          ,ROW_NUM                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*           :S-RETURN-CODE                                                
MFA-TR*          ,:S-REC-COUNT                                                  
MFA-TR*          ,:S-METER-NO                                                   
MFA-TR*          ,:S-CODE-MAKE                                                  
MFA-TR*          ,:S-CCF-CAP-PER-HR                                             
MFA-TR*          ,:S-MCF-CAP-PER-HR                                             
MFA-TR*          ,:S-METER-SIZE-ID                                              
MFA-TR*          ,:S-CODE-METER-TYPE                                            
MFA-TR*          ,:S-MODEL-CD                                                   
MFA-TR*          ,:S-LAST-TEST-SEL-DT                                           
MFA-TR*          ,:S-EQUIP-TYPE-CD                                              
MFA-TR*          ,:S-SERIAL-NO                                                  
MFA-TR*          ,:S-CODE-CRNT-LOC                                              
MFA-TR*          ,:S-DATE-LAST-TRAN                                             
MFA-TR*          ,:S-DATE-LAST-MOVE                                             
MFA-TR*          ,:S-METER-SIZE-DESC                                            
MFA-TR*          ,:S-IN-TRANSIT-EMP-ID                                          
MFA-TR*          ,:S-ROW-NUM                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04185_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8200-UPDATE-REC-COUNT                                          *        
      ******************************************************************        
       8200-UPDATE-REC-COUNT.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE #CSR04185_R1                                
              SET REC_COUNT   = :WS-ROW-COUNT                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE SESSION.CSR04185_R1                                        
MFA-TR*       SET REC_COUNT   = :WS-ROW-COUNT                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE SQLCODE                 TO ABEND-SQLCODE             
              MOVE '8200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'UPDATE'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSR04185_R1'           TO TABLE-1                   
              MOVE SPACES                  TO TABLE-ELEMENT-1           
              MOVE SPACES                  TO HOSTVAR-ELEMENT-1         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 8900-SEND-DONE                                                *         
      * 9000-SEND-ERROR-RESULT                                        *         
      * 9999-END-PROGRAM                                              *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
