       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04184.                                         
COB303 DATE-WRITTEN.                                                    
COB303            NOV 19, 2008.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      ******************************************************************00001000
      *                 P R O G R A M  S U M M A R Y                   *00001100
      *                                                                *00001200
      * SELECT SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC        *00001300
      * INVENTORY SCREEN WHICH RETRIEVES METER CAP DETAILS             *00001400
      *                                                                *00001500
      ******************************************************************00001600
      *                                                                *00001700
      *                     PROGRAM MODIFICATION LOG                   *00001800
      *                                                                *00001900
      *    DATE    INITIALS   COMMENTS                                 *00002000
      *  --------  --------   ---------------------------------------  *00002100
      *  11/19/08   VY95550   INITIAL VERSION.                         *00002200
C14744*  10/17/09  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *        
      *                                                                *00002300
      ******************************************************************00002400
      ******************************************************************00002500
      *                                                                *00002600
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00002700
      *                                                                *00002800
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00002900
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00003000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00003100
      *  3000 - 4999  NOT USED                                         *00003200
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00003300
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00003400
      *  7000 - 7999  INPUT MODULES                                    *00003500
      *  8000 - 8999  OUTPUT MODULES                                   *00003600
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00003700
      *                                                                *00003800
      ******************************************************************00003900
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04184'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************00004500
      *    WORK AREAS                                                  *00004600
      ******************************************************************00004700
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04184 STARTS HERE'.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-TOTAL-RECORD         PIC S9(9) COMP VALUE 0.          
      *                                                                 00005600
      *************************PARM FIELDS******************************00005700
       01  PARM-FIELDS.                                                 
           05  PARM-COMPANY-NO         PIC X(02) VALUE SPACES.          
           05  PARM-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.          
           05  PARM-LOCAL-OFFICE       PIC X(03) VALUE SPACES.          
           05  PARM-ELEC-MTR-SPEC-CD   PIC X(03) VALUE SPACES.          
           05  PARM-ELEC-MTR-CLASS-CD  PIC X(02) VALUE SPACES.          
           05  PARM-CODE-CRNT-LOC      PIC X(01) VALUE SPACES.          
           05  PARM-RECORD-COUNT-FL    PIC X(01) VALUE SPACES.          
           05  PARM-CONSTANT-FLAG      PIC X(01) VALUE SPACES.          
C14744     05  PARM-IN-TRANSIT-EMP-ID  PIC X(07) VALUE SPACES.          
      *                                                                 00006700
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04184'.      
           05  WS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
           05  WS-LOCAL-OFFICE         PIC X(03) VALUE SPACES.          
           05  WS-ELEC-MTR-SPEC-CD     PIC X(03) VALUE SPACES.          
           05  WS-ELEC-MTR-CLASS-CD    PIC X(02) VALUE SPACES.          
           05  WS-CODE-CRNT-LOC        PIC X(01) VALUE SPACES.          
           05  WS-RECORD-COUNT-FL      PIC X(01) VALUE SPACES.          
           05  WS-CONSTANT-FLAG        PIC X(01) VALUE SPACES.          
C14744     05  WS-IN-TRANSIT-EMP-ID     PIC X(07) VALUE SPACES.         
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-LAST-MOVE-IND   PIC S9(4) COMP VALUE 0.          
           05  WS-MFR-DT-IND           PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-LAST-TEST-IND   PIC S9(4) COMP VALUE 0.          
      *                                                                 00008300
      ************************THIS IS THE ROW RETURN AREA***************00008400
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-REC-COUNT            PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-METER-NO             PIC X(09) VALUE SPACES.          
           05  RS-CODE-MAKE            PIC X(02) VALUE SPACES.          
           05  RS-SERIAL-NO            PIC X(11) VALUE SPACES.          
           05  RS-DATE-LAST-MOVE       PIC X(10) VALUE SPACES.          
           05  RS-CODE-CRNT-LOC        PIC X(01) VALUE SPACES.          
           05  RS-CRNT-LOC-NO          PIC S9(10)V USAGE COMP-3 VALUE 0.
           05  RS-LOCAL-OFFICE         PIC X(03) VALUE SPACES.          
           05  RS-PALETTE-NO           PIC X(04) VALUE SPACES.          
           05  RS-MFR-DT               PIC X(10) VALUE SPACES.          
           05  RS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  RS-NO-WIRES             PIC X(01) VALUE SPACES.          
           05  RS-NO-PHASES            PIC X(01) VALUE SPACES.          
           05  RS-ELEC-MTR-CLASS-CD    PIC X(02) VALUE SPACES.          
           05  RS-VOLTAGE              PIC S9(04) USAGE COMP VALUE 0.   
           05  RS-ELEC-MTR-SPEC-CD     PIC X(03) VALUE SPACES.          
           05  RS-DATE-LAST-TESTED     PIC X(10) VALUE SPACES.          
           05  RS-MTR-CONNECT-TYP-ID   PIC X(10) VALUE SPACES.          
           05  RS-DEVICE-TYPE-CD       PIC X(01) VALUE SPACES.          
           05  RS-CODE-METER-TYPE      PIC X(01) VALUE SPACES.          
COB305     05 RS-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 VALUE 0.     
C14744     05  RS-IN-TRANSIT-EMP-ID    PIC X(7)  VALUE SPACES.          
           05  RS-ROW-NUM              PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                 00010800
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-REC-COUNT             PIC S9(09) USAGE COMP VALUE 0.   
           05  S-METER-NO              PIC X(09) VALUE SPACES.          
           05  S-CODE-MAKE             PIC X(02) VALUE SPACES.          
           05  S-SERIAL-NO             PIC X(11) VALUE SPACES.          
           05  S-DATE-LAST-MOVE        PIC X(10) VALUE SPACES.          
           05  S-CODE-CRNT-LOC         PIC X(01) VALUE SPACES.          
           05  S-CRNT-LOC-NO           PIC S9(10)V USAGE COMP-3 VALUE 0.
           05  S-LOCAL-OFFICE          PIC X(03) VALUE SPACES.          
           05  S-PALETTE-NO            PIC X(04) VALUE SPACES.          
           05  S-MFR-DT                PIC X(10) VALUE SPACES.          
           05  S-COMPANY-NO            PIC X(02) VALUE SPACES.          
           05  S-NO-WIRES              PIC X(01) VALUE SPACES.          
           05  S-NO-PHASES             PIC X(01) VALUE SPACES.          
           05  S-ELEC-MTR-CLASS-CD     PIC X(02) VALUE SPACES.          
           05  S-VOLTAGE               PIC S9(04) USAGE COMP VALUE 0.   
           05  S-ELEC-MTR-SPEC-CD      PIC X(03) VALUE SPACES.          
           05  S-DATE-LAST-TESTED      PIC X(10) VALUE SPACES.          
           05  S-MTR-CONNECT-TYP-ID    PIC X(10) VALUE SPACES.          
           05  S-DEVICE-TYPE-CD        PIC X(01) VALUE SPACES.          
           05  S-CODE-METER-TYPE       PIC X(01) VALUE SPACES.          
COB305     05 S-CONSTANT        PIC S9(6)V9(3) USAGE COMP-3 VALUE 0.     
C14744     05  S-IN-TRANSIT-EMP-ID     PIC X(7)  VALUE SPACES.          
           05  S-ROW-NUM               PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                 00013200
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 00013700
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
      ******************************************************************00014400
      *    DB2 INCLUDES                                                *00014500
      ******************************************************************00014600
                                                                        
           EXEC SQL                                                     00014800
              INCLUDE SQLCA                                             00014900
           END-EXEC.                                                    00015000
      *                                                                 00015100
      ******************************************************************00015200
      * CSS_EQUIPMENT, EQ                                              *00015300
      ******************************************************************00015400
                                                                        
           EXEC SQL                                                     00015600
              INCLUDE TBEQUIP                                           00015700
           END-EXEC.                                                    00015800
      *                                                                 00015900
      ******************************************************************00016000
      * CSS_MTR_CAP, MC                                             *   00016100
      ******************************************************************00016200
           EXEC SQL                                                     00016300
              INCLUDE TBMTRCAP                                          00016400
           END-EXEC.                                                    00016500
      *                                                                 00016600
      ******************************************************************00016700
      * CSS_ELEC_METER, EM                                             *00016800
      ******************************************************************00016900
           EXEC SQL                                                     00017000
              INCLUDE TBELMTR                                           00017100
           END-EXEC.                                                    00017200
                                                                        
                                                                        
      ******************************************************************00017500
      *    COBOL WORKING STORAGE COPY BOOKS                            *00017600
      ******************************************************************00017700
                                                                        
           COPY CWS00303.                                               00017900
                                                                        
           EXEC SQL                                                     00018100
              INCLUDE CWSX0010                                          00018200
           END-EXEC.                                                    00018300
                                                                        
      *                                                                 00018500
      ******************************************************************00018600
      *    CURSOR DECLARATIONS                                         *00018700
      *    FILTER WHEN THE PROCEDURE GETS ANY VALID INPUTS             *00018800
      *                                                                *00018900
      ******************************************************************00019000
           EXEC SQL DECLARE METER_FILTER CURSOR FOR                     
              SELECT DISTINCT TOP(1000) MC.METER_NO,
              MC.CONSTANT,
              EQ.CODE_MAKE,
              EQ.SERIAL_NO,
              EQ.DATE_LAST_MOVE,
              EQ.CODE_CRNT_LOC,
              EQ.CRNT_LOC_NO,
              EQ.LOCAL_OFFICE,
              EQ.PALETTE_NO,
              EQ.MFR_DT,
              EQ.COMPANY_NO,
              EM.NO_WIRES,
              EM.NO_PHASES,
              EM.ELEC_MTR_CLASS_CD,
              EM.VOLTAGE,
              EM.ELEC_MTR_SPEC_CD,
              EM.DATE_LAST_TESTED,
              EM.MTR_CONNECT_TYP_ID,
              EM.DEVICE_TYPE_CD,
              EM.CODE_METER_TYPE,
              EQ.IN_TRANSIT_EMP_ID                               
                FROM CSS_EQUIPMENT  AS EQ WITH(READUNCOMMITTED)                 
                    ,CSS_ELEC_METER AS EM WITH(READUNCOMMITTED)                 
                    ,CSS_MTR_CAP    AS MC WITH(READUNCOMMITTED)                 
                WHERE EQ.COMPANY_NO        = :EQ-COMPANY-NO             
                  AND EQ.CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE         
                  AND EQ.DEVICE_NO         = EM.METER_NO                
                  AND EM.COMPANY_NO        = EQ.COMPANY_NO              
                  AND EM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          
                  AND EM.METER_NO          = MC.METER_NO                
                  AND MC.COMPANY_NO        = EM.COMPANY_NO              
                  AND MC.CODE_UTIL_TYPE    = EM.CODE_UTIL_TYPE          
                  AND MC.METER_NO          = EM.METER_NO                
                  AND MC.REG_ID_NO        > 0                           
                  AND MC.CONSTANT         >= :MC-CONSTANT               
                  AND EQ.LOCAL_OFFICE      LIKE :EQ-LOCAL-OFFICE        
                  AND EM.ELEC_MTR_SPEC_CD  LIKE :EM-ELEC-MTR-SPEC-CD    
                  AND EM.ELEC_MTR_CLASS_CD LIKE :EM-ELEC-MTR-CLASS-CD   
                  AND EQ.CODE_CRNT_LOC     LIKE :EQ-CODE-CRNT-LOC       
C14744            AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID   
             ORDER BY MC.METER_NO                                       
                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE METER_FILTER CURSOR FOR                     00019100
MFA-TR*       SELECT DISTINCT                                           00019200
MFA-TR*              MC.METER_NO                                        00019300
MFA-TR*             ,MC.CONSTANT                                        00019310
MFA-TR*             ,EQ.CODE_MAKE                                       00019400
MFA-TR*             ,EQ.SERIAL_NO                                       00019500
MFA-TR*             ,EQ.DATE_LAST_MOVE                                  00019600
MFA-TR*             ,EQ.CODE_CRNT_LOC                                   00019700
MFA-TR*             ,EQ.CRNT_LOC_NO                                     00019800
MFA-TR*             ,EQ.LOCAL_OFFICE                                    00019900
MFA-TR*             ,EQ.PALETTE_NO                                      00020000
MFA-TR*             ,EQ.MFR_DT                                          00020100
MFA-TR*             ,EQ.COMPANY_NO                                      00020200
MFA-TR*             ,EM.NO_WIRES                                        00020300
MFA-TR*             ,EM.NO_PHASES                                       00020400
MFA-TR*             ,EM.ELEC_MTR_CLASS_CD                               00020500
MFA-TR*             ,EM.VOLTAGE                                         00020600
MFA-TR*             ,EM.ELEC_MTR_SPEC_CD                                00020700
MFA-TR*             ,EM.DATE_LAST_TESTED                                00020800
MFA-TR*             ,EM.MTR_CONNECT_TYP_ID                              00020900
MFA-TR*             ,EM.DEVICE_TYPE_CD                                  00021000
MFA-TR*             ,EM.CODE_METER_TYPE                                 00021100
MFA-TR*             ,EQ.IN_TRANSIT_EMP_ID                               00020100
MFA-TR*         FROM CSS_EQUIPMENT  AS EQ                               00021200
MFA-TR*             ,CSS_ELEC_METER AS EM                               00021300
MFA-TR*             ,CSS_MTR_CAP    AS MC                               00021400
MFA-TR*         WHERE EQ.COMPANY_NO        = :EQ-COMPANY-NO             00021500
MFA-TR*           AND EQ.CODE_UTIL_TYPE    = :EQ-CODE-UTIL-TYPE         00021600
MFA-TR*           AND EQ.DEVICE_NO         = EM.METER_NO                00021700
MFA-TR*           AND EM.COMPANY_NO        = EQ.COMPANY_NO              00021800
MFA-TR*           AND EM.CODE_UTIL_TYPE    = EQ.CODE_UTIL_TYPE          00021900
MFA-TR*           AND EM.METER_NO          = MC.METER_NO                00022000
MFA-TR*           AND MC.COMPANY_NO        = EM.COMPANY_NO              00022100
MFA-TR*           AND MC.CODE_UTIL_TYPE    = EM.CODE_UTIL_TYPE          00022200
MFA-TR*           AND MC.METER_NO          = EM.METER_NO                00022300
MFA-TR*           AND MC.REG_ID_NO        > 0                           00022400
MFA-TR*           AND MC.CONSTANT         >= :MC-CONSTANT               00022500
MFA-TR*           AND EQ.LOCAL_OFFICE      LIKE :EQ-LOCAL-OFFICE        00022600
MFA-TR*           AND EM.ELEC_MTR_SPEC_CD  LIKE :EM-ELEC-MTR-SPEC-CD    00022700
MFA-TR*           AND EM.ELEC_MTR_CLASS_CD LIKE :EM-ELEC-MTR-CLASS-CD   00022800
MFA-TR*           AND EQ.CODE_CRNT_LOC     LIKE :EQ-CODE-CRNT-LOC       00022900
MFA-TR*           AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID   00076000
MFA-TR*      ORDER BY MC.METER_NO                                       00023000
MFA-TR*      FETCH FIRST 1000 ROWS ONLY WITH UR                         00023100
MFA-TR*    END-EXEC.                                                    00023200
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                      RETURN_CODE                                       
                     ,REC_COUNT                                         
                     ,METER_NO                                          
                     ,CODE_MAKE                                         
                     ,SERIAL_NO                                         
                     ,DATE_LAST_MOVE                                    
                     ,CODE_CRNT_LOC                                     
                     ,CRNT_LOC_NO                                       
                     ,LOCAL_OFFICE                                      
                     ,PALETTE_NO                                        
                     ,MFR_DT                                            
                     ,COMPANY_NO                                        
                     ,NO_WIRES                                          
                     ,NO_PHASES                                         
                     ,ELEC_MTR_CLASS_CD                                 
                     ,VOLTAGE                                           
                     ,ELEC_MTR_SPEC_CD                                  
                     ,DATE_LAST_TESTED                                  
                     ,MTR_CONNECT_TYP_ID                                
                     ,DEVICE_TYPE_CD                                    
                     ,CODE_METER_TYPE                                   
                     ,CONSTANT                                          
C14744               ,IN_TRANSIT_EMP_ID                                 
                     ,ROW_NUM                                           
               FROM #CSR04184_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00023500
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00023600
MFA-TR*                          WITH ROWSET POSITIONING FOR            00023700
MFA-TR*        SELECT                                                   00023800
MFA-TR*               RETURN_CODE                                       00023900
MFA-TR*              ,REC_COUNT                                         00024000
MFA-TR*              ,METER_NO                                          00024100
MFA-TR*              ,CODE_MAKE                                         00024200
MFA-TR*              ,SERIAL_NO                                         00024300
MFA-TR*              ,DATE_LAST_MOVE                                    00024400
MFA-TR*              ,CODE_CRNT_LOC                                     00024500
MFA-TR*              ,CRNT_LOC_NO                                       00024600
MFA-TR*              ,LOCAL_OFFICE                                      00024700
MFA-TR*              ,PALETTE_NO                                        00024800
MFA-TR*              ,MFR_DT                                            00024900
MFA-TR*              ,COMPANY_NO                                        00025000
MFA-TR*              ,NO_WIRES                                          00025100
MFA-TR*              ,NO_PHASES                                         00025200
MFA-TR*              ,ELEC_MTR_CLASS_CD                                 00025300
MFA-TR*              ,VOLTAGE                                           00025400
MFA-TR*              ,ELEC_MTR_SPEC_CD                                  00025500
MFA-TR*              ,DATE_LAST_TESTED                                  00025600
MFA-TR*              ,MTR_CONNECT_TYP_ID                                00025700
MFA-TR*              ,DEVICE_TYPE_CD                                    00025800
MFA-TR*              ,CODE_METER_TYPE                                   00025900
MFA-TR*              ,CONSTANT                                          00025910
MFA-TR*              ,IN_TRANSIT_EMP_ID                                         
MFA-TR*              ,ROW_NUM                                           00026000
MFA-TR*        FROM SESSION.CSR04184_R1                                 00026100
MFA-TR*    END-EXEC.                                                    00026200
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-COMPANY-NO             PIC X(02).                       
       01  LINK-CODE-UTIL-TYPE         PIC X(01).                       
       01  LINK-LOCAL-OFFICE           PIC X(03).                       
       01  LINK-ELEC-MTR-SPEC-CD       PIC X(03).                       
       01  LINK-ELEC-MTR-CLASS-CD      PIC X(02).                       
       01  LINK-CODE-CRNT-LOC          PIC X(01).                       
       01  LINK-RECORD-COUNT-FL        PIC X(01).                       
       01  LINK-CONSTANT-FLAG          PIC X(01).                       
C14744 01  LINK-IN-TRANSIT-EMP-ID      PIC X(07).                       
      *                                                                 00027300
       PROCEDURE DIVISION USING        LINK-COMPANY-NO                  
                                      ,LINK-CODE-UTIL-TYPE              
                                      ,LINK-LOCAL-OFFICE                
                                      ,LINK-ELEC-MTR-SPEC-CD            
                                      ,LINK-ELEC-MTR-CLASS-CD           
                                      ,LINK-CODE-CRNT-LOC               
                                      ,LINK-RECORD-COUNT-FL             
                                      ,LINK-CONSTANT-FLAG               
C14744                                ,LINK-IN-TRANSIT-EMP-ID.          
      *                                                                 00028200
      ******************************************************************00028300
      * 0000-MAINLINE                                                  *00028400
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00028500
      ******************************************************************00028600
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00029800
      * 0100-INITIALIZE                                                *00029900
      *                                                                *00030000
      ******************************************************************00030100
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           MOVE LINK-COMPANY-NO          TO PARM-COMPANY-NO.            
           MOVE LINK-CODE-UTIL-TYPE      TO PARM-CODE-UTIL-TYPE.        
           MOVE LINK-LOCAL-OFFICE        TO PARM-LOCAL-OFFICE.          
           MOVE LINK-ELEC-MTR-SPEC-CD    TO PARM-ELEC-MTR-SPEC-CD.      
           MOVE LINK-ELEC-MTR-CLASS-CD   TO PARM-ELEC-MTR-CLASS-CD.     
           MOVE LINK-CODE-CRNT-LOC       TO PARM-CODE-CRNT-LOC.         
           MOVE LINK-RECORD-COUNT-FL     TO PARM-RECORD-COUNT-FL.       
           MOVE LINK-CONSTANT-FLAG       TO PARM-CONSTANT-FLAG.         
C14744     MOVE LINK-IN-TRANSIT-EMP-ID   TO PARM-IN-TRANSIT-EMP-ID.     
                                                                        
           PERFORM 0100A-DECLARE-GTT                                    
             THRU 0100A-EXIT.                                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00032200
      ******************************************************************00032300
      * 0100A-DECLARE-GTT                                              *00032400
      ******************************************************************00032500
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04184_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04184_R1
              (                                                          
               RETURN_CODE              INT                         
              ,REC_COUNT                INT                         
              ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,CODE_MAKE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,SERIAL_NO CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,DATE_LAST_MOVE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CODE_CRNT_LOC CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,CRNT_LOC_NO              DECIMAL(10,0)                   
              ,LOCAL_OFFICE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,PALETTE_NO CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,MFR_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2                 
              ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,NO_WIRES CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,NO_PHASES CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,ELEC_MTR_CLASS_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,VOLTAGE                  SMALLINT                        
              ,ELEC_MTR_SPEC_CD CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,DATE_LAST_TESTED CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,MTR_CONNECT_TYP_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,DEVICE_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CODE_METER_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CONSTANT                 DECIMAL(9,3)                    
C14744        ,IN_TRANSIT_EMP_ID CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,ROW_NUM                  INT                         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04184_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************00038200
      * 1000-PROCESS-INPUT                                             *00038300
      *                                                                *00038400
      ******************************************************************00038500
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY-NO        TO WS-COMPANY-NO                 
           MOVE PARM-CODE-UTIL-TYPE    TO WS-CODE-UTIL-TYPE             
           MOVE PARM-LOCAL-OFFICE      TO WS-LOCAL-OFFICE               
           MOVE PARM-ELEC-MTR-SPEC-CD  TO WS-ELEC-MTR-SPEC-CD           
           MOVE PARM-ELEC-MTR-CLASS-CD TO WS-ELEC-MTR-CLASS-CD          
           MOVE PARM-CODE-CRNT-LOC     TO WS-CODE-CRNT-LOC              
           MOVE PARM-RECORD-COUNT-FL   TO WS-RECORD-COUNT-FL            
           MOVE PARM-CONSTANT-FLAG     TO WS-CONSTANT-FLAG              
C14744     MOVE PARM-IN-TRANSIT-EMP-ID TO WS-IN-TRANSIT-EMP-ID          
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT         
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00040200
      * 1200-VALIDATE-INPUT-ARGUMENTS.                                 *00040300
      ******************************************************************00040400
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
                                                                        
           IF PARM-CODE-UTIL-TYPE = SPACES                              
              MOVE 9998                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'PARM-CODE-UTIL-TYPE'    TO TABLE-ELEMENT-1          
              MOVE PARM-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF PARM-COMPANY-NO = SPACES                                  
              MOVE 9997                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'PARM-COMPANY-NO'        TO TABLE-ELEMENT-1          
              MOVE PARM-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00043500
      ******************************************************************00043600
      * 2000-PROCESS-OUTPUT.                                           *00043700
      *                                                                *00043800
      ******************************************************************00043900
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF (WS-LOCAL-OFFICE NOT = '%%%'        AND                   
               WS-LOCAL-OFFICE > SPACES               ) OR              
              (WS-ELEC-MTR-SPEC-CD NOT = '%%%'    AND                   
               WS-ELEC-MTR-SPEC-CD > SPACES           ) OR              
              (WS-ELEC-MTR-CLASS-CD NOT = '%%'    AND                   
               WS-ELEC-MTR-CLASS-CD > SPACES          ) OR              
              (WS-CODE-CRNT-LOC NOT = '%'         AND                   
               WS-CODE-CRNT-LOC > SPACES              ) OR              
C14744        (WS-IN-TRANSIT-EMP-ID NOT = '%%%%%%%' AND                 
C14744         WS-IN-TRANSIT-EMP-ID > SPACES          )                 
              PERFORM 2100-PROCESS-FILTER      THRU 2100-EXIT           
           ELSE                                                         
              MOVE 9999                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'VALIDATE'               TO ABEND-FUNCTION           
              MOVE 'CSS_EQUIPMENT'          TO TABLE-1                  
              MOVE 'CSS_ELEC_METER'         TO TABLE-2                  
              MOVE 'PARM-LOCAL-OFFICE'      TO TABLE-ELEMENT-1          
              MOVE 'PARM-ELEC-MTR-SPEC-CD'  TO TABLE-ELEMENT-2          
              MOVE 'PARM-ELEC-MTR-CLASS-CD' TO TABLE-ELEMENT-3          
              MOVE 'PARM-CODE-CRNT-LOC'     TO TABLE-ELEMENT-4          
              MOVE PARM-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-1        
              MOVE PARM-ELEC-MTR-SPEC-CD    TO HOSTVAR-ELEMENT-2        
              MOVE PARM-ELEC-MTR-CLASS-CD   TO HOSTVAR-ELEMENT-3        
              MOVE PARM-CODE-CRNT-LOC       TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
                                                                        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00047400
      ******************************************************************00047500
      *2000A-MOVE-RESULT.                                               00047600
      ******************************************************************00047700
       2000A-MOVE-RESULT.                                               
      *                                                                 00047900
           MOVE RS-RETURN-CODE         TO  S-RETURN-CODE                
           MOVE RS-REC-COUNT           TO  S-REC-COUNT                  
           MOVE RS-METER-NO            TO  S-METER-NO                   
           MOVE RS-CODE-MAKE           TO  S-CODE-MAKE                  
           MOVE RS-SERIAL-NO           TO  S-SERIAL-NO                  
           MOVE RS-DATE-LAST-MOVE      TO  S-DATE-LAST-MOVE             
           MOVE RS-CODE-CRNT-LOC       TO  S-CODE-CRNT-LOC              
           MOVE RS-CRNT-LOC-NO         TO  S-CRNT-LOC-NO                
           MOVE RS-LOCAL-OFFICE        TO  S-LOCAL-OFFICE               
           MOVE RS-PALETTE-NO          TO  S-PALETTE-NO                 
           MOVE RS-MFR-DT              TO  S-MFR-DT                     
           MOVE RS-COMPANY-NO          TO  S-COMPANY-NO                 
           MOVE RS-NO-WIRES            TO  S-NO-WIRES                   
           MOVE RS-NO-PHASES           TO  S-NO-PHASES                  
           MOVE RS-ELEC-MTR-CLASS-CD   TO  S-ELEC-MTR-CLASS-CD          
           MOVE RS-VOLTAGE             TO  S-VOLTAGE                    
           MOVE RS-ELEC-MTR-SPEC-CD    TO  S-ELEC-MTR-SPEC-CD           
           MOVE RS-DATE-LAST-TESTED    TO  S-DATE-LAST-TESTED           
           MOVE RS-MTR-CONNECT-TYP-ID  TO  S-MTR-CONNECT-TYP-ID         
           MOVE RS-DEVICE-TYPE-CD      TO  S-DEVICE-TYPE-CD             
           MOVE RS-CODE-METER-TYPE     TO  S-CODE-METER-TYPE            
           MOVE RS-CONSTANT            TO  S-CONSTANT                   
C14744     MOVE RS-IN-TRANSIT-EMP-ID   TO  S-IN-TRANSIT-EMP-ID          
           MOVE RS-ROW-NUM             TO  S-ROW-NUM.                   
      *                                                                 00050200
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00050500
      ******************************************************************00050600
      * 2100-PROCESS-FILTER                                            *00050700
      ******************************************************************00050800
       2100-PROCESS-FILTER.                                             
      *                                                                 00051000
           MOVE WS-COMPANY-NO          TO EQ-COMPANY-NO                 
           MOVE WS-CODE-UTIL-TYPE      TO EQ-CODE-UTIL-TYPE             
                                                                        
           IF WS-CONSTANT-FLAG = '1'                                    
              MOVE 1.001               TO MC-CONSTANT                   
           ELSE                                                         
              MOVE 1                   TO MC-CONSTANT                   
           END-IF                                                       
      *                                                                 00051800
           IF WS-LOCAL-OFFICE = SPACES                                  
              MOVE '%%%'               TO EQ-LOCAL-OFFICE               
           ELSE                                                         
              MOVE WS-LOCAL-OFFICE     TO EQ-LOCAL-OFFICE               
           END-IF                                                       
      *                                                                 00052400
           IF WS-ELEC-MTR-SPEC-CD = SPACES                              
              MOVE '%%%'               TO EM-ELEC-MTR-SPEC-CD           
           ELSE                                                         
              MOVE WS-ELEC-MTR-SPEC-CD TO EM-ELEC-MTR-SPEC-CD           
           END-IF                                                       
      *                                                                 00053000
           IF WS-ELEC-MTR-CLASS-CD = SPACES                             
              MOVE '%%'                 TO EM-ELEC-MTR-CLASS-CD         
           ELSE                                                         
              MOVE WS-ELEC-MTR-CLASS-CD TO EM-ELEC-MTR-CLASS-CD         
           END-IF                                                       
      *                                                                 00053600
           IF WS-CODE-CRNT-LOC = SPACES                                 
              MOVE '%'                 TO EQ-CODE-CRNT-LOC              
           ELSE                                                         
              MOVE WS-CODE-CRNT-LOC    TO EQ-CODE-CRNT-LOC              
           END-IF                                                       
      *                                                                 00054200
C14744     IF WS-IN-TRANSIT-EMP-ID = SPACES                             
C14744        MOVE '%%%%%%%'           TO EQ-IN-TRANSIT-EMP-ID          
C14744     ELSE                                                         
C14744        MOVE WS-IN-TRANSIT-EMP-ID TO EQ-IN-TRANSIT-EMP-ID         
C14744     END-IF                                                       
C14744*                                                                 00054200
           IF WS-RECORD-COUNT-FL = 'Y'                                  
              PERFORM 7300-GET-TOTAL-REC-COUNT THRU 7300-EXIT           
           END-IF                                                       
                                                                        
           PERFORM 7100-OPEN-METER-FILTER      THRU 7100-EXIT           
                                                                        
           PERFORM 2120-PROCESS-FETCH-FILTER   THRU 2120-EXIT           
             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                                                                        
           PERFORM 7140-CLOSE-METER-FILTER     THRU 7140-EXIT           
                                                                        
           IF WS-RECORD-COUNT-FL = 'Y'                                  
              PERFORM 8200-UPDATE-REC-COUNT    THRU 8200-EXIT           
           END-IF.                                                      
      *                                                                 00055700
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00056000
      ******************************************************************00056100
      * 2120-PROCESS-FETCH-FILTER                                      *00056200
      ******************************************************************00056300
       2120-PROCESS-FETCH-FILTER.                                       
      *                                                                 00056500
           PERFORM 7120-FETCH-METER-FILTER     THRU 7120-EXIT           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                      TO WS-ROW-COUNT                
                                                                        
              MOVE EM-METER-NO           TO RS-METER-NO                 
              MOVE EQ-CODE-MAKE          TO RS-CODE-MAKE                
              MOVE EQ-SERIAL-NO          TO RS-SERIAL-NO                
              IF WS-DATE-LAST-MOVE-IND = -1                             
                 MOVE SPACES             TO RS-DATE-LAST-MOVE           
                 MOVE 0                  TO WS-DATE-LAST-MOVE-IND       
              ELSE                                                      
                 MOVE EQ-DATE-LAST-MOVE  TO RS-DATE-LAST-MOVE           
              END-IF                                                    
              MOVE EQ-CODE-CRNT-LOC      TO RS-CODE-CRNT-LOC            
              MOVE EQ-CRNT-LOC-NO        TO RS-CRNT-LOC-NO              
              MOVE EQ-LOCAL-OFFICE       TO RS-LOCAL-OFFICE             
              MOVE EQ-PALETTE-NO         TO RS-PALETTE-NO               
              IF WS-MFR-DT-IND         = -1                             
                 MOVE SPACES             TO RS-MFR-DT                   
                 MOVE 0                  TO WS-MFR-DT-IND               
              ELSE                                                      
                 MOVE EQ-MFR-DT          TO RS-MFR-DT                   
              END-IF                                                    
              MOVE EQ-COMPANY-NO         TO RS-COMPANY-NO               
C14744        MOVE EQ-IN-TRANSIT-EMP-ID  TO RS-IN-TRANSIT-EMP-ID        
              MOVE EM-NO-WIRES           TO RS-NO-WIRES                 
              MOVE EM-NO-PHASES          TO RS-NO-PHASES                
              MOVE EM-ELEC-MTR-CLASS-CD  TO RS-ELEC-MTR-CLASS-CD        
              MOVE EM-VOLTAGE            TO RS-VOLTAGE                  
              MOVE EM-ELEC-MTR-SPEC-CD   TO RS-ELEC-MTR-SPEC-CD         
              IF WS-DATE-LAST-TEST-IND = -1                             
                 MOVE SPACES                TO RS-DATE-LAST-TESTED      
                 MOVE 0                     TO WS-DATE-LAST-TEST-IND    
              ELSE                                                      
                 MOVE EM-DATE-LAST-TESTED   TO RS-DATE-LAST-TESTED      
              END-IF                                                    
              MOVE EM-MTR-CONNECT-TYP-ID TO RS-MTR-CONNECT-TYP-ID       
              MOVE EM-DEVICE-TYPE-CD     TO RS-DEVICE-TYPE-CD           
              MOVE EM-CODE-METER-TYPE    TO RS-CODE-METER-TYPE          
              MOVE MC-CONSTANT           TO RS-CONSTANT                 
              MOVE WS-ROW-COUNT          TO RS-ROW-NUM                  
                                                                        
              MOVE '2120'                TO ACTIVE-PARAGRAPH            
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
      *                                                                 00061000
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00061300
      ******************************************************************00061400
      * 7100-OPEN-METER-FILTER                                         *00061500
      ******************************************************************00061600
       7100-OPEN-METER-FILTER.                                          
                                                                        
           EXEC SQL                                                     
              OPEN METER_FILTER                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_EQUIPMENT'     TO TABLE-1                       
              MOVE 'CSS_ELEC_METER'    TO TABLE-2                       
              MOVE 'LOCAL_OFFICE'      TO TABLE-ELEMENT-1               
              MOVE 'ELEC_MTR_SPEC_CD'  TO TABLE-ELEMENT-2               
              MOVE 'ELEC_MTR_CLASS_CD' TO TABLE-ELEMENT-3               
              MOVE 'CODE_CRNT_LOC'     TO TABLE-ELEMENT-4               
              MOVE EQ-LOCAL-OFFICE     TO HOSTVAR-ELEMENT-1             
              MOVE EM-ELEC-MTR-SPEC-CD TO HOSTVAR-ELEMENT-2             
              MOVE EM-ELEC-MTR-CLASS-CD TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC    TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00064700
      ******************************************************************00064800
      * 7120-FETCH-METER-FILTER                                        *00064900
      ******************************************************************00065000
       7120-FETCH-METER-FILTER.                                         
                                                                        
           EXEC SQL                                                     
              FETCH METER_FILTER                                        
               INTO :EM-METER-NO                                        
                   ,:MC-CONSTANT                                        
                   ,:EQ-CODE-MAKE                                       
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND            
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-PALETTE-NO                                      
                   ,:EQ-MFR-DT :WS-MFR-DT-IND                            
                   ,:EQ-COMPANY-NO                                      
                   ,:EM-NO-WIRES                                        
                   ,:EM-NO-PHASES                                       
                   ,:EM-ELEC-MTR-CLASS-CD                               
                   ,:EM-VOLTAGE                                         
                   ,:EM-ELEC-MTR-SPEC-CD                                
                   ,:EM-DATE-LAST-TESTED :WS-DATE-LAST-TEST-IND          
                   ,:EM-MTR-CONNECT-TYP-ID                              
                   ,:EM-DEVICE-TYPE-CD                                  
                   ,:EM-CODE-METER-TYPE                                 
C14744             ,:EQ-IN-TRANSIT-EMP-ID                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7120'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE 'CSS_EQUIPMENT'     TO TABLE-1                       
              MOVE 'CSS_ELEC_METER'    TO TABLE-2                       
              MOVE 'LOCAL_OFFICE'      TO TABLE-ELEMENT-1               
              MOVE 'ELEC_MTR_SPEC_CD'  TO TABLE-ELEMENT-2               
              MOVE 'ELEC_MTR_CLASS_CD' TO TABLE-ELEMENT-3               
              MOVE 'CODE_CRNT_LOC'     TO TABLE-ELEMENT-4               
              MOVE EQ-LOCAL-OFFICE     TO HOSTVAR-ELEMENT-1             
              MOVE EM-ELEC-MTR-SPEC-CD TO HOSTVAR-ELEMENT-2             
              MOVE EM-ELEC-MTR-CLASS-CD TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC    TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00070000
      ******************************************************************00070100
      * 7140-CLOSE-METER-FILTER                                        *00070200
      ******************************************************************00070300
       7140-CLOSE-METER-FILTER.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE METER_FILTER                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7140'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_EQUIPMENT'     TO TABLE-1                       
              MOVE 'CSS_ELEC_METER'    TO TABLE-2                       
              MOVE 'LOCAL_OFFICE'      TO TABLE-ELEMENT-1               
              MOVE 'ELEC_MTR_SPEC_CD'  TO TABLE-ELEMENT-2               
              MOVE 'ELEC_MTR_CLASS_CD' TO TABLE-ELEMENT-3               
              MOVE 'CODE_CRNT_LOC'     TO TABLE-ELEMENT-4               
              MOVE EQ-LOCAL-OFFICE     TO HOSTVAR-ELEMENT-1             
              MOVE EM-ELEC-MTR-SPEC-CD TO HOSTVAR-ELEMENT-2             
              MOVE EM-ELEC-MTR-CLASS-CD TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC    TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00073400
      ******************************************************************00073500
      * 7300-GET-TOTAL-REC-COUNT                                       *00073600
      ******************************************************************00073700
       7300-GET-TOTAL-REC-COUNT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT COUNT( DISTINCT EM.METER_NO )                     
               INTO :WS-TOTAL-RECORD                                    
                FROM CSS_EQUIPMENT  AS EQ WITH(READUNCOMMITTED)                 
                    ,CSS_ELEC_METER AS EM WITH(READUNCOMMITTED)                 
                    ,CSS_MTR_CAP    AS MC WITH(READUNCOMMITTED)                 
                WHERE EQ.COMPANY_NO         = :EQ-COMPANY-NO            
                  AND EQ.CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE        
                  AND EQ.DEVICE_NO          = EM.METER_NO               
                  AND EM.COMPANY_NO         = EQ.COMPANY_NO             
                  AND EM.CODE_UTIL_TYPE     = EQ.CODE_UTIL_TYPE         
                  AND EM.METER_NO           = MC.METER_NO               
                  AND MC.COMPANY_NO         = EM.COMPANY_NO             
                  AND MC.CODE_UTIL_TYPE     = EM.CODE_UTIL_TYPE         
                  AND MC.METER_NO           = EM.METER_NO               
                  AND MC.REG_ID_NO         > 0                          
                  AND MC.CONSTANT          >= :MC-CONSTANT              
                  AND EQ.LOCAL_OFFICE      LIKE :EQ-LOCAL-OFFICE        
                  AND EM.ELEC_MTR_SPEC_CD  LIKE :EM-ELEC-MTR-SPEC-CD    
                  AND EM.ELEC_MTR_CLASS_CD LIKE :EM-ELEC-MTR-CLASS-CD   
                  AND EQ.CODE_CRNT_LOC     LIKE :EQ-CODE-CRNT-LOC       
C14744            AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00074000
MFA-TR*        SELECT COUNT( DISTINCT EM.METER_NO )                     00074100
MFA-TR*        INTO :WS-TOTAL-RECORD                                    00074200
MFA-TR*         FROM CSS_EQUIPMENT  AS EQ                               00074300
MFA-TR*             ,CSS_ELEC_METER AS EM                               00074400
MFA-TR*             ,CSS_MTR_CAP    AS MC                               00074500
MFA-TR*         WHERE EQ.COMPANY_NO         = :EQ-COMPANY-NO            00074600
MFA-TR*           AND EQ.CODE_UTIL_TYPE     = :EQ-CODE-UTIL-TYPE        00074700
MFA-TR*           AND EQ.DEVICE_NO          = EM.METER_NO               00074800
MFA-TR*           AND EM.COMPANY_NO         = EQ.COMPANY_NO             00074900
MFA-TR*           AND EM.CODE_UTIL_TYPE     = EQ.CODE_UTIL_TYPE         00075000
MFA-TR*           AND EM.METER_NO           = MC.METER_NO               00075100
MFA-TR*           AND MC.COMPANY_NO         = EM.COMPANY_NO             00075200
MFA-TR*           AND MC.CODE_UTIL_TYPE     = EM.CODE_UTIL_TYPE         00075300
MFA-TR*           AND MC.METER_NO           = EM.METER_NO               00075400
MFA-TR*           AND MC.REG_ID_NO         > 0                          00075500
MFA-TR*           AND MC.CONSTANT          >= :MC-CONSTANT              00075600
MFA-TR*           AND EQ.LOCAL_OFFICE      LIKE :EQ-LOCAL-OFFICE        00075700
MFA-TR*           AND EM.ELEC_MTR_SPEC_CD  LIKE :EM-ELEC-MTR-SPEC-CD    00075800
MFA-TR*           AND EM.ELEC_MTR_CLASS_CD LIKE :EM-ELEC-MTR-CLASS-CD   00075900
MFA-TR*           AND EQ.CODE_CRNT_LOC     LIKE :EQ-CODE-CRNT-LOC       00076000
MFA-TR*           AND EQ.IN_TRANSIT_EMP_ID LIKE :EQ-IN-TRANSIT-EMP-ID   00076000
MFA-TR*        WITH UR                                                  00076100
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                    00076200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE 'RECCOUNT'          TO ABEND-FUNCTION                
              MOVE 'CSS_EQUIPMENT'     TO TABLE-1                       
              MOVE 'CSS_ELEC_METER'    TO TABLE-2                       
              MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
              MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
              MOVE EQ-COMPANY-NO       TO HOSTVAR-ELEMENT-1             
              MOVE EQ-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
        7300-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************00078500
      * 8000A-DELETE-GTT-ROWS.                                         *00078600
      ******************************************************************00078700
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00078900
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00079300
            EXEC SQL                                                    
                DELETE FROM #CSR04184_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00079400
MFA-TR*         DELETE FROM SESSION.CSR04184_R1                         00079500
MFA-TR*     END-EXEC.                                                   00079600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00079700
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00079900
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04184_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00081500
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 00081800
      ******************************************************************00081900
      * 8100-SEND-RESULT.                                              *00082000
      ******************************************************************00082100
       8100-SEND-RESULT.                                                
      *                                                                 00082300
           EXEC SQL                                                     
             INSERT INTO #CSR04184_R1                            
             (                                                          
              RETURN_CODE                                               
             ,REC_COUNT                                                 
             ,METER_NO                                                  
             ,CODE_MAKE                                                 
             ,SERIAL_NO                                                 
             ,DATE_LAST_MOVE                                            
             ,CODE_CRNT_LOC                                             
             ,CRNT_LOC_NO                                               
             ,LOCAL_OFFICE                                              
             ,PALETTE_NO                                                
             ,MFR_DT                                                    
             ,COMPANY_NO                                                
             ,NO_WIRES                                                  
             ,NO_PHASES                                                 
             ,ELEC_MTR_CLASS_CD                                         
             ,VOLTAGE                                                   
             ,ELEC_MTR_SPEC_CD                                          
             ,DATE_LAST_TESTED                                          
             ,MTR_CONNECT_TYP_ID                                        
             ,DEVICE_TYPE_CD                                            
             ,CODE_METER_TYPE                                           
             ,CONSTANT                                                  
C14744       ,IN_TRANSIT_EMP_ID                                         
             ,ROW_NUM                                                   
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-REC-COUNT                                              
             ,:S-METER-NO                                               
             ,:S-CODE-MAKE                                              
             ,:S-SERIAL-NO                                              
             ,:S-DATE-LAST-MOVE                                         
             ,:S-CODE-CRNT-LOC                                          
             ,:S-CRNT-LOC-NO                                            
             ,:S-LOCAL-OFFICE                                           
             ,:S-PALETTE-NO                                             
             ,:S-MFR-DT                                                 
             ,:S-COMPANY-NO                                             
             ,:S-NO-WIRES                                               
             ,:S-NO-PHASES                                              
             ,:S-ELEC-MTR-CLASS-CD                                      
             ,:S-VOLTAGE                                                
             ,:S-ELEC-MTR-SPEC-CD                                       
             ,:S-DATE-LAST-TESTED                                       
             ,:S-MTR-CONNECT-TYP-ID                                     
             ,:S-DEVICE-TYPE-CD                                         
             ,:S-CODE-METER-TYPE                                        
             ,:S-CONSTANT                                               
C14744       ,:S-IN-TRANSIT-EMP-ID                                      
             ,:S-ROW-NUM                                                
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00082400
MFA-TR*      INSERT INTO SESSION.CSR04184_R1                            00082500
MFA-TR*      (                                                          00082600
MFA-TR*       RETURN_CODE                                               00082700
MFA-TR*      ,REC_COUNT                                                 00082800
MFA-TR*      ,METER_NO                                                  00082900
MFA-TR*      ,CODE_MAKE                                                 00083000
MFA-TR*      ,SERIAL_NO                                                 00083100
MFA-TR*      ,DATE_LAST_MOVE                                            00083200
MFA-TR*      ,CODE_CRNT_LOC                                             00083300
MFA-TR*      ,CRNT_LOC_NO                                               00083400
MFA-TR*      ,LOCAL_OFFICE                                              00083500
MFA-TR*      ,PALETTE_NO                                                00083600
MFA-TR*      ,MFR_DT                                                    00083700
MFA-TR*      ,COMPANY_NO                                                00083800
MFA-TR*      ,NO_WIRES                                                  00083900
MFA-TR*      ,NO_PHASES                                                 00084000
MFA-TR*      ,ELEC_MTR_CLASS_CD                                         00084100
MFA-TR*      ,VOLTAGE                                                   00084200
MFA-TR*      ,ELEC_MTR_SPEC_CD                                          00084300
MFA-TR*      ,DATE_LAST_TESTED                                          00084400
MFA-TR*      ,MTR_CONNECT_TYP_ID                                        00084500
MFA-TR*      ,DEVICE_TYPE_CD                                            00084600
MFA-TR*      ,CODE_METER_TYPE                                           00084700
MFA-TR*      ,CONSTANT                                                  00084710
MFA-TR*      ,IN_TRANSIT_EMP_ID                                         00083800
MFA-TR*      ,ROW_NUM                                                   00084800
MFA-TR*      )                                                          00084900
MFA-TR*      VALUES                                                     00085000
MFA-TR*      (                                                          00085100
MFA-TR*       :S-RETURN-CODE                                            00085200
MFA-TR*      ,:S-REC-COUNT                                              00085300
MFA-TR*      ,:S-METER-NO                                               00085400
MFA-TR*      ,:S-CODE-MAKE                                              00085500
MFA-TR*      ,:S-SERIAL-NO                                              00085600
MFA-TR*      ,:S-DATE-LAST-MOVE                                         00085700
MFA-TR*      ,:S-CODE-CRNT-LOC                                          00085800
MFA-TR*      ,:S-CRNT-LOC-NO                                            00085900
MFA-TR*      ,:S-LOCAL-OFFICE                                           00086000
MFA-TR*      ,:S-PALETTE-NO                                             00086100
MFA-TR*      ,:S-MFR-DT                                                 00086200
MFA-TR*      ,:S-COMPANY-NO                                             00086300
MFA-TR*      ,:S-NO-WIRES                                               00086400
MFA-TR*      ,:S-NO-PHASES                                              00086500
MFA-TR*      ,:S-ELEC-MTR-CLASS-CD                                      00086600
MFA-TR*      ,:S-VOLTAGE                                                00086700
MFA-TR*      ,:S-ELEC-MTR-SPEC-CD                                       00086800
MFA-TR*      ,:S-DATE-LAST-TESTED                                       00086900
MFA-TR*      ,:S-MTR-CONNECT-TYP-ID                                     00087000
MFA-TR*      ,:S-DEVICE-TYPE-CD                                         00087100
MFA-TR*      ,:S-CODE-METER-TYPE                                        00087200
MFA-TR*      ,:S-CONSTANT                                               00087210
MFA-TR*      ,:S-IN-TRANSIT-EMP-ID                                              
MFA-TR*      ,:S-ROW-NUM                                                00087300
MFA-TR*      )                                                          00087400
MFA-TR*    END-EXEC.                                                    00087500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04184_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00089400
      ******************************************************************00089500
      * 8200-UPDATE-REC-COUNT                                          *00089600
      ******************************************************************00089700
       8200-UPDATE-REC-COUNT.                                           
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04184_R1                             
                 SET REC_COUNT   = :WS-TOTAL-RECORD                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00090000
MFA-TR*          UPDATE SESSION.CSR04184_R1                             00090100
MFA-TR*          SET REC_COUNT   = :WS-TOTAL-RECORD                     00090200
MFA-TR*     END-EXEC.                                                   00090300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '8200'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04184_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00092300
      *                                                                 00092400
      ******************************************************************00092500
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00092600
      ******************************************************************00092700
           EXEC SQL                                                     00092800
              INCLUDE CPDSP300                                          00092900
           END-EXEC.                                                    00093000
      *                                                                 00093100
      ***************************************************************** 00093200
      * 8900-SEND-DONE                                                * 00093300
      * 9000-SEND-ERROR-RESULT                                        * 00093400
      * 9999-END-PROGRAM                                              * 00093500
      ***************************************************************** 00093600
           EXEC SQL                                                     00093700
              INCLUDE CPD00320                                          00093800
           END-EXEC.                                                    00093900
                                                                        
