       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04183.                                         
COB303 DATE-WRITTEN.  DEC 26 2008.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED FROM METER INVENTORY SYSTEM FOR      *        
      *  ELECTRIC AND GAS ATTACHMENT INVENTORY SCREENS                 *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES DETAILS OF GAS METER DEVICE          *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/26/08  JG41113    SPCB FOR METER INVENTORY SYSTEM          *        
C14744*  10/17/09  SB40505    ADDED INTRANSIT EMPLOYEE ID FOR BAR CODE *        
A02790*  09/29/10  SB40505    FIXED VERSION CODE CODE VALUE CALL       *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04183'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04183 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_EQUIP_ATTCHMTS LX                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQATTH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_EQUIP_MAKE M2                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQMAKE                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_EQUIP_LOCATION M6                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEQLOC                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MTR_STORGE_FAC W9                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRFAC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_CODE_VALUE UV                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_MTR_ATT_TYPE N5                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_METER_ATTCHMTS MA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRATT                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *01  GW-LIB-MISC-FIELDS.                                                  
      *    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
                                                                        
      *01  SNA-FIELDS.                                                          
      *    05  SNA-SUBC                PIC S9(9) COMP.                          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-TOT-ROW-COUNT        PIC S9(9) COMP VALUE 0.          
                                                                        
      *****************************************************************         
      * PARM FIELDS                                                    *        
      *****************************************************************         
                                                                        
      *01  WORK-FIELDS.                                                         
      *    05  WRK-DONE-STATUS         PIC S9(9) COMP.                          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04183'.      
           05  WS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
           05  WS-MTR-STORAGE-FAC-CD   PIC X(03) VALUE SPACES.          
           05  WS-MTR-STORAGE-FAC-CD1  PIC X(03) VALUE SPACES.          
           05  WS-EQUIP-LOC-ID         PIC X(01) VALUE SPACES.          
           05  WS-CODE-ATT-TYPE        PIC X(02) VALUE SPACES.          
           05  WS-CODE-MAKE            PIC X(02) VALUE SPACES.          
           05  WS-DEVICE-NO            PIC X(12) VALUE SPACES.          
C14744     05  WS-IN-TRANSIT-EMP-ID    PIC X(07) VALUE SPACES.          
           05  WS-NULL-INDICATOR        PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-1      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-2      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-3      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-4      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-5      PIC S9(04) COMP VALUE +0.       
           05  WS-ACTIVE-RETURN-CODE-2  PIC S9(04) VALUE 0.             
           05  WS-FOUND-DATA-FL         PIC X(01) VALUE 'N'.            
                                                                        
      ******************************************************************        
      *    THIS IS THE ROW RETURN AREA                                 *        
      ******************************************************************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-REC-COUNT            PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-COMPANY-NO           PIC X(02)  VALUE SPACES.         
           05  RS-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACES.         
           05  RS-CODE-ATT-TYPE        PIC X(02)  VALUE SPACES.         
           05  RS-DEVICE-NO            PIC X(12)  VALUE SPACES.         
           05  RS-MTR-STORAGE-FAC-CD   PIC X(03)  VALUE SPACES.         
           05  RS-CODE-MAKE            PIC X(02)  VALUE SPACES.         
           05  RS-DATE-LAST-TESTED     PIC X(10)  VALUE SPACES.         
           05  RS-EQUIP-ATTACH-DT      PIC X(10)  VALUE SPACES.         
           05  RS-VERSION-CD           PIC X(03)  VALUE SPACES.         
           05  RS-EQUIP-LOC-ID         PIC X(01)  VALUE SPACES.         
           05  RS-MTR-STORGE-FAC-TX    PIC X(35)  VALUE SPACES.         
           05  RS-VERSION-CD-DISP      PIC X(15)  VALUE SPACES.         
           05  RS-MTR-ATT-TYPE-DESC    PIC X(08)  VALUE SPACES.         
           05  RS-EQUIP-MAKE-DESC      PIC X(16)  VALUE SPACES.         
           05  RS-EQUIP-LOC-DESC       PIC X(25)  VALUE SPACES.         
           05  RS-METER-NO             PIC X(09)  VALUE SPACES.         
C14744     05  RS-IN-TRANSIT-EMP-ID    PIC X(07)  VALUE SPACES.         
           05  RS-ROW-NUM              PIC S9(09) USAGE COMP VALUE 0.   
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-REC-COUNT             PIC S9(09) USAGE COMP VALUE 0.   
           05  S-COMPANY-NO            PIC X(02)  VALUE SPACES.         
           05  S-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.         
           05  S-CODE-ATT-TYPE         PIC X(02)  VALUE SPACES.         
           05  S-DEVICE-NO             PIC X(12)  VALUE SPACES.         
           05  S-MTR-STORAGE-FAC-CD    PIC X(03)  VALUE SPACES.         
           05  S-CODE-MAKE             PIC X(02)  VALUE SPACES.         
           05  S-DATE-LAST-TESTED      PIC X(10)  VALUE SPACES.         
           05  S-EQUIP-ATTACH-DT       PIC X(10)  VALUE SPACES.         
           05  S-VERSION-CD            PIC X(03)  VALUE SPACES.         
           05  S-EQUIP-LOC-ID          PIC X(01)  VALUE SPACES.         
           05  S-MTR-STORGE-FAC-TX     PIC X(35)  VALUE SPACES.         
           05  S-VERSION-CD-DISP       PIC X(15)  VALUE SPACES.         
           05  S-MTR-ATT-TYPE-DESC     PIC X(08)  VALUE SPACES.         
           05  S-EQUIP-MAKE-DESC       PIC X(16)  VALUE SPACES.         
           05  S-EQUIP-LOC-DESC        PIC X(25)  VALUE SPACES.         
           05  S-METER-NO              PIC X(09)  VALUE SPACES.         
C14744     05  S-IN-TRANSIT-EMP-ID     PIC X(07)  VALUE SPACES.         
           05  S-ROW-NUM               PIC S9(09) USAGE COMP VALUE 0.   
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS - METER_FILTER                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE METER_FILTER CURSOR FOR                           
              SELECT TOP(1000) LX.COMPANY_NO,
              LX.CODE_UTIL_TYPE,
              LX.CODE_ATT_TYPE,
              LX.DEVICE_NO,
              LX.MTR_STORAGE_FAC_CD,
              LX.CODE_MAKE,
              LX.DATE_LAST_TESTED,
              LX.EQUIP_ATTACH_DT,
              LX.VERSION_CD,
              LX.EQUIP_LOC_ID,
              LX.IN_TRANSIT_EMP_ID,
              CIS.CONCAT(COALESCE(W9.MTR_STORAGE_FAC_CD,'N/A'),
                     CIS.CONCAT(' -',COALESCE(
           W9.MTR_STORAGE_FAC_TX,'N/A')))                    
                     AS MTR_STORGE_FAC_TX,
              UV.CODE_SHORT_DESC,
              N5.MTR_ATT_TYPE_DESC,
              CIS.CONCAT(M2.CODE_MAKE,                               
                     CIS.CONCAT(' - ',M2.EQUIP_MAKE_DESC))                  
                     AS EQUIP_MAKE_DESC,
              M6.EQUIP_LOC_DESC,
              MA.METER_NO                                        
               FROM                                                     
                    CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                 
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (M2.CODE_MAKE = LX.CODE_MAKE)                        
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_LOCATION M6 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                   
                    AND M6.COMPANY_NO = LX.COMPANY_NO                   
                    AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_MTR_STORGE_FAC W9 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD       
                    AND W9.COMPANY_NO = LX.COMPANY_NO                   
                    AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (UV.COMPANY_NO = LX.COMPANY_NO                       
                    AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'              
                    AND UV.COLUMN_NA = 'VERSION_CD'                     
A02790              AND UV.CODE_VALUE = LX.CODE_UTIL_TYPE + 
           LX.CODE_ATT_TYPE + LX.VERSION_CD)           
               LEFT OUTER JOIN                                          
                    CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                   
                 ON                                                     
                   (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE               
                    AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)            
               LEFT OUTER JOIN                                          
                   CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                  
                 ON                                                     
                   (MA.COMPANY_NO = LX.COMPANY_NO                       
                    AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE           
                    AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE             
                    AND MA.DEVICE_NO = LX.DEVICE_NO )                   
              WHERE                                                     
                    LX.COMPANY_NO = :LX-COMPANY-NO                      
               AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE               
      *        AND (:WS-MTR-STORAGE-FAC-CD = ' '                                
      *             OR LX.MTR_STORAGE_FAC_CD = :WS-MTR-STORAGE-FAC-CD)          
      *        AND (:WS-EQUIP-LOC-ID = ' '                                      
      *             OR LX.EQUIP_LOC_ID = :WS-EQUIP-LOC-ID)                      
      *        AND (:WS-CODE-ATT-TYPE = ' '                                     
      *             OR LX.CODE_ATT_TYPE = :WS-CODE-ATT-TYPE)                    
      *        AND (:WS-CODE-MAKE = ' '                                         
      *            OR LX.CODE_MAKE = :WS-CODE-MAKE)                             
               AND LX.MTR_STORAGE_FAC_CD LIKE :LX-MTR-STORAGE-FAC-CD    
               AND LX.EQUIP_LOC_ID   LIKE :LX-EQUIP-LOC-ID              
C14744         AND LX.IN_TRANSIT_EMP_ID   LIKE :LX-IN-TRANSIT-EMP-ID    
               AND LX.CODE_ATT_TYPE  LIKE :LX-CODE-ATT-TYPE             
               AND LX.CODE_MAKE      LIKE :LX-CODE-MAKE                 
             ORDER BY LX.DEVICE_NO                                      
                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER_FILTER CURSOR FOR                                   
MFA-TR*       SELECT LX.COMPANY_NO                                              
MFA-TR*             ,LX.CODE_UTIL_TYPE                                          
MFA-TR*             ,LX.CODE_ATT_TYPE                                           
MFA-TR*             ,LX.DEVICE_NO                                               
MFA-TR*             ,LX.MTR_STORAGE_FAC_CD                                      
MFA-TR*             ,LX.CODE_MAKE                                               
MFA-TR*             ,LX.DATE_LAST_TESTED                                        
MFA-TR*             ,LX.EQUIP_ATTACH_DT                                         
MFA-TR*             ,LX.VERSION_CD                                              
MFA-TR*             ,LX.EQUIP_LOC_ID                                            
MFA-TR*             ,LX.IN_TRANSIT_EMP_ID                                       
MFA-TR*             ,CONCAT(COALESCE(CHAR(W9.MTR_STORAGE_FAC_CD),'N/A'),        
MFA-TR*              CONCAT(' -',COALESCE(CHAR(                                 
MFA-TR*              W9.MTR_STORAGE_FAC_TX),'N/A')))                            
MFA-TR*              AS MTR_STORGE_FAC_TX                                       
MFA-TR*             ,UV.CODE_SHORT_DESC                                         
MFA-TR*             ,N5.MTR_ATT_TYPE_DESC                                       
MFA-TR*             ,CONCAT(M2.CODE_MAKE,                                       
MFA-TR*              CONCAT(' - ',M2.EQUIP_MAKE_DESC))                          
MFA-TR*              AS EQUIP_MAKE_DESC                                         
MFA-TR*             ,M6.EQUIP_LOC_DESC                                          
MFA-TR*             ,MA.METER_NO                                                
MFA-TR*        FROM                                                             
MFA-TR*             CSS_EQUIP_ATTCHMTS LX                                       
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_MAKE M2                                           
MFA-TR*          ON                                                             
MFA-TR*            (M2.CODE_MAKE = LX.CODE_MAKE)                                
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_LOCATION M6                                       
MFA-TR*          ON                                                             
MFA-TR*            (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                           
MFA-TR*             AND M6.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_STORGE_FAC W9                                       
MFA-TR*          ON                                                             
MFA-TR*            (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD               
MFA-TR*             AND W9.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_CODE_VALUE UV                                           
MFA-TR*          ON                                                             
MFA-TR*            (UV.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'                      
MFA-TR*             AND UV.COLUMN_NA = 'VERSION_CD'                             
MFA-TR*             AND UV.CODE_VALUE = LX.CODE_UTIL_TYPE ||                    
MFA-TR*                    LX.CODE_ATT_TYPE || LX.VERSION_CD)                   
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_ATT_TYPE N5                                         
MFA-TR*          ON                                                             
MFA-TR*            (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                       
MFA-TR*             AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)                    
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*            CSS_METER_ATTCHMTS MA                                        
MFA-TR*          ON                                                             
MFA-TR*            (MA.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                   
MFA-TR*             AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE                     
MFA-TR*             AND MA.DEVICE_NO = LX.DEVICE_NO )                           
MFA-TR*       WHERE                                                             
MFA-TR*             LX.COMPANY_NO = :LX-COMPANY-NO                              
MFA-TR*        AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                       
MFA-TR*        AND (:WS-MTR-STORAGE-FAC-CD = ' '                                
MFA-TR*             OR LX.MTR_STORAGE_FAC_CD = :WS-MTR-STORAGE-FAC-CD)          
MFA-TR*        AND (:WS-EQUIP-LOC-ID = ' '                                      
MFA-TR*             OR LX.EQUIP_LOC_ID = :WS-EQUIP-LOC-ID)                      
MFA-TR*        AND (:WS-CODE-ATT-TYPE = ' '                                     
MFA-TR*             OR LX.CODE_ATT_TYPE = :WS-CODE-ATT-TYPE)                    
MFA-TR*        AND (:WS-CODE-MAKE = ' '                                         
MFA-TR*            OR LX.CODE_MAKE = :WS-CODE-MAKE)                             
MFA-TR*        AND LX.MTR_STORAGE_FAC_CD LIKE :LX-MTR-STORAGE-FAC-CD            
MFA-TR*        AND LX.EQUIP_LOC_ID   LIKE :LX-EQUIP-LOC-ID                      
MFA-TR*        AND LX.IN_TRANSIT_EMP_ID   LIKE :LX-IN-TRANSIT-EMP-ID            
MFA-TR*        AND LX.CODE_ATT_TYPE  LIKE :LX-CODE-ATT-TYPE                     
MFA-TR*        AND LX.CODE_MAKE      LIKE :LX-CODE-MAKE                         
MFA-TR*      ORDER BY LX.DEVICE_NO                                              
MFA-TR*      FETCH FIRST 1000 ROWS ONLY WITH UR                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS - METER_FILTER_DEVICE                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE METER_FILTER_DEVICE CURSOR FOR                    
              SELECT TOP(1000) LX.COMPANY_NO,
              LX.CODE_UTIL_TYPE,
              LX.CODE_ATT_TYPE,
              LX.DEVICE_NO,
              LX.MTR_STORAGE_FAC_CD,
              LX.CODE_MAKE,
              LX.DATE_LAST_TESTED,
              LX.EQUIP_ATTACH_DT,
              LX.VERSION_CD,
              LX.EQUIP_LOC_ID,
              LX.IN_TRANSIT_EMP_ID,
              CIS.CONCAT(COALESCE(W9.MTR_STORAGE_FAC_CD,'N/A'),
                     CIS.CONCAT(' -',COALESCE(
           W9.MTR_STORAGE_FAC_TX,'N/A')))                    
                     AS MTR_STORGE_FAC_TX,
              UV.CODE_SHORT_DESC,
              N5.MTR_ATT_TYPE_DESC,
              CIS.CONCAT(M2.CODE_MAKE,                               
                     CIS.CONCAT(' - ',M2.EQUIP_MAKE_DESC))                  
                     AS EQUIP_MAKE_DESC,
              M6.EQUIP_LOC_DESC,
              MA.METER_NO                                        
               FROM                                                     
                    CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                 
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (M2.CODE_MAKE = LX.CODE_MAKE)                        
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_LOCATION M6 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                   
                    AND M6.COMPANY_NO = LX.COMPANY_NO                   
                    AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_MTR_STORGE_FAC W9 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD       
                    AND W9.COMPANY_NO = LX.COMPANY_NO                   
                    AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (UV.COMPANY_NO = LX.COMPANY_NO                       
                    AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'              
                    AND UV.COLUMN_NA = 'VERSION_CD'                     
                    AND UV.CODE_VALUE = LX.VERSION_CD)                  
               LEFT OUTER JOIN                                          
                    CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                   
                 ON                                                     
                   (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE               
                    AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)            
               LEFT OUTER JOIN                                          
                    CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (MA.COMPANY_NO = LX.COMPANY_NO                       
                    AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE           
                    AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE             
                    AND MA.DEVICE_NO = LX.DEVICE_NO )                   
              WHERE                                                     
                    LX.COMPANY_NO = :LX-COMPANY-NO                      
                AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE              
                AND LX.DEVICE_NO      = :WS-DEVICE-NO                   
             ORDER BY LX.DEVICE_NO                                      
                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE METER_FILTER_DEVICE CURSOR FOR                            
MFA-TR*       SELECT LX.COMPANY_NO                                              
MFA-TR*             ,LX.CODE_UTIL_TYPE                                          
MFA-TR*             ,LX.CODE_ATT_TYPE                                           
MFA-TR*             ,LX.DEVICE_NO                                               
MFA-TR*             ,LX.MTR_STORAGE_FAC_CD                                      
MFA-TR*             ,LX.CODE_MAKE                                               
MFA-TR*             ,LX.DATE_LAST_TESTED                                        
MFA-TR*             ,LX.EQUIP_ATTACH_DT                                         
MFA-TR*             ,LX.VERSION_CD                                              
MFA-TR*             ,LX.EQUIP_LOC_ID                                            
MFA-TR*             ,LX.IN_TRANSIT_EMP_ID                                       
MFA-TR*             ,CONCAT(COALESCE(CHAR(W9.MTR_STORAGE_FAC_CD),'N/A'),        
MFA-TR*              CONCAT(' -',COALESCE(CHAR(                                 
MFA-TR*              W9.MTR_STORAGE_FAC_TX),'N/A')))                            
MFA-TR*              AS MTR_STORGE_FAC_TX                                       
MFA-TR*             ,UV.CODE_SHORT_DESC                                         
MFA-TR*             ,N5.MTR_ATT_TYPE_DESC                                       
MFA-TR*             ,CONCAT(M2.CODE_MAKE,                                       
MFA-TR*              CONCAT(' - ',M2.EQUIP_MAKE_DESC))                          
MFA-TR*              AS EQUIP_MAKE_DESC                                         
MFA-TR*             ,M6.EQUIP_LOC_DESC                                          
MFA-TR*             ,MA.METER_NO                                                
MFA-TR*        FROM                                                             
MFA-TR*             CSS_EQUIP_ATTCHMTS LX                                       
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_MAKE M2                                           
MFA-TR*          ON                                                             
MFA-TR*            (M2.CODE_MAKE = LX.CODE_MAKE)                                
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_LOCATION M6                                       
MFA-TR*          ON                                                             
MFA-TR*            (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                           
MFA-TR*             AND M6.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_STORGE_FAC W9                                       
MFA-TR*          ON                                                             
MFA-TR*            (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD               
MFA-TR*             AND W9.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_CODE_VALUE UV                                           
MFA-TR*          ON                                                             
MFA-TR*            (UV.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'                      
MFA-TR*             AND UV.COLUMN_NA = 'VERSION_CD'                             
MFA-TR*             AND UV.CODE_VALUE = LX.VERSION_CD)                          
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_ATT_TYPE N5                                         
MFA-TR*          ON                                                             
MFA-TR*            (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                       
MFA-TR*             AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)                    
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_METER_ATTCHMTS MA                                       
MFA-TR*          ON                                                             
MFA-TR*            (MA.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                   
MFA-TR*             AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE                     
MFA-TR*             AND MA.DEVICE_NO = LX.DEVICE_NO )                           
MFA-TR*       WHERE                                                             
MFA-TR*             LX.COMPANY_NO = :LX-COMPANY-NO                              
MFA-TR*         AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                      
MFA-TR*         AND LX.DEVICE_NO      = :WS-DEVICE-NO                           
MFA-TR*      ORDER BY LX.DEVICE_NO                                              
MFA-TR*      FETCH FIRST 1000 ROWS ONLY WITH UR                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      *    FOR FINAL RETURN                                            *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                  RETURN_CODE                                           
                 ,REC_COUNT                                             
                 ,COMPANY_NO                                            
                 ,CODE_UTIL_TYPE                                        
                 ,CODE_ATT_TYPE                                         
                 ,DEVICE_NO                                             
                 ,MTR_STORAGE_FAC_CD                                    
                 ,CODE_MAKE                                             
                 ,DATE_LAST_TESTED                                      
                 ,EQUIP_ATTACH_DT                                       
                 ,VERSION_CD                                            
                 ,EQUIP_LOC_ID                                          
C14744           ,IN_TRANSIT_EMP_ID                                     
                 ,MTR_STORGE_FAC_TX                                     
                 ,VERSION_CD_DISP                                       
                 ,MTR_ATT_TYPE_DESC                                     
                 ,EQUIP_MAKE_DESC                                       
                 ,EQUIP_LOC_DESC                                        
                 ,METER_NO                                              
                 ,ROW_NUM                                               
              FROM #CSR04183_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,REC_COUNT                                                     
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,CODE_ATT_TYPE                                                 
MFA-TR*          ,DEVICE_NO                                                     
MFA-TR*          ,MTR_STORAGE_FAC_CD                                            
MFA-TR*          ,CODE_MAKE                                                     
MFA-TR*          ,DATE_LAST_TESTED                                              
MFA-TR*          ,EQUIP_ATTACH_DT                                               
MFA-TR*          ,VERSION_CD                                                    
MFA-TR*          ,EQUIP_LOC_ID                                                  
MFA-TR*          ,IN_TRANSIT_EMP_ID                                             
MFA-TR*          ,MTR_STORGE_FAC_TX                                             
MFA-TR*          ,VERSION_CD_DISP                                               
MFA-TR*          ,MTR_ATT_TYPE_DESC                                             
MFA-TR*          ,EQUIP_MAKE_DESC                                               
MFA-TR*          ,EQUIP_LOC_DESC                                                
MFA-TR*          ,METER_NO                                                      
MFA-TR*          ,ROW_NUM                                                       
MFA-TR*       FROM SESSION.CSR04183_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-COMPANY-NO         PIC X(02).                            
       01 PARM-CODE-UTIL-TYPE     PIC X(01).                            
       01 PARM-MTR-STORAGE-FAC-CD PIC X(03).                            
       01 PARM-EQUIP-LOC-ID       PIC X(01).                            
       01 PARM-CODE-ATT-TYPE      PIC X(02).                            
       01 PARM-CODE-MAKE          PIC X(02).                            
       01 PARM-DEVICE-NO          PIC X(12).                            
C14744 01 PARM-IN-TRANSIT-EMP-ID  PIC X(07).                            
      *                                                                         
       PROCEDURE DIVISION USING PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-MTR-STORAGE-FAC-CD                 
                                PARM-EQUIP-LOC-ID                       
                                PARM-CODE-ATT-TYPE                      
                                PARM-CODE-MAKE                          
                                PARM-DEVICE-NO                          
C14744                          PARM-IN-TRANSIT-EMP-ID.                 
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04183_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04183_R1
              (                                                         
                RETURN_CODE             INT                         
               ,REC_COUNT               INT                         
               ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
               ,CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,CODE_ATT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,DEVICE_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,MTR_STORAGE_FAC_CD CHAR(03)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,CODE_MAKE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,DATE_LAST_TESTED CHAR(10)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,EQUIP_ATTACH_DT CHAR(10)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,VERSION_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2            
               ,EQUIP_LOC_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
C14744         ,IN_TRANSIT_EMP_ID CHAR(07)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,MTR_STORGE_FAC_TX CHAR(35)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,VERSION_CD_DISP CHAR(15)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,MTR_ATT_TYPE_DESC CHAR(08)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,EQUIP_MAKE_DESC CHAR(16)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,EQUIP_LOC_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2              
               ,ROW_NUM                 INT                         
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000-DELETE-GTT-ROWS THRU 8000-EXIT               
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0110'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04183_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO.               
           MOVE PARM-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE.           
           MOVE PARM-MTR-STORAGE-FAC-CD TO WS-MTR-STORAGE-FAC-CD.       
           MOVE PARM-EQUIP-LOC-ID       TO WS-EQUIP-LOC-ID.             
           MOVE PARM-CODE-ATT-TYPE      TO WS-CODE-ATT-TYPE.            
           MOVE PARM-CODE-MAKE          TO WS-CODE-MAKE.                
           MOVE PARM-DEVICE-NO          TO WS-DEVICE-NO.                
C14744     MOVE PARM-IN-TRANSIT-EMP-ID  TO WS-IN-TRANSIT-EMP-ID.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF WS-COMPANY-NO = SPACES OR WS-CODE-UTIL-TYPE = SPACE       
                 MOVE 5100                  TO WS-ACTIVE-RETURN-CODE    
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 PERFORM 2010-MOVE-RESULT        THRU 2010-EXIT         
                 PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9999-END-PROGRAM        THRU 9999-EXIT         
           ELSE                                                         
                 IF (WS-DEVICE-NO         NOT = '%%%%%%%%%%%%' AND      
                     WS-DEVICE-NO          > SPACES)                    
                     PERFORM 2200-PROCESS-METER-DEVICE    THRU 2200-EXIT
                 ELSE                                                   
                     IF  WS-MTR-STORAGE-FAC-CD > SPACES OR              
                         WS-EQUIP-LOC-ID       > SPACES OR              
                         WS-CODE-ATT-TYPE      > SPACES OR              
                         WS-CODE-MAKE          > SPACES OR              
C14744                   WS-IN-TRANSIT-EMP-ID  > SPACES                 
                         PERFORM 2100-PROCESS-FILTER      THRU 2100-EXIT
                     ELSE                                               
                          MOVE 5100        TO WS-ACTIVE-RETURN-CODE     
                          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE  
                          PERFORM 2010-MOVE-RESULT        THRU 2010-EXIT
                          PERFORM 8100-SEND-RESULT        THRU 8100-EXIT
                          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT
                          PERFORM 9999-END-PROGRAM        THRU 9999-EXIT
                     END-IF                                             
                 END-IF                                                 
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2010-MOVE-RESULT.                                                        
      ******************************************************************        
       2010-MOVE-RESULT.                                                
                                                                        
              MOVE RS-RETURN-CODE        TO S-RETURN-CODE.              
              MOVE RS-REC-COUNT          TO S-REC-COUNT.                
              MOVE RS-COMPANY-NO         TO S-COMPANY-NO.               
              MOVE RS-CODE-UTIL-TYPE     TO S-CODE-UTIL-TYPE.           
              MOVE RS-CODE-ATT-TYPE      TO S-CODE-ATT-TYPE.            
              MOVE RS-DEVICE-NO          TO S-DEVICE-NO.                
              MOVE RS-MTR-STORAGE-FAC-CD TO S-MTR-STORAGE-FAC-CD.       
              MOVE RS-CODE-MAKE          TO S-CODE-MAKE.                
              MOVE RS-DATE-LAST-TESTED   TO S-DATE-LAST-TESTED.         
              MOVE RS-EQUIP-ATTACH-DT    TO S-EQUIP-ATTACH-DT.          
              MOVE RS-VERSION-CD         TO S-VERSION-CD.               
              MOVE RS-EQUIP-LOC-ID       TO S-EQUIP-LOC-ID.             
C14744        MOVE RS-IN-TRANSIT-EMP-ID  TO S-IN-TRANSIT-EMP-ID.        
              MOVE RS-MTR-STORGE-FAC-TX  TO S-MTR-STORGE-FAC-TX.        
              MOVE RS-VERSION-CD-DISP    TO S-VERSION-CD-DISP           
              MOVE RS-MTR-ATT-TYPE-DESC  TO S-MTR-ATT-TYPE-DESC.        
              MOVE RS-EQUIP-MAKE-DESC    TO S-EQUIP-MAKE-DESC.          
              MOVE RS-EQUIP-LOC-DESC     TO S-EQUIP-LOC-DESC.           
              MOVE RS-METER-NO           TO S-METER-NO.                 
              MOVE RS-ROW-NUM            TO S-ROW-NUM.                  
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-FILTER                                            *        
      ******************************************************************        
       2100-PROCESS-FILTER.                                             
      *                                                                         
           MOVE WS-COMPANY-NO             TO LX-COMPANY-NO.             
           MOVE WS-CODE-UTIL-TYPE         TO LX-CODE-UTIL-TYPE.         
      *    MOVE WS-MTR-STORAGE-FAC-CD     TO LX-MTR-STORAGE-FAC-CD.             
      *    MOVE WS-EQUIP-LOC-ID           TO LX-EQUIP-LOC-ID.                   
      *    MOVE WS-CODE-ATT-TYPE          TO LX-CODE-ATT-TYPE.                  
      *    MOVE WS-CODE-MAKE              TO LX-CODE-MAKE.                      
      *                                                                         
           IF WS-MTR-STORAGE-FAC-CD EQUAL SPACES                        
              MOVE '%%%'                  TO LX-MTR-STORAGE-FAC-CD      
           ELSE                                                         
              MOVE WS-MTR-STORAGE-FAC-CD   TO LX-MTR-STORAGE-FAC-CD     
           END-IF.                                                      
           IF WS-EQUIP-LOC-ID EQUAL SPACE                               
              MOVE '%'                    TO LX-EQUIP-LOC-ID            
           ELSE                                                         
              MOVE WS-EQUIP-LOC-ID        TO LX-EQUIP-LOC-ID            
           END-IF.                                                      
           IF WS-CODE-ATT-TYPE EQUAL SPACES                             
              MOVE '%%'                   TO LX-CODE-ATT-TYPE           
           ELSE                                                         
              MOVE WS-CODE-ATT-TYPE       TO LX-CODE-ATT-TYPE           
           END-IF.                                                      
           IF WS-CODE-MAKE EQUAL SPACES                                 
              MOVE '%%'                   TO LX-CODE-MAKE               
           ELSE                                                         
              MOVE WS-CODE-MAKE           TO LX-CODE-MAKE               
           END-IF.                                                      
C14744     IF WS-IN-TRANSIT-EMP-ID EQUAL SPACES                         
C14744        MOVE '%%%%%%%'              TO LX-IN-TRANSIT-EMP-ID       
C14744     ELSE                                                         
C14744        MOVE WS-IN-TRANSIT-EMP-ID   TO LX-IN-TRANSIT-EMP-ID       
C14744     END-IF.                                                      
      *                                                                         
           PERFORM 7100-OPEN-METER-FILTER        THRU 7100-EXIT.        
           PERFORM 7300-GET-TOT-ROW-COUNT        THRU 7300-EXIT.        
           PERFORM 2120-PROCESS-FETCH-FILTER     THRU 2120-EXIT         
                   UNTIL WS-ACTIVE-RETURN-CODE-2 = NOT-FOUND.           
                                                                        
           IF WS-FOUND-DATA-FL = 'N'                                    
              MOVE WS-ACTIVE-RETURN-CODE-2  TO RS-RETURN-CODE           
              MOVE '2100'                   TO ACTIVE-PARAGRAPH         
              PERFORM 2010-MOVE-RESULT      THRU 2010-EXIT              
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 7130-CLOSE-METER-FILTER       THRU 7130-EXIT.        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-PROCESS-FETCH-FILTER                                      *        
      ******************************************************************        
       2120-PROCESS-FETCH-FILTER.                                       
                                                                        
           PERFORM 7120-FETCH-METER-FILTER     THRU 7120-EXIT.          
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE TO WS-ACTIVE-RETURN-CODE-2.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO WS-ROW-COUNT                                     
                                                                        
              MOVE 'Y'                   TO WS-FOUND-DATA-FL            
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE WS-TOT-ROW-COUNT      TO RS-REC-COUNT                
              MOVE LX-COMPANY-NO         TO RS-COMPANY-NO               
              MOVE LX-CODE-UTIL-TYPE     TO RS-CODE-UTIL-TYPE           
              MOVE LX-CODE-ATT-TYPE      TO RS-CODE-ATT-TYPE            
              MOVE LX-DEVICE-NO          TO RS-DEVICE-NO                
              MOVE LX-MTR-STORAGE-FAC-CD TO RS-MTR-STORAGE-FAC-CD       
              MOVE LX-CODE-MAKE          TO RS-CODE-MAKE                
              MOVE LX-DATE-LAST-TESTED   TO RS-DATE-LAST-TESTED         
              MOVE LX-EQUIP-ATTACH-DT    TO RS-EQUIP-ATTACH-DT          
              MOVE LX-VERSION-CD         TO RS-VERSION-CD               
              MOVE LX-EQUIP-LOC-ID       TO RS-EQUIP-LOC-ID             
C14744        MOVE LX-IN-TRANSIT-EMP-ID  TO RS-IN-TRANSIT-EMP-ID        
              MOVE W9-MTR-STORAGE-FAC-TX TO RS-MTR-STORGE-FAC-TX        
              MOVE UV-CODE-SHORT-DESC-TEXT(1:UV-CODE-SHORT-DESC-LEN)    
                                         TO RS-VERSION-CD-DISP          
              MOVE N5-MTR-ATT-TYPE-DESC  TO RS-MTR-ATT-TYPE-DESC        
              MOVE M2-EQUIP-MAKE-DESC    TO RS-EQUIP-MAKE-DESC          
              MOVE M6-EQUIP-LOC-DESC     TO RS-EQUIP-LOC-DESC           
              MOVE MA-METER-NO           TO RS-METER-NO                 
                                                                        
              MOVE WS-ROW-COUNT          TO RS-ROW-NUM                  
                                                                        
              MOVE '2120'                   TO ACTIVE-PARAGRAPH         
              PERFORM 2010-MOVE-RESULT      THRU 2010-EXIT              
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-METER-DEVICE                                      *        
      ******************************************************************        
       2200-PROCESS-METER-DEVICE.                                       
                                                                        
           MOVE WS-COMPANY-NO             TO LX-COMPANY-NO.             
           MOVE WS-CODE-UTIL-TYPE         TO LX-CODE-UTIL-TYPE.         
           MOVE WS-DEVICE-NO              TO LX-DEVICE-NO.              
                                                                        
           PERFORM 7200-OPEN-METER-DEVICE         THRU 7200-EXIT.       
           PERFORM 7400-GET-DEVICE-TOT-ROW-COUNT  THRU 7400-EXIT.       
           PERFORM 2220-PROCESS-FETCH-DEVICE      THRU 2220-EXIT        
             UNTIL WS-ACTIVE-RETURN-CODE-2 = NOT-FOUND.                 
                                                                        
           IF WS-FOUND-DATA-FL = 'N'                                    
              MOVE WS-ACTIVE-RETURN-CODE-2        TO RS-RETURN-CODE     
              MOVE '2200'                         TO ACTIVE-PARAGRAPH   
              PERFORM 2010-MOVE-RESULT            THRU 2010-EXIT        
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF.                                                      
                                                                        
           PERFORM 7230-CLOSE-METER-DEVICE  THRU 7230-EXIT.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2220-PROCESS-FETCH-DEVICE                                      *        
      ******************************************************************        
       2220-PROCESS-FETCH-DEVICE.                                       
                                                                        
           PERFORM 7220-FETCH-METER-DEVICE     THRU 7220-EXIT           
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO WS-ACTIVE-RETURN-CODE-2.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                      TO WS-ROW-COUNT                
                                                                        
              MOVE 'Y'                   TO WS-FOUND-DATA-FL            
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE WS-TOT-ROW-COUNT      TO RS-REC-COUNT                
              MOVE LX-COMPANY-NO         TO RS-COMPANY-NO               
              MOVE LX-CODE-UTIL-TYPE     TO RS-CODE-UTIL-TYPE           
              MOVE LX-CODE-ATT-TYPE      TO RS-CODE-ATT-TYPE            
              MOVE LX-DEVICE-NO          TO RS-DEVICE-NO                
              MOVE LX-MTR-STORAGE-FAC-CD TO RS-MTR-STORAGE-FAC-CD       
              MOVE LX-CODE-MAKE          TO RS-CODE-MAKE                
              MOVE LX-DATE-LAST-TESTED   TO RS-DATE-LAST-TESTED         
              MOVE LX-EQUIP-ATTACH-DT    TO RS-EQUIP-ATTACH-DT          
              MOVE LX-VERSION-CD         TO RS-VERSION-CD               
              MOVE LX-EQUIP-LOC-ID       TO RS-EQUIP-LOC-ID             
C14744        MOVE LX-IN-TRANSIT-EMP-ID  TO RS-IN-TRANSIT-EMP-ID        
              MOVE W9-MTR-STORAGE-FAC-TX TO RS-MTR-STORGE-FAC-TX        
              MOVE UV-CODE-SHORT-DESC-TEXT(1:UV-CODE-SHORT-DESC-LEN)    
                                         TO RS-VERSION-CD-DISP          
              MOVE N5-MTR-ATT-TYPE-DESC  TO RS-MTR-ATT-TYPE-DESC        
              MOVE M2-EQUIP-MAKE-DESC    TO RS-EQUIP-MAKE-DESC          
              MOVE M6-EQUIP-LOC-DESC     TO RS-EQUIP-LOC-DESC           
              MOVE MA-METER-NO           TO RS-METER-NO                 
                                                                        
              MOVE WS-ROW-COUNT          TO RS-ROW-NUM                  
                                                                        
              MOVE '2220'                   TO ACTIVE-PARAGRAPH         
              PERFORM 2010-MOVE-RESULT      THRU 2010-EXIT              
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-METER-FILTER                                         *        
      ******************************************************************        
       7100-OPEN-METER-FILTER.                                          
                                                                        
           EXEC SQL                                                     
              OPEN METER_FILTER                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-FETCH-METER-FILTER                                        *        
      ******************************************************************        
       7120-FETCH-METER-FILTER.                                         
                                                                        
           EXEC SQL                                                     
              FETCH METER_FILTER                                        
               INTO :LX-COMPANY-NO,
                :LX-CODE-UTIL-TYPE,
                :LX-CODE-ATT-TYPE,
                :LX-DEVICE-NO,
                :LX-MTR-STORAGE-FAC-CD :WS-NULL-INDICATOR,
                :LX-CODE-MAKE,
                :LX-DATE-LAST-TESTED :WS-NULL-INDICATOR-1,
                :LX-EQUIP-ATTACH-DT :WS-NULL-INDICATOR-2,
                :LX-VERSION-CD,
                :LX-EQUIP-LOC-ID,
                :LX-IN-TRANSIT-EMP-ID,
                :W9-MTR-STORAGE-FAC-TX,
                :UV-CODE-SHORT-DESC :WS-NULL-INDICATOR-3,
                :N5-MTR-ATT-TYPE-DESC :WS-NULL-INDICATOR-4,
                :M2-EQUIP-MAKE-DESC,
                :M6-EQUIP-LOC-DESC,
                :MA-METER-NO :WS-NULL-INDICATOR-5                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH METER_FILTER                                                
MFA-TR*        INTO :LX-COMPANY-NO                                              
MFA-TR*            ,:LX-CODE-UTIL-TYPE                                          
MFA-TR*            ,:LX-CODE-ATT-TYPE                                           
MFA-TR*            ,:LX-DEVICE-NO                                               
MFA-TR*            ,:LX-MTR-STORAGE-FAC-CD :WS-NULL-INDICATOR                   
MFA-TR*            ,:LX-CODE-MAKE                                               
MFA-TR*            ,:LX-DATE-LAST-TESTED :WS-NULL-INDICATOR-1                   
MFA-TR*            ,:LX-EQUIP-ATTACH-DT :WS-NULL-INDICATOR-2                    
MFA-TR*            ,:LX-VERSION-CD                                              
MFA-TR*            ,:LX-EQUIP-LOC-ID                                            
MFA-TR*            ,:LX-IN-TRANSIT-EMP-ID                                       
MFA-TR*            ,:W9-MTR-STORAGE-FAC-TX                                      
MFA-TR*            ,:UV-CODE-SHORT-DESC :WS-NULL-INDICATOR-3                    
MFA-TR*            ,:N5-MTR-ATT-TYPE-DESC :WS-NULL-INDICATOR-4                  
MFA-TR*            ,:M2-EQUIP-MAKE-DESC                                         
MFA-TR*            ,:M6-EQUIP-LOC-DESC                                          
MFA-TR*            ,:MA-METER-NO :WS-NULL-INDICATOR-5                           
MFA-TR*            ,:WS-ROW-COUNT                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-INDICATOR   < ZERO                             
                  MOVE SPACES            TO LX-MTR-STORAGE-FAC-CD       
              END-IF                                                    
              IF WS-NULL-INDICATOR-1 < ZERO                             
                  MOVE SPACES            TO LX-DATE-LAST-TESTED         
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < ZERO                             
                  MOVE SPACES            TO LX-EQUIP-ATTACH-DT          
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < ZERO                             
                  MOVE SPACES            TO UV-CODE-SHORT-DESC          
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < ZERO                             
                  MOVE SPACES            TO N5-MTR-ATT-TYPE-DESC        
              END-IF                                                    
              IF WS-NULL-INDICATOR-5 < ZERO                             
                  MOVE SPACES            TO MA-METER-NO                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-CLOSE-METER-FILTER                                        *        
      ******************************************************************        
       7130-CLOSE-METER-FILTER.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE METER_FILTER                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7130'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-4             
              MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-METER-DEVICE                                         *        
      ******************************************************************        
       7200-OPEN-METER-DEVICE.                                          
                                                                        
           EXEC SQL                                                     
              OPEN METER_FILTER_DEVICE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7220-FETCH-METER-DEVICE                                        *        
      ******************************************************************        
       7220-FETCH-METER-DEVICE.                                         
                                                                        
           EXEC SQL                                                     
              FETCH METER_FILTER_DEVICE                                 
               INTO :LX-COMPANY-NO,
                :LX-CODE-UTIL-TYPE,
                :LX-CODE-ATT-TYPE,
                :LX-DEVICE-NO,
                :LX-MTR-STORAGE-FAC-CD :WS-NULL-INDICATOR,
                :LX-CODE-MAKE,
                :LX-DATE-LAST-TESTED :WS-NULL-INDICATOR-1,
                :LX-EQUIP-ATTACH-DT :WS-NULL-INDICATOR-2,
                :LX-VERSION-CD,
                :LX-EQUIP-LOC-ID,
                :LX-IN-TRANSIT-EMP-ID,
                :W9-MTR-STORAGE-FAC-TX,
                :UV-CODE-SHORT-DESC :WS-NULL-INDICATOR-3,
                :N5-MTR-ATT-TYPE-DESC :WS-NULL-INDICATOR-4,
                :M2-EQUIP-MAKE-DESC,
                :M6-EQUIP-LOC-DESC,
                :MA-METER-NO :WS-NULL-INDICATOR-5                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH METER_FILTER_DEVICE                                         
MFA-TR*        INTO :LX-COMPANY-NO                                              
MFA-TR*            ,:LX-CODE-UTIL-TYPE                                          
MFA-TR*            ,:LX-CODE-ATT-TYPE                                           
MFA-TR*            ,:LX-DEVICE-NO                                               
MFA-TR*            ,:LX-MTR-STORAGE-FAC-CD :WS-NULL-INDICATOR                   
MFA-TR*            ,:LX-CODE-MAKE                                               
MFA-TR*            ,:LX-DATE-LAST-TESTED :WS-NULL-INDICATOR-1                   
MFA-TR*            ,:LX-EQUIP-ATTACH-DT :WS-NULL-INDICATOR-2                    
MFA-TR*            ,:LX-VERSION-CD                                              
MFA-TR*            ,:LX-EQUIP-LOC-ID                                            
MFA-TR*            ,:LX-IN-TRANSIT-EMP-ID                                       
MFA-TR*            ,:W9-MTR-STORAGE-FAC-TX                                      
MFA-TR*            ,:UV-CODE-SHORT-DESC :WS-NULL-INDICATOR-3                    
MFA-TR*            ,:N5-MTR-ATT-TYPE-DESC :WS-NULL-INDICATOR-4                  
MFA-TR*            ,:M2-EQUIP-MAKE-DESC                                         
MFA-TR*            ,:M6-EQUIP-LOC-DESC                                          
MFA-TR*            ,:MA-METER-NO :WS-NULL-INDICATOR-5                           
MFA-TR*            ,:WS-ROW-COUNT                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-INDICATOR   < ZERO                             
                  MOVE SPACES            TO LX-MTR-STORAGE-FAC-CD       
              END-IF                                                    
              IF WS-NULL-INDICATOR-1 < ZERO                             
                  MOVE SPACES            TO LX-DATE-LAST-TESTED         
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < ZERO                             
                  MOVE SPACES            TO LX-EQUIP-ATTACH-DT          
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < ZERO                             
                  MOVE SPACES            TO UV-CODE-SHORT-DESC          
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < ZERO                             
                  MOVE SPACES            TO N5-MTR-ATT-TYPE-DESC        
              END-IF                                                    
              IF WS-NULL-INDICATOR-5 < ZERO                             
                  MOVE SPACES            TO MA-METER-NO                 
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7220'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EQUIP_ATTCHMTS' TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-4              
              MOVE LX-COMPANY-NO        TO HOSTVAR-ELEMENT-1            
              MOVE LX-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE LX-DEVICE-NO         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7230-CLOSE-METER-DEVICE                                        *        
      ******************************************************************        
       7230-CLOSE-METER-DEVICE.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE METER_FILTER_DEVICE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7230'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_EQUIP_ATTCHMTS'  TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-4             
              MOVE LX-COMPANY-NO         TO HOSTVAR-ELEMENT-1           
              MOVE LX-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE LX-DEVICE-NO          TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-TOT-ROW-COUNT.                                        *        
      ******************************************************************        
       7300-GET-TOT-ROW-COUNT.                                          
                                                                        
            EXEC SQL                                                    
                SELECT COUNT(1)                                         
                  INTO :WS-TOT-ROW-COUNT                                
               FROM                                                     
                    CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                 
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (M2.CODE_MAKE = LX.CODE_MAKE)                        
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_LOCATION M6 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                   
                    AND M6.COMPANY_NO = LX.COMPANY_NO                   
                    AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_MTR_STORGE_FAC W9 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD       
                    AND W9.COMPANY_NO = LX.COMPANY_NO                   
                    AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (UV.COMPANY_NO = LX.COMPANY_NO                       
                    AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'              
                    AND UV.COLUMN_NA = 'VERSION_CD'                     
                    AND UV.CODE_VALUE = LX.VERSION_CD)                  
               LEFT OUTER JOIN                                          
                    CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                   
                 ON                                                     
                   (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE               
                    AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)            
               LEFT OUTER JOIN                                          
                   CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                  
                 ON                                                     
                   (MA.COMPANY_NO = LX.COMPANY_NO                       
                    AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE           
                    AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE             
                    AND MA.DEVICE_NO = LX.DEVICE_NO )                   
              WHERE                                                     
                    LX.COMPANY_NO = :LX-COMPANY-NO                      
               AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE               
               AND LX.MTR_STORAGE_FAC_CD LIKE :LX-MTR-STORAGE-FAC-CD    
               AND LX.EQUIP_LOC_ID   LIKE :LX-EQUIP-LOC-ID              
C14744         AND LX.IN_TRANSIT_EMP_ID LIKE :LX-IN-TRANSIT-EMP-ID      
               AND LX.CODE_ATT_TYPE  LIKE :LX-CODE-ATT-TYPE             
               AND LX.CODE_MAKE      LIKE :LX-CODE-MAKE                 
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT COUNT(1)                                                 
MFA-TR*           INTO :WS-TOT-ROW-COUNT                                        
MFA-TR*        FROM                                                             
MFA-TR*             CSS_EQUIP_ATTCHMTS LX                                       
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_MAKE M2                                           
MFA-TR*          ON                                                             
MFA-TR*            (M2.CODE_MAKE = LX.CODE_MAKE)                                
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_LOCATION M6                                       
MFA-TR*          ON                                                             
MFA-TR*            (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                           
MFA-TR*             AND M6.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_STORGE_FAC W9                                       
MFA-TR*          ON                                                             
MFA-TR*            (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD               
MFA-TR*             AND W9.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_CODE_VALUE UV                                           
MFA-TR*          ON                                                             
MFA-TR*            (UV.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'                      
MFA-TR*             AND UV.COLUMN_NA = 'VERSION_CD'                             
MFA-TR*             AND UV.CODE_VALUE = LX.VERSION_CD)                          
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_ATT_TYPE N5                                         
MFA-TR*          ON                                                             
MFA-TR*            (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                       
MFA-TR*             AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)                    
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*            CSS_METER_ATTCHMTS MA                                        
MFA-TR*          ON                                                             
MFA-TR*            (MA.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                   
MFA-TR*             AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE                     
MFA-TR*             AND MA.DEVICE_NO = LX.DEVICE_NO )                           
MFA-TR*       WHERE                                                             
MFA-TR*             LX.COMPANY_NO = :LX-COMPANY-NO                              
MFA-TR*        AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                       
MFA-TR*        AND LX.MTR_STORAGE_FAC_CD LIKE :LX-MTR-STORAGE-FAC-CD            
MFA-TR*        AND LX.EQUIP_LOC_ID   LIKE :LX-EQUIP-LOC-ID                      
MFA-TR*        AND LX.IN_TRANSIT_EMP_ID LIKE :LX-IN-TRANSIT-EMP-ID              
MFA-TR*        AND LX.CODE_ATT_TYPE  LIKE :LX-CODE-ATT-TYPE                     
MFA-TR*        AND LX.CODE_MAKE      LIKE :LX-CODE-MAKE                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-GET-DEVICE-TOT-ROW-COUNT.                                 *        
      ******************************************************************        
       7400-GET-DEVICE-TOT-ROW-COUNT.                                   
                                                                        
            EXEC SQL                                                    
                SELECT COUNT(1)                                         
                  INTO :WS-TOT-ROW-COUNT                                
               FROM                                                     
                    CSS_EQUIP_ATTCHMTS LX WITH(READUNCOMMITTED)                 
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (M2.CODE_MAKE = LX.CODE_MAKE)                        
               LEFT OUTER JOIN                                          
                    CSS_EQUIP_LOCATION M6 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                   
                    AND M6.COMPANY_NO = LX.COMPANY_NO                   
                    AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_MTR_STORGE_FAC W9 WITH(READUNCOMMITTED)                 
                 ON                                                     
                   (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD       
                    AND W9.COMPANY_NO = LX.COMPANY_NO                   
                    AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)          
               LEFT OUTER JOIN                                          
                    CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                     
                 ON                                                     
                   (UV.COMPANY_NO = LX.COMPANY_NO                       
                    AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'              
                    AND UV.COLUMN_NA = 'VERSION_CD'                     
                    AND UV.CODE_VALUE = LX.VERSION_CD)                  
               LEFT OUTER JOIN                                          
                    CSS_MTR_ATT_TYPE N5 WITH(READUNCOMMITTED)                   
                 ON                                                     
                   (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE               
                    AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)            
               LEFT OUTER JOIN                                          
                   CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                  
                 ON                                                     
                   (MA.COMPANY_NO = LX.COMPANY_NO                       
                    AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE           
                    AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE             
                    AND MA.DEVICE_NO = LX.DEVICE_NO )                   
              WHERE                                                     
                    LX.COMPANY_NO = :LX-COMPANY-NO                      
                AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE              
                AND LX.DEVICE_NO      = :WS-DEVICE-NO                   
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT COUNT(1)                                                 
MFA-TR*           INTO :WS-TOT-ROW-COUNT                                        
MFA-TR*        FROM                                                             
MFA-TR*             CSS_EQUIP_ATTCHMTS LX                                       
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_MAKE M2                                           
MFA-TR*          ON                                                             
MFA-TR*            (M2.CODE_MAKE = LX.CODE_MAKE)                                
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_EQUIP_LOCATION M6                                       
MFA-TR*          ON                                                             
MFA-TR*            (M6.EQUIP_LOC_ID = LX.EQUIP_LOC_ID                           
MFA-TR*             AND M6.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND M6.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_STORGE_FAC W9                                       
MFA-TR*          ON                                                             
MFA-TR*            (W9.MTR_STORAGE_FAC_CD = LX.MTR_STORAGE_FAC_CD               
MFA-TR*             AND W9.COMPANY_NO = LX.COMPANY_NO                           
MFA-TR*             AND W9.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE)                  
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_CODE_VALUE UV                                           
MFA-TR*          ON                                                             
MFA-TR*            (UV.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND UV.TABLE_NA = 'CSS_EQUIP_ATTCHMTS'                      
MFA-TR*             AND UV.COLUMN_NA = 'VERSION_CD'                             
MFA-TR*             AND UV.CODE_VALUE = LX.VERSION_CD)                          
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*             CSS_MTR_ATT_TYPE N5                                         
MFA-TR*          ON                                                             
MFA-TR*            (N5.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                       
MFA-TR*             AND N5.CODE_ATT_TYPE = LX.CODE_ATT_TYPE)                    
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*            CSS_METER_ATTCHMTS MA                                        
MFA-TR*          ON                                                             
MFA-TR*            (MA.COMPANY_NO = LX.COMPANY_NO                               
MFA-TR*             AND MA.CODE_UTIL_TYPE = LX.CODE_UTIL_TYPE                   
MFA-TR*             AND MA.CODE_ATT_TYPE = LX.CODE_ATT_TYPE                     
MFA-TR*             AND MA.DEVICE_NO = LX.DEVICE_NO )                           
MFA-TR*       WHERE                                                             
MFA-TR*             LX.COMPANY_NO = :LX-COMPANY-NO                              
MFA-TR*         AND LX.CODE_UTIL_TYPE = :LX-CODE-UTIL-TYPE                      
MFA-TR*         AND LX.DEVICE_NO      = :WS-DEVICE-NO                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_METER_ATTCHMTS'  TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-DELETE-GTT-ROWS.                                          *        
      ******************************************************************        
       8000-DELETE-GTT-ROWS.                                            
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
               DELETE FROM #CSR04183_R1                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DELETE FROM SESSION.CSR04183_R1                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04183_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO #CSR04183_R1                           
              (                                                         
                  RETURN_CODE                                           
                 ,REC_COUNT                                             
                 ,COMPANY_NO                                            
                 ,CODE_UTIL_TYPE                                        
                 ,CODE_ATT_TYPE                                         
                 ,DEVICE_NO                                             
                 ,MTR_STORAGE_FAC_CD                                    
                 ,CODE_MAKE                                             
                 ,DATE_LAST_TESTED                                      
                 ,EQUIP_ATTACH_DT                                       
                 ,VERSION_CD                                            
                 ,EQUIP_LOC_ID                                          
C14744           ,IN_TRANSIT_EMP_ID                                     
                 ,MTR_STORGE_FAC_TX                                     
                 ,VERSION_CD_DISP                                       
                 ,MTR_ATT_TYPE_DESC                                     
                 ,EQUIP_MAKE_DESC                                       
                 ,EQUIP_LOC_DESC                                        
                 ,METER_NO                                              
                 ,ROW_NUM                                               
              )                                                         
              VALUES                                                    
              (                                                         
                  :S-RETURN-CODE                                        
                 ,:S-REC-COUNT                                          
                 ,:S-COMPANY-NO                                         
                 ,:S-CODE-UTIL-TYPE                                     
                 ,:S-CODE-ATT-TYPE                                      
                 ,:S-DEVICE-NO                                          
                 ,:S-MTR-STORAGE-FAC-CD                                 
                 ,:S-CODE-MAKE                                          
                 ,:S-DATE-LAST-TESTED                                   
                 ,:S-EQUIP-ATTACH-DT                                    
                 ,:S-VERSION-CD                                         
                 ,:S-EQUIP-LOC-ID                                       
C14744           ,:S-IN-TRANSIT-EMP-ID                                  
                 ,:S-MTR-STORGE-FAC-TX                                  
                 ,:S-VERSION-CD-DISP                                    
                 ,:S-MTR-ATT-TYPE-DESC                                  
                 ,:S-EQUIP-MAKE-DESC                                    
                 ,:S-EQUIP-LOC-DESC                                     
                 ,:S-METER-NO                                           
                 ,:S-ROW-NUM                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04183_R1                                   
MFA-TR*       (                                                                 
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,REC_COUNT                                                     
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,CODE_ATT_TYPE                                                 
MFA-TR*          ,DEVICE_NO                                                     
MFA-TR*          ,MTR_STORAGE_FAC_CD                                            
MFA-TR*          ,CODE_MAKE                                                     
MFA-TR*          ,DATE_LAST_TESTED                                              
MFA-TR*          ,EQUIP_ATTACH_DT                                               
MFA-TR*          ,VERSION_CD                                                    
MFA-TR*          ,EQUIP_LOC_ID                                                  
MFA-TR*          ,IN_TRANSIT_EMP_ID                                             
MFA-TR*          ,MTR_STORGE_FAC_TX                                             
MFA-TR*          ,VERSION_CD_DISP                                               
MFA-TR*          ,MTR_ATT_TYPE_DESC                                             
MFA-TR*          ,EQUIP_MAKE_DESC                                               
MFA-TR*          ,EQUIP_LOC_DESC                                                
MFA-TR*          ,METER_NO                                                      
MFA-TR*          ,ROW_NUM                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*           :S-RETURN-CODE                                                
MFA-TR*          ,:S-REC-COUNT                                                  
MFA-TR*          ,:S-COMPANY-NO                                                 
MFA-TR*          ,:S-CODE-UTIL-TYPE                                             
MFA-TR*          ,:S-CODE-ATT-TYPE                                              
MFA-TR*          ,:S-DEVICE-NO                                                  
MFA-TR*          ,:S-MTR-STORAGE-FAC-CD                                         
MFA-TR*          ,:S-CODE-MAKE                                                  
MFA-TR*          ,:S-DATE-LAST-TESTED                                           
MFA-TR*          ,:S-EQUIP-ATTACH-DT                                            
MFA-TR*          ,:S-VERSION-CD                                                 
MFA-TR*          ,:S-EQUIP-LOC-ID                                               
MFA-TR*          ,:S-IN-TRANSIT-EMP-ID                                          
MFA-TR*          ,:S-MTR-STORGE-FAC-TX                                          
MFA-TR*          ,:S-VERSION-CD-DISP                                            
MFA-TR*          ,:S-MTR-ATT-TYPE-DESC                                          
MFA-TR*          ,:S-EQUIP-MAKE-DESC                                            
MFA-TR*          ,:S-EQUIP-LOC-DESC                                             
MFA-TR*          ,:S-METER-NO                                                   
MFA-TR*          ,:S-ROW-NUM                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04183_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- ERROR HANDLING INCLUDE                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9000-/9999- ERROR HANDLING INCLUDE                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
