       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04174.                                         
COB303 DATE-WRITTEN.  DEC 18 2008.                                      
       DATE-COMPILED.                                                   
      *                                                                 00000500
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      ******************************************************************00001000
      *                 P R O G R A M  S U M M A R Y                   *00001100
      *                                                                *00001200
      * SELECT SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC AND    *00001300
      * GAS INQUIRY PAGE. DISPLAYS ATTACHMENT INFO.                    *00001400
      *                                                                *00001500
      ******************************************************************00001600
      *                                                                *00001700
      *                     PROGRAM MODIFICATION LOG                   *00001800
      *                                                                *00001900
      *    DATE    INITIALS   COMMENTS                                 *00002000
      *  --------  --------   ---------------------------------------  *00002100
      *  12/18/08  COVANSYS   INITIAL VERSION.                         *00002200
      *            CHENNAI                                             *00002300
      ******************************************************************00002400
      ******************************************************************00002500
      *                                                                *00002600
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00002700
      *                                                                *00002800
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00002900
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00003000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00003100
      *  3000 - 4999  NOT USED                                         *00003200
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00003300
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00003400
      *  7000 - 7999  INPUT MODULES                                    *00003500
      *  8000 - 8999  OUTPUT MODULES                                   *00003600
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00003700
      *                                                                *00003800
      ******************************************************************00003900
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04174'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04174 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00004900
      *    WORK AREAS                                                  *00005000
      ******************************************************************00005100
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04174'.      
           05  WS-ATCH1-CURS2-FLAG     PIC X(01) VALUE 'N'.             
           05  WS-NULL-IND1            PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-LAST-TESTED-IND PIC S9(4) COMP VALUE 0.          
           05  WS-EQUIP-MAKE-DESC-IND  PIC S9(4) COMP VALUE 0.          
                                                                        
      *************************THIS IS THE ROW RETURN AREA**************00007000
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  RS-CODE-UTIL-TYPE       PIC X(01)  VALUE SPACE.          
           05  RS-METER-NO             PIC X(09)  VALUE SPACES.         
           05  RS-CODE-DEVICE-TYPE     PIC X(01)  VALUE SPACE.          
           05  RS-DEVICE-NO            PIC X(12)  VALUE SPACES.         
           05  RS-CODE-ATT-TYPE        PIC X(02)  VALUE SPACES.         
           05  RS-RTO-UPPER-FRACTION   PIC S9(5)V9(1) USAGE COMP-3      
                                                  VALUE 0.              
           05  RS-RTO-LOWER-FRACTION   PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-COMPANY-NO           PIC X(02)  VALUE SPACES.         
           05  RS-CODE-MAKE            PIC X(02)  VALUE SPACES.         
           05  RS-DATE-LAST-TESTED     PIC X(10)  VALUE SPACES.         
           05  RS-TEST-SCHED-CD        PIC X(01)  VALUE SPACE.          
           05  RS-LOCAL-OFFICE         PIC X(03)  VALUE SPACES.         
           05  RS-SERIAL-NO            PIC X(11)  VALUE SPACES.         
           05  RS-CODE-CRNT-LOC        PIC X(01)  VALUE SPACE.          
           05  RS-EQUIP-MAKE-DESC      PIC X(16)  VALUE SPACES.         
           05  RS-HOW-ATTACHED-CD      PIC X(01)  VALUE SPACE.          
           05  RS-HOW-ATTACHED-CD-DISP PIC X(15)  VALUE SPACES.         
           05  RS-EQUIP-ATTACH-FLAG    PIC X(01)  VALUE SPACE.          
      *                                                                 00009300
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) USAGE COMP VALUE 0.   
           05  S-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACE.          
           05  S-METER-NO              PIC X(09)  VALUE SPACES.         
           05  S-CODE-DEVICE-TYPE      PIC X(01)  VALUE SPACE.          
           05  S-DEVICE-NO             PIC X(12)  VALUE SPACES.         
           05  S-CODE-ATT-TYPE         PIC X(02)  VALUE SPACES.         
COB305     05 S-RTO-UPPER-FRACTION        PIC S9(5)V9(1) USAGE COMP-3 
COB305       VALUE 0.      
           05  S-RTO-LOWER-FRACTION   PIC S9(4) USAGE COMP.             
           05  S-COMPANY-NO            PIC X(02)  VALUE SPACES.         
           05  S-CODE-MAKE             PIC X(02)  VALUE SPACES.         
           05  S-DATE-LAST-TESTED      PIC X(10)  VALUE SPACES.         
           05  S-TEST-SCHED-CD         PIC X(01)  VALUE SPACE.          
           05  S-LOCAL-OFFICE          PIC X(03)  VALUE SPACES.         
           05  S-SERIAL-NO             PIC X(11)  VALUE SPACES.         
           05  S-CODE-CRNT-LOC         PIC X(01)  VALUE SPACE.          
           05  S-EQUIP-MAKE-DESC       PIC X(16)  VALUE SPACES.         
           05  S-HOW-ATTACHED-CD       PIC X(01)  VALUE SPACE.          
           05  S-HOW-ATTACHED-CD-DISP  PIC X(15)  VALUE SPACES.         
           05  S-EQUIP-ATTACH-FLAG     PIC X(01)  VALUE SPACE.          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
                                                                        
      ******************************************************************00012200
      * DB2 INCLUDES                                                   *00012300
      ******************************************************************00012400
           EXEC SQL                                                     00012500
              INCLUDE SQLCA                                             00012600
           END-EXEC.                                                    00012700
                                                                        
      ******************************************************************00012900
      * CSS_EQUIPMENT  - EQ                                            *00013000
      ******************************************************************00013100
           EXEC SQL                                                     00013200
              INCLUDE TBEQUIP                                           00013300
           END-EXEC.                                                    00013400
                                                                        
      ******************************************************************00013600
      * CSS_CODE_VALUE - UV                                            *00013700
      ******************************************************************00013800
           EXEC SQL                                                     00013900
              INCLUDE TBCDVALU                                          00014000
           END-EXEC.                                                    00014100
                                                                        
      ******************************************************************00014300
      * CSS_EQUIP_MAKE - M2                                            *00014400
      ******************************************************************00014500
           EXEC SQL                                                     00014600
              INCLUDE TBEQMAKE                                          00014700
           END-EXEC.                                                    00014800
                                                                        
      ******************************************************************00015000
      * CSS_METER_ATTCHMTS - MA                                        *00015100
      ******************************************************************00015200
           EXEC SQL                                                     00015300
              INCLUDE TBMTRATT                                          00015400
           END-EXEC.                                                    00015500
                                                                        
      ******************************************************************00015700
      * CSS_INSTR_XFORMER - IX                                        * 00015800
      ******************************************************************00015900
           EXEC SQL                                                     00016000
              INCLUDE TBINXFOR                                          00016100
           END-EXEC.                                                    00016200
      *                                                                 00016300
      ******************************************************************00016400
      *    COBOL WORKING STORAGE COPY BOOKS                            *00016500
      ******************************************************************00016600
           COPY CWS00303.                                               00016700
                                                                        
           EXEC SQL                                                     00016900
              INCLUDE CWSX0010                                          00017000
           END-EXEC.                                                    00017100
                                                                        
      ******************************************************************00017300
      *    CURSOR DECLARATIONS  - MAIN CURSOR                          *00017400
      *    DEVICE_NO OF CSS_EQUIPMENT IS MAPPED TO  METER_NO  OF       *00017500
      *    CSS_METER_ATTCHMTS                                          *00017600
      ******************************************************************00017700
           EXEC SQL                                                     
              DECLARE ATCH_CURSOR1 CURSOR FOR                           
              SELECT MA.CODE_UTIL_TYPE                                  
                    ,MA.METER_NO                                        
                    ,MA.CODE_DEVICE_TYPE                                
                    ,MA.DEVICE_NO                                       
                    ,MA.CODE_ATT_TYPE                                   
                    ,MA.COMPANY_NO                                      
                    ,MA.CODE_MAKE                                       
                    ,MA.DATE_LAST_TESTED                                
                    ,MA.TEST_SCHED_CD                                   
                    ,EQ.LOCAL_OFFICE                                    
                    ,EQ.SERIAL_NO                                       
                    ,EQ.CODE_CRNT_LOC                                   
                    ,M2.EQUIP_MAKE_DESC                                 
                    ,MA.HOW_ATTACHED_CD                                 
                    ,UV.CODE_SHORT_DESC                                 
              FROM  CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)                 
              INNER JOIN CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                 
                  ON MA.METER_NO       = EQ.DEVICE_NO                   
                 AND MA.COMPANY_NO     = EQ.COMPANY_NO                  
                 AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              
              LEFT OUTER JOIN CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)           
                  ON M2.CODE_MAKE = EQ.CODE_MAKE                        
              LEFT OUTER JOIN CSS_CODE_VALUE UV WITH(READUNCOMMITTED)           
                  ON (UV.COMPANY_NO   = MA.COMPANY_NO                   
                  AND UV.TABLE_NA     = 'CSS_METER_ATTCHMTS'            
                  AND UV.COLUMN_NA    = 'HOW_ATTACHED_CD'               
                  AND UV.CODE_VALUE   = MA.HOW_ATTACHED_CD)             
              WHERE MA.METER_NO       = :MA-METER-NO                    
                AND MA.COMPANY_NO     = :MA-COMPANY-NO                  
                AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE              
              ORDER BY MA.CODE_ATT_TYPE                                 
                      ,MA.DEVICE_NO                                     
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00017800
MFA-TR*       DECLARE ATCH_CURSOR1 CURSOR FOR                           00017900
MFA-TR*       SELECT MA.CODE_UTIL_TYPE                                  00018000
MFA-TR*             ,MA.METER_NO                                        00018100
MFA-TR*             ,MA.CODE_DEVICE_TYPE                                00018200
MFA-TR*             ,MA.DEVICE_NO                                       00018300
MFA-TR*             ,MA.CODE_ATT_TYPE                                   00018400
MFA-TR*             ,MA.COMPANY_NO                                      00018500
MFA-TR*             ,MA.CODE_MAKE                                       00018600
MFA-TR*             ,MA.DATE_LAST_TESTED                                00018700
MFA-TR*             ,MA.TEST_SCHED_CD                                   00018800
MFA-TR*             ,EQ.LOCAL_OFFICE                                    00018900
MFA-TR*             ,EQ.SERIAL_NO                                       00019000
MFA-TR*             ,EQ.CODE_CRNT_LOC                                   00019100
MFA-TR*             ,M2.EQUIP_MAKE_DESC                                 00019200
MFA-TR*             ,MA.HOW_ATTACHED_CD                                 00019300
MFA-TR*             ,UV.CODE_SHORT_DESC                                 00019400
MFA-TR*       FROM  CSS_METER_ATTCHMTS MA                               00019500
MFA-TR*       INNER JOIN CSS_EQUIPMENT EQ                               00019600
MFA-TR*           ON MA.METER_NO       = EQ.DEVICE_NO                   00019700
MFA-TR*          AND MA.COMPANY_NO     = EQ.COMPANY_NO                  00019800
MFA-TR*          AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE              00019900
MFA-TR*       LEFT OUTER JOIN CSS_EQUIP_MAKE M2                         00020000
MFA-TR*           ON M2.CODE_MAKE = EQ.CODE_MAKE                        00020100
MFA-TR*       LEFT OUTER JOIN CSS_CODE_VALUE UV                         00020200
MFA-TR*           ON (UV.COMPANY_NO   = MA.COMPANY_NO                   00020300
MFA-TR*           AND UV.TABLE_NA     = 'CSS_METER_ATTCHMTS'            00020400
MFA-TR*           AND UV.COLUMN_NA    = 'HOW_ATTACHED_CD'               00020500
MFA-TR*           AND UV.CODE_VALUE   = MA.HOW_ATTACHED_CD)             00020600
MFA-TR*       WHERE MA.METER_NO       = :MA-METER-NO                    00020700
MFA-TR*         AND MA.COMPANY_NO     = :MA-COMPANY-NO                  00020800
MFA-TR*         AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE              00020900
MFA-TR*       ORDER BY MA.CODE_ATT_TYPE                                 00021000
MFA-TR*               ,MA.DEVICE_NO                                     00021100
MFA-TR*       FOR FETCH ONLY WITH UR                                    00021200
MFA-TR*    END-EXEC.                                                    00021300
                                                                        
      ******************************************************************00021500
      *    CURSOR DECLARATIONS - CURSOR FETCHED WHEN                   *00021600
      *    ATCH_CURSOR1 RETURNS SQLCODE 100*                           *00021700
      ******************************************************************00021800
           EXEC SQL                                                     
              DECLARE  ATCH_CURSOR2   CURSOR FOR                        
                 SELECT MA.CODE_UTIL_TYPE                               
                       ,MA.METER_NO                                     
                       ,MA.CODE_DEVICE_TYPE                             
                       ,MA.DEVICE_NO                                    
                       ,MA.CODE_ATT_TYPE                                
                       ,MA.COMPANY_NO                                   
                       ,MA.CODE_MAKE                                    
                       ,MA.DATE_LAST_TESTED                             
                       ,MA.HOW_ATTACHED_CD                              
                       ,EQ.CODE_CRNT_LOC                                
                 FROM CSS_METER_ATTCHMTS MA WITH(READUNCOMMITTED)               
                     ,CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                    
                 WHERE MA.DEVICE_NO      = EQ.DEVICE_NO                 
                   AND MA.COMPANY_NO     = EQ.COMPANY_NO                
                   AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE            
                   AND MA.DEVICE_NO      = :MA-METER-NO                 
                   AND MA.COMPANY_NO     = :MA-COMPANY-NO               
                   AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           
                   AND EQ.CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC            
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00021900
MFA-TR*       DECLARE  ATCH_CURSOR2   CURSOR FOR                        00022000
MFA-TR*          SELECT MA.CODE_UTIL_TYPE                               00022100
MFA-TR*                ,MA.METER_NO                                     00022200
MFA-TR*                ,MA.CODE_DEVICE_TYPE                             00022300
MFA-TR*                ,MA.DEVICE_NO                                    00022400
MFA-TR*                ,MA.CODE_ATT_TYPE                                00022500
MFA-TR*                ,MA.COMPANY_NO                                   00022600
MFA-TR*                ,MA.CODE_MAKE                                    00022700
MFA-TR*                ,MA.DATE_LAST_TESTED                             00022800
MFA-TR*                ,MA.HOW_ATTACHED_CD                              00022900
MFA-TR*                ,EQ.CODE_CRNT_LOC                                00023000
MFA-TR*          FROM CSS_METER_ATTCHMTS MA                             00023100
MFA-TR*              ,CSS_EQUIPMENT EQ                                  00023200
MFA-TR*          WHERE MA.DEVICE_NO      = EQ.DEVICE_NO                 00023300
MFA-TR*            AND MA.COMPANY_NO     = EQ.COMPANY_NO                00023400
MFA-TR*            AND MA.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE            00023500
MFA-TR*            AND MA.DEVICE_NO      = :MA-METER-NO                 00023600
MFA-TR*            AND MA.COMPANY_NO     = :MA-COMPANY-NO               00023700
MFA-TR*            AND MA.CODE_UTIL_TYPE = :MA-CODE-UTIL-TYPE           00023800
MFA-TR*            AND EQ.CODE_CRNT_LOC  = :EQ-CODE-CRNT-LOC            00023900
MFA-TR*          FOR FETCH ONLY WITH UR                                 00024000
MFA-TR*    END-EXEC.                                                    00024100
                                                                        
                                                                        
      ******************************************************************00024400
      *    CURSOR DECLARATIONS                                         *00024500
      *    FOR FINAL RETURN FOR ATCH_CURSOR1                           *00024600
      ******************************************************************00024700
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                  RETURN_CODE                                           
                 ,CODE_UTIL_TYPE                                        
                 ,METER_NO                                              
                 ,CODE_DEVICE_TYPE                                      
                 ,DEVICE_NO                                             
                 ,CODE_ATT_TYPE                                         
                 ,RTO_UPPER_FRACTION                                    
                 ,RTO_LOWER_FRACTION                                    
                 ,COMPANY_NO                                            
                 ,CODE_MAKE                                             
                 ,DATE_LAST_TESTED                                      
                 ,TEST_SCHED_CD                                         
                 ,LOCAL_OFFICE                                          
                 ,SERIAL_NO                                             
                 ,CODE_CRNT_LOC                                         
                 ,EQUIP_MAKE_DESC                                       
                 ,HOW_ATTACHED_CD                                       
                 ,HOW_ATTACHED_CD_DISP                                  
                 ,EQUIP_ATTACH_FLAG                                     
              FROM #CSR04174_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00024800
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR 00024900
MFA-TR*       SELECT                                                    00025000
MFA-TR*           RETURN_CODE                                           00025100
MFA-TR*          ,CODE_UTIL_TYPE                                        00025200
MFA-TR*          ,METER_NO                                              00025300
MFA-TR*          ,CODE_DEVICE_TYPE                                      00025400
MFA-TR*          ,DEVICE_NO                                             00025500
MFA-TR*          ,CODE_ATT_TYPE                                         00025600
MFA-TR*          ,RTO_UPPER_FRACTION                                    00025700
MFA-TR*          ,RTO_LOWER_FRACTION                                    00025800
MFA-TR*          ,COMPANY_NO                                            00025900
MFA-TR*          ,CODE_MAKE                                             00026000
MFA-TR*          ,DATE_LAST_TESTED                                      00026100
MFA-TR*          ,TEST_SCHED_CD                                         00026200
MFA-TR*          ,LOCAL_OFFICE                                          00026300
MFA-TR*          ,SERIAL_NO                                             00026400
MFA-TR*          ,CODE_CRNT_LOC                                         00026500
MFA-TR*          ,EQUIP_MAKE_DESC                                       00026600
MFA-TR*          ,HOW_ATTACHED_CD                                       00026700
MFA-TR*          ,HOW_ATTACHED_CD_DISP                                  00026800
MFA-TR*          ,EQUIP_ATTACH_FLAG                                     00026900
MFA-TR*       FROM SESSION.CSR04174_R1                                  00027000
MFA-TR*    END-EXEC.                                                    00027100
      *                                                                 00027200
      ******************************************************************00027300
      *    CURSOR DECLARATIONS                                         *00027400
      *    FOR FINAL RETURN FOR ATCH_CURSOR2                           *00027500
      ******************************************************************00027600
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                  RETURN_CODE                                           
                 ,CODE_UTIL_TYPE                                        
                 ,METER_NO                                              
                 ,CODE_DEVICE_TYPE                                      
                 ,DEVICE_NO                                             
                 ,CODE_ATT_TYPE                                         
                 ,RTO_UPPER_FRACTION                                    
                 ,RTO_LOWER_FRACTION                                    
                 ,COMPANY_NO                                            
                 ,CODE_MAKE                                             
                 ,DATE_LAST_TESTED                                      
                 ,HOW_ATTACHED_CD                                       
                 ,CODE_CRNT_LOC                                         
                 ,EQUIP_ATTACH_FLAG                                     
              FROM #CSR04174_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00027700
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR 00027800
MFA-TR*       SELECT                                                    00027900
MFA-TR*           RETURN_CODE                                           00028000
MFA-TR*          ,CODE_UTIL_TYPE                                        00028100
MFA-TR*          ,METER_NO                                              00028200
MFA-TR*          ,CODE_DEVICE_TYPE                                      00028300
MFA-TR*          ,DEVICE_NO                                             00028400
MFA-TR*          ,CODE_ATT_TYPE                                         00028500
MFA-TR*          ,RTO_UPPER_FRACTION                                    00028600
MFA-TR*          ,RTO_LOWER_FRACTION                                    00028700
MFA-TR*          ,COMPANY_NO                                            00028800
MFA-TR*          ,CODE_MAKE                                             00028900
MFA-TR*          ,DATE_LAST_TESTED                                      00029000
MFA-TR*          ,HOW_ATTACHED_CD                                       00029100
MFA-TR*          ,CODE_CRNT_LOC                                         00029200
MFA-TR*          ,EQUIP_ATTACH_FLAG                                     00029300
MFA-TR*       FROM SESSION.CSR04174_R1                                  00029400
MFA-TR*    END-EXEC.                                                    00029500
      *                                                                 00029600
HPCCDM*EJECT                                                            00029700
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                 00030000
       01 PARM-METER-NO         PIC X(09).                              
       01 PARM-COMPANY-NO       PIC X(02).                              
       01 PARM-CODE-UTIL-TYPE   PIC X(01).                              
       01 PARM-CODE-CRNT-LOC    PIC X(01).                              
      *                                                                 00030500
       PROCEDURE DIVISION USING PARM-METER-NO                           
                                PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-CODE-CRNT-LOC.                     
      *                                                                 00031000
      ******************************************************************00031100
      * 0000-MAINLINE                                                  *00031200
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00031300
      ******************************************************************00031400
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00032400
      ******************************************************************00032500
      * 0100-INITIALIZE                                                *00032600
      *                                                                *00032700
      ******************************************************************00032800
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           INITIALIZE TDS-RETURN-FIELDS.                                
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00033900
      ******************************************************************00034000
      * 0100A-DECLARE-GTT                                              *00034100
      ******************************************************************00034200
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04174_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04174_R1
              (                                                         
                RETURN_CODE             INT                         
               ,CODE_UTIL_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
               ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2               
               ,CODE_DEVICE_TYPE CHAR(1)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                         
               ,DEVICE_NO CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,CODE_ATT_TYPE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2          
               ,RTO_UPPER_FRACTION      DECIMAL(6,1)                   
               ,RTO_LOWER_FRACTION      SMALLINT                        
               ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,CODE_MAKE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2              
               ,DATE_LAST_TESTED CHAR(10)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,TEST_SCHED_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
               ,LOCAL_OFFICE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2           
               ,SERIAL_NO CHAR(11)  COLLATE LATIN1_GENERAL_100_BIN2             
               ,CODE_CRNT_LOC CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
               ,EQUIP_MAKE_DESC CHAR(16)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                        
               ,HOW_ATTACHED_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
               ,HOW_ATTACHED_CD_DISP VARCHAR(15)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                     
               ,EQUIP_ATTACH_FLAG CHAR(1)  COLLATE 
                             LATIN1_GENERAL_100_BIN2                         
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04174_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************00039500
      * 1000-PROCESS-INPUT                                             *00039600
      *                                                                *00039700
      ******************************************************************00039800
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-METER-NO           TO MA-METER-NO.                 
           MOVE PARM-COMPANY-NO         TO MA-COMPANY-NO                
                                           IX-COMPANY-NO.               
           MOVE PARM-CODE-UTIL-TYPE     TO MA-CODE-UTIL-TYPE.           
           MOVE PARM-CODE-CRNT-LOC      TO EQ-CODE-CRNT-LOC.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00041100
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *00041200
      ******************************************************************00041300
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
           IF PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-COMPANY-NO     = SPACES OR                           
              PARM-METER-NO       = SPACES                              
                                                                        
              MOVE 9998                   TO WS-ACTIVE-RETURN-CODE      
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '1200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'VALIDATE'             TO ABEND-FUNCTION             
              MOVE 'N/A'                  TO TABLE-1                    
              MOVE 'PARM-CODE-UTIL-TYPE'  TO TABLE-ELEMENT-1            
              MOVE 'PARM-COMPANY-NO'      TO TABLE-ELEMENT-2            
              MOVE 'PARM-METER-NO'        TO TABLE-ELEMENT-3            
              MOVE 'PARM-CODE-CRNT-LOC'   TO TABLE-ELEMENT-4            
              MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1          
              MOVE PARM-COMPANY-NO        TO HOSTVAR-ELEMENT-2          
              MOVE PARM-METER-NO          TO HOSTVAR-ELEMENT-3          
              MOVE PARM-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                                                                        
                .                                                       
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00044200
      * 2000-PROCESS-OUTPUT.                                           *00044300
      *                                                                *00044400
      ******************************************************************00044500
       2000-PROCESS-OUTPUT.                                             
            MOVE  0                         TO WS-ROW-COUNT.            
                                                                        
            MOVE SPACES                     TO MA-DATE-LAST-TESTED      
                                               M2-EQUIP-MAKE-DESC       
                                               UV-CODE-SHORT-DESC.      
            PERFORM 7100-OPEN-ATCH-CURSOR1          THRU 7100-EXIT      
            PERFORM 7120-FETCH-ATCH-CURSOR1         THRU 7120-EXIT      
            PERFORM 2100-PROCESS-ATCH-CURSOR1       THRU 2100-EXIT      
                      UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
            PERFORM   7130-CLOSE-ATCH-CURSOR1       THRU 7130-EXIT      
            IF WS-ROW-COUNT = 0                                         
               MOVE  'Y'                         TO WS-ATCH1-CURS2-FLAG 
               PERFORM 7140-OPEN-ATCH-CURSOR2    THRU 7140-EXIT         
               PERFORM 7150-FETCH-ATCH-CURSOR2   THRU 7150-EXIT         
               IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                    
                  MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE      
                  PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT        
                  PERFORM 8100-SEND-RESULT       THRU 8100-EXIT         
               ELSE                                                     
                  PERFORM 2200-PROCESS-ATCH-CURSOR2 THRU 2200-EXIT      
                          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND       
               END-IF                                                   
               PERFORM  7160-CLOSE-ATCH-CURSOR2  THRU 7160-EXIT         
            END-IF.                                                     
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
              MOVE RS-RETURN-CODE          TO S-RETURN-CODE.            
              MOVE RS-CODE-UTIL-TYPE       TO S-CODE-UTIL-TYPE.         
              MOVE RS-METER-NO             TO S-METER-NO.               
              MOVE RS-CODE-DEVICE-TYPE     TO S-CODE-DEVICE-TYPE.       
              MOVE RS-DEVICE-NO            TO S-DEVICE-NO.              
              MOVE RS-CODE-ATT-TYPE        TO S-CODE-ATT-TYPE.          
              MOVE RS-RTO-UPPER-FRACTION   TO S-RTO-UPPER-FRACTION.     
              MOVE RS-RTO-LOWER-FRACTION   TO S-RTO-LOWER-FRACTION.     
              MOVE RS-COMPANY-NO           TO S-COMPANY-NO.             
              MOVE RS-CODE-MAKE            TO S-CODE-MAKE.              
              IF WS-DATE-LAST-TESTED-IND = -1                           
                 MOVE SPACES               TO S-DATE-LAST-TESTED        
              ELSE                                                      
                 MOVE RS-DATE-LAST-TESTED  TO S-DATE-LAST-TESTED        
              END-IF.                                                   
              MOVE RS-TEST-SCHED-CD        TO S-TEST-SCHED-CD.          
              MOVE RS-LOCAL-OFFICE         TO S-LOCAL-OFFICE.           
              MOVE RS-SERIAL-NO            TO S-SERIAL-NO.              
              MOVE RS-CODE-CRNT-LOC        TO S-CODE-CRNT-LOC.          
              MOVE RS-EQUIP-MAKE-DESC      TO S-EQUIP-MAKE-DESC.        
              MOVE RS-HOW-ATTACHED-CD      TO S-HOW-ATTACHED-CD.        
              MOVE RS-HOW-ATTACHED-CD-DISP TO S-HOW-ATTACHED-CD-DISP.   
              MOVE RS-EQUIP-ATTACH-FLAG    TO S-EQUIP-ATTACH-FLAG.      
      *                                                                 00050100
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************00050500
      * 2100-PROCESS-ATCH-CURSOR1                                      *00050600
      ******************************************************************00050700
       2100-PROCESS-ATCH-CURSOR1.                                       
      *                                                                 00050900
           INITIALIZE   TDS-RETURN-FIELDS.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                        TO WS-ROW-COUNT              
                                                                        
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
              MOVE MA-CODE-UTIL-TYPE       TO RS-CODE-UTIL-TYPE         
              MOVE MA-METER-NO             TO RS-METER-NO               
              MOVE MA-CODE-DEVICE-TYPE     TO RS-CODE-DEVICE-TYPE       
              MOVE MA-DEVICE-NO            TO RS-DEVICE-NO              
              MOVE MA-CODE-ATT-TYPE        TO RS-CODE-ATT-TYPE          
              MOVE MA-COMPANY-NO           TO RS-COMPANY-NO             
              MOVE MA-CODE-MAKE            TO RS-CODE-MAKE              
              MOVE MA-DATE-LAST-TESTED     TO RS-DATE-LAST-TESTED       
              MOVE MA-TEST-SCHED-CD        TO RS-TEST-SCHED-CD          
              MOVE EQ-LOCAL-OFFICE         TO RS-LOCAL-OFFICE           
              MOVE EQ-SERIAL-NO            TO RS-SERIAL-NO              
              MOVE EQ-CODE-CRNT-LOC        TO RS-CODE-CRNT-LOC          
              IF WS-EQUIP-MAKE-DESC-IND = -1                            
                 MOVE 'N/A'                TO RS-EQUIP-MAKE-DESC        
              ELSE                                                      
                 MOVE M2-EQUIP-MAKE-DESC   TO RS-EQUIP-MAKE-DESC        
              END-IF                                                    
              MOVE MA-HOW-ATTACHED-CD      TO RS-HOW-ATTACHED-CD        
              MOVE UV-CODE-SHORT-DESC-TEXT TO RS-HOW-ATTACHED-CD-DISP   
              MOVE 'Y'                     TO RS-EQUIP-ATTACH-FLAG      
                                                                        
              IF RS-CODE-ATT-TYPE = 'CT' OR 'PT'                        
                 MOVE MA-DEVICE-NO            TO IX-XFORMER-NO          
                 PERFORM 7000-SELECT-CTPT-RATIO THRU 7000-EXIT          
                 MOVE IX-RTO-UPPER-FRACTION   TO RS-RTO-UPPER-FRACTION  
                 MOVE IX-RTO-LOWER-FRACTION   TO RS-RTO-LOWER-FRACTION  
              END-IF                                                    
                                                                        
                                                                        
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
           MOVE SPACES                     TO MA-DATE-LAST-TESTED       
                                              M2-EQUIP-MAKE-DESC        
                                              UV-CODE-SHORT-DESC.       
           PERFORM 7120-FETCH-ATCH-CURSOR1     THRU 7120-EXIT.          
      *                                                                 00055000
       2100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00055300
      * 2200-PROCESS-ATCH-CURSOR2.*                                     00055400
      ******************************************************************00055500
       2200-PROCESS-ATCH-CURSOR2.                                       
      *                                                                 00055700
           INITIALIZE   TDS-RETURN-FIELDS.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                      TO WS-ROW-COUNT                
                                                                        
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE MA-CODE-UTIL-TYPE     TO RS-CODE-UTIL-TYPE           
              MOVE MA-METER-NO           TO RS-METER-NO                 
              MOVE MA-CODE-DEVICE-TYPE   TO RS-CODE-DEVICE-TYPE         
              MOVE MA-DEVICE-NO          TO RS-DEVICE-NO                
              MOVE MA-CODE-ATT-TYPE      TO RS-CODE-ATT-TYPE            
              MOVE 0                     TO RS-RTO-UPPER-FRACTION       
              MOVE 0                     TO RS-RTO-LOWER-FRACTION       
              MOVE MA-COMPANY-NO         TO RS-COMPANY-NO               
              MOVE MA-CODE-MAKE          TO RS-CODE-MAKE                
              MOVE MA-DATE-LAST-TESTED   TO RS-DATE-LAST-TESTED         
              MOVE SPACES                TO RS-TEST-SCHED-CD            
              MOVE SPACES                TO RS-LOCAL-OFFICE             
              MOVE SPACES                TO RS-SERIAL-NO                
              MOVE EQ-CODE-CRNT-LOC      TO RS-CODE-CRNT-LOC            
              MOVE SPACES                TO RS-EQUIP-MAKE-DESC          
              MOVE MA-HOW-ATTACHED-CD    TO RS-HOW-ATTACHED-CD          
              MOVE SPACES                TO RS-HOW-ATTACHED-CD-DISP     
              MOVE 'N'                   TO RS-EQUIP-ATTACH-FLAG        
                                                                        
              IF RS-CODE-ATT-TYPE= 'CT' OR 'PT'                         
                 MOVE MA-DEVICE-NO            TO IX-XFORMER-NO          
                 PERFORM 7000-SELECT-CTPT-RATIO THRU 7000-EXIT          
                 MOVE IX-RTO-UPPER-FRACTION   TO RS-RTO-UPPER-FRACTION  
                 MOVE IX-RTO-LOWER-FRACTION   TO RS-RTO-LOWER-FRACTION  
              END-IF                                                    
                                                                        
              PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
           PERFORM 7150-FETCH-ATCH-CURSOR2  THRU 7150-EXIT.             
      *                                                                 00059300
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00059600
      ******************************************************************00059700
      * 7000-SELECT-CTPT-RATIO.                                         00059800
      ******************************************************************00059900
       7000-SELECT-CTPT-RATIO.                                          
           EXEC SQL                                                     
              SELECT  IX.RTO_UPPER_FRACTION                             
                     ,IX.RTO_LOWER_FRACTION                             
                INTO  :IX-RTO-UPPER-FRACTION                            
                     ,:IX-RTO-LOWER-FRACTION                            
                FROM CSS_INSTR_XFORMER IX WITH(READUNCOMMITTED)                 
               WHERE IX.XFORMER_NO = :IX-XFORMER-NO                     
                 AND IX.CODE_UTIL_TYPE = 'X'                            
                 AND IX.COMPANY_NO = :IX-COMPANY-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00060100
MFA-TR*       SELECT  IX.RTO_UPPER_FRACTION                             00060200
MFA-TR*              ,IX.RTO_LOWER_FRACTION                             00060300
MFA-TR*         INTO  :IX-RTO-UPPER-FRACTION                            00060400
MFA-TR*              ,:IX-RTO-LOWER-FRACTION                            00060500
MFA-TR*         FROM CSS_INSTR_XFORMER IX                               00060600
MFA-TR*        WHERE IX.XFORMER_NO = :IX-XFORMER-NO                     00060700
MFA-TR*          AND IX.CODE_UTIL_TYPE = 'X'                            00060800
MFA-TR*          AND IX.COMPANY_NO = :IX-COMPANY-NO                     00060900
MFA-TR*        WITH UR                                                  00061000
MFA-TR*    END-EXEC.                                                    00061100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                     
                 MOVE  0                TO IX-RTO-UPPER-FRACTION        
                 MOVE  0                TO IX-RTO-LOWER-FRACTION        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_INSTR_XFORMER'  TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'XFORMER_NO'         TO TABLE-ELEMENT-3              
              MOVE IX-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE IX-XFORMER-NO        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00063600
      * 7100-OPEN-ATCH-CURSOR1                                         *00063700
      ******************************************************************00063800
       7100-OPEN-ATCH-CURSOR1.                                          
                                                                        
           EXEC SQL                                                     
              OPEN ATCH_CURSOR1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'CSS_EQUIP_MAKE'     TO TABLE-3                      
              MOVE 'CSS_CODE_VALUE'     TO TABLE-4                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00066900
      ******************************************************************00067000
      * 7120-FETCH-ATCH-CURSOR1                                        *00067100
      ******************************************************************00067200
       7120-FETCH-ATCH-CURSOR1.                                         
                                                                        
           EXEC SQL                                                     
              FETCH ATCH_CURSOR1                                        
               INTO :MA-CODE-UTIL-TYPE                                  
                   ,:MA-METER-NO                                        
                   ,:MA-CODE-DEVICE-TYPE                                
                   ,:MA-DEVICE-NO                                       
                   ,:MA-CODE-ATT-TYPE                                   
                   ,:MA-COMPANY-NO                                      
                   ,:MA-CODE-MAKE                                       
                   ,:MA-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND        
                   ,:MA-TEST-SCHED-CD                                   
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:M2-EQUIP-MAKE-DESC :WS-EQUIP-MAKE-DESC-IND          
                   ,:MA-HOW-ATTACHED-CD                                 
                   ,:UV-CODE-SHORT-DESC :WS-NULL-IND1                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'CSS_EQUIP_MAKE'     TO TABLE-3                      
              MOVE 'CSS_CODE_VALUE'     TO TABLE-4                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00072400
      ******************************************************************00072500
      * 7130-CLOSE-ATCH-CURSOR1                                        *00072600
      ******************************************************************00072700
       7130-CLOSE-ATCH-CURSOR1.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE ATCH_CURSOR1                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7130'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'CSS_EQUIP_MAKE'     TO TABLE-3                      
              MOVE 'CSS_CODE_VALUE'     TO TABLE-4                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00075800
      ******************************************************************00075900
      * 7140-OPEN-ATCH-CURSOR2.                                         00076000
      ******************************************************************00076100
       7140-OPEN-ATCH-CURSOR2.                                          
                                                                        
           EXEC SQL                                                     
              OPEN ATCH_CURSOR2                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7140'               TO ACTIVE-PARAGRAPH             
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00079200
      ******************************************************************00079300
      * 7150-FETCH-ATCH-CURSOR2.                                        00079400
      ******************************************************************00079500
       7150-FETCH-ATCH-CURSOR2.                                         
                                                                        
           EXEC SQL                                                     
              FETCH ATCH_CURSOR2                                        
               INTO :MA-CODE-UTIL-TYPE                                  
                   ,:MA-METER-NO                                        
                   ,:MA-CODE-DEVICE-TYPE                                
                   ,:MA-DEVICE-NO                                       
                   ,:MA-CODE-ATT-TYPE                                   
                   ,:MA-COMPANY-NO                                      
                   ,:MA-CODE-MAKE                                       
                   ,:MA-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND        
                   ,:MA-HOW-ATTACHED-CD                                 
                   ,:EQ-CODE-CRNT-LOC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR  NOT-FOUND    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7150'               TO ACTIVE-PARAGRAPH             
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00083600
      ******************************************************************00083700
      *7160-CLOSE-ATCH-CURSOR2                                         *00083800
      ******************************************************************00083900
       7160-CLOSE-ATCH-CURSOR2.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE ATCH_CURSOR2                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7160'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                      
              MOVE 'CSS_EQUIPMENT'      TO TABLE-2                      
              MOVE 'METER_NO'           TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'CODE_CRNT_LOC'      TO TABLE-ELEMENT-4              
              MOVE MA-METER-NO          TO HOSTVAR-ELEMENT-1            
              MOVE MA-COMPANY-NO        TO HOSTVAR-ELEMENT-2            
              MOVE MA-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-3            
              MOVE EQ-CODE-CRNT-LOC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00087000
      * 8000A-DELETE-GTT-ROWS.                                         *00087100
      ******************************************************************00087200
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00087400
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
               DELETE FROM #CSR04174_R1                          
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00087900
MFA-TR*        DELETE FROM SESSION.CSR04174_R1                          00088000
MFA-TR*     END-EXEC.                                                   00088100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00088400
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04174_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00090000
       8000A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************00091100
      * 8100-SEND-RESULT.                                              *00091200
      ******************************************************************00091300
       8100-SEND-RESULT.                                                
      *                                                                 00091500
           EXEC SQL                                                     
              INSERT INTO #CSR04174_R1                           
              (                                                         
                  RETURN_CODE                                           
                 ,CODE_UTIL_TYPE                                        
                 ,METER_NO                                              
                 ,CODE_DEVICE_TYPE                                      
                 ,DEVICE_NO                                             
                 ,CODE_ATT_TYPE                                         
                 ,RTO_UPPER_FRACTION                                    
                 ,RTO_LOWER_FRACTION                                    
                 ,COMPANY_NO                                            
                 ,CODE_MAKE                                             
                 ,DATE_LAST_TESTED                                      
                 ,TEST_SCHED_CD                                         
                 ,LOCAL_OFFICE                                          
                 ,SERIAL_NO                                             
                 ,CODE_CRNT_LOC                                         
                 ,EQUIP_MAKE_DESC                                       
                 ,HOW_ATTACHED_CD                                       
                 ,HOW_ATTACHED_CD_DISP                                  
                 ,EQUIP_ATTACH_FLAG                                     
               )                                                        
              VALUES                                                    
              (                                                         
                  :S-RETURN-CODE                                        
                 ,:S-CODE-UTIL-TYPE                                     
                 ,:S-METER-NO                                           
                 ,:S-CODE-DEVICE-TYPE                                   
                 ,:S-DEVICE-NO                                          
                 ,:S-CODE-ATT-TYPE                                      
                 ,:S-RTO-UPPER-FRACTION                                 
                 ,:S-RTO-LOWER-FRACTION                                 
                 ,:S-COMPANY-NO                                         
                 ,:S-CODE-MAKE                                          
                 ,:S-DATE-LAST-TESTED                                   
                 ,:S-TEST-SCHED-CD                                      
                 ,:S-LOCAL-OFFICE                                       
                 ,:S-SERIAL-NO                                          
                 ,:S-CODE-CRNT-LOC                                      
                 ,:S-EQUIP-MAKE-DESC                                    
                 ,:S-HOW-ATTACHED-CD                                    
                 ,:S-HOW-ATTACHED-CD-DISP                               
                 ,:S-EQUIP-ATTACH-FLAG                                  
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00091600
MFA-TR*       INSERT INTO SESSION.CSR04174_R1                           00091700
MFA-TR*       (                                                         00091800
MFA-TR*           RETURN_CODE                                           00091900
MFA-TR*          ,CODE_UTIL_TYPE                                        00092000
MFA-TR*          ,METER_NO                                              00092100
MFA-TR*          ,CODE_DEVICE_TYPE                                      00092200
MFA-TR*          ,DEVICE_NO                                             00092300
MFA-TR*          ,CODE_ATT_TYPE                                         00092400
MFA-TR*          ,RTO_UPPER_FRACTION                                    00092500
MFA-TR*          ,RTO_LOWER_FRACTION                                    00092600
MFA-TR*          ,COMPANY_NO                                            00092700
MFA-TR*          ,CODE_MAKE                                             00092800
MFA-TR*          ,DATE_LAST_TESTED                                      00092900
MFA-TR*          ,TEST_SCHED_CD                                         00093000
MFA-TR*          ,LOCAL_OFFICE                                          00093100
MFA-TR*          ,SERIAL_NO                                             00093200
MFA-TR*          ,CODE_CRNT_LOC                                         00093300
MFA-TR*          ,EQUIP_MAKE_DESC                                       00093400
MFA-TR*          ,HOW_ATTACHED_CD                                       00093500
MFA-TR*          ,HOW_ATTACHED_CD_DISP                                  00093600
MFA-TR*          ,EQUIP_ATTACH_FLAG                                     00093700
MFA-TR*        )                                                        00093800
MFA-TR*       VALUES                                                    00093900
MFA-TR*       (                                                         00094000
MFA-TR*           :S-RETURN-CODE                                        00094100
MFA-TR*          ,:S-CODE-UTIL-TYPE                                     00094200
MFA-TR*          ,:S-METER-NO                                           00094300
MFA-TR*          ,:S-CODE-DEVICE-TYPE                                   00094400
MFA-TR*          ,:S-DEVICE-NO                                          00094500
MFA-TR*          ,:S-CODE-ATT-TYPE                                      00094600
MFA-TR*          ,:S-RTO-UPPER-FRACTION                                 00094700
MFA-TR*          ,:S-RTO-LOWER-FRACTION                                 00094800
MFA-TR*          ,:S-COMPANY-NO                                         00094900
MFA-TR*          ,:S-CODE-MAKE                                          00095000
MFA-TR*          ,:S-DATE-LAST-TESTED                                   00095100
MFA-TR*          ,:S-TEST-SCHED-CD                                      00095200
MFA-TR*          ,:S-LOCAL-OFFICE                                       00095300
MFA-TR*          ,:S-SERIAL-NO                                          00095400
MFA-TR*          ,:S-CODE-CRNT-LOC                                      00095500
MFA-TR*          ,:S-EQUIP-MAKE-DESC                                    00095600
MFA-TR*          ,:S-HOW-ATTACHED-CD                                    00095700
MFA-TR*          ,:S-HOW-ATTACHED-CD-DISP                               00095800
MFA-TR*          ,:S-EQUIP-ATTACH-FLAG                                  00095900
MFA-TR*       )                                                         00096000
MFA-TR*    END-EXEC.                                                    00096100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04174_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************00098100
      *   8900-SEND-DONE                                               *00098200
      ******************************************************************00098300
       8900-SEND-DONE.                                                  
      *                                                                 00098500
           IF WS-ATCH1-CURS2-FLAG = 'N'                                 
              EXEC SQL                                                  
                 OPEN C1                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           ELSE                                                         
              EXEC SQL                                                  
                 OPEN C2                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
      *                                                                 00099500
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00099800
      * 9000-SEND-ERROR-RESULT                                         *00099900
      ******************************************************************00100000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 00100200
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 00100800
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00101200
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 00101800
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                 00102100
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 00090300
      ******************************************************************00090400
      * 9900- ERROR HANDLING INCLUDE                                   *00090500
      ******************************************************************00090600
           EXEC SQL                                                     00090700
              INCLUDE CPDSP300                                          00090800
           END-EXEC.                                                    00090900
      *                                                                 00091000
      ******************************************************************00102500
      *   9999-END-PROGRAM                                             *00102600
      ******************************************************************00102700
      *                                                                 00102800
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************00103200
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *00103300
      ******************************************************************00103400
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
