       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04173.                                         
COB303 DATE-WRITTEN.  NOV 17 2008                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      *                                                                *00001000
      ******************************************************************00001100
      *                 P R O G R A M  S U M M A R Y                   *00001200
      *                                                                *00001300
      * SELECT SP CALLED BY METER INVENTORY SYSTEM FOR ELECTRIC AND    *00001400
      * GAS INQUIRY PAGE WHICH RETRIEVES METER DETAILS                 *00001500
      *                                                                *00001600
      ******************************************************************00001700
      *                                                                *00001800
      *                     PROGRAM MODIFICATION LOG                   *00001900
      *                                                                *00002000
      *    DATE    INITIALS   COMMENTS                                 *00002100
      *  --------  --------   ---------------------------------------  *00002200
      *  11/17/08  MN90523    PROCEDURE ORIGINALLY CODED.              *00002300
      *                                                                *00002400
P00447*  09/13/10  SB40505    ADD CSS_ELEC_CL_SPEC FOR CONSTANT DEFAULT*00002500
P00447*                       IF CT_METER_FL = 'Y' THEN 0 ELSE 1       *00002600
A04200*  10/13/16  SS95855    #ACT002 ADD FERC_ACCOUNT_NO/CSS_EQUIPMENT*00002700
      ******************************************************************00002800
      ******************************************************************00002900
      *                                                                *00003000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00003100
      *                                                                *00003200
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003300
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00003400
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00003500
      *  3000 - 4999  NOT USED                                         *00003600
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00003700
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00003800
      *  7000 - 7999  INPUT MODULES                                    *00003900
      *  8000 - 8999  OUTPUT MODULES                                   *00004000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00004100
      *                                                                *00004200
      ******************************************************************00004300
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04173'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04173 STARTS HERE'.                  
                                                                        
      ******************************************************************00005200
      *    WORK AREAS                                                  *00005300
      ******************************************************************00005400
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 1.          
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04173'.      
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-LAST-TEST-SEL-IND    PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-LAST-TESTED-IND PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-PURCHASED-IND   PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-DISPOSED-OF-IND PIC S9(04) COMP VALUE 0.         
           05  WS-WARRANTY-EXP-DT-IND  PIC S9(04) COMP VALUE 0.         
           05  WS-INSTALL-DT-IND       PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-LAST-TRAN-IND   PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-LAST-MOVE-IND   PIC S9(04) COMP VALUE 0.         
           05  WS-MFR-DT-IND           PIC S9(04) COMP VALUE 0.         
           05  WS-DATE-OBSOLETE-IND    PIC S9(04) COMP VALUE 0.         
           05  WS-TEST-SCHED-DESC-IND  PIC S9(04) COMP VALUE 0.         
           05  WS-MTR-STOR-FAC-TX-IND  PIC S9(04) COMP VALUE 0.         
                                                                        
        01 WS-MISC.                                                     
            10 WS-DEVICE-NO           PIC X(09) VALUE SPACES.           
            10 WS-COMPANY-NO          PIC X(02) VALUE SPACES.           
            10 WS-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.           
            10 WS-PREMISE-NO          PIC S9(10)V USAGE COMP-3 VALUE 0. 
            10 WS-PREMISE-FLAG        PIC X(01) VALUE ' '.              
            10 WS-MTR-STORGE-FAC-TX   PIC X(41) VALUE SPACES.           
            10 WS-METER-SIZE-DISP     PIC X(36) VALUE SPACES.           
            10 WS-TEST-SCHED-DISP     PIC X(17) VALUE SPACES.           
            10 WS-MTR-CAP-FLAG        PIC X(01) VALUE 'N'.              
            10 WS-HYPHEN              PIC X(03) VALUE ' - '.            
      *************************THIS IS THE ROW RETURN AREA************* 00009300
                                                                        
       01  TDS-RETURN-FIELDS-R1.                                        
           05  R1-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  R1-CODE-ATTACHMENTS     PIC X(06)  VALUE SPACES.         
           05  R1-CASE-PRESSURE        PIC S9(09) USAGE COMP VALUE 0.   
           05  R1-CCF-CAP-PER-HR       PIC S9(09) USAGE COMP VALUE 0.   
           05  R1-MCF-CAP-PER-HR       PIC S9(09) USAGE COMP VALUE 0.   
           05  R1-METER-SIZE-ID        PIC X(08)  VALUE SPACES.         
           05  R1-NUMBER-OF-DRIVE      PIC S9(04) USAGE COMP VALUE 0.   
           05  R1-CODE-METER-TYPE      PIC X(01)  VALUE SPACES.         
           05  R1-MODEL-CD-GM          PIC X(01)  VALUE SPACES.         
           05  R1-CONNECTION-TYPE-CD   PIC X(02)  VALUE SPACES.         
           05  R1-ALLOW-CONSTANT-FL    PIC X(01)  VALUE SPACES.         
           05  R1-TEST-SCHED-CD        PIC X(01)  VALUE SPACES.         
           05  R1-DIGTL-MTR-TYPE       PIC X(03)  VALUE SPACES.         
           05  R1-PROGRAM-ID           PIC X(02)  VALUE SPACES.         
           05  R1-LAST-TEST-SEL-DT     PIC X(10)  VALUE SPACES.         
           05  R1-DATE-LAST-TESTED     PIC X(10)  VALUE SPACES.         
           05  R1-INSTALL-EMP-ID       PIC X(07)  VALUE SPACES.         
           05  R1-LOCAL-OFFICE         PIC X(03)  VALUE SPACES.         
           05  R1-EQUIP-TYPE-CD        PIC X(01)  VALUE SPACES.         
           05  R1-PALETTE-NO           PIC X(04)  VALUE SPACES.         
           05  R1-SERIAL-NO            PIC X(11)  VALUE SPACES.         
           05  R1-CODE-CRNT-LOC        PIC X(01)  VALUE SPACES.         
           05  R1-CRNT-LOC-NO          PIC S9(10)V USAGE COMP-3 VALUE 0.
           05  R1-DATE-PURCHASED       PIC X(10)  VALUE SPACES.         
           05  R1-DATE-DISPOSED-OF     PIC X(10)  VALUE SPACES.         
           05  R1-WARRANTY-EXP-DT      PIC X(10)  VALUE SPACES.         
           05  R1-INSTALL-DT           PIC X(10)  VALUE SPACES.         
           05  R1-DATE-LAST-TRAN       PIC X(10)  VALUE SPACES.         
           05  R1-DATE-LAST-MOVE       PIC X(10)  VALUE SPACES.         
           05  R1-MFR-DT               PIC X(10)  VALUE SPACES.         
           05  R1-ACCOUNT-NO           PIC S9(13)V USAGE COMP-3 VALUE 0.
           05  R1-ADDR-PREFIX-1        PIC X(03)  VALUE SPACES.         
           05  R1-ADDR-PREFIX-2        PIC X(02)  VALUE SPACES.         
           05  R1-HOUSE-NO             PIC X(15)  VALUE SPACES.         
           05  R1-STREET-LOCATION-1    PIC X(04)  VALUE SPACES.         
           05  R1-STREET-LOCATION-2    PIC X(11)  VALUE SPACES.         
           05  R1-STREET-NAME          PIC X(30)  VALUE SPACES.         
           05  R1-STREET-SUFFIX        PIC X(04)  VALUE SPACES.         
           05  R1-ZIP-CODE             PIC X(05)  VALUE SPACES.         
           05  R1-STATE                PIC X(02)  VALUE SPACES.         
           05  R1-TOWN                 PIC X(26)  VALUE SPACES.         
           05  R1-MTR-STORGE-FAC-TX    PIC X(41)  VALUE SPACES.         
           05  R1-DATE-OBSOLETE        PIC X(10)  VALUE SPACES.         
           05  R1-EQUIP-COMMENTS-TX    PIC X(255) VALUE SPACES.         
           05  R1-EQUIP-MAKE-DESC      PIC X(16)  VALUE SPACES.         
           05  R1-EQUIP-LOC-DESC       PIC X(25)  VALUE SPACES.         
           05  R1-REMOTE-READ-CODE     PIC X(01)  VALUE SPACES.         
           05  R1-CONDEMN-FLAG         PIC X(01)  VALUE SPACES.         
           05  R1-CURB-METER-FL        PIC X(01)  VALUE SPACES.         
           05  R1-MODEL-CD-M5          PIC X(01)  VALUE SPACES.         
           05  R1-METER-SIZE-DESC      PIC X(25)  VALUE SPACES.         
           05  R1-METER-SIZE-DISP      PIC X(36)  VALUE SPACES.         
           05  R1-TEST-SCHED-DISP      PIC X(17)  VALUE SPACES.         
           05  R1-CODE-CO-SIZE         PIC S9(4)  USAGE COMP VALUE 0.   
           05  R1-CONSTANT             PIC S9(6)V9(3) USAGE COMP-3      
                                                  VALUE 0.              
           05  R1-NO-READ-DIALS        PIC S9(4) USAGE COMP VALUE 0.    
           05  R1-NO-DIALS             PIC S9(4) USAGE COMP VALUE 0.    
           05  R1-REG-MEASURES-CD      PIC X(3)   VALUE SPACES.         
           05  R1-CONSTANT-FOUND-FL    PIC X(01)  VALUE SPACES.         
           05  R1-CODE-MAKE            PIC X(02)  VALUE SPACES.         
ACT002     05  R1-FERC-ACCOUNT-NO      PIC X(05)  VALUE SPACES.         
      *                                                                 00015800
       01  TDS-RETURN-FIELDS-R2.                                        
           05  R2-RETURN-CODE          PIC S9(09) USAGE COMP VALUE 0.   
           05  R2-SERIAL-NO            PIC X(11)  VALUE SPACES.         
           05  R2-INSTALL-EMP-ID       PIC X(07)  VALUE SPACES.         
           05  R2-EQUIP-TYPE-CD        PIC X(01)  VALUE SPACES.         
           05  R2-PALETTE-NO           PIC X(04)  VALUE SPACES.         
           05  R2-CODE-MAKE            PIC X(02)  VALUE SPACES.         
           05  R2-DATE-PURCHASED       PIC X(10)  VALUE SPACES.         
           05  R2-DATE-DISPOSED-OF     PIC X(10)  VALUE SPACES.         
           05  R2-WARRANTY-EXP-DT      PIC X(10)  VALUE SPACES.         
           05  R2-DATE-LAST-TRAN       PIC X(10)  VALUE SPACES.         
           05  R2-DATE-LAST-MOVE       PIC X(10)  VALUE SPACES.         
           05  R2-MFR-DT               PIC X(10)  VALUE SPACES.         
           05  R2-DATE-OBSOLETE        PIC X(10)  VALUE SPACES.         
           05  R2-HAZARD-MATERIAL-CD   PIC X(01)  VALUE SPACES.         
           05  R2-CODE-CRNT-LOC        PIC X(01)  VALUE SPACES.         
           05  R2-CRNT-LOC-NO          PIC S9(10)V USAGE COMP-3 VALUE 0.
           05  R2-LOCAL-OFFICE         PIC X(03)  VALUE SPACES.         
           05  R2-EQUIP-COMMENTS-TX    PIC X(255) VALUE SPACES.         
           05  R2-AMPS                 PIC S9(2)V9 USAGE COMP-3 VALUE 0.
           05  R2-CODE-GEAR-REDUCTN    PIC X(01)  VALUE SPACES.         
           05  R2-KH-OR-KE             PIC S9(5)V9(4) USAGE COMP-3      
                                                  VALUE 0.              
           05  R2-REG-LOWER-FRACTION   PIC S9(04) USAGE COMP VALUE 0.   
           05  R2-REG-UPPER-FRACTION   PIC S9(04) USAGE COMP VALUE 0.   
           05  R2-REG-NO               PIC S9(09) USAGE COMP VALUE 0.   
           05  R2-DIGTL-MTR-TYPE       PIC X(03)  VALUE SPACES.         
           05  R2-ELEC-MTR-CLASS-CD    PIC X(02)  VALUE SPACES.         
           05  R2-ELEC-MTR-SPEC-CD     PIC X(03)  VALUE SPACES.         
           05  R2-NO-WIRES             PIC X(01)  VALUE SPACES.         
           05  R2-NO-PHASES            PIC X(01)  VALUE SPACES.         
           05  R2-VOLTAGE              PIC S9(04) USAGE COMP VALUE 0.   
           05  R2-CODE-ATTACHMENTS     PIC X(06)  VALUE SPACES.         
           05  R2-MTR-CONNECT-TYP-ID   PIC X(10)  VALUE SPACES.         
           05  R2-DEVICE-TYPE-CD       PIC X(01)  VALUE SPACES.         
           05  R2-WATTS-PER-PULSE      PIC S9(6)V9(3) USAGE COMP-3      
                                                  VALUE 0.              
           05  R2-PULSES-PER-REV       PIC S9(1)V9(3) USAGE COMP-3      
                                                  VALUE 0.              
           05  R2-TEST-SCHED-CD        PIC X(01)  VALUE SPACES.         
           05  R2-PROGRAM-ID           PIC X(02)  VALUE SPACES.         
           05  R2-CODE-METER-TYPE      PIC X(01)  VALUE SPACES.         
           05  R2-DATE-LAST-TESTED     PIC X(10)  VALUE SPACES.         
           05  R2-METER-SIZE-ID        PIC X(08)  VALUE SPACES.         
           05  R2-TOU-RATE-IND         PIC S9(04) USAGE COMP VALUE 0.   
           05  R2-OVERRIDE-CONST-FL    PIC X(01)  VALUE SPACES.         
           05  R2-IDR-MEMORY-SIZE      PIC X(02)  VALUE SPACES.         
           05  R2-ACCOUNT-NO           PIC S9(13)V USAGE COMP-3 VALUE 0.
           05  R2-ADDR-PREFIX-1        PIC X(03)  VALUE SPACES.         
           05  R2-ADDR-PREFIX-2        PIC X(02)  VALUE SPACES.         
           05  R2-HOUSE-NO             PIC X(15)  VALUE SPACES.         
           05  R2-STREET-LOCATION-1    PIC X(04)  VALUE SPACES.         
           05  R2-STREET-LOCATION-2    PIC X(11)  VALUE SPACES.         
           05  R2-STREET-NAME          PIC X(30)  VALUE SPACES.         
           05  R2-STREET-SUFFIX        PIC X(04)  VALUE SPACES.         
           05  R2-ZIP-CODE             PIC X(05)  VALUE SPACES.         
           05  R2-STATE                PIC X(02)  VALUE SPACES.         
           05  R2-TOWN                 PIC X(26)  VALUE SPACES.         
           05  R2-CONSTANT             PIC S9(6)V9(3) USAGE COMP-3      
                                                  VALUE 0.              
           05  R2-NO-READ-DIALS        PIC S9(4) USAGE COMP VALUE 0.    
           05  R2-NO-DIALS             PIC S9(4) USAGE COMP VALUE 0.    
           05  R2-REG-MEASURES-CD      PIC X(3)   VALUE SPACES.         
           05  R2-CONSTANT-FOUND-FL    PIC X(01)  VALUE SPACES.         
           05  R2-EQUIP-MAKE-DESC      PIC X(16)  VALUE SPACES.         
P00447     05  R2-CT-METER-FL          PIC X(01)  VALUE SPACES.         
ACT002     05  R2-FERC-ACCOUNT-NO      PIC X(05)  VALUE SPACES.         
      *                                                                 00022600
                                                                        
                                                                        
      ******************************************************************00022900
      *    DB2 INCLUDES                                                *00023000
      ******************************************************************00023100
                                                                        
           EXEC SQL                                                     00023300
              INCLUDE SQLCA                                             00023400
           END-EXEC.                                                    00023500
      *                                                                 00023600
      ******************************************************************00023700
      * CSS_ADDR_FORMATTED - DY                                        *00023800
      ******************************************************************00023900
           EXEC SQL                                                     00024000
              INCLUDE TBADRFMT                                          00024100
           END-EXEC.                                                    00024200
      *                                                                 00024300
      ******************************************************************00024400
      * CSS_CUST_PREM_HIST - CH                                        *00024500
      ******************************************************************00024600
           EXEC SQL                                                     00024700
              INCLUDE TBCSTPRM                                          00024800
           END-EXEC.                                                    00024900
      *                                                                 00025000
      ******************************************************************00025100
      * CSS_ELEC_METER - EM                                            *00025200
      ******************************************************************00025300
           EXEC SQL                                                     00025400
              INCLUDE TBELMTR                                           00025500
           END-EXEC.                                                    00025600
      *                                                                 00025700
      ******************************************************************00025800
      * CSS_ACCOUNT - AT                                               *00025900
      ******************************************************************00026000
           EXEC SQL                                                     00026100
              INCLUDE TBACCT                                            00026200
           END-EXEC.                                                    00026300
      *                                                                 00026400
      ******************************************************************00026500
      * CSS_EQUIP_LOCATION - M6                                        *00026600
      ******************************************************************00026700
           EXEC SQL                                                     00026800
              INCLUDE TBEQLOC                                           00026900
           END-EXEC.                                                    00027000
      *                                                                 00027100
      ******************************************************************00027200
      * CSS_EQUIP_MAKE - M2                                            *00027300
      ******************************************************************00027400
           EXEC SQL                                                     00027500
              INCLUDE TBEQMAKE                                          00027600
           END-EXEC.                                                    00027700
      *                                                                 00027800
      ******************************************************************00027900
      * CSS_EQUIPMENT - EQ                                             *00028000
      ******************************************************************00028100
           EXEC SQL                                                     00028200
              INCLUDE TBEQUIP                                           00028300
           END-EXEC.                                                    00028400
      *                                                                 00028500
      ******************************************************************00028600
      * CSS_GAS_METER_SIZE - M5                                        *00028700
      ******************************************************************00028800
           EXEC SQL                                                     00028900
              INCLUDE TBGASMSZ                                          00029000
           END-EXEC.                                                    00029100
      *                                                                 00029200
      ******************************************************************00029300
      * CSS_GAS_METER - GM                                             *00029400
      ******************************************************************00029500
           EXEC SQL                                                     00029600
              INCLUDE TBGASMTR                                          00029700
           END-EXEC.                                                    00029800
      *                                                                 00029900
      ******************************************************************00030000
      * CSS_MTR_STORGE_FAC - W9                                        *00030100
      ******************************************************************00030200
           EXEC SQL                                                     00030300
              INCLUDE TBMTRFAC                                          00030400
           END-EXEC.                                                    00030500
      *                                                                 00030600
      ******************************************************************00030700
      * CSS_TEST_SCHEDULE - M3                                         *00030800
      ******************************************************************00030900
           EXEC SQL                                                     00031000
              INCLUDE TBTSTSCH                                          00031100
           END-EXEC.                                                    00031200
      *                                                                 00031300
      ******************************************************************00031400
      * CSS_ZIP_CODE - A4                                              *00031500
      ******************************************************************00031600
           EXEC SQL                                                     00031700
              INCLUDE TBZIPCD                                           00031800
           END-EXEC.                                                    00031900
      *                                                                 00032000
      ******************************************************************00032100
      * CSS_PREMISE  - PR                                              *00032200
      ******************************************************************00032300
           EXEC SQL                                                     00032400
              INCLUDE TBPREM                                            00032500
           END-EXEC.                                                    00032600
      *                                                                 00032700
      ******************************************************************00032800
      * CSS_MTR_CAP  - MC                                              *00032900
      ******************************************************************00033000
           EXEC SQL                                                     00033100
              INCLUDE TBMTRCAP                                          00033200
           END-EXEC.                                                    00033300
      *                                                                 00033400
P00447******************************************************************00033500
P00447* CSS_ELEC_CL_SPEC, U0                                           *00033600
P00447******************************************************************00033700
P00447     EXEC SQL                                                     00033800
P00447         INCLUDE TBELCLSP                                         00033900
P00447     END-EXEC.                                                    00034000
P00447*                                                                 00034100
      ******************************************************************00034200
      *    COBOL WORKING STORAGE COPY BOOKS                            *00034300
      ******************************************************************00034400
                                                                        
           COPY CWS00303.                                               00034600
                                                                        
           EXEC SQL                                                     00034800
              INCLUDE CWSX0010                                          00034900
           END-EXEC.                                                    00035000
                                                                        
      *                                                                 00035200
                                                                        
HPCCDM*EJECT                                                            00035400
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-METER-NO             PIC X(09).                          
       01 PARM-COMPANY-NO           PIC X(02).                          
       01 PARM-CODE-UTIL-TYPE       PIC X(01).                          
       01 PARM-GET-PREMISE-DET-FL   PIC X(01).                          
      *                                                                 00036100
       PROCEDURE DIVISION USING PARM-METER-NO                           
                                PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-GET-PREMISE-DET-FL.                
                                                                        
      ******************************************************************00036700
      * 0000-MAINLINE                                                  *00036800
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00036900
      ******************************************************************00037000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************00038200
      * 0100-INITIALIZE                                                *00038300
      *                                                                *00038400
      ******************************************************************00038500
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                  :R1-RETURN-CODE             AS RETURN_CODE            
                 ,:R1-CODE-ATTACHMENTS        AS CODE_ATTACHMENTS       
                 ,:R1-CASE-PRESSURE           AS CASE_PRESSURE          
                 ,:R1-CCF-CAP-PER-HR          AS CCF_CAP_PER_HR         
                 ,:R1-MCF-CAP-PER-HR          AS MCF_CAP_PER_HR         
                 ,:R1-METER-SIZE-ID           AS METER_SIZE_ID          
                 ,:R1-NUMBER-OF-DRIVE         AS NUMBER_OF_DRIVE        
                 ,:R1-CODE-METER-TYPE         AS CODE_METER_TYPE        
                 ,:R1-MODEL-CD-GM             AS MODEL_CD_GM            
                 ,:R1-CONNECTION-TYPE-CD      AS CONNECTION_TYPE_CD     
                 ,:R1-ALLOW-CONSTANT-FL       AS ALLOW_CONSTANT_FL      
                 ,:R1-TEST-SCHED-CD           AS TEST_SCHED_CD          
                 ,:R1-DIGTL-MTR-TYPE          AS DIGTL_MTR_TYPE         
                 ,:R1-PROGRAM-ID              AS PROGRAM_ID             
                 ,:R1-LAST-TEST-SEL-DT        AS LAST_TEST_SEL_DT       
                 ,:R1-DATE-LAST-TESTED        AS DATE_LAST_TESTED       
                 ,:R1-INSTALL-EMP-ID          AS INSTALL_EMP_ID         
                 ,:R1-LOCAL-OFFICE            AS LOCAL_OFFICE           
                 ,:R1-EQUIP-TYPE-CD           AS EQUIP_TYPE_CD          
                 ,:R1-PALETTE-NO              AS PALETTE_NO             
                 ,:R1-SERIAL-NO               AS SERIAL_NO              
                 ,:R1-CODE-CRNT-LOC           AS CODE_CRNT_LOC          
                 ,:R1-CRNT-LOC-NO             AS CRNT_LOC_NO            
                 ,:R1-DATE-PURCHASED          AS DATE_PURCHASED         
                 ,:R1-DATE-DISPOSED-OF        AS DATE_DISPOSED_OF       
                 ,:R1-WARRANTY-EXP-DT         AS WARRANTY_EXP_DT        
                 ,:R1-INSTALL-DT              AS INSTALL_DT             
                 ,:R1-DATE-LAST-TRAN          AS DATE_LAST_TRAN         
                 ,:R1-DATE-LAST-MOVE          AS DATE_LAST_MOVE         
                 ,:R1-MFR-DT                  AS MFR_DT                 
                 ,:R1-ACCOUNT-NO              AS ACCOUNT_NO             
                 ,:R1-ADDR-PREFIX-1           AS ADDR_PREFIX_1          
                 ,:R1-ADDR-PREFIX-2           AS ADDR_PREFIX_2          
                 ,:R1-HOUSE-NO                AS HOUSE_NO               
                 ,:R1-STREET-LOCATION-1       AS STREET_LOCATION_1      
                 ,:R1-STREET-LOCATION-2       AS STREET_LOCATION_2      
                 ,:R1-STREET-NAME             AS STREET_NAME            
                 ,:R1-STREET-SUFFIX           AS STREET_SUFFIX          
                 ,:R1-ZIP-CODE                AS ZIP_CODE               
                 ,:R1-STATE                   AS STATE                  
                 ,:R1-TOWN                    AS TOWN                   
                 ,:R1-MTR-STORGE-FAC-TX       AS MTR_STORGE_FAC_TX      
                 ,:R1-DATE-OBSOLETE           AS DATE_OBSOLETE          
                 ,:R1-EQUIP-COMMENTS-TX       AS EQUIP_COMMENTS_TX      
                 ,:R1-EQUIP-MAKE-DESC         AS EQUIP_MAKE_DESC        
                 ,:R1-EQUIP-LOC-DESC          AS EQUIP_LOC_DESC         
                 ,:R1-REMOTE-READ-CODE        AS REMOTE_READ_CODE       
                 ,:R1-CONDEMN-FLAG            AS CONDEMN_FLAG           
                 ,:R1-CURB-METER-FL           AS CURB_METER_FL          
                 ,:R1-MODEL-CD-M5             AS MODEL_CD_M5            
                 ,:R1-METER-SIZE-DESC         AS METER_SIZE_DESC        
                 ,:R1-METER-SIZE-DISP         AS METER_SIZE_DISP        
                 ,:R1-TEST-SCHED-DISP         AS TEST_SCHED_DISP        
                 ,:R1-CODE-CO-SIZE            AS CODE_CO_SIZE           
                 ,:R1-CONSTANT                AS CONSTANT               
                 ,:R1-NO-READ-DIALS           AS NO_READ_DIALS          
                 ,:R1-NO-DIALS                AS NO_DIALS               
                 ,:R1-REG-MEASURES-CD         AS REG_MEASURES_CD        
                 ,:R1-CONSTANT-FOUND-FL       AS CONSTANT_FOUND_FL      
                 ,:R1-CODE-MAKE               AS CODE_MAKE              
ACT002           ,:R1-FERC-ACCOUNT-NO         AS FERC_ACCOUNT_NO        
             FROM                                                       
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     00039200
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                          00039300
MFA-TR*      SELECT                                                     00039400
MFA-TR*           :R1-RETURN-CODE             AS RETURN_CODE            00039500
MFA-TR*          ,:R1-CODE-ATTACHMENTS        AS CODE_ATTACHMENTS       00039600
MFA-TR*          ,:R1-CASE-PRESSURE           AS CASE_PRESSURE          00039700
MFA-TR*          ,:R1-CCF-CAP-PER-HR          AS CCF_CAP_PER_HR         00039800
MFA-TR*          ,:R1-MCF-CAP-PER-HR          AS MCF_CAP_PER_HR         00039900
MFA-TR*          ,:R1-METER-SIZE-ID           AS METER_SIZE_ID          00040000
MFA-TR*          ,:R1-NUMBER-OF-DRIVE         AS NUMBER_OF_DRIVE        00040100
MFA-TR*          ,:R1-CODE-METER-TYPE         AS CODE_METER_TYPE        00040200
MFA-TR*          ,:R1-MODEL-CD-GM             AS MODEL_CD_GM            00040300
MFA-TR*          ,:R1-CONNECTION-TYPE-CD      AS CONNECTION_TYPE_CD     00040400
MFA-TR*          ,:R1-ALLOW-CONSTANT-FL       AS ALLOW_CONSTANT_FL      00040500
MFA-TR*          ,:R1-TEST-SCHED-CD           AS TEST_SCHED_CD          00040600
MFA-TR*          ,:R1-DIGTL-MTR-TYPE          AS DIGTL_MTR_TYPE         00040700
MFA-TR*          ,:R1-PROGRAM-ID              AS PROGRAM_ID             00040800
MFA-TR*          ,:R1-LAST-TEST-SEL-DT        AS LAST_TEST_SEL_DT       00040900
MFA-TR*          ,:R1-DATE-LAST-TESTED        AS DATE_LAST_TESTED       00041000
MFA-TR*          ,:R1-INSTALL-EMP-ID          AS INSTALL_EMP_ID         00041100
MFA-TR*          ,:R1-LOCAL-OFFICE            AS LOCAL_OFFICE           00041200
MFA-TR*          ,:R1-EQUIP-TYPE-CD           AS EQUIP_TYPE_CD          00041300
MFA-TR*          ,:R1-PALETTE-NO              AS PALETTE_NO             00041400
MFA-TR*          ,:R1-SERIAL-NO               AS SERIAL_NO              00041500
MFA-TR*          ,:R1-CODE-CRNT-LOC           AS CODE_CRNT_LOC          00041600
MFA-TR*          ,:R1-CRNT-LOC-NO             AS CRNT_LOC_NO            00041700
MFA-TR*          ,:R1-DATE-PURCHASED          AS DATE_PURCHASED         00041800
MFA-TR*          ,:R1-DATE-DISPOSED-OF        AS DATE_DISPOSED_OF       00041900
MFA-TR*          ,:R1-WARRANTY-EXP-DT         AS WARRANTY_EXP_DT        00042000
MFA-TR*          ,:R1-INSTALL-DT              AS INSTALL_DT             00042100
MFA-TR*          ,:R1-DATE-LAST-TRAN          AS DATE_LAST_TRAN         00042200
MFA-TR*          ,:R1-DATE-LAST-MOVE          AS DATE_LAST_MOVE         00042300
MFA-TR*          ,:R1-MFR-DT                  AS MFR_DT                 00042400
MFA-TR*          ,:R1-ACCOUNT-NO              AS ACCOUNT_NO             00042500
MFA-TR*          ,:R1-ADDR-PREFIX-1           AS ADDR_PREFIX_1          00042600
MFA-TR*          ,:R1-ADDR-PREFIX-2           AS ADDR_PREFIX_2          00042700
MFA-TR*          ,:R1-HOUSE-NO                AS HOUSE_NO               00042800
MFA-TR*          ,:R1-STREET-LOCATION-1       AS STREET_LOCATION_1      00042900
MFA-TR*          ,:R1-STREET-LOCATION-2       AS STREET_LOCATION_2      00043000
MFA-TR*          ,:R1-STREET-NAME             AS STREET_NAME            00043100
MFA-TR*          ,:R1-STREET-SUFFIX           AS STREET_SUFFIX          00043200
MFA-TR*          ,:R1-ZIP-CODE                AS ZIP_CODE               00043300
MFA-TR*          ,:R1-STATE                   AS STATE                  00043400
MFA-TR*          ,:R1-TOWN                    AS TOWN                   00043500
MFA-TR*          ,:R1-MTR-STORGE-FAC-TX       AS MTR_STORGE_FAC_TX      00043600
MFA-TR*          ,:R1-DATE-OBSOLETE           AS DATE_OBSOLETE          00043700
MFA-TR*          ,:R1-EQUIP-COMMENTS-TX       AS EQUIP_COMMENTS_TX      00043800
MFA-TR*          ,:R1-EQUIP-MAKE-DESC         AS EQUIP_MAKE_DESC        00043900
MFA-TR*          ,:R1-EQUIP-LOC-DESC          AS EQUIP_LOC_DESC         00044000
MFA-TR*          ,:R1-REMOTE-READ-CODE        AS REMOTE_READ_CODE       00044100
MFA-TR*          ,:R1-CONDEMN-FLAG            AS CONDEMN_FLAG           00044200
MFA-TR*          ,:R1-CURB-METER-FL           AS CURB_METER_FL          00044300
MFA-TR*          ,:R1-MODEL-CD-M5             AS MODEL_CD_M5            00044400
MFA-TR*          ,:R1-METER-SIZE-DESC         AS METER_SIZE_DESC        00044500
MFA-TR*          ,:R1-METER-SIZE-DISP         AS METER_SIZE_DISP        00044600
MFA-TR*          ,:R1-TEST-SCHED-DISP         AS TEST_SCHED_DISP        00044700
MFA-TR*          ,:R1-CODE-CO-SIZE            AS CODE_CO_SIZE           00044800
MFA-TR*          ,:R1-CONSTANT                AS CONSTANT               00044900
MFA-TR*          ,:R1-NO-READ-DIALS           AS NO_READ_DIALS          00045000
MFA-TR*          ,:R1-NO-DIALS                AS NO_DIALS               00045100
MFA-TR*          ,:R1-REG-MEASURES-CD         AS REG_MEASURES_CD        00045200
MFA-TR*          ,:R1-CONSTANT-FOUND-FL       AS CONSTANT_FOUND_FL      00045300
MFA-TR*          ,:R1-CODE-MAKE               AS CODE_MAKE              00045400
MFA-TR*          ,:R1-FERC-ACCOUNT-NO         AS FERC_ACCOUNT_NO        00045500
MFA-TR*      FROM                                                       00045600
MFA-TR*           SYSIBM.SYSDUMMY1                                      00045700
MFA-TR*    END-EXEC.                                                    00045800
                                                                        
           EXEC SQL                                                     
             DECLARE C2 CURSOR  FOR                          
             SELECT                                                     
                  :R2-RETURN-CODE             AS RETURN_CODE            
                 ,:R2-SERIAL-NO               AS SERIAL_NO              
                 ,:R2-INSTALL-EMP-ID          AS INSTALL_EMP_ID         
                 ,:R2-EQUIP-TYPE-CD           AS EQUIP_TYPE_CD          
                 ,:R2-PALETTE-NO              AS PALETTE_NO             
                 ,:R2-CODE-MAKE               AS CODE_MAKE              
                 ,:R2-DATE-PURCHASED          AS DATE_PURCHASED         
                 ,:R2-DATE-DISPOSED-OF        AS DATE_DISPOSED_OF       
                 ,:R2-WARRANTY-EXP-DT         AS WARRANTY_EXP_DT        
                 ,:R2-DATE-LAST-TRAN          AS DATE_LAST_TRAN         
                 ,:R2-DATE-LAST-MOVE          AS DATE_LAST_MOVE         
                 ,:R2-MFR-DT                  AS MFR_DT                 
                 ,:R2-DATE-OBSOLETE           AS DATE_OBSOLETE          
                 ,:R2-HAZARD-MATERIAL-CD      AS HAZARD_MATERIAL_CD     
                 ,:R2-CODE-CRNT-LOC           AS CODE_CRNT_LOC          
                 ,:R2-CRNT-LOC-NO             AS CRNT_LOC_NO            
                 ,:R2-LOCAL-OFFICE            AS LOCAL_OFFICE           
                 ,:R2-EQUIP-COMMENTS-TX       AS EQUIP_COMMENTS_TX      
                 ,:R2-AMPS                    AS AMPS                   
                 ,:R2-CODE-GEAR-REDUCTN       AS CODE_GEAR_REDUCTN      
                 ,:R2-KH-OR-KE                AS KH_OR_KE               
                 ,:R2-REG-LOWER-FRACTION      AS REG_LOWER_FRACTION     
                 ,:R2-REG-UPPER-FRACTION      AS REG_UPPER_FRACTION     
                 ,:R2-REG-NO                  AS REG_NO                 
                 ,:R2-DIGTL-MTR-TYPE          AS DIGTL_MTR_TYPE         
                 ,:R2-ELEC-MTR-CLASS-CD       AS ELEC_MTR_CLASS_CD      
                 ,:R2-ELEC-MTR-SPEC-CD        AS ELEC_MTR_SPEC_CD       
                 ,:R2-NO-WIRES                AS NO_WIRES               
                 ,:R2-NO-PHASES               AS NO_PHASES              
                 ,:R2-VOLTAGE                 AS VOLTAGE                
                 ,:R2-CODE-ATTACHMENTS        AS CODE_ATTACHMENTS       
                 ,:R2-MTR-CONNECT-TYP-ID      AS MTR_CONNECT_TYP_ID     
                 ,:R2-DEVICE-TYPE-CD          AS DEVICE_TYPE_CD         
                 ,:R2-WATTS-PER-PULSE         AS WATTS_PER_PULSE        
                 ,:R2-PULSES-PER-REV          AS PULSES_PER_REV         
                 ,:R2-TEST-SCHED-CD           AS TEST_SCHED_CD          
                 ,:R2-PROGRAM-ID              AS PROGRAM_ID             
                 ,:R2-CODE-METER-TYPE         AS CODE_METER_TYPE        
                 ,:R2-DATE-LAST-TESTED        AS DATE_LAST_TESTED       
                 ,:R2-METER-SIZE-ID           AS METER_SIZE_ID          
                 ,:R2-TOU-RATE-IND            AS TOU_RATE_IND           
                 ,:R2-OVERRIDE-CONST-FL       AS OVERRIDE_CONST_FL      
                 ,:R2-IDR-MEMORY-SIZE         AS IDR_MEMORY_SIZE        
                 ,:R2-ACCOUNT-NO              AS ACCOUNT_NO             
                 ,:R2-ADDR-PREFIX-1           AS ADDR_PREFIX_1          
                 ,:R2-ADDR-PREFIX-2           AS ADDR_PREFIX_2          
                 ,:R2-HOUSE-NO                AS HOUSE_NO               
                 ,:R2-STREET-LOCATION-1       AS STREET_LOCATION_1      
                 ,:R2-STREET-LOCATION-2       AS STREET_LOCATION_2      
                 ,:R2-STREET-NAME             AS STREET_NAME            
                 ,:R2-STREET-SUFFIX           AS STREET_SUFFIX          
                 ,:R2-ZIP-CODE                AS ZIP_CODE               
                 ,:R2-STATE                   AS STATE                  
                 ,:R2-TOWN                    AS TOWN                   
                 ,:R2-CONSTANT                AS CONSTANT               
                 ,:R2-NO-READ-DIALS           AS NO_READ_DIALS          
                 ,:R2-NO-DIALS                AS NO_DIALS               
                 ,:R2-REG-MEASURES-CD         AS REG_MEASURES_CD        
                 ,:R2-CONSTANT-FOUND-FL       AS CONSTANT_FOUND_FL      
                 ,:R2-EQUIP-MAKE-DESC         AS EQUIP_MAKE_DESC        
P00447           ,:R2-CT-METER-FL             AS CT_METER_FL            
ACT002           ,:R2-FERC-ACCOUNT-NO         AS FERC_ACCOUNT_NO        
             FROM                                                       
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     00046000
MFA-TR*      DECLARE C2 CURSOR WITH RETURN FOR                          00046100
MFA-TR*      SELECT                                                     00046200
MFA-TR*           :R2-RETURN-CODE             AS RETURN_CODE            00046300
MFA-TR*          ,:R2-SERIAL-NO               AS SERIAL_NO              00046400
MFA-TR*          ,:R2-INSTALL-EMP-ID          AS INSTALL_EMP_ID         00046500
MFA-TR*          ,:R2-EQUIP-TYPE-CD           AS EQUIP_TYPE_CD          00046600
MFA-TR*          ,:R2-PALETTE-NO              AS PALETTE_NO             00046700
MFA-TR*          ,:R2-CODE-MAKE               AS CODE_MAKE              00046800
MFA-TR*          ,:R2-DATE-PURCHASED          AS DATE_PURCHASED         00046900
MFA-TR*          ,:R2-DATE-DISPOSED-OF        AS DATE_DISPOSED_OF       00047000
MFA-TR*          ,:R2-WARRANTY-EXP-DT         AS WARRANTY_EXP_DT        00047100
MFA-TR*          ,:R2-DATE-LAST-TRAN          AS DATE_LAST_TRAN         00047200
MFA-TR*          ,:R2-DATE-LAST-MOVE          AS DATE_LAST_MOVE         00047300
MFA-TR*          ,:R2-MFR-DT                  AS MFR_DT                 00047400
MFA-TR*          ,:R2-DATE-OBSOLETE           AS DATE_OBSOLETE          00047500
MFA-TR*          ,:R2-HAZARD-MATERIAL-CD      AS HAZARD_MATERIAL_CD     00047600
MFA-TR*          ,:R2-CODE-CRNT-LOC           AS CODE_CRNT_LOC          00047700
MFA-TR*          ,:R2-CRNT-LOC-NO             AS CRNT_LOC_NO            00047800
MFA-TR*          ,:R2-LOCAL-OFFICE            AS LOCAL_OFFICE           00047900
MFA-TR*          ,:R2-EQUIP-COMMENTS-TX       AS EQUIP_COMMENTS_TX      00048000
MFA-TR*          ,:R2-AMPS                    AS AMPS                   00048100
MFA-TR*          ,:R2-CODE-GEAR-REDUCTN       AS CODE_GEAR_REDUCTN      00048200
MFA-TR*          ,:R2-KH-OR-KE                AS KH_OR_KE               00048300
MFA-TR*          ,:R2-REG-LOWER-FRACTION      AS REG_LOWER_FRACTION     00048400
MFA-TR*          ,:R2-REG-UPPER-FRACTION      AS REG_UPPER_FRACTION     00048500
MFA-TR*          ,:R2-REG-NO                  AS REG_NO                 00048600
MFA-TR*          ,:R2-DIGTL-MTR-TYPE          AS DIGTL_MTR_TYPE         00048700
MFA-TR*          ,:R2-ELEC-MTR-CLASS-CD       AS ELEC_MTR_CLASS_CD      00048800
MFA-TR*          ,:R2-ELEC-MTR-SPEC-CD        AS ELEC_MTR_SPEC_CD       00048900
MFA-TR*          ,:R2-NO-WIRES                AS NO_WIRES               00049000
MFA-TR*          ,:R2-NO-PHASES               AS NO_PHASES              00049100
MFA-TR*          ,:R2-VOLTAGE                 AS VOLTAGE                00049200
MFA-TR*          ,:R2-CODE-ATTACHMENTS        AS CODE_ATTACHMENTS       00049300
MFA-TR*          ,:R2-MTR-CONNECT-TYP-ID      AS MTR_CONNECT_TYP_ID     00049400
MFA-TR*          ,:R2-DEVICE-TYPE-CD          AS DEVICE_TYPE_CD         00049500
MFA-TR*          ,:R2-WATTS-PER-PULSE         AS WATTS_PER_PULSE        00049600
MFA-TR*          ,:R2-PULSES-PER-REV          AS PULSES_PER_REV         00049700
MFA-TR*          ,:R2-TEST-SCHED-CD           AS TEST_SCHED_CD          00049800
MFA-TR*          ,:R2-PROGRAM-ID              AS PROGRAM_ID             00049900
MFA-TR*          ,:R2-CODE-METER-TYPE         AS CODE_METER_TYPE        00050000
MFA-TR*          ,:R2-DATE-LAST-TESTED        AS DATE_LAST_TESTED       00050100
MFA-TR*          ,:R2-METER-SIZE-ID           AS METER_SIZE_ID          00050200
MFA-TR*          ,:R2-TOU-RATE-IND            AS TOU_RATE_IND           00050300
MFA-TR*          ,:R2-OVERRIDE-CONST-FL       AS OVERRIDE_CONST_FL      00050400
MFA-TR*          ,:R2-IDR-MEMORY-SIZE         AS IDR_MEMORY_SIZE        00050500
MFA-TR*          ,:R2-ACCOUNT-NO              AS ACCOUNT_NO             00050600
MFA-TR*          ,:R2-ADDR-PREFIX-1           AS ADDR_PREFIX_1          00050700
MFA-TR*          ,:R2-ADDR-PREFIX-2           AS ADDR_PREFIX_2          00050800
MFA-TR*          ,:R2-HOUSE-NO                AS HOUSE_NO               00050900
MFA-TR*          ,:R2-STREET-LOCATION-1       AS STREET_LOCATION_1      00051000
MFA-TR*          ,:R2-STREET-LOCATION-2       AS STREET_LOCATION_2      00051100
MFA-TR*          ,:R2-STREET-NAME             AS STREET_NAME            00051200
MFA-TR*          ,:R2-STREET-SUFFIX           AS STREET_SUFFIX          00051300
MFA-TR*          ,:R2-ZIP-CODE                AS ZIP_CODE               00051400
MFA-TR*          ,:R2-STATE                   AS STATE                  00051500
MFA-TR*          ,:R2-TOWN                    AS TOWN                   00051600
MFA-TR*          ,:R2-CONSTANT                AS CONSTANT               00051700
MFA-TR*          ,:R2-NO-READ-DIALS           AS NO_READ_DIALS          00051800
MFA-TR*          ,:R2-NO-DIALS                AS NO_DIALS               00051900
MFA-TR*          ,:R2-REG-MEASURES-CD         AS REG_MEASURES_CD        00052000
MFA-TR*          ,:R2-CONSTANT-FOUND-FL       AS CONSTANT_FOUND_FL      00052100
MFA-TR*          ,:R2-EQUIP-MAKE-DESC         AS EQUIP_MAKE_DESC        00052200
MFA-TR*          ,:R2-CT-METER-FL             AS CT_METER_FL            00052300
MFA-TR*          ,:R2-FERC-ACCOUNT-NO         AS FERC_ACCOUNT_NO        00052400
MFA-TR*      FROM                                                       00052500
MFA-TR*           SYSIBM.SYSDUMMY1                                      00052600
MFA-TR*    END-EXEC.                                                    00052700
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00053000
      * 1000-PROCESS-INPUT                                             *00053100
      *                                                                *00053200
      ******************************************************************00053300
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1200-VALIDATE-INPUT-ARGUMENTS THRU 1200-EXIT.        
           MOVE PARM-METER-NO           TO WS-DEVICE-NO.                
           MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO.               
           MOVE PARM-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE.           
           MOVE PARM-GET-PREMISE-DET-FL TO WS-PREMISE-FLAG.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00054500
      * 1200-VALIDATE-INPUT-ARGUMENTS                                  *00054600
      ******************************************************************00054700
       1200-VALIDATE-INPUT-ARGUMENTS.                                   
           IF PARM-CODE-UTIL-TYPE = SPACES OR                           
              PARM-COMPANY-NO     = SPACES OR                           
              PARM-METER-NO       = SPACES                              
              MOVE 9998                   TO WS-ACTIVE-RETURN-CODE      
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '1200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'VALIDATE'             TO ABEND-FUNCTION             
              MOVE 'N/A'                  TO TABLE-1                    
              MOVE 'PARM-CODE-UTIL-TYPE'  TO TABLE-ELEMENT-1            
              MOVE 'PARM-COMPANY-NO'      TO TABLE-ELEMENT-2            
              MOVE 'PARM-METER-NO'        TO TABLE-ELEMENT-3            
              MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1          
              MOVE PARM-COMPANY-NO        TO HOSTVAR-ELEMENT-2          
              MOVE PARM-METER-NO          TO HOSTVAR-ELEMENT-3          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                .                                                       
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00056900
      * 2000-PROCESS-OUTPUT.                                           *00057000
      *                                                                *00057100
      ******************************************************************00057200
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE   WS-NULL-INDICATORS.                             
           IF WS-CODE-UTIL-TYPE = 'G'                                   
              PERFORM 2300-PROCESS-GAS-DETAILS     THRU 2300-EXIT       
           ELSE                                                         
              PERFORM 2400-PROCESS-ELEC-DETAILS    THRU 2400-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-PREMISE-FLAG = 'Y' AND WS-PREMISE-NO > 0               
              AND R1-RETURN-CODE = 0                                    
              AND R2-RETURN-CODE = 0                                    
              PERFORM 2500-GET-ADDRESS-INFO        THRU 2500-EXIT       
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00059000
      *2100-MOVE-RESULT-GAS                                            *00059100
      ******************************************************************00059200
       2100-MOVE-RESULT-GAS.                                            
      *                                                                 00059400
           MOVE GM-CODE-ATTACHMENTS       TO R1-CODE-ATTACHMENTS        
           MOVE GM-CASE-PRESSURE          TO R1-CASE-PRESSURE           
           MOVE M5-CCF-CAP-PER-HR         TO R1-CCF-CAP-PER-HR          
           MOVE GM-MCF-CAP-PER-HR         TO R1-MCF-CAP-PER-HR          
           MOVE GM-METER-SIZE-ID          TO R1-METER-SIZE-ID           
           MOVE GM-NUMBER-OF-DRIVE        TO R1-NUMBER-OF-DRIVE         
           MOVE GM-CODE-METER-TYPE        TO R1-CODE-METER-TYPE         
           MOVE GM-MODEL-CD               TO R1-MODEL-CD-GM             
           MOVE GM-CONNECTION-TYPE-CD     TO R1-CONNECTION-TYPE-CD      
           MOVE GM-ALLOW-CONSTANT-FL      TO R1-ALLOW-CONSTANT-FL       
           MOVE GM-TEST-SCHED-CD          TO R1-TEST-SCHED-CD           
           MOVE GM-DIGTL-MTR-TYPE         TO R1-DIGTL-MTR-TYPE          
           MOVE GM-PROGRAM-ID             TO R1-PROGRAM-ID              
           IF WS-LAST-TEST-SEL-IND     = -1                             
              MOVE  'N/A'                 TO R1-LAST-TEST-SEL-DT        
           ELSE                                                         
              MOVE GM-LAST-TEST-SEL-DT    TO R1-LAST-TEST-SEL-DT        
           END-IF                                                       
           IF WS-DATE-LAST-TESTED-IND  = -1                             
              MOVE  SPACES                TO R1-DATE-LAST-TESTED        
           ELSE                                                         
              MOVE GM-DATE-LAST-TESTED    TO R1-DATE-LAST-TESTED        
           END-IF                                                       
           MOVE EQ-INSTALL-EMP-ID         TO R1-INSTALL-EMP-ID          
           MOVE EQ-LOCAL-OFFICE           TO R1-LOCAL-OFFICE            
           MOVE WS-MTR-STORGE-FAC-TX      TO R1-MTR-STORGE-FAC-TX       
           MOVE EQ-EQUIP-TYPE-CD          TO R1-EQUIP-TYPE-CD           
           MOVE EQ-PALETTE-NO             TO R1-PALETTE-NO              
           MOVE EQ-SERIAL-NO              TO R1-SERIAL-NO               
           MOVE EQ-CODE-CRNT-LOC          TO R1-CODE-CRNT-LOC           
           MOVE EQ-CRNT-LOC-NO            TO R1-CRNT-LOC-NO             
           IF WS-DATE-PURCHASED-IND = -1                                
              MOVE  'N/A'                 TO R1-DATE-PURCHASED          
           ELSE                                                         
              MOVE EQ-DATE-PURCHASED      TO R1-DATE-PURCHASED          
           END-IF                                                       
           IF WS-DATE-DISPOSED-OF-IND = -1                              
              MOVE  'N/A'                 TO R1-DATE-DISPOSED-OF        
           ELSE                                                         
              MOVE EQ-DATE-DISPOSED-OF    TO R1-DATE-DISPOSED-OF        
           END-IF                                                       
           IF WS-WARRANTY-EXP-DT-IND = -1                               
              MOVE  'N/A'                 TO R1-WARRANTY-EXP-DT         
           ELSE                                                         
              MOVE  EQ-WARRANTY-EXP-DT    TO R1-WARRANTY-EXP-DT         
           END-IF                                                       
           IF WS-INSTALL-DT-IND     = -1                                
              MOVE  'N/A'                 TO R1-INSTALL-DT              
           ELSE                                                         
              MOVE  EQ-INSTALL-DT         TO R1-INSTALL-DT              
           END-IF                                                       
           IF WS-DATE-LAST-TRAN-IND = -1                                
              MOVE  'N/A'                 TO R1-DATE-LAST-TRAN          
           ELSE                                                         
              MOVE EQ-DATE-LAST-TRAN      TO R1-DATE-LAST-TRAN          
           END-IF                                                       
           IF WS-DATE-LAST-MOVE-IND = -1                                
              MOVE  'N/A'                 TO R1-DATE-LAST-MOVE          
           ELSE                                                         
              MOVE EQ-DATE-LAST-MOVE      TO R1-DATE-LAST-MOVE          
           END-IF                                                       
           IF WS-MFR-DT-IND            = -1                             
              MOVE  'N/A'                 TO R1-MFR-DT                  
           ELSE                                                         
              MOVE EQ-MFR-DT              TO R1-MFR-DT                  
           END-IF                                                       
           IF WS-DATE-OBSOLETE-IND     = -1                             
              MOVE  'N/A'                 TO R1-DATE-OBSOLETE           
           ELSE                                                         
              MOVE EQ-DATE-OBSOLETE       TO R1-DATE-OBSOLETE           
           END-IF                                                       
           MOVE EQ-EQUIP-COMMENTS-TX-TEXT TO R1-EQUIP-COMMENTS-TX       
ACT002     MOVE EQ-FERC-ACCOUNT-NO        TO R1-FERC-ACCOUNT-NO         
           MOVE M2-EQUIP-MAKE-DESC        TO R1-EQUIP-MAKE-DESC         
           MOVE M6-EQUIP-LOC-DESC         TO R1-EQUIP-LOC-DESC          
           MOVE M5-REMOTE-READ-CODE       TO R1-REMOTE-READ-CODE        
           MOVE M5-CONDEMN-FLAG           TO R1-CONDEMN-FLAG            
           MOVE M5-CURB-METER-FL          TO R1-CURB-METER-FL           
           MOVE M5-MODEL-CD               TO R1-MODEL-CD-M5             
           MOVE M5-METER-SIZE-DESC        TO R1-METER-SIZE-DESC         
           MOVE WS-METER-SIZE-DISP        TO R1-METER-SIZE-DISP         
           MOVE WS-TEST-SCHED-DISP        TO R1-TEST-SCHED-DISP         
           MOVE GM-CODE-CO-SIZE           TO R1-CODE-CO-SIZE            
           MOVE MC-CONSTANT               TO R1-CONSTANT                
           MOVE MC-NO-READ-DIALS          TO R1-NO-READ-DIALS           
           MOVE MC-NO-DIALS               TO R1-NO-DIALS                
           MOVE MC-REG-MEASURES-CD        TO R1-REG-MEASURES-CD         
           MOVE WS-MTR-CAP-FLAG           TO R1-CONSTANT-FOUND-FL       
           MOVE M2-CODE-MAKE              TO R1-CODE-MAKE.              
      *                                                                 00068400
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00068700
      ******************************************************************00068800
      *2200-MOVE-RESULT-ELEC                                            00068900
      ******************************************************************00069000
       2200-MOVE-RESULT-ELEC.                                           
      *                                                                 00069200
           MOVE EQ-SERIAL-NO                 TO R2-SERIAL-NO            
           MOVE EQ-INSTALL-EMP-ID            TO R2-INSTALL-EMP-ID       
           MOVE EQ-EQUIP-TYPE-CD             TO R2-EQUIP-TYPE-CD        
           MOVE EQ-PALETTE-NO                TO R2-PALETTE-NO           
           MOVE EQ-CODE-MAKE                 TO R2-CODE-MAKE            
           IF WS-DATE-PURCHASED-IND  = -1                               
              MOVE SPACES                    TO R2-DATE-PURCHASED       
           ELSE                                                         
              MOVE EQ-DATE-PURCHASED         TO R2-DATE-PURCHASED       
           END-IF                                                       
           IF WS-DATE-DISPOSED-OF-IND = -1                              
              MOVE SPACES                    TO R2-DATE-DISPOSED-OF     
           ELSE                                                         
              MOVE EQ-DATE-DISPOSED-OF       TO R2-DATE-DISPOSED-OF     
           END-IF                                                       
           IF WS-WARRANTY-EXP-DT-IND  = -1                              
              MOVE  SPACES                   TO R2-WARRANTY-EXP-DT      
           ELSE                                                         
              MOVE EQ-WARRANTY-EXP-DT        TO R2-WARRANTY-EXP-DT      
           END-IF                                                       
           IF WS-DATE-LAST-TRAN-IND   = -1                              
              MOVE  SPACES                   TO R2-DATE-LAST-TRAN       
           ELSE                                                         
              MOVE EQ-DATE-LAST-TRAN         TO R2-DATE-LAST-TRAN       
           END-IF                                                       
           IF WS-DATE-LAST-MOVE-IND = -1                                
              MOVE  SPACES                   TO R2-DATE-LAST-MOVE       
           ELSE                                                         
              MOVE EQ-DATE-LAST-MOVE         TO R2-DATE-LAST-MOVE       
           END-IF                                                       
           IF WS-MFR-DT-IND         = -1                                
              MOVE  SPACES                   TO R2-MFR-DT               
           ELSE                                                         
              MOVE EQ-MFR-DT                 TO R2-MFR-DT               
           END-IF                                                       
           IF WS-DATE-OBSOLETE-IND  = -1                                
              MOVE  SPACES                   TO R2-DATE-OBSOLETE        
           ELSE                                                         
              MOVE EQ-DATE-OBSOLETE          TO R2-DATE-OBSOLETE        
           END-IF                                                       
           MOVE EQ-HAZARD-MATERIAL-CD        TO R2-HAZARD-MATERIAL-CD   
           MOVE EQ-CODE-CRNT-LOC             TO R2-CODE-CRNT-LOC        
           MOVE EQ-CRNT-LOC-NO               TO R2-CRNT-LOC-NO          
           MOVE EQ-LOCAL-OFFICE              TO R2-LOCAL-OFFICE         
           MOVE EQ-EQUIP-COMMENTS-TX-TEXT    TO R2-EQUIP-COMMENTS-TX    
ACT002     MOVE EQ-FERC-ACCOUNT-NO           TO R2-FERC-ACCOUNT-NO      
           MOVE EM-AMPS                      TO R2-AMPS                 
           MOVE EM-CODE-GEAR-REDUCTN         TO R2-CODE-GEAR-REDUCTN    
           MOVE EM-KH-OR-KE                  TO R2-KH-OR-KE             
           MOVE EM-REG-LOWER-FRACTION        TO R2-REG-LOWER-FRACTION   
           MOVE EM-REG-UPPER-FRACTION        TO R2-REG-UPPER-FRACTION   
           MOVE EM-REG-NO                    TO R2-REG-NO               
           MOVE EM-DIGTL-MTR-TYPE            TO R2-DIGTL-MTR-TYPE       
           MOVE EM-ELEC-MTR-CLASS-CD         TO R2-ELEC-MTR-CLASS-CD    
           MOVE EM-ELEC-MTR-SPEC-CD          TO R2-ELEC-MTR-SPEC-CD     
           MOVE EM-NO-WIRES                  TO R2-NO-WIRES             
           MOVE EM-NO-PHASES                 TO R2-NO-PHASES            
           MOVE EM-VOLTAGE                   TO R2-VOLTAGE              
           MOVE EM-CODE-ATTACHMENTS          TO R2-CODE-ATTACHMENTS     
           MOVE EM-MTR-CONNECT-TYP-ID        TO R2-MTR-CONNECT-TYP-ID   
           MOVE EM-DEVICE-TYPE-CD            TO R2-DEVICE-TYPE-CD       
           MOVE EM-WATTS-PER-PULSE           TO R2-WATTS-PER-PULSE      
           MOVE EM-PULSES-PER-REV            TO R2-PULSES-PER-REV       
           MOVE EM-TEST-SCHED-CD             TO R2-TEST-SCHED-CD        
           MOVE EM-PROGRAM-ID                TO R2-PROGRAM-ID           
           MOVE EM-CODE-METER-TYPE           TO R2-CODE-METER-TYPE      
           IF WS-DATE-LAST-TESTED-IND = -1                              
              MOVE  SPACES                   TO R2-DATE-LAST-TESTED     
           ELSE                                                         
              MOVE EM-DATE-LAST-TESTED       TO R2-DATE-LAST-TESTED     
           END-IF                                                       
           MOVE EM-METER-SIZE-ID             TO R2-METER-SIZE-ID        
           MOVE EM-TOU-RATE-IND              TO R2-TOU-RATE-IND         
           MOVE EM-OVERRIDE-CONST-FL         TO R2-OVERRIDE-CONST-FL    
           MOVE EM-IDR-MEMORY-SIZE           TO R2-IDR-MEMORY-SIZE      
           MOVE MC-CONSTANT                  TO R2-CONSTANT             
           MOVE MC-NO-READ-DIALS             TO R2-NO-READ-DIALS        
           MOVE MC-NO-DIALS                  TO R2-NO-DIALS             
           MOVE MC-REG-MEASURES-CD           TO R2-REG-MEASURES-CD      
           MOVE WS-MTR-CAP-FLAG              TO R2-CONSTANT-FOUND-FL    
           MOVE M2-EQUIP-MAKE-DESC           TO R2-EQUIP-MAKE-DESC.     
P00447     MOVE U0-CT-METER-FL               TO R2-CT-METER-FL.         
      *                                                                 00077500
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00077800
      ******************************************************************00077900
      * 2300-PROCESS-GAS-DETAILS                                       *00078000
      ******************************************************************00078100
       2300-PROCESS-GAS-DETAILS.                                        
                                                                        
           MOVE WS-COMPANY-NO                 TO EQ-COMPANY-NO          
                                                 MC-COMPANY-NO.         
           MOVE WS-CODE-UTIL-TYPE             TO EQ-CODE-UTIL-TYPE      
                                                 MC-CODE-UTIL-TYPE.     
           MOVE WS-DEVICE-NO                  TO EQ-DEVICE-NO           
                                                 MC-METER-NO.           
                                                                        
           PERFORM 7100-SEL-GAS-EQ-DET        THRU 7100-EXIT.           
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-TEST-SCHED-DESC-IND = -1                            
                 MOVE SPACES                 TO M3-TEST-SCHED-DESC      
              END-IF                                                    
              IF WS-MTR-STOR-FAC-TX-IND = -1                            
                 MOVE 'N/A'                  TO W9-MTR-STORAGE-FAC-TX   
              END-IF                                                    
              STRING EQ-LOCAL-OFFICE        DELIMITED BY SPACE          
                     ,WS-HYPHEN                                         
                     ,W9-MTR-STORAGE-FAC-TX DELIMITED BY SIZE           
              INTO   WS-MTR-STORGE-FAC-TX                               
              STRING M5-METER-SIZE-ID       DELIMITED BY '  '           
                     ,WS-HYPHEN                                         
                     ,M5-METER-SIZE-DESC    DELIMITED BY SIZE           
              INTO   WS-METER-SIZE-DISP                                 
              STRING GM-TEST-SCHED-CD       DELIMITED BY SPACE          
                     ,WS-HYPHEN                                         
                     ,M3-TEST-SCHED-DESC    DELIMITED BY SIZE           
              INTO   WS-TEST-SCHED-DISP                                 
              PERFORM 7500-GET-MTR-CAP        THRU 7500-EXIT            
              PERFORM 2100-MOVE-RESULT-GAS    THRU 2100-EXIT            
              MOVE EQ-CRNT-LOC-NO             TO WS-PREMISE-NO          
           ELSE                                                         
              MOVE NOT-FOUND                  TO R1-RETURN-CODE         
           END-IF.                                                      
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00082300
      ******************************************************************00082400
      * 2400-PROCESS-ELEC-DETAILS                                      *00082500
      ******************************************************************00082600
       2400-PROCESS-ELEC-DETAILS.                                       
                                                                        
           MOVE WS-COMPANY-NO                 TO EQ-COMPANY-NO          
                                                 MC-COMPANY-NO.         
           MOVE WS-CODE-UTIL-TYPE             TO EQ-CODE-UTIL-TYPE      
                                                 MC-CODE-UTIL-TYPE.     
           MOVE WS-DEVICE-NO                  TO EQ-DEVICE-NO           
                                                 MC-METER-NO.           
                                                                        
           PERFORM 7200-SEL-ELEC-EQ-DET       THRU 7200-EXIT.           
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7500-GET-MTR-CAP        THRU 7500-EXIT            
              PERFORM 2200-MOVE-RESULT-ELEC   THRU 2200-EXIT            
              MOVE EQ-CRNT-LOC-NO             TO WS-PREMISE-NO          
           ELSE                                                         
              MOVE NOT-FOUND                  TO R2-RETURN-CODE         
           END-IF.                                                      
                                                                        
                                                                        
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00085100
      ******************************************************************00085200
      * 2500-GET-ADDRESS-INFO                                          *00085300
      ******************************************************************00085400
      *                                                                 00085500
       2500-GET-ADDRESS-INFO.                                           
                                                                        
           MOVE WS-PREMISE-NO                 TO PR-PREMISE-NO          
                                                 CH-PREMISE-NO.         
                                                                        
           PERFORM 7300-GET-PREMISE-DETAILS   THRU 7300-EXIT.           
           PERFORM 7400-GET-ACCOUNT-NO        THRU 7400-EXIT.           
                                                                        
           IF WS-CODE-UTIL-TYPE = 'G'                                   
              MOVE CH-ACCOUNT-NO              TO R1-ACCOUNT-NO          
              MOVE DY-ADDR-PREFIX-1           TO R1-ADDR-PREFIX-1       
              MOVE DY-ADDR-PREFIX-2           TO R1-ADDR-PREFIX-2       
              MOVE DY-HOUSE-NO                TO R1-HOUSE-NO            
              MOVE DY-STREET-LOCATION-1       TO R1-STREET-LOCATION-1   
              MOVE DY-STREET-LOCATION-2       TO R1-STREET-LOCATION-2   
              MOVE DY-STREET-NAME             TO R1-STREET-NAME         
              MOVE DY-STREET-SUFFIX           TO R1-STREET-SUFFIX       
              MOVE DY-ZIP-CODE                TO R1-ZIP-CODE            
              MOVE A4-STATE                   TO R1-STATE               
              MOVE A4-TOWN                    TO R1-TOWN                
           ELSE                                                         
              MOVE CH-ACCOUNT-NO              TO R2-ACCOUNT-NO          
              MOVE DY-ADDR-PREFIX-1           TO R2-ADDR-PREFIX-1       
              MOVE DY-ADDR-PREFIX-2           TO R2-ADDR-PREFIX-2       
              MOVE DY-HOUSE-NO                TO R2-HOUSE-NO            
              MOVE DY-STREET-LOCATION-1       TO R2-STREET-LOCATION-1   
              MOVE DY-STREET-LOCATION-2       TO R2-STREET-LOCATION-2   
              MOVE DY-STREET-NAME             TO R2-STREET-NAME         
              MOVE DY-STREET-SUFFIX           TO R2-STREET-SUFFIX       
              MOVE DY-ZIP-CODE                TO R2-ZIP-CODE            
              MOVE A4-STATE                   TO R2-STATE               
              MOVE A4-TOWN                    TO R2-TOWN                
           END-IF.                                                      
      *                                                                 00088900
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00089200
      ******************************************************************00089300
      *7100-SEL-GAS-EQ-DET                                             *00089400
      ******************************************************************00089500
      *                                                                 00089600
       7100-SEL-GAS-EQ-DET.                                             
      *                                                                 00089800
            EXEC SQL                                                    
              SELECT                                                    
                  GM.CODE_ATTACHMENTS                                   
                 ,GM.CASE_PRESSURE                                      
                 ,GM.MCF_CAP_PER_HR                                     
                 ,M5.CCF_CAP_PER_HR                                     
                 ,GM.METER_SIZE_ID                                      
                 ,GM.NUMBER_OF_DRIVE                                    
                 ,GM.CODE_METER_TYPE                                    
                 ,GM.MODEL_CD                                           
                 ,GM.CONNECTION_TYPE_CD                                 
                 ,GM.ALLOW_CONSTANT_FL                                  
                 ,GM.TEST_SCHED_CD                                      
                 ,GM.DIGTL_MTR_TYPE                                     
                 ,GM.PROGRAM_ID                                         
                 ,GM.LAST_TEST_SEL_DT                                   
                 ,GM.DATE_LAST_TESTED                                   
                 ,EQ.INSTALL_EMP_ID                                     
                 ,EQ.LOCAL_OFFICE                                       
                 ,W9.MTR_STORAGE_FAC_TX                                 
                 ,EQ.EQUIP_TYPE_CD                                      
                 ,EQ.PALETTE_NO                                         
                 ,EQ.SERIAL_NO                                          
                 ,EQ.CODE_CRNT_LOC                                      
                 ,EQ.CRNT_LOC_NO                                        
                 ,EQ.DATE_PURCHASED                                     
                 ,EQ.DATE_DISPOSED_OF                                   
                 ,EQ.WARRANTY_EXP_DT                                    
                 ,EQ.INSTALL_DT                                         
                 ,EQ.DATE_LAST_TRAN                                     
                 ,EQ.DATE_LAST_MOVE                                     
                 ,EQ.MFR_DT                                             
                 ,EQ.DATE_OBSOLETE                                      
                 ,EQ.EQUIP_COMMENTS_TX                                  
ACT002           ,EQ.FERC_ACCOUNT_NO                                    
                 ,M2.CODE_MAKE                                          
                 ,M2.EQUIP_MAKE_DESC                                    
                 ,M6.EQUIP_LOC_DESC                                     
                 ,M5.REMOTE_READ_CODE                                   
                 ,M5.CONDEMN_FLAG                                       
                 ,M5.CURB_METER_FL                                      
                 ,M5.MODEL_CD                                           
                 ,M5.METER_SIZE_DESC                                    
                 ,M5.METER_SIZE_ID                                      
                 ,M3.TEST_SCHED_DESC                                    
                 ,GM.CODE_CO_SIZE                                       
                INTO                                                    
                    :GM-CODE-ATTACHMENTS                                
                   ,:GM-CASE-PRESSURE                                   
                   ,:GM-MCF-CAP-PER-HR                                  
                   ,:M5-CCF-CAP-PER-HR                                  
                   ,:GM-METER-SIZE-ID                                   
                   ,:GM-NUMBER-OF-DRIVE                                 
                   ,:GM-CODE-METER-TYPE                                 
                   ,:GM-MODEL-CD                                        
                   ,:GM-CONNECTION-TYPE-CD                              
                   ,:GM-ALLOW-CONSTANT-FL                               
                   ,:GM-TEST-SCHED-CD                                   
                   ,:GM-DIGTL-MTR-TYPE                                  
                   ,:GM-PROGRAM-ID                                      
                   ,:GM-LAST-TEST-SEL-DT :WS-LAST-TEST-SEL-IND           
                   ,:GM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND        
                   ,:EQ-INSTALL-EMP-ID                                  
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:W9-MTR-STORAGE-FAC-TX :WS-MTR-STOR-FAC-TX-IND       
                   ,:EQ-EQUIP-TYPE-CD                                   
                   ,:EQ-PALETTE-NO                                      
                   ,:EQ-SERIAL-NO                                       
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:EQ-DATE-PURCHASED :WS-DATE-PURCHASED-IND            
                   ,:EQ-DATE-DISPOSED-OF :WS-DATE-DISPOSED-OF-IND        
                   ,:EQ-WARRANTY-EXP-DT :WS-WARRANTY-EXP-DT-IND          
                   ,:EQ-INSTALL-DT :WS-INSTALL-DT-IND                    
                   ,:EQ-DATE-LAST-TRAN :WS-DATE-LAST-TRAN-IND            
                   ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND            
                   ,:EQ-MFR-DT :WS-MFR-DT-IND                            
                   ,:EQ-DATE-OBSOLETE :WS-DATE-OBSOLETE-IND              
                   ,:EQ-EQUIP-COMMENTS-TX                               
ACT002             ,:EQ-FERC-ACCOUNT-NO                                 
                   ,:M2-CODE-MAKE                                       
                   ,:M2-EQUIP-MAKE-DESC                                 
                   ,:M6-EQUIP-LOC-DESC                                  
                   ,:M5-REMOTE-READ-CODE                                
                   ,:M5-CONDEMN-FLAG                                    
                   ,:M5-CURB-METER-FL                                   
                   ,:M5-MODEL-CD                                        
                   ,:M5-METER-SIZE-DESC                                 
                   ,:M5-METER-SIZE-ID                                   
                   ,:M3-TEST-SCHED-DESC :WS-TEST-SCHED-DESC-IND          
                   ,:GM-CODE-CO-SIZE                                    
               FROM                                                     
                  CSS_EQUIPMENT      EQ WITH(READUNCOMMITTED)                   
                  LEFT OUTER JOIN                                       
                  CSS_MTR_STORGE_FAC W9 WITH(READUNCOMMITTED)                   
                  ON (     W9.MTR_STORAGE_FAC_CD = EQ.LOCAL_OFFICE      
                       AND W9.COMPANY_NO         = EQ.COMPANY_NO        
                       AND W9.CODE_UTIL_TYPE     = EQ.CODE_UTIL_TYPE  ) 
                 ,CSS_GAS_METER      GM WITH(READUNCOMMITTED)                   
                  LEFT OUTER JOIN                                       
                  CSS_TEST_SCHEDULE  M3 WITH(READUNCOMMITTED)                   
                  ON ( M3.TEST_SCHED_CD = GM.TEST_SCHED_CD )            
                 ,CSS_EQUIP_MAKE     M2 WITH(READUNCOMMITTED)                   
                 ,CSS_EQUIP_LOCATION M6 WITH(READUNCOMMITTED)                   
                 ,CSS_GAS_METER_SIZE M5 WITH(READUNCOMMITTED)                   
              WHERE                                                     
                    EQ.COMPANY_NO     = :EQ-COMPANY-NO                  
                AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                   
                AND GM.COMPANY_NO     = EQ.COMPANY_NO                   
                AND GM.METER_NO       = EQ.DEVICE_NO                    
                AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE               
                AND M2.CODE_MAKE      = EQ.CODE_MAKE                    
                AND M6.EQUIP_LOC_ID   = EQ.CODE_CRNT_LOC                
                AND M6.COMPANY_NO     = EQ.COMPANY_NO                   
                AND M6.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE               
                AND M5.METER_SIZE_ID  = GM.METER_SIZE_ID                
                AND M5.COMPANY_NO     = GM.COMPANY_NO                   
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    00089900
MFA-TR*       SELECT                                                    00090000
MFA-TR*           GM.CODE_ATTACHMENTS                                   00090100
MFA-TR*          ,GM.CASE_PRESSURE                                      00090200
MFA-TR*          ,GM.MCF_CAP_PER_HR                                     00090300
MFA-TR*          ,M5.CCF_CAP_PER_HR                                     00090400
MFA-TR*          ,GM.METER_SIZE_ID                                      00090500
MFA-TR*          ,GM.NUMBER_OF_DRIVE                                    00090600
MFA-TR*          ,GM.CODE_METER_TYPE                                    00090700
MFA-TR*          ,GM.MODEL_CD                                           00090800
MFA-TR*          ,GM.CONNECTION_TYPE_CD                                 00090900
MFA-TR*          ,GM.ALLOW_CONSTANT_FL                                  00091000
MFA-TR*          ,GM.TEST_SCHED_CD                                      00091100
MFA-TR*          ,GM.DIGTL_MTR_TYPE                                     00091200
MFA-TR*          ,GM.PROGRAM_ID                                         00091300
MFA-TR*          ,GM.LAST_TEST_SEL_DT                                   00091400
MFA-TR*          ,GM.DATE_LAST_TESTED                                   00091500
MFA-TR*          ,EQ.INSTALL_EMP_ID                                     00091600
MFA-TR*          ,EQ.LOCAL_OFFICE                                       00091700
MFA-TR*          ,W9.MTR_STORAGE_FAC_TX                                 00091800
MFA-TR*          ,EQ.EQUIP_TYPE_CD                                      00091900
MFA-TR*          ,EQ.PALETTE_NO                                         00092000
MFA-TR*          ,EQ.SERIAL_NO                                          00092100
MFA-TR*          ,EQ.CODE_CRNT_LOC                                      00092200
MFA-TR*          ,EQ.CRNT_LOC_NO                                        00092300
MFA-TR*          ,EQ.DATE_PURCHASED                                     00092400
MFA-TR*          ,EQ.DATE_DISPOSED_OF                                   00092500
MFA-TR*          ,EQ.WARRANTY_EXP_DT                                    00092600
MFA-TR*          ,EQ.INSTALL_DT                                         00092700
MFA-TR*          ,EQ.DATE_LAST_TRAN                                     00092800
MFA-TR*          ,EQ.DATE_LAST_MOVE                                     00092900
MFA-TR*          ,EQ.MFR_DT                                             00093000
MFA-TR*          ,EQ.DATE_OBSOLETE                                      00093100
MFA-TR*          ,EQ.EQUIP_COMMENTS_TX                                  00093200
MFA-TR*          ,EQ.FERC_ACCOUNT_NO                                    00093300
MFA-TR*          ,M2.CODE_MAKE                                          00093400
MFA-TR*          ,M2.EQUIP_MAKE_DESC                                    00093500
MFA-TR*          ,M6.EQUIP_LOC_DESC                                     00093600
MFA-TR*          ,M5.REMOTE_READ_CODE                                   00093700
MFA-TR*          ,M5.CONDEMN_FLAG                                       00093800
MFA-TR*          ,M5.CURB_METER_FL                                      00093900
MFA-TR*          ,M5.MODEL_CD                                           00094000
MFA-TR*          ,M5.METER_SIZE_DESC                                    00094100
MFA-TR*          ,M5.METER_SIZE_ID                                      00094200
MFA-TR*          ,M3.TEST_SCHED_DESC                                    00094300
MFA-TR*          ,GM.CODE_CO_SIZE                                       00094400
MFA-TR*         INTO                                                    00094500
MFA-TR*             :GM-CODE-ATTACHMENTS                                00094600
MFA-TR*            ,:GM-CASE-PRESSURE                                   00094700
MFA-TR*            ,:GM-MCF-CAP-PER-HR                                  00094800
MFA-TR*            ,:M5-CCF-CAP-PER-HR                                  00094900
MFA-TR*            ,:GM-METER-SIZE-ID                                   00095000
MFA-TR*            ,:GM-NUMBER-OF-DRIVE                                 00095100
MFA-TR*            ,:GM-CODE-METER-TYPE                                 00095200
MFA-TR*            ,:GM-MODEL-CD                                        00095300
MFA-TR*            ,:GM-CONNECTION-TYPE-CD                              00095400
MFA-TR*            ,:GM-ALLOW-CONSTANT-FL                               00095500
MFA-TR*            ,:GM-TEST-SCHED-CD                                   00095600
MFA-TR*            ,:GM-DIGTL-MTR-TYPE                                  00095700
MFA-TR*            ,:GM-PROGRAM-ID                                      00095800
MFA-TR*            ,:GM-LAST-TEST-SEL-DT:WS-LAST-TEST-SEL-IND           00095900
MFA-TR*            ,:GM-DATE-LAST-TESTED:WS-DATE-LAST-TESTED-IND        00096000
MFA-TR*            ,:EQ-INSTALL-EMP-ID                                  00096100
MFA-TR*            ,:EQ-LOCAL-OFFICE                                    00096200
MFA-TR*            ,:W9-MTR-STORAGE-FAC-TX:WS-MTR-STOR-FAC-TX-IND       00096300
MFA-TR*            ,:EQ-EQUIP-TYPE-CD                                   00096400
MFA-TR*            ,:EQ-PALETTE-NO                                      00096500
MFA-TR*            ,:EQ-SERIAL-NO                                       00096600
MFA-TR*            ,:EQ-CODE-CRNT-LOC                                   00096700
MFA-TR*            ,:EQ-CRNT-LOC-NO                                     00096800
MFA-TR*            ,:EQ-DATE-PURCHASED:WS-DATE-PURCHASED-IND            00096900
MFA-TR*            ,:EQ-DATE-DISPOSED-OF:WS-DATE-DISPOSED-OF-IND        00097000
MFA-TR*            ,:EQ-WARRANTY-EXP-DT:WS-WARRANTY-EXP-DT-IND          00097100
MFA-TR*            ,:EQ-INSTALL-DT:WS-INSTALL-DT-IND                    00097200
MFA-TR*            ,:EQ-DATE-LAST-TRAN:WS-DATE-LAST-TRAN-IND            00097300
MFA-TR*            ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-IND            00097400
MFA-TR*            ,:EQ-MFR-DT:WS-MFR-DT-IND                            00097500
MFA-TR*            ,:EQ-DATE-OBSOLETE:WS-DATE-OBSOLETE-IND              00097600
MFA-TR*            ,:EQ-EQUIP-COMMENTS-TX                               00097700
MFA-TR*            ,:EQ-FERC-ACCOUNT-NO                                 00097800
MFA-TR*            ,:M2-CODE-MAKE                                       00097900
MFA-TR*            ,:M2-EQUIP-MAKE-DESC                                 00098000
MFA-TR*            ,:M6-EQUIP-LOC-DESC                                  00098100
MFA-TR*            ,:M5-REMOTE-READ-CODE                                00098200
MFA-TR*            ,:M5-CONDEMN-FLAG                                    00098300
MFA-TR*            ,:M5-CURB-METER-FL                                   00098400
MFA-TR*            ,:M5-MODEL-CD                                        00098500
MFA-TR*            ,:M5-METER-SIZE-DESC                                 00098600
MFA-TR*            ,:M5-METER-SIZE-ID                                   00098700
MFA-TR*            ,:M3-TEST-SCHED-DESC:WS-TEST-SCHED-DESC-IND          00098800
MFA-TR*            ,:GM-CODE-CO-SIZE                                    00098900
MFA-TR*        FROM                                                     00099000
MFA-TR*           CSS_EQUIPMENT      EQ                                 00099100
MFA-TR*           LEFT OUTER JOIN                                       00099200
MFA-TR*           CSS_MTR_STORGE_FAC W9                                 00099300
MFA-TR*           ON (     W9.MTR_STORAGE_FAC_CD = EQ.LOCAL_OFFICE      00099400
MFA-TR*                AND W9.COMPANY_NO         = EQ.COMPANY_NO        00099500
MFA-TR*                AND W9.CODE_UTIL_TYPE     = EQ.CODE_UTIL_TYPE  ) 00099600
MFA-TR*          ,CSS_GAS_METER      GM                                 00099700
MFA-TR*           LEFT OUTER JOIN                                       00099800
MFA-TR*           CSS_TEST_SCHEDULE  M3                                 00099900
MFA-TR*           ON ( M3.TEST_SCHED_CD = GM.TEST_SCHED_CD )            00100000
MFA-TR*          ,CSS_EQUIP_MAKE     M2                                 00100100
MFA-TR*          ,CSS_EQUIP_LOCATION M6                                 00100200
MFA-TR*          ,CSS_GAS_METER_SIZE M5                                 00100300
MFA-TR*       WHERE                                                     00100400
MFA-TR*             EQ.COMPANY_NO     = :EQ-COMPANY-NO                  00100500
MFA-TR*         AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              00100600
MFA-TR*         AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                   00100700
MFA-TR*         AND GM.COMPANY_NO     = EQ.COMPANY_NO                   00100800
MFA-TR*         AND GM.METER_NO       = EQ.DEVICE_NO                    00100900
MFA-TR*         AND GM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE               00101000
MFA-TR*         AND M2.CODE_MAKE      = EQ.CODE_MAKE                    00101100
MFA-TR*         AND M6.EQUIP_LOC_ID   = EQ.CODE_CRNT_LOC                00101200
MFA-TR*         AND M6.COMPANY_NO     = EQ.COMPANY_NO                   00101300
MFA-TR*         AND M6.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE               00101400
MFA-TR*         AND M5.METER_SIZE_ID  = GM.METER_SIZE_ID                00101500
MFA-TR*         AND M5.COMPANY_NO     = GM.COMPANY_NO                   00101600
MFA-TR*        WITH UR                                                  00101700
MFA-TR*     END-EXEC.                                                   00101800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7100'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_EQUIPMENT'       TO TABLE-1                   
                MOVE 'CSS_GAS_METER'       TO TABLE-2                   
                MOVE 'CSS_EQUIP_MAKE'      TO TABLE-3                   
                MOVE 'CSS_EQUIP_LOCATION'  TO TABLE-4                   
                MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3           
                MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-1         
                MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00104400
      ******************************************************************00104500
      * 7200-SEL-ELEC-EQ-DET                                           *00104600
      ******************************************************************00104700
      *                                                                 00104800
       7200-SEL-ELEC-EQ-DET.                                            
      *                                                                 00105000
            EXEC SQL                                                    
              SELECT                                                    
                  EQ.SERIAL_NO                                          
                 ,EQ.INSTALL_EMP_ID                                     
                 ,EQ.EQUIP_TYPE_CD                                      
                 ,EQ.PALETTE_NO                                         
                 ,EQ.CODE_MAKE                                          
                 ,EQ.DATE_PURCHASED                                     
                 ,EQ.DATE_DISPOSED_OF                                   
                 ,EQ.WARRANTY_EXP_DT                                    
                 ,EQ.DATE_LAST_TRAN                                     
                 ,EQ.DATE_LAST_MOVE                                     
                 ,EQ.MFR_DT                                             
                 ,EQ.DATE_OBSOLETE                                      
                 ,EQ.HAZARD_MATERIAL_CD                                 
                 ,EQ.CODE_CRNT_LOC                                      
                 ,EQ.CRNT_LOC_NO                                        
                 ,EQ.LOCAL_OFFICE                                       
                 ,EQ.EQUIP_COMMENTS_TX                                  
ACT002           ,EQ.FERC_ACCOUNT_NO                                    
                 ,EM.AMPS                                               
                 ,EM.CODE_GEAR_REDUCTN                                  
                 ,EM.KH_OR_KE                                           
                 ,EM.REG_LOWER_FRACTION                                 
                 ,EM.REG_UPPER_FRACTION                                 
                 ,EM.REG_NO                                             
                 ,EM.DIGTL_MTR_TYPE                                     
                 ,EM.ELEC_MTR_CLASS_CD                                  
                 ,EM.ELEC_MTR_SPEC_CD                                   
                 ,EM.NO_WIRES                                           
                 ,EM.NO_PHASES                                          
                 ,EM.VOLTAGE                                            
                 ,EM.CODE_ATTACHMENTS                                   
                 ,EM.MTR_CONNECT_TYP_ID                                 
                 ,EM.DEVICE_TYPE_CD                                     
                 ,EM.WATTS_PER_PULSE                                    
                 ,EM.PULSES_PER_REV                                     
                 ,EM.TEST_SCHED_CD                                      
                 ,EM.PROGRAM_ID                                         
                 ,EM.CODE_METER_TYPE                                    
                 ,EM.DATE_LAST_TESTED                                   
                 ,EM.METER_SIZE_ID                                      
                 ,EM.TOU_RATE_IND                                       
                 ,EM.OVERRIDE_CONST_FL                                  
                 ,EM.IDR_MEMORY_SIZE                                    
                 ,M2.EQUIP_MAKE_DESC                                    
P00447           ,U0.CT_METER_FL                                        
                INTO                                                    
                    :EQ-SERIAL-NO                                       
                   ,:EQ-INSTALL-EMP-ID                                  
                   ,:EQ-EQUIP-TYPE-CD                                   
                   ,:EQ-PALETTE-NO                                      
                   ,:EQ-CODE-MAKE                                       
                   ,:EQ-DATE-PURCHASED :WS-DATE-PURCHASED-IND            
                   ,:EQ-DATE-DISPOSED-OF :WS-DATE-DISPOSED-OF-IND        
                   ,:EQ-WARRANTY-EXP-DT :WS-WARRANTY-EXP-DT-IND          
                   ,:EQ-DATE-LAST-TRAN :WS-DATE-LAST-TRAN-IND            
                   ,:EQ-DATE-LAST-MOVE :WS-DATE-LAST-MOVE-IND            
                   ,:EQ-MFR-DT :WS-MFR-DT-IND                            
                   ,:EQ-DATE-OBSOLETE :WS-DATE-OBSOLETE-IND              
                   ,:EQ-HAZARD-MATERIAL-CD                              
                   ,:EQ-CODE-CRNT-LOC                                   
                   ,:EQ-CRNT-LOC-NO                                     
                   ,:EQ-LOCAL-OFFICE                                    
                   ,:EQ-EQUIP-COMMENTS-TX                               
ACT002             ,:EQ-FERC-ACCOUNT-NO                                 
                   ,:EM-AMPS                                            
                   ,:EM-CODE-GEAR-REDUCTN                               
                   ,:EM-KH-OR-KE                                        
                   ,:EM-REG-LOWER-FRACTION                              
                   ,:EM-REG-UPPER-FRACTION                              
                   ,:EM-REG-NO                                          
                   ,:EM-DIGTL-MTR-TYPE                                  
                   ,:EM-ELEC-MTR-CLASS-CD                               
                   ,:EM-ELEC-MTR-SPEC-CD                                
                   ,:EM-NO-WIRES                                        
                   ,:EM-NO-PHASES                                       
                   ,:EM-VOLTAGE                                         
                   ,:EM-CODE-ATTACHMENTS                                
                   ,:EM-MTR-CONNECT-TYP-ID                              
                   ,:EM-DEVICE-TYPE-CD                                  
                   ,:EM-WATTS-PER-PULSE                                 
                   ,:EM-PULSES-PER-REV                                  
                   ,:EM-TEST-SCHED-CD                                   
                   ,:EM-PROGRAM-ID                                      
                   ,:EM-CODE-METER-TYPE                                 
                   ,:EM-DATE-LAST-TESTED :WS-DATE-LAST-TESTED-IND        
                   ,:EM-METER-SIZE-ID                                   
                   ,:EM-TOU-RATE-IND                                    
                   ,:EM-OVERRIDE-CONST-FL                               
                   ,:EM-IDR-MEMORY-SIZE                                 
                   ,:M2-EQUIP-MAKE-DESC                                 
P00447             ,:U0-CT-METER-FL                                     
               FROM                                                     
                  CSS_EQUIPMENT  EQ WITH(READUNCOMMITTED)                       
                 ,CSS_ELEC_METER EM WITH(READUNCOMMITTED)                       
                 ,CSS_EQUIP_MAKE M2 WITH(READUNCOMMITTED)                       
P00447           ,CSS_ELEC_CL_SPEC U0 WITH(READUNCOMMITTED)                     
              WHERE                                                     
                    EQ.COMPANY_NO     = :EQ-COMPANY-NO                  
                AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              
                AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                   
                AND EM.COMPANY_NO     = EQ.COMPANY_NO                   
                AND EM.METER_NO       = EQ.DEVICE_NO                    
                AND EM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE               
                AND M2.CODE_MAKE      = EQ.CODE_MAKE                    
P00447          AND U0.ELEC_MTR_CLASS_CD = EM.ELEC_MTR_CLASS_CD         
P00447          AND U0.ELEC_MTR_SPEC_CD = EM.ELEC_MTR_SPEC_CD           
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    00105100
MFA-TR*       SELECT                                                    00105200
MFA-TR*           EQ.SERIAL_NO                                          00105300
MFA-TR*          ,EQ.INSTALL_EMP_ID                                     00105400
MFA-TR*          ,EQ.EQUIP_TYPE_CD                                      00105500
MFA-TR*          ,EQ.PALETTE_NO                                         00105600
MFA-TR*          ,EQ.CODE_MAKE                                          00105700
MFA-TR*          ,EQ.DATE_PURCHASED                                     00105800
MFA-TR*          ,EQ.DATE_DISPOSED_OF                                   00105900
MFA-TR*          ,EQ.WARRANTY_EXP_DT                                    00106000
MFA-TR*          ,EQ.DATE_LAST_TRAN                                     00106100
MFA-TR*          ,EQ.DATE_LAST_MOVE                                     00106200
MFA-TR*          ,EQ.MFR_DT                                             00106300
MFA-TR*          ,EQ.DATE_OBSOLETE                                      00106400
MFA-TR*          ,EQ.HAZARD_MATERIAL_CD                                 00106500
MFA-TR*          ,EQ.CODE_CRNT_LOC                                      00106600
MFA-TR*          ,EQ.CRNT_LOC_NO                                        00106700
MFA-TR*          ,EQ.LOCAL_OFFICE                                       00106800
MFA-TR*          ,EQ.EQUIP_COMMENTS_TX                                  00106900
MFA-TR*          ,EQ.FERC_ACCOUNT_NO                                    00107000
MFA-TR*          ,EM.AMPS                                               00107100
MFA-TR*          ,EM.CODE_GEAR_REDUCTN                                  00107200
MFA-TR*          ,EM.KH_OR_KE                                           00107300
MFA-TR*          ,EM.REG_LOWER_FRACTION                                 00107400
MFA-TR*          ,EM.REG_UPPER_FRACTION                                 00107500
MFA-TR*          ,EM.REG_NO                                             00107600
MFA-TR*          ,EM.DIGTL_MTR_TYPE                                     00107700
MFA-TR*          ,EM.ELEC_MTR_CLASS_CD                                  00107800
MFA-TR*          ,EM.ELEC_MTR_SPEC_CD                                   00107900
MFA-TR*          ,EM.NO_WIRES                                           00108000
MFA-TR*          ,EM.NO_PHASES                                          00108100
MFA-TR*          ,EM.VOLTAGE                                            00108200
MFA-TR*          ,EM.CODE_ATTACHMENTS                                   00108300
MFA-TR*          ,EM.MTR_CONNECT_TYP_ID                                 00108400
MFA-TR*          ,EM.DEVICE_TYPE_CD                                     00108500
MFA-TR*          ,EM.WATTS_PER_PULSE                                    00108600
MFA-TR*          ,EM.PULSES_PER_REV                                     00108700
MFA-TR*          ,EM.TEST_SCHED_CD                                      00108800
MFA-TR*          ,EM.PROGRAM_ID                                         00108900
MFA-TR*          ,EM.CODE_METER_TYPE                                    00109000
MFA-TR*          ,EM.DATE_LAST_TESTED                                   00109100
MFA-TR*          ,EM.METER_SIZE_ID                                      00109200
MFA-TR*          ,EM.TOU_RATE_IND                                       00109300
MFA-TR*          ,EM.OVERRIDE_CONST_FL                                  00109400
MFA-TR*          ,EM.IDR_MEMORY_SIZE                                    00109500
MFA-TR*          ,M2.EQUIP_MAKE_DESC                                    00109600
MFA-TR*          ,U0.CT_METER_FL                                        00109700
MFA-TR*         INTO                                                    00109800
MFA-TR*             :EQ-SERIAL-NO                                       00109900
MFA-TR*            ,:EQ-INSTALL-EMP-ID                                  00110000
MFA-TR*            ,:EQ-EQUIP-TYPE-CD                                   00110100
MFA-TR*            ,:EQ-PALETTE-NO                                      00110200
MFA-TR*            ,:EQ-CODE-MAKE                                       00110300
MFA-TR*            ,:EQ-DATE-PURCHASED:WS-DATE-PURCHASED-IND            00110400
MFA-TR*            ,:EQ-DATE-DISPOSED-OF:WS-DATE-DISPOSED-OF-IND        00110500
MFA-TR*            ,:EQ-WARRANTY-EXP-DT:WS-WARRANTY-EXP-DT-IND          00110600
MFA-TR*            ,:EQ-DATE-LAST-TRAN:WS-DATE-LAST-TRAN-IND            00110700
MFA-TR*            ,:EQ-DATE-LAST-MOVE:WS-DATE-LAST-MOVE-IND            00110800
MFA-TR*            ,:EQ-MFR-DT:WS-MFR-DT-IND                            00110900
MFA-TR*            ,:EQ-DATE-OBSOLETE:WS-DATE-OBSOLETE-IND              00111000
MFA-TR*            ,:EQ-HAZARD-MATERIAL-CD                              00111100
MFA-TR*            ,:EQ-CODE-CRNT-LOC                                   00111200
MFA-TR*            ,:EQ-CRNT-LOC-NO                                     00111300
MFA-TR*            ,:EQ-LOCAL-OFFICE                                    00111400
MFA-TR*            ,:EQ-EQUIP-COMMENTS-TX                               00111500
MFA-TR*            ,:EQ-FERC-ACCOUNT-NO                                 00111600
MFA-TR*            ,:EM-AMPS                                            00111700
MFA-TR*            ,:EM-CODE-GEAR-REDUCTN                               00111800
MFA-TR*            ,:EM-KH-OR-KE                                        00111900
MFA-TR*            ,:EM-REG-LOWER-FRACTION                              00112000
MFA-TR*            ,:EM-REG-UPPER-FRACTION                              00112100
MFA-TR*            ,:EM-REG-NO                                          00112200
MFA-TR*            ,:EM-DIGTL-MTR-TYPE                                  00112300
MFA-TR*            ,:EM-ELEC-MTR-CLASS-CD                               00112400
MFA-TR*            ,:EM-ELEC-MTR-SPEC-CD                                00112500
MFA-TR*            ,:EM-NO-WIRES                                        00112600
MFA-TR*            ,:EM-NO-PHASES                                       00112700
MFA-TR*            ,:EM-VOLTAGE                                         00112800
MFA-TR*            ,:EM-CODE-ATTACHMENTS                                00112900
MFA-TR*            ,:EM-MTR-CONNECT-TYP-ID                              00113000
MFA-TR*            ,:EM-DEVICE-TYPE-CD                                  00113100
MFA-TR*            ,:EM-WATTS-PER-PULSE                                 00113200
MFA-TR*            ,:EM-PULSES-PER-REV                                  00113300
MFA-TR*            ,:EM-TEST-SCHED-CD                                   00113400
MFA-TR*            ,:EM-PROGRAM-ID                                      00113500
MFA-TR*            ,:EM-CODE-METER-TYPE                                 00113600
MFA-TR*            ,:EM-DATE-LAST-TESTED:WS-DATE-LAST-TESTED-IND        00113700
MFA-TR*            ,:EM-METER-SIZE-ID                                   00113800
MFA-TR*            ,:EM-TOU-RATE-IND                                    00113900
MFA-TR*            ,:EM-OVERRIDE-CONST-FL                               00114000
MFA-TR*            ,:EM-IDR-MEMORY-SIZE                                 00114100
MFA-TR*            ,:M2-EQUIP-MAKE-DESC                                 00114200
MFA-TR*            ,:U0-CT-METER-FL                                     00114300
MFA-TR*        FROM                                                     00114400
MFA-TR*           CSS_EQUIPMENT  EQ                                     00114500
MFA-TR*          ,CSS_ELEC_METER EM                                     00114600
MFA-TR*          ,CSS_EQUIP_MAKE M2                                     00114700
MFA-TR*          ,CSS_ELEC_CL_SPEC U0                                   00114800
MFA-TR*       WHERE                                                     00114900
MFA-TR*             EQ.COMPANY_NO     = :EQ-COMPANY-NO                  00115000
MFA-TR*         AND EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE              00115100
MFA-TR*         AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                   00115200
MFA-TR*         AND EM.COMPANY_NO     = EQ.COMPANY_NO                   00115300
MFA-TR*         AND EM.METER_NO       = EQ.DEVICE_NO                    00115400
MFA-TR*         AND EM.CODE_UTIL_TYPE = EQ.CODE_UTIL_TYPE               00115500
MFA-TR*         AND M2.CODE_MAKE      = EQ.CODE_MAKE                    00115600
MFA-TR*         AND U0.ELEC_MTR_CLASS_CD = EM.ELEC_MTR_CLASS_CD         00115700
MFA-TR*         AND U0.ELEC_MTR_SPEC_CD = EM.ELEC_MTR_SPEC_CD           00115800
MFA-TR*        WITH UR                                                  00115900
MFA-TR*     END-EXEC.                                                   00116000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7200'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_EQUIPMENT'       TO TABLE-1                   
                MOVE 'CSS_ELEC_METER'      TO TABLE-2                   
                MOVE 'CSS_EQUIP_MAKE'      TO TABLE-3                   
                MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3           
                MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-1         
                MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00118500
      ******************************************************************00118600
      * 7300-GET-PREMISE-DETAILS                                       *00118700
      ******************************************************************00118800
      *                                                                 00118900
       7300-GET-PREMISE-DETAILS.                                        
      *                                                                 00119100
            EXEC SQL                                                    
                SELECT                                                  
                    DY.ADDR_PREFIX_1                                    
                   ,DY.ADDR_PREFIX_2                                    
                   ,DY.HOUSE_NO                                         
                   ,DY.STREET_LOCATION_1                                
                   ,DY.STREET_LOCATION_2                                
                   ,DY.STREET_NAME                                      
                   ,DY.STREET_SUFFIX                                    
                   ,DY.ZIP_CODE                                         
                   ,A4.STATE                                            
                   ,A4.TOWN                                             
                INTO                                                    
                    :DY-ADDR-PREFIX-1                                   
                   ,:DY-ADDR-PREFIX-2                                   
                   ,:DY-HOUSE-NO                                        
                   ,:DY-STREET-LOCATION-1                               
                   ,:DY-STREET-LOCATION-2                               
                   ,:DY-STREET-NAME                                     
                   ,:DY-STREET-SUFFIX                                   
                   ,:DY-ZIP-CODE                                        
                   ,:A4-STATE                                           
                   ,:A4-TOWN                                            
                FROM                                                    
                    CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                 
                   ,CSS_ZIP_CODE       A4 WITH(READUNCOMMITTED)                 
                   ,CSS_PREMISE        PR WITH(READUNCOMMITTED)                 
                WHERE                                                   
                      DY.ZIP_CODE       = A4.ZIP_CODE                   
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                  AND DY.ADDRESS_ID     = PR.ADDRESS_ID                 
                  AND PR.PREMISE_NO     = :PR-PREMISE-NO                
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    00119200
MFA-TR*         SELECT                                                  00119300
MFA-TR*             DY.ADDR_PREFIX_1                                    00119400
MFA-TR*            ,DY.ADDR_PREFIX_2                                    00119500
MFA-TR*            ,DY.HOUSE_NO                                         00119600
MFA-TR*            ,DY.STREET_LOCATION_1                                00119700
MFA-TR*            ,DY.STREET_LOCATION_2                                00119800
MFA-TR*            ,DY.STREET_NAME                                      00119900
MFA-TR*            ,DY.STREET_SUFFIX                                    00120000
MFA-TR*            ,DY.ZIP_CODE                                         00120100
MFA-TR*            ,A4.STATE                                            00120200
MFA-TR*            ,A4.TOWN                                             00120300
MFA-TR*         INTO                                                    00120400
MFA-TR*             :DY-ADDR-PREFIX-1                                   00120500
MFA-TR*            ,:DY-ADDR-PREFIX-2                                   00120600
MFA-TR*            ,:DY-HOUSE-NO                                        00120700
MFA-TR*            ,:DY-STREET-LOCATION-1                               00120800
MFA-TR*            ,:DY-STREET-LOCATION-2                               00120900
MFA-TR*            ,:DY-STREET-NAME                                     00121000
MFA-TR*            ,:DY-STREET-SUFFIX                                   00121100
MFA-TR*            ,:DY-ZIP-CODE                                        00121200
MFA-TR*            ,:A4-STATE                                           00121300
MFA-TR*            ,:A4-TOWN                                            00121400
MFA-TR*         FROM                                                    00121500
MFA-TR*             CSS_ADDR_FORMATTED DY                               00121600
MFA-TR*            ,CSS_ZIP_CODE       A4                               00121700
MFA-TR*            ,CSS_PREMISE        PR                               00121800
MFA-TR*         WHERE                                                   00121900
MFA-TR*               DY.ZIP_CODE       = A4.ZIP_CODE                   00122000
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             00122100
MFA-TR*           AND DY.ADDRESS_ID     = PR.ADDRESS_ID                 00122200
MFA-TR*           AND PR.PREMISE_NO     = :PR-PREMISE-NO                00122300
MFA-TR*          WITH UR                                                00122400
MFA-TR*     END-EXEC.                                                   00122500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7300'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                   
                MOVE 'CSS_ZIP_CODE'        TO TABLE-2                   
                MOVE 'CSS_PREMISE'         TO TABLE-3                   
                MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3           
                MOVE 'DEVICE_NO'           TO TABLE-ELEMENT-4           
                MOVE PR-PREMISE-NO         TO HOSTVAR-ELEMENT-1         
                MOVE EQ-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE EQ-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3         
                MOVE EQ-DEVICE-NO          TO HOSTVAR-ELEMENT-4         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00125200
      ******************************************************************00125300
      * 7400-GET-ACCOUNT-NO                                            *00125400
      ******************************************************************00125500
      *                                                                 00125600
       7400-GET-ACCOUNT-NO.                                             
      *                                                                 00125800
            EXEC SQL                                                    
                SELECT TOP(1) CH.ACCOUNT_NO                                     
                INTO                                                    
                    :CH-ACCOUNT-NO                                      
                FROM                                                    
                    CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)                 
                   ,CSS_ACCOUNT        AT WITH(READUNCOMMITTED)                 
                WHERE                                                   
                      CH.ACCOUNT_NO     = AT.ACCOUNT_NO                 
                  AND CH.PREMISE_NO     = :CH-PREMISE-NO                
                ORDER BY DATE_UTIL_SVC_STRT DESC                        
                                             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    00125900
MFA-TR*         SELECT                                                  00126000
MFA-TR*             CH.ACCOUNT_NO                                       00126100
MFA-TR*         INTO                                                    00126200
MFA-TR*             :CH-ACCOUNT-NO                                      00126300
MFA-TR*         FROM                                                    00126400
MFA-TR*             CSS_CUST_PREM_HIST CH                               00126500
MFA-TR*            ,CSS_ACCOUNT        AT                               00126600
MFA-TR*         WHERE                                                   00126700
MFA-TR*               CH.ACCOUNT_NO     = AT.ACCOUNT_NO                 00126800
MFA-TR*           AND CH.PREMISE_NO     = :CH-PREMISE-NO                00126900
MFA-TR*         ORDER BY DATE_UTIL_SVC_STRT DESC                        00127000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            00127100
MFA-TR*     END-EXEC.                                                   00127200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE 0                   TO CH-ACCOUNT-NO             
               END-IF                                                   
            ELSE                                                        
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7400'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_CUST_PREM_HIST'  TO TABLE-1                   
                MOVE 'CSS_ACCOUNT'         TO TABLE-2                   
                MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1           
                MOVE CH-PREMISE-NO         TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7400-EXIT.                                                       
            EXIT.                                                       
      *                                                                 00129400
      ******************************************************************00129500
      * 7500-GET-MTR-CAP                                               *00129600
      ******************************************************************00129700
      *                                                                 00129800
       7500-GET-MTR-CAP.                                                
      *                                                                 00130000
            EXEC SQL                                                    
                SELECT TOP(1) CONSTANT,
              REG_ID_NO,
              NO_READ_DIALS,
              NO_DIALS,
              REG_MEASURES_CD                                     
                INTO                                                    
                    :MC-CONSTANT                                        
                   ,:MC-REG-ID-NO                                       
                   ,:MC-NO-READ-DIALS                                   
                   ,:MC-NO-DIALS                                        
                   ,:MC-REG-MEASURES-CD                                 
                FROM                                                    
                   CSS_MTR_CAP WITH(READUNCOMMITTED)                            
                WHERE                                                   
                      COMPANY_NO     = :MC-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE               
                  AND METER_NO       = :MC-METER-NO                     
                ORDER BY REG_ID_NO                                      
                                             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    00130100
MFA-TR*         SELECT                                                  00130200
MFA-TR*             CONSTANT                                            00130300
MFA-TR*            ,REG_ID_NO                                           00130400
MFA-TR*            ,NO_READ_DIALS                                       00130500
MFA-TR*            ,NO_DIALS                                            00130600
MFA-TR*            ,REG_MEASURES_CD                                     00130700
MFA-TR*         INTO                                                    00130800
MFA-TR*             :MC-CONSTANT                                        00130900
MFA-TR*            ,:MC-REG-ID-NO                                       00131000
MFA-TR*            ,:MC-NO-READ-DIALS                                   00131100
MFA-TR*            ,:MC-NO-DIALS                                        00131200
MFA-TR*            ,:MC-REG-MEASURES-CD                                 00131300
MFA-TR*         FROM                                                    00131400
MFA-TR*            CSS_MTR_CAP                                          00131500
MFA-TR*         WHERE                                                   00131600
MFA-TR*               COMPANY_NO     = :MC-COMPANY-NO                   00131700
MFA-TR*           AND CODE_UTIL_TYPE = :MC-CODE-UTIL-TYPE               00131800
MFA-TR*           AND METER_NO       = :MC-METER-NO                     00131900
MFA-TR*         ORDER BY REG_ID_NO                                      00132000
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            00132100
MFA-TR*     END-EXEC.                                                   00132200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                     MOVE  'Y'             TO WS-MTR-CAP-FLAG           
                ELSE                                                    
                     MOVE  0               TO MC-CONSTANT               
                     MOVE  0               TO MC-NO-READ-DIALS          
                     MOVE  0               TO MC-NO-DIALS               
                     MOVE  SPACES          TO MC-REG-MEASURES-CD        
                END-IF                                                  
            ELSE                                                        
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7500'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_MTR_CAP'         TO TABLE-1                   
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1           
                MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2           
                MOVE 'METER_NO'            TO TABLE-ELEMENT-3           
                MOVE MC-COMPANY-NO         TO HOSTVAR-ELEMENT-1         
                MOVE MC-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2         
                MOVE MC-METER-NO           TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************00135200
      *   8900-SEND-DONE                                               *00135300
      ******************************************************************00135400
       8900-SEND-DONE.                                                  
      *                                                                 00135600
           IF WS-CODE-UTIL-TYPE = 'G'                                   
              EXEC SQL                                                  
                 OPEN C1                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           ELSE                                                         
              EXEC SQL                                                  
                 OPEN C2                                                
              END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                  
           END-IF.                                                      
      *                                                                 00136600
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00136900
      * 9000-SEND-ERROR-RESULT                                         *00137000
      ******************************************************************00137100
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 00137300
           MOVE 'N'                   TO SEND-DONE-SW.                  
                                                                        
           IF WS-CODE-UTIL-TYPE = 'G'                                   
              INITIALIZE TDS-RETURN-FIELDS-R1                           
              MOVE WS-ACTIVE-RETURN-CODE TO R1-RETURN-CODE              
           ELSE                                                         
              INITIALIZE TDS-RETURN-FIELDS-R2                           
              MOVE WS-ACTIVE-RETURN-CODE TO R2-RETURN-CODE              
           END-IF.                                                      
           MOVE WS-ACTIVE-RETURN-CODE    TO ABEND-SQLCODE.              
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 00138500
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00138900
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 00139500
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00139800
      ******************************************************************00139900
      *   9999-END-PROGRAM                                             *00140000
      ******************************************************************00140100
      *                                                                 00140200
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************00140600
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *00140700
      ******************************************************************00140800
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 00142600
      ******************************************************************00142700
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *00142800
      ******************************************************************00142900
           EXEC SQL                                                     00143000
              INCLUDE CPDSP300                                          00143100
           END-EXEC.                                                    00143200
                                                                        
                                                                        
