       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04159.                                          
COB303 DATE-WRITTEN.      AUGUST 26, 2008.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  DRIVER PROGRAM FOR WEB ROOMMATE / 3RD PARTY UPDATES.          *        
      *  STATUS CODE VALUES ARE:                                       *        
      *        100      NAME MISMATCH                                  *        
      *        150      SSN DOES NOT EXIST WHEN WEB THINKS IS DOES     *        
      *        300      DUPLICATE ROOMMATE                             *        
      *        320      CUSTOMER EXISTS AS COAPPLICANT                 *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/26/08    FMB      NEW PROGRAM.                                      
P00172*  07/02/09    FMB      ADD DHR_FL TO CSR02203 CALL.                      
A01832*  10/29/09    FMB      PASS CUSTOMER NUMBER OF ACCOUNT GETTING           
A01832*                       ROOMMATE INTO CSR02557 SO WQ WILL BE ON           
A01832*                       CORRECT CUSTOMER NUMBER.                          
P00422*  09/08/10    FMB      ADD LANDLORD_REVERT_FL TO CSR02203 CALL.          
A01360*  12/14/10   DB18339   ADDED FILTERING OF SSN.                           
P00465*  06/16/11    FMB      ADD WELCOME_KIT_CD TO TO CSR02203 CALL.           
ACT233*  07/26/16   TP7R341   REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04159'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04159 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRITPA                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04159_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACES.          
           05  RS-MIDDLE-NAME          PIC X(15) VALUE SPACES.          
           05  RS-LAST-NAME            PIC X(40) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-FIRST-NAME           PIC X(15) VALUE SPACES.           
           05  S-MIDDLE-NAME          PIC X(15) VALUE SPACES.           
           05  S-LAST-NAME            PIC X(40) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04159'.     
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES                       
               WS-CUSTOMER-NO-NUM       PIC X(10).                      
           05  AT-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  AT-CUSTOMER-NO-CHAR      REDEFINES                       
               AT-CUSTOMER-NO-NUM       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES                       
               WS-PREMISE-NO-NUM        PIC X(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES                       
               WS-ACCOUNT-NO-CHAR       PIC 9(13).                      
           05  WS-SSN-EXISTS-FL         PIC X(01) VALUE 'N'.            
           05  WS-NAME-MATCH-FL         PIC X(01) VALUE 'N'.            
           05  WS-WQ-LITERAL.                                           
               10  FILLER               PIC X(38) VALUE                 
                  'ADDED ROOMMATE WITH UNRESOLVED ITPA - '.             
               10  WS-WQ-NAME           PIC X(50) VALUE SPACES.         
               10  WS-WQ-SSN            PIC X(11) VALUE SPACES.         
                                                                        
      ******************************************************************        
      * CSR02203 - CREATE A CUSTOMER RECORD                            *        
      ******************************************************************        
                                                                        
       01  CSR02203-CALL-DATA.                                          
           03  UPDATE-TYPE-2203       PIC X(01) VALUE SPACES.           
           03  LAST-VISIT-DATE-2203   PIC X(10) VALUE SPACES.           
           03  LOCAL-OFFICE-2203      PIC X(03) VALUE SPACES.           
           03  COMPANY-NO-2203        PIC X(02) VALUE SPACES.           
           03  CUSTOMER-NO-2203       PIC X(10) VALUE SPACES.           
           03  TITLE-PREFIX-2203      PIC X(09) VALUE SPACES.           
           03  FIRST-NAME-2203        PIC X(15) VALUE SPACES.           
           03  MIDDLE-NAME-2203       PIC X(15) VALUE SPACES.           
           03  LAST-NAME-2203         PIC X(40) VALUE SPACES.           
           03  TITLE-SUFFIX-2203      PIC X(03) VALUE SPACES.           
           03  FULL-NAME-2203         PIC X(70) VALUE SPACES.           
           03  BUSINESS-NAME-2203     PIC X(70) VALUE SPACES.           
           03  NICKNAME-2203          PIC X(50) VALUE SPACES.           
           03  CUST-HOME-PHONE-2203   PIC X(10) VALUE SPACES.           
           03  CUST-OCCUP-2203        PIC X(15) VALUE SPACES.           
           03  CUST-WORK-PHONE-2203   PIC X(10) VALUE SPACES.           
           03  CUST-WORK-PHONE-EX-2203 PIC X(06) VALUE SPACES.          
           03  EMPLOYER-2203          PIC X(23) VALUE SPACES.           
           03  EMPLOYED-DATE-2203     PIC X(10) VALUE SPACES.           
           03  EMPLOYEE-NO-2203       PIC X(05) VALUE SPACES.           
           03  SSN-2203               PIC X(09) VALUE SPACES.           
           03  DOB-2203               PIC X(10) VALUE SPACES.           
           03  DLN-2203               PIC X(19) VALUE SPACES.           
           03  DLN-STATE-2203         PIC X(02) VALUE SPACES.           
           03  DLN-EXP-DATE-2203      PIC X(10) VALUE SPACES.           
           03  OTHER-ID-TYPE-2203     PIC X(12) VALUE SPACES.           
           03  OTHER-ID-2203          PIC X(16) VALUE SPACES.           
           03  ALIAS-2203             PIC X(07) VALUE SPACES.           
           03  TAX-ID-2203            PIC X(09) VALUE SPACES.           
           03  COMPANY-IND-2203       PIC X(01) VALUE SPACES.           
           03  BUSINESS-TYPE-CD-2203  PIC X(01) VALUE SPACES.           
           03  CONTRACTOR-TYPE-2203   PIC X(30) VALUE SPACES.           
           03  CONSULTING-PROJ-2203   PIC X(30) VALUE SPACES.           
           03  CONSULT-END-DATE-2203  PIC X(10) VALUE SPACES.           
           03  CUST-BUS-PHONE-2203    PIC X(10) VALUE SPACES.           
           03  USER-ID-2203           PIC X(07) VALUE SPACES.           
           03  COMMENT-TEXT-2203      PIC X(210) VALUE SPACES.          
           03  COMMENT-LEN-2203       PIC X(04) VALUE SPACES.           
           03  EMAIL-2203             PIC X(100) VALUE SPACES.          
           03  EMAIL-LEN-2203         PIC X(04) VALUE SPACES.           
           03  EMAIL-DISP-PREF-2203   PIC X(01) VALUE SPACES.           
           03  REFUSED-SSN-2203       PIC X(01) VALUE SPACES.           
           03  CUST-ALT-PHONE-2203    PIC X(10) VALUE SPACES.           
           03  PASSWORD-2203          PIC X(16) VALUE SPACES.           
           03  PASSWORD-HINT-2203     PIC X(02) VALUE SPACES.           
           03  EMAIL-SOURCE-2203      PIC X(01) VALUE SPACES.           
           03  LANGUAGE-PREF-2203     PIC X(02) VALUE SPACES.           
           03  DOB-VERIFIED-2203      PIC X(01) VALUE SPACES.           
           03  DHR-FL-2203            PIC X(01) VALUE SPACES.           
P00422     03  LL-REVERT-FL-2203      PIC X(01) VALUE SPACES.           
P00465     03  WELCOME-KIT-CD-2203    PIC X(01) VALUE SPACES.           
                                                                        
       01  CSR02203-RETURN-DATA.                                        
           03  RETURN-CODE-2203       PIC S9(9) COMP VALUE 0.           
           03  CUSTOMER-NO-OUT-2203   PIC X(10) VALUE SPACES.           
           03  CUSTOMER-EST-DATE-2203 PIC X(10) VALUE SPACES.           
                                                                        
      ******************************************************************        
      * CSR02174 - MAINTAIN ROOMMATE/COAPP/3RD PARTY INFO              *        
      ******************************************************************        
                                                                        
       01  CSR02174-CALL-DATA.                                          
           03  ACCOUNT-NO-2174        PIC X(13) VALUE SPACES.           
           03  ALLIANCE-TYPE-2174     PIC X(02) VALUE SPACES.           
           03  ACTION-CD-2174         PIC X(01) VALUE SPACES.           
           03  CUSTOMER-NO-2174       PIC X(10) VALUE SPACES.           
           03  TITLE-PREFIX-2174      PIC X(09) VALUE SPACES.           
           03  FIRST-NAME-2174        PIC X(15) VALUE SPACES.           
           03  MIDDLE-NAME-2174       PIC X(15) VALUE SPACES.           
           03  LAST-NAME-2174         PIC X(40) VALUE SPACES.           
           03  FULL-NAME-2174         PIC X(70) VALUE SPACES.           
           03  TITLE-SUFFIX-2174      PIC X(03) VALUE SPACES.           
           03  CUST-WORK-PHONE-2174   PIC X(10) VALUE SPACES.           
           03  CUST-WORK-PHONE-EX-2174 PIC X(06) VALUE SPACES.          
           03  CUST-HOME-PHONE-2174   PIC X(10) VALUE SPACES.           
           03  CONTACT-ID-2174        PIC X(10) VALUE SPACES.           
           03  ADDR-STREET-2174       PIC X(55) VALUE SPACES.           
           03  CITY-STATE-2174        PIC X(30) VALUE SPACES.           
           03  ADDR-ZIP-CODE-2174     PIC X(09) VALUE SPACES.           
           03  ADDR-COUNTRY-2174      PIC X(35) VALUE SPACES.           
           03  ADDRESS-OVERFLOW-2174  PIC X(35) VALUE SPACES.           
           03  ADDRESS-CHANGED-2174   PIC X(01) VALUE SPACES.           
           03  NAME-CHANGED-2174      PIC X(01) VALUE SPACES.           
           03  HOME-PHONE-CHANGED-2174 PIC X(01) VALUE SPACES.          
           03  WORK-PHONE-CHANGED-2174 PIC X(01) VALUE SPACES.          
           03  USER-ID-2174           PIC X(07) VALUE SPACES.           
           03  CUSTOMER-TYPE-2174     PIC X(01) VALUE SPACES.           
           03  TRANS-COMMENTS-2174    PIC X(210) VALUE SPACES.          
           03  TRANS-COMMENTS-LEN-2174 PIC X(04) VALUE SPACES.          
           03  3RD-PARTY-REL-2174     PIC X(15) VALUE SPACES.           
           03  3RD-PARTY-STATUS-2174  PIC X(01) VALUE SPACES.           
           03  3RD-PARTY-REL-CHG-2174 PIC X(01) VALUE SPACES.           
           03  3RD-PARTY-EXISTS-2174  PIC X(01) VALUE SPACES.           
                                                                        
       01  CSR02174-RETURN-DATA.                                        
           03  RETURN-CODE-2174       PIC S9(9) COMP VALUE 0.           
                                                                        
      ******************************************************************        
      * CSR02517 - WRITE A COMMUNICATION ROW                           *        
      ******************************************************************        
                                                                        
       01  CSR02517-CALL-DATA.                                          
           05  ACTION-CD-2517            PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2517           PIC X(13) VALUE SPACES.        
           05  CUSTOMER-NO-2517          PIC X(10) VALUE SPACES.        
           05  PREMISE-NO-2517           PIC X(10) VALUE SPACES.        
           05  COMMUNICATION-ID-2517     PIC X(26) VALUE SPACES.        
           05  COMPANY-NO-2517           PIC X(13) VALUE SPACES.        
           05  RED-FLAG-IND-2517         PIC X(01) VALUE SPACES.        
           05  RED-FLAG-EXP-DT-2517      PIC X(26) VALUE SPACES.        
           05  COMM-METHOD-2517          PIC X(01) VALUE SPACES.        
           05  COMM-DIRECTION-2517       PIC X(01) VALUE SPACES.        
           05  COMM-TYPE-CD-2517         PIC X(02) VALUE SPACES.        
           05  COMM-SUBTYPE-CD-2517      PIC X(02) VALUE SPACES.        
           05  USER-ID-ORIG-2517         PIC X(07) VALUE SPACES.        
           05  CONTACT-NAME-2517         PIC X(25) VALUE SPACES.        
           05  PROMOTION-ID-2517         PIC X(12) VALUE SPACES.        
           05  PSC-COMPLAINT-IND-2517    PIC X(01) VALUE SPACES.        
           05  CALL-ORIGIN-ID-2517       PIC X(04) VALUE SPACES.        
           05  CALL-END-TIME-2517        PIC X(26) VALUE SPACES.        
           05  NUMBER-TRANSFERS-2517     PIC X(09) VALUE SPACES.        
           05  HOLD-TIME-2517            PIC X(05) VALUE SPACES.        
           05  QUEUE-TIME-2517           PIC X(05) VALUE SPACES.        
           05  SCREEN-POP-IND-2517       PIC X(01) VALUE SPACES.        
           05  TOTAL-CALL-TIME-2517      PIC X(05) VALUE SPACES.        
           05  COMMENT-LEN-2517          PIC S9(4) COMP VALUE 0.        
           05  COMMENT-TEXT-2517         PIC X(255) VALUE SPACES.       
           05  COMM-ASSOC-CD-2517        PIC X(01) VALUE SPACES.        
           05  COMPLAINT-FL-2517         PIC X(01) VALUE SPACES.        
           05  RESPONSE-RESN-CD-2517     PIC X(04) VALUE SPACES.        
           05  RESPONSE-TYPE-CD-2517     PIC X(04) VALUE SPACES.        
           05  SOLICITATION-CD-2517      PIC X(03) VALUE SPACES.        
                                                                        
       01  CSR02517-RETURN-DATA.                                        
           05  RETURN-CODE-2517          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
ACT233* CSR04675 - WRITE A WQ                                          *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
      ******************************************************************        
      * CSR02557 - CHECK FOR WRITE OFF                                 *        
      ******************************************************************        
                                                                        
       01  CSR02557-CALL-DATA.                                          
           05  CUSTOMER-NO-2557          PIC X(10) VALUE SPACES.        
           05  SSN-2557                  PIC X(09) VALUE SPACES.        
                                                                        
       01  CSR02557-RETURN-DATA.                                        
           05  RETURN-CODE-2557          PIC S9(9) COMP VALUE 0.        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC2203 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2174 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2517 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2557 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2557 CURSOR
MSQ001          FOR CALL CSR02557                                             
                  ( :CUSTOMER-NO-2557
                  , :SSN-2557
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2203 CURSOR
MSQ001          FOR CALL CSR02203                                             
                  ( :UPDATE-TYPE-2203
                  , :LAST-VISIT-DATE-2203
                  , :LOCAL-OFFICE-2203
                  , :COMPANY-NO-2203
                  , :CUSTOMER-NO-2203
                  , :TITLE-PREFIX-2203
                  , :FIRST-NAME-2203
                  , :MIDDLE-NAME-2203
                  , :LAST-NAME-2203
                  , :TITLE-SUFFIX-2203
                  , :FULL-NAME-2203
                  , :BUSINESS-NAME-2203
                  , :NICKNAME-2203
                  , :CUST-HOME-PHONE-2203
                  , :CUST-OCCUP-2203
                  , :CUST-WORK-PHONE-2203
                  , :CUST-WORK-PHONE-EX-2203
                  , :EMPLOYER-2203
                  , :EMPLOYED-DATE-2203
                  , :EMPLOYEE-NO-2203
                  , :SSN-2203
                  , :DOB-2203
                  , :DLN-2203
                  , :DLN-STATE-2203
                  , :DLN-EXP-DATE-2203
                  , :OTHER-ID-TYPE-2203
                  , :OTHER-ID-2203
                  , :ALIAS-2203
                  , :TAX-ID-2203
                  , :COMPANY-IND-2203
                  , :BUSINESS-TYPE-CD-2203
                  , :CONTRACTOR-TYPE-2203
                  , :CONSULTING-PROJ-2203
                  , :CONSULT-END-DATE-2203
                  , :CUST-BUS-PHONE-2203
                  , :USER-ID-2203
                  , :COMMENT-TEXT-2203
                  , :COMMENT-LEN-2203
                  , :EMAIL-2203
                  , :EMAIL-LEN-2203
                  , :EMAIL-DISP-PREF-2203
                  , :REFUSED-SSN-2203
                  , :CUST-ALT-PHONE-2203
                  , :PASSWORD-2203
                  , :PASSWORD-HINT-2203
                  , :EMAIL-SOURCE-2203
                  , :LANGUAGE-PREF-2203
                  , :DOB-VERIFIED-2203
                  , :DHR-FL-2203
                  , :LL-REVERT-FL-2203
                  , :WELCOME-KIT-CD-2203
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2174 CURSOR
MSQ001          FOR CALL CSR02174                                             
                  ( :ACCOUNT-NO-2174
                  , :ALLIANCE-TYPE-2174
                  , :ACTION-CD-2174
                  , :CUSTOMER-NO-2174
                  , :TITLE-PREFIX-2174
                  , :FIRST-NAME-2174
                  , :MIDDLE-NAME-2174
                  , :LAST-NAME-2174
                  , :FULL-NAME-2174
                  , :TITLE-SUFFIX-2174
                  , :CUST-WORK-PHONE-2174
                  , :CUST-WORK-PHONE-EX-2174
                  , :CUST-HOME-PHONE-2174
                  , :CONTACT-ID-2174
                  , :ADDR-STREET-2174
                  , :CITY-STATE-2174
                  , :ADDR-ZIP-CODE-2174
                  , :ADDR-COUNTRY-2174
                  , :ADDRESS-OVERFLOW-2174
                  , :ADDRESS-CHANGED-2174
                  , :NAME-CHANGED-2174
                  , :HOME-PHONE-CHANGED-2174
                  , :WORK-PHONE-CHANGED-2174
                  , :USER-ID-2174
                  , :CUSTOMER-TYPE-2174
                  , :TRANS-COMMENTS-2174
                  , :TRANS-COMMENTS-LEN-2174
                  , :3RD-PARTY-REL-2174
                  , :3RD-PARTY-STATUS-2174
                  , :3RD-PARTY-REL-CHG-2174
                  , :3RD-PARTY-EXISTS-2174
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2517 CURSOR
MSQ001          FOR CALL CSR02517                                             
                  ( :ACTION-CD-2517
                  , :ACCOUNT-NO-2517
                  , :CUSTOMER-NO-2517
                  , :PREMISE-NO-2517
                  , :COMMUNICATION-ID-2517
                  , :COMPANY-NO-2517
                  , :RED-FLAG-IND-2517
                  , :RED-FLAG-EXP-DT-2517
                  , :COMM-METHOD-2517
                  , :COMM-DIRECTION-2517
                  , :COMM-TYPE-CD-2517
                  , :COMM-SUBTYPE-CD-2517
                  , :USER-ID-ORIG-2517
                  , :CONTACT-NAME-2517
                  , :PROMOTION-ID-2517
                  , :PSC-COMPLAINT-IND-2517
                  , :CALL-ORIGIN-ID-2517
                  , :CALL-END-TIME-2517
                  , :NUMBER-TRANSFERS-2517
                  , :HOLD-TIME-2517
                  , :QUEUE-TIME-2517
                  , :SCREEN-POP-IND-2517
                  , :TOTAL-CALL-TIME-2517
                  , :COMMENT-LEN-2517
                  , :COMMENT-TEXT-2517
                  , :COMM-ASSOC-CD-2517
                  , :COMPLAINT-FL-2517
                  , :RESPONSE-RESN-CD-2517
                  , :RESPONSE-TYPE-CD-2517
                  , :SOLICITATION-CD-2517
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PROGRAM-ID         PIC X(08).                           
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-ALLIANCE-TYPE      PIC X(02).                           
       01  LINK-ACTION-CODE        PIC X(01).                           
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-TITLE-PREFIX       PIC X(09).                           
       01  LINK-FIRST-NAME         PIC X(15).                           
       01  LINK-MIDDLE-NAME        PIC X(15).                           
       01  LINK-LAST-NAME          PIC X(40).                           
       01  LINK-FULL-NAME          PIC X(70).                           
       01  LINK-TITLE-SUFFIX       PIC X(03).                           
       01  LINK-CUST-WORK-PHONE    PIC X(10).                           
       01  LINK-CUST-WORK-PHONE-EX PIC X(06).                           
       01  LINK-CUST-HOME-PHONE    PIC X(10).                           
       01  LINK-CONTACT-ID         PIC X(10).                           
       01  LINK-ADDR-STREET        PIC X(55).                           
       01  LINK-CITY-STATE         PIC X(30).                           
       01  LINK-ADDR-ZIP-CODE      PIC X(09).                           
       01  LINK-ADDR-COUNTRY       PIC X(35).                           
       01  LINK-ADDRESS-OVERFLOW   PIC X(35).                           
       01  LINK-ADDRESS-CHANGED    PIC X(01).                           
       01  LINK-NAME-CHANGED       PIC X(01).                           
       01  LINK-HOME-PHONE-CHANGED PIC X(01).                           
       01  LINK-WORK-PHONE-CHANGED PIC X(01).                           
       01  LINK-USER-ID            PIC X(07).                           
       01  LINK-CUSTOMER-TYPE      PIC X(01).                           
       01  LINK-TRANS-COMMENTS     PIC X(210).                          
       01  LINK-TRANS-COMMENTS-LEN PIC X(04).                           
       01  LINK-3RD-PARTY-REL      PIC X(15).                           
       01  LINK-3RD-PARTY-STATUS   PIC X(01).                           
       01  LINK-3RD-PARTY-REL-CHG  PIC X(01).                           
       01  LINK-3RD-PARTY-EXISTS   PIC X(01).                           
       01  LINK-SSN-FL             PIC X(01).                           
       01  LINK-SSN                PIC X(09).                           
       01  LINK-COMPANY-NO         PIC X(02).                           
       01  LINK-CUSTOMER-OCCUP     PIC X(15).                           
       01  LINK-DOB                PIC X(10).                           
       01  LINK-DLN                PIC X(19).                           
       01  LINK-DLN-STATE          PIC X(02).                           
       01  LINK-DLN-EXP-DATE       PIC X(10).                           
       01  LINK-BUSINESS-NAME      PIC X(70).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PROGRAM-ID                               
                          LINK-ACCOUNT-NO                               
                          LINK-ALLIANCE-TYPE                            
                          LINK-ACTION-CODE                              
                          LINK-CUSTOMER-NO                              
                          LINK-TITLE-PREFIX                             
                          LINK-FIRST-NAME                               
                          LINK-MIDDLE-NAME                              
                          LINK-LAST-NAME                                
                          LINK-FULL-NAME                                
                          LINK-TITLE-SUFFIX                             
                          LINK-CUST-WORK-PHONE                          
                          LINK-CUST-WORK-PHONE-EX                       
                          LINK-CUST-HOME-PHONE                          
                          LINK-CONTACT-ID                               
                          LINK-ADDR-STREET                              
                          LINK-CITY-STATE                               
                          LINK-ADDR-ZIP-CODE                            
                          LINK-ADDR-COUNTRY                             
                          LINK-ADDRESS-OVERFLOW                         
                          LINK-ADDRESS-CHANGED                          
                          LINK-NAME-CHANGED                             
                          LINK-HOME-PHONE-CHANGED                       
                          LINK-WORK-PHONE-CHANGED                       
                          LINK-USER-ID                                  
                          LINK-CUSTOMER-TYPE                            
                          LINK-TRANS-COMMENTS                           
                          LINK-TRANS-COMMENTS-LEN                       
                          LINK-3RD-PARTY-REL                            
                          LINK-3RD-PARTY-STATUS                         
                          LINK-3RD-PARTY-REL-CHG                        
                          LINK-3RD-PARTY-EXISTS                         
                          LINK-SSN-FL                                   
                          LINK-SSN                                      
                          LINK-COMPANY-NO                               
                          LINK-CUSTOMER-OCCUP                           
                          LINK-DOB                                      
                          LINK-DLN                                      
                          LINK-DLN-STATE                                
                          LINK-DLN-EXP-DATE                             
                          LINK-BUSINESS-NAME.                           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE     AS RETURN_CODE,                
                      :S-STATUS-CODE     AS STATUS_CODE,                
                      :S-FIRST-NAME      AS FIRST_NAME,                 
                      :S-MIDDLE-NAME     AS MIDDLE_NAME,                
                      :S-LAST-NAME       AS LAST_NAME                   
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE     AS RETURN_CODE,                        
MFA-TR*               :S-STATUS-CODE     AS STATUS_CODE,                        
MFA-TR*               :S-FIRST-NAME      AS FIRST_NAME,                         
MFA-TR*               :S-MIDDLE-NAME     AS MIDDLE_NAME,                        
MFA-TR*               :S-LAST-NAME       AS LAST_NAME                           
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SSN TO CE-SSN.                                     
           MOVE LINK-USER-ID TO PF-USER-ID.                             
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
                                                                        
           PERFORM 7100-GET-USER-PROFILE THRU 7100-EXIT.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF LINK-ALLIANCE-TYPE = 'RO' AND                             
              LINK-ACTION-CODE = 'I'                                    
                  PERFORM 7000-GET-NAME THRU 7000-EXIT                  
                  PERFORM 7050-GET-ACCOUNT THRU 7050-EXIT               
                  IF WS-SSN-EXISTS-FL = 'Y'                             
                      PERFORM 3000-EXISTING-SSN THRU 3000-EXIT          
                  ELSE                                                  
                      PERFORM 3500-NO-EXISTING-SSN THRU 3500-EXIT       
                  END-IF                                                
           ELSE                                                         
               PERFORM 3400-CALL-CSR02174 THRU 3400-EXIT
           END-IF.               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE     TO S-RETURN-CODE.                  
             MOVE RS-STATUS-CODE     TO S-STATUS-CODE.                  
             MOVE RS-FIRST-NAME      TO S-FIRST-NAME.                   
             MOVE RS-MIDDLE-NAME     TO S-MIDDLE-NAME.                  
             MOVE RS-LAST-NAME       TO S-LAST-NAME.                    
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       3000-EXISTING-SSN.                                               
                                                                        
           IF DQ-FIRST-NAME = LINK-FIRST-NAME AND                       
              DQ-LAST-NAME  = LINK-LAST-NAME                            
                  MOVE 'UPDATED VIA WEB BY CUSTOMER' TO                 
                       LINK-TRANS-COMMENTS                              
                  MOVE '0026' TO LINK-TRANS-COMMENTS-LEN                
                  PERFORM 3400-CALL-CSR02174 THRU 3400-EXIT             
                  IF RS-STATUS-CODE = 0                                 
                      PERFORM 7200-CHECK-ITPA THRU 7200-EXIT            
                      PERFORM 3200-CALL-CSR02557 THRU 3200-EXIT         
                  END-IF                                                
           ELSE                                                         
               MOVE 0 TO RS-RETURN-CODE                                 
               MOVE +100 TO RS-STATUS-CODE                              
               MOVE DQ-FIRST-NAME TO RS-FIRST-NAME                      
               MOVE DQ-MIDDLE-NAME TO RS-MIDDLE-NAME                    
               MOVE DQ-LAST-NAME TO RS-LAST-NAME                        
               PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               ADD 1 TO  CTR-ROWS                                       
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-CALL-CSR02557.                                              
                                                                        
A01832     MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-2557.                     
           MOVE LINK-SSN TO SSN-2557.                                   
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02557                                             
      *           (:CUSTOMER-NO-2557,                                   
      *            :SSN-2557)                                           
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2557
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2557
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2557 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02557'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CUSTOMER-NO-2557      TO HOSTVAR-ELEMENT-1           
              MOVE 'SSN'                 TO TABLE-ELEMENT-2             
              MOVE SSN-2557              TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2557)                                                
      *       WITH PROCEDURE CSR02557                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2557 CURSOR FOR RESULT SET        
      *       :LOC2557                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2557 INTO                            
                 :RETURN-CODE-2557                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2557 NOT = 0                          
                       MOVE RETURN-CODE-2557  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3200'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02557'        TO TABLE-1                
                       MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1        
                       MOVE CUSTOMER-NO-2557  TO HOSTVAR-ELEMENT-1      
                       MOVE 'SSN'             TO TABLE-ELEMENT-2        
                       MOVE SSN-2557          TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02557'            TO TABLE-1                
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
                   MOVE CUSTOMER-NO-2557      TO HOSTVAR-ELEMENT-1      
                   MOVE 'SSN'                 TO TABLE-ELEMENT-2        
                   MOVE SSN-2557              TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-CALL-CSR02203.                                              
                                                                        
           MOVE 'I' TO UPDATE-TYPE-2203.                                
           MOVE PF-LOCAL-OFFICE TO LOCAL-OFFICE-2203.                   
           MOVE LINK-COMPANY-NO TO COMPANY-NO-2203.                     
           MOVE LINK-TITLE-PREFIX TO TITLE-PREFIX-2203.                 
           MOVE LINK-FIRST-NAME TO FIRST-NAME-2203.                     
           MOVE LINK-MIDDLE-NAME TO MIDDLE-NAME-2203.                   
           MOVE LINK-LAST-NAME TO LAST-NAME-2203.                       
           MOVE LINK-TITLE-SUFFIX TO TITLE-SUFFIX-2203.                 
           IF LINK-FULL-NAME <= SPACES                                  
               MOVE LINK-LAST-NAME TO LINK-FULL-NAME(1:20)              
               MOVE LINK-FIRST-NAME TO LINK-FULL-NAME(21:15)            
               MOVE LINK-MIDDLE-NAME TO LINK-FULL-NAME(37:15)
           END-IF.          
           MOVE LINK-FULL-NAME TO FULL-NAME-2203.                       
           MOVE LINK-BUSINESS-NAME TO BUSINESS-NAME-2203.               
           MOVE LINK-CUST-HOME-PHONE TO CUST-HOME-PHONE-2203.           
           MOVE LINK-CUSTOMER-OCCUP TO CUST-OCCUP-2203.                 
           MOVE LINK-CUST-WORK-PHONE TO CUST-WORK-PHONE-2203.           
           MOVE LINK-CUST-WORK-PHONE-EX TO CUST-WORK-PHONE-EX-2203.     
           MOVE LINK-SSN TO SSN-2203.                                   
           MOVE LINK-DOB TO DOB-2203.                                   
           MOVE LINK-DLN TO DLN-2203.                                   
           MOVE LINK-DLN-STATE TO DLN-STATE-2203.                       
           MOVE LINK-DLN-EXP-DATE TO DLN-EXP-DATE-2203.                 
           MOVE LINK-USER-ID TO USER-ID-2203.                           
           MOVE 'UPDATE VIA WEB BY CUSTOMER' TO COMMENT-TEXT-2203.      
           MOVE '0026' TO COMMENT-LEN-2203.                             
           MOVE 'D' TO EMAIL-SOURCE-2203.                               
           MOVE 'N' TO DHR-FL-2203                                      
P00422                 LL-REVERT-FL-2203.                               
P00465     MOVE ' ' TO WELCOME-KIT-CD-2203.                             
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02203                                             
      *           (:UPDATE-TYPE-2203,                                   
      *            :LAST-VISIT-DATE-2203,                               
      *            :LOCAL-OFFICE-2203,                                  
      *            :COMPANY-NO-2203,                                    
      *            :CUSTOMER-NO-2203,                                   
      *            :TITLE-PREFIX-2203,                                  
      *            :FIRST-NAME-2203,                                    
      *            :MIDDLE-NAME-2203,                                   
      *            :LAST-NAME-2203,                                     
      *            :TITLE-SUFFIX-2203,                                  
      *            :FULL-NAME-2203,                                     
      *            :BUSINESS-NAME-2203,                                 
      *            :NICKNAME-2203,                                      
      *            :CUST-HOME-PHONE-2203,                               
      *            :CUST-OCCUP-2203,                                    
      *            :CUST-WORK-PHONE-2203,                               
      *            :CUST-WORK-PHONE-EX-2203,                            
      *            :EMPLOYER-2203,                                      
      *            :EMPLOYED-DATE-2203,                                 
      *            :EMPLOYEE-NO-2203,                                   
      *            :SSN-2203,                                           
      *            :DOB-2203,                                           
      *            :DLN-2203,                                           
      *            :DLN-STATE-2203,                                     
      *            :DLN-EXP-DATE-2203,                                  
      *            :OTHER-ID-TYPE-2203,                                 
      *            :OTHER-ID-2203,                                      
      *            :ALIAS-2203,                                         
      *            :TAX-ID-2203,                                        
      *            :COMPANY-IND-2203,                                   
      *            :BUSINESS-TYPE-CD-2203,                              
      *            :CONTRACTOR-TYPE-2203,                               
      *            :CONSULTING-PROJ-2203,                               
      *            :CONSULT-END-DATE-2203,                              
      *            :CUST-BUS-PHONE-2203,                                
      *            :USER-ID-2203,                                       
      *            :COMMENT-TEXT-2203,                                  
      *            :COMMENT-LEN-2203,                                   
      *            :EMAIL-2203,                                         
      *            :EMAIL-LEN-2203,                                     
      *            :EMAIL-DISP-PREF-2203,                               
      *            :REFUSED-SSN-2203,                                   
      *            :CUST-ALT-PHONE-2203,                                
      *            :PASSWORD-2203,                                      
      *            :PASSWORD-HINT-2203,                                 
      *            :EMAIL-SOURCE-2203,                                  
      *            :LANGUAGE-PREF-2203,                                 
      *            :DOB-VERIFIED-2203,                                  
      *            :DHR-FL-2203,                                        
P00422*            :LL-REVERT-FL-2203,                                  
P00465*            :WELCOME-KIT-CD-2203)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2203
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2203
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2203 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02203'            TO TABLE-1                     
              MOVE 'LAST_NAME'           TO TABLE-ELEMENT-1             
              MOVE LAST-NAME-2203        TO HOSTVAR-ELEMENT-1           
              MOVE 'SSN'                 TO TABLE-ELEMENT-2             
              MOVE SSN-2203              TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE COMPANY-NO-2203       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2203)                                                
      *       WITH PROCEDURE CSR02203                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2203 CURSOR FOR RESULT SET        
      *       :LOC2203                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2203 INTO                            
                 :RETURN-CODE-2203,                                     
                 :CUSTOMER-NO-OUT-2203,                                 
                 :CUSTOMER-EST-DATE-2203                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2203 NOT = 0                          
                       MOVE RETURN-CODE-2203  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3300'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02203'        TO TABLE-1                
                       MOVE 'LAST_NAME'       TO TABLE-ELEMENT-1        
                       MOVE LAST-NAME-2203    TO HOSTVAR-ELEMENT-1      
                       MOVE 'SSN'             TO TABLE-ELEMENT-2        
                       MOVE SSN-2203          TO HOSTVAR-ELEMENT-2      
                       MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-3        
                       MOVE COMPANY-NO-2203   TO HOSTVAR-ELEMENT-3      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   ELSE                                                 
                       MOVE CUSTOMER-NO-OUT-2203 TO LINK-CUSTOMER-NO    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02203'            TO TABLE-1                
                   MOVE 'LAST_NAME'           TO TABLE-ELEMENT-1        
                   MOVE LAST-NAME-2203        TO HOSTVAR-ELEMENT-1      
                   MOVE 'SSN'                 TO TABLE-ELEMENT-2        
                   MOVE SSN-2203              TO HOSTVAR-ELEMENT-2      
                   MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3        
                   MOVE COMPANY-NO-2203       TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-CALL-CSR02174.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2174.                     
           MOVE LINK-ALLIANCE-TYPE TO ALLIANCE-TYPE-2174.               
           MOVE LINK-ACTION-CODE TO ACTION-CD-2174.                     
           MOVE LINK-CUSTOMER-NO TO CUSTOMER-NO-2174.                   
           MOVE LINK-TITLE-PREFIX TO TITLE-PREFIX-2174.                 
           MOVE LINK-FIRST-NAME TO FIRST-NAME-2174.                     
           MOVE LINK-MIDDLE-NAME TO MIDDLE-NAME-2174.                   
           MOVE LINK-LAST-NAME TO LAST-NAME-2174.                       
      *    MOVE LINK-FULL-NAME TO FULL-NAME-2174.                               
           MOVE LINK-BUSINESS-NAME TO FULL-NAME-2174.                   
           MOVE LINK-TITLE-SUFFIX TO TITLE-SUFFIX-2174.                 
           MOVE LINK-CUST-WORK-PHONE TO CUST-WORK-PHONE-2174.           
           MOVE LINK-CUST-WORK-PHONE-EX TO CUST-WORK-PHONE-EX-2174.     
           MOVE LINK-CUST-HOME-PHONE TO CUST-HOME-PHONE-2174.           
           MOVE LINK-CONTACT-ID TO CONTACT-ID-2174.                     
           MOVE LINK-ADDR-STREET TO ADDR-STREET-2174.                   
           MOVE LINK-CITY-STATE TO CITY-STATE-2174.                     
           MOVE LINK-ADDR-ZIP-CODE TO ADDR-ZIP-CODE-2174.               
           MOVE LINK-ADDR-COUNTRY TO ADDR-COUNTRY-2174.                 
           MOVE LINK-ADDRESS-OVERFLOW TO ADDRESS-OVERFLOW-2174.         
           MOVE LINK-ADDRESS-CHANGED TO ADDRESS-CHANGED-2174.           
           MOVE LINK-NAME-CHANGED TO NAME-CHANGED-2174.                 
           MOVE LINK-HOME-PHONE-CHANGED TO HOME-PHONE-CHANGED-2174.     
           MOVE LINK-WORK-PHONE-CHANGED TO WORK-PHONE-CHANGED-2174.     
           MOVE LINK-USER-ID TO USER-ID-2174.                           
           MOVE LINK-CUSTOMER-TYPE TO CUSTOMER-TYPE-2174.               
           MOVE LINK-TRANS-COMMENTS TO TRANS-COMMENTS-2174.             
           MOVE LINK-TRANS-COMMENTS-LEN TO TRANS-COMMENTS-LEN-2174.     
           MOVE LINK-3RD-PARTY-REL TO 3RD-PARTY-REL-2174.               
           MOVE LINK-3RD-PARTY-STATUS TO 3RD-PARTY-STATUS-2174.         
           MOVE LINK-3RD-PARTY-REL-CHG TO 3RD-PARTY-REL-CHG-2174.       
           MOVE LINK-3RD-PARTY-EXISTS TO 3RD-PARTY-EXISTS-2174.         
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02174                                             
      *           (:ACCOUNT-NO-2174,                                    
      *            :ALLIANCE-TYPE-2174,                                 
      *            :ACTION-CD-2174,                                     
      *            :CUSTOMER-NO-2174,                                   
      *            :TITLE-PREFIX-2174,                                  
      *            :FIRST-NAME-2174,                                    
      *            :MIDDLE-NAME-2174,                                   
      *            :LAST-NAME-2174,                                     
      *            :FULL-NAME-2174,                                     
      *            :TITLE-SUFFIX-2174,                                  
      *            :CUST-WORK-PHONE-2174,                               
      *            :CUST-WORK-PHONE-EX-2174,                            
      *            :CUST-HOME-PHONE-2174,                               
      *            :CONTACT-ID-2174,                                    
      *            :ADDR-STREET-2174,                                   
      *            :CITY-STATE-2174,                                    
      *            :ADDR-ZIP-CODE-2174,                                 
      *            :ADDR-COUNTRY-2174,                                  
      *            :ADDRESS-OVERFLOW-2174,                              
      *            :ADDRESS-CHANGED-2174,                               
      *            :NAME-CHANGED-2174,                                  
      *            :HOME-PHONE-CHANGED-2174,                            
      *            :WORK-PHONE-CHANGED-2174,                            
      *            :USER-ID-2174,                                       
      *            :CUSTOMER-TYPE-2174,                                 
      *            :TRANS-COMMENTS-2174,                                
      *            :TRANS-COMMENTS-LEN-2174,                            
      *            :3RD-PARTY-REL-2174,                                 
      *            :3RD-PARTY-STATUS-2174,                              
      *            :3RD-PARTY-REL-CHG-2174,                             
      *            :3RD-PARTY-EXISTS-2174)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2174
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2174
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2174 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02174'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2174       TO HOSTVAR-ELEMENT-1           
              MOVE 'ALLIANCE'            TO TABLE-ELEMENT-2             
              MOVE ALLIANCE-TYPE-2174    TO HOSTVAR-ELEMENT-2           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3             
              MOVE CUSTOMER-NO-2174      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2174)                                                
      *       WITH PROCEDURE CSR02174                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2174 CURSOR FOR RESULT SET        
      *       :LOC2174                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2174 INTO                            
                 :RETURN-CODE-2174                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2174 = 0 OR                           
                      RETURN-CODE-2174 = +300 OR                        
                      RETURN-CODE-2174 = +320                           
                          MOVE RETURN-CODE-2174 TO RS-STATUS-CODE       
                   ELSE                                                 
                       MOVE RETURN-CODE-2174  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3400'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02174'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2174   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ALLIANCE'        TO TABLE-ELEMENT-2        
                       MOVE ALLIANCE-TYPE-2174 TO HOSTVAR-ELEMENT-2     
                       MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-3        
                       MOVE CUSTOMER-NO-2174  TO HOSTVAR-ELEMENT-3      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3400'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02174'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2174       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ALLIANCE'            TO TABLE-ELEMENT-2        
                   MOVE ALLIANCE-TYPE-2174 TO HOSTVAR-ELEMENT-2         
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3        
                   MOVE CUSTOMER-NO-2174      TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3500-NO-EXISTING-SSN.                                            
                                                                        
           IF LINK-SSN-FL = 'Y'                                         
               MOVE 0 TO RS-RETURN-CODE                                 
               MOVE +150 TO RS-STATUS-CODE                              
               MOVE SPACES TO RS-FIRST-NAME                             
                              RS-MIDDLE-NAME                            
                              RS-LAST-NAME                              
               PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               ADD 1 TO  CTR-ROWS                                       
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT                  
           ELSE                                                         
               PERFORM 3300-CALL-CSR02203 THRU 3300-EXIT                
               PERFORM 3400-CALL-CSR02174 THRU 3400-EXIT
           END-IF.               
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3600-CALL-CSR02517.                                              
                                                                        
           MOVE 'I' TO ACTION-CD-2517.                                  
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-2517.                     
           MOVE AT-CUSTOMER-NO-CHAR TO CUSTOMER-NO-2517.                
           MOVE WS-PREMISE-NO-CHAR TO PREMISE-NO-2517.                  
           MOVE LINK-COMPANY-NO TO COMPANY-NO-2517.                     
           MOVE SPACES TO COMMUNICATION-ID-2517                         
                          RED-FLAG-EXP-DT-2517                          
                          PROMOTION-ID-2517                             
                          CALL-END-TIME-2517                            
                          SCREEN-POP-IND-2517                           
                          RESPONSE-RESN-CD-2517                         
                          RESPONSE-TYPE-CD-2517                         
                          SOLICITATION-CD-2517.                         
           MOVE 'N' TO RED-FLAG-IND-2517                                
                       PSC-COMPLAINT-IND-2517                           
                       COMPLAINT-FL-2517.                               
           MOVE 'O' TO COMM-METHOD-2517.                                
           MOVE 'I' TO COMM-DIRECTION-2517.                             
           MOVE '05' TO COMM-TYPE-CD-2517.                              
           MOVE '16' TO COMM-SUBTYPE-CD-2517.                           
           MOVE LINK-USER-ID TO USER-ID-ORIG-2517.                      
           MOVE 'RECEIVABLES MANAGEMENT' TO CONTACT-NAME-2517.          
           MOVE ZEROES TO CALL-ORIGIN-ID-2517                           
                          NUMBER-TRANSFERS-2517                         
                          HOLD-TIME-2517                                
                          QUEUE-TIME-2517                               
                          TOTAL-CALL-TIME-2517.                         
           MOVE 'C' TO COMM-ASSOC-CD-2517.                              
           STRING LINK-FIRST-NAME                                       
                  LINK-MIDDLE-NAME                                      
                  LINK-LAST-NAME                                        
           DELIMITED BY SIZE INTO WS-WQ-NAME.                           
A01360     STRING '***-**-' LINK-SSN(6:4)                               
A01360     DELIMITED BY SIZE INTO WS-WQ-SSN.                            
A01360*    MOVE LINK-SSN TO WS-WQ-SSN.                                          
           MOVE WS-WQ-LITERAL        TO COMMENT-TEXT-2517.              
           MOVE +100                 TO COMMENT-LEN-2517.               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02517                                             
      *           (:ACTION-CD-2517,                                     
      *            :ACCOUNT-NO-2517,                                    
      *            :CUSTOMER-NO-2517,                                   
      *            :PREMISE-NO-2517,                                    
      *            :COMMUNICATION-ID-2517,                              
      *            :COMPANY-NO-2517,                                    
      *            :RED-FLAG-IND-2517,                                  
      *            :RED-FLAG-EXP-DT-2517,                               
      *            :COMM-METHOD-2517,                                   
      *            :COMM-DIRECTION-2517,                                
      *            :COMM-TYPE-CD-2517,                                  
      *            :COMM-SUBTYPE-CD-2517,                               
      *            :USER-ID-ORIG-2517,                                  
      *            :CONTACT-NAME-2517,                                  
      *            :PROMOTION-ID-2517,                                  
      *            :PSC-COMPLAINT-IND-2517,                             
      *            :CALL-ORIGIN-ID-2517,                                
      *            :CALL-END-TIME-2517,                                 
      *            :NUMBER-TRANSFERS-2517,                              
      *            :HOLD-TIME-2517,                                     
      *            :QUEUE-TIME-2517,                                    
      *            :SCREEN-POP-IND-2517,                                
      *            :TOTAL-CALL-TIME-2517,                               
      *            :COMMENT-LEN-2517,                                   
      *            :COMMENT-TEXT-2517,                                  
      *            :COMM-ASSOC-CD-2517,                                 
      *            :COMPLAINT-FL-2517,                                  
      *            :RESPONSE-RESN-CD-2517,                              
      *            :RESPONSE-TYPE-CD-2517,                              
      *            :SOLICITATION-CD-2517)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2517 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3600'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02517'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2517)                                                
      *       WITH PROCEDURE CSR02517                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2517 CURSOR FOR RESULT SET        
      *       :LOC2517                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2517 INTO                            
                 :RETURN-CODE-2517                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2517 NOT = 0                          
                       MOVE RETURN-CODE-2517  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3600'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02517'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2517   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3600'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02517'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3600-EXIT.                                                       
            EXIT.                                                       
                                                                        
ACT233 3700-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT233     MOVE '5' TO ROUTING-CATEGORY-4675.                           
ACT233     MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT233     MOVE LINK-USER-ID TO USER-ID-ORIG-4675.                      
ACT233     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT233                    RESP-AREA-ID-4675                             
ACT233                    DATE-REQUIRED-4675                            
ACT233                    DATE-CREATED-4675                             
ACT233                    FREE-FORM-DATA-4675-TEXT.                     
ACT233     MOVE 'H' TO WQ-PRIORITY-4675                                 
ACT233     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT233     MOVE 370 TO CATEGORY-ID-4675.                                
ACT233     MOVE AT-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
ACT233     MOVE AT-PREMISE-NO TO PREMISE-NO-4675.                       
ACT233     MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-4675.                     
ACT233     MOVE ZEROES TO SERV-ORDER-NO-4675                            
ACT233     MOVE WS-WQ-LITERAL TO COMMENTS-4675-TEXT.                    
ACT233     MOVE +108 TO COMMENTS-4675-LEN.                              
ACT233     MOVE 'CSR04159' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3700'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3700'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT233                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3700'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT233             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3700-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              FULL_NAME,
              CUSTOMER_NO                                       
                 INTO :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :CE-CUSTOMER-NO                                   
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE SSN = :CE-SSN                                     
                  AND CE.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FULL_NAME,                                                
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*          INTO :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :CE-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE SSN = :CE-SSN                                             
MFA-TR*           AND CE.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SSN-EXISTS-FL                         
                   MOVE CE-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM            
                   MOVE WS-CUSTOMER-NO-CHAR TO LINK-CUSTOMER-NO         
                   IF LINK-FULL-NAME <= SPACES                          
                       MOVE DQ-FULL-NAME TO LINK-FULL-NAME              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SSN-EXISTS-FL                         
                   MOVE SPACES TO DQ-FIRST-NAME                         
                                  DQ-MIDDLE-NAME                        
                                  DQ-LAST-NAME                          
                                  DQ-FULL-NAME                          
                   MOVE ZEROES TO LINK-CUSTOMER-NO                      
                                  CE-CUSTOMER-NO                        
                                  WS-CUSTOMER-NO-NUM                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'CSS_NAME'         TO TABLE-2                   
                   MOVE 'SSN'              TO TABLE-ELEMENT-1           
                   MOVE CE-SSN             TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-GET-ACCOUNT.                                                
                                                                        
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PREMISE_NO,
              LOCAL_OFFICE,
              CUSTOMER_NO                                       
                 INTO :AT-PREMISE-NO,                                   
                      :AT-LOCAL-OFFICE,                                 
                      :AT-CUSTOMER-NO                                   
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO,                                               
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               CUSTOMER_NO                                               
MFA-TR*          INTO :AT-PREMISE-NO,                                           
MFA-TR*               :AT-LOCAL-OFFICE,                                         
MFA-TR*               :AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-PREMISE-NO TO WS-PREMISE-NO-NUM              
                   MOVE AT-CUSTOMER-NO TO AT-CUSTOMER-NO-NUM            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7050'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-USER-PROFILE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) LOCAL_OFFICE                                      
                 INTO :PF-LOCAL-OFFICE                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID  = :PF-USER-ID                            
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LOCAL_OFFICE                                              
MFA-TR*          INTO :PF-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID  = :PF-USER-ID                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-LOCAL-OFFICE                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7100'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_USER_PROFILE' TO TABLE-1                   
                   MOVE 'USER_ID'          TO TABLE-ELEMENT-1           
                   MOVE PF-USER-ID         TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CHECK-ITPA.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
                INTO :CE-CUSTOMER-NO                                    
                FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                     
               WHERE  SSN = :CE-SSN                                     
                 AND  CUSTOMER_TYPE = 'C'                               
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :CE-CUSTOMER-NO                                            
MFA-TR*         FROM   CSS_CUST_STATS                                           
MFA-TR*        WHERE  SSN = :CE-SSN                                             
MFA-TR*          AND  CUSTOMER_TYPE = 'C'                                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 7300-CREDIT-HISTORY THRU 7300-EXIT           
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7200'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'SSN'              TO TABLE-ELEMENT-1           
                   MOVE CE-SSN             TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_TYPE'    TO TABLE-ELEMENT-2           
                   MOVE 'C'                TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-CREDIT-HISTORY.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              LF.ITPA_RSLT_CURR_CD                              
               INTO :CK-CR-HIST-TRAN-DT,                                
                    :CK-CR-HIST-TRAN-TM,                                
                    :LF-ITPA-RSLT-CURR-CD                               
                 FROM CSS_CREDIT_HIST CK,                               
                      CSS_CRED_ITPA_HIST LF                             
                WHERE CK.CUSTOMER_NO = :CE-CUSTOMER-NO                  
                  AND LF.ITPA_RSLT_CURR_CD <> 'R'                       
                  AND CK.CR_HIST_TRAN_TM =                              
                     (SELECT MAX(CR_HIST_TRAN_TM)                       
                        FROM CSS_CREDIT_HIST                            
                       WHERE CUSTOMER_NO = :CE-CUSTOMER-NO              
                         AND CR_HIST_TRAN_DT =                          
                          (SELECT MAX(CR_HIST_TRAN_DT)                  
                             FROM CSS_CREDIT_HIST                       
                            WHERE CUSTOMER_NO = :CE-CUSTOMER-NO))       
                  AND CK.CR_HIST_TRAN_DT =                              
                   (SELECT MAX(CR_HIST_TRAN_DT)                         
                       FROM CSS_CREDIT_HIST                             
                 WHERE CUSTOMER_NO = :CE-CUSTOMER-NO)                   
                 AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                    
                 AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT            
                 AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM            
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     31540000
MFA-TR*        SELECT CK.CR_HIST_TRAN_DT,                               31550000
MFA-TR*               CK.CR_HIST_TRAN_TM,                               31560000
MFA-TR*               LF.ITPA_RSLT_CURR_CD                              31570000
MFA-TR*        INTO :CK-CR-HIST-TRAN-DT,                                31580000
MFA-TR*             :CK-CR-HIST-TRAN-TM,                                31590000
MFA-TR*             :LF-ITPA-RSLT-CURR-CD                               31600000
MFA-TR*          FROM CSS_CREDIT_HIST CK,                               31610000
MFA-TR*               CSS_CRED_ITPA_HIST LF                             31620000
MFA-TR*         WHERE CK.CUSTOMER_NO = :CE-CUSTOMER-NO                  31630000
MFA-TR*           AND LF.ITPA_RSLT_CURR_CD <> 'R'                       31640000
MFA-TR*           AND CK.CR_HIST_TRAN_TM =                              31650000
MFA-TR*              (SELECT MAX(CR_HIST_TRAN_TM)                       31660000
MFA-TR*                 FROM CSS_CREDIT_HIST                            31670000
MFA-TR*                WHERE CUSTOMER_NO = :CE-CUSTOMER-NO              31680000
MFA-TR*                  AND CR_HIST_TRAN_DT =                          31690000
MFA-TR*                   (SELECT MAX(CR_HIST_TRAN_DT)                  31700000
MFA-TR*                      FROM CSS_CREDIT_HIST                       31710000
MFA-TR*                     WHERE CUSTOMER_NO = :CE-CUSTOMER-NO))       31720000
MFA-TR*           AND CK.CR_HIST_TRAN_DT =                              31730000
MFA-TR*            (SELECT MAX(CR_HIST_TRAN_DT)                         31740000
MFA-TR*                FROM CSS_CREDIT_HIST                             31750000
MFA-TR*          WHERE CUSTOMER_NO = :CE-CUSTOMER-NO)                   31760000
MFA-TR*          AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                    31770000
MFA-TR*          AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT            31780000
MFA-TR*          AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM            31790000
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                31800000
MFA-TR*    END-EXEC.                                                    31810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
            WHEN SUCCESSFUL-CALL                                        
                PERFORM 3600-CALL-CSR02517 THRU 3600-EXIT               
ACT233          PERFORM 3700-CALL-CSR04675 THRU 3700-EXIT               
            WHEN NOT-FOUND                                              
                  CONTINUE                                              
            WHEN OTHER                                                  
                  MOVE PROGRAM-NAME    TO ABEND-PROGRAM                 
                  MOVE '7300'          TO ACTIVE-PARAGRAPH              
                  MOVE 'SELECT'        TO ABEND-FUNCTION                
                  MOVE 'CSS_CREDIT_HIST'  TO TABLE-1                    
                  MOVE 'CSS_CRED_HIST_ITPA'  TO TABLE-2                 
                  MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1               
                  MOVE CE-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1          
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
