       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04154.                                            
COB303 DATE-WRITTEN. JULY 22, 2008.                                      
       AUTHOR. VIDHU VALSARAJAN.                                        
      *****************************************************************         
      *                    SOUTH CAROLINA ELECTRIC & GAS              *         
      *****************************************************************         
      *                     STORED PROCEDURE:  CSR04154               *         
      *****************************************************************         
      *                           S U M M A R Y                       *         
      *    CSR04154 :                                                 *         
      *      #  RETRIEVES THE ORDERS TO BE CREATED FROM SPLIT ORDER   *         
      *      #  FUNCTIONALITY. CALLED FROM PANEL 015.                 *         
      *                                                               *         
      *****************************************************************         
      *--                                                           --*         
      *--  PARAMETERS                                               --*         
      *--      IN                                                   --*         
      *--            COMPANY_NO                                     --*         
      *--            CREATE_SCENARIO_CD                             --*         
      *--            FRO_FL                                         --*         
      *--      OUT                                                  --*         
      *--            RETURN-CODE                                    --*         
      *--            SCENARIO-SEQNO                                 --*         
      *--            SCENARIO-SEQCHOICE                             --*         
      *--            NEW-ORDER-TYPE-CD                              --*         
      *--            NEW-ELE-WKTYPE-CD                              --*         
      *--            NEW-GAS-WKTYPE-CD                              --*         
      *--            NEW-ORDER-STATE-CD                             --*         
      *--            DISPATCH-NOT-WQ-FL                             --*         
      *--            ADDTL-SO-REMARKS                               --*         
      *--            SO-HOLD-COMMENTS                               --*         
      *--            DATAWINDOW-DESC                                --*         
      *--            SCHED-DATE-FUNC-CD                             --*         
      *--            MAX-DATE                                       --*         
      *--                                                           --*         
      *--  RESULT SET                                               --*         
      *--                                                           --*         
      *--      1                                                    --*         
      *****************************************************************         
      *                           MODIFICATION LOG                    *         
      *                                                               *         
      *    DATE          INITIALS    COMMENTS                         *         
      *    ----------    --------    -------------------------------- *         
      *    07/22/2008    VV90387     NEW CODE                         *         
A00623*    02/06/2009    VV90387     APPL00000623 - ACT6232           *         
A00623*                              AUTOMATE ORDER SELECTION PROCESS *         
A00623*                              FOR SETS & REMOVES. ALSO CHECK   *         
A00623*                              EXISTING DATES FOR JUST WK TYPES *         
P00795*    01/23/2015    DB18339     ADDING ORDER_BUS_RULE_ID COLUMN  *         
P00795*    05/23/2015    DB18339     ADDING ORDER_UTILITY_CD.         *         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04154'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_SPLT_CREATE   (PREFIX = SO)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSOSPRT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_DATA          (PREFIX = VO)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_ORDER_INST    (PREFIX = VI)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * HST_SO_DATA          (PREFIX = YV)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBHSTDAT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * HST_SO_ORDER_INST    (PREFIX = ZG)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBHSTODR                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      * WORK AREAS                                                     *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME               PIC X(08) VALUE 'CSR04154'.   
           05  WS-SQLSTATE                PIC X(05) VALUE  SPACES.      
           05  ROWICMS                    PIC X(07) VALUE 'ROWICMS'.    
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN             PIC S9(04) COMP.              
               49 GTT-ROW-CHAR            PIC X(1024).                  
           05  GTT-SQLCODE                PIC S9(9) COMP.               
                                                                        
       01  FILLER                         PIC X(11) VALUE 'PARM FIELDS'.
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG               PIC X(8) VALUE 'CSRERLOG'.    
                                                                        
      ****************************************************************          
      * ERROR PROCESSING VARIABLES                                   *          
      ****************************************************************          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                  PIC X(18) VALUE SPACES.       
           10  S-SQLCODE                  PIC S9(9) COMP VALUE 0.       
           10  S-SQLSTATE                 PIC X(5)  VALUE ' '.          
           10  S-TABLE-NAME               PIC X(18) VALUE SPACES.       
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4) USAGE COMP.         
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4) USAGE COMP.         
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4) USAGE COMP.         
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L    PIC S9(4) USAGE COMP.         
               49  WS-ABEND-SQLERRMC-V    PIC X(255).                   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE               PIC S9(9) VALUE 0 COMP.       
           05 S-SCENARIO-SEQNO            PIC S9(4) VALUE 0 COMP.       
           05 S-SCENARIO-SEQCHOICE        PIC S9(4) VALUE 0 COMP.       
           05 S-NEW-ORDER-TYPE-CD         PIC X(05) VALUE SPACES.       
           05 S-NEW-ELE-WKTYPE-CD         PIC X(03) VALUE SPACES.       
           05 S-NEW-GAS-WKTYPE-CD         PIC X(03) VALUE SPACES.       
           05 S-NEW-ORDER-STATE-CD        PIC X(01) VALUE SPACES.       
           05 S-DISPATCH-NOT-WQ-FL        PIC X(01) VALUE SPACES.       
           05 S-ADDTL-SO-REMARKS          PIC X(50) VALUE SPACES.       
           05 S-SO-HOLD-COMMENTS          PIC X(25) VALUE SPACES.       
           05 S-DATAWINDOW-DESC           PIC X(60) VALUE SPACES.       
           05 S-SCHED-DATE-FUNC-CD        PIC X(01) VALUE SPACES.       
           05 S-MAX-DATE                  PIC X(10) VALUE SPACES.       
           05 S-ORD-AUTO-SELECT-CD        PIC X(01) VALUE SPACES.       
P00795     05 S-ORDER-BUS-RULE-ID         PIC X(10) VALUE SPACES.       
P00795     05 S-ORDER-UTILITY-CD          PIC X(01) VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  ABEND-CODES.                                                 
           05  DATE-ERROR                 PIC S9(9) VALUE -180 COMP.    
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-OEG-DATE-CHECK          PIC X(01) VALUE 'N'.          
           05  WS-OE-DATE-CHECK           PIC X(01) VALUE 'N'.          
           05  WS-EG-DATE-CHECK           PIC X(01) VALUE 'N'.          
           05  WS-E-DATE-CHECK            PIC X(01) VALUE 'N'.          
           05  WS-OG-DATE-CHECK           PIC X(01) VALUE 'N'.          
           05  WS-O-DATE-CHECK            PIC X(01) VALUE 'N'.          
           05  WS-G-DATE-CHECK            PIC X(01) VALUE 'N'.          
           05  WS-NULL-IND1               PIC S9(4) COMP VALUE 0.       
           05  WS-NULL-IND2               PIC S9(4) COMP VALUE 0.       
           05  WS-ASSIGNED-DT             PIC X(26) VALUE SPACES.       
           05  WS-WKTYP-EXIST-CD          PIC X(03) VALUE SPACES.       
           05  WS-CODE-UTIL-TYPE          PIC X(01) VALUE SPACES.       
           05  WS-FRO-FL                  PIC X(01) VALUE SPACES.       
                                                                        
       01  WS-VALUE-FIELDS.                                             
           05  WS-A                       PIC X(01) VALUE 'A'.          
           05  WS-E                       PIC X(01) VALUE 'E'.          
           05  WS-G                       PIC X(01) VALUE 'G'.          
           05  WS-N                       PIC X(01) VALUE 'N'.          
           05  WS-Y                       PIC X(01) VALUE 'Y'.          
           05  WS-YES                     PIC X(01) VALUE 'Y'.          
           05  WS-PREMISE-NO              PIC X(10) VALUE SPACES.       
           05  WS-PREMISE-NO-RED          REDEFINES WS-PREMISE-NO       
                                          PIC 9(10).                    
           05  WS-PREMISE-NUM             PIC S9(10) USAGE COMP         
                                                     VALUE 0.           
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE              PIC S9(9) VALUE 0 COMP.       
           05 RS-SCENARIO-SEQNO           PIC S9(4) VALUE 0 COMP.       
           05 RS-SCENARIO-SEQCHOICE       PIC S9(4) VALUE 0 COMP.       
           05 RS-NEW-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.       
           05 RS-NEW-ELE-WKTYPE-CD        PIC X(03) VALUE SPACES.       
           05 RS-NEW-GAS-WKTYPE-CD        PIC X(03) VALUE SPACES.       
           05 RS-NEW-ORDER-STATE-CD       PIC X(01) VALUE SPACES.       
           05 RS-DISPATCH-NOT-WQ-FL       PIC X(01) VALUE SPACES.       
           05 RS-ADDTL-SO-REMARKS         PIC X(50) VALUE SPACES.       
           05 RS-SO-HOLD-COMMENTS         PIC X(25) VALUE SPACES.       
           05 RS-DATAWINDOW-DESC          PIC X(60) VALUE SPACES.       
           05 RS-SCHED-DATE-FUNC-CD       PIC X(01) VALUE SPACES.       
           05 RS-MAX-DATE                 PIC X(10) VALUE SPACES.       
A00623     05 RS-ORD-AUTO-SELECT-CD       PIC X(01) VALUE SPACES.       
P00795     05 RS-ORDER-BUS-RULE-ID        PIC X(10) VALUE SPACES.       
P00795     05 RS-ORDER-UTILITY-CD         PIC X(01) VALUE SPACES.       
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
           05  SW-FETCH                   PIC X(01) VALUE 'Y'.          
               88 NO-MORE-ROWS                      VALUE 'N'.          
               88 MORE-ROWS                         VALUE 'Y'.          
                                                                        
      ******************************************************************        
      * MAIN CURSOR TO GET THE NEW ORDERS TO BE CREATED                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE SPLIT_CREATE CURSOR FOR                            
              SELECT SCENARIO_SEQNO                                     
                    ,SCENARIO_SEQCHOICE                                 
                    ,NEW_ORDER_TYPE_CD                                  
                    ,NEW_ELE_WKTYPE_CD                                  
                    ,NEW_GAS_WKTYPE_CD                                  
                    ,NEW_ORDER_STATE_CD                                 
                    ,DISPATCH_NOT_WQ_FL                                 
                    ,LTRIM(RTRIM(ADDTL_SO_REMARKS))                            
                    ,LTRIM(RTRIM(SO_HOLD_COMMENTS))                            
                    ,LTRIM(RTRIM(DATAWINDOW_DESC))                             
                    ,ORDER_TYP_EXIST_CD                                 
                    ,ELE_WKTYP_EXIST_CD                                 
                    ,GAS_WKTYP_EXIST_CD                                 
                    ,SCHED_DATE_FUNC_CD                                 
A00623              ,ORD_AUTO_SELECT_CD                                 
P00795              ,ORDER_BUS_RULE_ID                                  
P00795              ,ORDER_UTILITY_CD                                   
                FROM CSS_SO_SPLT_CREATE                                 
               WHERE COMPANY_NO         = :SO-COMPANY-NO                
                 AND CREATE_SCENARIO_CD = :SO-CREATE-SCENARIO-CD        
                 AND STATUS_CD          = 'A'                           
               ORDER BY SCENARIO_SEQNO, SCENARIO_SEQCHOICE              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE SPLIT_CREATE CURSOR FOR                                    
MFA-TR*       SELECT SCENARIO_SEQNO                                             
MFA-TR*             ,SCENARIO_SEQCHOICE                                         
MFA-TR*             ,NEW_ORDER_TYPE_CD                                          
MFA-TR*             ,NEW_ELE_WKTYPE_CD                                          
MFA-TR*             ,NEW_GAS_WKTYPE_CD                                          
MFA-TR*             ,NEW_ORDER_STATE_CD                                         
MFA-TR*             ,DISPATCH_NOT_WQ_FL                                         
MFA-TR*             ,STRIP(ADDTL_SO_REMARKS)                                    
MFA-TR*             ,STRIP(SO_HOLD_COMMENTS)                                    
MFA-TR*             ,STRIP(DATAWINDOW_DESC)                                     
MFA-TR*             ,ORDER_TYP_EXIST_CD                                         
MFA-TR*             ,ELE_WKTYP_EXIST_CD                                         
MFA-TR*             ,GAS_WKTYP_EXIST_CD                                         
MFA-TR*             ,SCHED_DATE_FUNC_CD                                         
MFA-TR*             ,ORD_AUTO_SELECT_CD                                         
MFA-TR*             ,ORDER_BUS_RULE_ID                                          
MFA-TR*             ,ORDER_UTILITY_CD                                           
MFA-TR*         FROM CSS_SO_SPLT_CREATE                                         
MFA-TR*        WHERE COMPANY_NO         = :SO-COMPANY-NO                        
MFA-TR*          AND CREATE_SCENARIO_CD = :SO-CREATE-SCENARIO-CD                
MFA-TR*          AND STATUS_CD          = 'A'                                   
MFA-TR*        ORDER BY SCENARIO_SEQNO, SCENARIO_SEQCHOICE                      
MFA-TR*    END-EXEC.                                                    00480000
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-COMPANY-NO                PIC X(02).                    
       01  PARM-CREATE-SCENARIO-CD        PIC X(15).                    
       01  PARM-FRO-FL                    PIC X(01).                    
       01  PARM-PREMISE-NO                PIC X(10).                    
                                                                        
       PROCEDURE DIVISION USING PARM-COMPANY-NO                         
                                PARM-CREATE-SCENARIO-CD                 
                                PARM-FRO-FL                             
                                PARM-PREMISE-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 0100-INITIALIZE.                                             *          
      * DECLARE ASSOCIATED CURSOR                                    *          
      ****************************************************************          
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                     RETURN_CODE                                        
                    ,SCENARIO_SEQNO                                     
                    ,SCENARIO_SEQCHOICE                                 
                    ,NEW_ORDER_TYPE_CD                                  
                    ,LTRIM(RTRIM(NEW_ELE_WKTYPE_CD))                           
                    ,LTRIM(RTRIM(NEW_GAS_WKTYPE_CD))                           
                    ,NEW_ORDER_STATE_CD                                 
                    ,DISPATCH_NOT_WQ_FL                                 
                    ,LTRIM(RTRIM(ADDTL_SO_REMARKS))                            
                    ,LTRIM(RTRIM(SO_HOLD_COMMENTS))                            
                    ,LTRIM(RTRIM(DATAWINDOW_DESC))                             
                    ,SCHED_DATE_FUNC_CD                                 
                    ,LTRIM(RTRIM(MAX_DATE))                                    
A00623              ,ORD_AUTO_SELECT_CD                                 
P00795              ,LTRIM(RTRIM(ORDER_BUS_RULE_ID))                           
P00795              ,LTRIM(RTRIM(ORDER_UTILITY_CD))                            
                FROM                                                    
                     #CSR04154_R1                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,SCENARIO_SEQNO                                             
MFA-TR*             ,SCENARIO_SEQCHOICE                                         
MFA-TR*             ,NEW_ORDER_TYPE_CD                                          
MFA-TR*             ,STRIP(NEW_ELE_WKTYPE_CD)                                   
MFA-TR*             ,STRIP(NEW_GAS_WKTYPE_CD)                                   
MFA-TR*             ,NEW_ORDER_STATE_CD                                         
MFA-TR*             ,DISPATCH_NOT_WQ_FL                                         
MFA-TR*             ,STRIP(ADDTL_SO_REMARKS)                                    
MFA-TR*             ,STRIP(SO_HOLD_COMMENTS)                                    
MFA-TR*             ,STRIP(DATAWINDOW_DESC)                                     
MFA-TR*             ,SCHED_DATE_FUNC_CD                                         
MFA-TR*             ,STRIP(MAX_DATE)                                            
MFA-TR*             ,ORD_AUTO_SELECT_CD                                         
MFA-TR*             ,STRIP(ORDER_BUS_RULE_ID)                                   
MFA-TR*             ,STRIP(ORDER_UTILITY_CD)                                    
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR04154_R1                                        
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 0100A-DECLARE-GTT.                                           *          
      * DECLARE TEMP TABLE FOR PROCESSING                            *          
      ****************************************************************          
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04154_R1'            
                                               TO S-SQL-STATEMENT-V.    
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04154_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04154_R1
              (                                                        
                      RETURN_CODE          INT                      
                     ,SCENARIO_SEQNO       INT                      
                     ,SCENARIO_SEQCHOICE   INT                      
                     ,NEW_ORDER_TYPE_CD CHAR(05)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,NEW_ELE_WKTYPE_CD CHAR(03)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,NEW_GAS_WKTYPE_CD CHAR(03)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,NEW_ORDER_STATE_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,DISPATCH_NOT_WQ_FL CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,ADDTL_SO_REMARKS CHAR(50)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,SO_HOLD_COMMENTS CHAR(25)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,DATAWINDOW_DESC CHAR(60)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,SCHED_DATE_FUNC_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,MAX_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
A00623               ,ORD_AUTO_SELECT_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
P00795               ,ORDER_BUS_RULE_ID CHAR(10)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
P00795               ,ORDER_UTILITY_CD CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                       TO WS-SQLSTATE.          
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE SQLCODE                    TO ABEND-SQLCODE         
               MOVE SQLSTATE                   TO ABEND-SQLSTATE        
               MOVE '0100A'                    TO ACTIVE-PARAGRAPH      
               MOVE 'DECLARE GTT'              TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSR04154_R1'              TO TABLE-1               
               MOVE SPACES                     TO TABLE-ELEMENT-1       
               MOVE SPACES                     TO HOSTVAR-ELEMENT-1     
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * MOVE PARAMETER VALUES.                                         *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY-NO                TO SO-COMPANY-NO.        
           MOVE PARM-CREATE-SCENARIO-CD        TO SO-CREATE-SCENARIO-CD.
           MOVE PARM-FRO-FL                    TO WS-FRO-FL.            
           MOVE PARM-PREMISE-NO                TO WS-PREMISE-NO.        
           MOVE WS-PREMISE-NO-RED              TO WS-PREMISE-NUM.       
           MOVE WS-PREMISE-NUM                 TO VO-PREMISE-NO         
                                                  YV-PREMISE-NO.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *   1.  DESCRIBE RESULT SET                                      *        
      *   2.  BUILD RESULT SET                                         *        
      *   3.  SEND RESULT SET                                          *        
      *   3.  SEND RESULT SET                                          *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT           THRU 2200-EXIT.          
           IF CTR-ROWS = 0                                              
              INITIALIZE                       TDS-RETURN-FIELDS        
              MOVE 100                         TO RS-RETURN-CODE        
              PERFORM 2100-MOVE-RESULT         THRU 2100-EXIT           
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-MOVE-RESULT.                                              *        
      * MOVE VALUES TO OUTPUT PARAMETERS                               *        
      ******************************************************************        
       2100-MOVE-RESULT.                                                
                                                                        
           MOVE '2100'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           MOVE RS-RETURN-CODE                 TO S-RETURN-CODE.        
           MOVE RS-SCENARIO-SEQNO              TO S-SCENARIO-SEQNO.     
           MOVE RS-SCENARIO-SEQCHOICE          TO S-SCENARIO-SEQCHOICE. 
           MOVE RS-NEW-ORDER-TYPE-CD           TO S-NEW-ORDER-TYPE-CD.  
           MOVE RS-NEW-ELE-WKTYPE-CD           TO S-NEW-ELE-WKTYPE-CD.  
           MOVE RS-NEW-GAS-WKTYPE-CD           TO S-NEW-GAS-WKTYPE-CD.  
           IF WS-FRO-FL = WS-Y                                          
              MOVE WS-A                        TO S-NEW-ORDER-STATE-CD  
              MOVE WS-N                        TO S-DISPATCH-NOT-WQ-FL  
              MOVE SPACES                      TO S-ADDTL-SO-REMARKS    
           ELSE                                                         
              MOVE RS-NEW-ORDER-STATE-CD       TO S-NEW-ORDER-STATE-CD  
              MOVE RS-DISPATCH-NOT-WQ-FL       TO S-DISPATCH-NOT-WQ-FL  
              MOVE RS-ADDTL-SO-REMARKS         TO S-ADDTL-SO-REMARKS    
           END-IF.                                                      
           MOVE RS-SO-HOLD-COMMENTS            TO S-SO-HOLD-COMMENTS.   
           MOVE RS-DATAWINDOW-DESC             TO S-DATAWINDOW-DESC.    
           MOVE RS-SCHED-DATE-FUNC-CD          TO S-SCHED-DATE-FUNC-CD. 
           MOVE RS-MAX-DATE                    TO S-MAX-DATE.           
A00623     MOVE RS-ORD-AUTO-SELECT-CD          TO S-ORD-AUTO-SELECT-CD. 
P00795     MOVE RS-ORDER-BUS-RULE-ID           TO S-ORDER-BUS-RULE-ID.  
P00795     MOVE RS-ORDER-UTILITY-CD            TO S-ORDER-UTILITY-CD.   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT.                                             *        
      * MAIN PROGRAM LOGIC                                             *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 7000-OPEN-CURSOR            THRU 7000-EXIT.          
           PERFORM 7100-FETCH-CURSOR           THRU 7100-EXIT.          
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               PERFORM 3200-PROCESS-ROWS       THRU 3200-EXIT           
               PERFORM 7100-FETCH-CURSOR       THRU 7100-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-CURSOR           THRU 7200-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3200-PROCESS-ROWS.                                             *        
      * DETERMINES THE DETAILS OF EACH NEW ORDER TO BE CREATED         *        
      ******************************************************************        
       3200-PROCESS-ROWS.                                               
                                                                        
           INITIALIZE                          TDS-RETURN-FIELDS        
                                               WS-WORK-FIELDS.          
                                                                        
           MOVE 0                              TO RS-RETURN-CODE.       
           MOVE SO-SCENARIO-SEQNO              TO RS-SCENARIO-SEQNO.    
           MOVE SO-SCENARIO-SEQCHOICE          TO RS-SCENARIO-SEQCHOICE.
           MOVE SO-NEW-ORDER-TYPE-CD           TO RS-NEW-ORDER-TYPE-CD. 
           MOVE SO-NEW-ELE-WKTYPE-CD           TO RS-NEW-ELE-WKTYPE-CD. 
           MOVE SO-NEW-GAS-WKTYPE-CD           TO RS-NEW-GAS-WKTYPE-CD. 
           MOVE SO-NEW-ORDER-STATE-CD          TO RS-NEW-ORDER-STATE-CD.
           MOVE SO-DISPATCH-NOT-WQ-FL          TO RS-DISPATCH-NOT-WQ-FL.
           MOVE SO-ADDTL-SO-REMARKS            TO RS-ADDTL-SO-REMARKS.  
           MOVE SO-SO-HOLD-COMMENTS            TO RS-SO-HOLD-COMMENTS.  
           MOVE SO-DATAWINDOW-DESC             TO RS-DATAWINDOW-DESC.   
           MOVE SO-SCHED-DATE-FUNC-CD          TO RS-SCHED-DATE-FUNC-CD.
A00623     MOVE SO-ORD-AUTO-SELECT-CD          TO RS-ORD-AUTO-SELECT-CD.
P00795     MOVE SO-ORDER-BUS-RULE-ID           TO RS-ORDER-BUS-RULE-ID. 
P00795     MOVE SO-ORDER-UTILITY-CD            TO RS-ORDER-UTILITY-CD.  
                                                                        
           EVALUATE TRUE                                                
               WHEN SO-ELE-WKTYP-EXIST-CD > SPACES                      
                    IF SO-ORDER-TYP-EXIST-CD > SPACES                   
                       IF SO-GAS-WKTYP-EXIST-CD > SPACES                
                          MOVE WS-YES               TO WS-OEG-DATE-CHECK
                       ELSE                                             
                          MOVE WS-YES               TO WS-OE-DATE-CHECK 
                       END-IF                                           
                    ELSE                                                
                       IF SO-GAS-WKTYP-EXIST-CD > SPACES                
                          MOVE WS-YES               TO WS-EG-DATE-CHECK 
                       ELSE                                             
                          MOVE WS-YES               TO WS-E-DATE-CHECK  
                       END-IF                                           
                    END-IF                                              
               WHEN SO-ELE-WKTYP-EXIST-CD = SPACES                      
                    IF SO-ORDER-TYP-EXIST-CD > SPACES                   
                       IF SO-GAS-WKTYP-EXIST-CD > SPACES                
                          MOVE WS-YES               TO WS-OG-DATE-CHECK 
                       ELSE                                             
                          MOVE WS-YES               TO WS-O-DATE-CHECK  
                       END-IF                                           
                    ELSE                                                
                       IF SO-GAS-WKTYP-EXIST-CD > SPACES                
                          MOVE WS-YES               TO WS-G-DATE-CHECK  
                       END-IF                                           
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
           EVALUATE TRUE                                                
              WHEN WS-OE-DATE-CHECK  = WS-YES                           
                   MOVE SO-ELE-WKTYP-EXIST-CD       TO WS-WKTYP-EXIST-CD
                   MOVE WS-E                        TO WS-CODE-UTIL-TYPE
                   PERFORM 7300-CSS-OW-MAX-DATE     THRU 7300-EXIT      
                   IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR            
                      (WS-NULL-IND1 = -1)                               
                      PERFORM 7350-HST-OW-MAX-DATE  THRU 7350-EXIT      
                   END-IF                                               
              WHEN WS-OG-DATE-CHECK  = WS-YES                           
                   MOVE SO-GAS-WKTYP-EXIST-CD       TO WS-WKTYP-EXIST-CD
                   MOVE WS-G                        TO WS-CODE-UTIL-TYPE
                   PERFORM 7300-CSS-OW-MAX-DATE     THRU 7300-EXIT      
                   IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR            
                      (WS-NULL-IND1 = -1)                               
                      PERFORM 7350-HST-OW-MAX-DATE  THRU 7350-EXIT      
                   END-IF                                               
              WHEN WS-OEG-DATE-CHECK = WS-YES                           
                   PERFORM 7400-CSS-OEG-MAX-DATE    THRU 7400-EXIT      
                   IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR            
                      (WS-NULL-IND1 = -1)                               
                      PERFORM 7450-HST-OEG-MAX-DATE THRU 7450-EXIT      
                   END-IF                                               
              WHEN WS-O-DATE-CHECK   = WS-YES                           
                   PERFORM 7500-CSS-O-MAX-DATE      THRU 7500-EXIT      
                   IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR            
                      (WS-NULL-IND1 = -1)                               
                      PERFORM 7550-HST-O-MAX-DATE   THRU 7550-EXIT      
                   END-IF                                               
A00623        WHEN WS-E-DATE-CHECK   = WS-YES                           
A00623             MOVE SO-ELE-WKTYP-EXIST-CD       TO WS-WKTYP-EXIST-CD
A00623                                                                  
A00623             MOVE WS-E                        TO WS-CODE-UTIL-TYPE
A00623             PERFORM 7600-CSS-W-MAX-DATE      THRU 7600-EXIT      
A00623             IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR            
A00623                (WS-NULL-IND1 = -1)                               
A00623                PERFORM 7650-HST-W-MAX-DATE   THRU 7650-EXIT      
A00623             END-IF                                               
A00623        WHEN WS-G-DATE-CHECK   = WS-YES                           
A00623             MOVE SO-GAS-WKTYP-EXIST-CD       TO WS-WKTYP-EXIST-CD
A00623             MOVE WS-G                        TO WS-CODE-UTIL-TYPE
A00623             PERFORM 7600-CSS-W-MAX-DATE      THRU 7600-EXIT      
A00623             IF (WS-ACTIVE-RETURN-CODE = NOT-FOUND) OR            
A00623                (WS-NULL-IND1 = -1)                               
A00623                PERFORM 7650-HST-W-MAX-DATE   THRU 7650-EXIT      
A00623             END-IF                                               
           END-EVALUATE.                                                
           EXEC SQL                                                     
              SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-ASSIGNED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ASSIGNED-DT
              ) <> 0) OR (LEN(:WS-ASSIGNED-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-ASSIGNED-DT
              ), CONVERT(DATE, :WS-ASSIGNED-DT) ),'USA')
            INTO
              :RS-MAX-DATE       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :RS-MAX-DATE =  CHAR(DATE(:WS-ASSIGNED-DT),USA)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 2100-MOVE-RESULT                 THRU 2100-EXIT.     
           PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT.     
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-OPEN-CURSOR.                                             *         
      *****************************************************************         
       7000-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN SPLIT_CREATE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'OPEN SPLIT CREATE'        TO TABLE-1               
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-CURSOR.                                             *        
      ******************************************************************        
       7100-FETCH-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH SPLIT_CREATE                                       
                INTO                                                    
                     :SO-SCENARIO-SEQNO                                 
                    ,:SO-SCENARIO-SEQCHOICE                             
                    ,:SO-NEW-ORDER-TYPE-CD                              
                    ,:SO-NEW-ELE-WKTYPE-CD                              
                    ,:SO-NEW-GAS-WKTYPE-CD                              
                    ,:SO-NEW-ORDER-STATE-CD                             
                    ,:SO-DISPATCH-NOT-WQ-FL                             
                    ,:SO-ADDTL-SO-REMARKS                               
                    ,:SO-SO-HOLD-COMMENTS                               
                    ,:SO-DATAWINDOW-DESC                                
                    ,:SO-ORDER-TYP-EXIST-CD                             
                    ,:SO-ELE-WKTYP-EXIST-CD                             
                    ,:SO-GAS-WKTYP-EXIST-CD                             
                    ,:SO-SCHED-DATE-FUNC-CD                             
A00623              ,:SO-ORD-AUTO-SELECT-CD                             
P00795              ,:SO-ORDER-BUS-RULE-ID                              
P00795              ,:SO-ORDER-UTILITY-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'FETCH'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_SO_SPLT_CREATE'        TO TABLE-1               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7200-CLOSE-CURSOR.                                            *         
      *****************************************************************         
       7200-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE SPLIT_CREATE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_SO_SPLT_CREATE'        TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
        7200-EXIT.                                                      
            EXIT.                                                       
                                                                        
      **************************************************************            
      * 7300-CSS-OW-MAX-DATE                                       *            
      * CHECKS MAX ASSIGNED DATE FOR THAT ORDER WORK TYPE COMBO    *            
      * FOR THAT PREMISE                                           *            
      **************************************************************            
       7300-CSS-OW-MAX-DATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
                INTO :WS-ASSIGNED-DT :WS-NULL-IND1                       
                FROM CSS_SO_DATA A                                      
               WHERE A.PREMISE_NO     = :VO-PREMISE-NO                  
                 AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD          
                 AND A.ORDER_STATE_CD <> 'C'                            
                 AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST C          
                     WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO           
                       AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD        
                       AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND1                               
MFA-TR*         FROM CSS_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :VO-PREMISE-NO                          
MFA-TR*          AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD                  
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*          AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST C                  
MFA-TR*              WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO                   
MFA-TR*                AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD                
MFA-TR*                AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7300'                      TO ACTIVE-PARAGRAPH      
              MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_SO_DATA'               TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7350-HST-OW-MAX-DATE                                       *            
      * CHECKS MAX ASSIGNED DATE FOR THAT ORDER WORK TYPE COMBO    *            
      * FOR THAT PREMISE                                           *            
      **************************************************************            
       7350-HST-OW-MAX-DATE.                                            
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
                INTO :WS-ASSIGNED-DT :WS-NULL-IND2                       
                FROM HST_SO_DATA A                                      
               WHERE A.PREMISE_NO     = :YV-PREMISE-NO                  
                 AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD          
                 AND A.ORDER_STATE_CD <> 'C'                            
                 AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST C          
                     WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO           
                       AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD        
                       AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND2                               
MFA-TR*         FROM HST_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :YV-PREMISE-NO                          
MFA-TR*          AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD                  
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*          AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST C                  
MFA-TR*              WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO                   
MFA-TR*                AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD                
MFA-TR*                AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND2 = -1                                      
                 MOVE SPACES                   TO WS-ASSIGNED-DT        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7350'                      TO ACTIVE-PARAGRAPH      
              MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'HST_SO_DATA'               TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7400-CSS-OEG-MAX-DATE                                      *            
      * CHECKS MAX ASSIGNED DATE FOR THAT ORDER WORK TYPE COMBO    *            
      * FOR THAT PREMISE                                           *            
      **************************************************************            
       7400-CSS-OEG-MAX-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
                INTO :WS-ASSIGNED-DT :WS-NULL-IND1                       
                FROM CSS_SO_DATA A                                      
               WHERE A.PREMISE_NO     = :VO-PREMISE-NO                  
                 AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD          
                 AND A.ORDER_STATE_CD <> 'C'                            
                 AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST C          
                     WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO           
                       AND C.WORK_TYPE_CD   = :SO-ELE-WKTYP-EXIST-CD    
                       AND C.CODE_UTIL_TYPE ='E')                       
                 AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST D          
                      WHERE A.SERV_ORDER_NO = D.SERV_ORDER_NO           
                        AND D.WORK_TYPE_CD = :SO-GAS-WKTYP-EXIST-CD     
                        AND D.CODE_UTIL_TYPE ='G')                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND1                               
MFA-TR*         FROM CSS_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :VO-PREMISE-NO                          
MFA-TR*          AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD                  
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*          AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST C                  
MFA-TR*              WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO                   
MFA-TR*                AND C.WORK_TYPE_CD   = :SO-ELE-WKTYP-EXIST-CD            
MFA-TR*                AND C.CODE_UTIL_TYPE ='E')                               
MFA-TR*          AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST D                  
MFA-TR*               WHERE A.SERV_ORDER_NO = D.SERV_ORDER_NO                   
MFA-TR*                 AND D.WORK_TYPE_CD = :SO-GAS-WKTYP-EXIST-CD             
MFA-TR*                 AND D.CODE_UTIL_TYPE ='G')                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7400'                      TO ACTIVE-PARAGRAPH      
              MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_SO_DATA'               TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7450-HST-OEG-MAX-DATE                                      *            
      * CHECKS MAX ASSIGNED DATE FOR THAT ORDER WORK TYPE COMBO    *            
      * FOR THAT PREMISE                                           *            
      **************************************************************            
       7450-HST-OEG-MAX-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
                INTO :WS-ASSIGNED-DT :WS-NULL-IND2                       
                FROM HST_SO_DATA A                                      
               WHERE A.PREMISE_NO     = :YV-PREMISE-NO                  
                 AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD          
                 AND A.ORDER_STATE_CD <> 'C'                            
                 AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST C          
                     WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO           
                       AND C.WORK_TYPE_CD   = :SO-ELE-WKTYP-EXIST-CD    
                       AND C.CODE_UTIL_TYPE ='E')                       
                 AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST D          
                      WHERE A.SERV_ORDER_NO = D.SERV_ORDER_NO           
                        AND D.WORK_TYPE_CD = :SO-GAS-WKTYP-EXIST-CD     
                        AND D.CODE_UTIL_TYPE ='G')                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND2                               
MFA-TR*         FROM HST_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :YV-PREMISE-NO                          
MFA-TR*          AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD                  
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*          AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST C                  
MFA-TR*              WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO                   
MFA-TR*                AND C.WORK_TYPE_CD   = :SO-ELE-WKTYP-EXIST-CD            
MFA-TR*                AND C.CODE_UTIL_TYPE ='E')                               
MFA-TR*          AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST D                  
MFA-TR*               WHERE A.SERV_ORDER_NO = D.SERV_ORDER_NO                   
MFA-TR*                 AND D.WORK_TYPE_CD = :SO-GAS-WKTYP-EXIST-CD             
MFA-TR*                 AND D.CODE_UTIL_TYPE ='G')                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND2 = -1                                      
                 MOVE SPACES                   TO WS-ASSIGNED-DT        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7450'                      TO ACTIVE-PARAGRAPH      
              MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'HST_SO_DATA'               TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-CSS-O-MAX-DATE                                           *         
      * CHECKS MAX ASSIGNED DATE FOR THAT ORDER TYPE FOR THAT PREMISE *         
      *****************************************************************         
       7500-CSS-O-MAX-DATE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
                INTO :WS-ASSIGNED-DT :WS-NULL-IND1                       
                FROM CSS_SO_DATA A                                      
               WHERE A.PREMISE_NO     = :VO-PREMISE-NO                  
                 AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD          
                 AND A.ORDER_STATE_CD <> 'C'                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND1                               
MFA-TR*         FROM CSS_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :VO-PREMISE-NO                          
MFA-TR*          AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD                  
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7500'                      TO ACTIVE-PARAGRAPH      
              MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_SO_DATA'               TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7550-HST-O-MAX-DATE                                           *         
      * CHECKS MAX ASSIGNED DATE FOR THAT ORDER TYPE FOR THAT PREMISE *         
      *****************************************************************         
       7550-HST-O-MAX-DATE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
                INTO :WS-ASSIGNED-DT :WS-NULL-IND2                       
                FROM HST_SO_DATA A                                      
               WHERE A.PREMISE_NO     = :YV-PREMISE-NO                  
                 AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD          
                 AND A.ORDER_STATE_CD <> 'C'                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND2                               
MFA-TR*         FROM HST_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :YV-PREMISE-NO                          
MFA-TR*          AND A.ORDER_TYPE_CD  = :SO-ORDER-TYP-EXIST-CD                  
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND2 = -1                                      
                 MOVE SPACES                   TO WS-ASSIGNED-DT        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7550'                      TO ACTIVE-PARAGRAPH      
              MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'HST_SO_DATA'               TO TABLE-1               
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
A00623**************************************************************            
A00623* 7600-CSS-W-MAX-DATE                                        *            
A00623* CHECKS MAX ASSIGNED DATE FOR THAT WORK TYPE FOR THAT PREMISE            
A00623**************************************************************            
A00623 7600-CSS-W-MAX-DATE.                                             
A00623                                                                  
A00623     EXEC SQL                                                     
A00623        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
A00623          INTO :WS-ASSIGNED-DT :WS-NULL-IND1                       
A00623          FROM CSS_SO_DATA A                                      
A00623         WHERE A.PREMISE_NO     = :VO-PREMISE-NO                  
A00623           AND A.ORDER_STATE_CD <> 'C'                            
A00623           AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST C          
A00623               WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO           
A00623                 AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD        
A00623                 AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)       
A00623     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND1                               
MFA-TR*         FROM CSS_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :VO-PREMISE-NO                          
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*          AND EXISTS (SELECT 1 FROM CSS_SO_ORDER_INST C                  
MFA-TR*              WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO                   
MFA-TR*                AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD                
MFA-TR*                AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00623                                                                  
A00623     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A00623                                                                  
A00623     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00623        NEXT SENTENCE                                             
A00623     ELSE                                                         
A00623        MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
A00623        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
A00623        MOVE '7600'                      TO ACTIVE-PARAGRAPH      
A00623        MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
A00623        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
A00623                                            ABEND-TABLES          
A00623        MOVE 'CSS_SO_DATA'               TO TABLE-1               
A00623        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00623        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00623      END-IF.                                                     
A00623                                                                  
A00623 7600-EXIT.                                                       
A00623     EXIT.                                                        
A00623                                                                  
A00623**************************************************************            
A00623* 7650-HST-W-MAX-DATE                                        *            
A00623* CHECKS MAX ASSIGNED DATE FOR THAT WORK TYPE FOR THAT PREMISE            
A00623**************************************************************            
A00623 7650-HST-W-MAX-DATE.                                             
A00623                                                                  
A00623     EXEC SQL                                                     
A00623        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           ASSIGNED_DATETIME), 121), ' ', '-'), ':', '.')                      
A00623          INTO :WS-ASSIGNED-DT :WS-NULL-IND2                       
A00623          FROM HST_SO_DATA A                                      
A00623         WHERE A.PREMISE_NO     = :YV-PREMISE-NO                  
A00623           AND A.ORDER_STATE_CD <> 'C'                            
A00623           AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST C          
A00623               WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO           
A00623                 AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD        
A00623                 AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)       
A00623     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ASSIGNED_DATETIME)                                     
MFA-TR*         INTO :WS-ASSIGNED-DT:WS-NULL-IND2                               
MFA-TR*         FROM HST_SO_DATA A                                              
MFA-TR*        WHERE A.PREMISE_NO     = :YV-PREMISE-NO                          
MFA-TR*          AND A.ORDER_STATE_CD <> 'C'                                    
MFA-TR*          AND EXISTS (SELECT 1 FROM HST_SO_ORDER_INST C                  
MFA-TR*              WHERE A.SERV_ORDER_NO  = C.SERV_ORDER_NO                   
MFA-TR*                AND C.WORK_TYPE_CD   = :WS-WKTYP-EXIST-CD                
MFA-TR*                AND C.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00623                                                                  
A00623     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A00623                                                                  
A00623     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00623        IF WS-NULL-IND2 = -1                                      
A00623           MOVE SPACES                   TO WS-ASSIGNED-DT        
A00623        END-IF                                                    
A00623     ELSE                                                         
A00623        MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
A00623        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
A00623        MOVE '7650'                      TO ACTIVE-PARAGRAPH      
A00623        MOVE 'MAX DATE'                  TO ABEND-FUNCTION        
A00623        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
A00623                                            ABEND-TABLES          
A00623        MOVE 'HST_SO_DATA'               TO TABLE-1               
A00623        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
A00623        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
A00623      END-IF.                                                     
A00623                                                                  
A00623 7650-EXIT.                                                       
A00623     EXIT.                                                        
A00623                                                                  
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04154_R1                         
                (                                                       
                    RETURN_CODE                                         
                   ,SCENARIO_SEQNO                                      
                   ,SCENARIO_SEQCHOICE                                  
                   ,NEW_ORDER_TYPE_CD                                   
                   ,NEW_ELE_WKTYPE_CD                                   
                   ,NEW_GAS_WKTYPE_CD                                   
                   ,NEW_ORDER_STATE_CD                                  
                   ,DISPATCH_NOT_WQ_FL                                  
                   ,ADDTL_SO_REMARKS                                    
                   ,SO_HOLD_COMMENTS                                    
                   ,DATAWINDOW_DESC                                     
                   ,SCHED_DATE_FUNC_CD                                  
                   ,MAX_DATE                                            
A00623             ,ORD_AUTO_SELECT_CD                                  
P00795             ,ORDER_BUS_RULE_ID                                   
P00795             ,ORDER_UTILITY_CD                                    
               )                                                        
                VALUES                                                  
               (                                                        
                    :S-RETURN-CODE                                      
                   ,:S-SCENARIO-SEQNO                                   
                   ,:S-SCENARIO-SEQCHOICE                               
                   ,:S-NEW-ORDER-TYPE-CD                                
                   ,:S-NEW-ELE-WKTYPE-CD                                
                   ,:S-NEW-GAS-WKTYPE-CD                                
                   ,:S-NEW-ORDER-STATE-CD                               
                   ,:S-DISPATCH-NOT-WQ-FL                               
                   ,:S-ADDTL-SO-REMARKS                                 
                   ,:S-SO-HOLD-COMMENTS                                 
                   ,:S-DATAWINDOW-DESC                                  
                   ,:S-SCHED-DATE-FUNC-CD                               
                   ,:S-MAX-DATE                                         
A00623             ,:S-ORD-AUTO-SELECT-CD                               
P00795             ,:S-ORDER-BUS-RULE-ID                                
P00795             ,:S-ORDER-UTILITY-CD                                 
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04154_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,SCENARIO_SEQNO                                              
MFA-TR*            ,SCENARIO_SEQCHOICE                                          
MFA-TR*            ,NEW_ORDER_TYPE_CD                                           
MFA-TR*            ,NEW_ELE_WKTYPE_CD                                           
MFA-TR*            ,NEW_GAS_WKTYPE_CD                                           
MFA-TR*            ,NEW_ORDER_STATE_CD                                          
MFA-TR*            ,DISPATCH_NOT_WQ_FL                                          
MFA-TR*            ,ADDTL_SO_REMARKS                                            
MFA-TR*            ,SO_HOLD_COMMENTS                                            
MFA-TR*            ,DATAWINDOW_DESC                                             
MFA-TR*            ,SCHED_DATE_FUNC_CD                                          
MFA-TR*            ,MAX_DATE                                                    
MFA-TR*            ,ORD_AUTO_SELECT_CD                                          
MFA-TR*            ,ORDER_BUS_RULE_ID                                           
MFA-TR*            ,ORDER_UTILITY_CD                                            
MFA-TR*        )                                                                
MFA-TR*         VALUES                                                          
MFA-TR*        (                                                                
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-SCENARIO-SEQNO                                           
MFA-TR*            ,:S-SCENARIO-SEQCHOICE                                       
MFA-TR*            ,:S-NEW-ORDER-TYPE-CD                                        
MFA-TR*            ,:S-NEW-ELE-WKTYPE-CD                                        
MFA-TR*            ,:S-NEW-GAS-WKTYPE-CD                                        
MFA-TR*            ,:S-NEW-ORDER-STATE-CD                                       
MFA-TR*            ,:S-DISPATCH-NOT-WQ-FL                                       
MFA-TR*            ,:S-ADDTL-SO-REMARKS                                         
MFA-TR*            ,:S-SO-HOLD-COMMENTS                                         
MFA-TR*            ,:S-DATAWINDOW-DESC                                          
MFA-TR*            ,:S-SCHED-DATE-FUNC-CD                                       
MFA-TR*            ,:S-MAX-DATE                                                 
MFA-TR*            ,:S-ORD-AUTO-SELECT-CD                                       
MFA-TR*            ,:S-ORDER-BUS-RULE-ID                                        
MFA-TR*            ,:S-ORDER-UTILITY-CD                                         
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                          TO CTR-ROWS               
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE SQLSTATE                   TO ABEND-SQLSTATE         
              MOVE 'CSR04154_R1'              TO TABLE-1                
              MOVE 'CREATE_SCENARIO_CD'       TO TABLE-ELEMENT-1        
              MOVE SO-CREATE-SCENARIO-CD      TO HOSTVAR-ELEMENT-1      
              MOVE 'SCENARIO_SEQNO'           TO TABLE-ELEMENT-2        
              MOVE SO-SCENARIO-SEQNO          TO HOSTVAR-ELEMENT-2      
              MOVE 'SCENARIO_SEQCHOICE'       TO TABLE-ELEMENT-3        
              MOVE SO-SCENARIO-SEQCHOICE      TO HOSTVAR-ELEMENT-3      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-JOURNALING / ERROR HANDLING INCLUDE                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
