       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04153.                                            
       DATE-WRITTEN. JULY 17, 2008.                                     
       AUTHOR. VIDHU VALSARAJAN.                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      * THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM DESKTOP 2000.*        
      * THIS STORED PROCEDURE IS CALLED FROM PANEL 015.                *        
      *                                                                *        
      * THIS PROGRAM DETERMINES IF THE ORDER NEEDS TO BE SPLIT AND     *        
      * RETURNS THE SPLIT SCENARIO CODE AND OTHER ORDER DETAILS.       *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
C34590*  07/17/08  VV90387    INITIAL CODE.                            *        
A02196*  07/08/10  VV90387    NEED NOT SPLIT FOR SPECIAL ELEC OR GAS   *        
A02196*                       METERS IN METRO AREAS FOR NON CRAWL      *        
A02196*                       SITUATIONS.                              *        
A02196*  09/16/10  VV90387    PASS CODE UTIL TYPE FOR GAS LARGE METER  *        
P00447*  09/16/10  VV90387    CHECK IF CONSTANT = 0 AS NOW LARGE METERS*        
P00447*                       CONSTANT WOULD BE CHANGED TO 0 WHEN      *        
P00447*                       ATTACHMENTS ARE REMOVED AND MOVED TO     *        
P00447*                       INVENTORY                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04153'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04153 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    SQL COMMUNICATION AREA                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_SPLT_ORIG      (PREFIX = SR)                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOSPOR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTRD_ENVRNMT     (PREFIX = MN)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_REGISTER_READ     (PREFIX = RG)                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRGREAD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT          (PREFIX = AT)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MTR_CAP          (PREFIX = MC)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_METER       (PREFIX = EM)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_CL_SPEC     (PREFIX = U0)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBELCLSP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ELEC_MTR_CLASS   (PREFIX = U4)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBEMTRCL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_GAS_METER        (PREFIX = GM)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT     (PREFIX = UT)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PRICE_SCHED      (PREFIX = PS)                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SO_DATA          (PREFIX = VO)                             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
A02196******************************************************************        
A02196* CSS_LOCAL_OFFICE     (PREFIX = B1)                             *        
A02196******************************************************************        
A02196     EXEC SQL                                                             
A02196         INCLUDE TBLOCOFC                                                 
A02196     END-EXEC.                                                            
A02196                                                                  
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04153'.    
           05  GWL-STATUS-SUBCODE        PIC S9(9) COMP.                
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(9)  COMP.               
           05  PARM-COMPANY-NO           PIC X(02)  VALUE SPACES.       
           05  PARM-LOCAL-OFFICE-CD      PIC X(03)  VALUE SPACES.       
           05  PARM-ORIG-ORDER-TYPE-CD   PIC X(05)  VALUE SPACES.       
           05  PARM-ORIG-ELE-WKTYPE-CD   PIC X(03)  VALUE SPACES.       
           05  PARM-ORIG-GAS-WKTYPE-CD   PIC X(03)  VALUE SPACES.       
           05  PARM-RELEASE-CD           PIC X(01)  VALUE SPACES.       
           05  PARM-APPL-CRAWL-CD        PIC X(01)  VALUE SPACES.       
           05  PARM-ACCOUNT-NO           PIC X(13)  VALUE SPACES.       
           05  PARM-ACCOUNT-NO-RED       REDEFINES  PARM-ACCOUNT-NO     
                                         PIC 9(13).                     
           05  PARM-ACCOUNT-NUM          PIC S9(13)V USAGE COMP VALUE 0.
           05  PARM-E-IC-NUM             PIC S9(04) USAGE COMP VALUE 0. 
           05  PARM-E-MTR-REF-NUM        PIC S9(04) USAGE COMP VALUE 0. 
           05  PARM-G-IC-NUM             PIC S9(04) USAGE COMP VALUE 0. 
           05  PARM-G-MTR-REF-NUM        PIC S9(04) USAGE COMP VALUE 0. 
           05  PARM-CALLING-SYSTEM       PIC X(03)  VALUE SPACES.       
           05  PARM-PREMISE-NO           PIC X(10)  VALUE SPACES.       
           05  PARM-PREMISE-NO-RED       REDEFINES  PARM-PREMISE-NO     
                                         PIC 9(10).                     
           05  PARM-PREMISE-NUM          PIC S9(10) USAGE COMP VALUE 0. 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-RCVPRM               PIC X(20)      VALUE SPACES.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISCELLANEOUS.                                            
           05  WS-NOACCOUNT            PIC X(01) VALUE 'N'.             
           05  WS-CONSTANT             PIC X(01) VALUE SPACES.          
           05  WS-RELEASE-CD           PIC X(01) VALUE SPACES.          
           05  WS-APPL-CRAWL-CD        PIC X(01) VALUE SPACES.          
           05  WS-E-MTRD               PIC X(01) VALUE 'N'.             
           05  WS-G-MTRD               PIC X(01) VALUE 'N'.             
           05  WS-E-ROW                PIC X(01) VALUE SPACES.          
           05  WS-G-ROW                PIC X(01) VALUE SPACES.          
           05  WS-LARGE-ELEC           PIC X(01) VALUE SPACES.          
           05  WS-LARGE-GAS            PIC X(01) VALUE SPACES.          
           05  WS-LARGE-MTR            PIC X(01) VALUE SPACES.          
           05  WS-SPECIAL-GMTR         PIC X(01) VALUE SPACES.          
           05  WS-SPLT-ROW             PIC X(01) VALUE SPACES.          
           05  WS-TOU-METER-FL         PIC X(01) VALUE SPACES.          
           05  WS-TOU-RATE-FL          PIC X(01) VALUE SPACES.          
           05  WS-TOU                  PIC X(01) VALUE SPACES.          
           05  WS-TOU-ACCOUNT          PIC X(01) VALUE SPACES.          
           05  WS-SPLT-TOU-VAL         PIC X(01) VALUE 'N'.             
           05  WS-E-METER-NO           PIC X(09) VALUE SPACES.          
           05  WS-E-IC-NO              PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-E-MTR-REF-NO         PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-E-CODE-TIME-PERIOD   PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-E-REG-ID-NO          PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-E-MTR-STATUS         PIC X(01) VALUE SPACES.          
           05  WS-G-METER-NO           PIC X(09) VALUE SPACES.          
           05  WS-G-IC-NO              PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-G-MTR-REF-NO         PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-G-CODE-TIME-PERIOD   PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-G-REG-ID-NO          PIC S9(04) USAGE COMP VALUE 0.   
           05  WS-G-MTR-STATUS         PIC X(01) VALUE SPACES.          
           05  WS-CHK-GASMTR-STATUS    PIC X(01) VALUE 'N'.             
           05  WS-CHK-STATUS-MATCH     PIC X(01) VALUE 'N'.             
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-A                    PIC X(01) VALUE 'A'.             
           05  WS-B                    PIC X(01) VALUE 'B'.             
           05  WS-C                    PIC X(01) VALUE 'C'.             
           05  WS-3                    PIC X(01) VALUE '3'.             
           05  WS-E                    PIC X(01) VALUE 'E'.             
           05  WS-G                    PIC X(01) VALUE 'G'.             
           05  WS-SPLIT-NON-TOU        PIC X(01) VALUE 'X'.             
           05  WS-SPLIT-TOU-ONLY       PIC X(01) VALUE 'T'.             
           05  WS-SPLIT-BOTH           PIC X(01) VALUE 'B'.             
           05  WS-ALWAYS-SPLIT         PIC X(01) VALUE 'A'.             
           05  WS-NEVER-SPLIT          PIC X(01) VALUE 'N'.             
           05  WS-COMMERCIAL           PIC X(01) VALUE 'C'.             
           05  WS-E-AND-G              PIC X(01) VALUE 'A'.             
           05  WS-ELEC                 PIC X(01) VALUE 'E'.             
           05  WS-GAS                  PIC X(02) VALUE 'G '.            
           05  WS-E-OR-G               PIC X(01) VALUE 'O'.             
           05  WS-B-ROW                PIC X(01) VALUE 'N'.             
           05  WS-INACTIVE             PIC X(01) VALUE 'J'.             
           05  WS-REMOVED              PIC X(01) VALUE 'K'.             
           05  WS-DW1                  PIC X(01) VALUE '1'.             
           05  WS-DW2                  PIC X(01) VALUE '2'.             
           05  WS-B01                  PIC X(03) VALUE 'B01'.           
           05  WS-B26                  PIC X(03) VALUE 'B26'.           
           05  WS-SCEG                 PIC X(02) VALUE '01'.            
           05  WS-PSNC                 PIC X(02) VALUE '26'.            
           05  WS-BOLT-IN              PIC X(07) VALUE SPACES.          
           05  WS-3-PHASE              PIC X(01) VALUE SPACES.          
           05  WS-ERROR                PIC X(01) VALUE 'E'.             
           05  WS-ERROR-MSG            PIC X(05) VALUE 'SP001'.         
           05  WS-PHONE                PIC X(12) VALUE SPACES.          
           05  WS-811                  PIC S9(4) COMP  VALUE -811.      
           05  WS-305                  PIC S9(4) COMP  VALUE -305.      
           05  WS-OFF01                PIC X(05) VALUE 'OFF01'.         
           05  WS-OFF02                PIC X(05) VALUE 'OFF02'.         
           05  WS-OFF03                PIC X(05) VALUE 'OFF03'.         
           05  WS-TOU-MSG              PIC X(05) VALUE 'SP012'.         
           05  WS-TOU-OFF-ERROR-MSG    PIC X(05) VALUE SPACES.          
A02196     05  WS-METRO                PIC X(05) VALUE 'METRO'.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  RS-SPLIT-CD            PIC X(01)      VALUE SPACES.      
           05  RS-CREATE-SCENARIO-CD  PIC X(15)      VALUE SPACES.      
           05  RS-ERROR-MSG-NO        PIC X(05)      VALUE SPACES.      
           05  RS-DATAWINDOW-DISP-CD  PIC X(01)      VALUE SPACES.      
           05  RS-TOU-OFF-ERROR-MSG   PIC X(05)      VALUE SPACES.      
           05  RS-TOU-ACCOUNT         PIC X(01)      VALUE SPACES.      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW            PIC X(01)      VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW           PIC X(01)      VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-COMPANY-NO               PIC X(02).                     
       01  LINK-LOCAL-OFFICE-CD          PIC X(03).                     
       01  LINK-ORIG-ORDER-TYPE-CD       PIC X(05).                     
       01  LINK-ORIG-ELE-WKTYPE-CD       PIC X(03).                     
       01  LINK-ORIG-GAS-WKTYPE-CD       PIC X(03).                     
       01  LINK-RELEASE-CD               PIC X(01).                     
       01  LINK-APPL-CRAWL-CD            PIC X(01).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
       01  LINK-E-IC-NUM                 PIC S9(04) COMP.               
       01  LINK-E-MTR-REF-NUM            PIC S9(04) COMP.               
       01  LINK-G-IC-NUM                 PIC S9(04) COMP.               
       01  LINK-G-MTR-REF-NUM            PIC S9(04) COMP.               
       01  LINK-CALLING-SYSTEM           PIC X(03).                     
       01  LINK-PREMISE-NO               PIC X(10).                     
                                                                        
       PROCEDURE DIVISION USING          LINK-COMPANY-NO                
                                        ,LINK-LOCAL-OFFICE-CD           
                                        ,LINK-ORIG-ORDER-TYPE-CD        
                                        ,LINK-ORIG-ELE-WKTYPE-CD        
                                        ,LINK-ORIG-GAS-WKTYPE-CD        
                                        ,LINK-RELEASE-CD                
                                        ,LINK-APPL-CRAWL-CD             
                                        ,LINK-ACCOUNT-NO                
                                        ,LINK-E-IC-NUM                  
                                        ,LINK-E-MTR-REF-NUM             
                                        ,LINK-G-IC-NUM                  
                                        ,LINK-G-MTR-REF-NUM             
                                        ,LINK-CALLING-SYSTEM            
                                        ,LINK-PREMISE-NO.               
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM.                     *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. DECLARE CURSOR                                          *        
      *     2. RECEIVE INPUT PARAMETRS                                 *        
      *     3. INITIALIZE OUTPUT PARAMETERS                            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE                AS RETURN_CODE       
                    ,:RS-SPLIT-CD                  AS SPLIT_CD          
                    ,LTRIM(RTRIM(:RS-CREATE-SCENARIO-CD)) AS 
           CREATE_SCENARIO_CD
                    ,LTRIM(RTRIM(:RS-ERROR-MSG-NO))       AS 
           ERROR_MSG_NO      
                    ,:RS-DATAWINDOW-DISP-CD        AS DW_DISPLAY_CD     
                    ,LTRIM(RTRIM(:RS-TOU-OFF-ERROR-MSG))  AS 
           TOU_OFF_ERROR_MSG 
                    ,:RS-TOU-ACCOUNT               AS TOU_ACCOUNT       
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE                AS RETURN_CODE               
MFA-TR*             ,:RS-SPLIT-CD                  AS SPLIT_CD                  
MFA-TR*             ,STRIP(:RS-CREATE-SCENARIO-CD) AS CREATE_SCENARIO_CD        
MFA-TR*             ,STRIP(:RS-ERROR-MSG-NO)       AS ERROR_MSG_NO              
MFA-TR*             ,:RS-DATAWINDOW-DISP-CD        AS DW_DISPLAY_CD             
MFA-TR*             ,STRIP(:RS-TOU-OFF-ERROR-MSG)  AS TOU_OFF_ERROR_MSG         
MFA-TR*             ,:RS-TOU-ACCOUNT               AS TOU_ACCOUNT               
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-COMPANY-NO              TO PARM-COMPANY-NO.        
           MOVE LINK-LOCAL-OFFICE-CD         TO PARM-LOCAL-OFFICE-CD.   
           MOVE LINK-ORIG-ORDER-TYPE-CD      TO PARM-ORIG-ORDER-TYPE-CD.
           MOVE LINK-ORIG-ELE-WKTYPE-CD      TO PARM-ORIG-ELE-WKTYPE-CD.
           MOVE LINK-ORIG-GAS-WKTYPE-CD      TO PARM-ORIG-GAS-WKTYPE-CD.
           MOVE LINK-RELEASE-CD              TO PARM-RELEASE-CD.        
           MOVE LINK-APPL-CRAWL-CD           TO PARM-APPL-CRAWL-CD.     
           MOVE LINK-ACCOUNT-NO              TO PARM-ACCOUNT-NO.        
           MOVE LINK-E-IC-NUM                TO PARM-E-IC-NUM.          
           MOVE LINK-E-MTR-REF-NUM           TO PARM-E-MTR-REF-NUM.     
           MOVE LINK-G-IC-NUM                TO PARM-G-IC-NUM.          
           MOVE LINK-G-MTR-REF-NUM           TO PARM-G-MTR-REF-NUM.     
           MOVE LINK-CALLING-SYSTEM          TO PARM-CALLING-SYSTEM.    
           MOVE LINK-PREMISE-NO              TO PARM-PREMISE-NO.        
                                                                        
           INITIALIZE                        S-RETURN-CODE              
                                             RS-SPLIT-CD                
                                             RS-CREATE-SCENARIO-CD      
                                             RS-ERROR-MSG-NO            
                                             RS-DATAWINDOW-DISP-CD      
                                             RS-TOU-OFF-ERROR-MSG       
                                             RS-TOU-ACCOUNT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     RECEIVE PARARMETERS AND MOVE TO NUMERIC FIELDS.            *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-COMPANY-NO               TO SR-COMPANY-NO          
                                                 MC-COMPANY-NO          
                                                 GM-COMPANY-NO.         
           MOVE PARM-LOCAL-OFFICE-CD          TO SR-LOCAL-OFFICE-CD     
A02196                                           B1-LOCAL-OFFICE.       
           MOVE PARM-ORIG-ORDER-TYPE-CD       TO SR-ORIG-ORDER-TYPE-CD. 
           MOVE PARM-ORIG-ELE-WKTYPE-CD       TO SR-ORIG-ELE-WKTYPE-CD. 
           MOVE PARM-ORIG-GAS-WKTYPE-CD       TO SR-ORIG-GAS-WKTYPE-CD. 
           MOVE PARM-RELEASE-CD               TO WS-RELEASE-CD.         
           MOVE PARM-APPL-CRAWL-CD            TO WS-APPL-CRAWL-CD.      
                                                                        
           MOVE PARM-ACCOUNT-NO-RED           TO PARM-ACCOUNT-NUM.      
                                                                        
           MOVE PARM-ACCOUNT-NUM              TO MN-ACCOUNT-NO          
                                                 RG-ACCOUNT-NO          
                                                 UT-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO.         
           MOVE PARM-E-IC-NUM                 TO WS-E-IC-NO.            
           MOVE PARM-E-MTR-REF-NUM            TO WS-E-MTR-REF-NO.       
           MOVE PARM-G-IC-NUM                 TO WS-G-IC-NO.            
           MOVE PARM-G-MTR-REF-NUM            TO WS-G-MTR-REF-NO.       
           MOVE PARM-PREMISE-NO-RED           TO PARM-PREMISE-NUM.      
           MOVE PARM-PREMISE-NUM              TO VO-PREMISE-NO          
                                                                        
           IF PARM-COMPANY-NO         = SPACES  OR                      
              PARM-LOCAL-OFFICE-CD    = SPACES  OR                      
              PARM-ORIG-ORDER-TYPE-CD = SPACES                          
              MOVE WS-ERROR                   TO RS-SPLIT-CD            
              MOVE WS-ERROR-MSG               TO RS-ERROR-MSG-NO        
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7900-GET-LOCAL-OFFICE      THRU 7900-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811         
              PERFORM 1500-VALIDATE-ROW       THRU 1500-EXIT            
           ELSE                                                         
               IF SR-COMPANY-NO = WS-SCEG                               
                  MOVE WS-B01                 TO SR-LOCAL-OFFICE-CD     
               ELSE                                                     
                  MOVE WS-B26                 TO SR-LOCAL-OFFICE-CD     
               END-IF                                                   
               PERFORM 7900-GET-LOCAL-OFFICE  THRU 7900-EXIT            
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811     
                  PERFORM 1500-VALIDATE-ROW   THRU 1500-EXIT            
               ELSE                                                     
                  PERFORM 3500A-DONT-SPLIT    THRU 3500A-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1500-VALIDATE-ROW                                              *        
      *     DETERMINE THE MATCHING ROW IN CSS_SO_SPLT_ORIG BASED ON    *        
      *     TOU AND GAS METER STATUS CODES.                            *        
      *                                                                *        
      *     CALLED BY: 1000-PROCESS-INPUT                              *        
      ******************************************************************        
       1500-VALIDATE-ROW.                                               
                                                                        
           MOVE '1500'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 7015-GET-GAS-MTR-STATUS       THRU 7015-EXIT.        
                                                                        
           IF MN-ACCOUNT-NO > 0                                         
              IF WS-CHK-GASMTR-STATUS EQUAL WS-YES                      
                 MOVE WS-G-IC-NO                 TO MN-IC-NO            
                 MOVE WS-G-MTR-REF-NO            TO MN-MTR-REF-NO       
                 MOVE WS-GAS                     TO MN-CODE-UTIL-TYPE   
                 PERFORM 7100-DETERMINE-MTR-DETAILS       THRU 7100-EXIT
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE WS-YES                  TO WS-G-MTRD           
                    MOVE MN-METER-NO             TO WS-G-METER-NO       
                    MOVE MN-CODE-TIME-PERIOD     TO                     
                                                 WS-G-CODE-TIME-PERIOD  
                    MOVE MN-REG-ID-NO            TO WS-G-REG-ID-NO      
                    MOVE MN-CODE-METER-STATUS    TO WS-G-MTR-STATUS     
                    PERFORM 7020-STATUS-MATCH    THRU 7020-EXIT         
                    IF WS-CHK-STATUS-MATCH  =    WS-YES                 
                       MOVE MN-CODE-METER-STATUS TO                     
                                                 SR-GAS-MTR-STATUS-CD   
                    ELSE                                                
                       MOVE WS-NO                TO SR-GAS-MTR-STATUS-CD
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-NO                   TO SR-GAS-MTR-STATUS-CD
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-NO                      TO SR-GAS-MTR-STATUS-CD
              END-IF                                                    
                                                                        
              PERFORM 7025-GET-SPLT-TOU-VAL   THRU 7025-EXIT            
              MOVE WS-E-IC-NO                 TO MN-IC-NO               
              MOVE WS-E-MTR-REF-NO            TO MN-MTR-REF-NO          
              MOVE WS-ELEC                    TO MN-CODE-UTIL-TYPE      
              PERFORM 7100-DETERMINE-MTR-DETAILS       THRU 7100-EXIT   
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-YES                  TO WS-E-MTRD              
                 MOVE MN-METER-NO             TO WS-E-METER-NO          
                 MOVE MN-CODE-TIME-PERIOD     TO                        
                                                 WS-E-CODE-TIME-PERIOD  
                 MOVE MN-REG-ID-NO            TO WS-E-REG-ID-NO         
                 MOVE MN-CODE-METER-STATUS    TO WS-E-MTR-STATUS        
                 IF WS-SPLT-TOU-VAL = WS-Y                              
                    IF WS-E-MTR-STATUS NOT EQUAL WS-REMOVED             
                       PERFORM 7200-DETERMINE-TOU         THRU 7200-EXIT
                       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
                          MOVE WS-YES            TO WS-TOU              
                       ELSE                                             
                          MOVE WS-NO             TO WS-TOU              
                       END-IF                                           
                    ELSE                                                
                       MOVE WS-NO                TO WS-TOU              
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-NO                   TO WS-TOU              
                 END-IF                                                 
              ELSE                                                      
                 IF WS-SPLT-TOU-VAL = WS-Y                              
                    PERFORM 7225-GET-RATE-PLAN            THRU 7225-EXIT
                    PERFORM 7250-CHECK-TOU                THRU 7250-EXIT
                    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
                       MOVE WS-YES               TO WS-TOU              
                    ELSE                                                
                       MOVE WS-NO                TO WS-TOU              
                    END-IF                                              
                 ELSE                                                   
                    MOVE WS-NO                   TO WS-TOU              
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO                         TO WS-TOU              
                                                    SR-GAS-MTR-STATUS-CD
              MOVE WS-YES                        TO WS-NOACCOUNT        
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1550-VALIDATE-OFFS.                                            *        
      *      WHEN TOU CHECK TO SEE IF THERE IS ANY ACTIVE/ON HOLD OFFS *        
      *                                                                *        
      *      CALLED BY: 2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       1550-VALIDATE-OFFS.                                              
                                                                        
           MOVE '1550'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7075-CHECK-EXISTING-OFFS   THRU 7075-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EVALUATE VO-ORDER-TYPE-CD                                 
                  WHEN WS-OFF01                                         
                       MOVE WS-OFF02          TO WS-TOU-OFF-ERROR-MSG   
                  WHEN WS-OFF02                                         
                       MOVE WS-OFF03          TO WS-TOU-OFF-ERROR-MSG   
                  WHEN WS-OFF03                                         
                       MOVE WS-TOU-MSG        TO WS-TOU-OFF-ERROR-MSG   
                  WHEN OTHER                                            
                       MOVE SPACES            TO WS-TOU-OFF-ERROR-MSG   
              END-EVALUATE                                              
           ELSE                                                         
              MOVE SPACES                     TO WS-TOU-OFF-ERROR-MSG   
              MOVE ZEROES                     TO WS-ACTIVE-RETURN-CODE  
           END-IF.                                                      
                                                                        
       1550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *      SET UP PARAMETERS TO BE RETURNED.                         *        
      *                                                                *        
      *      CALLED BY: 0000-MAINLINE                                  *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
           PERFORM 3500A-DONT-SPLIT           THRU 3500A-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      *     CALLED BY:  2000-PROCESS-OUTPUT                            *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           IF WS-SPLT-TOU-VAL = WS-YES                                  
              IF WS-TOU       = WS-YES                                  
                 MOVE WS-SPLIT-BOTH                 TO SR-TOU-RATE-FL   
                 PERFORM 7000-GET-SPLIT-DETAILS     THRU 7000-EXIT      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE WS-SPLIT-TOU-ONLY          TO SR-TOU-RATE-FL   
                    PERFORM 7000-GET-SPLIT-DETAILS  THRU 7000-EXIT      
                 ELSE                                                   
                    MOVE WS-YES                     TO WS-B-ROW         
                 END-IF                                                 
                 MOVE WS-YES                        TO WS-TOU-ACCOUNT   
                 PERFORM 1550-VALIDATE-OFFS         THRU 1550-EXIT      
              ELSE                                                      
                 MOVE WS-SPLIT-NON-TOU              TO SR-TOU-RATE-FL   
                 MOVE WS-NO                         TO WS-TOU-ACCOUNT   
                 PERFORM 7000-GET-SPLIT-DETAILS     THRU 7000-EXIT      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO                            TO SR-TOU-RATE-FL   
              MOVE WS-NO                            TO WS-TOU-ACCOUNT   
              PERFORM 7000-GET-SPLIT-DETAILS        THRU 7000-EXIT      
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL              
                                                                        
              PERFORM 2300-CHECK-SPLIT-CD           THRU 2300-EXIT      
                                                                        
              IF SR-COMMERCIAL-RATE-FL   = WS-YES                       
                 PERFORM 2400-CHECK-COMMERCIAL      THRU 2400-EXIT      
              END-IF                                                    
                                                                        
              IF SR-RELEASE-CD NOT EQUAL   WS-NO                        
                 PERFORM 2500-CHECK-RELEASE         THRU 2500-EXIT      
              END-IF                                                    
                                                                        
              IF WS-NOACCOUNT            = WS-NO                        
                 IF SR-METER-CD NOT EQUAL     WS-NO                     
                    PERFORM 2600-CHECK-MTR-CONSTANT THRU 2600-EXIT      
                 END-IF                                                 
                                                                        
                                                                        
                 IF SR-SPEC-ELE-METER-CD NOT EQUAL WS-NO                
                    PERFORM 2700-CHECK-SPECIAL-EMTR THRU 2700-EXIT      
                 END-IF                                                 
                                                                        
                 IF SR-SPEC-GAS-METER-CD NOT EQUAL WS-NO                
                    PERFORM 2800-CHECK-SPECIAL-GMTR THRU 2800-EXIT      
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF SR-APPL-CRAWL-CD NOT EQUAL WS-NO                       
                 PERFORM 2900-CHECK-APPL-CRAWL      THRU 2900-EXIT      
              END-IF                                                    
                                                                        
              PERFORM 3500-DONT-SPLIT               THRU 3500-EXIT      
                                                                        
           ELSE                                                         
              PERFORM 3500-DONT-SPLIT               THRU 3500-EXIT      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-CHECK-SPLIT-CD.                                           *        
      *     CHECK TO SEE IF THE ORDER NEEDS TO BE SPLIT OR NOT         *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2300-CHECK-SPLIT-CD.                                             
                                                                        
           IF WS-SPLT-TOU-VAL = WS-NO                                   
              IF SR-ORDER-SPLIT-CD            =  WS-ALWAYS-SPLIT        
                 PERFORM 3000-SEND-SPLIT-INFO       THRU 3000-EXIT      
              ELSE                                                      
                 IF SR-ORDER-SPLIT-CD         =  WS-NEVER-SPLIT         
                    PERFORM 3500-DONT-SPLIT         THRU 3500-EXIT      
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF WS-B-ROW     = WS-YES                                  
                 IF SR-ORDER-SPLIT-CD         =  WS-ALWAYS-SPLIT        
                    PERFORM 3000A-SEND-SPLIT-INFO   THRU 3000A-EXIT     
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-CHECK-COMMERCIAL.                                         *        
      *     CHECK IF ITS A COMMERCIAL ACCOUNT TO DETERMINE IF THE ORDER*        
      *     NEEDS TO BE SPLIT.                                         *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2400-CHECK-COMMERCIAL.                                           
                                                                        
           IF WS-NOACCOUNT  = WS-NO                                     
              PERFORM  7300-DETERMINE-COMMERCIAL    THRU 7300-EXIT      
                                                                        
              IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL              
                 IF AT-ACCOUNT-TYPE-CODE = WS-COMMERCIAL                
                    PERFORM 3000-SEND-SPLIT-INFO    THRU 3000-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-CHECK-RELEASE.                                            *        
      *     CHECK IF RELEASE CODE PASSED INTO SP MATCHES THE SPLIT     *        
      *     CRITERIA.                                                  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2500-CHECK-RELEASE.                                              
                                                                        
            IF  (WS-RELEASE-CD = SR-RELEASE-CD)  OR                     
               ((WS-RELEASE-CD = WS-ELEC)       AND                     
                (SR-RELEASE-CD = WS-E-OR-G))     OR                     
               ((WS-RELEASE-CD = WS-GAS)        AND                     
                (SR-RELEASE-CD = WS-E-OR-G))     OR                     
               ((WS-RELEASE-CD = WS-A  )        AND                     
                (SR-RELEASE-CD = WS-E-OR-G))                            
               PERFORM 3000-SEND-SPLIT-INFO     THRU 3000-EXIT          
            END-IF.                                                     
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-CHECK-MTR-CONSTANT                                        *        
      *     CHECK IF THE METER HAS A CONSTANT GREATER THAN 1           *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2600-CHECK-MTR-CONSTANT.                                         
                                                                        
           MOVE SR-COMPANY-NO             TO MC-COMPANY-NO              
           MOVE WS-ELEC                   TO MC-CODE-UTIL-TYPE          
           IF WS-E-MTRD = WS-NO                                         
              MOVE WS-E-IC-NO             TO MN-IC-NO                   
              MOVE WS-E-MTR-REF-NO        TO MN-MTR-REF-NO              
              PERFORM 7100-DETERMINE-MTR-DETAILS       THRU 7100-EXIT   
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-YES              TO WS-E-ROW                   
              END-IF                                                    
           END-IF.                                                      
           IF (WS-E-ROW = WS-YES OR WS-E-MTRD = WS-YES)                 
              MOVE WS-E-METER-NO          TO MC-METER-NO                
              MOVE WS-E-REG-ID-NO         TO MC-REG-ID-NO               
              PERFORM 7400-GET-MTR-CONSTANT  THRU 7400-EXIT             
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE WS-E                TO WS-LARGE-ELEC              
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-GAS                    TO MC-CODE-UTIL-TYPE          
A02196                                       MN-CODE-UTIL-TYPE          
           IF WS-G-MTRD = WS-NO                                         
              MOVE WS-G-IC-NO             TO MN-IC-NO                   
              MOVE WS-G-MTR-REF-NO        TO MN-MTR-REF-NO              
              PERFORM 7100-DETERMINE-MTR-DETAILS       THRU 7100-EXIT   
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 GO TO 2600-EXIT                                        
              END-IF                                                    
           END-IF.                                                      
           MOVE WS-GAS                    TO MC-CODE-UTIL-TYPE          
           MOVE WS-G-METER-NO             TO MC-METER-NO                
           MOVE WS-G-REG-ID-NO            TO MC-REG-ID-NO               
           PERFORM 7400-GET-MTR-CONSTANT  THRU 7400-EXIT                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-G                   TO WS-LARGE-GAS               
           END-IF                                                       
                                                                        
           IF (WS-LARGE-ELEC = WS-E) AND (WS-LARGE-GAS = WS-G)          
              MOVE WS-A                   TO WS-LARGE-MTR               
           END-IF                                                       
                                                                        
           EVALUATE TRUE                                                
               WHEN SR-METER-CD = WS-E-OR-G                             
                    IF ((WS-LARGE-ELEC = WS-E) OR                       
                        (WS-LARGE-GAS = WS-G))                          
                         PERFORM 3000-SEND-SPLIT-INFO   THRU 3000-EXIT  
                    END-IF                                              
               WHEN SR-METER-CD = WS-LARGE-ELEC                         
               WHEN SR-METER-CD = WS-LARGE-GAS                          
               WHEN SR-METER-CD = WS-LARGE-MTR                          
                    PERFORM 3000-SEND-SPLIT-INFO      THRU 3000-EXIT    
           END-EVALUATE.                                                
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-CHECK-SPECIAL-EMTR                                        *        
      *     CHECK IF THE ELECTRIC METER IS A BOLT-IN OR A 3 PHASE METER*        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2700-CHECK-SPECIAL-EMTR.                                         
                                                                        
           MOVE WS-ELEC                      TO MN-CODE-UTIL-TYPE.      
           IF WS-E-MTRD = WS-NO                                         
              MOVE WS-E-IC-NO                TO MN-IC-NO                
              MOVE WS-E-MTR-REF-NO           TO MN-MTR-REF-NO           
              PERFORM 7100-DETERMINE-MTR-DETAILS  THRU 7100-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE MN-METER-NO            TO WS-E-METER-NO           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7500-GET-ELEC-MTR-DTLS    THRU 7500-EXIT.            
                                                                        
           PERFORM 7600-CHECK-BOLT-IN-MTR    THRU 7600-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-B                      TO WS-BOLT-IN              
           END-IF.                                                      
                                                                        
           PERFORM 7700-CHECK-3-PHASE-MTR    THRU 7700-EXIT             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-3                      TO WS-3-PHASE              
           END-IF.                                                      
                                                                        
A02196     PERFORM 7910-CHECK-METRO-AREA     THRU 7910-EXIT.            
                                                                        
           EVALUATE TRUE                                                
               WHEN SR-SPEC-ELE-METER-CD = WS-E-OR-G                    
                    IF ((WS-BOLT-IN = WS-B) OR (WS-3-PHASE = WS-3))     
A02196                 IF B1-SERV-ORDER-WORK-CD = WS-METRO              
A02196                    IF WS-APPL-CRAWL-CD NOT EQUAL WS-NO           
A02196                       PERFORM 3000-SEND-SPLIT-INFO THRU 3000-EXIT
A02196                    END-IF                                        
A02196                 ELSE                                             
                          PERFORM 3000-SEND-SPLIT-INFO    THRU 3000-EXIT
A02196                 END-IF                                           
                    END-IF                                              
               WHEN SR-SPEC-ELE-METER-CD = WS-BOLT-IN                   
               WHEN SR-SPEC-ELE-METER-CD = WS-3-PHASE                   
A02196                 IF B1-SERV-ORDER-WORK-CD = WS-METRO              
A02196                    IF WS-APPL-CRAWL-CD NOT EQUAL WS-NO           
A02196                       PERFORM 3000-SEND-SPLIT-INFO THRU 3000-EXIT
A02196                    END-IF                                        
A02196                 ELSE                                             
                          PERFORM 3000-SEND-SPLIT-INFO    THRU 3000-EXIT
A02196                 END-IF                                           
           END-EVALUATE.                                                
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2800-CHECK-SPECIAL-GMTR                                        *        
      *     CHECK IF THE GAS METER HAS CCF_CAP_PER_HR IS >= 3000       *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2800-CHECK-SPECIAL-GMTR.                                         
                                                                        
           MOVE WS-GAS                    TO MN-CODE-UTIL-TYPE          
           IF WS-G-MTRD = WS-NO                                         
              MOVE WS-G-IC-NO             TO MN-IC-NO                   
              MOVE WS-G-MTR-REF-NO        TO MN-MTR-REF-NO              
              PERFORM 7100-DETERMINE-MTR-DETAILS  THRU 7100-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE MN-METER-NO         TO WS-G-METER-NO              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7800-GET-GAS-METER        THRU 7800-EXIT.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-C                      TO WS-SPECIAL-GMTR         
           END-IF.                                                      
                                                                        
           IF SR-SPEC-GAS-METER-CD = WS-SPECIAL-GMTR                    
              PERFORM 3000-SEND-SPLIT-INFO   THRU 3000-EXIT             
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2900-CHECK-APPL-CRAWL                                          *        
      *     CHECK IF THE APPLIANCE CRAWL WOULD NEED ORDER TO SPLIT     *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       2900-CHECK-APPL-CRAWL.                                           
                                                                        
            IF  (WS-APPL-CRAWL-CD = SR-APPL-CRAWL-CD)  OR               
               ((WS-APPL-CRAWL-CD = WS-ELEC)          AND               
                (SR-APPL-CRAWL-CD = WS-E-OR-G))        OR               
               ((WS-APPL-CRAWL-CD = WS-GAS)           AND               
                (SR-APPL-CRAWL-CD = WS-E-OR-G))        OR               
               ((WS-APPL-CRAWL-CD = WS-A  )           AND               
                (SR-APPL-CRAWL-CD = WS-E-OR-G))                         
               PERFORM 3000-SEND-SPLIT-INFO     THRU 3000-EXIT          
            END-IF.                                                     
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000-SEND-SPLIT-INFO.                                          *        
      *     CHECKS TO SEE IF IT SPLITS NON TOU OR TOU CONDITIONS       *        
      *                                                                *        
      ******************************************************************        
       3000-SEND-SPLIT-INFO.                                            
                                                                        
           IF WS-SPLT-TOU-VAL = WS-YES                                  
              IF WS-TOU       = WS-YES                                  
                 IF SR-TOU-RATE-FL = WS-SPLIT-TOU-ONLY                  
                    MOVE WS-SPLIT-BOTH               TO SR-TOU-RATE-FL  
                    PERFORM 7050-GET-SCENARIO-CD     THRU 7050-EXIT     
                    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                       PERFORM 3500A-DONT-SPLIT      THRU 3500A-EXIT    
                    END-IF                                              
                    PERFORM 3000A-SEND-SPLIT-INFO    THRU 3000A-EXIT    
                 ELSE                                                   
                    PERFORM 3000A-SEND-SPLIT-INFO    THRU 3000A-EXIT    
                 END-IF                                                 
              ELSE                                                      
                PERFORM 3000A-SEND-SPLIT-INFO        THRU 3000A-EXIT    
              END-IF                                                    
           ELSE                                                         
              PERFORM 3000A-SEND-SPLIT-INFO          THRU 3000A-EXIT    
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000A-SEND-SPLIT-INFO.                                         *        
      *     SENDS THE THE SPLIT SCENARIO CODE AND OTHER RELAVANT DETAILS        
      *                                                                *        
      ******************************************************************        
       3000A-SEND-SPLIT-INFO.                                           
                                                                        
           MOVE 0                          TO S-RETURN-CODE.            
           MOVE WS-YES                     TO RS-SPLIT-CD.              
           MOVE SR-CREATE-SCENARIO-CD      TO RS-CREATE-SCENARIO-CD.    
           MOVE SR-ERROR-MSG-NO            TO RS-ERROR-MSG-NO.          
           MOVE SR-DATAWINDOW-DISP-CD      TO RS-DATAWINDOW-DISP-CD.    
           MOVE WS-TOU-OFF-ERROR-MSG       TO RS-TOU-OFF-ERROR-MSG.     
           MOVE WS-TOU-ACCOUNT             TO RS-TOU-ACCOUNT.           
                                                                        
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       3000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3500-DONT-SPLIT.                                               *        
      *     THIS ORDER DOES NOT REQUIRE TO SPLIT BUT DETERMINE THE     *        
      *     SCENARIO CODE TO BE SENT BACK IF TOU.                               
      *                                                                *        
      ******************************************************************        
       3500-DONT-SPLIT.                                                 
                                                                        
           IF WS-SPLT-TOU-VAL = WS-YES                                  
              IF WS-TOU       = WS-YES                                  
                 MOVE WS-SPLIT-TOU-ONLY           TO SR-TOU-RATE-FL     
                 PERFORM 7050-GET-SCENARIO-CD     THRU 7050-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 3500A-DONT-SPLIT      THRU 3500A-EXIT       
                 ELSE                                                   
                    PERFORM 3000A-SEND-SPLIT-INFO THRU 3000A-EXIT       
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 3500A-DONT-SPLIT         THRU 3500A-EXIT       
              END-IF                                                    
           ELSE                                                         
              PERFORM 3500A-DONT-SPLIT            THRU 3500A-EXIT       
           END-IF.                                                      
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3500A-DONT-SPLIT.                                              *        
      *     THIS ORDER DOES NOT REQUIRE TO SPLIT                       *        
      *                                                                *        
      ******************************************************************        
       3500A-DONT-SPLIT.                                                
                                                                        
           MOVE 0                          TO S-RETURN-CODE.            
           MOVE WS-NO                      TO RS-SPLIT-CD.              
           MOVE SPACES                     TO RS-CREATE-SCENARIO-CD     
                                              RS-ERROR-MSG-NO           
                                              RS-DATAWINDOW-DISP-CD     
                                              RS-TOU-OFF-ERROR-MSG.     
           MOVE WS-TOU-ACCOUNT             TO RS-TOU-ACCOUNT.           
                                                                        
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       3500A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-SPLIT-DETAILS.                                        *        
      *     GET ALL SPLIT DETAILS FOR THAT LOCAL OFFICE,ORDER,E/G WORK *        
      *     TYPE COMBINATION                                           *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7000-GET-SPLIT-DETAILS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO                                         
                    ,LOCAL_OFFICE_CD                                    
                    ,ORIG_ORDER_TYPE_CD                                 
                    ,ORIG_ELE_WKTYPE_CD                                 
                    ,ORIG_GAS_WKTYPE_CD                                 
                    ,CREATE_SCENARIO_CD                                 
                    ,ORDER_SPLIT_CD                                     
                    ,COMMERCIAL_RATE_FL                                 
                    ,RELEASE_CD                                         
                    ,METER_CD                                           
                    ,SPEC_ELE_METER_CD                                  
                    ,SPEC_GAS_METER_CD                                  
                    ,APPL_CRAWL_CD                                      
                    ,ERROR_MSG_NO                                       
                    ,DATAWINDOW_DISP_CD                                 
                INTO :SR-COMPANY-NO                                     
                    ,:SR-LOCAL-OFFICE-CD                                
                    ,:SR-ORIG-ORDER-TYPE-CD                             
                    ,:SR-ORIG-ELE-WKTYPE-CD                             
                    ,:SR-ORIG-GAS-WKTYPE-CD                             
                    ,:SR-CREATE-SCENARIO-CD                             
                    ,:SR-ORDER-SPLIT-CD                                 
                    ,:SR-COMMERCIAL-RATE-FL                             
                    ,:SR-RELEASE-CD                                     
                    ,:SR-METER-CD                                       
                    ,:SR-SPEC-ELE-METER-CD                              
                    ,:SR-SPEC-GAS-METER-CD                              
                    ,:SR-APPL-CRAWL-CD                                  
                    ,:SR-ERROR-MSG-NO                                   
                    ,:SR-DATAWINDOW-DISP-CD                             
                FROM CSS_SO_SPLT_ORIG WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO         = :SR-COMPANY-NO                
                 AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD           
                 AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD        
                 AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD        
                 AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD        
                 AND TOU_RATE_FL        = :SR-TOU-RATE-FL               
                 AND GAS_MTR_STATUS_CD  = :SR-GAS-MTR-STATUS-CD         
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*             ,LOCAL_OFFICE_CD                                            
MFA-TR*             ,ORIG_ORDER_TYPE_CD                                         
MFA-TR*             ,ORIG_ELE_WKTYPE_CD                                         
MFA-TR*             ,ORIG_GAS_WKTYPE_CD                                         
MFA-TR*             ,CREATE_SCENARIO_CD                                         
MFA-TR*             ,ORDER_SPLIT_CD                                             
MFA-TR*             ,COMMERCIAL_RATE_FL                                         
MFA-TR*             ,RELEASE_CD                                                 
MFA-TR*             ,METER_CD                                                   
MFA-TR*             ,SPEC_ELE_METER_CD                                          
MFA-TR*             ,SPEC_GAS_METER_CD                                          
MFA-TR*             ,APPL_CRAWL_CD                                              
MFA-TR*             ,ERROR_MSG_NO                                               
MFA-TR*             ,DATAWINDOW_DISP_CD                                         
MFA-TR*         INTO :SR-COMPANY-NO                                             
MFA-TR*             ,:SR-LOCAL-OFFICE-CD                                        
MFA-TR*             ,:SR-ORIG-ORDER-TYPE-CD                                     
MFA-TR*             ,:SR-ORIG-ELE-WKTYPE-CD                                     
MFA-TR*             ,:SR-ORIG-GAS-WKTYPE-CD                                     
MFA-TR*             ,:SR-CREATE-SCENARIO-CD                                     
MFA-TR*             ,:SR-ORDER-SPLIT-CD                                         
MFA-TR*             ,:SR-COMMERCIAL-RATE-FL                                     
MFA-TR*             ,:SR-RELEASE-CD                                             
MFA-TR*             ,:SR-METER-CD                                               
MFA-TR*             ,:SR-SPEC-ELE-METER-CD                                      
MFA-TR*             ,:SR-SPEC-GAS-METER-CD                                      
MFA-TR*             ,:SR-APPL-CRAWL-CD                                          
MFA-TR*             ,:SR-ERROR-MSG-NO                                           
MFA-TR*             ,:SR-DATAWINDOW-DISP-CD                                     
MFA-TR*         FROM CSS_SO_SPLT_ORIG                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD                   
MFA-TR*          AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD                
MFA-TR*          AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD                
MFA-TR*          AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD                
MFA-TR*          AND TOU_RATE_FL        = :SR-TOU-RATE-FL                       
MFA-TR*          AND GAS_MTR_STATUS_CD  = :SR-GAS-MTR-STATUS-CD                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_SPLT_ORIG'         TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE SR-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-2        
              MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'TOU_RATE_FL'              TO TABLE-ELEMENT-3        
              MOVE SR-TOU-RATE-FL             TO HOSTVAR-ELEMENT-3      
              MOVE 'GAS_MTR_STATUS_CD'        TO TABLE-ELEMENT-4        
              MOVE SR-GAS-MTR-STATUS-CD       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7015-GET-GAS-MTR-STATUS                                        *        
      *     GET THE METER STATUS DEFINED IN THE TABLE                  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7015-GET-GAS-MTR-STATUS.                                         
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CHK-GASMTR-STATUS                              
                FROM CSS_SO_SPLT_ORIG WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO         = :SR-COMPANY-NO                
                 AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD           
                 AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD        
                 AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD        
                 AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD        
                 AND GAS_MTR_STATUS_CD  <> 'N'                          
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CHK-GASMTR-STATUS                                      
MFA-TR*         FROM CSS_SO_SPLT_ORIG                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD                   
MFA-TR*          AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD                
MFA-TR*          AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD                
MFA-TR*          AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD                
MFA-TR*          AND GAS_MTR_STATUS_CD  <> 'N'                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7015                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                      OR WS-811                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7015'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_SPLT_ORIG'         TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE SR-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-2        
              MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'ORIG_ORDER_TYPE'          TO TABLE-ELEMENT-3        
              MOVE SR-ORIG-ORDER-TYPE-CD      TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-STATUS-MATCH                                              *        
      *     GET THE METER STATUS DEFINED IN THE TABLE                  *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7020-STATUS-MATCH.                                               
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CHK-STATUS-MATCH                               
                FROM CSS_SO_SPLT_ORIG WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO         = :SR-COMPANY-NO                
                 AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD           
                 AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD        
                 AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD        
                 AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD        
                 AND GAS_MTR_STATUS_CD  = :MN-CODE-METER-STATUS         
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CHK-STATUS-MATCH                                       
MFA-TR*         FROM CSS_SO_SPLT_ORIG                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD                   
MFA-TR*          AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD                
MFA-TR*          AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD                
MFA-TR*          AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD                
MFA-TR*          AND GAS_MTR_STATUS_CD  = :MN-CODE-METER-STATUS                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                      OR WS-811                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_SPLT_ORIG'         TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE SR-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-2        
              MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'ORIG_ORDER_TYPE'          TO TABLE-ELEMENT-3        
              MOVE SR-ORIG-ORDER-TYPE-CD      TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-GET-SPLT-TOU-VAL.                                         *        
      *     CHECK TO SEE IF THERE ARE TOU SCENARIO ROWS.               *        
      *     CC ORDERS HAVE TOU SCENARIOS AND WOULD HAVE A X,T & B ROW  *        
      *     IN THE TOU_RATE_FL FIELD INSTEAD OF 'N'.                   *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7025-GET-SPLT-TOU-VAL.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-SPLT-TOU-VAL                                   
                FROM CSS_SO_SPLT_ORIG                                   
               WHERE COMPANY_NO         = :SR-COMPANY-NO                
                 AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD           
                 AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD        
                 AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD        
                 AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD        
                 AND TOU_RATE_FL        <> 'N'                          
                 AND GAS_MTR_STATUS_CD  = :SR-GAS-MTR-STATUS-CD         
                                                  
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SPLT-TOU-VAL                                           
MFA-TR*         FROM CSS_SO_SPLT_ORIG                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD                   
MFA-TR*          AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD                
MFA-TR*          AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD                
MFA-TR*          AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD                
MFA-TR*          AND TOU_RATE_FL        <> 'N'                                  
MFA-TR*          AND GAS_MTR_STATUS_CD  = :SR-GAS-MTR-STATUS-CD                 
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*      QUERYNO 7025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                                         WS-811         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7025'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_SPLT_ORIG'         TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE SR-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-2        
              MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'GAS_MTR_STATUS_CD'        TO TABLE-ELEMENT-3        
              MOVE SR-GAS-MTR-STATUS-CD       TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-GET-SCENARIO-CD.                                          *        
      *     GET THE CORRECT SCENARIO CODE FOR TOU                      *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7050-GET-SCENARIO-CD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT CREATE_SCENARIO_CD                                 
                INTO :SR-CREATE-SCENARIO-CD                             
                FROM CSS_SO_SPLT_ORIG WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO         = :SR-COMPANY-NO                
                 AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD           
                 AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD        
                 AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD        
                 AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD        
                 AND TOU_RATE_FL        = :SR-TOU-RATE-FL               
                 AND GAS_MTR_STATUS_CD  = :SR-GAS-MTR-STATUS-CD         
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CREATE_SCENARIO_CD                                         
MFA-TR*         INTO :SR-CREATE-SCENARIO-CD                                     
MFA-TR*         FROM CSS_SO_SPLT_ORIG                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD                   
MFA-TR*          AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD                
MFA-TR*          AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD                
MFA-TR*          AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD                
MFA-TR*          AND TOU_RATE_FL        = :SR-TOU-RATE-FL                       
MFA-TR*          AND GAS_MTR_STATUS_CD  = :SR-GAS-MTR-STATUS-CD                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7050                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_SPLT_ORIG'         TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE SR-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-2        
              MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-2      
              MOVE 'TOU_RATE_FL'              TO TABLE-ELEMENT-3        
              MOVE SR-TOU-RATE-FL             TO HOSTVAR-ELEMENT-3      
              MOVE 'GAS_MTR_STATUS_CD'        TO TABLE-ELEMENT-4        
              MOVE SR-GAS-MTR-STATUS-CD       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7075-CHECK-EXISTING-OFFS                                       *        
      *     CHECK IF THERE ARE ANY ACTIVE/ON HOLD OFF ORDERS           *        
      *                                                                *        
      *     CALLED BY:  1550-VALIDATE-OFFS                             *        
      ******************************************************************        
       7075-CHECK-EXISTING-OFFS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(ORDER_TYPE_CD)                                 
                INTO :VO-ORDER-TYPE-CD                                  
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO                =  :VO-PREMISE-NO        
                 AND CIS.SUBSTR3(ORDER_TYPE_CD,1,3) =  'OFF'                 
                 AND ORDER_STATE_CD            <> 'Z'                   
                 AND ORDER_STATE_CD            <> 'C'                   
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(ORDER_TYPE_CD)                                         
MFA-TR*         INTO :VO-ORDER-TYPE-CD                                          
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO                =  :VO-PREMISE-NO                
MFA-TR*          AND SUBSTR(ORDER_TYPE_CD,1,3) =  'OFF'                         
MFA-TR*          AND ORDER_STATE_CD            <> 'Z'                           
MFA-TR*          AND ORDER_STATE_CD            <> 'C'                           
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7075                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                      OR WS-305                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7075'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_DATA'              TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE VO-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-DETERMINE-MTR-STATUS                                      *        
      *     GET THE GAS METER STATUS                                   *        
      *                                                                *        
      *     CALLED BY:  1500-VALIDATE-ROW                              *        
      ******************************************************************        
       7100-DETERMINE-MTR-DETAILS.                                      
                                                                        
           EXEC SQL                                                     
              SELECT CODE_METER_STATUS                                  
                    ,METER_NO                                           
                    ,CODE_TIME_PERIOD                                   
                    ,REG_ID_NO                                          
                INTO :MN-CODE-METER-STATUS                              
                    ,:MN-METER-NO                                       
                    ,:MN-CODE-TIME-PERIOD                               
                    ,:MN-REG-ID-NO                                      
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE            
                 AND IC_NO              = :MN-IC-NO                     
                 AND MTR_REF_NO         = :MN-MTR-REF-NO                
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_METER_STATUS                                          
MFA-TR*             ,METER_NO                                                   
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,REG_ID_NO                                                  
MFA-TR*         INTO :MN-CODE-METER-STATUS                                      
MFA-TR*             ,:MN-METER-NO                                               
MFA-TR*             ,:MN-CODE-TIME-PERIOD                                       
MFA-TR*             ,:MN-REG-ID-NO                                              
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :MN-CODE-UTIL-TYPE                    
MFA-TR*          AND IC_NO              = :MN-IC-NO                             
MFA-TR*          AND MTR_REF_NO         = :MN-MTR-REF-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-DETERMINE-TOU                                             *        
      *     METER LEVEL CHECK FOR TIME OF USE RATE                     *        
      *                                                                *        
      *     CALLED BY:  1500-VALIDATE-ROW                              *        
      ******************************************************************        
       7200-DETERMINE-TOU.                                              
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-TOU-METER-FL                                   
                FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO         = :RG-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = 'E'                           
                 AND IC_NO              = :WS-E-IC-NO                   
                 AND MTR_REF_NO         = :WS-E-MTR-REF-NO              
                 AND REG_ID_NO          = :WS-E-REG-ID-NO               
                 AND CODE_TIME_PERIOD   > 0                             
                 AND CODE_REG_STATUS    = 'A'                           
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT 'Y'                                               
MFA-TR*         INTO :WS-TOU-METER-FL                                           
MFA-TR*         FROM CSS_REGISTER_READ                                          
MFA-TR*        WHERE ACCOUNT_NO         = :RG-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*          AND IC_NO              = :WS-E-IC-NO                           
MFA-TR*          AND MTR_REF_NO         = :WS-E-MTR-REF-NO                      
MFA-TR*          AND REG_ID_NO          = :WS-E-REG-ID-NO                       
MFA-TR*          AND CODE_TIME_PERIOD   > 0                                     
MFA-TR*          AND CODE_REG_STATUS    = 'A'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_REGISTER_READ'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE RG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'E'                        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7225-GET-RATE-PLAN                                             *        
      *     DETERMINE THE RATE PLAN NO                                 *        
      *                                                                *        
      *     CALLED BY:  1500-VALIDATE-ROW                              *        
      ******************************************************************        
       7225-GET-RATE-PLAN.                                              
                                                                        
           EXEC SQL                                                     
              SELECT RATE_PLAN_NO                                       
                INTO :UT-RATE-PLAN-NO                                   
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO                
                 AND CODE_UTIL_TYPE     = 'E'                           
                 AND IC_NO              = :WS-E-IC-NO                   
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_PLAN_NO                                               
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO         = :UT-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*          AND IC_NO              = :WS-E-IC-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7225                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7225'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'E'                        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-CHECK-TOU                                                 *        
      *     CHECK TO SEE IF ON TIME OF USE RATE                        *        
      *                                                                *        
      *     CALLED BY:  1500-VALIDATE-ROW                              *        
      ******************************************************************        
       7250-CHECK-TOU.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-TOU-RATE-FL                                    
                FROM CSS_PRICE_SCHED WITH(READUNCOMMITTED)                      
               WHERE RATE_PLAN_NO       = :UT-RATE-PLAN-NO              
                 AND CODE_UTIL_TYPE     = 'E'                           
                 AND CODE_TIME_PERIOD   > 0                             
                 AND VERSION_NO_CNTRL   =                               
                     (SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_PRICE_SCHED WITH(READUNCOMMITTED)              
                       WHERE RATE_PLAN_NO   = :UT-RATE-PLAN-NO          
                         AND CODE_UTIL_TYPE = 'E')                      
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-TOU-RATE-FL                                            
MFA-TR*         FROM CSS_PRICE_SCHED                                            
MFA-TR*        WHERE RATE_PLAN_NO       = :UT-RATE-PLAN-NO                      
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*          AND CODE_TIME_PERIOD   > 0                                     
MFA-TR*          AND VERSION_NO_CNTRL   =                                       
MFA-TR*              (SELECT MAX(VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_PRICE_SCHED                                    
MFA-TR*                WHERE RATE_PLAN_NO   = :UT-RATE-PLAN-NO                  
MFA-TR*                  AND CODE_UTIL_TYPE = 'E')                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7250                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                                               WS-811   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'E'                        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-DETERMINE-COMMERCIAL                                      *        
      *     DETERMINE IF ITS A COMMERCIAL ACCOUNT                      *        
      *                                                                *        
      *     CALLED BY:  2400-CHECK-COMMERCIAL                          *        
      ******************************************************************        
       7300-DETERMINE-COMMERCIAL.                                       
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_TYPE_CODE                                  
                INTO :AT-ACCOUNT-TYPE-CODE                              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE                                          
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-MTR-CONSTANT.                                         *        
      *     CHECKS FOR CONSTANT > 1 METERS                             *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7400-GET-MTR-CONSTANT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CONSTANT                                       
                FROM CSS_MTR_CAP WITH(READUNCOMMITTED)                          
               WHERE COMPANY_NO         = :MC-COMPANY-NO                
                 AND CODE_UTIL_TYPE     = :MC-CODE-UTIL-TYPE            
                 AND METER_NO           = :MC-METER-NO                  
                 AND REG_ID_NO          = :MC-REG-ID-NO                 
                 AND (CONSTANT          > 1                             
P00447            OR CONSTANT           = 0 )                           
                 AND CODE_CAP_TYPE      ='A'                            
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CONSTANT                                               
MFA-TR*         FROM CSS_MTR_CAP                                                
MFA-TR*        WHERE COMPANY_NO         = :MC-COMPANY-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = :MC-CODE-UTIL-TYPE                    
MFA-TR*          AND METER_NO           = :MC-METER-NO                          
MFA-TR*          AND REG_ID_NO          = :MC-REG-ID-NO                         
MFA-TR*          AND (CONSTANT          > 1                                     
MFA-TR*           OR CONSTANT           = 0 )                                   
MFA-TR*          AND CODE_CAP_TYPE      ='A'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MTR_CAP'              TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE MC-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE MC-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-3        
              MOVE MC-METER-NO                TO HOSTVAR-ELEMENT-3      
              MOVE 'REG_ID_NO'                TO TABLE-ELEMENT-4        
              MOVE MC-REG-ID-NO               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-ELEC-MTR-DTLS.                                        *        
      *     DETERMINE THE ELECTRIC METER DETAILS                       *        
      *                                                                *        
      *     CALLED BY:  2900-GET-ELEC-MTR-DTLS                         *        
      ******************************************************************        
       7500-GET-ELEC-MTR-DTLS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT ELEC_MTR_CLASS_CD,                                 
                     ELEC_MTR_SPEC_CD                                   
                INTO :EM-ELEC-MTR-CLASS-CD,                             
                     :EM-ELEC-MTR-SPEC-CD                               
                FROM CSS_ELEC_METER WITH(READUNCOMMITTED)                       
               WHERE METER_NO           = :WS-E-METER-NO                
                 AND CODE_UTIL_TYPE     = 'E'                           
                 AND COMPANY_NO         = :SR-COMPANY-NO                
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ELEC_MTR_CLASS_CD,                                         
MFA-TR*              ELEC_MTR_SPEC_CD                                           
MFA-TR*         INTO :EM-ELEC-MTR-CLASS-CD,                                     
MFA-TR*              :EM-ELEC-MTR-SPEC-CD                                       
MFA-TR*         FROM CSS_ELEC_METER                                             
MFA-TR*        WHERE METER_NO           = :WS-E-METER-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*          AND COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ELEC_METER'           TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE SR-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-2        
              MOVE WS-E-METER-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'E'                        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-CHECK-BOLT-IN-MTR.                                        *        
      *     CHECK IF ELECTRIC METER IS A BOLT IN METER                 *        
      *                                                                *        
      *     CALLED BY:  2900-GET-ELEC-MTR-DTLS                         *        
      ******************************************************************        
       7600-CHECK-BOLT-IN-MTR.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CONSTANT                                       
                FROM CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                     
               WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD         
                 AND ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD          
                 AND MTR_CONNECT_TYP_ID = 'BOLT-IN'                     
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CONSTANT                                               
MFA-TR*         FROM CSS_ELEC_CL_SPEC                                           
MFA-TR*        WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD                 
MFA-TR*          AND ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD                  
MFA-TR*          AND MTR_CONNECT_TYP_ID = 'BOLT-IN'                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ELEC_CL_SPEC'         TO TABLE-1                
              MOVE 'ELEC_MTR_CLASS_CD'        TO TABLE-ELEMENT-1        
              MOVE EM-ELEC-MTR-CLASS-CD       TO HOSTVAR-ELEMENT-1      
              MOVE 'ELEC_MTR_SPEC_CD'         TO TABLE-ELEMENT-2        
              MOVE EM-ELEC-MTR-SPEC-CD        TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-CHECK-3-PHASE-MTR.                                        *        
      *     CHECK IF ELECTRIC METER IS A 3 PHASE METER                 *        
      *                                                                *        
      *     CALLED BY:  2900-GET-ELEC-MTR-DTLS                         *        
      ******************************************************************        
       7700-CHECK-3-PHASE-MTR.                                          
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CONSTANT                                       
                FROM CSS_ELEC_MTR_CLASS WITH(READUNCOMMITTED)                   
               WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD         
                 AND NO_PHASES          = '3'                           
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CONSTANT                                               
MFA-TR*         FROM CSS_ELEC_MTR_CLASS                                         
MFA-TR*        WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD                 
MFA-TR*          AND NO_PHASES          = '3'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ELEC_MTR_CLASS'       TO TABLE-1                
              MOVE 'ELEC_MTR_CLASS_CD'        TO TABLE-ELEMENT-1        
              MOVE EM-ELEC-MTR-CLASS-CD       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-GET-GAS-METER.                                            *        
      *     CHECK IF GAS METER HAS A CCF_CAP_PER_HR > = 3000           *        
      *                                                                *        
      *     CALLED BY:  2900-GET-ELEC-MTR-DTLS                         *        
      ******************************************************************        
       7800-GET-GAS-METER.                                              
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-CONSTANT                                       
                FROM CSS_GAS_METER WITH(READUNCOMMITTED)                        
               WHERE CODE_UTIL_TYPE     = 'G'                           
                 AND METER_NO           = :WS-G-METER-NO                
                 AND COMPANY_NO         = :SR-COMPANY-NO                
                 AND CCF_CAP_PER_HR    >= 3000                          
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CONSTANT                                               
MFA-TR*         FROM CSS_GAS_METER                                              
MFA-TR*        WHERE CODE_UTIL_TYPE     = 'G'                                   
MFA-TR*          AND METER_NO           = :WS-G-METER-NO                        
MFA-TR*          AND COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND CCF_CAP_PER_HR    >= 3000                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_GAS_METER'            TO TABLE-1                
              MOVE 'METER_NO'                 TO TABLE-ELEMENT-1        
              MOVE WS-G-METER-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-GET-LOCAL-OFFICE                                          *        
      *     CHECK TO SEE IF A ROW EXISTS FOR THAT LOCAL OFFICE         *        
      *                                                                *        
      *     CALLED BY:  2200-BUILD-RESULT                              *        
      ******************************************************************        
       7900-GET-LOCAL-OFFICE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SPLT-ROW                                       
                FROM CSS_SO_SPLT_ORIG WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO         = :SR-COMPANY-NO                
                 AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD           
                 AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD        
                 AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD        
                 AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD        
P00447                                                           
A02196                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SPLT-ROW                                               
MFA-TR*         FROM CSS_SO_SPLT_ORIG                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE_CD    = :SR-LOCAL-OFFICE-CD                   
MFA-TR*          AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD                
MFA-TR*          AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD                
MFA-TR*          AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 S-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                                         WS-811         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_SO_SPLT_ORIG'         TO TABLE-1                
              MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-1        
              MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02196******************************************************************        
A02196* 7910-CHECK-METRO-AREA                                          *        
A02196*     CHECK TO SEE THE LOCAL OFFICE IS A METRO                   *        
A02196*                                                                *        
A02196*     CALLED BY:  2200-BUILD-RESULT                              *        
A02196******************************************************************        
A02196 7910-CHECK-METRO-AREA.                                           
A02196                                                                  
A02196     EXEC SQL                                                     
A02196        SELECT SERV_ORDER_WORK_CD                                 
A02196          INTO :B1-SERV-ORDER-WORK-CD                             
A02196          FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
A02196         WHERE COMPANY_NO         = :SR-COMPANY-NO                
A02196           AND LOCAL_OFFICE       = :B1-LOCAL-OFFICE              
P00447                                                           
A02196                                                      
A02196     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERV_ORDER_WORK_CD                                         
MFA-TR*         INTO :B1-SERV-ORDER-WORK-CD                                     
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE COMPANY_NO         = :SR-COMPANY-NO                        
MFA-TR*          AND LOCAL_OFFICE       = :B1-LOCAL-OFFICE                      
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02196                                                                  
A02196     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
A02196                                           S-RETURN-CODE.         
A02196                                                                  
A02196     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02196        NEXT SENTENCE                                             
A02196     ELSE                                                         
A02196        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02196        MOVE '7910'                     TO ACTIVE-PARAGRAPH       
A02196        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02196        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02196                                           ABEND-TABLES           
A02196        MOVE 'CSS_LOCAL_OFFICE'         TO TABLE-1                
A02196        MOVE 'LOCAL_OFFICE_CD'          TO TABLE-ELEMENT-1        
A02196        MOVE SR-LOCAL-OFFICE-CD         TO HOSTVAR-ELEMENT-1      
A02196        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02196        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02196     END-IF.                                                      
A02196                                                                  
A02196 7910-EXIT.                                                       
A02196     EXIT.                                                        
A02196                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
