       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04150.                                            
       DATE-WRITTEN. 06/26/2008.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *   THIS PROCEDURE IS USED TO SELECT THE MOST RECENT ACCOUNT AT  *00190000
      *   THE PREMISE WHICH HAS A PRIVATE LIGHT.                       *00200000
      *    THIS PROGRAM IS CALLED BY THE FOLLOWING:                    *        
      *    PANEL004, PANEL467                                          *        
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
C33743*  06/27/2008 SC41135   PROGRAM INITIALLY CODED - ADD NEW SEARCH *        
C33743*                       FOR LIGHT ADDRESS ON PANEL-004                    
C35979*  10/15/2008 SC41135   ADDING COMPANY_NO TO CSS_SUBDIVISION     *        
A37666*  06/15/2009 FMB       ARCHIVE ACCOUNT PROCESSING               *        
P00172*  06/15/2009 FMB       MOVE DHR FROM ACCOUNT TO CUSTOMER.       *        
A05460*  09/30/16   MR7E794   REMOVED THE MAIN USER TABLE AS PART      *        
      *             ACT282    OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
      ******************************************************************01590000
      *                                                                *01600000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01610000
      *                                                                *01620000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01630000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01640000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01650000
      *  3000 - 4999  NOT USED                                         *01660000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01670000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01680000
      *  7000 - 7999  INPUT MODULES                                    *01690000
      *  8000 - 8999  OUTPUT MODULES                                   *01700000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01710000
      *                                                                *01720000
      ******************************************************************01730000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04150'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                     01790000
              INCLUDE SQLCA                                             01800000
           END-EXEC.                                                    01810000
                                                                        
      ******************************************************************01830000
      *    UT - CSS_UTIL_ENVRNMT                                       *01840000
      ******************************************************************01850000
           EXEC SQL                                                     01860000
              INCLUDE TBUTLENV                                          01870000
           END-EXEC.                                                    01880000
                                                                        
      ******************************************************************01900000
      *    DQ - CSS_NAME                                               *01910000
      ******************************************************************01920000
           EXEC SQL                                                     01930000
              INCLUDE TBNAME                                            01940000
           END-EXEC.                                                    01950000
                                                                        
      ******************************************************************01970000
      *    HT - CSS_NAME_ACCT_XREF                                     *01980000
      ******************************************************************01990000
           EXEC SQL                                                     02000000
              INCLUDE TBNMACTX                                          02010000
           END-EXEC.                                                    02020000
                                                                        
      ******************************************************************02110000
      *    DY - CSS_ADDR_FORMATTED                                     *02120000
      ******************************************************************02130000
           EXEC SQL                                                     02140000
              INCLUDE TBADRFMT                                          02150000
           END-EXEC.                                                    02160000
                                                                        
      ******************************************************************02180000
      *    PR - CSS_PREMISE                                            *02190000
      ******************************************************************02200000
           EXEC SQL                                                     02210000
              INCLUDE TBPREM                                            02220000
           END-EXEC.                                                    02230000
                                                                        
      ******************************************************************02250000
      *    AT - CSS_ACCOUNT                                            *02260000
      ******************************************************************02270000
           EXEC SQL                                                     02280000
              INCLUDE TBACCT                                            02290000
           END-EXEC.                                                    02300000
                                                                        
      ******************************************************************02320000
      *    CU - CSS_CUSTOMER                                           *02330000
      ******************************************************************02340000
           EXEC SQL                                                     02350000
              INCLUDE TBCUST                                            02360000
           END-EXEC.                                                    02370000
                                                                        
      ******************************************************************02390000
      *    CE - CSS_CUST_STATS                                         *02400000
      ******************************************************************02410000
           EXEC SQL                                                     02420000
              INCLUDE TBCSTSTS                                          02430000
           END-EXEC.                                                    02440000
                                                                        
      ******************************************************************02460000
      *    MN - CSS_MTRD_ENVRNMT                                       *02470000
      ******************************************************************02480000
           EXEC SQL                                                     02490000
              INCLUDE TBMTRENV                                          02500000
           END-EXEC.                                                    02510000
                                                                        
      ******************************************************************02530000
      *    L9 - CSS_UM_EQUIPMENT                                   *    02540000
      ******************************************************************02550000
           EXEC SQL                                                     02560000
              INCLUDE TBUMEQP                                           02570000
           END-EXEC.                                                    02580000
                                                                        
      ******************************************************************02600000
      *    B0 - CSS_SUBDIVISON                                         *02610000
      ******************************************************************02620000
           EXEC SQL                                                     02630000
              INCLUDE TBSUBDVN                                          02640000
           END-EXEC.                                                    02650000
                                                                        
      ******************************************************************02670000
      *    A4 - CSS_ZIP_CD                                             *02680000
      ******************************************************************02690000
           EXEC SQL                                                     02700000
              INCLUDE TBZIPCD                                           02710000
           END-EXEC.                                                    02720000
                                                                        
      ******************************************************************02740000
      *    CP - CSS_CUST_PLAN                                          *02750000
      ******************************************************************02760000
           EXEC SQL                                                     02770000
              INCLUDE TBCSTPLN                                          02780000
           END-EXEC.                                                    02790000
                                                                        
      ******************************************************************02810000
      *    CB - CSS_CUST_PHONE                                         *02820000
      ******************************************************************02830000
           EXEC SQL                                                     02840000
              INCLUDE TBCSTPHN                                          02850000
           END-EXEC.                                                    02860000
                                                                        
      ******************************************************************02880000
ACT282*    SW - CSS_SO_CODE_DESC                                       *02890000
      ******************************************************************02900000
           EXEC SQL                                                     02910000
ACT282        INCLUDE TBSOCODE                                          02920000
           END-EXEC.                                                    02930000
                                                                        
      ******************************************************************02950000
      *    UP - CSS_UNMTR_PLAN                                         *02960000
      ******************************************************************02970000
           EXEC SQL                                                     02980000
              INCLUDE TBUMPLAN                                          02990000
           END-EXEC.                                                    03000000
                                                                        
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                    03010000
                                                                        
      ******************************************************************        
      *    LR - CSS_REG_PROFILE                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************02950000
      *         CSS_MODEL_SQL                                          *02960000
      ******************************************************************02970000
           EXEC SQL                                                     02980000
              INCLUDE TBMODEL                                           02990000
           END-EXEC.                                                    03000000
                                                                        
A37666******************************************************************02950000
A37666*         HST_ACCOUNT                                            *02960000
A37666******************************************************************02970000
A37666     EXEC SQL                                                     02980000
A37666        INCLUDE TBHACCT                                           02990000
A37666     END-EXEC.                                                    03000000
                                                                        
      ******************************************************************03020000
      *    COMMON COPYLIBS                                             *03030000
      ******************************************************************03040000
                                                                        
           COPY CCA00001.                                               03080000
           COPY CWS00027.                                               03100000
           COPY CWS00056.                                               03110000
           COPY CWS00303.                                               03120000
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************03140000
      *    WORK AREAS                                                  *03150000
      ******************************************************************03160000
                                                                        
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                             'SESSION.CSR04150_R1'.     
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(4) VALUE 'S200'.      
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
      ******************************************************************03500000
      *    INPUT PARAMETERS                                            *03510000
      ******************************************************************03520000
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-LIMITS.                                             
               10  PARM-LIMIT-TYPE          PIC X(1).                   
                   88  LIMIT-NONE           VALUE 'A'.                  
                   88  LIMIT-LOCAL-OFFICE   VALUE 'L'.                  
                   88  LIMIT-CITY           VALUE 'C'.                  
                   88  LIMIT-ACTIVE-IVR     VALUE 'I'.                  
                   88  LIMIT-COMPANY        VALUE 'B'.                  
               10  PARM-WRITE-OFF           PIC X(1).                   
                   88  FILTER-WRITE-OFF     VALUE 'Y'.                  
                   88  NO-FILTER-WRITE-OFF  VALUE 'N'.                  
               10  PARM-ACTIVE-CSR          PIC X(1).                   
                   88  FILTER-ACTIVE-CSR    VALUE 'Y'.                  
                   88  NO-FILTER-ACTIVE-CSR VALUE 'N'.                  
               10  PARM-BANKRUPT            PIC X(1).                   
                   88  FILTER-BANKRUPT      VALUE 'Y'.                  
                   88  NO-FILTER-BANKRUPT   VALUE 'N'.                  
           05  PARM-SELECT-METHOD           PIC X(3).                   
               88  SEL-METH-LIG             VALUE 'LIG'.                
                                                                        
       77  WS-BLO-LOT-SPACES                PIC X(05) VALUE SPACES.     
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      ******************************************************************04050000
      *    RESULT SET FIELDS                                           *04060000
      ******************************************************************04070000
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-RED-FLAG-INDICATOR        PIC X.                      
           05  RS-ADDRESS                   PIC X(71).                  
           05  RS-CITY                      PIC X(26).                  
           05  RS-NAME                      PIC X(76).                  
           05  RS-NAME-TYPE                 PIC X(2).                   
           05  RS-ACCT-TYPE                 PIC X.                      
           05  RS-SERVICE-SUPPLIED.                                     
               10  RS-SERV-SUPPLIED-OCC     OCCURS 5 TIMES.             
                   15  RS-SERV-SUPPLIED     PIC X.                      
           05  RS-SUBDIVISION               PIC X(26).                  
           05  RS-STATUS                    PIC X.                      
           05  RS-ACCOUNT-NO                PIC X(13).                  
           05  RS-SERVICE-AVAIL.                                        
               10  RS-SERV-AVAIL-OCC        OCCURS 5 TIMES.             
                   15  RS-SERV-AVAIL        PIC X.                      
           05  RS-CUSTOMER-NO               PIC X(10).                  
           05  RS-LOCAL-OFFICE              PIC X(3).                   
           05  RS-PREMISE-NO                PIC X(10).                  
           05  RS-NAME-FORMAT               PIC X.                      
           05  RS-BANKRUPT-IND              PIC X.                      
           05  RS-CREDIT-GROUP              PIC X(1).                   
           05  RS-CREDIT-STATUS             PIC X.                      
           05  RS-CODE-ACCT-STAT            PIC X.                      
           05  RS-ELEC-RATE                 PIC XXX.                    
           05  RS-GAS-RATE                  PIC XXX.                    
           05  RS-LIGHT-RATE                PIC XXX.                    
           05  RS-ZIP-CODE                  PIC X(5).                   
           05  RS-ZIP-CODE-TOKEN            PIC X.                      
           05  RS-MST-SUB-ACCT-IND          PIC X(01).                  
           05  RS-COMPANY-NO                PIC X(02).                  
           05  RS-CUST-NAME                 PIC X(76).                  
           05  RS-CODES-DATA-PRESENT        PIC X(32) VALUE SPACES.     
           05  RS-CODE-CRIT-OUTAGE          PIC X(2).                   
           05  RS-ACCT-TYPE-DESC            PIC X(25).                  
           05  RS-METER-NO                  PIC X(9).                   
           05  RS-POINT-ID                  PIC X(10).                  
           05  RS-LIGHT-TYPE                PIC X(17).                  
           05  RS-POLE-NO                   PIC X(07).                  
           05  RS-GROUP-CD                  PIC X(09).                  
A37666     05  RS-ARCHIVE-IND               PIC X(01).                  
       01  RS-ERROR-DESC                PIC X(40) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05   S-RETURN-CODE               PIC S9(9) COMP.             
           05   S-RED-FLAG-INDICATOR        PIC X.                      
           05   S-ADDRESS                   PIC X(71).                  
           05   S-CITY                      PIC X(26).                  
           05   S-NAME                      PIC X(56).                  
           05   S-NAME-TYPE                 PIC X(2).                   
           05   S-ACCT-TYPE                 PIC X.                      
           05   S-SERVICE-SUPPLIED          PIC X(05).                  
           05   S-SUBDIVISION               PIC X(26).                  
           05   S-STATUS                    PIC X.                      
           05   S-ACCOUNT-NO                PIC X(13).                  
           05   S-SERVICE-AVAIL             PIC X(05).                  
           05   S-CUSTOMER-NO               PIC X(10).                  
           05   S-LOCAL-OFFICE              PIC X(3).                   
           05   S-PREMISE-NO                PIC X(10).                  
           05   S-NAME-FORMAT               PIC X.                      
           05   S-BANKRUPT-IND              PIC X.                      
           05   S-CREDIT-GROUP              PIC X(1).                   
           05   S-CREDIT-STATUS             PIC X.                      
           05   S-CODE-ACCT-STAT            PIC X.                      
           05   S-ELEC-RATE                 PIC XXX.                    
           05   S-GAS-RATE                  PIC XXX.                    
           05   S-LIGHT-RATE                PIC XXX.                    
           05   S-ZIP-CODE                  PIC X(5).                   
           05   S-ZIP-CODE-TOKEN            PIC X.                      
           05   S-MST-SUB-ACCT-IND          PIC X(01).                  
           05   S-COMPANY-NO                PIC X(02).                  
           05   S-CUST-NAME                 PIC X(76).                  
           05   S-CODES-DATA-PRESENT        PIC X(32) VALUE SPACES.     
           05   S-CODE-CRIT-OUTAGE          PIC X(2).                   
           05   S-ACCT-TYPE-DESC            PIC X(25).                  
           05   S-METER-NO                  PIC X(9).                   
           05   S-POINT-ID                  PIC X(10).                  
           05   S-LIGHT-TYPE                PIC X(17).                  
           05   S-POLE-NO                   PIC X(07).                  
           05   S-GROUP-CD                  PIC X(09).                  
A37666     05   S-ARCHIVE-IND               PIC X(01).                  
       01  S-ERROR-DESC                PIC X(40) VALUE SPACES.          
      ******************************************************************04470000
      *    RESULT SET COLUMN NAMES                                     *04480000
      ******************************************************************04490000
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
      ******************************************************************05250000
      *    INPUT PARAMETER SEARCH CRITERIA UNSTRING AREA               *05260000
      ******************************************************************05270000
                                                                        
       01  WS-PARM-CRITERIA.                                            
                                                                        
                                                                        
           05  WS-ADD-PARM-CRITERIA.                                    
               10  ADD-ADDRESS-TYPE         PIC X.                      
                   88  SERVICE-ADDRESS      VALUE 'S'.                  
                   88  BILLING-ADDRESS      VALUE 'B'.                  
                   88  INTERSECTION-ADDRESS VALUE 'I'.                  
               10  ADD-STREET-NBR           PIC X(15).                  
               10  ADD-PREFIX-1             PIC X(3).                   
               10  ADD-PREFIX-2             PIC X(2).                   
               10  ADD-STREET-NAME          PIC X(30).                  
               10  ADD-LOCATION-1           PIC X(4).                   
               10  ADD-LOCATION-2           PIC X(11).                  
               10  ADD-CITY                 PIC X(26).                  
               10  ADD-OVERFLOW             PIC X(16).                  
               10  ADD-BLOCK                PIC X(05).                  
               10  ADD-LOT                  PIC X(05).                  
               10  ADD-STATE                PIC X(02).                  
                                                                        
      ******************************************************************06020000
      *    BETWEEN FIELD WORK AREAS                                    *06030000
      ******************************************************************06040000
       01  WS-LOW-HIGH-AREA.                                            
                                                                        
           05  ADD-STREET-NBR-L             PIC X(15) VALUE LOW-VALUE.  
           05  ADD-STREET-NBR-H             PIC X(15) VALUE HIGH-VALUE. 
           05  ADD-STREET-NBR-B             PIC X(15) VALUE             
              '%%%%%%%%%%%%%%%'.                                        
           05  ADD-PREFIX-1-L               PIC X(3)  VALUE LOW-VALUE.  
           05  ADD-PREFIX-1-H               PIC X(3)  VALUE HIGH-VALUE. 
           05  ADD-PREFIX-1-B               PIC X(3)  VALUE '%%%'.      
           05  ADD-PREFIX-2-L               PIC X(2)  VALUE LOW-VALUE.  
           05  ADD-PREFIX-2-H               PIC X(2)  VALUE HIGH-VALUE. 
           05  ADD-PREFIX-2-B               PIC X(2)  VALUE '%%'.       
           05  ADD-STREET-NAME-L            PIC X(30) VALUE LOW-VALUE.  
           05  ADD-STREET-NAME-H            PIC X(30) VALUE HIGH-VALUE. 
           05  ADD-STREET-NAME-B            PIC X(30) VALUE             
              '%%%%%%%%%%%%%%%%%%%%%%%%%'.                              
           05  ADD-STREET-NAME-C            PIC X(16) VALUE             
               '%%%%%%%%%%%%%%%%'.                                      
           05  ADD-STREET-OVERFLOW          PIC X(35) VALUE             
               '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                   
           05  ADD-LOCATION-1-L             PIC X(4)  VALUE LOW-VALUE.  
           05  ADD-LOCATION-1-H             PIC X(4)  VALUE HIGH-VALUE. 
           05  ADD-LOCATION-1-B             PIC X(4)  VALUE '%%%%'.     
           05  ADD-LOCATION-2-L             PIC X(11) VALUE LOW-VALUE.  
           05  ADD-LOCATION-2-H             PIC X(11) VALUE HIGH-VALUE. 
           05  ADD-LOCATION-2-B             PIC X(11) VALUE             
              '%%%%%%%%%%%'.                                            
           05  ADD-CITY-L                   PIC X(26) VALUE LOW-VALUE.  
           05  ADD-CITY-H                   PIC X(26) VALUE HIGH-VALUE. 
           05  ADD-CITY-B                   PIC X(26) VALUE             
               '%%%%%%%%%%%%%%%%%%%%%%%%%%'.                            
           05  ADD-OVERFLOW-L               PIC X(35) VALUE LOW-VALUE.  
           05  ADD-OVERFLOW-H               PIC X(35) VALUE HIGH-VALUE. 
           05  ADD-OVERFLOW-B               PIC X(35) VALUE             
               '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                   
           05  ADD-OVERFLOW-C               PIC X(35) VALUE             
               '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                   
           05  ADD-OVERFLOW-STREET          PIC X(30) VALUE             
               '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                        
           05  ADD-BLOCK-L                  PIC X(05) VALUE LOW-VALUE.  
           05  ADD-BLOCK-H                  PIC X(05) VALUE HIGH-VALUE. 
           05  ADD-BLOCK-B                  PIC X(05) VALUE '%%%%%'.    
           05  ADD-LOT-L                    PIC X(05) VALUE LOW-VALUE.  
           05  ADD-LOT-H                    PIC X(05) VALUE HIGH-VALUE. 
           05  ADD-LOT-B                    PIC X(05) VALUE '%%%%%'.    
                                                                        
       01  WS-BETWEEN-PARM-AREA.                                        
           05  WS-ASTERISK-POS              PIC S9(4).                  
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-NAME-FORMAT               PIC X.                      
           05  WS-NAME-I                    PIC X VALUE 'N'.            
           05  WS-NAME-B                    PIC X VALUE 'N'.            
           05  WS-UNDERSCORE                PIC X(50) VALUE             
               '__________________________________________________'.    
           05  WS-PERCENT                   PIC X(50) VALUE             
               '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.    
           05  WS-LIKE-VARIABLE.                                        
               10  WS-LIKE-X                OCCURS 51 TIMES PIC X.      
           05  WS-PERCENT-VARIABLE.                                     
               10  WS-PERCENT-X             OCCURS 51 TIMES PIC X.      
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
           05  WS-LOW.                                                  
               10  WS-LOW-X                 OCCURS 51 TIMES PIC X.      
           05  WS-HIGH.                                                 
               10  WS-HIGH-X                OCCURS 51 TIMES PIC X.      
           05  COMPANY-B                    PIC X(2) VALUE '%%'.        
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-UTIL-TYPE                 PIC X(1) VALUE SPACES.      
           05  WS-TOWN                      PIC X(26).                  
           05  WS-PREV-CUST                 PIC X(10) VALUE LOW-VALUE.  
           05  WS-PREV-NAME                 PIC X(56) VALUE LOW-VALUE.  
           05  WS-PREV-ADDRESS              PIC X(71) VALUE LOW-VALUE.  
           05  WS-PREV-CITY                 PIC X(26) VALUE LOW-VALUE.  
           05  WS-PREV-PREMISE-NO           PIC X(10) VALUE LOW-VALUE.  
           05  PROGRAM-NAME                 PIC X(8) VALUE 'S200'.      
           05  WS-NAME-TYPE                 PIC X(2) VALUE SPACES.      
           05  WS-CUST-LAST-NAME            PIC X(40) VALUE SPACES.     
           05  WS-CUST-FIRST-NAME           PIC X(15) VALUE SPACES.     
           05  WS-CUST-MIDDLE-NAME          PIC X(15) VALUE SPACES.     
           05  WS-CUST-FULL-NAME            PIC X(76) VALUE SPACES.     
           05  WS-CUST-NAME-FORMAT          PIC X(01) VALUE SPACES.     
           05  WS-CUST-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.     
           05  WS-NEED-ADDRESS              PIC X VALUE 'N'.            
               88  NEED-ADDRESS             VALUE 'Y'.                  
               88  NEED-ADDRESS-NO          VALUE 'N'.                  
           05  WS-NEED-CITY                 PIC X VALUE 'N'.            
               88  NEED-CITY                VALUE 'Y'.                  
               88  NEED-CITY-NO             VALUE 'N'.                  
           05  WS-NEED-NAME                 PIC X VALUE 'N'.            
               88  NEED-NAME                VALUE 'Y'.                  
               88  NEED-NAME-NO             VALUE 'N'.                  
           05  WS-WRITE-OFF-IND             PIC X.                      
               88  WRITE-OFF-YES            VALUE 'Y'.                  
               88  WRITE-OFF-NO             VALUE 'N'.                  
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 80 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-LOT-BLOCK                 PIC X(03) VALUE SPACES.     
           05  WS-UNMTR-FOUND               PIC X(01).                  
           05  WS-ELEC-RATE                 PIC X(03).                  
           05  WS-GAS-RATE                  PIC X(03).                  
           05  WS-LIGHT-RATE                PIC X(03).                  
           05  WS-ELEC-RATE-NULL-IND        PIC S9(04) COMP VALUE 0.    
           05  WS-GAS-RATE-NULL-IND         PIC S9(04) COMP VALUE 0.    
           05  WS-LIGHT-RATE-NULL-IND       PIC S9(04) COMP VALUE 0.    
           05  WS-TODAYS-DATE               PIC X(10).                  
           05  WS-ACTIVE-DHR                PIC X(01) VALUE ' '.        
COB305     05 WS-HOLD-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-HOLD-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-PREV-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-SUBDIV-LIGHT              PIC X(01).                  
C37666     05  WS-ARCHIVED-ACCOUNT     PIC X(01) VALUE SPACES.          
C37666     05  WS-NULL-PYMT-DATE-HA    PIC S9(04)    COMP   VALUE +0.   
C37666     05  WS-NULL-GROUP-EFF-TS    PIC S9(04)    COMP   VALUE +0.   
                                                                        
       01  WS-NEXT-VARAIBLES.                                           
           05  WS-NEXT-COUNTER              PIC S9(4) COMP VALUE 1.     
           05  WS-MULTIPLIER                PIC X(02) VALUE '00'.       
           05  WS-NEXT-MULTIPLIER           REDEFINES WS-MULTIPLIER     
                                            PIC 9(2).                   
           05  WS-ROWS-PROCESSED            PIC 9(4)  VALUE 1.          
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 20.    
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-LIMIT-TYPE-TEMP         PIC X(04).                       
       01 PARM-OFFICE-CITY             PIC X(26).                       
       01 PARM-SELECT-METHOD-TEMP      PIC X(3).                        
       01 PARM-CRITERIA                PIC X(152).                      
      ******************************************************************07680000
      *    B-LGT-CURSOR USED TO SEARCH FOR LIGHT ADDRESSES.            *07690000
      ******************************************************************07700000
           EXEC SQL DECLARE B-LGT-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2                              
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
                  AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
                  AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
                  AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
                  AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
                  AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
                  AND DY.ADDR_USAGE_CD           = 'F'                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND HT.COMPANY_NO     LIKE    :COMPANY-B              
                  AND EXISTS (SELECT 1                                  
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                     WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                   AND UT.RATE_PLAN_NO IN                               
                   ('017','018','025','026','029','062','064',          
                    '067','068','069','69A'))                           
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                         OR HT.NAME_ID = 0)                             
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
                      DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
                      DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-LGT-CURSOR CURSOR FOR                     07710000
MFA-TR*        SELECT HT.CUSTOMER_NO,                                   07720000
MFA-TR*               HT.ACCOUNT_NO,                                    07730000
MFA-TR*               HT.PREMISE_NO,                                    07740000
MFA-TR*               HT.ADDRESS_ID,                                    07750000
MFA-TR*               HT.NAME_ID,                                       07760000
MFA-TR*               HT.CUSTOMER_ROLE_CD,                              07770000
MFA-TR*               HT.COMPANY_NO,                                    07780000
MFA-TR*               DY.STREET_NAME,                                   07790000
MFA-TR*               DY.HOUSE_NO,                                      07800000
MFA-TR*               DY.ADDR_PREFIX_1,                                 07810000
MFA-TR*               DY.ADDR_PREFIX_2,                                 07820000
MFA-TR*               DY.STREET_LOCATION_1,                             07830000
MFA-TR*               DY.STREET_LOCATION_2                              07840000
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            07850000
MFA-TR*               CSS_NAME_ACCT_XREF HT                             07860000
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    07870000
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      07880000
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      07890000
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   07900000
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    07910000
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    07920000
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                  07930000
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID        07940000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                  07950000
MFA-TR*           AND HT.COMPANY_NO     LIKE    :COMPANY-B                      
MFA-TR*           AND EXISTS (SELECT 1                                          
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*              WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                            
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*            ('017','018','025','026','029','062','064',                  
MFA-TR*             '067','068','069','69A'))                                   
MFA-TR*           AND (EXISTS (SELECT 'X'                               07960000
MFA-TR*                          FROM CSS_NAME DQ                       07970000
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID         07980000
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')              07990000
MFA-TR*                  OR HT.NAME_ID = 0)                                     
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      08040000
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               08050000
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        08060000
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    08070000
                                                                        
      ******************************************************************        
      *    B-LGT-CURSOR-L USED TO SEARCH FOR LIGHT ADDRESSES WITH THE  *        
      *                   LOCAL OFFICE LIMIT.                          *        
      ******************************************************************        
           EXEC SQL DECLARE B-LGT-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2                              
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
                  AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
                  AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
                  AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
                  AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
                  AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
                  AND DY.ADDR_USAGE_CD           = 'F'                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY    
                  AND EXISTS (SELECT 1                                  
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                     WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                   AND UT.RATE_PLAN_NO IN                               
                   ('017','018','025','026','029','062','064',          
                    '067','068','069','69A'))                           
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
                      DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
                      DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-LGT-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2                                      
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY            
MFA-TR*           AND EXISTS (SELECT 1                                          
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*              WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                            
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*            ('017','018','025','026','029','062','064',                  
MFA-TR*             '067','068','069','69A'))                                   
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    B-LGT-CURSOR-C USED TO SEARCH FOR LGT ADDRESSES WITH THE    *        
      *                   CITY/STATE LIMIT.                            *        
      ******************************************************************        
           EXEC SQL DECLARE B-LGT-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2                              
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
                  AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
                  AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
                  AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
                  AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
                  AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
                  AND DY.ADDR_USAGE_CD           = 'F'                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND HT.TOWN                    = :PARM-OFFICE-CITY    
                  AND HT.STATE                   = :ADD-STATE           
                  AND EXISTS (SELECT 1                                  
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                     WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                   AND UT.RATE_PLAN_NO IN                               
                   ('017','018','025','026','029','062','064',          
                    '067','068','069','69A'))                           
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
                      DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
                      DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-LGT-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2                                      
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.TOWN                    = :PARM-OFFICE-CITY            
MFA-TR*           AND HT.STATE                   = :ADD-STATE                   
MFA-TR*           AND EXISTS (SELECT 1                                          
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*              WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                            
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*            ('017','018','025','026','029','062','064',                  
MFA-TR*             '067','068','069','69A'))                                   
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    B-MTR-CURSOR USED TO SEARCH FOR LGT ADDRESSES.              *        
      ******************************************************************        
           EXEC SQL DECLARE B-MTR-CURSOR CURSOR FOR                     
               SELECT MN. METER_NO,                                     
                      (PP.AREA_ID + PP.TAG_NM)                         
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_PIM_POINT    PP WITH(READUNCOMMITTED)                 
                WHERE MN.ACCOUNT_NO        = :HT-ACCOUNT-NO             
                  AND MN.CODE_UTIL_TYPE    = 'E'                        
                  AND MN.GIS_POINT_ID      = PP.POINT_ID                
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ031
MFA-TR*    EXEC SQL DECLARE B-MTR-CURSOR CURSOR FOR                             
MFA-TR*        SELECT MN. METER_NO,                                             
MFA-TR*               (PP.AREA_ID || PP.TAG_NM)                                 
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_PIM_POINT    PP                                       
MFA-TR*         WHERE MN.ACCOUNT_NO        = :HT-ACCOUNT-NO                     
MFA-TR*           AND MN.CODE_UTIL_TYPE    = 'E'                                
MFA-TR*           AND MN.GIS_POINT_ID      = PP.POINT_ID                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-PR-CURSOR USED TO SEARCH ON LOT AND BLOCK.               *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE DY-PR-CURSOR CURSOR FOR                     
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2                              
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
                  AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
                  AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
                  AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
                  AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
                  AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
                  AND PR.BLOCK             LIKE    :ADD-BLOCK-B         
                  AND PR.LOT               LIKE    :ADD-LOT-B           
                  AND DY.ADDR_USAGE_CD           = 'F'                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
                  AND PR.PREMISE_NO              = HT.PREMISE_NO        
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND EXISTS (SELECT 1                                  
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                     WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                   AND UT.RATE_PLAN_NO IN                               
                   ('017','018','025','026','029','062','064',          
                    '067','068','069','69A'))                           
                    AND HT.COMPANY_NO        LIKE    :COMPANY-B         
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
                      DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
                      DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR CURSOR FOR                     08110000
MFA-TR*        SELECT HT.CUSTOMER_NO,                                   08130000
MFA-TR*               HT.ACCOUNT_NO,                                    08150000
MFA-TR*               HT.PREMISE_NO,                                    08160000
MFA-TR*               HT.ADDRESS_ID,                                    08170000
MFA-TR*               HT.NAME_ID,                                       08180000
MFA-TR*               HT.CUSTOMER_ROLE_CD,                              08190000
MFA-TR*               HT.COMPANY_NO,                                    08200000
MFA-TR*               DY.STREET_NAME,                                   08210000
MFA-TR*               DY.HOUSE_NO,                                      08220000
MFA-TR*               DY.ADDR_PREFIX_1,                                 08230000
MFA-TR*               DY.ADDR_PREFIX_2,                                 08240000
MFA-TR*               DY.STREET_LOCATION_1,                             08250000
MFA-TR*               DY.STREET_LOCATION_2                              08260000
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            08270000
MFA-TR*               CSS_NAME_ACCT_XREF HT,                            08280000
MFA-TR*               CSS_PREMISE PR                                    08290000
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    08300000
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      08310000
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      08320000
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   08330000
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    08340000
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    08350000
MFA-TR*           AND PR.BLOCK             LIKE    :ADD-BLOCK-B         08360000
MFA-TR*           AND PR.LOT               LIKE    :ADD-LOT-B           08370000
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                  08380000
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID        08390000
MFA-TR*           AND PR.PREMISE_NO              = HT.PREMISE_NO        08400000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                  08410000
MFA-TR*           AND EXISTS (SELECT 1                                          
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*              WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                            
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*            ('017','018','025','026','029','062','064',                  
MFA-TR*             '067','068','069','69A'))                                   
MFA-TR*             AND HT.COMPANY_NO        LIKE    :COMPANY-B                 
MFA-TR*           AND (EXISTS (SELECT 'X'                               08420000
MFA-TR*                          FROM CSS_NAME DQ                       08430000
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID         08440000
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')              08450000
MFA-TR*                OR HT.NAME_ID = 0)                               08460000
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      08500000
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               08510000
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        08520000
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    08530000
                                                                        
      ******************************************************************11530000
      *    DY-PR-CURSOR-L USED TO SEARCH ON LOT AND BLOCK WITH THE     *        
      *                   LOCAL OFFICE LIMIT.                          *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE DY-PR-CURSOR-L CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2                              
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
                  AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
                  AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
                  AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
                  AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
                  AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
                  AND PR.BLOCK             LIKE    :ADD-BLOCK-B         
                  AND PR.LOT               LIKE    :ADD-LOT-B           
                  AND DY.ADDR_USAGE_CD           = 'F'                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
                  AND PR.PREMISE_NO              = HT.PREMISE_NO        
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY    
                  AND EXISTS (SELECT 1                                  
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                     WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                   AND UT.RATE_PLAN_NO IN                               
                   ('017','018','025','026','029','062','064',          
                    '067','068','069','69A'))                           
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
                      DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
                      DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2                                      
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND PR.BLOCK             LIKE    :ADD-BLOCK-B                 
MFA-TR*           AND PR.LOT               LIKE    :ADD-LOT-B                   
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND PR.PREMISE_NO              = HT.PREMISE_NO                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY            
MFA-TR*           AND EXISTS (SELECT 1                                          
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*              WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                            
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*            ('017','018','025','026','029','062','064',                  
MFA-TR*             '067','068','069','69A'))                                   
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY-PR-CURSOR-C USED TO SEARCH ON LOT AND BLOCK WITH THE     *        
      *                   CITY/STATE LIMIT.                            *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE DY-PR-CURSOR-C CURSOR FOR                   
               SELECT HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO,                                      
                      DY.ADDR_PREFIX_1,                                 
                      DY.ADDR_PREFIX_2,                                 
                      DY.STREET_LOCATION_1,                             
                      DY.STREET_LOCATION_2                              
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
                  AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
                  AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
                  AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
                  AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
                  AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
                  AND PR.BLOCK             LIKE    :ADD-BLOCK-B         
                  AND PR.LOT               LIKE    :ADD-LOT-B           
                  AND DY.ADDR_USAGE_CD           = 'F'                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
                  AND PR.PREMISE_NO              = HT.PREMISE_NO        
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND HT.TOWN                    = :PARM-OFFICE-CITY    
                  AND HT.STATE                   = :ADD-STATE           
                  AND EXISTS (SELECT 1                                  
                     FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)             
                     WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                   AND UT.RATE_PLAN_NO IN                               
                   ('017','018','025','026','029','062','064',          
                    '067','068','069','69A'))                           
                  AND (EXISTS (SELECT 'X'                               
                                 FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
                                WHERE HT.NAME_ID   = DQ.NAME_ID         
                                  AND DQ.NAME_TYPE = 'CN')              
                       OR HT.NAME_ID = 0)                               
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
                      DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
                      DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2                                      
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND PR.BLOCK             LIKE    :ADD-BLOCK-B                 
MFA-TR*           AND PR.LOT               LIKE    :ADD-LOT-B                   
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND PR.PREMISE_NO              = HT.PREMISE_NO                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.TOWN                    = :PARM-OFFICE-CITY            
MFA-TR*           AND HT.STATE                   = :ADD-STATE                   
MFA-TR*           AND EXISTS (SELECT 1                                          
MFA-TR*              FROM CSS_UTIL_ENVRNMT UT                                   
MFA-TR*              WHERE UT.ACCOUNT_NO = HT.ACCOUNT_NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                            
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*            ('017','018','025','026','029','062','064',                  
MFA-TR*             '067','068','069','69A'))                                   
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR HT.NAME_ID = 0)                                       
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************11530000
      *    UT-CURSOR USED TO SEARCH FOR UTILITY.                       *11540000
      ******************************************************************11550000
           EXEC SQL                                                     
            DECLARE UT-CURSOR CURSOR FOR                                
              SELECT CODE_UTIL_TYPE,MAX(RATE_PLAN_NO)                   
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                    
               GROUP BY CODE_UTIL_TYPE                                  
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11560000
MFA-TR*     DECLARE UT-CURSOR CURSOR FOR                                11570000
MFA-TR*       SELECT CODE_UTIL_TYPE,MAX(RATE_PLAN_NO)                   11580000
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  11590000
MFA-TR*        WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                    11600000
MFA-TR*        GROUP BY CODE_UTIL_TYPE                                  11610000
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    11630000
                                                                        
      *PROCEDURE DIVISION.                                                      
       PROCEDURE DIVISION USING PARM-LIMIT-TYPE-TEMP                    
                                PARM-OFFICE-CITY                        
                                PARM-SELECT-METHOD-TEMP                 
                                PARM-CRITERIA.                          
      ******************************************************************11790000
      * 0000-MAINLINE                                                  *11800000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *11810000
      ******************************************************************11820000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11940000
      * 0100-INITIALIZE                                                *11950000
      *                                                                *11960000
      *     1. RESET DB2 ERROR HANDLERS                                *11970000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *11980000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *11990000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*12000000
      *                                                                *12010000
      ******************************************************************12020000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM  0100A-DECLARE-GTT   THRU 0100A-EXIT.                
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE                                          
                  ,LTRIM(RTRIM(RED_FLAG_INDICATOR)) AS 
           RED_FLAG_INDICATOR      
                  ,LTRIM(RTRIM(ERROR_DESC))         AS ERROR_DESC              
                  ,LTRIM(RTRIM(ADDRESS))            AS ADDRESS                 
                  ,LTRIM(RTRIM(CITY))               AS CITY                    
                  ,LTRIM(RTRIM(NAME))               AS NAME                    
                  ,LTRIM(RTRIM(NAME_TYPE))          AS NAME_TYPE               
                  ,LTRIM(RTRIM(ACCT_TYPE))          AS ACCT_TYPE               
                  ,LTRIM(RTRIM(SERVICE_SUPPLIED))   AS SERVICE_SUPPLIED        
                  ,LTRIM(RTRIM(SUBDIVISION))        AS SUBDIVISION             
                  ,LTRIM(RTRIM(STATUS))             AS STATUS                  
                  ,LTRIM(RTRIM(ACCOUNT_NO))         AS ACCOUNT_NO              
                  ,LTRIM(RTRIM(SERVICE_AVAIL))      AS SERVICE_AVAIL           
                  ,LTRIM(RTRIM(CUSTOMER_NO))        AS CUSTOMER_NO             
                  ,LTRIM(RTRIM(LOCAL_OFFICE))       AS LOCAL_OFFICE            
                  ,LTRIM(RTRIM(PREMISE_NO))         AS PREMISE_NO              
                  ,LTRIM(RTRIM(NAME_FORMAT))        AS NAME_FORMAT             
                  ,LTRIM(RTRIM(BANKRUPT_IND))       AS BANKRUPT_IND            
                  ,LTRIM(RTRIM(CREDIT_GROUP))       AS CREDIT_GROUP            
                  ,LTRIM(RTRIM(CREDIT_STATUS))      AS CREDIT_STATUS           
                  ,LTRIM(RTRIM(CODE_ACCT_STAT))     AS CODE_ACCT_STAT          
                  ,LTRIM(RTRIM(ELEC_RATE))          AS ELEC_RATE               
                  ,LTRIM(RTRIM(GAS_RATE))           AS GAS_RATE                
                  ,LTRIM(RTRIM(LIGHT_RATE))         AS LIGHT_RATE              
                  ,LTRIM(RTRIM(ZIP_CODE))           AS ZIP_CODE                
                  ,LTRIM(RTRIM(ZIP_CODE_TOKEN))     AS ZIP_CODE_TOKEN          
                  ,LTRIM(RTRIM(MST_SUB_ACCT_IND))   AS MST_SUB_ACCT_IND        
                  ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO              
                  ,LTRIM(RTRIM(CUST_NAME))          AS CUST_NAME               
                  ,RTRIM(CODES_DATA_PRESENT) AS CODES_DATA_PRESENT      
                  ,LTRIM(RTRIM(CODE_CRIT_OUTAGE))   AS CODE_CRIT_OUTAGE        
                  ,LTRIM(RTRIM(ACCT_TYPE_DESC))     AS ACCT_TYPE_DESC          
                  ,LTRIM(RTRIM(METER_NO))           AS METER_NO                
                  ,LTRIM(RTRIM(POINT_ID))           AS POINT_ID                
                  ,LTRIM(RTRIM(LIGHT_TYPE))         AS LIGHT_TYPE              
                  ,LTRIM(RTRIM(POLE_NO))            AS POLE_NO                 
                  ,LTRIM(RTRIM(GROUP_CD))           AS GROUP_CD                
A37666            ,LTRIM(RTRIM(ARCHIVE_IND))        AS ARCHIVE_IND             
               FROM                                                     
                   #CSR04150_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STRIP(RED_FLAG_INDICATOR) AS RED_FLAG_INDICATOR              
MFA-TR*           ,STRIP(ERROR_DESC)         AS ERROR_DESC                      
MFA-TR*           ,STRIP(ADDRESS)            AS ADDRESS                         
MFA-TR*           ,STRIP(CITY)               AS CITY                            
MFA-TR*           ,STRIP(NAME)               AS NAME                            
MFA-TR*           ,STRIP(NAME_TYPE)          AS NAME_TYPE                       
MFA-TR*           ,STRIP(ACCT_TYPE)          AS ACCT_TYPE                       
MFA-TR*           ,STRIP(SERVICE_SUPPLIED)   AS SERVICE_SUPPLIED                
MFA-TR*           ,STRIP(SUBDIVISION)        AS SUBDIVISION                     
MFA-TR*           ,STRIP(STATUS)             AS STATUS                          
MFA-TR*           ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NO                      
MFA-TR*           ,STRIP(SERVICE_AVAIL)      AS SERVICE_AVAIL                   
MFA-TR*           ,STRIP(CUSTOMER_NO)        AS CUSTOMER_NO                     
MFA-TR*           ,STRIP(LOCAL_OFFICE)       AS LOCAL_OFFICE                    
MFA-TR*           ,STRIP(PREMISE_NO)         AS PREMISE_NO                      
MFA-TR*           ,STRIP(NAME_FORMAT)        AS NAME_FORMAT                     
MFA-TR*           ,STRIP(BANKRUPT_IND)       AS BANKRUPT_IND                    
MFA-TR*           ,STRIP(CREDIT_GROUP)       AS CREDIT_GROUP                    
MFA-TR*           ,STRIP(CREDIT_STATUS)      AS CREDIT_STATUS                   
MFA-TR*           ,STRIP(CODE_ACCT_STAT)     AS CODE_ACCT_STAT                  
MFA-TR*           ,STRIP(ELEC_RATE)          AS ELEC_RATE                       
MFA-TR*           ,STRIP(GAS_RATE)           AS GAS_RATE                        
MFA-TR*           ,STRIP(LIGHT_RATE)         AS LIGHT_RATE                      
MFA-TR*           ,STRIP(ZIP_CODE)           AS ZIP_CODE                        
MFA-TR*           ,STRIP(ZIP_CODE_TOKEN)     AS ZIP_CODE_TOKEN                  
MFA-TR*           ,STRIP(MST_SUB_ACCT_IND)   AS MST_SUB_ACCT_IND                
MFA-TR*           ,STRIP(COMPANY_NO)         AS COMPANY_NO                      
MFA-TR*           ,STRIP(CUST_NAME)          AS CUST_NAME                       
MFA-TR*           ,RTRIM(CODES_DATA_PRESENT) AS CODES_DATA_PRESENT              
MFA-TR*           ,STRIP(CODE_CRIT_OUTAGE)   AS CODE_CRIT_OUTAGE                
MFA-TR*           ,STRIP(ACCT_TYPE_DESC)     AS ACCT_TYPE_DESC                  
MFA-TR*           ,STRIP(METER_NO)           AS METER_NO                        
MFA-TR*           ,STRIP(POINT_ID)           AS POINT_ID                        
MFA-TR*           ,STRIP(LIGHT_TYPE)         AS LIGHT_TYPE                      
MFA-TR*           ,STRIP(POLE_NO)            AS POLE_NO                         
MFA-TR*           ,STRIP(GROUP_CD)           AS GROUP_CD                        
MFA-TR*           ,STRIP(ARCHIVE_IND)        AS ARCHIVE_IND                     
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04150_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04150_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04150_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04150_R1
              (                                                          
               RETURN_CODE              INT                         
              ,RED_FLAG_INDICATOR CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,ERROR_DESC CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,ADDRESS CHAR(71)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                   
              ,NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2                   
              ,NAME_TYPE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,SERVICE_SUPPLIED CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,SUBDIVISION CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                 
              ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,SERVICE_AVAIL CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,LOCAL_OFFICE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,BANKRUPT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CREDIT_GROUP CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CREDIT_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,ELEC_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,GAS_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,LIGHT_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,ZIP_CODE CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,ZIP_CODE_TOKEN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,MST_SUB_ACCT_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,CUST_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,CODES_DATA_PRESENT CHAR(32)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CODE_CRIT_OUTAGE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,ACCT_TYPE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
              ,LIGHT_TYPE CHAR(17)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,POLE_NO CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2                 
              ,GROUP_CD CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
A37666        ,ARCHIVE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04150_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************12290000
      * 1000-PROCESS-INPUT                                             *12300000
      *                                                                *12310000
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *12320000
      *     2. SPLIT OUT PARM STRING INFORMATION                       *12330000
      *                                                                *12340000
      ******************************************************************12350000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-LIMIT-TYPE-TEMP       TO PARM-LIMITS.              
           MOVE PARM-SELECT-METHOD-TEMP    TO PARM-SELECT-METHOD.       
           MOVE SPACE TO WS-PARM-CRITERIA.                              
                                                                        
                   MOVE 0 TO WS-HOLD-PREMISE-NO                         
                             WS-HOLD-ACCOUNT-NO                         
                             WS-PREV-ACCOUNT-NO                         
                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-LIG                                        
                   UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
                       INTO ADD-ADDRESS-TYPE                            
                            ADD-STREET-NBR                              
                            ADD-PREFIX-1                                
                            ADD-PREFIX-2                                
                            ADD-STREET-NAME                             
                            ADD-LOCATION-1                              
                            ADD-LOCATION-2                              
                            ADD-CITY                                    
                            ADD-OVERFLOW                                
                            ADD-BLOCK                                   
                            ADD-LOT                                     
                            ADD-STATE                                   
                            WS-MULTIPLIER                               
                                                                        
                   IF ADD-STREET-NBR NOT = SPACE                        
                       MOVE ADD-STREET-NBR TO WS-FROM                   
                       MOVE LENGTH OF ADD-STREET-NBR TO WS-LENGTH       
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-STREET-NBR-L                  
                       MOVE WS-HIGH TO ADD-STREET-NBR-H                 
                       MOVE WS-LIKE-VARIABLE TO ADD-STREET-NBR-B        
                   END-IF                                               
                   IF ADD-PREFIX-1 NOT = SPACE                          
                       MOVE ADD-PREFIX-1 TO WS-FROM                     
                       MOVE LENGTH OF ADD-PREFIX-1 TO WS-LENGTH         
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-PREFIX-1-L                    
                       MOVE WS-HIGH TO ADD-PREFIX-1-H                   
                       MOVE WS-LIKE-VARIABLE TO ADD-PREFIX-1-B          
                   END-IF                                               
                   IF ADD-PREFIX-2 NOT = SPACE                          
                       MOVE ADD-PREFIX-2 TO WS-FROM                     
                       MOVE LENGTH OF ADD-PREFIX-2 TO WS-LENGTH         
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-PREFIX-2-L                    
                       MOVE WS-HIGH TO ADD-PREFIX-2-H                   
                       MOVE WS-LIKE-VARIABLE TO ADD-PREFIX-2-B          
                   END-IF                                               
                   IF ADD-STREET-NAME NOT = SPACE                       
                       MOVE ADD-STREET-NAME TO WS-FROM                  
                       MOVE LENGTH OF ADD-STREET-NAME TO WS-LENGTH      
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-STREET-NAME-L                 
                       MOVE WS-HIGH TO ADD-STREET-NAME-H                
                       MOVE WS-LIKE-VARIABLE TO ADD-STREET-NAME-B       
                       MOVE WS-PERCENT-VARIABLE TO ADD-STREET-NAME-C    
                       MOVE WS-LIKE-VARIABLE TO ADD-STREET-OVERFLOW     
                   END-IF                                               
                   IF ADD-LOCATION-1 NOT = SPACE                        
                       MOVE ADD-LOCATION-1 TO WS-FROM                   
                       MOVE LENGTH OF ADD-LOCATION-1 TO WS-LENGTH       
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-LOCATION-1-L                  
                       MOVE WS-HIGH TO ADD-LOCATION-1-H                 
                       MOVE WS-LIKE-VARIABLE TO ADD-LOCATION-1-B        
                   END-IF                                               
                   IF ADD-LOCATION-2 NOT = SPACE                        
                       MOVE ADD-LOCATION-2 TO WS-FROM                   
                       MOVE LENGTH OF ADD-LOCATION-2 TO WS-LENGTH       
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-LOCATION-2-L                  
                       MOVE WS-HIGH TO ADD-LOCATION-2-H                 
                       MOVE WS-LIKE-VARIABLE TO ADD-LOCATION-2-B        
                   END-IF                                               
                   IF ADD-CITY NOT = SPACE                              
                       MOVE ADD-CITY TO WS-FROM                         
                       MOVE LENGTH OF ADD-CITY TO WS-LENGTH             
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-CITY-L                        
                       MOVE WS-HIGH TO ADD-CITY-H                       
                       MOVE WS-LIKE-VARIABLE TO ADD-CITY-B              
                   END-IF                                               
                   IF ADD-OVERFLOW NOT = SPACE                          
                       MOVE ADD-OVERFLOW TO WS-FROM                     
                       MOVE LENGTH OF ADD-OVERFLOW-C TO WS-LENGTH       
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-OVERFLOW-L                    
                       MOVE WS-HIGH TO ADD-OVERFLOW-H                   
                       MOVE WS-LIKE-VARIABLE TO ADD-OVERFLOW-B          
                       MOVE WS-PERCENT-VARIABLE TO ADD-OVERFLOW-C       
                       MOVE WS-LIKE-VARIABLE TO ADD-OVERFLOW-STREET     
                   END-IF                                               
                   IF ADD-BLOCK NOT = SPACE                             
                       MOVE ADD-BLOCK TO WS-FROM                        
                       MOVE LENGTH OF ADD-BLOCK TO WS-LENGTH            
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-BLOCK-L                       
                       MOVE WS-HIGH TO ADD-BLOCK-H                      
                       MOVE WS-LIKE-VARIABLE TO ADD-BLOCK-B             
                       MOVE 'YES' TO WS-LOT-BLOCK                       
                   END-IF                                               
                   IF ADD-LOT NOT = SPACE                               
                       MOVE ADD-LOT TO WS-FROM                          
                       MOVE LENGTH OF ADD-LOT TO WS-LENGTH              
                       PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
                       MOVE WS-LOW TO ADD-LOT-L                         
                       MOVE WS-HIGH TO ADD-LOT-H                        
                       MOVE WS-LIKE-VARIABLE TO ADD-LOT-B               
                       MOVE 'YES' TO WS-LOT-BLOCK                       
                   END-IF                                               
                   IF PARM-LIMIT-TYPE = 'B'                             
                       MOVE PARM-OFFICE-CITY TO COMPANY-B               
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
      ***************************************************************** 15570000
      ** IF A MULTIPLIER IS SENT UP MULTIPLY IT BY THE MAX ROWS, WHICH  15580000
      ** IS CURRENTLY 20.  THIS WILL TELL THE RPC WHEN TO ACTUALLY      15590000
      ** START SENDING THE RESULT TO THE CLIENT                         15600000
      ***************************************************************** 15610000
                                                                        
                                                                        
           IF WS-NEXT-MULTIPLIER > 0                                    
              COMPUTE WS-NEXT-COUNTER =                                 
                   WS-NEXT-MULTIPLIER * CN-MAX-RETURN-ROWS              
              ADD  1  TO WS-NEXT-COUNTER                                
           END-IF.                                                      
                                                                        
           PERFORM 7000-DETERMINE-REGION THRU 7000-EXIT.                
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                        
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TODAYS-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************15730000
      * 1110-FORMAT-BETWEEN-PARM                                       *15740000
      *                                                                *15750000
      *     DETERMINE WHERE THE ASTERISK IS IN THE SOURCE FIELD. IF    *15760000
      *     THE ASTERISK IS THE ONLY CHARACTER, SET LOW AND HIGH       *15770000
      *     VARIABLES SUCH THAT ALL VALUES WILL PASS THE BETWEEN       *15780000
      *     PREDICATE. IF NO ASTERISK IS FOUND, MOVE THE SOURCE VALUE  *15790000
      *     TO BOTH THE LOW AND HIGH RANGE VARIABLES. IF AN ASTERISK   *15800000
      *     IS FOUND AFTER OTHER CHARACTERS, MOVE THE CHARACTERS UP TO *15810000
      *     THE ASTERISK LEAVING LOW AND HIGH VALUES AFTER THESE       *15820000
      *     CHARACTERS.                                                *15830000
      *                                                                *15840000
      ******************************************************************15850000
                                                                        
       1110-FORMAT-BETWEEN-PARM.                                        
                                                                        
           MOVE ZERO TO WS-ASTERISK-POS.                                
           INSPECT WS-FROM                                              
               TALLYING WS-ASTERISK-POS                                 
               FOR CHARACTERS                                           
               BEFORE CN-ASTERISK.                                      
           IF WS-ASTERISK-POS = ZERO                                    
               MOVE WS-UNDERSCORE TO WS-LIKE-VARIABLE                   
               MOVE WS-PERCENT    TO WS-PERCENT-VARIABLE                
               MOVE LOW-VALUE     TO WS-LOW                             
               MOVE HIGH-VALUE    TO WS-HIGH                            
           ELSE                                                         
               IF WS-ASTERISK-POS > WS-LENGTH                           
                   MOVE WS-FROM TO WS-LOW                               
                                   WS-HIGH                              
                                   WS-LIKE-VARIABLE                     
                                   WS-PERCENT-VARIABLE                  
               ELSE                                                     
                   MOVE LOW-VALUE     TO WS-LOW                         
                   MOVE HIGH-VALUE    TO WS-HIGH                        
                   MOVE WS-UNDERSCORE TO WS-LIKE-VARIABLE               
                   MOVE WS-PERCENT    TO WS-PERCENT-VARIABLE            
                   PERFORM                                              
                       VARYING WS-SUB FROM 1 BY 1                       
                         UNTIL WS-SUB > WS-ASTERISK-POS                 
                            OR WS-SUB > WS-LENGTH                       
                       MOVE WS-FROM-X (WS-SUB) TO WS-LOW-X (WS-SUB)     
                       MOVE WS-FROM-X (WS-SUB) TO WS-HIGH-X (WS-SUB)    
                       MOVE WS-FROM-X (WS-SUB) TO WS-LIKE-X (WS-SUB)    
                       MOVE WS-FROM-X (WS-SUB) TO WS-PERCENT-X (WS-SUB) 
                   END-PERFORM                                          
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************16250000
      * 2000-PROCESS-OUTPUT                                            *16260000
      *                                                                *16270000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *16280000
      *     BUILD THE RESULT SET.                                      *16290000
      *                                                                *16300000
      ******************************************************************16310000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
                                                                        
           SET NEED-NAME-NO         TO TRUE.                            
           SET NEED-ADDRESS-NO      TO TRUE.                            
           SET NEED-CITY-NO         TO TRUE.                            
           IF LIMIT-LOCAL-OFFICE                                        
             MOVE PARM-OFFICE-CITY(1:3) TO HT-LOCAL-OFFICE
           END-IF.             
           EVALUATE TRUE                                                
               WHEN LIMIT-COMPANY                                       
               WHEN LIMIT-NONE                                          
                   IF WS-LOT-BLOCK = 'YES'                              
                      PERFORM 2211-SEARCH-VIA-DY-PR-CURSOR              
                              THRU 2211-EXIT                            
                   ELSE                                                 
                      PERFORM 2216-SEARCH-VIA-B-LGT-CURSOR              
                              THRU 2216-EXIT                            
                   END-IF                                               
               WHEN LIMIT-LOCAL-OFFICE                                  
                   IF WS-LOT-BLOCK = 'YES'                              
                      PERFORM 2212-SEARCH-VIA-DY-PR-CURSOR-L            
                              THRU 2212-EXIT                            
                   ELSE                                                 
                      PERFORM 2214-SEARCH-VIA-B-LGT-CURSOR-L            
                              THRU 2214-EXIT                            
                   END-IF                                               
               WHEN LIMIT-CITY                                          
                   IF WS-LOT-BLOCK = 'YES'                              
                      PERFORM 2213-SEARCH-VIA-DY-PR-CURSOR-C            
                              THRU 2213-EXIT                            
                   ELSE                                                 
                      PERFORM 2215-SEARCH-VIA-B-LGT-CURSOR-C            
                              THRU 2215-EXIT                            
                    END-IF                                              
            END-EVALUATE.                                               
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = CN-MAX-RETURN-ROWS                             
               MOVE 101 TO RS-RETURN-CODE                               
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************23580000
      * 2000A-MOVE-RESULT                                              *23870000
      ******************************************************************23920000
       2000A-MOVE-RESULT.                                               
             MOVE RS-RETURN-CODE         TO  S-RETURN-CODE.             
             MOVE RS-RED-FLAG-INDICATOR  TO  S-RED-FLAG-INDICATOR.      
             MOVE RS-ADDRESS             TO  S-ADDRESS.                 
             MOVE RS-CITY                TO  S-CITY.                    
             MOVE RS-NAME                TO  S-NAME.                    
             MOVE RS-NAME-TYPE           TO  S-NAME-TYPE.               
             MOVE RS-ACCT-TYPE           TO  S-ACCT-TYPE.               
             MOVE RS-SERVICE-SUPPLIED    TO  S-SERVICE-SUPPLIED.        
             MOVE RS-SUBDIVISION         TO  S-SUBDIVISION.             
             MOVE RS-STATUS              TO  S-STATUS.                  
             MOVE RS-ACCOUNT-NO          TO  S-ACCOUNT-NO .             
             MOVE RS-SERVICE-AVAIL       TO  S-SERVICE-AVAIL.           
             MOVE RS-CUSTOMER-NO         TO  S-CUSTOMER-NO .            
             MOVE RS-LOCAL-OFFICE        TO  S-LOCAL-OFFICE.            
             MOVE RS-PREMISE-NO          TO  S-PREMISE-NO.              
             MOVE RS-NAME-FORMAT         TO  S-NAME-FORMAT.             
             MOVE RS-BANKRUPT-IND        TO  S-BANKRUPT-IND.            
             MOVE RS-CREDIT-GROUP        TO S-CREDIT-GROUP.             
             MOVE RS-CREDIT-STATUS       TO  S-CREDIT-STATUS.           
             MOVE RS-CODE-ACCT-STAT      TO  S-CODE-ACCT-STAT.          
             MOVE RS-ELEC-RATE           TO  S-ELEC-RATE.               
             MOVE RS-GAS-RATE            TO  S-GAS-RATE.                
             MOVE RS-LIGHT-RATE          TO  S-LIGHT-RATE.              
             MOVE RS-ZIP-CODE            TO  S-ZIP-CODE.                
             MOVE RS-ZIP-CODE-TOKEN      TO  S-ZIP-CODE-TOKEN.          
             MOVE RS-MST-SUB-ACCT-IND    TO  S-MST-SUB-ACCT-IND .       
             MOVE RS-COMPANY-NO          TO  S-COMPANY-NO .             
             MOVE RS-CUST-NAME           TO  S-CUST-NAME.               
             MOVE RS-CODES-DATA-PRESENT  TO  S-CODES-DATA-PRESENT.      
             MOVE RS-CODE-CRIT-OUTAGE    TO  S-CODE-CRIT-OUTAGE.        
             MOVE RS-ACCT-TYPE-DESC      TO  S-ACCT-TYPE-DESC .         
             MOVE RS-METER-NO            TO  S-METER-NO.                
             MOVE RS-POINT-ID            TO  S-POINT-ID.                
             MOVE RS-LIGHT-TYPE          TO  S-LIGHT-TYPE.              
             MOVE RS-POLE-NO             TO  S-POLE-NO.                 
             MOVE RS-GROUP-CD            TO  S-GROUP-CD .               
A37666       MOVE RS-ARCHIVE-IND         TO  S-ARCHIVE-IND.             
             MOVE RS-ERROR-DESC          TO  S-ERROR-DESC.              
       2000A-EXIT.                                                      
             EXIT.                                                      
      ******************************************************************23580000
      * 2211-SEARCH-VIA-DY-PR-CURSOR                                   *23870000
      *                                                                *23880000
      *     SEARCH FOR ADDRESSES VIA THE DY-PR CURSOR. CALL COMMON     *23890000
      *     PARAGRAPH TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.  *23900000
      *                                                                *23910000
      ******************************************************************23920000
                                                                        
       2211-SEARCH-VIA-DY-PR-CURSOR.                                    
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7280-OPEN-DY-PR-CURSOR               THRU 7280-EXIT. 
           PERFORM 7281-FETCH-DY-PR-CURSOR              THRU 7281-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7281-FETCH-DY-PR-CURSOR          THRU 7281-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7282-CLOSE-DY-PR-CURSOR              THRU 7282-EXIT. 
                                                                        
       2211-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2212-SEARCH-VIA-DY-PR-CURSOR-L                                 *        
      *                                                                *        
      *     SEARCH FOR ADDRESSES VIA THE DY-PR-CURSOR-L WITH THE       *        
      *     LOCAL OFFICE LIMIT.                                        *        
      *     CALL COMMON PARAGRAPH TO RETRIEVE ADDITIONAL DATA.         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2212-SEARCH-VIA-DY-PR-CURSOR-L.                                  
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7283-OPEN-DY-PR-CURSOR-L             THRU 7283-EXIT. 
           PERFORM 7284-FETCH-DY-PR-CURSOR-L            THRU 7284-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7284-FETCH-DY-PR-CURSOR-L        THRU 7284-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7285-CLOSE-DY-PR-CURSOR-L            THRU 7285-EXIT. 
                                                                        
       2212-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2213-SEARCH-VIA-DY-PR-CURSOR-C                                 *        
      *                                                                *        
      *     SEARCH FOR ADDRESSES VIA THE DY-PR-CURSOR-C WITH THE       *        
      *     CITY/STATE LIMIT.                                          *        
      *     CALL COMMON PARAGRAPH TO RETRIEVE ADDITIONAL DATA.         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2213-SEARCH-VIA-DY-PR-CURSOR-C.                                  
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7286-OPEN-DY-PR-CURSOR-C             THRU 7286-EXIT. 
           PERFORM 7287-FETCH-DY-PR-CURSOR-C            THRU 7287-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7287-FETCH-DY-PR-CURSOR-C        THRU 7287-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7288-CLOSE-DY-PR-CURSOR-C            THRU 7288-EXIT. 
                                                                        
       2213-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2214-SEARCH-VIA-B-LGT-CURSOR-L                                 *        
      *                                                                *        
      *     SEARCH FOR LGT ADDRESSES VIA THE B-LGT-CURSOR-L WITH THE   *        
      *     LOCAL OFFICE LIMIT.                                        *        
      *     CALL COMMON PARAGRAPH TO RETRIEVE ADDTIONAL DATA.          *        
      *                                                                *        
      ******************************************************************        
       2214-SEARCH-VIA-B-LGT-CURSOR-L.                                  
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7221-OPEN-B-LGT-CURSOR-L             THRU 7221-EXIT. 
           PERFORM 7222-FETCH-B-LGT-CURSOR-L            THRU 7222-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7222-FETCH-B-LGT-CURSOR-L        THRU 7222-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7223-CLOSE-B-LGT-CURSOR-L            THRU 7223-EXIT. 
                                                                        
       2214-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2215-SEARCH-VIA-B-LGT-CURSOR-C                                 *        
      *                                                                *        
      *     SEARCH FOR LGT ADDRESSES VIA THE B-LGT-CURSOR-C WITH THE   *        
      *     CITY/STATE LIMIT.                                          *        
      *     CALL COMMON PARAGRAPH TO RETRIEVE ADDTIONAL DATA.          *        
      *                                                                *        
      ******************************************************************        
       2215-SEARCH-VIA-B-LGT-CURSOR-C.                                  
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7224-OPEN-B-LGT-CURSOR-C             THRU 7224-EXIT. 
           PERFORM 7225-FETCH-B-LGT-CURSOR-C            THRU 7225-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7225-FETCH-B-LGT-CURSOR-C        THRU 7225-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7226-CLOSE-B-LGT-CURSOR-C            THRU 7226-EXIT. 
                                                                        
       2215-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2216-SEARCH-VIA-B-LGT-CURSOR                                   *        
      *                                                                *        
      *     SEARCH FOR LGT ADDRESSES VIA THE B-LGT-CURSOR. CALL COMMON *        
      *     PARAGRAPH TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.  *        
      *                                                                *        
      ******************************************************************        
       2216-SEARCH-VIA-B-LGT-CURSOR.                                    
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7227-OPEN-B-LGT-CURSOR               THRU 7227-EXIT. 
           PERFORM 7228-FETCH-B-LGT-CURSOR              THRU 7228-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7228-FETCH-B-LGT-CURSOR          THRU 7228-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7229-CLOSE-B-LGT-CURSOR              THRU 7229-EXIT. 
                                                                        
       2216-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2218-SEARCH-VIA-B-MTR-CURSOR                                   *        
      *                                                                *        
      *     SEARCH FOR LGT ADDRESSES VIA THE B-MTR-CURSOR. CALL COMMON *        
      *     PARAGRAPH TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.  *        
      *                                                                *        
      ******************************************************************        
       2218-SEARCH-VIA-B-MTR-CURSOR.                                    
                                                                        
           SET NEED-NAME-NO TO TRUE.                                    
           SET NEED-CITY TO TRUE.                                       
                                                                        
           PERFORM 7231-OPEN-B-MTR-CURSOR               THRU 7231-EXIT. 
           PERFORM 7232-FETCH-B-MTR-CURSOR              THRU 7232-EXIT. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE MN-METER-NO TO RS-METER-NO                          
               MOVE MN-POINT-ID       TO RS-POINT-ID                    
           ELSE                                                         
               MOVE SPACES       TO RS-METER-NO                         
                                    RS-POINT-ID                         
           END-IF                                                       
            PERFORM 7233-CLOSE-B-MTR-CURSOR          THRU 7233-EXIT.    
            PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT.   
            PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT.    
                                                                        
       2218-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************28170000
      * 2500-PROCESS-ROW                                               *28180000
      *                                                                *28190000
      *     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *28200000
      *     PERFORM FILTERING BASED ON SELECTION CRITERIA. FORMAT      *28210000
      *     RESULT SET AND SEND DATA.                                  *28220000
      *                                                                *28230000
      ******************************************************************28240000
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
      ***************************************************************** 28300000
      ** FOR ALL THE SELECTION MATERIAL EXCEPT MASTER ACCOUNT BYPASS    28310000
      ** THIS SEND ROW LOGIC UNTIL YOU REACH THE SPECIFIED ROW THAT     28320000
      ** YOU WANT TO START RETURNING TO THE CLIENT (1,21,41, ETC)       28330000
      ***************************************************************** 28340000
           MOVE HT-COMPANY-NO TO RS-COMPANY-NO.                         
                                                                        
                IF HT-ACCOUNT-NO = WS-PREV-ACCOUNT-NO                   
                   MOVE HT-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO             
                   GO TO 2500-EXIT                                      
                ELSE                                                    
                   MOVE HT-ACCOUNT-NO TO WS-PREV-ACCOUNT-NO             
               END-IF                                                   
                                                                        
                                                                        
              IF HT-PREMISE-NO NOT = WS-HOLD-PREMISE-NO                 
                  MOVE ZEROES TO WS-CPD99-ACCOUNT-NO                    
                                 WS-CPD99-PREMISE-NO                    
                  MOVE HT-PREMISE-NO TO WS-HOLD-PREMISE-NO              
                                        WS-CPD99-PREMISE-NO             
                  PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT         
                  MOVE WS-CPD99-ACCOUNT-NO TO WS-HOLD-ACCOUNT-NO        
              END-IF                                                    
              IF HT-ACCOUNT-NO NOT = WS-HOLD-ACCOUNT-NO                 
                  GO TO 2500-EXIT                                       
              END-IF                                                    
                                                                        
           IF FILTER-ACTIVE-CSR                                         
                  CONTINUE                                              
           ELSE                                                         
           IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER                       
                ADD  1  TO WS-ROWS-PROCESSED                            
                GO TO 2500-EXIT                                         
           END-IF
           END-IF.                                                      
                                                                        
           IF HT-ACCOUNT-NO NOT EQUAL TO ZERO                           
C37666        MOVE 'N' TO WS-ARCHIVED-ACCOUNT                           
              PERFORM 7915-GET-ACCOUNT-DETAILS     THRU 7915-EXIT       
              MOVE AT-CODE-CRIT-OUTAGE TO RS-CODE-CRIT-OUTAGE           
           ELSE                                                         
              MOVE SPACE TO AT-CODE-ACCT-STAT                           
                            AT-ACCOUNT-TYPE-CODE                        
                            AT-LOCAL-OFFICE                             
                            AT-BANKRUPTCY-IND                           
                            AT-MST-SUB-ACCT-IND                         
                            AT-CODES-DATA-PRESENT                       
                            AT-CREDIT-GROUP                             
                            AT-CREDIT-STATUS-CODE                       
                            AT-CODE-CRIT-OUTAGE                         
ACT282                      SW-CODE-LONG-DESC                           
           END-IF.                                                      
                                                                        
              IF (WS-ROWS-PROCESSED < WS-NEXT-COUNTER)                  
               AND FILTER-ACTIVE-CSR AND (AT-CODE-ACCT-STAT = 'A')      
                  ADD 1     TO  WS-ROWS-PROCESSED                       
                  GO TO 2500-EXIT                                       
              END-IF                                                    
                                                                        
              IF (FILTER-ACTIVE-CSR AND AT-CODE-ACCT-STAT NOT = 'A')    
                  GO TO 2500-EXIT                                       
              END-IF                                                    
                                                                        
           IF HT-NAME-ID NOT EQUAL ZERO THEN                            
               PERFORM 7930-GET-NAME               THRU 7930-EXIT       
               IF (HT-CUSTOMER-ROLE-CD > SPACES OR                      
                   DQ-NAME-TYPE NOT = 'CN') AND (HT-ACCOUNT-NO > 0      
                    OR DQ-NAME-TYPE = 'SN')                             
                  IF HT-ACCOUNT-NO > 0                                  
                     PERFORM 7970-GET-CUST-NAME  THRU 7970-EXIT         
                  ELSE                                                  
                     PERFORM 7971-GET-CUST-NAME-WCUSNUM                 
                                                 THRU 7971-EXIT         
                  END-IF                                                
                  IF WS-CUST-NAME-FORMAT = 'I'                          
                     MOVE WS-CUST-LAST-NAME TO WS-FROM                  
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-LAST-NAME                  
                                                                        
                     MOVE WS-CUST-FIRST-NAME TO WS-FROM                 
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-FIRST-NAME                 
                                                                        
                     IF WS-CUST-MIDDLE-NAME NOT = SPACE                 
                         MOVE WS-CUST-MIDDLE-NAME TO WS-FROM            
                         PERFORM 2510-PROCESS-FROM-STRING               
                         MOVE WS-FROM TO WS-CUST-MIDDLE-NAME            
                     END-IF                                             
                                                                        
                     MOVE WS-CUST-TITLE-SUFFIX-1 TO WS-FROM             
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-TITLE-SUFFIX-1             
                                                                        
                     IF WS-CUST-MIDDLE-NAME = SPACE                     
                      STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER   
                       ', ' DELIMITED SIZE                              
                       WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER        
                       ' ' DELIMITED SIZE                               
                       WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER    
                       INTO RS-CUST-NAME                                
                         END-STRING                                     
                     ELSE                                               
                       STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER  
                        ', ' DELIMITED SIZE                             
                        WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER       
                        ' ' DELIMITED SIZE                              
                        WS-CUST-MIDDLE-NAME DELIMITED CN-DELIMITER      
                        ' ' DELIMITED SIZE                              
                        WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER   
                        INTO RS-CUST-NAME                               
                         END-STRING                                     
                     END-IF                                             
                  ELSE                                                  
                     MOVE WS-CUST-FULL-NAME     TO RS-CUST-NAME         
                  END-IF                                                
                                                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
                                                                        
           IF WS-CODE-RED-FLAG = 'A'                                    
               MOVE 'Y' TO RS-RED-FLAG-INDICATOR                        
           ELSE                                                         
               MOVE 'N' TO RS-RED-FLAG-INDICATOR                        
           END-IF.                                                      
                                                                        
           IF HT-PREMISE-NO NOT EQUAL TO ZERO                           
               PERFORM 7940-GET-PREMISE-DETAILS     THRU 7940-EXIT      
           ELSE                                                         
               MOVE SPACE  TO B0-SUBDIVISION-DESC                       
           END-IF.                                                      
                                                                        
           IF HT-ADDRESS-ID NOT EQUAL TO ZERO                           
               PERFORM 7920-GET-ADDRESS          THRU 7920-EXIT         
               PERFORM 7925-GET-CITY             THRU 7925-EXIT         
           ELSE                                                         
               MOVE SPACE TO DY-HOUSE-NO                                
                             DY-ADDR-PREFIX-1                           
                             DY-ADDR-PREFIX-2                           
                             DY-STREET-NAME                             
                             DY-ADDRESS-OVERFLOW                        
                             DY-ADDR-USAGE-CD                           
                             DY-STREET-SUFFIX                           
                             DY-STREET-LOCATION-1                       
                             DY-STREET-LOCATION-2                       
                             DY-ZIP-CODE                                
                             DY-ZIP-CODE-TOKEN                          
                             A4-TOWN                                    
           END-IF.                                                      
                                                                        
           IF LIMIT-CITY AND A4-TOWN NOT = PARM-OFFICE-CITY             
               GO TO 2500-EXIT                                          
           END-IF.                                                      
                                                                        
           MOVE B0-SUBDIVISION-DESC   TO RS-SUBDIVISION                 
           MOVE HT-ACCOUNT-NO         TO RS-ACCOUNT-NO.                 
           MOVE DQ-NAME-TYPE          TO RS-NAME-TYPE.                  
           MOVE AT-ACCOUNT-TYPE-CODE  TO RS-ACCT-TYPE.                  
ACT282     MOVE SW-CODE-LONG-DESC     TO RS-ACCT-TYPE-DESC.             
           MOVE AT-CREDIT-GROUP       TO RS-CREDIT-GROUP.               
           MOVE AT-CREDIT-STATUS-CODE TO RS-CREDIT-STATUS.              
           MOVE AT-CODE-ACCT-STAT     TO RS-CODE-ACCT-STAT.             
           MOVE SPACE                 TO RS-ELEC-RATE.                  
           MOVE SPACE                 TO RS-GAS-RATE.                   
           MOVE SPACE                 TO RS-LIGHT-RATE.                 
           MOVE DY-ZIP-CODE           TO RS-ZIP-CODE.                   
           MOVE DY-ZIP-CODE-TOKEN     TO RS-ZIP-CODE-TOKEN.             
           MOVE AT-MST-SUB-ACCT-IND   TO RS-MST-SUB-ACCT-IND.           
           MOVE AT-CODES-DATA-PRESENT TO RS-CODES-DATA-PRESENT.         
           INSPECT RS-CODES-DATA-PRESENT REPLACING ALL                  
               LOW-VALUES BY ' '.                                       
      *    PERFORM 7980-SELECT-WHITE-CROSS THRU 7980-EXIT.              30290000
           PERFORM 7274-OPEN-UT-CURSOR THRU 7274-EXIT.                  
           PERFORM 7275-FETCH-UT-CURSOR THRU 7275-EXIT.                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                EVALUATE UT-CODE-UTIL-TYPE                              
                    WHEN 'E'                                            
                        IF ( UT-RATE-PLAN-NO = '029'  OR                
                            UT-RATE-PLAN-NO = '69A' )                   
                           PERFORM 7725-GET-E-UTIL       THRU 7725-EXIT 
                           IF WS-SUBDIV-LIGHT NOT = 'Y'                 
                           PERFORM 7710-GET-LGT-RATE     THRU 7710-EXIT 
                           END-IF                                       
                        ELSE                                            
                            MOVE UT-RATE-PLAN-NO     TO RS-ELEC-RATE    
                        END-IF                                          
                    WHEN 'U'                                            
                        MOVE  'N'       TO WS-SUBDIV-LIGHT              
                        PERFORM 7705-GET-SUBDIV-RATE  THRU 7705-EXIT    
                        IF WS-SUBDIV-LIGHT = 'Y'                        
                        MOVE '064'       TO RS-LIGHT-RATE               
                                            WS-LIGHT-RATE               
                        PERFORM 7715-GET-LIGHT-TYPE    THRU 7715-EXIT   
                        ELSE                                            
                        PERFORM 7710-GET-LGT-RATE     THRU 7710-EXIT    
                        END-IF                                          
                    WHEN 'G'                                            
                        MOVE UT-RATE-PLAN-NO     TO RS-GAS-RATE         
                END-EVALUATE                                            
                PERFORM 7275-FETCH-UT-CURSOR      THRU 7275-EXIT        
           END-PERFORM.                                                 
           PERFORM 7276-CLOSE-UT-CURSOR           THRU 7276-EXIT.       
           MOVE L9-UM-EQUIP-SHRT-DESC TO RS-LIGHT-TYPE.                 
           MOVE CP-POLE-NO            TO RS-POLE-NO.                    
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF.                                                      
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-SUFFIX NOT = SPACE                            
                   MOVE DY-ADDR-SUFFIX                 TO WS-FROM       
                   MOVE LENGTH OF DY-ADDR-SUFFIX       TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
                                                                        
           MOVE A4-TOWN              TO RS-CITY.                        
           MOVE AT-CODE-ACCT-STAT    TO RS-STATUS.                      
           MOVE HT-CUSTOMER-NO       TO RS-CUSTOMER-NO.                 
           MOVE AT-LOCAL-OFFICE      TO RS-LOCAL-OFFICE.                
           MOVE HT-PREMISE-NO        TO RS-PREMISE-NO.                  
           MOVE DQ-NAME-FORMAT       TO RS-NAME-FORMAT.                 
           MOVE AT-BANKRUPTCY-IND    TO RS-BANKRUPT-IND.                
                                                                        
               MOVE RS-ADDRESS     TO WS-PREV-ADDRESS                   
               MOVE RS-CITY        TO WS-PREV-CITY                      
               MOVE RS-PREMISE-NO  TO WS-PREV-PREMISE-NO                
                                                                        
      ******************************************************************32040000
      *  THE FOLLOWING IF STATEMENT IS USED TO DISPLAY THE RELATIONSHIP*32050000
      *  A PERSON HAS WITH AN ACCOUNT.  THE CUSTOMER_ROLE_CD IN THE    *32060000
      *  THE CSS_NAME_ACCT_XREF TABLE SAYS WHETHER A PERSON IS A ROOM- *32070000
      *  MATE OR CO-APPLICANT.  WE ARE GOING TO MOVE THIS TO THE RE-   *32080000
      *  NAME_TYPE FIELD SO WE CAN SHOW ITS RELATIONSHIP.              *32090000
      ******************************************************************32100000
           IF HT-CUSTOMER-ROLE-CD = 'A'                                 
              MOVE 'A' TO RS-NAME-TYPE                                  
           END-IF.                                                      
                                                                        
           IF HT-CUSTOMER-ROLE-CD = 'B'                                 
              MOVE 'B' TO RS-NAME-TYPE                                  
           END-IF.                                                      
                                                                        
           IF C8-DELINQ-VALUE = 2                                       
               PERFORM 7750-REG-PROFILE      THRU 7750-EXIT             
               IF LR-REG-GROUP-CD = '200'                               
                   PERFORM 7760-ACTIVE-DHR   THRU 7760-EXIT             
               END-IF                                                   
           ELSE                                                         
               MOVE SPACES TO RS-GROUP-CD
           END-IF.                              
                                                                        
      ******************************************************************        
      *   PROCESS MULTIPLE METERS.                                     *        
      ******************************************************************        
                                                                        
                                                                        
           PERFORM 2218-SEARCH-VIA-B-MTR-CURSOR         THRU 2218-EXIT. 
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************32240000
      * 2510-PROCESS-FROM-STRING                                       *32250000
      *                                                                *32260000
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *32270000
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *32280000
      *                                                                *32290000
      ******************************************************************32300000
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************32970000
      * 2540-ACCUMULATE-ADDRESS                                        *32980000
      *                                                                *32990000
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *33000000
      *     THE FORMATTED ADDRESS FIELD.                               *33010000
      *                                                                *33020000
      ******************************************************************33030000
                                                                        
       2540-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH                               
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-DETERMINE-REGION.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = 'DATABASE'                             
                 AND COMPANY_NO = '01'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15040000
MFA-TR*       SELECT DELINQ_VALUE                                       15040000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15040000
MFA-TR*         FROM CSS_DELINQUENCY                                    15040000
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                             15040000
MFA-TR*          AND COMPANY_NO = '01'                                  15040000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7000 REGION'        TO RS-ERROR-DESC          
                                                  S-ERROR-DESC          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_DELINQUENCY'         TO TABLE-1                
               MOVE 'DELINQ_VALUE'            TO TABLE-ELEMENT-1        
               MOVE 'DATABASE'                TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33610000
      * 7221-OPEN-B-LGT-CURSOR-L                                       *        
      *                                                                *33630000
      *     OPEN B-LGT-CURSOR-L AND CHECK FOR SQL ERROR.               *        
      *                                                                *33650000
      ******************************************************************33660000
                                                                        
       7221-OPEN-B-LGT-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN B-LGT-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7221 ,OPEN CURSOR B-LGT-CURSOR-L'          
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7221'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7221-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33920000
      * 7222-FETCH-B-LGT-CURSOR-L                                      *        
      *                                                                *33940000
      *     FETCH B-LGT-CURSOR-L AND CHECK FOR SQL ERROR.              *        
      *                                                                *33960000
      ******************************************************************33970000
                                                                        
       7222-FETCH-B-LGT-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH B-LGT-CURSOR-L                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7222 ,FETCH CURSOR B-LGT-CURSOR-L'         
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7222'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7222-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************34360000
      * 7223-CLOSE-B-LGT-CURSOR-L                                      *        
      *                                                                *34380000
      *     CLOSE B-LGT-CURSOR-L AND CHECK FOR SQL ERROR.              *        
      *                                                                *34400000
      ******************************************************************34410000
                                                                        
       7223-CLOSE-B-LGT-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE B-LGT-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7223 ,CLOSE CURSOR B-LGT-CURSOR-L'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7223'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7223-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7224-OPEN-B-LGT-CURSOR-C                                       *        
      *                                                                *        
      *     OPEN B-LGT-CURSOR-C AND CHECK FOR SQL ERROR.               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7224-OPEN-B-LGT-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN B-LGT-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7224 ,OPEN CURSOR B-LGT-CURSOR-C'          
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7224'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7224-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7225-FETCH-B-LGT-CURSOR-C                                      *        
      *                                                                *        
      *     FETCH B-LGT-CURSOR-C AND CHECK FOR SQL ERROR.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7225-FETCH-B-LGT-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH B-LGT-CURSOR-C                                     
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7225 ,FETCH CURSOR B-LGT-CURSOR-C'         
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7225'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7225-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7226-CLOSE-B-LGT-CURSOR-C                                      *        
      *                                                                *        
      *     CLOSE B-LGT-CURSOR-C AND CHECK FOR SQL ERROR.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7226-CLOSE-B-LGT-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE B-LGT-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7226 ,CLOSE CURSOR B-LGT-CURSOR-C'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7226'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7226-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7227-OPEN-B-LGT-CURSOR                                         *        
      *                                                                *        
      *     OPEN B-LGT-CURSOR AND CHECK FOR SQL ERROR.                 *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7227-OPEN-B-LGT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN B-LGT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7227 ,OPEN CURSOR B-LGT-CURSOR'            
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7227'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7227-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7228-FETCH-B-LGT-CURSOR                                        *        
      *                                                                *        
      *     FETCH B-LGT-CURSOR AND CHECK FOR SQL ERROR.                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7228-FETCH-B-LGT-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH B-LGT-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7228 ,FETCH CURSOR B-LGT-CURSOR'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7228'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7228-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7229-CLOSE-B-LGT-CURSOR                                        *        
      *                                                                *        
      *     CLOSE B-LGT-CURSOR AND CHECK FOR SQL ERROR.                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7229-CLOSE-B-LGT-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE B-LGT-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7229 ,CLOSE CURSOR B-LGT-CURSOR'             
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7229'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7229-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7231-OPEN-B-MTR-CURSOR                                         *        
      *                                                                *        
      *     OPEN B-MTR-CURSOR AND CHECK FOR SQL ERROR.                 *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7231-OPEN-B-MTR-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN B-MTR-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7231 ,OPEN CURSOR B-MTR-CURSOR'            
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7231'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7231-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7232-FETCH-B-MTR-CURSOR                                        *        
      *                                                                *        
      *     FETCH B-MTR-CURSOR AND CHECK FOR SQL ERROR.                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7232-FETCH-B-MTR-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH B-MTR-CURSOR                                       
                INTO :MN-METER-NO,                                      
                     :MN-POINT-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7232 ,FETCH CURSOR B-MTR-CURSOR'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7232'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7232-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7233-CLOSE-B-MTR-CURSOR                                        *        
      *                                                                *        
      *     CLOSE B-MTR-CURSOR AND CHECK FOR SQL ERROR.                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7233-CLOSE-B-MTR-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE B-MTR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7233 ,CLOSE CURSOR B-MTR-CURSOR'             
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7233'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7233-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************43810000
      * 7274-OPEN-UT-CURSOR                                            *43820000
      *                                                                *43830000
      *     OPEN UT-CURSOR AND CHECK FOR SQL ERROR.                    *43840000
      *                                                                *43850000
      ******************************************************************43860000
                                                                        
       7274-OPEN-UT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN UT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7274 ,OPEN   CURSOR UT-CURSOR  '             
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7274'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7274-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************44120000
      * 7275-FETCH-UT-CURSOR                                           *44130000
      *                                                                *44140000
      *     FETCH UT-CURSOR AND CHECK FOR SQL ERROR.                   *44150000
      *                                                                *44160000
      ******************************************************************44170000
                                                                        
       7275-FETCH-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH UT-CURSOR                                          
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7275 ,FETCH  CURSOR UT-CURSOR  '             
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7275'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7275-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************44450000
      * 7276-CLOSE-UT-CURSOR                                           *44460000
      *                                                                *44470000
      *     CLOSE BS-CURSOR AND CHECK FOR SQL ERROR.                   *44480000
      *                                                                *44490000
      ******************************************************************44500000
                                                                        
       7276-CLOSE-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE UT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7276 ,CLOSE  CURSOR UT-CURSOR  '             
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7276'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7276-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************44760000
      * 7280-OPEN-DY-PR-CURSOR                                         *44770000
      *                                                                *44780000
      *     OPEN DY-PR-CURSOR AND CHECK FOR SQL ERROR.                 *44790000
      *                                                                *44800000
      ******************************************************************44810000
                                                                        
       7280-OPEN-DY-PR-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN DY-PR-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7280 ,OPEN CURSOR DY-PR-CURSOR'            
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7280'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************45070000
      * 7281-FETCH-DY-PR-CURSOR                                        *45080000
      *                                                                *45090000
      *     FETCH DY-PR-CURSOR AND CHECK FOR SQL ERROR.                *45100000
      *                                                                *45110000
      ******************************************************************45120000
                                                                        
       7281-FETCH-DY-PR-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH DY-PR-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7281 ,FETCH CURSOR DY-PR-CURSOR'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7281'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7281-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************45510000
      * 7282-CLOSE-DY-PR-CURSOR                                        *45520000
      *                                                                *45530000
      *     CLOSE DY-PR-CURSOR AND CHECK FOR SQL ERROR.                *45540000
      *                                                                *45550000
      ******************************************************************45560000
                                                                        
       7282-CLOSE-DY-PR-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DY-PR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7282 ,CLOSE CURSOR DY-PR-CURSOR'             
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7282'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7282-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************48800000
      * 7283-OPEN-DY-PR-CURSOR-L                                       *        
      *                                                                *48820000
      *     OPEN DY-PR-CURSOR-L AND CHECK FOR SQL ERROR.               *        
      *                                                                *48830000
      ******************************************************************48840000
                                                                        
       7283-OPEN-DY-PR-CURSOR-L.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-PR-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7283 ,OPEN CURSOR DY-PR-CURSOR-L'          
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7283'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7283-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7284-FETCH-DY-PR-CURSOR-L                                      *        
      *                                                                *        
      *     FETCH DY-PR-CURSOR-L AND CHECK FOR SQL ERROR.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7284-FETCH-DY-PR-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-PR-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7284 ,FETCH CURSOR DY-PR-CURSOR-L'         
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7284'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7284-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7285-CLOSE-DY-PR-CURSOR-L                                      *        
      *                                                                *        
      *     CLOSE DY-PR-CURSOR-L AND CHECK FOR SQL ERROR.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7285-CLOSE-DY-PR-CURSOR-L.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-PR-CURSOR-L                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7285 ,CLOSE CURSOR DY-PR-CURSOR-L'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7285'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7285-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7286-OPEN-DY-PR-CURSOR-C                                       *        
      *                                                                *        
      *     OPEN DY-PR-CURSOR-C AND CHECK FOR SQL ERROR.               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7286-OPEN-DY-PR-CURSOR-C.                                        
                                                                        
           EXEC SQL                                                     
               OPEN DY-PR-CURSOR-C                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7286 ,OPEN CURSOR DY-PR-CURSOR-C'          
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7286'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7286-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7287-FETCH-DY-PR-CURSOR-C                                      *        
      *                                                                *        
      *     FETCH DY-PR-CURSOR-C AND CHECK FOR SQL ERROR.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7287-FETCH-DY-PR-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               FETCH DY-PR-CURSOR                                       
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE   'PARA -7287 ,FETCH CURSOR DY-PR-CURSOR-C'         
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7287'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7287-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7288-CLOSE-DY-PR-CURSOR-C                                      *        
      *                                                                *        
      *     CLOSE DY-PR-CURSOR-C AND CHECK FOR SQL ERROR.              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7288-CLOSE-DY-PR-CURSOR-C.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE DY-PR-CURSOR-C                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7288 ,CLOSE CURSOR DY-PR-CURSOR-C'           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7288'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_PREMISE'          TO TABLE-3                   
               MOVE 'CSS_NAME'             TO TABLE-4                   
               MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
               MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
               MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
               MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
               MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
               MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
               MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
               MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7288-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7705-GET-SUBDIV-RATE.                                          *49220000
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7705-GET-SUBDIV-RATE.                                            
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y' INTO                                         
                       :WS-SUBDIV-LIGHT                                 
                  FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                  WHERE UT.ACCOUNT_NO     = :HT-ACCOUNT-NO              
                    AND UT.RATE_PLAN_NO   = '064'                       
                    AND UT.CODE_UTIL_TYPE = 'U'                         
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y' INTO                                                 
MFA-TR*                :WS-SUBDIV-LIGHT                                         
MFA-TR*           FROM CSS_UTIL_ENVRNMT UT                                      
MFA-TR*           WHERE UT.ACCOUNT_NO     = :HT-ACCOUNT-NO                      
MFA-TR*             AND UT.RATE_PLAN_NO   = '064'                               
MFA-TR*             AND UT.CODE_UTIL_TYPE = 'U'                                 
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7705 GET SUBDIV RATE' TO RS-ERROR-DESC        
                                                 S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7705'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UM_EQUIPMENT'        TO TABLE-1                
               MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1        
               MOVE '064'                     TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7705-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************49270000
       7710-GET-LGT-RATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT MAX(UT.RATE_PLAN_NO)                              
                 INTO :WS-LIGHT-RATE :WS-LIGHT-RATE-NULL-IND             
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO     = :HT-ACCOUNT-NO                
                  AND UT.CODE_UTIL_TYPE IN ('E','U')                    
                  AND UT.RATE_PLAN_NO IN                                
                     ('017','018','025','026','029','062','064',        
                      '067','068','069','69A')                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     49300000
MFA-TR*        SELECT MAX(UT.RATE_PLAN_NO)                              49310000
MFA-TR*          INTO :WS-LIGHT-RATE:WS-LIGHT-RATE-NULL-IND             49320000
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                               49330000
MFA-TR*         WHERE UT.ACCOUNT_NO     = :HT-ACCOUNT-NO                49340000
MFA-TR*           AND UT.CODE_UTIL_TYPE IN ('E','U')                    49350000
MFA-TR*           AND UT.RATE_PLAN_NO IN                                        
MFA-TR*              ('017','018','025','026','029','062','064',                
MFA-TR*               '067','068','069','69A')                                  
MFA-TR*               WITH UR                                                   
MFA-TR*    END-EXEC.                                                    49370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-LIGHT-RATE-NULL-IND = 0                            
                  MOVE WS-LIGHT-RATE          TO RS-LIGHT-RATE          
               END-IF                                                   
               PERFORM 7715-GET-LIGHT-TYPE    THRU 7715-EXIT            
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7710 GET LGT RATE'  TO RS-ERROR-DESC          
                                                 S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7710'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7715-GET-LIGHT-TYPE.                                           *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7715-GET-LIGHT-TYPE.                                             
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) L9.UM_EQUIP_SHRT_DESC,
              CP.POLE_NO                                       
                   INTO :L9-UM-EQUIP-SHRT-DESC                          
                       ,:CP-POLE-NO                                     
                  FROM CSS_UM_EQUIPMENT L9 WITH(READUNCOMMITTED),               
                       CSS_UNMTR_PLAN UP WITH(READUNCOMMITTED),                 
                       CSS_CUST_PLAN CP WITH(READUNCOMMITTED),                  
                       CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
                  WHERE UT.ACCOUNT_NO     = :HT-ACCOUNT-NO              
                    AND UT.CODE_UTIL_TYPE IN ('E','U')                  
                    AND UT.RATE_PLAN_NO   = :WS-LIGHT-RATE              
                    AND UP.RATE_PLAN_NO   = UT.RATE_PLAN_NO             
                    AND UP.UM_EQUIP_ID    = L9.UM_EQUIP_ID              
                     AND UP.VERSION_NO_CNTRL =                          
                    (SELECT MAX(VERSION_NO_CNTRL) FROM CSS_UNMTR_PLAN B
                           WITH(READUNCOMMITTED) 
                     WHERE B.RATE_PLAN_NO = UP.RATE_PLAN_NO             
                     AND B.RATE_ITEM_CODE = UP.RATE_ITEM_CODE           
                     AND B.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE)          
                    AND CP.ACCOUNT_NO = UT.ACCOUNT_NO                   
                    AND CP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE           
                    AND CP.IC_NO         = UT.IC_NO                     
                    AND CP.RATE_ITEM_CODE = UP.RATE_ITEM_CODE           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT L9.UM_EQUIP_SHRT_DESC,                                   
MFA-TR*                CP.POLE_NO                                               
MFA-TR*            INTO :L9-UM-EQUIP-SHRT-DESC                                  
MFA-TR*                ,:CP-POLE-NO                                             
MFA-TR*           FROM CSS_UM_EQUIPMENT L9,                                     
MFA-TR*                CSS_UNMTR_PLAN UP,                                       
MFA-TR*                CSS_CUST_PLAN CP,                                        
MFA-TR*                CSS_UTIL_ENVRNMT UT                                      
MFA-TR*           WHERE UT.ACCOUNT_NO     = :HT-ACCOUNT-NO                      
MFA-TR*             AND UT.CODE_UTIL_TYPE IN ('E','U')                          
MFA-TR*             AND UT.RATE_PLAN_NO   = :WS-LIGHT-RATE                      
MFA-TR*             AND UP.RATE_PLAN_NO   = UT.RATE_PLAN_NO                     
MFA-TR*             AND UP.UM_EQUIP_ID    = L9.UM_EQUIP_ID                      
MFA-TR*              AND UP.VERSION_NO_CNTRL =                                  
MFA-TR*             (SELECT MAX(VERSION_NO_CNTRL) FROM CSS_UNMTR_PLAN B         
MFA-TR*              WHERE B.RATE_PLAN_NO = UP.RATE_PLAN_NO                     
MFA-TR*              AND B.RATE_ITEM_CODE = UP.RATE_ITEM_CODE                   
MFA-TR*              AND B.CODE_UTIL_TYPE = UP.CODE_UTIL_TYPE)                  
MFA-TR*             AND CP.ACCOUNT_NO = UT.ACCOUNT_NO                           
MFA-TR*             AND CP.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                   
MFA-TR*             AND CP.IC_NO         = UT.IC_NO                             
MFA-TR*             AND CP.RATE_ITEM_CODE = UP.RATE_ITEM_CODE                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE SPACES TO L9-UM-EQUIP-SHRT-DESC                     
               MOVE SPACES TO CP-POLE-NO                                
           ELSE IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7715 GET LIGHT TYPE' TO RS-ERROR-DESC         
                                                 S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7715'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UM_EQUIPMENT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7715-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7725-GET-E-UTIL.                                               *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       7725-GET-E-UTIL.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :WS-ELEC-RATE :WS-ELEC-RATE-NULL-IND               
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND RATE_PLAN_NO NOT IN ('69A','029')                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :WS-ELEC-RATE:WS-ELEC-RATE-NULL-IND                       
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('69A','029')                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-ELEC-RATE-NULL-IND = 0                             
                  MOVE WS-ELEC-RATE            TO RS-ELEC-RATE          
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7725-GET-E-UTIL' TO RS-ERROR-DESC             
                                                 S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7725'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'E'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50470000
      * 7740-GET-PREM-DETAIL.                                          *50070000
      *                                                                *50080000
      *                                                                *50090000
      ******************************************************************50100000
       7740-GET-PREM-DETAIL.                                            
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT                                          
                      PR.LOCAL_OFFICE,                                  
                      PR.COMPANY_NO,                                    
                      DY.ZIP_CODE,                                      
                      DY.ZIP_CODE_TOKEN                                 
                 INTO                                                   
                      :PR-LOCAL-OFFICE,                                 
                      :PR-COMPANY-NO,                                   
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN                                
                 FROM CSS_PREMISE         PR WITH(READUNCOMMITTED),             
                      CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED)              
                 WHERE PR.PREMISE_NO = :PR-PREMISE-NO                   
                  AND DY.ADDRESS_ID  = PR.ADDRESS_ID                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50130000
MFA-TR*        SELECT DISTINCT                                          50140000
MFA-TR*               PR.LOCAL_OFFICE,                                          
MFA-TR*               PR.COMPANY_NO,                                            
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_TOKEN                                         
MFA-TR*          INTO                                                           
MFA-TR*               :PR-LOCAL-OFFICE,                                         
MFA-TR*               :PR-COMPANY-NO,                                           
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_PREMISE         PR,                                   
MFA-TR*               CSS_ADDR_FORMATTED  DY                                    
MFA-TR*          WHERE PR.PREMISE_NO = :PR-PREMISE-NO                   50170000
MFA-TR*           AND DY.ADDRESS_ID  = PR.ADDRESS_ID                    50180000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    50200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7740 GET PREM DET ' TO RS-ERROR-DESC          
                                                 S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7740'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_PREMISE'             TO TABLE-1                
               MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-2                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7750-REG-PROFILE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT REG_GROUP_CD,                                     
                      SENIOR_FL                                         
                 INTO :LR-REG-GROUP-CD,                                 
                      :LR-SENIOR-FL                                     
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                 WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD,                                             
MFA-TR*               SENIOR_FL                                                 
MFA-TR*          INTO :LR-REG-GROUP-CD,                                         
MFA-TR*               :LR-SENIOR-FL                                             
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*          WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                              
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                WHEN SUCCESSFUL-CALL                                    
                    MOVE LR-REG-GROUP-CD TO RS-GROUP-CD(1:3)            
                    IF LR-SENIOR-FL = 'Y'                               
                        MOVE '-S' TO RS-GROUP-CD(4:2)                   
                    ELSE                                                
                        MOVE '  ' TO RS-GROUP-CD(4:2)                   
                    END-IF                                              
                WHEN NOT-FOUND                                          
A37666              IF WS-ARCHIVED-ACCOUNT = 'Y'                        
A37666                  MOVE HA-REG-GROUP-CD TO RS-GROUP-CD(1:3)        
A37666                  IF HA-SENIOR-FL = 'Y'                           
A37666                      MOVE '-S' TO RS-GROUP-CD(4:2)               
A37666                  ELSE                                            
A37666                      MOVE '  ' TO RS-GROUP-CD(4:2)               
A37666                  END-IF                                          
A37666              ELSE                                                
                        MOVE 'NA' TO RS-GROUP-CD                        
A37666              END-IF                                              
                WHEN OTHER                                              
                    MOVE 'PARA 7750 GET REG PROF ' TO RS-ERROR-DESC     
                                                      S-ERROR-DESC      
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7750'               TO ACTIVE-PARAGRAPH       
                    MOVE 'SELECT'             TO ABEND-FUNCTION         
                    MOVE 'CSS_REG_PROFILE'    TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7760-ACTIVE-DHR.                                                 
                                                                        
           EXEC SQL                                                     
P00172         SELECT TOP(1) 'Y'                                               
                 INTO :WS-ACTIVE-DHR                                    
P00172           FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
P00172           WHERE CUSTOMER_NO       = :HT-CUSTOMER-NO              
P00172             AND DHR_FL            = 'Y'                          
P00172                                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ACTIVE-DHR                                            
MFA-TR*          FROM CSS_CUSTOMER                                              
MFA-TR*          WHERE CUSTOMER_NO       = :HT-CUSTOMER-NO                      
MFA-TR*            AND DHR_FL            = 'Y'                                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
                WHEN SUCCESSFUL-CALL                                    
                    IF WS-ACTIVE-DHR = 'Y'                              
                        MOVE '-DHR' TO RS-GROUP-CD(6:4)                 
                    ELSE                                                
                        MOVE '    ' TO RS-GROUP-CD(6:4)                 
                    END-IF                                              
                WHEN NOT-FOUND                                          
                    MOVE '    ' TO RS-GROUP-CD(6:4)                     
                WHEN OTHER                                              
                    MOVE 'PARA 7760 ACTIVE DHR' TO RS-ERROR-DESC        
                                                   S-ERROR-DESC         
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7760'               TO ACTIVE-PARAGRAPH       
                    MOVE 'SELECT'             TO ABEND-FUNCTION         
P00172              MOVE 'CSS_CUSTOMER'       TO TABLE-1                
P00172              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1        
P00172              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************51410000
      * 7915-GET-ACCOUNT-DETAILS                                       *51420000
      *                                                                *51430000
      *     GET COLUMNS FROM ACCOUNT TABLE.                            *51440000
      *                                                                *51450000
      ******************************************************************51460000
                                                                        
       7915-GET-ACCOUNT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_STAT,                                
                      AT.ACCOUNT_TYPE_CODE,                             
                      AT.LOCAL_OFFICE,                                  
                      AT.BANKRUPTCY_IND,                                
                      AT.ADDRESS_ID,                                    
                      AT.CUSTOMER_NO,                                   
                      AT.PREMISE_NO,                                    
                      AT.MST_SUB_ACCT_IND,                              
                      AT.CODES_DATA_PRESENT,                            
                      AT.CREDIT_GROUP,                                  
                      AT.CREDIT_STATUS_CODE,                            
                      AT.CODE_CRIT_OUTAGE,                              
ACT282                SW.CODE_LONG_DESC                                 
                INTO :AT-CODE-ACCT-STAT,                                
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-LOCAL-OFFICE,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-ADDRESS-ID,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CREDIT-GROUP,                                  
                     :AT-CREDIT-STATUS-CODE,                            
                     :AT-CODE-CRIT-OUTAGE,                              
                     :SW-CODE-LONG-DESC                                 
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED),                 
ACT282               CSS_SO_CODE_DESC SW WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              
ACT282           AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               
ACT282           AND SW.TABLE_NA          = 'CSS_ACCOUNT'               
ACT282           AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'         
ACT282           AND SW.PROGRAM_ID        = 'ALL'                       
ACT282           AND SW.COMPANY_NO        = '01'                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     51500000
MFA-TR*        SELECT AT.CODE_ACCT_STAT,                                51510000
MFA-TR*               AT.ACCOUNT_TYPE_CODE,                             51520000
MFA-TR*               AT.LOCAL_OFFICE,                                  51530000
MFA-TR*               AT.BANKRUPTCY_IND,                                51540000
MFA-TR*               AT.ADDRESS_ID,                                    51550000
MFA-TR*               AT.CUSTOMER_NO,                                   51560000
MFA-TR*               AT.PREMISE_NO,                                    51570000
MFA-TR*               AT.MST_SUB_ACCT_IND,                              51580000
MFA-TR*               AT.CODES_DATA_PRESENT,                            51590000
MFA-TR*               AT.CREDIT_GROUP,                                          
MFA-TR*               AT.CREDIT_STATUS_CODE,                            51610000
MFA-TR*               AT.CODE_CRIT_OUTAGE,                              51620000
MFA-TR*               SW.CODE_LONG_DESC                                 51630000
MFA-TR*         INTO :AT-CODE-ACCT-STAT,                                51640000
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                             51650000
MFA-TR*              :AT-LOCAL-OFFICE,                                  51660000
MFA-TR*              :AT-BANKRUPTCY-IND,                                51670000
MFA-TR*              :AT-ADDRESS-ID,                                    51680000
MFA-TR*              :AT-CUSTOMER-NO,                                   51690000
MFA-TR*              :AT-PREMISE-NO,                                    51700000
MFA-TR*              :AT-MST-SUB-ACCT-IND,                              51710000
MFA-TR*              :AT-CODES-DATA-PRESENT,                            51720000
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-CREDIT-STATUS-CODE,                            51740000
MFA-TR*              :AT-CODE-CRIT-OUTAGE,                              51750000
MFA-TR*              :SW-CODE-LONG-DESC                                 51760000
MFA-TR*         FROM CSS_ACCOUNT      AT,                               51770000
MFA-TR*              CSS_SO_CODE_DESC SW                                51780000
MFA-TR*        WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              51790000
MFA-TR*          AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               51800000
MFA-TR*          AND SW.TABLE_NA          = 'CSS_ACCOUNT'                       
MFA-TR*          AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'                 
MFA-TR*          AND SW.PROGRAM_ID        = 'ALL'                               
MFA-TR*          AND SW.COMPANY_NO        = '01'                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    51810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF HT-ADDRESS-ID = ZERO                                  
                   MOVE AT-ADDRESS-ID TO HT-ADDRESS-ID                  
               END-IF                                                   
               IF HT-PREMISE-NO = ZERO                                  
                   MOVE AT-PREMISE-NO TO HT-PREMISE-NO                  
               END-IF                                                   
               IF HT-CUSTOMER-NO = ZERO                                 
                   MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                
               END-IF                                                   
               MOVE AT-CODES-DATA-PRESENT                               
                   TO WS-CODES-DATA-PRESENT                             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO AT-CODE-ACCT-STAT                      
                                 AT-ACCOUNT-TYPE-CODE                   
                                 AT-LOCAL-OFFICE                        
                                 AT-BANKRUPTCY-IND                      
                                 AT-MST-SUB-ACCT-IND                    
                                 AT-CODES-DATA-PRESENT                  
                                 AT-CREDIT-STATUS-CODE                  
                                 AT-CODE-ACCT-STAT                      
                                 AT-CODE-CRIT-OUTAGE                    
ACT282                           SW-CODE-LONG-DESC                      
C37666             PERFORM 7990-ARCHIVE-ACCOUNT THRU 7990-EXIT          
               ELSE                                                     
                   MOVE 'PARA -7915 ,SELECT CSS_ACCOUNT     '           
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7915'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ACCOUNT'          TO TABLE-1               
ACT282             MOVE 'CSS_SO_CODE_DESC'     TO TABLE-2               
ACT282             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
ACT282             MOVE 'TABLE_NA'             TO TABLE-ELEMENT-2       
ACT282             MOVE 'COLUMN_NA'            TO TABLE-ELEMENT-3       
ACT282             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4       
ACT282             MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
ACT282             MOVE 'CSS_ACCOUNT'          TO HOSTVAR-ELEMENT-2     
ACT282             MOVE 'ACCOUNT_TYPE_CODE'    TO HOSTVAR-ELEMENT-3     
ACT282             MOVE '01'                   TO HOSTVAR-ELEMENT-4     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7915-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************53000000
      * 7920-GET-ADDRESS                                               *53010000
      *                                                                *53020000
      *     GET COLUMNS FROM FORMATTED ADDRESS TABLE.                  *53030000
      *                                                                *53040000
      ******************************************************************53050000
                                                                        
       7920-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              ADDRESS_OVERFLOW,
              ADDR_USAGE_CD,
              STREET_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              ZIP_CODE,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX                                       
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX                                   
                 FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
                WHERE ADDRESS_ID = :HT-ADDRESS-ID                       
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     53090000
MFA-TR*        SELECT HOUSE_NO,                                         53100000
MFA-TR*               ADDR_PREFIX_1,                                    53110000
MFA-TR*               ADDR_PREFIX_2,                                    53120000
MFA-TR*               STREET_NAME,                                      53130000
MFA-TR*               ADDRESS_OVERFLOW,                                 53140000
MFA-TR*               ADDR_USAGE_CD,                                    53150000
MFA-TR*               STREET_SUFFIX,                                    53160000
MFA-TR*               STREET_LOCATION_1,                                53170000
MFA-TR*               STREET_LOCATION_2,                                53180000
MFA-TR*               ZIP_CODE,                                         53190000
MFA-TR*               ZIP_CODE_TOKEN,                                   53200000
MFA-TR*               ADDR_SUFFIX                                               
MFA-TR*        INTO   :DY-HOUSE-NO,                                     53210000
MFA-TR*               :DY-ADDR-PREFIX-1,                                53220000
MFA-TR*               :DY-ADDR-PREFIX-2,                                53230000
MFA-TR*               :DY-STREET-NAME,                                  53240000
MFA-TR*               :DY-ADDRESS-OVERFLOW,                             53250000
MFA-TR*               :DY-ADDR-USAGE-CD,                                53260000
MFA-TR*               :DY-STREET-SUFFIX,                                53270000
MFA-TR*               :DY-STREET-LOCATION-1,                            53280000
MFA-TR*               :DY-STREET-LOCATION-2,                            53290000
MFA-TR*               :DY-ZIP-CODE,                                     53300000
MFA-TR*               :DY-ZIP-CODE-TOKEN,                               53310000
MFA-TR*               :DY-ADDR-SUFFIX                                           
MFA-TR*          FROM CSS_ADDR_FORMATTED                                53320000
MFA-TR*         WHERE ADDRESS_ID = :HT-ADDRESS-ID                       53330000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    53340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7920 ,SELECT CSS_ADDR_FORMATTED'             
                  TO RS-ERROR-DESC                                      
                     S-ERROR-DESC                                       
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7920'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
               MOVE HT-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************53570000
      * 7925-GET-CITY                                                  *53580000
      *                                                                *53590000
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *53600000
      *                                                                *53610000
      ******************************************************************53620000
                                                                        
       7925-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     53660000
MFA-TR*        SELECT TOWN                                              53670000
MFA-TR*          INTO :A4-TOWN                                          53680000
MFA-TR*          FROM CSS_ZIP_CODE                                      53690000
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                     53700000
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               53710000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                    53720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
               ELSE                                                     
                   MOVE 'PARA -7925 ,SELECT CSS_ZIP_CODE      '         
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7925'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************53980000
      * 7930-GET-NAME                                                  *53990000
      *                                                                *54000000
      *     GET CUSTOMER'S NAME.                                       *54010000
      *                                                                *54020000
      ******************************************************************54030000
                                                                        
       7930-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              TITLE_SUFFIX_2,
              FULL_NAME                                         
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME                                          
                WHERE NAME_ID      = :HT-NAME-ID                        
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     54070000
MFA-TR*        SELECT NAME_TYPE,                                        54080000
MFA-TR*               NAME_FORMAT,                                      54090000
MFA-TR*               LAST_NAME,                                        54100000
MFA-TR*               FIRST_NAME,                                       54110000
MFA-TR*               MIDDLE_NAME,                                      54120000
MFA-TR*               TITLE_PREFIX,                                     54130000
MFA-TR*               TITLE_SUFFIX_1,                                   54140000
MFA-TR*               TITLE_SUFFIX_2,                                   54150000
MFA-TR*               FULL_NAME                                         54160000
MFA-TR*         INTO :DQ-NAME-TYPE,                                     54170000
MFA-TR*              :DQ-NAME-FORMAT,                                   54180000
MFA-TR*              :DQ-LAST-NAME,                                     54190000
MFA-TR*              :DQ-FIRST-NAME,                                    54200000
MFA-TR*              :DQ-MIDDLE-NAME,                                   54210000
MFA-TR*              :DQ-TITLE-PREFIX,                                  54220000
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                54230000
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                54240000
MFA-TR*              :DQ-FULL-NAME                                      54250000
MFA-TR*          FROM CSS_NAME                                          54260000
MFA-TR*         WHERE NAME_ID      = :HT-NAME-ID                        54270000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                    54280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO DQ-NAME-TYPE                           
                                 DQ-NAME-FORMAT                         
                                 DQ-LAST-NAME                           
                                 DQ-FIRST-NAME                          
                                 DQ-MIDDLE-NAME                         
                                 DQ-TITLE-PREFIX                        
                                 DQ-TITLE-SUFFIX-1                      
                                 DQ-TITLE-SUFFIX-2                      
                                 DQ-FULL-NAME                           
               ELSE                                                     
                   MOVE 'PARA -7930 ,SELECT CSS_NAME          '         
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7930'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_NAME'             TO TABLE-1               
                   MOVE 'NAME_ID'              TO TABLE-ELEMENT-1       
                   MOVE HT-NAME-ID             TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************54630000
      * 7940-GET-PREMISE-DETAILS.                                      *54640000
      *                                                                *54650000
      *     GET COLUMNS FROM PREMISE TABLE.                            *54660000
      *                                                                *54670000
      ******************************************************************54680000
                                                                        
       7940-GET-PREMISE-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT SUBDIVISION_ID,                                   
                      GAS_AVAILABLE_IND,                                
                      ELEC_AVAILABLE_IND,                               
                      LITE_AVAILABLE_IND,                               
                      WTR_AVAILABLE_IND,                                
                      SWR_AVAILABLE_IND,                                
                      LOCAL_OFFICE,                                     
C35979                COMPANY_NO                                        
                INTO :PR-SUBDIVISION-ID,                                
                     :PR-GAS-AVAILABLE-IND,                             
                     :PR-ELEC-AVAILABLE-IND,                            
                     :PR-LITE-AVAILABLE-IND,                            
                     :PR-WTR-AVAILABLE-IND,                             
                     :PR-SWR-AVAILABLE-IND,                             
                     :AT-LOCAL-OFFICE,                                  
C35979               :PR-COMPANY-NO                                     
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     54720000
MFA-TR*        SELECT SUBDIVISION_ID,                                   54730000
MFA-TR*               GAS_AVAILABLE_IND,                                54740000
MFA-TR*               ELEC_AVAILABLE_IND,                               54750000
MFA-TR*               LITE_AVAILABLE_IND,                               54760000
MFA-TR*               WTR_AVAILABLE_IND,                                54770000
MFA-TR*               SWR_AVAILABLE_IND,                                54780000
MFA-TR*               LOCAL_OFFICE,                                     54790000
MFA-TR*               COMPANY_NO                                                
MFA-TR*         INTO :PR-SUBDIVISION-ID,                                54800000
MFA-TR*              :PR-GAS-AVAILABLE-IND,                             54810000
MFA-TR*              :PR-ELEC-AVAILABLE-IND,                            54820000
MFA-TR*              :PR-LITE-AVAILABLE-IND,                            54830000
MFA-TR*              :PR-WTR-AVAILABLE-IND,                             54840000
MFA-TR*              :PR-SWR-AVAILABLE-IND,                             54850000
MFA-TR*              :AT-LOCAL-OFFICE,                                  54860000
MFA-TR*              :PR-COMPANY-NO                                             
MFA-TR*         FROM CSS_PREMISE                                        54870000
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                        54880000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    54890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7940 ,SELECT CSS_PREMISE   '                 
                   TO RS-ERROR-DESC                                     
                      S-ERROR-DESC                                      
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7940'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SUBDIVISION_DESC                                  
                 INTO :B0-SUBDIVISION-DESC                              
                 FROM CSS_SUBDIVISION                                   
                WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID               
C35979            AND COMPANY_NO     = :PR-COMPANY-NO                   
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     55080000
MFA-TR*        SELECT SUBDIVISION_DESC                                  55090000
MFA-TR*          INTO :B0-SUBDIVISION-DESC                              55100000
MFA-TR*          FROM CSS_SUBDIVISION                                   55110000
MFA-TR*         WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID               55120000
MFA-TR*           AND COMPANY_NO     = :PR-COMPANY-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                    55130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               IF SQLCODE = NOT-FOUND                                   
                   MOVE SPACE TO B0-SUBDIVISION-DESC                    
               ELSE                                                     
                   MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE               
                   MOVE 'PARA -7940 ,SELECT CSS_SUBDIVISION'            
                       TO RS-ERROR-DESC                                 
                          S-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7940'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_SUBDIVISION'      TO TABLE-1               
                   MOVE 'SUBDIVISION_ID'       TO TABLE-ELEMENT-1       
                   MOVE PR-SUBDIVISION-ID      TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************56170000
405200* 7970-GET-CUST-NAME                                             *56180000
      *                                                                *56190000
      *     FIND THE CUSTOMER NAME FOR AN ACCOUNT.                     *56200000
      *                                                                *56210000
      ******************************************************************56220000
                                                                        
       7970-GET-CUST-NAME.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME,
              DQ.NAME_FORMAT,
              DQ.TITLE_SUFFIX_1                                 
                 INTO :WS-CUST-FIRST-NAME,                              
                      :WS-CUST-MIDDLE-NAME,                             
                      :WS-CUST-LAST-NAME,                               
                      :WS-CUST-FULL-NAME,                               
                      :WS-CUST-NAME-FORMAT,                             
                      :WS-CUST-TITLE-SUFFIX-1                           
                 FROM CSS_NAME_ACCT_XREF HT,                            
                      CSS_NAME DQ                                       
                WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND HT.NAME_ID    = DQ.NAME_ID                        
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE  = 'CN'                              
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     56260000
MFA-TR*        SELECT DQ.FIRST_NAME,                                    56270000
MFA-TR*               DQ.MIDDLE_NAME,                                   56280000
MFA-TR*               DQ.LAST_NAME,                                     56290000
MFA-TR*               DQ.FULL_NAME,                                     56300000
MFA-TR*               DQ.NAME_FORMAT,                                   56310000
MFA-TR*               DQ.TITLE_SUFFIX_1                                 56320000
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                              56330000
MFA-TR*               :WS-CUST-MIDDLE-NAME,                             56340000
MFA-TR*               :WS-CUST-LAST-NAME,                               56350000
MFA-TR*               :WS-CUST-FULL-NAME,                               56360000
MFA-TR*               :WS-CUST-NAME-FORMAT,                             56370000
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                           56380000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                            56390000
MFA-TR*               CSS_NAME DQ                                       56400000
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    56410000
MFA-TR*           AND HT.NAME_ID    = DQ.NAME_ID                        56420000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                         56430000
MFA-TR*           AND DQ.NAME_TYPE  = 'CN'                              56440000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                    56450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7970 ,SELECT CSS_NAME'                       
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7970'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************56660000
      * 7971-GET-CUST-NAME-WCUSNUM                                     *56670000
      *                                                                *56680000
      *     FIND THE CUSTOMER NAME FOR AN ACCOUNT USING THE CUSTOMER #.*56690000
      *                                                                *56700000
      ******************************************************************56710000
                                                                        
       7971-GET-CUST-NAME-WCUSNUM.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME,
              DQ.NAME_FORMAT,
              DQ.TITLE_SUFFIX_1                                 
                 INTO :WS-CUST-FIRST-NAME,                              
                      :WS-CUST-MIDDLE-NAME,                             
                      :WS-CUST-LAST-NAME,                               
                      :WS-CUST-FULL-NAME,                               
                      :WS-CUST-NAME-FORMAT,                             
                      :WS-CUST-TITLE-SUFFIX-1                           
                 FROM CSS_NAME_ACCT_XREF HT,                            
                      CSS_NAME DQ                                       
                WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                 
                  AND HT.NAME_ID      = DQ.NAME_ID                      
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE    = 'CN'                            
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     56750000
MFA-TR*        SELECT DQ.FIRST_NAME,                                    56760000
MFA-TR*               DQ.MIDDLE_NAME,                                   56770000
MFA-TR*               DQ.LAST_NAME,                                     56780000
MFA-TR*               DQ.FULL_NAME,                                     56790000
MFA-TR*               DQ.NAME_FORMAT,                                   56800000
MFA-TR*               DQ.TITLE_SUFFIX_1                                 56810000
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                              56820000
MFA-TR*               :WS-CUST-MIDDLE-NAME,                             56830000
MFA-TR*               :WS-CUST-LAST-NAME,                               56840000
MFA-TR*               :WS-CUST-FULL-NAME,                               56850000
MFA-TR*               :WS-CUST-NAME-FORMAT,                             56860000
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                           56870000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                            56880000
MFA-TR*               CSS_NAME DQ                                       56890000
MFA-TR*         WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                 56900000
MFA-TR*           AND HT.NAME_ID      = DQ.NAME_ID                      56910000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                         56920000
MFA-TR*           AND DQ.NAME_TYPE    = 'CN'                            56930000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                    56940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7971 ,SELECT CSS_NAME'                       
                      TO RS-ERROR-DESC                                  
                         S-ERROR-DESC                                   
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7971'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CUSTOMER-NO'          TO TABLE-ELEMENT-1           
               MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7971-EXIT.                                                       
           EXIT.                                                        
                                                                        
C37666 7990-ARCHIVE-ACCOUNT.                                            
C37666                                                                  
C37666     EXEC SQL                                                     
C37666        SELECT TOP(1) CUSTOMER_NO,
              ACCOUNT_NO,
              PREMISE_NO,
              HA.COMPANY_NO,
              LOCAL_OFFICE,
              ARCHIVED_DT,
              ACCT_CREATE_DT,
              ACCT_FINALED_DT,
              HA.ACCOUNT_TYPE_CODE,
              CODE_ACCT_STAT,
              CODE_STATUS_REASON,
              CREDIT_GROUP,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              LAST_PYMT_DATE,
              LAST_PYMT_AMOUNT,
              ACCT_XFER_FROM_LST,
              ACCT_XFER_TO,
              ACCOUNT_BALANCE_AM,
              REG_GROUP_CD,
              SENIOR_FL,
              DIST_ACCT_NO,
              ORIGINATION_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), GROUP_EFF_TS, 121), 
           ' ', '-'), ':', '.') GROUP_EFF_TS,
              CODE_LONG_DESC                                     
C37666          INTO :HA-CUSTOMER-NO,                                   
C37666               :HA-ACCOUNT-NO,                                    
C37666               :HA-PREMISE-NO,                                    
C37666               :HA-COMPANY-NO,                                    
C37666               :HA-LOCAL-OFFICE,                                  
C37666               :HA-ARCHIVED-DT,                                   
C37666               :HA-ACCT-CREATE-DT,                                
C37666               :HA-ACCT-FINALED-DT,                               
C37666               :HA-ACCOUNT-TYPE-CODE,                             
C37666               :HA-CODE-ACCT-STAT,                                
C37666               :HA-CODE-STATUS-REASON,                            
C37666               :HA-CREDIT-GROUP,                                  
C37666               :HA-ADDRESS-ID,                                    
C37666               :HA-ADDRESS-FORMAT,                                
C37666               :HA-LAST-PYMT-DATE :WS-NULL-PYMT-DATE-HA,           
C37666               :HA-LAST-PYMT-AMOUNT,                              
C37666               :HA-ACCT-XFER-FROM-LST,                            
C37666               :HA-ACCT-XFER-TO,                                  
C37666               :HA-ACCOUNT-BALANCE-AM,                            
C37666               :HA-REG-GROUP-CD,                                  
C37666               :HA-SENIOR-FL,                                     
C37666               :HA-DIST-ACCT-NO,                                  
C37666               :HA-ORIGINATION-CD,                                
C37666               :HA-GROUP-EFF-TS :WS-NULL-GROUP-EFF-TS,             
ACT282               :SW-CODE-LONG-DESC                                 
C37666          FROM HST_ACCOUNT HA WITH(READUNCOMMITTED),                      
ACT282               CSS_SO_CODE_DESC SW WITH(READUNCOMMITTED)                  
C37666         WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              
ACT282           AND HA.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               
ACT282           AND SW.TABLE_NA          = 'CSS_ACCOUNT'               
ACT282           AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'         
ACT282           AND SW.PROGRAM_ID        = 'ALL'                       
ACT282           AND SW.COMPANY_NO        = '01'                        
C37666                                           
C37666                                                           
C37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              HA.COMPANY_NO,                                             
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              ARCHIVED_DT,                                               
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              HA.ACCOUNT_TYPE_CODE,                                      
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CODE_STATUS_REASON,                                        
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              LAST_PYMT_DATE,                                            
MFA-TR*              LAST_PYMT_AMOUNT,                                          
MFA-TR*              ACCT_XFER_FROM_LST,                                        
MFA-TR*              ACCT_XFER_TO,                                              
MFA-TR*              ACCOUNT_BALANCE_AM,                                        
MFA-TR*              REG_GROUP_CD,                                              
MFA-TR*              SENIOR_FL,                                                 
MFA-TR*              DIST_ACCT_NO,                                              
MFA-TR*              ORIGINATION_CD,                                            
MFA-TR*              GROUP_EFF_TS,                                              
MFA-TR*              CODE_LONG_DESC                                             
MFA-TR*         INTO :HA-CUSTOMER-NO,                                           
MFA-TR*              :HA-ACCOUNT-NO,                                            
MFA-TR*              :HA-PREMISE-NO,                                            
MFA-TR*              :HA-COMPANY-NO,                                            
MFA-TR*              :HA-LOCAL-OFFICE,                                          
MFA-TR*              :HA-ARCHIVED-DT,                                           
MFA-TR*              :HA-ACCT-CREATE-DT,                                        
MFA-TR*              :HA-ACCT-FINALED-DT,                                       
MFA-TR*              :HA-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :HA-CODE-ACCT-STAT,                                        
MFA-TR*              :HA-CODE-STATUS-REASON,                                    
MFA-TR*              :HA-CREDIT-GROUP,                                          
MFA-TR*              :HA-ADDRESS-ID,                                            
MFA-TR*              :HA-ADDRESS-FORMAT,                                        
MFA-TR*              :HA-LAST-PYMT-DATE:WS-NULL-PYMT-DATE-HA,                   
MFA-TR*              :HA-LAST-PYMT-AMOUNT,                                      
MFA-TR*              :HA-ACCT-XFER-FROM-LST,                                    
MFA-TR*              :HA-ACCT-XFER-TO,                                          
MFA-TR*              :HA-ACCOUNT-BALANCE-AM,                                    
MFA-TR*              :HA-REG-GROUP-CD,                                          
MFA-TR*              :HA-SENIOR-FL,                                             
MFA-TR*              :HA-DIST-ACCT-NO,                                          
MFA-TR*              :HA-ORIGINATION-CD,                                        
MFA-TR*              :HA-GROUP-EFF-TS:WS-NULL-GROUP-EFF-TS,                     
MFA-TR*              :SW-CODE-LONG-DESC                                         
MFA-TR*         FROM HST_ACCOUNT HA,                                            
MFA-TR*              CSS_SO_CODE_DESC SW                                        
MFA-TR*        WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO                      
MFA-TR*          AND HA.ACCOUNT_TYPE_CODE = SW.CODE_VALUE                       
MFA-TR*          AND SW.TABLE_NA          = 'CSS_ACCOUNT'                       
MFA-TR*          AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'                 
MFA-TR*          AND SW.PROGRAM_ID        = 'ALL'                               
MFA-TR*          AND SW.COMPANY_NO        = '01'                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37666                                                                  
C37666     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C37666                                                                  
C37666     EVALUATE WS-ACTIVE-RETURN-CODE                               
C37666         WHEN SUCCESSFUL-CALL                                     
C37666             MOVE 'Y' TO WS-ARCHIVED-ACCOUNT                      
C37666             MOVE WS-ARCHIVED-ACCOUNT TO RS-ARCHIVE-IND           
C37666             IF HT-ADDRESS-ID = ZERO                              
C37666                 MOVE HA-ADDRESS-ID TO HT-ADDRESS-ID              
C37666             END-IF                                               
C37666             IF HT-PREMISE-NO = ZERO                              
C37666                 MOVE HA-PREMISE-NO TO HT-PREMISE-NO              
C37666             END-IF                                               
C37666             IF HT-CUSTOMER-NO = ZERO                             
C37666                 MOVE HA-CUSTOMER-NO TO HT-CUSTOMER-NO            
C37666             END-IF                                               
C37666             MOVE SPACES TO WS-CODES-DATA-PRESENT                 
C37666             MOVE HA-ACCOUNT-NO TO AT-ACCOUNT-NO                  
C37666             MOVE HA-ACCOUNT-TYPE-CODE TO AT-ACCOUNT-TYPE-CODE    
C37666             MOVE HA-CREDIT-GROUP TO AT-CREDIT-GROUP              
C37666             MOVE HA-LOCAL-OFFICE TO AT-LOCAL-OFFICE              
C37666             MOVE HA-CODE-ACCT-STAT TO AT-CODE-ACCT-STAT          
C37666         WHEN NOT-FOUND                                           
C37666             CONTINUE                                             
C37666         WHEN OTHER                                               
C37666             MOVE 'PARA -7990 ,SELECT HST_ACCOUNT     '           
C37666                TO RS-ERROR-DESC                                  
C37666             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
C37666             MOVE '7990'          TO ACTIVE-PARAGRAPH             
C37666             MOVE 'SELECT'        TO ABEND-FUNCTION               
C37666             MOVE 'HST_ACCOUNT'   TO TABLE-1                      
ACT282             MOVE 'CSS_SO_CODE_DESC'     TO TABLE-2               
ACT282             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
ACT282             MOVE 'TABLE_NA'             TO TABLE-ELEMENT-2       
ACT282             MOVE 'COLUMN_NA'            TO TABLE-ELEMENT-3       
ACT282             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4       
ACT282             MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
ACT282             MOVE 'CSS_ACCOUNT'          TO HOSTVAR-ELEMENT-2     
ACT282             MOVE 'ACCOUNT_TYPE_CODE'    TO HOSTVAR-ELEMENT-3     
ACT282             MOVE '01'                   TO HOSTVAR-ELEMENT-4     
C37666             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C37666             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C37666     END-EVALUATE.                                                
C37666                                                                  
C37666 7990-EXIT.                                                       
C37666     EXIT.                                                        
      ******************************************************************00000100
      * 8000A-DELETE-GTT-ROWS.                                         *00000200
      ******************************************************************00000300
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 00000500
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 00000900
            EXEC SQL                                                    
                DELETE FROM #CSR04150_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR04150_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00001300
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 00001500
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04150_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 00003100
       8000A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************00000100
      * 8100-SEND-RESULT                                               *00000200
      ******************************************************************00000300
       8100-SEND-RESULT.                                                
           EXEC SQL                                                     
             INSERT INTO #CSR04150_R1                            
             (                                                          
              RETURN_CODE                                               
             ,RED_FLAG_INDICATOR                                        
             ,ERROR_DESC                                                
             ,ADDRESS                                                   
             ,CITY                                                      
             ,NAME                                                      
             ,NAME_TYPE                                                 
             ,ACCT_TYPE                                                 
             ,SERVICE_SUPPLIED                                          
             ,SUBDIVISION                                               
             ,STATUS                                                    
             ,ACCOUNT_NO                                                
             ,SERVICE_AVAIL                                             
             ,CUSTOMER_NO                                               
             ,LOCAL_OFFICE                                              
             ,PREMISE_NO                                                
             ,NAME_FORMAT                                               
             ,BANKRUPT_IND                                              
             ,CREDIT_GROUP                                              
             ,CREDIT_STATUS                                             
             ,CODE_ACCT_STAT                                            
             ,ELEC_RATE                                                 
             ,GAS_RATE                                                  
             ,LIGHT_RATE                                                
             ,ZIP_CODE                                                  
             ,ZIP_CODE_TOKEN                                            
             ,MST_SUB_ACCT_IND                                          
             ,COMPANY_NO                                                
             ,CUST_NAME                                                 
             ,CODES_DATA_PRESENT                                        
             ,CODE_CRIT_OUTAGE                                          
             ,ACCT_TYPE_DESC                                            
             ,METER_NO                                                  
             ,POINT_ID                                                  
             ,LIGHT_TYPE                                                
             ,POLE_NO                                                   
A37666       ,ARCHIVE_IND                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-RED-FLAG-INDICATOR                                     
             ,:S-ERROR-DESC                                             
             ,:S-ADDRESS                                                
             ,:S-CITY                                                   
             ,:S-NAME                                                   
             ,:S-NAME-TYPE                                              
             ,:S-ACCT-TYPE                                              
             ,:S-SERVICE-SUPPLIED                                       
             ,:S-SUBDIVISION                                            
             ,:S-STATUS                                                 
             ,:S-ACCOUNT-NO                                             
             ,:S-SERVICE-AVAIL                                          
             ,:S-CUSTOMER-NO                                            
             ,:S-LOCAL-OFFICE                                           
             ,:S-PREMISE-NO                                             
             ,:S-NAME-FORMAT                                            
             ,:S-BANKRUPT-IND                                           
             ,:S-CREDIT-GROUP                                           
             ,:S-CREDIT-STATUS                                          
             ,:S-CODE-ACCT-STAT                                         
             ,:S-ELEC-RATE                                              
             ,:S-GAS-RATE                                               
             ,:S-LIGHT-RATE                                             
             ,:S-ZIP-CODE                                               
             ,:S-ZIP-CODE-TOKEN                                         
             ,:S-MST-SUB-ACCT-IND                                       
             ,:S-COMPANY-NO                                             
             ,:S-CUST-NAME                                              
             ,:S-CODES-DATA-PRESENT                                     
             ,:S-CODE-CRIT-OUTAGE                                       
             ,:S-ACCT-TYPE-DESC                                         
             ,:S-METER-NO                                               
             ,:S-POINT-ID                                               
             ,:S-LIGHT-TYPE                                             
             ,:S-POLE-NO                                                
A37666       ,:S-ARCHIVE-IND                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04150_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,RED_FLAG_INDICATOR                                                
MFA-TR*      ,ERROR_DESC                                                        
MFA-TR*      ,ADDRESS                                                           
MFA-TR*      ,CITY                                                              
MFA-TR*      ,NAME                                                              
MFA-TR*      ,NAME_TYPE                                                         
MFA-TR*      ,ACCT_TYPE                                                         
MFA-TR*      ,SERVICE_SUPPLIED                                                  
MFA-TR*      ,SUBDIVISION                                                       
MFA-TR*      ,STATUS                                                            
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,SERVICE_AVAIL                                                     
MFA-TR*      ,CUSTOMER_NO                                                       
MFA-TR*      ,LOCAL_OFFICE                                                      
MFA-TR*      ,PREMISE_NO                                                        
MFA-TR*      ,NAME_FORMAT                                                       
MFA-TR*      ,BANKRUPT_IND                                                      
MFA-TR*      ,CREDIT_GROUP                                                      
MFA-TR*      ,CREDIT_STATUS                                                     
MFA-TR*      ,CODE_ACCT_STAT                                                    
MFA-TR*      ,ELEC_RATE                                                         
MFA-TR*      ,GAS_RATE                                                          
MFA-TR*      ,LIGHT_RATE                                                        
MFA-TR*      ,ZIP_CODE                                                          
MFA-TR*      ,ZIP_CODE_TOKEN                                                    
MFA-TR*      ,MST_SUB_ACCT_IND                                                  
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CUST_NAME                                                         
MFA-TR*      ,CODES_DATA_PRESENT                                                
MFA-TR*      ,CODE_CRIT_OUTAGE                                                  
MFA-TR*      ,ACCT_TYPE_DESC                                                    
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,POINT_ID                                                          
MFA-TR*      ,LIGHT_TYPE                                                        
MFA-TR*      ,POLE_NO                                                           
MFA-TR*      ,ARCHIVE_IND                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-RED-FLAG-INDICATOR                                             
MFA-TR*      ,:S-ERROR-DESC                                                     
MFA-TR*      ,:S-ADDRESS                                                        
MFA-TR*      ,:S-CITY                                                           
MFA-TR*      ,:S-NAME                                                           
MFA-TR*      ,:S-NAME-TYPE                                                      
MFA-TR*      ,:S-ACCT-TYPE                                                      
MFA-TR*      ,:S-SERVICE-SUPPLIED                                               
MFA-TR*      ,:S-SUBDIVISION                                                    
MFA-TR*      ,:S-STATUS                                                         
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-SERVICE-AVAIL                                                  
MFA-TR*      ,:S-CUSTOMER-NO                                                    
MFA-TR*      ,:S-LOCAL-OFFICE                                                   
MFA-TR*      ,:S-PREMISE-NO                                                     
MFA-TR*      ,:S-NAME-FORMAT                                                    
MFA-TR*      ,:S-BANKRUPT-IND                                                   
MFA-TR*      ,:S-CREDIT-GROUP                                                   
MFA-TR*      ,:S-CREDIT-STATUS                                                  
MFA-TR*      ,:S-CODE-ACCT-STAT                                                 
MFA-TR*      ,:S-ELEC-RATE                                                      
MFA-TR*      ,:S-GAS-RATE                                                       
MFA-TR*      ,:S-LIGHT-RATE                                                     
MFA-TR*      ,:S-ZIP-CODE                                                       
MFA-TR*      ,:S-ZIP-CODE-TOKEN                                                 
MFA-TR*      ,:S-MST-SUB-ACCT-IND                                               
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      ,:S-CUST-NAME                                                      
MFA-TR*      ,:S-CODES-DATA-PRESENT                                             
MFA-TR*      ,:S-CODE-CRIT-OUTAGE                                               
MFA-TR*      ,:S-ACCT-TYPE-DESC                                                 
MFA-TR*      ,:S-METER-NO                                                       
MFA-TR*      ,:S-POINT-ID                                                       
MFA-TR*      ,:S-LIGHT-TYPE                                                     
MFA-TR*      ,:S-POLE-NO                                                        
MFA-TR*      ,:S-ARCHIVE-IND                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04150_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                 00002000
       8100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************57510000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     57520000
      ******************************************************************57530000
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      ******************************************************************57580000
      *       END PROGRAM COPYLIB                                      *57590000
      ******************************************************************57600000
      *    COPY CPD00320.                                               57610000
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE.                                      *        
      ******************************************************************        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
