       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04143.                                            
       DATE-WRITTEN. 05/21/2008.                                        
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO SELECT THE MOST RECENT ACCOUNT AT A *        
      *  PREMISE FOR A GIVEN POINT ID. THE POINT-ID HERE IS THE POINTID*        
      *  IN CSS_MTRD_ENVRNMT WHICH IS A COMBINATION OF TAG_NM AND      *        
      *  AREA_ID.       PANEL 791                                      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/16/2008  SC41135  PROCEDURE ORIGINALLY CODED               *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
A05460*  09/27/16    MR7E794  REMOVED THE MAIN USER TABLE AS PART      *        
      *              ACT282   OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04143'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    UT - CSS_UTIL_ENVRNMT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    HT - CSS_NAME_ACCT_XREF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    PR - CSS_PREMISE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CU - CSS_CUSTOMER                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    MN - CSS_MTRD_ENVRNMT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    B0 - CSS_SUBDIVISON                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    A4 - CSS_ZIP_CD                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CB - CSS_CUST_PHONE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      ******************************************************************        
ACT282*    SW - CSS_SO_CODE_DESC                                                
      ******************************************************************        
           EXEC SQL                                                             
ACT282        INCLUDE TBSOCODE                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_PIM_POINT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPIMPNT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_REV_DISTRICT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_CUST_PLAN                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CSS_CUST_PREM_HIST                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04143_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR04143'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-SELECT-METHOD           PIC X(03).                  
               88  SEL-METH-POI             VALUE 'POI'.                
               88  SEL-METH-PIM             VALUE 'PIM'.                
                                                                        
       77  WS-BLO-LOT-SPACES                PIC X(05) VALUE SPACES.     
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-ADDRESS                   PIC X(71).                  
           05  RS-CITY                      PIC X(26).                  
           05  RS-NAME                      PIC X(76).                  
           05  RS-NAME-TYPE                 PIC X(2).                   
           05  RS-ACCT-TYPE                 PIC X.                      
           05  RS-SERVICE-SUPPLIED.                                     
               10  RS-SERV-SUPPLIED-OCC     OCCURS 5 TIMES.             
                   15  RS-SERV-SUPPLIED     PIC X.                      
           05  RS-SUBDIVISION               PIC X(26).                  
           05  RS-STATUS                    PIC X.                      
           05  RS-ACCOUNT-NO                PIC X(13).                  
           05  RS-SERVICE-AVAIL.                                        
               10  RS-SERV-AVAIL-OCC        OCCURS 5 TIMES.             
                   15  RS-SERV-AVAIL        PIC X.                      
           05  RS-CUSTOMER-NO               PIC X(10).                  
           05  RS-LOCAL-OFFICE              PIC X(3).                   
           05  RS-PREMISE-NO                PIC X(10).                  
           05  RS-NAME-FORMAT               PIC X.                      
           05  RS-CODE-ACCT-STAT            PIC X.                      
           05  RS-ELEC-RATE                 PIC XXX.                    
           05  RS-GAS-RATE                  PIC XXX.                    
           05  RS-UNMETER-RATE              PIC XXX.                    
           05  RS-ZIP-CODE                  PIC X(5).                   
           05  RS-ZIP-CODE-TOKEN            PIC X.                      
           05  RS-COMPANY-NO                PIC X(02).                  
           05  RS-CUST-NAME                 PIC X(76).                  
           05  RS-ACCT-TYPE-DESC            PIC X(25).                  
           05  RS-REV-DISTRICT              PIC X(40).                  
           05  RS-READ-CYCLE                PIC X(02).                  
           05  RS-READ-ROUTE                PIC X(04).                  
           05  RS-STREET-LOCATION-1         PIC X(04).                  
           05  RS-STREET-LOCATION-2         PIC X(11).                  
           05  RS-SELECT-FLAG               PIC X(01) VALUE SPACES.     
       01  RS-ERROR-DESC                PIC X(40) VALUE SPACES.         
                                                                        
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE               PIC S9(9) COMP.              
           05  S-ADDRESS                   PIC X(71).                   
           05  S-CITY                      PIC X(26).                   
           05  S-NAME                      PIC X(76).                   
           05  S-NAME-TYPE                 PIC X(2).                    
           05  S-ACCT-TYPE                 PIC X.                       
           05  S-SERVICE-SUPPLIED          PIC X(5).                    
           05  S-SUBDIVISION               PIC X(26).                   
           05  S-STATUS                    PIC X.                       
           05  S-ACCOUNT-NO                PIC X(13).                   
           05  S-SERVICE-AVAIL             PIC X(5).                    
           05  S-CUSTOMER-NO               PIC X(10).                   
           05  S-LOCAL-OFFICE               PIC X(3).                   
           05  S-PREMISE-NO                PIC X(10).                   
           05  S-NAME-FORMAT               PIC X.                       
           05  S-CODE-ACCT-STAT            PIC X.                       
           05  S-ELEC-RATE                 PIC XXX.                     
           05  S-GAS-RATE                  PIC XXX.                     
           05  S-UNMETER-RATE              PIC XXX.                     
           05  S-ZIP-CODE                  PIC X(5).                    
           05  S-ZIP-CODE-TOKEN            PIC X.                       
           05  S-COMPANY-NO                PIC X(02).                   
           05  S-CUST-NAME                 PIC X(76).                   
           05  S-ACCT-TYPE-DESC            PIC X(25).                   
           05  S-REV-DISTRICT              PIC X(40).                   
           05  S-READ-CYCLE                PIC X(02).                   
           05  S-READ-ROUTE                PIC X(04).                   
           05  S-STREET-LOCATION-1         PIC X(04).                   
           05  S-STREET-LOCATION-2         PIC X(11).                   
           05  S-SELECT-FLAG               PIC X(01) VALUE SPACES.      
       01 S-ERROR-DESC                    PIC X(40) VALUE SPACES.       
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
      ******************************************************************        
      *    INPUT PARAMETER SEARCH CRITERIA UNSTRING AREA               *        
      ******************************************************************        
                                                                        
       01  WS-PARM-CRITERIA.                                            
           05  WS-POI-PARM-CRITERIA.                                    
               10  POI-ID-NUMBER            PIC X(10).                  
      ******************************************************************        
      *    BETWEEN FIELD WORK AREAS                                    *        
      ******************************************************************        
           05  POI-ID-NUMBER-L              PIC X(10)  VALUE LOW-VALUE. 
           05  POI-ID-NUMBER-H              PIC X(10) VALUE HIGH-VALUE. 
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-FROM.                                                 
               10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-PREV-NAME                 PIC X(56) VALUE LOW-VALUE.  
           05  WS-PREV-ADDRESS              PIC X(71) VALUE LOW-VALUE.  
           05  WS-PREV-CITY                 PIC X(26) VALUE LOW-VALUE.  
           05  WS-PREV-PREMISE-NO           PIC X(10) VALUE LOW-VALUE.  
           05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR04143'.  
           05  WS-CUST-LAST-NAME            PIC X(40) VALUE SPACES.     
           05  WS-CUST-FIRST-NAME           PIC X(15) VALUE SPACES.     
           05  WS-CUST-MIDDLE-NAME          PIC X(15) VALUE SPACES.     
           05  WS-CUST-FULL-NAME            PIC X(76) VALUE SPACES.     
           05  WS-CUST-NAME-FORMAT          PIC X(01) VALUE SPACES.     
           05  WS-CUST-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.     
           05  WS-ADDRESS.                                              
               10  WS-ADDRESS-X             OCCURS 80 TIMES             
                                            INDEXED BY WS-ADD-SUB.      
                   15  FILLER               PIC X.                      
           05  WS-UNMTR-FOUND               PIC X(01).                  
           05  WS-ELEC-RATE                 PIC X(03).                  
           05  WS-GAS-RATE                  PIC X(03).                  
           05  WS-ELEC-RATE-NULL-IND        PIC S9(04) COMP VALUE 0.    
           05  WS-GAS-RATE-NULL-IND         PIC S9(04) COMP VALUE 0.    
           05  WS-TODAYS-DATE               PIC X(10).                  
           05  WS-ACTIVE-DHR                PIC X(01) VALUE ' '.        
           05  WS-AREA-ID                   PIC X(03) VALUE SPACES.     
           05  WS-TAG-NM                    PIC X(10) VALUE SPACES.     
           05  WS-POINT-ID                  PIC X(10) VALUE SPACES.     
           05  WS-SERVICES-SET              PIC X(01) VALUE 'N'.        
           05  WS-ROW-FOUND                 PIC X(01) VALUE 'N'.        
           05  WS-READ-CYCLE-NULL           PIC S9(04) COMP VALUE 0.    
           05  WS-READ-ROUTE-NULL           PIC S9(04) COMP VALUE 0.    
COB305     05 WS-HOLD-PREMISE-NO        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-HOLD-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
                                                                        
       01  WS-NEXT-VARAIBLES.                                           
           05  WS-NEXT-COUNTER              PIC S9(4) COMP VALUE 1.     
           05  WS-MULTIPLIER                PIC X(02) VALUE '00'.       
           05  WS-NEXT-MULTIPLIER           REDEFINES WS-MULTIPLIER     
                                            PIC 9(2).                   
           05  WS-ROWS-PROCESSED            PIC 9(4)  VALUE 1.          
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 20.    
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-POINT-ID             PIC X(10).                         
       01  PARM-SELECT-METHOD-TEMP   PIC X(03).                         
       01  PARM-NEXT-COUNTER         PIC X(02).                         
      ******************************************************************        
      *    PR-CURSOR USED TO SEARCH FOR POINT ID'S.                    *        
      ******************************************************************        
           EXEC SQL DECLARE PR-CURSOR CURSOR FOR                        
              SELECT  DISTINCT                                          
                      HT.CUSTOMER_NO,                                   
                      HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.NAME_ID,                                       
                      HT.CUSTOMER_ROLE_CD,                              
                      HT.COMPANY_NO,                                    
                      DY.STREET_NAME,                                   
                      DY.HOUSE_NO                                       
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED),              
                      CSS_NAME           DQ WITH(READUNCOMMITTED),              
                      CSS_PIM_POINT      PP WITH(READUNCOMMITTED),              
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE PP.AREA_ID         = :WS-AREA-ID                  
                  AND PP.TAG_NM          = :WS-TAG-NM                   
                  AND MN.GIS_POINT_ID    = PP.POINT_ID                  
                  AND MN.ACCOUNT_NO              = HT.ACCOUNT_NO        
                  AND HT.NAME_ID                 = DQ.NAME_ID           
                  AND DQ.NAME_TYPE               = 'CN'                 
                  AND HT.CUSTOMER_ROLE_CD        = ' '                  
                  AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
C33743*      ORDER BY HT.CUSTOMER_NO                                            
             ORDER BY DY.STREET_NAME, DY.HOUSE_NO                       
             FOR READ ONLY                                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PR-CURSOR CURSOR FOR                                
MFA-TR*       SELECT  DISTINCT                                                  
MFA-TR*               HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO                                               
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_MTRD_ENVRNMT   MN,                                    
MFA-TR*               CSS_NAME           DQ,                                    
MFA-TR*               CSS_PIM_POINT      PP,                                    
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE PP.AREA_ID         = :WS-AREA-ID                          
MFA-TR*           AND PP.TAG_NM          = :WS-TAG-NM                           
MFA-TR*           AND MN.GIS_POINT_ID    = PP.POINT_ID                          
MFA-TR*           AND MN.ACCOUNT_NO              = HT.ACCOUNT_NO                
MFA-TR*           AND HT.NAME_ID                 = DQ.NAME_ID                   
MFA-TR*           AND DQ.NAME_TYPE               = 'CN'                         
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*      ORDER BY HT.CUSTOMER_NO                                            
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO                               
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    UT-CURSOR USED TO SEARCH FOR CODE_UTIL_TYPE.                *        
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE UT-CURSOR CURSOR FOR                                
              SELECT CODE_UTIL_TYPE,MIN(RATE_PLAN_NO)                   
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                    
               GROUP BY CODE_UTIL_TYPE                                  
               HAVING CODE_UTIL_TYPE IN ('E','G','U')                   
             FOR READ ONLY                                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE UT-CURSOR CURSOR FOR                                        
MFA-TR*       SELECT CODE_UTIL_TYPE,MIN(RATE_PLAN_NO)                           
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*        WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                            
MFA-TR*        GROUP BY CODE_UTIL_TYPE                                          
MFA-TR*        HAVING CODE_UTIL_TYPE IN ('E','G','U')                           
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING PARM-POINT-ID                           
                                PARM-SELECT-METHOD-TEMP                 
                                PARM-NEXT-COUNTER.                      
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.              
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
               PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.               
               EXEC SQL                                                 
                   DECLARE C1 CURSOR  FOR                    
                   SELECT                                               
                        RETURN_CODE                AS RETURN_CODE       
                       ,LTRIM(RTRIM(ERROR_DESC))          AS ERROR_DESC        
                       ,LTRIM(RTRIM(ADDRESS))             AS ADDRESS           
                       ,LTRIM(RTRIM(CITY))                AS CITY              
                       ,LTRIM(RTRIM(NAME))                AS NAME              
                       ,LTRIM(RTRIM(NAME_TYPE))           AS NAME_TYPE         
                       ,LTRIM(RTRIM(ACCT_TYPE))           AS ACCT_TYPE         
                       ,RTRIM(SERVICE_SUPPLIED)    AS SERVICE_SUPPLIED  
                       ,LTRIM(RTRIM(SUBDIVISION))         AS SUBDIVISION       
                       ,LTRIM(RTRIM(STATUS))              AS CUST_STATUS       
                       ,LTRIM(RTRIM(ACCOUNT_NO))          AS 
           ACCOUNT_NUMBER    
                       ,RTRIM(SERVICE_AVAIL)       AS SERVICE_AVAIL     
                       ,LTRIM(RTRIM(CUSTOMER_NO))         AS 
           CUSTOMER_NUMBER   
                       ,LTRIM(RTRIM(LOCAL_OFFICE))        AS 
           LOCAL_OFFICE      
                       ,LTRIM(RTRIM(PREMISE_NO))          AS PREMISE_NO        
                       ,LTRIM(RTRIM(NAME_FORMAT))         AS NAME_FORMAT       
                       ,LTRIM(RTRIM(CODE_ACCT_STAT))      AS 
           CODE_ACCT_STAT    
                       ,LTRIM(RTRIM(ELEC_RATE))           AS ELEC_RATE         
                       ,LTRIM(RTRIM(GAS_RATE))            AS GAS_RATE          
                       ,LTRIM(RTRIM(UNMETER_RATE))        AS 
           UNMETER_RATE      
                       ,LTRIM(RTRIM(ZIP_CODE))            AS ZIP_CODE          
                       ,LTRIM(RTRIM(ZIP_CODE_TOKEN))      AS 
           ZIP_CODE_TOKEN    
                       ,LTRIM(RTRIM(COMPANY_NO))          AS COMPANY_NO        
                       ,LTRIM(RTRIM(CUST_NAME))           AS CUST_NAME         
                       ,LTRIM(RTRIM(ACCT_TYPE_DESC))      AS 
           ACCT_TYPE_DESC    
                       ,LTRIM(RTRIM(REV_DISTRICT))        AS REV_DIST          
                       ,LTRIM(RTRIM(READ_CYCLE))          AS READ_CYC          
                       ,LTRIM(RTRIM(READ_ROUTE))          AS READ_RTE          
                       ,LTRIM(RTRIM(STREET_LOCATION_1))   AS 
           STREET_LOCATION_1 
                       ,LTRIM(RTRIM(STREET_LOCATION_2))   AS 
           STREET_LOCATION_2 
                       ,LTRIM(RTRIM(SELECT_FLAG))         AS SELECT_FLAG       
                   FROM                                                 
                       #CSR04143_R1                              
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*                 RETURN_CODE                AS RETURN_CODE               
MFA-TR*                ,STRIP(ERROR_DESC)          AS ERROR_DESC                
MFA-TR*                ,STRIP(ADDRESS)             AS ADDRESS                   
MFA-TR*                ,STRIP(CITY)                AS CITY                      
MFA-TR*                ,STRIP(NAME)                AS NAME                      
MFA-TR*                ,STRIP(NAME_TYPE)           AS NAME_TYPE                 
MFA-TR*                ,STRIP(ACCT_TYPE)           AS ACCT_TYPE                 
MFA-TR*                ,RTRIM(SERVICE_SUPPLIED)    AS SERVICE_SUPPLIED          
MFA-TR*                ,STRIP(SUBDIVISION)         AS SUBDIVISION               
MFA-TR*                ,STRIP(STATUS)              AS CUST_STATUS               
MFA-TR*                ,STRIP(ACCOUNT_NO)          AS ACCOUNT_NUMBER            
MFA-TR*                ,RTRIM(SERVICE_AVAIL)       AS SERVICE_AVAIL             
MFA-TR*                ,STRIP(CUSTOMER_NO)         AS CUSTOMER_NUMBER           
MFA-TR*                ,STRIP(LOCAL_OFFICE)        AS LOCAL_OFFICE              
MFA-TR*                ,STRIP(PREMISE_NO)          AS PREMISE_NO                
MFA-TR*                ,STRIP(NAME_FORMAT)         AS NAME_FORMAT               
MFA-TR*                ,STRIP(CODE_ACCT_STAT)      AS CODE_ACCT_STAT            
MFA-TR*                ,STRIP(ELEC_RATE)           AS ELEC_RATE                 
MFA-TR*                ,STRIP(GAS_RATE)            AS GAS_RATE                  
MFA-TR*                ,STRIP(UNMETER_RATE)        AS UNMETER_RATE              
MFA-TR*                ,STRIP(ZIP_CODE)            AS ZIP_CODE                  
MFA-TR*                ,STRIP(ZIP_CODE_TOKEN)      AS ZIP_CODE_TOKEN            
MFA-TR*                ,STRIP(COMPANY_NO)          AS COMPANY_NO                
MFA-TR*                ,STRIP(CUST_NAME)           AS CUST_NAME                 
MFA-TR*                ,STRIP(ACCT_TYPE_DESC)      AS ACCT_TYPE_DESC            
MFA-TR*                ,STRIP(REV_DISTRICT)        AS REV_DIST                  
MFA-TR*                ,STRIP(READ_CYCLE)          AS READ_CYC                  
MFA-TR*                ,STRIP(READ_ROUTE)          AS READ_RTE                  
MFA-TR*                ,STRIP(STREET_LOCATION_1)   AS STREET_LOCATION_1         
MFA-TR*                ,STRIP(STREET_LOCATION_2)   AS STREET_LOCATION_2         
MFA-TR*                ,STRIP(SELECT_FLAG)         AS SELECT_FLAG               
MFA-TR*            FROM                                                         
MFA-TR*                SESSION.CSR04143_R1                                      
MFA-TR*        END-EXEC.                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04143_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04143_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04143_R1
               (                                                       
                   RETURN_CODE              INT                     
                  ,ERROR_DESC CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,ADDRESS CHAR(71)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2               
                  ,NAME_TYPE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,SERVICE_SUPPLIED CHAR(5)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                  ,SUBDIVISION CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
                  ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,SERVICE_AVAIL CHAR(5)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                  ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,LOCAL_OFFICE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,ELEC_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,GAS_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,UNMETER_RATE CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,ZIP_CODE CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,ZIP_CODE_TOKEN CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CUST_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,ACCT_TYPE_DESC CHAR(25)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,REV_DISTRICT CHAR(40)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,READ_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,READ_ROUTE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,STREET_LOCATION_1 CHAR(04)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,STREET_LOCATION_2 CHAR(11)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                  ,SELECT_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
                                          THRU 8000A-EXIT               
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04143_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *     2. SPLIT OUT PARM STRING INFORMATION                       *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
                   UNSTRING PARM-POINT-ID  DELIMITED BY CN-DELIMITER    
                       INTO POI-ID-NUMBER                               
                            WS-MULTIPLIER                               
                                                                        
                   MOVE POI-ID-NUMBER   TO WS-POINT-ID                  
                   MOVE POI-ID-NUMBER   TO POI-ID-NUMBER-L              
                                           POI-ID-NUMBER-H              
                   MOVE POI-ID-NUMBER(1:3) TO WS-AREA-ID                
                   MOVE SPACES             TO WS-TAG-NM                 
                   MOVE POI-ID-NUMBER(4:7) TO WS-TAG-NM                 
               MOVE PARM-SELECT-METHOD-TEMP    TO PARM-SELECT-METHOD.   
               MOVE PARM-NEXT-COUNTER          TO WS-NEXT-MULTIPLIER.   
      *****************************************************************         
      ** IF A MULTIPLIER IS SENT UP MULTIPLY IT BY THE MAX ROWS, WHICH          
      ** IS CURRENTLY 20.  THIS WILL TELL THE RPC WHEN TO ACTUALLY              
      ** START SENDING THE RESULT TO THE CLIENT                                 
      *****************************************************************         
                                                                        
           IF WS-NEXT-MULTIPLIER > 0                                    
              COMPUTE WS-NEXT-COUNTER =                                 
                   WS-NEXT-MULTIPLIER * CN-MAX-RETURN-ROWS              
              ADD  1  TO WS-NEXT-COUNTER                                
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
                   MOVE 0 TO WS-HOLD-PREMISE-NO                         
                             WS-HOLD-ACCOUNT-NO                         
                                                                        
                   PERFORM 2290-SEARCH-VIA-PR-CURSOR    THRU 2290-EXIT  
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
           IF CTR-ROWS = CN-MAX-RETURN-ROWS                             
               MOVE 101 TO RS-RETURN-CODE                               
               PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT                                               *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-ERROR-DESC          TO S-ERROR-DESC.                 
           MOVE RS-ADDRESS             TO S-ADDRESS.                    
           MOVE RS-CITY                TO S-CITY.                       
           MOVE RS-NAME                TO S-NAME.                       
           MOVE RS-NAME-TYPE           TO S-NAME-TYPE.                  
           MOVE RS-ACCT-TYPE           TO S-ACCT-TYPE.                  
           MOVE RS-SERVICE-SUPPLIED    TO S-SERVICE-SUPPLIED.           
           MOVE RS-SUBDIVISION         TO S-SUBDIVISION.                
           MOVE RS-STATUS              TO S-STATUS.                     
           MOVE RS-ACCOUNT-NO          TO S-ACCOUNT-NO.                 
           MOVE RS-SERVICE-AVAIL       TO S-SERVICE-AVAIL.              
           MOVE RS-CUSTOMER-NO         TO S-CUSTOMER-NO.                
           MOVE RS-LOCAL-OFFICE        TO S-LOCAL-OFFICE.               
           MOVE RS-PREMISE-NO          TO S-PREMISE-NO.                 
           MOVE RS-NAME-FORMAT         TO S-NAME-FORMAT.                
           MOVE RS-CODE-ACCT-STAT      TO S-CODE-ACCT-STAT.             
           MOVE RS-ELEC-RATE           TO S-ELEC-RATE.                  
           MOVE RS-GAS-RATE            TO S-GAS-RATE.                   
           MOVE RS-UNMETER-RATE        TO S-UNMETER-RATE.               
           MOVE RS-ZIP-CODE            TO S-ZIP-CODE.                   
           MOVE RS-ZIP-CODE-TOKEN      TO S-ZIP-CODE-TOKEN.             
           MOVE RS-COMPANY-NO          TO S-COMPANY-NO.                 
           MOVE RS-CUST-NAME           TO S-CUST-NAME.                  
           MOVE RS-ACCT-TYPE-DESC      TO S-ACCT-TYPE-DESC.             
           MOVE RS-REV-DISTRICT        TO S-REV-DISTRICT.               
           MOVE RS-READ-CYCLE          TO S-READ-CYCLE.                 
           MOVE RS-READ-ROUTE          TO S-READ-ROUTE.                 
           MOVE RS-STREET-LOCATION-1   TO S-STREET-LOCATION-1.          
           MOVE RS-STREET-LOCATION-2   TO S-STREET-LOCATION-2.          
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2290-SEARCH-VIA-PR-CURSOR                                      *        
      *     SEARCH FOR ACCOUNTS VIA PR CURSOR. CALL COMMON PARAGRAPH   *        
      *     TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.            *        
      ******************************************************************        
                                                                        
       2290-SEARCH-VIA-PR-CURSOR.                                       
                                                                        
                                                                        
           PERFORM 7291-OPEN-PR-CURSOR                  THRU 7291-EXIT. 
           PERFORM 7292-FETCH-PR-CURSOR                 THRU 7292-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
                      CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7292-FETCH-PR-CURSOR             THRU 7292-EXIT  
           END-PERFORM.                                                 
                                                                        
           PERFORM 7293-CLOSE-PR-CURSOR                 THRU 7293-EXIT. 
                                                                        
           IF CTR-ROWS >= CN-MAX-RETURN-ROWS                            
               GO TO 2290-EXIT                                          
           END-IF.                                                      
                                                                        
       2290-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-ROW                                               *        
      *     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *        
      *     FORMAT RESULT SET AND SEND DATA.                           *        
      ******************************************************************        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER AND                   
              PARM-SELECT-METHOD NOT = 'PIM'                            
                ADD  1  TO WS-ROWS-PROCESSED                            
                GO TO 2500-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE HT-COMPANY-NO TO RS-COMPANY-NO.                         
                                                                        
           IF SEL-METH-PIM                                              
           IF HT-PREMISE-NO NOT = WS-HOLD-PREMISE-NO                    
               MOVE ZEROES TO WS-CPD99-ACCOUNT-NO                       
                              WS-CPD99-PREMISE-NO                       
               MOVE HT-PREMISE-NO TO WS-HOLD-PREMISE-NO                 
                                     WS-CPD99-PREMISE-NO                
               PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT            
               MOVE WS-CPD99-ACCOUNT-NO TO WS-HOLD-ACCOUNT-NO           
           END-IF                                                       
           IF HT-ACCOUNT-NO NOT = WS-HOLD-ACCOUNT-NO                    
               GO TO 2500-EXIT                                          
           END-IF                                                       
           END-IF                                                       
                                                                        
           IF HT-NAME-ID NOT EQUAL ZERO THEN                            
               PERFORM 7930-GET-NAME               THRU 7930-EXIT       
               IF (HT-CUSTOMER-ROLE-CD > SPACES OR                      
                   DQ-NAME-TYPE NOT = 'CN') AND (HT-ACCOUNT-NO > 0      
                    OR DQ-NAME-TYPE = 'SN')                             
                  IF HT-ACCOUNT-NO > 0                                  
                     PERFORM 7970-GET-CUST-NAME  THRU 7970-EXIT         
                  ELSE                                                  
                     PERFORM 7971-GET-CUST-NAME-WCUSNUM                 
                                                 THRU 7971-EXIT         
                  END-IF                                                
                  IF WS-CUST-NAME-FORMAT = 'I'                          
                     MOVE WS-CUST-LAST-NAME TO WS-FROM                  
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-LAST-NAME                  
                                                                        
                     MOVE WS-CUST-FIRST-NAME TO WS-FROM                 
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-FIRST-NAME                 
                                                                        
                     IF WS-CUST-MIDDLE-NAME NOT = SPACE                 
                         MOVE WS-CUST-MIDDLE-NAME TO WS-FROM            
                         PERFORM 2510-PROCESS-FROM-STRING               
                         MOVE WS-FROM TO WS-CUST-MIDDLE-NAME            
                     END-IF                                             
                                                                        
                     MOVE WS-CUST-TITLE-SUFFIX-1 TO WS-FROM             
                     PERFORM 2510-PROCESS-FROM-STRING                   
                     MOVE WS-FROM TO WS-CUST-TITLE-SUFFIX-1             
                                                                        
                     IF WS-CUST-MIDDLE-NAME = SPACE                     
                      STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER   
                       ', ' DELIMITED SIZE                              
                       WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER        
                       ' ' DELIMITED SIZE                               
                       WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER    
                       INTO RS-CUST-NAME                                
                         END-STRING                                     
                     ELSE                                               
                       STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER  
                        ', ' DELIMITED SIZE                             
                        WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER       
                        ' ' DELIMITED SIZE                              
                        WS-CUST-MIDDLE-NAME DELIMITED CN-DELIMITER      
                        ' ' DELIMITED SIZE                              
                        WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER   
                        INTO RS-CUST-NAME                               
                         END-STRING                                     
                     END-IF                                             
                  ELSE                                                  
                     MOVE WS-CUST-FULL-NAME     TO RS-CUST-NAME         
                  END-IF                                                
                                                                        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE 'N' TO WS-SERVICES-SET.                                 
           MOVE SPACES TO RS-READ-ROUTE RS-READ-CYCLE.                  
           IF HT-ACCOUNT-NO NOT EQUAL TO ZERO                           
              PERFORM 7915-GET-ACCOUNT-DETAILS     THRU 7915-EXIT       
              PERFORM 7917-SUPPLIED-AVAILABLE      THRU 7917-EXIT       
              PERFORM 7918-READ-CYCLE              THRU 7918-EXIT       
              MOVE UT-READ-CYCLE   TO RS-READ-CYCLE                     
              IF UT-READ-ROUTE = ZEROES                                 
                  MOVE SPACES TO RS-READ-ROUTE                          
              ELSE                                                      
                  MOVE UT-READ-ROUTE   TO RS-READ-ROUTE                 
              END-IF                                                    
           ELSE                                                         
              MOVE SPACE TO AT-CODE-ACCT-STAT                           
                            AT-ACCOUNT-TYPE-CODE                        
                            AT-LOCAL-OFFICE                             
ACT282                      SW-CODE-LONG-DESC                           
           END-IF.                                                      
                                                                        
           IF HT-PREMISE-NO NOT EQUAL TO ZERO                           
               PERFORM 7940-GET-PREMISE-DETAILS     THRU 7940-EXIT      
               IF WS-SERVICES-SET = 'N' OR ' '                          
                   PERFORM 2520-PROCESS-SERVICES    THRU 2520-EXIT      
               END-IF                                                   
           ELSE                                                         
               MOVE SPACE  TO B0-SUBDIVISION-DESC                       
           END-IF.                                                      
                                                                        
                                                                        
           IF HT-ADDRESS-ID NOT EQUAL TO ZERO                           
               PERFORM 7920-GET-ADDRESS          THRU 7920-EXIT         
               PERFORM 7925-GET-CITY             THRU 7925-EXIT         
           ELSE                                                         
               MOVE SPACE TO DY-HOUSE-NO                                
                             DY-ADDR-PREFIX-1                           
                             DY-ADDR-PREFIX-2                           
                             DY-STREET-NAME                             
                             DY-ADDRESS-OVERFLOW                        
                             DY-ADDR-USAGE-CD                           
                             DY-STREET-SUFFIX                           
                             DY-STREET-LOCATION-1                       
                             DY-STREET-LOCATION-2                       
                             DY-ZIP-CODE                                
                             DY-ZIP-CODE-TOKEN                          
                             A4-TOWN                                    
                             DY-ADDR-SUFFIX                             
           END-IF.                                                      
                                                                        
           IF SEL-METH-PIM                                              
               IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER                   
                   ADD 1 TO WS-ROWS-PROCESSED                           
                   GO TO 2500-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE B0-SUBDIVISION-DESC   TO RS-SUBDIVISION                 
           MOVE HT-ACCOUNT-NO         TO RS-ACCOUNT-NO.                 
           MOVE DQ-NAME-TYPE          TO RS-NAME-TYPE.                  
           MOVE AT-ACCOUNT-TYPE-CODE  TO RS-ACCT-TYPE.                  
ACT282     MOVE SW-CODE-LONG-DESC     TO RS-ACCT-TYPE-DESC.             
           MOVE AT-CODE-ACCT-STAT     TO RS-CODE-ACCT-STAT.             
           MOVE SPACE                 TO RS-ELEC-RATE.                  
           MOVE SPACE                 TO RS-GAS-RATE.                   
           MOVE SPACE                 TO RS-UNMETER-RATE.               
           MOVE DY-ZIP-CODE           TO RS-ZIP-CODE.                   
           MOVE DY-ZIP-CODE-TOKEN     TO RS-ZIP-CODE-TOKEN.             
           PERFORM 7274-OPEN-UT-CURSOR THRU 7274-EXIT.                  
           PERFORM 7275-FETCH-UT-CURSOR THRU 7275-EXIT.                 
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                EVALUATE UT-CODE-UTIL-TYPE                              
                    WHEN 'E'                                            
                        PERFORM 2550-CHECK-RATE   THRU 2550-EXIT        
                        IF WS-UNMTR-FOUND = 'N'                         
                           MOVE UT-RATE-PLAN-NO   TO RS-ELEC-RATE       
                           PERFORM 7720-CHECK-UNMTR-ELEC THRU 7720-EXIT 
                        ELSE                                            
                           PERFORM 7700-GET-ELEC-RATE THRU 7700-EXIT    
                        END-IF                                          
                    WHEN 'G'                                            
                        PERFORM 2550-CHECK-RATE   THRU 2550-EXIT        
                        IF WS-UNMTR-FOUND = 'N'                         
                           MOVE UT-RATE-PLAN-NO   TO RS-GAS-RATE        
                           PERFORM 7730-CHECK-UNMTR-GAS  THRU 7730-EXIT 
                        ELSE                                            
                           PERFORM 7710-GET-GAS-RATE  THRU 7710-EXIT    
                        END-IF                                          
                    WHEN 'U'                                            
                        IF UT-RATE-PLAN-NO > RS-UNMETER-RATE            
                           MOVE UT-RATE-PLAN-NO   TO RS-UNMETER-RATE    
                        END-IF                                          
                END-EVALUATE                                            
                PERFORM 7275-FETCH-UT-CURSOR      THRU 7275-EXIT        
           END-PERFORM.                                                 
           PERFORM 7276-CLOSE-UT-CURSOR           THRU 7276-EXIT.       
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF.                                                      
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
               MOVE DY-STREET-LOCATION-1 TO RS-STREET-LOCATION-1        
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
               MOVE DY-STREET-LOCATION-2 TO RS-STREET-LOCATION-2        
                                                                        
               IF DY-ADDR-SUFFIX NOT = SPACE                            
                   MOVE DY-ADDR-SUFFIX                 TO WS-FROM       
                   MOVE LENGTH OF DY-ADDR-SUFFIX       TO WS-MAX-SZ     
                   PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
           MOVE A4-TOWN              TO RS-CITY.                        
           MOVE AT-CODE-ACCT-STAT    TO RS-STATUS.                      
           MOVE HT-CUSTOMER-NO       TO RS-CUSTOMER-NO.                 
           MOVE AT-LOCAL-OFFICE      TO RS-LOCAL-OFFICE.                
           MOVE HT-PREMISE-NO        TO RS-PREMISE-NO.                  
           MOVE DQ-NAME-FORMAT       TO RS-NAME-FORMAT.                 
                                                                        
               MOVE RS-ADDRESS     TO WS-PREV-ADDRESS                   
               MOVE RS-CITY        TO WS-PREV-CITY                      
               MOVE RS-PREMISE-NO  TO WS-PREV-PREMISE-NO                
                                                                        
               MOVE RS-NAME        TO WS-PREV-NAME                      
                                                                        
           IF HT-CUSTOMER-NO = 0                                        
              MOVE SPACES TO RS-NAME                                    
           END-IF.                                                      
      ******************************************************************        
      *  THE FOLLOWING IF STATEMENT IS USED TO DISPLAY THE RELATIONSHIP*        
      *  A PERSON HAS WITH AN ACCOUNT.  THE CUSTOMER_ROLE_CD IN THE    *        
      *  THE CSS_NAME_ACCT_XREF TABLE SAYS WHETHER A PERSON IS A ROOM- *        
      *  MATE OR CO-APPLICANT.  WE ARE GOING TO MOVE THIS TO THE RE-   *        
      *  NAME_TYPE FIELD SO WE CAN SHOW ITS RELATIONSHIP.              *        
      ******************************************************************        
           IF HT-CUSTOMER-ROLE-CD = 'A'                                 
              MOVE 'A' TO RS-NAME-TYPE                                  
           END-IF.                                                      
                                                                        
           IF HT-CUSTOMER-ROLE-CD = 'B'                                 
              MOVE 'B' TO RS-NAME-TYPE                                  
           END-IF.                                                      
                                                                        
           MOVE PR-REV-DISTRICT-CD   TO RS-REV-DISTRICT(1:3).           
           MOVE ' - '                TO RS-REV-DISTRICT(4:3).           
           MOVE A9-REV-DISTRICT-DESC TO RS-REV-DISTRICT(7:33).          
                                                                        
           PERFORM 2000A-MOVE-RESULT         THRU    2000A-EXIT.        
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.        
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-PROCESS-FROM-STRING                                       *        
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *        
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *        
      ******************************************************************        
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2520-PROCESS-SERVICES                                          *        
      *     DETERMINE SERVICES USED BY THE PREMISE.                    *        
      ******************************************************************        
                                                                        
       2520-PROCESS-SERVICES.                                           
                                                                        
           IF PR-GAS-AVAILABLE-IND = 'A'                                
               MOVE 'G' TO RS-SERV-SUPPLIED (1)                         
                           RS-SERV-AVAIL (1)                            
           END-IF.                                                      
           IF PR-GAS-AVAILABLE-IND = 'I'                                
               MOVE 'G' TO RS-SERV-AVAIL (1)                            
           END-IF.                                                      
                                                                        
           IF PR-ELEC-AVAILABLE-IND = 'A'                               
               MOVE 'E' TO RS-SERV-SUPPLIED (2)                         
                           RS-SERV-AVAIL (2)                            
           END-IF.                                                      
           IF PR-ELEC-AVAILABLE-IND = 'I'                               
               MOVE 'E' TO RS-SERV-AVAIL (2)                            
           END-IF.                                                      
                                                                        
           IF PR-LITE-AVAILABLE-IND = 'A'                               
               MOVE 'L' TO RS-SERV-SUPPLIED (3)                         
                           RS-SERV-AVAIL (3)                            
           END-IF.                                                      
           IF PR-LITE-AVAILABLE-IND = 'I'                               
               MOVE 'L' TO RS-SERV-AVAIL (3)                            
           END-IF.                                                      
                                                                        
           IF PR-WTR-AVAILABLE-IND = 'A'                                
               MOVE 'W' TO RS-SERV-SUPPLIED (4)                         
                           RS-SERV-AVAIL (4)                            
           END-IF.                                                      
           IF PR-WTR-AVAILABLE-IND = 'I'                                
               MOVE 'W' TO RS-SERV-AVAIL (4)                            
           END-IF.                                                      
                                                                        
           IF PR-SWR-AVAILABLE-IND = 'A'                                
               MOVE 'S' TO RS-SERV-SUPPLIED (5)                         
                           RS-SERV-AVAIL (5)                            
           END-IF.                                                      
           IF PR-SWR-AVAILABLE-IND = 'I'                                
               MOVE 'S' TO RS-SERV-AVAIL (5)                            
           END-IF.                                                      
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2540-ACCUMULATE-ADDRESS                                        *        
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
      *     THE FORMATTED ADDRESS FIELD.                               *        
      ******************************************************************        
                                                                        
       2540-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH                               
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2550-CHECK-RATE.                                               *        
      *     DETERMINE IF THE ELECTRIC OR GAS RATE SUPPORTS UNMETERED   *        
      *     IC'S AND IF SO, MOVE THE RATE TO THE UNMETERED VARIABLE.   *        
      ******************************************************************        
       2550-CHECK-RATE.                                                 
                                                                        
            MOVE 'N'                          TO WS-UNMTR-FOUND.        
                                                                        
            IF UT-CODE-UTIL-TYPE = 'E'                                  
               IF UT-RATE-PLAN-NO = '013' OR '029' OR '069' OR '079' OR 
                                    '68A' OR '68B' OR '69A' OR '69B' OR 
                                    '69C' OR '69D' OR 'A68' OR 'A69' OR 
                                    'B68' OR 'B69' OR 'C69' OR 'D69'    
                  MOVE 'Y'                  TO WS-UNMTR-FOUND           
               END-IF                                                   
            ELSE                                                        
               IF UT-RATE-PLAN-NO = '049' OR '079' OR '047'             
                  MOVE 'Y'                  TO WS-UNMTR-FOUND           
               END-IF                                                   
            END-IF.                                                     
                                                                        
            IF WS-UNMTR-FOUND = 'Y' AND UT-RATE-PLAN-NO >               
                                        RS-UNMETER-RATE                 
               MOVE UT-RATE-PLAN-NO         TO RS-UNMETER-RATE          
            END-IF.                                                     
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE.                                      *        
      ******************************************************************        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7274-OPEN-UT-CURSOR                                            *        
      *     OPEN UT-CURSOR CHECK FOR SQL ERROR.                        *        
      ******************************************************************        
                                                                        
       7274-OPEN-UT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN UT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7274 ,OPEN   CURSOR UT-CURSOR  '             
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7274'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7274-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7275-FETCH-UT-CURSOR                                           *        
      *     FETCH UT-CURSOR CHECK FOR SQL ERROR.                       *        
      ******************************************************************        
                                                                        
       7275-FETCH-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH UT-CURSOR                                          
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7275 ,FETCH  CURSOR UT-CURSOR  '             
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7275'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7276-CLOSE-UT-CURSOR                                           *        
      *     CLOSE UT-CURSOR CHECK FOR SQL ERROR.                       *        
      ******************************************************************        
                                                                        
       7276-CLOSE-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE UT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7276 ,CLOSE  CURSOR UT-CURSOR  '             
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7276'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7276-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7291-OPEN-PR-CURSOR                                            *        
      *     OPEN PR-CURSOR CHECK FOR SQL ERROR.                        *        
      ******************************************************************        
                                                                        
       7291-OPEN-PR-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN PR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7291 ,OPEN   CURSOR PR-CURSOR  '             
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7291'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE POI-ID-NUMBER-L        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7291-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7292-FETCH-PR-CURSOR                                           *        
      *     FETCH PR-CURSOR CHECK FOR SQL ERROR.                       *        
      ******************************************************************        
                                                                        
       7292-FETCH-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH PR-CURSOR                                          
                INTO :HT-CUSTOMER-NO,                                   
                     :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-NAME-ID,                                       
                     :HT-CUSTOMER-ROLE-CD,                              
                     :HT-COMPANY-NO,                                    
                     :DY-STREET-NAME,                                   
                     :DY-HOUSE-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7292 ,FETCH  CURSOR PR-CURSOR  '             
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7292'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE POI-ID-NUMBER-L        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7292-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7293-CLOSE-PR-CURSOR                                           *        
      *     CLOSE PR-CURSOR CHECK FOR SQL ERROR.                       *        
      ******************************************************************        
                                                                        
       7293-CLOSE-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE PR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7293 ,CLOSE  CURSOR PR-CURSOR  '             
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7293'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CSS_NAME'             TO TABLE-3                   
               MOVE 'POINT_ID'             TO TABLE-ELEMENT-1           
               MOVE POI-ID-NUMBER-L        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7293-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ******************************************************************        
      * 7700-GET-ELEC-RATE.                                            *        
      ******************************************************************        
                                                                        
       7700-GET-ELEC-RATE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(RATE_PLAN_NO)                                 
                 INTO :WS-ELEC-RATE :WS-ELEC-RATE-NULL-IND               
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND RATE_PLAN_NO NOT IN ('013','029','069','079',     
                                           '68A','68B','69A','69B',     
                                           '69C','69D','A68','A69',     
                                           'B68','B69','C69','D69')     
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :WS-ELEC-RATE:WS-ELEC-RATE-NULL-IND                       
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('013','029','069','079',             
MFA-TR*                                    '68A','68B','69A','69B',             
MFA-TR*                                    '69C','69D','A68','A69',             
MFA-TR*                                    'B68','B69','C69','D69')             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-ELEC-RATE-NULL-IND = 0                             
                  MOVE WS-ELEC-RATE           TO RS-ELEC-RATE           
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7700 GET ELEC RATE' TO RS-ERROR-DESC          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7700'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'E'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7710-GET-GAS-RATE.                                             *        
      ******************************************************************        
                                                                        
       7710-GET-GAS-RATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(RATE_PLAN_NO)                                 
                 INTO :WS-GAS-RATE :WS-GAS-RATE-NULL-IND                 
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO NOT IN ('049','079','047')           
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :WS-GAS-RATE:WS-GAS-RATE-NULL-IND                         
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('049','079','047')                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-GAS-RATE-NULL-IND = 0                              
                  MOVE WS-GAS-RATE            TO RS-GAS-RATE            
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7710 GET GAS RATE'  TO RS-ERROR-DESC          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7710'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'G'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7720-CHECK-UNMTR-ELEC.                                         *        
      ******************************************************************        
                                                                        
       7720-CHECK-UNMTR-ELEC.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(RATE_PLAN_NO)                                 
                 INTO :WS-ELEC-RATE :WS-ELEC-RATE-NULL-IND               
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND RATE_PLAN_NO IN ('013','029','069','079',         
                                       '68A','68B','69A','69B',         
                                       '69C','69D','A68','A69',         
                                       'B68','B69','C69','D69')         
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :WS-ELEC-RATE:WS-ELEC-RATE-NULL-IND                       
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND RATE_PLAN_NO IN ('013','029','069','079',                 
MFA-TR*                                '68A','68B','69A','69B',                 
MFA-TR*                                '69C','69D','A68','A69',                 
MFA-TR*                                'B68','B69','C69','D69')                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-ELEC-RATE-NULL-IND = 0                             
                  MOVE WS-ELEC-RATE           TO RS-UNMETER-RATE        
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7720 GET ELEC RATE' TO RS-ERROR-DESC          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7720'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'E'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7730-CHECK-UNMTR-GAS.                                          *        
      ******************************************************************        
                                                                        
       7730-CHECK-UNMTR-GAS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MAX(RATE_PLAN_NO)                                 
                 INTO :WS-GAS-RATE :WS-GAS-RATE-NULL-IND                 
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO IN ('049','079','047')               
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :WS-GAS-RATE:WS-GAS-RATE-NULL-IND                         
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND RATE_PLAN_NO IN ('049','079','047')                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-GAS-RATE-NULL-IND = 0 AND WS-GAS-RATE >            
                                               RS-UNMETER-RATE          
                  MOVE WS-GAS-RATE            TO RS-UNMETER-RATE        
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7730 GET ELEC RATE' TO RS-ERROR-DESC          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7730'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               MOVE 'G'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7915-GET-ACCOUNT-DETAILS                                       *        
      *                                                                *        
      *     GET COLUMNS FROM ACCOUNT TABLE.                            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7915-GET-ACCOUNT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AT.CODE_ACCT_STAT,
              AT.ACCOUNT_TYPE_CODE,
              AT.LOCAL_OFFICE,
              AT.ADDRESS_ID,
              AT.CUSTOMER_NO,
              AT.PREMISE_NO,
              SW.CODE_LONG_DESC                                 
                INTO :AT-CODE-ACCT-STAT,                                
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-LOCAL-OFFICE,                                  
                     :AT-ADDRESS-ID,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
ACT282               :SW-CODE-LONG-DESC                                 
                FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED),                 
ACT282               CSS_SO_CODE_DESC SW WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              
ACT282           AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               
ACT282           AND SW.TABLE_NA   = 'CSS_ACCOUNT'                      
ACT282           AND SW.COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                
ACT282           AND SW.PROGRAM_ID = 'ALL'                              
ACT282           AND SW.COMPANY_NO = '01'                               
                                                 
ACT282                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODE_ACCT_STAT,                                        
MFA-TR*               AT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               AT.LOCAL_OFFICE,                                          
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.CUSTOMER_NO,                                           
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               SW.CODE_LONG_DESC                                         
MFA-TR*         INTO :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :SW-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_ACCOUNT      AT,                                       
MFA-TR*              CSS_SO_CODE_DESC SW                                        
MFA-TR*        WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO                      
MFA-TR*          AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE                       
MFA-TR*          AND SW.TABLE_NA   = 'CSS_ACCOUNT'                              
MFA-TR*          AND SW.COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                        
MFA-TR*          AND SW.PROGRAM_ID = 'ALL'                                      
MFA-TR*          AND SW.COMPANY_NO = '01'                                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF HT-ADDRESS-ID = ZERO                                  
                   MOVE AT-ADDRESS-ID TO HT-ADDRESS-ID                  
               END-IF                                                   
               IF HT-PREMISE-NO = ZERO                                  
                   MOVE AT-PREMISE-NO TO HT-PREMISE-NO                  
               END-IF                                                   
               IF HT-CUSTOMER-NO = ZERO                                 
                   MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO AT-CODE-ACCT-STAT                      
                                 AT-ACCOUNT-TYPE-CODE                   
                                 AT-LOCAL-OFFICE                        
                                 AT-CODE-ACCT-STAT                      
ACT282                           SW-CODE-LONG-DESC                      
               ELSE                                                     
                   MOVE 'PARA -7915 ,SELECT CSS_ACCOUNT     '           
                      TO RS-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7915'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ACCOUNT'          TO TABLE-1               
ACT282             MOVE 'CSS_SO_CODE_DESC'     TO TABLE-2               
ACT282             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
ACT282             MOVE 'TABLE_NA'             TO TABLE-ELEMENT-2       
ACT282             MOVE 'COLUMN_NA'            TO TABLE-ELEMENT-3       
ACT282             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4       
ACT282             MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
ACT282             MOVE 'CSS_ACCOUNT'          TO HOSTVAR-ELEMENT-2     
ACT282             MOVE 'ACCOUNT_TYPE_CODE'    TO HOSTVAR-ELEMENT-3     
ACT282             MOVE '01'                   TO HOSTVAR-ELEMENT-4     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7915-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7917-SUPPLIED-AVAILABLE.                                       *        
      ******************************************************************        
                                                                        
       7917-SUPPLIED-AVAILABLE.                                         
                                                                        
           MOVE 'Y' TO WS-SERVICES-SET.                                 
           PERFORM 7917E-SUPPLIED-AVAILABLE THRU 7917E-EXIT.            
           PERFORM 7917G-SUPPLIED-AVAILABLE THRU 7917G-EXIT.            
           PERFORM 7917L-SUPPLIED-AVAILABLE THRU 7917L-EXIT.            
                                                                        
       7917-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7917E-SUPPLIED-AVAILABLE.                                      *        
      ******************************************************************        
                                                                        
       7917E-SUPPLIED-AVAILABLE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'E' TO RS-SERV-SUPPLIED (2)                     
                               RS-SERV-AVAIL (2)                        
                   GO TO 7917E-EXIT                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917E'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'E' TO RS-SERV-AVAIL (2)                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917E'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7917E-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7917G-SUPPLIED-AVAILABLE.                                      *        
      ******************************************************************        
                                                                        
       7917G-SUPPLIED-AVAILABLE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')    
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND CODE_METER_STATUS IN ('0', '1', 'A', 'B', 'I')            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'G' TO RS-SERV-SUPPLIED (1)                     
                               RS-SERV-AVAIL (1)                        
                   GO TO 7917G-EXIT                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917G'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_MTRD_ENVRNMT                                  
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'G' TO RS-SERV-AVAIL (1)                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917G'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7917G-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7917L-SUPPLIED-AVAILABLE.                                      *        
      ******************************************************************        
                                                                        
       7917L-SUPPLIED-AVAILABLE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_CUST_PLAN                                     
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'U'                              
                  AND CODE_PLAN_STATUS = 'A'                            
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_CUST_PLAN                                             
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND CODE_PLAN_STATUS = 'A'                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'L' TO RS-SERV-SUPPLIED (3)                     
                               RS-SERV-AVAIL    (3)                     
                   GO TO 7917L-EXIT                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917L'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_CUST_PLAN'    TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ROW-FOUND                                     
                 FROM CSS_CUST_PLAN                                     
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'U'                              
                  AND CODE_PLAN_STATUS = 'I'                            
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ROW-FOUND                                             
MFA-TR*          FROM CSS_CUST_PLAN                                             
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND CODE_PLAN_STATUS = 'I'                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'L' TO RS-SERV-AVAIL (3)                        
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7917L'            TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7917L-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7918-READ-CYCLE.                                               *        
      ******************************************************************        
                                                                        
       7918-READ-CYCLE.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT MAX(READ_CYCLE)                                   
                 INTO :UT-READ-CYCLE :WS-READ-CYCLE-NULL                 
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE IN ('E', 'G')                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-READ-CYCLE-NULL < 0                            
                      MOVE SPACES TO UT-READ-CYCLE                      
                      MOVE ZEROES TO UT-READ-ROUTE                      
                   ELSE                                                 
                       PERFORM 7919-READ-ROUTE THRU 7919-EXIT           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                  MOVE SPACES TO UT-READ-CYCLE                          
                  MOVE ZEROES TO UT-READ-ROUTE                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7918'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7918-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7919-READ-ROUTE.                                               *        
      ******************************************************************        
                                                                        
       7919-READ-ROUTE.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT MAX(READ_ROUTE)                                   
                 INTO :UT-READ-ROUTE :WS-READ-ROUTE-NULL                 
                 FROM CSS_UTIL_ENVRNMT                                  
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE IN ('E', 'G')                      
                  AND READ_CYCLE = :UT-READ-CYCLE                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-READ-ROUTE-NULL < 0                            
                      MOVE ZEROES TO UT-READ-ROUTE                      
                   END-IF                                               
               WHEN NOT-FOUND                                           
                  MOVE ZEROES TO UT-READ-ROUTE                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7919'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7919-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7920-GET-ADDRESS                                               *        
      *     GET COLUMNS FROM FORMATTED ADDRESS TABLE.                  *        
      ******************************************************************        
                                                                        
       7920-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              ADDRESS_OVERFLOW,
              ADDR_USAGE_CD,
              STREET_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              ZIP_CODE,
              ZIP_CODE_TOKEN,
              ADDR_SUFFIX                                       
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX                                   
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :HT-ADDRESS-ID                       
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN,                                           
MFA-TR*               ADDR_SUFFIX                                               
MFA-TR*        INTO   :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-SUFFIX                                           
MFA-TR*          FROM CSS_ADDR_FORMATTED                                        
MFA-TR*         WHERE ADDRESS_ID = :HT-ADDRESS-ID                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7920 ,SELECT CSS_ADDR_FORMATTED'             
                  TO RS-ERROR-DESC                                      
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7920'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
               MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
               MOVE HT-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7925-GET-CITY                                                  *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      ******************************************************************        
                                                                        
       7925-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN                                                      
MFA-TR*          INTO :A4-TOWN                                                  
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                             
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
               ELSE                                                     
                   MOVE 'PARA -7925 ,SELECT CSS_ZIP_CODE      '         
                      TO RS-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7925'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7930-GET-NAME                                                  *        
      *     GET CUSTOMER'S NAME.                                       *        
      ******************************************************************        
                                                                        
       7930-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              TITLE_SUFFIX_2,
              FULL_NAME                                         
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME                                          
                WHERE NAME_ID      = :HT-NAME-ID                        
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NAME_TYPE,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               MIDDLE_NAME,                                              
MFA-TR*               TITLE_PREFIX,                                             
MFA-TR*               TITLE_SUFFIX_1,                                           
MFA-TR*               TITLE_SUFFIX_2,                                           
MFA-TR*               FULL_NAME                                                 
MFA-TR*         INTO :DQ-NAME-TYPE,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                        
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*          FROM CSS_NAME                                                  
MFA-TR*         WHERE NAME_ID      = :HT-NAME-ID                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO DQ-NAME-TYPE                           
                                 DQ-NAME-FORMAT                         
                                 DQ-LAST-NAME                           
                                 DQ-FIRST-NAME                          
                                 DQ-MIDDLE-NAME                         
                                 DQ-TITLE-PREFIX                        
                                 DQ-TITLE-SUFFIX-1                      
                                 DQ-TITLE-SUFFIX-2                      
                                 DQ-FULL-NAME                           
               ELSE                                                     
                   MOVE 'PARA -7930 ,SELECT CSS_NAME          '         
                      TO RS-ERROR-DESC                                  
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7930'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_NAME'             TO TABLE-1               
                   MOVE 'NAME_ID'              TO TABLE-ELEMENT-1       
                   MOVE HT-NAME-ID             TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7940-GET-PREMISE-DETAILS.                                      *        
      *     GET COLUMNS FROM PREMISE TABLE.                            *        
      ******************************************************************        
                                                                        
       7940-GET-PREMISE-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SUBDIVISION_ID,
              GAS_AVAILABLE_IND,
              ELEC_AVAILABLE_IND,
              LITE_AVAILABLE_IND,
              WTR_AVAILABLE_IND,
              SWR_AVAILABLE_IND,
              LOCAL_OFFICE,
              LOCATOR_ID,
              PR.REV_DISTRICT_CD,
              REV_DISTRICT_DESC                                 
                INTO :PR-SUBDIVISION-ID,                                
                     :PR-GAS-AVAILABLE-IND,                             
                     :PR-ELEC-AVAILABLE-IND,                            
                     :PR-LITE-AVAILABLE-IND,                            
                     :PR-WTR-AVAILABLE-IND,                             
                     :PR-SWR-AVAILABLE-IND,                             
                     :AT-LOCAL-OFFICE,                                  
                     :PR-LOCATOR-ID,                                    
                     :PR-REV-DISTRICT-CD,                               
                     :A9-REV-DISTRICT-DESC                              
                FROM CSS_PREMISE PR,                                    
                     CSS_REV_DISTRICT A9                                
               WHERE PREMISE_NO = :HT-PREMISE-NO                        
                 AND PR.REV_DISTRICT_CD = A9.REV_DISTRICT_CD            
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBDIVISION_ID,                                           
MFA-TR*               GAS_AVAILABLE_IND,                                        
MFA-TR*               ELEC_AVAILABLE_IND,                                       
MFA-TR*               LITE_AVAILABLE_IND,                                       
MFA-TR*               WTR_AVAILABLE_IND,                                        
MFA-TR*               SWR_AVAILABLE_IND,                                        
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               LOCATOR_ID,                                               
MFA-TR*               PR.REV_DISTRICT_CD,                                       
MFA-TR*               REV_DISTRICT_DESC                                         
MFA-TR*         INTO :PR-SUBDIVISION-ID,                                        
MFA-TR*              :PR-GAS-AVAILABLE-IND,                                     
MFA-TR*              :PR-ELEC-AVAILABLE-IND,                                    
MFA-TR*              :PR-LITE-AVAILABLE-IND,                                    
MFA-TR*              :PR-WTR-AVAILABLE-IND,                                     
MFA-TR*              :PR-SWR-AVAILABLE-IND,                                     
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :PR-LOCATOR-ID,                                            
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :A9-REV-DISTRICT-DESC                                      
MFA-TR*         FROM CSS_PREMISE PR,                                            
MFA-TR*              CSS_REV_DISTRICT A9                                        
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                                
MFA-TR*          AND PR.REV_DISTRICT_CD = A9.REV_DISTRICT_CD                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7940 ,SELECT CSS_PREMISE   '                 
                   TO RS-ERROR-DESC                                     
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7940'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_PREMISE'          TO TABLE-1                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SUBDIVISION_DESC                                  
                 INTO :B0-SUBDIVISION-DESC                              
                 FROM CSS_SUBDIVISION                                   
                WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID               
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBDIVISION_DESC                                          
MFA-TR*          INTO :B0-SUBDIVISION-DESC                                      
MFA-TR*          FROM CSS_SUBDIVISION                                           
MFA-TR*         WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               NEXT SENTENCE                                            
           ELSE                                                         
               IF SQLCODE = NOT-FOUND                                   
                   MOVE SPACE TO B0-SUBDIVISION-DESC                    
               ELSE                                                     
                   MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE               
                   MOVE 'PARA -7940 ,SELECT CSS_SUBDIVISION'            
                       TO RS-ERROR-DESC                                 
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7940'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_SUBDIVISION'      TO TABLE-1               
                   MOVE 'SUBDIVISION_ID'       TO TABLE-ELEMENT-1       
                   MOVE PR-SUBDIVISION-ID      TO HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7970-GET-CUST-NAME                                             *        
      *     FIND THE CUSTOMER NAME FOR AN ACCOUNT.                     *        
      ******************************************************************        
                                                                        
       7970-GET-CUST-NAME.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME,
              DQ.NAME_FORMAT,
              DQ.TITLE_SUFFIX_1                                 
                 INTO :WS-CUST-FIRST-NAME,                              
                      :WS-CUST-MIDDLE-NAME,                             
                      :WS-CUST-LAST-NAME,                               
                      :WS-CUST-FULL-NAME,                               
                      :WS-CUST-NAME-FORMAT,                             
                      :WS-CUST-TITLE-SUFFIX-1                           
                 FROM CSS_NAME_ACCT_XREF HT,                            
                      CSS_NAME DQ                                       
                WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND HT.NAME_ID    = DQ.NAME_ID                        
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE  = 'CN'                              
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.FIRST_NAME,                                            
MFA-TR*               DQ.MIDDLE_NAME,                                           
MFA-TR*               DQ.LAST_NAME,                                             
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_FORMAT,                                           
MFA-TR*               DQ.TITLE_SUFFIX_1                                         
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                                      
MFA-TR*               :WS-CUST-MIDDLE-NAME,                                     
MFA-TR*               :WS-CUST-LAST-NAME,                                       
MFA-TR*               :WS-CUST-FULL-NAME,                                       
MFA-TR*               :WS-CUST-NAME-FORMAT,                                     
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                                   
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                            
MFA-TR*           AND HT.NAME_ID    = DQ.NAME_ID                                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND DQ.NAME_TYPE  = 'CN'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7970 ,SELECT CSS_NAME'                       
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7970'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
               MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
               MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
               MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7970-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7971-GET-CUST-NAME-WCUSNUM                                     *        
      *     FIND THE CUSTOMER NAME FOR AN ACCOUNT USING THE CUSTOMER #.*        
      ******************************************************************        
                                                                        
       7971-GET-CUST-NAME-WCUSNUM.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME,
              DQ.NAME_FORMAT,
              DQ.TITLE_SUFFIX_1                                 
                 INTO :WS-CUST-FIRST-NAME,                              
                      :WS-CUST-MIDDLE-NAME,                             
                      :WS-CUST-LAST-NAME,                               
                      :WS-CUST-FULL-NAME,                               
                      :WS-CUST-NAME-FORMAT,                             
                      :WS-CUST-TITLE-SUFFIX-1                           
                 FROM CSS_NAME_ACCT_XREF HT,                            
                      CSS_NAME DQ                                       
                WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                 
                  AND HT.NAME_ID      = DQ.NAME_ID                      
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE    = 'CN'                            
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.FIRST_NAME,                                            
MFA-TR*               DQ.MIDDLE_NAME,                                           
MFA-TR*               DQ.LAST_NAME,                                             
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_FORMAT,                                           
MFA-TR*               DQ.TITLE_SUFFIX_1                                         
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                                      
MFA-TR*               :WS-CUST-MIDDLE-NAME,                                     
MFA-TR*               :WS-CUST-LAST-NAME,                                       
MFA-TR*               :WS-CUST-FULL-NAME,                                       
MFA-TR*               :WS-CUST-NAME-FORMAT,                                     
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                                   
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                         
MFA-TR*           AND HT.NAME_ID      = DQ.NAME_ID                              
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND DQ.NAME_TYPE    = 'CN'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA -7971 ,SELECT CSS_NAME'                       
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7971'                 TO ACTIVE-PARAGRAPH          
               MOVE 'SELECT'               TO ABEND-FUNCTION            
               MOVE 'CSS_NAME'             TO TABLE-1                   
               MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
               MOVE 'CUSTOMER-NO'          TO TABLE-ELEMENT-1           
               MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
               MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7971-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04143_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04143_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04143_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
            EXEC SQL                                                    
                 INSERT INTO #CSR04143_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,ERROR_DESC                                        
                     ,ADDRESS                                           
                     ,CITY                                              
                     ,NAME                                              
                     ,NAME_TYPE                                         
                     ,ACCT_TYPE                                         
                     ,SERVICE_SUPPLIED                                  
                     ,SUBDIVISION                                       
                     ,STATUS                                            
                     ,ACCOUNT_NO                                        
                     ,SERVICE_AVAIL                                     
                     ,CUSTOMER_NO                                       
                     ,LOCAL_OFFICE                                      
                     ,PREMISE_NO                                        
                     ,NAME_FORMAT                                       
                     ,CODE_ACCT_STAT                                    
                     ,ELEC_RATE                                         
                     ,GAS_RATE                                          
                     ,UNMETER_RATE                                      
                     ,ZIP_CODE                                          
                     ,ZIP_CODE_TOKEN                                    
                     ,COMPANY_NO                                        
                     ,CUST_NAME                                         
                     ,ACCT_TYPE_DESC                                    
                     ,REV_DISTRICT                                      
                     ,READ_CYCLE                                        
                     ,READ_ROUTE                                        
                     ,STREET_LOCATION_1                                 
                     ,STREET_LOCATION_2                                 
                     ,SELECT_FLAG                                       
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-ERROR-DESC                                     
                     ,:S-ADDRESS                                        
                     ,:S-CITY                                           
                     ,:S-NAME                                           
                     ,:S-NAME-TYPE                                      
                     ,:S-ACCT-TYPE                                      
                     ,:S-SERVICE-SUPPLIED                               
                     ,:S-SUBDIVISION                                    
                     ,:S-STATUS                                         
                     ,:S-ACCOUNT-NO                                     
                     ,:S-SERVICE-AVAIL                                  
                     ,:S-CUSTOMER-NO                                    
                     ,:S-LOCAL-OFFICE                                   
                     ,:S-PREMISE-NO                                     
                     ,:S-NAME-FORMAT                                    
                     ,:S-CODE-ACCT-STAT                                 
                     ,:S-ELEC-RATE                                      
                     ,:S-GAS-RATE                                       
                     ,:S-UNMETER-RATE                                   
                     ,:S-ZIP-CODE                                       
                     ,:S-ZIP-CODE-TOKEN                                 
                     ,:S-COMPANY-NO                                     
                     ,:S-CUST-NAME                                      
                     ,:S-ACCT-TYPE-DESC                                 
                     ,:S-REV-DISTRICT                                   
                     ,:S-READ-CYCLE                                     
                     ,:S-READ-ROUTE                                     
                     ,:S-STREET-LOCATION-1                              
                     ,:S-STREET-LOCATION-2                              
                     ,:S-SELECT-FLAG                                    
                 )                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04143_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,ERROR_DESC                                                
MFA-TR*              ,ADDRESS                                                   
MFA-TR*              ,CITY                                                      
MFA-TR*              ,NAME                                                      
MFA-TR*              ,NAME_TYPE                                                 
MFA-TR*              ,ACCT_TYPE                                                 
MFA-TR*              ,SERVICE_SUPPLIED                                          
MFA-TR*              ,SUBDIVISION                                               
MFA-TR*              ,STATUS                                                    
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,SERVICE_AVAIL                                             
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,NAME_FORMAT                                               
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,ELEC_RATE                                                 
MFA-TR*              ,GAS_RATE                                                  
MFA-TR*              ,UNMETER_RATE                                              
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,ZIP_CODE_TOKEN                                            
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CUST_NAME                                                 
MFA-TR*              ,ACCT_TYPE_DESC                                            
MFA-TR*              ,REV_DISTRICT                                              
MFA-TR*              ,READ_CYCLE                                                
MFA-TR*              ,READ_ROUTE                                                
MFA-TR*              ,STREET_LOCATION_1                                         
MFA-TR*              ,STREET_LOCATION_2                                         
MFA-TR*              ,SELECT_FLAG                                               
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-ERROR-DESC                                             
MFA-TR*              ,:S-ADDRESS                                                
MFA-TR*              ,:S-CITY                                                   
MFA-TR*              ,:S-NAME                                                   
MFA-TR*              ,:S-NAME-TYPE                                              
MFA-TR*              ,:S-ACCT-TYPE                                              
MFA-TR*              ,:S-SERVICE-SUPPLIED                                       
MFA-TR*              ,:S-SUBDIVISION                                            
MFA-TR*              ,:S-STATUS                                                 
MFA-TR*              ,:S-ACCOUNT-NO                                             
MFA-TR*              ,:S-SERVICE-AVAIL                                          
MFA-TR*              ,:S-CUSTOMER-NO                                            
MFA-TR*              ,:S-LOCAL-OFFICE                                           
MFA-TR*              ,:S-PREMISE-NO                                             
MFA-TR*              ,:S-NAME-FORMAT                                            
MFA-TR*              ,:S-CODE-ACCT-STAT                                         
MFA-TR*              ,:S-ELEC-RATE                                              
MFA-TR*              ,:S-GAS-RATE                                               
MFA-TR*              ,:S-UNMETER-RATE                                           
MFA-TR*              ,:S-ZIP-CODE                                               
MFA-TR*              ,:S-ZIP-CODE-TOKEN                                         
MFA-TR*              ,:S-COMPANY-NO                                             
MFA-TR*              ,:S-CUST-NAME                                              
MFA-TR*              ,:S-ACCT-TYPE-DESC                                         
MFA-TR*              ,:S-REV-DISTRICT                                           
MFA-TR*              ,:S-READ-CYCLE                                             
MFA-TR*              ,:S-READ-ROUTE                                             
MFA-TR*              ,:S-STREET-LOCATION-1                                      
MFA-TR*              ,:S-STREET-LOCATION-2                                      
MFA-TR*              ,:S-SELECT-FLAG                                            
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04143_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
