       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04142.                                         
COB303 DATE-WRITTEN.  AUGUST 29,2008.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000100
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *  PROGRAM:       CSR04142                                       *00130000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM UPDATES  GIS-POINT-ID IN                         *00190000
      *  CSS_MTRD_ENVRNMT FOR SELECTED ACCOUNTS.                       *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
C33743*  08/29/2008 SC41135   PROCEDURE ORIGINALLY CODED.              *00280000
APL839*  03/25/2009 SC41135   UPDATE GIS_POINT_ID IN CSS_ACCT_WHT_CROSS*        
      ******************************************************************00350000
      *                                                                *00360000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00370000
      *                                                                *00380000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00390000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00400000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00410000
      *  3000 - 4999  LOAD THE PARAMETERS INTO VARIABLES               *00420000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      *                                                                *00480000
      ******************************************************************00490000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04142'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04142 STARTS HERE'.                  
                                                                        
      ******************************************************************00580000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00590000
      ******************************************************************00600000
                                                                        
           COPY CWS00027.                                               00650000
           COPY CWS00303.                                               00660000
                                                                        
      ******************************************************************00680000
      *    WORK AREAS                                                  *00690000
      ******************************************************************00700000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04142'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-TRANS-HIST-SEQ-NO     PIC X(26) VALUE SPACES.         
           05  WS-TRAN-APPL-NO          PIC S9(4) COMP VALUE 0.         
           05  WS-DATE-TRANS            PIC X(10) VALUE SPACES.         
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-PRV-COL-VALUE         PIC X(75) VALUE SPACES.         
           05  WS-CHG-COL-VALUE         PIC X(75) VALUE SPACES.         
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO          PIC X(13)   VALUE SPACES.       
           05  PARM-USER-ID             PIC  X(07)  VALUE SPACES.       
           05  PARM-OLD-POINT-ID        PIC  X(10)  VALUE SPACES.       
           05  PARM-NEW-POINT-ID        PIC  X(10) VALUE SPACES.        
           05  PARM-NEW-GIS-PID         PIC  X(10) VALUE SPACES.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  PREV-VALUES.                                                 
           05  WS-ACCOUNT-NO             PIC X(13)                      
                                         JUSTIFIED RIGHT.               
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO         
                                        PIC 9(13).                      
           05  WS-OLD-POINT-ID          PIC  X(10).                     
           05  WS-OLD-GIS-PID           PIC  X(10).                     
                                                                        
       01  CURR-VALUES.                                                 
           05  WS-NEW-POINT-ID          PIC  X(10).                     
           05  WS-NEW-GIS-PID           PIC  X(10).                     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
                                                                        
           EXEC SQL                                                     01600000
              INCLUDE SQLCA                                             01610000
           END-EXEC.                                                    01620000
                                                                        
           EXEC SQL                                                     01640000
              INCLUDE TBMODEL                                           01650000
           END-EXEC.                                                    01660000
                                                                        
           EXEC SQL                                                     01680000
              INCLUDE TBMTRENV                                          01690000
           END-EXEC.                                                    01700000
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE TBMNHIST                                          01730000
           END-EXEC.                                                    01740000
                                                                        
           EXEC SQL                                                     01760000
              INCLUDE TBMNHDT                                           01770000
           END-EXEC.                                                    01780000
                                                                        
APL839     EXEC SQL                                                             
APL839        INCLUDE TBWCACCT                                                  
APL839     END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                            01880000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-USER-ID             PIC  X(07) .                        
       01  LINK-ACCOUNT-NO          PIC  X(13)               .          
       01  LINK-OLD-POINT-ID        PIC  X(10)               .          
       01  LINK-NEW-POINT-ID        PIC  X(10) .                        
       01  LINK-NEW-GIS-PID         PIC  X(10).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                 LINK-USER-ID                                           
               , LINK-ACCOUNT-NO                                        
               , LINK-OLD-POINT-ID                                      
               , LINK-NEW-POINT-ID                                      
               , LINK-NEW-GIS-PID                                       
               .                                                        
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
      *PROCEDURE DIVISION.                                              01890000
                                                                        
      ******************************************************************01910000
      * 0000-MAINLINE                                                  *01920000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01930000
      ******************************************************************01940000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 3000-LOAD-PARMS          THRU 3000-EXIT.             
           PERFORM 4000-GET-CURRENT-DATA    THRU 4000-EXIT.             
           PERFORM 5000-JRNL-UPDATE         THRU 5000-EXIT.             
             PERFORM 5500-UPDATE-POINT-ID      THRU 5500-EXIT.          
                                                                        
           PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140000
      * 0100-INITIALIZE                                                *02150000
      ******************************************************************02210000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE               AS    RETURN_CODE            
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE               AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           MOVE LINK-USER-ID       TO PARM-USER-ID             .        
           MOVE LINK-ACCOUNT-NO    TO PARM-ACCOUNT-NO          .        
           MOVE LINK-OLD-POINT-ID  TO PARM-OLD-POINT-ID        .        
           MOVE LINK-NEW-POINT-ID  TO PARM-NEW-POINT-ID        .        
           MOVE LINK-NEW-GIS-PID   TO PARM-NEW-GIS-PID         .        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04490000
      *  3000-LOAD-PARMS.                                              *04500000
      *                                                                *04510000
      *     LOAD PARAMETERS INTO TABLE VARIABLES.                      *04520000
      *                                                                *04530000
      ******************************************************************04540000
                                                                        
       3000-LOAD-PARMS.                                                 
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE PARM-OLD-POINT-ID         TO WS-OLD-POINT-ID.           
           MOVE PARM-NEW-POINT-ID         TO WS-NEW-POINT-ID.           
           MOVE PARM-NEW-GIS-PID          TO WS-NEW-GIS-PID.            
           MOVE WS-ACCOUNT-NO-NUM         TO MN-ACCOUNT-NO.             
           MOVE WS-NEW-POINT-ID           TO MN-POINT-ID.               
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      *   4000-GET-CURRENT-DATA                                                 
      *                                                                         
      *   GET THE FIELDS BEFORE THEY ARE UPDATED.                               
      *                                                                         
      *****************************************************************         
                                                                        
       4000-GET-CURRENT-DATA.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CIS.STRIP3(CIS.INT2CHAR(
           MN.GIS_POINT_ID),'L','0')                
                 INTO :WS-OLD-GIS-PID                                   
              FROM CSS_MTRD_ENVRNMT MN, CSS_PIM_POINT PP                
              WHERE MN.ACCOUNT_NO = :MN-ACCOUNT-NO                      
               AND MN.GIS_POINT_ID    = PP.POINT_ID                     
               AND (PP.AREA_ID + PP.TAG_NM) = :WS-OLD-POINT-ID         
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STRIP(CHAR(MN.GIS_POINT_ID),L,'0')                        
MFA-TR*          INTO :WS-OLD-GIS-PID                                           
MFA-TR*       FROM CSS_MTRD_ENVRNMT MN, CSS_PIM_POINT PP                        
MFA-TR*       WHERE MN.ACCOUNT_NO = :MN-ACCOUNT-NO                              
MFA-TR*        AND MN.GIS_POINT_ID    = PP.POINT_ID                             
MFA-TR*        AND (PP.AREA_ID || PP.TAG_NM) = :WS-OLD-POINT-ID                 
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'POINT_ID'            TO TABLE-ELEMENT-2             
              MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE MN-POINT-ID           TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
           EXEC SQL                                                     05360000
             INCLUDE CPD00067                                           05370000
           END-EXEC.                                                    05380000
                                                                        
      ******************************************************************05400000
      *                                                                *05410000
      *   5000-JRNL-UPDATE                                             *05420000
      *                                                                *05430000
      *   WRITE OUT A TRANSACTION HISTORY IF THIS IS AN UPDATE         *05440000
      *   INSTEAD OF AN INSERT.                                        *05450000
      *                                                                *05460000
      ******************************************************************05470000
                                                                        
       5000-JRNL-UPDATE.                                                
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 5100-JRNL-HEADER   THRU 5100-EXIT.                   
           PERFORM 5300-JRNL-DETAILS  THRU 5300-EXIT.                   
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05560000
      *                                                                *05570000
      *   5100-JRNL-HEADER                                             *05580000
      *                                                                *05590000
      *   WRITE OUT A TRANSACTION HISTORY SUMMARY RECORD.              *05600000
      *                                                                *05610000
      ******************************************************************05620000
                                                                        
       5100-JRNL-HEADER.                                                
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7300-GET-CUR-TIMESTAMP   THRU 7300-EXIT.             
           PERFORM 7350-CHECK-TIMESTAMP     THRU 7350-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             PERFORM 7300-GET-CUR-TIMESTAMP   THRU 7300-EXIT            
             PERFORM 7350-CHECK-TIMESTAMP     THRU 7350-EXIT            
             IF WS-ACTIVE-RETURN-CODE = 0                               
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'TWO ATTEMPTS TO'    TO TABLE-1                     
               MOVE 'CALCULATE UNIQUE'   TO TABLE-ELEMENT-1             
               MOVE 'TIMESTAMP FAILED'   TO HOSTVAR-ELEMENT-1           
               MOVE -1                   TO WS-ACTIVE-RETURN-CODE       
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
               
MSQ016        GOBACK                                                 
             END-IF                                                     
           END-IF.                                                      
           PERFORM 7400-GET-CUR-DATE        THRU 7400-EXIT.             
           PERFORM 7500-GET-RESP-AREA-ID    THRU 7500-EXIT.             
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO    TO MH-TRANS-HIST-SEQ-NO.        
           MOVE WS-DATE-TRANS           TO MH-DATE-TRANS.               
           MOVE 'F'                     TO MH-CODE-TRAN-TYPE.           
           MOVE WS-RESP-AREA-ID         TO MH-RESP-AREA-ID.             
           MOVE MN-ACCOUNT-NO           TO MH-ACCOUNT-NO.               
           MOVE PARM-USER-ID            TO MH-USER-ID.                  
           MOVE 'PANEL791'              TO MH-APPL-PROGRAM-ID.          
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06000000
      *                                                                *06010000
      *   5300-JRNL-DETAILS                                            *06020000
      *                                                                *06030000
      *   WRITE OUT THE TRANSACTION HISTORY DETAILS.                   *06040000
      *                                                                *06050000
      ******************************************************************06060000
                                                                        
       5300-JRNL-DETAILS.                                               
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
                                                                        
           MOVE WS-OLD-POINT-ID       TO WS-PRV-COL-VALUE               
           MOVE WS-NEW-POINT-ID        TO WS-CHG-COL-VALUE              
           MOVE MN-ACCOUNT-NO          TO MH-ACCOUNT-NO                 
           MOVE ZEROES                 TO MH-PREMISE-NO                 
           MOVE ZEROES                 TO MH-CUSTOMER-NO                
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                           TO WS-TRAN-APPL-NO        
              MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO        
              MOVE 'POINT ID'                 TO MI-COLUMN-DESC         
              MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
           MOVE WS-OLD-GIS-PID            TO WS-PRV-COL-VALUE           
           MOVE WS-NEW-GIS-PID       TO WS-CHG-COL-VALUE                
           IF WS-PRV-COL-VALUE EQUAL WS-CHG-COL-VALUE                   
              NEXT SENTENCE                                             
           ELSE                                                         
              ADD 1                           TO WS-TRAN-APPL-NO        
              MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO        
              MOVE 'GIS POINT ID'             TO MI-COLUMN-DESC         
              MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-PRV-COL-VALUE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE WS-CHG-COL-VALUE      TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.          
                                                                        
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08950000
      *                                                                *08960000
      *   5500-UPDATE-POINT-ID                                          08970000
      *                                                                *08980000
      *   UPDATE ALL SELECTED ACCOUNTS WITH NEW TABLE.                 *08990000
      *                                                                *09000000
      ******************************************************************09010000
                                                                        
       5500-UPDATE-POINT-ID.                                            
           MOVE '5500' TO ACTIVE-PARAGRAPH.                             
           MOVE WS-TRANS-HIST-SEQ-NO  TO MN-LAST-UPDATE-TS              
      *    MOVE WS-NEW-POINT-ID   TO MN-POINT-ID                                
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_MTRD_ENVRNMT                                    
             SET                                                        
      *           POINT_ID = :MN-POINT-ID,                                      
                  GIS_POINT_ID = IIF(TRY_CAST(:WS-NEW-GIS-PID
               AS INT) IS NULL, CIS.INTEGER(:WS-NEW-GIS-PID), CAST(
                                                        :WS-NEW-GIS-PID
               AS INT)),              
                  LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(:MN-LAST-UPDATE-TS
              )                   
             WHERE                                                      
                 ACCOUNT_NO   =  :MN-ACCOUNT-NO                         
                 AND GIS_POINT_ID = IIF(TRY_CAST(:WS-OLD-GIS-PID
               AS INT) IS NULL, CIS.INTEGER(:WS-OLD-GIS-PID), CAST(
                                                        :WS-OLD-GIS-PID
               AS INT))            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09080000
MFA-TR*      UPDATE CSS_MTRD_ENVRNMT                                    09090000
MFA-TR*      SET                                                        09100000
MFA-TR*           POINT_ID = :MN-POINT-ID,                                      
MFA-TR*           GIS_POINT_ID = INTEGER(:WS-NEW-GIS-PID),              09110000
MFA-TR*           LAST_UPDATE_TS = :MN-LAST-UPDATE-TS                   09120000
MFA-TR*      WHERE                                                      09140000
MFA-TR*          ACCOUNT_NO   =  :MN-ACCOUNT-NO                         09150000
MFA-TR*          AND GIS_POINT_ID = INTEGER(:WS-OLD-GIS-PID)                    
MFA-TR*    END-EXEC.                                                    09220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
            PERFORM 5050-SELECT-WHT-CROSS  THRU 5050-EXIT               
            END-IF                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
            NEXT SENTENCE                                               
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE 'UPDATE'              TO ABEND-FUNCTION               
             MOVE SPACES                TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
             MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                      
CBSI         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1              
             MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
APL839******************************************************************09390000
APL839*                                                                *        
APL839*   5050-SELECT-WHT-CROSS                                                 
APL839*                                                                *        
APL839*   UPDATE CSS_ACCT_WHT_CROSS TABLE WITH NEW PID.                *        
APL839*                                                                *        
APL839******************************************************************        
                                                                        
       5050-SELECT-WHT-CROSS.                                           
           MOVE '5050' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
             SELECT TOP(1) ACCOUNT_NO                                          
              INTO :WH-ACCOUNT-NO                                       
              FROM CSS_ACCT_WHT_CROSS                                   
             WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                          
               AND GIS_POINT_ID = IIF(TRY_CAST(:WS-OLD-GIS-PID
               AS INT) IS NULL, CIS.INTEGER(:WS-OLD-GIS-PID), CAST(
                                                        :WS-OLD-GIS-PID
               AS INT))              
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ACCOUNT_NO                                                  
MFA-TR*       INTO :WH-ACCOUNT-NO                                               
MFA-TR*       FROM CSS_ACCT_WHT_CROSS                                           
MFA-TR*      WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                                  
MFA-TR*        AND GIS_POINT_ID = INTEGER(:WS-OLD-GIS-PID)                      
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             PERFORM 7050-UPDATE-WHT-CROSS  THRU 7050-EXIT              
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE 'SELECT'              TO ABEND-FUNCTION               
             MOVE SPACES                TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
             MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                      
             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1              
             MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
APL839******************************************************************        
APL839*                                                                *        
APL839*   7050-UPDATE-WHT-CROSS                                                 
APL839*                                                                *        
APL839*   UPDATE CSS_ACCT_WHT_CROSS TABLE WITH NEW PID.                *        
APL839*                                                                *        
APL839******************************************************************        
                                                                        
       7050-UPDATE-WHT-CROSS.                                           
           MOVE '7050' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
             UPDATE CSS_ACCT_WHT_CROSS                                  
                SET GIS_POINT_ID = IIF(TRY_CAST(:WS-NEW-GIS-PID
               AS INT) IS NULL, CIS.INTEGER(:WS-NEW-GIS-PID), CAST(
                                                        :WS-NEW-GIS-PID
               AS INT))             
               WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_ACCT_WHT_CROSS                                          
MFA-TR*         SET GIS_POINT_ID = INTEGER(:WS-NEW-GIS-PID)                     
MFA-TR*        WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
             MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
             MOVE 'UPDATE'              TO ABEND-FUNCTION               
             MOVE SPACES                TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
             MOVE 'CSS_ACCT_WHT_CROSS'  TO TABLE-1                      
             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1              
             MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1            
             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT              
             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.             
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09400000
      *                                                                *09410000
      *   7300-GET-CUR-TIMESTAMP                                       *09420000
      *                                                                *09430000
      *   GET THE CURRENT TIMESTAMP TO USE AS A UNIQUE KEY FOR THE     *09440000
      *   TRANSACTION HISTORY.                                         *09450000
      *                                                                *09460000
      ******************************************************************09470000
                                                                        
       7300-GET-CUR-TIMESTAMP.                                          
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
             INTO :WS-TRANS-HIST-SEQ-NO                                 
             FROM CSS_MODEL_SQL                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09510000
MFA-TR*      SELECT CURRENT TIMESTAMP                                   09520000
MFA-TR*      INTO :WS-TRANS-HIST-SEQ-NO                                 09530000
MFA-TR*      FROM CSS_MODEL_SQL                                         09540000
MFA-TR*    END-EXEC.                                                    09550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09730000
      *                                                                *09740000
      *   7350-CHECK-TIMESTAMP                                         *09750000
      *                                                                *09760000
      *   CHECK TO SEE IF THE TIMESTAMP IS ALREADY USED AS A KEY IN    *09770000
      *   TRANSACTION HISTORY TABLE.                                   *09780000
      *                                                                *09790000
      ******************************************************************09800000
                                                                        
       7350-CHECK-TIMESTAMP.                                            
           MOVE '7350' TO ACTIVE-PARAGRAPH                              
           EXEC SQL                                                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
               INTO :MH-TRANS-HIST-SEQ-NO                               
             FROM CSS_MNT_TRANS_HIST                                    
             WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :WS-TRANS-HIST-SEQ-NO
              )            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09840000
MFA-TR*      SELECT TRANS_HIST_SEQ_NO                                   09850000
MFA-TR*        INTO :MH-TRANS-HIST-SEQ-NO                               09860000
MFA-TR*      FROM CSS_MNT_TRANS_HIST                                    09870000
MFA-TR*      WHERE TRANS_HIST_SEQ_NO = :WS-TRANS-HIST-SEQ-NO            09880000
MFA-TR*    END-EXEC.                                                    09890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MNT_TRANS_HIST'  TO TABLE-1                     
              MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE WS-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10100000
      *                                                                *10110000
      *   7400-GET-CUR-DATE                                            *10120000
      *                                                                *10130000
      *   GET THE CURRENT DATE SO IT CAN BE USED TO WRITE A DATE       *10140000
      *   IN THE TRANSACTION HISTORY TABLE.                            *10150000
      *                                                                *10160000
      ******************************************************************10170000
                                                                        
       7400-GET-CUR-DATE.                                               
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
             SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                           
             INTO :WS-DATE-TRANS                                        
             FROM CSS_MODEL_SQL                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10210000
MFA-TR*      SELECT CURRENT DATE                                        10220000
MFA-TR*      INTO :WS-DATE-TRANS                                        10230000
MFA-TR*      FROM CSS_MODEL_SQL                                         10240000
MFA-TR*    END-EXEC.                                                    10250000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10430000
      *                                                                *10440000
      *   7500-GET-RESP-AREA-ID                                        *10450000
      *                                                                *10460000
      *   GET THE RESPONSIBILTY AREA OF THE USER TO WRITE INTO THE     *10470000
      *   TRANSACTION HISTORY TABLE.                                   *10480000
      *                                                                *10490000
      ******************************************************************10500000
                                                                        
       7500-GET-RESP-AREA-ID.                                           
           MOVE '7500' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
             SELECT RESP_AREA_ID                                        
             INTO :WS-RESP-AREA-ID                                      
             FROM CSS_USER_PROFILE                                      
             WHERE USER_ID = :PARM-USER-ID                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7500-EXIT.                                                       
           EXIT.                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
      ******************************************************************10810000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *10820000
      ******************************************************************10830000
           EXEC SQL                                                     10840000
              INCLUDE CPDSP300                                          10850000
           END-EXEC.                                                    10860000
                                                                        
      ******************************************************************10880000
      *       END PROGRAM COPYLIB                                      *10890000
      ******************************************************************10900000
                                                                        
