       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04141.                                            
       DATE-WRITTEN. 05/09/08.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE REVERSES A SERVICE ORDER.                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/09/08    PD       PROCEDURE ORIGINALLY CODED.              *        
PR104 *  09/21/09    PK       UPDATE INSTALL_PREM_FL WHEN A SERVICE    *        
      *                       IS REVERSED.                             *        
      *  12/11/09    MA       DELETE SERVICE FROM CSS_GAS_SERV_MATL    *        
      *                       WHEN A SERVICE IS REVERSED.              *        
      *                       8971-DELETE-GAS-SERV-MATL                *        
PR104 *  12/30/09    MA       CODE CHANGE FOR DUMMY SO CREATION        *        
      *  12/30/09    MA       THROUGH CSR00061                                  
P0104 *  02/18/10    PK       CONTRACT APPROVAL - TO DELETE SERV AGREE *        
      *                       AMT, AGREE DT & STATUS ON REVERSING A SVC*        
      *  03/10/10    MA       ADDED INSTALL_TYPE_CD AS 'V' IN          *        
      *                       CSS_GASLINE_SO_XRF TABLE FOR REVERSE SVC *        
A03772*  11/02/11    PK98692  ADDED FILTER ON THE ORDER TYPE IN THE    *        
      *                       TABLE CSS_LINE_WORK_TYPE AS THE TABLE NOW*        
      *                       HAS FW007 ORDERS TYPES.                  *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
P00718*  02/20/14    VV90387  ADDITIONAL PARM FOR BUSINESS UNIT        *        
P00718*  04/02/14    VV90387  ADDITIONAL PARM FOR OPTIMIZE ORDER       *        
ACT193*  06/15/16   SS7F226   CHANGED THE WS-Y VARIABLE TO WS-YES TO   *        
ACT193*              A05460   AVOID DUPLICATE DECLARATION IN COPYBOOK  *        
ACT193*                       AND REMOVED UNUSED MODULES AND CODE.     *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ002  01 MFA-CSR00061.
MSQ002    05 ARG-10 PIC X(7).
MSQ002    05 ARG-11 PIC X(10).
MSQ002    05 ARG-30 PIC X(7).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04141'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    YV - HST_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VI - CSS_SO_ORDER_INST                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    ZG - HST_SO_ORDER_INST                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    TE - CSS_SO_CREW                                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOCREW                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    WU - CSS_SO_MATL_TRAN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBWMSTRN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WE - HST_SO_MATL_TRAN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTTRN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    EF - CSS_SO_REMARKS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    OE - HST_SO_REMARKS                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTREM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    EG - CSS_SO_REQUIREMENT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOREQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    OF - HST_SO_REQUIREMENT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTREQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VW - CSS_SO_UPDATE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    OK - HST_SO_UPDATE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTUPD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VG - CSS_SO_CHARGES                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSOCHR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    VG - HST_SO_CHARGES                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTCHR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    XX - CSS_GASLINE_SO_XRF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASSO                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    XO - CSS_GAS_SERV_LINE                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    XV - CSS_LINE_WORK_TYPE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLINEWK                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    PR - CSS_PREMISE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    Y0 - CSS_PREM_GAS_LINE                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    CH - CSS_CUST_PREM_HIST                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR04141'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      *01  LOC1                            USAGE IS SQL TYPE IS         
      *                                    RESULT-SET-LOCATOR VARYING.  
      *01  LOC2                            USAGE IS SQL TYPE IS         
      *                                    RESULT-SET-LOCATOR VARYING.  
                                                                        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-ID1                     PIC S9(9) COMP VALUE 1.     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
PR104  01  WS-TIME-STP                      PIC X(26).                  
PR104  01  WS-TIME-STP-D   REDEFINES WS-TIME-STP.                       
PR104     05 WS-STP-DATE                    PIC X(10).                  
PR104     05 WS-STP-HOUR                    PIC X(16).                  
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE               PIC S9(9) COMP.              
           05 S-RETURN-CODE                PIC S9(9) COMP.              
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-HST-FLAG                  PIC X(1) VALUE SPACES.      
ACT193     05  WS-YES                       PIC X(1) VALUE SPACES.      
           05  WS-YY                        PIC X(1) VALUE SPACES.      
           05  WS-ADDRESS                   PIC X(60) VALUE SPACES.     
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04141'. 
COB305     05 WS-NEW-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.         
PR104      05  WS-ORD-TYPE                  PIC X(5) VALUE SPACES.      
PR104      05  WS-WRK-TYPE                  PIC X(3) VALUE SPACES.      
PR104      05  WS-COMPANY-NO                PIC X(2) VALUE SPACES.      
PR104      05  WS-LOCAL-OFF                 PIC X(3) VALUE SPACES.      
PR104      05  WS-ZIP-CODE                  PIC X(5) VALUE SPACES.      
PR104      05  WS-PREMISE-NO                PIC X(10).                  
PR104      05  WS-PREMISE-NO-D REDEFINES WS-PREMISE-NO PIC 9(10).       
PR104      05  WS-ACCOUNT-NO                PIC X(13).                  
PR104      05  WS-ACCOUNT-NO-D REDEFINES WS-ACCOUNT-NO PIC 9(13).       
PR104      05  WS-RTN                       PIC S9(9) COMP.             
PR104      05  WS-WORK-AREA                 PIC X(12) VALUE SPACES.     
P00718     05  WS-BUSINESS-UNIT             PIC X(03) VALUE SPACES.     
COB305     05 WS-NEW-SO        PIC S9(13)V USAGE COMP-3 VALUE 0.
MSQ001        EXEC SQL
MSQ001          DECLARE C3 CURSOR
MSQ001          FOR CALL CSR01116                                       
                        ( :WS-LOCAL-OFF
                  , 'G'
                  , :WS-WRK-TYPE
                  , 'N'
                  , 'N'
                  , :WS-ZIP-CODE
                  , '0'
                  , ''
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR00061                                       
                        ( :WS-PREMISE-NO
                  , :WS-ACCOUNT-NO
                  , '0'
                  , '0'
                  , :WS-ORD-TYPE
                  , :WS-LOCAL-OFF
                  , ''
                  , ''
                  , ''
                  , :MFA-CSR00061.ARG-10
                  , :MFA-CSR00061.ARG-11
                  , :WS-TIME-STP
                  , ''
                  , 'N'
                  , ''
                  , ''
                  , ''
                  , ''
                  , ''
                  , 0
                  , ''
                  , :WS-WORK-AREA
                  , 7
                  , 'A'
                  , :WS-WRK-TYPE
                  , 'G'
                  , 0
                  , ''
                  , '524'
                  , :MFA-CSR00061.ARG-30
                  , 0.5
                  , ''
                  , 'N'
                  , :WS-COMPANY-NO
                  , ''
                  , 'A'
                  , ''
                  , 0
                  , 0
                  , ''
                  , ''
                  , ''
                  , :WS-BUSINESS-UNIT
                  , ' '
                  )
MSQ001        END-EXEC.
   
       LINKAGE SECTION.                                                 
COB305 01 PARM-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
COB305 01 PARM-SERVICE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
       01       PARM-COMMENT-TEXT       PIC X(255).                     
       01       PARM-COMMENT-LEN        PIC S9(4) USAGE COMP.           
                                                                        
       PROCEDURE DIVISION USING PARM-SERV-ORDER-NO                      
                                PARM-SERVICE-NO                         
                                PARM-COMMENT-TEXT                       
                                PARM-COMMENT-LEN.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
                                                                        
               EXEC SQL                                                 
                   DECLARE C1 CURSOR  FOR                    
                   SELECT                                               
                     :S-RETURN-CODE     AS     RETURN_CODE              
                   FROM CIS.SYSDUMMY1                                
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*              :S-RETURN-CODE     AS     RETURN_CODE                      
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*        END-EXEC.                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04141_R1'           
                                          TO S-SQL-STATEMENT-V.         
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *     2. SPLIT OUT PARM STRING INFORMATION                       *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-SERV-ORDER-NO         TO VO-SERV-ORDER-NO          
                                              YV-SERV-ORDER-NO          
                                              VI-SERV-ORDER-NO          
                                              ZG-SERV-ORDER-NO          
                                              TE-SERV-ORDER-NO          
                                              WU-SERV-ORDER-NO          
                                              WE-SERV-ORDER-NO          
                                              EF-SERV-ORDER-NO          
                                              OE-SERV-ORDER-NO          
                                              EG-SERV-ORDER-NO          
                                              OE-SERV-ORDER-NO          
                                              EG-SERV-ORDER-NO          
                                              OF-SERV-ORDER-NO          
                                              VW-SERV-ORDER-NO          
                                              OK-SERV-ORDER-NO          
                                              VG-SERV-ORDER-NO          
                                              YQ-SERV-ORDER-NO          
                                              XX-SERV-ORDER-NO.         
           MOVE PARM-SERVICE-NO            TO XX-SERVICE-NO             
                                              XO-SERVICE-NO.            
                                                                        
           EXEC SQL                                                     
               SELECT
              NEXT VALUE FOR SEQ_VO_SERV_ORDER_NO
            INTO
              :WS-NEW-SERV-ORDER-NO                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-NEW-SERV-ORDER-NO =                                      
MFA-TR*            NEXT VALUE FOR SEQ_VO_SERV_ORDER_NO                          
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-SO-DATA            THRU 7000-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7100-SELECT-HST-DATA        THRU 7100-EXIT        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  PERFORM 7050-CHECK-SERV         THRU 7050-EXIT        
                  IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
                     MOVE    5000                 TO RS-RETURN-CODE     
                     PERFORM 8100-SEND-RESULT     THRU 8100-EXIT        
                     PERFORM 9999-END-PROGRAM     THRU 9999-EXIT        
                  ELSE                                                  
                     MOVE 'P' TO WS-HST-FLAG                            
                  END-IF                                                
              ELSE                                                      
                 MOVE 'Y' TO WS-HST-FLAG                                
              END-IF                                                    
           ELSE                                                         
              MOVE 'N'    TO WS-HST-FLAG                                
           END-IF                                                       
           IF WS-HST-FLAG = 'N'                                         
              PERFORM 8200-INSERT-SO-DATA    THRU 8200-EXIT             
              PERFORM 8300-INSERT-SO-INST    THRU 8300-EXIT             
              PERFORM 8400-INSERT-SO-CREW    THRU 8400-EXIT             
              PERFORM 8500-INSERT-SO-MATL    THRU 8500-EXIT             
              PERFORM 8700-INSERT-SO-REQM    THRU 8700-EXIT             
              PERFORM 8760-INSERT-SO-CHGS    THRU 8760-EXIT             
           ELSE IF WS-HST-FLAG = 'Y'                                    
              PERFORM 8250-INSERT-HST-DATA   THRU 8250-EXIT             
              PERFORM 8350-INSERT-HST-INST   THRU 8350-EXIT             
              PERFORM 8400-INSERT-SO-CREW    THRU 8400-EXIT             
              PERFORM 8550-INSERT-HST-MATL   THRU 8550-EXIT             
              PERFORM 8750-INSERT-HST-REQM   THRU 8750-EXIT             
              PERFORM 8770-INSERT-HST-CHGS   THRU 8770-EXIT             
           ELSE IF WS-HST-FLAG = 'P'                                    
PR104         PERFORM 7030-GET-COMP-PRM    THRU 7030-EXIT               
PR104         MOVE    PR-PREMISE-NO    TO   WS-PREMISE-NO               
PR104         PERFORM 7010-GET-ORD-TYPE    THRU 7010-EXIT               
PR104         PERFORM 7020-GET-WRK-AREA    THRU 7020-EXIT               
PR104         PERFORM 7060-GET-ACCOUNT     THRU 7060-EXIT               
              MOVE    CH-ACCOUNT-NO    TO   WS-ACCOUNT-NO               
PR104         PERFORM 7070-GET-TMSTAMP     THRU 7070-EXIT               
PR104         PERFORM 8040-CALL-CSR00061   THRU 8040-EXIT               
PR104         MOVE    VO-SERV-ORDER-NO TO   WS-NEW-SO                   
PR104         PERFORM 8211-UPD-GS-SO-DATA  THRU 8211-EXIT               
PR104         PERFORM 8511-INSERT-GAS-MATL THRU 8511-EXIT               
PR104         PERFORM 8611-UPD-SOORD-INST  THRU 8611-EXIT               
PR104         PERFORM 8070-UPDATE-SO-REQM  THRU 8070-EXIT               
PR104         PERFORM 8060-INSERT-SO-CREW  THRU 8060-EXIT               
           END-IF
                END-IF
           END-IF.                                                      
           MOVE 'A'               TO EF-REMARK-TYPE-CD                  
           MOVE 'REVERSING MATL AND ACCTG' TO EF-REMARK-TX-TEXT         
           MOVE 24                TO EF-REMARK-TX-LEN                   
PR104      IF WS-HST-FLAG = 'P'                                         
PR104         MOVE WS-NEW-SO      TO WS-NEW-SERV-ORDER-NO               
PR104      END-IF.                                                      
           PERFORM 8600-INSERT-SO-REMK    THRU 8600-EXIT                
           MOVE 'G'               TO EF-REMARK-TYPE-CD                  
           MOVE PARM-COMMENT-TEXT TO EF-REMARK-TX-TEXT                  
           MOVE PARM-COMMENT-LEN  TO EF-REMARK-TX-LEN                   
PR104      IF WS-HST-FLAG = 'P'                                         
PR104         MOVE WS-NEW-SO      TO WS-NEW-SERV-ORDER-NO               
PR104      END-IF.                                                      
           PERFORM 8600-INSERT-SO-REMK    THRU 8600-EXIT                
           MOVE 'A'               TO VW-ORDER-STATE-CD                  
PR104      IF WS-HST-FLAG = 'P'                                         
PR104         MOVE WS-ORD-TYPE    TO VW-ORDER-TYPE-CD                   
PR104         MOVE WS-NEW-SO      TO WS-NEW-SERV-ORDER-NO               
           ELSE                                                         
              MOVE 'FW024'        TO VW-ORDER-TYPE-CD                   
           END-IF.                                                      
           MOVE '523'             TO VW-PANEL-NO                        
           MOVE '10'              TO VW-SERV-ORDER-STATUS               
           PERFORM 8800-INSERT-SO-UPDT      THRU 8800-EXIT              
           MOVE 'A'               TO VW-ORDER-STATE-CD                  
                                                                        
           IF WS-HST-FLAG = 'P'                                         
              MOVE WS-ORD-TYPE    TO VW-ORDER-TYPE-CD                   
PR104         MOVE WS-NEW-SO      TO WS-NEW-SERV-ORDER-NO               
           ELSE                                                         
              MOVE 'FW024'        TO VW-ORDER-TYPE-CD                   
           END-IF.                                                      
                                                                        
           MOVE 'P698'            TO VW-PANEL-NO                        
           MOVE '40'              TO VW-SERV-ORDER-STATUS               
           PERFORM 8800-INSERT-SO-UPDT      THRU 8800-EXIT              
           MOVE 'A'               TO VW-ORDER-STATE-CD                  
           IF WS-HST-FLAG = 'P'                                         
PR104         MOVE WS-NEW-SO      TO WS-NEW-SERV-ORDER-NO               
              MOVE WS-ORD-TYPE    TO VW-ORDER-TYPE-CD                   
           ELSE                                                         
              MOVE 'FW024'        TO VW-ORDER-TYPE-CD                   
           END-IF.                                                      
           MOVE '090'             TO VW-PANEL-NO                        
           MOVE '60'              TO VW-SERV-ORDER-STATUS               
           PERFORM 8800-INSERT-SO-UPDT      THRU 8800-EXIT              
           IF WS-HST-FLAG = 'P'                                         
              MOVE WS-NEW-SO         TO   WS-NEW-SERV-ORDER-NO          
           END-IF.                                                      
           PERFORM 8950-INSERT-SO-XRF        THRU 8950-EXIT.            
           PERFORM 8960-UPDATE-GAS-SERV-LINE THRU 8960-EXIT.            
           PERFORM 8970-UPDATE-PREM-GAS-LINE THRU 8970-EXIT.            
           PERFORM 8971-DELETE-GAS-SERV-MATL THRU 8971-EXIT.            
           PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-SELECT-SO-DATA                                                     
      ******************************************************************        
                                                                        
       7000-SELECT-SO-DATA.                                             
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
ACT193           INTO :WS-YES                                           
                 FROM CSS_SO_DATA                                       
                 WHERE SERV_ORDER_NO      = :VO-SERV-ORDER-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7000'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_DATA'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7010-GET-ORD-TYPE                                                       
      ******************************************************************        
                                                                        
       7010-GET-ORD-TYPE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                     XV.WORK_TYPE_CD,                                   
                     XV.ORDER_TYPE_CD                                   
                INTO :WS-WRK-TYPE,                                      
                     :WS-ORD-TYPE                                       
                FROM CSS_LINE_WORK_TYPE XV,                             
                     CSS_GAS_SERV_LINE  XO                              
                WHERE XO.INSTALL_TYPE_CD = XV.INSTALL_TYPE_CD           
                  AND XO.SERV_LINE_SIZE  = XV.SERV_LINE_SIZE            
                  AND XO.SERV_LINE_TYPE  = XV.SERV_LINE_TYPE            
                  AND XO.SERVICE_NO      = :XO-SERVICE-NO               
                  AND XV.COMPANY_NO      = :WS-COMPANY-NO               
A03772            AND XV.ORDER_TYPE_CD   = 'FW024'                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7010'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_LINE_WORK_TYPE' TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE  XO-SERVICE-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *7020-GET-WORK-AREA                                                       
      ******************************************************************        
                                                                        
       7020-GET-WRK-AREA.                                               
                                                                        
      *    EXEC SQL CALL CSR01116                                       
      *                 (:WS-LOCAL-OFF,                                 
      *                  'G',                                           
      *                  :WS-WRK-TYPE,                                  
      *                  'N',                                           
      *                  'N',                                           
      *                  :WS-ZIP-CODE,                                  
      *                  '0',                                           
      *                  ''                                             
      *                  )                                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           IF SQLCODE = 466 THEN                                        
      *      EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE          
      *         CSR01116                                                
      *      END-EXEC                                                   
      *      EXEC SQL ALLOCATE C3 CURSOR FOR RESULT SET :LOC1           
      *      END-EXEC                                                   
             EXEC SQL                                                   
             FETCH C3 INTO                                              
                :WS-RTN,                                                
                :WS-WORK-AREA,                                          
P00718          :WS-BUSINESS-UNIT                                       
             END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           END-IF.                                                      
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7020'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSR01116'           TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE  XO-SERVICE-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7030-GET-COMP-PRM                                              *        
      ******************************************************************        
       7030-GET-COMP-PRM.                                               
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                 PR.COMPANY_NO,                                         
                 PR.PREMISE_NO,                                         
                 PR.LOCAL_OFFICE,                                       
                 DY.ZIP_CODE,                                           
                 XO.SVC_LINE_INSTALL_DT                                 
                INTO :WS-COMPANY-NO,                                    
                     :PR-PREMISE-NO,                                    
                     :WS-LOCAL-OFF,                                     
                     :WS-ZIP-CODE,                                      
                     :XO-SVC-LINE-INSTALL-DT                            
                FROM CSS_PREMISE PR,                                    
                     CSS_PREM_GAS_LINE Y0,                              
                     CSS_ADDR_FORMATTED DY,                             
                     CSS_GAS_SERV_LINE XO                               
                WHERE Y0.PREMISE_NO=PR.PREMISE_NO                       
                  AND PR.ADDRESS_ID=DY.ADDRESS_ID                       
                  AND Y0.SERVICE_NO=:XO-SERVICE-NO                      
                  AND Y0.INSTALL_PREM_FL='Y'                            
                  AND Y0.SERVICE_NO=XO.SERVICE_NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7030'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_PREMISE'        TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE  XO-SERVICE-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7050-CHECK-SERV                                               *         
      ******************************************************************        
                                                                        
       7050-CHECK-SERV.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT DISTINCT 'P'                                      
                 INTO :WS-YY                                            
                 FROM CSS_GAS_SERV_MATL                                 
                 WHERE SERVICE_NO = :XO-SERVICE-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7050'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_GAS_SERV_MATL'  TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XO-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7060-GET-ACCOUNT                                               *        
      ******************************************************************        
       7060-GET-ACCOUNT.                                                
           EXEC SQL                                                     
               SELECT COALESCE(MAX(ACCOUNT_NO),0)                       
                 INTO :CH-ACCOUNT-NO                                    
                 FROM  CSS_CUST_PREM_HIST A                             
                WHERE PREMISE_NO=:PR-PREMISE-NO                         
                  AND DATE_UTIL_SVC_STRT=                               
                     (SELECT MAX(DATE_UTIL_SVC_STRT)                    
                        FROM CSS_CUST_PREM_HIST B                       
                       WHERE A.PREMISE_NO=B.PREMISE_NO                  
                     AND B.DATE_UTIL_SVC_STRT<=IIF(TRY_CONVERT(DATE, 
                                                :XO-SVC-LINE-INSTALL-DT
              ) IS NULL OR (PATINDEX('%.%', :XO-SVC-LINE-INSTALL-DT
              ) <> 0) OR (LEN(:XO-SVC-LINE-INSTALL-DT
              ) <> 10), CIS.CHAR2DATE(:XO-SVC-LINE-INSTALL-DT
              ), CONVERT(DATE, :XO-SVC-LINE-INSTALL-DT) )) 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COALESCE(MAX(ACCOUNT_NO),0)                               
MFA-TR*          INTO :CH-ACCOUNT-NO                                            
MFA-TR*          FROM  CSS_CUST_PREM_HIST A                                     
MFA-TR*         WHERE PREMISE_NO=:PR-PREMISE-NO                                 
MFA-TR*           AND DATE_UTIL_SVC_STRT=                                       
MFA-TR*              (SELECT MAX(DATE_UTIL_SVC_STRT)                            
MFA-TR*                 FROM CSS_CUST_PREM_HIST B                               
MFA-TR*                WHERE A.PREMISE_NO=B.PREMISE_NO                          
MFA-TR*              AND B.DATE_UTIL_SVC_STRT<=:XO-SVC-LINE-INSTALL-DT)         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7060'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
               MOVE  PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7070-GET-TMSTAMP                                               *        
      ******************************************************************        
       7070-GET-TMSTAMP.                                                
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIME-STP                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          VALUES CURRENT TIMESTAMP                                       
MFA-TR*            INTO :WS-TIME-STP                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE '-00.00.00.000000' TO WS-STP-HOUR.                      
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7070'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_MODEL_SQL'      TO TABLE-1                     
               MOVE 'TIMESTAMP'          TO TABLE-ELEMENT-1             
               MOVE 'TIMESTAMP'       TO HOSTVAR-ELEMENT-1              
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7100-SELECT-HST-DATA.                                                   
      ******************************************************************        
                                                                        
       7100-SELECT-HST-DATA.                                            
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
ACT193           INTO :WS-YES                                           
                 FROM HST_SO_DATA                                       
                 WHERE SERV_ORDER_NO      = :YV-SERV-ORDER-NO           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7100'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'HST_SO_DATA'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE YV-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                                    
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8040-CALL-CSR00061                                             *        
      ******************************************************************        
                                                                        
       8040-CALL-CSR00061.                                              

MSQ002     EXEC SQL
MSQ002         SELECT CIS.SESSION$USER()
MSQ002              , CAST(SYSDATETIMEOFFSET() AS DATE)
MSQ002              , CIS.SESSION$USER()
MSQ002           INTO :MFA-CSR00061.ARG-10
MSQ002              , :MFA-CSR00061.ARG-11
MSQ002              , :MFA-CSR00061.ARG-30
MSQ002     END-EXEC
                                                                        
      *    EXEC SQL CALL CSR00061                                       
      *                 (:WS-PREMISE-NO,                                
      *                  :WS-ACCOUNT-NO,                                
      *                  '0',                                           
      *                  '0',                                           
      *                  :WS-ORD-TYPE,                                  
      *                  :WS-LOCAL-OFF,                                 
      *                  '',                                            
      *                  '',                                            
      *                  '',                                            
      *                  USER,                                          
      *                  CURRENT DATE,                                  
      *                  :WS-TIME-STP,                                  
      *                  '',                                            
      *                  'N',                                           
      *                  '',                                            
      *                  '',                                            
      *                  '',                                            
      *                  '',                                            
      *                  '',                                            
      *                  0,                                             
      *                  '',                                            
      *                  :WS-WORK-AREA,                                 
      *                  7,                                             
      *                  'A',                                           
      *                  :WS-WRK-TYPE,                                  
      *                  'G',                                           
      *                  0,                                             
      *                  '',                                            
      *                  '524',                                         
      *                  USER,                                          
      *                  0.5,                                           
      *                  '',                                            
      *                  'N',                                           
      *                  :WS-COMPANY-NO,                                
      *                  '',                                            
      *                  'A',                                           
      *                  '',                                            
      *                  0,                                             
      *                  0,                                             
      *                  '',                                            
      *                  '',                                            
      *                  '',                                            
      *                  :WS-BUSINESS-UNIT,                             
      *                  ' '                                            
      *                  )                                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C4
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C4
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C4 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
           IF SQLCODE = 466 THEN                                        
      *      EXEC SQL ASSOCIATE LOCATORS(:LOC2) WITH PROCEDURE          
      *         CSR00061                                                
      *      END-EXEC                                                   
      *      EXEC SQL ALLOCATE C4 CURSOR FOR RESULT SET :LOC2           
      *      END-EXEC                                                   
             EXEC SQL                                                   
                 FETCH C4 INTO                                          
                 :WS-RTN,                                               
                 :VO-SERV-ORDER-NO                                      
             END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
            END-IF.                                                     
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8040'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSR00061'           TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE  XO-SERVICE-NO       TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-SO-CREW.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CREW                                  
                          (SERV_ORDER_NO,                               
                           CREW_ID,                                     
                           WORK_SEQ_NM,                                 
                           WORK_DT,                                     
                           CREW_SCHED_DT,                               
                           CREW_COMPLETE_DT)                            
               VALUES (:WS-NEW-SO,                                      
                      '000FRO',                                         
                      1,                                                
                      CIS.CURRENT$TIMESTAMP(),                                
                      CIS.CURRENT$TIMESTAMP(),                                
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_CREW                                          
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    CREW_ID,                                             
MFA-TR*                    WORK_SEQ_NM,                                         
MFA-TR*                    WORK_DT,                                             
MFA-TR*                    CREW_SCHED_DT,                                       
MFA-TR*                    CREW_COMPLETE_DT)                                    
MFA-TR*        VALUES (:WS-NEW-SO,                                              
MFA-TR*               '000FRO',                                                 
MFA-TR*               1,                                                        
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8060'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_CREW'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8060-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8070-UPDATE-SO-REQM.                                             
           EXEC SQL                                                     
               UPDATE  CSS_SO_REQUIREMENT                               
                  SET  REQMNT_COMP_DT=CIS.CURRENT$TIMESTAMP(),                
                       REQMNT_STAGE_CD='C'                              
               WHERE   SERV_ORDER_NO=:WS-NEW-SO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE  CSS_SO_REQUIREMENT                                       
MFA-TR*           SET  REQMNT_COMP_DT=CURRENT TIMESTAMP,                        
MFA-TR*                REQMNT_STAGE_CD='C'                                      
MFA-TR*        WHERE   SERV_ORDER_NO=:WS-NEW-SO                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8070'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SO            TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8070-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                         
      *************************************************************             
       8100-SEND-RESULT.                                                
           ADD +1                    TO  CTR-ROWS.                      
       8100-EXIT.                                                       
            EXIT.                                                       
       8200-INSERT-SO-DATA.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_DATA                                  
                          (PREMISE_NO,                                  
                           ACCOUNT_NO,                                  
                           SERV_ORDER_NO,                               
                           ORDER_TYPE_CD,                               
                           COMPANY_NO,                                  
                           LOCAL_OFFICE,                                
                           SERV_ORDER_STATUS,                           
                           PHONE_NO_EXT,                                
                           PHONE_NO,                                    
                           ORDER_PLACED_BY,                             
                           ORDER_RECVED_BY,                             
                           WANTED_BY_DATETIME,                          
                           DATE_RECVED,                                 
                           USER_ID_CPTD_BY,                             
                           COMPLETED_DATETIME,                          
                           CODE_EDITED_YES_NO,                          
                           ORDER_REASON,                                
                           BACK_DATED_IND,                              
                           RESP_AREA_ID,                                
                           CALL_BEFORE_MINUTS,                          
                           NOTIFY_CUST_IND,                             
                           NOTIFY_CSR_IND,                              
                           BREAKERS_OFF_IND,                            
                           NUMBER_OF_VISITS,                            
                           ORD_ASSIGNED_TO,                             
                           ASSIGNED_DATETIME,                           
                           DEPOSIT_AMT,                                 
                           WORK_COMPLETED_IND,                          
                           CATHODIC_PROTECT,                            
                           INIT_BY_CNTRCT_IND,                          
                           DATE_PRINTED,                                
                           WORK_AREA_ID,                                
                           ORDER_PRIORITY_CD,                           
                           AMT_DNP_AT_BILLING,                          
                           ORDER_STATE_CD,                              
                           BEGIN_APPT_DT,                               
                           END_APPT_DT,                                 
                           APPT_AM_PM_CD,                               
                           SO_EST_LABOR_HR,                             
                           DATE_FORECAST_DNP,                           
                           ACCOUNT_NO_PRIOR,                            
                           CODES_DATA_PRESENT,                          
                           VERIFY_RATE,                                 
                           COMPLETED_BY,                                
                           COMPLETED_BY_SEC,                            
                           PRINTED_IND,                                 
                           CUSTCHG_ORD_TYP_FL,                          
                           PRICE_PER_SERV,                              
                           ACCOUNT_TYPE_CODE,                           
                           WORK_START_DT,                               
                           MADE_SAFE_DT,                                
                           CUST_CNT_ID)                                 
               SELECT  PREMISE_NO,                                      
                       ACCOUNT_NO,                                      
                       :WS-NEW-SERV-ORDER-NO,                           
                       'FW024',                                         
                       COMPANY_NO,                                      
                       LOCAL_OFFICE,                                    
                       SERV_ORDER_STATUS,                               
                       PHONE_NO_EXT,                                    
                       PHONE_NO,                                        
                       ORDER_PLACED_BY,                                 
                       ORDER_RECVED_BY,                                 
                       CIS.CURRENT$TIMESTAMP(),                               
                       DATE_RECVED,                                     
                       USER_ID_CPTD_BY,                                 
                       CIS.CURRENT$TIMESTAMP(),                               
                       CODE_EDITED_YES_NO,                              
                       ORDER_REASON,                                    
                       BACK_DATED_IND,                                  
                       RESP_AREA_ID,                                    
                       CALL_BEFORE_MINUTS,                              
                       NOTIFY_CUST_IND,                                 
                       NOTIFY_CSR_IND,                                  
                       BREAKERS_OFF_IND,                                
                       NUMBER_OF_VISITS,                                
                       ORD_ASSIGNED_TO,                                 
                       CIS.CURRENT$TIMESTAMP(),                               
                       DEPOSIT_AMT,                                     
                       WORK_COMPLETED_IND,                              
                       CATHODIC_PROTECT,                                
                       INIT_BY_CNTRCT_IND,                              
                       DATE_PRINTED,                                    
                       WORK_AREA_ID,                                    
                       ORDER_PRIORITY_CD,                               
                       AMT_DNP_AT_BILLING,                              
                       ORDER_STATE_CD,                                  
                       BEGIN_APPT_DT,                                   
                       END_APPT_DT,                                     
                       APPT_AM_PM_CD,                                   
                       SO_EST_LABOR_HR,                                 
                       DATE_FORECAST_DNP,                               
                       ACCOUNT_NO_PRIOR,                                
                       CODES_DATA_PRESENT,                              
                       VERIFY_RATE,                                     
                       CIS.SESSION$USER(),                                      
                       COMPLETED_BY_SEC,                                
                       PRINTED_IND,                                     
                       CUSTCHG_ORD_TYP_FL,                              
                       PRICE_PER_SERV,                                  
                       ACCOUNT_TYPE_CODE,                               
                       WORK_START_DT,                                   
                       MADE_SAFE_DT,                                    
                       CUST_CNT_ID                                      
                 FROM CSS_SO_DATA SO                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_DATA                                          
MFA-TR*                   (PREMISE_NO,                                          
MFA-TR*                    ACCOUNT_NO,                                          
MFA-TR*                    SERV_ORDER_NO,                                       
MFA-TR*                    ORDER_TYPE_CD,                                       
MFA-TR*                    COMPANY_NO,                                          
MFA-TR*                    LOCAL_OFFICE,                                        
MFA-TR*                    SERV_ORDER_STATUS,                                   
MFA-TR*                    PHONE_NO_EXT,                                        
MFA-TR*                    PHONE_NO,                                            
MFA-TR*                    ORDER_PLACED_BY,                                     
MFA-TR*                    ORDER_RECVED_BY,                                     
MFA-TR*                    WANTED_BY_DATETIME,                                  
MFA-TR*                    DATE_RECVED,                                         
MFA-TR*                    USER_ID_CPTD_BY,                                     
MFA-TR*                    COMPLETED_DATETIME,                                  
MFA-TR*                    CODE_EDITED_YES_NO,                                  
MFA-TR*                    ORDER_REASON,                                        
MFA-TR*                    BACK_DATED_IND,                                      
MFA-TR*                    RESP_AREA_ID,                                        
MFA-TR*                    CALL_BEFORE_MINUTS,                                  
MFA-TR*                    NOTIFY_CUST_IND,                                     
MFA-TR*                    NOTIFY_CSR_IND,                                      
MFA-TR*                    BREAKERS_OFF_IND,                                    
MFA-TR*                    NUMBER_OF_VISITS,                                    
MFA-TR*                    ORD_ASSIGNED_TO,                                     
MFA-TR*                    ASSIGNED_DATETIME,                                   
MFA-TR*                    DEPOSIT_AMT,                                         
MFA-TR*                    WORK_COMPLETED_IND,                                  
MFA-TR*                    CATHODIC_PROTECT,                                    
MFA-TR*                    INIT_BY_CNTRCT_IND,                                  
MFA-TR*                    DATE_PRINTED,                                        
MFA-TR*                    WORK_AREA_ID,                                        
MFA-TR*                    ORDER_PRIORITY_CD,                                   
MFA-TR*                    AMT_DNP_AT_BILLING,                                  
MFA-TR*                    ORDER_STATE_CD,                                      
MFA-TR*                    BEGIN_APPT_DT,                                       
MFA-TR*                    END_APPT_DT,                                         
MFA-TR*                    APPT_AM_PM_CD,                                       
MFA-TR*                    SO_EST_LABOR_HR,                                     
MFA-TR*                    DATE_FORECAST_DNP,                                   
MFA-TR*                    ACCOUNT_NO_PRIOR,                                    
MFA-TR*                    CODES_DATA_PRESENT,                                  
MFA-TR*                    VERIFY_RATE,                                         
MFA-TR*                    COMPLETED_BY,                                        
MFA-TR*                    COMPLETED_BY_SEC,                                    
MFA-TR*                    PRINTED_IND,                                         
MFA-TR*                    CUSTCHG_ORD_TYP_FL,                                  
MFA-TR*                    PRICE_PER_SERV,                                      
MFA-TR*                    ACCOUNT_TYPE_CODE,                                   
MFA-TR*                    WORK_START_DT,                                       
MFA-TR*                    MADE_SAFE_DT,                                        
MFA-TR*                    CUST_CNT_ID)                                         
MFA-TR*        SELECT  PREMISE_NO,                                              
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                :WS-NEW-SERV-ORDER-NO,                                   
MFA-TR*                'FW024',                                                 
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                SERV_ORDER_STATUS,                                       
MFA-TR*                PHONE_NO_EXT,                                            
MFA-TR*                PHONE_NO,                                                
MFA-TR*                ORDER_PLACED_BY,                                         
MFA-TR*                ORDER_RECVED_BY,                                         
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                DATE_RECVED,                                             
MFA-TR*                USER_ID_CPTD_BY,                                         
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                CODE_EDITED_YES_NO,                                      
MFA-TR*                ORDER_REASON,                                            
MFA-TR*                BACK_DATED_IND,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                CALL_BEFORE_MINUTS,                                      
MFA-TR*                NOTIFY_CUST_IND,                                         
MFA-TR*                NOTIFY_CSR_IND,                                          
MFA-TR*                BREAKERS_OFF_IND,                                        
MFA-TR*                NUMBER_OF_VISITS,                                        
MFA-TR*                ORD_ASSIGNED_TO,                                         
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                DEPOSIT_AMT,                                             
MFA-TR*                WORK_COMPLETED_IND,                                      
MFA-TR*                CATHODIC_PROTECT,                                        
MFA-TR*                INIT_BY_CNTRCT_IND,                                      
MFA-TR*                DATE_PRINTED,                                            
MFA-TR*                WORK_AREA_ID,                                            
MFA-TR*                ORDER_PRIORITY_CD,                                       
MFA-TR*                AMT_DNP_AT_BILLING,                                      
MFA-TR*                ORDER_STATE_CD,                                          
MFA-TR*                BEGIN_APPT_DT,                                           
MFA-TR*                END_APPT_DT,                                             
MFA-TR*                APPT_AM_PM_CD,                                           
MFA-TR*                SO_EST_LABOR_HR,                                         
MFA-TR*                DATE_FORECAST_DNP,                                       
MFA-TR*                ACCOUNT_NO_PRIOR,                                        
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                VERIFY_RATE,                                             
MFA-TR*                USER,                                                    
MFA-TR*                COMPLETED_BY_SEC,                                        
MFA-TR*                PRINTED_IND,                                             
MFA-TR*                CUSTCHG_ORD_TYP_FL,                                      
MFA-TR*                PRICE_PER_SERV,                                          
MFA-TR*                ACCOUNT_TYPE_CODE,                                       
MFA-TR*                WORK_START_DT,                                           
MFA-TR*                MADE_SAFE_DT,                                            
MFA-TR*                CUST_CNT_ID                                              
MFA-TR*          FROM CSS_SO_DATA SO                                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8200'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_DATA'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8200-EXIT.                                                       
            EXIT.                                                       
       8211-UPD-GS-SO-DATA.                                             
           EXEC SQL                                                     
               UPDATE  CSS_SO_DATA                                      
                  SET COMPLETED_DATETIME=CIS.CURRENT$TIMESTAMP(),             
                      ORDER_STATE_CD='Z',                               
                      SERV_ORDER_STATUS='50'                            
                WHERE SERV_ORDER_NO = :WS-NEW-SO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE  CSS_SO_DATA                                              
MFA-TR*           SET COMPLETED_DATETIME=CURRENT TIMESTAMP,                     
MFA-TR*               ORDER_STATE_CD='Z',                                       
MFA-TR*               SERV_ORDER_STATUS='50'                                    
MFA-TR*         WHERE SERV_ORDER_NO = :WS-NEW-SO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8211'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_DATA'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE  WS-NEW-SO           TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8211-EXIT.                                                       
            EXIT.                                                       
       8250-INSERT-HST-DATA.                                            
           EXEC SQL                                                     
               INSERT INTO CSS_SO_DATA                                  
                          (PREMISE_NO,                                  
                           ACCOUNT_NO,                                  
                           SERV_ORDER_NO,                               
                           ORDER_TYPE_CD,                               
                           COMPANY_NO,                                  
                           LOCAL_OFFICE,                                
                           SERV_ORDER_STATUS,                           
                           PHONE_NO_EXT,                                
                           PHONE_NO,                                    
                           ORDER_PLACED_BY,                             
                           ORDER_RECVED_BY,                             
                           WANTED_BY_DATETIME,                          
                           DATE_RECVED,                                 
                           USER_ID_CPTD_BY,                             
                           COMPLETED_DATETIME,                          
                           CODE_EDITED_YES_NO,                          
                           ORDER_REASON,                                
                           BACK_DATED_IND,                              
                           RESP_AREA_ID,                                
                           CALL_BEFORE_MINUTS,                          
                           NOTIFY_CUST_IND,                             
                           NOTIFY_CSR_IND,                              
                           BREAKERS_OFF_IND,                            
                           NUMBER_OF_VISITS,                            
                           ORD_ASSIGNED_TO,                             
                           ASSIGNED_DATETIME,                           
                           DEPOSIT_AMT,                                 
                           WORK_COMPLETED_IND,                          
                           CATHODIC_PROTECT,                            
                           INIT_BY_CNTRCT_IND,                          
                           DATE_PRINTED,                                
                           WORK_AREA_ID,                                
                           ORDER_PRIORITY_CD,                           
                           AMT_DNP_AT_BILLING,                          
                           ORDER_STATE_CD,                              
                           BEGIN_APPT_DT,                               
                           END_APPT_DT,                                 
                           APPT_AM_PM_CD,                               
                           SO_EST_LABOR_HR,                             
                           DATE_FORECAST_DNP,                           
                           ACCOUNT_NO_PRIOR,                            
                           CODES_DATA_PRESENT,                          
                           VERIFY_RATE,                                 
                           COMPLETED_BY,                                
                           COMPLETED_BY_SEC,                            
                           PRINTED_IND,                                 
                           CUSTCHG_ORD_TYP_FL,                          
                           PRICE_PER_SERV,                              
                           ACCOUNT_TYPE_CODE,                           
                           WORK_START_DT,                               
                           MADE_SAFE_DT,                                
                           CUST_CNT_ID)                                 
               SELECT  PREMISE_NO,                                      
                       ACCOUNT_NO,                                      
                       :WS-NEW-SERV-ORDER-NO,                           
                       'FW024',                                         
                       COMPANY_NO,                                      
                       LOCAL_OFFICE,                                    
                       SERV_ORDER_STATUS,                               
                       PHONE_NO_EXT,                                    
                       PHONE_NO,                                        
                       ORDER_PLACED_BY,                                 
                       ORDER_RECVED_BY,                                 
                       CIS.CURRENT$TIMESTAMP(),                               
                       DATE_RECVED,                                     
                       USER_ID_CPTD_BY,                                 
                       CIS.CURRENT$TIMESTAMP(),                               
                       CODE_EDITED_YES_NO,                              
                       ORDER_REASON,                                    
                       BACK_DATED_IND,                                  
                       RESP_AREA_ID,                                    
                       CALL_BEFORE_MINUTS,                              
                       NOTIFY_CUST_IND,                                 
                       NOTIFY_CSR_IND,                                  
                       BREAKERS_OFF_IND,                                
                       NUMBER_OF_VISITS,                                
                       ORD_ASSIGNED_TO,                                 
                       CIS.CURRENT$TIMESTAMP(),                               
                       DEPOSIT_AMT,                                     
                       WORK_COMPLETED_IND,                              
                       CATHODIC_PROTECT,                                
                       INIT_BY_CNTRCT_IND,                              
                       DATE_PRINTED,                                    
                       WORK_AREA_ID,                                    
                       ORDER_PRIORITY_CD,                               
                       AMT_DNP_AT_BILLING,                              
                       ORDER_STATE_CD,                                  
                       BEGIN_APPT_DT,                                   
                       END_APPT_DT,                                     
                       APPT_AM_PM_CD,                                   
                       SO_EST_LABOR_HR,                                 
                       DATE_FORECAST_DNP,                               
                       ACCOUNT_NO_PRIOR,                                
                       CODES_DATA_PRESENT,                              
                       VERIFY_RATE,                                     
                       CIS.SESSION$USER(),                                      
                       COMPLETED_BY_SEC,                                
                       PRINTED_IND,                                     
                       CUSTCHG_ORD_TYP_FL,                              
                       PRICE_PER_SERV,                                  
                       ACCOUNT_TYPE_CODE,                               
                       WORK_START_DT,                                   
                       MADE_SAFE_DT,                                    
                       CUST_CNT_ID                                      
                 FROM HST_SO_DATA SO                                    
                WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_DATA                                          
MFA-TR*                   (PREMISE_NO,                                          
MFA-TR*                    ACCOUNT_NO,                                          
MFA-TR*                    SERV_ORDER_NO,                                       
MFA-TR*                    ORDER_TYPE_CD,                                       
MFA-TR*                    COMPANY_NO,                                          
MFA-TR*                    LOCAL_OFFICE,                                        
MFA-TR*                    SERV_ORDER_STATUS,                                   
MFA-TR*                    PHONE_NO_EXT,                                        
MFA-TR*                    PHONE_NO,                                            
MFA-TR*                    ORDER_PLACED_BY,                                     
MFA-TR*                    ORDER_RECVED_BY,                                     
MFA-TR*                    WANTED_BY_DATETIME,                                  
MFA-TR*                    DATE_RECVED,                                         
MFA-TR*                    USER_ID_CPTD_BY,                                     
MFA-TR*                    COMPLETED_DATETIME,                                  
MFA-TR*                    CODE_EDITED_YES_NO,                                  
MFA-TR*                    ORDER_REASON,                                        
MFA-TR*                    BACK_DATED_IND,                                      
MFA-TR*                    RESP_AREA_ID,                                        
MFA-TR*                    CALL_BEFORE_MINUTS,                                  
MFA-TR*                    NOTIFY_CUST_IND,                                     
MFA-TR*                    NOTIFY_CSR_IND,                                      
MFA-TR*                    BREAKERS_OFF_IND,                                    
MFA-TR*                    NUMBER_OF_VISITS,                                    
MFA-TR*                    ORD_ASSIGNED_TO,                                     
MFA-TR*                    ASSIGNED_DATETIME,                                   
MFA-TR*                    DEPOSIT_AMT,                                         
MFA-TR*                    WORK_COMPLETED_IND,                                  
MFA-TR*                    CATHODIC_PROTECT,                                    
MFA-TR*                    INIT_BY_CNTRCT_IND,                                  
MFA-TR*                    DATE_PRINTED,                                        
MFA-TR*                    WORK_AREA_ID,                                        
MFA-TR*                    ORDER_PRIORITY_CD,                                   
MFA-TR*                    AMT_DNP_AT_BILLING,                                  
MFA-TR*                    ORDER_STATE_CD,                                      
MFA-TR*                    BEGIN_APPT_DT,                                       
MFA-TR*                    END_APPT_DT,                                         
MFA-TR*                    APPT_AM_PM_CD,                                       
MFA-TR*                    SO_EST_LABOR_HR,                                     
MFA-TR*                    DATE_FORECAST_DNP,                                   
MFA-TR*                    ACCOUNT_NO_PRIOR,                                    
MFA-TR*                    CODES_DATA_PRESENT,                                  
MFA-TR*                    VERIFY_RATE,                                         
MFA-TR*                    COMPLETED_BY,                                        
MFA-TR*                    COMPLETED_BY_SEC,                                    
MFA-TR*                    PRINTED_IND,                                         
MFA-TR*                    CUSTCHG_ORD_TYP_FL,                                  
MFA-TR*                    PRICE_PER_SERV,                                      
MFA-TR*                    ACCOUNT_TYPE_CODE,                                   
MFA-TR*                    WORK_START_DT,                                       
MFA-TR*                    MADE_SAFE_DT,                                        
MFA-TR*                    CUST_CNT_ID)                                         
MFA-TR*        SELECT  PREMISE_NO,                                              
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                :WS-NEW-SERV-ORDER-NO,                                   
MFA-TR*                'FW024',                                                 
MFA-TR*                COMPANY_NO,                                              
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                SERV_ORDER_STATUS,                                       
MFA-TR*                PHONE_NO_EXT,                                            
MFA-TR*                PHONE_NO,                                                
MFA-TR*                ORDER_PLACED_BY,                                         
MFA-TR*                ORDER_RECVED_BY,                                         
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                DATE_RECVED,                                             
MFA-TR*                USER_ID_CPTD_BY,                                         
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                CODE_EDITED_YES_NO,                                      
MFA-TR*                ORDER_REASON,                                            
MFA-TR*                BACK_DATED_IND,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                CALL_BEFORE_MINUTS,                                      
MFA-TR*                NOTIFY_CUST_IND,                                         
MFA-TR*                NOTIFY_CSR_IND,                                          
MFA-TR*                BREAKERS_OFF_IND,                                        
MFA-TR*                NUMBER_OF_VISITS,                                        
MFA-TR*                ORD_ASSIGNED_TO,                                         
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                DEPOSIT_AMT,                                             
MFA-TR*                WORK_COMPLETED_IND,                                      
MFA-TR*                CATHODIC_PROTECT,                                        
MFA-TR*                INIT_BY_CNTRCT_IND,                                      
MFA-TR*                DATE_PRINTED,                                            
MFA-TR*                WORK_AREA_ID,                                            
MFA-TR*                ORDER_PRIORITY_CD,                                       
MFA-TR*                AMT_DNP_AT_BILLING,                                      
MFA-TR*                ORDER_STATE_CD,                                          
MFA-TR*                BEGIN_APPT_DT,                                           
MFA-TR*                END_APPT_DT,                                             
MFA-TR*                APPT_AM_PM_CD,                                           
MFA-TR*                SO_EST_LABOR_HR,                                         
MFA-TR*                DATE_FORECAST_DNP,                                       
MFA-TR*                ACCOUNT_NO_PRIOR,                                        
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                VERIFY_RATE,                                             
MFA-TR*                USER,                                                    
MFA-TR*                COMPLETED_BY_SEC,                                        
MFA-TR*                PRINTED_IND,                                             
MFA-TR*                CUSTCHG_ORD_TYP_FL,                                      
MFA-TR*                PRICE_PER_SERV,                                          
MFA-TR*                ACCOUNT_TYPE_CODE,                                       
MFA-TR*                WORK_START_DT,                                           
MFA-TR*                MADE_SAFE_DT,                                            
MFA-TR*                CUST_CNT_ID                                              
MFA-TR*          FROM HST_SO_DATA SO                                            
MFA-TR*         WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8250'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_DATA'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8250-EXIT.                                                       
            EXIT.                                                       
       8300-INSERT-SO-INST.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_ORDER_INST                            
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           SO_INST_SEQ_NO,                              
                           CODE_METER_LOC,                              
                           HOLD_RELEASE,                                
                           IC_NO,                                       
                           METER_NO,                                    
                           METER_SUPPLYING,                             
                           MTR_REF_NO,                                  
                           PER_TEMP_IND,                                
                           RLSE_DATE,                                   
                           RLSE_NO,                                     
                           WORK_TYPE_CD)                                
               SELECT  :WS-NEW-SERV-ORDER-NO,                           
                       CODE_UTIL_TYPE,                                  
                       SO_INST_SEQ_NO,                                  
                       CODE_METER_LOC,                                  
                       HOLD_RELEASE,                                    
                       IC_NO,                                           
                       METER_NO,                                        
                       METER_SUPPLYING,                                 
                       MTR_REF_NO,                                      
                       PER_TEMP_IND,                                    
                       RLSE_DATE,                                       
                       RLSE_NO,                                         
                       'G67'                                            
                 FROM CSS_SO_ORDER_INST                                 
                WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8300'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8300-EXIT.                                                       
            EXIT.                                                       
       8350-INSERT-HST-INST.                                            
           EXEC SQL                                                     
               INSERT INTO CSS_SO_ORDER_INST                            
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           SO_INST_SEQ_NO,                              
                           CODE_METER_LOC,                              
                           HOLD_RELEASE,                                
                           IC_NO,                                       
                           METER_NO,                                    
                           METER_SUPPLYING,                             
                           MTR_REF_NO,                                  
                           PER_TEMP_IND,                                
                           RLSE_DATE,                                   
                           RLSE_NO,                                     
                           WORK_TYPE_CD)                                
               SELECT  :WS-NEW-SERV-ORDER-NO,                           
                       CODE_UTIL_TYPE,                                  
                       SO_INST_SEQ_NO,                                  
                       CODE_METER_LOC,                                  
                       HOLD_RELEASE,                                    
                       IC_NO,                                           
                       METER_NO,                                        
                       METER_SUPPLYING,                                 
                       MTR_REF_NO,                                      
                       PER_TEMP_IND,                                    
                       RLSE_DATE,                                       
                       RLSE_NO,                                         
                       'G67'                                            
                 FROM HST_SO_ORDER_INST                                 
                WHERE SERV_ORDER_NO = :ZG-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8350'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'HST_SO_ORDER_INST'  TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8350-EXIT.                                                       
            EXIT.                                                       
       8400-INSERT-SO-CREW.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CREW                                  
                          (SERV_ORDER_NO,                               
                           CREW_ID,                                     
                           WORK_SEQ_NM,                                 
                           WORK_DT,                                     
                           CREW_SCHED_DT,                               
                           CREW_COMPLETE_DT)                            
               VALUES (:WS-NEW-SERV-ORDER-NO,                           
                      '000FRO',                                         
                      1,                                                
                      CIS.CURRENT$TIMESTAMP(),                                
                      CIS.CURRENT$TIMESTAMP(),                                
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_CREW                                          
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    CREW_ID,                                             
MFA-TR*                    WORK_SEQ_NM,                                         
MFA-TR*                    WORK_DT,                                             
MFA-TR*                    CREW_SCHED_DT,                                       
MFA-TR*                    CREW_COMPLETE_DT)                                    
MFA-TR*        VALUES (:WS-NEW-SERV-ORDER-NO,                                   
MFA-TR*               '000FRO',                                                 
MFA-TR*               1,                                                        
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8450'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_CREW'        TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8400-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       8500-INSERT-SO-MATL.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_MATL_TRAN                             
                          (SERV_ORDER_NO,                               
                           COMP_UNIT_CD,                                
                           CU_SEQ_NM,                                   
                           MATL_USAGE_CD,                               
                           MATL_ITEM_CD,                                
                           WORK_ORDER_NM,                               
                           GL_ACCT_NO,                                  
                           FUNC_ACT_CD,                                 
                           POINT,                                       
                           SPAN_TO_POINT,                               
                           MISC_TRK_STOCK_AM,                           
                           MATL_ITEM_QT,                                
                           CU_QT,                                       
                           MATL_ITEM_TOT_AM,                            
                           MATL_ITEM_TYPE_CD,                           
                           UOM_CD,                                      
                           COST_CENTER,                                 
                           EMPLOYEE_ID,                                 
                           COMPANY_NO,                                  
                           LOCAL_STORERM_ID,                            
                           WORK_AREA_WO_NM,                             
                           OK_TO_PROCESS_FL,                            
                           GAS_CARRIER_FL,                              
                           MATL_POSTED_FL)                              
               SELECT :WS-NEW-SERV-ORDER-NO,                            
                      COMP_UNIT_CD,                                     
                      CU_SEQ_NM,                                        
                      CASE MATL_USAGE_CD                                
                           WHEN 'I' THEN 'V'                            
                           WHEN 'A' THEN 'W'                            
                           WHEN 'S' THEN 'X'                            
                           WHEN 'R' THEN 'Y'                            
                      END,                                              
                      MATL_ITEM_CD,                                     
                      WORK_ORDER_NM,                                    
                      GL_ACCT_NO,                                       
                      FUNC_ACT_CD,                                      
                      POINT,                                            
                      SPAN_TO_POINT,                                    
                      MISC_TRK_STOCK_AM,                                
                      MATL_ITEM_QT * -1,                                
                      CU_QT,                                            
                      MATL_ITEM_TOT_AM * -1,                            
                      MATL_ITEM_TYPE_CD,                                
                      UOM_CD,                                           
                      COST_CENTER,                                      
                      EMPLOYEE_ID,                                      
                      COMPANY_NO,                                       
                      LOCAL_STORERM_ID,                                 
                      WORK_AREA_WO_NM,                                  
                      OK_TO_PROCESS_FL,                                 
                      GAS_CARRIER_FL,                                   
                      MATL_POSTED_FL                                    
                  FROM CSS_SO_MATL_TRAN                                 
                WHERE SERV_ORDER_NO = :WU-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8500'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_MATL_TRAN'   TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8500-EXIT.                                                       
            EXIT.                                                       
       8511-INSERT-GAS-MATL.                                            
           EXEC SQL                                                     
               INSERT INTO CSS_SO_MATL_TRAN                             
                          (SERV_ORDER_NO,                               
                           COMP_UNIT_CD,                                
                           CU_SEQ_NM,                                   
                           MATL_USAGE_CD,                               
                           MATL_ITEM_CD,                                
                           WORK_ORDER_NM,                               
                           GL_ACCT_NO,                                  
                           FUNC_ACT_CD,                                 
                           POINT,                                       
                           SPAN_TO_POINT,                               
                           MISC_TRK_STOCK_AM,                           
                           MATL_ITEM_QT,                                
                           CU_QT,                                       
                           MATL_ITEM_TOT_AM,                            
                           MATL_ITEM_TYPE_CD,                           
                           UOM_CD,                                      
                           COST_CENTER,                                 
                           EMPLOYEE_ID,                                 
                           COMPANY_NO,                                  
                           LOCAL_STORERM_ID,                            
                           WORK_AREA_WO_NM,                             
                           OK_TO_PROCESS_FL,                            
                           GAS_CARRIER_FL,                              
                           MATL_POSTED_FL)                              
               SELECT :WS-NEW-SO,                                       
                      '',                                               
                      0,                                                
                      CASE MATL_USAGE_CD                                
                           WHEN 'I' THEN 'V'                            
                           WHEN 'A' THEN 'W'                            
                           WHEN 'S' THEN 'X'                            
                           WHEN 'R' THEN 'Y'                            
                      END,                                              
                      MATL_ITEM_CD,                                     
                      '0',                                              
                      GL_ACCT_NO,                                       
                      FUNC_ACT_CD,                                      
                      0,                                                
                      0,                                                
                      0,                                                
                      MATL_ITEM_QT * -1,                                
                      0,                                                
                      MATL_ITEM_TOT_AM * -1,                            
                      MATL_ITEM_TYPE_CD,                                
                      '',                                               
                      COST_CENTER,                                      
                      EMPLOYEE_ID,                                      
                      COMPANY_NO,                                       
                      LOCAL_STORERM_ID,                                 
                      WORK_AREA_WO_NM,                                  
                      'Y',                                              
                      GAS_CARRIER_FL,                                   
                      'Y'                                               
                  FROM CSS_GAS_SERV_MATL                                
                WHERE SERVICE_NO = :XO-SERVICE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8511'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_MATL_TRAN'   TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8511-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       8550-INSERT-HST-MATL.                                            
           EXEC SQL                                                     
               INSERT INTO CSS_SO_MATL_TRAN                             
                          (SERV_ORDER_NO,                               
                           COMP_UNIT_CD,                                
                           CU_SEQ_NM,                                   
                           MATL_USAGE_CD,                               
                           MATL_ITEM_CD,                                
                           WORK_ORDER_NM,                               
                           GL_ACCT_NO,                                  
                           FUNC_ACT_CD,                                 
                           POINT,                                       
                           SPAN_TO_POINT,                               
                           MISC_TRK_STOCK_AM,                           
                           MATL_ITEM_QT,                                
                           CU_QT,                                       
                           MATL_ITEM_TOT_AM,                            
                           MATL_ITEM_TYPE_CD,                           
                           UOM_CD,                                      
                           COST_CENTER,                                 
                           EMPLOYEE_ID,                                 
                           COMPANY_NO,                                  
                           LOCAL_STORERM_ID,                            
                           WORK_AREA_WO_NM,                             
                           OK_TO_PROCESS_FL,                            
                           GAS_CARRIER_FL,                              
                           MATL_POSTED_FL)                              
               SELECT :WS-NEW-SERV-ORDER-NO,                            
                      COMP_UNIT_CD,                                     
                      CU_SEQ_NM,                                        
                      CASE MATL_USAGE_CD                                
                           WHEN 'I' THEN 'V'                            
                           WHEN 'A' THEN 'W'                            
                           WHEN 'S' THEN 'X'                            
                           WHEN 'R' THEN 'Y'                            
                      END,                                              
                      MATL_ITEM_CD,                                     
                      WORK_ORDER_NM,                                    
                      GL_ACCT_NO,                                       
                      FUNC_ACT_CD,                                      
                      POINT,                                            
                      SPAN_TO_POINT,                                    
                      MISC_TRK_STOCK_AM,                                
                      MATL_ITEM_QT * -1,                                
                      CU_QT,                                            
                      MATL_ITEM_TOT_AM * -1,                            
                      MATL_ITEM_TYPE_CD,                                
                      UOM_CD,                                           
                      COST_CENTER,                                      
                      EMPLOYEE_ID,                                      
                      COMPANY_NO,                                       
                      LOCAL_STORERM_ID,                                 
                      WORK_AREA_WO_NM,                                  
                      OK_TO_PROCESS_FL,                                 
                      GAS_CARRIER_FL,                                   
                      MATL_POSTED_FL                                    
                  FROM HST_SO_MATL_TRAN                                 
                WHERE SERV_ORDER_NO = :WE-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8550'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_MATL_TRAN'   TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8550-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8600-INSERT-SO-REMK.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REMARKS                               
                          (SERV_ORDER_NO,                               
                           REMARK_TYPE_CD,                              
                           REMARK_DATETIME,                             
                           CHANGED_BY_USER_ID,                          
                           REMARK_TX)                                   
               VALUES( :WS-NEW-SERV-ORDER-NO,                           
                      :EF-REMARK-TYPE-CD,                               
                      CIS.CURRENT$TIMESTAMP(),                                
                      CIS.SESSION$USER(),                                       
                      :EF-REMARK-TX )                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REMARKS                                       
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    REMARK_TYPE_CD,                                      
MFA-TR*                    REMARK_DATETIME,                                     
MFA-TR*                    CHANGED_BY_USER_ID,                                  
MFA-TR*                    REMARK_TX)                                           
MFA-TR*        VALUES( :WS-NEW-SERV-ORDER-NO,                                   
MFA-TR*               :EF-REMARK-TYPE-CD,                                       
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               USER,                                                     
MFA-TR*               :EF-REMARK-TX )                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8600'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_MATL_TRAN'   TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8611-UPD-SOORD-INST.                                             
           EXEC SQL                                                     
               UPDATE CSS_SO_ORDER_INST                                 
                 SET  WORK_TYPE_CD='G67'                                
               WHERE  SERV_ORDER_NO=:WS-NEW-SO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8611'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                    
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8611-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8700-INSERT-SO-REQM.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REQUIREMENT                           
                          (SERV_ORDER_NO,                               
                           SERV_ORDER_STATUS,                           
                           REQUIREMENT_CD,                              
                           AUTH_BY_USER_ID,                             
                           COMP_BY_USER_ID,                             
                           DAYS_DURATION_NM,                            
                           DISP_CD,                                     
                           LABOR_HRS_NM,                                
                           MILESTONE_FL,                                
                           NONSTD_REQMNT_TEXT,                          
                           REQMNT_COMP_DT,                              
                           REQMNT_STAGE_CD,                             
                           RESOURCE_CD)                                 
               SELECT :WS-NEW-SERV-ORDER-NO,                            
                      RQ.SERV_ORDER_STATUS,                             
                      RQ.REQUIREMENT_CD,                                
                      ' ',                                              
                      CIS.SESSION$USER(),                                       
                      0,                                                
                      ' ',                                              
                      0,                                                
                      ' ',                                              
                      ' ',                                              
                      CIS.CURRENT$TIMESTAMP(),                                
                      'C',                                              
                      RQ.RESOURCE_CD                                    
                 FROM CSS_REQUIREMENT RQ                                
                     ,CSS_SO_DATA VO                                    
                     ,CSS_ORDER_TYPE C2                                 
                WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO              
                  AND VO.COMPANY_NO    = C2.COMPANY_NO                  
                  AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD               
                  AND C2.WORK_CLASS_ID = RQ.WORK_CLASS_ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REQUIREMENT                                   
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    SERV_ORDER_STATUS,                                   
MFA-TR*                    REQUIREMENT_CD,                                      
MFA-TR*                    AUTH_BY_USER_ID,                                     
MFA-TR*                    COMP_BY_USER_ID,                                     
MFA-TR*                    DAYS_DURATION_NM,                                    
MFA-TR*                    DISP_CD,                                             
MFA-TR*                    LABOR_HRS_NM,                                        
MFA-TR*                    MILESTONE_FL,                                        
MFA-TR*                    NONSTD_REQMNT_TEXT,                                  
MFA-TR*                    REQMNT_COMP_DT,                                      
MFA-TR*                    REQMNT_STAGE_CD,                                     
MFA-TR*                    RESOURCE_CD)                                         
MFA-TR*        SELECT :WS-NEW-SERV-ORDER-NO,                                    
MFA-TR*               RQ.SERV_ORDER_STATUS,                                     
MFA-TR*               RQ.REQUIREMENT_CD,                                        
MFA-TR*               ' ',                                                      
MFA-TR*               USER,                                                     
MFA-TR*               0,                                                        
MFA-TR*               ' ',                                                      
MFA-TR*               0,                                                        
MFA-TR*               ' ',                                                      
MFA-TR*               ' ',                                                      
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               'C',                                                      
MFA-TR*               RQ.RESOURCE_CD                                            
MFA-TR*          FROM CSS_REQUIREMENT RQ                                        
MFA-TR*              ,CSS_SO_DATA VO                                            
MFA-TR*              ,CSS_ORDER_TYPE C2                                         
MFA-TR*         WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO                      
MFA-TR*           AND VO.COMPANY_NO    = C2.COMPANY_NO                          
MFA-TR*           AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                       
MFA-TR*           AND C2.WORK_CLASS_ID = RQ.WORK_CLASS_ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8700'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8700-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       8750-INSERT-HST-REQM.                                            
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REQUIREMENT                           
                          (SERV_ORDER_NO,                               
                           SERV_ORDER_STATUS,                           
                           REQUIREMENT_CD,                              
                           AUTH_BY_USER_ID,                             
                           COMP_BY_USER_ID,                             
                           DAYS_DURATION_NM,                            
                           DISP_CD,                                     
                           LABOR_HRS_NM,                                
                           MILESTONE_FL,                                
                           NONSTD_REQMNT_TEXT,                          
                           REQMNT_COMP_DT,                              
                           REQMNT_STAGE_CD,                             
                           RESOURCE_CD)                                 
               SELECT :WS-NEW-SERV-ORDER-NO,                            
                      RQ.SERV_ORDER_STATUS,                             
                      RQ.REQUIREMENT_CD,                                
                      ' ',                                              
                      CIS.SESSION$USER(),                                       
                      0,                                                
                      ' ',                                              
                      0,                                                
                      ' ',                                              
                      ' ',                                              
                      CIS.CURRENT$TIMESTAMP(),                                
                      'C',                                              
                      RQ.RESOURCE_CD                                    
                 FROM CSS_REQUIREMENT RQ                                
                     ,HST_SO_DATA YV                                    
                     ,CSS_ORDER_TYPE C2                                 
                WHERE SERV_ORDER_NO    = :YV-SERV-ORDER-NO              
                  AND YV.COMPANY_NO    = C2.COMPANY_NO                  
                  AND YV.ORDER_TYPE_CD = C2.ORDER_TYPE_CD               
                  AND C2.WORK_CLASS_ID = RQ.WORK_CLASS_ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REQUIREMENT                                   
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    SERV_ORDER_STATUS,                                   
MFA-TR*                    REQUIREMENT_CD,                                      
MFA-TR*                    AUTH_BY_USER_ID,                                     
MFA-TR*                    COMP_BY_USER_ID,                                     
MFA-TR*                    DAYS_DURATION_NM,                                    
MFA-TR*                    DISP_CD,                                             
MFA-TR*                    LABOR_HRS_NM,                                        
MFA-TR*                    MILESTONE_FL,                                        
MFA-TR*                    NONSTD_REQMNT_TEXT,                                  
MFA-TR*                    REQMNT_COMP_DT,                                      
MFA-TR*                    REQMNT_STAGE_CD,                                     
MFA-TR*                    RESOURCE_CD)                                         
MFA-TR*        SELECT :WS-NEW-SERV-ORDER-NO,                                    
MFA-TR*               RQ.SERV_ORDER_STATUS,                                     
MFA-TR*               RQ.REQUIREMENT_CD,                                        
MFA-TR*               ' ',                                                      
MFA-TR*               USER,                                                     
MFA-TR*               0,                                                        
MFA-TR*               ' ',                                                      
MFA-TR*               0,                                                        
MFA-TR*               ' ',                                                      
MFA-TR*               ' ',                                                      
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               'C',                                                      
MFA-TR*               RQ.RESOURCE_CD                                            
MFA-TR*          FROM CSS_REQUIREMENT RQ                                        
MFA-TR*              ,HST_SO_DATA YV                                            
MFA-TR*              ,CSS_ORDER_TYPE C2                                         
MFA-TR*         WHERE SERV_ORDER_NO    = :YV-SERV-ORDER-NO                      
MFA-TR*           AND YV.COMPANY_NO    = C2.COMPANY_NO                          
MFA-TR*           AND YV.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                       
MFA-TR*           AND C2.WORK_CLASS_ID = RQ.WORK_CLASS_ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8500'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8750-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       8760-INSERT-SO-CHGS.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CHARGES                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           OT_CHARGEABLE_HRS,                           
                           REG_CHARGEABLE_HRS,                          
                           MATERIAL_CHRG,                               
                           OTHER_CHRG,                                  
                           CALC_LABOR_CHRG,                             
                           COMMENTS,                                    
                           STD_LABOR_CHRG,                              
                           ADDL_LABOR_CHRG,                             
                           ADDL_MATL_CHRG,                              
                           CLASS_CD,                                    
                           CNT_NAME_CD,                                 
                           LBR_MARKUP_TYPE_CD,                          
                           MATL_OVERRIDE_CHRG,                          
                           MTL_MARKUP_TYPE_CD,                          
                           EQUIP_CHARG_AM,                              
                           EQUIP_OVERRIDE_AM,                           
                           CONTRACTOR_AM,                               
                           ACCOUNT_TYPE_CODE,                           
                           WAIVER_TYPE_CD,                              
                           WORK_PERIOD_CD)                              
               SELECT :WS-NEW-SERV-ORDER-NO,                            
                      CODE_UTIL_TYPE,                                   
                      OT_CHARGEABLE_HRS,                                
                      REG_CHARGEABLE_HRS,                               
                      MATERIAL_CHRG,                                    
                      OTHER_CHRG,                                       
                      CALC_LABOR_CHRG,                                  
                      COMMENTS,                                         
                      STD_LABOR_CHRG,                                   
                      ADDL_LABOR_CHRG,                                  
                      ADDL_MATL_CHRG,                                   
                      CLASS_CD,                                         
                      CNT_NAME_CD,                                      
                      LBR_MARKUP_TYPE_CD,                               
                      MATL_OVERRIDE_CHRG,                               
                      MTL_MARKUP_TYPE_CD,                               
                      EQUIP_CHARG_AM,                                   
                      EQUIP_OVERRIDE_AM,                                
                      CONTRACTOR_AM,                                    
                      ACCOUNT_TYPE_CODE,                                
                      WAIVER_TYPE_CD,                                   
                      WORK_PERIOD_CD                                    
                 FROM CSS_SO_CHARGES                                    
                WHERE SERV_ORDER_NO = :VG-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8760'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_CHARGES'     TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8760-EXIT.                                                       
            EXIT.                                                       
       8770-INSERT-HST-CHGS.                                            
           EXEC SQL                                                     
               INSERT INTO CSS_SO_CHARGES                               
                          (SERV_ORDER_NO,                               
                           CODE_UTIL_TYPE,                              
                           OT_CHARGEABLE_HRS,                           
                           REG_CHARGEABLE_HRS,                          
                           MATERIAL_CHRG,                               
                           OTHER_CHRG,                                  
                           CALC_LABOR_CHRG,                             
                           COMMENTS,                                    
                           STD_LABOR_CHRG,                              
                           ADDL_LABOR_CHRG,                             
                           ADDL_MATL_CHRG,                              
                           CLASS_CD,                                    
                           CNT_NAME_CD,                                 
                           LBR_MARKUP_TYPE_CD,                          
                           MATL_OVERRIDE_CHRG,                          
                           MTL_MARKUP_TYPE_CD,                          
                           EQUIP_CHARG_AM,                              
                           EQUIP_OVERRIDE_AM,                           
                           CONTRACTOR_AM,                               
                           ACCOUNT_TYPE_CODE,                           
                           WAIVER_TYPE_CD,                              
                           WORK_PERIOD_CD)                              
               SELECT :WS-NEW-SERV-ORDER-NO,                            
                      CODE_UTIL_TYPE,                                   
                      OT_CHARGEABLE_HRS,                                
                      REG_CHARGEABLE_HRS,                               
                      MATERIAL_CHRG,                                    
                      OTHER_CHRG,                                       
                      CALC_LABOR_CHRG,                                  
                      COMMENTS,                                         
                      STD_LABOR_CHRG,                                   
                      ADDL_LABOR_CHRG,                                  
                      ADDL_MATL_CHRG,                                   
                      CLASS_CD,                                         
                      CNT_NAME_CD,                                      
                      LBR_MARKUP_TYPE_CD,                               
                      MATL_OVERRIDE_CHRG,                               
                      MTL_MARKUP_TYPE_CD,                               
                      EQUIP_CHARG_AM,                                   
                      EQUIP_OVERRIDE_AM,                                
                      CONTRACTOR_AM,                                    
                      ACCOUNT_TYPE_CODE,                                
                      WAIVER_TYPE_CD,                                   
                      WORK_PERIOD_CD                                    
                 FROM HST_SO_CHARGES                                    
                WHERE SERV_ORDER_NO = :YQ-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8770'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_CHARGES'     TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8770-EXIT.                                                       
            EXIT.                                                       
       8800-INSERT-SO-UPDT.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                          (SERV_ORDER_NO,                               
                           UPDATE_DATETIME,                             
                           ASSIGNED_DATETIME,                           
                           ORDER_STATE_CD,                              
                           ORDER_TYPE_CD,                               
                           PANEL_NO,                                    
                           SERV_ORDER_STATUS,                           
                           USER_ID_UPDT_BY,                             
                           WANTED_BY_DATETIME)                          
               VALUES(:WS-NEW-SERV-ORDER-NO,                            
                      CIS.CURRENT$TIMESTAMP(),                                
                      CIS.CURRENT$TIMESTAMP(),                                
                      :VW-ORDER-STATE-CD,                               
                      :VW-ORDER-TYPE-CD,                                
                      :VW-PANEL-NO,                                     
                      :VW-SERV-ORDER-STATUS,                            
                      CIS.SESSION$USER(),                                       
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*                   (SERV_ORDER_NO,                                       
MFA-TR*                    UPDATE_DATETIME,                                     
MFA-TR*                    ASSIGNED_DATETIME,                                   
MFA-TR*                    ORDER_STATE_CD,                                      
MFA-TR*                    ORDER_TYPE_CD,                                       
MFA-TR*                    PANEL_NO,                                            
MFA-TR*                    SERV_ORDER_STATUS,                                   
MFA-TR*                    USER_ID_UPDT_BY,                                     
MFA-TR*                    WANTED_BY_DATETIME)                                  
MFA-TR*        VALUES(:WS-NEW-SERV-ORDER-NO,                                    
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               :VW-ORDER-STATE-CD,                                       
MFA-TR*               :VW-ORDER-TYPE-CD,                                        
MFA-TR*               :VW-PANEL-NO,                                             
MFA-TR*               :VW-SERV-ORDER-STATUS,                                    
MFA-TR*               USER,                                                     
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8800'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_UPDATE'      TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8800-EXIT.                                                       
            EXIT.                                                       
       8950-INSERT-SO-XRF.                                              
           EXEC SQL                                                     
               INSERT INTO CSS_GASLINE_SO_XRF                           
                          (SERVICE_NO,                                  
                           SERV_ORDER_NO,                               
                           INSTALL_TYPE_CD                              
                           )                                            
               VALUES(:XX-SERVICE-NO,                                   
                      :WS-NEW-SERV-ORDER-NO,                            
                      'V'                                               
                       )                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8900'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_GASLINE_SO_XRF' TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE WS-NEW-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8950-EXIT.                                                       
            EXIT.                                                       
       8960-UPDATE-GAS-SERV-LINE.                                       
           EXEC SQL                                                     
               UPDATE CSS_GAS_SERV_LINE                                 
                  SET SERV_LINE_STAT_FL = 'V'                           
               WHERE  SERVICE_NO = :XO-SERVICE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8960'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_GAS_SERV_LINE ' TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XO-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8960-EXIT.                                                       
            EXIT.                                                       
       8970-UPDATE-PREM-GAS-LINE.                                       
           EXEC SQL                                                     
               UPDATE CSS_PREM_GAS_LINE                                 
                  SET CMSN_REQUEST_FL = 'N'                             
PR104                ,INSTALL_PREM_FL    = ' '                          
P0104                ,SERV_AGREE_AMT     = 0                            
P0104                ,SERV_AGREE_DT      = NULL                         
P0104                ,SERV_AGREE_STAT_CD = ' '                          
               WHERE  SERVICE_NO = :XO-SERVICE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8970'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_PREM_GAS_LINE ' TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XO-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8970-EXIT.                                                       
       8971-DELETE-GAS-SERV-MATL.                                       
           EXEC SQL                                                     
               DELETE FROM CSS_GAS_SERV_MATL                            
               WHERE  SERVICE_NO = :XO-SERVICE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8971'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE 'CSS_GAS_SERV_MATL'  TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XO-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
       8971-EXIT.                                                       
            EXIT.                                                       
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
