       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04135.                                          
       AUTHOR.       COVANSYS.                                          
       DATE-WRITTEN. MAR 2008.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED IN     *        
      *  PANEL273 - FINAL BILL CREDIT ACTION WINDOW FOR DISPLAYING     *        
      *             COLLECTION AGENCY INFORMATION.                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  03/18/2007 CVNS      INITIAL VERSION. Created for Write off   *        
      *             CHENNAI   Changes C30169                           *        
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04135'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                     PIC X(40)  VALUE                 
           'WORKING STORAGE FOR CSR04135 STARTS HERE'.                  
      *                                                                         
      *****************************************************************         
      *   RETURN FIELD AREA                                           *         
      *****************************************************************         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9)  COMP VALUE ZERO.      
           05 S-COLL-AGNCY-NAME        PIC X(25)  VALUE  SPACES.        
           05 S-CONTAC-PHONE-NO        PIC X(10)  VALUE  SPACES.        
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
           05 RS-RETURN-CODE           PIC S9(9)   COMP VALUE ZERO.     
           05 RS-COLL-AGNCY-NAME       PIC X(25)   VALUE  SPACES.       
           05 RS-CONTAC-PHONE-NO       PIC X(10)   VALUE  SPACES.       
      *                                                                         
       01 WS-MISC.                                                      
           05 PROGRAM-NAME             PIC X(08)   VALUE 'CSR04135'.    
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM        REDEFINES   WS-ACCOUNT-NO        
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
      *    05 WS-FW-SEQ-NO             PIC S9(4)   USAGE COMP VALUE 0.          
           05 WS-ACTION-TYPE-CD        PIC X(05)   VALUE  SPACES.       
           05 WS-IZ-COLL-AGY-NULL      PIC S9(4)   COMP VALUE ZERO.     
           05 WS-CODE-COLLEC-AGNCY     PIC X(03)   VALUE  SPACES.       
           05 WS-COMPANY-NO            PIC X(02)   VALUE  SPACES.       
           05 WS-REGION                PIC X(03)   VALUE  SPACES.       
           05 SEND-DONE-SW             PIC X(01)   VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
      ******************************************************************        
      * SQL Error Checking Copy Books.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    FW - CSS_FINAL_WO                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFINLWO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    IZ - CSS_FIN_WO_COLLECT                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFWCLAG                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    IZ - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    Q7 - CSS_COLLECT_AGENCY                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCLAGNY                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * Error Handling Copy Book.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-ACCOUNT-NO             PIC X(13).                       
      *01  PARM-ACTION-TYPE            PIC X(05).                               
      *01  PARM-COLL-SEQ-NO            PIC S9(4)   USAGE COMP.                  
       01  PARM-REGION                 PIC X(03).                       
       01  PARM-COMPANY-NO             PIC X(02).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
      *                         PARM-ACTION-TYPE                                
      *                         PARM-COLL-SEQ-NO                                
                                PARM-REGION                             
                                PARM-COMPANY-NO.                        
      *                                                                         
      ******************************************************************        
      * Controls the Main Processing of the Program.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           INITIALIZE  GTT-RETURN-FIELDS                                
                       TDS-RETURN-FIELDS.                               
           EXEC SQL                                                     
                 DECLARE C1 CURSOR  FOR                      
                 SELECT                                                 
                   :S-RETURN-CODE      AS RETURN_CODE                   
                  ,:S-COLL-AGNCY-NAME  AS COLL_AGNCY_NAME               
                  ,:S-CONTAC-PHONE-NO  AS CONTAC_PHONE_NO               
                 FROM                                                   
                     CIS.SYSDUMMY1                                   
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE C1 CURSOR WITH RETURN FOR                              
MFA-TR*          SELECT                                                         
MFA-TR*            :S-RETURN-CODE      AS RETURN_CODE                           
MFA-TR*           ,:S-COLL-AGNCY-NAME  AS COLL_AGNCY_NAME                       
MFA-TR*           ,:S-CONTAC-PHONE-NO  AS CONTAC_PHONE_NO                       
MFA-TR*          FROM                                                           
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*      END-EXEC.                                                          
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                           PARM-ACTION-TYPE                     *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO               TO WS-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO                 TO WS-ACCOUNT-NO-NUM.     
           MOVE WS-ACCOUNT-NO-NUM             TO WS-ACCOUNT-NO-COMP3.   
      *    MOVE PARM-COLL-SEQ-NO              TO WS-FW-SEQ-NO.                  
      *    MOVE PARM-ACTION-TYPE              TO WS-ACTION-TYPE-CD.             
           MOVE PARM-COMPANY-NO               TO WS-COMPANY-NO.         
           MOVE PARM-REGION                   TO WS-REGION.             
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM  7000-SEL-DELINQUENCY             THRU 7000-EXIT.    
      *                                                                         
           PERFORM 2000A-MOVE-RESULT                 THRU 2000A-EXIT.   
           ADD +1                             TO CTR-ROWS.              
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * Prepares Result Set Row.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE                TO S-RETURN-CODE.         
           MOVE RS-COLL-AGNCY-NAME            TO S-COLL-AGNCY-NAME.     
           MOVE RS-CONTAC-PHONE-NO            TO S-CONTAC-PHONE-NO.     
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *2100-PROCESS-COLL-AGENCY.                                       *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-COLL-AGENCY.                                        
           IF  C8-DELINQ-VALUE         = 0                              
              IF WS-REGION             = 'CSR'                          
                 EVALUATE WS-COMPANY-NO                                 
                 WHEN  '01'                                             
                   MOVE  '005'                TO WS-CODE-COLLEC-AGNCY   
                 WHEN  '26'                                             
                   MOVE  '012'                TO WS-CODE-COLLEC-AGNCY   
                 END-EVALUATE                                           
              ELSE IF WS-REGION        = 'SEB'                          
                 MOVE  '005'                  TO WS-CODE-COLLEC-AGNCY   
              END-IF
              END-IF                                                    
           ELSE IF C8-DELINQ-VALUE     = 1                              
              PERFORM  7150-SEL-COLL-STATUS-CD     THRU 7150-EXIT       
              PERFORM  2200-PROCESS-ACTION-TYPE-CD THRU 2200-EXIT       
              MOVE WS-ACTION-TYPE-CD          TO IZ-FW-ACTION-TYPE-CD   
              PERFORM  7100-SEL-CODE-COLLEC-AGNCY  THRU 7100-EXIT       
              IF WS-CODE-COLLEC-AGNCY = SPACES                          
                IF WS-REGION           = 'CSR'                          
                   EVALUATE WS-COMPANY-NO                               
                   WHEN  '01'                                           
                     MOVE  '005'              TO WS-CODE-COLLEC-AGNCY   
                   WHEN  '26'                                           
                     MOVE  '012'              TO WS-CODE-COLLEC-AGNCY   
                   END-EVALUATE                                         
                ELSE IF WS-REGION      = 'SEB'                          
                   MOVE  '005'                TO WS-CODE-COLLEC-AGNCY   
                END-IF                                                  
             END-IF                                                     
           END-IF
                END-IF
           END-IF.                                                      
           IF WS-CODE-COLLEC-AGNCY     > SPACES                         
             PERFORM 7200-GET-COLL-AG-NAME         THRU 7200-EXIT       
           END-IF.                                                      
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-ACTION-TYPE-CD.                                   *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-ACTION-TYPE-CD.                                     
           EVALUATE FW-COLLECT-STATUS-CD                                
               WHEN 'F'                                                 
                    MOVE '1PLMT'              TO WS-ACTION-TYPE-CD      
               WHEN 'H'                                                 
                    MOVE '2PLMT'              TO WS-ACTION-TYPE-CD      
               WHEN 'J'                                                 
                    MOVE '3PLMT'              TO WS-ACTION-TYPE-CD      
               WHEN 'D'                                                 
                    MOVE 'ATY'                TO WS-ACTION-TYPE-CD      
               WHEN OTHER                                               
                    MOVE SPACES               TO WS-CODE-COLLEC-AGNCY   
           END-EVALUATE.                                                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7000-SEL-DELINQUENCY.                                           *        
      ******************************************************************        
      *                                                                         
       7000-SEL-DELINQUENCY.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                      
              INTO                                                      
                      :C8-DELINQ-VALUE                                  
              FROM                                                      
                     CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE                                                     
                     DELINQ_CD    ='COLL-AGNCY-INFO-SW'                 
              AND    COMPANY_NO   = :WS-COMPANY-NO                      
                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*               DELINQ_VALUE                                              
MFA-TR*       INTO                                                              
MFA-TR*               :C8-DELINQ-VALUE                                          
MFA-TR*       FROM                                                              
MFA-TR*              CSS_DELINQUENCY                                            
MFA-TR*       WHERE                                                             
MFA-TR*              DELINQ_CD    ='COLL-AGNCY-INFO-SW'                         
MFA-TR*       AND    COMPANY_NO   = :WS-COMPANY-NO                              
MFA-TR*       FETCH  FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                       TO RS-RETURN-CODE.        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL              
              PERFORM 2100-PROCESS-COLL-AGENCY  THRU 2100-EXIT          
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE SQLSTATE                   TO ABEND-SQLSTATE         
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
              MOVE 'COLL-AGNCY-INFO-SW'       TO HOSTVAR-ELEMENT-1      
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *7100-SEL-CODE-COLLEC-AGNCY                                     *         
      *****************************************************************         
       7100-SEL-CODE-COLLEC-AGNCY.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_COLLEC_AGNCY                                   
              INTO                                                      
                  :IZ-CODE-COLLEC-AGNCY :WS-IZ-COLL-AGY-NULL             
              FROM                                                      
                  CSS_FIN_WO_COLLECT WITH(READUNCOMMITTED)                      
              WHERE                                                     
                    ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP3            
              AND   FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD           
              ORDER BY FW_COLL_SEQ_NO DESC                              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           CODE_COLLEC_AGNCY                                             
MFA-TR*       INTO                                                              
MFA-TR*           :IZ-CODE-COLLEC-AGNCY:WS-IZ-COLL-AGY-NULL                     
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FIN_WO_COLLECT                                            
MFA-TR*       WHERE                                                             
MFA-TR*             ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP3                    
MFA-TR*       AND   FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                   
MFA-TR*       ORDER BY FW_COLL_SEQ_NO DESC                                      
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE IZ-CODE-COLLEC-AGNCY    TO WS-CODE-COLLEC-AGNCY   
                 IF WS-IZ-COLL-AGY-NULL < 0                             
                    MOVE SPACES               TO WS-CODE-COLLEC-AGNCY   
                    MOVE ZERO                 TO WS-IZ-COLL-AGY-NULL    
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 MOVE SPACES                  TO WS-CODE-COLLEC-AGNCY   
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '7100'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE 'CSS_FIN_WO_COLLECT'    TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE WS-ACCOUNT-NO-COMP3     TO HOSTVAR-ELEMENT-1      
                 MOVE 'FW_ACTION_TYPE_CD'     TO TABLE-ELEMENT-3        
                 MOVE IZ-FW-ACTION-TYPE-CD    TO HOSTVAR-ELEMENT-3      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7150-SEL-COLL-STATUS-CD.                                       *         
      *****************************************************************         
       7150-SEL-COLL-STATUS-CD.                                         
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                  COLLECT_STATUS_CD                                     
              INTO                                                      
                  :FW-COLLECT-STATUS-CD                                 
              FROM                                                      
                  CSS_FINAL_WO WITH(READUNCOMMITTED)                            
              WHERE                                                     
                    ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP3            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           COLLECT_STATUS_CD                                             
MFA-TR*       INTO                                                              
MFA-TR*           :FW-COLLECT-STATUS-CD                                         
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FINAL_WO                                                  
MFA-TR*       WHERE                                                             
MFA-TR*             ACCOUNT_NO        = :WS-ACCOUNT-NO-COMP3                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7150'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_FINAL_WO'          TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-ACCOUNT-NO-COMP3     TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7200-GET-COLL-AG-NAME.                                          *        
      ******************************************************************        
      *                                                                         
       7200-GET-COLL-AG-NAME.                                           
           EXEC SQL                                                     
              SELECT TOP(1) COLLEC_AGNCY_NAME,
              CONTACT_PHONE_NO                                   
              INTO                                                      
                     :Q7-COLLEC-AGNCY-NAME                              
                    ,:Q7-CONTACT-PHONE-NO                               
              FROM                                                      
                     CSS_COLLECT_AGENCY WITH(READUNCOMMITTED)                   
              WHERE                                                     
                     CODE_COLLEC_AGNCY = :WS-CODE-COLLEC-AGNCY          
                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              COLLEC_AGNCY_NAME                                          
MFA-TR*             ,CONTACT_PHONE_NO                                           
MFA-TR*       INTO                                                              
MFA-TR*              :Q7-COLLEC-AGNCY-NAME                                      
MFA-TR*             ,:Q7-CONTACT-PHONE-NO                                       
MFA-TR*       FROM                                                              
MFA-TR*              CSS_COLLECT_AGENCY                                         
MFA-TR*       WHERE                                                             
MFA-TR*              CODE_COLLEC_AGNCY = :WS-CODE-COLLEC-AGNCY                  
MFA-TR*       FETCH  FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                       TO  RS-RETURN-CODE.       
           MOVE SQLCODE                       TO  WS-ACTIVE-RETURN-CODE.
           IF WS-ACTIVE-RETURN-CODE      = SUCCESSFUL-CALL              
              MOVE Q7-COLLEC-AGNCY-NAME       TO  RS-COLL-AGNCY-NAME    
              MOVE Q7-CONTACT-PHONE-NO        TO  RS-CONTAC-PHONE-NO    
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE SQLSTATE                   TO ABEND-SQLSTATE         
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_COLLECT_AGENCY'       TO TABLE-1                
              MOVE 'CODE_COLLEC_AGNCY'        TO TABLE-ELEMENT-1        
              MOVE WS-CODE-COLLEC-AGNCY       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
