       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04128.                                         
       DATE-WRITTEN. FEB 26, 2008.                                      
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04128              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04128:                                                 --         
      *--                                                            --         
      *--  # RETURNS OPTION CODE LEVEL THERM PRICES                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            OPTION_CD             CHAR(12)                  --         
      *--            INT_EXT_FL            CHAR(01)                  --         
      *--            ACCOUNT_NO            DECIMAL(13,0)             --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            THERM_PRICE           DECIMAL(9,6)              --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     1                                                      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  02/26/2008    VY95550     PROGRAM INITIALLY WRITTEN.      --         
P00141*--  04/14/2009    SS97726     ADD START/END DATE TO USER TBL  --         
P00141*--                            CRM_OPT_ATTR_INCTV              --         
P00473*--  13 MAY 2011   SB93596     CHGS INCLUDED TO PULL APPROVED  --         
P00473*--                            OPTION/OPT ATTR INCTV RECORDS.  --         
P00805*--  10 FEB 2014   AD7F921     CHANGES TO ADD ACCOUNT NO AS IN --         
P00805*--                            PUT AND LOGIC TO LIMIT THE RATE --         
P00805*--                            SELECTION BASED ON THE MONTHS TO--         
P00805*--                            RENEW SELECT FROM DELIQ TABLE   --         
P00805*--                            FOR REG AND DREG ACCOUNTS.      --         
PFX805*--  16 MAY 2014   SS97726     PRODUCTION FIX.                 --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04128'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR04128 STARTS HERE'.            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC  S9(9) COMP.               
           05  PARM-OPTION-CD            PIC  X(12).                    
           05  PARM-INT-EXT-FL           PIC  X(01).                    
COB305     05 PARM-ACCOUNT-NO        PIC  S9(13)V USAGE COMP-3 VALUE 0.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
COB305     05 S-THERM-PRICE        PIC S9(3)V9(6) USAGE COMP-3 VALUE 0.   
                                                                        
       01  WS-GENERAL-WORKING-STORAGE.                                  
           05  RS-RETURN-CODE            PIC S9(04) COMP VALUE 0.       
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
P00805     05  WS-BILLED-DATE            PIC X(10) VALUE SPACES.        
P00805     05  WS-MONTHS-TO-RENEW        PIC S9(4) USAGE COMP           
P00805                                             VALUE 0.             
P00805     05  WS-DURATION-COUNTER       PIC S9(4) USAGE COMP           
P00805                                             VALUE 0.             
P00805     05  WS-DURATION-REMAIN-NO     PIC S9(4) USAGE COMP.          
P00805     05  WS-ZERO                   PIC S9(4) VALUE 0.             
P00805     05  WS-TEMP-REV-MONTH         PIC 9(6)  VALUE 0.             
P00805     05  WS-TEMP-REV-MONTH-RED REDEFINES WS-TEMP-REV-MONTH.       
P00805         10 WS-YEAR                PIC 9(4).                      
P00805         10 WS-MONTH               PIC 9(2).                      
           05  WS-CTR                    PIC S9(3) VALUE 0.             
           05  WS-THERM-PRICE            PIC S9(3)V9(6) USAGE COMP-3    
                                                   VALUE 0.             
           05  WS-LIMIT-DELINQ-VALUE     PIC S9(4) USAGE COMP VALUE +0. 
           05  WS-LIMIT-DELINQ-CD        PIC X(16) VALUE                
                                           'NUM-THERM-2-SHOW'.          
P00805     05  WS-REG-LIMIT-DELINQ-CD    PIC X(20) VALUE                
P00805                                     'MONTHS-TO-RENEW-REG'.       
P00805     05  WS-DREG-LIMIT-DELINQ-CD   PIC X(20) VALUE                
P00805                                     'MONTHS-TO-RENEW-DREG'.      
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-NO-ROWS                PIC X(01) VALUE 'N'.           
               88  NO-ROWS-FOUND                   VALUE 'Y'.           
P00805     05  PRICE-CUT-OFF-IND         PIC X(01) VALUE 'N'.           
P00805         88  PRICE-CUT-OFF                   VALUE 'Y'.           
P00805         88  NO-PRICE-CUT-OFF                VALUE 'N'.           
P00805     05  WS-ACCOUNT-PRCS           PIC X(01) VALUE 'N'.           
P00805         88  ACCOUNT-PRCS                    VALUE 'Y'.           
P00805         88  NO-ACCOUNT-PRCS                 VALUE 'N'.           
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04128'.    
                                                                        
P00805 01  WS-NULL-INDICATORS.                                          
P00805     05 WS-NULL-INDICATOR-1        PIC S9(4) COMP.                
P00805     05 WS-NULL-INDICATOR-2        PIC S9(4) COMP.                
P00805                                                                  
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
P00805*****************************************************************         
P00805*    CSS_ACCOUNT,     AT                                        *         
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805         INCLUDE TBACCT                                                   
P00805     END-EXEC.                                                            
P00805                                                                  
P00805*****************************************************************         
P00805*    CSS_BILLING_DET, BG                                        *         
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805         INCLUDE TBBLLDET                                                 
P00805     END-EXEC.                                                            
P00805                                                                  
P00805*****************************************************************         
P00805*    CSS_BILLING_HDR, BI                                        *         
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805         INCLUDE TBBLLHDR                                                 
P00805     END-EXEC.                                                            
P00805                                                                  
P00805*****************************************************************         
P00805*    CSS_ACCT_RTPK_AGR, DF                                      *         
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805         INCLUDE TBACCTRG                                                 
P00805     END-EXEC.                                                            
P00805                                                                  
P00805*****************************************************************         
P00805*    CSS_FIXED_FCTR,    FF                                      *         
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805         INCLUDE TBFXDFCT                                                 
P00805     END-EXEC.                                                            
P00805                                                                  
P00805*****************************************************************         
P00805*    CSS_REG_PROFILE,   LR                                                
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805        INCLUDE TBREGPRF                                                  
P00805     END-EXEC.                                                            
P00805                                                                  
P00805*****************************************************************         
P00805*    CSS_UTIL_ENVRNMT   UT                                                
P00805*****************************************************************         
P00805     EXEC SQL                                                             
P00805        INCLUDE TBUTLENV                                                  
P00805     END-EXEC.                                                            
P00805                                                                  
      *****************************************************************         
      *    TABLE : CSS_DELINQUENCY, C8                                *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_OPT_ATTR_INCTV, HQ                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SPCL_FCTR_APPL, SA                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_RT_PKG_OPTION, FI                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK                                 *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    DB2 ERRROR PROCESSING COPYBOOK                              *        
      ******************************************************************        
           COPY CWSSP001.                                                       
                                                                        
      *****************************************************************         
      **   SQL DECLARE STATEMENTS                                    **         
      *****************************************************************         
      *----------------------------------------------------------------*        
      * CURSOR TO GET INT FACTORS                                      *        
      *----------------------------------------------------------------*        
      *                                                                         
           EXEC SQL                                                     
            DECLARE INT_DISP_CUR  CURSOR FOR                            
             SELECT SA.FACTOR                                           
PFX805             ,CAST(SA.INT_DISP_START_TS AS DATE)                          
PFX805             ,CAST(SA.INT_DISP_END_TS AS DATE)                            
               FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                 
                   ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                 
                   ,CRM_RT_PKG_OPTION  RT WITH(READUNCOMMITTED)                 
              WHERE HQ.OPTION_CD           = :HQ-OPTION-CD              
                AND HQ.OPTION_CD           = RT.OPTION_CD               
                AND HQ.COMPANY_NO          = RT.COMPANY_NO              
                AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'              
                AND HQ.COMPANY_NO          = '01'                       
P00141          AND HQ.ATTR_INCTV_STRT_DT  <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00141          AND HQ.ATTR_INCTV_END_DT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00473          AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CURRENT$TIMESTAMP()         
P00473          AND HQ.OPT_ATTR_VEND_TS    >= CIS.CURRENT$TIMESTAMP()         
P00473          AND HQ.PROC_STATUS_CD       = 'AC'                      
                AND SA.CODE_UTIL_TYPE      = 'G'                        
                AND SA.FACTOR_ID           = HQ.FACTOR_ID               
                AND SA.RATE_PLAN_NO        = RT.RATE_PLAN_NO            
                AND SA.CODE_STATUS         = 'A'                        
                AND SA.INT_DISP_START_TS   <= CIS.CURRENT$TIMESTAMP()         
P00473          AND RT.OPT_VSTART_TS       <= CIS.CURRENT$TIMESTAMP()         
P00473          AND RT.OPT_VEND_TS         >= CIS.CURRENT$TIMESTAMP()         
P00473          AND RT.PROC_STATUS_CD       = 'AC'                      
              ORDER BY SA.DATE_FROM DESC                                
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE INT_DISP_CUR  CURSOR FOR                                    
MFA-TR*      SELECT SA.FACTOR                                                   
MFA-TR*            ,DATE(SA.INT_DISP_START_TS)                                  
MFA-TR*            ,DATE(SA.INT_DISP_END_TS)                                    
MFA-TR*        FROM CSS_SPCL_FCTR_APPL SA                                       
MFA-TR*            ,CRM_OPT_ATTR_INCTV HQ                                       
MFA-TR*            ,CRM_RT_PKG_OPTION  RT                                       
MFA-TR*       WHERE HQ.OPTION_CD           = :HQ-OPTION-CD                      
MFA-TR*         AND HQ.OPTION_CD           = RT.OPTION_CD                       
MFA-TR*         AND HQ.COMPANY_NO          = RT.COMPANY_NO                      
MFA-TR*         AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                      
MFA-TR*         AND HQ.COMPANY_NO          = '01'                               
MFA-TR*         AND HQ.ATTR_INCTV_STRT_DT  <= CURRENT DATE                      
MFA-TR*         AND HQ.ATTR_INCTV_END_DT   >= CURRENT DATE                      
MFA-TR*         AND HQ.OPT_ATTR_VSTART_TS  <= CURRENT TIMESTAMP                 
MFA-TR*         AND HQ.OPT_ATTR_VEND_TS    >= CURRENT TIMESTAMP                 
MFA-TR*         AND HQ.PROC_STATUS_CD       = 'AC'                              
MFA-TR*         AND SA.CODE_UTIL_TYPE      = 'G'                                
MFA-TR*         AND SA.FACTOR_ID           = HQ.FACTOR_ID                       
MFA-TR*         AND SA.RATE_PLAN_NO        = RT.RATE_PLAN_NO                    
MFA-TR*         AND SA.CODE_STATUS         = 'A'                                
MFA-TR*         AND SA.INT_DISP_START_TS   <= CURRENT TIMESTAMP                 
MFA-TR*         AND RT.OPT_VSTART_TS       <= CURRENT TIMESTAMP                 
MFA-TR*         AND RT.OPT_VEND_TS         >= CURRENT TIMESTAMP                 
MFA-TR*         AND RT.PROC_STATUS_CD       = 'AC'                              
MFA-TR*       ORDER BY SA.DATE_FROM DESC                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * CURSOR TO GET EXT FACTORS                                      *        
      *----------------------------------------------------------------*        
      *                                                                         
           EXEC SQL                                                     
            DECLARE EXT_DISP_CUR  CURSOR FOR                            
             SELECT SA.FACTOR                                           
               FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                 
                   ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                 
                   ,CRM_RT_PKG_OPTION  RT WITH(READUNCOMMITTED)                 
              WHERE HQ.OPTION_CD           = :HQ-OPTION-CD              
                AND HQ.OPTION_CD           = RT.OPTION_CD               
                AND HQ.COMPANY_NO          = RT.COMPANY_NO              
                AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'              
                AND HQ.COMPANY_NO          = '01'                       
P00141          AND HQ.ATTR_INCTV_STRT_DT  <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00141          AND HQ.ATTR_INCTV_END_DT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00473          AND HQ.OPT_ATTR_VSTART_TS  <= CIS.CURRENT$TIMESTAMP()         
P00473          AND HQ.OPT_ATTR_VEND_TS    >= CIS.CURRENT$TIMESTAMP()         
P00473          AND HQ.PROC_STATUS_CD       = 'AC'                      
                AND SA.CODE_UTIL_TYPE      = 'G'                        
                AND SA.FACTOR_ID           = HQ.FACTOR_ID               
                AND SA.RATE_PLAN_NO        = RT.RATE_PLAN_NO            
                AND SA.CODE_STATUS         = 'A'                        
                AND SA.EXT_DISP_START_TS   <= CIS.CURRENT$TIMESTAMP()         
                AND SA.EXT_DISP_END_TS     >= CIS.CURRENT$TIMESTAMP()         
P00473          AND RT.OPT_VSTART_TS       <= CIS.CURRENT$TIMESTAMP()         
P00473          AND RT.OPT_VEND_TS         >= CIS.CURRENT$TIMESTAMP()         
P00473          AND RT.PROC_STATUS_CD       = 'AC'                      
              ORDER BY SA.DATE_FROM DESC                                
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE EXT_DISP_CUR  CURSOR FOR                                    
MFA-TR*      SELECT SA.FACTOR                                                   
MFA-TR*        FROM CSS_SPCL_FCTR_APPL SA                                       
MFA-TR*            ,CRM_OPT_ATTR_INCTV HQ                                       
MFA-TR*            ,CRM_RT_PKG_OPTION  RT                                       
MFA-TR*       WHERE HQ.OPTION_CD           = :HQ-OPTION-CD                      
MFA-TR*         AND HQ.OPTION_CD           = RT.OPTION_CD                       
MFA-TR*         AND HQ.COMPANY_NO          = RT.COMPANY_NO                      
MFA-TR*         AND HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'                      
MFA-TR*         AND HQ.COMPANY_NO          = '01'                               
MFA-TR*         AND HQ.ATTR_INCTV_STRT_DT  <= CURRENT DATE                      
MFA-TR*         AND HQ.ATTR_INCTV_END_DT   >= CURRENT DATE                      
MFA-TR*         AND HQ.OPT_ATTR_VSTART_TS  <= CURRENT TIMESTAMP                 
MFA-TR*         AND HQ.OPT_ATTR_VEND_TS    >= CURRENT TIMESTAMP                 
MFA-TR*         AND HQ.PROC_STATUS_CD       = 'AC'                              
MFA-TR*         AND SA.CODE_UTIL_TYPE      = 'G'                                
MFA-TR*         AND SA.FACTOR_ID           = HQ.FACTOR_ID                       
MFA-TR*         AND SA.RATE_PLAN_NO        = RT.RATE_PLAN_NO                    
MFA-TR*         AND SA.CODE_STATUS         = 'A'                                
MFA-TR*         AND SA.EXT_DISP_START_TS   <= CURRENT TIMESTAMP                 
MFA-TR*         AND SA.EXT_DISP_END_TS     >= CURRENT TIMESTAMP                 
MFA-TR*         AND RT.OPT_VSTART_TS       <= CURRENT TIMESTAMP                 
MFA-TR*         AND RT.OPT_VEND_TS         >= CURRENT TIMESTAMP                 
MFA-TR*         AND RT.PROC_STATUS_CD       = 'AC'                              
MFA-TR*       ORDER BY SA.DATE_FROM DESC                                        
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  LINK-OPTION-CD                PIC X(12).                     
       01  LINK-INT-EXT-FL               PIC X(01).                     
COB305 01 LINK-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
                                                                        
       PROCEDURE DIVISION USING LINK-OPTION-CD                          
                                LINK-INT-EXT-FL                         
P00805                          LINK-ACCOUNT-NO.                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER    THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INIT-SERVER.                                                
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
               SELECT                                                   
                  RETURN_CODE                 AS RETURN_CODE            
                 ,THERM_PRICE                 AS THERM_PRICE            
                FROM #CSR04128_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                 AS RETURN_CODE                    
MFA-TR*          ,THERM_PRICE                 AS THERM_PRICE                    
MFA-TR*         FROM SESSION.CSR04128_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           PERFORM 0100A-DECLARE-GTT                                    
              THRU 0100A-EXIT                                           
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04128_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04128_R1
              (                                                          
               RETURN_CODE         INT                              
              ,THERM_PRICE         DECIMAL(9,6)                         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04128_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-OPTION-CD           TO PARM-OPTION-CD              
                                            FI-OPTION-CD                
                                            HQ-OPTION-CD                
           MOVE LINK-INT-EXT-FL          TO PARM-INT-EXT-FL.            
                                                                        
P00805     MOVE LINK-ACCOUNT-NO          TO PARM-ACCOUNT-NO             
P00805                                      AT-ACCOUNT-NO               
P00805                                      BG-ACCOUNT-NO               
P00805                                      LR-ACCOUNT-NO.              
P00805     MOVE 'G'                      TO UT-CODE-UTIL-TYPE.          
P00805     MOVE 01                       TO UT-IC-NO.                   
P00805     PERFORM 1100-GET-DELINQ-VALUE       THRU 1100-EXIT.          
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00805*****************************************************************         
P00805* 1100-GET-DELINQ-VALUE                                         *         
P00805*****************************************************************         
P00805 1100-GET-DELINQ-VALUE.                                           
P00805                                                                  
P00805* SET PROCESS FLAG                                                        
P00805     IF PARM-ACCOUNT-NO > ZERO                                    
P00805        MOVE 'Y'                      TO WS-ACCOUNT-PRCS          
P00805     ELSE                                                         
P00805        MOVE 'N'                      TO WS-ACCOUNT-PRCS          
P00805     END-IF.                                                      
P00805* GET MONTHS TO RENEW FOR REG AND DREG ACCOUNT FROM DELINQUENCY           
P00805     PERFORM 7010-GET-REG-PROFILE           THRU 7010-EXIT.       
P00805*                                                                         
P00805     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00805        MOVE WS-REG-LIMIT-DELINQ-CD   TO C8-DELINQ-CD             
P00805     ELSE                                                         
P00805        MOVE WS-DREG-LIMIT-DELINQ-CD  TO C8-DELINQ-CD             
P00805     END-IF.                                                      
P00805*                                                                         
P00805     MOVE '01'                        TO C8-COMPANY-NO.           
P00805     PERFORM 7000-SELECT-DELINQ-VALUE       THRU 7000-EXIT.       
P00805     MOVE C8-DELINQ-VALUE             TO WS-MONTHS-TO-RENEW.      
P00805     MOVE SPACES                      TO C8-DELINQ-CD.            
P00805     MOVE ZERO                        TO C8-DELINQ-VALUE.         
P00805*GET LIMIT VALUE FOR NO ACCOUNT PROCESS                                   
P00805     MOVE '01'                        TO C8-COMPANY-NO.           
P00805     MOVE WS-LIMIT-DELINQ-CD          TO C8-DELINQ-CD.            
P00805     PERFORM 7000-SELECT-DELINQ-VALUE       THRU 7000-EXIT.       
P00805     MOVE C8-DELINQ-VALUE             TO WS-LIMIT-DELINQ-VALUE.   
P00805     .                                                            
P00805 1100-EXIT.                                                       
P00805     EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
P00805     IF ACCOUNT-PRCS                                              
P00805        PERFORM 2010-ACCOUNT-PROCESS        THRU 2010-EXIT        
P00805     END-IF                                                       
           PERFORM 2100-BUILD-RESULT              THRU 2100-EXIT        
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE           TO S-RETURN-CODE               
           MOVE WS-THERM-PRICE           TO S-THERM-PRICE               
           .                                                            
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
P00805*****************************************************************         
P00805* 2010-ACCOUNT-PROCESS                                          *         
P00805*****************************************************************         
P00805 2010-ACCOUNT-PROCESS.                                            
P00805                                                                  
P00805* GET OPTION-CD,REV MONTH AND DURATION REMAINING                          
P00805     PERFORM 7020-GET-OPTION-CODE           THRU 7020-EXIT.       
P00805                                                                  
P00805* GET CALCULATED REVENUE MONTH WHEN REVENUE MONTH > 0                     
P00805* SELECT LAST THREE PRICES FOR REVENUE MONTH = 0                          
P00805*                                                                         
P00805     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00805        IF AT-REV-MTH-LST-NRML GREATER THAN WS-ZERO               
P00805           MOVE FF-DURATION-REMAIN-NO TO WS-DURATION-REMAIN-NO    
P00805           PERFORM 2020-GET-CALC-REVENUE-MON THRU 2020-EXIT       
P00805        ELSE                                                      
P00805           SET NO-ACCOUNT-PRCS        TO TRUE                     
P00805        END-IF                                                    
P00805     ELSE                                                         
P00805        SET NO-ACCOUNT-PRCS           TO TRUE                     
P00805     END-IF.                                                      
P00805                                                                  
P00805 2010-EXIT.                                                       
P00805     EXIT.                                                        
P00805                                                                  
P00805*****************************************************************         
P00805* 2020-GET-CALC-REVENUE-MON                                     *         
P00805*****************************************************************         
P00805 2020-GET-CALC-REVENUE-MON.                                       
P00805                                                                  
P00805     MOVE AT-REV-MTH-LST-NRML         TO WS-TEMP-REV-MONTH.       
P00805     COMPUTE WS-DURATION-COUNTER = (WS-DURATION-REMAIN-NO -       
P00805                                    WS-MONTHS-TO-RENEW) * - 1.    
P00805     PERFORM WS-DURATION-COUNTER      TIMES                       
P00805         COMPUTE WS-MONTH = WS-MONTH  - 1                         
P00805         IF WS-MONTH = WS-ZERO                                    
P00805            COMPUTE WS-YEAR = WS-YEAR - 1                         
P00805            MOVE 12                   TO WS-MONTH                 
P00805         END-IF                                                   
P00805         COMPUTE WS-DURATION-COUNTER = WS-DURATION-COUNTER - 1    
P00805     END-PERFORM.                                                 
P00805     MOVE WS-TEMP-REV-MONTH           TO BG-REVENUE-MONTH.        
P00805     MOVE SPACES                      TO BG-DATE-ORIG-BILL        
P00805                                         BI-DATE-BILLED.          
P00805     PERFORM 7030-GET-DATE-BILLED           THRU 7030-EXIT.       
P00805                                                                  
P00805     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00805        IF BG-DATE-ORIG-BILL GREATER THAN SPACES                  
P00805           MOVE BG-DATE-ORIG-BILL     TO WS-BILLED-DATE           
P00805        ELSE                                                      
P00805           MOVE BI-DATE-BILLED        TO WS-BILLED-DATE           
P00805        END-IF                                                    
P00805     END-IF.                                                      
P00805     .                                                            
P00805 2020-EXIT.                                                       
P00805     EXIT.                                                        
                                                                        
       2100-BUILD-RESULT.                                               
      *                                                                         
      *    IF PARM-INT-EXT-FL = 'I'                                             
              SET NO-PRICE-CUT-OFF          TO TRUE                     
              PERFORM 7100-OPEN-INT-DISP-CUR      THRU 7100-EXIT        
              PERFORM 7110-FETCH-INT-DISP-CUR     THRU 7110-EXIT        
                                                                        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT       
                 PERFORM 8100-SEND-RESULT         THRU 8100-EXIT        
P00805        ELSE                                                      
P00805           IF ACCOUNT-PRCS                                        
P00805              PERFORM 2110-PROCESS-INT-DISP THRU 2110-EXIT        
P00805                 UNTIL NO-ROWS-FOUND OR PRICE-CUT-OFF             
P00805           ELSE                                                   
P00805              PERFORM 2110-PROCESS-INT-DISP THRU 2110-EXIT        
P00805                 UNTIL NO-ROWS-FOUND OR                           
P00805                       CTR-ROWS >= WS-LIMIT-DELINQ-VALUE          
P00805           END-IF                                                 
P00805        END-IF                                                    
P00805                                                                  
P00805        PERFORM 7120-CLOSE-INT-DISP-CUR     THRU 7120-EXIT        
                                                                        
      *    ELSE                                                                 
      *                                                                         
      *       PERFORM 7200-OPEN-EXT-DISP-CUR   THRU 7200-EXIT                   
      *       PERFORM 7210-FETCH-EXT-DISP-CUR  THRU 7210-EXIT                   
      *                                                                         
      *       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                              
      *          PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT                  
      *          PERFORM 8100-SEND-RESULT      THRU 8100-EXIT                   
      *       END-IF                                                            
      *                                                                         
      *       PERFORM 2210-PROCESS-EXT-DISP    THRU 2210-EXIT                   
      *         UNTIL NO-ROWS-FOUND                                             
      *       PERFORM 7220-CLOSE-EXT-DISP-CUR  THRU 7220-EXIT                   
      *                                                                         
      *    END-IF                                                               
      *                                                                         
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2110-PROCESS-INT-DISP.                                           
                                                                        
P00805*                                                                         
P00805     IF ACCOUNT-PRCS                                              
P00805        IF SA-DATE-FROM >= WS-BILLED-DATE                         
P00805           CONTINUE                                               
P00805        ELSE                                                      
P00805           IF SA-DATE-TO >= WS-BILLED-DATE                        
P00805              CONTINUE                                            
P00805           ELSE                                                   
P00805              SET PRICE-CUT-OFF       TO TRUE                     
P00805           END-IF                                                 
P00805        END-IF                                                    
P00805     END-IF.                                                      
P00805*                                                                         
P00805     IF NO-PRICE-CUT-OFF OR NO-ACCOUNT-PRCS                       
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF                                                       
                                                                        
           PERFORM 7110-FETCH-INT-DISP-CUR        THRU 7110-EXIT        
      *                                                                         
           .                                                            
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2210-PROCESS-EXT-DISP.                                           
                                                                        
           IF CTR-ROWS < WS-LIMIT-DELINQ-VALUE                          
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF                                                       
                                                                        
           PERFORM 7210-FETCH-EXT-DISP-CUR     THRU 7210-EXIT           
      *                                                                         
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7000-SELECT-DELINQ-VALUE                                      *         
      *****************************************************************         
       7000-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD    = :C8-DELINQ-CD                       
                 AND COMPANY_NO   = :C8-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE SQLSTATE            TO ABEND-SQLSTATE                
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_DELINQUENCY'   TO TABLE-1                       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
P00805*                                                                         
P00805*****************************************************************         
P00805* 7010-GET-REG-PROFILE                                          *         
P00805*****************************************************************         
P00805 7010-GET-REG-PROFILE.                                            
P00805*****************************************************************         
P00805     EXEC SQL                                                     
P00805        SELECT LR.ACCOUNT_NO                                      
P00805          INTO :LR-ACCOUNT-NO                                     
P00805          FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                   
P00805         WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                     
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LR.ACCOUNT_NO                                              
MFA-TR*         INTO :LR-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_REG_PROFILE LR                                         
MFA-TR*        WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00805                                                                  
P00805     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00805        CONTINUE                                                  
P00805     ELSE                                                         
P00805        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00805        MOVE SQLCODE             TO ABEND-SQLCODE                 
P00805        MOVE SQLSTATE            TO ABEND-SQLSTATE                
P00805        MOVE '7010'              TO ACTIVE-PARAGRAPH              
P00805        MOVE 'SELECT'            TO ABEND-FUNCTION                
P00805        MOVE 'CSS_REG_PROFILE'   TO TABLE-1                       
P00805        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
P00805        MOVE  LR-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1             
P00805        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00805     END-IF                                                       
P00805     .                                                            
P00805 7010-EXIT.                                                       
P00805     EXIT.                                                        
P00805*****************************************************************         
P00805* 7020-GET-OPTION-CODE                                          *         
P00805*****************************************************************         
P00805 7020-GET-OPTION-CODE.                                            
P00805*                                                                         
P00805     EXEC SQL                                                     
P00805        SELECT TOP(1) AT.REV_MTH_LST_NRML,
              DF.OPTION_CD,
              COALESCE(FF.DURATION_REMAIN_NO,0)                    
P00805          INTO :AT-REV-MTH-LST-NRML                               
P00805              ,:DF-OPTION-CD                                      
P00805              ,:FF-DURATION-REMAIN-NO                             
P00805          FROM CSS_ACCOUNT         AT WITH(READUNCOMMITTED)               
P00805              ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)               
P00805              ,CSS_ACCT_RTPK_AGR   DF WITH(READUNCOMMITTED)               
P00805              ,CSS_FIXED_FCTR      FF WITH(READUNCOMMITTED)               
P00805              ,CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)               
P00805         WHERE AT.ACCOUNT_NO         =  :AT-ACCOUNT-NO            
P00805           AND UT.CODE_UTIL_TYPE     =  :UT-CODE-UTIL-TYPE        
P00805           AND UT.IC_NO              =  :UT-IC-NO                 
P00805           AND UT.ACCOUNT_NO         =  AT.ACCOUNT_NO             
P00805           AND DF.ACCOUNT_NO         =  AT.ACCOUNT_NO             
P00805           AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE         
P00805           AND DF.IC_NO              =  UT.IC_NO                  
P00805           AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO      
P00805           AND FF.ACCOUNT_NO         =  DF.ACCOUNT_NO             
P00805           AND FF.CODE_UTIL_TYPE     =  DF.CODE_UTIL_TYPE         
P00805           AND FF.IC_NO              =  DF.IC_NO                  
P00805           AND FF.RT_PKG_OPT_SEQ_NO  =  DF.RT_PKG_OPT_SEQ_NO      
P00805           AND HQ.FACTOR_ID          =  FF.FACTOR_ID              
P00805           AND HQ.OPTION_CD          =  DF.OPTION_CD              
P00805           AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT       
P00805           AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT       
P00805           AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'             
P00805           AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                       
P00805           AND HQ.PROC_STATUS_CD     =  'AC'                      
P00805           AND HQ.OPT_ATTR_VSTART_TS = (                          
P00805               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00805                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00805                WHERE H1.OPTION_CD         = HQ.OPTION_CD         
P00805                  AND H1.RT_ATTR_INCTV_TYPE                       
P00805                                           = HQ.RT_ATTR_INCTV_TYPE
P00805                  AND H1.ATTR_INCTV_STRT_DT                       
P00805                                           <= DF.OPT_AGRMT_EFF_DT 
P00805                  AND H1.ATTR_INCTV_END_DT                        
P00805                                           >= DF.OPT_AGRMT_EFF_DT 
P00805                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00805                                           <= DF.OPT_AGRMT_EFF_DT 
P00805                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00805                                            >= DF.OPT_AGRMT_EFF_DT
P00805                  AND H1.PROC_STATUS_CD  = 'AC')                  
P00805         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                      
P00805                 ,FF.EFF_DATE_FROM      DESC                      
P00805                                       
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,DF.OPTION_CD                                               
MFA-TR*             ,IFNULL(FF.DURATION_REMAIN_NO,0)                            
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:DF-OPTION-CD                                              
MFA-TR*             ,:FF-DURATION-REMAIN-NO                                     
MFA-TR*         FROM CSS_ACCOUNT         AT                                     
MFA-TR*             ,CSS_UTIL_ENVRNMT    UT                                     
MFA-TR*             ,CSS_ACCT_RTPK_AGR   DF                                     
MFA-TR*             ,CSS_FIXED_FCTR      FF                                     
MFA-TR*             ,CRM_OPT_ATTR_INCTV  HQ                                     
MFA-TR*        WHERE AT.ACCOUNT_NO         =  :AT-ACCOUNT-NO                    
MFA-TR*          AND UT.CODE_UTIL_TYPE     =  :UT-CODE-UTIL-TYPE                
MFA-TR*          AND UT.IC_NO              =  :UT-IC-NO                         
MFA-TR*          AND UT.ACCOUNT_NO         =  AT.ACCOUNT_NO                     
MFA-TR*          AND DF.ACCOUNT_NO         =  AT.ACCOUNT_NO                     
MFA-TR*          AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                 
MFA-TR*          AND DF.IC_NO              =  UT.IC_NO                          
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO              
MFA-TR*          AND FF.ACCOUNT_NO         =  DF.ACCOUNT_NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     =  DF.CODE_UTIL_TYPE                 
MFA-TR*          AND FF.IC_NO              =  DF.IC_NO                          
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  =  DF.RT_PKG_OPT_SEQ_NO              
MFA-TR*          AND HQ.FACTOR_ID          =  FF.FACTOR_ID                      
MFA-TR*          AND HQ.OPTION_CD          =  DF.OPTION_CD                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT               
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT               
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                     
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                               
MFA-TR*          AND HQ.PROC_STATUS_CD     =  'AC'                              
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS = (                                  
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD         = HQ.OPTION_CD                 
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                          = HQ.RT_ATTR_INCTV_TYPE        
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                          <= DF.OPT_AGRMT_EFF_DT         
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                          >= DF.OPT_AGRMT_EFF_DT         
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                          <= DF.OPT_AGRMT_EFF_DT         
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                           >= DF.OPT_AGRMT_EFF_DT        
MFA-TR*                 AND H1.PROC_STATUS_CD  = 'AC')                          
MFA-TR*        ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                              
MFA-TR*                ,FF.EFF_DATE_FROM      DESC                              
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00805                                                                  
P00805     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00805         WHEN SUCCESSFUL-CALL                                     
P00805              CONTINUE                                            
P00805         WHEN NOT-FOUND                                           
P00805              CONTINUE                                            
P00805         WHEN OTHER                                               
P00805              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
P00805              MOVE SQLCODE             TO ABEND-SQLCODE           
P00805              MOVE SQLSTATE            TO ABEND-SQLSTATE          
P00805              MOVE '7020'              TO ACTIVE-PARAGRAPH        
P00805              MOVE 'SELECT'            TO ABEND-FUNCTION          
P00805              MOVE 'CSS_ACCOUNT'       TO TABLE-1                 
P00805              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1         
P00805              MOVE  AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1       
P00805              MOVE 'CSS_FIXED_FCTR'    TO TABLE-2                 
P00805              MOVE 'DURATION_REMAIN_NO'                           
P00805                                       TO TABLE-ELEMENT-2         
P00805              MOVE  FF-DURATION-REMAIN-NO                         
P00805                                       TO HOSTVAR-ELEMENT-2       
P00805              MOVE 'CRM_OPT_ATTR_INCTV'                           
P00805                                       TO TABLE-3                 
P00805              MOVE 'OPTION_CD'         TO TABLE-ELEMENT-3         
P00805              MOVE  HQ-OPTION-CD       TO HOSTVAR-ELEMENT-3       
P00805              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
P00805     END-EVALUATE                                                 
P00805     .                                                            
P00805 7020-EXIT.                                                       
P00805     EXIT.                                                        
P00805*                                                                         
P00805*****************************************************************         
P00805*                                                               *         
P00805* 7030-GET-DATE-BILLED                                          *         
P00805*****************************************************************         
P00805  7030-GET-DATE-BILLED.                                           
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT TOP(1) BI.DATE_BILLED,
              BG.DATE_ORIG_BILL,
              BG.BILL_NO                                         
P00805          INTO :BI-DATE-BILLED :WS-NULL-INDICATOR-1                
P00805              ,:BG-DATE-ORIG-BILL :WS-NULL-INDICATOR-2             
P00805              ,:BG-BILL-NO                                        
P00805          FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
P00805              ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
P00805         WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
P00805           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              
P00805           AND BI.BILL_NO            = BG.BILL_NO                 
P00805           AND BG.CODE_BILL_CALC     = 'A'                        
P00805           AND BG.CODE_BILL_ITM_TYPE = 'C'                        
P00805           AND BG.CODE_BILL_ITM_IND  = 'A'                        
P00805           AND (BG.REVENUE_MONTH     = :BG-REVENUE-MONTH          
P00805            OR BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH )        
P00805                                              
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BI.DATE_BILLED                                             
MFA-TR*             ,BG.DATE_ORIG_BILL                                          
MFA-TR*             ,BG.BILL_NO                                                 
MFA-TR*         INTO :BI-DATE-BILLED:WS-NULL-INDICATOR-1                        
MFA-TR*             ,:BG-DATE-ORIG-BILL:WS-NULL-INDICATOR-2                     
MFA-TR*             ,:BG-BILL-NO                                                
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*          AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BI.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*          AND (BG.REVENUE_MONTH     = :BG-REVENUE-MONTH                  
MFA-TR*           OR BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH )                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00805                                                                  
P00805     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00805        IF WS-NULL-INDICATOR-1 < 0                                
P00805          MOVE SPACES                 TO BI-DATE-BILLED           
P00805        END-IF                                                    
P00805        IF WS-NULL-INDICATOR-2 < 0                                
P00805          MOVE SPACES                 TO BG-DATE-ORIG-BILL        
P00805        END-IF                                                    
P00805     ELSE                                                         
P00805        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00805        MOVE '7030'                    TO ACTIVE-PARAGRAPH        
P00805        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00805        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
P00805        MOVE 'CSS_BILLING_HDR'         TO TABLE-2                 
P00805        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00805        MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-2         
P00805        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00805        MOVE BG-REVENUE-MONTH          TO HOSTVAR-ELEMENT-2       
P00805        PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
P00805     END-IF.                                                      
P00805                                                                  
P00805 7030-EXIT.                                                       
P00805     EXIT.                                                        
      *                                                                         
       7100-OPEN-INT-DISP-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN INT_DISP_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '7100'               TO ACTIVE-PARAGRAPH            
               MOVE 'OPEN'               TO ABEND-FUNCTION              
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'CRM_OPT_ATTR_INCTV' TO TABLE-2                     
               MOVE 'OPTION_CD'          TO TABLE-ELEMENT-1             
               MOVE HQ-OPTION-CD         TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7110-FETCH-INT-DISP-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH INT_DISP_CUR                                      
                 INTO :SA-FACTOR                                        
P00805               ,:SA-DATE-FROM                                     
P00805               ,:SA-DATE-TO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE SA-FACTOR              TO WS-THERM-PRICE        
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-NO-ROWS            
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7110'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_SPCL_FCTR_APPL'   TO TABLE-1               
                   MOVE 'CRM_OPT_ATTR_INCTV'   TO TABLE-2               
                   MOVE 'OPTION_CD'            TO TABLE-ELEMENT-1       
                   MOVE HQ-OPTION-CD           TO HOSTVAR-ELEMENT-1     
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
           .                                                            
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7120-CLOSE-INT-DISP-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE INT_DISP_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '7120'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'CRM_OPT_ATTR_INCTV' TO TABLE-2                     
               MOVE 'OPTION_CD'          TO TABLE-ELEMENT-1             
               MOVE HQ-OPTION-CD         TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
           .                                                            
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7200-OPEN-EXT-DISP-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN EXT_DISP_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '7200'               TO ACTIVE-PARAGRAPH            
               MOVE 'OPEN'               TO ABEND-FUNCTION              
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'CRM_OPT_ATTR_INCTV' TO TABLE-2                     
               MOVE 'OPTION_CD'          TO TABLE-ELEMENT-1             
               MOVE HQ-OPTION-CD         TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7210-FETCH-EXT-DISP-CUR.                                         
      *                                                                         
           EXEC SQL                                                     
                FETCH EXT_DISP_CUR                                      
                 INTO :SA-FACTOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                         RS-RETURN-CODE.                
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE SA-FACTOR              TO WS-THERM-PRICE        
              WHEN NOT-FOUND                                            
                   MOVE 'Y'                    TO WS-NO-ROWS            
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7210'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE 'CSS_SPCL_FCTR_APPL'   TO TABLE-1               
                   MOVE 'CRM_OPT_ATTR_INCTV'   TO TABLE-2               
                   MOVE 'OPTION_CD'            TO TABLE-ELEMENT-1       
                   MOVE HQ-OPTION-CD           TO HOSTVAR-ELEMENT-1     
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
      *                                                                         
           .                                                            
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7220-CLOSE-EXT-DISP-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE EXT_DISP_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '7220'               TO ACTIVE-PARAGRAPH            
               MOVE 'CLOSE'              TO ABEND-FUNCTION              
               MOVE 'CSS_SPCL_FCTR_APPL' TO TABLE-1                     
               MOVE 'CRM_OPT_ATTR_INCTV' TO TABLE-2                     
               MOVE 'OPTION_CD'          TO TABLE-ELEMENT-1             
               MOVE HQ-OPTION-CD         TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
           .                                                            
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04128_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04128_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04128_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNAL INCLUDE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04128_R1                            
             (                                                          
              RETURN_CODE                                               
             ,THERM_PRICE                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-THERM-PRICE                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04128_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,THERM_PRICE                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-THERM-PRICE                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE SQLSTATE            TO ABEND-SQLSTATE                
              MOVE '8100'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSR04128_R1'       TO TABLE-1                       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *   END PROGRAM COPYLIB                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
      *                                                                         
