                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04127.                                            
       DATE-WRITTEN. 02/05/08.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CSR      *        
      *  DESKTOP                                                       *        
      *                                                                *        
      *  THIS PROGRAM IS USED BY PANEL284 (INSERT NEW PLACEMENTS).     *        
      *  THIS RETRIEVES THE FUTURE CREDIT BUREAU DATE FOR THE ACCOUNT  *        
      *  ALONG WITH THE DEFAULT WITHDRAW DAYS.                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/05/08  CVNS       INITIAL VERSION                          *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04127'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR04127 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * F8 - CSS_FW_FCST_ACTION                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFWPDTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * KD - CSS_FIN_WO_ACTION                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * G6 - CSS_JOB_PARM                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)  VALUE 'CSR04127'.      
           05  WS-COMPANY-NO           PIC X(02).                       
           05  WS-REG-GROUP-CD         PIC X(03).                       
           05  WS-PARM-DATA            PIC X(80).                       
           05  WS-LAST-RUN-DATE-PARM.                                   
               10 FILLER               PIC X(14) VALUE 'LAST RUN DATE='.
               10 WS-LAST-RUN-DATE     PIC X(10) VALUE SPACES.          
               10 FILLER               PIC X(56) VALUE SPACES.          
           05  WS-SEQ-NO               PIC S9(9) COMP VALUE 0.          
           05  WS-FIRST-RUN-DATE       PIC X(80) VALUE SPACES.          
           05  WS-ACT-RUN-DATE         PIC X(80) VALUE SPACES.          
           05  WS-FW-RUN-DATE          PIC X(80) VALUE SPACES.          
           05  WS-RUN-DATE1            PIC X(80) VALUE SPACES.          
           05  WS-RUN-DATE2            PIC X(80) VALUE SPACES.          
           05  WS-FIN-RUN-DATE         PIC X(80) VALUE SPACES.          
           05  WS-FINAL-RUN-DATE       PIC X(10) VALUE SPACES.          
           05  WS-COUNT-FLAG           PIC X(01) VALUE SPACE.           
           05  WS-COUNT                PIC S9(4) VALUE 0.               
           05  WS-DATE-CHK             PIC S9(2) VALUE 0.               
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-ACCT-NO              PIC X(13).                       
           05  WS-ACCT-NO-NUM          REDEFINES WS-ACCT-NO             
                                       PIC 9(13).                       
COB305     05 WS-ACCT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.              
           05  WS-ACTION-TYPE          PIC X(05).                       
           05  WS-ACTION-DT            PIC X(10).                       
           05  WS-CREDB-FL             PIC X(01).                       
COB305     05 WS-ACTION-DAYS-NM        PIC S9(5)V USAGE COMP-3 VALUE 0.         
      *                                                                         
       01  CN-CONSTANTS.                                                
           05  CN-EQUAL                PIC X VALUE '='.                 
           05  CN-SPACES               PIC X VALUE SPACES.              
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-CREDB-FL              PIC X(01) VALUE SPACES.          
           05  S-LAST-RUN-DT           PIC X(10) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      *01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCT-NO       PIC X(13).                                
       01  PARM-COMPANY-NO    PIC X(02).                                
       01  PARM-REG-GROUP-CD  PIC X(03).                                
                                                                        
       PROCEDURE DIVISION USING PARM-ACCT-NO                            
                                PARM-COMPANY-NO                         
                                PARM-REG-GROUP-CD.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE         THRU 0100-EXIT.             
            PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.             
            PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT.             
            PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL                                                    
                WHENEVER SQLWARNING CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER SQLERROR   CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER NOT FOUND  CONTINUE                            
            END-EXEC.                                                   
                                                                        
                                                                        
            EXEC SQL                                                    
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                     :S-RETURN-CODE                                     
                    ,:S-CREDB-FL                                        
                    ,:S-LAST-RUN-DT                                     
                FROM CIS.SYSDUMMY1                                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-CREDB-FL                                                
MFA-TR*             ,:S-LAST-RUN-DT                                             
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-ACCT-NO               TO WS-ACCT-NO.              
            MOVE PARM-COMPANY-NO            TO WS-COMPANY-NO.           
            MOVE PARM-REG-GROUP-CD          TO WS-REG-GROUP-CD.         
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            MOVE WS-ACCT-NO-NUM             TO WS-ACCT-NO-COMP3.        
                                                                        
            PERFORM 7000-SEL-ACTION-DAYS-NM THRU 7000-EXIT.             
            PERFORM 7010-GET-CURRENT-DATE   THRU 7010-EXIT.             
            PERFORM 7020-SEL-ACTION-DATE    THRU 7020-EXIT.             
                                                                        
            MOVE F8-FW-FCST-DAYS-NM         TO WS-ACTION-DAYS-NM.       
            MOVE KD-FW-ACTION-DT            TO WS-ACTION-DT.            
                                                                        
            PERFORM 5000-GET-LAST-RUN-DT    THRU 5000-EXIT.             
                                                                        
            IF WS-ACTION-DT > WS-CURRENT-DATE OR                        
               WS-ACTION-DT > WS-FINAL-RUN-DATE                         
               MOVE 'A'                     TO WS-CREDB-FL              
            ELSE                                                        
               MOVE 'B'                     TO WS-CREDB-FL              
            END-IF.                                                     
                                                                        
            ADD +1                          TO CTR-ROWS.                
            PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.            
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT.                                              *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
            MOVE  WS-ACTION-DAYS-NM         TO S-RETURN-CODE.           
            MOVE  WS-CREDB-FL               TO S-CREDB-FL.              
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5000-GET-LAST-RUN-DT.                                          *        
      ******************************************************************        
      *                                                                         
       5000-GET-LAST-RUN-DT.                                            
                                                                        
           IF WS-REG-GROUP-CD = '100' THEN                              
               MOVE +100                    TO WS-SEQ-NO                
           ELSE                                                         
              IF WS-REG-GROUP-CD = '200' THEN                           
                 MOVE +200                  TO WS-SEQ-NO                
              ELSE                                                      
                 MOVE +10                   TO WS-SEQ-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7040-SELECT-LAST-RUN-DT  THRU 7040-EXIT.             
                                                                        
           MOVE WS-PARM-DATA                TO WS-LAST-RUN-DATE-PARM.   
                                                                        
           MOVE WS-LAST-RUN-DATE            TO WS-FINAL-RUN-DATE        
                                               S-LAST-RUN-DT.           
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7000-SEL-ACTION-DAYS-NM                                        *        
      ******************************************************************        
      *                                                                         
       7000-SEL-ACTION-DAYS-NM.                                         
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FW_ACTION_TYPE_CD,
              FW_FCST_DAYS_NM                
                 INTO :F8-FW-ACTION-TYPE-CD,:F8-FW-FCST-DAYS-NM         
                 FROM CSS_FW_FCST_ACTION                                
                WHERE EFFECTIVE_DT   <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                  AND EXPIRATION_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                  AND FW_PATH_TYPE_CD = 'DE'                            
                  AND COMPANY_NO      = :WS-COMPANY-NO                  
                  AND REG_GROUP_CD    = :WS-REG-GROUP-CD                
                  AND FW_ACTION_TYPE_CD IN ('1PLWD','2PLWD','3PLWD')    
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FW_ACTION_TYPE_CD, FW_FCST_DAYS_NM                        
MFA-TR*          INTO :F8-FW-ACTION-TYPE-CD,:F8-FW-FCST-DAYS-NM                 
MFA-TR*          FROM CSS_FW_FCST_ACTION                                        
MFA-TR*         WHERE EFFECTIVE_DT   <= CURRENT DATE                            
MFA-TR*           AND EXPIRATION_DT  >= CURRENT DATE                            
MFA-TR*           AND FW_PATH_TYPE_CD = 'DE'                                    
MFA-TR*           AND COMPANY_NO      = :WS-COMPANY-NO                          
MFA-TR*           AND REG_GROUP_CD    = :WS-REG-GROUP-CD                        
MFA-TR*           AND FW_ACTION_TYPE_CD IN ('1PLWD','2PLWD','3PLWD')            
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                     TO F8-FW-FCST-DAYS-NM       
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FW_FCST_ACTION'     TO TABLE-1                  
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-1          
              MOVE 'REG_GROUP_CD'           TO TABLE-ELEMENT-2          
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-1        
              MOVE WS-REG-GROUP-CD          TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
      *                                                                         
       7010-GET-CURRENT-DATE.                                           
                                                                        
            EXEC SQL                                                    
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
            END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*     END-EXEC.                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                   
                                                                        
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7020-SEL-ACTION-DATE                                           *        
      ******************************************************************        
      *                                                                         
       7020-SEL-ACTION-DATE.                                            
           MOVE '7020'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FW_ACTION_DT                                      
                 INTO :KD-FW-ACTION-DT                                  
                 FROM CSS_FIN_WO_ACTION                                 
                WHERE ACCOUNT_NO        = :WS-ACCT-NO-COMP3             
                  AND FW_ACTION_TYPE_CD = 'CREDB'                       
                ORDER BY FW_SEQ_NO DESC                                 
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FW_ACTION_DT                                              
MFA-TR*          INTO :KD-FW-ACTION-DT                                          
MFA-TR*          FROM CSS_FIN_WO_ACTION                                         
MFA-TR*         WHERE ACCOUNT_NO        = :WS-ACCT-NO-COMP3                     
MFA-TR*           AND FW_ACTION_TYPE_CD = 'CREDB'                               
MFA-TR*         ORDER BY FW_SEQ_NO DESC                                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE '1900-01-01'          TO KD-FW-ACTION-DT          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIN_WO_ACTION'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'FW_ACTION_TYPE_CD'      TO TABLE-ELEMENT-2          
              MOVE WS-ACCT-NO               TO HOSTVAR-ELEMENT-1        
              MOVE 'CREDB'                  TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-SELECT-LAST-RUN-DT.                                       *        
      ******************************************************************        
      *                                                                         
       7040-SELECT-LAST-RUN-DT.                                         
      *                                                                         
            EXEC SQL                                                    
                SELECT TOP(1) PARM_DATA                                         
                INTO                                                    
                     :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    PROGRAM_NAME = 'PCSCA206'                           
                AND COMPANY_NO   = :WS-COMPANY-NO                       
                AND CMND_CODE    = 'PARM'                               
                AND STATUS       = 'A'                                  
                AND SEQ_NO       = :WS-SEQ-NO                           
                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*              PARM_DATA                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*         WHERE                                                           
MFA-TR*             PROGRAM_NAME = 'PCSCA206'                                   
MFA-TR*         AND COMPANY_NO   = :WS-COMPANY-NO                               
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SEQ_NO       = :WS-SEQ-NO                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7040'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_JOB_PARM'        TO TABLE-1                   
                MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'SEQ-NO'              TO TABLE-ELEMENT-3           
                MOVE 'PCSCA206'            TO HOSTVAR-ELEMENT-1         
                MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE WS-SEQ-NO             TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
