       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04126.                                     
COB303 DATE-WRITTEN.      MAR 19, 2008.                                 
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04126              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04126 :                                                --         
      *--                                                            --         
      *--    #  RETRIEVES AROP COMPLETED DATA FOR CURRENT DATE       --         
      *--    #  INVOKED FROM CRYSTAL REPORTING.                      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--      IN                                                    --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            DATE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  19 MAR 2008   DB18339     NEW CODE                        --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04126'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_LOCAL_OFFICE - B1                                                
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
                                                                        
      **** CSS_SO_DATA - VO                                                     
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_SO_ORDER_INST - VI                                               
           EXEC SQL                                                             
               INCLUDE TBSOODR                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_WORK_TYPE - L4                                                   
           EXEC SQL                                                             
               INCLUDE TBWKTYP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
       01  WS-WORK-ORDER-IND          PIC X(01)  VALUE 'N'.             
      *01  LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04126'.      
           05  WS-SQLSTATE             PIC X(05) VALUE  SPACES.         
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01 WS-COLUMNS.                                                   
          05 WS-NULL-1                   PIC S9(04) COMP VALUE +0.      
          05 WS-NULL-2                   PIC S9(04) COMP VALUE +0.      
          05 WS-GAS-IND                  PIC S9(4)  COMP VALUE 0.       
          05 WS-ELEC-IND                 PIC S9(4)  COMP VALUE 0.       
                                                                        
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           05 S-COMPANY-NO           PIC X(2).                          
           05 S-LOCAL-OFFICE         PIC X(3).                          
           05 S-LOCAL-OFFICE-DESC    PIC X(22).                         
           05 S-SERV-ORDER-NO        PIC S9(13) USAGE COMP-3 VALUE 0.   
           05 S-ACCOUNT-NO-PRIOR     PIC S9(13) USAGE COMP-3 VALUE 0.   
           05 S-WORK-AREA-ID         PIC X(12).                         
           05 S-AROP-IND             PIC S9(4) USAGE COMP.              
           05 S-AROI-IND             PIC S9(4) USAGE COMP.              
           05 S-AROC-IND             PIC S9(4) USAGE COMP.              
           05 S-RDO-IND              PIC S9(4) USAGE COMP.              
           05 S-COMPLETED-DT         PIC X(10).                         
           05 S-ORDER-STATE-CD       PIC X(1).                          
           05 S-GAS-IND              PIC S9(4) USAGE COMP.              
           05 S-ELEC-IND             PIC S9(4) USAGE COMP.              
           05 S-BOTH-IND             PIC S9(4) USAGE COMP.              
           05 S-AROP-GAS             PIC S9(4) USAGE COMP.              
           05 S-AROP-ELEC            PIC S9(4) USAGE COMP.              
           05 S-AROP-BOTH            PIC S9(4) USAGE COMP.              
           05 S-AROI-GAS             PIC S9(4) USAGE COMP.              
           05 S-AROI-ELEC            PIC S9(4) USAGE COMP.              
           05 S-AROI-BOTH            PIC S9(4) USAGE COMP.              
           05 S-AROC-GAS             PIC S9(4) USAGE COMP.              
           05 S-AROC-ELEC            PIC S9(4) USAGE COMP.              
           05 S-AROC-BOTH            PIC S9(4) USAGE COMP.              
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  ABEND-CODES.                                                 
           05  DATE-ERROR              PIC S9(9) VALUE -180 COMP.       
                                                                        
       01  WS-DATE-FIELDS.                                              
           05  WS-COMPLETED-DT         PIC X(10).                       
           05  WS-CURRENT-DT           PIC X(10).                       
           05  WS-CURRENT-TS           PIC X(26).                       
           05  WS-LAST-DT              PIC X(10).                       
           05  WS-LAST-TS              PIC X(26).                       
                                                                        
           05 WS-CUR-DT.                                                
              10 WS-CUR-YYYY       PIC X(4).                            
              10 WS-DT-SEP1        PIC X(1)       VALUE '-'.            
              10 WS-CUR-MM         PIC X(2).                            
              10 WS-DT-SEP2        PIC X(1)       VALUE '-'.            
              10 WS-CUR-DD         PIC X(2).                            
                                                                        
           05 WS-CUR-DT-MMDDYY     PIC X(10).                           
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE          PIC S9(9) VALUE 0 COMP.           
           05 RS-COMPANY-NO           PIC X(2).                         
           05 RS-LOCAL-OFFICE         PIC X(3).                         
           05 RS-LOCAL-OFFICE-DESC    PIC X(22).                        
           05 RS-SERV-ORDER-NO        PIC S9(13) USAGE COMP-3 VALUE 0.  
           05 RS-ACCOUNT-NO-PRIOR     PIC S9(13) USAGE COMP-3 VALUE 0.  
           05 RS-WORK-AREA-ID         PIC X(12).                        
           05 RS-AROP-IND             PIC S9(4) USAGE COMP.             
           05 RS-AROI-IND             PIC S9(4) USAGE COMP.             
           05 RS-AROC-IND             PIC S9(4) USAGE COMP.             
           05 RS-COMPLETED-DT         PIC X(10).                        
           05 RS-ORDER-STATE-CD       PIC X(1).                         
           05 RS-GAS-IND              PIC S9(4) USAGE COMP.             
           05 RS-ELEC-IND             PIC S9(4) USAGE COMP.             
           05 RS-BOTH-IND             PIC S9(4) USAGE COMP.             
           05 RS-AROP-GAS             PIC S9(4) USAGE COMP.             
           05 RS-AROP-ELEC            PIC S9(4) USAGE COMP.             
           05 RS-AROP-BOTH            PIC S9(4) USAGE COMP.             
           05 RS-AROI-GAS             PIC S9(4) USAGE COMP.             
           05 RS-AROI-ELEC            PIC S9(4) USAGE COMP.             
           05 RS-AROI-BOTH            PIC S9(4) USAGE COMP.             
           05 RS-AROC-GAS             PIC S9(4) USAGE COMP.             
           05 RS-AROC-ELEC            PIC S9(4) USAGE COMP.             
           05 RS-AROC-BOTH            PIC S9(4) USAGE COMP.             
      *                                                                         
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
           EXEC SQL                                                     
             DECLARE COMP_BASIC CURSOR FOR                              
              SELECT                                                    
               VO.COMPANY_NO,                                           
               VO.LOCAL_OFFICE,                                         
               B1.LOCAL_OFFICE_DESC,                                    
               VO.SERV_ORDER_NO,                                        
               VO.ACCOUNT_NO_PRIOR,                                     
               VO.WORK_AREA_ID,                                         
               CAST(CAST(VO.COMPLETED_DATETIME AS DATE) AS CHAR(10)) AS 
           COMPLETED_DT,       
               VO.ORDER_STATE_CD                                        
                                                                        
              FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                         
                                                                        
              INNER JOIN CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)              
               ON B1.COMPANY_NO = VO.COMPANY_NO                         
               AND B1.LOCAL_OFFICE = VO.LOCAL_OFFICE                    
                                                                        
              WHERE VO.ORDER_STATE_CD IN ('Z')                          
               AND CAST(VO.COMPLETED_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-LAST-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-DT) <> 0) OR (LEN(
                                                            :WS-LAST-DT
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-DT), CONVERT(DATE, 
                                                            :WS-LAST-DT
              ) )            
               AND B1.AROP_EXTRACT_CD IN ('A','B')                      
               FOR READ ONLY                                    
              END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE COMP_BASIC CURSOR FOR                                      
MFA-TR*       SELECT                                                            
MFA-TR*        VO.COMPANY_NO,                                                   
MFA-TR*        VO.LOCAL_OFFICE,                                                 
MFA-TR*        B1.LOCAL_OFFICE_DESC,                                            
MFA-TR*        VO.SERV_ORDER_NO,                                                
MFA-TR*        VO.ACCOUNT_NO_PRIOR,                                             
MFA-TR*        VO.WORK_AREA_ID,                                                 
MFA-TR*        CHAR(DATE(VO.COMPLETED_DATETIME)) AS COMPLETED_DT,               
MFA-TR*        VO.ORDER_STATE_CD                                                
MFA-TR*                                                                         
MFA-TR*       FROM CSS_SO_DATA VO                                               
MFA-TR*                                                                         
MFA-TR*       INNER JOIN CSS_LOCAL_OFFICE B1                                    
MFA-TR*        ON B1.COMPANY_NO = VO.COMPANY_NO                                 
MFA-TR*        AND B1.LOCAL_OFFICE = VO.LOCAL_OFFICE                            
MFA-TR*                                                                         
MFA-TR*       WHERE VO.ORDER_STATE_CD IN ('Z')                                  
MFA-TR*        AND DATE(VO.COMPLETED_DATETIME) = :WS-LAST-DT                    
MFA-TR*        AND B1.AROP_EXTRACT_CD IN ('A','B')                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       END-EXEC.                                                 00480000
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416 ( :WS-CURRENT-TS
                  , -1
                  )
MSQ001        END-EXEC.
                                                 
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE      THRU 0100-EXIT.                 
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           INITIALIZE TDS-RETURN-FIELDS                                 
                      WS-COLUMNS.                                       
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                    RETURN_CODE,                                        
                    COMPANY_NO,                                         
                    LOCAL_OFFICE,                                       
                    LOCAL_OFFICE_DESC,                                  
                    SERV_ORDER_NO,                                      
                    ACCOUNT_NO_PRIOR,                                   
                    WORK_AREA_ID,                                       
                    AROP_IND,                                           
                    AROI_IND,                                           
                    AROC_IND,                                           
                    RDO_IND,                                            
                    COMPLETED_DT,                                       
                    ORDER_STATE_CD,                                     
                    GAS_IND,                                            
                    ELEC_IND,                                           
                    BOTH_IND,                                           
                    AROP_GAS,                                           
                    AROP_ELEC,                                          
                    AROP_BOTH,                                          
                    AROI_GAS,                                           
                    AROI_ELEC,                                          
                    AROI_BOTH,                                          
                    AROC_GAS,                                           
                    AROC_ELEC,                                          
                    AROC_BOTH                                           
                FROM                                                    
                    #CSR04126_R1                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE,                                                
MFA-TR*             COMPANY_NO,                                                 
MFA-TR*             LOCAL_OFFICE,                                               
MFA-TR*             LOCAL_OFFICE_DESC,                                          
MFA-TR*             SERV_ORDER_NO,                                              
MFA-TR*             ACCOUNT_NO_PRIOR,                                           
MFA-TR*             WORK_AREA_ID,                                               
MFA-TR*             AROP_IND,                                                   
MFA-TR*             AROI_IND,                                                   
MFA-TR*             AROC_IND,                                                   
MFA-TR*             RDO_IND,                                                    
MFA-TR*             COMPLETED_DT,                                               
MFA-TR*             ORDER_STATE_CD,                                             
MFA-TR*             GAS_IND,                                                    
MFA-TR*             ELEC_IND,                                                   
MFA-TR*             BOTH_IND,                                                   
MFA-TR*             AROP_GAS,                                                   
MFA-TR*             AROP_ELEC,                                                  
MFA-TR*             AROP_BOTH,                                                  
MFA-TR*             AROI_GAS,                                                   
MFA-TR*             AROI_ELEC,                                                  
MFA-TR*             AROI_BOTH,                                                  
MFA-TR*             AROC_GAS,                                                   
MFA-TR*             AROC_ELEC,                                                  
MFA-TR*             AROC_BOTH                                                   
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04126_R1                                         
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04126_R1'            
                                    TO S-SQL-STATEMENT-V.               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04126_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04126_R1
              (                                                        
                      RETURN_CODE          INT                      
                     ,COMPANY_NO CHAR(2)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,LOCAL_OFFICE CHAR(3)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,LOCAL_OFFICE_DESC CHAR(22)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,SERV_ORDER_NO        DECIMAL(13,0)                
                     ,ACCOUNT_NO_PRIOR     DECIMAL(13,0)                
                     ,WORK_AREA_ID CHAR(12)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,AROP_IND             SMALLINT                     
                     ,AROI_IND             SMALLINT                     
                     ,AROC_IND             SMALLINT                     
                     ,RDO_IND              SMALLINT                     
                     ,COMPLETED_DT CHAR(10)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,ORDER_STATE_CD CHAR(1)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                     
                     ,GAS_IND              SMALLINT                     
                     ,ELEC_IND             SMALLINT                     
                     ,BOTH_IND             SMALLINT                     
                     ,AROP_GAS             SMALLINT                     
                     ,AROP_ELEC            SMALLINT                     
                     ,AROP_BOTH            SMALLINT                     
                     ,AROI_GAS             SMALLINT                     
                     ,AROI_ELEC            SMALLINT                     
                     ,AROI_BOTH            SMALLINT                     
                     ,AROC_GAS             SMALLINT                     
                     ,AROC_ELEC            SMALLINT                     
                     ,AROC_BOTH            SMALLINT                     
               )
           END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE SQLCODE            TO ABEND-SQLCODE                 
               MOVE SQLSTATE           TO ABEND-SQLSTATE                
               MOVE '0100A'            TO ACTIVE-PARAGRAPH              
               MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSR04126_R1'      TO TABLE-1                       
               MOVE SPACES             TO TABLE-ELEMENT-1               
               MOVE SPACES             TO HOSTVAR-ELEMENT-1             
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1200-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
       1200-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                 INTO   :WS-CURRENT-TS                                  
               FROM CSS_MODEL_SQL                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT_TIMESTAMP                                         
MFA-TR*          INTO   :WS-CURRENT-TS                                          
MFA-TR*        FROM CSS_MODEL_SQL                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                OR NOT-FOUND                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '1200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CURRENT TS'          TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *   1.  DESCRIBE RESULT SET                                      *        
      *   2.  BUILD RESULT SET                                         *        
      *   3.  SEND RESULT SET                                          *        
      *   3.  SEND RESULT SET                                          *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 1200-GET-CURRENT-DATE THRU 1200-EXIT.                
           PERFORM 7805-GET-LAST-DATE    THRU 7805-EXIT.                
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           IF CTR-ROWS = 0                                              
              INITIALIZE                 TDS-RETURN-FIELDS              
              MOVE 100                   TO RS-RETURN-CODE              
              MOVE WS-COMPLETED-DT       TO RS-COMPLETED-DT             
              PERFORM 2100-MOVE-RESULT   THRU 2100-EXIT                 
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2100-MOVE-RESULT.                                              *        
      ******************************************************************        
       2100-MOVE-RESULT.                                                
                                                                        
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
           MOVE RS-COMPANY-NO          TO S-COMPANY-NO.                 
           MOVE RS-LOCAL-OFFICE        TO S-LOCAL-OFFICE.               
           MOVE RS-LOCAL-OFFICE-DESC   TO S-LOCAL-OFFICE-DESC.          
           MOVE RS-SERV-ORDER-NO       TO S-SERV-ORDER-NO.              
           MOVE RS-ACCOUNT-NO-PRIOR    TO S-ACCOUNT-NO-PRIOR.           
           MOVE RS-WORK-AREA-ID        TO S-WORK-AREA-ID.               
           MOVE RS-AROP-IND            TO S-AROP-IND.                   
           MOVE RS-AROI-IND            TO S-AROI-IND.                   
           MOVE RS-AROC-IND            TO S-AROC-IND.                   
           MOVE 1                      TO S-RDO-IND.                    
           MOVE RS-COMPLETED-DT        TO S-COMPLETED-DT.               
           MOVE RS-ORDER-STATE-CD      TO S-ORDER-STATE-CD.             
           MOVE RS-GAS-IND             TO S-GAS-IND.                    
           MOVE RS-ELEC-IND            TO S-ELEC-IND.                   
           MOVE RS-BOTH-IND            TO S-BOTH-IND.                   
           MOVE RS-AROP-GAS            TO S-AROP-GAS.                   
           MOVE RS-AROP-ELEC           TO S-AROP-ELEC.                  
           MOVE RS-AROP-BOTH           TO S-AROP-BOTH.                  
           MOVE RS-AROI-GAS            TO S-AROI-GAS.                   
           MOVE RS-AROI-ELEC           TO S-AROI-ELEC.                  
           MOVE RS-AROI-BOTH           TO S-AROI-BOTH.                  
           MOVE RS-AROC-GAS            TO S-AROC-GAS.                   
           MOVE RS-AROC-ELEC           TO S-AROC-ELEC.                  
           MOVE RS-AROC-BOTH           TO S-AROC-BOTH.                  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT.                                             *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           PERFORM 3000-OPEN-CURSOR      THRU 3000-EXIT.                
           PERFORM 3100-FETCH-CURSOR     THRU 3100-EXIT.                
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
            MOVE 'Y' TO WS-WORK-ORDER-IND                               
            PERFORM 7850-WORK-ORDER-CHECK  THRU 7850-EXIT               
            IF WS-WORK-ORDER-IND = 'Y'                                  
             PERFORM 3200-PROCESS-ROWS     THRU 3200-EXIT               
            END-IF                                                      
            PERFORM 3100-FETCH-CURSOR     THRU 3100-EXIT                
           END-PERFORM.                                                 
           PERFORM 3300-CLOSE-CURSOR     THRU 3300-EXIT.                
           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT.                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 3000-OPEN-CURSOR.                                             *         
      *    OPEN CURSOR.                                               *         
      *****************************************************************         
       3000-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN COMP_BASIC                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE                  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '3000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'OPEN COMPLETED CURSOR'    TO TABLE-1               
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3100-FETCH-CURSOR.                                             *        
      ******************************************************************        
       3100-FETCH-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH COMP_BASIC                                         
                INTO                                                    
                     :VO-COMPANY-NO                                     
                    ,:VO-LOCAL-OFFICE                                   
                    ,:B1-LOCAL-OFFICE-DESC                              
                    ,:VO-SERV-ORDER-NO                                  
                    ,:VO-ACCOUNT-NO-PRIOR                               
                    ,:VO-WORK-AREA-ID                                   
                    ,:WS-COMPLETED-DT                                   
                    ,:VO-ORDER-STATE-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE                  
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                                OR   NOT-FOUND                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '3100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_SO_DATA'              TO TABLE-1               
           END-IF                                                       
           .                                                            
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3200-PROCESS-ROWS.                                             *        
      *     LOADS UTILITY TYPES AND AROP/AROC INDICATORS               *        
      ******************************************************************        
       3200-PROCESS-ROWS.                                               
                                                                        
           INITIALIZE TDS-RETURN-FIELDS                                 
                      WS-COLUMNS.                                       
           MOVE 0                      TO RS-RETURN-CODE.               
           MOVE VO-COMPANY-NO          TO RS-COMPANY-NO.                
           MOVE VO-LOCAL-OFFICE        TO RS-LOCAL-OFFICE.              
           MOVE B1-LOCAL-OFFICE-DESC   TO RS-LOCAL-OFFICE-DESC.         
           MOVE VO-SERV-ORDER-NO       TO RS-SERV-ORDER-NO.             
           MOVE VO-ACCOUNT-NO-PRIOR    TO RS-ACCOUNT-NO-PRIOR.          
           MOVE VO-WORK-AREA-ID        TO RS-WORK-AREA-ID.              
           IF VO-WORK-AREA-ID = 'AROPSCEG'                              
            MOVE 1 TO RS-AROP-IND                                       
            MOVE 1 TO RS-AROI-IND                                       
           END-IF.                                                      
           IF VO-WORK-AREA-ID = 'AROPPSNC'                              
            MOVE 1 TO RS-AROP-IND                                       
            MOVE 1 TO RS-AROI-IND                                       
           END-IF.                                                      
           IF VO-WORK-AREA-ID = 'AROCSCEG'                              
            MOVE 1 TO RS-AROP-IND                                       
            MOVE 1 TO RS-AROC-IND                                       
           END-IF.                                                      
           IF VO-WORK-AREA-ID = 'AROCPSNC'                              
            MOVE 1 TO RS-AROP-IND                                       
            MOVE 1 TO RS-AROC-IND                                       
           END-IF.                                                      
           MOVE WS-COMPLETED-DT        TO RS-COMPLETED-DT.              
           PERFORM 7125-GAS-METERS     THRU 7125-EXIT.                  
           PERFORM 7150-ELEC-METERS    THRU 7150-EXIT.                  
           IF WS-GAS-IND = 1 AND WS-ELEC-IND = 1                        
            MOVE 1                     TO RS-BOTH-IND                   
            MOVE 0                     TO RS-GAS-IND                    
            MOVE 0                     TO RS-ELEC-IND                   
           ELSE                                                         
            MOVE 0                     TO RS-BOTH-IND                   
            MOVE WS-GAS-IND            TO RS-GAS-IND                    
            MOVE WS-ELEC-IND           TO RS-ELEC-IND                   
           END-IF.                                                      
           IF RS-BOTH-IND = 1 AND RS-AROI-IND = 1                       
            MOVE 1                     TO RS-AROP-BOTH                  
            MOVE 1                     TO RS-AROI-BOTH                  
           END-IF.                                                      
           IF RS-GAS-IND = 1 AND RS-AROI-IND = 1                        
            MOVE 1                     TO RS-AROP-GAS                   
            MOVE 1                     TO RS-AROI-GAS                   
           END-IF.                                                      
           IF RS-ELEC-IND = 1 AND RS-AROI-IND = 1                       
            MOVE 1                     TO RS-AROP-ELEC                  
            MOVE 1                     TO RS-AROI-ELEC                  
           END-IF.                                                      
           IF RS-BOTH-IND = 1 AND RS-AROC-IND = 1                       
            MOVE 1                     TO RS-AROP-BOTH                  
            MOVE 1                     TO RS-AROC-BOTH                  
           END-IF.                                                      
           IF RS-GAS-IND = 1 AND RS-AROC-IND = 1                        
            MOVE 1                     TO RS-AROP-GAS                   
            MOVE 1                     TO RS-AROC-GAS                   
           END-IF.                                                      
           IF RS-ELEC-IND = 1 AND RS-AROC-IND = 1                       
            MOVE 1                     TO RS-AROP-ELEC                  
            MOVE 1                     TO RS-AROC-ELEC                  
           END-IF.                                                      
           MOVE VO-ORDER-STATE-CD      TO RS-ORDER-STATE-CD.            
           PERFORM 2100-MOVE-RESULT    THRU 2100-EXIT.                  
           PERFORM 8100-SEND-RESULT    THRU 8100-EXIT.                  
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE COMP_BASIC                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
        3300-EXIT.                                                      
            EXIT.                                                       
                                                                        
      **************************************************************            
      *  CHECKS SO_ORDER_INST FOR GAS METERS                       *            
      **************************************************************            
       7125-GAS-METERS.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
                INTO :WS-GAS-IND                                        
                FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
                INNER JOIN CSS_SO_DATA VO WITH(READUNCOMMITTED)                 
                      ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO            
                INNER JOIN CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)               
                      ON VO.COMPANY_NO = L4.COMPANY_NO                  
                      AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD             
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND L4.AROP_EXTRACT_IND = 'Y'                         
                  AND VI.CODE_UTIL_TYPE = 'G'                           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1                                                         
MFA-TR*         INTO :WS-GAS-IND                                                
MFA-TR*         FROM CSS_SO_ORDER_INST VI                                       
MFA-TR*         INNER JOIN CSS_SO_DATA VO                                       
MFA-TR*               ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                    
MFA-TR*         INNER JOIN CSS_WORK_TYPE L4                                     
MFA-TR*               ON VO.COMPANY_NO = L4.COMPANY_NO                          
MFA-TR*               AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                     
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*           AND L4.AROP_EXTRACT_IND = 'Y'                                 
MFA-TR*           AND VI.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7125'                TO ACTIVE-PARAGRAPH            
              MOVE 'GAS METERS'          TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *  CHECKS SO_ORDER_INST FOR ELEC METERS.                     *            
      **************************************************************            
       7150-ELEC-METERS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 1                                                 
                INTO :WS-ELEC-IND                                       
                FROM CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                 
                INNER JOIN CSS_SO_DATA VO WITH(READUNCOMMITTED)                 
                      ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO            
                INNER JOIN CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)               
                      ON VO.COMPANY_NO = L4.COMPANY_NO                  
                      AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD             
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND L4.AROP_EXTRACT_IND = 'Y'                         
                  AND VI.CODE_UTIL_TYPE = 'E'                           
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1                                                         
MFA-TR*         INTO :WS-ELEC-IND                                               
MFA-TR*         FROM CSS_SO_ORDER_INST VI                                       
MFA-TR*         INNER JOIN CSS_SO_DATA VO                                       
MFA-TR*               ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                    
MFA-TR*         INNER JOIN CSS_WORK_TYPE L4                                     
MFA-TR*               ON VO.COMPANY_NO = L4.COMPANY_NO                          
MFA-TR*               AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                     
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*           AND L4.AROP_EXTRACT_IND = 'Y'                                 
MFA-TR*           AND VI.CODE_UTIL_TYPE = 'E'                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                  OR NOT-FOUND                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'ELEC METERS'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7805-GET-LAST-DATE                                             *        
      ******************************************************************        
       7805-GET-LAST-DATE.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01416 (:WS-CURRENT-TS,-1)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7805'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01416'            TO TABLE-1                     
              MOVE 'LAST BIZ DAY'        TO TABLE-ELEMENT-1             
              MOVE WS-CURRENT-TS         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1416)                                                
      *       WITH PROCEDURE CSR01416                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
      *       :LOC1416                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1416 INTO                          
                :WS-LAST-TS                                             
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   SET NO-MORE-ROWS             TO TRUE                 
                   MOVE +000 TO WS-ACTIVE-RETURN-CODE                   
                END-IF                                                  
                EXEC SQL                                                
                 SELECT
              IIF(TRY_CONVERT(DATE, :WS-LAST-TS
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-TS) <> 0) OR (LEN(
                                                            :WS-LAST-TS
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-TS), CONVERT(DATE, 
                                                            :WS-LAST-TS
              ) )
            INTO
              :WS-LAST-DT                   
                END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*         EXEC SQL                                                        
MFA-TR*          SET :WS-LAST-DT =  DATE(:WS-LAST-TS)                           
MFA-TR*         END-EXEC                                                        
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                
             ELSE                                                       
                MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
                MOVE '7805'                     TO ACTIVE-PARAGRAPH     
                MOVE 'FETCH'                    TO ABEND-FUNCTION       
                MOVE 'CSR01416'                 TO TABLE-1              
                MOVE 'CURRENT TS'               TO TABLE-ELEMENT-1      
                MOVE WS-CURRENT-TS              TO HOSTVAR-ELEMENT-1    
                PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       7805-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02630000
      *   7850-WORK-ORDER-CHECK                                         08063003
      *        CHECKS IF EVERY WORK ORDER ON THIS SO IS AROP = Y       *08064003
      ******************************************************************08061003
                                                                        
       7850-WORK-ORDER-CHECK.                                           
                                                                        
           MOVE '7850'                     TO WS-ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'N'                                               
                  INTO :WS-WORK-ORDER-IND                               
                FROM CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)                
                INNER JOIN CSS_SO_DATA VO WITH(READUNCOMMITTED)                 
                      ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO            
                INNER JOIN CSS_WORK_TYPE L4 WITH(READUNCOMMITTED)               
                      ON VO.COMPANY_NO = L4.COMPANY_NO                  
                      AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD             
                WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO              
                  AND L4.AROP_EXTRACT_IND = 'N'                         
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08069303
MFA-TR*        SELECT 'N'                                               08069403
MFA-TR*           INTO :WS-WORK-ORDER-IND                               08069403
MFA-TR*         FROM CSS_SO_ORDER_INST  VI                              08069403
MFA-TR*         INNER JOIN CSS_SO_DATA VO                                       
MFA-TR*               ON VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                    
MFA-TR*         INNER JOIN CSS_WORK_TYPE L4                                     
MFA-TR*               ON VO.COMPANY_NO = L4.COMPANY_NO                          
MFA-TR*               AND VI.WORK_TYPE_CD = L4.WORK_TYPE_CD                     
MFA-TR*         WHERE VI.SERV_ORDER_NO = :VO-SERV-ORDER-NO                      
MFA-TR*           AND L4.AROP_EXTRACT_IND = 'N'                                 
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                    08069503

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7850'                TO ACTIVE-PARAGRAPH            
              MOVE 'WORK ORDER CHECK'    TO ABEND-FUNCTION              
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'CSS_SO_ORDER_INST'   TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                  8100-SEND-RESULT.                             *        
      ******************************************************************        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                INSERT INTO #CSR04126_R1                         
                (                                                       
                    RETURN_CODE,                                        
                    COMPANY_NO,                                         
                    LOCAL_OFFICE,                                       
                    LOCAL_OFFICE_DESC,                                  
                    SERV_ORDER_NO,                                      
                    ACCOUNT_NO_PRIOR,                                   
                    WORK_AREA_ID,                                       
                    AROP_IND,                                           
                    AROI_IND,                                           
                    AROC_IND,                                           
                    RDO_IND,                                            
                    COMPLETED_DT,                                       
                    ORDER_STATE_CD,                                     
                    GAS_IND,                                            
                    ELEC_IND,                                           
                    BOTH_IND,                                           
                    AROP_GAS,                                           
                    AROP_ELEC,                                          
                    AROP_BOTH,                                          
                    AROI_GAS,                                           
                    AROI_ELEC,                                          
                    AROI_BOTH,                                          
                    AROC_GAS,                                           
                    AROC_ELEC,                                          
                    AROC_BOTH                                           
               )                                                        
                VALUES                                                  
               (                                                        
                :S-RETURN-CODE,                                         
                :S-COMPANY-NO,                                          
                :S-LOCAL-OFFICE,                                        
                :S-LOCAL-OFFICE-DESC,                                   
                :S-SERV-ORDER-NO,                                       
                :S-ACCOUNT-NO-PRIOR,                                    
                :S-WORK-AREA-ID,                                        
                :S-AROP-IND,                                            
                :S-AROI-IND,                                            
                :S-AROC-IND,                                            
                :S-RDO-IND,                                             
                :S-COMPLETED-DT,                                        
                :S-ORDER-STATE-CD,                                      
                :S-GAS-IND,                                             
                :S-ELEC-IND,                                            
                :S-BOTH-IND,                                            
                :S-AROP-GAS,                                            
                :S-AROP-ELEC,                                           
                :S-AROP-BOTH,                                           
                :S-AROI-GAS,                                            
                :S-AROI-ELEC,                                           
                :S-AROI-BOTH,                                           
                :S-AROC-GAS,                                            
                :S-AROC-ELEC,                                           
                :S-AROC-BOTH                                            
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04126_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE,                                                
MFA-TR*             COMPANY_NO,                                                 
MFA-TR*             LOCAL_OFFICE,                                               
MFA-TR*             LOCAL_OFFICE_DESC,                                          
MFA-TR*             SERV_ORDER_NO,                                              
MFA-TR*             ACCOUNT_NO_PRIOR,                                           
MFA-TR*             WORK_AREA_ID,                                               
MFA-TR*             AROP_IND,                                                   
MFA-TR*             AROI_IND,                                                   
MFA-TR*             AROC_IND,                                                   
MFA-TR*             RDO_IND,                                                    
MFA-TR*             COMPLETED_DT,                                               
MFA-TR*             ORDER_STATE_CD,                                             
MFA-TR*             GAS_IND,                                                    
MFA-TR*             ELEC_IND,                                                   
MFA-TR*             BOTH_IND,                                                   
MFA-TR*             AROP_GAS,                                                   
MFA-TR*             AROP_ELEC,                                                  
MFA-TR*             AROP_BOTH,                                                  
MFA-TR*             AROI_GAS,                                                   
MFA-TR*             AROI_ELEC,                                                  
MFA-TR*             AROI_BOTH,                                                  
MFA-TR*             AROC_GAS,                                                   
MFA-TR*             AROC_ELEC,                                                  
MFA-TR*             AROC_BOTH                                                   
MFA-TR*        )                                                                
MFA-TR*         VALUES                                                          
MFA-TR*        (                                                                
MFA-TR*         :S-RETURN-CODE,                                                 
MFA-TR*         :S-COMPANY-NO,                                                  
MFA-TR*         :S-LOCAL-OFFICE,                                                
MFA-TR*         :S-LOCAL-OFFICE-DESC,                                           
MFA-TR*         :S-SERV-ORDER-NO,                                               
MFA-TR*         :S-ACCOUNT-NO-PRIOR,                                            
MFA-TR*         :S-WORK-AREA-ID,                                                
MFA-TR*         :S-AROP-IND,                                                    
MFA-TR*         :S-AROI-IND,                                                    
MFA-TR*         :S-AROC-IND,                                                    
MFA-TR*         :S-RDO-IND,                                                     
MFA-TR*         :S-COMPLETED-DT,                                                
MFA-TR*         :S-ORDER-STATE-CD,                                              
MFA-TR*         :S-GAS-IND,                                                     
MFA-TR*         :S-ELEC-IND,                                                    
MFA-TR*         :S-BOTH-IND,                                                    
MFA-TR*         :S-AROP-GAS,                                                    
MFA-TR*         :S-AROP-ELEC,                                                   
MFA-TR*         :S-AROP-BOTH,                                                   
MFA-TR*         :S-AROI-GAS,                                                    
MFA-TR*         :S-AROI-ELEC,                                                   
MFA-TR*         :S-AROI-BOTH,                                                   
MFA-TR*         :S-AROC-GAS,                                                    
MFA-TR*         :S-AROC-ELEC,                                                   
MFA-TR*         :S-AROC-BOTH                                                    
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                    TO CTR-ROWS                    
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8100'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE 'CSR04126_R1'        TO TABLE-1                     
               MOVE 'COMPLETED DT'       TO TABLE-ELEMENT-1             
               MOVE S-COMPLETED-DT       TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
