       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04120.                                         
       DATE-WRITTEN. AUG 25, 2010.                                      
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00060000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00080000
      *--                   STORED PROCEDURE:  CSR04120              -- 00090000
      *---------------------------------------------------------------- 00100000
      *--                         S U M M A R Y                      -- 00110000
      *--                                                            -- 00120000
      *--  CSR04120:                                                 -- 00130000
      *--                                                            -- 00140000
      *--  # RETURNS DETAILS OF AN ACCOUNT                           -- 00150000
      *--  # CALLED FROM BAT APPLICATION                             -- 00150000
      *--                                                            -- 00160000
      *---------------------------------------------------------------- 00170000
      *--                                                            -- 00180000
      *--  PARAMETERS                                                -- 00190000
      *--                                                            -- 00200000
      *--      IN                                                    -- 00210000
      *--            ACCOUNT_NO            DECIMAL(13,0)             -- 00230000
      *--                                                            -- 00260000
      *--      OUT                                                   -- 00270000
      *--            NONE                                            -- 00380000
      *--                                                            -- 00353006
      *--      INOUT                                                 -- 00360000
      *--                                                            -- 00370000
      *--            NONE                                            -- 00380000
      *--                                                            -- 00390000
      *--  RESULT SET                                                -- 00400000
      *--                                                            -- 00410000
      *--     1                                                      -- 00420000
      *--          O_RET_CODE               INTEGER                  -- 00430000
      *--          O_ACCOUNT_NO             DECIMAL(13,0)            -- 00430000
      *--          O_COMPANY_NO             CHAR(02)                 -- 00430000
      *--          O_START_DATE             CHAR(10)                 -- 00430000
      *--          O_END_DATE               CHAR(10)                 -- 00430000
      *--          O_REV_MNTH               DECIMAL(6,0)             -- 00430000
      *--          O_ESTIMATE               CHAR(01)                 -- 00430000
      *--          O_READY_TO_BILL          CHAR(01)                 -- 00430000
      *--          O_CANCEL_REBILL          CHAR(01)                 -- 00430000
      *--          O_CANCEL_REBILL_DATE     CHAR(10)                 -- 00430000
      *--          O_CREDIT_LETTER_IND      CHAR(01)                 -- 00430000
A02680*--          O_CALENDAR_DATE_MIN      CHAR(10)                 -- 00430000
A02680*--          O_CALENDAR_DATE_MAX      CHAR(10)                 -- 00430000
      *--                                                            -- 00430000
      *---------------------------------------------------------------- 00440000
      *--                        MODIFICATION LOG                    -- 00450000
      *--                                                            -- 00460000
      *--  DATE          INITIALS    COMMENTS                        -- 00470000
      *--  -----------   --------    ---------------------------------- 00480000
A02680*--  08/25/2010    VY95550     RE-WRITTEN AS SPCB AND ADDED    -- 00490000
A02680*--                            BUSINESS DAY LOGIC              -- 00430000
A02680*--  09/16/2010    VY95550     ADDED MAX AND MIN DATES         -- 00430000
      *---------------------------------------------------------------- 00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04120'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR04120 STARTS HERE'.            
                                                                        
      ******************************************************************00590000
      *    WORK AREAS                                                  *00600000
      ******************************************************************00610000
      *                                                                 00740000
       01  WS-GENERAL-WORKING-STORAGE.                                  
           05  WS-MONTHS-TO-ADD          PIC S9(9)  COMP VALUE 0.       
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  WS-CANCEL-REBILL-DATE     PIC X(10) VALUE SPACES.        
           05  WS-REV-MONTH-TMP          PIC 9(06) VALUE ZEROES.        
           05  WS-TEMP-REV-MTH-N REDEFINES WS-REV-MONTH-TMP.            
               10 WS-TEMP-YR-N           PIC 9(4).                      
               10 WS-TEMP-MT-N           PIC 9(2).                      
           05  WS-ADJ-DAY                PIC S9(4) USAGE COMP.          
           05 WS-RESULT-DATE             PIC X(10) VALUE SPACES.        
           05 WS-DUMMY-DATE              PIC X(10) VALUE SPACES.        
           05 WS-VALID-BUSINESS-DAY      PIC X(01) VALUE SPACES.        
           05 WS-ESTIMATE                PIC X(01) VALUE SPACES.        
      *                                                                 00740000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
COB305     05 RS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05  RS-COMPANY-NO             PIC  X(02) VALUE SPACES.       
           05  RS-START-DATE             PIC  X(10) VALUE SPACES.       
           05  RS-END-DATE               PIC  X(10) VALUE SPACES.       
COB305     05 RS-REV-MNTH        PIC S9(06)V USAGE COMP-3 VALUE 0.      
           05  RS-ESTIMATE               PIC  X(01) VALUE SPACES.       
           05  RS-READY-TO-BILL          PIC  X(01) VALUE SPACES.       
           05  RS-CANCEL-REBILL          PIC  X(01) VALUE SPACES.       
           05  RS-CANCEL-REBILL-DATE     PIC  X(10) VALUE SPACES.       
           05  RS-CREDIT-LETTER-IND      PIC  X(01) VALUE SPACES.       
A02680     05  RS-CALENDAR-DATE-MAX      PIC  X(10) VALUE SPACES.       
A02680     05  RS-CALENDAR-DATE-MIN      PIC  X(10) VALUE SPACES.       
      *                                                                 00740000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
      *                                                                 00740000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  WS-BUSINESS-DAY-FOUND     PIC X(01) VALUE 'N'.           
               88 BUSINESS-DAY-FOUND               VALUE 'Y'.           
A02680     05  WS-OFF-CYCLE-ACCOUNT      PIC X(01) VALUE 'N'.           
A02680         88 OFF-CYCLE-ACCOUNT                VALUE 'Y'.           
      *                                                                 00740000
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04120'.    
      *                                                                 00740000
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND1               PIC S9(04) COMP VALUE 0.       
           05 WS-NULL-IND2               PIC S9(04) COMP VALUE 0.       
      *                                                                 00740000
      ******************************************************************00881102
      *    DB2 INCLUDES                                                *00881202
      ******************************************************************00881302
           EXEC SQL                                                     00881402
              INCLUDE SQLCA                                             00881502
           END-EXEC.                                                    00881602
                                                                        
      ******************************************************************00881812
      * CSS_ACCOUNT, AT                                                *00881912
      ******************************************************************00882012
           EXEC SQL                                                     00882112
              INCLUDE TBACCT                                            00882212
           END-EXEC.                                                    00882312
                                                                        
      ******************************************************************00882512
      * CSS_BILL_WINDOW, BN                                            *00882612
      ******************************************************************00882712
           EXEC SQL                                                     00882812
              INCLUDE TBBILWDW                                          00882912
           END-EXEC.                                                    00883012
                                                                        
      ******************************************************************00882512
      * CSS_HOLIDAY, J8                                                *00882612
      ******************************************************************00882712
           EXEC SQL                                                     00882812
              INCLUDE TBHLDAY                                           00882912
           END-EXEC.                                                    00883012
                                                                        
      ******************************************************************00882512
      * CSS_OFF_CYCL_ACCT, OC                                          *00882612
      ******************************************************************00882712
           EXEC SQL                                                     00882812
              INCLUDE TBOFFCYL                                          00882912
           END-EXEC.                                                    00883012
                                                                        
      ******************************************************************00882512
      * CSS_UTIL_ENVRNMT, UT                                           *00882612
      ******************************************************************00882712
           EXEC SQL                                                     00882812
              INCLUDE TBUTLENV                                          00882912
           END-EXEC.                                                    00883012
                                                                        
      ******************************************************************00883212
      *    ERROR HANDLING COPY BOOK                                    *00883312
      ******************************************************************00883412
           EXEC SQL                                                     00883512
               INCLUDE CWSX0010                                         00883612
           END-EXEC.                                                    00883712
                                                                        
      ******************************************************************00883912
      *    SQL ERROR CHECKING COPYBOOK                                 *00884012
      ******************************************************************00884112
           COPY CWS00303.                                               00884212
                                                                        
      ******************************************************************00884412
      *    DB2 ERRROR PROCESSING COPYBOOK                              *00884512
      ******************************************************************00884612
           COPY CWSSP001.                                               00884712
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************01140000
      **                                                              **01150000
      **    0000-MAINLINE                                             **01160000
      **                                                              **01170000
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **01180000
      **                                                              **01190000
      ******************************************************************01200000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                  :RS-RETURN-CODE         AS RETURN_CODE                
                 ,:RS-ACCOUNT-NO          AS ACCOUNT_NO                 
                 ,:RS-COMPANY-NO          AS COMPANY_NO                 
                 ,:RS-START-DATE          AS START_DATE                 
                 ,:RS-END-DATE            AS END_DATE                   
                 ,:RS-REV-MNTH            AS REVENUE_MONTH              
                 ,:RS-ESTIMATE            AS ESTIMATE                   
                 ,:RS-READY-TO-BILL       AS READY_TO_BILL              
                 ,:RS-CANCEL-REBILL       AS CANCEL_REBILL              
                 ,:RS-CANCEL-REBILL-DATE  AS CANCEL_REBILL_DATE         
                 ,:RS-CREDIT-LETTER-IND   AS CREDIT_LETTER_IND          
A02680           ,:RS-CALENDAR-DATE-MIN   AS CALENDAR_DATE_MIN          
A02680           ,:RS-CALENDAR-DATE-MAX   AS CALENDAR_DATE_MAX          
             FROM                                                       
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*           :RS-RETURN-CODE         AS RETURN_CODE                        
MFA-TR*          ,:RS-ACCOUNT-NO          AS ACCOUNT_NO                         
MFA-TR*          ,:RS-COMPANY-NO          AS COMPANY_NO                         
MFA-TR*          ,:RS-START-DATE          AS START_DATE                         
MFA-TR*          ,:RS-END-DATE            AS END_DATE                           
MFA-TR*          ,:RS-REV-MNTH            AS REVENUE_MONTH                      
MFA-TR*          ,:RS-ESTIMATE            AS ESTIMATE                           
MFA-TR*          ,:RS-READY-TO-BILL       AS READY_TO_BILL                      
MFA-TR*          ,:RS-CANCEL-REBILL       AS CANCEL_REBILL                      
MFA-TR*          ,:RS-CANCEL-REBILL-DATE  AS CANCEL_REBILL_DATE                 
MFA-TR*          ,:RS-CREDIT-LETTER-IND   AS CREDIT_LETTER_IND                  
MFA-TR*          ,:RS-CALENDAR-DATE-MIN   AS CALENDAR_DATE_MIN                  
MFA-TR*          ,:RS-CALENDAR-DATE-MAX   AS CALENDAR_DATE_MAX                  
MFA-TR*      FROM                                                               
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO            
                                               UT-ACCOUNT-NO            
                                               OC-ACCOUNT-NO            
                                               RS-ACCOUNT-NO.           
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-BUILD-RESULT THRU 2100-EXIT                     
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-BUILD-RESULT.                                             *        
      ******************************************************************        
       2100-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-GET-ACCT-DETAIL         THRU 7000-EXIT.         
           MOVE AT-REV-MTH-LST-NRML         TO RS-REV-MNTH.             
           MOVE AT-CODE-ACCT-BILLED         TO RS-READY-TO-BILL.        
           MOVE AT-COMPANY-NO               TO RS-COMPANY-NO.           
                                                                        
A02680     MOVE 'N'                         TO WS-OFF-CYCLE-ACCOUNT     
A02680     PERFORM 7230-CHECK-CAN-REBILL        THRU 7230-EXIT.         
A02680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02680        SET OFF-CYCLE-ACCOUNT         TO TRUE                     
A02680     END-IF                                                       
A02680                                                                  
           IF AT-REV-MTH-LST-NRML = 0                                   
              PERFORM 7100-GET-CURRENT-DATE     THRU 7100-EXIT          
              MOVE WS-CURRENT-DATE          TO RS-START-DATE            
                                               RS-END-DATE              
                                               BN-DATE-EXTRACT          
                                                                        
              PERFORM 7110-GET-MAX-REV-MNTH     THRU 7110-EXIT          
              MOVE BN-REVENUE-MONTH         TO RS-REV-MNTH              
           ELSE                                                         
              IF AT-REV-MTH-LST-NRML > 0                                
      * INCREMENT THE REVENUE MONTH BY 1                                02164700
                 MOVE 1                     TO WS-MONTHS-TO-ADD         
                 MOVE RS-REV-MNTH           TO WS-REV-MONTH-TMP         
                                               BN-REVENUE-MONTH         
                 PERFORM 5000-STEP-UP-REV-MNTH  THRU 5000-EXIT          
                 MOVE WS-REV-MONTH-TMP      TO RS-REV-MNTH              
                                               BN-REVENUE-MONTH         
                                                                        
                 PERFORM 7200-SELECT-START-DATE THRU 7200-EXIT          
                 MOVE BN-DATE-EXTRACT       TO RS-START-DATE            
                                                                        
                 PERFORM 7210-SELECT-END-DATE   THRU 7210-EXIT          
                 MOVE BN-DATE-EXTRACT       TO RS-END-DATE              
              END-IF                                                    
           END-IF.                                                      
                                                                        
      * CHECK READY TO ESTIMATE                                         02164700
           PERFORM 7220-CHECK-ESTIMATE-OK       THRU 7220-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE 'Y'                      TO RS-ESTIMATE              
           ELSE                                                         
              MOVE 'N'                      TO RS-ESTIMATE              
           END-IF.                                                      
                                                                        
      * CHECK READY TO BILL                                             02164700
           IF RS-READY-TO-BILL = 'R' OR AT-CREDIT-GROUP = 'D' THEN      
              MOVE 'Y'                      TO RS-READY-TO-BILL         
           ELSE                                                         
              MOVE 'N'                      TO RS-READY-TO-BILL         
           END-IF.                                                      
                                                                        
           PERFORM 2110-PROCESS-OFF-CYCLE       THRU 2110-EXIT.         
                                                                        
           ADD +1  TO CTR-ROWS.                                         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02165212
      ******************************************************************        
      * 2110-PROCESS-OFF-CYCLE                                         *        
      ******************************************************************        
       2110-PROCESS-OFF-CYCLE.                                          
      *                                                                         
A02680     IF OFF-CYCLE-ACCOUNT                                         
              MOVE OC-CODE-BILL-OFF-CYCL    TO RS-CANCEL-REBILL         
              MOVE OC-CREDIT-LETTER-IND     TO RS-CREDIT-LETTER-IND     
              MOVE WS-CANCEL-REBILL-DATE    TO RS-CANCEL-REBILL-DATE    
A02680        PERFORM 5100-CALC-CALENDAR-DATE   THRU 5100-EXIT          
A02680     ELSE                                                         
A02680        MOVE SPACES                   TO RS-CANCEL-REBILL         
A02680                                         RS-CREDIT-LETTER-IND     
A02680                                         RS-CANCEL-REBILL-DATE    
A02680        MOVE RS-REV-MNTH              TO BN-REVENUE-MONTH         
A02680        PERFORM 7410-SEL-DATE-RANGE       THRU 7410-EXIT          
A02680     END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-STEP-UP-REV-MNTH.                                         *        
      ******************************************************************        
       5000-STEP-UP-REV-MNTH.                                           
      *                                                                         
           PERFORM WS-MONTHS-TO-ADD TIMES                               
             COMPUTE WS-TEMP-MT-N = WS-TEMP-MT-N + 1                    
             IF WS-TEMP-MT-N > 12                                       
                COMPUTE WS-TEMP-YR-N = WS-TEMP-YR-N + 1                 
                MOVE 01                     TO WS-TEMP-MT-N             
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
A02680* 5100-CALC-CALENDAR-DATE.                                       *        
A02680*    CALCULATE MIN AND MAX OF CALENDAR DATES                     *        
      ******************************************************************        
A02680 5100-CALC-CALENDAR-DATE.                                         
      *                                                                         
A02680     MOVE AT-COMPANY-NO               TO J8-COMPANY-NO.           
           MOVE AT-DATE-BILL-DAY-00         TO WS-DUMMY-DATE.           
           PERFORM 7300-ADD-1DAY                THRU 7300-EXIT.         
A02680     MOVE WS-RESULT-DATE              TO WS-DUMMY-DATE.           
A02680     MOVE 'N'                         TO WS-VALID-BUSINESS-DAY    
A02680                                         WS-BUSINESS-DAY-FOUND.   
A02680     PERFORM 7310-CHECK-BUSINESS-DAY      THRU 7310-EXIT.         
A02680                                                                  
A02680     IF WS-VALID-BUSINESS-DAY = 'Y'                               
A02680        MOVE WS-RESULT-DATE           TO RS-CALENDAR-DATE-MIN     
A02680     ELSE                                                         
A02680        PERFORM 7400-SEL-NEXT-BUSINESS-DAY THRU 7400-EXIT         
A02680          UNTIL BUSINESS-DAY-FOUND                                
A02680        MOVE WS-RESULT-DATE           TO RS-CALENDAR-DATE-MIN     
A02680     END-IF.                                                      
      *                                                                         
A02680     MOVE 'N'                         TO WS-VALID-BUSINESS-DAY    
A02680                                         WS-BUSINESS-DAY-FOUND.   
           MOVE WS-CANCEL-REBILL-DATE       TO WS-DUMMY-DATE.           
           PERFORM 7310-CHECK-BUSINESS-DAY      THRU 7310-EXIT.         
                                                                        
           IF WS-VALID-BUSINESS-DAY = 'Y'                               
A02680        MOVE WS-CANCEL-REBILL-DATE    TO RS-CALENDAR-DATE-MAX     
           ELSE                                                         
              PERFORM 7400-SEL-NEXT-BUSINESS-DAY THRU 7400-EXIT         
                UNTIL BUSINESS-DAY-FOUND                                
A02680        MOVE WS-RESULT-DATE           TO RS-CALENDAR-DATE-MAX     
A02680                                         RS-CANCEL-REBILL-DATE    
           END-IF.                                                      
      *                                                                         
A02680* SWAP WHEN MIN DATE GREATER THEN MAX DATE                                
      *                                                                         
A02680     IF RS-CALENDAR-DATE-MIN > RS-CALENDAR-DATE-MAX               
A02680        MOVE RS-CALENDAR-DATE-MIN     TO WS-DUMMY-DATE            
A02680        MOVE RS-CALENDAR-DATE-MAX     TO RS-CALENDAR-DATE-MIN     
A02680        MOVE WS-DUMMY-DATE            TO RS-CALENDAR-DATE-MAX     
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02165212
      ******************************************************************        
      * 7000-GET-ACCT-DETAIL.                                          *        
      ******************************************************************        
       7000-GET-ACCT-DETAIL.                                            
      *                                                                         
            EXEC SQL                                                    
               SELECT AT.REV_MTH_LST_NRML                               
                     ,AT.CODE_ACCT_BILLED                               
                     ,AT.COMPANY_NO                                     
                     ,AT.CREDIT_GROUP                                   
                     ,AT.DATE_BILL_DAY_00                               
                 INTO :AT-REV-MTH-LST-NRML                              
                     ,:AT-CODE-ACCT-BILLED                              
                     ,:AT-COMPANY-NO                                    
                     ,:AT-CREDIT-GROUP                                  
                     ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND1                 
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.CODE_ACCT_BILLED                                       
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CREDIT_GROUP                                           
MFA-TR*              ,AT.DATE_BILL_DAY_00                                       
MFA-TR*          INTO :AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-CODE-ACCT-BILLED                                      
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-CREDIT-GROUP                                          
MFA-TR*              ,:AT-DATE-BILL-DAY-00:WS-NULL-IND1                         
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-NULL-IND1 = -1                                     
                  MOVE SPACES             TO AT-DATE-BILL-DAY-00        
               END-IF                                                   
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7100-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
       7100-GET-CURRENT-DATE.                                           
      *                                                                         
            EXEC SQL                                                    
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7100'                TO ACTIVE-PARAGRAPH           
               MOVE 'SET'                 TO ABEND-FUNCTION             
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7110-GET-MAX-REV-MNTH.                                         *        
      ******************************************************************        
       7110-GET-MAX-REV-MNTH.                                           
      *                                                                         
            EXEC SQL                                                    
               SELECT MAX(BN.REVENUE_MONTH)                             
                 INTO :BN-REVENUE-MONTH :WS-NULL-IND2                    
                 FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT MAX(BN.REVENUE_MONTH)                                     
MFA-TR*          INTO :BN-REVENUE-MONTH:WS-NULL-IND2                            
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT                        
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-NULL-IND2 = -1                                     
                  MOVE 0                  TO BN-REVENUE-MONTH           
               END-IF                                                   
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7110'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                    
               MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-1            
               MOVE BN-DATE-EXTRACT       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7200-SELECT-START-DATE.                                        *        
      ******************************************************************        
       7200-SELECT-START-DATE.                                          
      *                                                                         
            EXEC SQL                                                    
               SELECT BN.DATE_EXTRACT                                   
                 INTO :BN-DATE-EXTRACT                                  
                 FROM CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
                     ,CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO              
                  AND AT.BILL_CYCLE       = BN.BILL_CYCLE               
                  AND BN.REVENUE_MONTH    = :BN-REVENUE-MONTH           
                  AND BN.DATE_EXTRACT     =                             
                       (                                                
                         SELECT MIN(DATE_EXTRACT)                       
                           FROM CSS_BILL_WINDOW BW WITH(READUNCOMMITTED)        
                          WHERE BW.BILL_CYCLE    = BN.BILL_CYCLE        
                            AND BW.REVENUE_MONTH = :BN-REVENUE-MONTH    
                       )                                                
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT BN.DATE_EXTRACT                                           
MFA-TR*          INTO :BN-DATE-EXTRACT                                          
MFA-TR*          FROM CSS_ACCOUNT     AT                                        
MFA-TR*              ,CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*           AND AT.BILL_CYCLE       = BN.BILL_CYCLE                       
MFA-TR*           AND BN.REVENUE_MONTH    = :BN-REVENUE-MONTH                   
MFA-TR*           AND BN.DATE_EXTRACT     =                                     
MFA-TR*                (                                                        
MFA-TR*                  SELECT MIN(DATE_EXTRACT)                               
MFA-TR*                    FROM CSS_BILL_WINDOW BW                              
MFA-TR*                   WHERE BW.BILL_CYCLE    = BN.BILL_CYCLE                
MFA-TR*                     AND BW.REVENUE_MONTH = :BN-REVENUE-MONTH            
MFA-TR*                )                                                        
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'CSS_BILL_WINDOW'     TO TABLE-2                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-2            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02165212
      ******************************************************************        
      * 7210-SELECT-END-DATE.                                          *        
      ******************************************************************        
       7210-SELECT-END-DATE.                                            
      *                                                                         
            EXEC SQL                                                    
               SELECT BN.DATE_EXTRACT                                   
                 INTO :BN-DATE-EXTRACT                                  
                 FROM CSS_ACCOUNT     AT WITH(READUNCOMMITTED)                  
                     ,CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
                WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO              
                  AND AT.BILL_CYCLE       = BN.BILL_CYCLE               
                  AND BN.REVENUE_MONTH    = :BN-REVENUE-MONTH           
                  AND BN.DATE_EXTRACT     =                             
                       (                                                
                         SELECT MAX(DATE_EXTRACT)                       
                           FROM CSS_BILL_WINDOW BW WITH(READUNCOMMITTED)        
                          WHERE BW.BILL_CYCLE    = BN.BILL_CYCLE        
                            AND BW.REVENUE_MONTH = :BN-REVENUE-MONTH    
                       )                                                
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT BN.DATE_EXTRACT                                           
MFA-TR*          INTO :BN-DATE-EXTRACT                                          
MFA-TR*          FROM CSS_ACCOUNT     AT                                        
MFA-TR*              ,CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*           AND AT.BILL_CYCLE       = BN.BILL_CYCLE                       
MFA-TR*           AND BN.REVENUE_MONTH    = :BN-REVENUE-MONTH                   
MFA-TR*           AND BN.DATE_EXTRACT     =                                     
MFA-TR*                (                                                        
MFA-TR*                  SELECT MAX(DATE_EXTRACT)                               
MFA-TR*                    FROM CSS_BILL_WINDOW BW                              
MFA-TR*                   WHERE BW.BILL_CYCLE    = BN.BILL_CYCLE                
MFA-TR*                     AND BW.REVENUE_MONTH = :BN-REVENUE-MONTH            
MFA-TR*                )                                                        
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7210'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'CSS_BILL_WINDOW'     TO TABLE-2                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-2            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02165212
      ******************************************************************        
      * 7220-CHECK-ESTIMATE-OK.                                        *        
      ******************************************************************        
       7220-CHECK-ESTIMATE-OK.                                          
      *                                                                         
            EXEC SQL                                                    
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-ESTIMATE                                      
                 FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO              
                  AND UT.CODE_ESTIMATE_OK = ' '                         
                                                                 
                                                  
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-ESTIMATE                                              
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO       = :UT-ACCOUNT-NO                      
MFA-TR*           AND UT.CODE_ESTIMATE_OK = ' '                                 
MFA-TR*          WITH UR                                                        
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7220'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7220-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02165212
      ******************************************************************        
      *  7230-CHECK-CAN-REBILL.                                        *        
      ******************************************************************        
       7230-CHECK-CAN-REBILL.                                           
      *                                                                         
            EXEC SQL                                                    
               SELECT TOP(1) OC.CODE_BILL_OFF_CYCL,
              CAST(OC.LAST_UPDATE_TS AS DATE),
              OC.CREDIT_LETTER_IND                              
                 INTO :OC-CODE-BILL-OFF-CYCL                            
                     ,:WS-CANCEL-REBILL-DATE                            
                     ,:OC-CREDIT-LETTER-IND                             
                 FROM CSS_OFF_CYCL_ACCT OC WITH(READUNCOMMITTED)                
                WHERE OC.ACCOUNT_NO   = :OC-ACCOUNT-NO                  
                  AND OC.CODE_BILL_OFF_CYCL in (' ','O','B')            
                ORDER BY OC.LAST_UPDATE_TS DESC                         
                                                  
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT OC.CODE_BILL_OFF_CYCL                                     
MFA-TR*              ,DATE(OC.LAST_UPDATE_TS)                                   
MFA-TR*              ,OC.CREDIT_LETTER_IND                                      
MFA-TR*          INTO :OC-CODE-BILL-OFF-CYCL                                    
MFA-TR*              ,:WS-CANCEL-REBILL-DATE                                    
MFA-TR*              ,:OC-CREDIT-LETTER-IND                                     
MFA-TR*          FROM CSS_OFF_CYCL_ACCT OC                                      
MFA-TR*         WHERE OC.ACCOUNT_NO   = :OC-ACCOUNT-NO                          
MFA-TR*           AND OC.CODE_BILL_OFF_CYCL in (' ','O','B')                    
MFA-TR*         ORDER BY OC.LAST_UPDATE_TS DESC                                 
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7230                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7230'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7230-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02165212
      ******************************************************************        
      * 7300-ADD-1DAY.                                                 *        
      ******************************************************************        
       7300-ADD-1DAY.                                                   
      *                                                                         
            EXEC SQL                                                    
               SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) )
            INTO
              :WS-RESULT-DATE       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-RESULT-DATE = DATE(:WS-DUMMY-DATE) + 1 DAY               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7300'                TO ACTIVE-PARAGRAPH           
               MOVE 'SET'                 TO ABEND-FUNCTION             
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02165212
      ******************************************************************        
      * 7310-CHECK-BUSINESS-DAY.                                       *        
      ******************************************************************        
       7310-CHECK-BUSINESS-DAY.                                         
      *                                                                         
            EXEC SQL                                                    
               SELECT 'Y'                                               
                 INTO :WS-VALID-BUSINESS-DAY                            
                 FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                       
                WHERE CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) )) -                      
                         (CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) )) / 7 * 7)  
                                           BETWEEN 1 AND 5              
                  AND NOT EXISTS                                        
                        (SELECT HOLIDAY_DT                              
                           FROM CSS_HOLIDAY WITH(READUNCOMMITTED)               
                          WHERE COMPANY_NO = :J8-COMPANY-NO             
                            AND HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ))            
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-VALID-BUSINESS-DAY                                    
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*         WHERE DAYS(DATE(:WS-DUMMY-DATE)) -                              
MFA-TR*                  (INTEGER(DAYS(DATE(:WS-DUMMY-DATE)) / 7) * 7)          
MFA-TR*                                    BETWEEN 1 AND 5                      
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                 (SELECT HOLIDAY_DT                                      
MFA-TR*                    FROM CSS_HOLIDAY                                     
MFA-TR*                   WHERE COMPANY_NO = :J8-COMPANY-NO                     
MFA-TR*                     AND HOLIDAY_DT = :WS-DUMMY-DATE)                    
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
            ELSE                                                        
               MOVE -1                    TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7310'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_HOLIDAY'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'WORK DATE'           TO TABLE-ELEMENT-2            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-DUMMY-DATE         TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7310-EXIT.                                                       
            EXIT.                                                       
      *                                                                 02165212
      ******************************************************************        
      * 7400-SEL-NEXT-BUSINESS-DAY.                                    *        
      ******************************************************************        
       7400-SEL-NEXT-BUSINESS-DAY.                                      
                                                                        
           EXEC SQL                                                     
              SELECT DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                         :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) )            
                INTO :WS-RESULT-DATE                                    
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
               WHERE CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) )) -                
                        (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE
              ) ) )) / 7 * 7) BETWEEN 1 AND 5 
                 AND NOT EXISTS                                         
                       (SELECT HOLIDAY_DT                               
                          FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                
                         WHERE COMPANY_NO = :J8-COMPANY-NO              
                           AND HOLIDAY_DT =                             
                               DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) ))                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-DUMMY-DATE) + :WS-ADJ-DAY DAYS                    
MFA-TR*         INTO :WS-RESULT-DATE                                            
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*        WHERE DAYS(DATE(:WS-DUMMY-DATE)                                  
MFA-TR*                            + :WS-ADJ-DAY DAYS) -                        
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-DUMMY-DATE)                      
MFA-TR*                   + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*                (SELECT HOLIDAY_DT                                       
MFA-TR*                   FROM CSS_HOLIDAY                                      
MFA-TR*                  WHERE COMPANY_NO = :J8-COMPANY-NO                      
MFA-TR*                    AND HOLIDAY_DT =                                     
MFA-TR*                        DATE(:WS-DUMMY-DATE) +                           
MFA-TR*                                :WS-ADJ-DAY DAYS)                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 SET BUSINESS-DAY-FOUND      TO TRUE                    
              ELSE                                                      
                 ADD +1                      TO WS-ADJ-DAY              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_HOLIDAY'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'WORK DATE'               TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-DUMMY-DATE             TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02680******************************************************************        
A02680*  7410-SEL-DATE-RANGE.                                          *        
A02680******************************************************************        
A02680 7410-SEL-DATE-RANGE.                                             
A02680*                                                                         
A02680      EXEC SQL                                                    
A02680         SELECT MAX(DATE_EXTRACT)                                 
A02680               ,MIN(DATE_EXTRACT)                                 
A02680           INTO :RS-CALENDAR-DATE-MAX                             
A02680               ,:RS-CALENDAR-DATE-MIN                             
A02680           FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
A02680          WHERE BN.REVENUE_MONTH = :BN-REVENUE-MONTH              
A02680                                                           
A02680                                                      
A02680      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT MAX(DATE_EXTRACT)                                         
MFA-TR*              ,MIN(DATE_EXTRACT)                                         
MFA-TR*          INTO :RS-CALENDAR-DATE-MAX                                     
MFA-TR*              ,:RS-CALENDAR-DATE-MIN                                     
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.REVENUE_MONTH = :BN-REVENUE-MONTH                      
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02680                                                                  
A02680      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
A02680                                                                  
A02680      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A02680         CONTINUE                                                 
A02680      ELSE                                                        
A02680         MOVE -1                    TO RS-RETURN-CODE             
A02680         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A02680         MOVE '7410'                TO ACTIVE-PARAGRAPH           
A02680         MOVE 'SELECT'              TO ABEND-FUNCTION             
A02680         MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                    
A02680         MOVE 'REVENUE MONTH'       TO TABLE-ELEMENT-1            
A02680         MOVE BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1          
A02680         PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
A02680         PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
A02680      END-IF.                                                     
A02680                                                                  
A02680 7410-EXIT.                                                       
A02680      EXIT.                                                       
A02680                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
