       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04118.                                         
COB303 DATE-WRITTEN.  FEBRUARY 18, 2008                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM RETRIEVES THE PAYMENT HISTORY FROM               *00190000
      *  CSS_AR_TRANS_HIST SINCE WRITE OFF                             *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  02/18/08  MN90523    PROCEDURE ORIGINALLY CODED.              *00280000
      *                                                                *00290000
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04118'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04118 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CCA00001.                                               00600000
           COPY CWS00027.                                               00620000
           COPY CWS00303.                                               00630000
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00650000
      *    WORK AREAS                                                  *00660000
      ******************************************************************00670000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04118'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-SQLSTATE              PIC X(5).                       
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-WRITEOFF-DT           PIC X(10)  VALUE SPACES.        
      *                                                                 00857000
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                           VALUE 'SESSION.CSR04118_R1'. 
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09)   COMP VALUE +0.     
           05  RS-AMT-ORIG-ENTERED      PIC S9(9)V99 COMP-3 VALUE 0.    
           05  RS-DATE-TRANS            PIC X(10)    VALUE SPACES.      
           05  RS-CODE-TRAN-TYPE        PIC X(01)    VALUE SPACES.      
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09)   COMP VALUE +0.      
           05  S-AMT-ORIG-ENTERED      PIC S9(9)V99 COMP-3 VALUE 0.     
           05  S-DATE-TRANS            PIC X(10)    VALUE SPACES.       
           05  S-CODE-TRAN-TYPE        PIC X(01)    VALUE SPACES.       
                                                                        
           EXEC SQL                                                     01570000
              INCLUDE SQLCA                                             01580000
           END-EXEC.                                                    01590000
                                                                        
           EXEC SQL                                                     01610000
              INCLUDE TBMODEL                                           01620000
           END-EXEC.                                                    01630000
                                                                        
      **********************CSS_FIN_WO_ACTION - KD  *************               
           EXEC SQL                                                     01650000
             INCLUDE TBFWACTN                                           01660000
           END-EXEC.                                                    01670000
                                                                        
      **********************CSS_AR_TRANS_HIST - AR *************                
           EXEC SQL                                                     01690000
             INCLUDE TBARHIST                                           01700000
           END-EXEC.                                                    01710000
                                                                        
      *                                                                 01720500
      ***************************************************************   01720600
      * CURSOR DECLARATIONS                                             01720700
      ***************************************************************   01720800
      *                                                                 01720900
           EXEC SQL                                                     
              DECLARE AR_TRANS_CUR CURSOR FOR                           
              SELECT                                                    
                   AMT_ORIG_ENTERED                                     
                  ,DATE_TRANS                                           
                  ,CODE_TRAN_TYPE                                       
                  ,REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
              FROM                                                      
                   CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                      
              WHERE                                                     
                  ACCOUNT_NO = :AR-ACCOUNT-NO                           
              AND DATE_TRANS > IIF(TRY_CONVERT(DATE, :WS-WRITEOFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-WRITEOFF-DT
              ) <> 0) OR (LEN(:WS-WRITEOFF-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-WRITEOFF-DT
              ), CONVERT(DATE, :WS-WRITEOFF-DT) )                          
              AND CODE_TRAN_TYPE IN ('I','T','S','R','D')               
              AND RECORD_ONLY_FL <> 'Y'                                 
              ORDER BY TRANS_HIST_SEQ_NO DESC                           
              FOR READ ONLY                                      
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01721000
MFA-TR*       DECLARE AR_TRANS_CUR CURSOR FOR                           01721100
MFA-TR*       SELECT                                                            
MFA-TR*            AMT_ORIG_ENTERED                                             
MFA-TR*           ,DATE_TRANS                                                   
MFA-TR*           ,CODE_TRAN_TYPE                                               
MFA-TR*           ,TRANS_HIST_SEQ_NO                                            
MFA-TR*       FROM                                                              
MFA-TR*            CSS_AR_TRANS_HIST                                            
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO = :AR-ACCOUNT-NO                                   
MFA-TR*       AND DATE_TRANS > :WS-WRITEOFF-DT                                  
MFA-TR*       AND CODE_TRAN_TYPE IN ('I','T','S','R','D')                       
MFA-TR*       AND RECORD_ONLY_FL <> 'Y'                                         
MFA-TR*       ORDER BY TRANS_HIST_SEQ_NO DESC                                   
MFA-TR*       FOR READ ONLY WITH UR                                             
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                    01722500
      *                                                                 01722600
HPCCDM*EJECT                                                            01730000
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC  X(13).                 
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                         
      ******************************************************************01760000
      * 0000-MAINLINE                                                  *01770000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01780000
      ******************************************************************01790000
      *                                                                 01800000
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************01900000
      * 0100-INITIALIZE                                                *01910000
      *   DECLARE RESULT SET CURSOR                                    *01920000
      *                                                                *01960000
      ******************************************************************01970000
      *                                                                 01980000
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                    RETURN_CODE                                         
                   ,AMT_ORIG_ENTERED                                    
                   ,DATE_TRANS                                          
                   ,CODE_TRAN_TYPE                                      
                FROM                                                    
                    #CSR04118_R1                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,AMT_ORIG_ENTERED                                            
MFA-TR*            ,DATE_TRANS                                                  
MFA-TR*            ,CODE_TRAN_TYPE                                              
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04118_R1                                         
MFA-TR*        END-EXEC.                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                                      
      *    DECLARE GTT FOR RESULT SET                                           
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04118_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04118_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04118_R1
               (                                                       
                    RETURN_CODE           INT                       
                   ,AMT_ORIG_ENTERED      DECIMAL(11,2)                 
                   ,DATE_TRANS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CODE_TRAN_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04118_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************02220000
      * 1000-PROCESS-INPUT.                                            *02230000
      ******************************************************************02270000
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-NUM           TO WS-ACCOUNT-NO-COMP3.     
           MOVE WS-ACCOUNT-NO-COMP3         TO AR-ACCOUNT-NO            
                                               KD-ACCOUNT-NO.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02760000
      * 2000-PROCESS-OUTPUT.                                           *02770000
      ******************************************************************02840000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 2100-PROCESS-AR-TRANS    THRU 2100-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
            MOVE RS-AMT-ORIG-ENTERED        TO S-AMT-ORIG-ENTERED.      
            MOVE RS-DATE-TRANS              TO S-DATE-TRANS.            
            MOVE RS-CODE-TRAN-TYPE          TO S-CODE-TRAN-TYPE.        
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  2100-PROCESS-AR-TRANS                                        * 04730000
      *                                                               * 04740000
      *    RETRIEVE THE CA DETAILS                                    * 04750000
      *                                                               * 04760000
      ***************************************************************** 04770000
      *                                                                 04771000
       2100-PROCESS-AR-TRANS.                                           
      *                                                                 04781000
           PERFORM 7000-SELECT-WRITEOFF-DT THRU 7000-EXIT.              
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE KD-FW-ACTION-DT          TO  WS-WRITEOFF-DT          
           END-IF.                                                      
                                                                        
           PERFORM 7100-OPEN-AR-TRANS-CURSOR          THRU 7100-EXIT.   
           PERFORM 7150-FETCH-AR-TRANS-CURSOR         THRU 7150-EXIT.   
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
                MOVE AR-AMT-ORIG-ENTERED         TO RS-AMT-ORIG-ENTERED 
                MOVE AR-DATE-TRANS               TO RS-DATE-TRANS       
                MOVE AR-CODE-TRAN-TYPE           TO RS-CODE-TRAN-TYPE   
                                                                        
                PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT   
                PERFORM 8100-SEND-RESULT              THRU 8100-EXIT    
                                                                        
                PERFORM 7150-FETCH-AR-TRANS-CURSOR    THRU 7150-EXIT    
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-AR-TRANS-CURSOR    THRU 7200-EXIT.        
                                                                        
           IF CTR-ROWS = 0                                              
              MOVE NOT-FOUND                     TO RS-RETURN-CODE      
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
      *                                                                 05051000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-SELECT-WRITEOFF-DT                                     **        
      **  SELECT WRITE OFF DATE FOR THE ACCOUNT                       **        
      ******************************************************************        
      *                                                                         
       7000-SELECT-WRITEOFF-DT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  FW_ACTION_DT                                          
              INTO                                                      
                  :KD-FW-ACTION-DT                                      
              FROM                                                      
                  CSS_FIN_WO_ACTION                                     
              WHERE                                                     
                  ACCOUNT_NO = :KD-ACCOUNT-NO                           
              AND FW_ACTION_TYPE_CD = 'WO'                              
              ORDER BY FW_SEQ_NO DESC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE KD-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05580100
      ***************************************************************** 05585000
      *                                                                 05585100
      * 7100-OPEN-AR-TRANS-CURSOR                                       05585200
      *                                                                 05585300
      ***************************************************************** 05585400
      *                                                                 05586000
       7100-OPEN-AR-TRANS-CURSOR.                                       
      *                                                                 05591000
           EXEC SQL                                                     
               OPEN AR_TRANS_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR_TRANS_HIST'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AR-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05595000
      ***************************************************************** 05597000
      *                                                                 05598000
      * 7150-FETCH-AR-TRANS-CURSOR                                      05599000
      *                                                                 05599100
      ***************************************************************** 05599200
      *                                                                 05599300
       7150-FETCH-AR-TRANS-CURSOR.                                      
      *                                                                 05599500
           EXEC SQL                                                     
               FETCH                                                    
                    AR_TRANS_CUR                                        
               INTO                                                     
                    :AR-AMT-ORIG-ENTERED                                
                   ,:AR-DATE-TRANS                                      
                   ,:AR-CODE-TRAN-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7150'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR_TRANS_HIST'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AR-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 05850500
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05850500
      ***************************************************************** 05603600
      * 7200-CLOSE-AR-TRANS-CURSOR                                    * 05603800
      *                                                               * 05603900
      ***************************************************************** 05604000
      *                                                                 05604100
       7200-CLOSE-AR-TRANS-CURSOR.                                      
      *                                                                 05604300
           EXEC SQL                                                     
               CLOSE AR_TRANS_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR_TRANS_HIST'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AR-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 05850800
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                                   
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04118_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04118_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04118_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  8100-SEND-RESULT                                              *        
      *                                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR04118_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,AMT_ORIG_ENTERED                                  
                     ,DATE_TRANS                                        
                     ,CODE_TRAN_TYPE                                    
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-AMT-ORIG-ENTERED                               
                     ,:S-DATE-TRANS                                     
                     ,:S-CODE-TRAN-TYPE                                 
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04118_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,AMT_ORIG_ENTERED                                          
MFA-TR*              ,DATE_TRANS                                                
MFA-TR*              ,CODE_TRAN_TYPE                                            
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-AMT-ORIG-ENTERED                                       
MFA-TR*              ,:S-DATE-TRANS                                             
MFA-TR*              ,:S-CODE-TRAN-TYPE                                         
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04118_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *                                                                 05867900
      ******************************************************************05868000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *05870000
      ******************************************************************05880000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************05930000
      *       END PROGRAM COPYLIB                                      *05940000
      ******************************************************************05950000
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
