       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04117.                                         
COB303 DATE-WRITTEN.  FEBRUARY 18, 2008                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM RETRIEVES A ROW FROM CSS_FIN_WO_ACTION AND       *00190000
      *  CSS_FIN_WO_COLLECT BASED ON ACCOUNT_NO AND ACTION_TYPE_CD     *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  02/18/08  MN90523    PROCEDURE ORIGINALLY CODED.              *00280000
      *                                                                *00290000
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04117'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04117 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CCA00001.                                               00600000
           COPY CWS00027.                                               00620000
           COPY CWS00303.                                               00630000
      *----< REDUCE EMBEDDED BLANKS              >                              
           COPY CWS00011.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00650000
      *    WORK AREAS                                                  *00660000
      ******************************************************************00670000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04117'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-SQLSTATE               PIC X(5).                      
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-COLL-AGY-EXIST-FLAG   PIC X(01) VALUE 'N'.            
           05  WS-WD-RSN-EXIST-FLAG     PIC X(01) VALUE 'N'.            
           05  WS-COLL-AGY-DESC.                                        
               10 WS-COLL-AGY-MAIN-DESC  PIC X(25) VALUE SPACES.        
               10 FILLER                 PIC X(03) VALUE ' - '.         
               10 WS-COLL-AGY-SUB-DESC   PIC X(25) VALUE SPACES.        
           05  WS-COMB-AGY-SUB-CODE.                                    
               10 WS-COLL-AGY-MAIN-CODE  PIC X(03) VALUE SPACES.        
               10 WS-COLL-AGY-SUB-CODE   PIC X(03) VALUE SPACES.        
                                                                        
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE +0.       
      *                                                                 00857000
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                           VALUE 'SESSION.CSR04117_R1'. 
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09)   COMP VALUE +0.     
           05  RS-ACTION-DATE           PIC X(10)    VALUE SPACES.      
           05  RS-ACTION-TYPE-CD        PIC X(05)    VALUE SPACES.      
           05  RS-CODE-COLLEC-AGNCY     PIC X(03)    VALUE SPACES.      
           05  RS-COLL-AGY-SUB-CD       PIC X(03)    VALUE SPACES.      
           05  RS-ACTION-AMT            PIC S9(9)V99 COMP-3 VALUE 0.    
           05  RS-WITHDRAW-DT           PIC X(10)    VALUE SPACES.      
           05  RS-WITHDRAW-AMT          PIC S9(9)V99 COMP-3 VALUE 0.    
           05  RS-WITHDRAW-RSN-CD       PIC X(25)    VALUE SPACES.      
           05  RS-COLL-SEQ-NO           PIC S9(04)   COMP VALUE +0.     
           05  RS-COMB-COLL-AGY-SUB     PIC X(55)    VALUE SPACE.       
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09)   COMP VALUE +0.      
           05  S-ACTION-DATE           PIC X(10)    VALUE SPACES.       
           05  S-ACTION-TYPE-CD        PIC X(05)    VALUE SPACES.       
           05  S-CODE-COLLEC-AGNCY     PIC X(03)    VALUE SPACES.       
           05  S-COLL-AGY-SUB-CD       PIC X(03)    VALUE SPACES.       
COB305     05 S-ACTION-AMT        PIC S9(9)V99 USAGE COMP-3 VALUE 0.       
           05  S-WITHDRAW-DT           PIC X(10)    VALUE SPACES.       
COB305     05 S-WITHDRAW-AMT        PIC S9(9)V99 USAGE COMP-3 VALUE 0.       
           05  S-WITHDRAW-RSN-CD       PIC X(25)    VALUE SPACES.       
           05  S-COLL-SEQ-NO           PIC S9(04)   COMP VALUE +0.      
           05  S-COMB-COLL-AGY-SUB     PIC X(55)    VALUE SPACE.        
                                                                        
           EXEC SQL                                                     01570000
              INCLUDE SQLCA                                             01580000
           END-EXEC.                                                    01590000
                                                                        
           EXEC SQL                                                     01610000
              INCLUDE TBMODEL                                           01620000
           END-EXEC.                                                    01630000
                                                                        
      **********************CSS_FIN_WO_ACTION - KD  *************               
           EXEC SQL                                                     01650000
             INCLUDE TBFWACTN                                           01660000
           END-EXEC.                                                    01670000
                                                                        
      **********************CSS_FIN_WO_COLLECT - IZ *************               
           EXEC SQL                                                     01690000
             INCLUDE TBFWCLAG                                           01700000
           END-EXEC.                                                    01710000
      ********************** CSS_COLLECT_AGENCY - Q7 ************               
           EXEC SQL                                                             
              INCLUDE TBCLAGNY                                                  
           END-EXEC.                                                            
                                                                        
      ********************** CSS_FW_ATTRIB_DESC - KV ************               
           EXEC SQL                                                             
              INCLUDE TBATTDES                                                  
           END-EXEC.                                                            
                                                                        
      ********************** CSS_COLL_AGY_ASSGN - KU ************               
           EXEC SQL                                                             
              INCLUDE TBCAASSN                                                  
           END-EXEC.                                                            
                                                                        
      ********************** CSS_COLL_AGY_ASSGN - KU ************               
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ********************** CSS_FW_ATTRIBUTE   - KC ************               
           EXEC SQL                                                             
              INCLUDE TBFWATTR                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                 01720500
      ***************************************************************   01720600
      * CURSOR DECLARATIONS                                             01720700
      ***************************************************************   01720800
      *                                                                 01720900
           EXEC SQL                                                     
              DECLARE CA_DETAIL_CUR CURSOR FOR                          
              SELECT                                                    
                  KD.FW_ACTION_DT                                       
                 ,KD.FW_ACTION_TYPE_CD                                  
                 ,IZ.CODE_COLLEC_AGNCY                                  
                 ,IZ.COLL_AGY_SUB_CD                                    
                 ,KD.FW_ACTION_AM                                       
                 ,IZ.WITHDRAW_DT                                        
                 ,IZ.WITHDRAW_AM                                        
                 ,IZ.WITHDRAW_REASON_CD                                 
                 ,KD.FW_SEQ_NO                                          
                 ,IZ.FW_COLL_SEQ_NO                                     
                 ,IZ.COMPANY_NO                                         
                 ,IZ.REG_GROUP_CD                                       
              FROM                                                      
                  CSS_FIN_WO_ACTION KD                                  
                 ,CSS_FIN_WO_COLLECT IZ                                 
              WHERE                                                     
                  KD.ACCOUNT_NO        = :KD-ACCOUNT-NO                 
              AND KD.FW_ACTION_TYPE_CD IN                               
                     ('1PLMT','2PLMT','3PLMT','ATY','SALE')             
              AND KD.FW_ACTION_AM      > 0                              
              AND KD.ACCOUNT_NO        = IZ.ACCOUNT_NO                  
              AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO              
              AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD           
              ORDER BY FW_ACTION_DT DESC                                
           END-EXEC.                                                    
      *                                                                 01722600
HPCCDM*EJECT                                                            01730000
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC  X(13).                 
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      *                                                                         
      ******************************************************************01760000
      * 0000-MAINLINE                                                  *01770000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01780000
      ******************************************************************01790000
      *                                                                 01800000
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************01900000
      * 0100-INITIALIZE                                                *01910000
      *   DECLARE RESULT SET CURSOR                                    *01920000
      *                                                                *01960000
      ******************************************************************01970000
      *                                                                 01980000
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
           EXEC SQL                                                     
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                    RETURN_CODE                                         
                   ,ACTION_DATE                                         
                   ,ACTION_TYPE_CD                                      
                   ,CODE_COLLEC_AGNCY                                   
                   ,COLL_AGY_SUB_CD                                     
                   ,ACTION_AMT                                          
                   ,WITHDRAW_DT                                         
                   ,WITHDRAW_AMT                                        
                   ,LTRIM(RTRIM(WITHDRAW_RSN_CD)) AS WITHDRAW_RSN_CD           
                   ,COLL_SEQ_NO                                         
                   ,COMB_COLL_AGY_SUB                                   
                FROM                                                    
                    #CSR04117_R1                                 
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,ACTION_DATE                                                 
MFA-TR*            ,ACTION_TYPE_CD                                              
MFA-TR*            ,CODE_COLLEC_AGNCY                                           
MFA-TR*            ,COLL_AGY_SUB_CD                                             
MFA-TR*            ,ACTION_AMT                                                  
MFA-TR*            ,WITHDRAW_DT                                                 
MFA-TR*            ,WITHDRAW_AMT                                                
MFA-TR*            ,STRIP(WITHDRAW_RSN_CD) AS WITHDRAW_RSN_CD                   
MFA-TR*            ,COLL_SEQ_NO                                                 
MFA-TR*            ,COMB_COLL_AGY_SUB                                           
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR04117_R1                                         
MFA-TR*        END-EXEC.                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                                      
      *    DECLARE GTT FOR RESULT SET                                           
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04117_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04117_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04117_R1
               (                                                       
                    RETURN_CODE            INT                      
                   ,ACTION_DATE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,ACTION_TYPE_CD CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,CODE_COLLEC_AGNCY CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,COLL_AGY_SUB_CD CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,ACTION_AMT             DECIMAL(11,2)                
                   ,WITHDRAW_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,WITHDRAW_AMT           DECIMAL(11,2)                
                   ,WITHDRAW_RSN_CD CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                   ,COLL_SEQ_NO            SMALLINT                     
                   ,COMB_COLL_AGY_SUB CHAR(55)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04117_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************02220000
      * 1000-PROCESS-INPUT.                                            *02230000
      *                                                                *02240000
      *     1. RECEIVE PARMS.                                          *02250000
      *                                                                *02260000
      ******************************************************************02270000
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-NUM           TO WS-ACCOUNT-NO-COMP3.     
           MOVE WS-ACCOUNT-NO-COMP3         TO KD-ACCOUNT-NO            
                                               AT-ACCOUNT-NO.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************02760000
      * 2000-PROCESS-OUTPUT.                                           *02770000
      *                                                                *02780000
      *     1. DESCRIBE RESULT SET                                     *02790000
      *     2. UPDATE DB2 DATA                                         *02800000
      *     3. BUILD RESULT SET                                        *02810000
      *     4. SEND RESULT SET                                         *02820000
      *                                                                *02830000
      ******************************************************************02840000
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 2100-PROCESS-CA-DETAILS  THRU 2100-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
            MOVE RS-ACTION-DATE             TO S-ACTION-DATE.           
            MOVE RS-ACTION-TYPE-CD          TO S-ACTION-TYPE-CD.        
            MOVE RS-CODE-COLLEC-AGNCY       TO S-CODE-COLLEC-AGNCY.     
            MOVE RS-COLL-AGY-SUB-CD         TO S-COLL-AGY-SUB-CD.       
            MOVE RS-ACTION-AMT              TO S-ACTION-AMT.            
            MOVE RS-WITHDRAW-DT             TO S-WITHDRAW-DT.           
            MOVE RS-WITHDRAW-AMT            TO S-WITHDRAW-AMT.          
            MOVE RS-WITHDRAW-RSN-CD         TO S-WITHDRAW-RSN-CD.       
            MOVE RS-COLL-SEQ-NO             TO S-COLL-SEQ-NO.           
            MOVE RS-COMB-COLL-AGY-SUB       TO S-COMB-COLL-AGY-SUB.     
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  2100-PROCESS-CA-DETAILS                                      * 04730000
      *                                                               * 04740000
      *    RETRIEVE THE CA DETAILS                                    * 04750000
      *                                                               * 04760000
      ***************************************************************** 04770000
      *                                                                 04771000
       2100-PROCESS-CA-DETAILS.                                         
      *                                                                 04781000
           PERFORM 7050-SELECT-ACCOUNT-DETAILS        THRU 7050-EXIT.   
                                                                        
           IF AT-ACCOUNT-TYPE-CODE NOT = 'R' AND NOT = 'C'              
              MOVE 'O'                         TO AT-ACCOUNT-TYPE-CODE  
           END-IF.                                                      
                                                                        
           PERFORM 7100-OPEN-CA-DETAIL-CURSOR         THRU 7100-EXIT.   
           PERFORM 7150-FETCH-CA-DETAIL-CURSOR        THRU 7150-EXIT.   
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE 'N'                       TO WS-COLL-AGY-EXIST-FLAG  
                                                WS-WD-RSN-EXIST-FLAG    
                                                                        
              IF IZ-CODE-COLLEC-AGNCY > SPACES AND                      
                 IZ-COLL-AGY-SUB-CD > SPACES                            
                 MOVE IZ-COMPANY-NO          TO KU-COMPANY-NO           
                 MOVE IZ-REG-GROUP-CD        TO KU-REG-GROUP-CD         
                 MOVE AT-ACCOUNT-TYPE-CODE   TO KU-COLL-ACCT-TYPE-CD    
                 MOVE KD-FW-ACTION-TYPE-CD   TO KU-FW-ACTION-TYPE-CD    
                 MOVE IZ-CODE-COLLEC-AGNCY   TO KU-CODE-COLLEC-AGNCY    
                 MOVE IZ-COLL-AGY-SUB-CD     TO KU-COLL-AGENCY-SUB-CD   
                                                                        
                 PERFORM 7240-CHECK-COLL-AGY-EXPIRY THRU 7240-EXIT      
                                                                        
              END-IF                                                    
                                                                        
              IF WS-COLL-AGY-EXIST-FLAG = 'Y' OR                        
                 IZ-CODE-COLLEC-AGNCY = SPACES OR                       
                 IZ-COLL-AGY-SUB-CD = SPACES                            
                 MOVE IZ-CODE-COLLEC-AGNCY     TO RS-CODE-COLLEC-AGNCY  
                                                  WS-COLL-AGY-MAIN-CODE 
                 MOVE IZ-COLL-AGY-SUB-CD       TO RS-COLL-AGY-SUB-CD    
                                                  WS-COLL-AGY-SUB-CODE  
                 MOVE WS-COMB-AGY-SUB-CODE     TO RS-COMB-COLL-AGY-SUB  
              ELSE                                                      
                 MOVE IZ-CODE-COLLEC-AGNCY     TO RS-CODE-COLLEC-AGNCY  
                 MOVE IZ-COLL-AGY-SUB-CD       TO RS-COLL-AGY-SUB-CD    
                                                                        
                 MOVE IZ-CODE-COLLEC-AGNCY      TO Q7-CODE-COLLEC-AGNCY 
                 PERFORM 7250-GET-COLL-AGY-DESC THRU 7250-EXIT          
                 MOVE Q7-COLLEC-AGNCY-NAME      TO WS-COLL-AGY-MAIN-DESC
                                                                        
                 MOVE 'AS'                      TO KV-FW-ATTRIB-TYPE-CD 
                 MOVE IZ-COLL-AGY-SUB-CD        TO KV-FW-ATTR-VALUE-CD  
                 PERFORM 7300-GET-ATTRIB-VALUE-DESC                     
                                                THRU 7300-EXIT          
                 MOVE KV-FW-ATTR-VALUE-DESC     TO WS-COLL-AGY-SUB-DESC 
                                                                        
                 MOVE LENGTH OF WS-COLL-AGY-DESC TO WS-EMB-LENG         
                 MOVE WS-COLL-AGY-DESC          TO WS-EMB-INPUT         
                 MOVE SPACES                    TO WS-CMP-TABLE         
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT     
                 MOVE WS-CMP-TABLE              TO RS-COMB-COLL-AGY-SUB 
              END-IF                                                    
                                                                        
              IF IZ-WITHDRAW-REASON-CD > SPACES                         
                 MOVE IZ-COMPANY-NO          TO KU-COMPANY-NO           
                 MOVE IZ-REG-GROUP-CD        TO KU-REG-GROUP-CD         
                 MOVE 'WD'                   TO KC-FW-ATTRIB-TYPE-CD    
                 MOVE IZ-WITHDRAW-REASON-CD  TO KC-FW-ATTR-VALUE-CD     
                 PERFORM 7350-CHECK-WD-RSN-EXPIRY   THRU 7350-EXIT      
              END-IF                                                    
                                                                        
              IF WS-WD-RSN-EXIST-FLAG = 'Y' OR                          
                 IZ-WITHDRAW-REASON-CD = SPACES                         
                 MOVE IZ-WITHDRAW-REASON-CD    TO RS-WITHDRAW-RSN-CD    
              ELSE                                                      
                 MOVE 'WD'                      TO KV-FW-ATTRIB-TYPE-CD 
                 MOVE IZ-WITHDRAW-REASON-CD     TO KV-FW-ATTR-VALUE-CD  
                 PERFORM 7300-GET-ATTRIB-VALUE-DESC                     
                                                THRU 7300-EXIT          
                 MOVE KV-FW-ATTR-VALUE-DESC     TO RS-WITHDRAW-RSN-CD   
              END-IF                                                    
                                                                        
              MOVE KD-FW-ACTION-DT              TO RS-ACTION-DATE       
              MOVE KD-FW-ACTION-TYPE-CD         TO RS-ACTION-TYPE-CD    
              MOVE KD-FW-ACTION-AM              TO RS-ACTION-AMT        
              MOVE IZ-WITHDRAW-DT               TO RS-WITHDRAW-DT       
              MOVE IZ-WITHDRAW-AM               TO RS-WITHDRAW-AMT      
              MOVE IZ-FW-COLL-SEQ-NO            TO RS-COLL-SEQ-NO       
                                                                        
              PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
                                                                        
              PERFORM 7150-FETCH-CA-DETAIL-CURSOR THRU 7150-EXIT        
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7200-CLOSE-CA-DETAIL-CURSOR   THRU 7200-EXIT.        
                                                                        
           IF CTR-ROWS = 0                                              
              MOVE NOT-FOUND                     TO RS-RETURN-CODE      
              PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
      *                                                                 05051000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7050-SELECT-ACCOUNT-DETAILS                                    *         
      *****************************************************************         
      *                                                                         
       7050-SELECT-ACCOUNT-DETAILS.                                     
                                                                        
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    ACCOUNT_TYPE_CODE                                   
               INTO                                                     
                   :AT-ACCOUNT-TYPE-CODE                                
               FROM                                                     
                   CSS_ACCOUNT WITH(READUNCOMMITTED)                            
               WHERE                                                    
                    ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             ACCOUNT_TYPE_CODE                                           
MFA-TR*        INTO                                                             
MFA-TR*            :AT-ACCOUNT-TYPE-CODE                                        
MFA-TR*        FROM                                                             
MFA-TR*            CSS_ACCOUNT                                                  
MFA-TR*        WHERE                                                            
MFA-TR*             ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                 05580100
      ***************************************************************** 05585000
      *                                                                 05585100
      * 7100-OPEN-CA-DETAIL-CURSOR                                      05585200
      *                                                                 05585300
      ***************************************************************** 05585400
      *                                                                 05586000
       7100-OPEN-CA-DETAIL-CURSOR.                                      
      *                                                                 05591000
           EXEC SQL                                                     
               OPEN CA_DETAIL_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_FIN_WO_ACTION'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE KD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05595000
      ***************************************************************** 05597000
      *                                                                 05598000
      * 7150-FETCH-CA-DETAIL-CURSOR                                     05599000
      *                                                                 05599100
      ***************************************************************** 05599200
      *                                                                 05599300
       7150-FETCH-CA-DETAIL-CURSOR.                                     
      *                                                                 05599500
           EXEC SQL                                                     
               FETCH                                                    
                    CA_DETAIL_CUR                                       
               INTO                                                     
                    :KD-FW-ACTION-DT                                    
                   ,:KD-FW-ACTION-TYPE-CD                               
                   ,:IZ-CODE-COLLEC-AGNCY                               
                   ,:IZ-COLL-AGY-SUB-CD                                 
                   ,:KD-FW-ACTION-AM                                    
                   ,:IZ-WITHDRAW-DT :WS-NULL-IND1                        
                   ,:IZ-WITHDRAW-AM                                     
                   ,:IZ-WITHDRAW-REASON-CD                              
                   ,:KD-FW-SEQ-NO                                       
                   ,:IZ-FW-COLL-SEQ-NO                                  
                   ,:IZ-COMPANY-NO                                      
                   ,:IZ-REG-GROUP-CD :WS-NULL-IND2                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-IND1 < 0                                    
                    MOVE SPACES           TO IZ-WITHDRAW-DT             
                    MOVE ZERO             TO WS-NULL-IND1               
                 END-IF                                                 
                 IF WS-NULL-IND2 < 0                                    
                    MOVE SPACES           TO IZ-REG-GROUP-CD            
                    MOVE ZERO             TO WS-NULL-IND2               
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7150'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_FIN_WO_ACTION'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE KD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 05850500
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05850500
      ***************************************************************** 05603600
      * 7200-CLOSE-CA-DETAIL-CURSOR                                   * 05603800
      *                                                               * 05603900
      ***************************************************************** 05604000
      *                                                                 05604100
       7200-CLOSE-CA-DETAIL-CURSOR.                                     
      *                                                                 05604300
           EXEC SQL                                                     
               CLOSE CA_DETAIL_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_FIN_WO_ACTION'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE KD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 05850800
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7240-CHECK-COLL-AGY-EXPIRY                                     *        
      ******************************************************************        
      *                                                                         
       7240-CHECK-COLL-AGY-EXPIRY.                                      
                                                                        
           MOVE '7240'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                   :WS-COLL-AGY-EXIST-FLAG                              
              FROM                                                      
                   CSS_COLL_AGY_ASSGN WITH(READUNCOMMITTED)                     
              WHERE                                                     
                  COMPANY_NO          = :KU-COMPANY-NO                  
              AND REG_GROUP_CD        = :KU-REG-GROUP-CD                
              AND COLL_ACCT_TYPE_CD   = :KU-COLL-ACCT-TYPE-CD           
              AND FW_ACTION_TYPE_CD   = :KU-FW-ACTION-TYPE-CD           
              AND CODE_COLLEC_AGNCY   = :KU-CODE-COLLEC-AGNCY           
              AND COLL_AGENCY_SUB_CD  = :KU-COLL-AGENCY-SUB-CD          
              AND EFFECTIVE_DATE     <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
              AND EXPIRATION_DT      >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            'Y'                                                          
MFA-TR*       INTO                                                              
MFA-TR*            :WS-COLL-AGY-EXIST-FLAG                                      
MFA-TR*       FROM                                                              
MFA-TR*            CSS_COLL_AGY_ASSGN                                           
MFA-TR*       WHERE                                                             
MFA-TR*           COMPANY_NO          = :KU-COMPANY-NO                          
MFA-TR*       AND REG_GROUP_CD        = :KU-REG-GROUP-CD                        
MFA-TR*       AND COLL_ACCT_TYPE_CD   = :KU-COLL-ACCT-TYPE-CD                   
MFA-TR*       AND FW_ACTION_TYPE_CD   = :KU-FW-ACTION-TYPE-CD                   
MFA-TR*       AND CODE_COLLEC_AGNCY   = :KU-CODE-COLLEC-AGNCY                   
MFA-TR*       AND COLL_AGENCY_SUB_CD  = :KU-COLL-AGENCY-SUB-CD                  
MFA-TR*       AND EFFECTIVE_DATE     <= CURRENT DATE                            
MFA-TR*       AND EXPIRATION_DT      >= CURRENT DATE                            
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COLL_AGY_ASSGN'       TO TABLE-1                
              MOVE 'CODE_COLLEC_AGNCY'        TO TABLE-ELEMENT-1        
              MOVE KU-CODE-COLLEC-AGNCY       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-GET-COLL-AGY-DESC                                         *        
      ******************************************************************        
      *                                                                         
       7250-GET-COLL-AGY-DESC.                                          
                                                                        
           MOVE '7250'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COLLEC_AGNCY_NAME                                   
              INTO                                                      
                  :Q7-COLLEC-AGNCY-NAME                                 
              FROM                                                      
                   CSS_COLLECT_AGENCY WITH(READUNCOMMITTED)                     
              WHERE                                                     
                  CODE_COLLEC_AGNCY   = :Q7-CODE-COLLEC-AGNCY           
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            COLLEC_AGNCY_NAME                                            
MFA-TR*       INTO                                                              
MFA-TR*           :Q7-COLLEC-AGNCY-NAME                                         
MFA-TR*       FROM                                                              
MFA-TR*            CSS_COLLECT_AGENCY                                           
MFA-TR*       WHERE                                                             
MFA-TR*           CODE_COLLEC_AGNCY   = :Q7-CODE-COLLEC-AGNCY                   
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE Q7-CODE-COLLEC-AGNCY    TO Q7-COLLEC-AGNCY-NAME   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COLLECT_AGENCY'       TO TABLE-1                
              MOVE 'CODE_COLLEC_AGNCY'        TO TABLE-ELEMENT-1        
              MOVE Q7-CODE-COLLEC-AGNCY       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-ATTRIB-VALUE-DESC                                     *        
      ******************************************************************        
      *                                                                         
       7300-GET-ATTRIB-VALUE-DESC.                                      
                                                                        
           MOVE '7300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FW_ATTR_VALUE_DESC                                  
              INTO                                                      
                  :KV-FW-ATTR-VALUE-DESC                                
              FROM                                                      
                   CSS_FW_ATTRIB_DESC WITH(READUNCOMMITTED)                     
              WHERE                                                     
                  FW_ATTRIB_TYPE_CD   = :KV-FW-ATTRIB-TYPE-CD           
              AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD            
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            FW_ATTR_VALUE_DESC                                           
MFA-TR*       INTO                                                              
MFA-TR*           :KV-FW-ATTR-VALUE-DESC                                        
MFA-TR*       FROM                                                              
MFA-TR*            CSS_FW_ATTRIB_DESC                                           
MFA-TR*       WHERE                                                             
MFA-TR*           FW_ATTRIB_TYPE_CD   = :KV-FW-ATTRIB-TYPE-CD                   
MFA-TR*       AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD                    
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE KV-FW-ATTR-VALUE-CD     TO KV-FW-ATTR-VALUE-DESC  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FW_ATTRIB_DESC'       TO TABLE-1                
              MOVE 'FW_ATTR_VALUE_CD'         TO TABLE-ELEMENT-1        
              MOVE KV-FW-ATTR-VALUE-CD        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7350-CHECK-WD-RSN-EXPIRY                                       *        
      ******************************************************************        
      *                                                                         
       7350-CHECK-WD-RSN-EXPIRY.                                        
                                                                        
           MOVE '7350'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                   :WS-WD-RSN-EXIST-FLAG                                
              FROM                                                      
                   CSS_FW_ATTRIBUTE WITH(READUNCOMMITTED)                       
              WHERE                                                     
                  COMPANY_NO          = :KC-COMPANY-NO                  
              AND REG_GROUP_CD        = :KC-REG-GROUP-CD                
              AND FW_ATTRIB_TYPE_CD   = :KC-FW-ATTRIB-TYPE-CD           
              AND FW_ATTR_VALUE_CD    = :KC-FW-ATTR-VALUE-CD            
              AND EFFECTIVE_DT       <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
              AND EXPIRATION_DT      >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            'Y'                                                          
MFA-TR*       INTO                                                              
MFA-TR*            :WS-WD-RSN-EXIST-FLAG                                        
MFA-TR*       FROM                                                              
MFA-TR*            CSS_FW_ATTRIBUTE                                             
MFA-TR*       WHERE                                                             
MFA-TR*           COMPANY_NO          = :KC-COMPANY-NO                          
MFA-TR*       AND REG_GROUP_CD        = :KC-REG-GROUP-CD                        
MFA-TR*       AND FW_ATTRIB_TYPE_CD   = :KC-FW-ATTRIB-TYPE-CD                   
MFA-TR*       AND FW_ATTR_VALUE_CD    = :KC-FW-ATTR-VALUE-CD                    
MFA-TR*       AND EFFECTIVE_DT       <= CURRENT DATE                            
MFA-TR*       AND EXPIRATION_DT      >= CURRENT DATE                            
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FW_ATTRIBUTE'         TO TABLE-1                
              MOVE 'FW_ATTR_VALUE_CD'         TO TABLE-ELEMENT-1        
              MOVE KC-FW-ATTR-VALUE-CD        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                                   
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04117_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04117_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04117_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  8100-SEND-RESULT                                              *        
      *                                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR04117_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,ACTION_DATE                                       
                     ,ACTION_TYPE_CD                                    
                     ,CODE_COLLEC_AGNCY                                 
                     ,COLL_AGY_SUB_CD                                   
                     ,ACTION_AMT                                        
                     ,WITHDRAW_DT                                       
                     ,WITHDRAW_AMT                                      
                     ,WITHDRAW_RSN_CD                                   
                     ,COLL_SEQ_NO                                       
                     ,COMB_COLL_AGY_SUB                                 
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-ACTION-DATE                                    
                     ,:S-ACTION-TYPE-CD                                 
                     ,:S-CODE-COLLEC-AGNCY                              
                     ,:S-COLL-AGY-SUB-CD                                
                     ,:S-ACTION-AMT                                     
                     ,:S-WITHDRAW-DT                                    
                     ,:S-WITHDRAW-AMT                                   
                     ,:S-WITHDRAW-RSN-CD                                
                     ,:S-COLL-SEQ-NO                                    
                     ,:S-COMB-COLL-AGY-SUB                              
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04117_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,ACTION_DATE                                               
MFA-TR*              ,ACTION_TYPE_CD                                            
MFA-TR*              ,CODE_COLLEC_AGNCY                                         
MFA-TR*              ,COLL_AGY_SUB_CD                                           
MFA-TR*              ,ACTION_AMT                                                
MFA-TR*              ,WITHDRAW_DT                                               
MFA-TR*              ,WITHDRAW_AMT                                              
MFA-TR*              ,WITHDRAW_RSN_CD                                           
MFA-TR*              ,COLL_SEQ_NO                                               
MFA-TR*              ,COMB_COLL_AGY_SUB                                         
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-ACTION-DATE                                            
MFA-TR*              ,:S-ACTION-TYPE-CD                                         
MFA-TR*              ,:S-CODE-COLLEC-AGNCY                                      
MFA-TR*              ,:S-COLL-AGY-SUB-CD                                        
MFA-TR*              ,:S-ACTION-AMT                                             
MFA-TR*              ,:S-WITHDRAW-DT                                            
MFA-TR*              ,:S-WITHDRAW-AMT                                           
MFA-TR*              ,:S-WITHDRAW-RSN-CD                                        
MFA-TR*              ,:S-COLL-SEQ-NO                                            
MFA-TR*              ,:S-COMB-COLL-AGY-SUB                                      
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04117_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  6010-REDUCE-EMBEDDED-SPACES                                   *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00004                                             
              END-EXEC.                                                         
      *                                                                 05867900
      ******************************************************************05868000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *05870000
      ******************************************************************05880000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************05930000
      *       END PROGRAM COPYLIB                                      *05940000
      ******************************************************************05950000
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
