       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04115.                                          
       DATE-WRITTEN. JUN 17, 2008.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS CALLED BY THE CSR DESKTOP.                    *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL DB2 STORED PROCEDURE THAT RETRIVES    *        
      *  PLACEMENT RECORDS FOR A GIVEN ACCOUNT                         *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  06/17/08  MN90523    INITIAL VERSION                          *        
P00799*  04/29/15  RC41079    CHANGE RETURN-CODE TO INTEGER DUE TO MOD *        
P00799*                       GIVING EXCEPTION WITH AS SMALLINT        *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04115'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04115 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_FIN_WO_COLLECT - IZ >                                           
           EXEC SQL                                                             
              INCLUDE TBFWCLAG                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_FIN_WO_ACTION  - KD >                                           
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT        - AT >                                           
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_REG_PROFILE    - LR >                                           
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_COLLECT_AGENCY - Q7 >                                           
           EXEC SQL                                                             
              INCLUDE TBCLAGNY                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_FW_ATTRIB_DESC - KV >                                           
           EXEC SQL                                                             
              INCLUDE TBATTDES                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_COLL_AGY_ASSGN - KU >                                           
           EXEC SQL                                                             
              INCLUDE TBCAASSN                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CHRG_OFF       - CO >                                           
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
                                                                        
      *----< ERROR HANDLING >                                                   
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
      *----< REDUCE EMBEDDED BLANKS              >                              
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                             'SESSION.CSR04115_R1'.     
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-IS-RSP-AREA-NULL     PIC X(01) VALUE 'Y'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-FW-ACTION-TYPE-CD     PIC X(05)  VALUE SPACE.          
           05  S-FW-ACTION-DT          PIC X(10)  VALUE SPACE.          
           05  S-WITHDRAW-DT           PIC X(10)  VALUE SPACE.          
           05  S-COLL-AGY-SUB-CD       PIC X(03)  VALUE SPACE.          
           05  S-CODE-COLLEC-AGNCY     PIC X(03)  VALUE SPACE.          
           05  S-FW-COLL-SEQ-NO        PIC S9(09) COMP VALUE 0.         
           05  S-COMB-COLL-AGY-SUB     PIC X(55)  VALUE SPACE.          
           05  S-CA206-LAST-RUN-DT     PIC X(10)  VALUE SPACE.          
           05  S-WO-BALANCE            PIC S9(9)V9(2) COMP-3 VALUE 0.   
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04115'.    
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           05  WS-ACCOUNT-NO-JST         PIC X(13) JUSTIFIED RIGHT.     
COB305     05 WS-ACCOUNT-NO-DEC        PIC S9(13) USAGE COMP-3 VALUE 0.       
           05  WS-ACTION-TYPE            PIC X(05).                     
           05  WS-COMPANY-NO             PIC X(02).                     
           05  WS-CA206-LAST-RUN-DATE    PIC X(10) VALUE SPACES.        
           05  WS-PARM-DATA              PIC X(80).                     
           05  WS-LAST-RUN-DATE-PARM.                                   
               10 FILLER               PIC X(14) VALUE 'LAST RUN DATE='.
               10 WS-LAST-RUN-DATE     PIC X(10) VALUE SPACES.          
               10 FILLER               PIC X(56) VALUE SPACES.          
           05  WS-PATH-TYPE-CD           PIC X(02).                     
           05  WS-COLL-AGY-DESC.                                        
               10 WS-COLL-AGY-MAIN-DESC  PIC X(25) VALUE SPACES.        
               10 FILLER                 PIC X(03) VALUE ' - '.         
               10 WS-COLL-AGY-SUB-DESC   PIC X(25) VALUE SPACES.        
           05  WS-COMB-AGY-SUB-CODE.                                    
               10 WS-COLL-AGY-MAIN-CODE  PIC X(03) VALUE SPACES.        
               10 WS-COLL-AGY-SUB-CODE   PIC X(03) VALUE SPACES.        
           05  WS-COLL-AGY-EXIST-FLAG    PIC X(01) VALUE 'N'.           
           05  WS-IZ-WITHDRAW-DT-NULL    PIC S9(04) COMP VALUE 0.       
           05  WS-CO-AMT-TRANS-NULL      PIC S9(04) COMP VALUE 0.       
           05  WS-SEQ-NO                 PIC S9(09) COMP VALUE 0.       
           05  WS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-END-FLAG             PIC X(01) VALUE 'N'.             
               88 WS-END-LOAD                    VALUE 'Y'.             
                                                                        
      *****************************************************************         
      **       CURSOR DECLARATIONS                                    *         
      *****************************************************************         
           EXEC SQL                                                     
               DECLARE FIN_WO_ACTION_CUR CURSOR FOR                     
               SELECT                                                   
                      KD.FW_ACTION_TYPE_CD                              
                     ,KD.FW_ACTION_DT                                   
                     ,IZ.WITHDRAW_DT                                    
                     ,IZ.COLL_AGY_SUB_CD                                
                     ,IZ.CODE_COLLEC_AGNCY                              
                     ,IZ.FW_COLL_SEQ_NO                                 
                 FROM CSS_FIN_WO_ACTION KD WITH(READUNCOMMITTED)                
                     ,CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)               
                WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO             
                  AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD      
                  AND KD.FW_SEQ_NO         = :KD-FW-SEQ-NO              
                  AND IZ.ACCOUNT_NO        = KD.ACCOUNT_NO              
                  AND IZ.FW_ACTION_TYPE_CD = KD.FW_ACTION_TYPE_CD       
                  AND IZ.FW_COLL_SEQ_NO    = KD.FW_SEQ_NO               
               FOR READ ONLY                                    
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FIN_WO_ACTION_CUR CURSOR FOR                             
MFA-TR*        SELECT                                                           
MFA-TR*               KD.FW_ACTION_TYPE_CD                                      
MFA-TR*              ,KD.FW_ACTION_DT                                           
MFA-TR*              ,IZ.WITHDRAW_DT                                            
MFA-TR*              ,IZ.COLL_AGY_SUB_CD                                        
MFA-TR*              ,IZ.CODE_COLLEC_AGNCY                                      
MFA-TR*              ,IZ.FW_COLL_SEQ_NO                                         
MFA-TR*          FROM CSS_FIN_WO_ACTION KD                                      
MFA-TR*              ,CSS_FIN_WO_COLLECT IZ                                     
MFA-TR*         WHERE KD.ACCOUNT_NO        = :KD-ACCOUNT-NO                     
MFA-TR*           AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD              
MFA-TR*           AND KD.FW_SEQ_NO         = :KD-FW-SEQ-NO                      
MFA-TR*           AND IZ.ACCOUNT_NO        = KD.ACCOUNT_NO                      
MFA-TR*           AND IZ.FW_ACTION_TYPE_CD = KD.FW_ACTION_TYPE_CD               
MFA-TR*           AND IZ.FW_COLL_SEQ_NO    = KD.FW_SEQ_NO                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC X(13).                  
       01  PARM-SEQ-NO                      PIC S9(04) COMP.            
       01  PARM-ACTION-TYPE-CD              PIC X(05).                  
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION USING                                         
                          PARM-ACCOUNT-NO                               
                          PARM-SEQ-NO                                   
                          PARM-ACTION-TYPE-CD.                          
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
                 SELECT                                                 
                     RETURN_CODE                                        
                    ,FW_ACTION_TYPE_CD                                  
                    ,FW_ACTION_DT                                       
                    ,WITHDRAW_DT                                        
                    ,COLL_AGY_SUB_CD                                    
                    ,CODE_COLLEC_AGNCY                                  
                    ,FW_COLL_SEQ_NO                                     
                    ,COMB_COLL_AGY_SUB                                  
                    ,CA206_LAST_RUN_DT                                  
                    ,WO_BALANCE                                         
                 FROM                                                   
                     #CSR04115_R1                                
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*          SELECT                                                         
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,FW_ACTION_TYPE_CD                                          
MFA-TR*             ,FW_ACTION_DT                                               
MFA-TR*             ,WITHDRAW_DT                                                
MFA-TR*             ,COLL_AGY_SUB_CD                                            
MFA-TR*             ,CODE_COLLEC_AGNCY                                          
MFA-TR*             ,FW_COLL_SEQ_NO                                             
MFA-TR*             ,COMB_COLL_AGY_SUB                                          
MFA-TR*             ,CA206_LAST_RUN_DT                                          
MFA-TR*             ,WO_BALANCE                                                 
MFA-TR*          FROM                                                           
MFA-TR*              SESSION.CSR04115_R1                                        
MFA-TR*      END-EXEC.                                                          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04115_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04115_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04115_R1
              (                                                       
P00799              RETURN_CODE          INT                        
                   ,FW_ACTION_TYPE_CD CHAR(05)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,FW_ACTION_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,WITHDRAW_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,COLL_AGY_SUB_CD CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CODE_COLLEC_AGNCY CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,FW_COLL_SEQ_NO       SMALLINT                       
                   ,COMB_COLL_AGY_SUB CHAR(55)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,CA206_LAST_RUN_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                   ,WO_BALANCE           DECIMAL(11,2)                  
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
                  MOVE SQLCODE            TO ABEND-SQLCODE              
                  MOVE SQLSTATE           TO ABEND-SQLSTATE             
                  MOVE '0100A'            TO ACTIVE-PARAGRAPH           
                  MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
                  MOVE SPACES             TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                  MOVE 'CSR04115_R1'      TO TABLE-1                    
                  MOVE SPACES             TO TABLE-ELEMENT-1            
                  MOVE SPACES             TO HOSTVAR-ELEMENT-1          
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                          THRU  9900-EXIT               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO-JST.       
           MOVE WS-ACCOUNT-NO-JST           TO WS-ACCOUNT-NO-DEC.       
           MOVE WS-ACCOUNT-NO-DEC           TO KD-ACCOUNT-NO            
                                               AT-ACCOUNT-NO            
                                               CO-ACCOUNT-NO            
                                               LR-ACCOUNT-NO.           
           MOVE PARM-SEQ-NO                 TO KD-FW-SEQ-NO.            
           MOVE PARM-ACTION-TYPE-CD         TO KD-FW-ACTION-TYPE-CD.    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *           2300-BUILD-RESULT                                    *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 2300-BUILD-RESULT        THRU 2300-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2300-BUILD-RESULT.                                               
                                                                        
           PERFORM 7050-SELECT-REG-GROUP-CD      THRU 7050-EXIT.        
           PERFORM 7100-SELECT-ACCOUNT-DETAILS   THRU 7100-EXIT.        
           MOVE AT-COMPANY-NO                    TO WS-COMPANY-NO.      
           PERFORM 2400-GET-LAST-RUN-DT          THRU 2400-EXIT.        
           MOVE WS-CA206-LAST-RUN-DATE           TO S-CA206-LAST-RUN-DT 
           PERFORM 7400-GET-BALANCE              THRU 7400-EXIT.        
           MOVE CO-AMT-TRANS                     TO S-WO-BALANCE.       
                                                                        
           IF AT-ACCOUNT-TYPE-CODE NOT = 'R' AND NOT = 'C'              
              MOVE 'O'                         TO AT-ACCOUNT-TYPE-CODE  
           END-IF.                                                      
                                                                        
           PERFORM 7200-OPEN-FIN-WO-ACTN-CURSOR  THRU 7200-EXIT.        
           PERFORM 7220-FETCH-FIN-WO-ACTN-CURSOR THRU 7220-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE 'N'                         TO WS-COLL-AGY-EXIST-FLAG
              MOVE AT-COMPANY-NO               TO KU-COMPANY-NO         
              MOVE LR-REG-GROUP-CD             TO KU-REG-GROUP-CD       
              MOVE AT-ACCOUNT-TYPE-CODE        TO KU-COLL-ACCT-TYPE-CD  
              MOVE KD-FW-ACTION-TYPE-CD        TO KU-FW-ACTION-TYPE-CD  
              MOVE IZ-CODE-COLLEC-AGNCY        TO KU-CODE-COLLEC-AGNCY  
              MOVE IZ-COLL-AGY-SUB-CD          TO KU-COLL-AGENCY-SUB-CD 
                                                                        
              IF IZ-CODE-COLLEC-AGNCY > SPACES AND                      
                 IZ-COLL-AGY-SUB-CD > SPACES                            
                 PERFORM 7240-CHECK-COLL-AGY-EXPIRY THRU 7240-EXIT      
              END-IF                                                    
                                                                        
              IF WS-COLL-AGY-EXIST-FLAG = 'N'  AND                      
                 IZ-CODE-COLLEC-AGNCY > SPACES AND                      
                 IZ-COLL-AGY-SUB-CD > SPACES                            
                                                                        
                 MOVE IZ-CODE-COLLEC-AGNCY      TO Q7-CODE-COLLEC-AGNCY 
                 PERFORM 7250-GET-COLL-AGY-DESC THRU 7250-EXIT          
                 MOVE Q7-COLLEC-AGNCY-NAME      TO WS-COLL-AGY-MAIN-DESC
                                                                        
                 MOVE IZ-COLL-AGY-SUB-CD        TO KV-FW-ATTR-VALUE-CD  
                 PERFORM 7300-GET-COLL-AGY-SUB-DESC                     
                                                THRU 7300-EXIT          
                 MOVE KV-FW-ATTR-VALUE-DESC     TO WS-COLL-AGY-SUB-DESC 
                                                                        
                 MOVE LENGTH OF WS-COLL-AGY-DESC TO WS-EMB-LENG         
                 MOVE WS-COLL-AGY-DESC          TO WS-EMB-INPUT         
                 MOVE SPACES                    TO WS-CMP-TABLE         
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT     
                 MOVE WS-CMP-TABLE              TO S-COMB-COLL-AGY-SUB  
              ELSE                                                      
                 MOVE IZ-COLL-AGY-SUB-CD        TO WS-COLL-AGY-SUB-CODE 
                 MOVE IZ-CODE-COLLEC-AGNCY      TO WS-COLL-AGY-MAIN-CODE
                 MOVE WS-COMB-AGY-SUB-CODE      TO S-COMB-COLL-AGY-SUB  
              END-IF                                                    
                                                                        
              MOVE KD-FW-ACTION-TYPE-CD         TO S-FW-ACTION-TYPE-CD  
              MOVE KD-FW-ACTION-DT              TO S-FW-ACTION-DT       
              MOVE IZ-WITHDRAW-DT               TO S-WITHDRAW-DT        
              MOVE IZ-COLL-AGY-SUB-CD           TO S-COLL-AGY-SUB-CD    
              MOVE IZ-CODE-COLLEC-AGNCY         TO S-CODE-COLLEC-AGNCY  
              MOVE IZ-FW-COLL-SEQ-NO            TO S-FW-COLL-SEQ-NO     
                                                                        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
                                                                        
              PERFORM 7220-FETCH-FIN-WO-ACTN-CURSOR THRU 7220-EXIT      
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7230-CLOSE-FIN-WO-ACTN-CURSOR THRU 7230-EXIT.        
                                                                        
           IF S-RETURN-CODE = 0 AND CTR-ROWS = 0                        
              MOVE 100                   TO   S-RETURN-CODE             
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-GET-LAST-RUN-DT.                                          *        
      ******************************************************************        
      *                                                                         
       2400-GET-LAST-RUN-DT.                                            
                                                                        
           IF LR-REG-GROUP-CD = '100' THEN                              
               MOVE +100                    TO WS-SEQ-NO                
           ELSE                                                         
              IF LR-REG-GROUP-CD = '200' THEN                           
                 MOVE +200                  TO WS-SEQ-NO                
              ELSE                                                      
                 MOVE +10                   TO WS-SEQ-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7040-SELECT-LAST-RUN-DT  THRU 7040-EXIT.             
                                                                        
           MOVE WS-PARM-DATA                TO WS-LAST-RUN-DATE-PARM.   
                                                                        
           MOVE WS-LAST-RUN-DATE            TO WS-CA206-LAST-RUN-DATE.  
                                                                        
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  6010-REDUCE-EMBEDDED-SPACES                                   *        
      ******************************************************************        
      *                                                                         
              EXEC SQL                                                          
                   INCLUDE CPD00004                                             
              END-EXEC.                                                         
      *                                                                         
      ******************************************************************        
      * 7040-SELECT-LAST-RUN-DT.                                       *        
      ******************************************************************        
      *                                                                         
       7040-SELECT-LAST-RUN-DT.                                         
      *                                                                         
            EXEC SQL                                                    
                SELECT TOP(1) PARM_DATA                                         
                INTO                                                    
                     :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    PROGRAM_NAME = 'PCSCA206'                           
                AND COMPANY_NO   = :WS-COMPANY-NO                       
                AND CMND_CODE    = 'PARM'                               
                AND STATUS       = 'A'                                  
                AND SEQ_NO       = :WS-SEQ-NO                           
                                           
P00799                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*              PARM_DATA                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*         WHERE                                                           
MFA-TR*             PROGRAM_NAME = 'PCSCA206'                                   
MFA-TR*         AND COMPANY_NO   = :WS-COMPANY-NO                               
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SEQ_NO       = :WS-SEQ-NO                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*         QUERYNO 7040                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7040'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_JOB_PARM'        TO TABLE-1                   
                MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'SEQ-NO'              TO TABLE-ELEMENT-3           
                MOVE 'PCSCA206'            TO HOSTVAR-ELEMENT-1         
                MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE WS-SEQ-NO             TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *7050-SELECT-REG-GROUP-CD                                       *         
      *****************************************************************         
      *                                                                         
       7050-SELECT-REG-GROUP-CD.                                        
                                                                        
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    REG_GROUP_CD                                        
               INTO                                                     
                    :LR-REG-GROUP-CD                                    
               FROM                                                     
                    CSS_REG_PROFILE                                     
               WHERE                                                    
                    ACCOUNT_NO = :LR-ACCOUNT-NO                         
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             REG_GROUP_CD                                                
MFA-TR*        INTO                                                             
MFA-TR*             :LR-REG-GROUP-CD                                            
MFA-TR*        FROM                                                             
MFA-TR*             CSS_REG_PROFILE                                             
MFA-TR*        WHERE                                                            
MFA-TR*             ACCOUNT_NO = :LR-ACCOUNT-NO                                 
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              MOVE SPACES                TO LR-REG-GROUP-CD             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_REG_PROFILE'     TO TABLE-1                     
              MOVE 'REG_GROUP_CD'        TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-DEC     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7100-SELECT-ACCOUNT-DETAILS                                    *         
      *****************************************************************         
      *                                                                         
       7100-SELECT-ACCOUNT-DETAILS.                                     
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    COMPANY_NO                                          
                   ,ACCOUNT_TYPE_CODE                                   
               INTO                                                     
                   :AT-COMPANY-NO                                       
                  ,:AT-ACCOUNT-TYPE-CODE                                
               FROM                                                     
                   CSS_ACCOUNT WITH(READUNCOMMITTED)                            
               WHERE                                                    
                    ACCOUNT_NO = :AT-ACCOUNT-NO                         
                                                                 
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             COMPANY_NO                                                  
MFA-TR*            ,ACCOUNT_TYPE_CODE                                           
MFA-TR*        INTO                                                             
MFA-TR*            :AT-COMPANY-NO                                               
MFA-TR*           ,:AT-ACCOUNT-TYPE-CODE                                        
MFA-TR*        FROM                                                             
MFA-TR*            CSS_ACCOUNT                                                  
MFA-TR*        WHERE                                                            
MFA-TR*             ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7200-OPEN-FIN-WO-ACTN-CURSOR                                   *         
      *****************************************************************         
      *                                                                         
       7200-OPEN-FIN-WO-ACTN-CURSOR.                                    
           MOVE '7200'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FIN_WO_ACTION_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FIN_WO_ACTION_CUR'        TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7220-FETCH-FIN-WO-ACTN-CURSOR                                  *         
      *****************************************************************         
      *                                                                         
       7220-FETCH-FIN-WO-ACTN-CURSOR.                                   
                                                                        
           MOVE '7220'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH FIN_WO_ACTION_CUR                                   
              INTO                                                      
                  :KD-FW-ACTION-TYPE-CD                                 
                 ,:KD-FW-ACTION-DT                                      
                 ,:IZ-WITHDRAW-DT :WS-IZ-WITHDRAW-DT-NULL               
                 ,:IZ-COLL-AGY-SUB-CD                                   
                 ,:IZ-CODE-COLLEC-AGNCY                                 
                 ,:IZ-FW-COLL-SEQ-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-IZ-WITHDRAW-DT-NULL < 0 THEN                        
                 MOVE '1900-01-01'          TO IZ-WITHDRAW-DT           
                 MOVE ZERO                  TO WS-IZ-WITHDRAW-DT-NULL   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'FIN_WO_ACTION_CUR'      TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7230-CLOSE-FIN-WO-ACTN-CURSOR.                                 *        
      ******************************************************************        
      *                                                                         
       7230-CLOSE-FIN-WO-ACTN-CURSOR.                                   
                                                                        
           MOVE '7230'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE FIN_WO_ACTION_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FIN_WO_ACTION_CUR'        TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7240-CHECK-COLL-AGY-EXPIRY                                     *        
      ******************************************************************        
      *                                                                         
       7240-CHECK-COLL-AGY-EXPIRY.                                      
                                                                        
           MOVE '7240'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                 
              INTO                                                      
                   :WS-COLL-AGY-EXIST-FLAG                              
              FROM                                                      
                   CSS_COLL_AGY_ASSGN WITH(READUNCOMMITTED)                     
              WHERE                                                     
                  COMPANY_NO          = :KU-COMPANY-NO                  
              AND REG_GROUP_CD        = :KU-REG-GROUP-CD                
              AND COLL_ACCT_TYPE_CD   = :KU-COLL-ACCT-TYPE-CD           
              AND FW_ACTION_TYPE_CD   = :KU-FW-ACTION-TYPE-CD           
              AND CODE_COLLEC_AGNCY   = :KU-CODE-COLLEC-AGNCY           
              AND COLL_AGENCY_SUB_CD  = :KU-COLL-AGENCY-SUB-CD          
              AND EFFECTIVE_DATE     <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
              AND EXPIRATION_DT      >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
                                                  
                                                                 
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            'Y'                                                          
MFA-TR*       INTO                                                              
MFA-TR*            :WS-COLL-AGY-EXIST-FLAG                                      
MFA-TR*       FROM                                                              
MFA-TR*            CSS_COLL_AGY_ASSGN                                           
MFA-TR*       WHERE                                                             
MFA-TR*           COMPANY_NO          = :KU-COMPANY-NO                          
MFA-TR*       AND REG_GROUP_CD        = :KU-REG-GROUP-CD                        
MFA-TR*       AND COLL_ACCT_TYPE_CD   = :KU-COLL-ACCT-TYPE-CD                   
MFA-TR*       AND FW_ACTION_TYPE_CD   = :KU-FW-ACTION-TYPE-CD                   
MFA-TR*       AND CODE_COLLEC_AGNCY   = :KU-CODE-COLLEC-AGNCY                   
MFA-TR*       AND COLL_AGENCY_SUB_CD  = :KU-COLL-AGENCY-SUB-CD                  
MFA-TR*       AND EFFECTIVE_DATE     <= CURRENT DATE                            
MFA-TR*       AND EXPIRATION_DT      >= CURRENT DATE                            
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7240                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COLL_AGY_ASSGN'       TO TABLE-1                
              MOVE 'CODE_COLLEC_AGNCY'        TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'REG_GROUP_CD'             TO TABLE-ELEMENT-3        
              MOVE 'COLL_ACCT_TYPE_CD'        TO TABLE-ELEMENT-4        
              MOVE KU-CODE-COLLEC-AGNCY       TO HOSTVAR-ELEMENT-1      
              MOVE KU-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE KU-REG-GROUP-CD            TO HOSTVAR-ELEMENT-3      
              MOVE KU-COLL-ACCT-TYPE-CD       TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-GET-COLL-AGY-DESC                                         *        
      ******************************************************************        
      *                                                                         
       7250-GET-COLL-AGY-DESC.                                          
                                                                        
           MOVE '7250'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COLLEC_AGNCY_NAME                                   
              INTO                                                      
                  :Q7-COLLEC-AGNCY-NAME                                 
              FROM                                                      
                   CSS_COLLECT_AGENCY WITH(READUNCOMMITTED)                     
              WHERE                                                     
                  CODE_COLLEC_AGNCY   = :Q7-CODE-COLLEC-AGNCY           
                                                  
                                                                 
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            COLLEC_AGNCY_NAME                                            
MFA-TR*       INTO                                                              
MFA-TR*           :Q7-COLLEC-AGNCY-NAME                                         
MFA-TR*       FROM                                                              
MFA-TR*            CSS_COLLECT_AGENCY                                           
MFA-TR*       WHERE                                                             
MFA-TR*           CODE_COLLEC_AGNCY   = :Q7-CODE-COLLEC-AGNCY                   
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COLLECT_AGENCY'       TO TABLE-1                
              MOVE 'CODE_COLLEC_AGNCY'        TO TABLE-ELEMENT-1        
              MOVE Q7-CODE-COLLEC-AGNCY       TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-GET-COLL-AGY-SUB-DESC                                     *        
      ******************************************************************        
      *                                                                         
       7300-GET-COLL-AGY-SUB-DESC.                                      
                                                                        
           MOVE '7300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FW_ATTR_VALUE_DESC                                  
              INTO                                                      
                  :KV-FW-ATTR-VALUE-DESC                                
              FROM                                                      
                   CSS_FW_ATTRIB_DESC WITH(READUNCOMMITTED)                     
              WHERE                                                     
                  FW_ATTRIB_TYPE_CD   = 'AS'                            
              AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD            
                                                  
                                                                 
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            FW_ATTR_VALUE_DESC                                           
MFA-TR*       INTO                                                              
MFA-TR*           :KV-FW-ATTR-VALUE-DESC                                        
MFA-TR*       FROM                                                              
MFA-TR*            CSS_FW_ATTRIB_DESC                                           
MFA-TR*       WHERE                                                             
MFA-TR*           FW_ATTRIB_TYPE_CD   = 'AS'                                    
MFA-TR*       AND FW_ATTR_VALUE_CD    = :KV-FW-ATTR-VALUE-CD                    
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_FW_ATTRIB_DESC'       TO TABLE-1                
              MOVE 'FW_ATTR_VALUE_CD'         TO TABLE-ELEMENT-1        
              MOVE KV-FW-ATTR-VALUE-CD        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *      7400-GET-BALANCE                                          *        
      ******************************************************************        
       7400-GET-BALANCE.                                                
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                    SUM(AMT_TRANS)                                      
                INTO                                                    
                    :CO-AMT-TRANS :WS-CO-AMT-TRANS-NULL                  
                FROM                                                    
                    CSS_CHRG_OFF WITH(READUNCOMMITTED)                          
                WHERE                                                   
                    ACCOUNT_NO        = :CO-ACCOUNT-NO                  
                                                                 
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             SUM(AMT_TRANS)                                              
MFA-TR*         INTO                                                            
MFA-TR*             :CO-AMT-TRANS:WS-CO-AMT-TRANS-NULL                          
MFA-TR*         FROM                                                            
MFA-TR*             CSS_CHRG_OFF                                                
MFA-TR*         WHERE                                                           
MFA-TR*             ACCOUNT_NO        = :CO-ACCOUNT-NO                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF  SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND               
               IF SQLCODE = NOT-FOUND OR WS-CO-AMT-TRANS-NULL < 0       
                  MOVE ZERO                  TO CO-AMT-TRANS            
                                                WS-CO-AMT-TRANS-NULL    
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CHRG_OFF'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE CO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR04115_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04115_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04115_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04115_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,FW_ACTION_TYPE_CD                                  
                    ,FW_ACTION_DT                                       
                    ,WITHDRAW_DT                                        
                    ,COLL_AGY_SUB_CD                                    
                    ,CODE_COLLEC_AGNCY                                  
                    ,FW_COLL_SEQ_NO                                     
                    ,COMB_COLL_AGY_SUB                                  
                    ,CA206_LAST_RUN_DT                                  
                    ,WO_BALANCE                                         
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-FW-ACTION-TYPE-CD                               
                    ,:S-FW-ACTION-DT                                    
                    ,:S-WITHDRAW-DT                                     
                    ,:S-COLL-AGY-SUB-CD                                 
                    ,:S-CODE-COLLEC-AGNCY                               
                    ,:S-FW-COLL-SEQ-NO                                  
                    ,:S-COMB-COLL-AGY-SUB                               
                    ,:S-CA206-LAST-RUN-DT                               
                    ,:S-WO-BALANCE                                      
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04115_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,FW_ACTION_TYPE_CD                                          
MFA-TR*             ,FW_ACTION_DT                                               
MFA-TR*             ,WITHDRAW_DT                                                
MFA-TR*             ,COLL_AGY_SUB_CD                                            
MFA-TR*             ,CODE_COLLEC_AGNCY                                          
MFA-TR*             ,FW_COLL_SEQ_NO                                             
MFA-TR*             ,COMB_COLL_AGY_SUB                                          
MFA-TR*             ,CA206_LAST_RUN_DT                                          
MFA-TR*             ,WO_BALANCE                                                 
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-FW-ACTION-TYPE-CD                                       
MFA-TR*             ,:S-FW-ACTION-DT                                            
MFA-TR*             ,:S-WITHDRAW-DT                                             
MFA-TR*             ,:S-COLL-AGY-SUB-CD                                         
MFA-TR*             ,:S-CODE-COLLEC-AGNCY                                       
MFA-TR*             ,:S-FW-COLL-SEQ-NO                                          
MFA-TR*             ,:S-COMB-COLL-AGY-SUB                                       
MFA-TR*             ,:S-CA206-LAST-RUN-DT                                       
MFA-TR*             ,:S-WO-BALANCE                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04115_R2'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                 12700000
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
