       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04114.                                       
       AUTHOR.       JIJU CHOVVA.                                       
COB303 DATE-WRITTEN. FEB 12, 2008.                                       
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04114              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04114 :                                                --         
      *--                                                            --         
      *--  THIS PROGRAM IS CALLED FROM RATE SELECTION APPLICATION    --         
      *--  AND AT ANY GIVEN POINT OF TIME, IT WILL RETURN ALL THE    --         
      *--  TIER DETAILS FOR A CUSTOMER, CUSTOMER NAME. THERM PRICE   --         
      *--  WILL BE RETURNED ONLY WHEN IC DETAILS ARE PROVIDED.       --         
      *--                                                            --         
      *--  PGM CAN BE CALLED IN TWO DIFFERENT MODES, WHICH IS        --         
      *--  DETERMINED BY UPDATE FLAG.                                --         
      *--                                                            --         
      *--       (A) "I"NSERT - WHEN A NEW IC IS SETUP FROM PANEL 051 --         
      *--       (B) "U"PDATE - RATE CHANGES FOR AN EXISTING CUSTOMER --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            OPTION_CD             CHAR(12)                  --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            CODE_UTIL_TYPE        CHAR(01)                  --         
      *--            IC_NO                 CHAR(04)                  --         
      *--            USER_ID               CHAR(07)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            RETURN_CODE           CHAR(9)                   --         
      *--            OPT_REMAIN_MTHS       CHAR(02)                  --         
      *--            CSC_AMOUNT            CHAR(11)                  --         
      *--            EXIT_FEE_FLAG         CHAR(01)                  --         
      *--            EXIT_FEE              CHAR(11)                  --         
      *--            INIT_BILL_FL          CHAR(01)                  --         
      *--            THERM_PRICE           CHAR(01)                  --         
      *--            ACCT_TIER             CHAR(04)                  --         
      *--            ACCT_TIER             CHAR(04)                  --         
      *--            OPT_DESC_INT_LONG     CHAR(255)                 --         
      *--            SUPER_USER_FLAG       CHAR(01)                  --         
P00680*--            PAG_FL                CHAR(01)                  --         
P00680*--            ADJUSTABLE_FLAG       CHAR(01)                  --         
P00680*--            OFFER_CD              CHAR(12)                  --         
P00680*--            SWITCH_EXIT_FEE       DECIMAL(11,6)             --         
P00680*****                                                          --         
P00680*--            CURRENT OPTION DISCOUNT DETAILS                 --         
P00680*--            PENDING OPTION DISCOUNT DETAILS                 --         
P00680*****                                                          --         
P00805*--            CURR_OPT_VALID_MNTHS  SMALLINT                  --         
P00805*--            CURR_OPT_CORE_RATE    CHAR(03)                  --         
P00805*--            CURR_OPT_ROR_END_DT   CHAR(10)                  --         
P00805*--            IS_CURR_RATE_SENIOR   CHAR(01)                  --         
P00805*--            PEND_OPT_VALID_MNTHS  SMALLINT                  --         
P00805*--            PEND_OPT_CORE_RATE    CHAR(03)                  --         
P00805*--            PEND_OPT_ROR_END_DT   CHAR(10)                  --         
P00805*--            IS_PEND_RATE_SENIOR   CHAR(01)                  --         
P00805*--            PEND_OPT_EXIT_FEE     DECIMAL(11,6)             --         
P00892*--            PEND_AUTO_REN_OPT_IN_FL CHAR(01)                --         
P00892*--            CURR_AUTO_REN_OPT_IN_FL CHAR(01)                --         
P00892*--            SEASONAL_FL             CHAR(01)                --         
P00892*--            CURR_OPT_CALC_TYPE_CD   CHAR(02)                --         
P00892*--            PEND_OPT_CALC_TYPE_CD   CHAR(02)                --         
OTPOOL*--            LOCAL_OFFICE            CHAR(03)                --         
P805CS*--            PAPERLESS_CSC_DSC_FL    CHAR(01)                --         
P805CS*--            PAPERLESS_CSC_DSC_AMT   DECIMAL(7,2)            --         
P805CS*--            AUTORENEW_CSC_DSC_FL    CHAR(01)                --         
P805CS*--            AUTORENEW_CSC_DSC_AMT   DECIMAL(7,2)            --         
I02262*--            AGL_PREM_NO             DECIMAL(9,0)            --         
I02262*--            CODE_ACCT_STAT          CHAR(01)                --         
I02262*--            PREM_ADDR_ZIP_CODE      CHAR(05)                --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--     MULTIPLE                                               --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
T34569*--  02/11/2008    JC91900     PROGRAM INTIALLY WRITTEN.       --         
I00113*--  01/14/2009    JC91900     GROUP 1 SR. MOVEMENT.           --         
P00141*--  04/10/2009    SS97726     UPDATE FIXED RATE EXIT FEE FROM --         
P00141*--                            $50 TO $100.                    --         
A01339*--  06/30/2009    VY95550     VARCHAR INITIALIZATION.         --         
P00172*--  07/31/2009    VY95550     DHR PHASE OUT CHANGES           --         
I00484*--  08/14/2009    VY95550     GET PENDING OPTION THERM PRICES --         
P00269*--  02/01/2010    MN90523     INCLUDED USER ID INPUT AND SUPER--         
P00269*--                            USER FLAG OUTPUT PARMS          --         
P00453*--  04/08/2011    SB93596     ADDED PRP FLAG FOR ACCOUNTS.    --         
A03303*--  05/24/2011    SV95326     FIXED FACTOR PRECISION CHANGES  --         
A03303*--                ACT004      4 TO 6 DECIMAL POINTS FOR       --         
A03303*--                            INDUSTRIAL BILLING.             --         
A03303*--  06/07/2011    SV95326     QUERYNO INSERTED FOR CURSOR &   --         
A03303*--                            SELECT STATEMENT.               --         
P00473*--  08/12/2011    SB93596     CHGS INCLUDED TO PULL APPROVED  --         
P00473*--                            OPTION/OPT ATTR INCTV RECORDS.  --         
A04019*--  05/24/2012    VIJAY       SEB CSC CHANGES.                --         
P00680*--  05/09/2012    GD97441     CUST RETENTION PROJECT CHANGES  --         
P00677*--  07/23/2012    MS93554     REGULATED PROVIDER GRP2 CHANGES.--         
P00680*--  08/14/2012    GD97441     EXIT FEE PRORATION CHANGES.     --         
P00680*--  08/15/2012    MS93554     GET OPTION DISCOUNT DETAILS.    --         
P00680*--                SS97726     ADDITIONAL CHANGES FOR DISCOUNTS--         
A04019*--  09/18/2012    MS93554     REMOVED ALL SEB CSC CHANGES WITH--         
A04019*--                            THE TAG A04019.                 --         
P680PN*--  04/30/2013    SS97726     PASS NEGOTIATED PRICE CODE FOR  --         
P680PN*--                            CURRENT AND PENDING OPTION/S.   --         
P00805*--  04/03/2014    SS97726     EXTENDED EARLY RENEWAL.         --         
P00892*--  04/13/2015    VIJAY       FIXED RATE AUTO RENEWAL CHANGES --         
ACT185*--  06/01/2015    MC95456     A5460 -REMOVED UNUSED COPY BOOKS--         
P805AP*--  06/22/2016    SV95326     CURR OPTION RIGHT OF RECESSION  --         
P805AP*--                            DATE CHANGES(UNBILLED ACCOUNT)  --         
OTPOOL*--  08/15/2016    SS45239     ADD LOCAL_OFFICE TO RESULT SET  --         
P805CS*--  08/22/2016    SS45239     PASS CSC DISCOUNT INFORMATION   --         
I02262*--  09/23/2016    SS45239     ADD AGL_PREM_NO CODE_ACCT_STAT  --         
I02262*--                            PREM_ADDR_ZIP_CODE              --         
P01137*--  17 JAN  2017  GD43988     REPLACED CSS_NAVIGATION WITH    --         
P01137*--                            CATEGORY_ID = 346 CHECK         --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04114'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CRM_OPT_ATTR_INCTV, HQ                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBOPTATT                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_REG_PROFILE, LR                                                     
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBREGPRF                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_FIXED_FCTR, FF                                            *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBFXDFCT                                               
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      * CSS_ACCT_MKT_TIER, DD                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME, DQ                                       *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FORMATTED, DY                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUSTOMER, CU                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ZIP_CODE, A4                                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_NAME_ACC_XREF, HT                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_CUST_ADD_XREF, DM                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBCSADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ACCT_MISC_INFO, TA                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBATMISC                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_ADDR_FREEFORM, DZ                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_PREMISE, PR                                    *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_BILL_ADDR_XREF, AQ                             *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBBLADRX                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    TABLE : CSS_RT_PKG_OPTION, FI                              *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_MKT_TIER, IG                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
                                                                        
I00113*****************************************************************         
I00113* CSS_DELINQUENCY, C8                                           *         
I00113*****************************************************************         
I00113      EXEC SQL                                                            
I00113           INCLUDE TBDELQ                                                 
I00113      END-EXEC.                                                           
I00113                                                                  
I00113*****************************************************************         
I00113* CSS_CUST_STATS, CE                                            *         
I00113*****************************************************************         
I00113      EXEC SQL                                                            
I00113           INCLUDE TBCSTSTS                                               
I00113      END-EXEC.                                                           
I00113                                                                  
P00141                                                                  
P00141*****************************************************************         
P00141* CSS_UTIL_ENVRNMT UT                                           *         
P00141*****************************************************************         
P00141      EXEC SQL                                                            
P00141           INCLUDE TBUTLENV                                               
P00141      END-EXEC.                                                           
P00141                                                                  
P00141*****************************************************************         
P00141* CSS_ACCT_RTPK_AGR DF                                          *         
P00141*****************************************************************         
P00141      EXEC SQL                                                            
P00141           INCLUDE TBACCTRG                                               
P00141      END-EXEC.                                                           
                                                                        
P00269*****************************************************************         
P00269* CSS_CATEGORY F5                                               *         
P00269*****************************************************************         
P00269      EXEC SQL                                                            
P00269           INCLUDE TBCAT                                                  
P00269      END-EXEC.                                                           
                                                                        
P00453******************************************************************01498100
P00453* CSS_PREPAY_HIST  PK                                            *01498200
P00453******************************************************************01498300
P00453       EXEC SQL                                                   01498400
P00453           INCLUDE TBPREHST                                       01498500
P00453       END-EXEC.                                                  01498600
P00453*                                                                 01498700
A03303*****************************************************************         
A03303* CSS_SPCL_FCTR   SF                                            *         
A03303*****************************************************************         
A03303      EXEC SQL                                                            
A03303           INCLUDE TBSPLFTR                                               
A03303      END-EXEC.                                                           
A03303                                                                  
P00677******************************************************************        
P00677* CRM_MKT_TIER_ADJ 1B                                            *        
P00677******************************************************************        
P00677      EXEC SQL                                                            
P00677        INCLUDE TBMKTTAD                                                  
P00677      END-EXEC.                                                           
P00677                                                                  
P00680*                                                                         
P00680***** CSS_JOB_PARM, G6                                                    
P00680      EXEC SQL                                                            
P00680           INCLUDE TBJBPARM                                               
P00680      END-EXEC.                                                           
P00680*                                                                         
P00680***** CSS_BILL_WINDOW, BN                                                 
P00680      EXEC SQL                                                            
P00680           INCLUDE TBBILWDW                                               
P00680      END-EXEC.                                                           
P00680*                                                                         
P00680***** CRM_ATTR_PRORATE, 2L                                                
P00680*                                                                         
P00680      EXEC SQL                                                            
P00680           INCLUDE TBATRPRO                                               
P00680      END-EXEC.                                                           
P00680*                                                                         
P00680***** CRM_ATTR_PRO_FCTR, 2R                                               
P00680      EXEC SQL                                                            
P00680           INCLUDE TBATRFCT                                               
P00680      END-EXEC.                                                           
P00680*                                                                         
P00805***** CSS_RATE_PLAN_DESC, RD                                              
P00805      EXEC SQL                                                            
P00805           INCLUDE TBRTDESC                                               
P00805      END-EXEC.                                                           
P00805*                                                                         
P805AP***** CSS_COMM_DATA, KO                                                   
P805AP*                                                                         
P805AP      EXEC SQL                                                            
P805AP          INCLUDE TBCOMDAT                                                
P805AP      END-EXEC.                                                           
P805AP*                                                                         
P805AP***** CSS_ACCT_ATTRIBUTE, YP                                              
P805AP*                                                                         
P805AP      EXEC SQL                                                            
P805AP          INCLUDE TBACTATT                                                
P805AP      END-EXEC.                                                           
P805AP*                                                                 01400000
      *****************************************************************         
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
P00453******************************************************************        
P00453*    WORK AREAS TO CODES-DATA-PRESENT OF AT TABLE.               *        
P00453******************************************************************        
P00453     COPY CWS00056.                                                       
P00453*                                                                         
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR 063.                            *        
      ******************************************************************        
           COPY CWS00063.                                                       
                                                                        
P00680**** INCTV / INCTV PRORATION WS- COPYBOOK                                 
P00680     EXEC SQL                                                             
P00680         INCLUDE CWS04114                                                 
P00680     END-EXEC.                                                            
P00680*                                                                         
      ******************************************************************        
      *    WQ CREATION COPYBOOK.                                       *        
      ******************************************************************        
           COPY CWS0070B.                                                       
                                                                        
      ***************************************************************** 00165600
      * COPYBOOK FOR THE WORKING STORAGE THAT IS TUNED FOR BATCH      * 00165700
      ***************************************************************** 00165800
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
P805CS*** DISCOUNT ELIGIBILITY ROUTINE WS COPYBOOK(S)                           
P805CS     EXEC SQL                                                             
P805CS         INCLUDE CWS0444E                                                 
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS     COPY CWS00444.                                                       
P805CS*                                                                         
      ******************************************************************        
      *    NAME & ADDRESS FORMAT SUPPORT.                              *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
           05 WS-ACCOUNT-NO           PIC 9(13) VALUE ZEROES.           
           05 WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.           
           05 WS-IC-NO                PIC X(04) VALUE SPACES.           
           05 WS-UPD-FLAG             PIC X(01) VALUE SPACES.           
           05 WS-ACCT-SUB-TYPE        PIC X(01) VALUE SPACES.           
P00453     05 WS-PK-EXISTS            PIC X(01) VALUE 'N'.              
P00453     05 WS-PRP-MKT-TIER-RANK    PIC S9(4) USAGE COMP VALUE +0.    
P00805     05 WS-3DAY-ROR-DAYS        PIC S9(4) USAGE COMP VALUE +0.    
P00892     05 WS-90DAY-GRACE-PERIOD   PIC S9(4) USAGE COMP VALUE +0.    
P00453     05 WS-PRP-DEFAULT-TIER     PIC X(20) VALUE                   
P00453                                   'PRP-DEFAULT-TIER'.            
                                                                        
I00113     05 WS-DUMMY-DATE-ST        PIC X(10) VALUE SPACES.           
I00113     05 WS-DUMMY-DATE-END       PIC X(10) VALUE SPACES.           
I00113     05 WS-CURRENT-DATE         PIC X(10) VALUE SPACES.           
I00113     05 WS-RESULT-YEAR          PIC S9(04) COMP.                  
P00805     05 WS-RESULT-DATE          PIC X(10) VALUE SPACES.           
P00269     05 WS-USER-ID              PIC X(07)  VALUE SPACES.          
P00269     05 WS-SUPER-USER-FLAG      PIC X(01)  VALUE 'N'.             
           05 WS-MCSCB063-RET-CODE    PIC S9(04) COMP VALUE 0.          
A03303     05 WS-FACTOR-FF            PIC S9(09)V9(06) USAGE COMP-3     
A03303                                                   VALUE 0.       
A04019     05 WS-CSC-AMT-DESC         PIC $Z9.99.                       
P00680     05 WS-DURATION-NO-HQ       PIC Z9.                           
P00680     05 WS-FACTOR-TEXT-LEN      PIC S9(4) COMP.                   
P00680     05 WS-PRC-DSCNT-CTR        PIC S9(4) USAGE COMP VALUE +0.    
P00680     05 WS-CSC-DSCNT-CTR        PIC S9(4) USAGE COMP VALUE +0.    
P805AP     05 WS-COMMUNICATION-DT     PIC X(10) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
I00113     05 WS-GRP1-SR-ELIGIBLE     PIC X(01) VALUE 'N'.              
I00113        88 GRP1-SR-ELIGIBLE         VALUE 'Y'.                    
P00677     05 WS-GRP2-SR-ELIGIBLE     PIC X(01) VALUE 'N'.              
P00677        88 GRP2-SR-ELIGIBLE         VALUE 'Y'.                    
I00113     05 WS-DHR-CUSTOMER         PIC X(01) VALUE 'N'.              
I00113        88 DHR-CUSTOMER                   VALUE 'Y'.              
I00113        88 NON-DHR-CUSTOMER               VALUE 'N'.              
I00113     05 WS-TIER-RANK-SET        PIC X(01) VALUE 'N'.              
I00113        88 TIER-RANK-SET                  VALUE 'Y'.              
P00680     05 WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.              
P00680        88 NO-MORE-ROWS                   VALUE 'Y'.              
I00113                                                                  
I00113 01  WS-NULL-INDICATORS.                                          
I00113     05 WS-NULL-IND-01          PIC S9(4) COMP.                   
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04114'.       
           05 MCSCB063                PIC X(08) VALUE 'MCSCB063'.       
           05 WS-N                    PIC X(01) VALUE 'N'.              
P00453     05 WS-ACTIVE               PIC X(01) VALUE 'A'.              
           05 WS-EXIT-FEE-FCTR        PIC X(09) VALUE 'EXIT FEE'.       
I00113     05 REG-GRP1-CUST           PIC X(01) VALUE '1'.              
P00677     05 REG-GRP2-CUST           PIC X(01) VALUE '2'.              
P00892     05 CON-RES-CUST            PIC X(01) VALUE 'R'.              
P00892     05 ACN-RES-CUST            PIC X(01) VALUE 'A'.              
P00892     05 RES-BUS-OWNER-CUST      PIC X(01) VALUE 'B'.              
P00892     05 DEREG-RES-CUST          PIC X(01) VALUE 'D'.              
P00892     05 SMALL-COM-CUST          PIC X(01) VALUE 'S'.              
P00677     05 WS-SCANA-SENIOR         PIC X(01) VALUE 'S'.              
P00677     05 WS-SCANA-SR-SETUP       PIC X(02) VALUE 'SS'.             
P00677     05 WS-YES                  PIC X(01) VALUE 'Y'.              
I00113     05 SCANA-SR-AGE            PIC X(17)                         
I00113                                      VALUE 'SCANA SENIOR AGE'.   
P00805     05 3DAY-ROR-DAYS           PIC X(07)                         
P00805                                      VALUE '3DAYROR'.            
P00892     05 90-DAY-GRACE-PERIOD     PIC X(16)                         
P00892                                      VALUE '90DAYGRACEPERIOD'.   
I00484     05 WS-PENDING-OPTION       PIC X(01) VALUE 'P'.              
A04019     05 WS-CSC-LIT-DESC         PIC X(04) VALUE ' CSC'.           
P00680     05 WS-FOR-LIT-DESC         PIC X(04) VALUE ' for'.           
P00680     05 WS-MONTHS-LIT-DESC      PIC X(08) VALUE ' Months:'.       
           05 GTT-NAME                PIC X(26)                         
                                            VALUE 'SESSION.CSR04114_R1'.
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05 RS-OPT-REMAIN-MTHS        PIC S9(04) COMP VALUE 0.        
           05 RS-CSC-AMOUNT             PIC S9(5)V9(6)                  
                                                   USAGE COMP-3 VALUE 0.
           05 RS-EXIT-FEE-FLAG          PIC X(01)  VALUE SPACES.        
P00680     05 RS-RATE-CHANGE-EXIT-FEE   PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
           05 RS-INIT-BILL-FL           PIC X(01)  VALUE SPACES.        
           05 RS-THERM-PRICE            PIC S9(5)V9(6)                  
                                                   USAGE COMP-3 VALUE 0.
           05 RS-ACCT-TIER              PIC S9(04) COMP VALUE 0.        
           05 RS-CUSTOMER-NAME          PIC X(70)  VALUE SPACES.        
           05 RS-ADDRESS                PIC X(150) VALUE SPACES.        
           05 RS-TIER-CUST-STAT-CD      PIC X(01)  VALUE SPACES.        
           05 RS-TIER-ACCT-TYPE-CD      PIC X(01)  VALUE SPACES.        
           05 RS-MKT-TIER-START-DT      PIC X(10)  VALUE SPACES.        
           05 RS-OPT-DESC-INT-LONG      PIC X(255) VALUE SPACES.        
I00484     05 RS-PEND-OPTION-FLAG       PIC X(01)  VALUE SPACES.        
I00484     05 RS-PEND-THERM-PRICE       PIC S9(5)V9(6)                  
I00484                                             USAGE COMP-3 VALUE 0.
I00484     05 RS-PEND-OPTION-CD         PIC X(12)  VALUE SPACES.        
I00484     05 RS-PEND-OPTION-DESC       PIC X(255) VALUE SPACES.        
P00269     05 RS-SUPER-USER-FLAG        PIC X(01)  VALUE 'N'.           
                                                                        
P00453     05 RS-PRP-FL                 PIC X(01)  VALUE 'N'.           
P00680     05 RS-RTPK-STAT-ADJ-FL       PIC X(01)  VALUE 'N'.           
P00680     05 RS-OFFER-CD               PIC X(12)  VALUE SPACES.        
P00680     05 RS-SWITCH-AWAY-EXIT-FEE   PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-THRM-PRC-DSCNT-FL                              
P00680                                  PIC X(01)  VALUE 'N'.           
P00680     05 RS-CUR-OPT-CSC-DSCNT-FL   PIC X(01)  VALUE 'N'.           
P00680     05 RS-CUR-OPT-DSCNTD-PRC     PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-DSCNTD-CSC     PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-TOT-PRC-DSCNT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-TOT-CSC-DSCNT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-PRC-DSC-A-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-PRC-DSC-A-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-PRC-DSC-A-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-PRC-DSC-B-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-PRC-DSC-B-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-PRC-DSC-B-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-PRC-DSC-C-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-PRC-DSC-C-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-PRC-DSC-C-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-PRC-DSC-D-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-PRC-DSC-D-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-PRC-DSC-D-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-PRC-DSC-E-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-PRC-DSC-E-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-PRC-DSC-E-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-CSC-DSC-A-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-CSC-DSC-A-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-CSC-DSC-A-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-CSC-DSC-B-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-CSC-DSC-B-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-CSC-DSC-B-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-CSC-DSC-C-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-CSC-DSC-C-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-CSC-DSC-C-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-CSC-DSC-D-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-CSC-DSC-D-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-CSC-DSC-D-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-CUR-OPT-CSC-DSC-E-TXT  PIC X(35)  VALUE SPACES.        
P00680     05 RS-CUR-OPT-CSC-DSC-E-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05 RS-CUR-OPT-CSC-DSC-E-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-THRM-PRC-DSCNT-FL                             
P00680                                  PIC X(01)  VALUE 'N'.           
P00680     05 RS-PNDG-OPT-CSC-DSCNT-FL  PIC X(01)  VALUE 'N'.           
P00680     05 RS-PNDG-OPT-DSCNTD-PRC    PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-DSCNTD-CSC    PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-TOT-PRC-DSCNT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-TOT-CSC-DSCNT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-PRC-DSC-A-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-PRC-DSC-A-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-PRC-DSC-A-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-PRC-DSC-B-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-PRC-DSC-B-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-PRC-DSC-B-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-PRC-DSC-C-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-PRC-DSC-C-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-PRC-DSC-C-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-PRC-DSC-D-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-PRC-DSC-D-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-PRC-DSC-D-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-PRC-DSC-E-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-PRC-DSC-E-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-PRC-DSC-E-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-CSC-DSC-A-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-CSC-DSC-A-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-CSC-DSC-A-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-CSC-DSC-B-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-CSC-DSC-B-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-CSC-DSC-B-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-CSC-DSC-C-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-CSC-DSC-C-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-CSC-DSC-C-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-CSC-DSC-D-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-CSC-DSC-D-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-CSC-DSC-D-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05 RS-PNDG-OPT-CSC-DSC-E-TXT PIC X(35)  VALUE SPACES.        
P00680     05 RS-PNDG-OPT-CSC-DSC-E-DUR PIC S9(04) COMP VALUE 0.        
P00680     05 RS-PNDG-OPT-CSC-DSC-E-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P680PN     05 RS-CUR-OPT-PRCE-NEG-CD    PIC X(01)  VALUE 'N'.           
P680PN     05 RS-PNDG-OPT-PRCE-NEG-CD   PIC X(01)  VALUE 'N'.           
P00805     05 RS-CURR-OPT-VALID-MNTHS   PIC S9(09) COMP VALUE 0.        
P00805     05 RS-CURR-OPT-CORE-RATE     PIC X(03)  VALUE SPACES.        
P00805     05 RS-CURR-OPT-ROR-END-DT    PIC X(10)  VALUE SPACES.        
P00805     05 RS-IS-CURR-RATE-SENIOR    PIC X(01)  VALUE 'N'.           
P00805     05 RS-PEND-OPT-VALID-MNTHS   PIC S9(09) COMP VALUE 0.        
P00805     05 RS-PEND-OPT-CORE-RATE     PIC X(03)  VALUE SPACES.        
P00805     05 RS-PEND-OPT-ROR-END-DT    PIC X(10)  VALUE SPACES.        
P00805     05 RS-IS-PEND-RATE-SENIOR    PIC X(01)  VALUE 'N'.           
P00805     05 RS-PEND-OPT-EXIT-FEE      PIC S9(5)V9(6)                  
P00805                                             USAGE COMP-3 VALUE 0.
P00892     05 RS-PEND-AUTO-REN-OPT-IN-FL  PIC X(01) VALUE SPACES.       
P00892     05 RS-CURR-AUTO-REN-OPT-IN-FL  PIC X(01) VALUE SPACES.       
P00892     05 RS-SEASONAL-FL              PIC X(01) VALUE SPACES.       
P00892     05 RS-CURR-DISP-AUTO-REN-FL    PIC X(01) VALUE SPACES.       
P00892     05 RS-PEND-DISP-AUTO-REN-FL    PIC X(01) VALUE SPACES.       
OTPOOL     05 RS-LOCAL-OFFICE             PIC X(03) VALUE SPACES.       
P805CS     05 RS-PAPERLESS-DSC-FL         PIC X(01) VALUE SPACES.       
P805CS     05 RS-PAPERLESS-DSC-AMT        PIC S9(5)V99 COMP-3 VALUE 0.  
P805CS     05 RS-AUTORENEW-DSC-FL         PIC X(01) VALUE SPACES.       
P805CS     05 RS-AUTORENEW-DSC-AMT        PIC S9(5)V99 COMP-3 VALUE 0.  
I02262     05 RS-AGL-PREM-NO              PIC S9(9)V   COMP-3 VALUE 0.  
I02262     05 RS-CODE-ACCT-STAT           PIC X(01) VALUE SPACES.       
I02262     05 RS-PREM-ADDR-ZIP-CODE       PIC X(05) VALUE SPACES.       
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05  S-OPT-REMAIN-MTHS        PIC S9(04) COMP VALUE 0.        
           05  S-CSC-AMOUNT             PIC S9(5)V9(6)                  
                                                   USAGE COMP-3 VALUE 0.
           05  S-EXIT-FEE-FLAG          PIC X(01)  VALUE SPACES.        
P00680     05  S-RATE-CHANGE-EXIT-FEE   PIC S9(5)V9(6)                  
                                                   USAGE COMP-3 VALUE 0.
           05  S-INIT-BILL-FL           PIC X(01)  VALUE SPACES.        
           05  S-THERM-PRICE            PIC S9(5)V9(6)                  
                                                   USAGE COMP-3 VALUE 0.
           05  S-ACCT-TIER              PIC S9(04) COMP VALUE 0.        
           05  S-CUSTOMER-NAME          PIC X(96)  VALUE SPACES.        
           05  S-ADDRESS                PIC X(71)  VALUE SPACES.        
           05  S-TIER-CUST-STAT-CD      PIC X(01)  VALUE SPACES.        
           05  S-TIER-ACCT-TYPE-CD      PIC X(01)  VALUE SPACES.        
           05  S-MKT-TIER-START-DT      PIC X(10)  VALUE SPACES.        
           05  S-OPT-DESC-INT-LONG      PIC X(255) VALUE SPACES.        
I00484     05  S-PEND-OPTION-FLAG       PIC X(01)  VALUE SPACES.        
I00484     05  S-PEND-THERM-PRICE       PIC S9(5)V9(6)                  
I00484                                             USAGE COMP-3 VALUE 0.
I00484     05  S-PEND-OPTION-CD         PIC X(12)  VALUE SPACES.        
I00484     05  S-PEND-OPTION-DESC       PIC X(255) VALUE SPACES.        
P00269     05  S-SUPER-USER-FLAG        PIC X(01)  VALUE 'N'.           
                                                                        
P00453     05  S-PRP-FL                 PIC X(01)  VALUE 'N'.           
P00680     05  S-RTPK-STAT-ADJ-FL       PIC X(01)  VALUE 'N'.           
P00680     05  S-OFFER-CD               PIC X(12)  VALUE SPACES.        
P00680     05  S-SWITCH-AWAY-EXIT-FEE   PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-THRM-PRC-DSCNT-FL                              
P00680                                  PIC X(01)  VALUE 'N'.           
P00680     05  S-CUR-OPT-CSC-DSCNT-FL   PIC X(01)  VALUE 'N'.           
P00680     05  S-CUR-OPT-DSCNTD-PRC     PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-DSCNTD-CSC     PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-TOT-PRC-DSCNT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-TOT-CSC-DSCNT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-PRC-DSC-A-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-PRC-DSC-A-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-PRC-DSC-A-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-PRC-DSC-B-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-PRC-DSC-B-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-PRC-DSC-B-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-PRC-DSC-C-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-PRC-DSC-C-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-PRC-DSC-C-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-PRC-DSC-D-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-PRC-DSC-D-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-PRC-DSC-D-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-PRC-DSC-E-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-PRC-DSC-E-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-PRC-DSC-E-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-CSC-DSC-A-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-CSC-DSC-A-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-CSC-DSC-A-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-CSC-DSC-B-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-CSC-DSC-B-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-CSC-DSC-B-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-CSC-DSC-C-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-CSC-DSC-C-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-CSC-DSC-C-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-CSC-DSC-D-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-CSC-DSC-D-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-CSC-DSC-D-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-CUR-OPT-CSC-DSC-E-TXT  PIC X(35)  VALUE SPACES.        
P00680     05  S-CUR-OPT-CSC-DSC-E-DUR  PIC S9(04) COMP VALUE 0.        
P00680     05  S-CUR-OPT-CSC-DSC-E-AMT  PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-THRM-PRC-DSCNT-FL                             
P00680                                  PIC X(01)  VALUE 'N'.           
P00680     05  S-PNDG-OPT-CSC-DSCNT-FL  PIC X(01)  VALUE 'N'.           
P00680     05  S-PNDG-OPT-DSCNTD-PRC    PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-DSCNTD-CSC    PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-TOT-PRC-DSCNT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-TOT-CSC-DSCNT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-PRC-DSC-A-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-PRC-DSC-A-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-PRC-DSC-A-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-PRC-DSC-B-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-PRC-DSC-B-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-PRC-DSC-B-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-PRC-DSC-C-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-PRC-DSC-C-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-PRC-DSC-C-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-PRC-DSC-D-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-PRC-DSC-D-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-PRC-DSC-D-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-PRC-DSC-E-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-PRC-DSC-E-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-PRC-DSC-E-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-CSC-DSC-A-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-CSC-DSC-A-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-CSC-DSC-A-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-CSC-DSC-B-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-CSC-DSC-B-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-CSC-DSC-B-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-CSC-DSC-C-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-CSC-DSC-C-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-CSC-DSC-C-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-CSC-DSC-D-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-CSC-DSC-D-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-CSC-DSC-D-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P00680     05  S-PNDG-OPT-CSC-DSC-E-TXT PIC X(35)  VALUE SPACES.        
P00680     05  S-PNDG-OPT-CSC-DSC-E-DUR PIC S9(04) COMP VALUE 0.        
P00680     05  S-PNDG-OPT-CSC-DSC-E-AMT PIC S9(5)V9(6)                  
P00680                                             USAGE COMP-3 VALUE 0.
P680PN     05  S-CUR-OPT-PRCE-NEG-CD    PIC X(01)  VALUE 'N'.           
P680PN     05  S-PNDG-OPT-PRCE-NEG-CD   PIC X(01)  VALUE 'N'.           
P00805     05  S-CURR-OPT-VALID-MNTHS   PIC S9(09) COMP VALUE 0.        
P00805     05  S-CURR-OPT-CORE-RATE     PIC X(03)  VALUE SPACES.        
P00805     05  S-CURR-OPT-ROR-END-DT    PIC X(10)  VALUE SPACES.        
P00805     05  S-IS-CURR-RATE-SENIOR    PIC X(01)  VALUE 'N'.           
P00805     05  S-PEND-OPT-VALID-MNTHS   PIC S9(09) COMP VALUE 0.        
P00805     05  S-PEND-OPT-CORE-RATE     PIC X(03)  VALUE SPACES.        
P00805     05  S-PEND-OPT-ROR-END-DT    PIC X(10)  VALUE SPACES.        
P00805     05  S-IS-PEND-RATE-SENIOR    PIC X(01)  VALUE 'N'.           
P00805     05  S-PEND-OPT-EXIT-FEE      PIC S9(5)V9(6)                  
P00805                                             USAGE COMP-3 VALUE 0.
P00892     05  S-PEND-AUTO-REN-OPT-IN-FL PIC X(01) VALUE SPACES.        
P00892     05  S-CURR-AUTO-REN-OPT-IN-FL PIC X(01) VALUE SPACES.        
P00892     05  S-SEASONAL-FL             PIC X(01) VALUE SPACES.        
P00892     05  S-CURR-DISP-AUTO-REN-FL   PIC X(01) VALUE SPACES.        
P00892     05  S-PEND-DISP-AUTO-REN-FL   PIC X(01) VALUE SPACES.        
OTPOOL     05  S-LOCAL-OFFICE            PIC X(03) VALUE SPACES.        
P805CS     05  S-PAPERLESS-DSC-FL        PIC X(01) VALUE SPACES.        
P805CS     05  S-PAPERLESS-DSC-AMT       PIC S9(5)V99 COMP-3 VALUE 0.   
P805CS     05  S-AUTORENEW-DSC-FL        PIC X(01) VALUE SPACES.        
P805CS     05  S-AUTORENEW-DSC-AMT       PIC S9(5)V99 COMP-3 VALUE 0.   
I02262     05  S-AGL-PREM-NO             PIC S9(9)V   COMP-3 VALUE 0.   
I02262     05  S-CODE-ACCT-STAT          PIC X(01) VALUE SPACES.        
I02262     05  S-PREM-ADDR-ZIP-CODE      PIC X(05) VALUE SPACES.        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
P00680******************************************************************        
P00680* DECLARE CURSOR TO RETRIEVE DISCOUNT FACTORS FOR CURRENT OPTION *        
P00680******************************************************************        
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         DECLARE ACTV_FIXED_FCTR_CUR CURSOR FOR                   
P00680          SELECT  SF.FACTOR_TEXT                                  
P00680                 ,DATALENGTH(LTRIM(RTRIM(SF.FACTOR_TEXT)))                
P00680                 ,SF.FCTR_POWER_10                                
P00680                 ,FF.FACTOR                                       
P00680                 ,HQ.DURATION_NO                                  
P00680                 ,HQ.RT_ATTR_INCTV_TYPE                           
P00680                                                                  
P00680            FROM  CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
P00680                 ,CSS_ACCT_RTPK_AGR    DF WITH(READUNCOMMITTED)           
P00680                 ,CSS_UTIL_ENVRNMT     UT WITH(READUNCOMMITTED)           
P00680                 ,CRM_OPT_ATTR_INCTV   HQ WITH(READUNCOMMITTED)           
P00680                 ,CSS_SPCL_FCTR        SF WITH(READUNCOMMITTED)           
P00680                                                                  
P00680           WHERE  DF.ACCOUNT_NO          = :DF-ACCOUNT-NO         
P00680             AND  DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE     
P00680             AND  DF.IC_NO               = :DF-IC-NO              
P00680             AND  UT.ACCOUNT_NO          = DF.ACCOUNT_NO          
P00680             AND  UT.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE      
P00680             AND  UT.IC_NO               = DF.IC_NO               
P00680             AND  UT.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO   
P00680             AND  FF.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO   
P00680             AND  FF.ACCOUNT_NO          = DF.ACCOUNT_NO          
P00680             AND  FF.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE      
P00680             AND  FF.IC_NO               = DF.IC_NO               
P00680             AND  FF.DURATION_REMAIN_NO  > 0                      
P00680             AND  FF.FACTOR_ID           = SF.FACTOR_ID           
P00680             AND  HQ.OPTION_CD           = DF.OPTION_CD           
P00680             AND  HQ.FACTOR_ID           = FF.FACTOR_ID           
P00680             AND  HQ.COMPANY_NO          = DF.COMPANY_NO          
P00680             AND  HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT    
P00680             AND  HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT    
P00680             AND  HQ.RT_ATTR_INCTV_TYPE IN ('PRICE DISCOUNT',     
P00680                                            'CSC DISCOUNT')       
P00680             AND  HQ.PROC_STATUS_CD      = 'AC'                   
P00680             AND  HQ.OPT_ATTR_VSTART_TS  = (                      
P00680                SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                
P00680                  FROM  CRM_OPT_ATTR_INCTV H1
                           WITH(READUNCOMMITTED)                     
P00680                 WHERE  H1.OPTION_CD      = HQ.OPTION_CD          
P00680                   AND  H1.RT_ATTR_INCTV_TYPE                     
P00680                                          = HQ.RT_ATTR_INCTV_TYPE 
P00680                   AND  H1.ATTR_INCTV_STRT_DT                     
P00680                                          <= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  H1.ATTR_INCTV_END_DT                      
P00680                                          >= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  CAST(H1.OPT_ATTR_VSTART_TS AS DATE)               
P00680                                          <= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  CAST(H1.OPT_ATTR_VEND_TS AS DATE)                 
P00680                                          >= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  H1.PROC_STATUS_CD  = 'AC')                
P00680             FOR READ ONLY                                      
P00680                                                          
P00680                                                     
P00680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACTV_FIXED_FCTR_CUR CURSOR FOR                           
MFA-TR*         SELECT  SF.FACTOR_TEXT                                          
MFA-TR*                ,LENGTH(STRIP(SF.FACTOR_TEXT))                           
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,HQ.DURATION_NO                                          
MFA-TR*                ,HQ.RT_ATTR_INCTV_TYPE                                   
MFA-TR*                                                                         
MFA-TR*           FROM  CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_ACCT_RTPK_AGR    DF                                 
MFA-TR*                ,CSS_UTIL_ENVRNMT     UT                                 
MFA-TR*                ,CRM_OPT_ATTR_INCTV   HQ                                 
MFA-TR*                ,CSS_SPCL_FCTR        SF                                 
MFA-TR*                                                                         
MFA-TR*          WHERE  DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                 
MFA-TR*            AND  DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE             
MFA-TR*            AND  DF.IC_NO               = :DF-IC-NO                      
MFA-TR*            AND  UT.ACCOUNT_NO          = DF.ACCOUNT_NO                  
MFA-TR*            AND  UT.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE              
MFA-TR*            AND  UT.IC_NO               = DF.IC_NO                       
MFA-TR*            AND  UT.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO           
MFA-TR*            AND  FF.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO           
MFA-TR*            AND  FF.ACCOUNT_NO          = DF.ACCOUNT_NO                  
MFA-TR*            AND  FF.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE              
MFA-TR*            AND  FF.IC_NO               = DF.IC_NO                       
MFA-TR*            AND  FF.DURATION_REMAIN_NO  > 0                              
MFA-TR*            AND  FF.FACTOR_ID           = SF.FACTOR_ID                   
MFA-TR*            AND  HQ.OPTION_CD           = DF.OPTION_CD                   
MFA-TR*            AND  HQ.FACTOR_ID           = FF.FACTOR_ID                   
MFA-TR*            AND  HQ.COMPANY_NO          = DF.COMPANY_NO                  
MFA-TR*            AND  HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT            
MFA-TR*            AND  HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT            
MFA-TR*            AND  HQ.RT_ATTR_INCTV_TYPE IN ('PRICE DISCOUNT',             
MFA-TR*                                           'CSC DISCOUNT')               
MFA-TR*            AND  HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*            AND  HQ.OPT_ATTR_VSTART_TS  = (                              
MFA-TR*               SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                 FROM  CRM_OPT_ATTR_INCTV H1                             
MFA-TR*                WHERE  H1.OPTION_CD      = HQ.OPTION_CD                  
MFA-TR*                  AND  H1.RT_ATTR_INCTV_TYPE                             
MFA-TR*                                         = HQ.RT_ATTR_INCTV_TYPE         
MFA-TR*                  AND  H1.ATTR_INCTV_STRT_DT                             
MFA-TR*                                         <= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  H1.ATTR_INCTV_END_DT                              
MFA-TR*                                         >= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  DATE(H1.OPT_ATTR_VSTART_TS)                       
MFA-TR*                                         <= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  DATE(H1.OPT_ATTR_VEND_TS)                         
MFA-TR*                                         >= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  H1.PROC_STATUS_CD  = 'AC')                        
MFA-TR*            FOR  FETCH ONLY                                              
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO  7200                                                    
MFA-TR*    END-EXEC.                                                            
P00680                                                                  
P00680******************************************************************        
P00680* DECLARE CURSOR TO RETRIEVE DISCOUNT FACTORS FOR PENDING OPTION *        
P00680******************************************************************        
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         DECLARE PEND_FIXED_FCTR_CUR CURSOR FOR                   
P00680          SELECT  SF.FACTOR_TEXT                                  
P00680                 ,DATALENGTH(LTRIM(RTRIM(SF.FACTOR_TEXT)))                
P00680                 ,SF.FCTR_POWER_10                                
P00680                 ,FF.FACTOR                                       
P00680                 ,HQ.DURATION_NO                                  
P00680                 ,HQ.RT_ATTR_INCTV_TYPE                           
P00680                                                                  
P00680            FROM  CSS_FIXED_FCTR       FF WITH(READUNCOMMITTED)           
P00680                 ,CSS_ACCT_RTPK_AGR    DF WITH(READUNCOMMITTED)           
P00680                 ,CSS_SPCL_FCTR        SF WITH(READUNCOMMITTED)           
P00680                 ,CRM_OPT_ATTR_INCTV   HQ WITH(READUNCOMMITTED)           
P00680                                                                  
P00680           WHERE  DF.ACCOUNT_NO          = :DF-ACCOUNT-NO         
P00680             AND  DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE     
P00680             AND  DF.IC_NO               = :DF-IC-NO              
P00680             AND  DF.STATUS_CD           = 'P'                    
P00680             AND  FF.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO   
P00680             AND  FF.ACCOUNT_NO          = DF.ACCOUNT_NO          
P00680             AND  FF.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE      
P00680             AND  FF.IC_NO               = DF.IC_NO               
P00680             AND  FF.FACTOR_ID           = SF.FACTOR_ID           
P00680             AND  FF.DURATION_REMAIN_NO  > 0                      
P00680             AND  HQ.OPTION_CD           = DF.OPTION_CD           
P00680             AND  HQ.FACTOR_ID           = FF.FACTOR_ID           
P00680             AND  HQ.COMPANY_NO          = DF.COMPANY_NO          
P00680             AND  HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT    
P00680             AND  HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT    
P00680             AND  HQ.RT_ATTR_INCTV_TYPE IN ('PRICE DISCOUNT',     
P00680                                            'CSC DISCOUNT')       
P00680             AND  HQ.PROC_STATUS_CD      = 'AC'                   
P00680             AND  HQ.OPT_ATTR_VSTART_TS  = (                      
P00680                SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                
P00680                  FROM  CRM_OPT_ATTR_INCTV H1
                           WITH(READUNCOMMITTED)                     
P00680                 WHERE  H1.OPTION_CD      = HQ.OPTION_CD          
P00680                   AND  H1.RT_ATTR_INCTV_TYPE                     
P00680                                          = HQ.RT_ATTR_INCTV_TYPE 
P00680                   AND  H1.ATTR_INCTV_STRT_DT                     
P00680                                          <= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  H1.ATTR_INCTV_END_DT                      
P00680                                          >= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  CAST(H1.OPT_ATTR_VSTART_TS AS DATE)               
P00680                                          <= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  CAST(H1.OPT_ATTR_VEND_TS AS DATE)                 
P00680                                          >= DF.OPT_AGRMT_EFF_DT  
P00680                   AND  H1.PROC_STATUS_CD  = 'AC')                
P00680             FOR READ ONLY                               
P00680                                                     
P00680     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PEND_FIXED_FCTR_CUR CURSOR FOR                           
MFA-TR*         SELECT  SF.FACTOR_TEXT                                          
MFA-TR*                ,LENGTH(STRIP(SF.FACTOR_TEXT))                           
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,HQ.DURATION_NO                                          
MFA-TR*                ,HQ.RT_ATTR_INCTV_TYPE                                   
MFA-TR*                                                                         
MFA-TR*           FROM  CSS_FIXED_FCTR       FF                                 
MFA-TR*                ,CSS_ACCT_RTPK_AGR    DF                                 
MFA-TR*                ,CSS_SPCL_FCTR        SF                                 
MFA-TR*                ,CRM_OPT_ATTR_INCTV   HQ                                 
MFA-TR*                                                                         
MFA-TR*          WHERE  DF.ACCOUNT_NO          = :DF-ACCOUNT-NO                 
MFA-TR*            AND  DF.CODE_UTIL_TYPE      = :DF-CODE-UTIL-TYPE             
MFA-TR*            AND  DF.IC_NO               = :DF-IC-NO                      
MFA-TR*            AND  DF.STATUS_CD           = 'P'                            
MFA-TR*            AND  FF.RT_PKG_OPT_SEQ_NO   = DF.RT_PKG_OPT_SEQ_NO           
MFA-TR*            AND  FF.ACCOUNT_NO          = DF.ACCOUNT_NO                  
MFA-TR*            AND  FF.CODE_UTIL_TYPE      = DF.CODE_UTIL_TYPE              
MFA-TR*            AND  FF.IC_NO               = DF.IC_NO                       
MFA-TR*            AND  FF.FACTOR_ID           = SF.FACTOR_ID                   
MFA-TR*            AND  FF.DURATION_REMAIN_NO  > 0                              
MFA-TR*            AND  HQ.OPTION_CD           = DF.OPTION_CD                   
MFA-TR*            AND  HQ.FACTOR_ID           = FF.FACTOR_ID                   
MFA-TR*            AND  HQ.COMPANY_NO          = DF.COMPANY_NO                  
MFA-TR*            AND  HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT            
MFA-TR*            AND  HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT            
MFA-TR*            AND  HQ.RT_ATTR_INCTV_TYPE IN ('PRICE DISCOUNT',             
MFA-TR*                                           'CSC DISCOUNT')               
MFA-TR*            AND  HQ.PROC_STATUS_CD      = 'AC'                           
MFA-TR*            AND  HQ.OPT_ATTR_VSTART_TS  = (                              
MFA-TR*               SELECT  MAX(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                 FROM  CRM_OPT_ATTR_INCTV H1                             
MFA-TR*                WHERE  H1.OPTION_CD      = HQ.OPTION_CD                  
MFA-TR*                  AND  H1.RT_ATTR_INCTV_TYPE                             
MFA-TR*                                         = HQ.RT_ATTR_INCTV_TYPE         
MFA-TR*                  AND  H1.ATTR_INCTV_STRT_DT                             
MFA-TR*                                         <= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  H1.ATTR_INCTV_END_DT                              
MFA-TR*                                         >= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  DATE(H1.OPT_ATTR_VSTART_TS)                       
MFA-TR*                                         <= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  DATE(H1.OPT_ATTR_VEND_TS)                         
MFA-TR*                                         >= DF.OPT_AGRMT_EFF_DT          
MFA-TR*                  AND  H1.PROC_STATUS_CD  = 'AC')                        
MFA-TR*            FOR  FETCH ONLY WITH UR                                      
MFA-TR*        QUERYNO  7230                                                    
MFA-TR*    END-EXEC.                                                            
P00680                                                                  
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                PIC X(13).                    
       01  PARM-CODE-UTIL-TYPE            PIC X(01).                    
       01  PARM-IC-NO                     PIC X(04).                    
       01  PARM-OPTION-CD                 PIC X(12).                    
       01  PARM-UPD-FLAG                  PIC X(01).                    
       01  PARM-ACCT-SUB-TYPE             PIC X(01).                    
P00269 01  PARM-USER-ID                   PIC X(07).                    
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-OPTION-CD                         
                                 PARM-UPD-FLAG                          
                                 PARM-ACCT-SUB-TYPE                     
P00269                           PARM-USER-ID.                          
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE         AS RETURN_CODE           
                       ,:S-OPT-REMAIN-MTHS     AS OPT_REMAIN_MTHS       
                       ,:S-CSC-AMOUNT          AS CSC_AMOUNT            
                       ,:S-EXIT-FEE-FLAG       AS EXIT_FEE_FLAG         
P00680                 ,:S-RATE-CHANGE-EXIT-FEE AS EXIT_FEE             
                       ,:S-INIT-BILL-FL        AS INIT_BILL_FL          
                       ,:S-THERM-PRICE         AS THERM_PRICE           
                       ,:S-ACCT-TIER           AS ACCT_TIER             
                       ,LTRIM(RTRIM(:S-CUSTOMER-NAME)) AS CUSTOMER_NAME        
                       ,LTRIM(RTRIM(:S-ADDRESS))       AS ADDRESS              
                       ,:S-TIER-CUST-STAT-CD   AS TIER_CUST_STAT_CD     
                       ,:S-TIER-ACCT-TYPE-CD   AS TIER_ACCT_TYPE_CD     
                       ,:S-MKT-TIER-START-DT   AS MKT_TIER_START_DT     
                       ,:S-MKT-TIER-START-DT   AS MKT_TIER_START_DT     
                       ,LTRIM(RTRIM(:S-OPT-DESC-INT-LONG)) AS OPT_DESC         
I00484                 ,:S-PEND-OPTION-FLAG    AS PEND_OPTION_FLAG      
I00484                 ,:S-PEND-THERM-PRICE    AS PEND_THERM_PRICE      
I00484                 ,:S-PEND-OPTION-CD      AS PEND_OPTION_CD        
I00484                 ,LTRIM(RTRIM(:S-PEND-OPTION-DESC)) AS 
           PEND_OPT_DESC     
P00269                 ,:S-SUPER-USER-FLAG     AS SUPER_USER_FLAG       
                                                                        
P00453                 ,:S-PRP-FL              AS PAG_FL                
P00680                 ,:S-RTPK-STAT-ADJ-FL    AS ADJUSTABLE_FLAG       
P00680                 ,:S-OFFER-CD            AS OFFER_CD              
P00680                 ,:S-SWITCH-AWAY-EXIT-FEE                         
P00680                                     AS SWITCH_EXIT_FEE           
P00680                 ,:S-CUR-OPT-THRM-PRC-DSCNT-FL                    
P00680                                     AS CUR_OPT_PRC_DSCNT_FL      
P00680                 ,:S-CUR-OPT-CSC-DSCNT-FL                         
P00680                                     AS CUR_OPT_CSC_DSCNT_FL      
P00680                 ,:S-CUR-OPT-DSCNTD-PRC                           
P00680                                     AS CUR_OPT_DSCNTD_PRC        
P00680                 ,:S-CUR-OPT-DSCNTD-CSC                           
P00680                                     AS CUR_OPT_DSCNTD_CSC        
P00680                 ,:S-CUR-OPT-TOT-PRC-DSCNT                        
P00680                                     AS CUR_OPT_TOT_PRC_DSCNT     
P00680                 ,:S-CUR-OPT-TOT-CSC-DSCNT                        
P00680                                     AS CUR_OPT_TOT_CSC_DSCNT     
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-PRC-DSC-A-TXT))                 
P00680                                     AS CUR_OPT_PRC_DSCNT_1_TXT   
P00680                 ,:S-CUR-OPT-PRC-DSC-A-DUR                        
P00680                                     AS CUR_OPT_PRC_DSCNT_1_DUR   
P00680                 ,:S-CUR-OPT-PRC-DSC-A-AMT                        
P00680                                     AS CUR_OPT_PRC_DSCNT_1_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-PRC-DSC-B-TXT))                 
P00680                                     AS CUR_OPT_PRC_DSCNT_2_TXT   
P00680                 ,:S-CUR-OPT-PRC-DSC-B-DUR                        
P00680                                     AS CUR_OPT_PRC_DSCNT_2_DUR   
P00680                 ,:S-CUR-OPT-PRC-DSC-B-AMT                        
P00680                                     AS CUR_OPT_PRC_DSCNT_2_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-PRC-DSC-C-TXT))                 
P00680                                     AS CUR_OPT_PRC_DSCNT_3_TXT   
P00680                 ,:S-CUR-OPT-PRC-DSC-C-DUR                        
P00680                                     AS CUR_OPT_PRC_DSCNT_3_DUR   
P00680                 ,:S-CUR-OPT-PRC-DSC-C-AMT                        
P00680                                     AS CUR_OPT_PRC_DSCNT_3_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-PRC-DSC-D-TXT))                 
P00680                                     AS CUR_OPT_PRC_DSCNT_4_TXT   
P00680                 ,:S-CUR-OPT-PRC-DSC-D-DUR                        
P00680                                     AS CUR_OPT_PRC_DSCNT_4_DUR   
P00680                 ,:S-CUR-OPT-PRC-DSC-D-AMT                        
P00680                                     AS CUR_OPT_PRC_DSCNT_4_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-PRC-DSC-E-TXT))                 
P00680                                     AS CUR_OPT_PRC_DSCNT_5_TXT   
P00680                 ,:S-CUR-OPT-PRC-DSC-E-DUR                        
P00680                                     AS CUR_OPT_PRC_DSCNT_5_DUR   
P00680                 ,:S-CUR-OPT-PRC-DSC-E-AMT                        
P00680                                     AS CUR_OPT_PRC_DSCNT_5_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-CSC-DSC-A-TXT))                 
P00680                                     AS CUR_OPT_CSC_DSCNT_1_TXT   
P00680                 ,:S-CUR-OPT-CSC-DSC-A-DUR                        
P00680                                     AS CUR_OPT_CSC_DSCNT_1_DUR   
P00680                 ,:S-CUR-OPT-CSC-DSC-A-AMT                        
P00680                                     AS CUR_OPT_CSC_DSCNT_1_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-CSC-DSC-B-TXT))                 
P00680                                     AS CUR_OPT_CSC_DSCNT_2_TXT   
P00680                 ,:S-CUR-OPT-CSC-DSC-B-DUR                        
P00680                                     AS CUR_OPT_CSC_DSCNT_2_DUR   
P00680                 ,:S-CUR-OPT-CSC-DSC-B-AMT                        
P00680                                     AS CUR_OPT_CSC_DSCNT_2_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-CSC-DSC-C-TXT))                 
P00680                                     AS CUR_OPT_CSC_DSCNT_3_TXT   
P00680                 ,:S-CUR-OPT-CSC-DSC-C-DUR                        
P00680                                     AS CUR_OPT_CSC_DSCNT_3_DUR   
P00680                 ,:S-CUR-OPT-CSC-DSC-C-AMT                        
P00680                                     AS CUR_OPT_CSC_DSCNT_3_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-CSC-DSC-D-TXT))                 
P00680                                     AS CUR_OPT_CSC_DSCNT_4_TXT   
P00680                 ,:S-CUR-OPT-CSC-DSC-D-DUR                        
P00680                                     AS CUR_OPT_CSC_DSCNT_4_DUR   
P00680                 ,:S-CUR-OPT-CSC-DSC-D-AMT                        
P00680                                     AS CUR_OPT_CSC_DSCNT_4_AMT   
P00680                 ,LTRIM(RTRIM(:S-CUR-OPT-CSC-DSC-E-TXT))                 
P00680                                     AS CUR_OPT_CSC_DSCNT_5_TXT   
P00680                 ,:S-CUR-OPT-CSC-DSC-E-DUR                        
P00680                                     AS CUR_OPT_CSC_DSCNT_5_DUR   
P00680                 ,:S-CUR-OPT-CSC-DSC-E-AMT                        
P00680                                     AS CUR_OPT_CSC_DSCNT_5_AMT   
P00680                 ,:S-PNDG-OPT-THRM-PRC-DSCNT-FL                   
P00680                                     AS PNDG_OPT_PRC_DSCNT_FL     
P00680                 ,:S-PNDG-OPT-CSC-DSCNT-FL                        
P00680                                     AS PNDG_OPT_CSC_DSCNT_FL     
P00680                 ,:S-PNDG-OPT-DSCNTD-PRC                          
P00680                                     AS PNDG_OPT_DSCNTD_PRC       
P00680                 ,:S-PNDG-OPT-DSCNTD-CSC                          
P00680                                     AS PNDG_OPT_DSCNTD_CSC       
P00680                 ,:S-PNDG-OPT-TOT-PRC-DSCNT                       
P00680                                     AS PNDG_OPT_TOT_PRC_DSCNT    
P00680                 ,:S-PNDG-OPT-TOT-CSC-DSCNT                       
P00680                                     AS PNDG_OPT_TOT_CSC_DSCNT    
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-PRC-DSC-A-TXT))                
P00680                                     AS PNDG_OPT_PRC_DSCNT_1_TXT  
P00680                 ,:S-PNDG-OPT-PRC-DSC-A-DUR                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_1_DUR  
P00680                 ,:S-PNDG-OPT-PRC-DSC-A-AMT                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_1_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-PRC-DSC-B-TXT))                
P00680                                     AS PNDG_OPT_PRC_DSCNT_2_TXT  
P00680                 ,:S-PNDG-OPT-PRC-DSC-B-DUR                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_2_DUR  
P00680                 ,:S-PNDG-OPT-PRC-DSC-B-AMT                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_2_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-PRC-DSC-C-TXT))                
P00680                                     AS PNDG_OPT_PRC_DSCNT_3_TXT  
P00680                 ,:S-PNDG-OPT-PRC-DSC-C-DUR                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_3_DUR  
P00680                 ,:S-PNDG-OPT-PRC-DSC-C-AMT                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_3_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-PRC-DSC-D-TXT))                
P00680                                     AS PNDG_OPT_PRC_DSCNT_4_TXT  
P00680                 ,:S-PNDG-OPT-PRC-DSC-D-DUR                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_4_DUR  
P00680                 ,:S-PNDG-OPT-PRC-DSC-D-AMT                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_4_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-PRC-DSC-E-TXT))                
P00680                                     AS PNDG_OPT_PRC_DSCNT_5_TXT  
P00680                 ,:S-PNDG-OPT-PRC-DSC-E-DUR                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_5_DUR  
P00680                 ,:S-PNDG-OPT-PRC-DSC-E-AMT                       
P00680                                     AS PNDG_OPT_PRC_DSCNT_5_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-CSC-DSC-A-TXT))                
P00680                                     AS PNDG_OPT_CSC_DSCNT_1_TXT  
P00680                 ,:S-PNDG-OPT-CSC-DSC-A-DUR                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_1_DUR  
P00680                 ,:S-PNDG-OPT-CSC-DSC-A-AMT                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_1_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-CSC-DSC-B-TXT))                
P00680                                     AS PNDG_OPT_CSC_DSCNT_2_TXT  
P00680                 ,:S-PNDG-OPT-CSC-DSC-B-DUR                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_2_DUR  
P00680                 ,:S-PNDG-OPT-CSC-DSC-B-AMT                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_2_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-CSC-DSC-C-TXT))                
P00680                                     AS PNDG_OPT_CSC_DSCNT_3_TXT  
P00680                 ,:S-PNDG-OPT-CSC-DSC-C-DUR                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_3_DUR  
P00680                 ,:S-PNDG-OPT-CSC-DSC-C-AMT                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_3_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-CSC-DSC-D-TXT))                
P00680                                     AS PNDG_OPT_CSC_DSCNT_4_TXT  
P00680                 ,:S-PNDG-OPT-CSC-DSC-D-DUR                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_4_DUR  
P00680                 ,:S-PNDG-OPT-CSC-DSC-D-AMT                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_4_AMT  
P00680                 ,LTRIM(RTRIM(:S-PNDG-OPT-CSC-DSC-E-TXT))                
P00680                                     AS PNDG_OPT_CSC_DSCNT_5_TXT  
P00680                 ,:S-PNDG-OPT-CSC-DSC-E-DUR                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_5_DUR  
P00680                 ,:S-PNDG-OPT-CSC-DSC-E-AMT                       
P00680                                     AS PNDG_OPT_CSC_DSCNT_5_AMT  
P680PN                 ,:S-CUR-OPT-PRCE-NEG-CD                          
P680PN                                     AS CUR_OPT_PRCE_NEG_CD       
P680PN                 ,:S-PNDG-OPT-PRCE-NEG-CD                         
P680PN                                     AS PNDG_OPT_PRCE_NEG_CD      
P00805                 ,:S-CURR-OPT-VALID-MNTHS                         
P00805                                     AS CURR_OPT_VALID_MNTHS      
P00805                 ,LTRIM(RTRIM(:S-CURR-OPT-CORE-RATE))                    
P00805                                     AS CURR_OPT_CORE_RATE        
P00805                 ,LTRIM(RTRIM(:S-CURR-OPT-ROR-END-DT))                   
P00805                                     AS CURR_OPT_ROR_END_DT       
P00805                 ,LTRIM(RTRIM(:S-IS-CURR-RATE-SENIOR))                   
P00805                                     AS IS_CURR_RATE_SENIOR       
P00805                 ,:S-PEND-OPT-VALID-MNTHS                         
P00805                                     AS PEND_OPT_VALID_MNTHS      
P00805                 ,LTRIM(RTRIM(:S-PEND-OPT-CORE-RATE))                    
P00805                                     AS PEND_OPT_CORE_RATE        
P00805                 ,LTRIM(RTRIM(:S-PEND-OPT-ROR-END-DT))                   
P00805                                     AS PEND_OPT_ROR_END_DT       
P00805                 ,LTRIM(RTRIM(:S-IS-PEND-RATE-SENIOR))                   
P00805                                     AS IS_PEND_RATE_SENIOR       
P00805                 ,:S-PEND-OPT-EXIT-FEE                            
P00805                                     AS PEND_OPT_EXIT_FEE         
P00892                 ,:S-PEND-AUTO-REN-OPT-IN-FL                      
P00892                                     AS PEND_AUTO_REN_OPT_IN_FL   
P00892                 ,:S-CURR-AUTO-REN-OPT-IN-FL                      
P00892                                     AS CURR_AUTO_REN_OPT_IN_FL   
P00892                 ,:S-SEASONAL-FL     AS SEASONAL_FL               
P00892                 ,:S-CURR-DISP-AUTO-REN-FL                        
P00892                                     AS CURR_DISP_AUTO_REN_FL     
P00892                 ,:S-PEND-DISP-AUTO-REN-FL                        
P00892                                     AS PEND_DISP_AUTO_REN_FL     
OTPOOL                 ,:S-LOCAL-OFFICE    AS LOCAL_OFFICE              
P805CS                 ,:S-PAPERLESS-DSC-FL                             
P805CS                                     AS PAPERLESS_CSC_DSC_FL      
P805CS                 ,:S-PAPERLESS-DSC-AMT                            
P805CS                                     AS PAPERLESS_CSC_DSC_AMT     
P805CS                 ,:S-AUTORENEW-DSC-FL                             
P805CS                                     AS AUTORENEW_CSC_DSC_FL      
P805CS                 ,:S-AUTORENEW-DSC-AMT                            
P805CS                                     AS AUTORENEW_CSC_DSC_AMT     
I02262                 ,:S-AGL-PREM-NO     AS AGL_PREM_NO               
I02262                 ,:S-CODE-ACCT-STAT  AS CODE_ACCT_STAT            
I02262                 ,:S-PREM-ADDR-ZIP-CODE                           
I02262                                     AS PREM_ADDR_ZIP_CODE        
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE         AS RETURN_CODE                   
MFA-TR*                ,:S-OPT-REMAIN-MTHS     AS OPT_REMAIN_MTHS               
MFA-TR*                ,:S-CSC-AMOUNT          AS CSC_AMOUNT                    
MFA-TR*                ,:S-EXIT-FEE-FLAG       AS EXIT_FEE_FLAG                 
MFA-TR*                ,:S-RATE-CHANGE-EXIT-FEE AS EXIT_FEE                     
MFA-TR*                ,:S-INIT-BILL-FL        AS INIT_BILL_FL                  
MFA-TR*                ,:S-THERM-PRICE         AS THERM_PRICE                   
MFA-TR*                ,:S-ACCT-TIER           AS ACCT_TIER                     
MFA-TR*                ,STRIP(:S-CUSTOMER-NAME) AS CUSTOMER_NAME                
MFA-TR*                ,STRIP(:S-ADDRESS)       AS ADDRESS                      
MFA-TR*                ,:S-TIER-CUST-STAT-CD   AS TIER_CUST_STAT_CD             
MFA-TR*                ,:S-TIER-ACCT-TYPE-CD   AS TIER_ACCT_TYPE_CD             
MFA-TR*                ,:S-MKT-TIER-START-DT   AS MKT_TIER_START_DT             
MFA-TR*                ,:S-MKT-TIER-START-DT   AS MKT_TIER_START_DT             
MFA-TR*                ,STRIP(:S-OPT-DESC-INT-LONG) AS OPT_DESC                 
MFA-TR*                ,:S-PEND-OPTION-FLAG    AS PEND_OPTION_FLAG              
MFA-TR*                ,:S-PEND-THERM-PRICE    AS PEND_THERM_PRICE              
MFA-TR*                ,:S-PEND-OPTION-CD      AS PEND_OPTION_CD                
MFA-TR*                ,STRIP(:S-PEND-OPTION-DESC) AS PEND_OPT_DESC             
MFA-TR*                ,:S-SUPER-USER-FLAG     AS SUPER_USER_FLAG               
MFA-TR*                                                                         
MFA-TR*                ,:S-PRP-FL              AS PAG_FL                        
MFA-TR*                ,:S-RTPK-STAT-ADJ-FL    AS ADJUSTABLE_FLAG               
MFA-TR*                ,:S-OFFER-CD            AS OFFER_CD                      
MFA-TR*                ,:S-SWITCH-AWAY-EXIT-FEE                                 
MFA-TR*                                    AS SWITCH_EXIT_FEE                   
MFA-TR*                ,:S-CUR-OPT-THRM-PRC-DSCNT-FL                            
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_FL              
MFA-TR*                ,:S-CUR-OPT-CSC-DSCNT-FL                                 
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_FL              
MFA-TR*                ,:S-CUR-OPT-DSCNTD-PRC                                   
MFA-TR*                                    AS CUR_OPT_DSCNTD_PRC                
MFA-TR*                ,:S-CUR-OPT-DSCNTD-CSC                                   
MFA-TR*                                    AS CUR_OPT_DSCNTD_CSC                
MFA-TR*                ,:S-CUR-OPT-TOT-PRC-DSCNT                                
MFA-TR*                                    AS CUR_OPT_TOT_PRC_DSCNT             
MFA-TR*                ,:S-CUR-OPT-TOT-CSC-DSCNT                                
MFA-TR*                                    AS CUR_OPT_TOT_CSC_DSCNT             
MFA-TR*                ,STRIP(:S-CUR-OPT-PRC-DSC-A-TXT)                         
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_1_TXT           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-A-DUR                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_1_DUR           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-A-AMT                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_1_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-PRC-DSC-B-TXT)                         
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_2_TXT           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-B-DUR                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_2_DUR           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-B-AMT                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_2_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-PRC-DSC-C-TXT)                         
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_3_TXT           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-C-DUR                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_3_DUR           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-C-AMT                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_3_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-PRC-DSC-D-TXT)                         
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_4_TXT           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-D-DUR                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_4_DUR           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-D-AMT                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_4_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-PRC-DSC-E-TXT)                         
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_5_TXT           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-E-DUR                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_5_DUR           
MFA-TR*                ,:S-CUR-OPT-PRC-DSC-E-AMT                                
MFA-TR*                                    AS CUR_OPT_PRC_DSCNT_5_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-CSC-DSC-A-TXT)                         
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_1_TXT           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-A-DUR                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_1_DUR           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-A-AMT                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_1_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-CSC-DSC-B-TXT)                         
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_2_TXT           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-B-DUR                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_2_DUR           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-B-AMT                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_2_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-CSC-DSC-C-TXT)                         
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_3_TXT           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-C-DUR                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_3_DUR           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-C-AMT                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_3_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-CSC-DSC-D-TXT)                         
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_4_TXT           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-D-DUR                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_4_DUR           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-D-AMT                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_4_AMT           
MFA-TR*                ,STRIP(:S-CUR-OPT-CSC-DSC-E-TXT)                         
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_5_TXT           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-E-DUR                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_5_DUR           
MFA-TR*                ,:S-CUR-OPT-CSC-DSC-E-AMT                                
MFA-TR*                                    AS CUR_OPT_CSC_DSCNT_5_AMT           
MFA-TR*                ,:S-PNDG-OPT-THRM-PRC-DSCNT-FL                           
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_FL             
MFA-TR*                ,:S-PNDG-OPT-CSC-DSCNT-FL                                
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_FL             
MFA-TR*                ,:S-PNDG-OPT-DSCNTD-PRC                                  
MFA-TR*                                    AS PNDG_OPT_DSCNTD_PRC               
MFA-TR*                ,:S-PNDG-OPT-DSCNTD-CSC                                  
MFA-TR*                                    AS PNDG_OPT_DSCNTD_CSC               
MFA-TR*                ,:S-PNDG-OPT-TOT-PRC-DSCNT                               
MFA-TR*                                    AS PNDG_OPT_TOT_PRC_DSCNT            
MFA-TR*                ,:S-PNDG-OPT-TOT-CSC-DSCNT                               
MFA-TR*                                    AS PNDG_OPT_TOT_CSC_DSCNT            
MFA-TR*                ,STRIP(:S-PNDG-OPT-PRC-DSC-A-TXT)                        
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_1_TXT          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-A-DUR                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_1_DUR          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-A-AMT                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_1_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-PRC-DSC-B-TXT)                        
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_2_TXT          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-B-DUR                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_2_DUR          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-B-AMT                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_2_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-PRC-DSC-C-TXT)                        
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_3_TXT          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-C-DUR                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_3_DUR          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-C-AMT                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_3_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-PRC-DSC-D-TXT)                        
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_4_TXT          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-D-DUR                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_4_DUR          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-D-AMT                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_4_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-PRC-DSC-E-TXT)                        
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_5_TXT          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-E-DUR                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_5_DUR          
MFA-TR*                ,:S-PNDG-OPT-PRC-DSC-E-AMT                               
MFA-TR*                                    AS PNDG_OPT_PRC_DSCNT_5_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-CSC-DSC-A-TXT)                        
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_1_TXT          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-A-DUR                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_1_DUR          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-A-AMT                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_1_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-CSC-DSC-B-TXT)                        
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_2_TXT          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-B-DUR                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_2_DUR          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-B-AMT                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_2_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-CSC-DSC-C-TXT)                        
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_3_TXT          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-C-DUR                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_3_DUR          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-C-AMT                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_3_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-CSC-DSC-D-TXT)                        
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_4_TXT          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-D-DUR                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_4_DUR          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-D-AMT                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_4_AMT          
MFA-TR*                ,STRIP(:S-PNDG-OPT-CSC-DSC-E-TXT)                        
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_5_TXT          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-E-DUR                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_5_DUR          
MFA-TR*                ,:S-PNDG-OPT-CSC-DSC-E-AMT                               
MFA-TR*                                    AS PNDG_OPT_CSC_DSCNT_5_AMT          
MFA-TR*                ,:S-CUR-OPT-PRCE-NEG-CD                                  
MFA-TR*                                    AS CUR_OPT_PRCE_NEG_CD               
MFA-TR*                ,:S-PNDG-OPT-PRCE-NEG-CD                                 
MFA-TR*                                    AS PNDG_OPT_PRCE_NEG_CD              
MFA-TR*                ,:S-CURR-OPT-VALID-MNTHS                                 
MFA-TR*                                    AS CURR_OPT_VALID_MNTHS              
MFA-TR*                ,STRIP(:S-CURR-OPT-CORE-RATE)                            
MFA-TR*                                    AS CURR_OPT_CORE_RATE                
MFA-TR*                ,STRIP(:S-CURR-OPT-ROR-END-DT)                           
MFA-TR*                                    AS CURR_OPT_ROR_END_DT               
MFA-TR*                ,STRIP(:S-IS-CURR-RATE-SENIOR)                           
MFA-TR*                                    AS IS_CURR_RATE_SENIOR               
MFA-TR*                ,:S-PEND-OPT-VALID-MNTHS                                 
MFA-TR*                                    AS PEND_OPT_VALID_MNTHS              
MFA-TR*                ,STRIP(:S-PEND-OPT-CORE-RATE)                            
MFA-TR*                                    AS PEND_OPT_CORE_RATE                
MFA-TR*                ,STRIP(:S-PEND-OPT-ROR-END-DT)                           
MFA-TR*                                    AS PEND_OPT_ROR_END_DT               
MFA-TR*                ,STRIP(:S-IS-PEND-RATE-SENIOR)                           
MFA-TR*                                    AS IS_PEND_RATE_SENIOR               
MFA-TR*                ,:S-PEND-OPT-EXIT-FEE                                    
MFA-TR*                                    AS PEND_OPT_EXIT_FEE                 
MFA-TR*                ,:S-PEND-AUTO-REN-OPT-IN-FL                              
MFA-TR*                                    AS PEND_AUTO_REN_OPT_IN_FL           
MFA-TR*                ,:S-CURR-AUTO-REN-OPT-IN-FL                              
MFA-TR*                                    AS CURR_AUTO_REN_OPT_IN_FL           
MFA-TR*                ,:S-SEASONAL-FL     AS SEASONAL_FL                       
MFA-TR*                ,:S-CURR-DISP-AUTO-REN-FL                                
MFA-TR*                                    AS CURR_DISP_AUTO_REN_FL             
MFA-TR*                ,:S-PEND-DISP-AUTO-REN-FL                                
MFA-TR*                                    AS PEND_DISP_AUTO_REN_FL             
MFA-TR*                ,:S-LOCAL-OFFICE    AS LOCAL_OFFICE                      
MFA-TR*                ,:S-PAPERLESS-DSC-FL                                     
MFA-TR*                                    AS PAPERLESS_CSC_DSC_FL              
MFA-TR*                ,:S-PAPERLESS-DSC-AMT                                    
MFA-TR*                                    AS PAPERLESS_CSC_DSC_AMT             
MFA-TR*                ,:S-AUTORENEW-DSC-FL                                     
MFA-TR*                                    AS AUTORENEW_CSC_DSC_FL              
MFA-TR*                ,:S-AUTORENEW-DSC-AMT                                    
MFA-TR*                                    AS AUTORENEW_CSC_DSC_AMT             
MFA-TR*                ,:S-AGL-PREM-NO     AS AGL_PREM_NO                       
MFA-TR*                ,:S-CODE-ACCT-STAT  AS CODE_ACCT_STAT                    
MFA-TR*                ,:S-PREM-ADDR-ZIP-CODE                                   
MFA-TR*                                    AS PREM_ADDR_ZIP_CODE                
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO              
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE          
           MOVE PARM-IC-NO                TO WS-IC-NO                   
           MOVE PARM-OPTION-CD            TO WS-OPTION-CD.              
           MOVE PARM-UPD-FLAG             TO WS-UPD-FLAG.               
           MOVE PARM-ACCT-SUB-TYPE        TO WS-ACCT-SUB-TYPE.          
P00269     MOVE PARM-USER-ID              TO WS-USER-ID.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE     WS-PK-EXISTS .                                
           MOVE WS-ACCOUNT-NO                TO AT-ACCOUNT-NO           
                                                DD-ACCOUNT-NO           
                                                FF-ACCOUNT-NO           
                                                LR-ACCOUNT-NO           
P00453                                          PK-ACCOUNT-NO           
                                                WS-ACCOUNT-NO-063       
P00680                                          DF-ACCOUNT-NO           
P00892                                          TA-ACCOUNT-NO.          
I00113     MOVE 'N'                          TO WS-TIER-RANK-SET        
           MOVE WS-OPTION-CD                 TO FI-OPTION-CD            
                                                HQ-OPTION-CD.           
           MOVE WS-CODE-UTIL-TYPE            TO FF-CODE-UTIL-TYPE       
                                                WS-CODE-UTIL-TYPE-063   
P00680                                          DF-CODE-UTIL-TYPE.      
           MOVE WS-IC-NO                     TO FF-IC-NO                
                                                WS-IC-NO-063            
P00680                                          DF-IC-NO.               
P00269     MOVE WS-USER-ID                   TO F5-USER-ID.             
                                                                        
           PERFORM 7000-SEL-ACCT-DET            THRU 7000-EXIT.         
                                                                        
OTPOOL     MOVE AT-LOCAL-OFFICE              TO RS-LOCAL-OFFICE.        
I02262     MOVE PR-AGL-PREM-NO               TO RS-AGL-PREM-NO.         
I02262     MOVE AT-CODE-ACCT-STAT            TO RS-CODE-ACCT-STAT.      
                                                                        
P00453     MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
P00453     IF WS-CODE-PRE-PAY-PLAN = WS-ACTIVE                          
P00453        MOVE 'Y'                       TO RS-PRP-FL               
P00453     ELSE                                                         
P00453        IF AT-CODE-ACCT-STAT = 'B'                                
P00453           PERFORM 7126-GET-PREPAY-HIST   THRU 7126-EXIT          
P00453           IF WS-PK-EXISTS    = 'Y'    THEN                       
P00453              MOVE 'Y'                 TO RS-PRP-FL               
P00453           END-IF                                                 
P00453        END-IF                                                    
P00453     END-IF.                                                      
P00453                                                                  
P00269     PERFORM 7110-GET-SUPER-USER-FLAG  THRU 7110-EXIT.            
P00269     MOVE WS-SUPER-USER-FLAG           TO RS-SUPER-USER-FLAG.     
                                                                        
                                                                        
                                                                        
           MOVE ZEROES                       TO DD-MKT-TIER-RANKING     
           IF WS-UPD-FLAG EQUAL 'I'                                     
              MOVE ZEROES                    TO RS-OPT-REMAIN-MTHS      
                                                RS-CSC-AMOUNT           
P00680                                          RS-RATE-CHANGE-EXIT-FEE 
P00680                                          RS-SWITCH-AWAY-EXIT-FEE 
                                                RS-THERM-PRICE          
              MOVE 'N'                       TO RS-EXIT-FEE-FLAG        
                                                RS-INIT-BILL-FL         
P00680                                          RS-RTPK-STAT-ADJ-FL     
P680PN                                          RS-CUR-OPT-PRCE-NEG-CD  
P680PN                                          RS-PNDG-OPT-PRCE-NEG-CD 
              MOVE SPACES                    TO RS-OPT-DESC-INT-LONG    
              MOVE WS-ACCT-SUB-TYPE          TO IG-TIER-ACCT-TYPE-CD    
                                                RS-TIER-ACCT-TYPE-CD    
                                                                        
              MOVE SPACES                    TO LR-REG-GROUP-CD         
              PERFORM 7050-SEL-REG-PROFILE      THRU 7050-EXIT          
              IF LR-REG-GROUP-CD > SPACES                               
                 MOVE 'E'                    TO IG-TIER-CUST-STAT-CD    
                                                RS-TIER-CUST-STAT-CD    
              ELSE                                                      
                 MOVE 'P'                    TO IG-TIER-CUST-STAT-CD    
                                                RS-TIER-CUST-STAT-CD    
              END-IF                                                    
                                                                        
              PERFORM 7020-SEL-MKT-TIER-RANKING THRU 7020-EXIT          
I00113        PERFORM 5100-CHK-CUST-QUALIFY-SS  THRU 5100-EXIT          
P00677        IF GRP1-SR-ELIGIBLE OR GRP2-SR-ELIGIBLE                   
I00113           CONTINUE                                               
I00113        ELSE                                                      
                 IF DD-TIER-ACCT-TYPE-CD EQUAL WS-ACCT-SUB-TYPE         
I00113                                         AND TIER-RANK-SET        
                    MOVE DD-MKT-TIER-RANKING   TO RS-ACCT-TIER          
                    MOVE DD-MKT-TIER-START-DT  TO RS-MKT-TIER-START-DT  
                    MOVE DD-TIER-CUST-STAT-CD  TO RS-TIER-CUST-STAT-CD  
                 ELSE                                                   
P00453              IF RS-PRP-FL = 'Y' THEN                             
P00453                 MOVE '01'                 TO C8-COMPANY-NO       
P00453                 MOVE WS-PRP-DEFAULT-TIER  TO C8-DELINQ-CD        
P00453                 PERFORM 7060-SELECT-DELINQNCY                    
P00453                                           THRU 7060-EXIT         
P00453                 MOVE C8-DELINQ-VALUE      TO WS-PRP-MKT-TIER-RANK
P00453                 MOVE WS-PRP-MKT-TIER-RANK TO IG-MKT-TIER-RANKING 
P00453                 PERFORM 7045-SELECT-PRP-TIER-DTLS THRU 7045-EXIT 
P00453              ELSE                                                
                       MOVE 'Y'                 TO IG-CUST-ACCT-DEFLT-FL
                       PERFORM 7040-SELECT-DEFLT-RANKIG  THRU 7040-EXIT 
P00453              END-IF                                              
                    MOVE IG-MKT-TIER-RANKING   TO RS-ACCT-TIER          
                    MOVE IG-MKT-TIER-START-DT  TO RS-MKT-TIER-START-DT  
                 END-IF                                                 
I00113        END-IF                                                    
           ELSE                                                         
              IF WS-CODE-UTIL-TYPE > SPACES AND WS-IC-NO > ZEROES       
                 PERFORM 5050-GET-ACCT-REL-DET THRU 5050-EXIT           
              END-IF                                                    
              PERFORM 7020-SEL-MKT-TIER-RANKING THRU 7020-EXIT          
I00113        PERFORM 5100-CHK-CUST-QUALIFY-SS  THRU 5100-EXIT          
P00677        IF GRP1-SR-ELIGIBLE OR GRP2-SR-ELIGIBLE                   
I00113           CONTINUE                                               
I00113        ELSE                                                      
                 IF DD-TIER-ACCT-TYPE-CD NOT EQUAL WS-ACCT-SUB-TYPE     
                    MOVE WS-ACCT-SUB-TYPE      TO IG-TIER-ACCT-TYPE-CD  
                                                  RS-TIER-ACCT-TYPE-CD  
                    MOVE DD-TIER-CUST-STAT-CD  TO IG-TIER-CUST-STAT-CD  
                                                  RS-TIER-CUST-STAT-CD  
P00453              IF RS-PRP-FL = 'Y' THEN                             
P00453                 MOVE '01'                 TO C8-COMPANY-NO       
P00453                 MOVE WS-PRP-DEFAULT-TIER  TO C8-DELINQ-CD        
P00453                 PERFORM 7060-SELECT-DELINQNCY                    
P00453                                           THRU 7060-EXIT         
P00453                 MOVE C8-DELINQ-VALUE      TO WS-PRP-MKT-TIER-RANK
P00453                 MOVE WS-PRP-MKT-TIER-RANK TO IG-MKT-TIER-RANKING 
P00453                 PERFORM 7045-SELECT-PRP-TIER-DTLS THRU 7045-EXIT 
P00453              ELSE                                                
                       MOVE 'Y'                 TO IG-CUST-ACCT-DEFLT-FL
                       PERFORM 7040-SELECT-DEFLT-RANKIG  THRU 7040-EXIT 
P00453              END-IF                                              
                    MOVE IG-MKT-TIER-RANKING   TO RS-ACCT-TIER          
                    MOVE IG-MKT-TIER-START-DT  TO RS-MKT-TIER-START-DT  
                 ELSE                                                   
                    MOVE DD-TIER-ACCT-TYPE-CD   TO RS-TIER-ACCT-TYPE-CD 
                    MOVE DD-MKT-TIER-RANKING    TO RS-ACCT-TIER         
                    MOVE DD-TIER-CUST-STAT-CD   TO RS-TIER-CUST-STAT-CD 
                    MOVE DD-MKT-TIER-START-DT   TO RS-MKT-TIER-START-DT 
                 END-IF                                                 
I00113        END-IF                                                    
           END-IF                                                       
                                                                        
P00680**** GET THERM PRICE AND CSC DISCOUNTS FOR CURRENT OPTION CODE            
P00680     MOVE 'N'                          TO WS-NO-MORE-ROWS .       
P00680     MOVE +1                           TO WS-PRC-DSCNT-CTR        
P00680                                          WS-CSC-DSCNT-CTR.       
P00680     MOVE RS-THERM-PRICE               TO RS-CUR-OPT-DSCNTD-PRC.  
P00680     MOVE RS-CSC-AMOUNT                TO RS-CUR-OPT-DSCNTD-CSC.  
P00680     MOVE ZEROS                        TO RS-CUR-OPT-TOT-PRC-DSCNT
P00680                                          RS-CUR-OPT-TOT-CSC-DSCNT
P00680     PERFORM 7200-OPEN-ACTV-FIXED-FCTR-CUR  THRU 7200-EXIT.       
P00680     PERFORM 7210-FETCH-ACTV-FIXED-FCTR-CUR THRU 7210-EXIT.       
P00680     PERFORM 2100-GET-ACTV-OPTION-DSCNT     THRU 2100-EXIT        
P00680             UNTIL NO-MORE-ROWS.                                  
P00680     PERFORM 7220-CLOSE-ACTV-FIXED-FCTR-CUR THRU 7220-EXIT.       
P00680                                                                  
P00680     COMPUTE RS-CUR-OPT-TOT-PRC-DSCNT EQUAL                       
P00680             RS-CUR-OPT-TOT-PRC-DSCNT * -1.                       
P00680     COMPUTE RS-CUR-OPT-TOT-CSC-DSCNT EQUAL                       
P00680             RS-CUR-OPT-TOT-CSC-DSCNT * -1.                       
P00680                                                                  
           PERFORM 4000-MAIL-NAME-ADDRESS       THRU 4000-EXIT.         
           MOVE WS-CUSTOMER-NAME             TO RS-CUSTOMER-NAME        
           MOVE WS-PREMISE-ADDR              TO RS-ADDRESS              
I02262     MOVE WS-PR-ADDR-ZIP-CODE          TO RS-PREM-ADDR-ZIP-CODE   
                                                                        
P805CS     PERFORM 2600-PROCESS-CSC-DISCOUNTS   THRU 2600-EXIT.         
                                                                        
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
            MOVE RS-OPT-REMAIN-MTHS         TO S-OPT-REMAIN-MTHS        
            MOVE RS-CSC-AMOUNT              TO S-CSC-AMOUNT             
            MOVE RS-EXIT-FEE-FLAG           TO S-EXIT-FEE-FLAG          
P00680      MOVE RS-RATE-CHANGE-EXIT-FEE    TO S-RATE-CHANGE-EXIT-FEE   
            MOVE RS-INIT-BILL-FL            TO S-INIT-BILL-FL           
            MOVE RS-THERM-PRICE             TO S-THERM-PRICE            
            MOVE RS-ACCT-TIER               TO S-ACCT-TIER.             
            MOVE RS-CUSTOMER-NAME           TO S-CUSTOMER-NAME          
            MOVE RS-ADDRESS                 TO S-ADDRESS                
            MOVE RS-TIER-CUST-STAT-CD       TO S-TIER-CUST-STAT-CD      
            MOVE RS-TIER-ACCT-TYPE-CD       TO S-TIER-ACCT-TYPE-CD      
            MOVE RS-MKT-TIER-START-DT       TO S-MKT-TIER-START-DT.     
            MOVE RS-OPT-DESC-INT-LONG       TO S-OPT-DESC-INT-LONG.     
I00484      MOVE RS-PEND-OPTION-FLAG        TO S-PEND-OPTION-FLAG.      
I00484      MOVE RS-PEND-THERM-PRICE        TO S-PEND-THERM-PRICE.      
I00484      MOVE RS-PEND-OPTION-CD          TO S-PEND-OPTION-CD.        
I00484      MOVE RS-PEND-OPTION-DESC        TO S-PEND-OPTION-DESC.      
P00269      MOVE RS-SUPER-USER-FLAG         TO S-SUPER-USER-FLAG.       
                                                                        
P00453      MOVE RS-PRP-FL                  TO S-PRP-FL.                
P00680      MOVE RS-RTPK-STAT-ADJ-FL        TO S-RTPK-STAT-ADJ-FL.      
P00680      MOVE RS-OFFER-CD                TO S-OFFER-CD.              
P00680      MOVE RS-SWITCH-AWAY-EXIT-FEE    TO S-SWITCH-AWAY-EXIT-FEE.  
P00680      MOVE RS-CUR-OPT-THRM-PRC-DSCNT-FL                           
P00680           TO S-CUR-OPT-THRM-PRC-DSCNT-FL.                        
P00680      MOVE RS-CUR-OPT-CSC-DSCNT-FL    TO S-CUR-OPT-CSC-DSCNT-FL.  
P00680      MOVE RS-CUR-OPT-DSCNTD-PRC      TO S-CUR-OPT-DSCNTD-PRC.    
P00680      MOVE RS-CUR-OPT-DSCNTD-CSC      TO S-CUR-OPT-DSCNTD-CSC.    
P00680      MOVE RS-CUR-OPT-TOT-PRC-DSCNT   TO S-CUR-OPT-TOT-PRC-DSCNT. 
P00680      MOVE RS-CUR-OPT-TOT-CSC-DSCNT   TO S-CUR-OPT-TOT-CSC-DSCNT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-A-TXT   TO S-CUR-OPT-PRC-DSC-A-TXT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-A-DUR   TO S-CUR-OPT-PRC-DSC-A-DUR. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-A-AMT   TO S-CUR-OPT-PRC-DSC-A-AMT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-B-TXT   TO S-CUR-OPT-PRC-DSC-B-TXT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-B-DUR   TO S-CUR-OPT-PRC-DSC-B-DUR. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-B-AMT   TO S-CUR-OPT-PRC-DSC-B-AMT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-C-TXT   TO S-CUR-OPT-PRC-DSC-C-TXT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-C-DUR   TO S-CUR-OPT-PRC-DSC-C-DUR. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-C-AMT   TO S-CUR-OPT-PRC-DSC-C-AMT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-D-TXT   TO S-CUR-OPT-PRC-DSC-D-TXT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-D-DUR   TO S-CUR-OPT-PRC-DSC-D-DUR. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-D-AMT   TO S-CUR-OPT-PRC-DSC-D-AMT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-E-TXT   TO S-CUR-OPT-PRC-DSC-E-TXT. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-E-DUR   TO S-CUR-OPT-PRC-DSC-E-DUR. 
P00680      MOVE RS-CUR-OPT-PRC-DSC-E-AMT   TO S-CUR-OPT-PRC-DSC-E-AMT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-A-TXT   TO S-CUR-OPT-CSC-DSC-A-TXT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-A-DUR   TO S-CUR-OPT-CSC-DSC-A-DUR. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-A-AMT   TO S-CUR-OPT-CSC-DSC-A-AMT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-B-TXT   TO S-CUR-OPT-CSC-DSC-B-TXT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-B-DUR   TO S-CUR-OPT-CSC-DSC-B-DUR. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-B-AMT   TO S-CUR-OPT-CSC-DSC-B-AMT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-C-TXT   TO S-CUR-OPT-CSC-DSC-C-TXT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-C-DUR   TO S-CUR-OPT-CSC-DSC-C-DUR. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-C-AMT   TO S-CUR-OPT-CSC-DSC-C-AMT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-D-TXT   TO S-CUR-OPT-CSC-DSC-D-TXT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-D-DUR   TO S-CUR-OPT-CSC-DSC-D-DUR. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-D-AMT   TO S-CUR-OPT-CSC-DSC-D-AMT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-E-TXT   TO S-CUR-OPT-CSC-DSC-E-TXT. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-E-DUR   TO S-CUR-OPT-CSC-DSC-E-DUR. 
P00680      MOVE RS-CUR-OPT-CSC-DSC-E-AMT   TO S-CUR-OPT-CSC-DSC-E-AMT. 
P00680      MOVE RS-PNDG-OPT-THRM-PRC-DSCNT-FL                          
P00680           TO S-PNDG-OPT-THRM-PRC-DSCNT-FL.                       
P00680      MOVE RS-PNDG-OPT-CSC-DSCNT-FL   TO S-PNDG-OPT-CSC-DSCNT-FL. 
P00680      MOVE RS-PNDG-OPT-DSCNTD-PRC     TO S-PNDG-OPT-DSCNTD-PRC.   
P00680      MOVE RS-PNDG-OPT-DSCNTD-CSC     TO S-PNDG-OPT-DSCNTD-CSC.   
P00680      MOVE RS-PNDG-OPT-TOT-PRC-DSCNT  TO S-PNDG-OPT-TOT-PRC-DSCNT.
P00680      MOVE RS-PNDG-OPT-TOT-CSC-DSCNT  TO S-PNDG-OPT-TOT-CSC-DSCNT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-A-TXT  TO S-PNDG-OPT-PRC-DSC-A-TXT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-A-DUR  TO S-PNDG-OPT-PRC-DSC-A-DUR.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-A-AMT  TO S-PNDG-OPT-PRC-DSC-A-AMT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-B-TXT  TO S-PNDG-OPT-PRC-DSC-B-TXT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-B-DUR  TO S-PNDG-OPT-PRC-DSC-B-DUR.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-B-AMT  TO S-PNDG-OPT-PRC-DSC-B-AMT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-C-TXT  TO S-PNDG-OPT-PRC-DSC-C-TXT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-C-DUR  TO S-PNDG-OPT-PRC-DSC-C-DUR.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-C-AMT  TO S-PNDG-OPT-PRC-DSC-C-AMT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-D-TXT  TO S-PNDG-OPT-PRC-DSC-D-TXT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-D-DUR  TO S-PNDG-OPT-PRC-DSC-D-DUR.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-D-AMT  TO S-PNDG-OPT-PRC-DSC-D-AMT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-E-TXT  TO S-PNDG-OPT-PRC-DSC-E-TXT.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-E-DUR  TO S-PNDG-OPT-PRC-DSC-E-DUR.
P00680      MOVE RS-PNDG-OPT-PRC-DSC-E-AMT  TO S-PNDG-OPT-PRC-DSC-E-AMT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-A-TXT  TO S-PNDG-OPT-CSC-DSC-A-TXT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-A-DUR  TO S-PNDG-OPT-CSC-DSC-A-DUR.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-A-AMT  TO S-PNDG-OPT-CSC-DSC-A-AMT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-B-TXT  TO S-PNDG-OPT-CSC-DSC-B-TXT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-B-DUR  TO S-PNDG-OPT-CSC-DSC-B-DUR.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-B-AMT  TO S-PNDG-OPT-CSC-DSC-B-AMT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-C-TXT  TO S-PNDG-OPT-CSC-DSC-C-TXT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-C-DUR  TO S-PNDG-OPT-CSC-DSC-C-DUR.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-C-AMT  TO S-PNDG-OPT-CSC-DSC-C-AMT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-D-TXT  TO S-PNDG-OPT-CSC-DSC-D-TXT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-D-DUR  TO S-PNDG-OPT-CSC-DSC-D-DUR.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-D-AMT  TO S-PNDG-OPT-CSC-DSC-D-AMT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-E-TXT  TO S-PNDG-OPT-CSC-DSC-E-TXT.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-E-DUR  TO S-PNDG-OPT-CSC-DSC-E-DUR.
P00680      MOVE RS-PNDG-OPT-CSC-DSC-E-AMT  TO S-PNDG-OPT-CSC-DSC-E-AMT.
P680PN      MOVE RS-CUR-OPT-PRCE-NEG-CD     TO S-CUR-OPT-PRCE-NEG-CD.   
P680PN      MOVE RS-PNDG-OPT-PRCE-NEG-CD    TO S-PNDG-OPT-PRCE-NEG-CD.  
P00805      MOVE RS-CURR-OPT-VALID-MNTHS    TO S-CURR-OPT-VALID-MNTHS.  
P00805      MOVE RS-CURR-OPT-CORE-RATE      TO S-CURR-OPT-CORE-RATE.    
P00805      MOVE RS-CURR-OPT-ROR-END-DT     TO S-CURR-OPT-ROR-END-DT.   
P00805      MOVE RS-IS-CURR-RATE-SENIOR     TO S-IS-CURR-RATE-SENIOR.   
P00805      MOVE RS-PEND-OPT-VALID-MNTHS    TO S-PEND-OPT-VALID-MNTHS.  
P00805      MOVE RS-PEND-OPT-CORE-RATE      TO S-PEND-OPT-CORE-RATE.    
P00805      MOVE RS-PEND-OPT-ROR-END-DT     TO S-PEND-OPT-ROR-END-DT.   
P00805      MOVE RS-IS-PEND-RATE-SENIOR     TO S-IS-PEND-RATE-SENIOR.   
P00805      MOVE RS-PEND-OPT-EXIT-FEE       TO S-PEND-OPT-EXIT-FEE.     
P00892      MOVE RS-PEND-AUTO-REN-OPT-IN-FL TO S-PEND-AUTO-REN-OPT-IN-FL
P00892      MOVE RS-CURR-AUTO-REN-OPT-IN-FL TO S-CURR-AUTO-REN-OPT-IN-FL
P00892      MOVE RS-SEASONAL-FL             TO S-SEASONAL-FL            
P00892      MOVE RS-CURR-DISP-AUTO-REN-FL   TO S-CURR-DISP-AUTO-REN-FL  
P00892      MOVE RS-PEND-DISP-AUTO-REN-FL   TO S-PEND-DISP-AUTO-REN-FL  
OTPOOL      MOVE RS-LOCAL-OFFICE            TO S-LOCAL-OFFICE           
P805CS      MOVE RS-PAPERLESS-DSC-FL        TO S-PAPERLESS-DSC-FL       
P805CS      MOVE RS-PAPERLESS-DSC-AMT       TO S-PAPERLESS-DSC-AMT      
P805CS      MOVE RS-AUTORENEW-DSC-FL        TO S-AUTORENEW-DSC-FL       
P805CS      MOVE RS-AUTORENEW-DSC-AMT       TO S-AUTORENEW-DSC-AMT      
I02262      MOVE RS-AGL-PREM-NO             TO S-AGL-PREM-NO            
I02262      MOVE RS-CODE-ACCT-STAT          TO S-CODE-ACCT-STAT         
I02262      MOVE RS-PREM-ADDR-ZIP-CODE      TO S-PREM-ADDR-ZIP-CODE     
P00892      .                                                           
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
P00680******************************************************************        
P00680* 2100-GET-ACTV-OPTION-DSCNT.                                    *        
P00680******************************************************************        
P00680 2100-GET-ACTV-OPTION-DSCNT.                                      
P00680                                                                  
P00680     MOVE HQ-DURATION-NO             TO WS-DURATION-NO-HQ.        
P00680                                                                  
P00680     IF SF-FCTR-POWER-10 NOT EQUAL 0                              
P00680        COMPUTE FF-FACTOR = FF-FACTOR * 10** SF-FCTR-POWER-10     
P00680     END-IF                                                       
P00680                                                                  
P00680     EVALUATE HQ-RT-ATTR-INCTV-TYPE                               
P00680                                                                  
P00680         WHEN 'PRICE DISCOUNT'                                    
P00680           MOVE 'Y'                                               
P00680                TO RS-CUR-OPT-THRM-PRC-DSCNT-FL                   
P00680           COMPUTE RS-CUR-OPT-DSCNTD-PRC    EQUAL                 
P00680                   RS-CUR-OPT-DSCNTD-PRC    + FF-FACTOR           
P00680           COMPUTE RS-CUR-OPT-TOT-PRC-DSCNT EQUAL                 
P00680                   RS-CUR-OPT-TOT-PRC-DSCNT + FF-FACTOR           
P00680                                                                  
P00680           EVALUATE WS-PRC-DSCNT-CTR                              
P00680                                                                  
P00680               WHEN 1                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-PRC-DSC-A-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-PRC-DSC-A-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-PRC-DSC-A-AMT  
P00680                                                                  
P00680               WHEN 2                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-PRC-DSC-B-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-PRC-DSC-B-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-PRC-DSC-B-AMT  
P00680                                                                  
P00680               WHEN 3                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-PRC-DSC-C-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-PRC-DSC-C-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-PRC-DSC-C-AMT  
P00680                                                                  
P00680               WHEN 4                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-PRC-DSC-D-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-PRC-DSC-D-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-PRC-DSC-D-AMT  
P00680                                                                  
P00680               WHEN 5                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-PRC-DSC-E-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-PRC-DSC-E-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-PRC-DSC-E-AMT  
P00680                                                                  
P00680               WHEN OTHER                                         
P00680                 CONTINUE                                         
P00680                                                                  
P00680           END-EVALUATE                                           
P00680           ADD +1                    TO WS-PRC-DSCNT-CTR          
P00680                                                                  
P00680         WHEN 'CSC DISCOUNT'                                      
P00680           MOVE 'Y'                                               
P00680                TO RS-CUR-OPT-CSC-DSCNT-FL                        
P00680           COMPUTE RS-CUR-OPT-DSCNTD-CSC    EQUAL                 
P00680                   RS-CUR-OPT-DSCNTD-CSC    + FF-FACTOR           
P00680           COMPUTE RS-CUR-OPT-TOT-CSC-DSCNT EQUAL                 
P00680                   RS-CUR-OPT-TOT-CSC-DSCNT + FF-FACTOR           
P00680                                                                  
P00680           EVALUATE WS-CSC-DSCNT-CTR                              
P00680                                                                  
P00680               WHEN 1                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-CSC-DSC-A-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-CSC-DSC-A-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-CSC-DSC-A-AMT  
P00680                                                                  
P00680               WHEN 2                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-CSC-DSC-B-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-CSC-DSC-B-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-CSC-DSC-B-AMT  
P00680                                                                  
P00680               WHEN 3                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-CSC-DSC-C-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-CSC-DSC-C-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-CSC-DSC-C-AMT  
P00680                                                                  
P00680               WHEN 4                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-CSC-DSC-D-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-CSC-DSC-D-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-CSC-DSC-D-AMT  
P00680                                                                  
P00680               WHEN 5                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-CUR-OPT-CSC-DSC-E-TXT                  
P00680                 MOVE HQ-DURATION-NO TO RS-CUR-OPT-CSC-DSC-E-DUR  
P00680                 MOVE FF-FACTOR      TO RS-CUR-OPT-CSC-DSC-E-AMT  
P00680                                                                  
P00680               WHEN OTHER                                         
P00680                 CONTINUE                                         
P00680                                                                  
P00680           END-EVALUATE                                           
P00680           ADD +1                    TO WS-CSC-DSCNT-CTR          
P00680                                                                  
P00680         WHEN OTHER                                               
P00680           CONTINUE                                               
P00680                                                                  
P00680     END-EVALUATE.                                                
P00680                                                                  
P00680     PERFORM 7210-FETCH-ACTV-FIXED-FCTR-CUR THRU 7210-EXIT.       
P00680                                                                  
P00680 2100-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P00680******************************************************************        
P00680* 2200-GET-PNDG-OPTION-DSCNT.                                    *        
P00680******************************************************************        
P00680 2200-GET-PNDG-OPTION-DSCNT.                                      
P00680                                                                  
P00680     MOVE HQ-DURATION-NO           TO WS-DURATION-NO-HQ.          
P00680                                                                  
P00680     IF SF-FCTR-POWER-10 NOT EQUAL 0                              
P00680        COMPUTE FF-FACTOR = FF-FACTOR * 10** SF-FCTR-POWER-10     
P00680     END-IF                                                       
P00680                                                                  
P00680     EVALUATE HQ-RT-ATTR-INCTV-TYPE                               
P00680                                                                  
P00680         WHEN 'PRICE DISCOUNT'                                    
P00680           MOVE 'Y'                                               
P00680                TO RS-PNDG-OPT-THRM-PRC-DSCNT-FL                  
P00680           COMPUTE RS-PNDG-OPT-DSCNTD-PRC    EQUAL                
P00680                   RS-PNDG-OPT-DSCNTD-PRC    + FF-FACTOR          
P00680           COMPUTE RS-PNDG-OPT-TOT-PRC-DSCNT EQUAL                
P00680                   RS-PNDG-OPT-TOT-PRC-DSCNT + FF-FACTOR          
P00680                                                                  
P00680           EVALUATE WS-PRC-DSCNT-CTR                              
P00680                                                                  
P00680               WHEN 1                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-PRC-DSC-A-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-PRC-DSC-A-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-PRC-DSC-A-AMT 
P00680                                                                  
P00680               WHEN 2                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-PRC-DSC-B-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-PRC-DSC-B-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-PRC-DSC-B-AMT 
P00680                                                                  
P00680               WHEN 3                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-PRC-DSC-C-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-PRC-DSC-C-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-PRC-DSC-C-AMT 
P00680                                                                  
P00680               WHEN 4                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-PRC-DSC-D-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-PRC-DSC-D-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-PRC-DSC-D-AMT 
P00680                                                                  
P00680               WHEN 5                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-PRC-DSC-E-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-PRC-DSC-E-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-PRC-DSC-E-AMT 
P00680                                                                  
P00680               WHEN OTHER                                         
P00680                 CONTINUE                                         
P00680                                                                  
P00680           END-EVALUATE                                           
P00680           ADD +1                    TO WS-PRC-DSCNT-CTR          
P00680                                                                  
P00680         WHEN 'CSC DISCOUNT'                                      
P00680           MOVE 'Y'                                               
P00680                TO RS-PNDG-OPT-CSC-DSCNT-FL                       
P00680           COMPUTE RS-PNDG-OPT-DSCNTD-CSC    EQUAL                
P00680                   RS-PNDG-OPT-DSCNTD-CSC    + FF-FACTOR          
P00680           COMPUTE RS-PNDG-OPT-TOT-CSC-DSCNT EQUAL                
P00680                   RS-PNDG-OPT-TOT-CSC-DSCNT + FF-FACTOR          
P00680                                                                  
P00680           EVALUATE WS-CSC-DSCNT-CTR                              
P00680                                                                  
P00680               WHEN 1                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-CSC-DSC-A-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-CSC-DSC-A-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-CSC-DSC-A-AMT 
P00680                                                                  
P00680               WHEN 2                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-CSC-DSC-B-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-CSC-DSC-B-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-CSC-DSC-B-AMT 
P00680                                                                  
P00680               WHEN 3                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-CSC-DSC-C-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-CSC-DSC-C-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-CSC-DSC-C-AMT 
P00680                                                                  
P00680               WHEN 4                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-CSC-DSC-D-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-CSC-DSC-D-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-CSC-DSC-D-AMT 
P00680                                                                  
P00680               WHEN 5                                             
P00680                 STRING SF-FACTOR-TEXT (1:WS-FACTOR-TEXT-LEN)     
P00680                                                DELIMITED BY SIZE 
P00680                        WS-FOR-LIT-DESC         DELIMITED BY SIZE 
P00680                        ' '                     DELIMITED BY SIZE 
P00680                        WS-DURATION-NO-HQ       DELIMITED BY SIZE 
P00680                        WS-MONTHS-LIT-DESC      DELIMITED BY SIZE 
P00680                   INTO RS-PNDG-OPT-CSC-DSC-E-TXT                 
P00680                 MOVE HQ-DURATION-NO TO RS-PNDG-OPT-CSC-DSC-E-DUR 
P00680                 MOVE FF-FACTOR      TO RS-PNDG-OPT-CSC-DSC-E-AMT 
P00680                                                                  
P00680               WHEN OTHER                                         
P00680                 CONTINUE                                         
P00680                                                                  
P00680           END-EVALUATE                                           
P00680           ADD +1                    TO WS-CSC-DSCNT-CTR          
P00680                                                                  
P00680         WHEN OTHER                                               
P00680           CONTINUE                                               
P00680                                                                  
P00680     END-EVALUATE.                                                
P00680                                                                  
P00680     PERFORM 7240-FETCH-PNDG-FIXED-FCTR-CUR THRU 7240-EXIT.       
P00680                                                                  
P00680 2200-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P805CS*****************************************************************         
P805CS*** VALIDATE CSC DISOCUNT ELIGIBILITY                         ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 2600-PROCESS-CSC-DISCOUNTS.                                      
P805CS*                                                                         
P805CS     MOVE WS-ACCOUNT-NO                TO WS-444-I-ACCT-NO.       
P805CS     MOVE PROGRAM-NAME                 TO WS-444-I-PGM-ID.        
P805CS     MOVE SPACES                       TO WS-444-I-USER-ID.       
P805CS*                                                                         
P805CS     PERFORM 6000-CPD444-CSC-DISCOUNT-ELIG                        
P805CS        THRU 6000-CPD444-EXIT.                                    
P805CS*                                                                         
P805CS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P805CS         WHEN 0                                                   
P805CS            PERFORM VARYING WS-444-S FROM 1 BY 1                  
P805CS              UNTIL WS-444-S > 10                                 
P805CS                 OR WS-444-O-DISC-CD(WS-444-S) = SPACES           
P805CS               EVALUATE WS-444-O-DISC-CD(WS-444-S)                
P805CS                   WHEN 'PAPERLESS'                               
P805CS                     IF WS-444-O-ELIG-FL(WS-444-S) = 'Y'          
P805CS                        MOVE WS-444-O-ELIG-FL(WS-444-S)           
P805CS                             TO RS-PAPERLESS-DSC-FL               
P805CS                        MOVE WS-444-O-FACTOR (WS-444-S)           
P805CS                             TO RS-PAPERLESS-DSC-AMT              
P805CS                     END-IF                                       
P805CS                   WHEN 'AUTORENEW'                               
P805CS                     IF WS-444-O-ELIG-FL(WS-444-S) = 'Y'          
P805CS                        MOVE WS-444-O-ELIG-FL(WS-444-S)           
P805CS                             TO RS-AUTORENEW-DSC-FL               
P805CS                        MOVE WS-444-O-FACTOR (WS-444-S)           
P805CS                             TO RS-AUTORENEW-DSC-AMT              
P805CS                     END-IF                                       
P805CS               END-EVALUATE                                       
P805CS            END-PERFORM                                           
P805CS         WHEN 999                                                 
P805CS            CONTINUE                                              
P805CS         WHEN OTHER                                               
P805CS            PERFORM 6999-CPD444-ERROR-ROUTINE                     
P805CS               THRU 6999-CPD444-EXIT                              
P805CS     END-EVALUATE.                                                
P805CS*                                                                         
P805CS 2600-EXIT.                                                       
P805CS     EXIT.                                                        
P805CS*                                                                         
      *****************************************************************         
      *                                                               *         
      * 5050-GET-ACCT-REL-DET.                                        *         
      *****************************************************************         
       5050-GET-ACCT-REL-DET.                                           
                                                                        
P00805     MOVE 3DAY-ROR-DAYS                TO C8-DELINQ-CD.           
P00805     MOVE '01'                         TO C8-COMPANY-NO.          
P00805     PERFORM 7060-SELECT-DELINQNCY        THRU 7060-EXIT.         
P00805     MOVE C8-DELINQ-VALUE              TO WS-3DAY-ROR-DAYS.       
                                                                        
P00892     MOVE 90-DAY-GRACE-PERIOD          TO C8-DELINQ-CD.           
P00892     MOVE '01'                         TO C8-COMPANY-NO.          
P00892     PERFORM 7060-SELECT-DELINQNCY        THRU 7060-EXIT.         
P00892     MOVE C8-DELINQ-VALUE              TO WS-90DAY-GRACE-PERIOD.  
                                                                        
           MOVE 'Y'                          TO WS-THERM-CSC-ACCT-FL.   
I00484     MOVE 'Y'                          TO                         
I00484                                      WS-PENDING-OPTION-FL-063.   
I00484     MOVE 'N'                          TO RS-PEND-OPTION-FLAG.    
I00484     MOVE WS-ACCOUNT-NO                TO DF-ACCOUNT-NO           
I00484     MOVE WS-CODE-UTIL-TYPE            TO DF-CODE-UTIL-TYPE       
I00484     MOVE WS-IC-NO                     TO DF-IC-NO                
I00484     PERFORM 7005-OPT-AGR-EFF-DT          THRU 7005-EXIT.         
P00805     PERFORM 7075-ADD-DAYS                THRU 7075-EXIT.         
P00805     MOVE WS-RESULT-DATE               TO RS-CURR-OPT-ROR-END-DT. 
P00892****   I - OPTED-IN FOR AUTO RENEWAL, FAR - AUTORENEWED                   
P00892     IF DF-AUTO-REN-OPT-IN-FL = 'I' AND                           
P00892       DF-AGREEMNT-SOURCE-CD  = 'FAR'                             
P00892        PERFORM 7076-ADD-DAYS-GRACE-PERIOD THRU 7076-EXIT         
P00892        MOVE WS-RESULT-DATE            TO RS-CURR-OPT-ROR-END-DT  
P00892     END-IF                                                       
                                                                        
P805AP     IF AT-REV-MTH-LST-NRML = 0                                   
P805AP        PERFORM 5060-GET-NEWBILL-ROR-DATE THRU 5060-EXIT          
P805AP        MOVE WS-RESULT-DATE            TO RS-CURR-OPT-ROR-END-DT  
P805AP     END-IF                                                       
                                                                        
P00680     MOVE DF-OFFER-CD                  TO RS-OFFER-CD.            
P680PN     MOVE DF-PRCE-NEGOTIATED-CD        TO RS-CUR-OPT-PRCE-NEG-CD  
P00892     MOVE DF-AUTO-REN-OPT-IN-FL TO RS-CURR-AUTO-REN-OPT-IN-FL     
P00892     IF WS-ACCT-SUB-TYPE = ( CON-RES-CUST OR ACN-RES-CUST OR      
P00892                             RES-BUS-OWNER-CUST OR DEREG-RES-CUST 
P00892                             OR SMALL-COM-CUST)                   
P00892       AND FI-OPT-CALC-TYPE-CD = 'FP'                             
P00892           MOVE SPACE TO RS-CURR-DISP-AUTO-REN-FL                 
P00892     ELSE                                                         
P00892           MOVE 'X'   TO RS-CURR-DISP-AUTO-REN-FL                 
P00892     END-IF                                                       
P00892                                                                  
P00892     PERFORM 7077-SEL-SEASONAL-FL         THRU 7077-EXIT          
P00892     MOVE TA-SEASONAL-FL               TO RS-SEASONAL-FL          
                                                                        
           PERFORM 6000-CALL-MCSCB063           THRU 6000-EXIT          
                                                                        
           IF AT-REV-MTH-LST-NRML EQUAL ZEROES                          
              MOVE 'Y'                       TO RS-INIT-BILL-FL         
           ELSE                                                         
              MOVE 'N'                       TO RS-INIT-BILL-FL         
           END-IF                                                       
                                                                        
P00680***** GET EXIT FEE, RATE CHNG EXIT FEE & RTPK STAT ADJ FL                 
P00680     MOVE WS-ACCOUNT-NO                TO WS-ACCT-NO-4114.        
P00680     MOVE WS-EXIT-FEE-FCTR             TO WS-INCTV-TYPE-4114.     
P00680     INITIALIZE                           WS-RTPK-AGR-STAT-4114   
P00680                                          WS-INPUT-DATE-4114      
P00680                                          WS-REV-MTH-4114.        
P00680                                                                  
P00680     PERFORM 6000-GET-PRO-INCTV-CPD4114   THRU                    
P00680             6000-CPD4114-EXIT.                                   
P00680                                                                  
P00680     IF NO-ERRORS-4114                                            
P00680        IF WS-FF-DURATION-REM > 0                                 
P00680           MOVE 'Y'                    TO RS-EXIT-FEE-FLAG        
P00680           MOVE WS-RATE-CHNG-EXIT-FEE-4114                        
P00680                                       TO RS-RATE-CHANGE-EXIT-FEE 
P00680        ELSE                                                      
P00680           MOVE 'N'                    TO RS-EXIT-FEE-FLAG        
P00680           MOVE 0                      TO RS-RATE-CHANGE-EXIT-FEE 
P00680        END-IF                                                    
P00680        MOVE WS-RTPK-STAT-ADJ-FL-4114  TO RS-RTPK-STAT-ADJ-FL     
P00680        MOVE WS-EXIT-FEE-4114          TO RS-SWITCH-AWAY-EXIT-FEE 
P00680     ELSE                                                         
P00680        MOVE 'N'                       TO RS-EXIT-FEE-FLAG        
P00680                                          RS-RTPK-STAT-ADJ-FL     
P00680        MOVE 0                         TO RS-RATE-CHANGE-EXIT-FEE 
P00680                                          RS-SWITCH-AWAY-EXIT-FEE 
P00680     END-IF.                                                      
                                                                        
A01339     INITIALIZE          FI-OPT-DESC-INT-LONG                     
A01339                         RS-OPT-DESC-INT-LONG                     
I00484     MOVE WS-OPTION-CD                 TO FI-OPTION-CD.           
           PERFORM 7030-SEL-OPT-DESC            THRU 7030-EXIT.         
A01339     MOVE FI-OPT-DESC-INT-LONG-TEXT                               
A01339               (1:FI-OPT-DESC-INT-LONG-LEN)                       
A01339                                       TO RS-OPT-DESC-INT-LONG.   
A04019     MOVE WS-CSC-AMT                   TO WS-CSC-AMT-DESC.        
A04019     STRING RS-OPT-DESC-INT-LONG DELIMITED BY '   '               
A04019            ' with '                                              
A04019            WS-CSC-AMT-DESC DELIMITED BY SIZE                     
A04019            WS-CSC-LIT-DESC DELIMITED BY SIZE                     
A04019     INTO RS-OPT-DESC-INT-LONG.                                   
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
P805AP 5060-GET-NEWBILL-ROR-DATE.                                       
P805AP*                                                                         
P805AP     INITIALIZE                           KO-COMMUNICATION-ID     
P805AP                                          YP-ATTRIBUTE-VALUE-DT   
P805AP                                          WS-RESULT-DATE.         
P805AP*                                                                         
P805AP     MOVE WS-ACCOUNT-NO                TO KO-ACCOUNT-NO           
P805AP                                          YP-ACCOUNT-NO.          
P805AP*                                                                         
P805AP*    GET LATEST RATE CHANGE LETTER SENT DATE                              
P805AP     MOVE '45'                         TO KO-COMM-TYPE-CD.        
P805AP     MOVE '10'                         TO KO-COMM-SUBTYPE-CODE.   
P805AP     PERFORM 7350-GET-LATEST-LETTER-DATE THRU 7350-EXIT.          
P805AP     IF KO-COMMUNICATION-ID > '1900-01-01-00.00.00.000000'        
P805AP        MOVE KO-COMMUNICATION-ID(1:10) TO WS-COMMUNICATION-DT     
P805AP        PERFORM 7300-ADD-ROR-DAYS    THRU 7300-EXIT               
P805AP     ELSE                                                         
P805AP*    GET LATEST WELCOME KIT LETTER SENT DATE                              
P805AP        MOVE '22'                      TO KO-COMM-TYPE-CD         
P805AP        MOVE '10'                      TO KO-COMM-SUBTYPE-CODE    
P805AP        INITIALIZE                        KO-COMMUNICATION-ID     
P805AP        PERFORM 7350-GET-LATEST-LETTER-DATE THRU 7350-EXIT        
P805AP        IF KO-COMMUNICATION-ID > '1900-01-01-00.00.00.000000'     
P805AP           MOVE KO-COMMUNICATION-ID(1:10) TO WS-COMMUNICATION-DT  
P805AP           PERFORM 7300-ADD-ROR-DAYS    THRU 7300-EXIT            
P805AP        ELSE                                                      
P805AP           PERFORM 7400-GET-ACCT-MKT-TIER-DATA THRU 7400-EXIT     
P805AP           IF DD-TIER-ACCT-TYPE-CD = 'S'                          
P805AP              PERFORM 7450-GET-ADV-PRICE-ATTR-DT THRU 7450-EXIT   
P805AP              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
P805AP                 MOVE YP-ATTRIBUTE-VALUE-DT TO WS-COMMUNICATION-DT
P805AP                 PERFORM 7300-ADD-ROR-DAYS THRU 7300-EXIT         
P805AP              ELSE                                                
P805AP                 MOVE '2999-12-31'     TO WS-RESULT-DATE          
P805AP              END-IF                                              
P805AP           ELSE                                                   
P805AP              MOVE '2999-12-31'        TO WS-RESULT-DATE          
P805AP           END-IF                                                 
P805AP        END-IF                                                    
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 5060-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
I00113*****************************************************************         
I00113*                                                               *         
I00113* 5100-CHK-CUST-QUALIFY-SS.                                     *         
I00113*****************************************************************         
I00113 5100-CHK-CUST-QUALIFY-SS.                                        
I00113                                                                  
I00113     MOVE 'N'                          TO WS-DHR-CUSTOMER.        
P00172     MOVE AT-CUSTOMER-NO               TO CU-CUSTOMER-NO.         
I00113     PERFORM 7090-SEL-DHR-HIST            THRU 7090-EXIT.         
P00677     IF (WS-ACCT-SUB-TYPE EQUAL REG-GRP1-CUST OR REG-GRP2-CUST)   
P00677                                             AND DHR-CUSTOMER     
I00113        MOVE AT-CUSTOMER-NO            TO CE-CUSTOMER-NO          
I00113        MOVE 'C'                       TO CE-CUSTOMER-TYPE        
I00113        MOVE SPACES                    TO CE-DOB-VERIFIED-CD      
I00113                                          CE-DATE-OF-BIRTH        
I00113        PERFORM 7080-SELECT-CUST-STATS    THRU 7080-EXIT          
I00113        IF CE-DOB-VERIFIED-CD NOT EQUAL SPACES                    
I00113                      AND CE-DATE-OF-BIRTH NOT EQUAL SPACES       
I00113           MOVE WS-CURRENT-DATE        TO WS-DUMMY-DATE-ST        
I00113           MOVE CE-DATE-OF-BIRTH       TO WS-DUMMY-DATE-END       
I00113           MOVE SCANA-SR-AGE           TO C8-DELINQ-CD            
I00113           MOVE '01'                   TO C8-COMPANY-NO           
I00113           PERFORM 7060-SELECT-DELINQNCY  THRU 7060-EXIT          
I00113           PERFORM 7070-GET-YEAR-BETWEEN  THRU 7070-EXIT          
I00113           IF WS-RESULT-YEAR >= C8-DELINQ-VALUE                   
I00113              MOVE WS-ACCT-SUB-TYPE     TO IG-TIER-ACCT-TYPE-CD   
I00113                                           RS-TIER-ACCT-TYPE-CD   
P00677              IF DD-MKT-TIER-RANKING > 0                          
P00677                 MOVE DD-TIER-CUST-STAT-CD TO IG-TIER-CUST-STAT-CD
P00677                 MOVE DD-MKT-TIER-RANKING  TO IG-MKT-TIER-RANKING 
P00677              ELSE                                                
P00677                 MOVE 'E'               TO IG-TIER-CUST-STAT-CD   
P00677                 MOVE 'Y'               TO IG-CUST-ACCT-DEFLT-FL  
P00677                 PERFORM 7040-SELECT-DEFLT-RANKIG THRU 7040-EXIT  
P00677              END-IF                                              
P00677              PERFORM 7035-SELECT-SENIOR-RANKING THRU 7035-EXIT   
P00677              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
P00677                 IF IG-TIER-ACCT-TYPE-CD = REG-GRP1-CUST          
P00677                    SET GRP1-SR-ELIGIBLE TO TRUE                  
P00677                 ELSE                                             
P00677                    SET GRP2-SR-ELIGIBLE TO TRUE                  
P00677                 END-IF                                           
P00677                 MOVE 1B-ADJ-TIER-RANKING  TO RS-ACCT-TIER        
P00677                 MOVE 1B-ADJ-TIER-START-DT TO RS-MKT-TIER-START-DT
P00677                 MOVE 1B-TIER-CUST-STAT-CD TO RS-TIER-CUST-STAT-CD
P00677              END-IF                                              
I00113           END-IF                                                 
I00113        END-IF                                                    
I00113     END-IF.                                                      
I00113                                                                  
I00113 5100-EXIT.                                                       
I00113     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-CALL-MCSCB063.                                           *         
      *****************************************************************         
       6000-CALL-MCSCB063.                                              
                                                                        
           CALL MCSCB063 USING CWS00063-FIELDS,                         
                              ,ABEND-FILE,                              
                              ,WS-MCSCB063-RET-CODE.                    
                                                                        
           MOVE WS-MCSCB063-RET-CODE         TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-MCSCB063-RET-CODE EQUAL ZEROES                         
I00484        IF WS-FF-DURATION-REM EQUAL ZEROES                        
I00484                         AND WS-RATE-CALC-TYPE-CD EQUAL '02'      
I00484           MOVE DF-OPTION-CD           TO HQ-OPTION-CD            
I00484           MOVE DF-RT-PKG-OPT-SEQ-NO   TO FF-RT-PKG-OPT-SEQ-NO    
I00484           PERFORM 7100-SEL-THERM-PRICE   THRU 7100-EXIT          
I00484           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
I00484              MOVE FF-FACTOR              TO RS-THERM-PRICE       
A03303              MOVE FF-FACTOR-ID     TO SF-FACTOR-ID               
A03303              MOVE 0                TO SF-FCTR-POWER-10           
A03303              PERFORM 7120-SELECT-FCTR-POWER THRU 7120-EXIT       
A03303              IF SF-FCTR-POWER-10  NOT EQUAL 0                    
A03303                 COMPUTE WS-FACTOR-FF = FF-FACTOR *               
A03303                                   10** SF-FCTR-POWER-10          
A03303                 MOVE WS-FACTOR-FF  TO RS-THERM-PRICE             
A03303              END-IF                                              
I00484           END-IF                                                 
I00484        ELSE                                                      
                 MOVE WS-THERM-PRICE         TO RS-THERM-PRICE          
I00484        END-IF                                                    
              MOVE WS-FF-DURATION-REM        TO RS-OPT-REMAIN-MTHS      
              MOVE WS-CSC-AMT                TO RS-CSC-AMOUNT           
P00805        MOVE WS-OPTN-VALID-MNTHS       TO RS-CURR-OPT-VALID-MNTHS 
P00805        MOVE WS-CORE-RATE-PLAN-NO      TO RS-CURR-OPT-CORE-RATE   
P00805                                          RD-RATE-PLAN-NO         
P00805        PERFORM 7125-SELECT-RATE-PLAN     THRU 7125-EXIT          
P00805        IF RD-SENIOR-RATE-FL EQUAL 'Y' OR 'S'                     
P00805           MOVE WS-YES                 TO RS-IS-CURR-RATE-SENIOR  
P00805        END-IF                                                    
I00484        IF WS-PENDING-OPTION-FL-063 = 'Y'                         
I00484           MOVE WS-PEND063-THERM-PRICE TO RS-PEND-THERM-PRICE     
P00805           MOVE WS-PEND063-VALID-MNTHS TO RS-PEND-OPT-VALID-MNTHS 
P00805           MOVE WS-PEND063-CORE-RATE-PLAN                         
P00805                                       TO RS-PEND-OPT-CORE-RATE   
P00805                                          RD-RATE-PLAN-NO         
P00805           IF RD-RATE-PLAN-NO NOT EQUAL SPACES AND LOW-VALUES     
P00805              PERFORM 7125-SELECT-RATE-PLAN                       
P00805                                          THRU 7125-EXIT          
P00805              IF RD-SENIOR-RATE-FL EQUAL 'Y' OR 'S'               
P00805                 MOVE WS-YES           TO RS-IS-PEND-RATE-SENIOR  
P00805              END-IF                                              
P00805           END-IF                                                 
I00484           INITIALIZE             FI-OPT-DESC-INT-LONG            
I00484                                  RS-PEND-OPTION-DESC             
I00484           MOVE WS-PENDING-OPTION      TO DF-STATUS-CD            
I00484                                                                  
I00484           PERFORM 7002-SEL-PEND-OPTION   THRU 7002-EXIT          
I00484           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
I00484              MOVE 'Y'                 TO RS-PEND-OPTION-FLAG     
I00484              MOVE FI-OPTION-CD        TO RS-PEND-OPTION-CD       
I00484              MOVE FI-OPT-DESC-INT-LONG-TEXT                      
I00484                        (1:FI-OPT-DESC-INT-LONG-LEN)              
I00484                                       TO RS-PEND-OPTION-DESC     
A04019              MOVE WS-PEND063-CSC-AMT  TO WS-CSC-AMT-DESC         
A04019              STRING RS-PEND-OPTION-DESC DELIMITED BY '   '       
A04019                     ' with '                                     
A04019                     WS-CSC-AMT-DESC DELIMITED BY SIZE            
A04019                     WS-CSC-LIT-DESC DELIMITED BY SIZE            
A04019              INTO RS-PEND-OPTION-DESC                            
P680PN              MOVE DF-PRCE-NEGOTIATED-CD                          
P680PN                                    TO RS-PNDG-OPT-PRCE-NEG-CD    
P00892              MOVE DF-AUTO-REN-OPT-IN-FL                          
P00892                                    TO RS-PEND-AUTO-REN-OPT-IN-FL 
P00892              IF WS-ACCT-SUB-TYPE =                               
P00892                           ( CON-RES-CUST OR ACN-RES-CUST OR      
P00892                             RES-BUS-OWNER-CUST OR DEREG-RES-CUST 
P00892                             OR SMALL-COM-CUST)                   
P00892                AND FI-OPT-CALC-TYPE-CD = 'FP'                    
P00892                     MOVE SPACE TO RS-PEND-DISP-AUTO-REN-FL       
P00892              ELSE                                                
P00892                     MOVE 'X'   TO RS-PEND-DISP-AUTO-REN-FL       
P00892              END-IF                                              
P00805              MOVE SPACES              TO WS-RESULT-DATE          
P00805              PERFORM 7075-ADD-DAYS       THRU 7075-EXIT          
P00805              MOVE WS-RESULT-DATE      TO RS-PEND-OPT-ROR-END-DT  
P00892***********     I - OPTED-IN FOR AUTO RENEWAL, FAR - AUTORENEWED          
P00892              IF DF-AUTO-REN-OPT-IN-FL = 'I' AND                  
P00892                DF-AGREEMNT-SOURCE-CD  = 'FAR'                    
P00892                 PERFORM 7076-ADD-DAYS-GRACE-PERIOD THRU 7076-EXIT
P00892                 MOVE WS-RESULT-DATE  TO RS-PEND-OPT-ROR-END-DT   
P00892              END-IF                                              
P00805              MOVE FI-OPTION-CD        TO HQ-OPTION-CD            
P00805              IF WS-PEND063-CALC-TYPE-CD EQUAL '02'               
P00805                 MOVE WS-EXIT-FEE-FCTR TO HQ-FACTOR-ID            
P00805                 PERFORM 7010-SEL-EXIT-FEE THRU 7010-EXIT         
P00805                 MOVE HQ-ATTR-INCTV-VALUE TO RS-PEND-OPT-EXIT-FEE 
P00805              END-IF                                              
I00484           END-IF                                                 
P00680**** GET THERM PRICE AND CSC DISCOUNTS FOR PENDING OPTION CODE            
P00680           MOVE 'N'                    TO WS-NO-MORE-ROWS         
P00680           MOVE +1                     TO WS-PRC-DSCNT-CTR        
P00680                                          WS-CSC-DSCNT-CTR        
P00680           MOVE RS-PEND-THERM-PRICE    TO RS-PNDG-OPT-DSCNTD-PRC  
P00680           MOVE WS-PEND063-CSC-AMT     TO RS-PNDG-OPT-DSCNTD-CSC  
P00680           MOVE ZEROS                                             
P00680                TO RS-PNDG-OPT-TOT-PRC-DSCNT                      
P00680                   RS-PNDG-OPT-TOT-CSC-DSCNT                      
P00680                                                                  
P00680           PERFORM 7230-OPEN-PNDG-FIXED-FCTR-CUR                  
P00680                                          THRU 7230-EXIT          
P00680           PERFORM 7240-FETCH-PNDG-FIXED-FCTR-CUR                 
P00680                                          THRU 7240-EXIT          
P00680           PERFORM 2200-GET-PNDG-OPTION-DSCNT                     
P00680                                          THRU 2200-EXIT          
P00680                                          UNTIL NO-MORE-ROWS      
P00680           PERFORM 7250-CLOSE-PNDG-FIXED-FCTR-CUR                 
P00680                                          THRU 7250-EXIT          
P00680                                                                  
P00680           COMPUTE RS-PNDG-OPT-TOT-PRC-DSCNT EQUAL                
P00680                   RS-PNDG-OPT-TOT-PRC-DSCNT * -1                 
P00680           COMPUTE RS-PNDG-OPT-TOT-CSC-DSCNT EQUAL                
P00680                   RS-PNDG-OPT-TOT-CSC-DSCNT * -1                 
P00680                                                                  
I00484        END-IF                                                    
           ELSE                                                         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00680***************************************************************** *       
P00680** 6000-GET-PRORATED-INCTV-CPD4114 THRU 6000-CPD4114-EXIT      **         
P00680***************************************************************** *       
P00680     EXEC SQL                                                             
P00680        INCLUDE CPD04114                                                  
P00680     END-EXEC.                                                            
P00680*                                                                         
P00680***************************************************************** *       
P00680** ERROR ROUTINE FOR COPYBOOK CPD4114                          **         
P00680***************************************************************** *       
P00680*                                                                         
P00680 6999-ERROR-ROUTINE-CPD4114.                                      
P00680*                                                                         
P00680     IF ERRORS-4114                                               
P00680        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
P00680           CONTINUE                                               
P00680        ELSE                                                      
P00680           PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
P00680           PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
P00680        END-IF                                                    
P00680     END-IF.                                                      
P00680*                                                                         
P00680 6999-CPD4114-EXIT.                                               
P00680     EXIT.                                                        
P00680*                                                                         
P805CS*****************************************************************         
P805CS*** 6000-CPD444-CSC-DISCOUNT-ELIG THRU 6000-CPD444-EXIT       ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS     EXEC SQL                                                     PCS03470
P805CS        INCLUDE CPD0444E                                          PCS03470
P805CS     END-EXEC.                                                            
P805CS*                                                                         
P805CS*****************************************************************         
P805CS*** ERROR ROUTINE FOR CPD0444E                                ***         
P805CS*****************************************************************         
P805CS*                                                                         
P805CS 6999-CPD444-ERROR-ROUTINE.                                       
P805CS*                                                                         
P805CS     PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT.          
P805CS*                                                                         
P805CS 6999-CPD444-EXIT.                                                
P805CS     EXIT.                                                        
P805CS*                                                                         
      *****************************************************************         
      *                                                               *         
      * 7000-SEL-ACCT-DET.                                            *         
      *****************************************************************         
       7000-SEL-ACCT-DET.                                               
                                                                        
           EXEC SQL                                                     
               SELECT AT.REV_MTH_LST_NRML                               
                     ,AT.ADDRESS_ID                                     
I00113               ,AT.CUSTOMER_NO                                    
I00113               ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
P00453               ,AT.CODES_DATA_PRESENT                             
P00453               ,AT.CODE_ACCT_STAT                                 
OTPOOL               ,AT.LOCAL_OFFICE                                   
I02262               ,PR.AGL_PREM_NO                                    
                 INTO :AT-REV-MTH-LST-NRML                              
                     ,:AT-ADDRESS-ID                                    
I00113               ,:AT-CUSTOMER-NO                                   
I00113               ,:WS-CURRENT-DATE                                  
P00453               ,:AT-CODES-DATA-PRESENT                            
P00453               ,:AT-CODE-ACCT-STAT                                
OTPOOL               ,:AT-LOCAL-OFFICE                                  
I02262               ,:PR-AGL-PREM-NO                                   
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
I02262               ,CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
I02262            AND PR.PREMISE_NO =  AT.PREMISE_NO                    
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.ADDRESS_ID                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*              ,AT.CODES_DATA_PRESENT                                     
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,PR.AGL_PREM_NO                                            
MFA-TR*          INTO :AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-ADDRESS-ID                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:WS-CURRENT-DATE                                          
MFA-TR*              ,:AT-CODES-DATA-PRESENT                                    
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:PR-AGL-PREM-NO                                           
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*              ,CSS_PREMISE PR                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND PR.PREMISE_NO =  AT.PREMISE_NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00484*****************************************************************         
I00484*                                                               *         
I00484* 7002-SEL-PEND-OPTION.                                         *         
I00484*****************************************************************         
I00484 7002-SEL-PEND-OPTION.                                            
I00484                                                                  
I00484     EXEC SQL                                                     
I00484         SELECT FI.OPTION_CD                                      
I00484               ,FI.OPT_DESC_INT_LONG                              
P680PN               ,DF.PRCE_NEGOTIATED_CD                             
P00805               ,DF.OPT_AGRMT_EFF_DT                               
P00892               ,DF.AUTO_REN_OPT_IN_FL                             
P00892               ,DF.AGREEMNT_SOURCE_CD                             
P00892               ,FI.OPT_CALC_TYPE_CD                               
I00484           INTO :FI-OPTION-CD                                     
I00484               ,:FI-OPT-DESC-INT-LONG                             
P680PN               ,:DF-PRCE-NEGOTIATED-CD                            
P00805               ,:DF-OPT-AGRMT-EFF-DT                              
P00892               ,:DF-AUTO-REN-OPT-IN-FL                            
P00892               ,:DF-AGREEMNT-SOURCE-CD                            
P00892               ,:FI-OPT-CALC-TYPE-CD                              
I00484           FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
I00484               ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
I00484          WHERE DF.ACCOUNT_NO       = :DF-ACCOUNT-NO              
I00484            AND DF.CODE_UTIL_TYPE   = :DF-CODE-UTIL-TYPE          
I00484            AND DF.IC_NO            = :DF-IC-NO                   
I00484            AND DF.STATUS_CD        = :DF-STATUS-CD               
I00484            AND DF.OPTION_CD        = FI.OPTION_CD                
P00473            AND FI.OPT_VSTART_TS   <= CIS.CURRENT$TIMESTAMP()           
P00473            AND FI.OPT_VEND_TS     >= CIS.CURRENT$TIMESTAMP()           
P00473            AND FI.PROC_STATUS_CD   = 'AC'                        
I00484                                                           
A03303                                                      
I00484     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.OPTION_CD                                              
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,DF.PRCE_NEGOTIATED_CD                                     
MFA-TR*              ,DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                                     
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*          INTO :FI-OPTION-CD                                             
MFA-TR*              ,:FI-OPT-DESC-INT-LONG                                     
MFA-TR*              ,:DF-PRCE-NEGOTIATED-CD                                    
MFA-TR*              ,:DF-OPT-AGRMT-EFF-DT                                      
MFA-TR*              ,:DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*              ,:DF-AGREEMNT-SOURCE-CD                                    
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*         WHERE DF.ACCOUNT_NO       = :DF-ACCOUNT-NO                      
MFA-TR*           AND DF.CODE_UTIL_TYPE   = :DF-CODE-UTIL-TYPE                  
MFA-TR*           AND DF.IC_NO            = :DF-IC-NO                           
MFA-TR*           AND DF.STATUS_CD        = :DF-STATUS-CD                       
MFA-TR*           AND DF.OPTION_CD        = FI.OPTION_CD                        
MFA-TR*           AND FI.OPT_VSTART_TS   <= CURRENT TIMESTAMP                   
MFA-TR*           AND FI.OPT_VEND_TS     >= CURRENT TIMESTAMP                   
MFA-TR*           AND FI.PROC_STATUS_CD   = 'AC'                                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00484                                                                  
I00484     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00484                                                                  
I00484     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00484        CONTINUE                                                  
I00484     ELSE                                                         
I00484        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00484        MOVE '7002'                    TO ACTIVE-PARAGRAPH        
I00484        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00484        MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1                 
I00484        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
I00484        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
I00484        MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
I00484        MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
I00484        MOVE DF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
I00484        MOVE DF-IC-NO                  TO HOSTVAR-ELEMENT-3       
I00484        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00484        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00484     END-IF.                                                      
I00484                                                                  
I00484 7002-EXIT.                                                       
I00484     EXIT.                                                        
I00484                                                                  
P00141****************************************************************          
P00141** 7005-OPT-AGR-EFF-DT.                                       **          
P00141****************************************************************          
P00141 7005-OPT-AGR-EFF-DT.                                             
P00141                                                                  
P00141     EXEC SQL                                                     
P00141         SELECT DF.OPT_AGRMT_EFF_DT                               
I00484               ,DF.OPTION_CD                                      
I00484               ,DF.RT_PKG_OPT_SEQ_NO                              
I00484               ,DF.STATUS_CD                                      
P00680               ,DF.OFFER_CD                                       
P680PN               ,DF.PRCE_NEGOTIATED_CD                             
P00892               ,DF.AUTO_REN_OPT_IN_FL                             
P00892               ,DF.AGREEMNT_SOURCE_CD                             
P00892               ,FI.OPT_CALC_TYPE_CD                               
P00141           INTO :DF-OPT-AGRMT-EFF-DT                              
I00484               ,:DF-OPTION-CD                                     
I00484               ,:DF-RT-PKG-OPT-SEQ-NO                             
I00484               ,:DF-STATUS-CD                                     
P00680               ,:DF-OFFER-CD                                      
P680PN               ,:DF-PRCE-NEGOTIATED-CD                            
P00892               ,:DF-AUTO-REN-OPT-IN-FL                            
P00892               ,:DF-AGREEMNT-SOURCE-CD                            
P00892               ,:FI-OPT-CALC-TYPE-CD                              
P00141           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
P00141               ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                
P00892               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
P00141          WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             
P00141            AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         
P00141            AND DF.IC_NO             = :DF-IC-NO                  
P00141            AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO              
P00141            AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE          
P00141            AND UT.IC_NO             = DF.IC_NO                   
P00141            AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO       
P00892            AND DF.OPTION_CD         = FI.OPTION_CD               
P00892            AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()          
P00892            AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()          
P00892            AND FI.PROC_STATUS_CD    = 'AC'                       
P00141                                                           
A03303                                                      
P00141     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,DF.OPTION_CD                                              
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.STATUS_CD                                      41146600
MFA-TR*              ,DF.OFFER_CD                                               
MFA-TR*              ,DF.PRCE_NEGOTIATED_CD                                     
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                                     
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*          INTO :DF-OPT-AGRMT-EFF-DT                                      
MFA-TR*              ,:DF-OPTION-CD                                             
MFA-TR*              ,:DF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:DF-STATUS-CD                                     41146600
MFA-TR*              ,:DF-OFFER-CD                                              
MFA-TR*              ,:DF-PRCE-NEGOTIATED-CD                                    
MFA-TR*              ,:DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*              ,:DF-AGREEMNT-SOURCE-CD                                    
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CSS_UTIL_ENVRNMT  UT                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                     
MFA-TR*           AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE                 
MFA-TR*           AND DF.IC_NO             = :DF-IC-NO                          
MFA-TR*           AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                      
MFA-TR*           AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                  
MFA-TR*           AND UT.IC_NO             = DF.IC_NO                           
MFA-TR*           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO               
MFA-TR*           AND DF.OPTION_CD         = FI.OPTION_CD                       
MFA-TR*           AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7005                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00141                                                                  
P00141     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00141                                                                  
P00141     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00141        NEXT SENTENCE                                             
P00141     ELSE                                                         
P00141        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00141        MOVE '7005'                    TO ACTIVE-PARAGRAPH        
P00141        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00141        MOVE 'CSS_ACCT_RTPK_AGR'       TO TABLE-1                 
P00141        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00141        MOVE DF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00141        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00141        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00141     END-IF.                                                      
P00141                                                                  
P00141 7005-EXIT.                                                       
P00141     EXIT.                                                        
P00141                                                                  
      *****************************************************************         
      *                                                               *         
      * 7010-SEL-EXIT-FEE.                                            *         
      *****************************************************************         
       7010-SEL-EXIT-FEE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HQ.ATTR_INCTV_VALUE                               
                 INTO :HQ-ATTR-INCTV-VALUE                              
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.OPTION_CD           = :HQ-OPTION-CD            
                  AND HQ.FACTOR_ID           = :HQ-FACTOR-ID            
P00141            AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )     
P00141            AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )     
P00473            AND HQ.PROC_STATUS_CD      = 'AC'                     
P00805            AND HQ.OPT_ATTR_VSTART_TS = (                         
P00805                SELECT MAX(H1.OPT_ATTR_VSTART_TS)                 
P00805                  FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)        
P00805                 WHERE H1.OPTION_CD       = HQ.OPTION_CD          
P00805                   AND H1.FACTOR_ID       = HQ.FACTOR_ID          
P00805                   AND H1.ATTR_INCTV_STRT_DT                      
P00805                                         <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )  
P00805                   AND H1.ATTR_INCTV_END_DT                       
P00805                                         >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )  
P00805                   AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                
P00805                                         <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )  
P00805                   AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                  
P00805                                         >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )  
P00805                   AND H1.PROC_STATUS_CD  = 'AC')                 
P00141          ORDER BY HQ.ATTR_INCTV_STRT_DT                          
                                             
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HQ.ATTR_INCTV_VALUE                                       
MFA-TR*          INTO :HQ-ATTR-INCTV-VALUE                                      
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.OPTION_CD           = :HQ-OPTION-CD                    
MFA-TR*           AND HQ.FACTOR_ID           = :HQ-FACTOR-ID                    
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= :DF-OPT-AGRMT-EFF-DT             
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= :DF-OPT-AGRMT-EFF-DT             
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS = (                                 
MFA-TR*               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                 FROM CRM_OPT_ATTR_INCTV H1                              
MFA-TR*                WHERE H1.OPTION_CD       = HQ.OPTION_CD                  
MFA-TR*                  AND H1.FACTOR_ID       = HQ.FACTOR_ID                  
MFA-TR*                  AND H1.ATTR_INCTV_STRT_DT                              
MFA-TR*                                        <= :DF-OPT-AGRMT-EFF-DT          
MFA-TR*                  AND H1.ATTR_INCTV_END_DT                               
MFA-TR*                                        >= :DF-OPT-AGRMT-EFF-DT          
MFA-TR*                  AND DATE(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                                        <= :DF-OPT-AGRMT-EFF-DT          
MFA-TR*                  AND DATE(H1.OPT_ATTR_VEND_TS)                          
MFA-TR*                                        >= :DF-OPT-AGRMT-EFF-DT          
MFA-TR*                  AND H1.PROC_STATUS_CD  = 'AC')                         
MFA-TR*         ORDER BY HQ.ATTR_INCTV_STRT_DT                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7020-SEL-MKT-TIER-RANKING.                                    *         
      *****************************************************************         
       7020-SEL-MKT-TIER-RANKING.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) DD.MKT_TIER_RANKING,
              DD.TIER_CUST_STAT_CD,
              DD.TIER_ACCT_TYPE_CD,
              DD.MKT_TIER_START_DT                             
                  INTO :DD-MKT-TIER-RANKING                             
                      ,:DD-TIER-CUST-STAT-CD                            
                      ,:DD-TIER-ACCT-TYPE-CD                            
                      ,:DD-MKT-TIER-START-DT                            
                  FROM CSS_ACCT_MKT_TIER DD                             
                 WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                 
                   AND DD.EFF_START_DT = (                              
                            SELECT MAX(EFF_START_DT)                    
                              FROM CSS_ACCT_MKT_TIER                    
                             WHERE ACCOUNT_NO = :DD-ACCOUNT-NO          
                                         )                              
                                                    
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*         SELECT DD.MKT_TIER_RANKING                              41146600
MFA-TR*               ,DD.TIER_CUST_STAT_CD                             41146600
MFA-TR*               ,DD.TIER_ACCT_TYPE_CD                             41146600
MFA-TR*               ,DD.MKT_TIER_START_DT                             41146600
MFA-TR*           INTO :DD-MKT-TIER-RANKING                             41146600
MFA-TR*               ,:DD-TIER-CUST-STAT-CD                            41146600
MFA-TR*               ,:DD-TIER-ACCT-TYPE-CD                            41146600
MFA-TR*               ,:DD-MKT-TIER-START-DT                            41146600
MFA-TR*           FROM CSS_ACCT_MKT_TIER DD                             41146600
MFA-TR*          WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                 41146600
MFA-TR*            AND DD.EFF_START_DT = (                              41146600
MFA-TR*                     SELECT MAX(EFF_START_DT)                    41146600
MFA-TR*                       FROM CSS_ACCT_MKT_TIER                    41146600
MFA-TR*                      WHERE ACCOUNT_NO = :DD-ACCOUNT-NO          41146600
MFA-TR*                                  )                              41146600
MFA-TR*          FETCH FIRST ROW ONLY                                   41146600
MFA-TR*          QUERYNO 7020                                                   
MFA-TR*    END-EXEC.                                                    41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00113        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00113           SET TIER-RANK-SET TO TRUE                              
I00113        END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCT_MKT_TIER'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE DD-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7030-SEL-OPT-DESC.                                            *         
      *****************************************************************         
       7030-SEL-OPT-DESC.                                               
                                                                        
           EXEC SQL                                                     
               SELECT OPT_DESC_INT_LONG                                 
                 INTO :FI-OPT-DESC-INT-LONG                             
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.OPTION_CD      = :FI-OPTION-CD                 
P00473            AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()             
P00473            AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()             
P00473            AND FI.PROC_STATUS_CD = 'AC'                          
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OPT_DESC_INT_LONG                                         
MFA-TR*          INTO :FI-OPT-DESC-INT-LONG                                     
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.OPTION_CD      = :FI-OPTION-CD                         
MFA-TR*           AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP                     
MFA-TR*           AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP                     
MFA-TR*           AND FI.PROC_STATUS_CD = 'AC'                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00677*****************************************************************         
P00677*                                                               *         
P00677* 7035-SELECT-SENIOR-RANKING.                                   *         
P00677*****************************************************************         
P00677 7035-SELECT-SENIOR-RANKING.                                      
P00677                                                                  
P00677     EXEC SQL                                                     
P00677         SELECT [1B].ADJ_TIER_RANKING                               
P00677               ,[1B].ADJ_TIER_START_DT                              
P00677               ,[1B].TIER_CUST_STAT_CD                              
P00677           INTO :1B-ADJ-TIER-RANKING                              
P00677               ,:1B-ADJ-TIER-START-DT                             
P00677               ,:1B-TIER-CUST-STAT-CD                             
P00677           FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
P00677               ,CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
P00677          WHERE IG.TIER_ACCT_TYPE_CD   = :IG-TIER-ACCT-TYPE-CD    
P00677            AND IG.TIER_CUST_STAT_CD   = :IG-TIER-CUST-STAT-CD    
P00677            AND IG.MKT_TIER_RANKING    = :IG-MKT-TIER-RANKING     
P00677            AND [1B].COMPANY_NO          =  IG.COMPANY_NO           
P00677            AND [1B].TIER_CUST_STAT_CD   =  IG.TIER_CUST_STAT_CD    
P00677            AND [1B].TIER_ACCT_TYPE_CD   =  IG.TIER_ACCT_TYPE_CD    
P00677            AND [1B].MKT_TIER_RANKING    =  IG.MKT_TIER_RANKING     
P00677            AND [1B].MKT_TIER_START_DT   =  IG.MKT_TIER_START_DT    
P00677            AND [1B].ADJ_START_DT       <=  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
P00677            AND [1B].ADJ_END_DT         >=  
           CAST(SYSDATETIMEOFFSET() AS DATE)            
P00677            AND [1B].AGL_LOW_INCM_SR_FL  = :WS-SCANA-SENIOR         
P00677            AND [1B].APPLICATION_CD      = :WS-SCANA-SR-SETUP       
P00677            AND [1B].DHR_QUALIFIED_FL    = :WS-YES                  
P00677                                                           
P00677                                                      
P00677     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.ADJ_TIER_RANKING                                       
MFA-TR*              ,1B.ADJ_TIER_START_DT                                      
MFA-TR*              ,1B.TIER_CUST_STAT_CD                                      
MFA-TR*          INTO :1B-ADJ-TIER-RANKING                                      
MFA-TR*              ,:1B-ADJ-TIER-START-DT                                     
MFA-TR*              ,:1B-TIER-CUST-STAT-CD                                     
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*              ,CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE IG.TIER_ACCT_TYPE_CD   = :IG-TIER-ACCT-TYPE-CD            
MFA-TR*           AND IG.TIER_CUST_STAT_CD   = :IG-TIER-CUST-STAT-CD            
MFA-TR*           AND IG.MKT_TIER_RANKING    = :IG-MKT-TIER-RANKING             
MFA-TR*           AND 1B.COMPANY_NO          =  IG.COMPANY_NO                   
MFA-TR*           AND 1B.TIER_CUST_STAT_CD   =  IG.TIER_CUST_STAT_CD            
MFA-TR*           AND 1B.TIER_ACCT_TYPE_CD   =  IG.TIER_ACCT_TYPE_CD            
MFA-TR*           AND 1B.MKT_TIER_RANKING    =  IG.MKT_TIER_RANKING             
MFA-TR*           AND 1B.MKT_TIER_START_DT   =  IG.MKT_TIER_START_DT            
MFA-TR*           AND 1B.ADJ_START_DT       <=  CURRENT DATE                    
MFA-TR*           AND 1B.ADJ_END_DT         >=  CURRENT DATE                    
MFA-TR*           AND 1B.AGL_LOW_INCM_SR_FL  = :WS-SCANA-SENIOR                 
MFA-TR*           AND 1B.APPLICATION_CD      = :WS-SCANA-SR-SETUP               
MFA-TR*           AND 1B.DHR_QUALIFIED_FL    = :WS-YES                          
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7035                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00677                                                                  
P00677     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00677                                                                  
P00677     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00677        NEXT SENTENCE                                             
P00677     ELSE                                                         
P00677        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00677        MOVE '7035'                    TO ACTIVE-PARAGRAPH        
P00677        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00677        MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
P00677        MOVE 'CRM_MKT_TIER_ADJ'        TO TABLE-2                 
P00677        MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-1         
P00677        MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-2         
P00677        MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-3         
P00677        MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-1       
P00677        MOVE IG-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
P00677        MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-3       
P00677        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00677        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00677     END-IF.                                                      
P00677                                                                  
P00677 7035-EXIT.                                                       
P00677     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7040-SELECT-DEFLT-RANKIG.                                     *         
      *****************************************************************         
       7040-SELECT-DEFLT-RANKIG.                                        
                                                                        
           EXEC SQL                                                     
                SELECT IG.MKT_TIER_RANKING                              
                      ,IG.TIER_CUST_STAT_CD                             
                      ,IG.MKT_TIER_START_DT                             
                  INTO :IG-MKT-TIER-RANKING                             
                      ,:IG-TIER-CUST-STAT-CD                            
                      ,:IG-MKT-TIER-START-DT                            
                  FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                    
                 WHERE IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD    
                   AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD    
I00113             AND IG.CUST_ACCT_DEFLT_FL = :IG-CUST-ACCT-DEFLT-FL   
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IG.MKT_TIER_RANKING                                      
MFA-TR*               ,IG.TIER_CUST_STAT_CD                                     
MFA-TR*               ,IG.MKT_TIER_START_DT                                     
MFA-TR*           INTO :IG-MKT-TIER-RANKING                                     
MFA-TR*               ,:IG-TIER-CUST-STAT-CD                                    
MFA-TR*               ,:IG-MKT-TIER-START-DT                                    
MFA-TR*           FROM CRM_MKT_TIER IG                                          
MFA-TR*          WHERE IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD            
MFA-TR*            AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD            
MFA-TR*            AND IG.CUST_ACCT_DEFLT_FL = :IG-CUST-ACCT-DEFLT-FL           
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7040                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-1         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-2         
              MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-1       
              MOVE IG-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00453*****************************************************************         
P00453* 7045-SELECT-PRP-TIER-DTLS.                                    *         
P00453*****************************************************************         
P00453 7045-SELECT-PRP-TIER-DTLS.                                       
P00453                                                                  
P00453     EXEC SQL                                                     
P00453          SELECT IG.MKT_TIER_RANKING                              
P00453                ,IG.MKT_TIER_START_DT                             
P00453            INTO :IG-MKT-TIER-RANKING                             
P00453                ,:IG-MKT-TIER-START-DT                            
P00453            FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                    
P00453           WHERE IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD    
P00453             AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD    
P00453             AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING     
A03303                                                           
A03303                                                      
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IG.MKT_TIER_RANKING                                      
MFA-TR*               ,IG.MKT_TIER_START_DT                                     
MFA-TR*           INTO :IG-MKT-TIER-RANKING                                     
MFA-TR*               ,:IG-MKT-TIER-START-DT                                    
MFA-TR*           FROM CRM_MKT_TIER IG                                          
MFA-TR*          WHERE IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD            
MFA-TR*            AND IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD            
MFA-TR*            AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING             
MFA-TR*           WITH UR                                                       
MFA-TR*          QUERYNO 7045                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453                                                                  
P00453     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00453                                                                  
P00453     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00453        NEXT SENTENCE                                             
P00453     ELSE                                                         
P00453        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00453        MOVE '7045'                    TO ACTIVE-PARAGRAPH        
P00453        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00453        MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
P00453        MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-1         
P00453        MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-2         
P00453        MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-3         
P00453        MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-1       
P00453        MOVE IG-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
P00453        MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-3       
P00453        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00453        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00453     END-IF.                                                      
P00453                                                                  
P00453 7045-EXIT.                                                       
P00453     EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-SEL-REG-PROFILE.                                         *         
      *****************************************************************         
       7050-SEL-REG-PROFILE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT LR.REG_GROUP_CD                                   
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
                WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                    
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LR.REG_GROUP_CD                                           
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE LR                                        
MFA-TR*         WHERE LR.ACCOUNT_NO = :LR-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REG_PROFILE'         TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE LR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00113******************************************************************        
I00113*                                                                *        
I00113* 7060-SELECT-DELINQNCY                                          *        
I00113******************************************************************        
I00113 7060-SELECT-DELINQNCY.                                           
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT DELINQ_VALUE                                      
I00113           INTO :C8-DELINQ-VALUE                                  
I00113           FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
I00113          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     
I00113            AND C8.COMPANY_NO = :C8-COMPANY-NO                    
A03303                                                           
A03303                                                      
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY C8                                        
MFA-TR*         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*           AND C8.COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7060                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7060'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00113        MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
I00113        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
I00113        MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-2         
I00113        MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
I00113        MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7060-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
I00113******************************************************************        
I00113*                                                                *        
I00113* 7070-GET-YEAR-BETWEEN.                                         *        
I00113******************************************************************        
I00113 7070-GET-YEAR-BETWEEN.                                           
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT
              ( 12 *                            
I00113                                  CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))     
I00113                                  + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                      :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))     
I00113                                 ) / 12
            INTO
              :WS-RESULT-YEAR                           
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-YEAR =  ( 12 *                                    
MFA-TR*                                 YEAR(DATE(:WS-DUMMY-DATE-ST)            
MFA-TR*                                 - DATE(:WS-DUMMY-DATE-END))             
MFA-TR*                                 + MONTH(DATE(:WS-DUMMY-DATE-ST)         
MFA-TR*                                 - DATE(:WS-DUMMY-DATE-END))             
MFA-TR*                                ) / 12                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7070'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00113        MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
I00113        MOVE 'START DATE'              TO TABLE-ELEMENT-1         
I00113        MOVE 'END DATE'                TO TABLE-ELEMENT-2         
I00113        MOVE WS-DUMMY-DATE-ST          TO HOSTVAR-ELEMENT-1       
I00113        MOVE WS-DUMMY-DATE-END         TO HOSTVAR-ELEMENT-2       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7070-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
P00805******************************************************************        
P00805* 7075-ADD-DAYS.                                                 *        
P00805******************************************************************        
P00805 7075-ADD-DAYS.                                                   
P00805                                                                  
P00805     EXEC SQL                                                     
P00805         SELECT
              DATEADD( DAY, -1, DATEADD( DAY, :WS-3DAY-ROR-DAYS, 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) ) ) )
            INTO
              :WS-RESULT-DATE    
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-DATE =  DATE(DATE(:DF-OPT-AGRMT-EFF-DT)           
MFA-TR*                                    + (:WS-3DAY-ROR-DAYS DAYS)           
MFA-TR*                                    -                  1 DAY)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00805                                                                  
P00805     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00805        NEXT SENTENCE                                             
P00805     ELSE                                                         
P00805        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00805        MOVE '7075'                    TO ACTIVE-PARAGRAPH        
P00805        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00805        MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
P00805        MOVE 'OPTION EFF_DT'           TO TABLE-ELEMENT-1         
P00805        MOVE 'ROR END DATE'            TO TABLE-ELEMENT-2         
P00805        MOVE DF-OPT-AGRMT-EFF-DT       TO HOSTVAR-ELEMENT-1       
P00805        MOVE WS-RESULT-DATE            TO HOSTVAR-ELEMENT-2       
P00805        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00805        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00805     END-IF.                                                      
P00805                                                                  
P00805 7075-EXIT.                                                       
P00805     EXIT.                                                        
P00805                                                                  
P00892******************************************************************        
P00892* 7076-ADD-DAYS-GRACE-PERIOD.                                *            
P00892******************************************************************        
P00892 7076-ADD-DAYS-GRACE-PERIOD.                                      
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         SELECT
              DATEADD( DAY, :WS-90DAY-GRACE-PERIOD, 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) ) )
            INTO
              :WS-RESULT-DATE 
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-DATE =  DATE(DATE(:DF-OPT-AGRMT-EFF-DT)           
MFA-TR*                                + (:WS-90DAY-GRACE-PERIOD DAYS))         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00892        NEXT SENTENCE                                             
P00892     ELSE                                                         
P00892        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00892        MOVE '7076'                    TO ACTIVE-PARAGRAPH        
P00892        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00892        MOVE 'SET '                    TO TABLE-1                 
P00892        MOVE 'OPTION EFF_DT'           TO TABLE-ELEMENT-1         
P00892        MOVE '90 DAY GRACE'            TO TABLE-ELEMENT-2         
P00892        MOVE DF-OPT-AGRMT-EFF-DT       TO HOSTVAR-ELEMENT-1       
P00892        MOVE WS-RESULT-DATE            TO HOSTVAR-ELEMENT-2       
P00892        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00892        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00892     END-IF.                                                      
P00892                                                                  
P00892 7076-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
P00892*****************************************************************         
P00892*                                                               *         
P00892* 7077-SEL-SEASONAL-FL.                                         *         
P00892*****************************************************************         
P00892 7077-SEL-SEASONAL-FL.                                            
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         SELECT TA.SEASONAL_FL                                    
P00892           INTO :TA-SEASONAL-FL                                   
P00892           FROM CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
P00892          WHERE TA.ACCOUNT_NO = :TA-ACCOUNT-NO                    
P00892                                                           
P00892                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TA.SEASONAL_FL                                            
MFA-TR*          INTO :TA-SEASONAL-FL                                           
MFA-TR*          FROM CSS_ACCT_MISC_INFO TA                                     
MFA-TR*         WHERE TA.ACCOUNT_NO = :TA-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7077                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00892        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00892           MOVE SPACES TO TA-SEASONAL-FL                          
P00892        END-IF                                                    
P00892     ELSE                                                         
P00892        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00892        MOVE '7077'                    TO ACTIVE-PARAGRAPH        
P00892        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00892        MOVE 'CSS_ACCT_MISC_INFO'      TO TABLE-1                 
P00892        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00892        MOVE TA-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00892        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00892        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00892     END-IF.                                                      
P00892                                                                  
P00892 7077-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
I00113******************************************************************        
I00113*                                                                *        
I00113* 7080-SELECT-CUST-STATS.                                        *        
I00113******************************************************************        
I00113 7080-SELECT-CUST-STATS.                                          
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT CE.DOB_VERIFIED_CD                                
I00113               ,CE.DATE_OF_BIRTH                                  
I00113           INTO :CE-DOB-VERIFIED-CD                               
I00113               ,:CE-DATE-OF-BIRTH :WS-NULL-IND-01                  
I00113           FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
I00113          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                
I00113            AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE              
A03303                                                           
A03303                                                      
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CE.DOB_VERIFIED_CD                                        
MFA-TR*              ,CE.DATE_OF_BIRTH                                          
MFA-TR*          INTO :CE-DOB-VERIFIED-CD                                       
MFA-TR*              ,:CE-DATE-OF-BIRTH:WS-NULL-IND-01                          
MFA-TR*          FROM CSS_CUST_STATS CE                                         
MFA-TR*         WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                        
MFA-TR*           AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                      
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7080                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7080'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00113        MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
I00113        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
I00113        MOVE 'CUSTOMER_TYPE'           TO TABLE-ELEMENT-2         
I00113        MOVE CE-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
I00113        MOVE CE-CUSTOMER-TYPE          TO HOSTVAR-ELEMENT-2       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7080-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
I00113*****************************************************************         
I00113*                                                               *         
I00113* 7090-SEL-DHR-HIST.                                            *         
I00113*****************************************************************         
I00113 7090-SEL-DHR-HIST.                                               
I00113                                                                  
I00113     EXEC SQL                                                     
P00172          SELECT CU.DHR_FL                                        
I00113            INTO :WS-DHR-CUSTOMER                                 
P00172            FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                    
P00172           WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                
P00172                                                           
A03303                                                      
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CU.DHR_FL                                                
MFA-TR*           INTO :WS-DHR-CUSTOMER                                         
MFA-TR*           FROM CSS_CUSTOMER CU                                          
MFA-TR*          WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                        
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7090                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7090'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00172        MOVE 'CSS_CUSTOMER'            TO TABLE-1                 
P00172        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
P00172        MOVE CU-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7090-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
I00484*****************************************************************         
I00484*                                                               *         
I00484* 7100-SEL-THERM-PRICE.                                         *         
I00484*****************************************************************         
I00484 7100-SEL-THERM-PRICE.                                            
I00484                                                                  
I00484     EXEC SQL                                                     
I00484        SELECT TOP(1) FACTOR,
              FF.FACTOR_ID                                       
I00484          INTO :FF-FACTOR                                         
A03303              ,:FF-FACTOR-ID                                      
I00484          FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
I00484              ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
I00484         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO             
I00484           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE         
I00484           AND FF.IC_NO              = :FF-IC-NO                  
I00484           AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO      
I00484           AND FF.FACTOR_ID          = HQ.FACTOR_ID               
I00484           AND HQ.OPTION_CD          = :HQ-OPTION-CD              
I00484           AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'              
I00484           AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
I00484           AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00473           AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
P00473           AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
P00473           AND HQ.PROC_STATUS_CD      = 'AC'                      
P00680         ORDER BY FF.EFF_DATE_FROM DESC                           
P00680                                              
I00484                                                           
A03303                                                      
I00484     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FACTOR                                                     
MFA-TR*             ,FF.FACTOR_ID                                               
MFA-TR*         INTO :FF-FACTOR                                                 
MFA-TR*             ,:FF-FACTOR-ID                                              
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                     
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                 
MFA-TR*          AND FF.IC_NO              = :FF-IC-NO                          
MFA-TR*          AND FF.RT_PKG_OPT_SEQ_NO  = :FF-RT-PKG-OPT-SEQ-NO              
MFA-TR*          AND FF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00484                                                                  
I00484     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00484                                                                  
I00484     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00484        CONTINUE                                                  
I00484     ELSE                                                         
I00484        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00484        MOVE '7100'                    TO ACTIVE-PARAGRAPH        
I00484        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00484        MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
I00484        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
I00484        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
I00484        MOVE 'RT_PKG_OPT_SEQ_NO'       TO TABLE-ELEMENT-3         
I00484        MOVE 'OPTION_CD'               TO TABLE-ELEMENT-4         
I00484        MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
I00484        MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
I00484        MOVE FF-RT-PKG-OPT-SEQ-NO      TO HOSTVAR-ELEMENT-3       
I00484        MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-4       
I00484        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00484        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00484     END-IF.                                                      
I00484                                                                  
I00484 7100-EXIT.                                                       
I00484     EXIT.                                                        
I00484                                                                  
P00269*****************************************************************         
P00269*                                                               *         
P00269* 7110-GET-SUPER-USER-FLAG.                                     *         
P00269*****************************************************************         
P00269 7110-GET-SUPER-USER-FLAG.                                        
P00269                                                                  
P00269     EXEC SQL                                                     
P00269        SELECT TOP(1) 'Y'                                                
P00269          INTO :WS-SUPER-USER-FLAG                                
P00269          FROM CSS_CATEGORY   F5 WITH(READUNCOMMITTED)                    
P00269         WHERE F5.USER_ID     = :F5-USER-ID                       
P00269           AND F5.CATEGORY_ID =  346                              
P00269                                              
P00269                                                           
A03303                                                      
P00269     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SUPER-USER-FLAG                                        
MFA-TR*         FROM CSS_CATEGORY   F5                                          
MFA-TR*        WHERE F5.USER_ID     = :F5-USER-ID                               
MFA-TR*          AND F5.CATEGORY_ID =  346                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00269                                                                  
P00269     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00269                                                                  
P00269     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00269        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
P00269           MOVE 'N'                    TO WS-SUPER-USER-FLAG      
P00269        END-IF                                                    
P00269     ELSE                                                         
P00269        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00269        MOVE '7110'                    TO ACTIVE-PARAGRAPH        
P00269        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00269        MOVE 'CSS_CATEGORY'            TO TABLE-1                 
P00269        MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
P00269        MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
P00269        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00269        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00269     END-IF.                                                      
P00269                                                                  
P00269 7110-EXIT.                                                       
P00269     EXIT.                                                        
P00269*                                                                         
A03303******************************************************************        
A03303* 7120-SELECT-FCTR-POWER.                                        *        
A03303******************************************************************        
A03303 7120-SELECT-FCTR-POWER.                                          
A03303                                                                  
A03303     EXEC SQL                                                     
A03303        SELECT SF.FCTR_POWER_10                                   
A03303          INTO :SF-FCTR-POWER-10                                  
A03303          FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
A03303         WHERE SF.FACTOR_ID = :SF-FACTOR-ID                       
A03303                                                           
A03303                                                      
A03303     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SF.FCTR_POWER_10                                           
MFA-TR*         INTO :SF-FCTR-POWER-10                                          
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*        WHERE SF.FACTOR_ID = :SF-FACTOR-ID                               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7120                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03303                                                                  
A03303     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A03303                                                                  
A03303     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A03303        NEXT SENTENCE                                             
A03303     ELSE                                                         
A03303        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A03303        MOVE '7120'                     TO ACTIVE-PARAGRAPH       
A03303        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A03303        MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
A03303        MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
A03303        MOVE SF-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
A03303        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A03303        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A03303     END-IF.                                                      
A03303                                                                  
A03303 7120-EXIT.                                                       
A03303     EXIT.                                                        
A03303                                                                  
P00805******************************************************************        
P00805* 7125-SELECT-RATE-PLAN.                                         *        
P00805******************************************************************        
P00805 7125-SELECT-RATE-PLAN.                                           
P00805                                                                  
P00805     EXEC SQL                                                     
P00805        SELECT  RD.SENIOR_RATE_FL                                 
P00805          INTO :RD-SENIOR-RATE-FL                                 
P00805          FROM  CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)               
P00805         WHERE  RD.CODE_UTIL_TYPE = 'G'                           
P00805           AND  RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO              
P00805                                                           
P00805                                                      
P00805     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RD.SENIOR_RATE_FL                                         
MFA-TR*         INTO :RD-SENIOR-RATE-FL                                         
MFA-TR*         FROM  CSS_RATE_PLAN_DESC RD                                     
MFA-TR*        WHERE  RD.CODE_UTIL_TYPE = 'G'                                   
MFA-TR*          AND  RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                      
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7125                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00805                                                                  
P00805     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00805                                                                  
P00805     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00805        NEXT SENTENCE                                             
P00805     ELSE                                                         
P00805        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00805        MOVE '7125'                     TO ACTIVE-PARAGRAPH       
P00805        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00805        MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
P00805        MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
P00805        MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
P00805        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00805        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00805     END-IF.                                                      
P00805                                                                  
P00805 7125-EXIT.                                                       
P00805     EXIT.                                                        
P00805                                                                  
P00453************************************************************              
P00453*                                                          *              
P00453* 7126-GET-PREPAY-HIST.                                    *              
P00453************************************************************              
P00453 7126-GET-PREPAY-HIST.                                            
P00453                                                                  
P00453     EXEC SQL                                                     
P00453          SELECT TOP(1) 'Y'                                              
P00453            INTO :WS-PK-EXISTS                                    
P00453            FROM CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                 
P00453           WHERE PK.ACCOUNT_NO   = :PK-ACCOUNT-NO                 
P00453                                       
P00453                                                      
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07975200
MFA-TR*         SELECT 'Y'                                              07975300
MFA-TR*           INTO :WS-PK-EXISTS                                    07976000
MFA-TR*           FROM CSS_PREPAY_HIST PK                               07976700
MFA-TR*          WHERE PK.ACCOUNT_NO   = :PK-ACCOUNT-NO                 07976800
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                           07977000
MFA-TR*        QUERYNO 7126                                             07977000
MFA-TR*    END-EXEC.                                                    07977100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453                                                                  
P00453     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00453     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00453        IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
P00453           MOVE 'N'                TO WS-PK-EXISTS                
P00453        END-IF                                                    
P00453     ELSE                                                         
P00453        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00453        MOVE '7126'                    TO ACTIVE-PARAGRAPH        
P00453        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00453        MOVE 'CSS_PREPAY_HIST'         TO TABLE-1                 
P00453        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00453        MOVE PK-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00453        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00453        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00453     END-IF.                                                      
P00453                                                                  
P00453 7126-EXIT.                                                       
P00453     EXIT.                                                        
                                                                        
P00680******************************************************************        
P00680*                                                                *        
P00680* 7200-OPEN-ACTV-FIXED-FCTR-CUR.                                 *        
P00680******************************************************************        
P00680 7200-OPEN-ACTV-FIXED-FCTR-CUR.                                   
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         OPEN ACTV_FIXED_FCTR_CUR                                 
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00680        MOVE '7200'                   TO ACTIVE-PARAGRAPH         
P00680        MOVE 'OPEN'                   TO ABEND-FUNCTION           
P00680        MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
P00680        MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
P00680        MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
P00680        MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-4                  
P00680        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00680        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
P00680        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
P00680        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00680        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
P00680        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
P00680        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00680        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00680     END-IF.                                                      
P00680                                                                  
P00680 7200-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P00680******************************************************************        
P00680*                                                                *        
P00680* 7210-FETCH-ACTV-FIXED-FCTR-CUR.                                *        
P00680******************************************************************        
P00680 7210-FETCH-ACTV-FIXED-FCTR-CUR.                                  
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         FETCH ACTV_FIXED_FCTR_CUR                                
P00680          INTO :SF-FACTOR-TEXT                                    
P00680              ,:WS-FACTOR-TEXT-LEN                                
P00680              ,:SF-FCTR-POWER-10                                  
P00680              ,:FF-FACTOR                                         
P00680              ,:HQ-DURATION-NO                                    
P00680              ,:HQ-RT-ATTR-INCTV-TYPE                             
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00680                                                                  
P00680     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00680         WHEN SUCCESSFUL-CALL                                     
P00680            CONTINUE                                              
P00680         WHEN NOT-FOUND                                           
P00680            MOVE 'Y'                  TO WS-NO-MORE-ROWS          
P00680         WHEN OTHER                                               
P00680            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
P00680            MOVE '7210'               TO ACTIVE-PARAGRAPH         
P00680            MOVE 'FETCH'              TO ABEND-FUNCTION           
P00680            MOVE 'CSS_FIXED_FCTR  '   TO TABLE-1                  
P00680            MOVE 'CSS_SPCL_FCTR   '   TO TABLE-2                  
P00680            MOVE 'CSS_ACCT_RTPK_AG'   TO TABLE-3                  
P00680            MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-4                  
P00680            MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
P00680            MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2          
P00680            MOVE 'IC_NO'              TO TABLE-ELEMENT-3          
P00680            MOVE DF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
P00680            MOVE DF-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2        
P00680            MOVE DF-IC-NO             TO HOSTVAR-ELEMENT-3        
P00680            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
P00680            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
P00680     END-EVALUATE.                                                
P00680                                                                  
P00680 7210-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P00680******************************************************************        
P00680*                                                                *        
P00680* 7220-CLOSE-ACTV-FIXED-FCTR-CUR.                                *        
P00680******************************************************************        
P00680 7220-CLOSE-ACTV-FIXED-FCTR-CUR.                                  
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         CLOSE ACTV_FIXED_FCTR_CUR                                
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00680        MOVE '7220'                   TO ACTIVE-PARAGRAPH         
P00680        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
P00680        MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
P00680        MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
P00680        MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
P00680        MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-4                  
P00680        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00680        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
P00680        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
P00680        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00680        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
P00680        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
P00680        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00680        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00680     END-IF.                                                      
P00680                                                                  
P00680 7220-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P00680******************************************************************        
P00680*                                                                *        
P00680* 7230-OPEN-PNDG-FIXED-FCTR-CUR.                                 *        
P00680******************************************************************        
P00680 7230-OPEN-PNDG-FIXED-FCTR-CUR.                                   
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         OPEN PEND_FIXED_FCTR_CUR                                 
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00680        MOVE '7230'                   TO ACTIVE-PARAGRAPH         
P00680        MOVE 'OPEN'                   TO ABEND-FUNCTION           
P00680        MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
P00680        MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
P00680        MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
P00680        MOVE 'CSS_SPCL_FCTR'          TO TABLE-4                  
P00680        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00680        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
P00680        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
P00680        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00680        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
P00680        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
P00680        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00680        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00680     END-IF.                                                      
P00680                                                                  
P00680 7230-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P00680******************************************************************        
P00680*                                                                *        
P00680* 7240-FETCH-PNDG-FIXED-FCTR-CUR.                                *        
P00680******************************************************************        
P00680 7240-FETCH-PNDG-FIXED-FCTR-CUR.                                  
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         FETCH PEND_FIXED_FCTR_CUR                                
P00680          INTO :SF-FACTOR-TEXT                                    
P00680              ,:WS-FACTOR-TEXT-LEN                                
P00680              ,:SF-FCTR-POWER-10                                  
P00680              ,:FF-FACTOR                                         
P00680              ,:HQ-DURATION-NO                                    
P00680              ,:HQ-RT-ATTR-INCTV-TYPE                             
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00680                                                                  
P00680     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00680         WHEN SUCCESSFUL-CALL                                     
P00680            CONTINUE                                              
P00680         WHEN NOT-FOUND                                           
P00680            MOVE 'Y'                  TO WS-NO-MORE-ROWS          
P00680         WHEN OTHER                                               
P00680            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
P00680            MOVE '7240'               TO ACTIVE-PARAGRAPH         
P00680            MOVE 'FETCH'              TO ABEND-FUNCTION           
P00680            MOVE 'CSS_FIXED_FCTR  '   TO TABLE-1                  
P00680            MOVE 'CSS_SPCL_FCTR   '   TO TABLE-2                  
P00680            MOVE 'CSS_ACCT_RTPK_AG'   TO TABLE-3                  
P00680            MOVE 'CSS_SPCL_FCTR'      TO TABLE-4                  
P00680            MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
P00680            MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2          
P00680            MOVE 'IC_NO'              TO TABLE-ELEMENT-3          
P00680            MOVE DF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
P00680            MOVE DF-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2        
P00680            MOVE DF-IC-NO             TO HOSTVAR-ELEMENT-3        
P00680            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
P00680            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
P00680     END-EVALUATE.                                                
P00680                                                                  
P00680 7240-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P00680******************************************************************        
P00680*                                                                *        
P00680* 7250-CLOSE-PNDG-FIXED-FCTR-CUR.                                *        
P00680******************************************************************        
P00680 7250-CLOSE-PNDG-FIXED-FCTR-CUR.                                  
P00680                                                                  
P00680     EXEC SQL                                                     
P00680         CLOSE PEND_FIXED_FCTR_CUR                                
P00680     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00680                                                                  
P00680     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00680                                                                  
P00680     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00680        MOVE '7250'                   TO ACTIVE-PARAGRAPH         
P00680        MOVE 'CLOSE'                  TO ABEND-FUNCTION           
P00680        MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
P00680        MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
P00680        MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
P00680        MOVE 'CSS_SPCL_FCTR'          TO TABLE-4                  
P00680        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00680        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
P00680        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
P00680        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00680        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
P00680        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
P00680        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00680        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00680     END-IF.                                                      
P00680                                                                  
P00680 7250-EXIT.                                                       
P00680     EXIT.                                                        
P00680                                                                  
P805AP 7300-ADD-ROR-DAYS.                                               
P805AP                                                                  
P805AP     EXEC SQL                                                     
P805AP         SELECT
              DATEADD( DAY, -1, DATEADD( DAY, :WS-3DAY-ROR-DAYS, 
              IIF(TRY_CONVERT(DATE, :WS-COMMUNICATION-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMUNICATION-DT
              ) <> 0) OR (LEN(:WS-COMMUNICATION-DT
              ) <> 10), CIS.CHAR2DATE(:WS-COMMUNICATION-DT
              ), CONVERT(DATE, :WS-COMMUNICATION-DT) ) ) )
            INTO
              :WS-RESULT-DATE  
P805AP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-DATE = DATE(DATE(:WS-COMMUNICATION-DT)            
MFA-TR*                            + (:WS-3DAY-ROR-DAYS DAYS) - 1 DAY)          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P805AP        NEXT SENTENCE                                             
P805AP     ELSE                                                         
P805AP        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P805AP        MOVE '7300'                    TO ACTIVE-PARAGRAPH        
P805AP        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P805AP        MOVE 'SET '                    TO TABLE-1                 
P805AP        MOVE 'COMMUNICATION_DT'        TO TABLE-ELEMENT-1         
P805AP        MOVE 'ROR DAYS'                TO TABLE-ELEMENT-2         
P805AP        MOVE KO-COMMUNICATION-ID       TO HOSTVAR-ELEMENT-1       
P805AP        MOVE WS-3DAY-ROR-DAYS          TO HOSTVAR-ELEMENT-2       
P805AP        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P805AP        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 7300-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
P805AP 7350-GET-LATEST-LETTER-DATE.                                     
P805AP*                                                                 04500000
P805AP     EXEC SQL                                                     
P805AP        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), COALESCE(MAX(
           KO.COMMUNICATION_ID),                   
P805AP                      CIS.CHAR2TIMESTAMP(
              '1900-01-01-00.00.00.000000')), 121), ' ', '-'), ':', 
           '.')               
P805AP          INTO :KO-COMMUNICATION-ID                               
P805AP          FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED)                     
P805AP         WHERE KO.ACCOUNT_NO        = :KO-ACCOUNT-NO              
P805AP           AND KO.COMM_TYPE_CD      = :KO-COMM-TYPE-CD            
P805AP           AND KO.COMM_SUBTYPE_CODE = :KO-COMM-SUBTYPE-CODE       
P805AP                                                           
P805AP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04510000
MFA-TR*       SELECT IFNULL(MAX(KO.COMMUNICATION_ID),                   04520000
MFA-TR*                     '1900-01-01-00.00.00.000000')                       
MFA-TR*         INTO :KO-COMMUNICATION-ID                               04540000
MFA-TR*         FROM CSS_COMM_DATA KO                                   04560000
MFA-TR*        WHERE KO.ACCOUNT_NO        = :KO-ACCOUNT-NO              04580000
MFA-TR*          AND KO.COMM_TYPE_CD      = :KO-COMM-TYPE-CD            04590000
MFA-TR*          AND KO.COMM_SUBTYPE_CODE = :KO-COMM-SUBTYPE-CODE       04600000
MFA-TR*         WITH UR                                                 04660000
MFA-TR*    END-EXEC.                                                    04670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P805AP        NEXT SENTENCE                                             
P805AP     ELSE                                                         
P805AP        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P805AP        MOVE SQLCODE                TO ABEND-SQLCODE              
P805AP        MOVE '7350'                 TO ACTIVE-PARAGRAPH           
P805AP        MOVE 'SELECT'               TO ABEND-FUNCTION             
P805AP        MOVE 'CSS_COMM_DATA'        TO TABLE-1                    
P805AP        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
P805AP        MOVE 'COMM TYPE'            TO TABLE-ELEMENT-2            
P805AP        MOVE 'COMM SUB TYPE'        TO TABLE-ELEMENT-3            
P805AP        MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1          
P805AP        MOVE KO-COMM-TYPE-CD        TO HOSTVAR-ELEMENT-2          
P805AP        MOVE KO-COMM-SUBTYPE-CODE   TO HOSTVAR-ELEMENT-3          
P805AP        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P805AP        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 7350-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP*                                                                         
P805AP*                                                                 04480000
P805AP 7400-GET-ACCT-MKT-TIER-DATA.                                     
P805AP*                                                                 04500000
P805AP     EXEC SQL                                                     
P805AP        SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                               
P805AP          INTO :DD-TIER-ACCT-TYPE-CD                              
P805AP          FROM CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)                
P805AP         WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                   
P805AP           AND DD.COMPANY_NO   = '01'                             
P805AP           AND DD.EFF_START_DT =                                  
P805AP              (SELECT MAX(DD1.EFF_START_DT)                       
P805AP                 FROM CSS_ACCT_MKT_TIER DD1 WITH(READUNCOMMITTED)         
P805AP                WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)             
P805AP                                            
P805AP                                                           
P805AP                                                      
P805AP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04510000
MFA-TR*       SELECT DD.TIER_ACCT_TYPE_CD                               04520000
MFA-TR*         INTO :DD-TIER-ACCT-TYPE-CD                              04540000
MFA-TR*         FROM CSS_ACCT_MKT_TIER  DD                              04560000
MFA-TR*        WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                   04580000
MFA-TR*          AND DD.COMPANY_NO   = '01'                             04600000
MFA-TR*          AND DD.EFF_START_DT =                                  04610000
MFA-TR*             (SELECT MAX(DD1.EFF_START_DT)                       04620000
MFA-TR*                FROM CSS_ACCT_MKT_TIER DD1                       04630000
MFA-TR*               WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)             04640000
MFA-TR*       FETCH FIRST 1 ROW ONLY                                    04650000
MFA-TR*       WITH UR                                                   04660000
MFA-TR*       QUERYNO 7400                                              04660000
MFA-TR*    END-EXEC.                                                    04670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P805AP        NEXT SENTENCE                                             
P805AP     ELSE                                                         
P805AP        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P805AP        MOVE SQLCODE                TO ABEND-SQLCODE              
P805AP        MOVE '7400'                 TO ACTIVE-PARAGRAPH           
P805AP        MOVE 'SELECT'               TO ABEND-FUNCTION             
P805AP        MOVE 'CSS_ACCT_MKT_TIER'    TO TABLE-1                    
P805AP        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
P805AP        MOVE DD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
P805AP        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P805AP        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 7400-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP*                                                                 04920000
P805AP 7450-GET-ADV-PRICE-ATTR-DT.                                      
P805AP                                                                  
P805AP     EXEC SQL                                                     
P805AP        SELECT YP.ATTRIBUTE_VALUE_DT                              
P805AP          INTO :YP-ATTRIBUTE-VALUE-DT                             
P805AP          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P805AP         WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                
P805AP           AND YP.ATTRIBUTE_DESC  = 'ADVANCED PRICE'              
P805AP                                                           
P805AP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT YP.ATTRIBUTE_VALUE_DT                                      
MFA-TR*         INTO :YP-ATTRIBUTE-VALUE-DT                                     
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                        
MFA-TR*          AND YP.ATTRIBUTE_DESC  = 'ADVANCED PRICE'                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P805AP        NEXT SENTENCE                                             
P805AP     ELSE                                                         
P805AP        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
P805AP        MOVE SQLCODE                TO ABEND-SQLCODE              
P805AP        MOVE '7450'                 TO ACTIVE-PARAGRAPH           
P805AP        MOVE 'SELECT'               TO ABEND-FUNCTION             
P805AP        MOVE 'CSS_ACCT_ATTRIBUTE'   TO TABLE-1                    
P805AP        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
P805AP        MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1          
P805AP        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P805AP        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 7450-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
              ADD +1                    TO CTR-ROWS.                    
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    NAME & ADDRESS FORMAT COPYBOOK.                             *        
      ******************************************************************        
           EXEC SQL                                                     14994500
                INCLUDE CPD00074                                        14994600
           END-EXEC.                                                    14994700
                                                                        
           EXEC SQL                                                     14994500
                INCLUDE CPD00004                                        14994600
           END-EXEC.                                                    14994700
                                                                        
           EXEC SQL                                                     04490000
              INCLUDE CPD0023C                                          04490000
           END-EXEC.                                                    04490000
                                                                        
