       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04113.                                          
COB303 DATE-WRITTEN.      AUGUST 11, 2008.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS ORDERS FOR A GIVEN ACCOUNT FOR THE WEB. *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/11/08    FMB      NEW PROGRAM.                                      
A05317*  09/16/15    FMB      SIGNED IN CUSTOMER SHOULD NOT SEE                 
A05317*                       COMPLETED ORDERS FOR OTHER CUSTOMERS.             
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04113'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04113 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04113_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
           05  S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.           
           05  S-ASSIGNED-DATETIME    PIC X(26) VALUE SPACES.           
           05  S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.           
           05  S-RELEASE-IND          PIC X(01) VALUE SPACES.           
           05  S-COMPLETED-DATETIME   PIC X(26) VALUE SPACES.           
           05  S-ORDER-DESCRIPTION    PIC X(50) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-TABLES.                                                   
           05  WS-ORDER-TABLE          OCCURS 25 TIMES                  
                                       INDEXED BY T1-INDEX.             
               10 T1-SERV-ORDER-NO      PIC X(13) VALUE SPACES.         
               10 T1-ORDER-TYPE-CD      PIC X(05) VALUE SPACES.         
               10 T1-ASSIGNED-DATETIME  PIC X(26) VALUE SPACES.         
               10 T1-ACCOUNT-NO         PIC X(13) VALUE SPACES.         
               10 T1-ACCOUNT-NO-PRIOR   PIC X(13) VALUE SPACES.         
               10 T1-ORDER-STATE-CD     PIC X(01) VALUE SPACES.         
               10 T1-ORDER-REASON       PIC X(01) VALUE SPACES.         
               10 T1-RELEASE-IND        PIC X(01) VALUE SPACES.         
               10 T1-COMPLETED-DATETIME PIC X(26) VALUE SPACES.         
               10 T1-WORK-AREA-ID       PIC X(12) VALUE SPACES.         
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-SERV-ORDER-NO-NUM     PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    REDEFINES WS-SERV-ORDER-NO-NUM  
                                        PIC X(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04113'.     
           05  WS-NULL-DATE-1           PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-DATE-2           PIC S9(04) COMP VALUE ZERO.     
           05  WS-SUB1                  PIC S9(04) COMP VALUE ZERO.     
           05  WS-SUB2                  PIC S9(04) COMP VALUE ZERO.     
           05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-OFF-DESC              PIC X(50) VALUE                 
               'Request to stop service'.                               
           05  WS-ON-DESC               PIC X(50) VALUE                 
               'Request to start service'.                              
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE SO_CURSOR CURSOR FOR                             
                   SELECT SERV_ORDER_NO,                                
                          ORDER_TYPE_CD,                                
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                            
                          ACCOUNT_NO,                                   
                          ACCOUNT_NO_PRIOR,                             
                          ORDER_STATE_CD,                               
                          ORDER_REASON,                                 
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           COMPLETED_DATETIME, 121), ' ', '-'), ':', '.') 
           COMPLETED_DATETIME,                           
                          WORK_AREA_ID                                  
                     FROM CSS_SO_DATA                                   
                    WHERE PREMISE_NO = :VO-PREMISE-NO                   
                      AND (ORDER_TYPE_CD LIKE 'CC%'                     
                       OR  ORDER_TYPE_CD LIKE 'OFF%'                    
                       OR  ORDER_TYPE_CD = 'NC001')                     
                      AND NOT ORDER_STATE_CD = 'C'                      
                      AND NOT BACK_DATED_IND = 'Y'                      
                      AND (COMPLETED_DATETIME IS NULL                   
                       OR  COMPLETED_DATETIME > CIS.CHAR2TIMESTAMP(
                                                 :VO-COMPLETED-DATETIME
              )) 
                    ORDER BY ASSIGNED_DATETIME,                         
                             ORDER_TYPE_CD                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_CURSOR CURSOR FOR                                     
MFA-TR*            SELECT SERV_ORDER_NO,                                        
MFA-TR*                   ORDER_TYPE_CD,                                        
MFA-TR*                   ASSIGNED_DATETIME,                                    
MFA-TR*                   ACCOUNT_NO,                                           
MFA-TR*                   ACCOUNT_NO_PRIOR,                                     
MFA-TR*                   ORDER_STATE_CD,                                       
MFA-TR*                   ORDER_REASON,                                         
MFA-TR*                   COMPLETED_DATETIME,                                   
MFA-TR*                   WORK_AREA_ID                                          
MFA-TR*              FROM CSS_SO_DATA                                           
MFA-TR*             WHERE PREMISE_NO = :VO-PREMISE-NO                           
MFA-TR*               AND (ORDER_TYPE_CD LIKE 'CC%'                             
MFA-TR*                OR  ORDER_TYPE_CD LIKE 'OFF%'                            
MFA-TR*                OR  ORDER_TYPE_CD = 'NC001')                             
MFA-TR*               AND NOT ORDER_STATE_CD = 'C'                              
MFA-TR*               AND NOT BACK_DATED_IND = 'Y'                              
MFA-TR*               AND (COMPLETED_DATETIME IS NULL                           
MFA-TR*                OR  COMPLETED_DATETIME > :VO-COMPLETED-DATETIME)         
MFA-TR*             ORDER BY ASSIGNED_DATETIME,                                 
MFA-TR*                      ORDER_TYPE_CD                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      SERV_ORDER_NO       AS SERV_ORDER_NO,             
                      ORDER_TYPE_CD       AS ORDER_TYPE_CD,             
                      ASSIGNED_DATETIME   AS ASSIGNED_DATETIME,         
                      ORDER_STATE_CD      AS ORDER_STATE_CD,            
                      RELEASE_IND         AS RELEASE_IND,               
                      COMPLETED_DATETIME  AS COMPLETED_DATETIME,        
                      ORDER_DESCRIPTION   AS ORDER_DESCRIPTION          
                FROM #CSR04113_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               SERV_ORDER_NO       AS SERV_ORDER_NO,                     
MFA-TR*               ORDER_TYPE_CD       AS ORDER_TYPE_CD,                     
MFA-TR*               ASSIGNED_DATETIME   AS ASSIGNED_DATETIME,                 
MFA-TR*               ORDER_STATE_CD      AS ORDER_STATE_CD,                    
MFA-TR*               RELEASE_IND         AS RELEASE_IND,                       
MFA-TR*               COMPLETED_DATETIME  AS COMPLETED_DATETIME,                
MFA-TR*               ORDER_DESCRIPTION   AS ORDER_DESCRIPTION                  
MFA-TR*         FROM SESSION.CSR04113_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04113_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04113_R1
              (                                                          
               RETURN_CODE          INT,                            
               SERV_ORDER_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ASSIGNED_DATETIME CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RELEASE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               COMPLETED_DATETIME CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ORDER_DESCRIPTION CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04113_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
               END-IF
           END-IF.      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO            TO WS-ACCOUNT-NO-CHAR.       
           MOVE WS-ACCOUNT-NO-NUM          TO AT-ACCOUNT-NO.            
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, -30, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :VO-COMPLETED-DATETIME                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES (TIMESTAMP(CURRENT TIMESTAMP) - 30 DAYS)                  
MFA-TR*          INTO :VO-COMPLETED-DATETIME                                    
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-PREMISE     THRU 7000-EXIT.                 
           PERFORM 7100-OPEN-SO-CURSOR  THRU 7100-EXIT.                 
           PERFORM 2100-BUILD-TABLE     THRU 2100-EXIT VARYING          
               T1-INDEX FROM 1 BY 1 UNTIL                               
               T1-INDEX > 25 OR                                         
               WS-ACTIVE-RETURN-CODE = NOT-FOUND.                       
           PERFORM 7300-CLOSE-SO-CURSOR THRU 7300-EXIT.                 
                                                                        
           PERFORM 2200-CHAINING THRU 2200-EXIT VARYING                 
               WS-SUB1 FROM 1 BY 1 UNTIL                                
SCA006         WS-SUB1 > 25 OR 
               T1-SERV-ORDER-NO (WS-SUB1) <= SPACES.                            
                                                                        
           PERFORM 3000-ORDERS-TABLE THRU 3000-EXIT VARYING             
               T1-INDEX FROM 1 BY 1 UNTIL                               
SCA006         T1-INDEX > 25 OR 
               T1-SERV-ORDER-NO (T1-INDEX) <= SPACES.                           
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH SO_CURSOR                                          
               INTO :VO-SERV-ORDER-NO,                                  
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-ASSIGNED-DATETIME :WS-NULL-DATE-1,               
                    :VO-ACCOUNT-NO,                                     
                    :VO-ACCOUNT-NO-PRIOR,                               
                    :VO-ORDER-STATE-CD,                                 
                    :VO-ORDER-REASON,                                   
                    :VO-COMPLETED-DATETIME :WS-NULL-DATE-2,              
                    :VO-WORK-AREA-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-DATE-1 < 0                                
                       MOVE SPACES TO VO-ASSIGNED-DATETIME              
                   END-IF                                               
                   IF WS-NULL-DATE-2 < 0                                
                       MOVE SPACES TO VO-COMPLETED-DATETIME             
                   END-IF                                               
                   MOVE VO-SERV-ORDER-NO TO                             
                        T1-SERV-ORDER-NO (T1-INDEX)                     
                   MOVE VO-ORDER-TYPE-CD TO                             
                        T1-ORDER-TYPE-CD (T1-INDEX)                     
                   MOVE VO-ASSIGNED-DATETIME TO                         
                        T1-ASSIGNED-DATETIME (T1-INDEX)                 
                   MOVE VO-ACCOUNT-NO TO                                
                        T1-ACCOUNT-NO (T1-INDEX)                        
                   MOVE VO-ACCOUNT-NO-PRIOR TO                          
                        T1-ACCOUNT-NO-PRIOR (T1-INDEX)                  
                   MOVE VO-ORDER-STATE-CD TO                            
                        T1-ORDER-STATE-CD (T1-INDEX)                    
                   MOVE VO-ORDER-REASON TO                              
                        T1-ORDER-REASON (T1-INDEX)                      
                   MOVE VO-COMPLETED-DATETIME TO                        
                        T1-COMPLETED-DATETIME (T1-INDEX)                
                   MOVE VO-WORK-AREA-ID TO                              
                        T1-WORK-AREA-ID (T1-INDEX)                      
                   PERFORM 7400-ORDER-INSTRUCTIONS THRU 7400-EXIT       
               WHEN NOT-FOUND                                           
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '2100'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE VO-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2200-CHAINING.                                                   
                                                                        
           MOVE T1-ACCOUNT-NO (WS-SUB1) TO WS-ACCOUNT-NO.               
           COMPUTE WS-SUB2 = WS-SUB1 + 1.                               
           PERFORM UNTIL T1-SERV-ORDER-NO (WS-SUB2) <= SPACES OR        
               WS-SUB2 > 25                                             
                   MOVE WS-ACCOUNT-NO TO T1-ACCOUNT-NO-PRIOR (WS-SUB2)  
                   ADD +1 TO WS-SUB2                                    
           END-PERFORM.                                                 
                                                                        
       2200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3000-ORDERS-TABLE.                                               
                                                                        
A05317     IF LINK-ACCOUNT-NO NOT = T1-ACCOUNT-NO (T1-INDEX) AND        
A05317        T1-ORDER-STATE-CD (T1-INDEX) = 'Z'                        
A05317            GO TO 3000-EXIT
           END-IF.                                      
                                                                        
           IF LINK-ACCOUNT-NO = T1-ACCOUNT-NO (T1-INDEX) OR             
              LINK-ACCOUNT-NO = T1-ACCOUNT-NO-PRIOR (T1-INDEX)          
                  INITIALIZE GTT-RETURN-FIELDS                          
                  MOVE T1-SERV-ORDER-NO (T1-INDEX) TO S-SERV-ORDER-NO   
                  MOVE T1-ORDER-TYPE-CD (T1-INDEX) TO S-ORDER-TYPE-CD   
                  MOVE T1-ASSIGNED-DATETIME (T1-INDEX) TO               
                       S-ASSIGNED-DATETIME                              
                  IF T1-ORDER-STATE-CD (T1-INDEX) = 'H' AND             
                     T1-WORK-AREA-ID (T1-INDEX) (1:3) = 'ARO'           
                         MOVE 'A' TO S-ORDER-STATE-CD                   
                  ELSE                                                  
                      MOVE T1-ORDER-STATE-CD (T1-INDEX) TO              
                           S-ORDER-STATE-CD                             
                  END-IF                                                
                  MOVE T1-RELEASE-IND (T1-INDEX) TO S-RELEASE-IND       
                  MOVE T1-COMPLETED-DATETIME (T1-INDEX) TO              
                       S-COMPLETED-DATETIME                             
                  IF LINK-ACCOUNT-NO = T1-ACCOUNT-NO-PRIOR (T1-INDEX)   
                      MOVE WS-OFF-DESC TO S-ORDER-DESCRIPTION           
                  ELSE                                                  
                      MOVE WS-ON-DESC TO S-ORDER-DESCRIPTION            
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-GET-PREMISE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PREMISE_NO                                        
                 INTO :AT-PREMISE-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          INTO :AT-PREMISE-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-PREMISE-NO   TO VO-PREMISE-NO                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-SO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7100'             TO ACTIVE-PARAGRAPH          
                   MOVE 'OPEN'             TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE VO-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-CLOSE-SO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE SO_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7100'             TO ACTIVE-PARAGRAPH          
                   MOVE 'CLOSE'            TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE VO-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-ORDER-INSTRUCTIONS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VI-SERV-ORDER-NO                                 
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND HOLD_RELEASE = 'Y'                                
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VI-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                        
MFA-TR*           AND HOLD_RELEASE = 'Y'                                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO T1-RELEASE-IND (T1-INDEX)                
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO T1-RELEASE-IND (T1-INDEX)                
                   MOVE ZEROES TO SQLCODE                               
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04113_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04113_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04113_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04113_R1                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              ORDER_TYPE_CD,                                            
              ASSIGNED_DATETIME,                                        
              ORDER_STATE_CD,                                           
              RELEASE_IND,                                              
              COMPLETED_DATETIME,                                       
              ORDER_DESCRIPTION                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-SERV-ORDER-NO,                                        
               :S-ORDER-TYPE-CD,                                        
               :S-ASSIGNED-DATETIME,                                    
               :S-ORDER-STATE-CD,                                       
               :S-RELEASE-IND,                                          
               :S-COMPLETED-DATETIME,                                   
               :S-ORDER-DESCRIPTION                                     
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04113_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       ASSIGNED_DATETIME,                                                
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       RELEASE_IND,                                                      
MFA-TR*       COMPLETED_DATETIME,                                               
MFA-TR*       ORDER_DESCRIPTION                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-SERV-ORDER-NO,                                                
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ASSIGNED-DATETIME,                                            
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-RELEASE-IND,                                                  
MFA-TR*        :S-COMPLETED-DATETIME,                                           
MFA-TR*        :S-ORDER-DESCRIPTION                                             
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04113_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
