       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04112.                                          
COB303 DATE-WRITTEN.      JULY 16, 2008.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  BATCH SERVICE ORDER PROCESS TO TAKE ORDERS OFF OF THE HOLD    *        
      *  FOR PAYMENT STATUS.                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/16/08    FMB      NEW PROGRAM.                                      
A01225*  05/07/09    FMB      SPACE OUT VARCHAR BEFORE SELECT.                  
A01666*  09/30/09    FMB      INCLUDE PAID DEPOSITS.                            
A01899*  11/19/09    FMB      DEDUCT INSTALLMENT DEPOSIT AMOUNT FROM            
A01899*                       TOTAL.                                            
A02033*  01/12/10    FMB      THRESHOLD PROCESSING.                             
A04558*  07/02/13    FMB      DIRECTED PAYMENTS.                                
P00718*  08/21/14    VV       RESET PRINTED_IND FOR FM                          
ACT227*  08/03/16    TP7R341  REPLACE CSR00028 WITH CSR04675                    
ACT227*   A05460                                                                
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04112'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04112 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
A04558     EXEC SQL                                                             
A04558        INCLUDE TBARHDT                                                   
A04558     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04112_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04112'.     
           05  WS-CAT-464-SAME-DAY-01   PIC X(01) VALUE 'N'.            
           05  WS-CAT-464-SAME-DAY-26   PIC X(01) VALUE 'N'.            
           05  WS-CAT-464-PAST-DAY-01   PIC X(01) VALUE 'N'.            
           05  WS-CAT-464-PAST-DAY-26   PIC X(01) VALUE 'N'.            
           05  WS-ITERATION-STORAGE.                                    
COB305         10 WS-TOTAL-PAYMENTS        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.    
COB305         10 WS-TOTAL-CORRECTIONS        PIC S9(9)V9(2) 
COB305           USAGE COMP-3 VALUE 0.    
COB305         10 WS-TOTAL-RET-CHECK        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.    
               10 WS-SCHEDULED-DT       PIC X(10) VALUE SPACES.         
               10 WS-DEPOSIT-PAID-FL    PIC X(01) VALUE 'N'.            
               10 WS-INSTALLMENTS-FL    PIC X(01) VALUE 'N'.            
               10 WS-RETURN-CHECK-FL    PIC X(01) VALUE 'N'.            
               10 WS-REMARKS-FL         PIC X(01) VALUE 'N'.            
               10 WS-COUNT-DEPOSITS     PIC S9(4) COMP VALUE 0.         
               10 WS-AMT-INSTALL-DEP    PIC S9(7)V9(2) COMP-3 VALUE 0.  
               10 WS-SAME-DAY-ORDER     PIC X(01) VALUE 'N'.            
               10 WS-NULL1              PIC S9(04) COMP VALUE ZERO.     
               10 WS-NULL2              PIC S9(04) COMP VALUE ZERO.     
               10 WS-NULL3              PIC S9(04) COMP VALUE ZERO.     
               10 WS-NULL4              PIC S9(04) COMP VALUE ZERO.     
               10 WS-NULL5              PIC S9(04) COMP VALUE ZERO.     
A02033         10 WS-THRESHOLD          PIC S9(4)V9(5) COMP-3 VALUE +0. 
               10 WS-CUSTOMER-NO        PIC 9(10)  VALUE ZEROES.        
               10 WS-ACCOUNT-NO-NUM     PIC 9(13)  VALUE ZEROES.        
               10 WS-ACCOUNT-NO-CHAR    REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
               10 WS-REMARKS-TEXT-A.                                    
                  15 WS-REMARKS-TEXT-1  PIC X(54).                      
                  15 WS-REMARKS-TEXT-2  PIC X(210).                     
               10 WS-REMARKS-TEXT-B.                                    
                  15 WS-REMARKS-TEXT-3  PIC X(171).                     
                  15 WS-REMARKS-TEXT-4  PIC X(39).                      
           05  WS-WQ-COMMENTS-1.                                        
               10 WS-WQ-ACCOUNT         PIC X(16).                      
               10 F                     PIC X(78) VALUE                 
           ' PAYMENT MADE ON OR AFTER SCHEDULED DATE OF TURN ON ORDER. O        
      -    'RDER TURNED DOWN.'.                                                 
           05  WS-WQ-COMMENTS-2         PIC X(65)  VALUE                
           'DETERMINE IF MONEY SHOULD BE MOVED BETWEEN ACCOUNTS.'.      
           05  WS-CHANGE-REMARKS.                                       
               10  F                    PIC X(01)  VALUE '('.           
               10  WS-REMARKS-DATE      PIC X(10)  VALUE SPACES.        
               10  F                    PIC X(02)  VALUE ') '.          
               10  F                    PIC X(40)  VALUE                
                  'ORIG ORDER STATE CD - PAYMENT REQUIRED'.             
           05  WS-REMARKS-COMMENTS      PIC X(39) VALUE                 
                  '/PAYMENT MADE ON/AFTER SCHEDULED DATE'.              
A02033     05  WS-SCEG-THRESHOLD        PIC S9(4)V9(5) COMP-3 VALUE +0. 
A02033     05  WS-PSNC-THRESHOLD        PIC S9(4)V9(5) COMP-3 VALUE +0. 
                                                                        
      ******************************************************************        
      * CSR04070 - CHECK ALL ACCOUNTS FOR CUSTOMER AND SPOUSE          *        
      ******************************************************************        
                                                                        
       01  CSR04070-CALL-DATA.                                          
           03 CUSTOMER-NO-4070          PIC X(10) VALUE SPACES.         
           03 ACCOUNT-NO-4070           PIC X(13) VALUE SPACES.         
           03 COMPANY-NO-4070           PIC X(02) VALUE SPACES.         
                                                                        
       01  CSR04070-RETURN-DATA.                                        
           05  RETURN-CODE-4070      PIC S9(9)     COMP VALUE 0.        
           05  TOTAL-PAST-DUE-4070   PIC S9(09)V99 COMP-3 VALUE +0.     
           05  STD-LABOR-CHG-4070    PIC S9(07)V99 COMP-3 VALUE +0.     
           05  CIA-4070              PIC S9(09)V99 COMP-3 VALUE +0.     
           05  RELEASE-FL-4070       PIC X(1)      VALUE SPACES.        
                                                                        
      ******************************************************************        
ACT227* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT227 01  CSR04675-CALL-DATA.                                          
ACT227     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT227     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT227     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT227     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT227     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT227     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT227     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT227     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT227     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT227     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT227     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT227     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT227     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT227     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT227     05  COMMENTS-4675.                                           
ACT227        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT227        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT227     05  FREE-FORM-DATA-4675.                                     
ACT227        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT227        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT227     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT227 01  CSR04675-RETURN-DATA.                                        
ACT227     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT227     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) COMP.                 
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) COMP.                 
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) COMP.                 
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  WS-COMPRESSION-TABLES.                                       
           05  WS-EMB-INPUT.                                            
               10  WS-EMB-CHAR         PIC X(01)                        
                                       OCCURS 210 TIMES                 
                                       INDEXED BY WS-EMB-INDX.          
           05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +210.           
           05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.           
           05  WS-EMB-LAST-CHAR        PIC X(01).                       
           05  WS-CMP-TABLE.                                            
               10  WS-CMP-CHAR         PIC X(01)                        
                                       OCCURS 210 TIMES                 
                                       INDEXED BY WS-CMP-INDX.          
                                                                        
      *01 LOC4070 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
ACT227*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE SO_CURSOR CURSOR WITH HOLD FOR                   
                   SELECT VO.SERV_ORDER_NO,                             
                          VO.PREMISE_NO,                                
                          VO.ACCOUNT_NO,                                
                          AT.CUSTOMER_NO,                               
                          VO.COMPANY_NO,                                
                          AT.LOCAL_OFFICE,                              
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                        
                          VO.PREMISE_NO,                                
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VO.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                         
                          VO.ORDER_TYPE_CD,                             
                          VO.SERV_ORDER_STATUS,                         
                          VO.ORDER_STATE_CD,                            
                          VO.COMPANY_NO,                                
                          VO.ORDER_RECVED_BY                            
                     FROM CSS_SO_DATA VO,                               
                          CSS_ACCOUNT AT                                
                    WHERE ORDER_STATE_CD = 'R'                          
                      AND VO.ACCOUNT_NO = AT.ACCOUNT_NO                 
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_CURSOR CURSOR WITH HOLD FOR                           
MFA-TR*            SELECT VO.SERV_ORDER_NO,                                     
MFA-TR*                   VO.PREMISE_NO,                                        
MFA-TR*                   VO.ACCOUNT_NO,                                        
MFA-TR*                   AT.CUSTOMER_NO,                                       
MFA-TR*                   VO.COMPANY_NO,                                        
MFA-TR*                   AT.LOCAL_OFFICE,                                      
MFA-TR*                   VO.WANTED_BY_DATETIME,                                
MFA-TR*                   VO.PREMISE_NO,                                        
MFA-TR*                   VO.ASSIGNED_DATETIME,                                 
MFA-TR*                   VO.ORDER_TYPE_CD,                                     
MFA-TR*                   VO.SERV_ORDER_STATUS,                                 
MFA-TR*                   VO.ORDER_STATE_CD,                                    
MFA-TR*                   VO.COMPANY_NO,                                        
MFA-TR*                   VO.ORDER_RECVED_BY                                    
MFA-TR*              FROM CSS_SO_DATA VO,                                       
MFA-TR*                   CSS_ACCOUNT AT                                        
MFA-TR*             WHERE ORDER_STATE_CD = 'R'                                  
MFA-TR*               AND VO.ACCOUNT_NO = AT.ACCOUNT_NO                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4070 CURSOR
MSQ001          FOR CALL CSR04070                                             
                  ( :CUSTOMER-NO-4070
                  , :ACCOUNT-NO-4070
                  , :COMPANY-NO-4070
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT227            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE        AS RETURN_CODE              
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE        AS RETURN_CODE                      
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE '/' TO WS-REMARKS-DATE(3:1)                             
                       WS-REMARKS-DATE(6:1).                            
           MOVE WS-CURRENT-DATE(1:4) TO WS-REMARKS-DATE(7:4).           
           MOVE WS-CURRENT-DATE(6:2) TO WS-REMARKS-DATE(1:2).           
           MOVE WS-CURRENT-DATE(9:2) TO WS-REMARKS-DATE(4:2).           
                                                                        
           PERFORM 7500-SELECT-DELINQUENCY THRU 7500-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 7000-OPEN-SO-CURSOR THRU 7000-EXIT.                  
           PERFORM 1500-FETCH-ORDERS THRU 1500-EXIT.                    
           PERFORM 7100-CLOSE-SO-CURSOR THRU 7100-EXIT.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1500-FETCH-ORDERS.                                               
                                                                        
           EXEC SQL                                                     
               FETCH SO_CURSOR                                          
               INTO :VO-SERV-ORDER-NO,                                  
                    :VO-PREMISE-NO,                                     
                    :VO-ACCOUNT-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :VO-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :VO-WANTED-BY-DATETIME,                             
                    :VO-PREMISE-NO,                                     
                    :VO-ASSIGNED-DATETIME,                              
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-SERV-ORDER-STATUS,                              
                    :VO-ORDER-STATE-CD,                                 
                    :VO-COMPANY-NO,                                     
                    :VO-ORDER-RECVED-BY                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 2100-PROCESS-ORDER THRU 2100-EXIT            
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 1500-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '1500'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'FETCH'                  TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO_DATA'            TO TABLE-1             
                   MOVE 'CSS_ACCOUNT'            TO TABLE-2             
                   MOVE 'ORDER_STATE_CD'         TO TABLE-ELEMENT-1     
                   MOVE 'R'                      TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           GO TO 1500-FETCH-ORDERS.                                     
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                 
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       2100-PROCESS-ORDER.                                              
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           MOVE VO-ACCOUNT-NO TO DO-ACCOUNT-NO.                         
           MOVE VO-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM.                     
           MOVE WS-ACCOUNT-NO-CHAR(1:1) TO WS-WQ-ACCOUNT(1:1).          
           MOVE WS-ACCOUNT-NO-CHAR(2:4) TO WS-WQ-ACCOUNT(3:4).          
           MOVE WS-ACCOUNT-NO-CHAR(6:4) TO WS-WQ-ACCOUNT(8:4).          
           MOVE WS-ACCOUNT-NO-CHAR(10:4) TO WS-WQ-ACCOUNT(13:4).        
           MOVE '-' TO WS-WQ-ACCOUNT(2:1)                               
                       WS-WQ-ACCOUNT(7:1)                               
                       WS-WQ-ACCOUNT(12:1).                             
           PERFORM 7150-CHECK-INSTALLMENTS THRU 7150-EXIT.              
           IF WS-INSTALLMENTS-FL = 'Y'                                  
               PERFORM 7700-COUNT-DEPOSITS THRU 7700-EXIT               
A01899         PERFORM 7750-SUM-INSTALL-DEP THRU 7750-EXIT
           END-IF.             
           MOVE VO-ACCOUNT-NO TO NH-ACCOUNT-NO.                         
           PERFORM 7800-RETURN-CHECK THRU 7800-EXIT.                    
           IF WS-RETURN-CHECK-FL = 'Y'                                  
               GO TO 2100-EXIT
           END-IF.                                         
           PERFORM 7200-DEP-ON-HAND THRU 7200-EXIT.                     
           IF WS-DEPOSIT-PAID-FL = 'N'                                  
               PERFORM 2200-COMPARE-PAYMENTS-BALANCE THRU 2200-EXIT
           END-IF.    
           PERFORM 3100-CALL-CSR04070 THRU 3100-EXIT.                   
           EVALUATE RELEASE-FL-4070                                     
               WHEN ' '                                                 
               WHEN 'N'                                                 
                   CONTINUE                                             
               WHEN 'Y'                                                 
                   IF WS-DEPOSIT-PAID-FL = 'Y' OR                       
                      WS-INSTALLMENTS-FL = 'Y'                          
                         IF CIA-4070 > 0                                
                             PERFORM 2300-MOVE-MONEY-WQ THRU 2300-EXIT  
                         END-IF                                         
                         PERFORM 2500-UPDATE-PROCESSING THRU 2500-EXIT  
                   ELSE                                                 
      *                IF CIA-4070 >= AC-AMT-TRAN-BALANCE                       
                       IF CIA-4070 >= DO-AMT-DEPOSIT                    
                           PERFORM 2300-MOVE-MONEY-WQ THRU 2300-EXIT    
                           PERFORM 2500-UPDATE-PROCESSING THRU          
                                   2500-EXIT                            
                       END-IF                                           
                   END-IF                                               
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-COMPARE-PAYMENTS-BALANCE.                                   
                                                                        
           MOVE VO-ACCOUNT-NO TO AR-ACCOUNT-NO.                         
           PERFORM 7300-AR-TRANS-HIST THRU 7300-EXIT.                   
                                                                        
           MOVE VO-ACCOUNT-NO TO AC-ACCOUNT-NO.                         
           PERFORM 7400-AR-CNTL THRU 7400-EXIT.                         
                                                                        
           MOVE VO-ACCOUNT-NO TO DO-ACCOUNT-NO.                         
           PERFORM 7600-DEP-ON-HAND THRU 7600-EXIT.                     
A01899     COMPUTE DO-AMT-DEPOSIT =                                     
A01899             DO-AMT-DEPOSIT -                                     
A01899             WS-AMT-INSTALL-DEP.                                  
                                                                        
      *    IF AR-AMT-ORIG-ENTERED >= AC-AMT-TRAN-BALANCE                        
      *        MOVE 'Y' TO WS-DEPOSIT-PAID-FL.                                  
                                                                        
A02033     IF VO-COMPANY-NO = '01'                                      
A02033         MOVE WS-SCEG-THRESHOLD TO WS-THRESHOLD                   
A02033     ELSE                                                         
A02033         MOVE WS-PSNC-THRESHOLD TO WS-THRESHOLD
           END-IF.                  
                                                                        
A02033     IF AR-AMT-ORIG-ENTERED + WS-THRESHOLD >= DO-AMT-DEPOSIT      
               MOVE 'Y' TO WS-DEPOSIT-PAID-FL
           END-IF.                          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-MOVE-MONEY-WQ.                                              
                                                                        
           IF VO-ORDER-RECVED-BY = 'SYSTEM' OR 'WEBTRN1'                
               CONTINUE                                                 
           ELSE                                                         
ACT227         MOVE '3' TO ROUTING-CATEGORY-4675                        
ACT227         MOVE 463 TO CATEGORY-ID-4675                             
ACT227         MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT              
ACT227         MOVE 65 TO COMMENTS-4675-LEN                             
ACT227         MOVE 'H' TO WQ-PRIORITY-4675                             
ACT227         MOVE VO-ORDER-RECVED-BY TO USER-ID-ASGN-4675             
ACT227         PERFORM 3200-CALL-CSR04675 THRU 3200-EXIT
           END-IF.               
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-SCHEDULED-DT-WQ.                                            
                                                                        
ACT227     MOVE '5' TO ROUTING-CATEGORY-4675.                           
ACT227     MOVE 464 TO CATEGORY-ID-4675.                                
ACT227     MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT                  
ACT227     MOVE 100 TO COMMENTS-4675-LEN.                               
ACT227     MOVE 'H' TO WQ-PRIORITY-4675.                                
ACT227     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT227     PERFORM 3200-CALL-CSR04675 THRU 3200-EXIT.                   
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-UPDATE-PROCESSING.                                          
                                                                        
           MOVE VO-ASSIGNED-DATETIME(1:10) TO WS-SCHEDULED-DT.          
           IF WS-SCHEDULED-DT <= WS-CURRENT-DATE                        
               IF WS-SCHEDULED-DT = WS-CURRENT-DATE                     
                   MOVE 'Y' TO WS-SAME-DAY-ORDER                        
               END-IF                                                   
               PERFORM 2600-PAYMENT-TOO-LATE THRU 2600-EXIT             
           ELSE                                                         
               PERFORM 2700-RELEASE-ORDER THRU 2700-EXIT
           END-IF.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-PAYMENT-TOO-LATE.                                           
                                                                        
           IF WS-SAME-DAY-ORDER = 'Y'                                   
               IF (VO-COMPANY-NO = '01' AND                             
                   WS-CAT-464-SAME-DAY-01 = 'Y') OR                     
                  (VO-COMPANY-NO = '26' AND                             
                   WS-CAT-464-SAME-DAY-26 = 'Y')                        
                       PERFORM 2400-SCHEDULED-DT-WQ THRU 2400-EXIT      
               END-IF                                                   
           ELSE                                                         
               IF (VO-COMPANY-NO = '01' AND                             
                   WS-CAT-464-PAST-DAY-01 = 'Y') OR                     
                  (VO-COMPANY-NO = '26' AND                             
                   WS-CAT-464-PAST-DAY-26 = 'Y')                        
                       PERFORM 2400-SCHEDULED-DT-WQ THRU 2400-EXIT
               END-IF
           END-IF.     
                                                                        
           MOVE 'D' TO VO-ORDER-STATE-CD.                               
           PERFORM 8600-UPDATE-STATE THRU 8600-EXIT.                    
           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                
P00718     PERFORM 8800-UPDATE-PRINT-IND THRU 8800-EXIT.                
                                                                        
           MOVE 'N' TO WS-REMARKS-FL.                                   
           MOVE 'G' TO EF-REMARK-TYPE-CD.                               
           PERFORM 7900-SELECT-REMARKS THRU 7900-EXIT.                  
           IF WS-REMARKS-FL = 'N'                                       
               MOVE WS-REMARKS-COMMENTS TO EF-REMARK-TX-TEXT            
               MOVE 37 TO EF-REMARK-TX-LEN                              
               MOVE 'G' TO EF-REMARK-TYPE-CD                            
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT               
           ELSE                                                         
               MOVE EF-REMARK-TX-TEXT TO WS-REMARKS-TEXT-3              
               MOVE WS-REMARKS-COMMENTS TO WS-REMARKS-TEXT-4            
               INSPECT WS-REMARKS-TEXT-B REPLACING ALL                  
                   LOW-VALUES BY SPACES                                 
               MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE                 
               MOVE WS-REMARKS-TEXT-B TO WS-EMB-INPUT                   
               PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT       
               MOVE WS-CMP-TABLE TO EF-REMARK-TX-TEXT                   
               COMPUTE EF-REMARK-TX-LEN =                               
                       EF-REMARK-TX-LEN + 39                            
               END-COMPUTE                                              
               IF EF-REMARK-TX-LEN > +210                               
                   MOVE +210 TO EF-REMARK-TX-LEN                        
               END-IF                                                   
               MOVE 'G' TO EF-REMARK-TYPE-CD                            
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2700-RELEASE-ORDER.                                              
                                                                        
           MOVE 'A' TO VO-ORDER-STATE-CD.                               
           PERFORM 8600-UPDATE-STATE THRU 8600-EXIT.                    
           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                
P00718     PERFORM 8800-UPDATE-PRINT-IND THRU 8800-EXIT.                
                                                                        
           MOVE 'N' TO WS-REMARKS-FL.                                   
           MOVE 'E' TO EF-REMARK-TYPE-CD.                               
           PERFORM 7900-SELECT-REMARKS THRU 7900-EXIT.                  
           IF WS-REMARKS-FL = 'N'                                       
               MOVE WS-CHANGE-REMARKS TO EF-REMARK-TX-TEXT              
               MOVE 60 TO EF-REMARK-TX-LEN                              
               MOVE 'E' TO EF-REMARK-TYPE-CD                            
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT               
           ELSE                                                         
               MOVE WS-CHANGE-REMARKS TO WS-REMARKS-TEXT-1              
               MOVE EF-REMARK-TX-TEXT TO WS-REMARKS-TEXT-2              
               MOVE WS-REMARKS-TEXT-A TO EF-REMARK-TX-TEXT              
               COMPUTE EF-REMARK-TX-LEN =                               
                       EF-REMARK-TX-LEN + 53                            
               END-COMPUTE                                              
               IF EF-REMARK-TX-LEN > +210                               
                   MOVE +210 TO EF-REMARK-TX-LEN                        
               END-IF                                                   
               MOVE 'E' TO EF-REMARK-TYPE-CD                            
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-CALL-CSR04070.                                              
                                                                        
           MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO.                       
           MOVE WS-CUSTOMER-NO TO CUSTOMER-NO-4070.                     
           MOVE VO-ACCOUNT-NO TO WS-ACCOUNT-NO-NUM.                     
           MOVE WS-ACCOUNT-NO-CHAR TO ACCOUNT-NO-4070.                  
           MOVE VO-COMPANY-NO TO COMPANY-NO-4070.                       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04070                                             
      *           (:CUSTOMER-NO-4070,                                   
      *            :ACCOUNT-NO-4070,                                    
      *            :COMPANY-NO-4070)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4070
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4070
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4070 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04070'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE VO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-3             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4070)                                                
      *       WITH PROCEDURE CSR04070                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4070 CURSOR FOR RESULT SET        
      *       :LOC4070                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4070 INTO                            
                 :RETURN-CODE-4070,                                     
                 :TOTAL-PAST-DUE-4070,                                  
                 :STD-LABOR-CHG-4070,                                   
                 :CIA-4070,                                             
                 :RELEASE-FL-4070                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4070 NOT = 0                          
                       MOVE RETURN-CODE-4070 TO WS-ACTIVE-RETURN-CODE   
                       MOVE PROGRAM-NAME        TO ABEND-PROGRAM        
                       MOVE '3100'              TO ACTIVE-PARAGRAPH     
                       MOVE 'FETCH'             TO ABEND-FUNCTION       
                       MOVE 'CSR04070'          TO TABLE-1              
                       MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1      
                       MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1    
                       MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-2      
                       MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2    
                       MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-3      
                       MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-3    
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   COMPUTE CIA-4070 = CIA-4070 * -1                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
                   MOVE '3100'                  TO ACTIVE-PARAGRAPH     
                   MOVE 'FETCH'                 TO ABEND-FUNCTION       
                   MOVE 'CSR04070'              TO TABLE-1              
                   MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1      
                   MOVE VO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
                   MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-2      
                   MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-2    
                   MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-3      
                   MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-3    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
ACT227**  CALL CSR04675 TO INSERT A WQ.                             **          
      ****************************************************************          
                                                                        
ACT227 3200-CALL-CSR04675.                                              
                                                                        
ACT227     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT227     MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT227     MOVE 'SYSTEM' TO USER-ID-ORIG-4675.                          
ACT227     MOVE SPACES TO RESP-AREA-ID-4675                             
ACT227                    DATE-REQUIRED-4675                            
ACT227                    DATE-CREATED-4675                             
ACT227                    FREE-FORM-DATA-4675-TEXT.                     
ACT227     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT227     MOVE VO-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
ACT227     MOVE VO-PREMISE-NO TO PREMISE-NO-4675.                       
ACT227     MOVE AT-CUSTOMER-NO TO CUSTOMER-NO-4675.                     
ACT227     MOVE VO-SERV-ORDER-NO TO SERV-ORDER-NO-4675.                 
ACT227     MOVE 'CSR04112' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT227*       CALL CSR04675                                             
ACT227*           (:IN-ITEM-ID-4675,                                    
ACT227*            :ROUTING-CATEGORY-4675,                              
ACT227*            :LOCAL-OFFICE-4675,                                  
ACT227*            :USER-ID-ORIG-4675,                                  
ACT227*            :USER-ID-ASGN-4675,                                  
ACT227*            :RESP-AREA-ID-4675,                                  
ACT227*            :CATEGORY-ID-4675,                                   
ACT227*            :ACCOUNT-NO-4675,                                    
ACT227*            :PREMISE-NO-4675,                                    
ACT227*            :CUSTOMER-NO-4675,                                   
ACT227*            :SERV-ORDER-NO-4675,                                 
ACT227*            :COMMENTS-4675,                                      
ACT227*            :DATE-REQUIRED-4675,                                 
ACT227*            :DATE-CREATED-4675,                                  
ACT227*            :WQ-PRIORITY-4675,                                   
ACT227*            :FREE-FORM-DATA-4675,                                
ACT227*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT227        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT227        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT227        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT227*       (:LOC4675)                                                
ACT227*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT227*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT227*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT227        FETCH RESULT_SET_CSR_4675 INTO                            
ACT227           :RETURN-CODE-4675,                                     
ACT227           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT227             IF RETURN-CODE-4675 NOT = 0                          
ACT227                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT227                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT227                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT227                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT227             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT227             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT227             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6000-REDUCE-EMBEDDED-SPACES.                                     
                                                                        
           MOVE 210 TO WS-EMB-TBL-LENG.                                 
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
           MOVE SPACE TO WS-EMB-LAST-CHAR.                              
           IF WS-EMB-LENG NUMERIC AND                                   
              WS-EMB-LENG > ZERO AND                                    
              WS-EMB-LENG < WS-EMB-TBL-LENG                             
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG TO WS-EMB-LENG
           END-IF.                     
           PERFORM 6010-COMPRESSION-ROUTINE THRU 6010-EXIT              
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX > WS-EMB-LENG.                         
           MOVE ZERO TO WS-EMB-LENG.                                    
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6010-COMPRESSION-ROUTINE.                                        
                                                                        
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE AND                 
              WS-EMB-LAST-CHAR                                          
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                        
                    WS-CMP-CHAR (WS-CMP-INDX)                           
                    WS-EMB-LAST-CHAR                                    
                SET WS-CMP-INDX UP BY 1
           END-IF.                                
                                                                        
       6010-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-OPEN-SO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'CSS_ACCOUNT'           TO TABLE-2                  
               MOVE 'ORDER_STATE_CD'        TO TABLE-ELEMENT-1          
               MOVE 'R'                     TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CLOSE-SO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE SO_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7170'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'CSS_ACCOUNT'           TO TABLE-2                  
               MOVE 'ORDER_STATE_CD'        TO TABLE-ELEMENT-1          
               MOVE 'R'                     TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-CHECK-INSTALLMENTS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DEP_BILL_OPTION_CD                                
                 INTO :DR-DEP-BILL-OPTION-CD                            
                 FROM CSS_DEP_ON_HAND D1,                               
                      CSS_DEP_REQ DR                                    
                WHERE D1.ACCOUNT_NO = :DO-ACCOUNT-NO                    
                  AND D1.ACCOUNT_NO = DR.ACCOUNT_NO                     
                  AND DEPOSIT_STATUS_CD = 'A'                           
                  AND DEP_BILL_OPTION_CD = 'T'                          
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEP_BILL_OPTION_CD                                        
MFA-TR*          INTO :DR-DEP-BILL-OPTION-CD                                    
MFA-TR*          FROM CSS_DEP_ON_HAND D1,                                       
MFA-TR*               CSS_DEP_REQ DR                                            
MFA-TR*         WHERE D1.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*           AND D1.ACCOUNT_NO = DR.ACCOUNT_NO                             
MFA-TR*           AND DEPOSIT_STATUS_CD = 'A'                                   
MFA-TR*           AND DEP_BILL_OPTION_CD = 'T'                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-INSTALLMENTS-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-INSTALLMENTS-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7150'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
                   MOVE 'CSS_DEP_REQ'            TO TABLE-2             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-DEP-ON-HAND.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DEPOSIT_STATUS_CD                                 
                 INTO :DO-DEPOSIT-STATUS-CD                             
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                       
                  AND DEPOSIT_STATUS_CD NOT IN ('P', 'R', 'T')          
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEPOSIT_STATUS_CD                                         
MFA-TR*          INTO :DO-DEPOSIT-STATUS-CD                                     
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD NOT IN ('P', 'R', 'T')                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO WS-DEPOSIT-PAID-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO WS-DEPOSIT-PAID-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7200'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-AR-TRANS-HIST.                                              
                                                                        
           EXEC SQL                                                     
A04558         SELECT SUM(AMT_POSTED)                                   
                 INTO :WS-TOTAL-PAYMENTS :WS-NULL1                       
                 FROM CSS_AR_TRANS_HIST AR,                             
A04558                CSS_AR_TRN_HST_DET AU                             
                WHERE AR.ACCOUNT_NO = :AR-ACCOUNT-NO                    
                  AND CODE_TRAN_TYPE = 'P'                              
A04558            AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                     
A04558            AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO       
A04558            AND GL_ACCT_CREDIT = 142.0800                         
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_POSTED)                                           
MFA-TR*          INTO :WS-TOTAL-PAYMENTS:WS-NULL1                               
MFA-TR*          FROM CSS_AR_TRANS_HIST AR,                                     
MFA-TR*               CSS_AR_TRN_HST_DET AU                                     
MFA-TR*         WHERE AR.ACCOUNT_NO = :AR-ACCOUNT-NO                            
MFA-TR*           AND CODE_TRAN_TYPE = 'P'                                      
MFA-TR*           AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                             
MFA-TR*           AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO               
MFA-TR*           AND GL_ACCT_CREDIT = 142.0800                                 
MFA-TR*         QUERYNO 73001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE 0.0 TO WS-TOTAL-PAYMENTS                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO WS-TOTAL-PAYMENTS                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7300'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT1'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
A04558         SELECT SUM(AMT_POSTED)                                   
                 INTO :WS-TOTAL-CORRECTIONS :WS-NULL4                    
                 FROM CSS_AR_TRANS_HIST AR,                             
A04558                CSS_AR_TRN_HST_DET AU                             
                WHERE AR.ACCOUNT_NO = :AR-ACCOUNT-NO                    
                  AND CODE_TRAN_TYPE = 'C'                              
A04558            AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                     
A04558            AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO       
A04558            AND GL_ACCT_DEBIT = 142.0800                          
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_POSTED)                                           
MFA-TR*          INTO :WS-TOTAL-CORRECTIONS:WS-NULL4                            
MFA-TR*          FROM CSS_AR_TRANS_HIST AR,                                     
MFA-TR*               CSS_AR_TRN_HST_DET AU                                     
MFA-TR*         WHERE AR.ACCOUNT_NO = :AR-ACCOUNT-NO                            
MFA-TR*           AND CODE_TRAN_TYPE = 'C'                                      
MFA-TR*           AND AR.ACCOUNT_NO = AU.ACCOUNT_NO                             
MFA-TR*           AND AR.TRANS_HIST_SEQ_NO = AU.TRANS_HIST_SEQ_NO               
MFA-TR*           AND GL_ACCT_DEBIT = 142.0800                                  
MFA-TR*         QUERYNO 73002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL4 < 0                                      
                       MOVE 0.0 TO WS-TOTAL-CORRECTIONS                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO WS-TOTAL-CORRECTIONS                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7300'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT2'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_AR_TRANS_HIST'      TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           COMPUTE AR-AMT-ORIG-ENTERED =                                
                   WS-TOTAL-PAYMENTS -                                  
                   WS-TOTAL-CORRECTIONS.                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-AR-CNTL.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_TRAN_BALANCE)                             
                 INTO :AC-AMT-TRAN-BALANCE :WS-NULL2                     
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL = 80                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRAN_BALANCE)                                     
MFA-TR*          INTO :AC-AMT-TRAN-BALANCE:WS-NULL2                             
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL = 80                                    
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL2 < 0                                      
                       MOVE 0.0 TO AC-AMT-TRAN-BALANCE                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO AC-AMT-TRAN-BALANCE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7400'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_AR_CNTL'            TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-SELECT-DELINQUENCY.                                         
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY                                   
                WHERE DELINQ_CD = 'CAT-464-WQ-SAME-DAY'                 
                  AND COMPANY_NO = '01'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = 'CAT-464-WQ-SAME-DAY'                         
MFA-TR*           AND COMPANY_NO = '01'                                         
MFA-TR*         QUERYNO 75001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF C8-DELINQ-VALUE = 1                               
                       MOVE 'Y' TO WS-CAT-464-SAME-DAY-01               
                   ELSE                                                 
                       MOVE 'N' TO WS-CAT-464-SAME-DAY-01               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CAT-464-SAME-DAY-01                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7500'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT1'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
                   MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
                   MOVE 'CAT-464-WQ-SAME-DAY'    TO HOSTVAR-ELEMENT-1   
                   MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
                   MOVE '01'                     TO HOSTVAR-ELEMENT-2   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY                                   
                WHERE DELINQ_CD = 'CAT-464-WQ-SAME-DAY'                 
                  AND COMPANY_NO = '26'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = 'CAT-464-WQ-SAME-DAY'                         
MFA-TR*           AND COMPANY_NO = '26'                                         
MFA-TR*         QUERYNO 75002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF C8-DELINQ-VALUE = 1                               
                       MOVE 'Y' TO WS-CAT-464-SAME-DAY-26               
                   ELSE                                                 
                       MOVE 'N' TO WS-CAT-464-SAME-DAY-26               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CAT-464-SAME-DAY-26                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7500'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT2'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
                   MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
                   MOVE 'CAT-464-WQ-SAME-DAY'    TO HOSTVAR-ELEMENT-1   
                   MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
                   MOVE '26'                     TO HOSTVAR-ELEMENT-2   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY                                   
                WHERE DELINQ_CD = 'CAT-464-WQ-PAST-DAY'                 
                  AND COMPANY_NO = '01'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = 'CAT-464-WQ-PAST-DAY'                         
MFA-TR*           AND COMPANY_NO = '01'                                         
MFA-TR*         QUERYNO 75003                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF C8-DELINQ-VALUE = 1                               
                       MOVE 'Y' TO WS-CAT-464-PAST-DAY-01               
                   ELSE                                                 
                       MOVE 'N' TO WS-CAT-464-PAST-DAY-01               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CAT-464-PAST-DAY-01                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7500'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT3'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
                   MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
                   MOVE 'CAT-464-WQ-PAST-DAY'    TO HOSTVAR-ELEMENT-1   
                   MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
                   MOVE '01'                     TO HOSTVAR-ELEMENT-2   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY                                   
                WHERE DELINQ_CD = 'CAT-464-WQ-PAST-DAY'                 
                  AND COMPANY_NO = '26'                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = 'CAT-464-WQ-PAST-DAY'                         
MFA-TR*           AND COMPANY_NO = '26'                                         
MFA-TR*         QUERYNO 75004                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF C8-DELINQ-VALUE = 1                               
                       MOVE 'Y' TO WS-CAT-464-PAST-DAY-26               
                   ELSE                                                 
                       MOVE 'N' TO WS-CAT-464-PAST-DAY-26               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CAT-464-PAST-DAY-26                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7500'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT4'                TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
                   MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
                   MOVE 'CAT-464-WQ-PAST-DAY'    TO HOSTVAR-ELEMENT-1   
                   MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
                   MOVE '26'                     TO HOSTVAR-ELEMENT-2   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A02033     EXEC SQL                                                     
A02033        SELECT C8.DELINQ_VALUE                                    
A02033          INTO :WS-SCEG-THRESHOLD                                 
A02033          FROM CSS_DELINQUENCY C8                                 
A02033         WHERE C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'            
A02033           AND C8.COMPANY_NO  = '01'                              
A02033     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02033                                                                  
A02033     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02033     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02033         WHEN SUCCESSFUL-CALL                                     
A02033             CONTINUE                                             
A02033         WHEN NOT-FOUND                                           
A02033             MOVE 0.00 TO WS-SCEG-THRESHOLD                       
A02033         WHEN OTHER                                               
A02033             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
A02033             MOVE '7500'                   TO ACTIVE-PARAGRAPH    
A02033             MOVE 'SELECT5'                TO ABEND-FUNCTION      
A02033             MOVE SPACES                   TO ABEND-SQL-PREDICATES
A02033                                             ABEND-TABLES         
A02033             MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
A02033             MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
A02033             MOVE 'AMT-STRTUP-THRESHOLD'   TO HOSTVAR-ELEMENT-1   
A02033             MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
A02033             MOVE '01'                     TO HOSTVAR-ELEMENT-2   
A02033             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A02033             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A02033     END-EVALUATE.                                                
A02033                                                                  
A02033     EXEC SQL                                                     
A02033        SELECT C8.DELINQ_VALUE                                    
A02033          INTO :WS-PSNC-THRESHOLD                                 
A02033          FROM CSS_DELINQUENCY C8                                 
A02033         WHERE C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'            
A02033           AND C8.COMPANY_NO  = '26'                              
A02033     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02033                                                                  
A02033     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02033     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02033         WHEN SUCCESSFUL-CALL                                     
A02033             CONTINUE                                             
A02033         WHEN NOT-FOUND                                           
A02033             MOVE 0.00 TO WS-PSNC-THRESHOLD                       
A02033         WHEN OTHER                                               
A02033             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
A02033             MOVE '7500'                   TO ACTIVE-PARAGRAPH    
A02033             MOVE 'SELECT6'                TO ABEND-FUNCTION      
A02033             MOVE SPACES                   TO ABEND-SQL-PREDICATES
A02033                                             ABEND-TABLES         
A02033             MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
A02033             MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
A02033             MOVE 'AMT-STRTUP-THRESHOLD'   TO HOSTVAR-ELEMENT-1   
A02033             MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
A02033             MOVE '26'                     TO HOSTVAR-ELEMENT-2   
A02033             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A02033             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A02033     END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-DEP-ON-HAND.                                                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :DO-AMT-DEPOSIT :WS-NULL3                          
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                       
A01666            AND DEPOSIT_STATUS_CD NOT IN ('R', 'T')               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :DO-AMT-DEPOSIT:WS-NULL3                                  
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD NOT IN ('R', 'T')                       
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL3 < 0                                      
                       MOVE 0.0 TO DO-AMT-DEPOSIT                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0.0 TO DO-AMT-DEPOSIT                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7600'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-COUNT-DEPOSITS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-DEPOSITS                                
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                       
                  AND DEPOSIT_STATUS_CD NOT IN ('P', 'R', 'T')          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-DEPOSITS                                        
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD NOT IN ('P', 'R', 'T')                  
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-COUNT-DEPOSITS > 1                             
                       MOVE 'N' TO WS-INSTALLMENTS-FL                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7700'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01899 7750-SUM-INSTALL-DEP.                                            
A01899                                                                  
A01899     EXEC SQL                                                     
A01899         SELECT SUM(AMT_DEPOSIT)                                  
A01899           INTO :WS-AMT-INSTALL-DEP :WS-NULL5                      
A01899           FROM CSS_DEP_ON_HAND D1,                               
A01899                CSS_DEP_REQ DR                                    
A01899          WHERE D1.ACCOUNT_NO = :DO-ACCOUNT-NO                    
A01899            AND D1.ACCOUNT_NO = DR.ACCOUNT_NO                     
A01899            AND DEPOSIT_STATUS_CD = 'A'                           
A01899            AND DEP_BILL_OPTION_CD = 'T'                          
A01899            AND DEPOSIT_CERT_NO = DEP_ITEM_ID                     
A01899                                                      
A01899     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :WS-AMT-INSTALL-DEP:WS-NULL5                              
MFA-TR*          FROM CSS_DEP_ON_HAND D1,                                       
MFA-TR*               CSS_DEP_REQ DR                                            
MFA-TR*         WHERE D1.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*           AND D1.ACCOUNT_NO = DR.ACCOUNT_NO                             
MFA-TR*           AND DEPOSIT_STATUS_CD = 'A'                                   
MFA-TR*           AND DEP_BILL_OPTION_CD = 'T'                                  
MFA-TR*           AND DEPOSIT_CERT_NO = DEP_ITEM_ID                             
MFA-TR*         QUERYNO 7750                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01899                                                                  
A01899     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01899     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01899         WHEN SUCCESSFUL-CALL                                     
A01899             IF WS-NULL5 < 0                                      
A01899                 MOVE 0.00 TO WS-AMT-INSTALL-DEP                  
A01899             END-IF                                               
A01899         WHEN NOT-FOUND                                           
A01899             CONTINUE                                             
A01899         WHEN OTHER                                               
A01899             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
A01899             MOVE '7750'                   TO ACTIVE-PARAGRAPH    
A01899             MOVE 'SELECT'                 TO ABEND-FUNCTION      
A01899             MOVE SPACES                   TO ABEND-SQL-PREDICATES
A01899                                             ABEND-TABLES         
A01899             MOVE 'CSS_DEP_ON_HAND'        TO TABLE-1             
A01899             MOVE 'CSS_DEP_REQ'            TO TABLE-2             
A01899             MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
A01899             MOVE DO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
A01899             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01899             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01899     END-EVALUATE.                                                
A01899                                                                  
A01899 7750-EXIT.                                                       
A01899     EXIT.                                                        
                                                                        
       7800-RETURN-CHECK.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :NH-ACCOUNT-NO                                    
                 FROM CSS_NSF_HIST                                      
                WHERE ACCOUNT_NO = :NH-ACCOUNT-NO                       
                  AND NSF_STATUS_CD = 'C'                               
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :NH-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_NSF_HIST                                              
MFA-TR*         WHERE ACCOUNT_NO = :NH-ACCOUNT-NO                               
MFA-TR*           AND NSF_STATUS_CD = 'C'                                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-RETURN-CHECK-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-RETURN-CHECK-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7800'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_NSF_HIST'           TO TABLE-1             
                   MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1     
                   MOVE NH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7900-SELECT-REMARKS.                                             
                                                                        
A01225     MOVE SPACES TO EF-REMARK-TX EF-REMARK-DATETIME.              
           EXEC SQL                                                     
               SELECT TOP(1) REMARK_TX,
              REPLACE(REPLACE(CONVERT(CHAR(26), REMARK_DATETIME, 121), 
           ' ', '-'), ':', '.') REMARK_DATETIME                                
                 INTO :EF-REMARK-TX,                                    
                      :EF-REMARK-DATETIME                               
                 FROM CSS_SO_REMARKS                                    
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                  AND REMARK_TYPE_CD = :EF-REMARK-TYPE-CD               
             ORDER BY REMARK_DATETIME DESC                              
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REMARK_TX,                                                
MFA-TR*               REMARK_DATETIME                                           
MFA-TR*          INTO :EF-REMARK-TX,                                            
MFA-TR*               :EF-REMARK-DATETIME                                       
MFA-TR*          FROM CSS_SO_REMARKS                                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*           AND REMARK_TYPE_CD = :EF-REMARK-TYPE-CD                       
MFA-TR*      ORDER BY REMARK_DATETIME DESC                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-REMARKS-FL                            
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-REMARKS-FL                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '7900'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'SELECT'                 TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO-DATA'            TO TABLE-1             
                   MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1     
                   MOVE VO-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-INSERT-REMARKS.                                             
                                                                        
           MOVE VO-SERV-ORDER-NO TO EF-SERV-ORDER-NO.                   
           MOVE 'SYSTEM' TO EF-CHANGED-BY-USER-ID.                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REMARKS                               
                   (SERV_ORDER_NO,                                      
                    REMARK_TYPE_CD,                                     
                    REMARK_DATETIME,                                    
                    CHANGED_BY_USER_ID,                                 
                    REMARK_TX)                                          
               VALUES                                                   
                   ( :EF-SERV-ORDER-NO,                                 
                     :EF-REMARK-TYPE-CD,                                
                     CIS.CURRENT$TIMESTAMP(),                                 
                     :EF-CHANGED-BY-USER-ID,                            
                     :EF-REMARK-TX)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REMARKS                                       
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             REMARK_TYPE_CD,                                             
MFA-TR*             REMARK_DATETIME,                                            
MFA-TR*             CHANGED_BY_USER_ID,                                         
MFA-TR*             REMARK_TX)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*            ( :EF-SERV-ORDER-NO,                                         
MFA-TR*              :EF-REMARK-TYPE-CD,                                        
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :EF-CHANGED-BY-USER-ID,                                    
MFA-TR*              :EF-REMARK-TX)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REMARKS'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EF-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-UPDATE-STATE.                                               
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ORDER_STATE_CD = :VO-ORDER-STATE-CD               
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET ORDER_STATE_CD = :VO-ORDER-STATE-CD                       
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*       QUERYNO 8600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   MOVE 'ORDER_STATE_CD'     TO TABLE-ELEMENT-1         
                   MOVE VO-ORDER-STATE-CD    TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-INSERT-AUDIT-ROW.                                           
                                                                        
           MOVE 'SYSTEM' TO VW-USER-ID-UPDT-BY.                         
           MOVE '016' TO VW-PANEL-NO.                                   
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                   (SERV_ORDER_NO,                                      
                    USER_ID_UPDT_BY,                                    
                    UPDATE_DATETIME,                                    
                    PANEL_NO,                                           
                    ASSIGNED_DATETIME,                                  
                    ORDER_TYPE_CD,                                      
                    SERV_ORDER_STATUS,                                  
                    ORDER_STATE_CD,                                     
                    WANTED_BY_DATETIME)                                 
               VALUES                                                   
                   (:VO-SERV-ORDER-NO,                                  
                    :VW-USER-ID-UPDT-BY,                                
                    CIS.CURRENT$TIMESTAMP(),                                  
                    :VW-PANEL-NO,                                       
                    CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME),                  
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-SERV-ORDER-STATUS,                              
                    :VO-ORDER-STATE-CD,                                 
                    CIS.CHAR2TIMESTAMP(:VO-WANTED-BY-DATETIME))                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             USER_ID_UPDT_BY,                                            
MFA-TR*             UPDATE_DATETIME,                                            
MFA-TR*             PANEL_NO,                                                   
MFA-TR*             ASSIGNED_DATETIME,                                          
MFA-TR*             ORDER_TYPE_CD,                                              
MFA-TR*             SERV_ORDER_STATUS,                                          
MFA-TR*             ORDER_STATE_CD,                                             
MFA-TR*             WANTED_BY_DATETIME)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (:VO-SERV-ORDER-NO,                                          
MFA-TR*             :VW-USER-ID-UPDT-BY,                                        
MFA-TR*             CURRENT TIMESTAMP,                                          
MFA-TR*             :VW-PANEL-NO,                                               
MFA-TR*             :VO-ASSIGNED-DATETIME,                                      
MFA-TR*             :VO-ORDER-TYPE-CD,                                          
MFA-TR*             :VO-SERV-ORDER-STATUS,                                      
MFA-TR*             :VO-ORDER-STATE-CD,                                         
MFA-TR*             :VO-WANTED-BY-DATETIME)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_UPDATE'      TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00718 8800-UPDATE-PRINT-IND.                                           
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         UPDATE CSS_SO_DATA                                       
P00718            SET PRINTED_IND   = 'N'                               
P00718          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET PRINTED_IND   = 'N'                                       
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*       QUERYNO 8800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '8800'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'UPDATE'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
P00718             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
P00718             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
P00718             MOVE 'PRINTED_IND'        TO TABLE-ELEMENT-2         
P00718             MOVE 'N'                  TO HOSTVAR-ELEMENT-2       
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 8800-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
