       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04111.                                          
COB303 DATE-WRITTEN.      FEBRUARY 8, 2008.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS ELECTRIC AND GAS FLAGS TO THE WEB.       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/08/08    FMB      NEW PROGRAM.                                      
P01176*  10/06/16    FMB      GAS SAMPLE TEST.                                  
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04111'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04111 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04111_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-ELEC-FL              PIC X(01) VALUE SPACES.          
           05  RS-GAS-FL               PIC X(01) VALUE SPACES.          
           05  RS-ELEC-UNBLOCK-FL      PIC X(01) VALUE SPACES.          
           05  RS-GAS-UNBLOCK-FL       PIC X(01) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-ELEC-FL              PIC X(01) VALUE SPACES.           
           05  S-GAS-FL               PIC X(01) VALUE SPACES.           
           05  S-ELEC-UNBLOCK-FL      PIC X(01) VALUE SPACES.           
           05  S-GAS-UNBLOCK-FL       PIC X(01) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04111'.     
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-CUSTOMER-NO        PIC X(10).                           
       01  LINK-ORDER-EXISTS-FL    PIC X(01).                           
       01  LINK-UPDATE-ORDER-FL    PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO,                              
                          LINK-PREMISE-NO,                              
                          LINK-CUSTOMER-NO,                             
                          LINK-ORDER-EXISTS-FL,                         
                          LINK-UPDATE-ORDER-FL.                         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE     AS RETURN_CODE,                
                      :S-ELEC-FL         AS ELEC_FL,                    
                      :S-GAS-FL          AS GAS_FL,                     
                      :S-ELEC-UNBLOCK-FL AS ELEC_UNBLOCK_FL,            
                      :S-GAS-UNBLOCK-FL  AS GAS_UNBLOCK_FL              
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE     AS RETURN_CODE,                        
MFA-TR*               :S-ELEC-FL         AS ELEC_FL,                            
MFA-TR*               :S-GAS-FL          AS GAS_FL,                             
MFA-TR*               :S-ELEC-UNBLOCK-FL AS ELEC_UNBLOCK_FL,                    
MFA-TR*               :S-GAS-UNBLOCK-FL  AS GAS_UNBLOCK_FL                      
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-PREMISE-NO            TO WS-PREMISE-NO-CHAR.       
           MOVE WS-PREMISE-NO-NUM          TO VO-PREMISE-NO.            
           MOVE LINK-ACCOUNT-NO            TO WS-ACCOUNT-NO-CHAR.       
           MOVE WS-ACCOUNT-NO-NUM          TO MN-ACCOUNT-NO.            
           MOVE 'N'                        TO RS-ELEC-FL                
                                              RS-GAS-FL                 
                                              RS-ELEC-UNBLOCK-FL        
                                              RS-GAS-UNBLOCK-FL.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-CHECK-METERS THRU 7000-EXIT.                    
           IF LINK-ORDER-EXISTS-FL = 'Y' AND                            
              LINK-UPDATE-ORDER-FL = 'N'                                
                  PERFORM 7100-UNBLOCK-FROM-ORDER THRU 7100-EXIT        
           ELSE                                                         
               PERFORM 7200-UNBLOCK-FROM-ACCOUNT THRU 7200-EXIT
           END-IF.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = 100                               
               MOVE 0 TO WS-ACTIVE-RETURN-CODE
           END-IF.                         
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE     TO S-RETURN-CODE.                  
             MOVE RS-ELEC-FL         TO S-ELEC-FL.                      
             MOVE RS-GAS-FL          TO S-GAS-FL.                       
             MOVE RS-ELEC-UNBLOCK-FL TO S-ELEC-UNBLOCK-FL.              
             MOVE RS-GAS-UNBLOCK-FL  TO S-GAS-UNBLOCK-FL.               
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       7000-CHECK-METERS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :RS-ELEC-FL                                       
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'E'                              
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-ELEC-FL                                               
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-ELEC-FL                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-ELEC-FL                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT1'          TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE MN-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :RS-GAS-FL                                        
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-GAS-FL                                                
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-GAS-FL                                
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-GAS-FL                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT2'          TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE MN-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-UNBLOCK-FROM-ORDER.                                         
                                                                        
           MOVE MN-ACCOUNT-NO TO VO-ACCOUNT-NO-PRIOR.                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :RS-ELEC-UNBLOCK-FL                               
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR           
                  AND ORDER_TYPE_CD    IN ('CC001', 'OFF01')            
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
P01176            AND WORK_TYPE_CD     IN ('BLK', 'VRB', 'MCB')         
                  AND ORDER_STATE_CD   NOT IN ('C', 'Z')                
                  AND CODE_UTIL_TYPE   = 'E'                            
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-ELEC-UNBLOCK-FL                                       
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR                   
MFA-TR*           AND ORDER_TYPE_CD    IN ('CC001', 'OFF01')                    
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND WORK_TYPE_CD     IN ('BLK', 'VRB', 'MCB')                 
MFA-TR*           AND ORDER_STATE_CD   NOT IN ('C', 'Z')                        
MFA-TR*           AND CODE_UTIL_TYPE   = 'E'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-ELEC-UNBLOCK-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-ELEC-UNBLOCK-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT1'           TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :RS-GAS-UNBLOCK-FL                                
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR           
                  AND ORDER_TYPE_CD    IN ('CC001', 'OFF01')            
                  AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO               
P01176            AND WORK_TYPE_CD     IN ('BLK', 'VRB', 'MCB')         
                  AND ORDER_STATE_CD   NOT IN ('C', 'Z')                
                  AND CODE_UTIL_TYPE   = 'G'                            
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-GAS-UNBLOCK-FL                                        
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_ORDER_INST VI                                      
MFA-TR*         WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO-PRIOR                   
MFA-TR*           AND ORDER_TYPE_CD    IN ('CC001', 'OFF01')                    
MFA-TR*           AND VO.SERV_ORDER_NO = VI.SERV_ORDER_NO                       
MFA-TR*           AND WORK_TYPE_CD     IN ('BLK', 'VRB', 'MCB')                 
MFA-TR*           AND ORDER_STATE_CD   NOT IN ('C', 'Z')                        
MFA-TR*           AND CODE_UTIL_TYPE   = 'G'                                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-GAS-UNBLOCK-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-GAS-UNBLOCK-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT2'           TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-UNBLOCK-FROM-ACCOUNT.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :RS-ELEC-UNBLOCK-FL                               
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                 
                  AND CODE_UTIL_TYPE   = 'E'                            
                  AND CODE_METER_STATUS = 'J'                           
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-ELEC-UNBLOCK-FL                                       
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                         
MFA-TR*           AND CODE_UTIL_TYPE   = 'E'                                    
MFA-TR*           AND CODE_METER_STATUS = 'J'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-ELEC-UNBLOCK-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-ELEC-UNBLOCK-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT1'           TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :RS-GAS-UNBLOCK-FL                                
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                 
                  AND CODE_UTIL_TYPE   = 'G'                            
                  AND CODE_METER_STATUS = 'J'                           
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-GAS-UNBLOCK-FL                                        
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO       = :MN-ACCOUNT-NO                         
MFA-TR*           AND CODE_UTIL_TYPE   = 'G'                                    
MFA-TR*           AND CODE_METER_STATUS = 'J'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-GAS-UNBLOCK-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-GAS-UNBLOCK-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT2'           TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
