       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04110.                                          
COB303 DATE-WRITTEN.      FEBRUARY 19, 2008.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CALCULATES AVAILABLE APPOINTMENTS FOR THE WEB.   *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/18/08    FMB      NEW PROGRAM.                                      
A01737*  10/02/09    FMB      SET AM AND PM FLAGS WHEN BAD ALL DAY FLAG         
A01737*                       IS SET.                                           
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04110'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04110 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKABLO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLCKID                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKARPR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04110_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-BAD-ALL-DAY          PIC X(01) VALUE SPACES.          
           05  RS-BAD-AM-APPT          PIC X(01) VALUE SPACES.          
           05  RS-BAD-PM-APPT          PIC X(01) VALUE SPACES.          
           05  RS-START-AM-TIME        PIC X(26) VALUE SPACES.          
           05  RS-STOP-AM-TIME         PIC X(26) VALUE SPACES.          
           05  RS-START-PM-TIME        PIC X(26) VALUE SPACES.          
           05  RS-STOP-PM-TIME         PIC X(26) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-BAD-ALL-DAY          PIC X(01) VALUE SPACES.           
           05  S-BAD-AM-APPT          PIC X(01) VALUE SPACES.           
           05  S-BAD-PM-APPT          PIC X(01) VALUE SPACES.           
           05  S-START-AM-TIME        PIC X(26) VALUE SPACES.           
           05  S-STOP-AM-TIME         PIC X(26) VALUE SPACES.           
           05  S-START-PM-TIME        PIC X(26) VALUE SPACES.           
           05  S-STOP-PM-TIME         PIC X(26) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 NORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04110'.     
           05  WS-NULL-BEGIN-DT         PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-END-DT           PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-DIFF             PIC S9(04) COMP VALUE ZERO.     
           05  WS-DAY-OF-WEEK           PIC 9(01) VALUE ZEROES.         
           05  WS-DAY-OF-WEEK-CHAR      PIC X(01) VALUE SPACES.         
           05  WS-DAYOFWEEK-ISO         PIC S9(9) COMP VALUE 0.         
           05  WS-TOTAL-ORDERS          PIC 9(4) VALUE 0.               
           05  WS-TOTAL-AM-APPTS        PIC 9(4) VALUE 0.               
           05  WS-TOTAL-PM-APPTS        PIC 9(4) VALUE 0.               
           05  WS-TOTAL-AH-APPTS        PIC 9(4) VALUE 0.               
           05  WS-SO-EST-LABOR-MM       PIC S9(6)V9(1) COMP-3 VALUE 0.  
           05  WS-TOTAL-RES-MM          PIC S9(6)V9(1) COMP-3 VALUE 0.  
           05  WS-TOTAL-AM-RES-MM       PIC S9(6)V9(1) COMP-3 VALUE 0.  
           05  WS-TOTAL-PM-RES-MM       PIC S9(6)V9(1) COMP-3 VALUE 0.  
           05  WS-TOTAL-AH-RES-MM       PIC S9(6)V9(1) COMP-3 VALUE 0.  
           05  WS-START-SHIFT-AM-TM     PIC X(26) VALUE SPACES.         
           05  WS-START-SHIFT-PM-TM     PIC X(26) VALUE SPACES.         
           05  WS-START-SHIFT-AH-TM     PIC X(26) VALUE SPACES.         
           05  WS-STOP-SHIFT-AM-TM      PIC X(26) VALUE SPACES.         
           05  WS-STOP-SHIFT-PM-TM      PIC X(26) VALUE SPACES.         
           05  WS-STOP-SHIFT-AH-TM      PIC X(26) VALUE SPACES.         
           05  WS-BLOCK-FROM-TIME       PIC X(26) VALUE SPACES.         
           05  WS-BLOCK-UNTIL-TIME      PIC X(26) VALUE SPACES.         
           05  WS-SCHEDULED-TS          PIC X(26) VALUE SPACES.         
           05  WS-SCHEDULED-DATE        PIC X(10) VALUE SPACES.         
           05  WS-TIME-DIFFERENCE       PIC S9(9) COMP VALUE 0.         
           05  WS-SERV-ORDER-RES        PIC 9(6) VALUE 0.               
           05  WS-SERV-ORDER-RES-DEC    PIC 9(5)V9 VALUE 0.             
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE SERV_ORDER_CURSOR CURSOR FOR                     
                   SELECT SO_EST_LABOR_HR,                              
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           BEGIN_APPT_DT, 121), ' ', '-'), ':', '.') BEGIN_APPT_DT,            
                          REPLACE(REPLACE(CONVERT(CHAR(26), END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT                            
                     FROM CSS_SO_DATA WITH(READUNCOMMITTED)                     
                    WHERE WORK_AREA_ID            = :VO-WORK-AREA-ID    
                      AND CAST(ASSIGNED_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-SCHEDULED-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-SCHEDULED-DATE
              ) <> 0) OR (LEN(:WS-SCHEDULED-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-SCHEDULED-DATE
              ), CONVERT(DATE, :WS-SCHEDULED-DATE) )  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SERV_ORDER_CURSOR CURSOR FOR                             
MFA-TR*            SELECT SO_EST_LABOR_HR,                                      
MFA-TR*                   BEGIN_APPT_DT,                                        
MFA-TR*                   END_APPT_DT                                           
MFA-TR*              FROM CSS_SO_DATA                                           
MFA-TR*             WHERE WORK_AREA_ID            = :VO-WORK-AREA-ID            
MFA-TR*               AND DATE(ASSIGNED_DATETIME) = :WS-SCHEDULED-DATE          
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-WORK-AREA-ID       PIC X(12).                           
       01  LINK-SCHEDULED-DT       PIC X(10).                           
       01  LINK-SERV-ORDER-RES     PIC X(06).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-WORK-AREA-ID                             
                          LINK-SCHEDULED-DT                             
                          LINK-SERV-ORDER-RES.                          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE       AS RETURN_CODE,              
                      :S-BAD-ALL-DAY       AS BAD_ALL_DAY,              
                      :S-BAD-AM-APPT       AS BAD_AM_APPT,              
                      :S-BAD-PM-APPT       AS BAD_PM_APPT,              
                      :S-START-AM-TIME     AS START_AM_TIME,            
                      :S-STOP-AM-TIME      AS STOP_AM_TIME,             
                      :S-START-PM-TIME     AS START_PM_TIME,            
                      :S-STOP-PM-TIME      AS STOP_PM_TIME              
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE       AS RETURN_CODE,                      
MFA-TR*               :S-BAD-ALL-DAY       AS BAD_ALL_DAY,                      
MFA-TR*               :S-BAD-AM-APPT       AS BAD_AM_APPT,                      
MFA-TR*               :S-BAD-PM-APPT       AS BAD_PM_APPT,                      
MFA-TR*               :S-START-AM-TIME     AS START_AM_TIME,                    
MFA-TR*               :S-STOP-AM-TIME      AS STOP_AM_TIME,                     
MFA-TR*               :S-START-PM-TIME     AS START_PM_TIME,                    
MFA-TR*               :S-STOP-PM-TIME      AS STOP_PM_TIME                      
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-SERV-ORDER-RES NOT NUMERIC                           
               MOVE ZEROES TO LINK-SERV-ORDER-RES
           END-IF.                      
           MOVE LINK-SERV-ORDER-RES TO WS-SERV-ORDER-RES.               
           MOVE WS-SERV-ORDER-RES(1:5) TO WS-SERV-ORDER-RES-DEC(1:5).   
           MOVE WS-SERV-ORDER-RES(6:1) TO WS-SERV-ORDER-RES-DEC(6:1).   
           MOVE LINK-SCHEDULED-DT TO J8-HOLIDAY-DT.                     
           PERFORM 7000-CHECK-HOLIDAY THRU 7000-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE 0 TO RS-RETURN-CODE                                 
               MOVE 'Y' TO RS-BAD-ALL-DAY                               
           ELSE                                                         
               PERFORM 3000-BLOCK-PROCESSING THRU 3000-EXIT
           END-IF.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
A01737     IF RS-BAD-ALL-DAY = 'Y'                                      
A01737        MOVE 'Y' TO RS-BAD-AM-APPT                                
A01737                    RS-BAD-PM-APPT
           END-IF.                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                
             MOVE RS-BAD-ALL-DAY       TO S-BAD-ALL-DAY.                
             MOVE RS-BAD-AM-APPT       TO S-BAD-AM-APPT.                
             MOVE RS-BAD-PM-APPT       TO S-BAD-PM-APPT.                
             MOVE RS-START-AM-TIME     TO S-START-AM-TIME.              
             MOVE RS-STOP-AM-TIME      TO S-STOP-AM-TIME.               
             MOVE RS-START-PM-TIME     TO S-START-PM-TIME.              
             MOVE RS-STOP-PM-TIME      TO S-STOP-PM-TIME.               
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       3000-BLOCK-PROCESSING.                                           
                                                                        
           EXEC SQL                                                     
               SELECT
              CIS.DAYOFWEEK_ISO( IIF(TRY_CONVERT(DATE, 
                                                     :LINK-SCHEDULED-DT
              ) IS NULL OR (PATINDEX('%.%', :LINK-SCHEDULED-DT
              ) <> 0) OR (LEN(:LINK-SCHEDULED-DT
              ) <> 10), CIS.CHAR2DATE(:LINK-SCHEDULED-DT
              ), CONVERT(DATE, :LINK-SCHEDULED-DT) ) )
            INTO
              :WS-DAYOFWEEK-ISO                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES DAYOFWEEK_ISO(:LINK-SCHEDULED-DT)                         
MFA-TR*          INTO :WS-DAYOFWEEK-ISO                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DAYOFWEEK-ISO TO WS-DAY-OF-WEEK.                     
           MOVE WS-DAY-OF-WEEK TO WS-DAY-OF-WEEK-CHAR.                  
           MOVE LINK-WORK-AREA-ID TO H5-WORK-AREA-ID                    
                                     I4-WORK-AREA-ID                    
                                     VO-WORK-AREA-ID.                   
           MOVE WS-DAY-OF-WEEK-CHAR TO H7-BLOCK-TYPE-ID                 
                                       I4-BLOCK-TYPE-ID.                
           PERFORM 7100-GET-BLOCK-INFO THRU 7100-EXIT.                  
           PERFORM 7200-GET-PERMISSIONS THRU 7200-EXIT.                 
           PERFORM 3010-CONVERT-DATES THRU 3010-EXIT.                   
           IF WS-SCHEDULED-TS <= H5-BLOCK-EXP-DATE                      
               IF WS-SCHEDULED-TS >= H5-BLOCK-EFF-DATE                  
                   IF WS-BLOCK-FROM-TIME >= WS-START-SHIFT-AM-TM        
                       MOVE 'Y' TO RS-BAD-AM-APPT                       
                   END-IF                                               
                   IF WS-BLOCK-FROM-TIME >= WS-START-SHIFT-AM-TM AND    
                      WS-BLOCK-UNTIL-TIME <= WS-STOP-SHIFT-PM-TM        
                          MOVE 'Y' TO RS-BAD-ALL-DAY                    
                          MOVE 0 TO RS-RETURN-CODE                      
                          GO TO 3000-EXIT                               
                   END-IF                                               
                   IF WS-BLOCK-FROM-TIME >= WS-START-SHIFT-PM-TM AND    
                      WS-BLOCK-UNTIL-TIME <= WS-STOP-SHIFT-PM-TM        
                          MOVE 'Y' TO RS-BAD-PM-APPT
                   END-IF
               END-IF
           END-IF.                   
                                                                        
           PERFORM 7010-OPEN-CURSOR THRU 7010-EXIT.                     
           PERFORM 3100-FETCH-ROWS THRU 3100-EXIT.                      
           PERFORM 7030-CLOSE-CURSOR THRU 7030-EXIT.                    
                                                                        
           COMPUTE WS-TOTAL-ORDERS = WS-TOTAL-ORDERS + 1.               
           COMPUTE WS-TOTAL-RES-MM = WS-TOTAL-RES-MM +                  
                  (WS-SERV-ORDER-RES-DEC * 60).                         
           COMPUTE WS-TOTAL-AM-APPTS = WS-TOTAL-AM-APPTS + 1.           
           COMPUTE WS-TOTAL-AM-RES-MM = WS-TOTAL-AM-RES-MM +            
                  (WS-SERV-ORDER-RES-DEC * 60).                         
           COMPUTE WS-TOTAL-PM-APPTS = WS-TOTAL-PM-APPTS + 1.           
           COMPUTE WS-TOTAL-PM-RES-MM = WS-TOTAL-PM-RES-MM +            
                  (WS-SERV-ORDER-RES-DEC * 60).                         
                                                                        
           IF I4-MAX-DAY-WK-REQ-FL = 'Y' AND                            
              WS-TOTAL-ORDERS > I4-MAX-DAILY-WK-REQ                     
                  MOVE 'Y' TO RS-BAD-ALL-DAY
           END-IF.                           
           IF I4-MAX-DAILY-APPT-FL = 'Y' AND                            
              WS-TOTAL-ORDERS > I4-MAX-DAILY-APPT AND                   
              I4-MAX-DAILY-APPT > 0                                     
                  MOVE 'Y' TO RS-BAD-ALL-DAY
           END-IF.                           
           IF I4-MAX-RE-PER-DAY-FL = 'Y' AND                            
              WS-TOTAL-RES-MM > (I4-MAX-RE-PER-DAY * 60)                
                  MOVE 'Y' TO RS-BAD-ALL-DAY
           END-IF.                           
           IF WS-TOTAL-AM-APPTS > I4-MAX-AM-APPT-QT                     
               MOVE 'Y' TO RS-BAD-AM-APPT
           END-IF.                              
           IF WS-TOTAL-AM-RES-MM > (I4-MAX-RE-AM-QT * 60)               
               MOVE 'Y' TO RS-BAD-AM-APPT
           END-IF.                              
           IF WS-TOTAL-PM-APPTS > I4-MAX-PM-APPT-QT                     
               MOVE 'Y' TO RS-BAD-PM-APPT
           END-IF.                              
           IF WS-TOTAL-PM-RES-MM > (I4-MAX-RE-PM-QT * 60)               
               MOVE 'Y' TO RS-BAD-PM-APPT
           END-IF.                              
                                                                        
           MOVE WS-START-SHIFT-AM-TM TO RS-START-AM-TIME.               
           MOVE WS-STOP-SHIFT-AM-TM TO RS-STOP-AM-TIME.                 
           MOVE WS-START-SHIFT-PM-TM TO RS-START-PM-TIME.               
           MOVE WS-STOP-SHIFT-PM-TM TO RS-STOP-PM-TIME.                 
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3010-CONVERT-DATES.                                              
                                                                        
           MOVE I4-START-SHIFT-AM-TM TO WS-START-SHIFT-AM-TM.           
           MOVE LINK-SCHEDULED-DT TO WS-START-SHIFT-AM-TM(1:10).        
           MOVE I4-START-SHIFT-PM-TM TO WS-START-SHIFT-PM-TM.           
           MOVE LINK-SCHEDULED-DT TO WS-START-SHIFT-PM-TM(1:10).        
           MOVE I4-START-SHIFT-AH-TM TO WS-START-SHIFT-AH-TM.           
           MOVE LINK-SCHEDULED-DT TO WS-START-SHIFT-AH-TM(1:10).        
           MOVE I4-STOP-SHIFT-AM-TM TO WS-STOP-SHIFT-AM-TM.             
           MOVE LINK-SCHEDULED-DT TO WS-STOP-SHIFT-AM-TM(1:10).         
           MOVE I4-STOP-SHIFT-PM-TM TO WS-STOP-SHIFT-PM-TM.             
           MOVE LINK-SCHEDULED-DT TO WS-STOP-SHIFT-PM-TM(1:10).         
           MOVE I4-STOP-SHIFT-AH-TM TO WS-STOP-SHIFT-AH-TM.             
           MOVE LINK-SCHEDULED-DT TO WS-STOP-SHIFT-AH-TM(1:10).         
           MOVE H5-BLOCK-FROM-TIME TO WS-BLOCK-FROM-TIME.               
           MOVE LINK-SCHEDULED-DT TO WS-BLOCK-FROM-TIME(1:10).          
           MOVE H5-BLOCK-UNTIL-TIME TO WS-BLOCK-UNTIL-TIME.             
           MOVE LINK-SCHEDULED-DT TO WS-BLOCK-UNTIL-TIME(1:10).         
           MOVE LINK-SCHEDULED-DT TO WS-SCHEDULED-DATE                  
                                     WS-SCHEDULED-TS(1:10).             
           MOVE '-00.00.00.000000' TO WS-SCHEDULED-TS(11:16).           
                                                                        
       3010-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH SERV_ORDER_CURSOR                                  
               INTO :VO-SO-EST-LABOR-HR,                                
                    :VO-BEGIN-APPT-DT :WS-NULL-BEGIN-DT,                 
                    :VO-END-APPT-DT :WS-NULL-END-DT                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-BEGIN-DT < 0                              
                       MOVE SPACES TO VO-BEGIN-APPT-DT                  
                   END-IF                                               
                   IF WS-NULL-END-DT < 0                                
                       MOVE SPACES TO VO-END-APPT-DT                    
                   END-IF                                               
                   PERFORM 3200-PROCESS-ORDER THRU 3200-EXIT            
               WHEN NOT-FOUND                                           
                   GO TO 3100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '3100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
           GO TO 3100-FETCH-ROWS.                                       
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3200-PROCESS-ORDER.                                              
                                                                        
           COMPUTE WS-TOTAL-ORDERS = WS-TOTAL-ORDERS + 1.               
           COMPUTE WS-SO-EST-LABOR-MM = VO-SO-EST-LABOR-HR * 60.        
           COMPUTE WS-TOTAL-RES-MM = WS-TOTAL-RES-MM +                  
                                     WS-SO-EST-LABOR-MM.                
           IF VO-BEGIN-APPT-DT > SPACES AND                             
              VO-END-APPT-DT > SPACES                                   
                  PERFORM 3210-ACCUMULATE-APPTS THRU 3210-EXIT
           END-IF.         
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3210-ACCUMULATE-APPTS.                                           
                                                                        
           IF VO-BEGIN-APPT-DT < WS-STOP-SHIFT-AM-TM                    
               COMPUTE WS-TOTAL-AM-APPTS = WS-TOTAL-AM-APPTS + 1        
               COMPUTE WS-TOTAL-AM-RES-MM = WS-TOTAL-AM-RES-MM +        
                                            WS-SO-EST-LABOR-MM          
               IF VO-END-APPT-DT > WS-START-SHIFT-PM-TM                 
                   MOVE 0 TO WS-TIME-DIFFERENCE                         
                   COMPUTE WS-TOTAL-PM-APPTS = WS-TOTAL-PM-APPTS + 1    
                   EXEC SQL                                             
                       SELECT
              CIS.TIMESTAMPDIFF(4,CIS.DECIMAL2CHAR(                     
                              CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                               :WS-START-SHIFT-PM-TM), 
           CIS.CHAR2TIMESTAMP(:VO-END-APPT-DT) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF          
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*            EXEC SQL                                                     
MFA-TR*                VALUES TIMESTAMPDIFF(4,CHAR(                             
MFA-TR*                       TIMESTAMP(:WS-START-SHIFT-PM-TM) -                
MFA-TR*                       TIMESTAMP(:VO-END-APPT-DT)))                      
MFA-TR*                  INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF                  
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   IF WS-NULL-DIFF < 0                                  
                       MOVE 0 TO WS-TIME-DIFFERENCE                     
                   END-IF                                               
                   COMPUTE WS-TOTAL-PM-RES-MM =                         
                           WS-TOTAL-PM-RES-MM + WS-TIME-DIFFERENCE      
                   COMPUTE WS-TOTAL-AM-RES-MM =                         
                           WS-TOTAL-AM-RES-MM - WS-TIME-DIFFERENCE      
               END-IF                                                   
               IF VO-END-APPT-DT > WS-START-SHIFT-AH-TM                 
                   MOVE 0 TO WS-TIME-DIFFERENCE                         
                   COMPUTE WS-TOTAL-AH-APPTS = WS-TOTAL-AH-APPTS + 1    
                   EXEC SQL                                             
                       SELECT
              CIS.TIMESTAMPDIFF(4,CIS.DECIMAL2CHAR(                     
                              CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                               :WS-START-SHIFT-AH-TM), 
           CIS.CHAR2TIMESTAMP(:VO-END-APPT-DT) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF          
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*            EXEC SQL                                                     
MFA-TR*                VALUES TIMESTAMPDIFF(4,CHAR(                             
MFA-TR*                       TIMESTAMP(:WS-START-SHIFT-AH-TM) -                
MFA-TR*                       TIMESTAMP(:VO-END-APPT-DT)))                      
MFA-TR*                  INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF                  
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   IF WS-NULL-DIFF < 0                                  
                       MOVE 0 TO WS-TIME-DIFFERENCE                     
                   END-IF                                               
                   COMPUTE WS-TOTAL-AH-RES-MM =                         
                           WS-TOTAL-AH-RES-MM + WS-TIME-DIFFERENCE      
                   COMPUTE WS-TOTAL-PM-RES-MM =                         
                           WS-TOTAL-PM-RES-MM - WS-TIME-DIFFERENCE      
               END-IF                                                   
           ELSE                                                         
               IF VO-BEGIN-APPT-DT < WS-STOP-SHIFT-PM-TM                
                   COMPUTE WS-TOTAL-PM-APPTS = WS-TOTAL-PM-APPTS + 1    
                   COMPUTE WS-TOTAL-PM-RES-MM = WS-TOTAL-PM-RES-MM +    
                           WS-SO-EST-LABOR-MM                           
                   IF VO-END-APPT-DT > WS-START-SHIFT-AH-TM             
                       MOVE 0 TO WS-TIME-DIFFERENCE                     
                       COMPUTE WS-TOTAL-AH-APPTS = WS-TOTAL-AH-APPTS + 1
                       EXEC SQL                                         
                           SELECT
              CIS.TIMESTAMPDIFF(4,CIS.DECIMAL2CHAR(                 
                                  CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                               :WS-START-SHIFT-AH-TM), 
           CIS.CHAR2TIMESTAMP(:VO-END-APPT-DT) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF      
                       END-EXEC                                         

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*                EXEC SQL                                                 
MFA-TR*                    VALUES TIMESTAMPDIFF(4,CHAR(                         
MFA-TR*                           TIMESTAMP(:WS-START-SHIFT-AH-TM) -            
MFA-TR*                           TIMESTAMP(:VO-END-APPT-DT)))                  
MFA-TR*                      INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF              
MFA-TR*                END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                       IF WS-NULL-DIFF < 0                              
                           MOVE 0 TO WS-TIME-DIFFERENCE                 
                       END-IF                                           
                       COMPUTE WS-TOTAL-AH-RES-MM =                     
                               WS-TOTAL-AH-RES-MM + WS-TIME-DIFFERENCE  
                       COMPUTE WS-TOTAL-PM-RES-MM =                     
                               WS-TOTAL-PM-RES-MM - WS-TIME-DIFFERENCE  
                   END-IF                                               
               ELSE                                                     
                   IF VO-BEGIN-APPT-DT < WS-STOP-SHIFT-AH-TM            
                       COMPUTE WS-TOTAL-AH-APPTS = WS-TOTAL-AH-APPTS + 1
                       COMPUTE WS-TOTAL-AH-RES-MM =                     
                               WS-TOTAL-AH-RES-MM +                     
                               WS-SO-EST-LABOR-MM
                   END-IF
               END-IF
           END-IF.                      
       3210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-CHECK-HOLIDAY.                                              
                                                                        
           EXEC SQL                                                     
               SELECT HOLIDAY_DT                                        
                 INTO :J8-HOLIDAY-DT                                    
                 FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                         
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOLIDAY_DT                                                
MFA-TR*          INTO :J8-HOLIDAY-DT                                            
MFA-TR*          FROM CSS_HOLIDAY                                               
MFA-TR*         WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_HOLIDAY'         TO TABLE-1                     
              MOVE 'HOLIDAY_DT'          TO TABLE-ELEMENT-1             
              MOVE J8-HOLIDAY-DT         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN SERV_ORDER_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE SERV_ORDER_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-BLOCK-INFO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BLOCK_FROM_TIME, 121), ' ', '-'), ':', '.') BLOCK_FROM_TIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), BLOCK_UNTIL_TIME, 121), 
           ' ', '-'), ':', '.') BLOCK_UNTIL_TIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), BLOCK_EFF_DATE, 121), 
           ' ', '-'), ':', '.') BLOCK_EFF_DATE,
              REPLACE(REPLACE(CONVERT(CHAR(26), BLOCK_EXP_DATE, 121), 
           ' ', '-'), ':', '.') BLOCK_EXP_DATE                                 
                 INTO :H5-BLOCK-FROM-TIME,                              
                      :H5-BLOCK-UNTIL-TIME,                             
                      :H5-BLOCK-EFF-DATE,                               
                      :H5-BLOCK-EXP-DATE                                
                 FROM CSS_WKAREA_BLOCK H5 WITH(READUNCOMMITTED),                
                      CSS_BLOCK_ID H7 WITH(READUNCOMMITTED)                     
                WHERE WORK_AREA_ID = :H5-WORK-AREA-ID                   
                  AND BLOCK_TYPE_ID = :H7-BLOCK-TYPE-ID                 
                  AND H5.BLOCK_ID = H7.BLOCK_ID                         
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BLOCK_FROM_TIME,                                          
MFA-TR*               BLOCK_UNTIL_TIME,                                         
MFA-TR*               BLOCK_EFF_DATE,                                           
MFA-TR*               BLOCK_EXP_DATE                                            
MFA-TR*          INTO :H5-BLOCK-FROM-TIME,                                      
MFA-TR*               :H5-BLOCK-UNTIL-TIME,                                     
MFA-TR*               :H5-BLOCK-EFF-DATE,                                       
MFA-TR*               :H5-BLOCK-EXP-DATE                                        
MFA-TR*          FROM CSS_WKAREA_BLOCK H5,                                      
MFA-TR*               CSS_BLOCK_ID H7                                           
MFA-TR*         WHERE WORK_AREA_ID = :H5-WORK-AREA-ID                           
MFA-TR*           AND BLOCK_TYPE_ID = :H7-BLOCK-TYPE-ID                         
MFA-TR*           AND H5.BLOCK_ID = H7.BLOCK_ID                                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1900-01-01-00.00.00.000000' TO                 
                                  H5-BLOCK-FROM-TIME                    
                                  H5-BLOCK-UNTIL-TIME                   
                                  H5-BLOCK-EFF-DATE                     
                                  H5-BLOCK-EXP-DATE                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_WKAREA_BLOCK' TO TABLE-1                   
                   MOVE 'CSS_BLOCK_ID'     TO TABLE-2                   
                   MOVE 'WORK_AREA_ID'   TO TABLE-ELEMENT-1             
                   MOVE H5-WORK-AREA-ID  TO HOSTVAR-ELEMENT-1           
                   MOVE 'BLOCK_TYPE_ID'  TO TABLE-ELEMENT-2             
                   MOVE H7-BLOCK-TYPE-ID TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-PERMISSIONS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           START_SHIFT_AM_TM, 121), ' ', '-'), ':', '.') 
           START_SHIFT_AM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), START_SHIFT_PM_TM
           , 121), ' ', '-'), ':', '.') START_SHIFT_PM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_SHIFT_AM_TM, 121), 
           ' ', '-'), ':', '.') STOP_SHIFT_AM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_SHIFT_PM_TM, 121), 
           ' ', '-'), ':', '.') STOP_SHIFT_PM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), START_SHIFT_AH_TM
           , 121), ' ', '-'), ':', '.') START_SHIFT_AH_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_SHIFT_AH_TM, 121), 
           ' ', '-'), ':', '.') STOP_SHIFT_AH_TM,
              MAX_DAY_WK_REQ_FL,
              MAX_DAILY_APPT_FL,
              MAX_DAILY_APPT,
              MAX_RE_PER_DAY_FL,
              MAX_RE_PER_DAY,
              MAX_AM_APPT_QT,
              MAX_RE_AM_QT,
              MAX_PM_APPT_QT,
              MAX_RE_PM_QT,
              MAX_DAILY_WK_REQ                                  
                 INTO :I4-START-SHIFT-AM-TM,                            
                      :I4-START-SHIFT-PM-TM,                            
                      :I4-STOP-SHIFT-AM-TM,                             
                      :I4-STOP-SHIFT-PM-TM,                             
                      :I4-START-SHIFT-AH-TM,                            
                      :I4-STOP-SHIFT-AH-TM ,                            
                      :I4-MAX-DAY-WK-REQ-FL,                            
                      :I4-MAX-DAILY-APPT-FL,                            
                      :I4-MAX-DAILY-APPT,                               
                      :I4-MAX-RE-PER-DAY-FL,                            
                      :I4-MAX-RE-PER-DAY,                               
                      :I4-MAX-AM-APPT-QT,                               
                      :I4-MAX-RE-AM-QT,                                 
                      :I4-MAX-PM-APPT-QT,                               
                      :I4-MAX-RE-PM-QT,                                 
                      :I4-MAX-DAILY-WK-REQ                              
                 FROM CSS_WKAREA_PRMSSN WITH(READUNCOMMITTED)                   
                WHERE WORK_AREA_ID = :I4-WORK-AREA-ID                   
                  AND BLOCK_TYPE_ID = :I4-BLOCK-TYPE-ID                 
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT START_SHIFT_AM_TM,                                        
MFA-TR*               START_SHIFT_PM_TM,                                        
MFA-TR*               STOP_SHIFT_AM_TM,                                         
MFA-TR*               STOP_SHIFT_PM_TM,                                         
MFA-TR*               START_SHIFT_AH_TM,                                        
MFA-TR*               STOP_SHIFT_AH_TM ,                                        
MFA-TR*               MAX_DAY_WK_REQ_FL,                                        
MFA-TR*               MAX_DAILY_APPT_FL,                                        
MFA-TR*               MAX_DAILY_APPT,                                           
MFA-TR*               MAX_RE_PER_DAY_FL,                                        
MFA-TR*               MAX_RE_PER_DAY,                                           
MFA-TR*               MAX_AM_APPT_QT,                                           
MFA-TR*               MAX_RE_AM_QT,                                             
MFA-TR*               MAX_PM_APPT_QT,                                           
MFA-TR*               MAX_RE_PM_QT,                                             
MFA-TR*               MAX_DAILY_WK_REQ                                          
MFA-TR*          INTO :I4-START-SHIFT-AM-TM,                                    
MFA-TR*               :I4-START-SHIFT-PM-TM,                                    
MFA-TR*               :I4-STOP-SHIFT-AM-TM,                                     
MFA-TR*               :I4-STOP-SHIFT-PM-TM,                                     
MFA-TR*               :I4-START-SHIFT-AH-TM,                                    
MFA-TR*               :I4-STOP-SHIFT-AH-TM ,                                    
MFA-TR*               :I4-MAX-DAY-WK-REQ-FL,                                    
MFA-TR*               :I4-MAX-DAILY-APPT-FL,                                    
MFA-TR*               :I4-MAX-DAILY-APPT,                                       
MFA-TR*               :I4-MAX-RE-PER-DAY-FL,                                    
MFA-TR*               :I4-MAX-RE-PER-DAY,                                       
MFA-TR*               :I4-MAX-AM-APPT-QT,                                       
MFA-TR*               :I4-MAX-RE-AM-QT,                                         
MFA-TR*               :I4-MAX-PM-APPT-QT,                                       
MFA-TR*               :I4-MAX-RE-PM-QT,                                         
MFA-TR*               :I4-MAX-DAILY-WK-REQ                                      
MFA-TR*          FROM CSS_WKAREA_PRMSSN                                         
MFA-TR*         WHERE WORK_AREA_ID = :I4-WORK-AREA-ID                           
MFA-TR*           AND BLOCK_TYPE_ID = :I4-BLOCK-TYPE-ID                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO I4-START-SHIFT-AM-TM                  
                                  I4-START-SHIFT-AM-TM                  
                                  I4-STOP-SHIFT-AM-TM                   
                                  I4-STOP-SHIFT-PM-TM                   
                                  I4-START-SHIFT-AH-TM                  
                                  I4-STOP-SHIFT-AH-TM                   
                                  I4-MAX-DAY-WK-REQ-FL                  
                                  I4-MAX-DAILY-APPT-FL                  
                                  I4-MAX-RE-PER-DAY-FL                  
                   MOVE ZEROES TO I4-MAX-AM-APPT-QT                     
                                  I4-MAX-RE-AM-QT                       
                                  I4-MAX-PM-APPT-QT                     
                                  I4-MAX-RE-PM-QT                       
                                  I4-MAX-DAILY-WK-REQ                   
                                  I4-MAX-DAILY-APPT                     
                                  I4-MAX-RE-PER-DAY                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_WKAREA_PRMSSN' TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'   TO TABLE-ELEMENT-1             
                   MOVE I4-WORK-AREA-ID  TO HOSTVAR-ELEMENT-1           
                   MOVE 'BLOCK_TYPE_ID'  TO TABLE-ELEMENT-1             
                   MOVE I4-BLOCK-TYPE-ID TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
