       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04109.                                          
COB303 DATE-WRITTEN.      FEBRUARY 13, 2008.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS THE WORKGROUP CALENDAR FOR THE WEB.       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/13/08    FMB      NEW PROGRAM.                                      
P00544*  11/14/11    FMB      ADD CSS_BLOCK_OUT_DAYS AND DELINQUENCY.           
A04086*  11/22/12    FMB      FIX SEB HOLIDAY LOOP.                             
A05189*  02/26/15    FMB      ALL DAYS AVAILABLE FOR AROP OR READ ONLY          
A05189*                       ORDERS.                                           
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04109'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04109 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKARPR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKAR                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
P00544     EXEC SQL                                                             
P00544        INCLUDE TBBLKDAY                                                  
P00544     END-EXEC.                                                            
                                                                        
P00544     EXEC SQL                                                             
P00544        INCLUDE TBDELQ                                                    
P00544     END-EXEC.                                                            
                                                                        
A05189     EXEC SQL                                                             
A05189        INCLUDE TBWKTYP                                                   
A05189     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04109_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-CALENDAR-DT          PIC X(10) VALUE SPACES.           
           05  S-GOOD-DAY             PIC X(01) VALUE SPACES.           
           05  S-TOTAL-SO-HRS         PIC X(06) VALUE SPACES.           
           05  S-MAX-RE-PER-DAY       PIC S9(4) COMP VALUE 0.           
           05  S-TOTAL-SO             PIC S9(4) COMP VALUE 0.           
           05  S-MAX-DAILY-WK-REQ     PIC S9(4) COMP VALUE 0.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-SERV-ORDER-NO-CHAR    PIC X(13).                      
           05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO-CHAR 
                                        PIC 9(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04109'.     
           05  WS-GOOD-DATE             PIC X(01) VALUE 'N'.            
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-SUB                   PIC 9(03) VALUE ZEROES.         
           05  WS-COUNT-DAYS            PIC 9(03) VALUE ZEROES.         
           05  WS-TOTAL-RES             PIC 9(06) VALUE ZEROES.         
           05  WS-TOTAL-RES-DEC         PIC 9(05)V9 VALUE ZEROES.       
           05  WS-PROCESS-DATE          PIC X(10) VALUE ZEROES.         
           05  WS-BEG-TS                PIC X(26) VALUE ZEROES.         
           05  WS-END-TS                PIC X(26) VALUE ZEROES.         
           05  WS-CALENDAR-FIELDS.                                      
               10 WS-DAY-OF-WEEK        PIC 9(01) VALUE ZEROES.         
               10 WS-DAY-OF-WEEK-CHAR   PIC X(01) VALUE SPACES.         
               10 WS-COUNT-SO-PER-DAY   PIC S9(4) COMP VALUE 0.         
               10 WS-DAYOFWEEK-ISO      PIC S9(9) COMP VALUE 0.         
               10 WS-MAX-DAILY-WK-REQ   PIC S9(4) COMP VALUE 0.         
               10 WS-MAX-RE-PER-DAY     PIC S9(4) COMP VALUE 0.         
               10 WS-NULL-SUM-LABOR-HR  PIC S9(4) COMP VALUE 0.         
               10 WS-HOLIDAY-FL         PIC X(01) VALUE 'N'.            
P00544         10 WS-BLOCK-FL           PIC X(01) VALUE 'N'.            
P00544         10 WS-RANGE-FL           PIC X(01) VALUE 'N'.            
           05  WS-TOTAL-SO-HRS          PIC S9(5)V9 COMP-3 VALUE 0.     
           05  WS-TOTAL-SO-HRS-NODEC    PIC 9(6)  VALUE 0.              
P00544     05  WS-PLUS-DAYS             PIC S9(08) COMP-3 VALUE +0.     
P00544     05  WS-INPUT-DATE            PIC X(10) VALUE SPACES.         
P00544     05  WS-OUTPUT-DATE           PIC X(10) VALUE SPACES.         
P00544     05  WS-STEP                  PIC S9(08) COMP-3 VALUE +0.     
P00544     05  WS-HOLIDAY               PIC X(01) VALUE SPACES.         
A05189     05  WS-AROP-FL               PIC X(01) VALUE SPACES.         
A05189     05  WS-READ-ONLY-FL          PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-TABLES.                                                   
           05  T1-PERMISSIONS         OCCURS 10                         
                                      INDEXED BY T1-INDEX.              
               10  T1-BLOCK-TYPE        PIC X(01).                      
               10  T1-MAX-DAILY-WK-REQ  PIC S9(4) COMP.                 
               10  T1-MAX-RE-PER-DAY    PIC S9(4) COMP.                 
           05  T2-CALENDAR            OCCURS 120                        
                                      INDEXED BY T2-INDEX.              
               10 T2-SCHED-DATE         PIC X(10).                      
               10 T2-GOOD-DAY           PIC X(01).                      
               10 T2-TOTAL-SO-HRS       PIC S9(5)V9 COMP.               
               10 T2-MAX-RE-PER-DAY     PIC S9(4) COMP.                 
               10 T2-TOTAL-SO           PIC S9(4) COMP.                 
               10 T2-MAX-DAILY-WK-REQ   PIC S9(4) COMP.                 
P00544     05  T3-BUSINESS-DAYS       OCCURS 30                         
P00544                                INDEXED BY T3-INDEX.              
P00544         10 T3-BUSINESS-DAY       PIC X(10).                      
A05189     05  T4-WORK-TYPES            PIC X(150).                     
A05189     05  T4-WORK-TYPES-R REDEFINES T4-WORK-TYPES.                 
A05189         10  T4-WORK-TYPE-LINE    OCCURS 30                       
A05189                                  INDEXED BY T4-INDEX.            
A05189             15 T4-WORK-TYPE      PIC X(03).                      
A05189             15 T4-CODE-UTIL-TYPE PIC X(01).                      
A05189             15 T4-FILLER         PIC X(01).                      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE PERMISSIONS_CURSOR CURSOR FOR                    
                   SELECT BLOCK_TYPE_ID,                                
                          SUM(CASE WHEN MAX_DAY_WK_REQ_FL <> 'Y'        
                              THEN 0                                    
                              ELSE MAX_DAILY_WK_REQ END),               
                          SUM(CASE WHEN MAX_RE_PER_DAY_FL <> 'Y'        
                              THEN 0                                    
                              ELSE MAX_RE_PER_DAY END)                  
                     FROM CSS_WKAREA_PRMSSN WITH(READUNCOMMITTED)               
                    WHERE WORK_AREA_ID IN                               
                     (SELECT WORK_AREA_ID                               
                        FROM CSS_WORK_AREA WITH(READUNCOMMITTED)                
                       WHERE WORK_GROUP_ID = :I2-WORK-GROUP-ID)         
                    GROUP BY BLOCK_TYPE_ID                              
                   FOR READ ONLY                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PERMISSIONS_CURSOR CURSOR FOR                            
MFA-TR*            SELECT BLOCK_TYPE_ID,                                        
MFA-TR*                   SUM(CASE WHEN MAX_DAY_WK_REQ_FL = 'Y'                
MFA-TR*                       THEN 0                                            
MFA-TR*                       ELSE MAX_DAILY_WK_REQ END),                       
MFA-TR*                   SUM(CASE WHEN MAX_RE_PER_DAY_FL = 'Y'                
MFA-TR*                       THEN 0                                            
MFA-TR*                       ELSE MAX_RE_PER_DAY END)                          
MFA-TR*              FROM CSS_WKAREA_PRMSSN                                     
MFA-TR*             WHERE WORK_AREA_ID IN                                       
MFA-TR*              (SELECT WORK_AREA_ID                                       
MFA-TR*                 FROM CSS_WORK_AREA                                      
MFA-TR*                WHERE WORK_GROUP_ID = :I2-WORK-GROUP-ID)                 
MFA-TR*             GROUP BY BLOCK_TYPE_ID                                      
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7010                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      CALENDAR_DT         AS CALENDAR_DATE,             
                      GOOD_DAY            AS GOOD_DAY,                  
                      TOTAL_SO_HRS        AS TOTAL_SO_HRS,              
                      MAX_RE_PER_DAY      AS MAX_RE_PER_DAY,            
                      TOTAL_SO            AS TOTAL_SO,                  
                      MAX_DAILY_WK_REQ    AS MAX_DAILY_WK_REQ           
               FROM #CSR04109_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               CALENDAR_DT         AS CALENDAR_DATE,                     
MFA-TR*               GOOD_DAY            AS GOOD_DAY,                          
MFA-TR*               TOTAL_SO_HRS        AS TOTAL_SO_HRS,                      
MFA-TR*               MAX_RE_PER_DAY      AS MAX_RE_PER_DAY,                    
MFA-TR*               TOTAL_SO            AS TOTAL_SO,                          
MFA-TR*               MAX_DAILY_WK_REQ    AS MAX_DAILY_WK_REQ                   
MFA-TR*        FROM SESSION.CSR04109_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-WORK-AREA-ID       PIC X(12).                           
       01  LINK-ASSIGNED-DATETIME  PIC X(26).                           
       01  LINK-SERV-ORDER-NO      PIC X(13).                           
       01  LINK-TOTAL-RES          PIC X(06).                           
       01  LINK-NO-DAYS            PIC X(03).                           
       01  LINK-SYSTEM-INITIATED   PIC X(03).                           
A05189 01  LINK-WORK-TYPES         PIC X(150).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-WORK-AREA-ID                             
                          LINK-ASSIGNED-DATETIME                        
                          LINK-SERV-ORDER-NO                            
                          LINK-TOTAL-RES                                
                          LINK-NO-DAYS                                  
                          LINK-SYSTEM-INITIATED                         
A05189                    LINK-WORK-TYPES.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04109_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04109_R1
              (                                                          
               RETURN_CODE          INT,                            
               CALENDAR_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               GOOD_DAY CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
      *        TOTAL_SO_HRS         DECIMAL(5,1),                               
               TOTAL_SO_HRS CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2,          
               MAX_RE_PER_DAY       SMALLINT,                           
               TOTAL_SO             SMALLINT,                           
               MAX_DAILY_WK_REQ     SMALLINT                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04109_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
               END-IF
           END-IF.      
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-NO-DAYS NOT NUMERIC                                  
               MOVE '030' TO LINK-NO-DAYS
           END-IF.                              
           IF LINK-TOTAL-RES NOT NUMERIC                                
               MOVE ZEROES TO LINK-TOTAL-RES
           END-IF.                           
           MOVE LINK-TOTAL-RES TO WS-TOTAL-RES.                         
           MOVE WS-TOTAL-RES(1:5) TO WS-TOTAL-RES-DEC(1:5).             
           MOVE WS-TOTAL-RES(6:1) TO WS-TOTAL-RES-DEC(6:1).             
           MOVE LINK-NO-DAYS TO WS-COUNT-DAYS.                          
           IF WS-COUNT-DAYS > 120                                       
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE +999 TO S-RETURN-CODE                               
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE '0000000000000' TO LINK-SERV-ORDER-NO
           END-IF.              
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR.            
           MOVE WS-SERV-ORDER-NO-NUM TO VO-SERV-ORDER-NO.               
           MOVE LINK-WORK-AREA-ID TO I2-WORK-AREA-ID.                   
A05189     IF LINK-WORK-AREA-ID(1:4) = 'AROP'                           
A05189         MOVE 'Y' TO WS-AROP-FL                                   
A05189     ELSE                                                         
A05189         MOVE 'N' TO WS-AROP-FL
           END-IF.                                  
           MOVE LINK-ASSIGNED-DATETIME(1:10) TO WS-PROCESS-DATE         
                                                WS-INPUT-DATE.          
P00544     PERFORM 7005-SELECT-DELINQUENCY THRU 7005-EXIT.              
P00544     IF WS-PLUS-DAYS > 0                                          
P00544        PERFORM 1020-BUILD-TABLE THRU 1020-EXIT VARYING           
P00544            T3-INDEX FROM 1 BY 1 UNTIL                            
P00544            T3-INDEX > 30 OR T3-INDEX > WS-PLUS-DAYS
           END-IF.             
                                                                        
           PERFORM 7000-GET-WORK-GROUP THRU 7000-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05189         MOVE LINK-WORK-TYPES TO T4-WORK-TYPES                    
A05189         MOVE 'Y' TO WS-READ-ONLY-FL                              
A05189         PERFORM 1200-CHECK-WORK-TYPES THRU 1200-EXIT VARYING     
A05189             T4-INDEX FROM 1 BY 1 UNTIL                           
SCA006             WS-READ-ONLY-FL = 'N' OR 
                   T4-INDEX > 30 OR 
                   T4-WORK-TYPE (T4-INDEX) <= SPACES                            
               PERFORM 7010-OPEN-CURSOR THRU 7010-EXIT                  
               PERFORM 1010-BUILD-TABLE THRU 1010-EXIT VARYING          
                    T1-INDEX FROM 1 BY 1 UNTIL                          
                    T1-INDEX > 10 OR                                    
                    WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
               PERFORM 7030-CLOSE-CURSOR THRU 7030-EXIT                 
               PERFORM 3000-BUILD-CALENDAR THRU 3000-EXIT               
                   VARYING WS-SUB FROM WS-COUNT-DAYS BY -1              
                   UNTIL WS-SUB = 0                                     
           ELSE                                                         
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1010-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH PERMISSIONS_CURSOR                                 
               INTO :I4-BLOCK-TYPE-ID,                                  
                    :I4-MAX-DAILY-WK-REQ,                               
                    :I4-MAX-RE-PER-DAY                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE I4-BLOCK-TYPE-ID TO                             
                        T1-BLOCK-TYPE (T1-INDEX)                        
                   MOVE I4-MAX-DAILY-WK-REQ TO                          
                        T1-MAX-DAILY-WK-REQ (T1-INDEX)                  
                   MOVE I4-MAX-RE-PER-DAY TO                            
                        T1-MAX-RE-PER-DAY (T1-INDEX)                    
               WHEN NOT-FOUND                                           
                   GO TO 1010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '1010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                   ABEND-TABLES         
                   MOVE 'CSS_WKAREA_PRMSSN' TO TABLE-1                  
                   MOVE 'CSS_WORK_AREA'     TO TABLE-2                  
                   MOVE 'WORK_GROUP_ID'     TO TABLE-ELEMENT-1          
                   MOVE I2-WORK-GROUP-ID    TO HOSTVAR-ELEMENT-1        
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
           END-EVALUATE.                                                
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00544 1020-BUILD-TABLE.                                                
P00544                                                                  
P00544     PERFORM 1100-BUSINESS-DAY THRU 1100-EXIT.                    
P00544     MOVE WS-OUTPUT-DATE TO T3-BUSINESS-DAY (T3-INDEX).           
P00544     ADD +1 TO WS-STEP.                                           
P00544                                                                  
P00544 1020-EXIT.                                                       
P00544     EXIT.                                                        
                                                                        
P00544 1100-BUSINESS-DAY.                                               
P00544                                                                  
P00544     EXEC SQL                                                     
P00544         SELECT
              DATEADD( DAY, CIS.DECIMAL2DAY(:WS-STEP), 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-OUTPUT-DATE                                   
P00544     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-INPUT-DATE) +                                  
MFA-TR*                 DAY(:WS-STEP) DAYS)                                     
MFA-TR*          INTO :WS-OUTPUT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00544     EXEC SQL                                                     
P00544         SELECT
              CIS.DAYOFWEEK_ISO( IIF(TRY_CONVERT(DATE, :WS-OUTPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OUTPUT-DATE
              ) <> 0) OR (LEN(:WS-OUTPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-OUTPUT-DATE
              ), CONVERT(DATE, :WS-OUTPUT-DATE) ) )
            INTO
              :WS-DAYOFWEEK-ISO                                 
P00544     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  DAYOFWEEK_ISO(:WS-OUTPUT-DATE)                           
MFA-TR*          INTO :WS-DAYOFWEEK-ISO                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00544     MOVE WS-DAYOFWEEK-ISO TO WS-DAY-OF-WEEK.                     
P00544     IF WS-DAY-OF-WEEK = 6 OR 7                                   
P00544         ADD 1 TO WS-STEP                                         
P00544         GO TO 1100-BUSINESS-DAY
           END-IF.                                 
A04086     MOVE WS-OUTPUT-DATE TO J8-HOLIDAY-DT.                        
P00544     PERFORM 7100-CHECK-HOLIDAY THRU 7100-EXIT.                   
P00544     IF WS-HOLIDAY = 'Y'                                          
P00544         ADD 1 TO WS-STEP                                         
P00544         GO TO 1100-BUSINESS-DAY
           END-IF.                                 
P00544                                                                  
P00544 1100-EXIT.                                                       
P00544      EXIT.                                                       
                                                                        
A05189 1200-CHECK-WORK-TYPES.                                           
A05189                                                                  
A05189     MOVE T4-WORK-TYPE (T4-INDEX) TO L4-WORK-TYPE-CD.             
A05189     MOVE I2-COMPANY-NO TO L4-COMPANY-NO.                         
A05189     PERFORM 7400-SELECT-WORK-TYPE THRU 7400-EXIT.                
A05189     IF L4-AROP-EXTRACT-IND NOT = 'Y'                             
A05189         MOVE 'N' TO WS-READ-ONLY-FL
           END-IF.                             
A05189                                                                  
A05189 1200-EXIT.                                                       
A05189      EXIT.                                                       
                                                                        
       3000-BUILD-CALENDAR.                                             
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
                      WS-CALENDAR-FIELDS.                               
                                                                        
           MOVE WS-PROCESS-DATE TO S-CALENDAR-DT                        
                                   WS-BEG-TS(1:10)                      
                                   WS-END-TS(1:10).                     
MAN016     MOVE ' 00:00:00.000000' TO WS-BEG-TS(11:16).                 
MAN016     MOVE ' 23:59:59.999999' TO WS-END-TS(11:16).                 
           PERFORM 7200-SUM-SO-DATA THRU 7200-EXIT.                     
                                                                        
           MOVE WS-PROCESS-DATE TO J8-HOLIDAY-DT                        
P00544                             ZZ-BLOCK-OUT-DT.                     
           PERFORM 7100-CHECK-HOLIDAY THRU 7100-EXIT.                   
P00544     IF WS-DAY-OF-WEEK = 0                                        
P00544         PERFORM 7300-CHECK-BLOCK THRU 7300-EXIT
           END-IF.                 
P00544     IF WS-DAY-OF-WEEK = 0 AND WS-PLUS-DAYS > 0                   
P00544         SET T3-INDEX TO +1                                       
P00544         SEARCH T3-BUSINESS-DAYS                                  
P00544             AT END                                               
P00544                 MOVE 'N' TO WS-RANGE-FL                          
P00544             WHEN WS-PROCESS-DATE = T3-BUSINESS-DAY (T3-INDEX)    
P00544                 MOVE 'Y' TO WS-RANGE-FL                          
P00544                 MOVE 8 TO WS-DAY-OF-WEEK                         
P00544         END-SEARCH
           END-IF.                                              
           IF WS-DAY-OF-WEEK = 0                                        
               EXEC SQL                                                 
                   SELECT
              CIS.DAYOFWEEK_ISO( IIF(TRY_CONVERT(DATE, :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) ) )
            INTO
              :WS-DAYOFWEEK-ISO                             
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*        EXEC SQL                                                         
MFA-TR*            VALUES DAYOFWEEK_ISO(:WS-PROCESS-DATE)                       
MFA-TR*              INTO :WS-DAYOFWEEK-ISO                                     
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               MOVE WS-DAYOFWEEK-ISO TO WS-DAY-OF-WEEK
           END-IF.                 
                                                                        
           MOVE WS-DAY-OF-WEEK TO WS-DAY-OF-WEEK-CHAR.                  
           SET T1-INDEX TO +1                                           
           SEARCH T1-PERMISSIONS                                        
               AT END                                                   
                   MOVE ZEROES TO WS-MAX-DAILY-WK-REQ                   
                                  WS-MAX-RE-PER-DAY                     
               WHEN WS-DAY-OF-WEEK-CHAR = T1-BLOCK-TYPE (T1-INDEX)      
                   MOVE T1-MAX-DAILY-WK-REQ (T1-INDEX) TO               
                        WS-MAX-DAILY-WK-REQ                             
                   MOVE T1-MAX-RE-PER-DAY (T1-INDEX) TO                 
                        WS-MAX-RE-PER-DAY                               
           END-SEARCH.                                                  
           COMPUTE VO-SO-EST-LABOR-HR =                                 
                   VO-SO-EST-LABOR-HR +                                 
                   WS-TOTAL-RES-DEC.                                    
           COMPUTE WS-COUNT-SO-PER-DAY =                                
                   WS-COUNT-SO-PER-DAY + 1.                             
           IF WS-MAX-RE-PER-DAY >= VO-SO-EST-LABOR-HR AND               
              WS-MAX-DAILY-WK-REQ >= WS-COUNT-SO-PER-DAY                
                  MOVE 'Y' TO S-GOOD-DAY                                
           ELSE                                                         
               MOVE 'N' TO S-GOOD-DAY
           END-IF.                                  
A05189     IF WS-AROP-FL = 'Y' OR                                       
A05189        WS-READ-ONLY-FL = 'Y'                                     
A05189            EVALUATE WS-DAY-OF-WEEK-CHAR                          
A05189                WHEN '6'                                          
A05189                WHEN '7'                                          
A05189                    MOVE 'N' TO S-GOOD-DAY                        
A05189                WHEN OTHER                                        
A05189                    MOVE 'Y' TO S-GOOD-DAY                        
A05189            END-EVALUATE
           END-IF.                                         
           IF WS-HOLIDAY-FL = 'Y'                                       
               MOVE 'N' TO S-GOOD-DAY
           END-IF.                                  
P00544     IF WS-BLOCK-FL = 'Y'                                         
P00544         MOVE 'N' TO S-GOOD-DAY
           END-IF.                                  
P00544     IF WS-RANGE-FL = 'Y'                                         
P00544         MOVE 'N' TO S-GOOD-DAY
           END-IF.                                  
           MOVE WS-MAX-RE-PER-DAY TO S-MAX-RE-PER-DAY.                  
           MOVE WS-MAX-DAILY-WK-REQ TO S-MAX-DAILY-WK-REQ.              
           MOVE VO-SO-EST-LABOR-HR TO WS-TOTAL-SO-HRS.                  
           MOVE WS-COUNT-SO-PER-DAY TO S-TOTAL-SO.                      
                                                                        
           COMPUTE WS-TOTAL-SO-HRS-NODEC =                              
                   WS-TOTAL-SO-HRS * 10.                                
           MOVE WS-TOTAL-SO-HRS-NODEC TO S-TOTAL-SO-HRS.                
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) ) )
            INTO
              :WS-PROCESS-DATE                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-PROCESS-DATE) + 1 DAY)                         
MFA-TR*          INTO :WS-PROCESS-DATE                                          
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-GET-WORK-GROUP.                                             
                                                                        
           EXEC SQL                                                     
               SELECT WORK_GROUP_ID,                                    
A05189                COMPANY_NO                                        
                 INTO :I2-WORK-GROUP-ID,                                
A05189                :I2-COMPANY-NO                                    
                 FROM CSS_WORK_AREA WITH(READUNCOMMITTED)                       
                WHERE WORK_AREA_ID = :I2-WORK-AREA-ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_GROUP_ID,                                            
MFA-TR*               COMPANY_NO                                                
MFA-TR*          INTO :I2-WORK-GROUP-ID,                                        
MFA-TR*               :I2-COMPANY-NO                                            
MFA-TR*          FROM CSS_WORK_AREA                                             
MFA-TR*         WHERE WORK_AREA_ID = :I2-WORK-AREA-ID                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_WORK_AREA'       TO TABLE-1                     
              MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-1             
              MOVE I2-WORK-AREA-ID       TO HOSTVAR-ELEMENT-1           
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              PERFORM 9999-END-PROGRAM THRU 9999-EXIT                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00544 7005-SELECT-DELINQUENCY.                                         
P00544                                                                  
P00544     EXEC SQL                                                     
P00544        SELECT DELINQ_VALUE                                       
P00544          INTO :C8-DELINQ-VALUE                                   
P00544          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
P00544         WHERE DELINQ_CD = 'BLOCK-PLUS-DAYS'                      
P00544           AND COMPANY_NO = '01'                                  
P00544                                                           
P00544                                                      
P00544     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = 'BLOCK-PLUS-DAYS'                              
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00544                                                                  
P00544     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00544     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00544         WHEN SUCCESSFUL-CALL                                     
P00544             MOVE C8-DELINQ-VALUE TO WS-PLUS-DAYS                 
P00544         WHEN NOT-FOUND                                           
P00544             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00544             MOVE 0 TO WS-PLUS-DAYS                               
P00544         WHEN OTHER                                               
P00544             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00544             MOVE '7005'           TO ACTIVE-PARAGRAPH            
P00544             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00544             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00544                                      ABEND-TABLES                
P00544             MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
P00544             MOVE 'DATABASE'       TO TABLE-ELEMENT-1             
P00544             PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
P00544             PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
P00544     END-EVALUATE.                                                
P00544                                                                  
P00544 7005-EXIT.                                                       
P00544     EXIT.                                                        
                                                                        
       7010-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN PERMISSIONS_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_WKAREA_PRMSSN'     TO TABLE-1                  
               MOVE 'CSS_WORK_AREA'         TO TABLE-2                  
               MOVE 'WORK_GROUP_ID'         TO TABLE-ELEMENT-1          
               MOVE I2-WORK-GROUP-ID        TO HOSTVAR-ELEMENT-1        
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT                  
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE PERMISSIONS_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_WKAREA_PRMSSN'     TO TABLE-1                  
               MOVE 'CSS_WORK_AREA'         TO TABLE-2                  
               MOVE 'WORK_GROUP_ID'         TO TABLE-ELEMENT-1          
               MOVE I2-WORK-GROUP-ID        TO HOSTVAR-ELEMENT-1        
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT                  
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CHECK-HOLIDAY.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOLIDAY_DT,
              'Y'                                               
                 INTO :J8-HOLIDAY-DT,                                   
P00544                :WS-HOLIDAY                                       
                 FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                         
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOLIDAY_DT,                                               
MFA-TR*               'Y'                                                       
MFA-TR*          INTO :J8-HOLIDAY-DT,                                           
MFA-TR*               :WS-HOLIDAY                                               
MFA-TR*          FROM CSS_HOLIDAY                                               
MFA-TR*         WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 8 TO WS-DAY-OF-WEEK                             
                   MOVE 'Y' TO WS-HOLIDAY-FL                            
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-HOLIDAY-FL                            
A04086                         WS-HOLIDAY                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_HOLIDAY'    TO TABLE-1                     
                   MOVE 'HOLIDAY_DT'     TO TABLE-ELEMENT-1             
                   MOVE J8-HOLIDAY-DT    TO HOSTVAR-ELEMENT-1           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SUM-SO-DATA.                                                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(SO_EST_LABOR_HR),                             
                      COUNT(SERV_ORDER_NO)                              
                 INTO :VO-SO-EST-LABOR-HR :WS-NULL-SUM-LABOR-HR,         
                      :WS-COUNT-SO-PER-DAY                              
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                 
                WHERE ASSIGNED_DATETIME >= :WS-BEG-TS                   
                  AND ASSIGNED_DATETIME <= :WS-END-TS                   
                  AND SERV_ORDER_NO <> :VO-SERV-ORDER-NO                
                  AND WORK_AREA_ID IN                                   
                     (SELECT WORK_AREA_ID                               
                        FROM CSS_WORK_AREA WITH(READUNCOMMITTED)                
                       WHERE WORK_GROUP_ID = :I2-WORK-GROUP-ID)         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(SO_EST_LABOR_HR),                                     
MFA-TR*               COUNT(SERV_ORDER_NO)                                      
MFA-TR*          INTO :VO-SO-EST-LABOR-HR:WS-NULL-SUM-LABOR-HR,                 
MFA-TR*               :WS-COUNT-SO-PER-DAY                                      
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ASSIGNED_DATETIME >= :WS-BEG-TS                           
MFA-TR*           AND ASSIGNED_DATETIME <= :WS-END-TS                           
MFA-TR*           AND SERV_ORDER_NO = :VO-SERV-ORDER-NO                        
MFA-TR*           AND WORK_AREA_ID IN                                           
MFA-TR*              (SELECT WORK_AREA_ID                                       
MFA-TR*                 FROM CSS_WORK_AREA                                      
MFA-TR*                WHERE WORK_GROUP_ID = :I2-WORK-GROUP-ID)                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-SUM-LABOR-HR < 0                          
                       MOVE 0 TO VO-SO-EST-LABOR-HR                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT-SO-PER-DAY                        
                             VO-SO-EST-LABOR-HR                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ASSIGNED_DATETIME'  TO TABLE-ELEMENT-1         
                   MOVE WS-PROCESS-DATE  TO HOSTVAR-ELEMENT-1           
                   MOVE 'WORK_GROUP_ID'  TO TABLE-ELEMENT-2             
                   MOVE I2-WORK-GROUP-ID TO HOSTVAR-ELEMENT-2           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                   PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00544 7300-CHECK-BLOCK.                                                
P00544                                                                  
P00544     EXEC SQL                                                     
P00544         SELECT BLOCK_OUT_DT                                      
P00544           INTO :ZZ-BLOCK-OUT-DT                                  
P00544           FROM CSS_BLOCK_OUT_DAYS WITH(READUNCOMMITTED)                  
P00544          WHERE BLOCK_OUT_DT = IIF(TRY_CONVERT(DATE, 
                                                       :ZZ-BLOCK-OUT-DT
              ) IS NULL OR (PATINDEX('%.%', :ZZ-BLOCK-OUT-DT
              ) <> 0) OR (LEN(:ZZ-BLOCK-OUT-DT) <> 10), CIS.CHAR2DATE(
                                                       :ZZ-BLOCK-OUT-DT
              ), CONVERT(DATE, :ZZ-BLOCK-OUT-DT) )                   
P00544                                                           
P00544                                                      
P00544     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BLOCK_OUT_DT                                              
MFA-TR*          INTO :ZZ-BLOCK-OUT-DT                                          
MFA-TR*          FROM CSS_BLOCK_OUT_DAYS                                        
MFA-TR*         WHERE BLOCK_OUT_DT = :ZZ-BLOCK-OUT-DT                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00544                                                                  
P00544     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00544                                                                  
P00544     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00544         WHEN SUCCESSFUL-CALL                                     
P00544             MOVE 8 TO WS-DAY-OF-WEEK                             
P00544             MOVE 'Y' TO WS-HOLIDAY-FL                            
P00544         WHEN NOT-FOUND                                           
P00544             MOVE 'N' TO WS-HOLIDAY-FL                            
P00544         WHEN OTHER                                               
P00544             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00544             MOVE '7300'           TO ACTIVE-PARAGRAPH            
P00544             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00544             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00544                                           ABEND-TABLES           
P00544             MOVE 'CSS_BLOCK_OUT_DAYS'  TO TABLE-1                
P00544             MOVE 'BLOCK_OUT_DT'   TO TABLE-ELEMENT-1             
P00544             MOVE ZZ-BLOCK-OUT-DT  TO HOSTVAR-ELEMENT-1           
P00544             PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
P00544             PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
P00544     END-EVALUATE.                                                
P00544                                                                  
P00544 7300-EXIT.                                                       
P00544     EXIT.                                                        
                                                                        
A05189 7400-SELECT-WORK-TYPE.                                           
A05189                                                                  
A05189     EXEC SQL                                                     
A05189         SELECT AROP_EXTRACT_IND                                  
A05189           INTO :L4-AROP-EXTRACT-IND                              
A05189           FROM CSS_WORK_TYPE WITH(READUNCOMMITTED)                       
A05189          WHERE WORK_TYPE_CD = :L4-WORK-TYPE-CD                   
A05189            AND COMPANY_NO = :L4-COMPANY-NO                       
A05189                                                           
A05189                                                      
A05189     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AROP_EXTRACT_IND                                          
MFA-TR*          INTO :L4-AROP-EXTRACT-IND                                      
MFA-TR*          FROM CSS_WORK_TYPE                                             
MFA-TR*         WHERE WORK_TYPE_CD = :L4-WORK-TYPE-CD                           
MFA-TR*           AND COMPANY_NO = :L4-COMPANY-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05189                                                                  
A05189     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05189         WHEN SUCCESSFUL-CALL                                     
A05189             CONTINUE                                             
A05189         WHEN NOT-FOUND                                           
A05189             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05189             MOVE 'N' TO L4-AROP-EXTRACT-IND                      
A05189         WHEN OTHER                                               
A05189             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A05189             MOVE '7400'           TO ACTIVE-PARAGRAPH            
A05189             MOVE 'SELECT'         TO ABEND-FUNCTION              
A05189             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A05189                                           ABEND-TABLES           
A05189             MOVE 'CSS_WORK_TYPE'  TO TABLE-1                     
A05189             MOVE 'WORK_TYPE_CD'   TO TABLE-ELEMENT-1             
A05189             MOVE L4-WORK-TYPE-CD  TO HOSTVAR-ELEMENT-1           
A05189             MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-2             
A05189             MOVE L4-COMPANY-NO    TO HOSTVAR-ELEMENT-2           
A05189             PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
A05189             PERFORM 9999-END-PROGRAM THRU 9999-EXIT              
A05189     END-EVALUATE.                                                
A05189                                                                  
A05189 7400-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04109_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04109_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04109_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04109_R1                            
             (                                                          
              RETURN_CODE,                                              
              CALENDAR_DT,                                              
              GOOD_DAY,                                                 
              TOTAL_SO_HRS,                                             
              MAX_RE_PER_DAY,                                           
              TOTAL_SO,                                                 
              MAX_DAILY_WK_REQ                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-CALENDAR-DT,                                          
               :S-GOOD-DAY,                                             
               :S-TOTAL-SO-HRS,                                         
               :S-MAX-RE-PER-DAY,                                       
               :S-TOTAL-SO,                                             
               :S-MAX-DAILY-WK-REQ                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04109_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CALENDAR_DT,                                                      
MFA-TR*       GOOD_DAY,                                                         
MFA-TR*       TOTAL_SO_HRS,                                                     
MFA-TR*       MAX_RE_PER_DAY,                                                   
MFA-TR*       TOTAL_SO,                                                         
MFA-TR*       MAX_DAILY_WK_REQ                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-CALENDAR-DT,                                                  
MFA-TR*        :S-GOOD-DAY,                                                     
MFA-TR*        :S-TOTAL-SO-HRS,                                                 
MFA-TR*        :S-MAX-RE-PER-DAY,                                               
MFA-TR*        :S-TOTAL-SO,                                                     
MFA-TR*        :S-MAX-DAILY-WK-REQ                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04109_R1'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
