       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04108.                                          
COB303 DATE-WRITTEN.      FEBRUARY 11, 2008.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CALCULATES WORK AREA FOR THE WEB ORDER.          *        
      *  STATUS CODE VALUES ARE:                                       *        
      *      100   ORDER NOT FOUND                                     *        
      *      999   ORDER STATE NOT ACTIVE                              *        
      *      999   INVALID WORK TYPE                                   *        
      *      999   MORE THAN TWO METERS                                *        
      *      999   ERROR CALLING CSR01116                              *        
      *  TABLES CONTAIN:                                               *        
      *      T1    WORK TYPE AND EST LABOR HOURS                       *        
      *      T2    METER DATA                                          *        
      *      T3    SNAPSHOT DATA                                       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/11/08    FMB      NEW PROGRAM.                                      
      *  06/19/09    SC41135  CHANGES TO ACCOMODATE MORE METERS-A1387  *        
A00560*  07/07/09    FMB      CHANGES TO WORK AREA CALCULATION.        *        
P00718*  02/20/14    VV       ADDITIONAL RETURN FIELD FOR BUSINESS UNIT*        
A05189*  03/02/14    FMB      DETERMINE AROP ELIGIBILITY.              *        
P01176*  10/06/16    FMB      GAS SAMPLE TEST.                         *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04108'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04108 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
A00560     EXEC SQL                                                             
A00560        INCLUDE TBLOCOFC                                                  
A00560     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBPREM                                                    
P00718     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBSOLOC                                                   
P00718     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBRGREAD                                                  
P00718     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04108_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-SERV-ORDER-NO        PIC X(13) VALUE SPACES.          
           05  RS-ASSIGNED-DATETIME    PIC X(26) VALUE SPACES.          
           05  RS-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.          
           05  RS-ORDER-STATE-CD       PIC X(01) VALUE SPACES.          
           05  RS-ORDER-REASON         PIC X(15) VALUE SPACES.          
      *    05  RS-WK-TOTAL-RES         PIC S9(5)V9(1) COMP-3 VALUE 0.0.         
           05  RS-WK-TOTAL-RES         PIC X(06) VALUE SPACES.          
           05  RS-WORK-AREA            PIC X(12) VALUE SPACES.          
P00718     05  RS-BUSINESS-UNIT        PIC X(03) VALUE SPACES.          
P00718     05  RS-WORK-DISTRICT        PIC X(40) VALUE SPACES.          
P00718     05  RS-WORK-TYPES           PIC X(150) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
           05  S-ASSIGNED-DATETIME    PIC X(26) VALUE SPACES.           
           05  S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.           
           05  S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.           
           05  S-ORDER-REASON         PIC X(15) VALUE SPACES.           
      *    05  S-WK-TOTAL-RES         PIC S9(5)V9(1) COMP-3 VALUE 0.0.          
           05  S-WK-TOTAL-RES         PIC X(06) VALUE SPACES.           
           05  S-WORK-AREA            PIC X(12) VALUE SPACES.           
P00718     05  S-BUSINESS-UNIT        PIC X(03) VALUE SPACES.           
P00718     05  S-WORK-DISTRICT        PIC X(40) VALUE SPACES.           
P00718     05  S-WORK-TYPES           PIC X(150) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 NORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-SERV-ORDER-NO-CHAR    PIC X(13).                      
           05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO-CHAR 
                                        PIC 9(13).                      
           05  WS-READ-ROUTE-NUM        PIC 9(04).                      
           05  WS-READ-ROUTE-CHAR       REDEFINES WS-READ-ROUTE-NUM     
                                        PIC X(04).                      
           05  WS-GIS-POINT-ID          PIC 9(09).                      
           05  WS-GIS-POINT-ID-CHAR     REDEFINES WS-GIS-POINT-ID       
                                        PIC X(09).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04108'.     
           05  WS-WORK-TYPE-CD          PIC X(03) VALUE SPACES.         
           05  WS-T2-SUB                PIC 9(4) VALUE 0.               
           05  WS-T3-SUB                PIC 9(4) VALUE 0.               
           05  WS-WORK-TYPE-SUB         PIC 9(9) VALUE 0.               
           05  WS-CALCULATE-RES         PIC 9(5)V9 VALUE 0.0.           
           05  WS-NULL-RLSE-DT          PIC S9(04) COMP VALUE ZERO.     
           05  WS-WK-TOTAL-RES          PIC S9(5)V9(1) COMP-3 VALUE 0.0.
           05  WS-WK-TOTAL-RES-NODEC    PIC 9(6) VALUE 0.               
           05  WS-APPLIANCES-AT-PREMISE PIC X(01) VALUE 'N'.            
A00560     05  WS-CRAWL-LOCAL-OFFICE    PIC X(01) VALUE 'N'.            
P00718     05  WS-MULTI-REG-MTR         PIC X(01) VALUE 'N'.            
P00718     05  WS-WORK-DISTRICT         PIC X(40) VALUE SPACES.         
P00718     05  WS-TASK-TYPES            PIC X(150) VALUE SPACES.        
P00718     05  WS-TASK-TYPE             PIC X(4)  VALUE SPACES.         
P00718     05  WS-COUNT                 PIC S9(3) COMP-3 VALUE 0.       
A05189     05  WS-AROP-EXTRACT-IND      PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-TABLES.                                                   
           05  T1-WORK-TYPE           OCCURS 300                        
                                      INDEXED BY T1-INDEX.              
               10  T1-WORK-TYPE-CD      PIC X(03).                      
COB305         10 T1-EST-LABOR-HRS        PIC S9(1)V9(1) USAGE COMP-3 
COB305           VALUE 0.    
A05189         10  T1-AROP-EXTRACT-IND  PIC X(01).                      
           05  T2-CSR01121            OCCURS 10                         
                                      INDEXED BY T2-INDEX.              
               10 T2-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
               10 T2-SO-INST-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T2-RATE-PLAN-NO       PIC X(03) VALUE SPACES.         
               10 T2-RATE-DESC          PIC X(50) VALUE SPACES.         
               10 T2-METER-NO           PIC X(09) VALUE SPACES.         
               10 T2-METER-LOC-DESC     PIC X(14) VALUE SPACES.         
               10 T2-CODE-MTR-STATUS-WS PIC X(01) VALUE SPACES.         
               10 T2-CODE-STATUS-REA-WS PIC X(01) VALUE SPACES.         
               10 T2-METER-SUPPLYING    PIC X(15) VALUE SPACES.         
               10 T2-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T2-HOLD-RELEASE       PIC X(01) VALUE SPACES.         
               10 T2-RLSE-NO            PIC X(10) VALUE SPACES.         
               10 T2-RLSE-DATE          PIC X(26) VALUE SPACES.         
               10 T2-CODE-METER-LOC     PIC X(02) VALUE SPACES.         
               10 T2-PER-TEMP-IND       PIC X(01) VALUE SPACES.         
               10 T2-IC-NO              PIC S9(4) COMP VALUE 0.         
               10 T2-METER-IND          PIC X(01) VALUE SPACES.         
               10 T2-MTR-REF-NO         PIC S9(4) COMP VALUE 0.         
               10 T2-RLSE-IND           PIC X(01) VALUE SPACES.         
           05  T3-CSR02210            OCCURS 20                         
                                      INDEXED BY T3-INDEX.              
               10 T3-TABLE-ID           PIC X(02) VALUE SPACES.         
               10 T3-CODE-METER-S       PIC X(01) VALUE SPACES.         
               10 T3-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
               10 T3-RATE-PLAN-NO       PIC X(03) VALUE SPACES.         
                                                                        
      *****************************************************************         
      * CSR01121 - GET METER DATA FOR EXISTING ORDER                            
      *****************************************************************         
                                                                        
       01  CSR01121-RETURN-DATA.                                        
           03  RETURN-CODE-1121         PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-1121      PIC X(01) VALUE SPACES.         
           03  SO-INST-SEQ-NO-1121      PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-NO-1121        PIC X(03) VALUE SPACES.         
           03  RATE-DESC-1121           PIC X(50) VALUE SPACES.         
           03  METER-NO-1121            PIC X(09) VALUE SPACES.         
           03  METER-LOC-DESC-1121      PIC X(14) VALUE SPACES.         
           03  CODE-MTR-STATUS-WS-1121  PIC X(01) VALUE SPACES.         
           03  CODE-STATUS-REA-WS-1121  PIC X(01) VALUE SPACES.         
           03  METER-SUPPLYING-1121     PIC X(15) VALUE SPACES.         
           03  WORK-TYPE-CD-1121        PIC X(03) VALUE SPACES.         
           03  HOLD-RELEASE-1121        PIC X(01) VALUE SPACES.         
           03  RLSE-NO-1121             PIC X(10) VALUE SPACES.         
           03  RLSE-DATE-1121           PIC X(26) VALUE SPACES.         
           03  CODE-METER-LOC-1121      PIC X(02) VALUE SPACES.         
           03  PER-TEMP-IND-1121        PIC X(01) VALUE SPACES.         
           03  IC-NO-1121               PIC S9(4) COMP VALUE 0.         
           03  METER-IND-1121           PIC X(01) VALUE SPACES.         
           03  MTR-REF-NO-1121          PIC S9(4) COMP VALUE 0.         
           03  RLSE-IND-1121            PIC X(01) VALUE SPACES.         
                                                                        
      *****************************************************************         
      * CSR01116 - CALCULATE WORK AREA                                          
      *****************************************************************         
                                                                        
       01  CSR01116-CALL-DATA.                                          
           03  LOCAL-OFFICE-1116        PIC X(03) VALUE SPACES.         
A1387      03  CODE-UTIL-TYPE-1116      PIC X(50) VALUE SPACES.         
A1387      03  WORK-TYPE-CD-1116        PIC X(150) VALUE SPACES.        
           03  CRAWL-IND-1116           PIC X(01) VALUE SPACES.         
A1387      03  METER-IND-1116           PIC X(50) VALUE SPACES.         
           03  ZIP-CODE-1116            PIC X(05) VALUE SPACES.         
           03  READ-ROUTE-1116          PIC X(04) VALUE SPACES.         
           03  POINT-ID-1116            PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR01116-RETURN-DATA.                                        
           03  RETURN-CODE-1116         PIC S9(9) COMP VALUE 0.         
           03  WORK-AREA-1116           PIC X(12) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-1116       PIC X(03) VALUE SPACES.         
                                                                        
      *****************************************************************         
      * CSR02210 - SNAPSHOT                                                     
      *****************************************************************         
                                                                        
       01  CSR02210-CALL-DATA.                                          
           03  ACCOUNT-NO-2210          PIC X(13) VALUE SPACES.         
           03  PREMISE-NO-2210          PIC X(10) VALUE SPACES.         
           03  COMPANY-NO-2210          PIC X(02) VALUE SPACES.         
           03  MKTG-ORDER-2210          PIC X(01) VALUE SPACES.         
           03  RETURN-UTILS-2210        PIC X(01) VALUE SPACES.         
           03  RETURN-DISC-BAL-2210     PIC X(01) VALUE SPACES.         
           03  ORDER-REASON-2210        PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02210-RETURN-DATA.                                        
           05  RETURN-CODE-2210      PIC S9(9)     COMP VALUE 0.        
           05  ACTIVE-PARA-2210      PIC X(30)     VALUE SPACES.        
           05  TABLE-NAME-2210       PIC X(30)     VALUE SPACES.        
           05  TABLE-ID-2210         PIC X(2)      VALUE SPACES.        
           05  UT-CODE-UTIL-TY-2210  PIC X(1)      VALUE SPACES.        
           05  UT-IC-NO-2210         PIC S9(4)     COMP VALUE 0.        
           05  UT-READ-ROUTE-2210    PIC S9(4)     COMP VALUE 0.        
           05  UT-RATE-PLAN-NO-2210  PIC X(3)      VALUE SPACES.        
           05  UT-RATE-DESC-2210     PIC X(25)     VALUE SPACES.        
           05  UT-CODE-REV-CLA-2210  PIC X(3)      VALUE SPACES.        
           05  UT-READ-CYCLE-2210    PIC X(2)      VALUE SPACES.        
           05  UT-CODE-SIC-NO-2210   PIC X(4)      VALUE SPACES.        
           05  MN-METER-NO-2210      PIC X(9)      VALUE SPACES.        
           05  MN-MTR-REF-NO-2210    PIC S9(4)     COMP VALUE 0.        
           05  MN-CODE-TIME-PE-2210  PIC S9(4)     COMP VALUE 0.        
           05  MN-LAST-READ-VA-2210  PIC S9(12)V999 COMP-3 VALUE 0.     
           05  MN-CD-STUS-RS-2210    PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-T-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-I-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-METER-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-METER-SUPPLY-2210  PIC X(15)     VALUE SPACES.        
           05  MN-CODE-METER-L-2210  PIC X(2)      VALUE SPACES.        
           05  MN-METER-LOC-DE-2210  PIC X(14)     VALUE SPACES.        
           05  MN-METER-IND-2210     PIC X(1)      VALUE SPACES.        
           05  MN-CONSTANT-2210      PIC S9(6)V    COMP-3 VALUE 0.      
           05  MN-NO-DIALS-2210      PIC S9(4) COMP VALUE 0.            
           05  MN-DIST-NODE-PO-2210  PIC X(20)     VALUE SPACES.        
           05  MN-POINT-ID-2210      PIC X(10)     VALUE SPACES.        
           05  MN-SEAL-CODE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-HEX-LOCATION-2210  PIC X(02)     VALUE SPACES.        
           05  MN-INSULATED-IN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-LOCK-TYPE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-DELIVERY-LEV-2210  PIC X(01)     VALUE SPACES.        
           05  MN-UTILITY-SOUR-2210  PIC X(01)     VALUE SPACES.        
           05  MN-IDR-RECIPIEN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-PROGRAM-ID-2210    PIC X(02)     VALUE SPACES.        
           05  MN-MTR-READ-SO-2210   PIC X(01)     VALUE SPACES.        
           05  RG-CODE-REG-ST-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-STATUS-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-TIME-P-2210   PIC S9(4)     COMP VALUE 0.        
           05  RG-CODE-USAGE-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-SRC-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  RG-LAST-READD-2210    PIC X(10)     VALUE SPACES.        
           05  RG-LST-READVL-2210    PIC S9(12)V9(3) COMP-3 VALUE 0.    
           05  RG-REG-ID-NO-2210     PIC S9(4)     COMP VALUE 0.        
           05  CP-NO-UNITS-2210      PIC S9(9)     COMP VALUE 0.        
           05  CP-CODE-PLAN-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-STATRS-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-SVC-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  CP-MTLY-AMT-FX-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-RT-ITEM-CD-2210    PIC S9(4)     COMP VALUE 0.        
           05  CP-LIGHT-NO-2210      PIC S9(4)     COMP VALUE 0.        
           05  CP-POLE-NO-2210       PIC X(7)      VALUE SPACES.        
           05  CP-DIST-NO-2210       PIC X(3)      VALUE SPACES.        
           05  CP-USAGE-FIXED-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-ITEM-SEQ-NO-2210   PIC S9(4)     COMP VALUE 0.        
           05  CP-EQUIP-ID-2210      PIC X(2)      VALUE SPACES.        
           05  PREM-DIR-IND-2210     PIC X(1)      VALUE SPACES.        
           05  SUBDIV-LIGHT-2210 PIC S9(3)V        COMP-3 VALUE 0.      
           05  ACCT-TYPE-2210        PIC X(1)      VALUE SPACES.        
           05  CD-RNTL-PROP-2210     PIC X(1)      VALUE SPACES.        
           05  LL-CUSTOMER-NO-2210   PIC S9(10)    COMP-3 VALUE 0.      
           05  REV-DIST-CD-2210      PIC X(3)      VALUE SPACES.        
           05  DISC-BAL-2210         PIC S9(11)V99 COMP-3 VALUE 0.      
           05  OUT-ACCOUNT-NO-2210   PIC S9(13)V   COMP-3 VALUE 0.      
           05  ACCT-STATUS-2210      PIC X(1)      VALUE SPACES.        
           05  ROW-NO-2210           PIC S9(4)     COMP VALUE 0.        
           05  DEPOSIT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  SEC-TOT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  CUR-MTH-ARR-CD-2210   PIC X(01)     VALUE SPACES.        
           05  CREDIT-GROUP-2210     PIC X(01)     VALUE SPACES.        
           05  CURRENT-ACCOUNT-2210  PIC X(01)     VALUE 'Y'.           
           05  DATE-BNKRPT-FL-2210   PIC X(10)     VALUE SPACES.        
           05  FILED-CASE-NO-2210    PIC X(10)     VALUE SPACES.        
           05  DL-NO-2210            PIC X(19)     VALUE SPACES.        
           05  DL-STATE-2210         PIC X(02)     VALUE SPACES.        
           05  SSN-2210              PIC X(09)     VALUE SPACES.        
           05  PRIOR-ACCT-STAT-2210  PIC X(01)     VALUE SPACES.        
           05  READ-CYCLE-2210       PIC X(02)     VALUE SPACES.        
           05  SERV-STRT-DT-2210     PIC X(10)     VALUE SPACES.        
           05  DEP-INTST-RT-2210     PIC S9(2)V99  COMP-3 VALUE 0.      
           05  CP-DT-PLN-ST-2210     PIC X(10)     VALUE SPACES.        
           05  ACTIVE-CONTRACT-2210  PIC X(01)     VALUE SPACES.        
           05  SECURED-RATE-FL-2210  PIC X(01)     VALUE SPACES.        
           05  MN-CODE-MTR-RD-2210   PIC X(02)     VALUE SPACES.        
           05  MN-MTR-PRESS-2210     PIC X(03)     VALUE SPACES.        
                                                                        
A05189*****************************************************************         
A05189* CSR04849 - AROP ELIGIBILITY                                             
A05189*****************************************************************         
A05189                                                                  
A05189 01  CSR04849-CALL-DATA.                                          
A05189     03  ACCOUNT-NO-4849          PIC X(13) VALUE SPACES.         
A05189     03  PREMISE-NO-4849          PIC X(10) VALUE SPACES.         
A05189     03  SERV-ORDER-NO-4849       PIC X(13) VALUE SPACES.         
A05189                                                                  
A05189 01  CSR04849-RETURN-DATA.                                        
A05189     05  RETURN-CODE-4849         PIC S9(9) COMP VALUE 0.         
A05189     05  AROP-ELIGIBLE-FL-4849    PIC X(01) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC1121 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1116 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2210 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
A05189*01 LOC4849 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE WORK_TYPE_CURSOR CURSOR FOR                      
                   SELECT WORK_TYPE_CD,                                 
                          EST_LABOR_HRS,                                
A05189                    AROP_EXTRACT_IND                              
                     FROM CSS_WORK_TYPE WITH(READUNCOMMITTED)                   
                    WHERE COMPANY_NO = :L4-COMPANY-NO                   
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WORK_TYPE_CURSOR CURSOR FOR                              
MFA-TR*            SELECT WORK_TYPE_CD,                                         
MFA-TR*                   EST_LABOR_HRS,                                        
MFA-TR*                   AROP_EXTRACT_IND                                      
MFA-TR*              FROM CSS_WORK_TYPE                                         
MFA-TR*             WHERE COMPANY_NO = :L4-COMPANY-NO                           
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1121 CURSOR
MSQ001          FOR CALL CSR01121 ( :LINK-SERV-ORDER-NO
                  , 'C'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1116 CURSOR
MSQ001          FOR CALL CSR01116                                             
                   ( :LOCAL-OFFICE-1116
                  , :CODE-UTIL-TYPE-1116
                  , :WORK-TYPE-CD-1116
                  , :CRAWL-IND-1116
                  , :METER-IND-1116
                  , :ZIP-CODE-1116
                  , :READ-ROUTE-1116
                  , :POINT-ID-1116
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2210 CURSOR
MSQ001          FOR CALL CSR02210                                             
                  ( :ACCOUNT-NO-2210
                  , :PREMISE-NO-2210
                  , :COMPANY-NO-2210
                  , :MKTG-ORDER-2210
                  , :RETURN-UTILS-2210
                  , :RETURN-DISC-BAL-2210
                  , :ORDER-REASON-2210
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4849 CURSOR
MSQ001          FOR CALL CSR04849                                             
                   ( :ACCOUNT-NO-4849
                  , :PREMISE-NO-4849
                  , :SERV-ORDER-NO-4849
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-COMPANY-NO         PIC X(02).                           
       01  LINK-ORDER-TYPE-CD      PIC X(05).                           
       01  LINK-WEB-FL             PIC X(01).                           
       01  LINK-SERV-ORDER-NO      PIC X(13).                           
       01  LINK-ZIP-CODE           PIC X(05).                           
       01  LINK-REVERT-FL          PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PREMISE-NO                               
                          LINK-ACCOUNT-NO                               
                          LINK-COMPANY-NO                               
                          LINK-ORDER-TYPE-CD                            
                          LINK-WEB-FL                                   
                          LINK-SERV-ORDER-NO                            
                          LINK-ZIP-CODE                                 
                          LINK-REVERT-FL.                               
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE       AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-SERV-ORDER-NO     AS SERV_ORDER_NO,            
                      :S-ASSIGNED-DATETIME AS ASSIGNED_DATETIME,        
                      :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,            
                      :S-ORDER-STATE-CD    AS ORDER_STATE_CD,           
                      :S-ORDER-REASON      AS ORDER_REASON,             
                      :S-WK-TOTAL-RES      AS WK_TOTAL_RES,             
                      :S-WORK-AREA         AS WORK_AREA,                
P00718                :S-BUSINESS-UNIT     AS BUSINESS_UNIT,            
P00718          LTRIM(RTRIM(:S-WORK-DISTRICT))    AS WORK_DISTRICT,            
P00718          LTRIM(RTRIM(:S-WORK-TYPES))       AS WORK_TYPES                
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE       AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-SERV-ORDER-NO     AS SERV_ORDER_NO,                    
MFA-TR*               :S-ASSIGNED-DATETIME AS ASSIGNED_DATETIME,                
MFA-TR*               :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,                    
MFA-TR*               :S-ORDER-STATE-CD    AS ORDER_STATE_CD,                   
MFA-TR*               :S-ORDER-REASON      AS ORDER_REASON,                     
MFA-TR*               :S-WK-TOTAL-RES      AS WK_TOTAL_RES,                     
MFA-TR*               :S-WORK-AREA         AS WORK_AREA,                        
MFA-TR*               :S-BUSINESS-UNIT     AS BUSINESS_UNIT,                    
MFA-TR*         STRIP(:S-WORK-DISTRICT)    AS WORK_DISTRICT,                    
MFA-TR*         STRIP(:S-WORK-TYPES)       AS WORK_TYPES                        
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE '0000000000000' TO LINK-SERV-ORDER-NO
           END-IF.              
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR.            
           MOVE WS-SERV-ORDER-NO-NUM TO VO-SERV-ORDER-NO.               
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO UT-ACCOUNT-NO                      
                                     MN-ACCOUNT-NO                      
                                     AT-ACCOUNT-NO.                     
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO LA-PREMISE-NO.                     
P00718     MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO.                     
           MOVE LINK-COMPANY-NO            TO L4-COMPANY-NO             
                                              B1-COMPANY-NO.            
A05189     MOVE 'Y' TO WS-AROP-EXTRACT-IND.                             
           PERFORM 7010-OPEN-CURSOR THRU 7010-EXIT.                     
           PERFORM 1010-BUILD-TABLE THRU 1010-EXIT VARYING              
                T1-INDEX FROM 1 BY 1 UNTIL                              
                T1-INDEX > 300 OR                                       
                WS-ACTIVE-RETURN-CODE = NOT-FOUND.                      
           PERFORM 7030-CLOSE-CURSOR THRU 7030-EXIT.                    
           PERFORM 7100-GET-READ-ROUTE THRU 7100-EXIT.                  
           PERFORM 7200-GET-POINT-ID   THRU 7200-EXIT.                  
           PERFORM 7300-GET-LOCOFF     THRU 7300-EXIT.                  
A00560     IF B1-SERV-ORDER-WORK-CD = 'METRO' OR 'DISTC'                
A00560         MOVE 'Y' TO WS-CRAWL-LOCAL-OFFICE
           END-IF.                       
                                                                        
           IF LINK-WEB-FL = 'Y'                                         
               PERFORM 3000-WORK-AREA-FROM-ORDER THRU 3000-EXIT         
           ELSE                                                         
               PERFORM 4000-WORK-AREA-FROM-MTRENV THRU 4000-EXIT
           END-IF.       
                                                                        
A05189     IF WS-AROP-EXTRACT-IND = 'Y'                                 
A05189         PERFORM 4400-CALL-CSR04849 THRU 4400-EXIT                
A05189         IF AROP-ELIGIBLE-FL-4849 = 'Y'                           
A05189             MOVE SPACES TO RS-WORK-DISTRICT                      
A05189             EVALUATE LINK-COMPANY-NO                             
A05189                 WHEN '01'                                        
A05189                     MOVE 'AROPSCEG' TO RS-WORK-AREA              
A05189                 WHEN '26'                                        
A05189                     MOVE 'AROPPSNC' TO RS-WORK-AREA              
A05189             END-EVALUATE
               END-IF
           END-IF.                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1010-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH WORK_TYPE_CURSOR                                   
               INTO :L4-WORK-TYPE-CD,                                   
                    :L4-EST-LABOR-HRS,                                  
A05189              :L4-AROP-EXTRACT-IND                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE L4-WORK-TYPE-CD    TO                           
                        T1-WORK-TYPE-CD   (T1-INDEX)                    
                   MOVE L4-EST-LABOR-HRS   TO                           
                        T1-EST-LABOR-HRS  (T1-INDEX)                    
A05189             MOVE L4-AROP-EXTRACT-IND TO                          
A05189                  T1-AROP-EXTRACT-IND  (T1-INDEX)                 
               WHEN NOT-FOUND                                           
                   GO TO 1010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '1010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                   ABEND-TABLES         
                   MOVE 'CSS_WORK_TYPE'     TO TABLE-1                  
                   MOVE 'CSS_ORDER_WK_TYPE' TO TABLE-2                  
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       1010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             COMPUTE WS-WK-TOTAL-RES-NODEC =                            
                     WS-WK-TOTAL-RES * 10.                              
             MOVE WS-WK-TOTAL-RES-NODEC TO RS-WK-TOTAL-RES.             
                                                                        
             MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                
             MOVE RS-STATUS-CODE       TO S-STATUS-CODE.                
             MOVE RS-SERV-ORDER-NO     TO S-SERV-ORDER-NO.              
             MOVE RS-ASSIGNED-DATETIME TO S-ASSIGNED-DATETIME.          
             MOVE RS-ORDER-TYPE-CD     TO S-ORDER-TYPE-CD.              
             MOVE RS-ORDER-STATE-CD    TO S-ORDER-STATE-CD.             
             MOVE RS-ORDER-REASON      TO S-ORDER-REASON.               
             MOVE RS-WK-TOTAL-RES      TO S-WK-TOTAL-RES.               
             MOVE RS-WORK-AREA         TO S-WORK-AREA.                  
P00718       MOVE RS-BUSINESS-UNIT     TO S-BUSINESS-UNIT.              
P00718       MOVE RS-WORK-DISTRICT     TO S-WORK-DISTRICT.              
P00718       MOVE RS-WORK-TYPES        TO S-WORK-TYPES.                 
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       3000-WORK-AREA-FROM-ORDER.                                       
                                                                        
           PERFORM 7000-SELECT-ORDER THRU 7000-EXIT.                    
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE +100 TO RS-STATUS-CODE                              
               MOVE ZEROES TO VO-SERV-ORDER-NO                          
               MOVE SPACES TO VO-ASSIGNED-DATETIME                      
                              VO-ORDER-TYPE-CD                          
                              VO-ORDER-STATE-CD                         
                              VO-ORDER-REASON                           
           ELSE                                                         
               IF VO-ORDER-STATE-CD NOT = 'A'                           
                   MOVE +999 TO RS-STATUS-CODE                          
               ELSE                                                     
                   PERFORM 3100-CALL-CSR01121 THRU 3100-EXIT
               END-IF
           END-IF.           
           MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM.               
           MOVE WS-SERV-ORDER-NO-CHAR TO RS-SERV-ORDER-NO.              
           MOVE VO-ASSIGNED-DATETIME TO RS-ASSIGNED-DATETIME.           
           MOVE VO-ORDER-TYPE-CD TO RS-ORDER-TYPE-CD.                   
           MOVE VO-ORDER-STATE-CD TO RS-ORDER-STATE-CD.                 
           MOVE VO-ORDER-REASON TO RS-ORDER-REASON.                     
P00718     INSPECT WS-TASK-TYPES TALLYING WS-COUNT FOR CHARACTERS       
P00718     BEFORE INITIAL ' '.                                          
P00718     IF WS-COUNT = 5                                              
P00718        MOVE WS-TASK-TYPES  TO WS-TASK-TYPE                       
P00718        MOVE WS-TASK-TYPE   TO WS-TASK-TYPES                      
P00718     END-IF.                                                      
P00718     MOVE WS-TASK-TYPES   TO RS-WORK-TYPES.                       
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3100-CALL-CSR01121.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01121 (:LINK-SERV-ORDER-NO, 'C')                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1121
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1121
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1121 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01121'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1121)                                                
      *       WITH PROCEDURE CSR01121                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1121 CURSOR FOR RESULT SET        
      *       :LOC1121                                                  
      *    END-EXEC.                                                    
                                                                        
           SET T2-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1121 INTO                          
                   :RETURN-CODE-1121,                                   
                   :CODE-UTIL-TYPE-1121,                                
                   :SO-INST-SEQ-NO-1121,                                
                   :RATE-PLAN-NO-1121,                                  
                   :RATE-DESC-1121,                                     
                   :METER-NO-1121,                                      
                   :METER-LOC-DESC-1121,                                
                   :CODE-MTR-STATUS-WS-1121,                            
                   :CODE-STATUS-REA-WS-1121,                            
                   :METER-SUPPLYING-1121,                               
                   :WORK-TYPE-CD-1121,                                  
                   :HOLD-RELEASE-1121,                                  
                   :RLSE-NO-1121,                                       
                   :RLSE-DATE-1121 :WS-NULL-RLSE-DT,                     
                   :CODE-METER-LOC-1121,                                
                   :PER-TEMP-IND-1121,                                  
                   :IC-NO-1121,                                         
                   :METER-IND-1121,                                     
                   :MTR-REF-NO-1121,                                    
                   :RLSE-IND-1121                                       
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF T2-INDEX > 2                                    
                         MOVE +999 TO RS-STATUS-CODE                    
                     END-IF                                             
                     IF WS-NULL-RLSE-DT < 0                             
                         MOVE SPACES TO RLSE-DATE-1121                  
                     END-IF                                             
                     PERFORM 3200-LOAD-CSR01121-TABLE THRU 3200-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01121'            TO TABLE-1              
                     MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1      
                     MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           MOVE 'N' TO CRAWL-IND-1116.                                  
                                                                        
           MOVE 1 TO WS-T2-SUB.                                         
           PERFORM 3300-ORDER-TABLE-LOOP THRU 3300-EXIT                 
               VARYING T2-INDEX FROM 1 BY 1 UNTIL                       
SCA006         T2-INDEX > 10 OR 
               T2-CODE-UTIL-TYPE (T2-INDEX) <= SPACES.                          
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 3410-CALL-CSR01116 THRU 3410-EXIT
           END-IF.               
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3200-LOAD-CSR01121-TABLE.                                        
                                                                        
           MOVE CODE-UTIL-TYPE-1121 TO T2-CODE-UTIL-TYPE (T2-INDEX).    
           MOVE SO-INST-SEQ-NO-1121 TO T2-SO-INST-SEQ-NO (T2-INDEX).    
           MOVE RATE-PLAN-NO-1121 TO T2-RATE-PLAN-NO (T2-INDEX).        
           MOVE RATE-DESC-1121 TO T2-RATE-DESC (T2-INDEX).              
           MOVE METER-NO-1121 TO T2-METER-NO (T2-INDEX).                
           MOVE METER-LOC-DESC-1121 TO T2-METER-LOC-DESC (T2-INDEX).    
           MOVE CODE-MTR-STATUS-WS-1121 TO                              
                T2-CODE-MTR-STATUS-WS (T2-INDEX).                       
           MOVE CODE-STATUS-REA-WS-1121 TO                              
                T2-CODE-STATUS-REA-WS (T2-INDEX).                       
           MOVE METER-SUPPLYING-1121 TO T2-METER-SUPPLYING (T2-INDEX).  
           MOVE WORK-TYPE-CD-1121 TO T2-WORK-TYPE-CD (T2-INDEX).        
           MOVE HOLD-RELEASE-1121 TO T2-HOLD-RELEASE (T2-INDEX).        
           MOVE RLSE-NO-1121 TO T2-RLSE-NO (T2-INDEX).                  
           MOVE RLSE-DATE-1121 TO T2-RLSE-DATE (T2-INDEX).              
           MOVE CODE-METER-LOC-1121 TO T2-CODE-METER-LOC (T2-INDEX).    
           MOVE PER-TEMP-IND-1121 TO T2-PER-TEMP-IND (T2-INDEX).        
           MOVE IC-NO-1121 TO T2-IC-NO (T2-INDEX).                      
           MOVE METER-IND-1121 TO T2-METER-IND (T2-INDEX).              
           MOVE MTR-REF-NO-1121 TO T2-MTR-REF-NO (T2-INDEX).            
           MOVE RLSE-IND-1121 TO T2-RLSE-IND (T2-INDEX).                
           SET T2-INDEX UP BY 1.                                        
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3300-ORDER-TABLE-LOOP.                                           
                                                                        
           IF VO-ORDER-TYPE-CD = 'OFF01'                                
               EVALUATE T2-WORK-TYPE-CD (T2-INDEX)                      
                   WHEN 'BLK'                                           
P01176             WHEN 'MCB'                                           
                       MOVE 'UNB' TO WS-WORK-TYPE-CD                    
                   WHEN 'VRB'                                           
                       MOVE 'UNB' TO WS-WORK-TYPE-CD                    
                   WHEN 'RDO'                                           
                       MOVE 'RDO' TO WS-WORK-TYPE-CD                    
                   WHEN OTHER                                           
                       MOVE +999 TO RS-STATUS-CODE                      
               END-EVALUATE                                             
           ELSE                                                         
               EVALUATE T2-WORK-TYPE-CD (T2-INDEX)                      
                   WHEN 'BLK'                                           
P01176             WHEN 'MCB'                                           
                       MOVE 'UNB' TO WS-WORK-TYPE-CD                    
                   WHEN 'VRB'                                           
                       MOVE 'UNB' TO WS-WORK-TYPE-CD                    
                   WHEN 'RDO'                                           
                       MOVE 'RDO' TO WS-WORK-TYPE-CD                    
                   WHEN OTHER                                           
                       MOVE +999 TO RS-STATUS-CODE                      
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 3400-FORMAT-1116-CALL THRU 3400-EXIT             
               ADD 1 TO WS-T2-SUB
           END-IF.                                      
                                                                        
       3300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3400-FORMAT-1116-CALL.                                           
                                                                        
           MOVE T2-CODE-UTIL-TYPE (T2-INDEX) TO                         
                CODE-UTIL-TYPE-1116 (WS-T2-SUB:1).                      
           IF WS-T2-SUB = 1                                             
               MOVE 1 TO WS-WORK-TYPE-SUB                               
           ELSE                                                         
               MOVE 4 TO WS-WORK-TYPE-SUB
           END-IF.                              
           MOVE WS-WORK-TYPE-CD TO                                      
                WORK-TYPE-CD-1116 (WS-WORK-TYPE-SUB:3).                 
P00718     STRING WS-TASK-TYPES WS-WORK-TYPE-CD                         
P00718            T2-CODE-UTIL-TYPE (T2-INDEX)                          
P00718            ';' DELIMITED BY ' '                                  
P00718       INTO WS-TASK-TYPES.                                        
           MOVE 'N' TO METER-IND-1116 (WS-T2-SUB:1).                    
           IF T2-CODE-UTIL-TYPE (T2-INDEX) = 'G' AND                    
P01176        WS-WORK-TYPE-CD = ('UNB' OR 'MCU') AND                    
A00560        WS-CRAWL-LOCAL-OFFICE = 'Y'                               
                  PERFORM 7500-APPLIANCES-EXIST THRU 7500-EXIT          
                  IF WS-APPLIANCES-AT-PREMISE = 'N'                     
                      MOVE 'Y' TO CRAWL-IND-1116                        
                  ELSE                                                  
                      PERFORM 7400-CRAWL-APPLIANCES THRU 7400-EXIT
                  END-IF
           END-IF.     
                                                                        
           SET T1-INDEX TO +1                                           
           SEARCH T1-WORK-TYPE                                          
               AT END                                                   
                   MOVE ZEROES TO WS-CALCULATE-RES                      
               WHEN WS-WORK-TYPE-CD = T1-WORK-TYPE-CD (T1-INDEX)        
                   MOVE T1-EST-LABOR-HRS (T1-INDEX) TO                  
                        WS-CALCULATE-RES                                
A05189             IF T1-AROP-EXTRACT-IND (T1-INDEX) NOT = 'Y'          
A05189                 MOVE 'N' TO WS-AROP-EXTRACT-IND                  
A05189             END-IF                                               
           END-SEARCH.                                                  
           ADD WS-CALCULATE-RES TO WS-WK-TOTAL-RES.                     
                                                                        
       3400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3410-CALL-CSR01116.                                              
                                                                        
           IF VO-LOCAL-OFFICE > ' '                                     
               MOVE VO-LOCAL-OFFICE TO LOCAL-OFFICE-1116                
           ELSE                                                         
               MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-1116
           END-IF.               
           MOVE LINK-ZIP-CODE TO ZIP-CODE-1116.                         
           MOVE UT-READ-ROUTE TO WS-READ-ROUTE-NUM.                     
           MOVE WS-READ-ROUTE-CHAR TO READ-ROUTE-1116.                  
           MOVE MN-GIS-POINT-ID TO WS-GIS-POINT-ID.                     
           MOVE WS-GIS-POINT-ID-CHAR TO POINT-ID-1116.                  
P00718*    MOVE WORK-TYPE-CD-1116    TO RS-WORK-TYPES.                          
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01116                                             
      *            (:LOCAL-OFFICE-1116,                                 
      *             :CODE-UTIL-TYPE-1116,                               
      *             :WORK-TYPE-CD-1116,                                 
      *             :CRAWL-IND-1116,                                    
      *             :METER-IND-1116,                                    
      *             :ZIP-CODE-1116,                                     
      *             :READ-ROUTE-1116,                                   
      *             :POINT-ID-1116)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1116 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3410'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01116'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1116)                                                
      *       WITH PROCEDURE CSR01116                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1116 CURSOR FOR RESULT SET        
      *       :LOC1116                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_1116 INTO                           
                   :RETURN-CODE-1116 ,                                  
                   :WORK-AREA-1116,                                     
P00718             :BUSINESS-UNIT-1116                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WORK-AREA-1116     TO RS-WORK-AREA              
P00718             MOVE BUSINESS-UNIT-1116 TO RS-BUSINESS-UNIT          
P00718             PERFORM 3420-GET-WORK-DISTRICT  THRU 3420-EXIT       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RS-WORK-AREA                          
P00718             MOVE SPACES TO RS-BUSINESS-UNIT                      
P00718             MOVE SPACES TO RS-WORK-DISTRICT                      
                   MOVE +999 TO RS-STATUS-CODE                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3410'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01116'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3410-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00718 3420-GET-WORK-DISTRICT.                                          
P00718                                                                  
P00718     PERFORM 7600-GET-PREMISE-DETAILS    THRU 7600-EXIT.          
P00718     INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     EVALUATE TRUE                                                
P00718        WHEN RS-BUSINESS-UNIT = 'EOP'                             
P00718         AND PR-FM-ELEC-SVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-ELEC-SVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN RS-BUSINESS-UNIT = 'GOP'                             
P00718         AND PR-FM-GAS-OPS-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-GAS-OPS-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN RS-BUSINESS-UNIT = 'FSV'                             
P00718         AND PR-FM-FLD-SVCS-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-FLD-SVCS-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN RS-BUSINESS-UNIT = 'RVP'                             
P00718         AND PR-FM-REV-PRT-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-REV-PRT-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN RS-BUSINESS-UNIT = 'DSM'                             
P00718         AND PR-FM-DSM-ESVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-DSM-ESVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718     PERFORM 7610-GET-PRINT-LOC                THRU 7610-EXIT.    
P00718     MOVE LINK-ACCOUNT-NO                      TO RG-ACCOUNT-NO.  
P00718     PERFORM 7620-GET-REGISTER-DTLS            THRU 7620-EXIT.    
P00718     IF (C4-CAD-WORKAREA-FL = 'Y' AND WS-MULTI-REG-MTR = 'N')     
P00718        MOVE WS-WORK-DISTRICT                  TO RS-WORK-DISTRICT
P00718     ELSE                                                         
P00718        MOVE SPACES                            TO RS-WORK-DISTRICT
P00718     END-IF.                                                      
P00718                                                                  
P00718 3420-EXIT.                                                       
P00718      EXIT.                                                       
P00718                                                                  
       4000-WORK-AREA-FROM-MTRENV.                                      
                                                                        
           MOVE WS-ACCOUNT-NO-CHAR TO ACCOUNT-NO-2210.                  
           MOVE WS-PREMISE-NO-CHAR TO PREMISE-NO-2210.                  
           MOVE LINK-COMPANY-NO TO COMPANY-NO-2210.                     
           MOVE 'N' TO MKTG-ORDER-2210.                                 
           MOVE 'Y' TO RETURN-UTILS-2210.                               
           MOVE 'N' TO RETURN-DISC-BAL-2210.                            
           MOVE ' ' TO ORDER-REASON-2210.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02210                                             
      *           (:ACCOUNT-NO-2210,                                    
      *            :PREMISE-NO-2210,                                    
      *            :COMPANY-NO-2210,                                    
      *            :MKTG-ORDER-2210,                                    
      *            :RETURN-UTILS-2210,                                  
      *            :RETURN-DISC-BAL-2210,                               
      *            :ORDER-REASON-2210)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2210 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02210'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-CHAR    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2210)                                                
      *       WITH PROCEDURE CSR02210                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2210 CURSOR FOR RESULT SET        
      *       :LOC2210                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           SET T3-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2210 INTO                          
                   :RETURN-CODE-2210,                                   
                   :ACTIVE-PARA-2210,                                   
                   :TABLE-NAME-2210,                                    
                   :TABLE-ID-2210,                                      
                   :UT-CODE-UTIL-TY-2210,                               
                   :UT-IC-NO-2210,                                      
                   :UT-READ-ROUTE-2210,                                 
                   :UT-RATE-PLAN-NO-2210,                               
                   :UT-RATE-DESC-2210,                                  
                   :UT-CODE-REV-CLA-2210,                               
                   :UT-READ-CYCLE-2210,                                 
                   :UT-CODE-SIC-NO-2210,                                
                   :MN-METER-NO-2210,                                   
                   :MN-MTR-REF-NO-2210,                                 
                   :MN-CODE-TIME-PE-2210,                               
                   :MN-LAST-READ-VA-2210,                               
                   :MN-CD-STUS-RS-2210,                                 
                   :MN-CODE-USAGE-T-2210,                               
                   :MN-CODE-USAGE-I-2210,                               
                   :MN-CODE-USAGE-S-2210,                               
                   :MN-CODE-METER-S-2210,                               
                   :MN-METER-SUPPLY-2210,                               
                   :MN-CODE-METER-L-2210,                               
                   :MN-METER-LOC-DE-2210,                               
                   :MN-METER-IND-2210,                                  
                   :MN-CONSTANT-2210,                                   
                   :MN-NO-DIALS-2210,                                   
                   :MN-DIST-NODE-PO-2210,                               
                   :MN-POINT-ID-2210,                                   
                   :MN-SEAL-CODE-ID-2210,                               
                   :MN-HEX-LOCATION-2210,                               
                   :MN-INSULATED-IN-2210,                               
                   :MN-LOCK-TYPE-ID-2210,                               
                   :MN-DELIVERY-LEV-2210,                               
                   :MN-UTILITY-SOUR-2210,                               
                   :MN-IDR-RECIPIEN-2210,                               
                   :MN-PROGRAM-ID-2210,                                 
                   :MN-MTR-READ-SO-2210,                                
                   :RG-CODE-REG-ST-2210,                                
                   :RG-CODE-STATUS-2210,                                
                   :RG-CODE-TIME-P-2210,                                
                   :RG-CODE-USAGE-2210,                                 
                   :RG-CD-USG-SRC-2210,                                 
                   :RG-CD-USG-TYP-2210,                                 
                   :RG-LAST-READD-2210,                                 
                   :RG-LST-READVL-2210,                                 
                   :RG-REG-ID-NO-2210,                                  
                   :CP-NO-UNITS-2210,                                   
                   :CP-CODE-PLAN-2210,                                  
                   :CP-CD-STATRS-2210,                                  
                   :CP-CD-SVC-TYP-2210,                                 
                   :CP-MTLY-AMT-FX-2210,                                
                   :CP-RT-ITEM-CD-2210,                                 
                   :CP-LIGHT-NO-2210,                                   
                   :CP-POLE-NO-2210,                                    
                   :CP-DIST-NO-2210,                                    
                   :CP-USAGE-FIXED-2210,                                
                   :CP-ITEM-SEQ-NO-2210,                                
                   :CP-EQUIP-ID-2210,                                   
                   :PREM-DIR-IND-2210,                                  
                   :SUBDIV-LIGHT-2210,                                  
                   :ACCT-TYPE-2210,                                     
                   :CD-RNTL-PROP-2210,                                  
                   :LL-CUSTOMER-NO-2210,                                
                   :REV-DIST-CD-2210,                                   
                   :DISC-BAL-2210,                                      
                   :OUT-ACCOUNT-NO-2210,                                
                   :ACCT-STATUS-2210,                                   
                   :ROW-NO-2210,                                        
                   :DEPOSIT-AMT-2210,                                   
                   :SEC-TOT-AMT-2210,                                   
                   :CUR-MTH-ARR-CD-2210,                                
                   :CREDIT-GROUP-2210,                                  
                   :CURRENT-ACCOUNT-2210,                               
                   :DATE-BNKRPT-FL-2210,                                
                   :FILED-CASE-NO-2210,                                 
                   :DL-NO-2210,                                         
                   :DL-STATE-2210,                                      
                   :SSN-2210,                                           
                   :PRIOR-ACCT-STAT-2210,                               
                   :READ-CYCLE-2210,                                    
                   :SERV-STRT-DT-2210,                                  
                   :DEP-INTST-RT-2210,                                  
                   :CP-DT-PLN-ST-2210,                                  
                   :ACTIVE-CONTRACT-2210,                               
                   :SECURED-RATE-FL-2210,                               
                   :MN-CODE-MTR-RD-2210,                                
                   :MN-MTR-PRESS-2210                                   
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     PERFORM 4100-LOAD-CSR02210-TABLE THRU 4100-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '4000'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02210'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE WS-ACCOUNT-NO-CHAR    TO HOSTVAR-ELEMENT-1    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           MOVE 'N' TO CRAWL-IND-1116.                                  
                                                                        
           MOVE 1 TO WS-T3-SUB.                                         
           PERFORM 4200-ACCOUNT-TABLE-LOOP THRU 4200-EXIT               
               VARYING T3-INDEX FROM 1 BY 1 UNTIL                       
SCA006         T3-INDEX > 20 OR 
               T3-TABLE-ID (T3-INDEX) <= SPACES.                                
                                                                        
           PERFORM 3410-CALL-CSR01116 THRU 3410-EXIT.                   
           MOVE SPACES TO RS-SERV-ORDER-NO                              
                          RS-ASSIGNED-DATETIME                          
                          RS-ORDER-TYPE-CD                              
                          RS-ORDER-STATE-CD                             
                          RS-ORDER-REASON.                              
P00718     INSPECT WS-TASK-TYPES TALLYING WS-COUNT FOR CHARACTERS       
P00718     BEFORE INITIAL ' '.                                          
P00718     IF WS-COUNT = 5                                              
P00718        MOVE WS-TASK-TYPES     TO WS-TASK-TYPE                    
P00718        MOVE WS-TASK-TYPE      TO WS-TASK-TYPES                   
P00718     END-IF.                                                      
P00718     MOVE WS-TASK-TYPES        TO RS-WORK-TYPES.                  
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-LOAD-CSR02210-TABLE.                                        
                                                                        
           MOVE TABLE-ID-2210 TO T3-TABLE-ID (T3-INDEX).                
           MOVE MN-CODE-METER-S-2210 TO T3-CODE-METER-S (T3-INDEX).     
           MOVE UT-CODE-UTIL-TY-2210 TO T3-CODE-UTIL-TYPE (T3-INDEX).   
           MOVE UT-RATE-PLAN-NO-2210 TO T3-RATE-PLAN-NO (T3-INDEX).     
           SET T3-INDEX UP BY 1.                                        
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4200-ACCOUNT-TABLE-LOOP.                                         
                                                                        
           IF T3-TABLE-ID (T3-INDEX) = 'MN'                             
               IF T3-CODE-METER-S (T3-INDEX) = 'A'                      
                   IF LINK-ORDER-TYPE-CD = 'CC001'                      
                       MOVE 'RDO' TO WS-WORK-TYPE-CD                    
                   ELSE                                                 
                       IF T3-RATE-PLAN-NO (T3-INDEX) = '005'            
                           MOVE 'RMM' TO WS-WORK-TYPE-CD                
                       ELSE                                             
                           MOVE 'BLK' TO WS-WORK-TYPE-CD                
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   IF LINK-ORDER-TYPE-CD = 'CC001'                      
                       IF LINK-REVERT-FL = 'Y'                          
                           EVALUATE T3-CODE-METER-S (T3-INDEX)          
                               WHEN 'J'                                 
                                   MOVE 'VRB' TO WS-WORK-TYPE-CD        
                               WHEN 'I'                                 
                                   MOVE 'RDO' TO WS-WORK-TYPE-CD        
                               WHEN OTHER                               
                                   MOVE '   ' TO WS-WORK-TYPE-CD        
                           END-EVALUATE                                 
                       ELSE                                             
                           MOVE 'UNB' TO WS-WORK-TYPE-CD                
                       END-IF                                           
                   ELSE                                                 
                       IF T3-CODE-METER-S (T3-INDEX) = 'J'              
                           IF T3-RATE-PLAN-NO (T3-INDEX) = '005'        
                               MOVE 'RMM' TO WS-WORK-TYPE-CD            
                           ELSE                                         
                               MOVE 'VRB' TO WS-WORK-TYPE-CD            
                           END-IF                                       
                       ELSE                                             
                           IF T3-CODE-METER-S (T3-INDEX) = 'I'          
                               MOVE 'BLK' TO WS-WORK-TYPE-CD            
                           ELSE                                         
                               MOVE 'FIN' TO WS-WORK-TYPE-CD            
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
               PERFORM 4300-FORMAT-1116-CALL THRU 4300-EXIT             
               ADD 1 TO WS-T3-SUB
           END-IF.                                      
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4300-FORMAT-1116-CALL.                                           
                                                                        
           MOVE T3-CODE-UTIL-TYPE (T3-INDEX) TO                         
                CODE-UTIL-TYPE-1116 (WS-T3-SUB:1).                      
           IF WS-T3-SUB = 1                                             
               MOVE 1 TO WS-WORK-TYPE-SUB                               
           ELSE                                                         
               MOVE 4 TO WS-WORK-TYPE-SUB
           END-IF.                              
           MOVE WS-WORK-TYPE-CD TO                                      
                WORK-TYPE-CD-1116 (WS-WORK-TYPE-SUB:3).                 
P00718     STRING WS-TASK-TYPES WS-WORK-TYPE-CD                         
P00718     T3-CODE-UTIL-TYPE (T3-INDEX) ';' DELIMITED BY ' '            
P00718     INTO WS-TASK-TYPES.                                          
           MOVE 'N' TO METER-IND-1116 (WS-T3-SUB:1).                    
           IF T3-CODE-UTIL-TYPE (T3-INDEX) = 'G' AND                    
P01176        WS-WORK-TYPE-CD = ('UNB' OR 'MCU') AND                    
A00560        WS-CRAWL-LOCAL-OFFICE = 'Y'                               
                  PERFORM 7500-APPLIANCES-EXIST THRU 7500-EXIT          
                  IF WS-APPLIANCES-AT-PREMISE = 'N'                     
                      MOVE 'Y' TO CRAWL-IND-1116                        
                  ELSE                                                  
                      PERFORM 7400-CRAWL-APPLIANCES THRU 7400-EXIT
                  END-IF
           END-IF.     
                                                                        
           SET T1-INDEX TO +1                                           
           SEARCH T1-WORK-TYPE                                          
               AT END                                                   
                   MOVE ZEROES TO WS-CALCULATE-RES                      
               WHEN WS-WORK-TYPE-CD = T1-WORK-TYPE-CD (T1-INDEX)        
                   MOVE T1-EST-LABOR-HRS (T1-INDEX) TO                  
                        WS-CALCULATE-RES                                
A05189             IF T1-AROP-EXTRACT-IND (T1-INDEX) NOT = 'Y'          
A05189                 MOVE 'N' TO WS-AROP-EXTRACT-IND                  
A05189             END-IF                                               
           END-SEARCH.                                                  
           ADD WS-CALCULATE-RES TO WS-WK-TOTAL-RES.                     
                                                                        
       4300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4400-CALL-CSR04849.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-4849.                     
           MOVE LINK-PREMISE-NO TO PREMISE-NO-4849.                     
           MOVE ZEROES TO SERV-ORDER-NO-4849.                           
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04849                                             
      *            (:ACCOUNT-NO-4849,                                   
      *             :PREMISE-NO-4849,                                   
      *             :SERV-ORDER-NO-4849)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4849
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4849
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4849 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04849'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4849)                                                
      *       WITH PROCEDURE CSR04849                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4849 CURSOR FOR RESULT SET        
      *       :LOC4849                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_4849 INTO                           
                   :RETURN-CODE-4849 ,                                  
A05189             :AROP-ELIGIBLE-FL-4849                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05189             MOVE 'N' TO AROP-ELIGIBLE-FL-4849                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4400'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04849'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE LINK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ORDER.                                               
                                                                        
           EXEC SQL                                                     
               SELECT SERV_ORDER_NO,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                                
                      ORDER_TYPE_CD,                                    
                      ORDER_STATE_CD,                                   
                      ORDER_REASON,                                     
                      LOCAL_OFFICE                                      
                 INTO :VO-SERV-ORDER-NO,                                
                      :VO-ASSIGNED-DATETIME,                            
                      :VO-ORDER-TYPE-CD,                                
                      :VO-ORDER-STATE-CD,                               
                      :VO-ORDER-REASON,                                 
                      :VO-LOCAL-OFFICE                                  
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ORDER_TYPE_CD,                                            
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               ORDER_REASON,                                             
MFA-TR*               LOCAL_OFFICE                                              
MFA-TR*          INTO :VO-SERV-ORDER-NO,                                        
MFA-TR*               :VO-ASSIGNED-DATETIME,                                    
MFA-TR*               :VO-ORDER-TYPE-CD,                                        
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-ORDER-REASON,                                         
MFA-TR*               :VO-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SO_DATA'         TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE VO-SERV-ORDER-NO      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN WORK_TYPE_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_WORK_TYPE'         TO TABLE-1                  
               MOVE 'CSS_ORDER_WK_TYPE'     TO TABLE-2                  
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE WORK_TYPE_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_WORK_TYPE'         TO TABLE-1                  
               MOVE 'CSS_ORDER_WK_TYPE'     TO TABLE-2                  
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-READ-ROUTE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) READ_ROUTE                                        
                 INTO :UT-READ-ROUTE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                       
                  AND READ_ROUTE > 0                                    
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_ROUTE                                                
MFA-TR*          INTO :UT-READ-ROUTE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                               
MFA-TR*           AND READ_ROUTE > 0                                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO UT-READ-ROUTE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE UT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-POINT-ID.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) GIS_POINT_ID                                      
                 INTO :MN-GIS-POINT-ID                                  
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                       
      *           AND POINT_ID > ' '                                            
                  AND GIS_POINT_ID > 0                                  
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GIS_POINT_ID                                              
MFA-TR*          INTO :MN-GIS-POINT-ID                                          
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                               
MFA-TR*           AND POINT_ID > ' '                                            
MFA-TR*           AND GIS_POINT_ID > 0                                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO MN-GIS-POINT-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE UT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-LOCOFF.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AT.LOCAL_OFFICE,
              SERV_ORDER_WORK_CD                                
                 INTO :AT-LOCAL-OFFICE,                                 
A00560                :B1-SERV-ORDER-WORK-CD                            
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
A00560                CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                 
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A00560            AND B1.COMPANY_NO = AT.COMPANY_NO                     
A00560            AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                 
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.LOCAL_OFFICE,                                          
MFA-TR*               SERV_ORDER_WORK_CD                                        
MFA-TR*          INTO :AT-LOCAL-OFFICE,                                         
MFA-TR*               :B1-SERV-ORDER-WORK-CD                                    
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_LOCAL_OFFICE B1                                       
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND B1.COMPANY_NO = AT.COMPANY_NO                             
MFA-TR*           AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO AT-LOCAL-OFFICE                       
                                   B1-SERV-ORDER-WORK-CD                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
A00560             MOVE 'CSS_LOCAL_OFFICE' TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CRAWL-APPLIANCES.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CRAWL_FL                                          
                 INTO :JA-CRAWL-FL                                      
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND LA.APPLIANCE_CD =  JA.APPLIANCE_CD                
                  AND CRAWL_FL = 'Y'                                    
                  AND CIS_DISPLAY_FL = 'Y'                              
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CRAWL_FL                                                  
MFA-TR*          INTO :JA-CRAWL-FL                                              
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND LA.APPLIANCE_CD =  JA.APPLIANCE_CD                        
MFA-TR*           AND CRAWL_FL = 'Y'                                            
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO CRAWL-IND-1116                           
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO CRAWL-IND-1116                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'    TO TABLE-1                   
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE LA-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-APPLIANCES-EXIST.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PREMISE_NO                                        
                 INTO :LA-PREMISE-NO                                    
                 FROM CSS_APPLIANCE WITH(READUNCOMMITTED)                       
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          INTO :LA-PREMISE-NO                                            
MFA-TR*          FROM CSS_APPLIANCE                                             
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-APPLIANCES-AT-PREMISE                 
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-APPLIANCES-AT-PREMISE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'    TO TABLE-1                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE LA-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00718 7600-GET-PREMISE-DETAILS.                                        
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT FM_ELEC_SVC_WKDIST,                               
P00718                FM_GAS_OPS_WKDIST,                                
P00718                FM_FLD_SVCS_WKDIST,                               
P00718                FM_REV_PRT_WKDIST,                                
P00718                FM_DSM_ESVC_WKDIST                                
P00718           INTO :PR-FM-ELEC-SVC-WKDIST,                           
P00718                :PR-FM-GAS-OPS-WKDIST,                            
P00718                :PR-FM-FLD-SVCS-WKDIST,                           
P00718                :PR-FM-REV-PRT-WKDIST,                            
P00718                :PR-FM-DSM-ESVC-WKDIST                            
P00718           FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
P00718          WHERE PREMISE_NO = :PR-PREMISE-NO                       
P00718                                                           
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*          INTO :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST,                                    
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST,                                    
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST                                    
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718             CONTINUE                                             
P00718         WHEN NOT-FOUND                                           
P00718             MOVE SPACES TO RS-WORK-DISTRICT                      
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7600'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_PREMISE'      TO TABLE-1                   
P00718             MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
P00718             MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7600-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718 7610-GET-PRINT-LOC.                                              
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT CAD_WORKAREA_FL                                   
P00718           INTO :C4-CAD-WORKAREA-FL                               
P00718           FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
P00718          WHERE WORK_AREA_ID = :WORK-AREA-1116                    
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CAD_WORKAREA_FL                                           
MFA-TR*          INTO :C4-CAD-WORKAREA-FL                                       
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID = :WORK-AREA-1116                            
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7610                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN NOT-FOUND                                           
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7610'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_SO_PRINT_LOC' TO TABLE-1                   
P00718             MOVE 'WORK_AREA'      TO TABLE-ELEMENT-1             
P00718             MOVE WORK-AREA-1116   TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7610-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718 7620-GET-REGISTER-DTLS.                                          
P00718                                                                  
P00718     EXEC SQL                                                     
P00718        SELECT TOP(1) 'Y'                                                
P00718          INTO :WS-MULTI-REG-MTR                                  
P00718          FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED),                
P00718               CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
P00718         WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO               
P00718           AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                
P00718           AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE            
P00718           AND MN.METER_NO         = RG.METER_NO                  
P00718           AND MN.IC_NO            = RG.IC_NO                     
P00718           AND MN.MTR_REF_NO       = RG.MTR_REF_NO                
P00718                                            
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MULTI-REG-MTR                                          
MFA-TR*         FROM CSS_REGISTER_READ RG,                                      
MFA-TR*              CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO                       
MFA-TR*          AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                        
MFA-TR*          AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE                    
MFA-TR*          AND MN.METER_NO         = RG.METER_NO                          
MFA-TR*          AND MN.IC_NO            = RG.IC_NO                             
MFA-TR*          AND MN.MTR_REF_NO       = RG.MTR_REF_NO                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7620                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN -811                                                
P00718             CONTINUE                                             
P00718         WHEN NOT-FOUND                                           
P00718             MOVE 'N'              TO WS-MULTI-REG-MTR            
P00718             MOVE 0                TO WS-ACTIVE-RETURN-CODE       
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7620'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
P00718             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00718             MOVE RG-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7620-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
