       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04106.                                          
COB303 DATE-WRITTEN.      APRIL 16, 2008.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS AND INSERTS AN OFF ORDER FROM THE WEB.    *        
      *  STATUS CODE VALUES ARE:                                       *        
      *       025     CC/REASON NOT FORCED                                      
      *       050     OFF01 EXISTS                                              
      *       075     FINAL BILL ADDRESS EXISTS                                 
      *       150     MULTIPLE OFF ORDERS EXIST AT PREMISE                      
      *       200     NO CC/OFF ORDER EXISTS BUT WEB SAYS IT DOES      *        
      *       300     EXISTING ORDER STATE IS NOT ACTIVE               *        
      *       500     SCHEDULED DATE HAS CHANGED                       *        
      *       600     ORDER NUMBER IS DIFFERENT THAN PASSED FROM WEB   *        
      *       700     ORDER TYPE IS DIFFERENT THAN PASSED FROM WEB     *        
      *  WORKING STORAGE TABLES:                                       *        
      *       T3      SNAPSHOT DATA FROM THE ACCOUNT                   *        
      *       T5      APPLIANCE DATA FROM CSS_APPLIANCE                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/16/08    FMB      NEW PROGRAM.                                      
A01648*  09/03/09    FMB      SET CODES_DATA_PRESENT FOR FINAL BILL             
A01648*                       ADDRESSES.                                        
P00196*  12/21/09    FMB      READ CSS_ORDER_PRIORITY INSTEAD OF                
P00196*                       HARDCODING PRIORITY.                              
P00390*  05/10/10    FMB      TWO NEW FIELDS IN CSR02210 RESULTS SET.           
A03140*  02/11/11    FMB      PASS DEPOSIT AMOUNT INTO CSR00073.                
A04670*  08/05/13    FMB      UPDATE SOURCE SYSTEM CODE.                        
P00718*  02/20/14    VV       NEW PARM FOR BUSINESS UNIT TO CSR00073            
P00718*  04/03/14    VV       NEW PARM FOR OPTIMIZE ORDER TO CSR00073           
P00817*  11/17/14    VV       COMMENTED LIGHTING CONTRACT WQ                    
P00795*  02/16/15    DB18339  ADDED TRANSFER_FL FROM CSR02146.                  
A05189*  02/24/15    FMB      CREATE AROP ORDERS ON HOLD WITH REMARKS.          
P00795*  03/30/15    DB18339  ADDED CONTRACT DESC FROM CSR02146.                
D06358*  04/20/15    FMB      TRANSFER CONTRACT ONLY IF XFER FLAG = Y.          
A05317*  03/15/16    FMB      INCREASE CSR02210 SUBSCRIPT.                      
P00836*  06/29/16    FMB      POPULATE NEW COLUMNS.                             
P00836*  07/07/16    FMB      TREAT CC ON HOLD FOR AROP AS ACTIVE.              
ACT233*  07/26/16   TP7R341   REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04106'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04106 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPLCON                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOREQ                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRTOF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOWEB                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOFIN                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
P00196     EXEC SQL                                                             
P00196        INCLUDE TBORDPRI                                                  
P00196     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBSOLOC                                                   
P00718     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBRGREAD                                                  
P00718     END-EXEC.                                                            
                                                                        
A05189     EXEC SQL                                                             
A05189        INCLUDE TBSOREM                                                   
A05189     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
ACT233*    COPY CCA00001.                                                       
                                                                        
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04106_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-SERV-ORDER-NO        PIC X(13) VALUE SPACES.          
           05  RS-CONTRACT-FL          PIC X(01) VALUE SPACES.          
           05  RS-BANK-DRAFT-FL        PIC X(01) VALUE SPACES.          
           05  RS-EPP-FL               PIC X(01) VALUE SPACES.          
           05  RS-DPP-FL               PIC X(01) VALUE SPACES.          
           05  RS-DFA-FL               PIC X(01) VALUE SPACES.          
           05  RS-MED-CERT-FL          PIC X(01) VALUE SPACES.          
           05  RS-LITE-CONTRACT-FL     PIC X(01) VALUE SPACES.          
P00718     05  RS-WORK-DISTRICT        PIC X(40) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
           05  S-CONTRACT-FL          PIC X(01) VALUE SPACES.           
           05  S-BANK-DRAFT-FL        PIC X(01) VALUE SPACES.           
           05  S-EPP-FL               PIC X(01) VALUE SPACES.           
           05  S-DPP-FL               PIC X(01) VALUE SPACES.           
           05  S-DFA-FL               PIC X(01) VALUE SPACES.           
           05  S-MED-CERT-FL          PIC X(01) VALUE SPACES.           
           05  S-LITE-CONTRACT-FL     PIC X(01) VALUE SPACES.           
P00718     05  S-WORK-DISTRICT        PIC X(40) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-NUM    
                                        PIC X(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-ACCOUNT-XFER-CHAR     PIC X(13).                      
           05  WS-ACCOUNT-XFER-NUM      REDEFINES WS-ACCOUNT-XFER-CHAR  
                                        PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    PIC X(13).                      
           05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO-CHAR 
                                        PIC 9(13).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-DATE-USA      PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04106'.     
           05  WS-EXISTING-ORDER-FL     PIC X(01) VALUE SPACES.         
           05  WS-COUNT-ORDERS          PIC S9(4) COMP VALUE 0.         
           05  WS-WORK-TYPE-CD          PIC X(03) VALUE SPACES.         
           05  WS-II-CTR                PIC S9(4) COMP VALUE 0.         
           05  WS-II-MCTR               PIC S9(4) COMP VALUE 0.         
           05  WS-LIGHTING-CONTRACT-FL  PIC X(01) VALUE SPACES.         
           05  WS-BUILDER-LIGHTING-FL   PIC X(01) VALUE SPACES.         
           05  WS-ACTIVE-CONTRACT-FL    PIC X(01) VALUE SPACES.         
           05  WS-MORE-ROWS             PIC X(01) VALUE SPACES.         
           05  WS-T3-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-T5-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-NO-OF-DAYS            PIC S9(4) COMP VALUE 0.         
           05  WS-UTIL-ENV-EXISTS       PIC X(01) VALUE SPACES.         
           05  WS-ORDER-INST-EXISTS     PIC X(01) VALUE SPACES.         
           05  WS-EQUIPMENT-EXISTS      PIC X(01) VALUE SPACES.         
           05  WS-INCLUDE-INST          PIC X(01) VALUE SPACES.         
           05  WS-LINK-SCHEDULED-DT     PIC X(10) VALUE SPACES.         
           05  WS-PLAN-START-DATE       PIC X(10) VALUE SPACES.         
           05  WS-SO-EST-LABOR-HR       PIC 9(6) VALUE 0.               
           05  WS-SO-EST-LABOR-HR-DEC   PIC 9(5)V9 VALUE 0.             
           05  WS-SPCL-INST-LEN         PIC S9(4) COMP VALUE 0.         
P00817*    05  WS-WQ-COMMENTS-1         PIC X(115) VALUE                        
P00817*    'THIS CUSTOMER IS FINAL BILLING AND REMOVING THE LIGHTS. PLEA        
P00817*-    'SE REVIEW/ENTER CONTRACT CHARGES FOR LIGHTING.'.                   
           05  WS-WQ-COMMENTS-2         PIC X(105) VALUE                
           'ACTIVE MERCHANDISE CONTRACT EXISTS ON ACCOUNT.  CNT MUST BE         
      -    'TRANSFERRED BEFORE ACCT CAN FINAL BILL.'.                           
           05  WS-WAIVER-COMMENTS.                                      
               10  F                    PIC X(28) VALUE                 
                  'SERVICE ORDER TRANSFER FROM '.                       
               10  WS-DISP-XFER-ACCT    PIC 9(13).                      
               10  F                    PIC X(18) VALUE                 
                  ' SERVICE ORDER NO '.                                 
               10  WS-DISP-XFER-SO      PIC 9(13).                      
               10  F                    PIC X(10) VALUE                 
                  ' CSR USER '.                                         
               10  WS-DISP-XFER-USER    PIC X(07).                      
           05  WS-HOLD-SERV-ORDER-NO    PIC 9(13).                      
           05  WS-MISSING-STRT-EVENT    PIC X(01) VALUE 'N'.            
           05  WS-BILL-ADDRESS-EXISTS   PIC X(01) VALUE 'N'.            
           05  WS-DUPLICATE-UPDATE      PIC X(01) VALUE 'N'.            
P00718     05  WS-MULTI-REG-MTR         PIC X(01) VALUE 'N'.            
P00718     05  WS-WORK-DISTRICT         PIC X(40) VALUE SPACES.         
A05189     05  WS-AROP-FL               PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-TABLES.                                                   
           05  T3-CSR02210            OCCURS 80                         
                                      INDEXED BY T3-INDEX.              
               10 T3-TABLE-ID           PIC X(02) VALUE SPACES.         
               10 T3-UT-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.         
               10 T3-UT-IC-NO           PIC S9(4) COMP VALUE 0.         
               10 T3-UT-READ-ROUTE      PIC S9(4) COMP VALUE 0.         
               10 T3-UT-RATE-PLAN-NO    PIC X(03).                      
               10 T3-UT-RATE-DESC       PIC X(25).                      
               10 T3-UT-CODE-REV-CLASS  PIC X(03).                      
               10 T3-UT-READ-CYCLE      PIC X(02).                      
               10 T3-UT-CODE-SIC-NO     PIC X(04).                      
               10 T3-MN-METER-NO        PIC X(09).                      
               10 T3-MN-MTR-REF-NO      PIC S9(4) COMP VALUE 0.         
               10 T3-MN-CODE-TIME-PER   PIC S9(4) COMP VALUE 0.         
               10 T3-MN-LAST-READ-VAL   PIC S9(12)V9(3) COMP-3 VALUE 0. 
               10 T3-MN-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-USAGE-T    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-USAGE-I    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-USAGE-S    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-METER-S    PIC X(01) VALUE SPACES.         
               10 T3-MN-METER-SUPPLY    PIC X(15) VALUE SPACES.         
               10 T3-MN-CODE-METER-LOC  PIC X(02) VALUE SPACES.         
               10 T3-MN-METER-LOC-DESC  PIC X(14) VALUE SPACES.         
               10 T3-MN-METER-IND       PIC X(01) VALUE SPACES.         
               10 T3-MN-CONSTANT        PIC S9(6)V COMP-3 VALUE 0.      
               10 T3-MN-NO-DIALS        PIC S9(4) COMP VALUE 0.         
               10 T3-MN-DIST-NODE-PO    PIC X(20) VALUE SPACES.         
               10 T3-MN-POINT-ID        PIC X(10) VALUE SPACES.         
               10 T3-MN-SEAL-CODE-ID    PIC X(01) VALUE SPACES.         
               10 T3-MN-HEX-LOCATION    PIC X(02) VALUE SPACES.         
               10 T3-MN-INSULATED-IND   PIC X(01) VALUE SPACES.         
               10 T3-MN-LOCK-TYPE-ID    PIC X(01) VALUE SPACES.         
               10 T3-MN-DELIVERY-LEV    PIC X(01) VALUE SPACES.         
               10 T3-MN-UTILITY-SOURCE  PIC X(01) VALUE SPACES.         
               10 T3-MN-IDR-RECIPIENT   PIC X(01) VALUE SPACES.         
               10 T3-MN-PROGRAM-ID      PIC X(02) VALUE SPACES.         
               10 T3-MN-MTR-READ-SOURCE PIC X(01) VALUE SPACES.         
               10 T3-RG-LAST-READD      PIC X(10) VALUE SPACES.         
               10 T3-RG-REG-ID-NO       PIC S9(4) COMP VALUE 0.         
               10 T3-CP-NO-UNITS        PIC S9(9) COMP VALUE 0.         
               10 T3-CP-CODE-PLAN       PIC X(01) VALUE SPACES.         
               10 T3-CP-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T3-CP-CD-SVC-TYPE     PIC X(01) VALUE SPACES.         
               10 T3-CP-MTHLY-AMT       PIC S9(9)V COMP-3 VALUE 0.      
               10 T3-CP-RT-ITEM-CD      PIC S9(4) COMP VALUE 0.         
               10 T3-CP-LIGHT-NO        PIC S9(4) COMP VALUE 0.         
               10 T3-CP-POLE-NO         PIC X(07) VALUE SPACES.         
               10 T3-CP-DIST-NO         PIC X(03) VALUE SPACES.         
               10 T3-CP-USAGE-FIXED     PIC S9(9)V COMP-3 VALUE 0.      
               10 T3-CP-ITEM-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T3-CP-EQUIP-ID        PIC X(02) VALUE SPACES.         
               10 T3-PREM-DIR-IND       PIC X(01) VALUE SPACES.         
               10 T3-SUBDIV-LIGHT       PIC S9(3)V COMP-3 VALUE 0.      
               10 T3-ACCT-TYPE-CODE     PIC X(01) VALUE SPACES.         
               10 T3-CD-RENTAL-PROP     PIC X(01) VALUE SPACES.         
               10 T3-LL-CUSTOMER-NO     PIC S9(10)V COMP-3 VALUE 0.     
               10 T3-REV-DISTRICT-CD    PIC X(03) VALUE SPACES.         
               10 T3-DISC-BAL           PIC S9(11)V99 COMP-3 VALUE 0.   
               10 T3-OUT-ACCOUNT-NO     PIC S9(13)V COMP-3 VALUE 0.     
               10 T3-ACCT-STATUS        PIC X(01) VALUE SPACES.         
               10 T3-ROW-NO             PIC S9(4) COMP VALUE 0.         
               10 T3-DEPOSIT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T3-SEC-TOT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T3-CUR-MTH-ARR-CD     PIC X(01) VALUE SPACES.         
               10 T3-CREDIT-GROUP       PIC X(01) VALUE SPACES.         
               10 T3-CURRENT-ACCOUNT    PIC X(01) VALUE SPACES.         
               10 T3-DATE-BANKRUPT      PIC X(10) VALUE SPACES.         
               10 T3-FILED-CASE-NO      PIC X(10) VALUE SPACES.         
               10 T3-DL-NO              PIC X(19) VALUE SPACES.         
               10 T3-DL-STATE           PIC X(02) VALUE SPACES.         
               10 T3-SSN                PIC X(09) VALUE SPACES.         
               10 T3-PRIOR-ACCT-STAT    PIC X(01) VALUE SPACES.         
               10 T3-READ-CYCLE         PIC X(02) VALUE SPACES.         
               10 T3-SERV-STRT-DT       PIC X(10) VALUE SPACES.         
               10 T3-DEP-INTST-RT       PIC S9(2)V99 COMP-3 VALUE 0.    
               10 T3-CP-DT-PLAN-ST      PIC X(10) VALUE SPACES.         
               10 T3-ACTIVE-CONTRACT    PIC X(01) VALUE SPACES.         
               10 T3-SECURED-RATE-FL    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-MTR-RD     PIC X(02) VALUE SPACES.         
               10 T3-MN-MTR-PRESS       PIC X(03) VALUE SPACES.         
           05  T5-APPLIANCES          OCCURS 20                         
                                      INDEXED BY T5-INDEX.              
               10 T5-APPLIANCE-CD       PIC X(02) VALUE SPACES.         
               10 T5-EQUIP-OWNER        PIC X(12) VALUE SPACES.         
               10 T5-PRIMARY-FUEL-CD    PIC X(06) VALUE SPACES.         
               10 T5-EQUIPMENT-NO       PIC X(20) VALUE SPACES.         
               10 T5-INSTALL-DT         PIC X(10) VALUE SPACES.         
               10 T5-REPLACE-APP-FL     PIC X(01) VALUE SPACES.         
               10 T5-CAUTION-TAG-IND    PIC X(01) VALUE SPACES.         
               10 T5-CONDITION-DESC     PIC X(50) VALUE SPACES.         
               10 T5-CUT-IND            PIC X(01) VALUE SPACES.         
               10 T5-APPLIANCE-DESC     PIC X(20) VALUE SPACES.         
               10 T5-CRAWL-FL           PIC X(01) VALUE SPACES.         
                                                                        
      ******************************************************************        
      * CSR02210 - SNAPSHOT DATA FROM ACCOUNT                          *        
      ******************************************************************        
                                                                        
       01  CSR02210-CALL-DATA.                                          
           03 ACCOUNT-NO-2210           PIC X(13) VALUE SPACES.         
           03 PREMISE-NO-2210           PIC X(10) VALUE SPACES.         
           03 COMPANY-NO-2210           PIC X(02) VALUE SPACES.         
           03 MKTG-ORDER-2210           PIC X(01) VALUE SPACES.         
           03 RETURN-UTILS-2210         PIC X(01) VALUE SPACES.         
           03 RETURN-DISC-BAL-2210      PIC X(01) VALUE SPACES.         
           03 ORDER-REASON-2210         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02210-RETURN-DATA.                                        
           05  RETURN-CODE-2210      PIC S9(9)     COMP VALUE 0.        
           05  ACTIVE-PARA-2210      PIC X(30)     VALUE SPACES.        
           05  TABLE-NAME-2210       PIC X(30)     VALUE SPACES.        
           05  TABLE-ID-2210         PIC X(2)      VALUE SPACES.        
           05  UT-CODE-UTIL-TY-2210  PIC X(1)      VALUE SPACES.        
           05  UT-IC-NO-2210         PIC S9(4)     COMP VALUE 0.        
           05  UT-READ-ROUTE-2210    PIC S9(4)     COMP VALUE 0.        
           05  UT-RATE-PLAN-NO-2210  PIC X(3)      VALUE SPACES.        
           05  UT-RATE-DESC-2210     PIC X(25)     VALUE SPACES.        
           05  UT-CODE-REV-CLA-2210  PIC X(3)      VALUE SPACES.        
           05  UT-READ-CYCLE-2210    PIC X(2)      VALUE SPACES.        
           05  UT-CODE-SIC-NO-2210   PIC X(4)      VALUE SPACES.        
           05  MN-METER-NO-2210      PIC X(9)      VALUE SPACES.        
           05  MN-MTR-REF-NO-2210    PIC S9(4)     COMP VALUE 0.        
           05  MN-CODE-TIME-PE-2210  PIC S9(4)     COMP VALUE 0.        
           05  MN-LAST-READ-VA-2210  PIC S9(12)V999 COMP-3 VALUE 0.     
           05  MN-CD-STUS-RS-2210    PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-T-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-I-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-METER-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-METER-SUPPLY-2210  PIC X(15)     VALUE SPACES.        
           05  MN-CODE-METER-L-2210  PIC X(2)      VALUE SPACES.        
           05  MN-METER-LOC-DE-2210  PIC X(14)     VALUE SPACES.        
           05  MN-METER-IND-2210     PIC X(1)      VALUE SPACES.        
           05  MN-CONSTANT-2210      PIC S9(6)V    COMP-3 VALUE 0.      
           05  MN-NO-DIALS-2210      PIC S9(4) COMP VALUE 0.            
           05  MN-DIST-NODE-PO-2210  PIC X(20)     VALUE SPACES.        
           05  MN-POINT-ID-2210      PIC X(10)     VALUE SPACES.        
           05  MN-SEAL-CODE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-HEX-LOCATION-2210  PIC X(02)     VALUE SPACES.        
           05  MN-INSULATED-IN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-LOCK-TYPE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-DELIVERY-LEV-2210  PIC X(01)     VALUE SPACES.        
           05  MN-UTILITY-SOUR-2210  PIC X(01)     VALUE SPACES.        
           05  MN-IDR-RECIPIEN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-PROGRAM-ID-2210    PIC X(02)     VALUE SPACES.        
           05  MN-MTR-READ-SO-2210   PIC X(01)     VALUE SPACES.        
           05  RG-CODE-REG-ST-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-STATUS-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-TIME-P-2210   PIC S9(4)     COMP VALUE 0.        
           05  RG-CODE-USAGE-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-SRC-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  RG-LAST-READD-2210    PIC X(10)     VALUE SPACES.        
           05  RG-LST-READVL-2210    PIC S9(12)V9(3) COMP-3 VALUE 0.    
           05  RG-REG-ID-NO-2210     PIC S9(4)     COMP VALUE 0.        
           05  CP-NO-UNITS-2210      PIC S9(9)     COMP VALUE 0.        
           05  CP-CODE-PLAN-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-STATRS-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-SVC-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  CP-MTLY-AMT-FX-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-RT-ITEM-CD-2210    PIC S9(4)     COMP VALUE 0.        
           05  CP-LIGHT-NO-2210      PIC S9(4)     COMP VALUE 0.        
           05  CP-POLE-NO-2210       PIC X(7)      VALUE SPACES.        
           05  CP-DIST-NO-2210       PIC X(3)      VALUE SPACES.        
           05  CP-USAGE-FIXED-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-ITEM-SEQ-NO-2210   PIC S9(4)     COMP VALUE 0.        
           05  CP-EQUIP-ID-2210      PIC X(2)      VALUE SPACES.        
           05  PREM-DIR-IND-2210     PIC X(1)      VALUE SPACES.        
           05  SUBDIV-LIGHT-2210 PIC S9(3)V        COMP-3 VALUE 0.      
           05  ACCT-TYPE-2210        PIC X(1)      VALUE SPACES.        
           05  CD-RNTL-PROP-2210     PIC X(1)      VALUE SPACES.        
           05  LL-CUSTOMER-NO-2210   PIC S9(10)    COMP-3 VALUE 0.      
           05  REV-DIST-CD-2210      PIC X(3)      VALUE SPACES.        
           05  DISC-BAL-2210         PIC S9(11)V99 COMP-3 VALUE 0.      
           05  OUT-ACCOUNT-NO-2210   PIC S9(13)V   COMP-3 VALUE 0.      
           05  ACCT-STATUS-2210      PIC X(1)      VALUE SPACES.        
           05  ROW-NO-2210           PIC S9(4)     COMP VALUE 0.        
           05  DEPOSIT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  SEC-TOT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  CUR-MTH-ARR-CD-2210   PIC X(01)     VALUE SPACES.        
           05  CREDIT-GROUP-2210     PIC X(01)     VALUE SPACES.        
           05  CURRENT-ACCOUNT-2210  PIC X(01)     VALUE 'Y'.           
           05  DATE-BNKRPT-FL-2210   PIC X(10)     VALUE SPACES.        
           05  FILED-CASE-NO-2210    PIC X(10)     VALUE SPACES.        
           05  DL-NO-2210            PIC X(19)     VALUE SPACES.        
           05  DL-STATE-2210         PIC X(02)     VALUE SPACES.        
           05  SSN-2210              PIC X(09)     VALUE SPACES.        
           05  PRIOR-ACCT-STAT-2210  PIC X(01)     VALUE SPACES.        
           05  READ-CYCLE-2210       PIC X(02)     VALUE SPACES.        
           05  SERV-STRT-DT-2210     PIC X(10)     VALUE SPACES.        
           05  DEP-INTST-RT-2210     PIC S9(2)V99  COMP-3 VALUE 0.      
           05  CP-DT-PLN-ST-2210     PIC X(10)     VALUE SPACES.        
           05  ACTIVE-CONTRACT-2210  PIC X(01)     VALUE SPACES.        
           05  SECURED-RATE-FL-2210  PIC X(01)     VALUE SPACES.        
           05  MN-CODE-MTR-RD-2210   PIC X(02)     VALUE SPACES.        
           05  MN-MTR-PRESS-2210     PIC X(03)     VALUE SPACES.        
P00390     05  ERROR-MSG-NO-02-2210  PIC X(05)     VALUE SPACES.        
P00390     05  ERROR-MSG-NO-A4-2210  PIC X(05)     VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR00073 - ADD/UPDATE SERVICE ORDER                            *        
      ******************************************************************        
                                                                        
       01  CSR00073-CALL-DATA.                                          
           03  ROW-NO-0073              PIC S9(4) COMP VALUE 0.         
           03  PREMISE-NO-0073          PIC X(10) VALUE SPACES.         
           03  ACCOUNT-NO-0073          PIC X(13) VALUE SPACES.         
           03  ACCOUNT-NO-PRIOR-0073    PIC X(13) VALUE SPACES.         
           03  SERV-ORDER-NO-0073       PIC X(13) VALUE SPACES.         
           03  ORDER-TYPE-CD-0073       PIC X(05) VALUE SPACES.         
           03  LOCAL-OFFICE-0073        PIC X(03) VALUE SPACES.         
           03  PHONE-NO-EXT-0073        PIC X(06) VALUE SPACES.         
           03  PHONE-NO-0073            PIC X(10) VALUE SPACES.         
           03  ORDER-PLACED-BY-0073     PIC X(25) VALUE SPACES.         
           03  ORDER-RECVED-BY-0073     PIC X(07) VALUE SPACES.         
           03  WANTED-BY-DATE-0073      PIC X(10) VALUE SPACES.         
           03  ASSIGNED-DATETIME-0073   PIC X(26) VALUE SPACES.         
           03  ORDER-REASON-0073        PIC X(01) VALUE SPACES.         
           03  BACK-DATED-IND-0073      PIC X(01) VALUE SPACES.         
           03  RESP-AREA-ID-0073        PIC X(03) VALUE SPACES.         
           03  CALL-BEFORE-MIN-0073     PIC X(03) VALUE SPACES.         
           03  NOTIFY-CUST-IND-0073     PIC X(01) VALUE SPACES.         
           03  NOTIFY-CSR-IND-0073      PIC X(01) VALUE SPACES.         
           03  BREAKERS-OFF-0073        PIC X(01) VALUE SPACES.         
           03  DEPOSIT-AMT-0073         PIC S9(9)V9(2) COMP-3 VALUE 0.  
           03  INIT-BY-CNTRCT-0073      PIC X(01) VALUE SPACES.         
           03  WORK-AREA-ID-0073        PIC X(12) VALUE SPACES.         
           03  ORDER-PRIORITY-0073      PIC S9(4) COMP VALUE 0.         
           03  ORDER-STATE-CD-0073      PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-0073        PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-0073      PIC X(01) VALUE SPACES.         
           03  STD-CHG-AMT-0073         PIC S9(7)V9(2) COMP-3 VALUE 0.  
           03  HOLD-RELEASE-0073        PIC X(01) VALUE SPACES.         
           03  RLSE-IND-0073            PIC X(01) VALUE SPACES.         
           03  PER-TEMP-IND-0073        PIC X(01) VALUE SPACES.         
           03  RLSE-NO-0073             PIC X(10) VALUE SPACES.         
           03  RLSE-DATE-0073           PIC X(10) VALUE SPACES.         
           03  SO-INST-SEQ-NO-0073      PIC S9(4) COMP VALUE 0.         
           03  TABLE-ID-0073            PIC X(02) VALUE SPACES.         
           03  UT-CODE-UTIL-TYPE-0073   PIC X(01) VALUE SPACES.         
           03  IC-NO-0073               PIC S9(4) COMP VALUE 0.         
           03  UT-READ-ROUTE-0073       PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-NO-0073        PIC X(03) VALUE SPACES.         
           03  UT-CODE-REV-CLASS-0073   PIC X(03) VALUE SPACES.         
           03  UT-READ-CYCLE-0073       PIC X(02) VALUE SPACES.         
           03  UT-CODE-SIC-NO-0073      PIC X(04) VALUE SPACES.         
           03  METER-NO-0073            PIC X(09) VALUE SPACES.         
           03  MN-MTR-REF-NO-0073       PIC S9(4) COMP VALUE 0.         
           03  MN-CODE-TIME-PER-0073    PIC S9(4) COMP VALUE 0.         
           03  MN-LAST-READ-VAL-0073    PIC S9(12)V9(3) COMP-3 VALUE 0. 
           03  MN-CODE-STATUS-REA-0073  PIC X(01) VALUE SPACES.         
           03  MN-CODE-USAGE-TYPE-0073  PIC X(01) VALUE SPACES.         
           03  MN-CODE-USAGE-ID-0073    PIC X(01) VALUE SPACES.         
           03  MN-CODE-USAGE-SO-0073    PIC X(01) VALUE SPACES.         
           03  CODE-METER-STATUS-0073   PIC X(01) VALUE SPACES.         
           03  METER-SUPPLYING-0073     PIC X(15) VALUE SPACES.         
           03  CODE-MTR-LOC-0073        PIC X(02) VALUE SPACES.         
           03  MN-CONSTANT-0073         PIC S9(6)V9(3) COMP-3 VALUE 0.  
           03  MN-NO-DIALS-0073         PIC S9(4) COMP VALUE 0.         
           03  MN-POINT-ID-0073         PIC X(10) VALUE SPACES.         
           03  MN-SEAL-CODE-ID-0073     PIC X(01) VALUE SPACES.         
           03  MN-HEX-LOCATION-0073     PIC X(02) VALUE SPACES.         
           03  MN-INSULATED-IND-0073    PIC X(01) VALUE SPACES.         
           03  MN-LOCK-TYPE-ID-0073     PIC X(01) VALUE SPACES.         
           03  MN-DELV-LEVEL-CD-0073    PIC X(01) VALUE SPACES.         
           03  MN-UTILITY-SOURCE-0073   PIC X(01) VALUE SPACES.         
           03  MN-IDR-RECIPIENT-0073    PIC X(01) VALUE SPACES.         
           03  MN-PROGRAM-ID-0073       PIC X(02) VALUE SPACES.         
           03  READ-SOURCE-CD-0073      PIC X(01) VALUE SPACES.         
           03  RG-CODE-REG-STAT-0073    PIC X(01) VALUE SPACES.         
           03  RG-CODE-STATUS-REA-0073  PIC X(01) VALUE SPACES.         
           03  RG-CODE-TIME-PER-0073    PIC S9(4) COMP VALUE 0.         
           03  RG-CODE-USAGE-ID-0073    PIC X(01) VALUE SPACES.         
           03  RG-CODE-USAGE-SO-0073    PIC X(01) VALUE SPACES.         
           03  RG-CODE-USAGE-TY-0073    PIC X(01) VALUE SPACES.         
           03  RG-LAST-READ-DT-0073     PIC X(10) VALUE SPACES.         
           03  RG-LAST-READ-VAL-0073    PIC S9(12)V9(3) COMP-3 VALUE 0. 
           03  RG-REG-ID-NO-0073        PIC S9(4) COMP VALUE 0.         
           03  CP-NO-UNITS-0073         PIC S9(9) COMP VALUE 0.         
           03  CP-CODE-PLAN-STA-0073    PIC X(01) VALUE SPACES.         
           03  CP-CODE-STAT-REA-0073    PIC X(01) VALUE SPACES.         
           03  CP-CODE-SERVICEZ-0073    PIC X(01) VALUE SPACES.         
           03  CP-MNTHLY-AMT-FI-0073    PIC S9(9)V9(2) COMP-3 VALUE 0.  
           03  CP-RATE-ITEM-CD-0073     PIC S9(4) COMP VALUE 0.         
           03  CP-LIGHT-NO-0073         PIC S9(4) COMP VALUE 0.         
           03  CP-POLE-NO-0073          PIC X(07) VALUE SPACES.         
           03  CP-DIST-NO-0073          PIC X(03) VALUE SPACES.         
           03  CP-USAGE-FIXED-0073      PIC S9(9)V COMP-3 VALUE 0.      
           03  CP-EQUIP-ID-0073         PIC X(02) VALUE SPACES.         
           03  APPLIANCE-CD-0073        PIC X(03) VALUE SPACES.         
           03  APPLIANCE-SEQ-NO-0073    PIC S9(4) COMP VALUE 0.         
           03  EQUIP-OWNER-0073         PIC X(01) VALUE SPACES.         
           03  MKT-CODE-UTIL-TYPE-0073  PIC X(01) VALUE SPACES.         
           03  LEAK-IND-0073            PIC X(01) VALUE SPACES.         
           03  LIGHT-IND-0073           PIC X(01) VALUE SPACES.         
           03  REPAIR-IND-0073          PIC X(01) VALUE SPACES.         
           03  CUTOFF-IND-0073          PIC X(01) VALUE SPACES.         
           03  CAUTION-TAG-IND-0073     PIC X(01) VALUE SPACES.         
           03  IMPROPER-REASON-0073     PIC X(50) VALUE SPACES.         
           03  EQUIPMENT-UNQ-0073       PIC X(20) VALUE SPACES.         
           03  VERIFY-RATE-0073         PIC X(01) VALUE SPACES.         
           03  ORDER-INST-PRESEN-0073   PIC X(01) VALUE SPACES.         
           03  EQUIPMENT-PRESEN-0073    PIC X(01) VALUE SPACES.         
           03  UTIL-ENV-PRESEN-0073     PIC X(01) VALUE SPACES.         
           03  NEW-ORDER-0073           PIC X(01) VALUE SPACES.         
           03  PANEL-NO-0073            PIC X(04) VALUE SPACES.         
           03  INCLUDE-INST-0073        PIC X(01) VALUE SPACES.         
           03  REV-DIST-CD-0073         PIC X(03) VALUE SPACES.         
           03  USER-ID-0073             PIC X(07) VALUE SPACES.         
           03  SO-EST-LABOR-HR-0073     PIC S9(2)V9(1) COMP-3 VALUE 0.  
           03  ACCT-STATUS-0073         PIC X(01) VALUE SPACES.         
           03  REORDER-FLAG-0073        PIC X(01) VALUE SPACES.         
           03  COMPANY-NO-0073          PIC X(02) VALUE SPACES.         
           03  INSTALL-DT-0073          PIC X(10) VALUE SPACES.         
           03  REPLACE-APP-FL-0073      PIC X(01) VALUE SPACES.         
           03  PRD-SRV-TYPE-DESC-0073   PIC X(32) VALUE SPACES.         
           03  OLD-ACCT-STAT-0073       PIC X(01) VALUE SPACES.         
           03  CODE-KEY-FIELD-0073      PIC X(01) VALUE SPACES.         
           03  RCC-CODE-0073            PIC X(03) VALUE SPACES.         
           03  MN-LAST-READ-DT-0073     PIC X(10) VALUE SPACES.         
           03  MN-REG-ID-NO-0073        PIC S9(4) COMP VALUE 0.         
           03  DATE-FORECAST-DNP-0073   PIC X(10) VALUE SPACES.         
           03  AMT-DNP-AT-BILLING-0073  PIC S9(11)V9(2) COMP-3 VALUE 0. 
           03  PRICE-PER-SERV-0073      PIC S9(3)V9(6) COMP-3 VALUE 0.  
           03  ACCOUNT-TYPE-CODE-0073   PIC X(01) VALUE SPACES.         
           03  INSTALL-IND-0073         PIC X(01) VALUE SPACES.         
           03  CP-ITEM-SEQ-NO-0073      PIC S9(4) COMP VALUE 0.         
           03  CUST-CNT-ID-0073         PIC X(10) VALUE SPACES.         
           03  WORK-PERIOD-CD-0073      PIC X(01) VALUE SPACES.         
           03  WAIVER-TYPE-CD-0073      PIC X(01) VALUE SPACES.         
           03  MN-METER-PRESSURE-0073   PIC X(03) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-0073       PIC X(03) VALUE SPACES.         
P00718     03  OPTIMIZE-ORDER-0073      PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR00073-RETURN-DATA.                                        
           05  NO-ERROR-0073             PIC S9(9) COMP VALUE 0.        
           05  NEW-SERV-ORDER-NO-0073    PIC S9(13)V COMP-3 VALUE 0.    
           05  WORK-QUEUE-0073           PIC S9(9) COMP VALUE 0.        
           05  RLSE-NO-NEW-0073          PIC X(10) VALUE SPACES.        
                                                                        
      ******************************************************************        
ACT233* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
ACT233     05  SERV-ORDER-NO-4675        PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) COMP VALUE 0.        
ACT233     05  ACCOUNT-NO-4675           PIC S9(13)V COMP-3 VALUE 0.    
ACT233     05  PREMISE-NO-4675           PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  CUSTOMER-NO-4675          PIC S9(10)V COMP-3 VALUE 0.    
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) COMP VALUE 0.        
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) COMP VALUE 0.       
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
      ******************************************************************        
      * CSR00148 - INSERT FINAL BILL ADDRESS                           *        
      ******************************************************************        
                                                                        
       01  CSR00148-CALL-DATA.                                          
           05  SERV-ORDER-NO-0148        PIC X(13) VALUE SPACES.        
           05  ADDRESS-FORMAT-0148       PIC X(01) VALUE SPACES.        
           05  CREDIT-LETTER-IND-0148    PIC X(01) VALUE SPACES.        
           05  SEND-TO-LOCOFF-IND-0148   PIC X(01) VALUE SPACES.        
           05  HOUSE-NO-0148             PIC X(05) VALUE SPACES.        
           05  ADDR-PREFIX-1-0148        PIC X(03) VALUE SPACES.        
           05  ADDR-PREFIX-2-0148        PIC X(02) VALUE SPACES.        
           05  STREET-NAME-0148          PIC X(16) VALUE SPACES.        
           05  STREET-SUFFIX-0148        PIC X(04) VALUE SPACES.        
           05  ADDR-SUFFIX-0148          PIC X(02) VALUE SPACES.        
           05  STREET-LOC-1-0148         PIC X(04) VALUE SPACES.        
           05  STREET-LOC-2-0148         PIC X(06) VALUE SPACES.        
           05  ZIP-CODE-0148             PIC X(05) VALUE SPACES.        
           05  ZIP-CODE-PLUS-FOUR-0148   PIC X(04) VALUE SPACES.        
           05  ZIP-CODE-TOKEN-0148       PIC X(01) VALUE SPACES.        
           05  ADDRESS-OVERFLOW-0148     PIC X(35) VALUE SPACES.        
           05  ADDR-ST-0148              PIC X(35) VALUE SPACES.        
           05  FINAL-BILL-CY-ST-0148     PIC X(20) VALUE SPACES.        
           05  ADDR-ZIP-CODE-0148        PIC X(09) VALUE SPACES.        
           05  ADDR-COUNTRY-0148         PIC X(35) VALUE SPACES.        
           05  FINAL-BILL-OVFL-0148      PIC X(35) VALUE SPACES.        
           05  CARRIER-ROUTE-0148        PIC X(05) VALUE SPACES.        
                                                                        
       01  CSR00148-RETURN-DATA.                                        
           05  RETURN-CODE-0148          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02517 - ADD A COMMUNICATION RECORD                          *        
      ******************************************************************        
                                                                        
       01  CSR02517-CALL-DATA.                                          
           05  ACTION-CD-2517            PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2517           PIC X(13) VALUE SPACES.        
           05  CUSTOMER-NO-2517          PIC X(10) VALUE SPACES.        
           05  PREMISE-NO-2517           PIC X(10) VALUE SPACES.        
           05  COMMUNICATION-ID-2517     PIC X(26) VALUE SPACES.        
           05  COMPANY-NO-2517           PIC X(13) VALUE SPACES.        
           05  RED-FLAG-IND-2517         PIC X(01) VALUE SPACES.        
           05  RED-FLAG-EXP-DT-2517      PIC X(26) VALUE SPACES.        
           05  COMM-METHOD-2517          PIC X(01) VALUE SPACES.        
           05  COMM-DIRECTION-2517       PIC X(01) VALUE SPACES.        
           05  COMM-TYPE-CD-2517         PIC X(02) VALUE SPACES.        
           05  COMM-SUBTYPE-CD-2517      PIC X(02) VALUE SPACES.        
           05  USER-ID-ORIG-2517         PIC X(07) VALUE SPACES.        
           05  CONTACT-NAME-2517         PIC X(25) VALUE SPACES.        
           05  PROMOTION-ID-2517         PIC X(12) VALUE SPACES.        
           05  PSC-COMPLAINT-IND-2517    PIC X(01) VALUE SPACES.        
           05  CALL-ORIGIN-ID-2517       PIC X(04) VALUE SPACES.        
           05  CALL-END-TIME-2517        PIC X(26) VALUE SPACES.        
           05  NUMBER-TRANSFERS-2517     PIC X(09) VALUE SPACES.        
           05  HOLD-TIME-2517            PIC X(05) VALUE SPACES.        
           05  QUEUE-TIME-2517           PIC X(05) VALUE SPACES.        
           05  SCREEN-POP-IND-2517       PIC X(01) VALUE SPACES.        
           05  TOTAL-CALL-TIME-2517      PIC X(05) VALUE SPACES.        
           05  COMMENT-LEN-2517          PIC S9(4) COMP VALUE 0.        
           05  COMMENT-TEXT-2517         PIC X(255) VALUE SPACES.       
           05  COMM-ASSOC-CD-2517        PIC X(01) VALUE SPACES.        
           05  COMPLAINT-FL-2517         PIC X(01) VALUE SPACES.        
           05  RESPONSE-RESN-CD-2517     PIC X(04) VALUE SPACES.        
           05  RESPONSE-TYPE-CD-2517     PIC X(04) VALUE SPACES.        
           05  SOLICITATION-CD-2517      PIC X(03) VALUE SPACES.        
                                                                        
       01  CSR02517-RETURN-DATA.                                        
           05  RETURN-CODE-2517          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02165 - ADD A WAIVER                                        *        
      ******************************************************************        
                                                                        
       01  CSR02165-CALL-DATA.                                          
           05  ACTION-CODE-2165          PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2165           PIC X(13) VALUE SPACES.        
           05  WAIVER-TYPE-CD-2165       PIC X(01) VALUE SPACES.        
           05  CODE-STATUS-2165          PIC X(01) VALUE SPACES.        
           05  COMMENTS-LEN-2165         PIC X(04) VALUE SPACES.        
           05  COMMENTS-TEXT-2165        PIC X(72) VALUE SPACES.        
           05  CODE-STATUS-REAS-2165     PIC X(20) VALUE SPACES.        
           05  WAIVER-SRCE-DESC-2165     PIC X(35) VALUE SPACES.        
           05  TRIGGER-DATE-2165         PIC X(10) VALUE SPACES.        
           05  BOND-ITEM-ID-2165         PIC X(09) VALUE SPACES.        
           05  USER-ID-2165              PIC X(07) VALUE SPACES.        
           05  TRAN-COMMENT-LEN-2165     PIC X(04) VALUE SPACES.        
           05  TRAN-COMMENT-TXT-2165     PIC X(210) VALUE SPACES.       
                                                                        
       01  CSR02165-RETURN-DATA.                                        
           05  RETURN-CODE-2165          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02142 - GET XFER INFORMATION                                *        
      ******************************************************************        
                                                                        
       01  CSR02142-CALL-DATA.                                          
           05  ACCOUNT-NO-2142           PIC X(13) VALUE SPACES.        
                                                                        
       01  CSR02142-RETURN-DATA.                                        
           05  DNP-DATE-2142           PIC X(10).                       
           05  PAST-DUE-BAL-2142       PIC S9(09)V99 COMP-3 VALUE +0.   
           05  BILL-DATE-2142          PIC X(10) VALUE SPACES.          
           05  CREDIT-GROUP-2142       PIC X(01) VALUE SPACES.          
           05  ACCT-XFER-FROM-LST-2142 PIC X(13) VALUE SPACES.          
           05  STA-IND-2142            PIC X(01) VALUE SPACES.          
           05  UTL-IND-2142            PIC X(01) VALUE SPACES.          
           05  BANK-DRAFT-IND-2142     PIC X(01) VALUE SPACES.          
           05  EPP-IND-2142            PIC X(01) VALUE SPACES.          
           05  DEPOSIT-IND-2142        PIC X(01) VALUE SPACES.          
           05  OTHER-RECV-IND-2142     PIC X(01) VALUE SPACES.          
           05  PROJ-SHARE-IND-2142     PIC X(01) VALUE SPACES.          
           05  WRITE-OFF-IND-2142      PIC X(01) VALUE SPACES.          
           05  IN-LIEU-DEP-IND-2142    PIC X(01) VALUE SPACES.          
           05  ROOMMATE-IND-2142       PIC X(01) VALUE SPACES.          
           05  CO-APP-IND-2142         PIC X(01) VALUE SPACES.          
           05  MEDICAL-IND-2142        PIC X(01) VALUE SPACES.          
           05  WHITE-CROSS-IND-2142    PIC X(01) VALUE SPACES.          
           05  RETURN-CODE-2142        PIC S9(9) COMP VALUE 0.          
           05  EPP-TRAN-BALANCE-2142   PIC S9(09)V99 COMP-3 VALUE +0.   
           05  CONTRACT-FLAG-2142      PIC X(01) VALUE SPACES.          
           05  CODE-ACCT-STAT-2142     PIC X(01) VALUE SPACES.          
           05  ADDRESS-FORMAT-2142     PIC X(01) VALUE SPACES.          
           05  HOUSE-NO-2142           PIC X(05) VALUE SPACES.          
           05  ADDR-PREFIX-1-2142      PIC X(03) VALUE SPACES.          
           05  ADDR-PREFIX-2-2142      PIC X(02) VALUE SPACES.          
           05  STREET-NAME-2142        PIC X(16) VALUE SPACES.          
           05  STREET-SUFFIX-2142      PIC X(04) VALUE SPACES.          
           05  ADDR-SUFFIX-2142        PIC X(02) VALUE SPACES.          
           05  STREET-LOCATION-1-2142  PIC X(04) VALUE SPACES.          
           05  STREET-LOCATION-2-2142  PIC X(06) VALUE SPACES.          
           05  ZIP-CODE-2142           PIC X(05) VALUE SPACES.          
           05  ZIP-CODE-PLUS-FOUR-2142 PIC X(04) VALUE SPACES.          
           05  ZIP-CODE-TOKEN-2142     PIC X(01) VALUE SPACES.          
           05  ADDRESS-OVERFLOW-2142   PIC X(35) VALUE SPACES.          
           05  ADDR-STREET-2142        PIC X(35) VALUE SPACES.          
           05  ADDR-CITY-STATE-2142    PIC X(20) VALUE SPACES.          
           05  ADDR-ZIP-CODE-2142      PIC X(09) VALUE SPACES.          
           05  ADDR-COUNTRY-2142       PIC X(35) VALUE SPACES.          
           05  ADDR-OVERFLOW-2142      PIC X(35) VALUE SPACES.          
                                                                        
      ******************************************************************        
      * CSR00178 - UPDATE XFER INFORMATION                             *        
      ******************************************************************        
                                                                        
       01  CSR00178-CALL-DATA.                                          
           05  UPDATE-TYPE-0178          PIC X(01) VALUE SPACES.        
           05  TO-ACCT-NO-0178           PIC S9(13)V COMP-3 VALUE 0.    
           05  SERV-ORDER-NO-0178        PIC X(13) VALUE SPACES.        
           05  ROOMMATE-XFER-IND-0178    PIC X(01) VALUE SPACES.        
           05  EPP-XFER-IND-0178         PIC X(01) VALUE SPACES.        
           05  DEPOSIT-XFER-IND-0178     PIC X(01) VALUE SPACES.        
           05  OTHER-AR-XFER-IND-0178    PIC X(01) VALUE SPACES.        
           05  PROJ-SHR-XFER-IND-0178    PIC X(01) VALUE SPACES.        
           05  WRITE-OFF-XFER-IND-0178   PIC X(01) VALUE SPACES.        
           05  IN-LIEU-XFER-IND-0178     PIC X(01) VALUE SPACES.        
           05  WHT-CROSS-XFER-IND-0178   PIC X(01) VALUE SPACES.        
           05  COAPPL-XFER-IND-0178      PIC X(01) VALUE SPACES.        
           05  MED-CERT-XFER-IND-0178    PIC X(01) VALUE SPACES.        
                                                                        
       01  CSR00178-RETURN-DATA.                                        
           05  RETURN-CODE-0178        PIC S9(9) COMP VALUE 0.          
                                                                        
      ******************************************************************        
      * CSR02146 - GET CONTRACT INFORMATION                            *        
      ******************************************************************        
                                                                        
       01  CSR02146-CALL-DATA.                                          
           05  ACCOUNT-NO-2146           PIC X(13) VALUE SPACES.        
                                                                        
       01  CSR02146-RETURN-DATA.                                        
           05  CONTRACT-ID-2146        PIC S9(9) COMP VALUE 0.          
           05  CONTRACT-NAME-ABBR-2146 PIC X(10) VALUE SPACES.          
           05  AR-TRAN-BAL-2146        PIC S9(09)V99 COMP-3 VALUE +0.   
           05  LIEN-CD-2146            PIC X(1) VALUE SPACES.           
P00795     05  TRANSFER-FL-2146        PIC X(1) VALUE SPACES.           
P00795     05  CNT-NAME-DESC-2146      PIC X(30) VALUE SPACES.          
           05  RETURN-CODE-2146        PIC S9(09) COMP VALUE 0.         
                                                                        
      ******************************************************************        
      * CSR00178 - UPDATE CONTRACT INFO FOR XFER                       *        
      ******************************************************************        
                                                                        
       01  CSR00179-CALL-DATA.                                          
           05  UPDATE-TYPE-0179        PIC X(01) VALUE SPACES.          
           05  TO-ACCT-NO-0179         PIC S9(13)V COMP-3 VALUE 0.      
           05  CNT-ITEM-ID-0179        PIC S9(9) COMP VALUE 0.          
           05  SERV-ORDER-NO-0179      PIC X(13) VALUE SPACES.          
                                                                        
       01  CSR00179-RETURN-DATA.                                        
           05  RETURN-CODE-0179        PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-COMPRESSION-TABLES.                                       
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) COMP.                 
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) COMP.                 
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) COMP.                 
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC2210 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0073 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0425 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2517 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0148 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2165 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2142 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0178 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2146 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0179 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE APP_CURSOR CURSOR FOR                            
                   SELECT LA.APPLIANCE_CD,                              
                          LA.PRIMARY_FUEL_CD,                           
                          LA.EQUIPMENT_NO,                              
                          LA.CAUTION_TAG_IND,                           
                          A7.CONDITION_DESC,                            
                          LA.CUT_IND,                                   
                          JA.APPLIANCE_DESC,                            
                          JA.CRAWL_FL                                   
                     FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),               
                          CSS_APPLIANCE_COND A7 WITH(READUNCOMMITTED),          
                          CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)            
                    WHERE LA.PREMISE_NO = :LA-PREMISE-NO                
                      AND LA.PRIMARY_FUEL_CD = 'NA-GAS'                 
                      AND LA.CONDITION_CD    = A7.CONDITION_CD          
                      AND LA.COMPANY_NO      = A7.COMPANY_NO            
                      AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD          
                      AND LA.COMPANY_NO      = JA.COMPANY_NO            
                                                                 
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE APP_CURSOR CURSOR FOR                                    
MFA-TR*            SELECT LA.APPLIANCE_CD,                                      
MFA-TR*                   LA.PRIMARY_FUEL_CD,                                   
MFA-TR*                   LA.EQUIPMENT_NO,                                      
MFA-TR*                   LA.CAUTION_TAG_IND,                                   
MFA-TR*                   A7.CONDITION_DESC,                                    
MFA-TR*                   LA.CUT_IND,                                           
MFA-TR*                   JA.APPLIANCE_DESC,                                    
MFA-TR*                   JA.CRAWL_FL                                           
MFA-TR*              FROM CSS_APPLIANCE LA,                                     
MFA-TR*                   CSS_APPLIANCE_COND A7,                                
MFA-TR*                   CSS_MKT_APPLIANCE JA                                  
MFA-TR*             WHERE LA.PREMISE_NO = :LA-PREMISE-NO                        
MFA-TR*               AND LA.PRIMARY_FUEL_CD = 'NA-GAS'                         
MFA-TR*               AND LA.CONDITION_CD    = A7.CONDITION_CD                  
MFA-TR*               AND LA.COMPANY_NO      = A7.COMPANY_NO                    
MFA-TR*               AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD                  
MFA-TR*               AND LA.COMPANY_NO      = JA.COMPANY_NO                    
MFA-TR*            WITH UR                                                      
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2210 CURSOR
MSQ001          FOR CALL CSR02210                                             
                  ( :ACCOUNT-NO-2210
                  , :PREMISE-NO-2210
                  , :COMPANY-NO-2210
                  , :MKTG-ORDER-2210
                  , :RETURN-UTILS-2210
                  , :RETURN-DISC-BAL-2210
                  , :ORDER-REASON-2210
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0148 CURSOR
MSQ001          FOR CALL CSR00148                                             
                  ( :SERV-ORDER-NO-0148
                  , :ADDRESS-FORMAT-0148
                  , :CREDIT-LETTER-IND-0148
                  , :SEND-TO-LOCOFF-IND-0148
                  , :HOUSE-NO-0148
                  , :ADDR-PREFIX-1-0148
                  , :ADDR-PREFIX-2-0148
                  , :STREET-NAME-0148
                  , :STREET-SUFFIX-0148
                  , :ADDR-SUFFIX-0148
                  , :STREET-LOC-1-0148
                  , :STREET-LOC-2-0148
                  , :ZIP-CODE-0148
                  , :ZIP-CODE-PLUS-FOUR-0148
                  , :ZIP-CODE-TOKEN-0148
                  , :ADDRESS-OVERFLOW-0148
                  , :ADDR-ST-0148
                  , :FINAL-BILL-CY-ST-0148
                  , :ADDR-ZIP-CODE-0148
                  , :ADDR-COUNTRY-0148
                  , :FINAL-BILL-OVFL-0148
                  , :CARRIER-ROUTE-0148
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0073 CURSOR
MSQ001          FOR CALL CSR00073                                             
                  ( :ROW-NO-0073
                  , :PREMISE-NO-0073
                  , :ACCOUNT-NO-0073
                  , :ACCOUNT-NO-PRIOR-0073
                  , :SERV-ORDER-NO-0073
                  , :ORDER-TYPE-CD-0073
                  , :LOCAL-OFFICE-0073
                  , :PHONE-NO-EXT-0073
                  , :PHONE-NO-0073
                  , :ORDER-PLACED-BY-0073
                  , :ORDER-RECVED-BY-0073
                  , :WANTED-BY-DATE-0073
                  , :ASSIGNED-DATETIME-0073
                  , :ORDER-REASON-0073
                  , :BACK-DATED-IND-0073
                  , :RESP-AREA-ID-0073
                  , :CALL-BEFORE-MIN-0073
                  , :NOTIFY-CUST-IND-0073
                  , :NOTIFY-CSR-IND-0073
                  , :BREAKERS-OFF-0073
                  , :DEPOSIT-AMT-0073
                  , :INIT-BY-CNTRCT-0073
                  , :WORK-AREA-ID-0073
                  , :ORDER-PRIORITY-0073
                  , :ORDER-STATE-CD-0073
                  , :WORK-TYPE-CD-0073
                  , :CODE-UTIL-TYPE-0073
                  , :STD-CHG-AMT-0073
                  , :HOLD-RELEASE-0073
                  , :RLSE-IND-0073
                  , :PER-TEMP-IND-0073
                  , :RLSE-NO-0073
                  , :RLSE-DATE-0073
                  , :SO-INST-SEQ-NO-0073
                  , :TABLE-ID-0073
                  , :UT-CODE-UTIL-TYPE-0073
                  , :IC-NO-0073
                  , :UT-READ-ROUTE-0073
                  , :RATE-PLAN-NO-0073
                  , :UT-CODE-REV-CLASS-0073
                  , :UT-READ-CYCLE-0073
                  , :UT-CODE-SIC-NO-0073
                  , :METER-NO-0073
                  , :MN-MTR-REF-NO-0073
                  , :MN-CODE-TIME-PER-0073
                  , :MN-LAST-READ-VAL-0073
                  , :MN-CODE-STATUS-REA-0073
                  , :MN-CODE-USAGE-TYPE-0073
                  , :MN-CODE-USAGE-ID-0073
                  , :MN-CODE-USAGE-SO-0073
                  , :CODE-METER-STATUS-0073
                  , :METER-SUPPLYING-0073
                  , :CODE-MTR-LOC-0073
                  , :MN-CONSTANT-0073
                  , :MN-NO-DIALS-0073
                  , :MN-POINT-ID-0073
                  , :MN-SEAL-CODE-ID-0073
                  , :MN-HEX-LOCATION-0073
                  , :MN-INSULATED-IND-0073
                  , :MN-LOCK-TYPE-ID-0073
                  , :MN-DELV-LEVEL-CD-0073
                  , :MN-UTILITY-SOURCE-0073
                  , :MN-IDR-RECIPIENT-0073
                  , :MN-PROGRAM-ID-0073
                  , :READ-SOURCE-CD-0073
                  , :RG-CODE-REG-STAT-0073
                  , :RG-CODE-STATUS-REA-0073
                  , :RG-CODE-TIME-PER-0073
                  , :RG-CODE-USAGE-ID-0073
                  , :RG-CODE-USAGE-SO-0073
                  , :RG-CODE-USAGE-TY-0073
                  , :RG-LAST-READ-DT-0073
                  , :RG-LAST-READ-VAL-0073
                  , :RG-REG-ID-NO-0073
                  , :CP-NO-UNITS-0073
                  , :CP-CODE-PLAN-STA-0073
                  , :CP-CODE-STAT-REA-0073
                  , :CP-CODE-SERVICEZ-0073
                  , :CP-MNTHLY-AMT-FI-0073
                  , :CP-RATE-ITEM-CD-0073
                  , :CP-LIGHT-NO-0073
                  , :CP-POLE-NO-0073
                  , :CP-DIST-NO-0073
                  , :CP-USAGE-FIXED-0073
                  , :CP-EQUIP-ID-0073
                  , :APPLIANCE-CD-0073
                  , :APPLIANCE-SEQ-NO-0073
                  , :EQUIP-OWNER-0073
                  , :MKT-CODE-UTIL-TYPE-0073
                  , :LEAK-IND-0073
                  , :LIGHT-IND-0073
                  , :REPAIR-IND-0073
                  , :CUTOFF-IND-0073
                  , :CAUTION-TAG-IND-0073
                  , :IMPROPER-REASON-0073
                  , :EQUIPMENT-UNQ-0073
                  , :VERIFY-RATE-0073
                  , :ORDER-INST-PRESEN-0073
                  , :EQUIPMENT-PRESEN-0073
                  , :UTIL-ENV-PRESEN-0073
                  , :NEW-ORDER-0073
                  , :PANEL-NO-0073
                  , :INCLUDE-INST-0073
                  , :REV-DIST-CD-0073
                  , :USER-ID-0073
                  , :SO-EST-LABOR-HR-0073
                  , :ACCT-STATUS-0073
                  , :REORDER-FLAG-0073
                  , :COMPANY-NO-0073
                  , :INSTALL-DT-0073
                  , :REPLACE-APP-FL-0073
                  , :PRD-SRV-TYPE-DESC-0073
                  , :OLD-ACCT-STAT-0073
                  , :CODE-KEY-FIELD-0073
                  , :RCC-CODE-0073
                  , :MN-LAST-READ-DT-0073
                  , :MN-REG-ID-NO-0073
                  , :DATE-FORECAST-DNP-0073
                  , :AMT-DNP-AT-BILLING-0073
                  , :PRICE-PER-SERV-0073
                  , :ACCOUNT-TYPE-CODE-0073
                  , :INSTALL-IND-0073
                  , :CP-ITEM-SEQ-NO-0073
                  , :CUST-CNT-ID-0073
                  , :WORK-PERIOD-CD-0073
                  , :WAIVER-TYPE-CD-0073
                  , :MN-METER-PRESSURE-0073
                  , :BUSINESS-UNIT-0073
                  , :OPTIMIZE-ORDER-0073
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2142 CURSOR
MSQ001          FOR CALL CSR02142                                             
                  ( :ACCOUNT-NO-2142
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0178 CURSOR
MSQ001          FOR CALL CSR00178                                             
                 ( :UPDATE-TYPE-0178
                  , :TO-ACCT-NO-0178
                  , :SERV-ORDER-NO-0178
                  , :ROOMMATE-XFER-IND-0178
                  , :EPP-XFER-IND-0178
                  , :DEPOSIT-XFER-IND-0178
                  , :OTHER-AR-XFER-IND-0178
                  , :PROJ-SHR-XFER-IND-0178
                  , :WRITE-OFF-XFER-IND-0178
                  , :IN-LIEU-XFER-IND-0178
                  , :WHT-CROSS-XFER-IND-0178
                  , :COAPPL-XFER-IND-0178
                  , :MED-CERT-XFER-IND-0178
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2146 CURSOR
MSQ001          FOR CALL CSR02146                                             
                  ( :ACCOUNT-NO-2146
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0179 CURSOR
MSQ001          FOR CALL CSR00179                                             
                  ( :UPDATE-TYPE-0179
                  , :TO-ACCT-NO-0179
                  , :CNT-ITEM-ID-0179
                  , :SERV-ORDER-NO-0179
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2165 CURSOR
MSQ001          FOR CALL CSR02165                                             
                  ( :ACTION-CODE-2165
                  , :ACCOUNT-NO-2165
                  , :WAIVER-TYPE-CD-2165
                  , :CODE-STATUS-2165
                  , :COMMENTS-LEN-2165
                  , :COMMENTS-TEXT-2165
                  , :CODE-STATUS-REAS-2165
                  , :WAIVER-SRCE-DESC-2165
                  , :TRIGGER-DATE-2165
                  , :BOND-ITEM-ID-2165
                  , :USER-ID-2165
                  , :TRAN-COMMENT-LEN-2165
                  , :TRAN-COMMENT-TXT-2165
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2517 CURSOR
MSQ001          FOR CALL CSR02517                                             
                  ( :ACTION-CD-2517
                  , :ACCOUNT-NO-2517
                  , :CUSTOMER-NO-2517
                  , :PREMISE-NO-2517
                  , :COMMUNICATION-ID-2517
                  , :COMPANY-NO-2517
                  , :RED-FLAG-IND-2517
                  , :RED-FLAG-EXP-DT-2517
                  , :COMM-METHOD-2517
                  , :COMM-DIRECTION-2517
                  , :COMM-TYPE-CD-2517
                  , :COMM-SUBTYPE-CD-2517
                  , :USER-ID-ORIG-2517
                  , :CONTACT-NAME-2517
                  , :PROMOTION-ID-2517
                  , :PSC-COMPLAINT-IND-2517
                  , :CALL-ORIGIN-ID-2517
                  , :CALL-END-TIME-2517
                  , :NUMBER-TRANSFERS-2517
                  , :HOLD-TIME-2517
                  , :QUEUE-TIME-2517
                  , :SCREEN-POP-IND-2517
                  , :TOTAL-CALL-TIME-2517
                  , :COMMENT-LEN-2517
                  , :COMMENT-TEXT-2517
                  , :COMM-ASSOC-CD-2517
                  , :COMPLAINT-FL-2517
                  , :RESPONSE-RESN-CD-2517
                  , :RESPONSE-TYPE-CD-2517
                  , :SOLICITATION-CD-2517
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-SERV-ORDER-NO      PIC X(13).                           
       01  LINK-UPDATE-ORDER-FL    PIC X(01).                           
       01  LINK-CURR-ORDER-TYPE    PIC X(05).                           
       01  LINK-CURR-ACCOUNT-NO    PIC X(13).                           
       01  LINK-SCHEDULED-DT       PIC X(26).                           
       01  LINK-PHONE-NO           PIC X(10).                           
       01  LINK-ORDER-PLACED-BY    PIC X(25).                           
       01  LINK-MTR-ACCESS-FL      PIC X(01).                           
       01  LINK-ORDER-RECVED-BY    PIC X(07).                           
       01  LINK-WORK-AREA          PIC X(12).                           
       01  LINK-SO-EST-LABOR-HR    PIC X(06).                           
       01  LINK-TURNOFF-REQ-FL     PIC X(01).                           
       01  LINK-TURNOFF-REASON-CD  PIC X(01).                           
       01  LINK-TURNOFF-COMMENTS   PIC X(255).                          
       01  LINK-FUEL-CHG-TYPE-CD   PIC X(01).                           
       01  LINK-FUEL-CHG-REASON-CD PIC X(01).                           
       01  LINK-ADD-FINAL-ADDR-FL  PIC X(01).                           
       01  LINK-ADDRESS-FORMAT     PIC X(01).                           
       01  LINK-HOUSE-NO           PIC X(15).                           
       01  LINK-ADDR-PREFIX-1      PIC X(03).                           
       01  LINK-ADDR-PREFIX-2      PIC X(02).                           
       01  LINK-STREET-NAME        PIC X(30).                           
       01  LINK-STREET-SUFFIX      PIC X(04).                           
       01  LINK-ADDR-SUFFIX        PIC X(02).                           
       01  LINK-STREET-LOC-1       PIC X(04).                           
       01  LINK-STREET-LOC-2       PIC X(11).                           
       01  LINK-TOWN               PIC X(26).                           
       01  LINK-STATE              PIC X(02).                           
       01  LINK-ZIP-CODE           PIC X(05).                           
       01  LINK-ZIP-CODE-PLUS-4    PIC X(04).                           
       01  LINK-ADDR-STREET        PIC X(55).                           
       01  LINK-ADDR-CITY-STATE    PIC X(30).                           
       01  LINK-FR-ZIP-CODE        PIC X(09).                           
       01  LINK-COUNTRY            PIC X(35).                           
       01  LINK-XFER-FL            PIC X(01).                           
       01  LINK-XFER-ACCOUNT-NO    PIC X(13).                           
       01  LINK-ADDR-STREET-2      PIC X(55).                           
       01  LINK-ADDRESS-OVERFLOW   PIC X(35).                           
P00718 01  LINK-BUSINESS-UNIT      PIC X(03).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PREMISE-NO                               
                          LINK-SERV-ORDER-NO                            
                          LINK-UPDATE-ORDER-FL                          
                          LINK-CURR-ORDER-TYPE                          
                          LINK-CURR-ACCOUNT-NO                          
                          LINK-SCHEDULED-DT                             
                          LINK-PHONE-NO                                 
                          LINK-ORDER-PLACED-BY                          
                          LINK-MTR-ACCESS-FL                            
                          LINK-ORDER-RECVED-BY                          
                          LINK-WORK-AREA                                
                          LINK-SO-EST-LABOR-HR                          
                          LINK-TURNOFF-REQ-FL                           
                          LINK-TURNOFF-REASON-CD                        
                          LINK-TURNOFF-COMMENTS                         
                          LINK-FUEL-CHG-TYPE-CD                         
                          LINK-FUEL-CHG-REASON-CD                       
                          LINK-ADD-FINAL-ADDR-FL                        
                          LINK-ADDRESS-FORMAT                           
                          LINK-HOUSE-NO                                 
                          LINK-ADDR-PREFIX-1                            
                          LINK-ADDR-PREFIX-2                            
                          LINK-STREET-NAME                              
                          LINK-STREET-SUFFIX                            
                          LINK-ADDR-SUFFIX                              
                          LINK-STREET-LOC-1                             
                          LINK-STREET-LOC-2                             
                          LINK-TOWN                                     
                          LINK-STATE                                    
                          LINK-ZIP-CODE                                 
                          LINK-ZIP-CODE-PLUS-4                          
                          LINK-ADDR-STREET                              
                          LINK-ADDR-CITY-STATE                          
                          LINK-FR-ZIP-CODE                              
                          LINK-COUNTRY                                  
                          LINK-XFER-FL                                  
                          LINK-XFER-ACCOUNT-NO                          
                          LINK-ADDR-STREET-2                            
                          LINK-ADDRESS-OVERFLOW                         
P00718                    LINK-BUSINESS-UNIT.                           
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE        AS RETURN_CODE,             
                      :S-STATUS-CODE        AS STATUS_CODE,             
                      :S-SERV-ORDER-NO      AS SERV_ORDER_NO,           
                      :S-CONTRACT-FL        AS CONTRACT_FL,             
                      :S-BANK-DRAFT-FL      AS BANK_DRAFT_FL,           
                      :S-EPP-FL             AS EPP_FL,                  
                      :S-DPP-FL             AS DPP_FL,                  
                      :S-DFA-FL             AS DFA_FL,                  
                      :S-MED-CERT-FL        AS MED_CERT_FL,             
                      :S-LITE-CONTRACT-FL   AS LITE_CONTRACT_FL,        
P00718          LTRIM(RTRIM(:S-WORK-DISTRICT))     AS WORK_DISTRICT            
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE        AS RETURN_CODE,                     
MFA-TR*               :S-STATUS-CODE        AS STATUS_CODE,                     
MFA-TR*               :S-SERV-ORDER-NO      AS SERV_ORDER_NO,                   
MFA-TR*               :S-CONTRACT-FL        AS CONTRACT_FL,                     
MFA-TR*               :S-BANK-DRAFT-FL      AS BANK_DRAFT_FL,                   
MFA-TR*               :S-EPP-FL             AS EPP_FL,                          
MFA-TR*               :S-DPP-FL             AS DPP_FL,                          
MFA-TR*               :S-DFA-FL             AS DFA_FL,                          
MFA-TR*               :S-MED-CERT-FL        AS MED_CERT_FL,                     
MFA-TR*               :S-LITE-CONTRACT-FL   AS LITE_CONTRACT_FL,                
MFA-TR*         STRIP(:S-WORK-DISTRICT)     AS WORK_DISTRICT                    
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')
            INTO
              :WS-CURRENT-DATE-USA       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE-USA = CHAR(CURRENT_DATE,USA)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE 'N' TO RS-CONTRACT-FL                                   
                       RS-BANK-DRAFT-FL                                 
                       RS-EPP-FL                                        
                       RS-DPP-FL                                        
                       RS-DFA-FL                                        
                       RS-MED-CERT-FL                                   
                       RS-LITE-CONTRACT-FL.                             
                                                                        
           IF LINK-UPDATE-ORDER-FL <= SPACES                            
               MOVE 'N' TO LINK-UPDATE-ORDER-FL
           END-IF.                        
           IF LINK-MTR-ACCESS-FL <= SPACES                              
               MOVE 'N' TO LINK-MTR-ACCESS-FL
           END-IF.                          
           IF LINK-XFER-FL <= SPACES                                    
               MOVE 'N' TO LINK-XFER-FL
           END-IF.                                
           IF LINK-TURNOFF-REASON-CD > ' ' OR                           
              LINK-TURNOFF-COMMENTS > ' '                               
                  MOVE 'Y' TO LINK-TURNOFF-REQ-FL                       
           ELSE                                                         
               MOVE 'N' TO LINK-TURNOFF-REQ-FL
           END-IF.                         
                                                                        
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE '0000000000000' TO LINK-SERV-ORDER-NO
           END-IF.              
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR.            
           MOVE WS-SERV-ORDER-NO-NUM TO WS-HOLD-SERV-ORDER-NO.          
                                                                        
           IF LINK-CURR-ACCOUNT-NO NOT NUMERIC                          
               MOVE '0000000000000' TO LINK-CURR-ACCOUNT-NO
           END-IF.            
           MOVE LINK-CURR-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.             
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                      
                                     CT-ACCOUNT-NO                      
                                     BE-ACCOUNT-NO.                     
                                                                        
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE '0000000000' TO LINK-PREMISE-NO
           END-IF.                    
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO                      
                                     VO-PREMISE-NO                      
                                     LA-PREMISE-NO.                     
                                                                        
           IF LINK-SO-EST-LABOR-HR NOT NUMERIC                          
               MOVE ZEROES TO LINK-SO-EST-LABOR-HR
           END-IF.                     
           MOVE LINK-SO-EST-LABOR-HR TO WS-SO-EST-LABOR-HR.             
           MOVE WS-SO-EST-LABOR-HR(1:5) TO WS-SO-EST-LABOR-HR-DEC(1:5). 
           MOVE WS-SO-EST-LABOR-HR(6:1) TO WS-SO-EST-LABOR-HR-DEC(6:1). 
                                                                        
           IF LINK-XFER-ACCOUNT-NO NOT NUMERIC                          
               MOVE '0000000000000' TO LINK-XFER-ACCOUNT-NO
           END-IF.            
           MOVE LINK-XFER-ACCOUNT-NO TO WS-ACCOUNT-XFER-CHAR.           
                                                                        
           MOVE LINK-SCHEDULED-DT(1:10) TO WS-LINK-SCHEDULED-DT.        
A05189     IF LINK-WORK-AREA(1:4) = 'AROP'                              
A05189         MOVE 'Y' TO WS-AROP-FL                                   
A05189     ELSE                                                         
A05189         MOVE 'N' TO WS-AROP-FL
           END-IF.                                  
                                                                        
           PERFORM 7180-GET-RESP-AREA THRU 7180-EXIT.                   
           MOVE 'N' TO WS-EXISTING-ORDER-FL.                            
           MOVE 0 TO WS-COUNT-ORDERS                                    
                     RS-STATUS-CODE.                                    
           PERFORM 7000-COUNT-ORDERS THRU 7000-EXIT.                    
           IF WS-COUNT-ORDERS > 1                                       
               MOVE +150 TO RS-STATUS-CODE
           END-IF.                             
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7010-SELECT-ORDER THRU 7010-EXIT                 
               IF LINK-SERV-ORDER-NO = ZEROES                           
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
                   MOVE WS-SERV-ORDER-NO-CHAR TO LINK-SERV-ORDER-NO
               END-IF
           END-IF.    
           PERFORM 7100-SELECT-PREMISE THRU 7100-EXIT                   
           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT                   
                                                                        
           IF LINK-ADD-FINAL-ADDR-FL = 'S'                              
               IF WS-BILL-ADDRESS-EXISTS = 'N'                          
                   MOVE 'N' TO LINK-ADD-FINAL-ADDR-FL                   
               ELSE                                                     
                   PERFORM 5200-FORMAT-SERVICE-ADDRESS THRU 5200-EXIT
               END-IF
           END-IF.  
           IF LINK-ADD-FINAL-ADDR-FL = 'Y' AND                          
              LINK-ADDRESS-FORMAT = 'A' AND                             
              AT-ADDRESS-FORMAT = 'A' AND                               
              WS-BILL-ADDRESS-EXISTS = 'Y'                              
                  PERFORM 5300-COMPARE-ADDRESSES THRU 5300-EXIT
           END-IF.        
                                                                        
           IF RS-STATUS-CODE = 0 AND                                    
              LINK-UPDATE-ORDER-FL = 'Y'                                
                  PERFORM 7800-EXISTING-ORDER-EDITS THRU 7800-EXIT      
                  IF RS-STATUS-CODE = 0                                 
                      PERFORM 3300-UPDATE-EXISTING-ORDER THRU 3300-EXIT
                  END-IF
           END-IF.
                                                                        
           IF RS-STATUS-CODE = 0 AND                                    
              LINK-UPDATE-ORDER-FL = 'N'                                
                  PERFORM 3100-CALL-CSR02210 THRU 3100-EXIT             
                  PERFORM 4000-ADD-ORDER THRU 4000-EXIT                 
P00817*           IF WS-LIGHTING-CONTRACT-FL = 'Y'                              
P00817*               PERFORM 8100-INSERT-LIGHT-RQMT THRU 8100-EXIT             
P00817*               MOVE '1' TO ROUTING-CATEGORY-4675                         
P00817*               IF WS-BUILDER-LIGHTING-FL = 'Y'                           
P00817*                   MOVE 461 TO CATEGORY-ID-4675                          
P00817*               ELSE                                                      
P00817*                   MOVE 28 TO CATEGORY-ID-4675                           
P00817*               END-IF                                                    
P00817*               MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT               
P00817*               MOVE 115 TO COMMENTS-4675-LEN                             
P00817*               PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT                 
P00817*           END-IF                                                        
                  IF LINK-ADD-FINAL-ADDR-FL = 'Y'                       
                      PERFORM 3400-CALL-CSR00148 THRU 3400-EXIT         
                      MOVE '046' TO VW-PANEL-NO                         
                      PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT      
                  END-IF                                                
                  IF WS-ACTIVE-CONTRACT-FL = 'Y' AND                    
                     PR-COMPANY-NO = '26'                               
ACT233                   MOVE '4' TO ROUTING-CATEGORY-4675              
ACT233                   MOVE 304 TO CATEGORY-ID-4675                   
ACT233                   MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT    
ACT233                   MOVE 105 TO COMMENTS-4675-LEN                  
ACT233                   PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT      
                  END-IF                                                
                  PERFORM 8300-UPDATE-PREMISE THRU 8300-EXIT            
A05189            IF WS-AROP-FL = 'Y'                                   
A05189                PERFORM 5065-AROP-REMARKS THRU 5065-EXIT          
A05189            END-IF                                                
                  IF LINK-MTR-ACCESS-FL = 'Y'                           
                      PERFORM 5070-SPECIAL-INST THRU 5070-EXIT          
                  END-IF                                                
                  IF LINK-TURNOFF-REQ-FL = 'Y'                          
                      PERFORM 8800-INSERT-TURNOFF THRU 8800-EXIT        
                  END-IF                                                
                  IF LINK-XFER-FL = 'Y'                                 
                      PERFORM 5000-XFER-PROCESSING THRU 5000-EXIT       
                  END-IF                                                
                  PERFORM 5090-CALL-CSR02517 THRU 5090-EXIT             
                  PERFORM 5100-SET-FLAGS THRU 5100-EXIT
           END-IF.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF RS-STATUS-CODE NOT = 0                                    
               CONTINUE                                                 
           ELSE                                                         
               IF LINK-XFER-FL = 'Y'                                    
                   PERFORM 6800-UPDATE-WEB-EVENT THRU 6800-EXIT         
               ELSE                                                     
                   PERFORM 6700-WRITE-WEB-EVENT THRU 6700-EXIT
               END-IF
           END-IF.         
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                 
            MOVE RS-STATUS-CODE       TO S-STATUS-CODE.                 
            MOVE RS-SERV-ORDER-NO     TO S-SERV-ORDER-NO.               
            MOVE RS-CONTRACT-FL       TO S-CONTRACT-FL.                 
            MOVE RS-BANK-DRAFT-FL     TO S-BANK-DRAFT-FL.               
            MOVE RS-EPP-FL            TO S-EPP-FL.                      
            MOVE RS-DPP-FL            TO S-DPP-FL.                      
            MOVE RS-DFA-FL            TO S-DFA-FL.                      
            MOVE RS-MED-CERT-FL       TO S-MED-CERT-FL.                 
            MOVE RS-LITE-CONTRACT-FL  TO S-LITE-CONTRACT-FL.            
P00718      MOVE RS-WORK-DISTRICT     TO S-WORK-DISTRICT.               
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ****************************************************************          
      **  CALL CSR02210 TO GET DATA FOR THE ACCOUNT.  DATA WILL BE  **          
      **  LOADED INTO THE T3-CSR02210 WORKING STORAGE TABLE.        **          
      ****************************************************************          
                                                                        
       3100-CALL-CSR02210.                                              
                                                                        
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2210.                
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2210.                     
           MOVE PR-COMPANY-NO TO COMPANY-NO-2210.                       
           MOVE 'N' TO MKTG-ORDER-2210.                                 
           MOVE 'Y' TO RETURN-UTILS-2210.                               
           MOVE 'N' TO RETURN-DISC-BAL-2210.                            
           MOVE ' ' TO ORDER-REASON-2210.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02210                                             
      *           (:ACCOUNT-NO-2210,                                    
      *            :PREMISE-NO-2210,                                    
      *            :COMPANY-NO-2210,                                    
      *            :MKTG-ORDER-2210,                                    
      *            :RETURN-UTILS-2210,                                  
      *            :RETURN-DISC-BAL-2210,                               
      *            :ORDER-REASON-2210)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2210 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02210'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-CURR-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2210)                                                
      *       WITH PROCEDURE CSR02210                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2210 CURSOR FOR RESULT SET        
      *       :LOC2210                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           SET T3-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2210 INTO                          
                   :RETURN-CODE-2210,                                   
                   :ACTIVE-PARA-2210,                                   
                   :TABLE-NAME-2210,                                    
                   :TABLE-ID-2210,                                      
                   :UT-CODE-UTIL-TY-2210,                               
                   :UT-IC-NO-2210,                                      
                   :UT-READ-ROUTE-2210,                                 
                   :UT-RATE-PLAN-NO-2210,                               
                   :UT-RATE-DESC-2210,                                  
                   :UT-CODE-REV-CLA-2210,                               
                   :UT-READ-CYCLE-2210,                                 
                   :UT-CODE-SIC-NO-2210,                                
                   :MN-METER-NO-2210,                                   
                   :MN-MTR-REF-NO-2210,                                 
                   :MN-CODE-TIME-PE-2210,                               
                   :MN-LAST-READ-VA-2210,                               
                   :MN-CD-STUS-RS-2210,                                 
                   :MN-CODE-USAGE-T-2210,                               
                   :MN-CODE-USAGE-I-2210,                               
                   :MN-CODE-USAGE-S-2210,                               
                   :MN-CODE-METER-S-2210,                               
                   :MN-METER-SUPPLY-2210,                               
                   :MN-CODE-METER-L-2210,                               
                   :MN-METER-LOC-DE-2210,                               
                   :MN-METER-IND-2210,                                  
                   :MN-CONSTANT-2210,                                   
                   :MN-NO-DIALS-2210,                                   
                   :MN-DIST-NODE-PO-2210,                               
                   :MN-POINT-ID-2210,                                   
                   :MN-SEAL-CODE-ID-2210,                               
                   :MN-HEX-LOCATION-2210,                               
                   :MN-INSULATED-IN-2210,                               
                   :MN-LOCK-TYPE-ID-2210,                               
                   :MN-DELIVERY-LEV-2210,                               
                   :MN-UTILITY-SOUR-2210,                               
                   :MN-IDR-RECIPIEN-2210,                               
                   :MN-PROGRAM-ID-2210,                                 
                   :MN-MTR-READ-SO-2210,                                
                   :RG-CODE-REG-ST-2210,                                
                   :RG-CODE-STATUS-2210,                                
                   :RG-CODE-TIME-P-2210,                                
                   :RG-CODE-USAGE-2210,                                 
                   :RG-CD-USG-SRC-2210,                                 
                   :RG-CD-USG-TYP-2210,                                 
                   :RG-LAST-READD-2210,                                 
                   :RG-LST-READVL-2210,                                 
                   :RG-REG-ID-NO-2210,                                  
                   :CP-NO-UNITS-2210,                                   
                   :CP-CODE-PLAN-2210,                                  
                   :CP-CD-STATRS-2210,                                  
                   :CP-CD-SVC-TYP-2210,                                 
                   :CP-MTLY-AMT-FX-2210,                                
                   :CP-RT-ITEM-CD-2210,                                 
                   :CP-LIGHT-NO-2210,                                   
                   :CP-POLE-NO-2210,                                    
                   :CP-DIST-NO-2210,                                    
                   :CP-USAGE-FIXED-2210,                                
                   :CP-ITEM-SEQ-NO-2210,                                
                   :CP-EQUIP-ID-2210,                                   
                   :PREM-DIR-IND-2210,                                  
                   :SUBDIV-LIGHT-2210,                                  
                   :ACCT-TYPE-2210,                                     
                   :CD-RNTL-PROP-2210,                                  
                   :LL-CUSTOMER-NO-2210,                                
                   :REV-DIST-CD-2210,                                   
                   :DISC-BAL-2210,                                      
                   :OUT-ACCOUNT-NO-2210,                                
                   :ACCT-STATUS-2210,                                   
                   :ROW-NO-2210,                                        
                   :DEPOSIT-AMT-2210,                                   
                   :SEC-TOT-AMT-2210,                                   
                   :CUR-MTH-ARR-CD-2210,                                
                   :CREDIT-GROUP-2210,                                  
                   :CURRENT-ACCOUNT-2210,                               
                   :DATE-BNKRPT-FL-2210,                                
                   :FILED-CASE-NO-2210,                                 
                   :DL-NO-2210,                                         
                   :DL-STATE-2210,                                      
                   :SSN-2210,                                           
                   :PRIOR-ACCT-STAT-2210,                               
                   :READ-CYCLE-2210,                                    
                   :SERV-STRT-DT-2210,                                  
                   :DEP-INTST-RT-2210,                                  
                   :CP-DT-PLN-ST-2210,                                  
                   :ACTIVE-CONTRACT-2210,                               
                   :SECURED-RATE-FL-2210,                               
                   :MN-CODE-MTR-RD-2210,                                
                   :MN-MTR-PRESS-2210,                                  
P00390             :ERROR-MSG-NO-02-2210,                               
P00390             :ERROR-MSG-NO-A4-2210                                
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-2210 NOT = 0                        
                         MOVE RETURN-CODE-2210  TO RS-STATUS-CODE       
                                                  WS-ACTIVE-RETURN-CODE 
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR02210'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE LINK-CURR-ACCOUNT-NO TO HOSTVAR-ELEMENT-1 
                         MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-2      
                         MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-2    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
                     PERFORM 3110-LOAD-CSR02210-TABLE THRU 3110-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02210'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-CURR-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD ACCOUNT DATA INTO THE T3-CSR02210 WORKING STORAGE    **          
      **  TABLE. THE ROWCOUNT FOR THIS TABLE IS IN WS-T3-ROWCOUNT.  **          
      ****************************************************************          
                                                                        
       3110-LOAD-CSR02210-TABLE.                                        
                                                                        
           MOVE TABLE-ID-2210 TO T3-TABLE-ID (T3-INDEX).                
           MOVE MN-CODE-METER-S-2210 TO T3-MN-CODE-METER-S (T3-INDEX).  
           MOVE UT-CODE-UTIL-TY-2210 TO T3-UT-CODE-UTIL-TYPE (T3-INDEX).
           MOVE UT-IC-NO-2210 TO T3-UT-IC-NO (T3-INDEX).                
           MOVE UT-READ-ROUTE-2210 TO T3-UT-READ-ROUTE (T3-INDEX).      
           MOVE UT-RATE-PLAN-NO-2210 TO T3-UT-RATE-PLAN-NO (T3-INDEX).  
           MOVE UT-RATE-DESC-2210 TO T3-UT-RATE-DESC (T3-INDEX).        
           MOVE UT-CODE-REV-CLA-2210 TO                                 
                T3-UT-CODE-REV-CLASS (T3-INDEX).                        
           MOVE UT-READ-CYCLE-2210 TO T3-UT-READ-CYCLE (T3-INDEX).      
           MOVE UT-CODE-SIC-NO-2210 TO T3-UT-CODE-SIC-NO (T3-INDEX).    
           MOVE MN-METER-NO-2210 TO T3-MN-METER-NO (T3-INDEX).          
           MOVE MN-MTR-REF-NO-2210 TO T3-MN-MTR-REF-NO (T3-INDEX).      
           MOVE MN-CODE-TIME-PE-2210 TO T3-MN-CODE-TIME-PER (T3-INDEX). 
           MOVE MN-LAST-READ-VA-2210 TO T3-MN-LAST-READ-VAL (T3-INDEX). 
           MOVE MN-CD-STUS-RS-2210 TO T3-MN-CD-STAT-REAS (T3-INDEX).    
           MOVE MN-CODE-USAGE-T-2210 TO T3-MN-CODE-USAGE-T (T3-INDEX).  
           MOVE MN-CODE-USAGE-I-2210 TO T3-MN-CODE-USAGE-I (T3-INDEX).  
           MOVE MN-CODE-USAGE-S-2210 TO T3-MN-CODE-USAGE-S (T3-INDEX).  
           MOVE MN-CODE-METER-S-2210 TO T3-MN-CODE-METER-S (T3-INDEX).  
           MOVE MN-METER-SUPPLY-2210 TO T3-MN-METER-SUPPLY (T3-INDEX).  
           MOVE MN-CODE-METER-L-2210 TO                                 
                T3-MN-CODE-METER-LOC (T3-INDEX).                        
           MOVE MN-METER-LOC-DE-2210 TO                                 
                T3-MN-METER-LOC-DESC (T3-INDEX).                        
           MOVE MN-METER-IND-2210 TO T3-MN-METER-IND (T3-INDEX).        
           MOVE MN-CONSTANT-2210 TO T3-MN-CONSTANT (T3-INDEX).          
           MOVE MN-NO-DIALS-2210 TO T3-MN-NO-DIALS (T3-INDEX).          
           MOVE MN-DIST-NODE-PO-2210 TO                                 
                T3-MN-DIST-NODE-PO (T3-INDEX).                          
           MOVE MN-POINT-ID-2210 TO T3-MN-POINT-ID (T3-INDEX).          
           MOVE MN-SEAL-CODE-ID-2210 TO T3-MN-SEAL-CODE-ID (T3-INDEX).  
           MOVE MN-HEX-LOCATION-2210 TO T3-MN-HEX-LOCATION (T3-INDEX).  
           MOVE MN-INSULATED-IN-2210 TO T3-MN-INSULATED-IND (T3-INDEX). 
           MOVE MN-LOCK-TYPE-ID-2210 TO T3-MN-LOCK-TYPE-ID (T3-INDEX).  
           MOVE MN-DELIVERY-LEV-2210 TO T3-MN-DELIVERY-LEV (T3-INDEX).  
           MOVE MN-UTILITY-SOUR-2210 TO                                 
                T3-MN-UTILITY-SOURCE (T3-INDEX).                        
           MOVE MN-IDR-RECIPIEN-2210 TO T3-MN-IDR-RECIPIENT (T3-INDEX). 
           MOVE MN-PROGRAM-ID-2210 TO T3-MN-PROGRAM-ID (T3-INDEX).      
           MOVE MN-MTR-READ-SO-2210 TO                                  
                T3-MN-MTR-READ-SOURCE (T3-INDEX).                       
           MOVE RG-LAST-READD-2210 TO T3-RG-LAST-READD (T3-INDEX).      
           MOVE RG-REG-ID-NO-2210 TO T3-RG-REG-ID-NO (T3-INDEX).        
           MOVE CP-NO-UNITS-2210 TO T3-CP-NO-UNITS (T3-INDEX).          
           MOVE CP-CODE-PLAN-2210 TO T3-CP-CODE-PLAN (T3-INDEX).        
           MOVE CP-CD-STATRS-2210 TO T3-CP-CD-STAT-REAS (T3-INDEX).     
           MOVE CP-CD-SVC-TYP-2210 TO T3-CP-CD-SVC-TYPE (T3-INDEX).     
           MOVE CP-MTLY-AMT-FX-2210 TO T3-CP-MTHLY-AMT (T3-INDEX).      
           MOVE CP-RT-ITEM-CD-2210 TO T3-CP-RT-ITEM-CD (T3-INDEX).      
           MOVE CP-LIGHT-NO-2210 TO T3-CP-LIGHT-NO (T3-INDEX).          
           MOVE CP-POLE-NO-2210 TO T3-CP-POLE-NO (T3-INDEX).            
           MOVE CP-DIST-NO-2210 TO T3-CP-DIST-NO (T3-INDEX).            
           MOVE CP-USAGE-FIXED-2210 TO T3-CP-USAGE-FIXED (T3-INDEX).    
           MOVE CP-ITEM-SEQ-NO-2210 TO T3-CP-ITEM-SEQ-NO (T3-INDEX).    
           MOVE CP-EQUIP-ID-2210 TO T3-CP-EQUIP-ID (T3-INDEX).          
           MOVE PREM-DIR-IND-2210 TO T3-PREM-DIR-IND (T3-INDEX).        
           MOVE SUBDIV-LIGHT-2210 TO T3-SUBDIV-LIGHT (T3-INDEX).        
           MOVE ACCT-TYPE-2210 TO T3-ACCT-TYPE-CODE (T3-INDEX).         
           MOVE CD-RNTL-PROP-2210 TO T3-CD-RENTAL-PROP (T3-INDEX).      
           MOVE LL-CUSTOMER-NO-2210 TO T3-LL-CUSTOMER-NO (T3-INDEX).    
           MOVE REV-DIST-CD-2210 TO T3-REV-DISTRICT-CD (T3-INDEX).      
           MOVE DISC-BAL-2210 TO T3-DISC-BAL (T3-INDEX).                
           MOVE OUT-ACCOUNT-NO-2210 TO T3-OUT-ACCOUNT-NO (T3-INDEX).    
           MOVE ACCT-STATUS-2210 TO T3-ACCT-STATUS (T3-INDEX).          
           MOVE ROW-NO-2210 TO T3-ROW-NO (T3-INDEX).                    
           MOVE DEPOSIT-AMT-2210 TO T3-DEPOSIT-AMT (T3-INDEX).          
           MOVE SEC-TOT-AMT-2210 TO T3-SEC-TOT-AMT (T3-INDEX).          
           MOVE CUR-MTH-ARR-CD-2210 TO T3-CUR-MTH-ARR-CD (T3-INDEX).    
           MOVE CREDIT-GROUP-2210 TO T3-CREDIT-GROUP (T3-INDEX).        
           MOVE CURRENT-ACCOUNT-2210 TO T3-CURRENT-ACCOUNT (T3-INDEX).  
           MOVE DATE-BNKRPT-FL-2210 TO T3-DATE-BANKRUPT (T3-INDEX).     
           MOVE FILED-CASE-NO-2210 TO T3-FILED-CASE-NO (T3-INDEX).      
           MOVE DL-NO-2210 TO T3-DL-NO (T3-INDEX).                      
           MOVE DL-STATE-2210 TO T3-DL-STATE (T3-INDEX).                
           MOVE SSN-2210 TO T3-SSN (T3-INDEX).                          
           MOVE PRIOR-ACCT-STAT-2210 TO T3-PRIOR-ACCT-STAT (T3-INDEX).  
           MOVE READ-CYCLE-2210 TO T3-READ-CYCLE (T3-INDEX).            
           MOVE SERV-STRT-DT-2210 TO T3-SERV-STRT-DT (T3-INDEX).        
           MOVE DEP-INTST-RT-2210 TO T3-DEP-INTST-RT (T3-INDEX).        
           MOVE CP-DT-PLN-ST-2210 TO T3-CP-DT-PLAN-ST (T3-INDEX).       
           MOVE ACTIVE-CONTRACT-2210 TO T3-ACTIVE-CONTRACT (T3-INDEX).  
           IF ACTIVE-CONTRACT-2210 = 'Y'                                
               MOVE 'Y' TO WS-ACTIVE-CONTRACT-FL
           END-IF.                       
           MOVE SECURED-RATE-FL-2210 TO T3-SECURED-RATE-FL (T3-INDEX).  
           MOVE MN-CODE-MTR-RD-2210 TO T3-MN-CODE-MTR-RD (T3-INDEX).    
           MOVE MN-MTR-PRESS-2210 TO T3-MN-MTR-PRESS (T3-INDEX).        
           ADD 1 TO WS-T3-ROWCOUNT.                                     
           SET T3-INDEX UP BY 1.                                        
                                                                        
       3110-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  IF A CC ORDER EXISTS, ONLY ORDER REASON AND FINAL BILL    **          
      **  ADDRESS CAN BE ENTERED.  AUDIT ROWS ARE WRITTEN FOR BOTH. **          
      ****************************************************************          
                                                                        
       3300-UPDATE-EXISTING-ORDER.                                      
                                                                        
           MOVE LINK-SERV-ORDER-NO TO RS-SERV-ORDER-NO.                 
           IF VO-ORDER-REASON > SPACES                                  
               PERFORM 8600-UPDATE-ORDER-REASON THRU 8600-EXIT          
               MOVE '016' TO VW-PANEL-NO                                
               PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT
           END-IF.            
           IF LINK-ADD-FINAL-ADDR-FL = 'Y'                              
               PERFORM 3400-CALL-CSR00148 THRU 3400-EXIT                
               MOVE '046' TO VW-PANEL-NO                                
               PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT
           END-IF.            
           IF LINK-XFER-FL = 'Y'                                        
               PERFORM 5000-XFER-PROCESSING THRU 5000-EXIT
           END-IF.             
           PERFORM 5090-CALL-CSR02517 THRU 5090-EXIT.                   
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CALL CSR00148 TO ADD A FINAL BILL ADDRESS.                **          
      ****************************************************************          
                                                                        
       3400-CALL-CSR00148.                                              
                                                                        
           INITIALIZE CSR00148-CALL-DATA.                               
           MOVE RS-SERV-ORDER-NO TO SERV-ORDER-NO-0148.                 
           MOVE 'N' TO CREDIT-LETTER-IND-0148                           
                       SEND-TO-LOCOFF-IND-0148.                         
           IF LINK-ADDRESS-FORMAT = 'A'                                 
               MOVE 'A' TO ADDRESS-FORMAT-0148                          
               MOVE LINK-HOUSE-NO TO HOUSE-NO-0148                      
               MOVE LINK-ADDR-PREFIX-1 TO ADDR-PREFIX-1-0148            
               MOVE LINK-ADDR-PREFIX-2 TO ADDR-PREFIX-2-0148            
               MOVE LINK-STREET-NAME TO STREET-NAME-0148                
               MOVE LINK-STREET-SUFFIX TO STREET-SUFFIX-0148            
               MOVE LINK-STREET-LOC-1 TO STREET-LOC-1-0148              
               MOVE LINK-STREET-LOC-2 TO STREET-LOC-2-0148              
               MOVE LINK-ZIP-CODE TO ZIP-CODE-0148                      
               MOVE LINK-ZIP-CODE-PLUS-4 TO ZIP-CODE-PLUS-FOUR-0148     
               MOVE SPACES TO ADDRESS-OVERFLOW-0148                     
                              CARRIER-ROUTE-0148                        
               PERFORM 7400-GET-TOKEN THRU 7400-EXIT                    
               MOVE A4-ZIP-CODE-TOKEN TO ZIP-CODE-TOKEN-0148            
               MOVE LINK-ADDR-SUFFIX TO ADDR-SUFFIX-0148                
           ELSE                                                         
               MOVE 'B' TO ADDRESS-FORMAT-0148                          
               MOVE LINK-ADDR-STREET TO ADDR-ST-0148                    
               MOVE LINK-ADDR-CITY-STATE TO FINAL-BILL-CY-ST-0148       
               MOVE LINK-FR-ZIP-CODE TO ADDR-ZIP-CODE-0148              
               MOVE LINK-COUNTRY TO ADDR-COUNTRY-0148                   
               MOVE LINK-ADDRESS-OVERFLOW TO FINAL-BILL-OVFL-0148
           END-IF.      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00148                                             
      *           (:SERV-ORDER-NO-0148,                                 
      *            :ADDRESS-FORMAT-0148,                                
      *            :CREDIT-LETTER-IND-0148,                             
      *            :SEND-TO-LOCOFF-IND-0148,                            
      *            :HOUSE-NO-0148,                                      
      *            :ADDR-PREFIX-1-0148,                                 
      *            :ADDR-PREFIX-2-0148,                                 
      *            :STREET-NAME-0148,                                   
      *            :STREET-SUFFIX-0148,                                 
      *            :ADDR-SUFFIX-0148,                                   
      *            :STREET-LOC-1-0148,                                  
      *            :STREET-LOC-2-0148,                                  
      *            :ZIP-CODE-0148,                                      
      *            :ZIP-CODE-PLUS-FOUR-0148,                            
      *            :ZIP-CODE-TOKEN-0148,                                
      *            :ADDRESS-OVERFLOW-0148,                              
      *            :ADDR-ST-0148,                                       
      *            :FINAL-BILL-CY-ST-0148,                              
      *            :ADDR-ZIP-CODE-0148,                                 
      *            :ADDR-COUNTRY-0148,                                  
      *            :FINAL-BILL-OVFL-0148,                               
      *            :CARRIER-ROUTE-0148)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0148
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0148
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0148 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00148'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0148    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0148)                                                
      *       WITH PROCEDURE CSR00148                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0148 CURSOR FOR RESULT SET        
      *       :LOC0148                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0148 INTO                            
                 :RETURN-CODE-0148                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0148 NOT = 0                          
                       MOVE RETURN-CODE-0148  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3400'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00148'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0148 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3400'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00148'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0148    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A01648     PERFORM 8850-UPDATE-CDP THRU 8850-EXIT.                      
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET ANY APPLIANCES AT THE PREMISE.  LOAD DATA FOR THE     **          
      **  ORDER.                                                    **          
      ****************************************************************          
                                                                        
       4000-ADD-ORDER.                                                  
                                                                        
           PERFORM 4170-GET-APPLIANCES THRU 4170-EXIT.                  
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-0073.                     
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-PRIOR-0073           
                                        ACCOUNT-NO-0073.                
           MOVE ZEROES TO SERV-ORDER-NO-0073.                           
           MOVE 'OFF01' TO ORDER-TYPE-CD-0073.                          
           MOVE PR-LOCAL-OFFICE TO LOCAL-OFFICE-0073.                   
           MOVE LINK-PHONE-NO TO PHONE-NO-0073.                         
           MOVE LINK-ORDER-PLACED-BY TO ORDER-PLACED-BY-0073.           
           MOVE LINK-SCHEDULED-DT TO WANTED-BY-DATE-0073                
                                     ASSIGNED-DATETIME-0073(1:10).      
           MOVE '-00.00.00.000000' TO ASSIGNED-DATETIME-0073(11:16).    
           MOVE LINK-ORDER-RECVED-BY TO ORDER-RECVED-BY-0073.           
           MOVE 'N' TO BACK-DATED-IND-0073.                             
           MOVE PF-RESP-AREA-ID TO RESP-AREA-ID-0073.                   
           MOVE SPACES TO BREAKERS-OFF-0073                             
                          ORDER-REASON-0073                             
                          PHONE-NO-EXT-0073                             
                          INIT-BY-CNTRCT-0073                           
                          CALL-BEFORE-MIN-0073                          
                          HOLD-RELEASE-0073                             
                          RLSE-IND-0073                                 
                          RLSE-DATE-0073                                
                          RLSE-NO-0073                                  
                          NOTIFY-CUST-IND-0073                          
                          NOTIFY-CSR-IND-0073.                          
A03140     MOVE DEPOSIT-AMT-2210 TO DEPOSIT-AMT-0073                    
           MOVE 0.0 TO STD-CHG-AMT-0073.                                
           MOVE LINK-WORK-AREA TO WORK-AREA-ID-0073.                    
P00718     MOVE LINK-BUSINESS-UNIT TO BUSINESS-UNIT-0073.               
                                                                        
P00196     MOVE 'NORMAL' TO OY-PRIORITY-DESC.                           
P00196     PERFORM 7810-ORDER-PRIORITY THRU 7810-EXIT.                  
P00196     MOVE OY-PRIORITY-CD TO ORDER-PRIORITY-0073.                  
                                                                        
A05189     IF WS-AROP-FL = 'Y'                                          
A05189         MOVE 'H' TO ORDER-STATE-CD-0073                          
A05189     ELSE                                                         
               MOVE 'A' TO ORDER-STATE-CD-0073
           END-IF.                         
                                                                        
           MOVE +1 TO WS-II-CTR.                                        
           MOVE 0 TO WS-II-MCTR.                                        
           MOVE 'Y' TO WS-MORE-ROWS.                                    
                                                                        
           PERFORM 4020-METER-LOOP THRU 4020-EXIT UNTIL                 
               WS-MORE-ROWS = 'N'.                                      
P00718     PERFORM 4065-GET-WORK-DISTRICT THRU 4065-EXIT.               
                                                                        
           MOVE 0 TO ROW-NO-0073.                                       
           MOVE 'N' TO EQUIPMENT-PRESEN-0073                            
                       UTIL-ENV-PRESEN-0073                             
                       ORDER-INST-PRESEN-0073.                          
           PERFORM 4200-CALL-CSR00073 THRU 4200-EXIT.                   
                                                                        
A04670     PERFORM 8450-UPDATE-SOURCE-SYSTEM THRU 8450-EXIT.            
                                                                        
           MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
           MOVE ASSIGNED-DATETIME-0073 TO VO-ASSIGNED-DATETIME          
                                          VO-WANTED-BY-DATETIME.        
           MOVE ORDER-STATE-CD-0073 TO VO-ORDER-STATE-CD.               
           MOVE ORDER-TYPE-CD-0073 TO VO-ORDER-TYPE-CD.                 
           MOVE '10' TO VO-SERV-ORDER-STATUS.                           
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOOP THROUGH SNAPSHOT DATA TO LOAD WORK TYPE AND TABLE    **          
      **  ID.  LOAD DATA FOR ADD OF ORDER.  CALL CSR00073 IF ANY    **          
      **  CONDITION IS SET.                                         **          
      ****************************************************************          
                                                                        
       4020-METER-LOOP.                                                 
                                                                        
           IF WS-II-CTR <= WS-T3-ROWCOUNT                               
               SET T3-INDEX TO WS-II-CTR                                
               IF T3-TABLE-ID (T3-INDEX) = 'MN'                         
                   ADD 1 TO WS-II-MCTR                                  
               END-IF                                                   
               MOVE T3-TABLE-ID (T3-INDEX) TO TABLE-ID-0073             
           END-IF.                                                      
                                                                        
           PERFORM 4050-LOAD-NEW-ORDER-INFO THRU 4050-EXIT.             
                                                                        
           MOVE WS-II-CTR TO ROW-NO-0073.                               
           IF WS-UTIL-ENV-EXISTS = 'Y' OR                               
              WS-ORDER-INST-EXISTS = 'Y' OR                             
              WS-EQUIPMENT-EXISTS = 'Y'                                 
                  PERFORM 4200-CALL-CSR00073 THRU 4200-EXIT             
                  MOVE NEW-SERV-ORDER-NO-0073 TO WS-SERV-ORDER-NO-NUM   
                  MOVE WS-SERV-ORDER-NO-CHAR TO RS-SERV-ORDER-NO        
                                                SERV-ORDER-NO-0073      
              ELSE                                                      
                  MOVE 'N' TO WS-MORE-ROWS
           END-IF.                             
           ADD +1 TO WS-II-CTR.                                         
                                                                        
       4020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD DATA TO ADD A NEW ORDER.                             **          
      ****************************************************************          
                                                                        
       4050-LOAD-NEW-ORDER-INFO.                                        
                                                                        
           MOVE 'N' TO ORDER-INST-PRESEN-0073                           
                       INCLUDE-INST-0073                                
                       UTIL-ENV-PRESEN-0073                             
                       EQUIPMENT-PRESEN-0073.                           
                                                                        
           IF WS-II-CTR <= WS-T3-ROWCOUNT                               
               PERFORM 4055-LOAD-SNAPSHOT-DATA THRU 4055-EXIT           
           ELSE                                                         
               MOVE 'N' TO WS-UTIL-ENV-EXISTS                           
                           UTIL-ENV-PRESEN-0073
           END-IF.                        
                                                                        
           IF WS-II-CTR <= WS-T5-ROWCOUNT                               
               PERFORM 4060-LOAD-APPLIANCE-DATA THRU 4060-EXIT          
           ELSE                                                         
               MOVE 'N' TO EQUIPMENT-PRESEN-0073                        
                           WS-EQUIPMENT-EXISTS
           END-IF.                         
                                                                        
           MOVE 'N' TO VERIFY-RATE-0073.                                
           MOVE 'Y' TO NEW-ORDER-0073.                                  
           MOVE '015' TO PANEL-NO-0073.                                 
           MOVE PR-REV-DISTRICT-CD TO REV-DIST-CD-0073.                 
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-0073.                   
           MOVE WS-SO-EST-LABOR-HR-DEC TO SO-EST-LABOR-HR-0073.         
           MOVE 'N' TO REORDER-FLAG-0073.                               
           MOVE PR-COMPANY-NO TO COMPANY-NO-0073.                       
           MOVE 'A' TO CODE-KEY-FIELD-0073.                             
           MOVE 0 TO RCC-CODE-0073.                                     
           MOVE SPACES TO DATE-FORECAST-DNP-0073                        
                          CUST-CNT-ID-0073                              
                          WAIVER-TYPE-CD-0073                           
                          WORK-PERIOD-CD-0073                           
                          WAIVER-TYPE-CD-0073.                          
           MOVE 0.0 TO AMT-DNP-AT-BILLING-0073.                         
           MOVE 'P' TO PER-TEMP-IND-0073.                               
           MOVE 'N' TO RLSE-IND-0073.                                   
           MOVE WS-II-MCTR TO SO-INST-SEQ-NO-0073.                      
                                                                        
       4050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD SNAPSHOT DATA TO ADD A NEW ORDER.  DETERMINE IF A    **          
      **  LIGHTING CONTRACT REQUIREMENT AND WQ ARE NEEDED.          **          
      ****************************************************************          
                                                                        
       4055-LOAD-SNAPSHOT-DATA.                                         
                                                                        
           SET T3-INDEX TO WS-II-CTR.                                   
                                                                        
           IF T3-TABLE-ID (T3-INDEX) = 'CP'                             
               MOVE T3-CP-DT-PLAN-ST (T3-INDEX) TO WS-PLAN-START-DATE   
               EXEC SQL                                                 
                   SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-LINK-SCHEDULED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LINK-SCHEDULED-DT
              ) <> 0) OR (LEN(:WS-LINK-SCHEDULED-DT
              ) <> 10), CIS.CHAR2DATE(:WS-LINK-SCHEDULED-DT
              ), CONVERT(DATE, :WS-LINK-SCHEDULED-DT) )) -          
                          CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                    :WS-PLAN-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PLAN-START-DATE
              ) <> 0) OR (LEN(:WS-PLAN-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PLAN-START-DATE
              ), CONVERT(DATE, :WS-PLAN-START-DATE) ))
            INTO
              :WS-NO-OF-DAYS                                
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*        EXEC SQL                                                         
MFA-TR*            VALUES (DAYS(DATE(:WS-LINK-SCHEDULED-DT)) -                  
MFA-TR*                   DAYS(DATE(:WS-PLAN-START-DATE)))                      
MFA-TR*              INTO :WS-NO-OF-DAYS                                        
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               IF T3-ACCT-STATUS (T3-INDEX) = 'A' AND                   
                  ORDER-TYPE-CD-0073(1:3) = 'OFF'                       
                      IF (T3-UT-RATE-PLAN-NO (T3-INDEX) = '017' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '018' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '062' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '067' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '025' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '026' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ' AND         
                          WS-NO-OF-DAYS < 1827)                         
                              MOVE 'Y' TO WS-LIGHTING-CONTRACT-FL       
                              IF T3-UT-RATE-PLAN-NO (T3-INDEX) =        
                                      '017' OR '018' OR '062' OR '067'  
                                  MOVE 'Y' TO WS-BUILDER-LIGHTING-FL
                              END-IF
                      END-IF
               END-IF
           END-IF.   
                                                                        
           MOVE T3-UT-CODE-UTIL-TYPE (T3-INDEX) TO CODE-UTIL-TYPE-0073  
                                                UT-CODE-UTIL-TYPE-0073. 
           MOVE T3-UT-IC-NO (T3-INDEX) TO IC-NO-0073.                   
           MOVE T3-UT-READ-ROUTE (T3-INDEX) TO UT-READ-ROUTE-0073.      
           MOVE T3-UT-RATE-PLAN-NO (T3-INDEX) TO RATE-PLAN-NO-0073.     
           MOVE T3-UT-CODE-REV-CLASS (T3-INDEX) TO                      
                UT-CODE-REV-CLASS-0073.                                 
           MOVE T3-UT-READ-CYCLE (T3-INDEX) TO UT-READ-CYCLE-0073.      
           MOVE T3-UT-CODE-SIC-NO (T3-INDEX) TO UT-CODE-SIC-NO-0073.    
           MOVE T3-MN-MTR-REF-NO (T3-INDEX) TO MN-MTR-REF-NO-0073.      
           MOVE T3-MN-METER-NO (T3-INDEX) TO METER-NO-0073.             
           MOVE T3-MN-CODE-TIME-PER (T3-INDEX) TO MN-CODE-TIME-PER-0073.
           MOVE T3-MN-LAST-READ-VAL (T3-INDEX) TO MN-LAST-READ-VAL-0073.
           MOVE T3-MN-CD-STAT-REAS (T3-INDEX) TO                        
                MN-CODE-STATUS-REA-0073.                                
           MOVE T3-MN-CODE-USAGE-T (T3-INDEX) TO                        
                MN-CODE-USAGE-TYPE-0073.                                
           MOVE T3-MN-CODE-USAGE-I (T3-INDEX) TO                        
                MN-CODE-USAGE-ID-0073.                                  
           MOVE T3-MN-CODE-USAGE-S (T3-INDEX) TO                        
                MN-CODE-USAGE-SO-0073.                                  
           MOVE T3-MN-CODE-METER-S (T3-INDEX) TO                        
                CODE-METER-STATUS-0073.                                 
           MOVE T3-MN-METER-SUPPLY (T3-INDEX) TO                        
                METER-SUPPLYING-0073.                                   
           MOVE T3-MN-CODE-METER-LOC (T3-INDEX) TO                      
                CODE-MTR-LOC-0073.                                      
           MOVE T3-MN-CONSTANT (T3-INDEX) TO MN-CONSTANT-0073.          
           MOVE T3-MN-NO-DIALS (T3-INDEX) TO MN-NO-DIALS-0073.          
           MOVE T3-MN-POINT-ID (T3-INDEX) TO MN-POINT-ID-0073.          
           MOVE T3-MN-SEAL-CODE-ID (T3-INDEX) TO                        
                MN-SEAL-CODE-ID-0073.                                   
           MOVE T3-MN-HEX-LOCATION (T3-INDEX) TO                        
                MN-HEX-LOCATION-0073.                                   
           MOVE T3-MN-INSULATED-IND (T3-INDEX) TO                       
                MN-INSULATED-IND-0073.                                  
           MOVE T3-MN-LOCK-TYPE-ID (T3-INDEX) TO                        
                MN-LOCK-TYPE-ID-0073.                                   
           MOVE T3-MN-DELIVERY-LEV (T3-INDEX) TO MN-DELV-LEVEL-CD-0073. 
           MOVE T3-MN-UTILITY-SOURCE (T3-INDEX) TO                      
                MN-UTILITY-SOURCE-0073.                                 
           MOVE T3-MN-IDR-RECIPIENT (T3-INDEX) TO                       
                MN-IDR-RECIPIENT-0073.                                  
           MOVE T3-MN-PROGRAM-ID (T3-INDEX) TO MN-PROGRAM-ID-0073.      
           MOVE T3-MN-MTR-READ-SOURCE (T3-INDEX) TO READ-SOURCE-CD-0073.
           MOVE T3-MN-MTR-PRESS(T3-INDEX) TO MN-METER-PRESSURE-0073.    
                                                                        
           EVALUATE T3-MN-CODE-METER-S (T3-INDEX)                       
               WHEN 'K'                                                 
                   MOVE 'FIN' TO WS-WORK-TYPE-CD                        
               WHEN 'A'                                                 
                   MOVE 'BLK' TO WS-WORK-TYPE-CD                        
               WHEN 'J'                                                 
                   MOVE 'VRB' TO WS-WORK-TYPE-CD                        
           END-EVALUATE.                                                
                                                                        
           IF T3-UT-RATE-PLAN-NO (T3-INDEX) = '005' AND                 
             (T3-MN-CODE-METER-S (T3-INDEX) = 'A' OR 'J')               
                 MOVE 'RMM' TO WS-WORK-TYPE-CD
           END-IF.                         
                                                                        
           MOVE WS-WORK-TYPE-CD TO WORK-TYPE-CD-0073.                   
                                                                        
           MOVE SPACES TO RG-CODE-REG-STAT-0073                         
                          RG-CODE-STATUS-REA-0073                       
                          RG-CODE-USAGE-ID-0073                         
                          RG-CODE-USAGE-SO-0073                         
                          RG-CODE-USAGE-TY-0073                         
                          RG-LAST-READ-DT-0073.                         
           MOVE 0 TO RG-CODE-TIME-PER-0073                              
                     RG-REG-ID-NO-0073.                                 
           MOVE 0.0 TO RG-LAST-READ-VAL-0073.                           
                                                                        
           MOVE T3-CP-CODE-PLAN (T3-INDEX) TO CP-CODE-PLAN-STA-0073.    
           MOVE T3-CP-CD-STAT-REAS (T3-INDEX) TO CP-CODE-STAT-REA-0073. 
           MOVE T3-CP-CD-SVC-TYPE (T3-INDEX) TO CP-CODE-SERVICEZ-0073.  
           MOVE T3-CP-DIST-NO (T3-INDEX) TO CP-DIST-NO-0073.            
           MOVE T3-CP-EQUIP-ID (T3-INDEX) TO CP-EQUIP-ID-0073.          
           MOVE T3-CP-USAGE-FIXED (T3-INDEX) TO CP-USAGE-FIXED-0073.    
           MOVE T3-CP-MTHLY-AMT (T3-INDEX) TO CP-MNTHLY-AMT-FI-0073     
           MOVE T3-CP-RT-ITEM-CD (T3-INDEX) TO CP-RATE-ITEM-CD-0073.    
           MOVE T3-CP-LIGHT-NO (T3-INDEX) TO CP-LIGHT-NO-0073.          
           MOVE T3-CP-POLE-NO (T3-INDEX) TO CP-POLE-NO-0073.            
           MOVE T3-CP-ITEM-SEQ-NO (T3-INDEX) TO CP-ITEM-SEQ-NO-0073.    
           MOVE T3-CP-NO-UNITS (T3-INDEX) TO CP-NO-UNITS-0073.          
                                                                        
           EVALUATE T3-TABLE-ID (T3-INDEX)                              
               WHEN 'MN'                                                
                   MOVE 'Y' TO WS-INCLUDE-INST                          
               WHEN 'XX'                                                
                   MOVE 'Y' TO WS-INCLUDE-INST                          
               WHEN 'UT'                                                
                   MOVE 'N' TO WS-INCLUDE-INST                          
               WHEN OTHER                                               
                   MOVE 'N' TO WS-INCLUDE-INST                          
           END-EVALUATE,                                                
                                                                        
           MOVE WS-INCLUDE-INST TO ORDER-INST-PRESEN-0073               
                                   INCLUDE-INST-0073.                   
           MOVE 'Y' TO WS-UTIL-ENV-EXISTS                               
                       UTIL-ENV-PRESEN-0073.                            
           MOVE T3-ACCT-STATUS (T3-INDEX) TO OLD-ACCT-STAT-0073         
                                             ACCT-STATUS-0073.          
           MOVE T3-RG-LAST-READD (T3-INDEX) TO MN-LAST-READ-DT-0073.    
           MOVE T3-RG-REG-ID-NO (T3-INDEX) TO MN-REG-ID-NO-0073.        
           MOVE T3-SUBDIV-LIGHT (T3-INDEX) TO PRICE-PER-SERV-0073.      
           MOVE T3-ACCT-TYPE-CODE (T3-INDEX) TO ACCOUNT-TYPE-CODE-0073. 
                                                                        
       4055-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA TO ADD A NEW ORDER.                   **          
      ****************************************************************          
                                                                        
       4060-LOAD-APPLIANCE-DATA.                                        
                                                                        
           MOVE 'Y' TO WS-EQUIPMENT-EXISTS.                             
           SET T5-INDEX TO WS-II-CTR.                                   
           MOVE T5-APPLIANCE-CD (T5-INDEX) TO APPLIANCE-CD-0073.        
           MOVE 0 TO APPLIANCE-SEQ-NO-0073.                             
           MOVE SPACES TO EQUIP-OWNER-0073.                             
           MOVE 'G' TO MKT-CODE-UTIL-TYPE-0073.                         
           MOVE T5-CUT-IND (T5-INDEX) TO CUTOFF-IND-0073.               
           MOVE T5-CAUTION-TAG-IND (T5-INDEX) TO CAUTION-TAG-IND-0073.  
           MOVE T5-CONDITION-DESC (T5-INDEX) TO IMPROPER-REASON-0073.   
           MOVE T5-EQUIPMENT-NO (T5-INDEX) TO EQUIPMENT-UNQ-0073.       
           MOVE 'Y' TO EQUIPMENT-PRESEN-0073.                           
           MOVE SPACES TO INSTALL-DT-0073.                              
           MOVE 'N' TO REPLACE-APP-FL-0073                              
                       LEAK-IND-0073                                    
                       LIGHT-IND-0073                                   
                       REPAIR-IND-0073.                                 
           MOVE T5-APPLIANCE-DESC (T5-INDEX) TO PRD-SRV-TYPE-DESC-0073. 
           MOVE 'N' TO INSTALL-IND-0073.                                
                                                                        
       4060-EXIT.                                                       
            EXIT.                                                       
P00718                                                                  
P00718 4065-GET-WORK-DISTRICT.                                          
P00718     INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     EVALUATE TRUE                                                
P00718        WHEN LINK-BUSINESS-UNIT = 'EOP'                           
P00718         AND PR-FM-ELEC-SVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-ELEC-SVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'GOP'                           
P00718         AND PR-FM-GAS-OPS-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-GAS-OPS-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'FSV'                           
P00718         AND PR-FM-FLD-SVCS-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-FLD-SVCS-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'RVP'                           
P00718         AND PR-FM-REV-PRT-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-REV-PRT-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'DSM'                           
P00718         AND PR-FM-DSM-ESVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-DSM-ESVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718     PERFORM 7900-GET-PRINT-LOC                THRU 7900-EXIT.    
P00718     MOVE LINK-CURR-ACCOUNT-NO                 TO RG-ACCOUNT-NO.  
P00718     PERFORM 7905-GET-REGISTER-DTLS            THRU 7905-EXIT.    
P00718     IF (C4-CAD-WORKAREA-FL = 'Y' AND WS-MULTI-REG-MTR = 'N')     
P00718        MOVE WS-WORK-DISTRICT                  TO RS-WORK-DISTRICT
P00718     ELSE                                                         
P00718        MOVE SPACES                            TO RS-WORK-DISTRICT
P00718     END-IF.                                                      
P00718                                                                  
P00718 4065-EXIT.                                                       
P00718      EXIT.                                                       
P00718                                                                  
      ****************************************************************          
      **  GET APPLIANCES FOR THE PREMISE FROM CSS_APPLIANCE.        **          
      ****************************************************************          
                                                                        
       4170-GET-APPLIANCES.                                             
                                                                        
           PERFORM 7160-OPEN-APP-CURSOR THRU 7160-EXIT.                 
           PERFORM 4175-BUILD-TABLE THRU 4175-EXIT VARYING              
                T5-INDEX FROM 1 BY 1 UNTIL                              
                T5-INDEX > 20  OR                                       
                WS-ACTIVE-RETURN-CODE = NOT-FOUND.                      
           PERFORM 7170-CLOSE-APP-CURSOR THRU 7170-EXIT.                
                                                                        
       4170-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA FOR PREMISE INTO T5-APPLIANCES        **          
      **  WORKING STORAGE TABLE.  THE ROWCOUNT FOR THIS TABLE IS    **          
      **  IN WS-T5-ROWCOUNT.                                        **          
      ****************************************************************          
                                                                        
       4175-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH APP_CURSOR                                         
               INTO :LA-APPLIANCE-CD,                                   
                    :LA-PRIMARY-FUEL-CD,                                
                    :LA-EQUIPMENT-NO,                                   
                    :LA-CAUTION-TAG-IND,                                
                    :A7-CONDITION-DESC,                                 
                    :LA-CUT-IND,                                        
                    :JA-APPLIANCE-DESC,                                 
                    :JA-CRAWL-FL                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE LA-APPLIANCE-CD TO                              
                        T5-APPLIANCE-CD (T5-INDEX)                      
                   MOVE LA-PRIMARY-FUEL-CD TO                           
                        T5-PRIMARY-FUEL-CD (T5-INDEX)                   
                   MOVE LA-EQUIPMENT-NO TO                              
                        T5-EQUIPMENT-NO (T5-INDEX)                      
                   MOVE LA-CAUTION-TAG-IND TO                           
                        T5-CAUTION-TAG-IND (T5-INDEX)                   
                   MOVE A7-CONDITION-DESC TO                            
                        T5-CONDITION-DESC (T5-INDEX)                    
                   MOVE LA-CUT-IND TO                                   
                        T5-CUT-IND (T5-INDEX)                           
                   MOVE JA-APPLIANCE-DESC TO                            
                        T5-APPLIANCE-DESC (T5-INDEX)                    
                   MOVE JA-CRAWL-FL TO                                  
                        T5-CRAWL-FL (T5-INDEX)                          
                   MOVE SPACES TO                                       
                        T5-EQUIP-OWNER (T5-INDEX)                       
                        T5-INSTALL-DT (T5-INDEX)                        
                   MOVE 'N' TO T5-REPLACE-APP-FL (T5-INDEX)             
                   ADD 1 TO WS-T5-ROWCOUNT                              
               WHEN NOT-FOUND                                           
                   GO TO 4175-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '4075'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'FETCH'                  TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_APPLIANCE'          TO TABLE-1             
                   MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1     
                   MOVE LA-PREMISE-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4175-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00073 TO ADD AN ORDER.  MULTIPLE CALLS ARE        **          
      **  REQUIRED.  THE LAST CALL HAS A 0 ROW-COUNT.               **          
      ****************************************************************          
                                                                        
       4200-CALL-CSR00073.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00073                                             
      *           (:ROW-NO-0073,                                        
      *            :PREMISE-NO-0073,                                    
      *            :ACCOUNT-NO-0073,                                    
      *            :ACCOUNT-NO-PRIOR-0073,                              
      *            :SERV-ORDER-NO-0073,                                 
      *            :ORDER-TYPE-CD-0073,                                 
      *            :LOCAL-OFFICE-0073,                                  
      *            :PHONE-NO-EXT-0073,                                  
      *            :PHONE-NO-0073,                                      
      *            :ORDER-PLACED-BY-0073,                               
      *            :ORDER-RECVED-BY-0073,                               
      *            :WANTED-BY-DATE-0073,                                
      *            :ASSIGNED-DATETIME-0073,                             
      *            :ORDER-REASON-0073,                                  
      *            :BACK-DATED-IND-0073,                                
      *            :RESP-AREA-ID-0073,                                  
      *            :CALL-BEFORE-MIN-0073,                               
      *            :NOTIFY-CUST-IND-0073,                               
      *            :NOTIFY-CSR-IND-0073,                                
      *            :BREAKERS-OFF-0073,                                  
      *            :DEPOSIT-AMT-0073,                                   
      *            :INIT-BY-CNTRCT-0073,                                
      *            :WORK-AREA-ID-0073,                                  
      *            :ORDER-PRIORITY-0073,                                
      *            :ORDER-STATE-CD-0073,                                
      *            :WORK-TYPE-CD-0073,                                  
      *            :CODE-UTIL-TYPE-0073,                                
      *            :STD-CHG-AMT-0073,                                   
      *            :HOLD-RELEASE-0073,                                  
      *            :RLSE-IND-0073,                                      
      *            :PER-TEMP-IND-0073,                                  
      *            :RLSE-NO-0073,                                       
      *            :RLSE-DATE-0073,                                     
      *            :SO-INST-SEQ-NO-0073,                                
      *            :TABLE-ID-0073,                                      
      *            :UT-CODE-UTIL-TYPE-0073,                             
      *            :IC-NO-0073,                                         
      *            :UT-READ-ROUTE-0073,                                 
      *            :RATE-PLAN-NO-0073,                                  
      *            :UT-CODE-REV-CLASS-0073,                             
      *            :UT-READ-CYCLE-0073,                                 
      *            :UT-CODE-SIC-NO-0073,                                
      *            :METER-NO-0073,                                      
      *            :MN-MTR-REF-NO-0073,                                 
      *            :MN-CODE-TIME-PER-0073,                              
      *            :MN-LAST-READ-VAL-0073,                              
      *            :MN-CODE-STATUS-REA-0073,                            
      *            :MN-CODE-USAGE-TYPE-0073,                            
      *            :MN-CODE-USAGE-ID-0073,                              
      *            :MN-CODE-USAGE-SO-0073,                              
      *            :CODE-METER-STATUS-0073,                             
      *            :METER-SUPPLYING-0073,                               
      *            :CODE-MTR-LOC-0073,                                  
      *            :MN-CONSTANT-0073,                                   
      *            :MN-NO-DIALS-0073,                                   
      *            :MN-POINT-ID-0073,                                   
      *            :MN-SEAL-CODE-ID-0073,                               
      *            :MN-HEX-LOCATION-0073,                               
      *            :MN-INSULATED-IND-0073,                              
      *            :MN-LOCK-TYPE-ID-0073,                               
      *            :MN-DELV-LEVEL-CD-0073,                              
      *            :MN-UTILITY-SOURCE-0073,                             
      *            :MN-IDR-RECIPIENT-0073,                              
      *            :MN-PROGRAM-ID-0073,                                 
      *            :READ-SOURCE-CD-0073,                                
      *            :RG-CODE-REG-STAT-0073,                              
      *            :RG-CODE-STATUS-REA-0073,                            
      *            :RG-CODE-TIME-PER-0073,                              
      *            :RG-CODE-USAGE-ID-0073,                              
      *            :RG-CODE-USAGE-SO-0073,                              
      *            :RG-CODE-USAGE-TY-0073,                              
      *            :RG-LAST-READ-DT-0073,                               
      *            :RG-LAST-READ-VAL-0073,                              
      *            :RG-REG-ID-NO-0073,                                  
      *            :CP-NO-UNITS-0073,                                   
      *            :CP-CODE-PLAN-STA-0073,                              
      *            :CP-CODE-STAT-REA-0073,                              
      *            :CP-CODE-SERVICEZ-0073,                              
      *            :CP-MNTHLY-AMT-FI-0073,                              
      *            :CP-RATE-ITEM-CD-0073,                               
      *            :CP-LIGHT-NO-0073,                                   
      *            :CP-POLE-NO-0073,                                    
      *            :CP-DIST-NO-0073,                                    
      *            :CP-USAGE-FIXED-0073,                                
      *            :CP-EQUIP-ID-0073,                                   
      *            :APPLIANCE-CD-0073,                                  
      *            :APPLIANCE-SEQ-NO-0073,                              
      *            :EQUIP-OWNER-0073,                                   
      *            :MKT-CODE-UTIL-TYPE-0073,                            
      *            :LEAK-IND-0073,                                      
      *            :LIGHT-IND-0073,                                     
      *            :REPAIR-IND-0073,                                    
      *            :CUTOFF-IND-0073,                                    
      *            :CAUTION-TAG-IND-0073,                               
      *            :IMPROPER-REASON-0073,                               
      *            :EQUIPMENT-UNQ-0073,                                 
      *            :VERIFY-RATE-0073,                                   
      *            :ORDER-INST-PRESEN-0073,                             
      *            :EQUIPMENT-PRESEN-0073,                              
      *            :UTIL-ENV-PRESEN-0073,                               
      *            :NEW-ORDER-0073,                                     
      *            :PANEL-NO-0073,                                      
      *            :INCLUDE-INST-0073,                                  
      *            :REV-DIST-CD-0073,                                   
      *            :USER-ID-0073,                                       
      *            :SO-EST-LABOR-HR-0073,                               
      *            :ACCT-STATUS-0073,                                   
      *            :REORDER-FLAG-0073,                                  
      *            :COMPANY-NO-0073,                                    
      *            :INSTALL-DT-0073,                                    
      *            :REPLACE-APP-FL-0073,                                
      *            :PRD-SRV-TYPE-DESC-0073,                             
      *            :OLD-ACCT-STAT-0073,                                 
      *            :CODE-KEY-FIELD-0073,                                
      *            :RCC-CODE-0073,                                      
      *            :MN-LAST-READ-DT-0073,                               
      *            :MN-REG-ID-NO-0073,                                  
      *            :DATE-FORECAST-DNP-0073,                             
      *            :AMT-DNP-AT-BILLING-0073,                            
      *            :PRICE-PER-SERV-0073,                                
      *            :ACCOUNT-TYPE-CODE-0073,                             
      *            :INSTALL-IND-0073,                                   
      *            :CP-ITEM-SEQ-NO-0073,                                
      *            :CUST-CNT-ID-0073,                                   
      *            :WORK-PERIOD-CD-0073,                                
      *            :WAIVER-TYPE-CD-0073,                                
      *            :MN-METER-PRESSURE-0073,                             
      *            :BUSINESS-UNIT-0073,                                 
      *            :OPTIMIZE-ORDER-0073)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0073
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0073
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0073 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00073'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-0073       TO HOSTVAR-ELEMENT-1           
              MOVE 'ROW_NO'              TO TABLE-ELEMENT-2             
              MOVE ROW-NO-0073           TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0073)                                                
      *       WITH PROCEDURE CSR00073                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0073 CURSOR FOR RESULT SET        
      *       :LOC0073                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0073 INTO                            
                 :NO-ERROR-0073,                                        
                 :NEW-SERV-ORDER-NO-0073,                               
                 :WORK-QUEUE-0073,                                      
                 :RLSE-NO-NEW-0073                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00073'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PREMISE-NO-0073       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ROW_NO'              TO TABLE-ELEMENT-2        
                   MOVE ROW-NO-0073           TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF NO-ERROR-0073 NOT = 0                                     
               MOVE NO-ERROR-0073             TO RS-STATUS-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '4200'                    TO ACTIVE-PARAGRAPH       
               MOVE 'ERROR'                   TO ABEND-FUNCTION         
               MOVE 'CSR00073'                TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE PREMISE-NO-0073           TO HOSTVAR-ELEMENT-1      
               MOVE 'ROW_NO'                  TO TABLE-ELEMENT-2        
               MOVE ROW-NO-0073               TO HOSTVAR-ELEMENT-2      
               MOVE 'ERROR_NO'                TO TABLE-ELEMENT-2        
               MOVE NO-ERROR-0073             TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
ACT233**  CALL CSR04675 TO INSERT A WQ.                             **          
      ****************************************************************          
                                                                        
ACT233 4210-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT233     MOVE PR-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT233     MOVE LINK-ORDER-RECVED-BY TO USER-ID-ORIG-4675.              
ACT233     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT233                    RESP-AREA-ID-4675                             
ACT233                    DATE-REQUIRED-4675                            
ACT233                    DATE-CREATED-4675                             
ACT233                    FREE-FORM-DATA-4675-TEXT.                     
ACT233     MOVE 'N' TO WQ-PRIORITY-4675                                 
ACT233     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT233     MOVE AT-ACCOUNT-NO TO ACCOUNT-NO-4675.                       
ACT233     MOVE PR-PREMISE-NO TO PREMISE-NO-4675.                       
ACT233     MOVE WS-CUSTOMER-NO-NUM TO CUSTOMER-NO-4675.                 
ACT233     MOVE NEW-SERV-ORDER-NO-0073 TO SERV-ORDER-NO-4675.           
ACT233     MOVE 'CSR04106' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
ACT233                 MOVE ACCOUNT-NO-4675   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
ACT233             MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  TRANSFER PROCESSING.                                      **          
      ****************************************************************          
                                                                        
       5000-XFER-PROCESSING.                                            
                                                                        
           PERFORM 5010-CALL-CSR02142 THRU 5010-EXIT.                   
           PERFORM 5015-CALL-CSR00178 THRU 5015-EXIT.                   
           PERFORM 5020-CALL-CSR02146 THRU 5020-EXIT.                   
           PERFORM 5030-CALL-CSR02165 THRU 5030-EXIT.                   
           IF LINK-ADD-FINAL-ADDR-FL = 'N'                              
               PERFORM 5040-DEFAULT-FB-ADDRESS THRU 5040-EXIT
           END-IF.          
           MOVE '038' TO VW-PANEL-NO.                                   
           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02142 TO GET TRANSFER INFORMATION.                **          
      ****************************************************************          
                                                                        
       5010-CALL-CSR02142.                                              
                                                                        
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2142.                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02142                                             
      *           (:ACCOUNT-NO-2142)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2142
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2142
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2142 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5010'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02142'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2142       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2142)                                                
      *       WITH PROCEDURE CSR02142                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2142 CURSOR FOR RESULT SET        
      *       :LOC2142                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2142 INTO                            
                 :DNP-DATE-2142,                                        
                 :PAST-DUE-BAL-2142,                                    
                 :BILL-DATE-2142,                                       
                 :CREDIT-GROUP-2142,                                    
                 :ACCT-XFER-FROM-LST-2142,                              
                 :STA-IND-2142,                                         
                 :UTL-IND-2142,                                         
                 :BANK-DRAFT-IND-2142,                                  
                 :EPP-IND-2142,                                         
                 :DEPOSIT-IND-2142,                                     
                 :OTHER-RECV-IND-2142,                                  
                 :PROJ-SHARE-IND-2142,                                  
                 :WRITE-OFF-IND-2142,                                   
                 :IN-LIEU-DEP-IND-2142,                                 
                 :ROOMMATE-IND-2142,                                    
                 :CO-APP-IND-2142,                                      
                 :MEDICAL-IND-2142,                                     
                 :WHITE-CROSS-IND-2142,                                 
                 :RETURN-CODE-2142,                                     
                 :EPP-TRAN-BALANCE-2142,                                
                 :CONTRACT-FLAG-2142,                                   
                 :CODE-ACCT-STAT-2142,                                  
                 :ADDRESS-FORMAT-2142,                                  
                 :HOUSE-NO-2142,                                        
                 :ADDR-PREFIX-1-2142,                                   
                 :ADDR-PREFIX-2-2142,                                   
                 :STREET-NAME-2142,                                     
                 :STREET-SUFFIX-2142,                                   
                 :ADDR-SUFFIX-2142,                                     
                 :STREET-LOCATION-1-2142,                               
                 :STREET-LOCATION-2-2142,                               
                 :ZIP-CODE-2142,                                        
                 :ZIP-CODE-PLUS-FOUR-2142,                              
                 :ZIP-CODE-TOKEN-2142,                                  
                 :ADDRESS-OVERFLOW-2142,                                
                 :ADDR-STREET-2142,                                     
                 :ADDR-CITY-STATE-2142,                                 
                 :ADDR-ZIP-CODE-2142,                                   
                 :ADDR-COUNTRY-2142,                                    
                 :ADDR-OVERFLOW-2142                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2142 NOT = 0                          
                       MOVE RETURN-CODE-2142  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5010'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02142'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2142   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5010'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02142'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2142       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00178 TO UPDATE SO ACCOUNT TRANSFER.              **          
      ****************************************************************          
                                                                        
       5015-CALL-CSR00178.                                              
                                                                        
           MOVE 'U' TO UPDATE-TYPE-0178.                                
           MOVE WS-ACCOUNT-XFER-NUM TO TO-ACCT-NO-0178.                 
           MOVE RS-SERV-ORDER-NO TO SERV-ORDER-NO-0178.                 
           IF ROOMMATE-IND-2142 = 'A'                                   
               MOVE 'Y' TO ROOMMATE-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO ROOMMATE-XFER-IND-0178
           END-IF.                      
           IF EPP-IND-2142 = 'A'                                        
               MOVE 'Y' TO EPP-XFER-IND-0178                            
           ELSE                                                         
               MOVE 'N' TO EPP-XFER-IND-0178
           END-IF.                           
           IF DEPOSIT-IND-2142 = 'A'                                    
               MOVE 'Y' TO DEPOSIT-XFER-IND-0178                        
           ELSE                                                         
               MOVE 'N' TO DEPOSIT-XFER-IND-0178
           END-IF.                       
           IF OTHER-RECV-IND-2142 = 'A'                                 
               MOVE 'Y' TO OTHER-AR-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO OTHER-AR-XFER-IND-0178
           END-IF.                      
           IF PROJ-SHARE-IND-2142 = 'A'                                 
               MOVE 'Y' TO PROJ-SHR-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO PROJ-SHR-XFER-IND-0178
           END-IF.                      
           MOVE 'N' TO WRITE-OFF-XFER-IND-0178.                         
           IF IN-LIEU-DEP-IND-2142 = 'A'                                
               MOVE 'Y' TO IN-LIEU-XFER-IND-0178                        
           ELSE                                                         
               MOVE 'N' TO IN-LIEU-XFER-IND-0178
           END-IF.                       
           IF WHITE-CROSS-IND-2142 = 'A'                                
               MOVE 'Y' TO WHT-CROSS-XFER-IND-0178                      
           ELSE                                                         
               MOVE 'N' TO WHT-CROSS-XFER-IND-0178
           END-IF.                     
           IF CO-APP-IND-2142 = 'A'                                     
               MOVE 'Y' TO COAPPL-XFER-IND-0178                         
           ELSE                                                         
               MOVE 'N' TO COAPPL-XFER-IND-0178
           END-IF.                        
           IF MEDICAL-IND-2142 = 'A'                                    
               MOVE 'Y' TO MED-CERT-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO MED-CERT-XFER-IND-0178
           END-IF.                      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00178                                             
      *          (:UPDATE-TYPE-0178,                                    
      *           :TO-ACCT-NO-0178,                                     
      *           :SERV-ORDER-NO-0178,                                  
      *           :ROOMMATE-XFER-IND-0178,                              
      *           :EPP-XFER-IND-0178,                                   
      *           :DEPOSIT-XFER-IND-0178,                               
      *           :OTHER-AR-XFER-IND-0178,                              
      *           :PROJ-SHR-XFER-IND-0178,                              
      *           :WRITE-OFF-XFER-IND-0178,                             
      *           :IN-LIEU-XFER-IND-0178,                               
      *           :WHT-CROSS-XFER-IND-0178,                             
      *           :COAPPL-XFER-IND-0178,                                
      *           :MED-CERT-XFER-IND-0178)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0178
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0178
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0178 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5015'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00178'            TO TABLE-1                     
              MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1             
              MOVE TO-ACCT-NO-0178       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0178)                                                
      *       WITH PROCEDURE CSR00178                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0178 CURSOR FOR RESULT SET        
      *       :LOC0178                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0178 INTO                            
                 :RETURN-CODE-0178                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0178 NOT = 0                          
                       MOVE RETURN-CODE-0178  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5015'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00178'        TO TABLE-1                
                       MOVE 'TO_ACCT_NO'      TO TABLE-ELEMENT-1        
                       MOVE TO-ACCT-NO-0178   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5015'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00178'            TO TABLE-1                
                   MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1        
                   MOVE TO-ACCT-NO-0178       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5015-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02146 TO GET CONTRACT INFORMATION.  FOR EACH      **          
      **  CONTRACT, CALL CSR00179 TO UPDATE SO TABLE FOR XFER.      **          
      ****************************************************************          
                                                                        
       5020-CALL-CSR02146.                                              
                                                                        
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2146.                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02146                                             
      *           (:ACCOUNT-NO-2146)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2146
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2146
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2146 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5020'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02146'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2146       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2146)                                                
      *       WITH PROCEDURE CSR02146                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2146 CURSOR FOR RESULT SET        
      *       :LOC2146                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
               EXEC SQL                                                 
                  FETCH RESULT_SET_CSR_2146 INTO                        
                     :CONTRACT-ID-2146,                                 
                     :CONTRACT-NAME-ABBR-2146,                          
                     :AR-TRAN-BAL-2146,                                 
                     :LIEN-CD-2146,                                     
P00795               :TRANSFER-FL-2146,                                 
P00795               :CNT-NAME-DESC-2146,                               
                     :RETURN-CODE-2146                                  
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       IF RETURN-CODE-2146 NOT = 0 AND                  
                          RETURN-CODE-2146 NOT = 100                    
                             MOVE RETURN-CODE-2146 TO RS-STATUS-CODE    
                                                WS-ACTIVE-RETURN-CODE   
                             MOVE PROGRAM-NAME  TO ABEND-PROGRAM        
                             MOVE '5020'        TO ACTIVE-PARAGRAPH     
                             MOVE 'FETCH'       TO ABEND-FUNCTION       
                             MOVE 'CSR02146'    TO TABLE-1              
                             MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1      
                             MOVE ACCOUNT-NO-2146 TO HOSTVAR-ELEMENT-1  
                             PERFORM 9000-SEND-ERROR-RESULT THRU        
                                     9000-EXIT                          
                             PERFORM 9900-SQL-ERROR-ROUTINE THRU        
                                     9900-EXIT                          
                       END-IF                                           
                       IF RETURN-CODE-2146 = 100                        
                           SET NO-MORE-ROWS TO TRUE                     
                           MOVE 0 TO WS-ACTIVE-RETURN-CODE              
                       END-IF                                           
                       IF RETURN-CODE-2146 = 0 AND                      
                          LIEN-CD-2146 NOT = 'Y' AND                    
D06358                    TRANSFER-FL-2146 = 'Y'                        
                             PERFORM 5025-CALL-CSR00179 THRU 5025-EXIT  
                       END-IF                                           
                   WHEN NOT-FOUND                                       
                       SET NO-MORE-ROWS TO TRUE                         
                       MOVE 0 TO WS-ACTIVE-RETURN-CODE                  
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5020'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02146'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2146   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE                                             
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00170 TO UPDATE SO TABLE FOR XFER.                **          
      ****************************************************************          
                                                                        
       5025-CALL-CSR00179.                                              
                                                                        
           MOVE 'U' TO UPDATE-TYPE-0179.                                
           MOVE WS-ACCOUNT-XFER-NUM TO TO-ACCT-NO-0179.                 
           MOVE CONTRACT-ID-2146 TO CNT-ITEM-ID-0179.                   
           MOVE RS-SERV-ORDER-NO TO SERV-ORDER-NO-0179.                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00179                                             
      *           (:UPDATE-TYPE-0179,                                   
      *            :TO-ACCT-NO-0179,                                    
      *            :CNT-ITEM-ID-0179,                                   
      *            :SERV-ORDER-NO-0179)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0179
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0179
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0179 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5025'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00179'            TO TABLE-1                     
              MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1             
              MOVE TO-ACCT-NO-0179       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0179)                                                
      *       WITH PROCEDURE CSR00179                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0179 CURSOR FOR RESULT SET        
      *       :LOC0179                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0179 INTO                            
                 :RETURN-CODE-0179                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0179 NOT = 0                          
                       MOVE RETURN-CODE-0179  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5025'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00179'        TO TABLE-1                
                       MOVE 'TO_ACCT_NO'      TO TABLE-ELEMENT-1        
                       MOVE TO-ACCT-NO-0179   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5025'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00179'            TO TABLE-1                
                   MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1        
                   MOVE TO-ACCT-NO-0179       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5025-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02165 TO CREATE A WAIVER.                         **          
      ****************************************************************          
                                                                        
       5030-CALL-CSR02165.                                              
                                                                        
           MOVE 'I' TO ACTION-CODE-2165.                                
           MOVE LINK-XFER-ACCOUNT-NO TO ACCOUNT-NO-2165                 
                                        WS-DISP-XFER-ACCT.              
           MOVE 'K' TO WAIVER-TYPE-CD-2165.                             
           MOVE 'A' TO CODE-STATUS-2165.                                
           MOVE 'WAIVER ADDED BY SYSTEM' TO COMMENTS-TEXT-2165.         
           MOVE '0022' TO COMMENTS-LEN-2165.                            
           MOVE SPACES TO CODE-STATUS-REAS-2165                         
                          TRIGGER-DATE-2165                             
                          WAIVER-SRCE-DESC-2165.                        
           MOVE ZEROES TO BOND-ITEM-ID-2165.                            
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-2165                    
                                        WS-DISP-XFER-USER.              
           MOVE RS-SERV-ORDER-NO TO WS-DISP-XFER-SO.                    
           MOVE WS-WAIVER-COMMENTS TO TRAN-COMMENT-TXT-2165.            
           MOVE '0090' TO TRAN-COMMENT-LEN-2165.                        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02165                                             
      *           (:ACTION-CODE-2165,                                   
      *            :ACCOUNT-NO-2165,                                    
      *            :WAIVER-TYPE-CD-2165,                                
      *            :CODE-STATUS-2165,                                   
      *            :COMMENTS-LEN-2165,                                  
      *            :COMMENTS-TEXT-2165,                                 
      *            :CODE-STATUS-REAS-2165,                              
      *            :WAIVER-SRCE-DESC-2165,                              
      *            :TRIGGER-DATE-2165,                                  
      *            :BOND-ITEM-ID-2165,                                  
      *            :USER-ID-2165,                                       
      *            :TRAN-COMMENT-LEN-2165,                              
      *            :TRAN-COMMENT-TXT-2165)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2165
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2165
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2165 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5030'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02165'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2165       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2165)                                                
      *       WITH PROCEDURE CSR02165                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2165 CURSOR FOR RESULT SET        
      *       :LOC2165                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2165 INTO                            
                 :RETURN-CODE-2165                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2165 NOT = 0                          
                       MOVE RETURN-CODE-2165  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5030'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02165'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2165   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5030'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02165'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2165       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5030-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5040-DEFAULT-FB-ADDRESS.                                         
                                                                        
           IF ADDRESS-FORMAT-2142 = 'A'                                 
               MOVE 'A' TO LINK-ADDRESS-FORMAT                          
               MOVE HOUSE-NO-2142 TO LINK-HOUSE-NO                      
               MOVE ADDR-PREFIX-1-2142 TO LINK-ADDR-PREFIX-1            
               MOVE ADDR-PREFIX-2-2142 TO LINK-ADDR-PREFIX-2            
               MOVE STREET-NAME-2142 TO LINK-STREET-NAME                
               MOVE STREET-SUFFIX-2142 TO LINK-STREET-SUFFIX            
               MOVE ADDR-SUFFIX-2142 TO LINK-ADDR-SUFFIX                
               MOVE STREET-LOCATION-1-2142 TO LINK-STREET-LOC-1         
               MOVE STREET-LOCATION-2-2142 TO LINK-STREET-LOC-2         
               MOVE ZIP-CODE-2142 TO LINK-ZIP-CODE                      
               MOVE ZIP-CODE-PLUS-FOUR-2142 TO LINK-ZIP-CODE-PLUS-4     
           ELSE                                                         
               MOVE 'B' TO LINK-ADDRESS-FORMAT                          
               MOVE ADDR-OVERFLOW-2142 TO LINK-ADDRESS-OVERFLOW         
               MOVE ADDR-STREET-2142 TO LINK-ADDR-STREET                
               MOVE ADDR-CITY-STATE-2142 TO LINK-ADDR-CITY-STATE        
               MOVE ADDR-ZIP-CODE-2142 TO LINK-FR-ZIP-CODE              
               MOVE ADDR-COUNTRY-2142 TO LINK-COUNTRY
           END-IF.                  
                                                                        
           PERFORM 3400-CALL-CSR00148 THRU 3400-EXIT.                   
           MOVE '046' TO VW-PANEL-NO.                                   
           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                
                                                                        
       5040-EXIT.                                                       
            EXIT.                                                       
                                                                        
A05189****************************************************************          
A05189**  BUILD HOLD REMARKS FOR AN AROP ORDER.                     **          
A05189****************************************************************          
A05189                                                                  
A05189 5065-AROP-REMARKS.                                               
A05189                                                                  
A05189     MOVE 'HOLD FOR AROP IN CYCLE' TO EF-REMARK-TX-TEXT.          
A05189     MOVE +35 TO EF-REMARK-TX-LEN.                                
A05189     MOVE NEW-SERV-ORDER-NO-0073 TO EF-SERV-ORDER-NO.             
A05189     MOVE 'H' TO EF-REMARK-TYPE-CD.                               
A05189     MOVE LINK-ORDER-RECVED-BY TO EF-CHANGED-BY-USER-ID.          
A05189     PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT.                  
A05189                                                                  
A05189 5065-EXIT.                                                       
A05189      EXIT.                                                       
                                                                        
      ****************************************************************          
      **  UPDATE PREMISE SPECIAL INSTRUCTIONS TO INDICATE THE       **          
      **  METER IS ACCESSIBLE.                                      **          
      ****************************************************************          
                                                                        
       5070-SPECIAL-INST.                                               
                                                                        
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           MOVE PR-SPCL-INSTRUCTIONS-LEN TO WS-SPCL-INST-LEN.           
           IF WS-SPCL-INST-LEN > +230                                   
               MOVE +230 TO WS-SPCL-INST-LEN
           END-IF.                           
           STRING PR-SPCL-INSTRUCTIONS-TEXT (1:WS-SPCL-INST-LEN)        
                  ' M/A '                                               
                  WS-CURRENT-DATE-USA                                   
                  DELIMITED BY SIZE INTO WS-EMB-INPUT.                  
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           MOVE WS-CMP-TABLE TO PR-SPCL-INSTRUCTIONS-TEXT.              
           COMPUTE PR-SPCL-INSTRUCTIONS-LEN =                           
                   WS-SPCL-INST-LEN + 15.                               
           PERFORM 8500-UPDATE-INSTRUCTIONS THRU 8500-EXIT.             
                                                                        
       5070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02517 TO INSERT A COMMUNICATION RECORD.           **          
      ****************************************************************          
                                                                        
       5090-CALL-CSR02517.                                              
                                                                        
           MOVE 'I' TO ACTION-CD-2517.                                  
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2517.                
           MOVE WS-CUSTOMER-NO-CHAR TO CUSTOMER-NO-2517.                
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2517.                     
           MOVE SPACES TO COMMUNICATION-ID-2517                         
                          RED-FLAG-EXP-DT-2517                          
                          PROMOTION-ID-2517                             
                          CALL-END-TIME-2517                            
                          SCREEN-POP-IND-2517                           
                          RESPONSE-RESN-CD-2517                         
                          RESPONSE-TYPE-CD-2517                         
                          SOLICITATION-CD-2517.                         
           MOVE PR-COMPANY-NO TO COMPANY-NO-2517.                       
           MOVE 'N' TO RED-FLAG-IND-2517                                
                       PSC-COMPLAINT-IND-2517                           
                       COMPLAINT-FL-2517.                               
           MOVE 'Z' TO COMM-METHOD-2517.                                
           MOVE 'I' TO COMM-DIRECTION-2517.                             
           MOVE '41' TO COMM-TYPE-CD-2517.                              
           IF LINK-XFER-FL = 'Y'                                        
               MOVE '11' TO COMM-SUBTYPE-CD-2517                        
           ELSE                                                         
               MOVE '12' TO COMM-SUBTYPE-CD-2517
           END-IF.                       
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-ORIG-2517.              
           MOVE LINK-ORDER-PLACED-BY TO CONTACT-NAME-2517.              
           MOVE ZEROES TO CALL-ORIGIN-ID-2517                           
                          NUMBER-TRANSFERS-2517                         
                          HOLD-TIME-2517                                
                          QUEUE-TIME-2517                               
                          TOTAL-CALL-TIME-2517.                         
           MOVE 'A' TO COMM-ASSOC-CD-2517.                              
           STRING 'TURN OFF ORDER SCHEDULED '                           
                  WS-LINK-SCHEDULED-DT                                  
                  ' SEE EMAIL IMAGE FOR ADDL DETAILS'                   
                  DELIMITED BY SIZE INTO COMMENT-TEXT-2517.             
           MOVE LENGTH OF COMMENT-TEXT-2517 TO COMMENT-LEN-2517.        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02517                                             
      *           (:ACTION-CD-2517,                                     
      *            :ACCOUNT-NO-2517,                                    
      *            :CUSTOMER-NO-2517,                                   
      *            :PREMISE-NO-2517,                                    
      *            :COMMUNICATION-ID-2517,                              
      *            :COMPANY-NO-2517,                                    
      *            :RED-FLAG-IND-2517,                                  
      *            :RED-FLAG-EXP-DT-2517,                               
      *            :COMM-METHOD-2517,                                   
      *            :COMM-DIRECTION-2517,                                
      *            :COMM-TYPE-CD-2517,                                  
      *            :COMM-SUBTYPE-CD-2517,                               
      *            :USER-ID-ORIG-2517,                                  
      *            :CONTACT-NAME-2517,                                  
      *            :PROMOTION-ID-2517,                                  
      *            :PSC-COMPLAINT-IND-2517,                             
      *            :CALL-ORIGIN-ID-2517,                                
      *            :CALL-END-TIME-2517,                                 
      *            :NUMBER-TRANSFERS-2517,                              
      *            :HOLD-TIME-2517,                                     
      *            :QUEUE-TIME-2517,                                    
      *            :SCREEN-POP-IND-2517,                                
      *            :TOTAL-CALL-TIME-2517,                               
      *            :COMMENT-LEN-2517,                                   
      *            :COMMENT-TEXT-2517,                                  
      *            :COMM-ASSOC-CD-2517,                                 
      *            :COMPLAINT-FL-2517,                                  
      *            :RESPONSE-RESN-CD-2517,                              
      *            :RESPONSE-TYPE-CD-2517,                              
      *            :SOLICITATION-CD-2517)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2517 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5090'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02517'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2517)                                                
      *       WITH PROCEDURE CSR02517                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2517 CURSOR FOR RESULT SET        
      *       :LOC2517                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2517 INTO                            
                 :RETURN-CODE-2517                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2517 NOT = 0                          
                       MOVE RETURN-CODE-2517  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5090'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02517'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2517   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5090'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02517'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5090-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  SET FLAGS TO BE RETURNED TO WEB.                          **          
      ****************************************************************          
                                                                        
       5100-SET-FLAGS.                                                  
                                                                        
           PERFORM 7500-GET-CONTRACT THRU 7500-EXIT.                    
           IF WS-CODE-BANK-EFT = 'A'                                    
               MOVE 'Y' TO RS-BANK-DRAFT-FL                             
           ELSE                                                         
               PERFORM 7600-GET-BANK-EFT THRU 7600-EXIT
           END-IF.                
           IF WS-CODE-BUDGET = 'A'                                      
               MOVE 'Y' TO RS-EPP-FL
           END-IF.                                   
           IF WS-CODE-DPP-ACCT = 'A'                                    
               MOVE 'Y' TO RS-DPP-FL
           END-IF.                                   
           IF WS-CODE-DFA-ACCT = 'A'                                    
               MOVE 'Y' TO RS-DFA-FL
           END-IF.                                   
           IF WS-CODE-MEDICAL = 'A'                                     
               MOVE 'Y' TO RS-MED-CERT-FL
           END-IF.                              
           IF WS-LIGHTING-CONTRACT-FL = 'Y'                             
               MOVE 'Y' TO RS-LITE-CONTRACT-FL
           END-IF.                         
           MOVE 0 TO WS-ACTIVE-RETURN-CODE.                             
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5200-FORMAT-SERVICE-ADDRESS.                                     
                                                                        
           MOVE 'Y' TO LINK-ADD-FINAL-ADDR-FL.                          
           MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID.                         
           PERFORM 7700-FORMATTED-ADDRESS THRU 7700-EXIT.               
           MOVE 'A' TO LINK-ADDRESS-FORMAT.                             
           MOVE DY-HOUSE-NO TO LINK-HOUSE-NO.                           
           MOVE DY-ADDR-PREFIX-1 TO LINK-ADDR-PREFIX-1.                 
           MOVE DY-ADDR-PREFIX-2 TO LINK-ADDR-PREFIX-2.                 
           MOVE DY-STREET-NAME TO LINK-STREET-NAME.                     
           MOVE DY-STREET-SUFFIX TO LINK-STREET-SUFFIX.                 
           MOVE DY-ADDR-SUFFIX TO LINK-ADDR-SUFFIX.                     
           MOVE DY-STREET-LOCATION-1 TO LINK-STREET-LOC-1.              
           MOVE DY-STREET-LOCATION-2 TO LINK-STREET-LOC-2.              
           MOVE DY-ZIP-CODE TO LINK-ZIP-CODE.                           
           MOVE DY-ZIP-CODE-PLUS-FOUR TO LINK-ZIP-CODE-PLUS-4.          
           MOVE A4-TOWN TO LINK-TOWN.                                   
           MOVE A4-STATE TO LINK-STATE.                                 
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5300-COMPARE-ADDRESSES.                                          
                                                                        
           MOVE AT-ADDRESS-ID TO DY-ADDRESS-ID.                         
           PERFORM 7700-FORMATTED-ADDRESS THRU 7700-EXIT.               
           IF LINK-HOUSE-NO = DY-HOUSE-NO AND                           
              LINK-ADDR-PREFIX-1 = DY-ADDR-PREFIX-1 AND                 
              LINK-ADDR-PREFIX-2 = DY-ADDR-PREFIX-2 AND                 
              LINK-STREET-NAME = DY-STREET-NAME AND                     
              LINK-STREET-SUFFIX = DY-STREET-SUFFIX AND                 
              LINK-ADDR-SUFFIX = DY-ADDR-SUFFIX AND                     
              LINK-STREET-LOC-1 = DY-STREET-LOCATION-1 AND              
              LINK-STREET-LOC-2 = DY-STREET-LOCATION-2 AND              
              LINK-TOWN = A4-TOWN AND                                   
              LINK-STATE = A4-STATE AND                                 
              LINK-ZIP-CODE = DY-ZIP-CODE                               
                  MOVE 'N' TO LINK-ADD-FINAL-ADDR-FL
           END-IF.                   
                                                                        
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  COMPRESSION ROUTINE TO ELIMINATE SPACES.                  **          
      ****************************************************************          
                                                                        
       6000-REDUCE-EMBEDDED-SPACES.                                     
                                                                        
           MOVE 255 TO WS-EMB-TBL-LENG.                                 
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
           MOVE SPACE TO WS-EMB-LAST-CHAR.                              
           IF WS-EMB-LENG NUMERIC AND                                   
              WS-EMB-LENG > ZERO AND                                    
              WS-EMB-LENG < WS-EMB-TBL-LENG                             
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG TO WS-EMB-LENG
           END-IF.                     
           PERFORM 6010-COMPRESSION-ROUTINE THRU 6010-EXIT              
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX > WS-EMB-LENG.                         
           MOVE ZERO TO WS-EMB-LENG.                                    
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6010-COMPRESSION-ROUTINE.                                        
                                                                        
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE AND                 
              WS-EMB-LAST-CHAR                                          
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                        
                    WS-CMP-CHAR (WS-CMP-INDX)                           
                    WS-EMB-LAST-CHAR                                    
                SET WS-CMP-INDX UP BY 1
           END-IF.                                
                                                                        
       6010-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6700-WRITE-WEB-EVENT.                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-WEB-EVENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-WEB-EVENT-TS = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO.                   
           MOVE 'N' TO WS-DEPOSIT-FL.                                   
           IF LINK-XFER-FL = 'Y'                                        
               MOVE 'Y' TO WS-WAIVER-FL                                 
           ELSE                                                         
               MOVE 'N' TO WS-WAIVER-FL
           END-IF.                                
           MOVE 0.00 TO WS-AMT-DEPOSIT.                                 
           MOVE ZEROES TO WS-ON-ORDER-NO                                
                          WS-OFF-ORDER-NO.                              
                                                                        
           IF LINK-UPDATE-ORDER-FL = 'Y'                                
               MOVE 'STOP' TO WS-WEB-EVENT-TYPE-CD                      
               MOVE WS-HOLD-SERV-ORDER-NO TO WS-OFF-ORDER-NO            
           ELSE                                                         
               IF WS-MISSING-STRT-EVENT = 'Y'                           
                   MOVE 'XFER' TO WS-WEB-EVENT-TYPE-CD                  
                   MOVE NEW-SERV-ORDER-NO-0073 TO WS-OFF-ORDER-NO       
               ELSE                                                     
                   MOVE 'STOP' TO WS-WEB-EVENT-TYPE-CD                  
                   MOVE NEW-SERV-ORDER-NO-0073 TO WS-OFF-ORDER-NO
               END-IF
           END-IF.      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_WEB_EVENT                             
                   (WEB_EVENT_TS,                                       
                    WEB_EVENT_TYPE_CD,                                  
                    ON_ORDER_NO,                                        
                    OFF_ORDER_NO,                                       
                    WAIVER_FL,                                          
                    DEPOSIT_FL,                                         
                    ON_STATE_EMAIL_FL,                                  
                    OFF_STATE_EMAIL_FL,                                 
                    ON_SCHED_EMAIL_FL,                                  
                    OFF_SCHED_EMAIL_FL,                                 
                    ON_PAST_EMAIL_FL,                                   
                    OFF_PAST_EMAIL_FL,                                  
                    CUSTOMER_NO,                                        
                    AMT_DEPOSIT)                                        
               VALUES                                                   
                   ( CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS),                      
                     :WS-WEB-EVENT-TYPE-CD,                             
                     :WS-ON-ORDER-NO,                                   
                     :WS-OFF-ORDER-NO,                                  
                     :WS-WAIVER-FL,                                     
                     :WS-DEPOSIT-FL,                                    
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     :WS-CUSTOMER-NO,                                   
                     :WS-AMT-DEPOSIT)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_WEB_EVENT                                     
MFA-TR*            (WEB_EVENT_TS,                                               
MFA-TR*             WEB_EVENT_TYPE_CD,                                          
MFA-TR*             ON_ORDER_NO,                                                
MFA-TR*             OFF_ORDER_NO,                                               
MFA-TR*             WAIVER_FL,                                                  
MFA-TR*             DEPOSIT_FL,                                                 
MFA-TR*             ON_STATE_EMAIL_FL,                                          
MFA-TR*             OFF_STATE_EMAIL_FL,                                         
MFA-TR*             ON_SCHED_EMAIL_FL,                                          
MFA-TR*             OFF_SCHED_EMAIL_FL,                                         
MFA-TR*             ON_PAST_EMAIL_FL,                                           
MFA-TR*             OFF_PAST_EMAIL_FL,                                          
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             AMT_DEPOSIT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*            ( :WS-WEB-EVENT-TS,                                          
MFA-TR*              :WS-WEB-EVENT-TYPE-CD,                                     
MFA-TR*              :WS-ON-ORDER-NO,                                           
MFA-TR*              :WS-OFF-ORDER-NO,                                          
MFA-TR*              :WS-WAIVER-FL,                                             
MFA-TR*              :WS-DEPOSIT-FL,                                            
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              :WS-CUSTOMER-NO,                                           
MFA-TR*              :WS-AMT-DEPOSIT)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '6700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_WEB_EVENT'   TO TABLE-1                 
                   MOVE 'ON_ORDER_NO'        TO TABLE-ELEMENT-1         
                   MOVE WS-ON-ORDER-NO       TO HOSTVAR-ELEMENT-1       
                   MOVE 'OFF_ORDER_NO'       TO TABLE-ELEMENT-2         
                   MOVE WS-OFF-ORDER-NO      TO HOSTVAR-ELEMENT-2       
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3         
                   MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-3       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       6700-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6800-UPDATE-WEB-EVENT.                                           
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO.                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           WEB_EVENT_TS, 121), ' ', '-'), ':', '.') WEB_EVENT_TS               
                 INTO :WS-WEB-EVENT-TS                                  
                 FROM CSS_SO_WEB_EVENT                                  
                WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                     
                  AND WEB_EVENT_TYPE_CD = 'STRT'                        
                  AND WEB_EVENT_TS > DATEADD( MINUTE, -10, 
           CIS.CURRENT$TIMESTAMP() )     
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WEB_EVENT_TS                                              
MFA-TR*          INTO :WS-WEB-EVENT-TS                                          
MFA-TR*          FROM CSS_SO_WEB_EVENT                                          
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                             
MFA-TR*           AND WEB_EVENT_TYPE_CD = 'STRT'                                
MFA-TR*           AND WEB_EVENT_TS > CURRENT TIMESTAMP - 10 MINUTES             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 6800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO WS-MISSING-STRT-EVENT                    
                   PERFORM 6700-WRITE-WEB-EVENT THRU 6700-EXIT          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '6800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_WEB_EVENT'   TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF LINK-UPDATE-ORDER-FL = 'Y'                                
               MOVE WS-HOLD-SERV-ORDER-NO TO WS-OFF-ORDER-NO            
           ELSE                                                         
               MOVE NEW-SERV-ORDER-NO-0073 TO WS-OFF-ORDER-NO
           END-IF.          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_WEB_EVENT                                  
                  SET WEB_EVENT_TYPE_CD = 'XFER',                       
                      OFF_ORDER_NO = :WS-OFF-ORDER-NO,                  
                      WAIVER_FL    = 'Y'                                
                WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS
              )                   
                  AND CUSTOMER_NO  = :WS-CUSTOMER-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_WEB_EVENT                                          
MFA-TR*           SET WEB_EVENT_TYPE_CD = 'XFER',                               
MFA-TR*               OFF_ORDER_NO = :WS-OFF-ORDER-NO,                          
MFA-TR*               WAIVER_FL    = 'Y'                                        
MFA-TR*         WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                           
MFA-TR*           AND CUSTOMER_NO  = :WS-CUSTOMER-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '6800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_WEB_EVENT'   TO TABLE-1                 
                   MOVE 'WEB_EVENT_TS'       TO TABLE-ELEMENT-1         
                   MOVE WS-WEB-EVENT-TS      TO HOSTVAR-ELEMENT-1       
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2         
                   MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       6800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  COUNT THE NUMBER OF CC001 ORDERS FOR THE PREMISE.  CHECK  **          
      **  FOR AN EXISTING OFF ORDER.                                **          
      ****************************************************************          
                                                                        
       7000-COUNT-ORDERS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-ORDERS                                  
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :VO-PREMISE-NO                   
                  AND ORDER_TYPE_CD  = 'CC001'                          
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-ORDERS                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO     = :VO-PREMISE-NO                           
MFA-TR*           AND ORDER_TYPE_CD  = 'CC001'                                  
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT-ORDERS                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-DUPLICATE-UPDATE                              
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ORDER_TYPE FO WITH(READUNCOMMITTED)                   
                WHERE PREMISE_NO   = :VO-PREMISE-NO                     
                  AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = FO.COMPANY_NO                     
                  AND FO.ORDER_GROUP_CD = 'D'                           
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND VO.ORDER_TYPE_CD = 'OFF01'                        
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-DUPLICATE-UPDATE                                      
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE FO                                         
MFA-TR*         WHERE PREMISE_NO   = :VO-PREMISE-NO                             
MFA-TR*           AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = FO.COMPANY_NO                             
MFA-TR*           AND FO.ORDER_GROUP_CD = 'D'                                   
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND VO.ORDER_TYPE_CD = 'OFF01'                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +050 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE VO-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  SELECT THE EXSTING ORDER AT THE PREMISE IF ONE EXISTS.    **          
      **  SET THE EXISTING ORDER FLAG. PERFORM EDITS.               **          
      ****************************************************************          
                                                                        
       7010-SELECT-ORDER.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO,
              ORDER_TYPE_CD,
              ORDER_STATE_CD,
              ORDER_REASON,
              REPLACE(REPLACE(CONVERT(CHAR(26), ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              ACCOUNT_NO,
              ACCOUNT_NO_PRIOR,
              SERV_ORDER_STATUS,
              REPLACE(REPLACE(CONVERT(CHAR(26), WANTED_BY_DATETIME
           , 121), ' ', '-'), ':', '.') WANTED_BY_DATETIME,
              WORK_AREA_ID                                      
                 INTO :VO-SERV-ORDER-NO,                                
                      :VO-ORDER-TYPE-CD,                                
                      :VO-ORDER-STATE-CD,                               
                      :VO-ORDER-REASON,                                 
                      :VO-ASSIGNED-DATETIME,                            
                      :VO-ACCOUNT-NO,                                   
                      :VO-ACCOUNT-NO-PRIOR,                             
                      :VO-SERV-ORDER-STATUS,                            
                      :VO-WANTED-BY-DATETIME,                           
P00836                :VO-WORK-AREA-ID                                  
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :VO-PREMISE-NO                   
                  AND ORDER_TYPE_CD  = 'CC001'                          
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ORDER_TYPE_CD,                                            
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               ORDER_REASON,                                             
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               ACCOUNT_NO_PRIOR,                                         
MFA-TR*               SERV_ORDER_STATUS,                                        
MFA-TR*               WANTED_BY_DATETIME,                                       
MFA-TR*               WORK_AREA_ID                                              
MFA-TR*          INTO :VO-SERV-ORDER-NO,                                        
MFA-TR*               :VO-ORDER-TYPE-CD,                                        
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-ORDER-REASON,                                         
MFA-TR*               :VO-ASSIGNED-DATETIME,                                    
MFA-TR*               :VO-ACCOUNT-NO,                                           
MFA-TR*               :VO-ACCOUNT-NO-PRIOR,                                     
MFA-TR*               :VO-SERV-ORDER-STATUS,                                    
MFA-TR*               :VO-WANTED-BY-DATETIME,                                   
MFA-TR*               :VO-WORK-AREA-ID                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO     = :VO-PREMISE-NO                           
MFA-TR*           AND ORDER_TYPE_CD  = 'CC001'                                  
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXISTING-ORDER-FL                     
                   IF VO-ORDER-STATE-CD NOT = 'A'                       
                       MOVE +300 TO RS-STATUS-CODE                      
                   END-IF                                               
P00836             IF VO-ORDER-STATE-CD = 'H' AND                       
P00836                VO-WORK-AREA-ID(1:4) = 'AROP'                     
P00836                    MOVE 0 TO RS-STATUS-CODE                      
P00836             END-IF                                               
                   IF LINK-UPDATE-ORDER-FL = 'Y'                        
                       IF VO-ASSIGNED-DATETIME NOT =                    
                          LINK-SCHEDULED-DT                             
                              MOVE +500 TO RS-STATUS-CODE               
                       END-IF                                           
                       IF VO-SERV-ORDER-NO NOT =                        
                          WS-SERV-ORDER-NO-NUM                          
                              MOVE +600 TO RS-STATUS-CODE               
                       END-IF                                           
                       IF VO-ORDER-TYPE-CD NOT =                        
                          LINK-CURR-ORDER-TYPE                          
                              MOVE +700 TO RS-STATUS-CODE               
                       END-IF                                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO VO-ACCOUNT-NO                              
                             VO-SERV-ORDER-NO                           
                   MOVE 'N' TO WS-EXISTING-ORDER-FL                     
                   IF LINK-UPDATE-ORDER-FL = 'Y'                        
                       MOVE +200 TO RS-STATUS-CODE                      
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET PREMISE INFORMATION.                                  **          
      ****************************************************************          
                                                                        
       7100-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COMPANY_NO,
              REV_DISTRICT_CD,
              LOCAL_OFFICE,
              SPCL_INSTRUCTIONS,
              ADDRESS_ID,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST                                
                 INTO :PR-COMPANY-NO,                                   
                      :PR-REV-DISTRICT-CD,                              
                      :PR-LOCAL-OFFICE,                                 
                      :PR-SPCL-INSTRUCTIONS,                            
                      :PR-ADDRESS-ID,                                   
P00718                :PR-FM-ELEC-SVC-WKDIST,                           
P00718                :PR-FM-GAS-OPS-WKDIST,                            
P00718                :PR-FM-FLD-SVCS-WKDIST,                           
P00718                :PR-FM-REV-PRT-WKDIST,                            
P00718                :PR-FM-DSM-ESVC-WKDIST                            
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :PR-PREMISE-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO,                                               
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               SPCL_INSTRUCTIONS,                                        
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*          INTO :PR-COMPANY-NO,                                           
MFA-TR*               :PR-REV-DISTRICT-CD,                                      
MFA-TR*               :PR-LOCAL-OFFICE,                                         
MFA-TR*               :PR-SPCL-INSTRUCTIONS,                                    
MFA-TR*               :PR-ADDRESS-ID,                                           
MFA-TR*               :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST,                                    
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST,                                    
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST                                    
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO     = :PR-PREMISE-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'CSS_REV_DISTRICT' TO TABLE-2                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CURSOR PROCESSING TO READ CSS_APPLIANCE.                  **          
      ****************************************************************          
                                                                        
       7160-OPEN-APP-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN APP_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7160'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_APPLIANCE'         TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE LA-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-CLOSE-APP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE APP_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7170'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_APPLIANCE'         TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE LA-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE RESPONSIBLE AREA FOR THE USERID.  IT WILL BE      **          
      **  PASSED INTO CSR00073 WHEN THE ORDER IS CREATED.           **          
      ****************************************************************          
                                                                        
       7180-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :LINK-ORDER-RECVED-BY                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :LINK-ORDER-RECVED-BY                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7180                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_USER_PROFILE'   TO TABLE-1                 
                   MOVE 'USER_ID'            TO TABLE-ELEMENT-1         
                   MOVE LINK-ORDER-RECVED-BY TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET ACCOUNT INFORMATION.                                  **          
      ****************************************************************          
                                                                        
       7200-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO,
              CODES_DATA_PRESENT,
              ADDRESS_ID,
              ADDRESS_FORMAT                                    
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-CODES-DATA-PRESENT,                           
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               CODES_DATA_PRESENT,                                       
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT                                            
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-CODES-DATA-PRESENT,                                   
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM            
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
                   IF AT-ADDRESS-ID > 0                                 
                       MOVE 'Y' TO WS-BILL-ADDRESS-EXISTS               
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE ZIP CODE TOKEN.                                   **          
      ****************************************************************          
                                                                        
       7400-GET-TOKEN.                                                  
                                                                        
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-2         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET CONTRACT INFORMATION.                                 **          
      ****************************************************************          
                                                                        
       7500-GET-CONTRACT.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :CT-ACCOUNT-NO                                    
                 FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :CT-ACCOUNT-NO                       
                  AND CODE_CONTRACT_TYPE = 'B'                          
                  AND CODE_BILL_TYPE = 'C'                              
                  AND CNT_STATUS_CD = 'B'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :CT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_CONTRACT CT                                           
MFA-TR*         WHERE ACCOUNT_NO = :CT-ACCOUNT-NO                               
MFA-TR*           AND CODE_CONTRACT_TYPE = 'B'                                  
MFA-TR*           AND CODE_BILL_TYPE = 'C'                                      
MFA-TR*           AND CNT_STATUS_CD = 'B'                                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-CONTRACT-FL                           
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-CONTRACT-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_CONTRACT'       TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE CT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET EPAY INFORMATION.                                     **          
      ****************************************************************          
                                                                        
       7600-GET-BANK-EFT.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :BE-ACCOUNT-NO                                    
                 FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                       
                  AND STATUS_CODE IN ('M', 'N', 'O')                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :BE-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_BANK_EFT                                              
MFA-TR*         WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                               
MFA-TR*           AND STATUS_CODE IN ('M', 'N', 'O')                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-BANK-DRAFT-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RS-BANK-DRAFT-FL                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_BANK-EFT'       TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-FORMATTED-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      DY.ZIP_CODE,                                      
                      ZIP_CODE_PLUS_FOUR,                               
                      DY.ZIP_CODE_TOKEN,                                
                      ADDR_USAGE_CD,                                    
                      ADDR_SUFFIX,                                      
                      USPS_DELIV_PT_CD,                                 
                      TOWN,                                             
                      STATE                                             
                 INTO :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-USAGE-CD,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-USPS-DELIV-PT-CD,                             
                      :A4-TOWN,                                         
                      :A4-STATE                                         
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               CARRIER_ROUTE,                                            
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               USPS_DELIV_PT_CD,                                         
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*          INTO :DY-ADDRESS-ID,                                           
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-CARRIER-ROUTE,                                        
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-USPS-DELIV-PT-CD,                                     
MFA-TR*               :A4-TOWN,                                                 
MFA-TR*               :A4-STATE                                                 
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4                                           
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO LINK-ADD-FINAL-ADDR-FL                   
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                              DCLCSS-ZIP-CODE                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  ORDER REASON OF EXISTING CC MUST BE FORCED.  FINAL BILL   **          
      **  ADDRESS CANNOT ALREADY EXIST.                             **          
      ****************************************************************          
                                                                        
       7800-EXISTING-ORDER-EDITS.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-DUPLICATE-UPDATE                              
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO       = :PR-PREMISE-NO                 
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD = 'CC001'                           
                  AND ORDER_REASON IN (' ', 'R', 'B')                   
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-DUPLICATE-UPDATE                                      
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO       = :PR-PREMISE-NO                         
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*           AND ORDER_REASON IN (' ', 'R', 'B')                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 78001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +025 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-DUPLICATE-UPDATE                              
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_FINAL_BILL XD WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO   = :PR-PREMISE-NO                     
                  AND VO.SERV_ORDER_NO = XD.SERV_ORDER_NO               
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD = 'CC001'                           
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-DUPLICATE-UPDATE                                      
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_FINAL_BILL XD                                      
MFA-TR*         WHERE PREMISE_NO   = :PR-PREMISE-NO                             
MFA-TR*           AND VO.SERV_ORDER_NO = XD.SERV_ORDER_NO                       
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 78002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +075 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE PR-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00196 7810-ORDER-PRIORITY.                                             
P00196                                                                  
P00196     EXEC SQL                                                     
P00196         SELECT PRIORITY_CD                                       
P00196           INTO :OY-PRIORITY-CD                                   
P00196           FROM CSS_ORDER_PRIORITY WITH(READUNCOMMITTED)                  
P00196          WHERE PRIORITY_DESC = :OY-PRIORITY-DESC                 
P00196                                                           
P00196                                                     
P00196     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRIORITY_CD                                               
MFA-TR*          INTO :OY-PRIORITY-CD                                           
MFA-TR*          FROM CSS_ORDER_PRIORITY                                        
MFA-TR*         WHERE PRIORITY_DESC = :OY-PRIORITY-DESC                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7810                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00196                                                                  
P00196     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00196                                                                  
P00196     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00196         WHEN SUCCESSFUL-CALL                                     
P00196             CONTINUE                                             
P00196         WHEN NOT-FOUND                                           
P00196             MOVE 7 TO OY-PRIORITY-CD                             
P00196         WHEN OTHER                                               
P00196             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00196             MOVE '7810'           TO ACTIVE-PARAGRAPH            
P00196             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00196             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00196                                           ABEND-TABLES           
P00196             MOVE 'CSS_ORDER_PRIORITY' TO TABLE-1                 
P00196             MOVE OY-PRIORITY-DESC     TO HOSTVAR-ELEMENT-1       
P00196             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00196             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00196     END-EVALUATE.                                                
P00196                                                                  
P00196 7810-EXIT.                                                       
P00196     EXIT.                                                        
                                                                        
P00718 7900-GET-PRINT-LOC.                                              
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT CAD_WORKAREA_FL                                   
P00718           INTO :C4-CAD-WORKAREA-FL                               
P00718           FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
P00718          WHERE WORK_AREA_ID = :LINK-WORK-AREA                    
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CAD_WORKAREA_FL                                           
MFA-TR*          INTO :C4-CAD-WORKAREA-FL                                       
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID = :LINK-WORK-AREA                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN NOT-FOUND                                           
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7900'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_SO_PRINT_LOC' TO TABLE-1                   
P00718             MOVE LINK-WORK-AREA       TO HOSTVAR-ELEMENT-1       
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7900-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718 7905-GET-REGISTER-DTLS.                                          
P00718                                                                  
P00718     EXEC SQL                                                     
P00718        SELECT TOP(1) 'Y'                                                
P00718          INTO :WS-MULTI-REG-MTR                                  
P00718          FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED),                
P00718               CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
P00718         WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO               
P00718           AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                
P00718           AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE            
P00718           AND MN.METER_NO         = RG.METER_NO                  
P00718           AND MN.IC_NO            = RG.IC_NO                     
P00718           AND MN.MTR_REF_NO       = RG.MTR_REF_NO                
P00718                                            
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MULTI-REG-MTR                                          
MFA-TR*         FROM CSS_REGISTER_READ RG,                                      
MFA-TR*              CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO                       
MFA-TR*          AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                        
MFA-TR*          AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE                    
MFA-TR*          AND MN.METER_NO         = RG.METER_NO                          
MFA-TR*          AND MN.IC_NO            = RG.IC_NO                             
MFA-TR*          AND MN.MTR_REF_NO       = RG.MTR_REF_NO                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7905                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN -811                                                
P00718             CONTINUE                                             
P00718         WHEN NOT-FOUND                                           
P00718             MOVE 'N'              TO WS-MULTI-REG-MTR            
P00718             MOVE 0                TO WS-ACTIVE-RETURN-CODE       
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7905'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
P00718             MOVE RG-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7905-EXIT.                                                       
P00718     EXIT.                                                        
      ****************************************************************          
      **  INSERT A LIGHTING REQUIREMENT.                            **          
      ****************************************************************          
                                                                        
       8100-INSERT-LIGHT-RQMT.                                          
                                                                        
           MOVE NEW-SERV-ORDER-NO-0073 TO EG-SERV-ORDER-NO.             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REQUIREMENT                           
                   (SERV_ORDER_NO,                                      
                    REQUIREMENT_CD,                                     
                    RESOURCE_CD,                                        
                    REQMNT_STAGE_CD,                                    
                    SERV_ORDER_STATUS)                                  
               VALUES                                                   
                   ( :EG-SERV-ORDER-NO,                                 
                     '2',                                               
                     '0',                                               
                     'R',                                               
                     '40')                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EG-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05189****************************************************************          
A05189**  INSERT REMARKS.                                           **          
A05189****************************************************************          
A05189                                                                  
A05189 8200-INSERT-REMARKS.                                             
A05189                                                                  
A05189     EXEC SQL                                                     
A05189         INSERT INTO CSS_SO_REMARKS                               
A05189             (SERV_ORDER_NO,                                      
A05189              REMARK_TYPE_CD,                                     
A05189              REMARK_DATETIME,                                    
A05189              CHANGED_BY_USER_ID,                                 
A05189              REMARK_TX)                                          
A05189         VALUES                                                   
A05189             ( :EF-SERV-ORDER-NO,                                 
A05189               :EF-REMARK-TYPE-CD,                                
A05189               CIS.CURRENT$TIMESTAMP(),                                 
A05189               :EF-CHANGED-BY-USER-ID,                            
A05189               :EF-REMARK-TX)                                     
A05189     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REMARKS                                       
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             REMARK_TYPE_CD,                                             
MFA-TR*             REMARK_DATETIME,                                            
MFA-TR*             CHANGED_BY_USER_ID,                                         
MFA-TR*             REMARK_TX)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*            ( :EF-SERV-ORDER-NO,                                         
MFA-TR*              :EF-REMARK-TYPE-CD,                                        
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :EF-CHANGED-BY-USER-ID,                                    
MFA-TR*              :EF-REMARK-TX)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05189                                                                  
A05189     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05189         WHEN SUCCESSFUL-CALL                                     
A05189             CONTINUE                                             
A05189         WHEN OTHER                                               
A05189             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A05189             MOVE '8200'           TO ACTIVE-PARAGRAPH            
A05189             MOVE 'INSERT'         TO ABEND-FUNCTION              
A05189             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A05189                                           ABEND-TABLES           
A05189             MOVE 'CSS_SO_REMARKS'     TO TABLE-1                 
A05189             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A05189             MOVE EF-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A05189             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05189             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05189     END-EVALUATE.                                                
A05189                                                                  
A05189 8200-EXIT.                                                       
A05189     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE THE PREMISE RECORD.                                **          
      ****************************************************************          
                                                                        
       8300-UPDATE-PREMISE.                                             
                                                                        
           MOVE LINK-SCHEDULED-DT TO PR-PEND-OFF-ORD-DT.                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET SERV_ORDER_PEND = 'Y',                            
                      PEND_OFF_ORD_DT = IIF(TRY_CONVERT(DATE, 
                                                    :PR-PEND-OFF-ORD-DT
              ) IS NULL OR (PATINDEX('%.%', :PR-PEND-OFF-ORD-DT
              ) <> 0) OR (LEN(:PR-PEND-OFF-ORD-DT
              ) <> 10), CIS.CHAR2DATE(:PR-PEND-OFF-ORD-DT
              ), CONVERT(DATE, :PR-PEND-OFF-ORD-DT) )             
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET SERV_ORDER_PEND = 'Y',                                    
MFA-TR*               PEND_OFF_ORD_DT = :PR-PEND-OFF-ORD-DT                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'        TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04670****************************************************************          
A04670**  UPDATE SOURCE SYSTEM.                                     **          
A04670****************************************************************          
A04670                                                                  
A04670 8450-UPDATE-SOURCE-SYSTEM.                                       
A04670                                                                  
A04670     MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
A04670                                                                  
A04670     EXEC SQL                                                     
A04670         UPDATE CSS_SO_DATA                                       
A04670            SET SOURCE_SYSTEM_CD = 'WEB',                         
P00836                MTR_ACCESSIBLE_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ),             
P00836                MTR_ACCESSIBLE_CD = 'Y',                          
P00836                MTR_ACCESSIBLE_RSN = 'Y'                          
A04670          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A04670                                                      
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET SOURCE_SYSTEM_CD = 'WEB',                                 
MFA-TR*               MTR_ACCESSIBLE_DT = :WS-CURRENT-DATE,                     
MFA-TR*               MTR_ACCESSIBLE_CD = 'Y',                                  
MFA-TR*               MTR_ACCESSIBLE_RSN = 'Y'                                  
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*        QUERYNO 8450                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04670                                                                  
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             CONTINUE                                             
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A04670             MOVE '8450'           TO ACTIVE-PARAGRAPH            
A04670             MOVE 'UPDATE'         TO ABEND-FUNCTION              
A04670             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A04670                                           ABEND-TABLES           
A04670             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
A04670             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A04670             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A04670             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A04670             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A04670     END-EVALUATE.                                                
A04670                                                                  
A04670 8450-EXIT.                                                       
A04670     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE PREMISE SPECIAL INSTRUCTIONS.                      **          
      ****************************************************************          
                                                                        
       8500-UPDATE-INSTRUCTIONS.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET SPCL_INSTRUCTIONS = :PR-SPCL-INSTRUCTIONS         
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'        TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE ORDER REASON TO SPACES.                            **          
      ****************************************************************          
                                                                        
       8600-UPDATE-ORDER-REASON.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ORDER_REASON = '               '                  
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE AN AUDIT ROW.                                      **          
      ****************************************************************          
                                                                        
       8700-INSERT-AUDIT-ROW.                                           
                                                                        
           MOVE LINK-ORDER-RECVED-BY TO VW-USER-ID-UPDT-BY.             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                   (SERV_ORDER_NO,                                      
                    USER_ID_UPDT_BY,                                    
                    UPDATE_DATETIME,                                    
                    PANEL_NO,                                           
                    ASSIGNED_DATETIME,                                  
                    ORDER_TYPE_CD,                                      
                    SERV_ORDER_STATUS,                                  
                    ORDER_STATE_CD,                                     
                    WANTED_BY_DATETIME)                                 
               VALUES                                                   
                   (:VO-SERV-ORDER-NO,                                  
                    :VW-USER-ID-UPDT-BY,                                
                    CIS.CURRENT$TIMESTAMP(),                                  
                    :VW-PANEL-NO,                                       
                    CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME),                  
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-SERV-ORDER-STATUS,                              
                    :VO-ORDER-STATE-CD,                                 
                    CIS.CHAR2TIMESTAMP(:VO-WANTED-BY-DATETIME))                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             USER_ID_UPDT_BY,                                            
MFA-TR*             UPDATE_DATETIME,                                            
MFA-TR*             PANEL_NO,                                                   
MFA-TR*             ASSIGNED_DATETIME,                                          
MFA-TR*             ORDER_TYPE_CD,                                              
MFA-TR*             SERV_ORDER_STATUS,                                          
MFA-TR*             ORDER_STATE_CD,                                             
MFA-TR*             WANTED_BY_DATETIME)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (:VO-SERV-ORDER-NO,                                          
MFA-TR*             :VW-USER-ID-UPDT-BY,                                        
MFA-TR*             CURRENT TIMESTAMP,                                          
MFA-TR*             :VW-PANEL-NO,                                               
MFA-TR*             :VO-ASSIGNED-DATETIME,                                      
MFA-TR*             :VO-ORDER-TYPE-CD,                                          
MFA-TR*             :VO-SERV-ORDER-STATUS,                                      
MFA-TR*             :VO-ORDER-STATE-CD,                                         
MFA-TR*             :VO-WANTED-BY-DATETIME)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_UPDATE'      TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  INSERT A TURNOFF ROW.                                     **          
      ****************************************************************          
                                                                        
       8800-INSERT-TURNOFF.                                             
                                                                        
           MOVE AT-ACCOUNT-NO TO YT-ACCOUNT-NO.                         
           MOVE NEW-SERV-ORDER-NO-0073 TO YT-SERV-ORDER-NO.             
           MOVE 'G' TO YT-CODE-UTIL-TYPE.                               
           MOVE 'R' TO YT-ACCOUNT-TYPE-CODE.                            
           MOVE LINK-TURNOFF-REASON-CD TO YT-MTR-TURNOFF-RSN-CD.        
           MOVE LINK-FUEL-CHG-REASON-CD TO YT-FUEL-CHNG-RSN-CD.         
           MOVE LINK-FUEL-CHG-TYPE-CD TO YT-FUEL-CHNG-TYPE-CD.          
           MOVE 'N' TO YT-CLOTHES-DRYER-FL                              
                       YT-WATER-HEAT-FL                                 
                       YT-COOKING-EQUIP-FL                              
                       YT-HEATING-EQUIP-FL                              
                       YT-FIREPLACE-EQUIP-FL                            
                       YT-PROCESSNG-EQUIP-FL                            
                       YT-OTHER-EQUIP-FL.                               
           MOVE LINK-ORDER-RECVED-BY TO YT-CREATED-BY-USERID.           
           IF LINK-TURNOFF-COMMENTS > SPACES                            
               MOVE LINK-TURNOFF-COMMENTS TO YT-COMMENTS-TEXT           
               MOVE 255 TO YT-COMMENTS-LEN                              
           ELSE                                                         
               MOVE SPACES TO YT-COMMENTS-TEXT                          
               MOVE 0 TO YT-COMMENTS-LEN
           END-IF.                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_METER_TURNOFF                             
                         (ACCOUNT_NO                                    
                         ,SERV_ORDER_NO                                 
                         ,CODE_UTIL_TYPE                                
                         ,ACCOUNT_TYPE_CODE                             
                         ,MTR_TURNOFF_RSN_CD                            
                         ,FUEL_CHNG_RSN_CD                              
                         ,FUEL_CHNG_TYPE_CD                             
                         ,CLOTHES_DRYER_FL                              
                         ,WATER_HEAT_FL                                 
                         ,COOKING_EQUIP_FL                              
                         ,HEATING_EQUIP_FL                              
                         ,FIREPLACE_EQUIP_FL                            
                         ,PROCESSNG_EQUIP_FL                            
                         ,OTHER_EQUIP_FL                                
                         ,CREATED_TS                                    
                         ,CREATED_BY_USERID                             
                         ,COMMENTS)                                     
                     VALUES                                             
                         (:YT-ACCOUNT-NO                                
                         ,:YT-SERV-ORDER-NO                             
                         ,:YT-CODE-UTIL-TYPE                            
                         ,:YT-ACCOUNT-TYPE-CODE                         
                         ,:YT-MTR-TURNOFF-RSN-CD                        
                         ,:YT-FUEL-CHNG-RSN-CD                          
                         ,:YT-FUEL-CHNG-TYPE-CD                         
                         ,:YT-CLOTHES-DRYER-FL                          
                         ,:YT-WATER-HEAT-FL                             
                         ,:YT-COOKING-EQUIP-FL                          
                         ,:YT-HEATING-EQUIP-FL                          
                         ,:YT-FIREPLACE-EQUIP-FL                        
                         ,:YT-PROCESSNG-EQUIP-FL                        
                         ,:YT-OTHER-EQUIP-FL                            
                         ,CIS.CURRENT$TIMESTAMP()                             
                         ,:YT-CREATED-BY-USERID                         
                         ,:YT-COMMENTS)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_METER_TURNOFF                                     
MFA-TR*                  (ACCOUNT_NO                                            
MFA-TR*                  ,SERV_ORDER_NO                                         
MFA-TR*                  ,CODE_UTIL_TYPE                                        
MFA-TR*                  ,ACCOUNT_TYPE_CODE                                     
MFA-TR*                  ,MTR_TURNOFF_RSN_CD                                    
MFA-TR*                  ,FUEL_CHNG_RSN_CD                                      
MFA-TR*                  ,FUEL_CHNG_TYPE_CD                                     
MFA-TR*                  ,CLOTHES_DRYER_FL                                      
MFA-TR*                  ,WATER_HEAT_FL                                         
MFA-TR*                  ,COOKING_EQUIP_FL                                      
MFA-TR*                  ,HEATING_EQUIP_FL                                      
MFA-TR*                  ,FIREPLACE_EQUIP_FL                                    
MFA-TR*                  ,PROCESSNG_EQUIP_FL                                    
MFA-TR*                  ,OTHER_EQUIP_FL                                        
MFA-TR*                  ,CREATED_TS                                            
MFA-TR*                  ,CREATED_BY_USERID                                     
MFA-TR*                  ,COMMENTS)                                             
MFA-TR*              VALUES                                                     
MFA-TR*                  (:YT-ACCOUNT-NO                                        
MFA-TR*                  ,:YT-SERV-ORDER-NO                                     
MFA-TR*                  ,:YT-CODE-UTIL-TYPE                                    
MFA-TR*                  ,:YT-ACCOUNT-TYPE-CODE                                 
MFA-TR*                  ,:YT-MTR-TURNOFF-RSN-CD                                
MFA-TR*                  ,:YT-FUEL-CHNG-RSN-CD                                  
MFA-TR*                  ,:YT-FUEL-CHNG-TYPE-CD                                 
MFA-TR*                  ,:YT-CLOTHES-DRYER-FL                                  
MFA-TR*                  ,:YT-WATER-HEAT-FL                                     
MFA-TR*                  ,:YT-COOKING-EQUIP-FL                                  
MFA-TR*                  ,:YT-HEATING-EQUIP-FL                                  
MFA-TR*                  ,:YT-FIREPLACE-EQUIP-FL                                
MFA-TR*                  ,:YT-PROCESSNG-EQUIP-FL                                
MFA-TR*                  ,:YT-OTHER-EQUIP-FL                                    
MFA-TR*                  ,CURRENT TIMESTAMP                                     
MFA-TR*                  ,:YT-CREATED-BY-USERID                                 
MFA-TR*                  ,:YT-COMMENTS)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_METER_TURNOFF'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE YT-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01648****************************************************************          
A01648**  UPDATE CODES_DATA_PRESENT FOR FB ADDRESSES                **          
A01648****************************************************************          
A01648                                                                  
A01648 8850-UPDATE-CDP.                                                 
A01648                                                                  
A01648     IF LINK-UPDATE-ORDER-FL = 'Y'                                
A01648         NEXT SENTENCE                                            
A01648     ELSE                                                         
A01648         MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO
           END-IF.         
A01648                                                                  
A01648     EXEC SQL                                                     
A01648         UPDATE CSS_SO_DATA                                       
A01648            SET CODES_DATA_PRESENT =                              
A01648               (CIS.SUBSTR3(CODES_DATA_PRESENT,1,5) + 'A' + 
           CIS.SUBSTR3(CODES_DATA_PRESENT,7,29))                  
A01648          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A01648     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT =                                      
MFA-TR*              (SUBSTR(CODES_DATA_PRESENT,1,5) || 'A' ||                  
MFA-TR*               SUBSTR(CODES_DATA_PRESENT,7,29))                          
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01648                                                                  
A01648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01648                                                                  
A01648     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01648         WHEN SUCCESSFUL-CALL                                     
A01648             CONTINUE                                             
A01648         WHEN OTHER                                               
A01648             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A01648             MOVE '8850'           TO ACTIVE-PARAGRAPH            
A01648             MOVE 'UPDATE'         TO ABEND-FUNCTION              
A01648             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A01648                                           ABEND-TABLES           
A01648             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
A01648             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A01648             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A01648             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01648             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01648     END-EVALUATE.                                                
A01648                                                                  
A01648 8850-EXIT.                                                       
A01648     EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
