       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04105.                                          
COB303 DATE-WRITTEN.      FEBRUARY 25, 2008.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS AND INSERTS A CC ORDER FROM THE WEB.      *        
      *  STATUS CODE VALUES ARE:                                       *        
      *       150     MULTIPLE OFF/CC ORDERS EXIST AT PREMISE          *        
      *       200     NO CC/OFF ORDER EXISTS BUT WEB SAYS IT DOES      *        
      *       300     EXISTING ORDER STATE IS NOT ACTIVE               *        
      *       400     ORDER REASON FOR CC001 IS NOT REVERT             *        
      *       500     SCHEDULED DATE HAS CHANGED                       *        
      *       600     ORDER NUMBER IS DIFFERENT THAN PASSED FROM WEB   *        
      *       700     ORDER TYPE IS DIFFERENT THAN PASSED FROM WEB     *        
      *       800     REVERT WITH EXISTING OFF OR CC ORDER             *        
      *       970     ORDER SHOULD SPLIT                               *        
      *  WORKING STORAGE TABLES:                                       *        
      *       T2      METER DATA FROM EXSTING ORDER                    *        
      *       T3      SNAPSHOT DATA FROM THE ACCOUNT                   *        
      *       T4      APPLIANCE DATA FROM CSS_SO_APPLIANCE             *        
      *       T5      APPLIANCE DATA FROM CSS_APPLIANCE                *        
      *  SO REMARKS TYPES:                                             *        
      *       E       CHANGE LOG REMARKS                               *        
      *       G       SERVICE ORDER REMARKS                            *        
      *       H       HOLD REMARKS                                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/25/08    FMB      NEW PROGRAM.                                      
A01648*  09/03/09    FMB      SET CODES_DATA_PRESENT FOR FINAL BILL             
A01648*                       ADDRESSES.                                        
A01114*  09/08/09    FMB      SET 12TH POSITION OF CODES_DATA_PRESENT           
A01114*                       WHEN UNBLOCKING GAS WITH NO SEASONAL APP.         
P00196*  12/21/09    FMB      READ CSS_ORDER_PRIORITY INSTEAD OF                
P00196*                       HARDCODING PRIORITY.                              
A01798*  03/02/10    FMB      ALWAYS RETURN CHARGE AMOUNT.                      
P00390*  05/10/10    FMB      TWO NEW FIELDS IN CSR02210 RESULTS SET.           
P00465*  05/23/11    FMB      NEW INPUT COLUMN FOR E-WELCOME KIT.               
A04336*  09/04/12    FMB      CHECK FOR EXISTING CC002.                         
A04670*  08/05/13    FMB      UPDATE SOURCE SYSTEM CODE.                        
P00718*  02/20/14    VV       NEW PARM FOR BUSINESS UNIT FOR CSR00073           
P00718*  04/02/14    VV       NEW PARM FOR OPTIMIZE ORDER FOR CSR00073          
P00817*  11/07/14    VV       COMMENT LIGHTING CONTRACT WQ                      
P00795*  12/16/15    DB18339  ADDED TRANSFER_FL FROM CSR02146.                  
A05189*  02/24/15    FMB      CREATE AROP ORDERS ON HOLD WITH REMARKS.          
A05189*                       PAYMENT REQUIRED AND AROP STATES ARE              
A05189*                       MUTUALLY EXCLUSIVE.                               
P00795*  03/30/15    DB18339  ADDED CONTRACT NAME DESC FROM CSR02146.           
D06358*  04/20/15    FMB      TRANSFER CONTRACT ONLY IF XFER FLAG = Y.          
A05189*  08/13/15    FMB      CALL CSR04747 TO CANCEL CLICK WHEN OFF            
A05189*                       UPDATED TO CC.                                    
A05317*  03/15/16    FMB      INCREASE CSR02210 SUBSCRIPT.                      
A05317*  06/21/16    FMB      CORRECT DUPLICATE CURSOR NAME.                    
P00836*  07/07/16    FMB      GENERATE WQ IF CUSTOMER DOES NOT PROVIDE          
P00836*                       EITHER NAME OR METER NUMBER. POPULATE NEW         
P00836*                       COLUMNS.                                          
P01176*  10/06/16    FMB      GAS SAMPLE TEST.                                  
ACT233*  10/20/16   TP7R341   REPLACE CSR00028 WITH CSR04675           *00290000
ACT233*   A05460                                                       *00290000
A05317*  01/27/17    FMB      REPLACE CSR02040 WITH CSR04291                    
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04105'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04105 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORWT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOEQP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPLCON                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPRMRL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRLSED                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOREQ                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSRVCHG                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOXAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOSPOR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOWEB                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
A01114     EXEC SQL                                                             
A01114        INCLUDE TBLOCOFC                                                  
A01114     END-EXEC.                                                            
                                                                        
A01114     EXEC SQL                                                             
A01114        INCLUDE TBWKAR                                                    
A01114     END-EXEC.                                                            
                                                                        
P00196     EXEC SQL                                                             
P00196        INCLUDE TBORDPRI                                                  
P00196     END-EXEC.                                                            
                                                                        
P00465     EXEC SQL                                                             
P00465        INCLUDE TBCUST                                                    
P00465     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBSOLOC                                                   
P00718     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBRGREAD                                                  
P00718     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBMTRENV                                                  
P00718     END-EXEC.                                                            
                                                                        
P00836     EXEC SQL                                                             
P00836        INCLUDE TBCSTEML                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836     EXEC SQL                                                             
P00836        INCLUDE TBNAME                                                    
P00836     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04105_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-SERV-ORDER-NO        PIC X(13) VALUE SPACES.          
      *    05  RS-CHARGE-AMT           PIC S9(7)V99 COMP-3 VALUE 0.0.           
           05  RS-CHARGE-AMT           PIC X(09) VALUE SPACES.          
           05  RS-NEW-ACCOUNT-NO       PIC X(13) VALUE SPACES.          
           05  RS-GAS-APPL-FL          PIC X(01) VALUE SPACES.          
           05  RS-GAS-MTR-FL           PIC X(01) VALUE SPACES.          
           05  RS-ELEC-RLSE-REQ-FL     PIC X(01) VALUE SPACES.          
           05  RS-ELEC-MESSAGE         PIC X(05) VALUE SPACES.          
           05  RS-ELEC-ADTL-MESSAGE    PIC X(05) VALUE SPACES.          
           05  RS-ELEC-PHONE           PIC X(12) VALUE SPACES.          
           05  RS-ELEC-ALT-PHONE       PIC X(12) VALUE SPACES.          
           05  RS-ELEC-REV-DIST-DESC   PIC X(25) VALUE SPACES.          
           05  RS-GAS-RLSE-REQ-FL      PIC X(01) VALUE SPACES.          
           05  RS-GAS-MESSAGE          PIC X(05) VALUE SPACES.          
           05  RS-GAS-ADTL-MESSAGE     PIC X(05) VALUE SPACES.          
           05  RS-GAS-PHONE            PIC X(12) VALUE SPACES.          
           05  RS-GAS-ALT-PHONE        PIC X(12) VALUE SPACES.          
           05  RS-GAS-REV-DIST-DESC    PIC X(25) VALUE SPACES.          
           05  RS-SERVICE-CHG-FL       PIC X(01) VALUE SPACES.          
           05  RS-ORDER-STATE-CD       PIC X(01) VALUE SPACES.          
P00718     05  RS-WORK-DISTRICT        PIC X(40) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
      *    05  S-CHARGE-AMT           PIC S9(7)V99 COMP-3 VALUE 0.0.            
           05  S-CHARGE-AMT           PIC X(09) VALUE SPACES.           
           05  S-NEW-ACCOUNT-NO       PIC X(13) VALUE SPACES.           
           05  S-GAS-APPL-FL          PIC X(01) VALUE SPACES.           
           05  S-GAS-MTR-FL           PIC X(01) VALUE SPACES.           
           05  S-ELEC-RLSE-REQ-FL     PIC X(01) VALUE SPACES.           
           05  S-ELEC-MESSAGE         PIC X(05) VALUE SPACES.           
           05  S-ELEC-ADTL-MESSAGE    PIC X(05) VALUE SPACES.           
           05  S-ELEC-PHONE           PIC X(12) VALUE SPACES.           
           05  S-ELEC-ALT-PHONE       PIC X(12) VALUE SPACES.           
           05  S-ELEC-REV-DIST-DESC   PIC X(25) VALUE SPACES.           
           05  S-GAS-RLSE-REQ-FL      PIC X(01) VALUE SPACES.           
           05  S-GAS-MESSAGE          PIC X(05) VALUE SPACES.           
           05  S-GAS-ADTL-MESSAGE     PIC X(05) VALUE SPACES.           
           05  S-GAS-PHONE            PIC X(12) VALUE SPACES.           
           05  S-GAS-ALT-PHONE        PIC X(12) VALUE SPACES.           
           05  S-GAS-REV-DIST-DESC    PIC X(25) VALUE SPACES.           
           05  S-SERVICE-CHG-FL       PIC X(01) VALUE SPACES.           
           05  S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.           
P00718     05  S-WORK-DISTRICT        PIC X(40) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-NUM        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       REDEFINES WS-PREMISE-NO-NUM     
                                        PIC X(10).                      
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-ACCOUNT-XFER-CHAR     PIC X(13).                      
           05  WS-ACCOUNT-XFER-NUM      REDEFINES WS-ACCOUNT-XFER-CHAR  
                                        PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    PIC X(13).                      
           05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO-CHAR 
                                        PIC 9(13).                      
           05  WS-IC-NO-NUM             PIC 9(04).                      
           05  WS-IC-NO-CHAR            REDEFINES WS-IC-NO-NUM          
                                        PIC X(04).                      
           05  WS-MTR-REF-NO-NUM        PIC 9(04).                      
           05  WS-MTR-REF-NO-CHAR       REDEFINES WS-MTR-REF-NO-NUM     
                                        PIC X(04).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-DATE-USA      PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04105'.     
           05  WS-NULL-RLSE-DT          PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-APPT-DT          PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-ACCESS-DT        PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-EQUIP-OWNER      PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IMPROPER-REASON  PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-INSTALL-DT       PIC S9(04) COMP VALUE ZERO.     
           05  WS-ACCT-WK-TYPE-FL       PIC X(01) VALUE SPACES.         
           05  WS-EXISTING-ORDER-FL     PIC X(01) VALUE SPACES.         
           05  WS-NEW-ORDER-FL          PIC X(01) VALUE SPACES.         
           05  WS-COUNT-ORDERS          PIC S9(4) COMP VALUE 0.         
           05  WS-ORDER-TYPE-CD         PIC X(05) VALUE SPACES.         
           05  WS-ORDER-REASON          PIC X(01) VALUE SPACES.         
           05  WS-WORK-TYPE-CD          PIC X(03) VALUE SPACES.         
           05  WS-WORK-TYPE-CD-E        PIC X(03) VALUE SPACES.         
           05  WS-WORK-TYPE-CD-G        PIC X(03) VALUE SPACES.         
           05  WS-UNBLOCK-GAS-FL        PIC X(01) VALUE SPACES.         
           05  WS-UNBLOCK-METER-FL      PIC X(01) VALUE SPACES.         
           05  WS-APPLIANCE-FL          PIC X(01) VALUE SPACES.         
           05  WS-READ-GAS-MTR-FL       PIC X(01) VALUE SPACES.         
           05  WS-HOLD-STATE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ACTIVE-STATE-FL       PIC X(01) VALUE 'N'.            
           05  WS-ORDER-ON-HOLD-FL      PIC X(01) VALUE 'N'.            
           05  WS-SPLIT-ORDER-FL        PIC X(01) VALUE 'N'.            
P00718     05  WS-MULTI-REG-MTR         PIC X(01) VALUE 'N'.            
           05  WS-CHANGE-LOG-REMARKS    PIC X(100) VALUE SPACES.        
           05  WS-SO-REMARKS            PIC X(255) VALUE SPACES.        
           05  WS-MISMATCH-COMMENTS     PIC X(47) VALUE SPACES.         
           05  WS-METER-SUPPLYING       PIC X(15) VALUE SPACES.         
           05  WS-PRIORITY              PIC S9(4) COMP VALUE 0.         
           05  WS-II-CTR                PIC S9(4) COMP VALUE 0.         
           05  WS-II-MCTR               PIC S9(4) COMP VALUE 0.         
           05  WS-SS-CTR                PIC S9(4) COMP VALUE 0.         
           05  WS-LIGHTING-CONTRACT-FL  PIC X(01) VALUE SPACES.         
           05  WS-BUILDER-LIGHTING-FL   PIC X(01) VALUE SPACES.         
           05  WS-MORE-ROWS             PIC X(01) VALUE SPACES.         
           05  WS-T2-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-T3-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-T4-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-T5-ROWCOUNT           PIC S9(4) COMP VALUE 0.         
           05  WS-NO-OF-DAYS-LITE       PIC S9(4) COMP VALUE 0.         
           05  WS-NO-OF-DAYS-DEP        PIC S9(4) COMP VALUE 0.         
           05  WS-UTIL-ENV-EXISTS       PIC X(01) VALUE SPACES.         
           05  WS-ORDER-INST-EXISTS     PIC X(01) VALUE SPACES.         
           05  WS-EQUIPMENT-EXISTS      PIC X(01) VALUE SPACES.         
           05  WS-INCLUDE-INST          PIC X(01) VALUE SPACES.         
           05  WS-LINK-SCHEDULED-DT     PIC X(10) VALUE SPACES.         
           05  WS-PLAN-START-DATE       PIC X(10) VALUE SPACES.         
           05  WS-RELEASE-REQUIRED      PIC X(01) VALUE SPACES.         
           05  WS-WQ-COMMENTS.                                          
               10  F                    PIC X(6) VALUE 'ORDER '.        
               10  WS-WQ-SERV-ORDER-NO  PIC 9(13).                      
               10  F                    PIC X(10) VALUE ', RELEASE '.   
               10  WS-WQ-RELEASE-NO     PIC X(10).                      
               10  F                    PIC X(33) VALUE                 
               ' EXISTS FOR THIS PREMISE, UNABLE '.                     
               10  F                    PIC X(48) VALUE                 
               'TO MATCH RELEASE WITH SERVICE ORDER CRITERIA. '.        
           05  WS-WQ-COMMENTS-2.                                        
               10  F                    PIC X(23) VALUE                 
               'CURRENT CUSTOMER NAME: '.                               
               10  WS-WQ-CUST-NAME      PIC X(76).                      
               10  F                    PIC X(23) VALUE                 
               ' , NEW CUSTOMER EMAIL: '.                               
               10  WS-WQ-EMAIL-ADDRESS  PIC X(100).                     
P00817*    05  WS-WQ-COMMENTS-1         PIC X(115) VALUE                        
P00817*    'THIS CUSTOMER IS FINAL BILLING AND REMOVING THE LIGHTS. PLEA        
P00817*-    'SE REVIEW/ENTER CONTRACT CHARGES FOR LIGHTING.'.                   
           05  WS-SPLIT-COMMENTS        PIC X(73) VALUE                 
           'REQUEST INCOMPLETE-CUST TOLD TO CALL//ORDER WOULD NEED TO SP        
      -    'LIT.'.                                                              
           05  WS-DEPOSIT-AMT-NUM       PIC 9(7)V99.                    
           05  WS-DEPOSIT-AMT-CHAR      REDEFINES WS-DEPOSIT-AMT-NUM    
                                        PIC X(9).                       
           05  WS-DEPOSIT-AMT           PIC 9(9) VALUE 0.               
           05  WS-DEPOSIT-AMT-DEC       PIC 9(7)V99 VALUE 0.            
           05  WS-LAST-READ-DATE        PIC X(10) VALUE SPACES.         
           05  WS-DATE-LAST-YEAR        PIC X(10) VALUE SPACES.         
           05  WS-TOTAL-CHARGES         PIC 9(9)V99 VALUE 0.            
           05  WS-DISPLAY-CHARGES       PIC Z(8)9.99.                   
           05  WS-GAS-UT-EXISTS         PIC X(01) VALUE SPACES.         
           05  WS-ARRANGEMENT-REMARKS   PIC X(90) VALUE SPACE.          
           05  WS-EW-REMARKS            PIC X(06) VALUE SPACE.          
           05  WS-RELEASE-REMARKS       PIC X(18) VALUE SPACE.          
           05  WS-SO-EST-LABOR-HR       PIC 9(6) VALUE 0.               
           05  WS-SO-EST-LABOR-HR-DEC   PIC 9(5)V9 VALUE 0.             
           05  WS-CHARGE-AMT           PIC S9(7)V99 COMP-3 VALUE 0.0.   
           05  WS-CHARGE-AMT-NODEC     PIC 9(9) VALUE 0.                
           05  WS-ELEC-WORK-TYPE-REMARKS.                               
               10  F                       PIC X(21) VALUE              
               'ELEC ORIG WORK TYPE '.                                  
               10  WS-EXISTING-WORK-TYPE-E PIC X(03).                   
           05  WS-GAS-WORK-TYPE-REMARKS.                                
               10  F                       PIC X(20) VALUE              
               'GAS ORIG WORK TYPE '.                                   
               10  WS-EXISTING-WORK-TYPE-G PIC X(03).                   
           05  WS-E-REMARKS-EXIST       PIC X(01) VALUE SPACES.         
           05  WS-G-REMARKS-EXIST       PIC X(01) VALUE SPACES.         
           05  WS-SPCL-INST-LEN         PIC S9(4) COMP VALUE 0.         
           05  WS-DELETE-FLAG           PIC X(01) VALUE SPACES.         
           05  WS-SO-NUMBER-DELETE      PIC S9(13)V COMP-3 VALUE 9.     
           05  WS-PREM-NO-NUM           PIC 9(10).                      
           05  WS-PREM-NO-CHAR          REDEFINES WS-PREM-NO-NUM        
                                        PIC X(10).                      
           05  WS-CUST-NO-NUM           PIC 9(10).                      
           05  WS-CUST-NO-CHAR          REDEFINES WS-CUST-NO-NUM        
                                        PIC X(10).                      
           05  WS-ACCT-NO-NUM           PIC 9(13).                      
           05  WS-ACCT-NO-CHAR          REDEFINES WS-ACCT-NO-NUM        
                                        PIC X(13).                      
           05  WS-CURR-CUSTOMER-NO-NUM  PIC 9(10).                      
           05  WS-CURR-CUSTOMER-NO-CHAR REDEFINES                       
               WS-CURR-CUSTOMER-NO-NUM  PIC X(10).                      
           05  WS-LLRD-CUSTOMER-NO-NUM  PIC 9(10).                      
           05  WS-LLRD-CUSTOMER-NO-CHAR REDEFINES                       
               WS-LLRD-CUSTOMER-NO-NUM  PIC X(10).                      
           05  WS-LINK-CUSTOMER-NO-CHAR PIC X(10).                      
           05  WS-LINK-CUSTOMER-NO-NUM  REDEFINES                       
               WS-LINK-CUSTOMER-NO-CHAR PIC 9(10).                      
           05  WS-SPCL-INST-TEXT        PIC X(210).                     
           05  WS-TRAN-APPL-NO           PIC S9(4)   COMP VALUE 1.      
           05  WS-WAIVER-COMMENTS.                                      
               10  F                    PIC X(28) VALUE                 
                  'SERVICE ORDER TRANSFER FROM '.                       
               10  WS-DISP-XFER-ACCT    PIC 9(13).                      
               10  F                    PIC X(18) VALUE                 
                  ' SERVICE ORDER NO '.                                 
               10  WS-DISP-XFER-SO      PIC 9(13).                      
               10  F                    PIC X(10) VALUE                 
                  ' CSR USER '.                                         
               10  WS-DISP-XFER-USER    PIC X(07).                      
           05  WS-HOLD-SERV-ORDER-NO    PIC 9(13).                      
           05  WS-MISSING-STRT-EVENT    PIC X(01) VALUE 'N'.            
           05  WS-BILL-ADDRESS-EXISTS   PIC X(01) VALUE 'N'.            
           05  WS-SCENARIO              PIC X(01) VALUE ' '.            
               88  REGULAR-CC           VALUE 'C'.                      
               88  REVERT-NO-XFER       VALUE 'R'.                      
               88  REVERT-XFER          VALUE 'X'.                      
A01114     05  WS-SEASONAL-APP-FL       PIC X(01) VALUE SPACES.         
A01114     05  WS-COMBO-DIST-LO-FL      PIC X(01) VALUE SPACES.         
A01114     05  WS-GAS-WORK-AREA-FL      PIC X(01) VALUE SPACES.         
P00718     05  WS-WORK-DISTRICT         PIC X(40) VALUE SPACES.         
A05189     05  WS-AROP-FL               PIC X(01) VALUE SPACES.         
P00836     05  WS-CUST-NAME             PIC X(76) VALUE SPACES.         
                                                                        
       01  WS-TABLES.                                                   
           05  WS-SUPPLYING-TABLE.                                      
               10  WS-SUPPLYING-DATA.                                   
                   15  FILLER  PIC X(17) VALUE 'A APARTMENT      '.     
                   15  FILLER  PIC X(17) VALUE 'B BALL PARK      '.     
                   15  FILLER  PIC X(17) VALUE 'C BARN           '.     
                   15  FILLER  PIC X(17) VALUE 'D BOAT HOUSE/DOCK'.     
                   15  FILLER  PIC X(17) VALUE 'E CAMPER/RV TRLR '.     
                   15  FILLER  PIC X(17) VALUE 'F COMMERCIAL     '.     
                   15  FILLER  PIC X(17) VALUE 'G COMM TRAILER   '.     
                   15  FILLER  PIC X(17) VALUE 'H COTTAGE APT    '.     
                   15  FILLER  PIC X(17) VALUE 'I FIRECRACKER STD'.     
                   15  FILLER  PIC X(17) VALUE 'J GARAGE         '.     
                   15  FILLER  PIC X(17) VALUE 'K GARAGE APT     '.     
                   15  FILLER  PIC X(17) VALUE 'L GREENHOUSE     '.     
                   15  FILLER  PIC X(17) VALUE 'M HOUSE          '.     
                   15  FILLER  PIC X(17) VALUE 'N INDUSTRIAL     '.     
                   15  FILLER  PIC X(17) VALUE 'O IRRIGATION     '.     
                   15  FILLER  PIC X(17) VALUE 'P LIFT STATION   '.     
                   15  FILLER  PIC X(17) VALUE 'Q MOBILE HOME    '.     
                   15  FILLER  PIC X(17) VALUE 'R POOL HEATER    '.     
                   15  FILLER  PIC X(17) VALUE 'S PUMP/WELL      '.     
                   15  FILLER  PIC X(17) VALUE 'T STANDBY GEN    '.     
                   15  FILLER  PIC X(17) VALUE 'U T-SAW POLE     '.     
                   15  FILLER  PIC X(17) VALUE 'V TOBACCO BARN   '.     
                   15  FILLER  PIC X(17) VALUE 'W TURKEY SHOOT   '.     
                   15  FILLER  PIC X(17) VALUE 'X WAREHOUSE      '.     
                   15  FILLER  PIC X(17) VALUE 'Y WHOLESALE CUST '.     
                   15  FILLER  PIC X(17) VALUE 'Z XMAS TREE STAND'.     
                   15  FILLER  PIC X(17) VALUE '0 UNKNOWN        '.     
               10  WS-SUPPLYING-DATA-R REDEFINES WS-SUPPLYING-DATA.     
                   15  WS-SUPPLYING-LINE  OCCURS 27                     
                                          INDEXED BY WS-SUPPLYING-INDEX.
                       20 WS-SUPPLYING-CD   PIC X(02).                  
                       20 WS-SUPPLYING-DESC PIC X(15).                  
           05  T2-CSR01121            OCCURS 10                         
                                      INDEXED BY T2-INDEX.              
               10 T2-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
               10 T2-SO-INST-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T2-RATE-PLAN-NO       PIC X(03) VALUE SPACES.         
               10 T2-RATE-DESC          PIC X(50) VALUE SPACES.         
               10 T2-METER-NO           PIC X(09) VALUE SPACES.         
               10 T2-METER-LOC-DESC     PIC X(14) VALUE SPACES.         
               10 T2-CODE-MTR-STATUS-WS PIC X(01) VALUE SPACES.         
               10 T2-CODE-STATUS-REA-WS PIC X(01) VALUE SPACES.         
               10 T2-METER-SUPPLYING    PIC X(15) VALUE SPACES.         
               10 T2-OLD-WORK-TYPE-CD   PIC X(03) VALUE SPACES.         
               10 T2-HOLD-RELEASE       PIC X(01) VALUE SPACES.         
               10 T2-RLSE-NO            PIC X(10) VALUE SPACES.         
               10 T2-RLSE-DATE          PIC X(26) VALUE SPACES.         
               10 T2-CODE-METER-LOC     PIC X(02) VALUE SPACES.         
               10 T2-PER-TEMP-IND       PIC X(01) VALUE SPACES.         
               10 T2-IC-NO              PIC S9(4) COMP VALUE 0.         
               10 T2-METER-IND          PIC X(01) VALUE SPACES.         
               10 T2-MTR-REF-NO         PIC S9(4) COMP VALUE 0.         
               10 T2-RLSE-IND           PIC X(01) VALUE SPACES.         
               10 T2-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T2-RLSE-REQUIRED      PIC X(01) VALUE SPACES.         
A05317     05  T3-CSR02210            OCCURS 80                         
                                      INDEXED BY T3-INDEX.              
               10 T3-TABLE-ID           PIC X(02) VALUE SPACES.         
               10 T3-UT-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.         
               10 T3-UT-IC-NO           PIC S9(4) COMP VALUE 0.         
               10 T3-UT-READ-ROUTE      PIC S9(4) COMP VALUE 0.         
               10 T3-UT-RATE-PLAN-NO    PIC X(03).                      
               10 T3-UT-RATE-DESC       PIC X(25).                      
               10 T3-UT-CODE-REV-CLASS  PIC X(03).                      
               10 T3-UT-READ-CYCLE      PIC X(02).                      
               10 T3-UT-CODE-SIC-NO     PIC X(04).                      
               10 T3-MN-METER-NO        PIC X(09).                      
               10 T3-MN-MTR-REF-NO      PIC S9(4) COMP VALUE 0.         
               10 T3-MN-CODE-TIME-PER   PIC S9(4) COMP VALUE 0.         
               10 T3-MN-LAST-READ-VAL   PIC S9(12)V9(3) COMP-3 VALUE 0. 
               10 T3-MN-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-USAGE-T    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-USAGE-I    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-USAGE-S    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-METER-S    PIC X(01) VALUE SPACES.         
               10 T3-MN-METER-SUPPLY    PIC X(15) VALUE SPACES.         
               10 T3-MN-CODE-METER-LOC  PIC X(02) VALUE SPACES.         
               10 T3-MN-METER-LOC-DESC  PIC X(14) VALUE SPACES.         
               10 T3-MN-METER-IND       PIC X(01) VALUE SPACES.         
               10 T3-MN-CONSTANT        PIC S9(6)V COMP-3 VALUE 0.      
               10 T3-MN-NO-DIALS        PIC S9(4) COMP VALUE 0.         
               10 T3-MN-DIST-NODE-PO    PIC X(20) VALUE SPACES.         
               10 T3-MN-POINT-ID        PIC X(10) VALUE SPACES.         
               10 T3-MN-SEAL-CODE-ID    PIC X(01) VALUE SPACES.         
               10 T3-MN-HEX-LOCATION    PIC X(02) VALUE SPACES.         
               10 T3-MN-INSULATED-IND   PIC X(01) VALUE SPACES.         
               10 T3-MN-LOCK-TYPE-ID    PIC X(01) VALUE SPACES.         
               10 T3-MN-DELIVERY-LEV    PIC X(01) VALUE SPACES.         
               10 T3-MN-UTILITY-SOURCE  PIC X(01) VALUE SPACES.         
               10 T3-MN-IDR-RECIPIENT   PIC X(01) VALUE SPACES.         
               10 T3-MN-PROGRAM-ID      PIC X(02) VALUE SPACES.         
               10 T3-MN-MTR-READ-SOURCE PIC X(01) VALUE SPACES.         
               10 T3-RG-LAST-READD      PIC X(10) VALUE SPACES.         
               10 T3-RG-REG-ID-NO       PIC S9(4) COMP VALUE 0.         
               10 T3-CP-NO-UNITS        PIC S9(9) COMP VALUE 0.         
               10 T3-CP-CODE-PLAN       PIC X(01) VALUE SPACES.         
               10 T3-CP-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T3-CP-CD-SVC-TYPE     PIC X(01) VALUE SPACES.         
               10 T3-CP-MTHLY-AMT       PIC S9(9)V COMP-3 VALUE 0.      
               10 T3-CP-RT-ITEM-CD      PIC S9(4) COMP VALUE 0.         
               10 T3-CP-LIGHT-NO        PIC S9(4) COMP VALUE 0.         
               10 T3-CP-POLE-NO         PIC X(07) VALUE SPACES.         
               10 T3-CP-DIST-NO         PIC X(03) VALUE SPACES.         
               10 T3-CP-USAGE-FIXED     PIC S9(9)V COMP-3 VALUE 0.      
               10 T3-CP-ITEM-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T3-CP-EQUIP-ID        PIC X(02) VALUE SPACES.         
               10 T3-PREM-DIR-IND       PIC X(01) VALUE SPACES.         
               10 T3-SUBDIV-LIGHT       PIC S9(3)V COMP-3 VALUE 0.      
               10 T3-ACCT-TYPE-CODE     PIC X(01) VALUE SPACES.         
               10 T3-CD-RENTAL-PROP     PIC X(01) VALUE SPACES.         
               10 T3-LL-CUSTOMER-NO     PIC S9(10)V COMP-3 VALUE 0.     
               10 T3-REV-DISTRICT-CD    PIC X(03) VALUE SPACES.         
               10 T3-DISC-BAL           PIC S9(11)V99 COMP-3 VALUE 0.   
               10 T3-OUT-ACCOUNT-NO     PIC S9(13)V COMP-3 VALUE 0.     
               10 T3-ACCT-STATUS        PIC X(01) VALUE SPACES.         
               10 T3-ROW-NO             PIC S9(4) COMP VALUE 0.         
               10 T3-DEPOSIT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T3-SEC-TOT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T3-CUR-MTH-ARR-CD     PIC X(01) VALUE SPACES.         
               10 T3-CREDIT-GROUP       PIC X(01) VALUE SPACES.         
               10 T3-CURRENT-ACCOUNT    PIC X(01) VALUE SPACES.         
               10 T3-DATE-BANKRUPT      PIC X(10) VALUE SPACES.         
               10 T3-FILED-CASE-NO      PIC X(10) VALUE SPACES.         
               10 T3-DL-NO              PIC X(19) VALUE SPACES.         
               10 T3-DL-STATE           PIC X(02) VALUE SPACES.         
               10 T3-SSN                PIC X(09) VALUE SPACES.         
               10 T3-PRIOR-ACCT-STAT    PIC X(01) VALUE SPACES.         
               10 T3-READ-CYCLE         PIC X(02) VALUE SPACES.         
               10 T3-SERV-STRT-DT       PIC X(10) VALUE SPACES.         
               10 T3-DEP-INTST-RT       PIC S9(2)V99 COMP-3 VALUE 0.    
               10 T3-CP-DT-PLAN-ST      PIC X(10) VALUE SPACES.         
               10 T3-ACTIVE-CONTRACT    PIC X(01) VALUE SPACES.         
               10 T3-SECURED-RATE-FL    PIC X(01) VALUE SPACES.         
               10 T3-MN-CODE-MTR-RD     PIC X(02) VALUE SPACES.         
               10 T3-MN-MTR-PRESS       PIC X(03) VALUE SPACES.         
               10 T3-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T3-RLSE-REQUIRED      PIC X(01) VALUE SPACES.         
               10 T3-RLSE-NO            PIC X(10) VALUE SPACES.         
               10 T3-RLSE-DATE          PIC X(10) VALUE SPACES.         
           05  T4-SO-APPLIANCES       OCCURS 20                         
                                      INDEXED BY T4-INDEX.              
               10 T4-APPLIANCE-CD       PIC X(03) VALUE SPACES.         
               10 T4-EQUIP-OWNER        PIC X(01) VALUE SPACES.         
               10 T4-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
               10 T4-LEAK-IND           PIC X(01) VALUE SPACES.         
               10 T4-LIGHT-IND          PIC X(01) VALUE SPACES.         
               10 T4-REPAIR-IND         PIC X(01) VALUE SPACES.         
               10 T4-CUTOFF-IND         PIC X(01) VALUE SPACES.         
               10 T4-CAUTION-TAG-IND    PIC X(01) VALUE SPACES.         
               10 T4-IMPROPER-REASON    PIC X(50) VALUE SPACES.         
               10 T4-APPLIANCE-SEQ-NO   PIC S9(4) COMP VALUE 0.         
               10 T4-EQUIPMENT-UNQ      PIC X(20) VALUE SPACES.         
               10 T4-CATHODIC-PROTECT   PIC X(03) VALUE SPACES.         
               10 T4-INSTALL-DT         PIC X(10) VALUE SPACES.         
               10 T4-REPLACE-APP-FL     PIC X(01) VALUE SPACES.         
               10 T4-PRD-SRV-TYP-DESC   PIC X(32) VALUE SPACES.         
               10 T4-INSTALL-IND        PIC X(01) VALUE SPACES.         
           05  T5-APPLIANCES          OCCURS 20                         
                                      INDEXED BY T5-INDEX.              
               10 T5-APPLIANCE-CD       PIC X(02) VALUE SPACES.         
               10 T5-EQUIP-OWNER        PIC X(12) VALUE SPACES.         
               10 T5-PRIMARY-FUEL-CD    PIC X(06) VALUE SPACES.         
               10 T5-EQUIPMENT-NO       PIC X(20) VALUE SPACES.         
               10 T5-INSTALL-DT         PIC X(10) VALUE SPACES.         
               10 T5-REPLACE-APP-FL     PIC X(01) VALUE SPACES.         
               10 T5-CAUTION-TAG-IND    PIC X(01) VALUE SPACES.         
               10 T5-CONDITION-DESC     PIC X(50) VALUE SPACES.         
               10 T5-CUT-IND            PIC X(01) VALUE SPACES.         
               10 T5-APPLIANCE-DESC     PIC X(20) VALUE SPACES.         
               10 T5-CRAWL-FL           PIC X(01) VALUE SPACES.         
                                                                        
      ******************************************************************        
      * CSR01121 - GET METER DATA FOR EXISTING ORDER                   *        
      ******************************************************************        
                                                                        
       01  CSR01121-CALL-DATA.                                          
           03  SERV-ORDER-NO-1121       PIC X(13) VALUE SPACES.         
           03  CURRENT-HISTORY-1121     PIC X(01) VALUE 'C'.            
                                                                        
       01  CSR01121-RETURN-DATA.                                        
           03  RETURN-CODE-1121         PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-1121      PIC X(01) VALUE SPACES.         
           03  SO-INST-SEQ-NO-1121      PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-NO-1121        PIC X(03) VALUE SPACES.         
           03  RATE-DESC-1121           PIC X(50) VALUE SPACES.         
           03  METER-NO-1121            PIC X(09) VALUE SPACES.         
           03  METER-LOC-DESC-1121      PIC X(14) VALUE SPACES.         
           03  CODE-MTR-STATUS-WS-1121  PIC X(01) VALUE SPACES.         
           03  CODE-STATUS-REA-WS-1121  PIC X(01) VALUE SPACES.         
           03  METER-SUPPLYING-1121     PIC X(15) VALUE SPACES.         
           03  WORK-TYPE-CD-1121        PIC X(03) VALUE SPACES.         
           03  HOLD-RELEASE-1121        PIC X(01) VALUE SPACES.         
           03  RLSE-NO-1121             PIC X(10) VALUE SPACES.         
           03  RLSE-DATE-1121           PIC X(26) VALUE SPACES.         
           03  CODE-METER-LOC-1121      PIC X(02) VALUE SPACES.         
           03  PER-TEMP-IND-1121        PIC X(01) VALUE SPACES.         
           03  IC-NO-1121               PIC S9(4) COMP VALUE 0.         
           03  METER-IND-1121           PIC X(01) VALUE SPACES.         
           03  MTR-REF-NO-1121          PIC S9(4) COMP VALUE 0.         
           03  RLSE-IND-1121            PIC X(01) VALUE SPACES.         
                                                                        
      ******************************************************************        
      * CSR02210 - SNAPSHOT DATA FROM ACCOUNT                          *        
      ******************************************************************        
                                                                        
       01  CSR02210-CALL-DATA.                                          
           03 ACCOUNT-NO-2210           PIC X(13) VALUE SPACES.         
           03 PREMISE-NO-2210           PIC X(10) VALUE SPACES.         
           03 COMPANY-NO-2210           PIC X(02) VALUE SPACES.         
           03 MKTG-ORDER-2210           PIC X(01) VALUE SPACES.         
           03 RETURN-UTILS-2210         PIC X(01) VALUE SPACES.         
           03 RETURN-DISC-BAL-2210      PIC X(01) VALUE SPACES.         
           03 ORDER-REASON-2210         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02210-RETURN-DATA.                                        
           05  RETURN-CODE-2210      PIC S9(9)     COMP VALUE 0.        
           05  ACTIVE-PARA-2210      PIC X(30)     VALUE SPACES.        
           05  TABLE-NAME-2210       PIC X(30)     VALUE SPACES.        
           05  TABLE-ID-2210         PIC X(2)      VALUE SPACES.        
           05  UT-CODE-UTIL-TY-2210  PIC X(1)      VALUE SPACES.        
           05  UT-IC-NO-2210         PIC S9(4)     COMP VALUE 0.        
           05  UT-READ-ROUTE-2210    PIC S9(4)     COMP VALUE 0.        
           05  UT-RATE-PLAN-NO-2210  PIC X(3)      VALUE SPACES.        
           05  UT-RATE-DESC-2210     PIC X(25)     VALUE SPACES.        
           05  UT-CODE-REV-CLA-2210  PIC X(3)      VALUE SPACES.        
           05  UT-READ-CYCLE-2210    PIC X(2)      VALUE SPACES.        
           05  UT-CODE-SIC-NO-2210   PIC X(4)      VALUE SPACES.        
           05  MN-METER-NO-2210      PIC X(9)      VALUE SPACES.        
           05  MN-MTR-REF-NO-2210    PIC S9(4)     COMP VALUE 0.        
           05  MN-CODE-TIME-PE-2210  PIC S9(4)     COMP VALUE 0.        
           05  MN-LAST-READ-VA-2210  PIC S9(12)V999 COMP-3 VALUE 0.     
           05  MN-CD-STUS-RS-2210    PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-T-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-I-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-METER-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-METER-SUPPLY-2210  PIC X(15)     VALUE SPACES.        
           05  MN-CODE-METER-L-2210  PIC X(2)      VALUE SPACES.        
           05  MN-METER-LOC-DE-2210  PIC X(14)     VALUE SPACES.        
           05  MN-METER-IND-2210     PIC X(1)      VALUE SPACES.        
           05  MN-CONSTANT-2210      PIC S9(6)V    COMP-3 VALUE 0.      
           05  MN-NO-DIALS-2210      PIC S9(4) COMP VALUE 0.            
           05  MN-DIST-NODE-PO-2210  PIC X(20)     VALUE SPACES.        
           05  MN-POINT-ID-2210      PIC X(10)     VALUE SPACES.        
           05  MN-SEAL-CODE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-HEX-LOCATION-2210  PIC X(02)     VALUE SPACES.        
           05  MN-INSULATED-IN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-LOCK-TYPE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-DELIVERY-LEV-2210  PIC X(01)     VALUE SPACES.        
           05  MN-UTILITY-SOUR-2210  PIC X(01)     VALUE SPACES.        
           05  MN-IDR-RECIPIEN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-PROGRAM-ID-2210    PIC X(02)     VALUE SPACES.        
           05  MN-MTR-READ-SO-2210   PIC X(01)     VALUE SPACES.        
           05  RG-CODE-REG-ST-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-STATUS-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-TIME-P-2210   PIC S9(4)     COMP VALUE 0.        
           05  RG-CODE-USAGE-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-SRC-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  RG-LAST-READD-2210    PIC X(10)     VALUE SPACES.        
           05  RG-LST-READVL-2210    PIC S9(12)V9(3) COMP-3 VALUE 0.    
           05  RG-REG-ID-NO-2210     PIC S9(4)     COMP VALUE 0.        
           05  CP-NO-UNITS-2210      PIC S9(9)     COMP VALUE 0.        
           05  CP-CODE-PLAN-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-STATRS-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-SVC-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  CP-MTLY-AMT-FX-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-RT-ITEM-CD-2210    PIC S9(4)     COMP VALUE 0.        
           05  CP-LIGHT-NO-2210      PIC S9(4)     COMP VALUE 0.        
           05  CP-POLE-NO-2210       PIC X(7)      VALUE SPACES.        
           05  CP-DIST-NO-2210       PIC X(3)      VALUE SPACES.        
           05  CP-USAGE-FIXED-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-ITEM-SEQ-NO-2210   PIC S9(4)     COMP VALUE 0.        
           05  CP-EQUIP-ID-2210      PIC X(2)      VALUE SPACES.        
           05  PREM-DIR-IND-2210     PIC X(1)      VALUE SPACES.        
           05  SUBDIV-LIGHT-2210 PIC S9(3)V        COMP-3 VALUE 0.      
           05  ACCT-TYPE-2210        PIC X(1)      VALUE SPACES.        
           05  CD-RNTL-PROP-2210     PIC X(1)      VALUE SPACES.        
           05  LL-CUSTOMER-NO-2210   PIC S9(10)    COMP-3 VALUE 0.      
           05  REV-DIST-CD-2210      PIC X(3)      VALUE SPACES.        
           05  DISC-BAL-2210         PIC S9(11)V99 COMP-3 VALUE 0.      
           05  OUT-ACCOUNT-NO-2210   PIC S9(13)V   COMP-3 VALUE 0.      
           05  ACCT-STATUS-2210      PIC X(1)      VALUE SPACES.        
           05  ROW-NO-2210           PIC S9(4)     COMP VALUE 0.        
           05  DEPOSIT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  SEC-TOT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  CUR-MTH-ARR-CD-2210   PIC X(01)     VALUE SPACES.        
           05  CREDIT-GROUP-2210     PIC X(01)     VALUE SPACES.        
           05  CURRENT-ACCOUNT-2210  PIC X(01)     VALUE 'Y'.           
           05  DATE-BNKRPT-FL-2210   PIC X(10)     VALUE SPACES.        
           05  FILED-CASE-NO-2210    PIC X(10)     VALUE SPACES.        
           05  DL-NO-2210            PIC X(19)     VALUE SPACES.        
           05  DL-STATE-2210         PIC X(02)     VALUE SPACES.        
           05  SSN-2210              PIC X(09)     VALUE SPACES.        
           05  PRIOR-ACCT-STAT-2210  PIC X(01)     VALUE SPACES.        
           05  READ-CYCLE-2210       PIC X(02)     VALUE SPACES.        
           05  SERV-STRT-DT-2210     PIC X(10)     VALUE SPACES.        
           05  DEP-INTST-RT-2210     PIC S9(2)V99  COMP-3 VALUE 0.      
           05  CP-DT-PLN-ST-2210     PIC X(10)     VALUE SPACES.        
           05  ACTIVE-CONTRACT-2210  PIC X(01)     VALUE SPACES.        
           05  SECURED-RATE-FL-2210  PIC X(01)     VALUE SPACES.        
           05  MN-CODE-MTR-RD-2210   PIC X(02)     VALUE SPACES.        
           05  MN-MTR-PRESS-2210     PIC X(03)     VALUE SPACES.        
P00390     05  ERROR-MSG-NO-02-2210  PIC X(05)     VALUE SPACES.        
P00390     05  ERROR-MSG-NO-A4-2210  PIC X(05)     VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR02054 - CREATE A NEW ACCOUNT                                *        
      ******************************************************************        
                                                                        
       01  CSR02054-CALL-DATA.                                          
           03  PREMISE-NO-2054          PIC X(10) VALUE SPACES.         
           03  CUSTOMER-NO-2054         PIC X(10) VALUE SPACES.         
           03  USERID-2054              PIC X(07) VALUE SPACES.         
           03  COMPANY-NO-2054          PIC X(02) VALUE SPACES.         
                                                                        
       01  CSR02054-RETURN-DATA.                                        
           05  RETURN-CODE-2054      PIC S9(9)     COMP VALUE 0.        
           05  ACCOUNT-NO-2054       PIC X(13)     VALUE SPACES.        
           05  COMPANY-ACCT-2054     PIC X(01)     VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR04012 - DETERMINE IF A RELEASE IS REQUIRED                  *        
      ******************************************************************        
                                                                        
       01  CSR04012-CALL-DATA.                                          
           03  COMPANY-NO-4012          PIC X(02) VALUE SPACES.         
           03  REV-DISTRICT-CD-4012     PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-4012      PIC X(01) VALUE SPACES.         
           03  ORDER-TYPE-CD-4012       PIC X(05) VALUE SPACES.         
           03  WORK-TYPE-CD-4012        PIC X(03) VALUE SPACES.         
           03  RLSE-CHECK-CD-4012       PIC X(01) VALUE SPACES.         
           03  ACCOUNT-NO-4012          PIC X(13) VALUE SPACES.         
           03  IC-NO-4012               PIC X(04) VALUE SPACES.         
           03  MTR-REF-NO-4012          PIC X(04) VALUE SPACES.         
           03  METER-SUPPLYING-CD-4012  PIC X(02) VALUE SPACES.         
           03  CODE-STATUS-REAS-4012    PIC X(01) VALUE SPACES.         
           03  CALLING-SYSTEM-4012      PIC X(03) VALUE SPACES.         
           03  WANTED-BY-DATE-4012      PIC X(10) VALUE SPACES.         
           03  PREMISE-NO-4012          PIC X(10) VALUE SPACES.         
           03  RLSE-TYPE-4012           PIC X(02) VALUE SPACES.         
           03  RLSE-SUPPLIES-4012       PIC X(15) VALUE SPACES.         
                                                                        
       01  CSR04012-RETURN-DATA.                                        
           05  RETURN-CODE-4012      PIC S9(9)     COMP VALUE 0.        
           05  RLSE-REQUIRED-FL-4012 PIC X(01)     VALUE SPACES.        
           05  MESSAGE-4012          PIC X(05)     VALUE SPACES.        
           05  ADTL-MESSAGE-4012     PIC X(05)     VALUE SPACES.        
           05  PHONE-4012            PIC X(12)     VALUE SPACES.        
           05  ALT-PHONE-4012        PIC X(12)     VALUE SPACES.        
           05  UTIL-TYPE-4012        PIC X(04)     VALUE SPACES.        
           05  REV-DIST-DESC-4012    PIC X(25)     VALUE SPACES.        
           05  RLSE-EXISTS-4012      PIC X(01)     VALUE SPACES.        
           05  RLSE-NO-4012          PIC X(10)     VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR01297 - ADD AN APPLIANCE TO CSS_APPLIANCE                   *        
      ******************************************************************        
                                                                        
       01  CSR01297-CALL-DATA.                                          
           03  UPDATE-TYPE-1297         PIC X(02) VALUE SPACES.         
           03  PREMISE-NO-1297          PIC X(10) VALUE SPACES.         
           03  EQUIPMENT-NO-1297        PIC X(20) VALUE SPACES.         
           03  COMPANY-NO-1297          PIC X(02) VALUE SPACES.         
           03  APPLIANCE-CD-1297        PIC X(02) VALUE SPACES.         
           03  CAUTION-TAG-IND-1297     PIC X(01) VALUE SPACES.         
           03  CUT-IND-1297             PIC X(01) VALUE SPACES.         
           03  PRIMARY-FUEL-CD-1297     PIC X(06) VALUE SPACES.         
           03  UPDATE-DT-1297           PIC X(10) VALUE SPACES.         
           03  UPDATE-ID-1297           PIC X(07) VALUE SPACES.         
           03  TAG-NO-1297              PIC X(10) VALUE SPACES.         
           03  CONDITION-CD-1297        PIC X(03) VALUE SPACES.         
           03  LOCATION-CD-1297         PIC X(03) VALUE SPACES.         
           03  APPL-CMNT-LEN-1297       PIC S9(04) COMP VALUE 0.        
           03  APPL-CMNT-TXT-1297       PIC X(255) VALUE SPACES.        
           03  CAUTION-TAG-DT-1297      PIC X(10) VALUE SPACES.         
           03  SOURCE-SYSTEM-CD-1297    PIC X(03) VALUE SPACES.         
           03  CMNT-TXT-LEN-1297        PIC S9(04) COMP VALUE 0.        
           03  CMNT-TXT-1297            PIC X(255) VALUE SPACES.        
                                                                        
       01  CSR01297-RETURN-DATA.                                        
           05  RETURN-CODE-1297      PIC S9(9)     COMP VALUE 0.        
           05  WQ-FLAG-1297          PIC X(01)     VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR01105 - GET DATA FOR EXISTING SERVICE ORDER                 *        
      ******************************************************************        
                                                                        
       01  CSR01105-CALL-DATA.                                          
           03  SERV-ORDER-NO-1105       PIC X(13) VALUE SPACES.         
           03  HISTORY-FL-1105          PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01105-RETURN-DATA.                                        
           05  RETURN-CODE-1105          PIC S9(9) COMP VALUE 0.        
           05  ORDER-TYPE-CD-1105        PIC X(05) VALUE SPACES.        
           05  ORDER-REASON-1105         PIC X(15) VALUE SPACES.        
           05  STATUS-TX-1105            PIC X(25) VALUE SPACES.        
           05  ORDER-STATE-CD-1105       PIC X(01) VALUE SPACES.        
           05  ORDER-PLACED-BY-1105      PIC X(25) VALUE SPACES.        
           05  PHONE-NO-1105             PIC X(10) VALUE SPACES.        
           05  PHONE-NO-EXT-1105         PIC X(06) VALUE SPACES.        
           05  WANTED-BY-DATETIME-1105   PIC X(26) VALUE SPACES.        
           05  ASSIGNED-DATETIME-1105    PIC X(26) VALUE SPACES.        
           05  CALL-BEFORE-MINUTS-1105   PIC X(03) VALUE SPACES.        
           05  WORK-AREA-ID-1105         PIC X(12) VALUE SPACES.        
           05  BREAKERS-OFF-IND-1105     PIC X(01) VALUE SPACES.        
           05  INIT-BY-CNTRCT-IND-1105   PIC X(01) VALUE SPACES.        
           05  NOTIFY-CSR-IND-1105       PIC X(01) VALUE SPACES.        
           05  NOTIFY-CUST-IND-1105      PIC X(01) VALUE SPACES.        
           05  ORDER-PRIORITY-CD-1105    PIC S9(4) COMP VALUE 0.        
           05  STD-LABOR-CHRG-1105       PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  WORK-TYPE-CD-1105         PIC X(03) VALUE SPACES.        
           05  BACK-DATED-IND-1105       PIC X(01) VALUE SPACES.        
           05  DEPOSIT-AMT-1105          PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  ORDER-RECVED-BY-1105      PIC X(07) VALUE SPACES.        
           05  VERIFY-RATE-1105          PIC X(01) VALUE SPACES.        
           05  PREMISE-NO-1105           PIC S9(10)V COMP-3 VALUE 0.    
           05  ACCOUNT-NO-1105           PIC S9(13)V COMP-3 VALUE 0.    
           05  ACCOUNT-NO-PRIOR-1105     PIC S9(13)V COMP-3 VALUE 0.    
           05  BEGIN-APPT-DATE-1105      PIC X(26) VALUE SPACES.        
           05  SO-EST-LABOR-HR-1105      PIC S9(5)V9 COMP-3 VALUE 0.    
           05  CUSTCHG-ORD-TYPE-FL-1105  PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-1105      PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  FILLER-1105               PIC S9(4) COMP VALUE 0.        
           05  CURRENT-DATE-1105         PIC X(10) VALUE SPACES.        
           05  CODE-UTIL-TYPE-1105       PIC X(01) VALUE SPACES.        
           05  PRICE-PER-SERV-1105       PIC S9(3)V9(6) COMP-3 VALUE 0. 
           05  ACCOUNT-TYPE-DESC-1105    PIC X(25) VALUE SPACES.        
           05  ORDER-CHARGE-AMT-1105     PIC S9(3)V9(2) COMP-3 VALUE 0. 
           05  TOTAL-CHARGES-AMT-1105    PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  CUST-CNT-ID-1105          PIC X(10) VALUE SPACES.        
           05  FILLER-A-1105             PIC X(01) VALUE SPACES.        
           05  FILLER-B-1105             PIC X(10) VALUE SPACES.        
           05  FILLER-C-1105             PIC X(08) VALUE SPACES.        
           05  FILLER-D-1105             PIC X(10) VALUE SPACES.        
           05  FILLER-E-1105             PIC X(04) VALUE SPACES.        
           05  MTR-ACCESSIBLE-CD-1105    PIC X(02) VALUE SPACES.        
           05  MTR-ACCESSIBLE-DT-1105    PIC X(10) VALUE SPACES.        
           05  MTR-ACCESSIBLE-RSN-1105   PIC X(02) VALUE SPACES.        
           05  SOURCE-SYSTEM-CD-1105     PIC X(03) VALUE SPACES.        
           05  ALT-PHONE-NO-1105         PIC X(10) VALUE SPACES.        
           05  ALT-PHONE-NO-EXT-1105     PIC X(06) VALUE SPACES.        
           05  HOME-ALL-DAY-FL-1105      PIC X(01) VALUE SPACES.        
P00718     05  BUSINESS-UNIT-1105        PIC X(03) VALUE SPACES.        
P00718     05  OPTIMIZE-ORDER-1105       PIC X(01) VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR00073 - ADD/UPDATE SERVICE ORDER                            *        
      ******************************************************************        
                                                                        
       01  CSR00073-CALL-DATA.                                          
           03  ROW-NO-0073              PIC S9(4) COMP VALUE 0.         
           03  PREMISE-NO-0073          PIC X(10) VALUE SPACES.         
           03  ACCOUNT-NO-0073          PIC X(13) VALUE SPACES.         
           03  ACCOUNT-NO-PRIOR-0073    PIC X(13) VALUE SPACES.         
           03  SERV-ORDER-NO-0073       PIC X(13) VALUE SPACES.         
           03  ORDER-TYPE-CD-0073       PIC X(05) VALUE SPACES.         
           03  LOCAL-OFFICE-0073        PIC X(03) VALUE SPACES.         
           03  PHONE-NO-EXT-0073        PIC X(06) VALUE SPACES.         
           03  PHONE-NO-0073            PIC X(10) VALUE SPACES.         
           03  ORDER-PLACED-BY-0073     PIC X(25) VALUE SPACES.         
           03  ORDER-RECVED-BY-0073     PIC X(07) VALUE SPACES.         
           03  WANTED-BY-DATE-0073      PIC X(10) VALUE SPACES.         
           03  ASSIGNED-DATETIME-0073   PIC X(26) VALUE SPACES.         
           03  ORDER-REASON-0073        PIC X(01) VALUE SPACES.         
           03  BACK-DATED-IND-0073      PIC X(01) VALUE SPACES.         
           03  RESP-AREA-ID-0073        PIC X(03) VALUE SPACES.         
           03  CALL-BEFORE-MIN-0073     PIC X(03) VALUE SPACES.         
           03  NOTIFY-CUST-IND-0073     PIC X(01) VALUE SPACES.         
           03  NOTIFY-CSR-IND-0073      PIC X(01) VALUE SPACES.         
           03  BREAKERS-OFF-0073        PIC X(01) VALUE SPACES.         
           03  DEPOSIT-AMT-0073         PIC S9(9)V9(2) COMP-3 VALUE 0.  
           03  INIT-BY-CNTRCT-0073      PIC X(01) VALUE SPACES.         
           03  WORK-AREA-ID-0073        PIC X(12) VALUE SPACES.         
           03  ORDER-PRIORITY-0073      PIC S9(4) COMP VALUE 0.         
           03  ORDER-STATE-CD-0073      PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-0073        PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-0073      PIC X(01) VALUE SPACES.         
           03  STD-CHG-AMT-0073         PIC S9(7)V9(2) COMP-3 VALUE 0.  
           03  HOLD-RELEASE-0073        PIC X(01) VALUE SPACES.         
           03  RLSE-IND-0073            PIC X(01) VALUE SPACES.         
           03  PER-TEMP-IND-0073        PIC X(01) VALUE SPACES.         
           03  RLSE-NO-0073             PIC X(10) VALUE SPACES.         
           03  RLSE-DATE-0073           PIC X(10) VALUE SPACES.         
           03  SO-INST-SEQ-NO-0073      PIC S9(4) COMP VALUE 0.         
           03  TABLE-ID-0073            PIC X(02) VALUE SPACES.         
           03  UT-CODE-UTIL-TYPE-0073   PIC X(01) VALUE SPACES.         
           03  IC-NO-0073               PIC S9(4) COMP VALUE 0.         
           03  UT-READ-ROUTE-0073       PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-NO-0073        PIC X(03) VALUE SPACES.         
           03  UT-CODE-REV-CLASS-0073   PIC X(03) VALUE SPACES.         
           03  UT-READ-CYCLE-0073       PIC X(02) VALUE SPACES.         
           03  UT-CODE-SIC-NO-0073      PIC X(04) VALUE SPACES.         
           03  METER-NO-0073            PIC X(09) VALUE SPACES.         
           03  MN-MTR-REF-NO-0073       PIC S9(4) COMP VALUE 0.         
           03  MN-CODE-TIME-PER-0073    PIC S9(4) COMP VALUE 0.         
           03  MN-LAST-READ-VAL-0073    PIC S9(12)V9(3) COMP-3 VALUE 0. 
           03  MN-CODE-STATUS-REA-0073  PIC X(01) VALUE SPACES.         
           03  MN-CODE-USAGE-TYPE-0073  PIC X(01) VALUE SPACES.         
           03  MN-CODE-USAGE-ID-0073    PIC X(01) VALUE SPACES.         
           03  MN-CODE-USAGE-SO-0073    PIC X(01) VALUE SPACES.         
           03  CODE-METER-STATUS-0073   PIC X(01) VALUE SPACES.         
           03  METER-SUPPLYING-0073     PIC X(15) VALUE SPACES.         
           03  CODE-MTR-LOC-0073        PIC X(02) VALUE SPACES.         
           03  MN-CONSTANT-0073         PIC S9(6)V9(3) COMP-3 VALUE 0.  
           03  MN-NO-DIALS-0073         PIC S9(4) COMP VALUE 0.         
           03  MN-POINT-ID-0073         PIC X(10) VALUE SPACES.         
           03  MN-SEAL-CODE-ID-0073     PIC X(01) VALUE SPACES.         
           03  MN-HEX-LOCATION-0073     PIC X(02) VALUE SPACES.         
           03  MN-INSULATED-IND-0073    PIC X(01) VALUE SPACES.         
           03  MN-LOCK-TYPE-ID-0073     PIC X(01) VALUE SPACES.         
           03  MN-DELV-LEVEL-CD-0073    PIC X(01) VALUE SPACES.         
           03  MN-UTILITY-SOURCE-0073   PIC X(01) VALUE SPACES.         
           03  MN-IDR-RECIPIENT-0073    PIC X(01) VALUE SPACES.         
           03  MN-PROGRAM-ID-0073       PIC X(02) VALUE SPACES.         
           03  READ-SOURCE-CD-0073      PIC X(01) VALUE SPACES.         
           03  RG-CODE-REG-STAT-0073    PIC X(01) VALUE SPACES.         
           03  RG-CODE-STATUS-REA-0073  PIC X(01) VALUE SPACES.         
           03  RG-CODE-TIME-PER-0073    PIC S9(4) COMP VALUE 0.         
           03  RG-CODE-USAGE-ID-0073    PIC X(01) VALUE SPACES.         
           03  RG-CODE-USAGE-SO-0073    PIC X(01) VALUE SPACES.         
           03  RG-CODE-USAGE-TY-0073    PIC X(01) VALUE SPACES.         
           03  RG-LAST-READ-DT-0073     PIC X(10) VALUE SPACES.         
           03  RG-LAST-READ-VAL-0073    PIC S9(12)V9(3) COMP-3 VALUE 0. 
           03  RG-REG-ID-NO-0073        PIC S9(4) COMP VALUE 0.         
           03  CP-NO-UNITS-0073         PIC S9(9) COMP VALUE 0.         
           03  CP-CODE-PLAN-STA-0073    PIC X(01) VALUE SPACES.         
           03  CP-CODE-STAT-REA-0073    PIC X(01) VALUE SPACES.         
           03  CP-CODE-SERVICEZ-0073    PIC X(01) VALUE SPACES.         
           03  CP-MNTHLY-AMT-FI-0073    PIC S9(9)V9(2) COMP-3 VALUE 0.  
           03  CP-RATE-ITEM-CD-0073     PIC S9(4) COMP VALUE 0.         
           03  CP-LIGHT-NO-0073         PIC S9(4) COMP VALUE 0.         
           03  CP-POLE-NO-0073          PIC X(07) VALUE SPACES.         
           03  CP-DIST-NO-0073          PIC X(03) VALUE SPACES.         
           03  CP-USAGE-FIXED-0073      PIC S9(9)V COMP-3 VALUE 0.      
           03  CP-EQUIP-ID-0073         PIC X(02) VALUE SPACES.         
           03  APPLIANCE-CD-0073        PIC X(03) VALUE SPACES.         
           03  APPLIANCE-SEQ-NO-0073    PIC S9(4) COMP VALUE 0.         
           03  EQUIP-OWNER-0073         PIC X(01) VALUE SPACES.         
           03  MKT-CODE-UTIL-TYPE-0073  PIC X(01) VALUE SPACES.         
           03  LEAK-IND-0073            PIC X(01) VALUE SPACES.         
           03  LIGHT-IND-0073           PIC X(01) VALUE SPACES.         
           03  REPAIR-IND-0073          PIC X(01) VALUE SPACES.         
           03  CUTOFF-IND-0073          PIC X(01) VALUE SPACES.         
           03  CAUTION-TAG-IND-0073     PIC X(01) VALUE SPACES.         
           03  IMPROPER-REASON-0073     PIC X(50) VALUE SPACES.         
           03  EQUIPMENT-UNQ-0073       PIC X(20) VALUE SPACES.         
           03  VERIFY-RATE-0073         PIC X(01) VALUE SPACES.         
           03  ORDER-INST-PRESEN-0073   PIC X(01) VALUE SPACES.         
           03  EQUIPMENT-PRESEN-0073    PIC X(01) VALUE SPACES.         
           03  UTIL-ENV-PRESEN-0073     PIC X(01) VALUE SPACES.         
           03  NEW-ORDER-0073           PIC X(01) VALUE SPACES.         
           03  PANEL-NO-0073            PIC X(04) VALUE SPACES.         
           03  INCLUDE-INST-0073        PIC X(01) VALUE SPACES.         
           03  REV-DIST-CD-0073         PIC X(03) VALUE SPACES.         
           03  USER-ID-0073             PIC X(07) VALUE SPACES.         
           03  SO-EST-LABOR-HR-0073     PIC S9(2)V9(1) COMP-3 VALUE 0.  
           03  ACCT-STATUS-0073         PIC X(01) VALUE SPACES.         
           03  REORDER-FLAG-0073        PIC X(01) VALUE SPACES.         
           03  COMPANY-NO-0073          PIC X(02) VALUE SPACES.         
           03  INSTALL-DT-0073          PIC X(10) VALUE SPACES.         
           03  REPLACE-APP-FL-0073      PIC X(01) VALUE SPACES.         
           03  PRD-SRV-TYPE-DESC-0073   PIC X(32) VALUE SPACES.         
           03  OLD-ACCT-STAT-0073       PIC X(01) VALUE SPACES.         
           03  CODE-KEY-FIELD-0073      PIC X(01) VALUE SPACES.         
           03  RCC-CODE-0073            PIC X(03) VALUE SPACES.         
           03  MN-LAST-READ-DT-0073     PIC X(10) VALUE SPACES.         
           03  MN-REG-ID-NO-0073        PIC S9(4) COMP VALUE 0.         
           03  DATE-FORECAST-DNP-0073   PIC X(10) VALUE SPACES.         
           03  AMT-DNP-AT-BILLING-0073  PIC S9(11)V9(2) COMP-3 VALUE 0. 
           03  PRICE-PER-SERV-0073      PIC S9(3)V9(6) COMP-3 VALUE 0.  
           03  ACCOUNT-TYPE-CODE-0073   PIC X(01) VALUE SPACES.         
           03  INSTALL-IND-0073         PIC X(01) VALUE SPACES.         
           03  CP-ITEM-SEQ-NO-0073      PIC S9(4) COMP VALUE 0.         
           03  CUST-CNT-ID-0073         PIC X(10) VALUE SPACES.         
           03  WORK-PERIOD-CD-0073      PIC X(01) VALUE SPACES.         
           03  WAIVER-TYPE-CD-0073      PIC X(01) VALUE SPACES.         
           03  MN-METER-PRESSURE-0073   PIC X(03) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-0073       PIC X(03) VALUE SPACES.         
P00718     03  OPTIMIZE-ORDER-0073      PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR00073-RETURN-DATA.                                        
           05  NO-ERROR-0073             PIC S9(9) COMP VALUE 0.        
           05  NEW-SERV-ORDER-NO-0073    PIC S9(13)V COMP-3 VALUE 0.    
           05  WORK-QUEUE-0073           PIC S9(9) COMP VALUE 0.        
           05  RLSE-NO-NEW-0073          PIC X(10) VALUE SPACES.        
                                                                        
      ******************************************************************        
ACT233* CSR04675 - INSERT A WORK QUEUE                                 *        
      ******************************************************************        
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
      ******************************************************************        
      * CSR00425 - ADD CHANGE LOG REMARKS                              *        
      ******************************************************************        
                                                                        
       01  CSR00425-CALL-DATA.                                          
           05  SERV-ORDER-NO-0425        PIC X(13) VALUE SPACES.        
           05  REMARK-TYPE-CD-0425       PIC X(01) VALUE SPACES.        
           05  REMARKS-0425.                                            
              49 REMARKS-0425-LEN        PIC S9(4) USAGE COMP VALUE 0.  
              49 REMARKS-0425-TEXT       PIC X(210) VALUE SPACES.       
           05  USER-ID-0425              PIC X(07) VALUE SPACES.        
                                                                        
       01  CSR00425-RETURN-DATA.                                        
           05  RETURN-CODE-0425          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02072 - ADD A DEPOSIT                                       *        
      ******************************************************************        
                                                                        
       01  CSR02072-CALL-DATA.                                          
           05  ACTION-CODE-2072          PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2072           PIC X(13) VALUE SPACES.        
           05  AMT-ORIG-ENTERED-2072     PIC X(11) VALUE SPACES.        
           05  DEPOSIT-STATUS-CD-2072    PIC X(01) VALUE SPACES.        
           05  SERVICE-TYPE-CD-2072      PIC X(01) VALUE SPACES.        
           05  DEPOSIT-CERT-NO-2072      PIC X(09) VALUE SPACES.        
           05  DEP-ACTION-CODE-2072      PIC X(01) VALUE SPACES.        
           05  USER-ID-UPDT-BY-2072      PIC X(07) VALUE SPACES.        
           05  COMMENTS-2072             PIC X(210) VALUE SPACES.       
           05  COMMENTS-LEN-2072         PIC X(04) VALUE SPACES.        
           05  PANEL-COMMENTS-2072       PIC X(255) VALUE SPACES.       
           05  PANEL-COMMENTS-LEN-2072   PIC X(04) VALUE SPACES.        
           05  BILL-OPTION-CD-2072       PIC X(01) VALUE SPACES.        
           05  ORIG-BILL-OPT-CD-2072     PIC X(01) VALUE SPACES.        
           05  NO-SCHED-PYMTS-2072       PIC X(03) VALUE SPACES.        
           05  AMT-MO-PYMT-2072          PIC X(11) VALUE SPACES.        
           05  CODE-DEP-TYPE-2072        PIC X(01) VALUE SPACES.        
           05  CUT-DATE-2072             PIC X(10) VALUE SPACES.        
           05  PROJECT-CR-DT-2072        PIC X(10) VALUE SPACES.        
           05  DUE-DATE-2072             PIC X(10) VALUE SPACES.        
           05  PROGRAM-NAME-2072         PIC X(09) VALUE SPACES.        
           05  LAST-UPDATE-TS-2072       PIC X(26) VALUE SPACES.        
           05  CODE-REFUND-ELIG-2072     PIC X(01) VALUE SPACES.        
           05  ERROR-SWITCH-2072         PIC X(01) VALUE SPACES.        
           05  AUTODEP-LTR-DT-2072       PIC X(10) VALUE SPACES.        
           05  AUTODEP-LTR-IND-2072      PIC X(01) VALUE SPACES.        
           05  AUTODEP-NOT-AM-2072       PIC S9(9)V99 COMP-3 VALUE 0.   
           05  AUTODEP-RECAL-AM-2072     PIC S9(9)V99 COMP-3 VALUE 0.   
                                                                        
       01  CSR02072-RETURN-DATA.                                        
           05  ERROR-CODE-2072           PIC X(50) VALUE SPACES.        
           05  RETURN-CODE-2072          PIC S9(9) COMP VALUE 0.        
           05  AR-LOCKOUT-IND-2072       PIC X(01) VALUE SPACES.        
           05  ACCT-XFER-TO-2072         PIC X(13) VALUE SPACES.        
           05  ABEND-PROGRAM-2072        PIC X(08) VALUE SPACES.        
           05  ACTIVE-PARA-2072          PIC X(04) VALUE SPACES.        
           05  ABEND-FUNCTION-2072       PIC X(08) VALUE SPACES.        
           05  ABEND-TABLE-2072          PIC X(20) VALUE SPACES.        
           05  TABLE-ELMT-1-2072         PIC X(20) VALUE SPACES.        
           05  TABLE-ELMT-2-2072         PIC X(20) VALUE SPACES.        
           05  TABLE-ELMT-3-2072         PIC X(20) VALUE SPACES.        
           05  TABLE-ELMT-4-2072         PIC X(20) VALUE SPACES.        
           05  HOSTVAR-ELMT-1-2072       PIC X(20) VALUE SPACES.        
           05  HOSTVAR-ELMT-2-2072       PIC X(20) VALUE SPACES.        
           05  HOSTVAR-ELMT-3-2072       PIC X(20) VALUE SPACES.        
           05  HOSTVAR-ELMT-4-2072       PIC X(20) VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR02165 - ADD A WAIVER                                        *        
      ******************************************************************        
                                                                        
       01  CSR02165-CALL-DATA.                                          
           05  ACTION-CODE-2165          PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2165           PIC X(13) VALUE SPACES.        
           05  WAIVER-TYPE-CD-2165       PIC X(01) VALUE SPACES.        
           05  CODE-STATUS-2165          PIC X(01) VALUE SPACES.        
           05  COMMENTS-LEN-2165         PIC X(04) VALUE SPACES.        
           05  COMMENTS-TEXT-2165        PIC X(72) VALUE SPACES.        
           05  CODE-STATUS-REAS-2165     PIC X(20) VALUE SPACES.        
           05  WAIVER-SRCE-DESC-2165     PIC X(35) VALUE SPACES.        
           05  TRIGGER-DATE-2165         PIC X(10) VALUE SPACES.        
           05  BOND-ITEM-ID-2165         PIC X(09) VALUE SPACES.        
           05  USER-ID-2165              PIC X(07) VALUE SPACES.        
           05  TRAN-COMMENT-LEN-2165     PIC X(04) VALUE SPACES.        
           05  TRAN-COMMENT-TXT-2165     PIC X(210) VALUE SPACES.       
                                                                        
       01  CSR02165-RETURN-DATA.                                        
           05  RETURN-CODE-2165          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR00151 - ADD SERVICE ORDER CHARGES                           *        
      ******************************************************************        
                                                                        
       01  CSR00151-CALL-DATA.                                          
           05  SERV-ORDER-NO-0151        PIC X(13) VALUE SPACES.        
           05  CODE-UTIL-TYPE-0151       PIC X(01) VALUE SPACES.        
           05  OT-CHARGEABLE-HR-0151     PIC S9(4) COMP VALUE 0.        
           05  REG-CHARGEABLE-HR-0151    PIC S9(4) COMP VALUE 0.        
           05  MATERIAL-CHRG-0151        PIC S9(7)V99 COMP-3 VALUE 0.   
           05  OTHER-CHRG-0151           PIC S9(7)V99 COMP-3 VALUE 0.   
           05  CALC-LABOR-CHRG-0151      PIC S9(7)V99 COMP-3 VALUE 0.   
           05  COMMENTS-0151             PIC X(35) VALUE SPACES.        
           05  STD-LABOR-CHRG-0151       PIC S9(7)V99 COMP-3 VALUE 0.   
           05  ACCOUNT-TYPE-CD-0151      PIC X(01) VALUE SPACES.        
           05  USER-ID-0151              PIC X(07) VALUE SPACES.        
           05  PANEL-NO-0151             PIC X(04) VALUE SPACES.        
           05  WORK-PERIOD-CD-0151       PIC X(01) VALUE SPACES.        
           05  WAIVER-TYPE-CD-0151       PIC X(01) VALUE SPACES.        
                                                                        
       01  CSR00151-RETURN-DATA.                                        
           05  RETURN-CODE-0151          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02517 - ADD A COMMUNICATION RECORD                          *        
      ******************************************************************        
                                                                        
       01  CSR02517-CALL-DATA.                                          
           05  ACTION-CD-2517            PIC X(01) VALUE SPACES.        
           05  ACCOUNT-NO-2517           PIC X(13) VALUE SPACES.        
           05  CUSTOMER-NO-2517          PIC X(10) VALUE SPACES.        
           05  PREMISE-NO-2517           PIC X(10) VALUE SPACES.        
           05  COMMUNICATION-ID-2517     PIC X(26) VALUE SPACES.        
           05  COMPANY-NO-2517           PIC X(13) VALUE SPACES.        
           05  RED-FLAG-IND-2517         PIC X(01) VALUE SPACES.        
           05  RED-FLAG-EXP-DT-2517      PIC X(26) VALUE SPACES.        
           05  COMM-METHOD-2517          PIC X(01) VALUE SPACES.        
           05  COMM-DIRECTION-2517       PIC X(01) VALUE SPACES.        
           05  COMM-TYPE-CD-2517         PIC X(02) VALUE SPACES.        
           05  COMM-SUBTYPE-CD-2517      PIC X(02) VALUE SPACES.        
           05  USER-ID-ORIG-2517         PIC X(07) VALUE SPACES.        
           05  CONTACT-NAME-2517         PIC X(25) VALUE SPACES.        
           05  PROMOTION-ID-2517         PIC X(12) VALUE SPACES.        
           05  PSC-COMPLAINT-IND-2517    PIC X(01) VALUE SPACES.        
           05  CALL-ORIGIN-ID-2517       PIC X(04) VALUE SPACES.        
           05  CALL-END-TIME-2517        PIC X(26) VALUE SPACES.        
           05  NUMBER-TRANSFERS-2517     PIC X(09) VALUE SPACES.        
           05  HOLD-TIME-2517            PIC X(05) VALUE SPACES.        
           05  QUEUE-TIME-2517           PIC X(05) VALUE SPACES.        
           05  SCREEN-POP-IND-2517       PIC X(01) VALUE SPACES.        
           05  TOTAL-CALL-TIME-2517      PIC X(05) VALUE SPACES.        
           05  COMMENT-LEN-2517          PIC S9(4) COMP VALUE 0.        
           05  COMMENT-TEXT-2517         PIC X(255) VALUE SPACES.       
           05  COMM-ASSOC-CD-2517        PIC X(01) VALUE SPACES.        
           05  COMPLAINT-FL-2517         PIC X(01) VALUE SPACES.        
           05  RESPONSE-RESN-CD-2517     PIC X(04) VALUE SPACES.        
           05  RESPONSE-TYPE-CD-2517     PIC X(04) VALUE SPACES.        
           05  SOLICITATION-CD-2517      PIC X(03) VALUE SPACES.        
                                                                        
       01  CSR02517-RETURN-DATA.                                        
           05  RETURN-CODE-2517          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02049 - ADD BILLING ADDRESS                                 *        
      ******************************************************************        
                                                                        
       01  CSR02049-CALL-DATA.                                          
           05  USER-ID-2049              PIC X(07) VALUE SPACES.        
           05  ACCOUNT-NO-2049           PIC X(13) VALUE SPACES.        
           05  BILL-ADDR-ENTRED-2049     PIC X(01) VALUE SPACES.        
           05  BILL-NME-ENTERED-2049     PIC X(01) VALUE SPACES.        
           05  BILL-HDR-ENTERED-2049     PIC X(01) VALUE SPACES.        
           05  ADDRESS-FORMAT-2049       PIC X(01) VALUE SPACES.        
           05  AT-NAME-ID-2049           PIC X(13) VALUE SPACES.        
           05  AT-NAME-FORMAT-2049       PIC X(01) VALUE SPACES.        
           05  AT-NAME-TYPE-2049         PIC X(02) VALUE SPACES.        
           05  AT-FIRST-NAME-2049        PIC X(15) VALUE SPACES.        
           05  AT-MIDDLE-NAME-2049       PIC X(15) VALUE SPACES.        
           05  AT-LAST-NAME-2049         PIC X(40) VALUE SPACES.        
           05  AT-TITLE-PREFIX-2049      PIC X(09) VALUE SPACES.        
           05  AT-TITLE-SUFIX-1-2049     PIC X(03) VALUE SPACES.        
           05  AT-TITLE-SUFIX-2-2049     PIC X(03) VALUE SPACES.        
           05  AT-FULL-NAME-2049         PIC X(70) VALUE SPACES.        
           05  NB-NAME-ID-2049           PIC X(13) VALUE SPACES.        
           05  NB-NAME-FORMAT-2049       PIC X(01) VALUE SPACES.        
           05  NB-NAME-TYPE-2049         PIC X(02) VALUE SPACES.        
           05  NB-FIRST-NAME-2049        PIC X(15) VALUE SPACES.        
           05  NB-MIDDLE-NAME-2049       PIC X(15) VALUE SPACES.        
           05  NB-LAST-NAME-2049         PIC X(40) VALUE SPACES.        
           05  NB-TITLE-PREFIX-2049      PIC X(09) VALUE SPACES.        
           05  NB-TITLE-SUFIX-1-2049     PIC X(03) VALUE SPACES.        
           05  NB-TITLE-SUFIX-2-2049     PIC X(03) VALUE SPACES.        
           05  NB-FULL-NAME-2049         PIC X(70) VALUE SPACES.        
           05  ADDRESS-ID-2049           PIC X(13) VALUE SPACES.        
           05  FO-UPDATE-FLG-2049        PIC X(03) VALUE SPACES.        
           05  FO-HOUSE-NO-2049          PIC X(15) VALUE SPACES.        
           05  FO-ADDR-PREFIX-1-2049     PIC X(03) VALUE SPACES.        
           05  FO-ADDR-PREFIX-2-2049     PIC X(02) VALUE SPACES.        
           05  FO-STREET-NAME-2049       PIC X(30) VALUE SPACES.        
           05  FO-STREET-SUFFIX-2049     PIC X(04) VALUE SPACES.        
           05  FO-STRT-LOCTN-1-2049      PIC X(04) VALUE SPACES.        
           05  FO-STRT-LOCTN-2-2049      PIC X(11) VALUE SPACES.        
           05  FO-ADDS-OVRFLOW-2049      PIC X(26) VALUE SPACES.        
           05  FO-ZIP-CODE-2049          PIC X(05) VALUE SPACES.        
           05  FO-ZIP-CDE-PL-FR-2049     PIC X(04) VALUE SPACES.        
           05  FO-ZIP-CODE-TKN-2049      PIC X(01) VALUE SPACES.        
           05  FR-ADDR-STREET-2049       PIC X(55) VALUE SPACES.        
           05  FR-ADDR-OVRFLOW-2049      PIC X(35) VALUE SPACES.        
           05  FR-CITY-STATE-2049        PIC X(30) VALUE SPACES.        
           05  FR-ZIP-CODE-2049          PIC X(09) VALUE SPACES.        
           05  FR-COUNTRY-2049           PIC X(35) VALUE SPACES.        
           05  FO-ADDR-SUFFIX-2049       PIC X(02) VALUE SPACES.        
           05  COMMENTS-TEXT-2049        PIC X(210) VALUE SPACES.       
           05  COMMENT-TXT-LEN-2049      PIC S9(4) COMP VALUE 0.        
                                                                        
       01  CSR02049-RETURN-DATA.                                        
           05  RETURN-CODE-2049          PIC S9(9) COMP VALUE 0.        
           05  NEW-ADDRESS-ID-2049       PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR01416 - GET DATE X NUMBER OF BUSINESS DAYS IN THE FUTURE    *        
      ******************************************************************        
                                                                        
       01  CSR01416-CALL-DATA.                                          
           05  INPUT-DATE-1416           PIC X(26) VALUE SPACES.        
           05  BUSINESS-DAYS-1416        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  CSR01416-RETURN-DATA.                                        
           05  OUTPUT-DATE-1416          PIC X(26) VALUE SPACES.        
                                                                        
      ******************************************************************        
A05317* CSR04291 - DELETE ACCOUNT                                      *        
      ******************************************************************        
                                                                        
A05317 01  CSR04291-CALL-DATA.                                          
A05317     05  ACCOUNT-NO-4291           PIC X(13) VALUE SPACES.        
A05317     05  USER-ID-4291              PIC X(07) VALUE SPACES.        
A05317     05  COMMENTS-4291             PIC X(210) VALUE SPACES.       
                                                                        
A05317 01  CSR04291-RETURN-DATA.                                        
A05317     05  RETURN-CODE-4291          PIC S9(9) COMP VALUE 0.        
A05317     05  STATUS-CODE-4291          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR00148 - INSERT FINAL BILL ADDRESS                           *        
      ******************************************************************        
                                                                        
       01  CSR00148-CALL-DATA.                                          
           05  SERV-ORDER-NO-0148        PIC X(13) VALUE SPACES.        
           05  ADDRESS-FORMAT-0148       PIC X(01) VALUE SPACES.        
           05  CREDIT-LETTER-IND-0148    PIC X(01) VALUE SPACES.        
           05  SEND-TO-LOCOFF-IND-0148   PIC X(01) VALUE SPACES.        
           05  HOUSE-NO-0148             PIC X(05) VALUE SPACES.        
           05  ADDR-PREFIX-1-0148        PIC X(03) VALUE SPACES.        
           05  ADDR-PREFIX-2-0148        PIC X(02) VALUE SPACES.        
           05  STREET-NAME-0148          PIC X(16) VALUE SPACES.        
           05  STREET-SUFFIX-0148        PIC X(04) VALUE SPACES.        
           05  ADDR-SUFFIX-0148          PIC X(02) VALUE SPACES.        
           05  STREET-LOC-1-0148         PIC X(04) VALUE SPACES.        
           05  STREET-LOC-2-0148         PIC X(06) VALUE SPACES.        
           05  ZIP-CODE-0148             PIC X(05) VALUE SPACES.        
           05  ZIP-CODE-PLUS-FOUR-0148   PIC X(04) VALUE SPACES.        
           05  ZIP-CODE-TOKEN-0148       PIC X(01) VALUE SPACES.        
           05  ADDRESS-OVERFLOW-0148     PIC X(35) VALUE SPACES.        
           05  ADDR-ST-0148              PIC X(35) VALUE SPACES.        
           05  FINAL-BILL-CY-ST-0148     PIC X(20) VALUE SPACES.        
           05  ADDR-ZIP-CODE-0148        PIC X(09) VALUE SPACES.        
           05  ADDR-COUNTRY-0148         PIC X(35) VALUE SPACES.        
           05  FINAL-BILL-OVFL-0148      PIC X(35) VALUE SPACES.        
           05  CARRIER-ROUTE-0148        PIC X(05) VALUE SPACES.        
                                                                        
       01  CSR00148-RETURN-DATA.                                        
           05  RETURN-CODE-0148          PIC S9(9) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR02142 - GET XFER INFORMATION                                *        
      ******************************************************************        
                                                                        
       01  CSR02142-CALL-DATA.                                          
           05  ACCOUNT-NO-2142           PIC X(13) VALUE SPACES.        
                                                                        
       01  CSR02142-RETURN-DATA.                                        
           05  DNP-DATE-2142           PIC X(10).                       
           05  PAST-DUE-BAL-2142       PIC S9(09)V99 COMP-3 VALUE +0.   
           05  BILL-DATE-2142          PIC X(10) VALUE SPACES.          
           05  CREDIT-GROUP-2142       PIC X(01) VALUE SPACES.          
           05  ACCT-XFER-FROM-LST-2142 PIC X(13) VALUE SPACES.          
           05  STA-IND-2142            PIC X(01) VALUE SPACES.          
           05  UTL-IND-2142            PIC X(01) VALUE SPACES.          
           05  BANK-DRAFT-IND-2142     PIC X(01) VALUE SPACES.          
           05  EPP-IND-2142            PIC X(01) VALUE SPACES.          
           05  DEPOSIT-IND-2142        PIC X(01) VALUE SPACES.          
           05  OTHER-RECV-IND-2142     PIC X(01) VALUE SPACES.          
           05  PROJ-SHARE-IND-2142     PIC X(01) VALUE SPACES.          
           05  WRITE-OFF-IND-2142      PIC X(01) VALUE SPACES.          
           05  IN-LIEU-DEP-IND-2142    PIC X(01) VALUE SPACES.          
           05  ROOMMATE-IND-2142       PIC X(01) VALUE SPACES.          
           05  CO-APP-IND-2142         PIC X(01) VALUE SPACES.          
           05  MEDICAL-IND-2142        PIC X(01) VALUE SPACES.          
           05  WHITE-CROSS-IND-2142    PIC X(01) VALUE SPACES.          
           05  RETURN-CODE-2142        PIC S9(9) COMP VALUE 0.          
           05  EPP-TRAN-BALANCE-2142   PIC S9(09)V99 COMP-3 VALUE +0.   
           05  CONTRACT-FLAG-2142      PIC X(01) VALUE SPACES.          
           05  CODE-ACCT-STAT-2142     PIC X(01) VALUE SPACES.          
           05  ADDRESS-FORMAT-2142     PIC X(01) VALUE SPACES.          
           05  HOUSE-NO-2142           PIC X(05) VALUE SPACES.          
           05  ADDR-PREFIX-1-2142      PIC X(03) VALUE SPACES.          
           05  ADDR-PREFIX-2-2142      PIC X(02) VALUE SPACES.          
           05  STREET-NAME-2142        PIC X(16) VALUE SPACES.          
           05  STREET-SUFFIX-2142      PIC X(04) VALUE SPACES.          
           05  ADDR-SUFFIX-2142        PIC X(02) VALUE SPACES.          
           05  STREET-LOCATION-1-2142  PIC X(04) VALUE SPACES.          
           05  STREET-LOCATION-2-2142  PIC X(06) VALUE SPACES.          
           05  ZIP-CODE-2142           PIC X(05) VALUE SPACES.          
           05  ZIP-CODE-PLUS-FOUR-2142 PIC X(04) VALUE SPACES.          
           05  ZIP-CODE-TOKEN-2142     PIC X(01) VALUE SPACES.          
           05  ADDRESS-OVERFLOW-2142   PIC X(35) VALUE SPACES.          
           05  ADDR-STREET-2142        PIC X(35) VALUE SPACES.          
           05  ADDR-CITY-STATE-2142    PIC X(20) VALUE SPACES.          
           05  ADDR-ZIP-CODE-2142      PIC X(09) VALUE SPACES.          
           05  ADDR-COUNTRY-2142       PIC X(35) VALUE SPACES.          
           05  ADDR-OVERFLOW-2142      PIC X(35) VALUE SPACES.          
                                                                        
      ******************************************************************        
      * CSR00178 - UPDATE XFER INFORMATION                             *        
      ******************************************************************        
                                                                        
       01  CSR00178-CALL-DATA.                                          
           05  UPDATE-TYPE-0178          PIC X(01) VALUE SPACES.        
           05  TO-ACCT-NO-0178           PIC S9(13)V COMP-3 VALUE 0.    
           05  SERV-ORDER-NO-0178        PIC X(13) VALUE SPACES.        
           05  ROOMMATE-XFER-IND-0178    PIC X(01) VALUE SPACES.        
           05  EPP-XFER-IND-0178         PIC X(01) VALUE SPACES.        
           05  DEPOSIT-XFER-IND-0178     PIC X(01) VALUE SPACES.        
           05  OTHER-AR-XFER-IND-0178    PIC X(01) VALUE SPACES.        
           05  PROJ-SHR-XFER-IND-0178    PIC X(01) VALUE SPACES.        
           05  WRITE-OFF-XFER-IND-0178   PIC X(01) VALUE SPACES.        
           05  IN-LIEU-XFER-IND-0178     PIC X(01) VALUE SPACES.        
           05  WHT-CROSS-XFER-IND-0178   PIC X(01) VALUE SPACES.        
           05  COAPPL-XFER-IND-0178      PIC X(01) VALUE SPACES.        
           05  MED-CERT-XFER-IND-0178    PIC X(01) VALUE SPACES.        
                                                                        
       01  CSR00178-RETURN-DATA.                                        
           05  RETURN-CODE-0178        PIC S9(9) COMP VALUE 0.          
                                                                        
      ******************************************************************        
      * CSR02146 - GET CONTRACT INFORMATION                            *        
      ******************************************************************        
                                                                        
       01  CSR02146-CALL-DATA.                                          
           05  ACCOUNT-NO-2146           PIC X(13) VALUE SPACES.        
                                                                        
       01  CSR02146-RETURN-DATA.                                        
           05  CONTRACT-ID-2146        PIC S9(9) COMP VALUE 0.          
           05  CONTRACT-NAME-ABBR-2146 PIC X(10) VALUE SPACES.          
           05  AR-TRAN-BAL-2146        PIC S9(09)V99 COMP-3 VALUE +0.   
           05  LIEN-CD-2146            PIC X(1) VALUE SPACES.           
P00795     05  TRANSFER-FL-2146        PIC X(1) VALUE SPACES.           
P00795     05  CNT-NAME-DESC-2146      PIC X(30) VALUE SPACES.          
           05  RETURN-CODE-2146        PIC S9(09) COMP VALUE 0.         
                                                                        
      ******************************************************************        
      * CSR00178 - UPDATE CONTRACT INFO FOR XFER                       *        
      ******************************************************************        
                                                                        
       01  CSR00179-CALL-DATA.                                          
           05  UPDATE-TYPE-0179        PIC X(01) VALUE SPACES.          
           05  TO-ACCT-NO-0179         PIC S9(13)V COMP-3 VALUE 0.      
           05  CNT-ITEM-ID-0179        PIC S9(9) COMP VALUE 0.          
           05  SERV-ORDER-NO-0179      PIC X(13) VALUE SPACES.          
                                                                        
       01  CSR00179-RETURN-DATA.                                        
           05  RETURN-CODE-0179        PIC S9(9) COMP VALUE 0.          
                                                                        
A05189******************************************************************        
A05189* CSR04747 - INSERT INTO CLICK TASK QUEUE                        *        
A05189******************************************************************        
A05189                                                                  
A05189 01  CSR04747-CALL-DATA.                                          
A05189     05  SERV-ORDER-NO-4747        PIC X(13) VALUE SPACES.        
A05189     05  PRIORITY-4747             PIC X(01) VALUE SPACES.        
A05189     05  ACTION-CD-4747            PIC X(01) VALUE SPACES.        
A05189     05  USER-ID-4747              PIC X(07) VALUE SPACES.        
A05189     05  IN-WORK-DISTRICT-4747     PIC X(40) VALUE SPACES.        
A05189                                                                  
A05189 01  CSR04747-RETURN-DATA.                                        
A05189     05  RETURN-CODE-4747          PIC S9(9) COMP VALUE 0.        
A05189     05  OUT-WORK-DISTRICT-4747    PIC X(40) VALUE SPACES.        
                                                                        
        01  WS-COMPRESSION-TABLES.                                      
            05  WS-EMB-INPUT.                                           
                10  WS-EMB-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-EMB-INDX.         
            05  WS-EMB-TBL-LENG         PIC S9(03) VALUE +255.          
            05  WS-EMB-LENG             PIC S9(03) VALUE ZERO.          
            05  WS-EMB-LAST-CHAR        PIC X(01).                      
            05  WS-CMP-TABLE.                                           
                10  WS-CMP-CHAR         PIC X(01)                       
                                        OCCURS 255 TIMES                
                                        INDEXED BY WS-CMP-INDX.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC1121 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2210 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2054 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4012 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1297 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1105 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0073 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0425 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2072 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2165 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0151 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2517 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2049 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1416 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
A05317*01 LOC4291 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0148 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2142 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0178 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC2146 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0179 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
A05189*01 LOC4747 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE SO_APP_CURSOR CURSOR FOR                         
                   SELECT VQ.APPLIANCE_CD,                              
                          VQ.EQUIP_OWNER,                               
                          VQ.CODE_UTIL_TYPE,                            
                          VQ.LEAK_IND,                                  
                          VQ.LIGHT_IND,                                 
                          VQ.REPAIR_IND,                                
                          VQ.CUTOFF_IND,                                
                          VQ.CAUTION_TAG_IND,                           
                          VQ.IMPROPER_REASON,                           
                          VQ.APPLIANCE_SEQ_NO,                          
                          VQ.EQUIPMENT_UNQ,                             
                          VO.CATHODIC_PROTECT,                          
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VQ.INSTALL_DT, 121), ' ', '-'), ':', '.') INSTALL_DT,               
                          VQ.REPLACE_APP_FL,                            
                          VQ.PRD_SRV_TYP_DESC,                          
                          VQ.INSTALL_IND                                
                     FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED),            
                          CSS_SO_DATA VO WITH(READUNCOMMITTED)                  
                    WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO          
                      AND VQ.SERV_ORDER_NO = VO.SERV_ORDER_NO           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO_APP_CURSOR CURSOR FOR                                 
MFA-TR*            SELECT VQ.APPLIANCE_CD,                                      
MFA-TR*                   VQ.EQUIP_OWNER,                                       
MFA-TR*                   VQ.CODE_UTIL_TYPE,                                    
MFA-TR*                   VQ.LEAK_IND,                                          
MFA-TR*                   VQ.LIGHT_IND,                                         
MFA-TR*                   VQ.REPAIR_IND,                                        
MFA-TR*                   VQ.CUTOFF_IND,                                        
MFA-TR*                   VQ.CAUTION_TAG_IND,                                   
MFA-TR*                   VQ.IMPROPER_REASON,                                   
MFA-TR*                   VQ.APPLIANCE_SEQ_NO,                                  
MFA-TR*                   VQ.EQUIPMENT_UNQ,                                     
MFA-TR*                   VO.CATHODIC_PROTECT,                                  
MFA-TR*                   VQ.INSTALL_DT,                                        
MFA-TR*                   VQ.REPLACE_APP_FL,                                    
MFA-TR*                   VQ.PRD_SRV_TYP_DESC,                                  
MFA-TR*                   VQ.INSTALL_IND                                        
MFA-TR*              FROM CSS_SO_APPLIANCE VQ,                                  
MFA-TR*                   CSS_SO_DATA VO                                        
MFA-TR*             WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO                  
MFA-TR*               AND VQ.SERV_ORDER_NO = VO.SERV_ORDER_NO                   
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 4165                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE APP_CURSOR CURSOR FOR                            
                   SELECT LA.APPLIANCE_CD,                              
                          LA.PRIMARY_FUEL_CD,                           
                          LA.EQUIPMENT_NO,                              
                          LA.CAUTION_TAG_IND,                           
                          A7.CONDITION_DESC,                            
                          LA.CUT_IND,                                   
                          JA.APPLIANCE_DESC,                            
                          JA.CRAWL_FL,                                  
A01114                    JA.SEASONAL_RT_FL                             
                     FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),               
                          CSS_APPLIANCE_COND A7 WITH(READUNCOMMITTED),          
                          CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)            
                    WHERE LA.PREMISE_NO = :LA-PREMISE-NO                
                      AND LA.PRIMARY_FUEL_CD = 'NA-GAS'                 
                      AND LA.CONDITION_CD    = A7.CONDITION_CD          
                      AND LA.COMPANY_NO      = A7.COMPANY_NO            
                      AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD          
                      AND LA.COMPANY_NO      = JA.COMPANY_NO            
                                                                 
                                                            
P00718     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE APP_CURSOR CURSOR FOR                                    
MFA-TR*            SELECT LA.APPLIANCE_CD,                                      
MFA-TR*                   LA.PRIMARY_FUEL_CD,                                   
MFA-TR*                   LA.EQUIPMENT_NO,                                      
MFA-TR*                   LA.CAUTION_TAG_IND,                                   
MFA-TR*                   A7.CONDITION_DESC,                                    
MFA-TR*                   LA.CUT_IND,                                           
MFA-TR*                   JA.APPLIANCE_DESC,                                    
MFA-TR*                   JA.CRAWL_FL,                                          
MFA-TR*                   JA.SEASONAL_RT_FL                                     
MFA-TR*              FROM CSS_APPLIANCE LA,                                     
MFA-TR*                   CSS_APPLIANCE_COND A7,                                
MFA-TR*                   CSS_MKT_APPLIANCE JA                                  
MFA-TR*             WHERE LA.PREMISE_NO = :LA-PREMISE-NO                        
MFA-TR*               AND LA.PRIMARY_FUEL_CD = 'NA-GAS'                         
MFA-TR*               AND LA.CONDITION_CD    = A7.CONDITION_CD                  
MFA-TR*               AND LA.COMPANY_NO      = A7.COMPANY_NO                    
MFA-TR*               AND LA.APPLIANCE_CD    = JA.APPLIANCE_CD                  
MFA-TR*               AND LA.COMPANY_NO      = JA.COMPANY_NO                    
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 7160                                                     
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1121 CURSOR
MSQ001          FOR CALL CSR01121                                             
                  ( :SERV-ORDER-NO-1121
                  , 'C'
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2210 CURSOR
MSQ001          FOR CALL CSR02210                                             
                  ( :ACCOUNT-NO-2210
                  , :PREMISE-NO-2210
                  , :COMPANY-NO-2210
                  , :MKTG-ORDER-2210
                  , :RETURN-UTILS-2210
                  , :RETURN-DISC-BAL-2210
                  , :ORDER-REASON-2210
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2054 CURSOR
MSQ001          FOR CALL CSR02054                                             
                  ( :PREMISE-NO-2054
                  , :CUSTOMER-NO-2054
                  , :USERID-2054
                  , :COMPANY-NO-2054
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4012 CURSOR
MSQ001          FOR CALL CSR04012                                             
                  ( :COMPANY-NO-4012
                  , :REV-DISTRICT-CD-4012
                  , :CODE-UTIL-TYPE-4012
                  , :ORDER-TYPE-CD-4012
                  , :WORK-TYPE-CD-4012
                  , :RLSE-CHECK-CD-4012
                  , :ACCOUNT-NO-4012
                  , :IC-NO-4012
                  , :MTR-REF-NO-4012
                  , :METER-SUPPLYING-CD-4012
                  , :CODE-STATUS-REAS-4012
                  , :CALLING-SYSTEM-4012
                  , :WANTED-BY-DATE-4012
                  , :PREMISE-NO-4012
                  , :RLSE-TYPE-4012
                  , :RLSE-SUPPLIES-4012
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1297 CURSOR
MSQ001          FOR CALL CSR01297                                             
                  ( :UPDATE-TYPE-1297
                  , :PREMISE-NO-1297
                  , :EQUIPMENT-NO-1297
                  , :COMPANY-NO-1297
                  , :APPLIANCE-CD-1297
                  , :CAUTION-TAG-IND-1297
                  , :CUT-IND-1297
                  , :PRIMARY-FUEL-CD-1297
                  , :UPDATE-DT-1297
                  , :UPDATE-ID-1297
                  , :TAG-NO-1297
                  , :CONDITION-CD-1297
                  , :LOCATION-CD-1297
                  , :APPL-CMNT-LEN-1297
                  , :APPL-CMNT-TXT-1297
                  , :CAUTION-TAG-DT-1297
                  , :SOURCE-SYSTEM-CD-1297
                  , :CMNT-TXT-LEN-1297
                  , :CMNT-TXT-1297
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1105 CURSOR
MSQ001          FOR CALL CSR01105                                             
                  ( :SERV-ORDER-NO-1105
                  , :HISTORY-FL-1105
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0073 CURSOR
MSQ001          FOR CALL CSR00073                                             
                  ( :ROW-NO-0073
                  , :PREMISE-NO-0073
                  , :ACCOUNT-NO-0073
                  , :ACCOUNT-NO-PRIOR-0073
                  , :SERV-ORDER-NO-0073
                  , :ORDER-TYPE-CD-0073
                  , :LOCAL-OFFICE-0073
                  , :PHONE-NO-EXT-0073
                  , :PHONE-NO-0073
                  , :ORDER-PLACED-BY-0073
                  , :ORDER-RECVED-BY-0073
                  , :WANTED-BY-DATE-0073
                  , :ASSIGNED-DATETIME-0073
                  , :ORDER-REASON-0073
                  , :BACK-DATED-IND-0073
                  , :RESP-AREA-ID-0073
                  , :CALL-BEFORE-MIN-0073
                  , :NOTIFY-CUST-IND-0073
                  , :NOTIFY-CSR-IND-0073
                  , :BREAKERS-OFF-0073
                  , :DEPOSIT-AMT-0073
                  , :INIT-BY-CNTRCT-0073
                  , :WORK-AREA-ID-0073
                  , :ORDER-PRIORITY-0073
                  , :ORDER-STATE-CD-0073
                  , :WORK-TYPE-CD-0073
                  , :CODE-UTIL-TYPE-0073
                  , :STD-CHG-AMT-0073
                  , :HOLD-RELEASE-0073
                  , :RLSE-IND-0073
                  , :PER-TEMP-IND-0073
                  , :RLSE-NO-0073
                  , :RLSE-DATE-0073
                  , :SO-INST-SEQ-NO-0073
                  , :TABLE-ID-0073
                  , :UT-CODE-UTIL-TYPE-0073
                  , :IC-NO-0073
                  , :UT-READ-ROUTE-0073
                  , :RATE-PLAN-NO-0073
                  , :UT-CODE-REV-CLASS-0073
                  , :UT-READ-CYCLE-0073
                  , :UT-CODE-SIC-NO-0073
                  , :METER-NO-0073
                  , :MN-MTR-REF-NO-0073
                  , :MN-CODE-TIME-PER-0073
                  , :MN-LAST-READ-VAL-0073
                  , :MN-CODE-STATUS-REA-0073
                  , :MN-CODE-USAGE-TYPE-0073
                  , :MN-CODE-USAGE-ID-0073
                  , :MN-CODE-USAGE-SO-0073
                  , :CODE-METER-STATUS-0073
                  , :METER-SUPPLYING-0073
                  , :CODE-MTR-LOC-0073
                  , :MN-CONSTANT-0073
                  , :MN-NO-DIALS-0073
                  , :MN-POINT-ID-0073
                  , :MN-SEAL-CODE-ID-0073
                  , :MN-HEX-LOCATION-0073
                  , :MN-INSULATED-IND-0073
                  , :MN-LOCK-TYPE-ID-0073
                  , :MN-DELV-LEVEL-CD-0073
                  , :MN-UTILITY-SOURCE-0073
                  , :MN-IDR-RECIPIENT-0073
                  , :MN-PROGRAM-ID-0073
                  , :READ-SOURCE-CD-0073
                  , :RG-CODE-REG-STAT-0073
                  , :RG-CODE-STATUS-REA-0073
                  , :RG-CODE-TIME-PER-0073
                  , :RG-CODE-USAGE-ID-0073
                  , :RG-CODE-USAGE-SO-0073
                  , :RG-CODE-USAGE-TY-0073
                  , :RG-LAST-READ-DT-0073
                  , :RG-LAST-READ-VAL-0073
                  , :RG-REG-ID-NO-0073
                  , :CP-NO-UNITS-0073
                  , :CP-CODE-PLAN-STA-0073
                  , :CP-CODE-STAT-REA-0073
                  , :CP-CODE-SERVICEZ-0073
                  , :CP-MNTHLY-AMT-FI-0073
                  , :CP-RATE-ITEM-CD-0073
                  , :CP-LIGHT-NO-0073
                  , :CP-POLE-NO-0073
                  , :CP-DIST-NO-0073
                  , :CP-USAGE-FIXED-0073
                  , :CP-EQUIP-ID-0073
                  , :APPLIANCE-CD-0073
                  , :APPLIANCE-SEQ-NO-0073
                  , :EQUIP-OWNER-0073
                  , :MKT-CODE-UTIL-TYPE-0073
                  , :LEAK-IND-0073
                  , :LIGHT-IND-0073
                  , :REPAIR-IND-0073
                  , :CUTOFF-IND-0073
                  , :CAUTION-TAG-IND-0073
                  , :IMPROPER-REASON-0073
                  , :EQUIPMENT-UNQ-0073
                  , :VERIFY-RATE-0073
                  , :ORDER-INST-PRESEN-0073
                  , :EQUIPMENT-PRESEN-0073
                  , :UTIL-ENV-PRESEN-0073
                  , :NEW-ORDER-0073
                  , :PANEL-NO-0073
                  , :INCLUDE-INST-0073
                  , :REV-DIST-CD-0073
                  , :USER-ID-0073
                  , :SO-EST-LABOR-HR-0073
                  , :ACCT-STATUS-0073
                  , :REORDER-FLAG-0073
                  , :COMPANY-NO-0073
                  , :INSTALL-DT-0073
                  , :REPLACE-APP-FL-0073
                  , :PRD-SRV-TYPE-DESC-0073
                  , :OLD-ACCT-STAT-0073
                  , :CODE-KEY-FIELD-0073
                  , :RCC-CODE-0073
                  , :MN-LAST-READ-DT-0073
                  , :MN-REG-ID-NO-0073
                  , :DATE-FORECAST-DNP-0073
                  , :AMT-DNP-AT-BILLING-0073
                  , :PRICE-PER-SERV-0073
                  , :ACCOUNT-TYPE-CODE-0073
                  , :INSTALL-IND-0073
                  , :CP-ITEM-SEQ-NO-0073
                  , :CUST-CNT-ID-0073
                  , :WORK-PERIOD-CD-0073
                  , :WAIVER-TYPE-CD-0073
                  , :MN-METER-PRESSURE-0073
                  , :BUSINESS-UNIT-0073
                  , :OPTIMIZE-ORDER-0073
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747                                             
                  ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :IN-WORK-DISTRICT-4747 OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0425 CURSOR
MSQ001          FOR CALL CSR00425                                             
                  ( :SERV-ORDER-NO-0425
                  , :REMARK-TYPE-CD-0425
                  , :REMARKS-0425
                  , :USER-ID-0425
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2072 CURSOR
MSQ001          FOR CALL CSR02072                                             
                  ( :ACTION-CODE-2072
                  , :ACCOUNT-NO-2072
                  , :AMT-ORIG-ENTERED-2072
                  , :DEPOSIT-STATUS-CD-2072
                  , :SERVICE-TYPE-CD-2072
                  , :DEPOSIT-CERT-NO-2072
                  , :DEP-ACTION-CODE-2072
                  , :USER-ID-UPDT-BY-2072
                  , :COMMENTS-2072
                  , :COMMENTS-LEN-2072
                  , :PANEL-COMMENTS-2072
                  , :PANEL-COMMENTS-LEN-2072
                  , :BILL-OPTION-CD-2072
                  , :ORIG-BILL-OPT-CD-2072
                  , :NO-SCHED-PYMTS-2072
                  , :AMT-MO-PYMT-2072
                  , :CODE-DEP-TYPE-2072
                  , :CUT-DATE-2072
                  , :PROJECT-CR-DT-2072
                  , :DUE-DATE-2072
                  , :PROGRAM-NAME-2072
                  , :LAST-UPDATE-TS-2072
                  , :CODE-REFUND-ELIG-2072
                  , :ERROR-SWITCH-2072
                  , :AUTODEP-LTR-DT-2072
                  , :AUTODEP-LTR-IND-2072
                  , :AUTODEP-NOT-AM-2072
                  , :AUTODEP-RECAL-AM-2072
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2165 CURSOR
MSQ001          FOR CALL CSR02165                                             
                  ( :ACTION-CODE-2165
                  , :ACCOUNT-NO-2165
                  , :WAIVER-TYPE-CD-2165
                  , :CODE-STATUS-2165
                  , :COMMENTS-LEN-2165
                  , :COMMENTS-TEXT-2165
                  , :CODE-STATUS-REAS-2165
                  , :WAIVER-SRCE-DESC-2165
                  , :TRIGGER-DATE-2165
                  , :BOND-ITEM-ID-2165
                  , :USER-ID-2165
                  , :TRAN-COMMENT-LEN-2165
                  , :TRAN-COMMENT-TXT-2165
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0151 CURSOR
MSQ001          FOR CALL CSR00151                                             
                  ( :SERV-ORDER-NO-0151
                  , :CODE-UTIL-TYPE-0151
                  , :OT-CHARGEABLE-HR-0151
                  , :REG-CHARGEABLE-HR-0151
                  , :MATERIAL-CHRG-0151
                  , :OTHER-CHRG-0151
                  , :CALC-LABOR-CHRG-0151
                  , :COMMENTS-0151
                  , :STD-LABOR-CHRG-0151
                  , :ACCOUNT-TYPE-CD-0151
                  , :USER-ID-0151
                  , :PANEL-NO-0151
                  , :WORK-PERIOD-CD-0151
                  , :WAIVER-TYPE-CD-0151
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2049 CURSOR
MSQ001          FOR CALL CSR02049                                             
                  ( :USER-ID-2049
                  , :ACCOUNT-NO-2049
                  , :BILL-ADDR-ENTRED-2049
                  , :BILL-NME-ENTERED-2049
                  , :BILL-HDR-ENTERED-2049
                  , :ADDRESS-FORMAT-2049
                  , :AT-NAME-ID-2049
                  , :AT-NAME-FORMAT-2049
                  , :AT-NAME-TYPE-2049
                  , :AT-FIRST-NAME-2049
                  , :AT-MIDDLE-NAME-2049
                  , :AT-LAST-NAME-2049
                  , :AT-TITLE-PREFIX-2049
                  , :AT-TITLE-SUFIX-1-2049
                  , :AT-TITLE-SUFIX-2-2049
                  , :AT-FULL-NAME-2049
                  , :NB-NAME-ID-2049
                  , :NB-NAME-FORMAT-2049
                  , :NB-NAME-TYPE-2049
                  , :NB-FIRST-NAME-2049
                  , :NB-MIDDLE-NAME-2049
                  , :NB-LAST-NAME-2049
                  , :NB-TITLE-PREFIX-2049
                  , :NB-TITLE-SUFIX-1-2049
                  , :NB-TITLE-SUFIX-2-2049
                  , :NB-FULL-NAME-2049
                  , :ADDRESS-ID-2049
                  , :FO-UPDATE-FLG-2049
                  , :FO-HOUSE-NO-2049
                  , :FO-ADDR-PREFIX-1-2049
                  , :FO-ADDR-PREFIX-2-2049
                  , :FO-STREET-NAME-2049
                  , :FO-STREET-SUFFIX-2049
                  , :FO-STRT-LOCTN-1-2049
                  , :FO-STRT-LOCTN-2-2049
                  , :FO-ADDS-OVRFLOW-2049
                  , :FO-ZIP-CODE-2049
                  , :FO-ZIP-CDE-PL-FR-2049
                  , :FO-ZIP-CODE-TKN-2049
                  , :FR-ADDR-STREET-2049
                  , :FR-ADDR-OVRFLOW-2049
                  , :FR-CITY-STATE-2049
                  , :FR-ZIP-CODE-2049
                  , :FR-COUNTRY-2049
                  , :FO-ADDR-SUFFIX-2049
                  , :COMMENTS-TEXT-2049
                  , :COMMENT-TXT-LEN-2049
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2517 CURSOR
MSQ001          FOR CALL CSR02517                                             
                  ( :ACTION-CD-2517
                  , :ACCOUNT-NO-2517
                  , :CUSTOMER-NO-2517
                  , :PREMISE-NO-2517
                  , :COMMUNICATION-ID-2517
                  , :COMPANY-NO-2517
                  , :RED-FLAG-IND-2517
                  , :RED-FLAG-EXP-DT-2517
                  , :COMM-METHOD-2517
                  , :COMM-DIRECTION-2517
                  , :COMM-TYPE-CD-2517
                  , :COMM-SUBTYPE-CD-2517
                  , :USER-ID-ORIG-2517
                  , :CONTACT-NAME-2517
                  , :PROMOTION-ID-2517
                  , :PSC-COMPLAINT-IND-2517
                  , :CALL-ORIGIN-ID-2517
                  , :CALL-END-TIME-2517
                  , :NUMBER-TRANSFERS-2517
                  , :HOLD-TIME-2517
                  , :QUEUE-TIME-2517
                  , :SCREEN-POP-IND-2517
                  , :TOTAL-CALL-TIME-2517
                  , :COMMENT-LEN-2517
                  , :COMMENT-TEXT-2517
                  , :COMM-ASSOC-CD-2517
                  , :COMPLAINT-FL-2517
                  , :RESPONSE-RESN-CD-2517
                  , :RESPONSE-TYPE-CD-2517
                  , :SOLICITATION-CD-2517
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1416 CURSOR
MSQ001          FOR CALL CSR01416                                             
                  ( :INPUT-DATE-1416
                  , :BUSINESS-DAYS-1416
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4291 CURSOR
MSQ001          FOR CALL CSR04291                                             
A05317            ( :ACCOUNT-NO-4291
                  , :USER-ID-4291
                  , :COMMENTS-4291
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2142 CURSOR
MSQ001          FOR CALL CSR02142                                             
                  ( :ACCOUNT-NO-2142
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0178 CURSOR
MSQ001          FOR CALL CSR00178                                             
                 ( :UPDATE-TYPE-0178
                  , :TO-ACCT-NO-0178
                  , :SERV-ORDER-NO-0178
                  , :ROOMMATE-XFER-IND-0178
                  , :EPP-XFER-IND-0178
                  , :DEPOSIT-XFER-IND-0178
                  , :OTHER-AR-XFER-IND-0178
                  , :PROJ-SHR-XFER-IND-0178
                  , :WRITE-OFF-XFER-IND-0178
                  , :IN-LIEU-XFER-IND-0178
                  , :WHT-CROSS-XFER-IND-0178
                  , :COAPPL-XFER-IND-0178
                  , :MED-CERT-XFER-IND-0178
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2146 CURSOR
MSQ001          FOR CALL CSR02146                                             
                  ( :ACCOUNT-NO-2146
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0179 CURSOR
MSQ001          FOR CALL CSR00179                                             
                  ( :UPDATE-TYPE-0179
                  , :TO-ACCT-NO-0179
                  , :CNT-ITEM-ID-0179
                  , :SERV-ORDER-NO-0179
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2165_2 CURSOR
MSQ001          FOR CALL CSR02165                                             
                  ( :ACTION-CODE-2165
                  , :ACCOUNT-NO-2165
                  , :WAIVER-TYPE-CD-2165
                  , :CODE-STATUS-2165
                  , :COMMENTS-LEN-2165
                  , :COMMENTS-TEXT-2165
                  , :CODE-STATUS-REAS-2165
                  , :WAIVER-SRCE-DESC-2165
                  , :TRIGGER-DATE-2165
                  , :BOND-ITEM-ID-2165
                  , :USER-ID-2165
                  , :TRAN-COMMENT-LEN-2165
                  , :TRAN-COMMENT-TXT-2165
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0148 CURSOR
MSQ001          FOR CALL CSR00148                                             
                  ( :SERV-ORDER-NO-0148
                  , :ADDRESS-FORMAT-0148
                  , :CREDIT-LETTER-IND-0148
                  , :SEND-TO-LOCOFF-IND-0148
                  , :HOUSE-NO-0148
                  , :ADDR-PREFIX-1-0148
                  , :ADDR-PREFIX-2-0148
                  , :STREET-NAME-0148
                  , :STREET-SUFFIX-0148
                  , :ADDR-SUFFIX-0148
                  , :STREET-LOC-1-0148
                  , :STREET-LOC-2-0148
                  , :ZIP-CODE-0148
                  , :ZIP-CODE-PLUS-FOUR-0148
                  , :ZIP-CODE-TOKEN-0148
                  , :ADDRESS-OVERFLOW-0148
                  , :ADDR-ST-0148
                  , :FINAL-BILL-CY-ST-0148
                  , :ADDR-ZIP-CODE-0148
                  , :ADDR-COUNTRY-0148
                  , :FINAL-BILL-OVFL-0148
                  , :CARRIER-ROUTE-0148
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
      *  LINK-UPDATE-ORDER-FL = 'Y' INDICATES THAT THE EXISTING ORDER           
      *  SHOULD BE UPDATED BECAUSE CUSTOMER WANTS SERVICE ON THE SAME           
      *  DAY AS THE EXISTING OFF/CC-REVERT ORDER.  SO NUMBER MUST BE            
      *  PASSED.                                                                
                                                                        
      *  WS-NEW-ORDER-FL INDICATES IF A NEW ORDER WILL BE CREATED OR            
      *  IF THE EXISTING ORDER WILL BE UPDATED                                  
                                                                        
      *  WS-ACCT-WK-TYPE-FL INDICATES WHERE THE WORK TYPE SHOULD BE             
      *  CALCULATED FROM - A (ACCOUNT) OR O (ORDER).                            
                                                                        
      *  WS-EXISTING-ORDER-FL INDICATES IF A CC/REVERT OR OFF ORDER             
      *  ALREADY EXISTS AT THE PREMISE                                          
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO         PIC X(10).                           
       01  LINK-SERV-ORDER-NO      PIC X(13).                           
       01  LINK-UPDATE-ORDER-FL    PIC X(01).                           
       01  LINK-CURR-ORDER-TYPE    PIC X(05).                           
       01  LINK-CURR-SCHEDULED-DT  PIC X(26).                           
       01  LINK-CURR-ACCOUNT-NO    PIC X(13).                           
       01  LINK-NEW-CUSTOMER-NO    PIC X(10).                           
       01  LINK-NEW-SCHEDULED-DT   PIC X(26).                           
       01  LINK-ARRANGEMENT-FL     PIC X(01).                           
       01  LINK-START-TS           PIC X(26).                           
       01  LINK-STOP-TS            PIC X(26).                           
       01  LINK-PHONE-NO           PIC X(10).                           
       01  LINK-ORDER-PLACED-BY    PIC X(25).                           
       01  LINK-ALT-CONTACT        PIC X(25).                           
       01  LINK-ALT-PHONE          PIC X(10).                           
       01  LINK-EW-FL              PIC X(01).                           
       01  LINK-MTR-ACCESS-FL      PIC X(01).                           
       01  LINK-ORDER-RECVED-BY    PIC X(07).                           
       01  LINK-CALL-BEFORE-MM     PIC X(03).                           
       01  LINK-BREAKERS-FL        PIC X(01).                           
       01  LINK-DEPOSIT-AMT        PIC X(09).                           
       01  LINK-WORK-AREA          PIC X(12).                           
       01  LINK-SO-EST-LABOR-HR    PIC X(06).                           
       01  LINK-WAIVER-FL          PIC X(01).                           
       01  LINK-WAIVER-ACCT        PIC X(13).                           
       01  LINK-ADD-BILL-ADDR-FL   PIC X(01).                           
       01  LINK-ADDRESS-FORMAT     PIC X(01).                           
       01  LINK-HOUSE-NO           PIC X(15).                           
       01  LINK-ADDR-PREFIX-1      PIC X(03).                           
       01  LINK-ADDR-PREFIX-2      PIC X(02).                           
       01  LINK-STREET-NAME        PIC X(30).                           
       01  LINK-STREET-SUFFIX      PIC X(04).                           
       01  LINK-ADDR-SUFFIX        PIC X(02).                           
       01  LINK-STREET-LOC-1       PIC X(04).                           
       01  LINK-STREET-LOC-2       PIC X(11).                           
       01  LINK-TOWN               PIC X(26).                           
       01  LINK-STATE              PIC X(02).                           
       01  LINK-ZIP-CODE           PIC X(05).                           
       01  LINK-ZIP-CODE-PLUS-4    PIC X(04).                           
       01  LINK-ADDR-STREET        PIC X(55).                           
       01  LINK-ADDR-CITY-STATE    PIC X(30).                           
       01  LINK-FR-ZIP-CODE        PIC X(09).                           
       01  LINK-COUNTRY            PIC X(35).                           
       01  LINK-REVERT-FL          PIC X(01).                           
       01  LINK-XFER-FL            PIC X(01).                           
       01  LINK-XFER-ACCOUNT-NO    PIC X(13).                           
       01  LINK-ADDR-STREET-2      PIC X(55).                           
       01  LINK-ADDRESS-OVERFLOW   PIC X(35).                           
P00465 01  LINK-WELCOME-KIT-CD     PIC X(01).                           
P00718 01  LINK-BUSINESS-UNIT      PIC X(03).                           
P00836 01  LINK-WQ-FL              PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-PREMISE-NO                               
                          LINK-SERV-ORDER-NO                            
                          LINK-UPDATE-ORDER-FL                          
                          LINK-CURR-ORDER-TYPE                          
                          LINK-CURR-SCHEDULED-DT                        
                          LINK-CURR-ACCOUNT-NO                          
                          LINK-NEW-CUSTOMER-NO                          
                          LINK-NEW-SCHEDULED-DT                         
                          LINK-ARRANGEMENT-FL                           
                          LINK-START-TS                                 
                          LINK-STOP-TS                                  
                          LINK-PHONE-NO                                 
                          LINK-ORDER-PLACED-BY                          
                          LINK-ALT-CONTACT                              
                          LINK-ALT-PHONE                                
                          LINK-EW-FL                                    
                          LINK-MTR-ACCESS-FL                            
                          LINK-ORDER-RECVED-BY                          
                          LINK-CALL-BEFORE-MM                           
                          LINK-BREAKERS-FL                              
                          LINK-DEPOSIT-AMT                              
                          LINK-WORK-AREA                                
                          LINK-SO-EST-LABOR-HR                          
                          LINK-WAIVER-FL                                
                          LINK-WAIVER-ACCT                              
                          LINK-ADD-BILL-ADDR-FL                         
                          LINK-ADDRESS-FORMAT                           
                          LINK-HOUSE-NO                                 
                          LINK-ADDR-PREFIX-1                            
                          LINK-ADDR-PREFIX-2                            
                          LINK-STREET-NAME                              
                          LINK-STREET-SUFFIX                            
                          LINK-ADDR-SUFFIX                              
                          LINK-STREET-LOC-1                             
                          LINK-STREET-LOC-2                             
                          LINK-TOWN                                     
                          LINK-STATE                                    
                          LINK-ZIP-CODE                                 
                          LINK-ZIP-CODE-PLUS-4                          
                          LINK-ADDR-STREET                              
                          LINK-ADDR-CITY-STATE                          
                          LINK-FR-ZIP-CODE                              
                          LINK-COUNTRY                                  
                          LINK-REVERT-FL                                
                          LINK-XFER-FL                                  
                          LINK-XFER-ACCOUNT-NO                          
                          LINK-ADDR-STREET-2                            
                          LINK-ADDRESS-OVERFLOW                         
P00465                    LINK-WELCOME-KIT-CD                           
P00718                    LINK-BUSINESS-UNIT                            
P00836                    LINK-WQ-FL.                                   
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE        AS RETURN_CODE,             
                      :S-STATUS-CODE        AS STATUS_CODE,             
                      :S-SERV-ORDER-NO      AS SERV_ORDER_NO,           
                      :S-CHARGE-AMT         AS CHARGE_AMT,              
                      :S-NEW-ACCOUNT-NO     AS NEW_ACCOUNT_NO,          
                      :S-GAS-APPL-FL        AS GAS_APPL_FL,             
                      :S-GAS-MTR-FL         AS GAS_MTR_FL,              
                      :S-ELEC-RLSE-REQ-FL   AS ELEC_RLSE_REQ_FL,        
                      :S-ELEC-MESSAGE       AS ELEC_MESSAGE,            
                      :S-ELEC-ADTL-MESSAGE  AS ELEC_ADTL_MESSAGE,       
                      :S-ELEC-PHONE         AS ELEC_PHONE,              
                      :S-ELEC-ALT-PHONE     AS ELEC_ALT_PHONE,          
                      :S-ELEC-REV-DIST-DESC AS ELEC_REV_DIST_DESC,      
                      :S-GAS-RLSE-REQ-FL    AS GAS_RLSE_REQ_FL,         
                      :S-GAS-MESSAGE        AS GAS_MESSAGE,             
                      :S-GAS-ADTL-MESSAGE   AS GAS_ADTL_MESSAGE,        
                      :S-GAS-PHONE          AS GAS_PHONE,               
                      :S-GAS-ALT-PHONE      AS GAS_ALT_PHONE,           
                      :S-GAS-REV-DIST-DESC  AS GAS_REV_DIST_DESC,       
                      :S-ORDER-STATE-CD     AS ORDER_STATE_CD,          
P00718          LTRIM(RTRIM(:S-WORK-DISTRICT))     AS WORK_DISTRICT            
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE        AS RETURN_CODE,                     
MFA-TR*               :S-STATUS-CODE        AS STATUS_CODE,                     
MFA-TR*               :S-SERV-ORDER-NO      AS SERV_ORDER_NO,                   
MFA-TR*               :S-CHARGE-AMT         AS CHARGE_AMT,                      
MFA-TR*               :S-NEW-ACCOUNT-NO     AS NEW_ACCOUNT_NO,                  
MFA-TR*               :S-GAS-APPL-FL        AS GAS_APPL_FL,                     
MFA-TR*               :S-GAS-MTR-FL         AS GAS_MTR_FL,                      
MFA-TR*               :S-ELEC-RLSE-REQ-FL   AS ELEC_RLSE_REQ_FL,                
MFA-TR*               :S-ELEC-MESSAGE       AS ELEC_MESSAGE,                    
MFA-TR*               :S-ELEC-ADTL-MESSAGE  AS ELEC_ADTL_MESSAGE,               
MFA-TR*               :S-ELEC-PHONE         AS ELEC_PHONE,                      
MFA-TR*               :S-ELEC-ALT-PHONE     AS ELEC_ALT_PHONE,                  
MFA-TR*               :S-ELEC-REV-DIST-DESC AS ELEC_REV_DIST_DESC,              
MFA-TR*               :S-GAS-RLSE-REQ-FL    AS GAS_RLSE_REQ_FL,                 
MFA-TR*               :S-GAS-MESSAGE        AS GAS_MESSAGE,                     
MFA-TR*               :S-GAS-ADTL-MESSAGE   AS GAS_ADTL_MESSAGE,                
MFA-TR*               :S-GAS-PHONE          AS GAS_PHONE,                       
MFA-TR*               :S-GAS-ALT-PHONE      AS GAS_ALT_PHONE,                   
MFA-TR*               :S-GAS-REV-DIST-DESC  AS GAS_REV_DIST_DESC,               
MFA-TR*               :S-ORDER-STATE-CD     AS ORDER_STATE_CD,                  
MFA-TR*         STRIP(:S-WORK-DISTRICT)     AS WORK_DISTRICT                    
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE),'USA')
            INTO
              :WS-CURRENT-DATE-USA       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE-USA = CHAR(CURRENT_DATE,USA)               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-LAST-YEAR                                
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 1 YEAR)                        
MFA-TR*          INTO :WS-DATE-LAST-YEAR                                        
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-WAIVER-FL <= SPACES                                  
               MOVE 'N' TO LINK-WAIVER-FL
           END-IF.                              
           IF LINK-UPDATE-ORDER-FL <= SPACES                            
               MOVE 'N' TO LINK-UPDATE-ORDER-FL
           END-IF.                        
           IF LINK-EW-FL <= SPACES                                      
               MOVE 'N' TO LINK-EW-FL
           END-IF.                                  
           IF LINK-MTR-ACCESS-FL <= SPACES                              
               MOVE 'N' TO LINK-MTR-ACCESS-FL
           END-IF.                          
           IF LINK-WAIVER-ACCT NOT NUMERIC                              
               MOVE ZEROES TO LINK-WAIVER-ACCT
           END-IF.                         
           IF LINK-REVERT-FL <= SPACES                                  
               MOVE 'N' TO LINK-REVERT-FL
           END-IF.                              
           IF LINK-XFER-FL <= SPACES                                    
               MOVE 'N' TO LINK-XFER-FL
           END-IF.                                
           IF LINK-CALL-BEFORE-MM = '060'                               
               MOVE '60 ' TO LINK-CALL-BEFORE-MM
           END-IF.                       
           IF LINK-CALL-BEFORE-MM = '045'                               
               MOVE '45 ' TO LINK-CALL-BEFORE-MM
           END-IF.                       
           IF LINK-CALL-BEFORE-MM = '030'                               
               MOVE '30 ' TO LINK-CALL-BEFORE-MM
           END-IF.                       
           IF LINK-CALL-BEFORE-MM = '015'                               
               MOVE '15 ' TO LINK-CALL-BEFORE-MM
           END-IF.                       
           IF LINK-CALL-BEFORE-MM = '000' OR '00 ' OR '0  '             
               MOVE SPACES TO LINK-CALL-BEFORE-MM
           END-IF.                      
P00465     IF LINK-WELCOME-KIT-CD = 'E' OR 'P'                          
P00465         NEXT SENTENCE                                            
P00465     ELSE                                                         
P00465         MOVE SPACES TO LINK-WELCOME-KIT-CD
           END-IF.                      
A05189     IF LINK-WORK-AREA(1:4) = 'AROP'                              
A05189         MOVE 'Y' TO WS-AROP-FL                                   
A05189     ELSE                                                         
A05189         MOVE 'N' TO WS-AROP-FL
           END-IF.                                  
P00836     IF LINK-WQ-FL <= SPACES                                      
P00836         MOVE 'N' TO LINK-WQ-FL
           END-IF.                                  
                                                                        
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE '0000000000000' TO LINK-SERV-ORDER-NO
           END-IF.              
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR.            
           MOVE WS-SERV-ORDER-NO-NUM TO VQ-SERV-ORDER-NO                
                                        VI-SERV-ORDER-NO                
                                        WS-HOLD-SERV-ORDER-NO.          
                                                                        
           IF LINK-CURR-ACCOUNT-NO NOT NUMERIC                          
               MOVE '0000000000000' TO LINK-CURR-ACCOUNT-NO
           END-IF.            
           MOVE LINK-CURR-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.             
           IF WS-ACCOUNT-NO-NUM > 0                                     
               MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                  
               PERFORM 7700-SELECT-CURR-ACCOUNT THRU 7700-EXIT
           END-IF.         
           MOVE 0 TO AT-ACCOUNT-NO.                                     
                                                                        
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE '0000000000' TO LINK-PREMISE-NO
           END-IF.                    
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO-CHAR.                  
           MOVE WS-PREMISE-NO-NUM TO VO-PREMISE-NO                      
                                     PR-PREMISE-NO                      
                                     LA-PREMISE-NO                      
                                     RP-PREMISE-NO                      
                                     SI-PREMISE-NO                      
                                     MH-PREMISE-NO.                     
                                                                        
           IF LINK-REVERT-FL = 'Y'                                      
               PERFORM 7900-SELECT-LANDLORD THRU 7900-EXIT              
               MOVE WS-LLRD-CUSTOMER-NO-CHAR TO LINK-NEW-CUSTOMER-NO
           END-IF.   
           IF LINK-NEW-CUSTOMER-NO NOT NUMERIC                          
               MOVE '0000000000' TO LINK-NEW-CUSTOMER-NO
           END-IF.               
                                                                        
           IF LINK-DEPOSIT-AMT NOT NUMERIC                              
               MOVE ZEROES TO LINK-DEPOSIT-AMT
           END-IF.                         
           MOVE LINK-DEPOSIT-AMT TO WS-DEPOSIT-AMT.                     
           MOVE WS-DEPOSIT-AMT(1:7) TO WS-DEPOSIT-AMT-DEC(1:7).         
           MOVE WS-DEPOSIT-AMT(8:2) TO WS-DEPOSIT-AMT-DEC(8:2).         
                                                                        
           IF LINK-SO-EST-LABOR-HR NOT NUMERIC                          
               MOVE ZEROES TO LINK-SO-EST-LABOR-HR
           END-IF.                     
           MOVE LINK-SO-EST-LABOR-HR TO WS-SO-EST-LABOR-HR.             
           MOVE WS-SO-EST-LABOR-HR(1:5) TO WS-SO-EST-LABOR-HR-DEC(1:5). 
           MOVE WS-SO-EST-LABOR-HR(6:1) TO WS-SO-EST-LABOR-HR-DEC(6:1). 
                                                                        
           IF LINK-XFER-ACCOUNT-NO NOT NUMERIC                          
               MOVE '0000000000000' TO LINK-XFER-ACCOUNT-NO
           END-IF.            
           MOVE LINK-XFER-ACCOUNT-NO TO WS-ACCOUNT-XFER-CHAR.           
                                                                        
           MOVE LINK-NEW-SCHEDULED-DT(1:10) TO WS-LINK-SCHEDULED-DT.    
                                                                        
           MOVE 0 TO SV-STD-LABOR-CHRG.                                 
                                                                        
           IF LINK-REVERT-FL = 'Y'                                      
              IF LINK-XFER-FL = 'Y'                                     
                  MOVE 'X' TO WS-SCENARIO                               
              ELSE                                                      
                  MOVE 'R' TO WS-SCENARIO                               
              END-IF                                                    
           ELSE                                                         
              MOVE 'C' TO WS-SCENARIO
           END-IF.                                  
                                                                        
           IF LINK-REVERT-FL = 'N' OR ' '                               
               IF LINK-ADD-BILL-ADDR-FL = 'S'                           
                   MOVE 'N' TO LINK-ADD-BILL-ADDR-FL                    
               END-IF                                                   
           ELSE                                                         
               IF LINK-ADD-BILL-ADDR-FL = 'S'                           
                   IF WS-BILL-ADDRESS-EXISTS = 'N'                      
                       MOVE 'N' TO LINK-ADD-BILL-ADDR-FL                
                   ELSE                                                 
                       PERFORM 7100-SELECT-PREMISE THRU 7100-EXIT       
                       PERFORM 5400-FORMAT-SERVICE-ADDRESS THRU         
                               5400-EXIT                                
                   END-IF                                               
               END-IF                                                   
               IF LINK-ADD-BILL-ADDR-FL = 'Y' AND                       
                  LINK-ADDRESS-FORMAT = 'A' AND                         
                  AT-ADDRESS-FORMAT = 'A' AND                           
                  WS-BILL-ADDRESS-EXISTS = 'Y'                          
                      PERFORM 5450-COMPARE-ADDRESSES THRU 5450-EXIT
               END-IF
           END-IF.    
                                                                        
           PERFORM 7180-GET-RESP-AREA THRU 7180-EXIT.                   
           PERFORM 1100-FORMAT-TRANS-HIST THRU 1100-EXIT.               
           MOVE 'N' TO WS-EXISTING-ORDER-FL.                            
           MOVE 0 TO WS-COUNT-ORDERS                                    
                     RS-STATUS-CODE.                                    
           PERFORM 7000-COUNT-ORDERS THRU 7000-EXIT.                    
           IF WS-COUNT-ORDERS > 1                                       
               MOVE +150 TO RS-STATUS-CODE
           END-IF.                             
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7010-SELECT-ORDER THRU 7010-EXIT                 
               IF LINK-SERV-ORDER-NO = ZEROES                           
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
                                            VQ-SERV-ORDER-NO            
                                            VI-SERV-ORDER-NO            
                   MOVE WS-SERV-ORDER-NO-CHAR TO LINK-SERV-ORDER-NO
               END-IF
           END-IF.    
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 3200-SET-ORDER-REASON THRU 3200-EXIT             
               PERFORM 7100-SELECT-PREMISE THRU 7100-EXIT               
               IF WS-ACCT-WK-TYPE-FL = 'O' OR                           
                  WS-NEW-ORDER-FL = 'N'                                 
                      PERFORM 3000-CALL-CSR01121 THRU 3000-EXIT         
               END-IF                                                   
               PERFORM 3100-CALL-CSR02210 THRU 3100-EXIT                
               PERFORM 4000-ADD-ORDER THRU 4000-EXIT                    
               IF RS-STATUS-CODE = 0                                    
P00817*            IF WS-LIGHTING-CONTRACT-FL = 'Y'                             
P00817*                PERFORM 8100-INSERT-LIGHT-RQMT THRU 8100-EXIT            
P00817*                IF WS-BUILDER-LIGHTING-FL = 'Y'                          
P00817*                    MOVE '1' TO ROUTING-CATEGORY-0028                    
P00817*                    MOVE 461 TO CATEGORY-ID-0028                         
P00817*                    MOVE WS-WQ-COMMENTS-1 TO COMMENTS-0028-TEXT          
P00817*                    MOVE 115 TO COMMENTS-0028-LEN                        
P00817*                    MOVE WS-ACCOUNT-NO-NUM TO ACCOUNT-NO-0028            
P00817*                    MOVE WS-CURR-CUSTOMER-NO-NUM TO                      
P00817*                         CUSTOMER-NO-0028                                
P00817*                    PERFORM 4210-CALL-CSR00028 THRU 4210-EXIT            
P00817*                END-IF                                                   
P00817*            END-IF                                                       
                   IF WS-CHANGE-LOG-REMARKS > ' '                       
                       PERFORM 5000-CALL-CSR00425 THRU 5000-EXIT        
                   END-IF                                               
                   PERFORM 5010-ORDER-COMMENTS THRU 5010-EXIT           
                   IF WS-EXISTING-ORDER-FL = 'N'                        
                       PERFORM 8300-UPDATE-PREMISE THRU 8300-EXIT       
                   END-IF                                               
                   IF LINK-ARRANGEMENT-FL = 'A' OR 'P'                  
                       PERFORM 8400-ADD-APPOINTMENT THRU 8400-EXIT      
                   END-IF                                               
                   IF WS-DEPOSIT-AMT-DEC > 0                            
                       PERFORM 5020-CALL-CSR02072 THRU 5020-EXIT        
                   ELSE                                                 
                       IF LINK-WAIVER-FL NOT = 'N'                      
                           PERFORM 5030-CALL-CSR02165 THRU 5030-EXIT    
                       END-IF                                           
                   END-IF                                               
                   IF PR-COMPANY-NO = '26' AND                          
                      LINK-NEW-CUSTOMER-NO = WS-CURR-CUSTOMER-NO-CHAR   
                          PERFORM 5040-PSNC-SERVICE-CHARGES THRU        
                                  5040-EXIT                             
                   END-IF                                               
                   IF WS-ORDER-ON-HOLD-FL = 'Y'                         
                       PERFORM 5060-HOLD-REMARKS THRU 5060-EXIT         
                   END-IF                                               
A05189             IF WS-AROP-FL = 'Y'                                  
A05189                 PERFORM 5065-AROP-REMARKS THRU 5065-EXIT         
A05189             END-IF                                               
                   IF LINK-MTR-ACCESS-FL = 'Y'                          
                       PERFORM 5070-SPECIAL-INST THRU 5070-EXIT         
                   END-IF                                               
                   IF LINK-XFER-FL = 'Y'                                
                       PERFORM 5500-XFER-PROCESSING THRU 5500-EXIT      
                   END-IF                                               
                   MOVE 'N' TO RS-GAS-APPL-FL                           
                               RS-GAS-MTR-FL                            
                   IF LINK-ADD-BILL-ADDR-FL = 'Y'                       
                       IF LINK-REVERT-FL = 'Y'                          
                           PERFORM 5540-CALL-CSR00148 THRU 5540-EXIT    
                       ELSE                                             
                           PERFORM 5080-CALL-CSR02049 THRU 5080-EXIT    
                       END-IF                                           
                   END-IF                                               
                   IF WS-APPLIANCE-FL = 'Y' AND WS-UNBLOCK-GAS-FL = 'Y' 
                       MOVE 'A' TO RS-GAS-APPL-FL                       
A01114                 IF PR-COMPANY-NO = '01' AND                      
A01114                    WS-SEASONAL-APP-FL = 'N'                      
A01114                        PERFORM 7210-GET-LOCAL-OFFICE THRU        
A01114                                7210-EXIT                         
A01114                        PERFORM 7220-GET-WORK-AREA THRU           
A01114                                7220-EXIT                         
A01114                        IF WS-COMBO-DIST-LO-FL = 'Y' AND          
A01114                           WS-GAS-WORK-AREA-FL = 'N'              
A01114                               PERFORM 8810-UPDATE-APPL-CDP THRU  
A01114                                       8810-EXIT                  
A01114                        END-IF                                    
A01114                 END-IF                                           
                   END-IF                                               
                   IF WS-APPLIANCE-FL = 'Y' AND                         
                      WS-READ-GAS-MTR-FL = 'Y'                          
                          MOVE 'B' TO RS-GAS-APPL-FL                    
                   END-IF                                               
                   IF WS-UNBLOCK-GAS-FL = 'Y'                           
                       MOVE 'U' TO RS-GAS-MTR-FL                        
                   END-IF                                               
P00465             IF LINK-WELCOME-KIT-CD = 'E' OR 'P'                  
P00465                 MOVE LINK-NEW-CUSTOMER-NO TO                     
P00465                      WS-LINK-CUSTOMER-NO-CHAR                    
P00465                 MOVE WS-LINK-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO   
P00465                 PERFORM 7970-SELECT-CUST THRU 7970-EXIT          
P00465                 IF LINK-WELCOME-KIT-CD NOT = CU-WELCOME-KIT-CD   
P00465                     PERFORM 8820-UPDATE-CUST THRU 8820-EXIT      
P00465                 END-IF                                           
P00465             END-IF                                               
                   PERFORM 5090-CALL-CSR02517 THRU 5090-EXIT            
                   IF VO-ACCOUNT-NO > 0 AND                             
                      WS-NEW-ORDER-FL = 'N'                             
                      PERFORM 5200-DELETE-PENDING-ACCOUNT THRU          
                              5200-EXIT                                 
                   END-IF                                               
A05189             IF LINK-SERV-ORDER-NO NOT = ZEROES AND               
A05189                LINK-UPDATE-ORDER-FL = 'Y' AND                    
A05189                LINK-CURR-ORDER-TYPE = 'OFF01' AND                
A05189                LINK-WORK-AREA(1:4) = 'AROP'                      
A05189                    PERFORM 4220-CALL-CSR04747 THRU 4220-EXIT     
A05189             END-IF                                               
P00836             IF LINK-WQ-FL = 'Y'                                  
P00836                 MOVE LINK-NEW-CUSTOMER-NO TO                     
P00836                      WS-LINK-CUSTOMER-NO-CHAR                    
P00836                 MOVE WS-LINK-CUSTOMER-NO-NUM TO NE-CUSTOMER-NO   
P00836                 PERFORM 7990-EMAIL-ADDRESS THRU 7990-EXIT        
P00836                 MOVE NE-EMAIL-ADDRESS-TX-TEXT TO                 
P00836                      WS-WQ-EMAIL-ADDRESS                         
P00836                 MOVE WS-CUST-NAME TO WS-WQ-CUST-NAME             
ACT233                 MOVE '4' TO ROUTING-CATEGORY-4675                
ACT233                 MOVE 603 TO CATEGORY-ID-4675                     
ACT233                 MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT      
ACT233                 MOVE 240 TO COMMENTS-4675-LEN                    
ACT233                 MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-4675          
ACT233                 MOVE CUSTOMER-NO-2054 TO CUSTOMER-NO-4675        
ACT233                 MOVE 'H' TO WQ-PRIORITY-4675                     
ACT233                 PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT        
P00836             END-IF
               END-IF
           END-IF.                                              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-FORMAT-TRANS-HIST.                                          
                                                                        
           MOVE ZEROES                      TO MH-CUSTOMER-NO           
                                               MH-ACCOUNT-NO.           
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE LINK-ORDER-RECVED-BY        TO MH-USER-ID.              
           MOVE 'CSR04105'                  TO MH-APPL-PROGRAM-ID.      
           MOVE 0                           TO MH-TRAN-COMMENT-LEN      
           MOVE SPACES                      TO MH-TRAN-COMMENT-TEXT.    
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF RS-STATUS-CODE NOT = 0                                    
               CONTINUE                                                 
           ELSE                                                         
               IF LINK-XFER-FL = 'Y'                                    
                   PERFORM 6800-UPDATE-WEB-EVENT THRU 6800-EXIT         
               ELSE                                                     
                   PERFORM 6700-WRITE-WEB-EVENT THRU 6700-EXIT
               END-IF
           END-IF.         
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
A01798      IF WS-CHARGE-AMT = 0                                        
A01798          COMPUTE WS-TOTAL-CHARGES =                              
A01798                  WS-DEPOSIT-AMT-DEC +                            
A01798                  SV-STD-LABOR-CHRG                               
A01798          MOVE WS-TOTAL-CHARGES TO WS-CHARGE-AMT
            END-IF.                 
                                                                        
            COMPUTE WS-CHARGE-AMT-NODEC =                               
                    WS-CHARGE-AMT * 100.                                
            MOVE WS-CHARGE-AMT-NODEC TO RS-CHARGE-AMT.                  
                                                                        
            MOVE RS-RETURN-CODE       TO S-RETURN-CODE.                 
            MOVE RS-STATUS-CODE       TO S-STATUS-CODE.                 
            MOVE RS-SERV-ORDER-NO     TO S-SERV-ORDER-NO.               
            MOVE RS-CHARGE-AMT        TO S-CHARGE-AMT.                  
            MOVE RS-NEW-ACCOUNT-NO    TO S-NEW-ACCOUNT-NO.              
            MOVE RS-GAS-APPL-FL       TO S-GAS-APPL-FL.                 
            MOVE RS-GAS-MTR-FL        TO S-GAS-MTR-FL.                  
            MOVE RS-ELEC-RLSE-REQ-FL  TO S-ELEC-RLSE-REQ-FL.            
            MOVE RS-ELEC-MESSAGE      TO S-ELEC-MESSAGE.                
            MOVE RS-ELEC-ADTL-MESSAGE TO S-ELEC-ADTL-MESSAGE.           
            MOVE RS-ELEC-PHONE        TO S-ELEC-PHONE.                  
            MOVE RS-ELEC-ALT-PHONE    TO S-ELEC-ALT-PHONE.              
            MOVE RS-ELEC-REV-DIST-DESC TO S-ELEC-REV-DIST-DESC.         
            MOVE RS-GAS-RLSE-REQ-FL   TO S-GAS-RLSE-REQ-FL.             
            MOVE RS-GAS-MESSAGE       TO S-GAS-MESSAGE.                 
            MOVE RS-GAS-ADTL-MESSAGE  TO S-GAS-ADTL-MESSAGE.            
            MOVE RS-GAS-PHONE         TO S-GAS-PHONE.                   
            MOVE RS-GAS-ALT-PHONE     TO S-GAS-ALT-PHONE.               
            MOVE RS-GAS-REV-DIST-DESC TO S-GAS-REV-DIST-DESC.           
            MOVE RS-SERVICE-CHG-FL    TO S-SERVICE-CHG-FL.              
            MOVE RS-ORDER-STATE-CD    TO S-ORDER-STATE-CD.              
P00718      MOVE RS-WORK-DISTRICT     TO S-WORK-DISTRICT.               
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ****************************************************************          
      **  CALL CSR01121 TO GET DATA FOR EXISTING ORDER.  DATA WILL  **          
      **  BE LOADED INTO THE T2-CSR01121 WORKING STORAGE TABLE.     **          
      **  ROUTINE IS CALLED WHEN THE EXISTING ORDER IS TO BE        **          
      **  UPDATED OR WHEN THE WORK TYPE IS DERIVED FROM THE ORDER   **          
      ****************************************************************          
                                                                        
       3000-CALL-CSR01121.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-1121.               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01121                                             
      *           (:SERV-ORDER-NO-1121,                                 
      *            'C')                                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1121
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1121
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1121 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01121'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1121    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1121)                                                
      *       WITH PROCEDURE CSR01121                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1121 CURSOR FOR RESULT SET        
      *       :LOC1121                                                  
      *    END-EXEC.                                                    
                                                                        
           SET T2-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1121 INTO                          
                   :RETURN-CODE-1121,                                   
                   :CODE-UTIL-TYPE-1121,                                
                   :SO-INST-SEQ-NO-1121,                                
                   :RATE-PLAN-NO-1121,                                  
                   :RATE-DESC-1121,                                     
                   :METER-NO-1121,                                      
                   :METER-LOC-DESC-1121,                                
                   :CODE-MTR-STATUS-WS-1121,                            
                   :CODE-STATUS-REA-WS-1121,                            
                   :METER-SUPPLYING-1121,                               
                   :WORK-TYPE-CD-1121,                                  
                   :HOLD-RELEASE-1121,                                  
                   :RLSE-NO-1121,                                       
                   :RLSE-DATE-1121 :WS-NULL-RLSE-DT,                     
                   :CODE-METER-LOC-1121,                                
                   :PER-TEMP-IND-1121,                                  
                   :IC-NO-1121,                                         
                   :METER-IND-1121,                                     
                   :MTR-REF-NO-1121,                                    
                   :RLSE-IND-1121                                       
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-1121 NOT = 0                        
                         MOVE RETURN-CODE-1121 TO RS-STATUS-CODE        
                                                  WS-ACTIVE-RETURN-CODE 
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3000'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR01121'        TO TABLE-1              
                         MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1      
                         MOVE SERV-ORDER-NO-1121 TO HOSTVAR-ELEMENT-1   
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
                     IF WS-NULL-RLSE-DT < 0                             
                         MOVE SPACES TO RLSE-DATE-1121                  
                     END-IF                                             
                     PERFORM 3010-LOAD-CSR01121-TABLE THRU 3010-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3000'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01121'            TO TABLE-1              
                     MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1      
                     MOVE SERV-ORDER-NO-1121    TO HOSTVAR-ELEMENT-1    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD ORDER DATA INTO T2-CSR01121 WORKING STORAGE TABLE.   **          
      **  THE ROWCOUNT FOR THIS TABLE IS IN WS-T2-ROWCOUNT.         **          
      ****************************************************************          
                                                                        
       3010-LOAD-CSR01121-TABLE.                                        
                                                                        
           MOVE CODE-UTIL-TYPE-1121 TO T2-CODE-UTIL-TYPE (T2-INDEX).    
           MOVE SO-INST-SEQ-NO-1121 TO T2-SO-INST-SEQ-NO (T2-INDEX).    
           MOVE RATE-PLAN-NO-1121 TO T2-RATE-PLAN-NO (T2-INDEX).        
           MOVE RATE-DESC-1121 TO T2-RATE-DESC (T2-INDEX).              
           MOVE METER-NO-1121 TO T2-METER-NO (T2-INDEX).                
           MOVE METER-LOC-DESC-1121 TO T2-METER-LOC-DESC (T2-INDEX).    
           MOVE CODE-MTR-STATUS-WS-1121 TO                              
                T2-CODE-MTR-STATUS-WS (T2-INDEX).                       
           MOVE CODE-STATUS-REA-WS-1121 TO                              
                T2-CODE-STATUS-REA-WS (T2-INDEX).                       
           MOVE METER-SUPPLYING-1121 TO T2-METER-SUPPLYING (T2-INDEX).  
           MOVE WORK-TYPE-CD-1121 TO T2-OLD-WORK-TYPE-CD (T2-INDEX).    
           MOVE HOLD-RELEASE-1121 TO T2-HOLD-RELEASE (T2-INDEX).        
           MOVE RLSE-NO-1121 TO T2-RLSE-NO (T2-INDEX).                  
           MOVE RLSE-DATE-1121 TO T2-RLSE-DATE (T2-INDEX).              
           MOVE CODE-METER-LOC-1121 TO T2-CODE-METER-LOC (T2-INDEX).    
           MOVE PER-TEMP-IND-1121 TO T2-PER-TEMP-IND (T2-INDEX).        
           MOVE IC-NO-1121 TO T2-IC-NO (T2-INDEX).                      
           MOVE METER-IND-1121 TO T2-METER-IND (T2-INDEX).              
           MOVE MTR-REF-NO-1121 TO T2-MTR-REF-NO (T2-INDEX).            
           MOVE RLSE-IND-1121 TO T2-RLSE-IND (T2-INDEX).                
           MOVE SPACES TO T2-WORK-TYPE-CD (T2-INDEX)                    
                          T2-RLSE-REQUIRED (T2-INDEX).                  
           ADD 1 TO WS-T2-ROWCOUNT.                                     
           SET T2-INDEX UP BY 1.                                        
                                                                        
       3010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02210 TO GET DATA FOR THE ACCOUNT.  DATA WILL BE  **          
      **  LOADED INTO THE T3-CSR02210 WORKING STORAGE TABLE.        **          
      **  ROUTINE IS CALLED FOR ALL ORDERS.                         **          
      ****************************************************************          
                                                                        
       3100-CALL-CSR02210.                                              
                                                                        
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2210.                
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2210.                     
           MOVE PR-COMPANY-NO TO COMPANY-NO-2210.                       
           MOVE 'N' TO MKTG-ORDER-2210.                                 
           MOVE 'Y' TO RETURN-UTILS-2210.                               
           MOVE 'N' TO RETURN-DISC-BAL-2210.                            
           MOVE ' ' TO ORDER-REASON-2210.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02210                                             
      *           (:ACCOUNT-NO-2210,                                    
      *            :PREMISE-NO-2210,                                    
      *            :COMPANY-NO-2210,                                    
      *            :MKTG-ORDER-2210,                                    
      *            :RETURN-UTILS-2210,                                  
      *            :RETURN-DISC-BAL-2210,                               
      *            :ORDER-REASON-2210)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2210 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02210'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-CURR-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2210)                                                
      *       WITH PROCEDURE CSR02210                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2210 CURSOR FOR RESULT SET        
      *       :LOC2210                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           SET T3-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2210 INTO                          
                   :RETURN-CODE-2210,                                   
                   :ACTIVE-PARA-2210,                                   
                   :TABLE-NAME-2210,                                    
                   :TABLE-ID-2210,                                      
                   :UT-CODE-UTIL-TY-2210,                               
                   :UT-IC-NO-2210,                                      
                   :UT-READ-ROUTE-2210,                                 
                   :UT-RATE-PLAN-NO-2210,                               
                   :UT-RATE-DESC-2210,                                  
                   :UT-CODE-REV-CLA-2210,                               
                   :UT-READ-CYCLE-2210,                                 
                   :UT-CODE-SIC-NO-2210,                                
                   :MN-METER-NO-2210,                                   
                   :MN-MTR-REF-NO-2210,                                 
                   :MN-CODE-TIME-PE-2210,                               
                   :MN-LAST-READ-VA-2210,                               
                   :MN-CD-STUS-RS-2210,                                 
                   :MN-CODE-USAGE-T-2210,                               
                   :MN-CODE-USAGE-I-2210,                               
                   :MN-CODE-USAGE-S-2210,                               
                   :MN-CODE-METER-S-2210,                               
                   :MN-METER-SUPPLY-2210,                               
                   :MN-CODE-METER-L-2210,                               
                   :MN-METER-LOC-DE-2210,                               
                   :MN-METER-IND-2210,                                  
                   :MN-CONSTANT-2210,                                   
                   :MN-NO-DIALS-2210,                                   
                   :MN-DIST-NODE-PO-2210,                               
                   :MN-POINT-ID-2210,                                   
                   :MN-SEAL-CODE-ID-2210,                               
                   :MN-HEX-LOCATION-2210,                               
                   :MN-INSULATED-IN-2210,                               
                   :MN-LOCK-TYPE-ID-2210,                               
                   :MN-DELIVERY-LEV-2210,                               
                   :MN-UTILITY-SOUR-2210,                               
                   :MN-IDR-RECIPIEN-2210,                               
                   :MN-PROGRAM-ID-2210,                                 
                   :MN-MTR-READ-SO-2210,                                
                   :RG-CODE-REG-ST-2210,                                
                   :RG-CODE-STATUS-2210,                                
                   :RG-CODE-TIME-P-2210,                                
                   :RG-CODE-USAGE-2210,                                 
                   :RG-CD-USG-SRC-2210,                                 
                   :RG-CD-USG-TYP-2210,                                 
                   :RG-LAST-READD-2210,                                 
                   :RG-LST-READVL-2210,                                 
                   :RG-REG-ID-NO-2210,                                  
                   :CP-NO-UNITS-2210,                                   
                   :CP-CODE-PLAN-2210,                                  
                   :CP-CD-STATRS-2210,                                  
                   :CP-CD-SVC-TYP-2210,                                 
                   :CP-MTLY-AMT-FX-2210,                                
                   :CP-RT-ITEM-CD-2210,                                 
                   :CP-LIGHT-NO-2210,                                   
                   :CP-POLE-NO-2210,                                    
                   :CP-DIST-NO-2210,                                    
                   :CP-USAGE-FIXED-2210,                                
                   :CP-ITEM-SEQ-NO-2210,                                
                   :CP-EQUIP-ID-2210,                                   
                   :PREM-DIR-IND-2210,                                  
                   :SUBDIV-LIGHT-2210,                                  
                   :ACCT-TYPE-2210,                                     
                   :CD-RNTL-PROP-2210,                                  
                   :LL-CUSTOMER-NO-2210,                                
                   :REV-DIST-CD-2210,                                   
                   :DISC-BAL-2210,                                      
                   :OUT-ACCOUNT-NO-2210,                                
                   :ACCT-STATUS-2210,                                   
                   :ROW-NO-2210,                                        
                   :DEPOSIT-AMT-2210,                                   
                   :SEC-TOT-AMT-2210,                                   
                   :CUR-MTH-ARR-CD-2210,                                
                   :CREDIT-GROUP-2210,                                  
                   :CURRENT-ACCOUNT-2210,                               
                   :DATE-BNKRPT-FL-2210,                                
                   :FILED-CASE-NO-2210,                                 
                   :DL-NO-2210,                                         
                   :DL-STATE-2210,                                      
                   :SSN-2210,                                           
                   :PRIOR-ACCT-STAT-2210,                               
                   :READ-CYCLE-2210,                                    
                   :SERV-STRT-DT-2210,                                  
                   :DEP-INTST-RT-2210,                                  
                   :CP-DT-PLN-ST-2210,                                  
                   :ACTIVE-CONTRACT-2210,                               
                   :SECURED-RATE-FL-2210,                               
                   :MN-CODE-MTR-RD-2210,                                
                   :MN-MTR-PRESS-2210,                                  
P00390             :ERROR-MSG-NO-02-2210,                               
P00390             :ERROR-MSG-NO-A4-2210                                
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-2210 NOT = 0                        
                         MOVE RETURN-CODE-2210  TO RS-STATUS-CODE       
                                                  WS-ACTIVE-RETURN-CODE 
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR02210'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE LINK-CURR-ACCOUNT-NO TO HOSTVAR-ELEMENT-1 
                         MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-2      
                         MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-2    
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
                     PERFORM 3110-LOAD-CSR02210-TABLE THRU 3110-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02210'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE LINK-CURR-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1    
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2      
                     MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD ACCOUNT DATA INTO THE T3-CSR02210 WORKING STORAGE    **          
      **  TABLE. THE ROWCOUNT FOR THIS TABLE IS IN WS-T3-ROWCOUNT.  **          
      ****************************************************************          
                                                                        
       3110-LOAD-CSR02210-TABLE.                                        
                                                                        
           MOVE TABLE-ID-2210 TO T3-TABLE-ID (T3-INDEX).                
           MOVE MN-CODE-METER-S-2210 TO T3-MN-CODE-METER-S (T3-INDEX).  
           MOVE UT-CODE-UTIL-TY-2210 TO T3-UT-CODE-UTIL-TYPE (T3-INDEX).
           IF UT-CODE-UTIL-TY-2210 = 'G'                                
               MOVE 'Y' TO WS-GAS-UT-EXISTS
           END-IF.                            
           MOVE UT-IC-NO-2210 TO T3-UT-IC-NO (T3-INDEX).                
           MOVE UT-READ-ROUTE-2210 TO T3-UT-READ-ROUTE (T3-INDEX).      
           MOVE UT-RATE-PLAN-NO-2210 TO T3-UT-RATE-PLAN-NO (T3-INDEX).  
           MOVE UT-RATE-DESC-2210 TO T3-UT-RATE-DESC (T3-INDEX).        
           MOVE UT-CODE-REV-CLA-2210 TO                                 
                T3-UT-CODE-REV-CLASS (T3-INDEX).                        
           MOVE UT-READ-CYCLE-2210 TO T3-UT-READ-CYCLE (T3-INDEX).      
           MOVE UT-CODE-SIC-NO-2210 TO T3-UT-CODE-SIC-NO (T3-INDEX).    
           MOVE MN-METER-NO-2210 TO T3-MN-METER-NO (T3-INDEX).          
           MOVE MN-MTR-REF-NO-2210 TO T3-MN-MTR-REF-NO (T3-INDEX).      
           MOVE MN-CODE-TIME-PE-2210 TO T3-MN-CODE-TIME-PER (T3-INDEX). 
           MOVE MN-LAST-READ-VA-2210 TO T3-MN-LAST-READ-VAL (T3-INDEX). 
           MOVE MN-CD-STUS-RS-2210 TO T3-MN-CD-STAT-REAS (T3-INDEX).    
           MOVE MN-CODE-USAGE-T-2210 TO T3-MN-CODE-USAGE-T (T3-INDEX).  
           MOVE MN-CODE-USAGE-I-2210 TO T3-MN-CODE-USAGE-I (T3-INDEX).  
           MOVE MN-CODE-USAGE-S-2210 TO T3-MN-CODE-USAGE-S (T3-INDEX).  
           MOVE MN-CODE-METER-S-2210 TO T3-MN-CODE-METER-S (T3-INDEX).  
           MOVE MN-METER-SUPPLY-2210 TO T3-MN-METER-SUPPLY (T3-INDEX).  
           MOVE MN-CODE-METER-L-2210 TO                                 
                T3-MN-CODE-METER-LOC (T3-INDEX).                        
           MOVE MN-METER-LOC-DE-2210 TO                                 
                T3-MN-METER-LOC-DESC (T3-INDEX).                        
           MOVE MN-METER-IND-2210 TO T3-MN-METER-IND (T3-INDEX).        
           MOVE MN-CONSTANT-2210 TO T3-MN-CONSTANT (T3-INDEX).          
           MOVE MN-NO-DIALS-2210 TO T3-MN-NO-DIALS (T3-INDEX).          
           MOVE MN-DIST-NODE-PO-2210 TO                                 
                T3-MN-DIST-NODE-PO (T3-INDEX).                          
           MOVE MN-POINT-ID-2210 TO T3-MN-POINT-ID (T3-INDEX).          
           MOVE MN-SEAL-CODE-ID-2210 TO T3-MN-SEAL-CODE-ID (T3-INDEX).  
           MOVE MN-HEX-LOCATION-2210 TO T3-MN-HEX-LOCATION (T3-INDEX).  
           MOVE MN-INSULATED-IN-2210 TO T3-MN-INSULATED-IND (T3-INDEX). 
           MOVE MN-LOCK-TYPE-ID-2210 TO T3-MN-LOCK-TYPE-ID (T3-INDEX).  
           MOVE MN-DELIVERY-LEV-2210 TO T3-MN-DELIVERY-LEV (T3-INDEX).  
           MOVE MN-UTILITY-SOUR-2210 TO                                 
                T3-MN-UTILITY-SOURCE (T3-INDEX).                        
           MOVE MN-IDR-RECIPIEN-2210 TO T3-MN-IDR-RECIPIENT (T3-INDEX). 
           MOVE MN-PROGRAM-ID-2210 TO T3-MN-PROGRAM-ID (T3-INDEX).      
           MOVE MN-MTR-READ-SO-2210 TO                                  
                T3-MN-MTR-READ-SOURCE (T3-INDEX).                       
           MOVE RG-LAST-READD-2210 TO T3-RG-LAST-READD (T3-INDEX).      
           MOVE RG-REG-ID-NO-2210 TO T3-RG-REG-ID-NO (T3-INDEX).        
           MOVE CP-NO-UNITS-2210 TO T3-CP-NO-UNITS (T3-INDEX).          
           MOVE CP-CODE-PLAN-2210 TO T3-CP-CODE-PLAN (T3-INDEX).        
           MOVE CP-CD-STATRS-2210 TO T3-CP-CD-STAT-REAS (T3-INDEX).     
           MOVE CP-CD-SVC-TYP-2210 TO T3-CP-CD-SVC-TYPE (T3-INDEX).     
           MOVE CP-MTLY-AMT-FX-2210 TO T3-CP-MTHLY-AMT (T3-INDEX).      
           MOVE CP-RT-ITEM-CD-2210 TO T3-CP-RT-ITEM-CD (T3-INDEX).      
           MOVE CP-LIGHT-NO-2210 TO T3-CP-LIGHT-NO (T3-INDEX).          
           MOVE CP-POLE-NO-2210 TO T3-CP-POLE-NO (T3-INDEX).            
           MOVE CP-DIST-NO-2210 TO T3-CP-DIST-NO (T3-INDEX).            
           MOVE CP-USAGE-FIXED-2210 TO T3-CP-USAGE-FIXED (T3-INDEX).    
           MOVE CP-ITEM-SEQ-NO-2210 TO T3-CP-ITEM-SEQ-NO (T3-INDEX).    
           MOVE CP-EQUIP-ID-2210 TO T3-CP-EQUIP-ID (T3-INDEX).          
           MOVE PREM-DIR-IND-2210 TO T3-PREM-DIR-IND (T3-INDEX).        
           MOVE SUBDIV-LIGHT-2210 TO T3-SUBDIV-LIGHT (T3-INDEX).        
           MOVE ACCT-TYPE-2210 TO T3-ACCT-TYPE-CODE (T3-INDEX).         
           MOVE CD-RNTL-PROP-2210 TO T3-CD-RENTAL-PROP (T3-INDEX).      
           MOVE LL-CUSTOMER-NO-2210 TO T3-LL-CUSTOMER-NO (T3-INDEX).    
           MOVE REV-DIST-CD-2210 TO T3-REV-DISTRICT-CD (T3-INDEX).      
           MOVE DISC-BAL-2210 TO T3-DISC-BAL (T3-INDEX).                
           MOVE OUT-ACCOUNT-NO-2210 TO T3-OUT-ACCOUNT-NO (T3-INDEX).    
           MOVE ACCT-STATUS-2210 TO T3-ACCT-STATUS (T3-INDEX).          
           MOVE ROW-NO-2210 TO T3-ROW-NO (T3-INDEX).                    
           MOVE DEPOSIT-AMT-2210 TO T3-DEPOSIT-AMT (T3-INDEX).          
           MOVE SEC-TOT-AMT-2210 TO T3-SEC-TOT-AMT (T3-INDEX).          
           MOVE CUR-MTH-ARR-CD-2210 TO T3-CUR-MTH-ARR-CD (T3-INDEX).    
           MOVE CREDIT-GROUP-2210 TO T3-CREDIT-GROUP (T3-INDEX).        
           MOVE CURRENT-ACCOUNT-2210 TO T3-CURRENT-ACCOUNT (T3-INDEX).  
           MOVE DATE-BNKRPT-FL-2210 TO T3-DATE-BANKRUPT (T3-INDEX).     
           MOVE FILED-CASE-NO-2210 TO T3-FILED-CASE-NO (T3-INDEX).      
           MOVE DL-NO-2210 TO T3-DL-NO (T3-INDEX).                      
           MOVE DL-STATE-2210 TO T3-DL-STATE (T3-INDEX).                
           MOVE SSN-2210 TO T3-SSN (T3-INDEX).                          
           MOVE PRIOR-ACCT-STAT-2210 TO T3-PRIOR-ACCT-STAT (T3-INDEX).  
           MOVE READ-CYCLE-2210 TO T3-READ-CYCLE (T3-INDEX).            
           MOVE SERV-STRT-DT-2210 TO T3-SERV-STRT-DT (T3-INDEX).        
           MOVE DEP-INTST-RT-2210 TO T3-DEP-INTST-RT (T3-INDEX).        
           MOVE CP-DT-PLN-ST-2210 TO T3-CP-DT-PLAN-ST (T3-INDEX).       
           MOVE ACTIVE-CONTRACT-2210 TO T3-ACTIVE-CONTRACT (T3-INDEX).  
           MOVE SECURED-RATE-FL-2210 TO T3-SECURED-RATE-FL (T3-INDEX).  
           MOVE MN-CODE-MTR-RD-2210 TO T3-MN-CODE-MTR-RD (T3-INDEX).    
           MOVE MN-MTR-PRESS-2210 TO T3-MN-MTR-PRESS (T3-INDEX).        
           MOVE SPACES TO T3-WORK-TYPE-CD (T3-INDEX)                    
                          T3-RLSE-REQUIRED (T3-INDEX)                   
                          T3-RLSE-NO (T3-INDEX)                         
                          T3-RLSE-DATE (T3-INDEX).                      
           ADD 1 TO WS-T3-ROWCOUNT.                                     
           SET T3-INDEX UP BY 1.                                        
                                                                        
       3110-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  DETERMINE THE ORDER TYPE AND REASON AND IF A NEW ORDER    **          
      **  WILL BE CREATED.                                          **          
      **  SCENARIOS:                                                **          
      **  1.  EXISTING ORDER TO BE UPDATED.  OFF BECOMES CC.        **          
      **      CC/REVERT BECOMES CC.                                 **          
      **  2.  DATE REQUESTED IS SAME AS THAT OF EXISTING ORDER, SO  **          
      **      EXISTING ORDER TO BE UPDATED.  SAME AS #1.            **          
      **  3.  DATE REQUESTED IS AFTER THAT OF EXISTING ORDER, SO    **          
      **      NEW CC ORDER TO BE CREATED.                           **          
      **  4.  DATE REQUESTED IS BEFORE THAT OF EXISTING ORDER, SO   **          
      **      EXISTING ORDER TO BE UPDATED.                         **          
      **  5.  NO ORDER EXISTS SO A NEW ONE MUST BE CREATED.         **          
      ****************************************************************          
                                                                        
       3200-SET-ORDER-REASON.                                           
                                                                        
           IF LINK-UPDATE-ORDER-FL = 'Y'                                
               MOVE 'A' TO WS-ACCT-WK-TYPE-FL                           
               MOVE 'N' TO WS-NEW-ORDER-FL                              
               MOVE 'CC001' TO WS-ORDER-TYPE-CD                         
               MOVE SPACES TO WS-ORDER-REASON                           
           ELSE                                                         
               IF WS-EXISTING-ORDER-FL = 'Y'                            
                   IF VO-ASSIGNED-DATETIME = LINK-NEW-SCHEDULED-DT      
                       MOVE 'A' TO WS-ACCT-WK-TYPE-FL                   
                       MOVE 'N' TO WS-NEW-ORDER-FL                      
                       MOVE 'CC001' TO WS-ORDER-TYPE-CD                 
                       MOVE SPACES TO WS-ORDER-REASON                   
                   END-IF                                               
                   IF VO-ASSIGNED-DATETIME < LINK-NEW-SCHEDULED-DT      
                       MOVE 'O' TO WS-ACCT-WK-TYPE-FL                   
                       MOVE 'Y' TO WS-NEW-ORDER-FL                      
                       IF VO-ORDER-TYPE-CD = 'OFF01'                    
                           MOVE 'CC001' TO WS-ORDER-TYPE-CD             
                           MOVE SPACES TO WS-ORDER-REASON               
                       ELSE                                             
                           MOVE 'CC002' TO WS-ORDER-TYPE-CD             
                           MOVE 'F' TO WS-ORDER-REASON                  
                       END-IF                                           
                   END-IF                                               
                   IF VO-ASSIGNED-DATETIME > LINK-NEW-SCHEDULED-DT      
                       MOVE 'A' TO WS-ACCT-WK-TYPE-FL                   
                       MOVE 'N' TO WS-NEW-ORDER-FL                      
                       IF VO-ORDER-TYPE-CD = 'OFF01'                    
                           MOVE 'CC001' TO WS-ORDER-TYPE-CD             
                           MOVE SPACES TO WS-ORDER-REASON               
                       ELSE                                             
                           MOVE 'CC001' TO WS-ORDER-TYPE-CD             
                           MOVE 'F' TO WS-ORDER-REASON                  
                       END-IF                                           
                   END-IF                                               
               ELSE                                                     
                   MOVE 'Y' TO WS-NEW-ORDER-FL                          
                   MOVE 'A' TO WS-ACCT-WK-TYPE-FL                       
                   MOVE 'CC001' TO WS-ORDER-TYPE-CD                     
                   IF LINK-REVERT-FL = 'Y'                              
                       MOVE 'R' TO WS-ORDER-REASON                      
                   ELSE                                                 
                       MOVE 'F' TO WS-ORDER-REASON
                   END-IF
               END-IF
           END-IF.                     
           IF WS-ORDER-REASON = 'F' AND                                 
              AT-CODE-ACCT-STAT NOT = 'A'                               
                  MOVE SPACES TO WS-ORDER-REASON
           END-IF.                       
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CREATE THE NEW ACCOUNT, GET ANY RELEASE INFOMATION AND    **          
      **  SET WORK TYPES.                                           **          
      ****************************************************************          
                                                                        
       4000-ADD-ORDER.                                                  
                                                                        
           MOVE 'N' TO WS-UNBLOCK-GAS-FL                                
                       WS-UNBLOCK-METER-FL                              
                       WS-APPLIANCE-FL                                  
A01114                 WS-SEASONAL-APP-FL                               
A01114                 WS-COMBO-DIST-LO-FL                              
A01114                 WS-GAS-WORK-AREA-FL                              
                       WS-READ-GAS-MTR-FL.                              
           MOVE SPACES TO WS-CHANGE-LOG-REMARKS                         
                          WS-SO-REMARKS.                                
                                                                        
           PERFORM 4100-CALL-CSR02054 THRU 4100-EXIT.                   
           MOVE ACCOUNT-NO-2054 TO RS-NEW-ACCOUNT-NO.                   
                                                                        
           IF WS-ACCT-WK-TYPE-FL = 'O'                                  
               PERFORM 4110-ORDER-RELEASE THRU 4110-EXIT                
                   VARYING T2-INDEX FROM 1 BY 1 UNTIL                   
SCA006             T2-INDEX > 10 OR 
                   T2-CODE-UTIL-TYPE (T2-INDEX) <= SPACES                       
           ELSE                                                         
               PERFORM 4120-ACCOUNT-RELEASE THRU 4120-EXIT              
                   VARYING T3-INDEX FROM 1 BY 1 UNTIL                   
SCA006             T3-INDEX > 80 OR 
                   T3-TABLE-ID (T3-INDEX) <= SPACES
           END-IF.                                       
                                                                        
           IF WS-NEW-ORDER-FL = 'Y'                                     
               PERFORM 4300-CHECK-FOR-SPLIT THRU 4300-EXIT              
               IF WS-SPLIT-ORDER-FL = 'Y'                               
                   EXEC SQL                                             
                       ROLLBACK                                         
                   END-EXEC                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   PERFORM 5090-CALL-CSR02517 THRU 5090-EXIT            
                   MOVE +970 TO RS-STATUS-CODE
               END-IF
           END-IF.                         
                                                                        
           IF RS-STATUS-CODE = 0                                        
               PERFORM 4010-ADD-PROCESSING THRU 4010-EXIT
           END-IF.              
                                                                        
A04670     IF RS-STATUS-CODE = 0 AND                                    
A04670        WS-NEW-ORDER-FL = 'Y'                                     
A04670            PERFORM 8450-UPDATE-SOURCE-SYSTEM THRU 8450-EXIT
           END-IF.     
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  MAIN SO ADD/UPDATE PROCESSING.  IF NO APPLIANCES EXIST    **          
      **  FOR AN UNBLOCK GAS ORDER, ADD A DUCT FURNACE.  GET DATA   **          
      **  FOR EXISTING ORDER IF NO NEW ORDER IS TO BE CREATED.  GET **          
      **  ANY EXISTING APPLIANCE DATA.  BUILD CHANGE LOG REMARKS IF **          
      **  NEEDED.  ADD/UPDATE ORDER.                                **          
      ****************************************************************          
                                                                        
       4010-ADD-PROCESSING.                                             
                                                                        
           IF WS-GAS-UT-EXISTS = 'Y' AND WS-UNBLOCK-GAS-FL = 'Y'        
               PERFORM 7120-GET-APPLIANCES THRU 7120-EXIT               
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   PERFORM 4140-CALL-CSR01297 THRU 4140-EXIT            
A01114             MOVE 'Y' TO WS-APPLIANCE-FL                          
                   IF WS-NEW-ORDER-FL = 'N'                             
                       PERFORM 7130-GET-SO-APPLIANCES THRU 7130-EXIT    
                       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                           PERFORM 8000-INSERT-SO-APPLIANCE THRU        
                                   8000-EXIT
                       END-IF
                   END-IF
               END-IF
           END-IF.                           
                                                                        
           IF WS-NEW-ORDER-FL = 'N'                                     
               PERFORM 4150-CALL-CSR01105 THRU 4150-EXIT                
               PERFORM 4160-GET-SO-APPLIANCES THRU 4160-EXIT            
               PERFORM 4180-BUILD-CHANGE-REMARKS THRU 4180-EXIT         
           ELSE                                                         
               PERFORM 4170-GET-APPLIANCES THRU 4170-EXIT
           END-IF.              
                                                                        
           EVALUATE LINK-ARRANGEMENT-FL                                 
               WHEN 'C'                                                 
P00196             MOVE 'ARRANGEMENT' TO OY-PRIORITY-DESC               
P00196             PERFORM 7960-ORDER-PRIORITY THRU 7960-EXIT           
P00196             MOVE OY-PRIORITY-CD TO WS-PRIORITY                   
               WHEN 'A'                                                 
               WHEN 'P'                                                 
P00196             MOVE 'APPOINTMENT' TO OY-PRIORITY-DESC               
P00196             PERFORM 7960-ORDER-PRIORITY THRU 7960-EXIT           
P00196             MOVE OY-PRIORITY-CD TO WS-PRIORITY                   
               WHEN OTHER                                               
P00196             MOVE 'NORMAL' TO OY-PRIORITY-DESC                    
P00196             PERFORM 7960-ORDER-PRIORITY THRU 7960-EXIT           
P00196             MOVE OY-PRIORITY-CD TO WS-PRIORITY                   
           END-EVALUATE.                                                
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-0073.                     
           MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-0073.                     
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-PRIOR-0073.          
           IF WS-NEW-ORDER-FL = 'N'                                     
               MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-0073            
           ELSE                                                         
               MOVE ZEROES TO SERV-ORDER-NO-0073
           END-IF.                       
           MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-0073.                 
           MOVE PR-LOCAL-OFFICE TO LOCAL-OFFICE-0073.                   
           MOVE SPACES TO PHONE-NO-EXT-0073.                            
           MOVE LINK-PHONE-NO TO PHONE-NO-0073.                         
           MOVE LINK-ORDER-PLACED-BY TO ORDER-PLACED-BY-0073.           
           MOVE LINK-NEW-SCHEDULED-DT TO WANTED-BY-DATE-0073            
                                         ASSIGNED-DATETIME-0073(1:10).  
           MOVE '-00.00.00.000000' TO ASSIGNED-DATETIME-0073(11:16).    
           MOVE WS-ORDER-REASON TO ORDER-REASON-0073.                   
           IF LINK-BREAKERS-FL = 'N'                                    
               MOVE SPACES TO LINK-BREAKERS-FL
           END-IF.                         
           IF WS-NEW-ORDER-FL = 'N'                                     
               MOVE BACK-DATED-IND-1105 TO BACK-DATED-IND-0073          
               MOVE PF-RESP-AREA-ID TO RESP-AREA-ID-0073                
               MOVE NOTIFY-CUST-IND-1105 TO NOTIFY-CUST-IND-0073        
               MOVE NOTIFY-CSR-IND-1105 TO NOTIFY-CSR-IND-0073          
               MOVE BREAKERS-OFF-IND-1105 TO BREAKERS-OFF-0073          
               MOVE DEPOSIT-AMT-1105 TO DEPOSIT-AMT-0073                
               MOVE INIT-BY-CNTRCT-IND-1105 TO INIT-BY-CNTRCT-0073      
               MOVE ORDER-RECVED-BY-1105 TO ORDER-RECVED-BY-0073        
           ELSE                                                         
               MOVE LINK-ORDER-RECVED-BY TO ORDER-RECVED-BY-0073        
               MOVE 'N' TO BACK-DATED-IND-0073                          
               MOVE PF-RESP-AREA-ID TO RESP-AREA-ID-0073                
               MOVE ' ' TO NOTIFY-CUST-IND-0073                         
               MOVE ' ' TO NOTIFY-CSR-IND-0073                          
               MOVE LINK-BREAKERS-FL TO BREAKERS-OFF-0073               
               MOVE WS-DEPOSIT-AMT-DEC TO DEPOSIT-AMT-0073              
               MOVE ' ' TO INIT-BY-CNTRCT-0073
           END-IF.                         
           IF LINK-CALL-BEFORE-MM = '000'                               
               MOVE SPACES TO LINK-CALL-BEFORE-MM
           END-IF.                      
           MOVE LINK-CALL-BEFORE-MM TO CALL-BEFORE-MIN-0073.            
           MOVE LINK-WORK-AREA TO WORK-AREA-ID-0073.                    
P00718     MOVE LINK-BUSINESS-UNIT TO BUSINESS-UNIT-0073.               
           MOVE WS-PRIORITY TO ORDER-PRIORITY-0073.                     
           MOVE 0.0 TO STD-CHG-AMT-0073.                                
           IF WS-HOLD-STATE-FL = 'Y' AND                                
             (WS-ACTIVE-STATE-FL = 'N' OR ' ')                          
                 MOVE 'Y' TO WS-ORDER-ON-HOLD-FL                        
                 MOVE 'R' TO ORDER-STATE-CD-0073                        
           ELSE                                                         
A05189         IF WS-AROP-FL = 'Y'                                      
A05189             MOVE 'H' TO ORDER-STATE-CD-0073                      
A05189         ELSE                                                     
                   MOVE 'A' TO ORDER-STATE-CD-0073
               END-IF
           END-IF.                     
           MOVE ORDER-STATE-CD-0073 TO RS-ORDER-STATE-CD.               
                                                                        
           MOVE +1 TO WS-II-CTR.                                        
           MOVE 0 TO WS-SS-CTR.                                         
           MOVE 0 TO WS-II-MCTR.                                        
           MOVE 'Y' TO WS-MORE-ROWS.                                    
                                                                        
           PERFORM 4020-METER-LOOP THRU 4020-EXIT UNTIL                 
               WS-MORE-ROWS = 'N'.                                      
P00718     PERFORM 4065-GET-WORK-DISTRICT THRU 4065-EXIT.               
                                                                        
           MOVE 0 TO ROW-NO-0073.                                       
           MOVE 'N' TO EQUIPMENT-PRESEN-0073                            
                       UTIL-ENV-PRESEN-0073                             
                       ORDER-INST-PRESEN-0073.                          
           PERFORM 4200-CALL-CSR00073 THRU 4200-EXIT.                   
                                                                        
       4010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOOP THROUGH SNAPSHOT DATA TO LOAD WORK TYPE AND TABLE    **          
      **  ID.  LOAD DATA FOR ADD OR UPDATE OF ORDER.  CALL          **          
      **  CSR00073 IF ANY CONDITION IS SET.                         **          
      ****************************************************************          
                                                                        
       4020-METER-LOOP.                                                 
                                                                        
           IF WS-II-CTR <= WS-T3-ROWCOUNT                               
               SET T3-INDEX TO WS-II-CTR                                
               IF T3-TABLE-ID (T3-INDEX) = 'UT'                         
                   ADD 1 TO WS-SS-CTR                                   
               END-IF                                                   
               IF T3-TABLE-ID (T3-INDEX) = 'MN'                         
                   ADD 1 TO WS-II-MCTR                                  
               END-IF                                                   
               EVALUATE T3-UT-CODE-UTIL-TYPE (T3-INDEX)                 
                   WHEN 'E'                                             
                       MOVE WS-WORK-TYPE-CD-E TO WORK-TYPE-CD-0073      
                   WHEN 'G'                                             
                       MOVE WS-WORK-TYPE-CD-G TO WORK-TYPE-CD-0073      
               END-EVALUATE                                             
               MOVE T3-TABLE-ID (T3-INDEX) TO TABLE-ID-0073             
           ELSE                                                         
               ADD +1 TO WS-SS-CTR                                      
           END-IF.                                                      
                                                                        
           IF WS-NEW-ORDER-FL = 'N'                                     
               PERFORM 4030-LOAD-OLD-ORDER-INFO THRU 4030-EXIT          
           ELSE                                                         
               PERFORM 4050-LOAD-NEW-ORDER-INFO THRU 4050-EXIT
           END-IF.         
                                                                        
           MOVE WS-II-CTR TO ROW-NO-0073.                               
           IF WS-UTIL-ENV-EXISTS = 'Y' OR                               
              WS-ORDER-INST-EXISTS = 'Y' OR                             
              WS-EQUIPMENT-EXISTS = 'Y'                                 
                  PERFORM 4200-CALL-CSR00073 THRU 4200-EXIT             
                  MOVE NEW-SERV-ORDER-NO-0073 TO WS-SERV-ORDER-NO-NUM   
                  MOVE WS-SERV-ORDER-NO-CHAR TO RS-SERV-ORDER-NO        
                                                SERV-ORDER-NO-0073      
                  IF WORK-QUEUE-0073 = 200 AND                          
                     (UT-CODE-UTIL-TYPE-0073 = 'E' OR 'G')              
                         PERFORM 4025-FORMAT-RELEASE-WQ THRU 4025-EXIT  
ACT233                   PERFORM 4210-CALL-CSR04675 THRU 4210-EXIT      
                  END-IF                                                
              ELSE                                                      
                  MOVE 'N' TO WS-MORE-ROWS
           END-IF.                             
           ADD +1 TO WS-II-CTR.                                         
                                                                        
       4020-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4025-FORMAT-RELEASE-WQ.                                          
                                                                        
ACT233     MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-4675.                     
ACT233     MOVE CUSTOMER-NO-2054 TO CUSTOMER-NO-4675.                   
                                                                        
           PERFORM 7200-GET-RELEASE THRU 7200-EXIT.                     
ACT233     MOVE '1' TO ROUTING-CATEGORY-4675.                           
           IF UT-CODE-UTIL-TYPE-0073 = 'E'                              
ACT233         MOVE 83 TO CATEGORY-ID-4675                              
           ELSE                                                         
ACT233         MOVE 325 TO CATEGORY-ID-4675
           END-IF.                            
           MOVE RLSE-NO-NEW-0073 TO WS-WQ-RELEASE-NO.                   
           IF RE-REV-DISTRICT-CD NOT = REV-DIST-CD-0073                 
               MOVE 'REVENUE DISTRICT' TO WS-MISMATCH-COMMENTS(1:16)
           END-IF.   
           IF RE-RLSE-TYPE(1:1) NOT = CODE-UTIL-TYPE-0073               
               MOVE ' UTILITY TYPE' TO WS-MISMATCH-COMMENTS(17:14)
           END-IF.     
           IF RE-RLSE-SUPPLIES NOT = METER-SUPPLYING-0073               
               MOVE ' METER SUPPLIES' TO WS-MISMATCH-COMMENTS(30:16)
           END-IF.   
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           STRING WS-WQ-COMMENTS                                        
                  WS-MISMATCH-COMMENTS                                  
                  ' DOES NOT MATCH.'                                    
                  DELIMITED BY SIZE INTO WS-EMB-INPUT.                  
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
ACT233     MOVE WS-CMP-TABLE TO COMMENTS-4675-TEXT.                     
ACT233     MOVE +200 TO COMMENTS-4675-LEN.                              
ACT233     MOVE 'N' TO WQ-PRIORITY-4675.                                
                                                                        
       4025-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD DATA TO UPDATE AN EXISTING ORDER.                    **          
      ****************************************************************          
                                                                        
       4030-LOAD-OLD-ORDER-INFO.                                        
                                                                        
           MOVE 'N' TO ORDER-INST-PRESEN-0073                           
                       INCLUDE-INST-0073                                
                       UTIL-ENV-PRESEN-0073                             
                       EQUIPMENT-PRESEN-0073                            
                       INSTALL-IND-0073                                 
                       WS-LIGHTING-CONTRACT-FL.                         
                                                                        
           MOVE SPACES TO CODE-UTIL-TYPE-0073                           
                          RATE-PLAN-NO-0073                             
                          UT-CODE-REV-CLASS-0073                        
                          UT-READ-CYCLE-0073                            
                          UT-CODE-SIC-NO-0073                           
                          METER-NO-0073                                 
                          MN-CODE-STATUS-REA-0073                       
                          MN-CODE-USAGE-TYPE-0073                       
                          MN-CODE-USAGE-ID-0073                         
                          MN-CODE-USAGE-SO-0073                         
                          CODE-METER-STATUS-0073                        
                          CODE-MTR-LOC-0073                             
                          RG-CODE-REG-STAT-0073                         
                          RG-CODE-STATUS-REA-0073                       
                          RG-CODE-USAGE-ID-0073                         
                          RG-CODE-USAGE-SO-0073                         
                          RG-CODE-USAGE-TY-0073                         
                          CP-CODE-PLAN-STA-0073                         
                          CP-CODE-STAT-REA-0073                         
                          CP-CODE-SERVICEZ-0073                         
                          CP-DIST-NO-0073                               
                          CP-EQUIP-ID-0073                              
                          CP-POLE-NO-0073                               
                          APPLIANCE-CD-0073                             
                          PRD-SRV-TYPE-DESC-0073                        
                          EQUIP-OWNER-0073                              
                          LEAK-IND-0073                                 
                          LIGHT-IND-0073                                
                          REPAIR-IND-0073                               
                          INSTALL-IND-0073                              
                          CUTOFF-IND-0073                               
                          CAUTION-TAG-IND-0073                          
                          IMPROPER-REASON-0073                          
                          EQUIPMENT-UNQ-0073                            
                          INSTALL-DT-0073                               
                          REPLACE-APP-FL-0073                           
                          MKT-CODE-UTIL-TYPE-0073.                      
           MOVE 0 TO MN-LAST-READ-VAL-0073                              
                     MN-CONSTANT-0073                                   
                     MN-NO-DIALS-0073                                   
                     MN-CODE-TIME-PER-0073                              
                     RG-CODE-TIME-PER-0073                              
                     CP-MNTHLY-AMT-FI-0073                              
                     CP-USAGE-FIXED-0073                                
                     CP-RATE-ITEM-CD-0073                               
                     CP-LIGHT-NO-0073                                   
                     RG-LAST-READ-VAL-0073                              
                     IC-NO-0073                                         
                     UT-READ-ROUTE-0073                                 
                     MN-MTR-REF-NO-0073                                 
                     RG-REG-ID-NO-0073                                  
                     CP-NO-UNITS-0073                                   
                     APPLIANCE-SEQ-NO-0073.                             
                                                                        
      *    IF WS-II-CTR <= WS-T2-ROWCOUNT                                       
           IF WS-SS-CTR <= WS-T2-ROWCOUNT                               
               PERFORM 4035-LOAD-METER-DATA THRU 4035-EXIT              
           ELSE                                                         
               MOVE 'N' TO WS-ORDER-INST-EXISTS                         
                           ORDER-INST-PRESEN-0073
           END-IF.                      
                                                                        
           IF WS-II-CTR <= WS-T4-ROWCOUNT                               
               PERFORM 4040-LOAD-SO-APPLIANCE-DATA THRU 4040-EXIT       
           ELSE                                                         
               MOVE 'N' TO EQUIPMENT-PRESEN-0073                        
                           WS-EQUIPMENT-EXISTS
           END-IF.                         
                                                                        
           MOVE 'N' TO VERIFY-RATE-0073.                                
           MOVE 'N' TO NEW-ORDER-0073.                                  
           MOVE '015' TO PANEL-NO-0073.                                 
           MOVE PR-REV-DISTRICT-CD TO REV-DIST-CD-0073.                 
           MOVE ORDER-RECVED-BY-1105 TO ORDER-RECVED-BY-0073.           
           MOVE WS-SO-EST-LABOR-HR-DEC TO SO-EST-LABOR-HR-0073.         
           MOVE 'N' TO REORDER-FLAG-0073.                               
           MOVE PR-COMPANY-NO TO COMPANY-NO-0073.                       
           MOVE 'A' TO CODE-KEY-FIELD-0073.                             
           MOVE 0 TO RCC-CODE-0073                                      
                     AMT-DNP-AT-BILLING-0073                            
                     CP-ITEM-SEQ-NO-0073.                               
           MOVE SPACES TO DATE-FORECAST-DNP-0073                        
                          WORK-PERIOD-CD-0073                           
                          WAIVER-TYPE-CD-0073.                          
           MOVE ACCOUNT-TYPE-DESC-1105 TO ACCOUNT-TYPE-CODE-0073.       
           MOVE CUST-CNT-ID-1105 TO CUST-CNT-ID-0073.                   
           MOVE T3-SUBDIV-LIGHT (1) TO PRICE-PER-SERV-0073.             
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-0073.                   
                                                                        
       4030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD METER DATA TO UPDATE AN EXISTING ORDER.              **          
      ****************************************************************          
                                                                        
       4035-LOAD-METER-DATA.                                            
                                                                        
      *    SET T2-INDEX TO WS-II-CTR.                                           
           SET T2-INDEX TO WS-SS-CTR.                                   
                                                                        
           MOVE T2-CODE-UTIL-TYPE (T2-INDEX) TO UT-CODE-UTIL-TYPE-0073. 
           MOVE T2-RATE-PLAN-NO (T2-INDEX) TO RATE-PLAN-NO-0073.        
           MOVE T2-IC-NO (T2-INDEX) TO IC-NO-0073.                      
           MOVE T2-METER-NO (T2-INDEX) TO METER-NO-0073.                
           MOVE T2-CODE-MTR-STATUS-WS (T2-INDEX) TO                     
                CODE-METER-STATUS-0073.                                 
           MOVE T2-CODE-METER-LOC (T2-INDEX) TO CODE-MTR-LOC-0073.      
           MOVE T2-METER-SUPPLYING (T2-INDEX) TO METER-SUPPLYING-0073.  
           MOVE T2-MTR-REF-NO (T2-INDEX) TO MN-MTR-REF-NO-0073.         
           MOVE T2-RLSE-REQUIRED (T2-INDEX) TO RLSE-IND-0073.           
           MOVE T2-RLSE-IND (T2-INDEX) TO HOLD-RELEASE-0073.            
           MOVE T2-RLSE-NO (T2-INDEX) TO RLSE-NO-0073.                  
           MOVE T2-PER-TEMP-IND (T2-INDEX) TO PER-TEMP-IND-0073.        
           MOVE T2-RLSE-DATE (T2-INDEX) TO RLSE-DATE-0073.              
           MOVE T2-SO-INST-SEQ-NO (T2-INDEX) TO SO-INST-SEQ-NO-0073.    
           MOVE 'Y' TO ORDER-INST-PRESEN-0073.                          
           MOVE 'Y' TO INCLUDE-INST-0073.                               
           MOVE 'Y' TO WS-ORDER-INST-EXISTS.                            
                                                                        
       4035-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA TO UPDATE AN EXISTING ORDER.          **          
      ****************************************************************          
                                                                        
       4040-LOAD-SO-APPLIANCE-DATA.                                     
                                                                        
           MOVE 'Y' TO WS-EQUIPMENT-EXISTS.                             
           SET T4-INDEX TO WS-II-CTR.                                   
           MOVE T4-APPLIANCE-CD (T4-INDEX) TO APPLIANCE-CD-0073.        
           MOVE SPACES TO PRD-SRV-TYPE-DESC-0073.                       
           MOVE T4-APPLIANCE-SEQ-NO (T4-INDEX) TO                       
                APPLIANCE-SEQ-NO-0073.                                  
           MOVE SPACES TO EQUIP-OWNER-0073.                             
           MOVE T4-CODE-UTIL-TYPE (T4-INDEX) TO MKT-CODE-UTIL-TYPE-0073.
           MOVE T4-LEAK-IND (T4-INDEX) TO LEAK-IND-0073.                
           IF WS-UNBLOCK-GAS-FL = 'Y'                                   
               MOVE 'Y' TO LIGHT-IND-0073                               
           ELSE                                                         
               MOVE 'N' TO LIGHT-IND-0073
           END-IF.                              
           MOVE T4-REPAIR-IND (T4-INDEX) TO REPAIR-IND-0073.            
           MOVE T4-CUTOFF-IND (T4-INDEX) TO CUTOFF-IND-0073.            
           MOVE T4-CAUTION-TAG-IND (T4-INDEX) TO                        
                CAUTION-TAG-IND-0073.                                   
           MOVE SPACES TO REPLACE-APP-FL-0073.                          
           MOVE T4-IMPROPER-REASON (T4-INDEX) TO IMPROPER-REASON-0073.  
           MOVE T4-EQUIPMENT-UNQ (T4-INDEX) TO EQUIPMENT-UNQ-0073.      
           MOVE SPACES TO INSTALL-DT-0073.                              
           MOVE 'Y' TO EQUIPMENT-PRESEN-0073.                           
           MOVE T4-INSTALL-IND (T4-INDEX) TO INSTALL-IND-0073.          
                                                                        
       4040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD DATA TO ADD A NEW ORDER.                             **          
      ****************************************************************          
                                                                        
       4050-LOAD-NEW-ORDER-INFO.                                        
                                                                        
           MOVE 'N' TO ORDER-INST-PRESEN-0073                           
                       INCLUDE-INST-0073                                
                       UTIL-ENV-PRESEN-0073                             
                       EQUIPMENT-PRESEN-0073.                           
                                                                        
           IF WS-II-CTR <= WS-T3-ROWCOUNT                               
               PERFORM 4055-LOAD-SNAPSHOT-DATA THRU 4055-EXIT           
           ELSE                                                         
               MOVE 'N' TO WS-UTIL-ENV-EXISTS                           
                           UTIL-ENV-PRESEN-0073
           END-IF.                        
                                                                        
           IF WS-II-CTR <= WS-T5-ROWCOUNT                               
               PERFORM 4060-LOAD-APPLIANCE-DATA THRU 4060-EXIT          
           ELSE                                                         
               MOVE 'N' TO EQUIPMENT-PRESEN-0073                        
                           WS-EQUIPMENT-EXISTS
           END-IF.                         
                                                                        
           MOVE 'N' TO VERIFY-RATE-0073.                                
           MOVE 'Y' TO NEW-ORDER-0073.                                  
           MOVE '015' TO PANEL-NO-0073.                                 
           MOVE PR-REV-DISTRICT-CD TO REV-DIST-CD-0073.                 
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-0073.                   
           MOVE WS-SO-EST-LABOR-HR-DEC TO SO-EST-LABOR-HR-0073.         
           MOVE 'N' TO REORDER-FLAG-0073.                               
           MOVE PR-COMPANY-NO TO COMPANY-NO-0073.                       
           MOVE 'A' TO CODE-KEY-FIELD-0073.                             
           MOVE 0 TO RCC-CODE-0073.                                     
           MOVE SPACES TO DATE-FORECAST-DNP-0073                        
                          CUST-CNT-ID-0073                              
                          WAIVER-TYPE-CD-0073                           
                          RLSE-NO-0073.                                 
           MOVE 0.0 TO AMT-DNP-AT-BILLING-0073.                         
           MOVE 'P' TO PER-TEMP-IND-0073.                               
           MOVE WS-II-MCTR TO SO-INST-SEQ-NO-0073.                      
                                                                        
       4050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD SNAPSHOT DATA TO ADD A NEW ORDER.  DETERMINE IF A    **          
      **  LIGHTING CONTRACT REQUIREMENT IS NEEDED.                  **          
      ****************************************************************          
                                                                        
       4055-LOAD-SNAPSHOT-DATA.                                         
                                                                        
           SET T3-INDEX TO WS-II-CTR.                                   
                                                                        
           IF T3-TABLE-ID (T3-INDEX) = 'CP'                             
               MOVE T3-CP-DT-PLAN-ST (T3-INDEX) TO WS-PLAN-START-DATE   
               EXEC SQL                                                 
                   SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-LINK-SCHEDULED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LINK-SCHEDULED-DT
              ) <> 0) OR (LEN(:WS-LINK-SCHEDULED-DT
              ) <> 10), CIS.CHAR2DATE(:WS-LINK-SCHEDULED-DT
              ), CONVERT(DATE, :WS-LINK-SCHEDULED-DT) )) -          
                          CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                    :WS-PLAN-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PLAN-START-DATE
              ) <> 0) OR (LEN(:WS-PLAN-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PLAN-START-DATE
              ), CONVERT(DATE, :WS-PLAN-START-DATE) ))
            INTO
              :WS-NO-OF-DAYS-LITE                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*        EXEC SQL                                                         
MFA-TR*            VALUES (DAYS(DATE(:WS-LINK-SCHEDULED-DT)) -                  
MFA-TR*                   DAYS(DATE(:WS-PLAN-START-DATE)))                      
MFA-TR*              INTO :WS-NO-OF-DAYS-LITE                                   
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

               IF T3-ACCT-STATUS (T3-INDEX) = 'A' AND                   
                  WS-ORDER-TYPE-CD(1:2) = 'CC'                          
                      IF (T3-UT-RATE-PLAN-NO (T3-INDEX) = '017' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '018' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '062' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '067' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '025' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' ') OR         
                         (T3-UT-RATE-PLAN-NO (T3-INDEX) = '026' AND     
                          T3-CP-DT-PLAN-ST (T3-INDEX) > ' '  AND        
                          WS-NO-OF-DAYS-LITE < 1827)                    
                              MOVE 'Y' TO WS-LIGHTING-CONTRACT-FL       
                              IF T3-UT-RATE-PLAN-NO (T3-INDEX) =        
                                      '017' OR '018' OR '062' OR '067'  
                                  MOVE 'Y' TO WS-BUILDER-LIGHTING-FL
                              END-IF
                      END-IF
               END-IF
           END-IF.   
                                                                        
           MOVE T3-UT-CODE-UTIL-TYPE (T3-INDEX) TO CODE-UTIL-TYPE-0073  
                                                UT-CODE-UTIL-TYPE-0073. 
           MOVE T3-UT-IC-NO (T3-INDEX) TO IC-NO-0073.                   
           MOVE T3-UT-READ-ROUTE (T3-INDEX) TO UT-READ-ROUTE-0073.      
           MOVE T3-UT-RATE-PLAN-NO (T3-INDEX) TO RATE-PLAN-NO-0073.     
           MOVE T3-UT-CODE-REV-CLASS (T3-INDEX) TO                      
                UT-CODE-REV-CLASS-0073.                                 
           MOVE T3-UT-READ-CYCLE (T3-INDEX) TO UT-READ-CYCLE-0073.      
           MOVE T3-UT-CODE-SIC-NO (T3-INDEX) TO UT-CODE-SIC-NO-0073.    
           MOVE T3-MN-MTR-REF-NO (T3-INDEX) TO MN-MTR-REF-NO-0073.      
           MOVE T3-MN-METER-NO (T3-INDEX) TO METER-NO-0073.             
           MOVE T3-MN-CODE-TIME-PER (T3-INDEX) TO MN-CODE-TIME-PER-0073.
           MOVE T3-MN-LAST-READ-VAL (T3-INDEX) TO MN-LAST-READ-VAL-0073.
           MOVE T3-MN-CD-STAT-REAS (T3-INDEX) TO                        
                MN-CODE-STATUS-REA-0073.                                
           MOVE T3-MN-CODE-USAGE-T (T3-INDEX) TO                        
                MN-CODE-USAGE-TYPE-0073.                                
           MOVE T3-MN-CODE-USAGE-I (T3-INDEX) TO                        
                MN-CODE-USAGE-ID-0073.                                  
           MOVE T3-MN-CODE-USAGE-S (T3-INDEX) TO                        
                MN-CODE-USAGE-SO-0073.                                  
           MOVE T3-MN-CODE-METER-S (T3-INDEX) TO                        
                CODE-METER-STATUS-0073.                                 
           MOVE T3-MN-METER-SUPPLY (T3-INDEX) TO                        
                METER-SUPPLYING-0073.                                   
           MOVE T3-MN-CODE-METER-LOC (T3-INDEX) TO                      
                CODE-MTR-LOC-0073.                                      
           MOVE T3-MN-CONSTANT (T3-INDEX) TO MN-CONSTANT-0073.          
           MOVE T3-MN-NO-DIALS (T3-INDEX) TO MN-NO-DIALS-0073.          
           MOVE T3-MN-POINT-ID (T3-INDEX) TO MN-POINT-ID-0073.          
           MOVE T3-MN-SEAL-CODE-ID (T3-INDEX) TO                        
                MN-SEAL-CODE-ID-0073.                                   
           MOVE T3-MN-HEX-LOCATION (T3-INDEX) TO                        
                MN-HEX-LOCATION-0073.                                   
           MOVE T3-MN-INSULATED-IND (T3-INDEX) TO                       
                MN-INSULATED-IND-0073.                                  
           MOVE T3-MN-LOCK-TYPE-ID (T3-INDEX) TO                        
                MN-LOCK-TYPE-ID-0073.                                   
           MOVE T3-MN-DELIVERY-LEV (T3-INDEX) TO MN-DELV-LEVEL-CD-0073. 
           MOVE T3-MN-UTILITY-SOURCE (T3-INDEX) TO                      
                MN-UTILITY-SOURCE-0073.                                 
           MOVE T3-MN-IDR-RECIPIENT (T3-INDEX) TO                       
                MN-IDR-RECIPIENT-0073.                                  
           MOVE T3-MN-PROGRAM-ID (T3-INDEX) TO MN-PROGRAM-ID-0073.      
           MOVE T3-MN-MTR-READ-SOURCE (T3-INDEX) TO READ-SOURCE-CD-0073.
           MOVE T3-MN-MTR-PRESS(T3-INDEX) TO MN-METER-PRESSURE-0073.    
                                                                        
           MOVE SPACES TO RG-CODE-REG-STAT-0073                         
                          RG-CODE-STATUS-REA-0073                       
                          RG-CODE-USAGE-ID-0073                         
                          RG-CODE-USAGE-SO-0073                         
                          RG-CODE-USAGE-TY-0073                         
                          RG-LAST-READ-DT-0073.                         
           MOVE 0 TO RG-CODE-TIME-PER-0073                              
                     RG-REG-ID-NO-0073.                                 
           MOVE 0.0 TO RG-LAST-READ-VAL-0073.                           
                                                                        
           MOVE T3-CP-CODE-PLAN (T3-INDEX) TO CP-CODE-PLAN-STA-0073.    
           MOVE T3-CP-CD-STAT-REAS (T3-INDEX) TO CP-CODE-STAT-REA-0073. 
           MOVE T3-CP-CD-SVC-TYPE (T3-INDEX) TO CP-CODE-SERVICEZ-0073.  
           MOVE T3-CP-DIST-NO (T3-INDEX) TO CP-DIST-NO-0073.            
           MOVE T3-CP-EQUIP-ID (T3-INDEX) TO CP-EQUIP-ID-0073.          
           MOVE T3-CP-USAGE-FIXED (T3-INDEX) TO CP-USAGE-FIXED-0073.    
           MOVE T3-CP-MTHLY-AMT (T3-INDEX) TO CP-MNTHLY-AMT-FI-0073     
           MOVE T3-CP-RT-ITEM-CD (T3-INDEX) TO CP-RATE-ITEM-CD-0073.    
           MOVE T3-CP-LIGHT-NO (T3-INDEX) TO CP-LIGHT-NO-0073.          
           MOVE T3-CP-POLE-NO (T3-INDEX) TO CP-POLE-NO-0073.            
           MOVE T3-CP-ITEM-SEQ-NO (T3-INDEX) TO CP-ITEM-SEQ-NO-0073.    
           MOVE T3-CP-NO-UNITS (T3-INDEX) TO CP-NO-UNITS-0073.          
                                                                        
           EVALUATE T3-TABLE-ID (T3-INDEX)                              
               WHEN 'MN'                                                
                   MOVE 'Y' TO WS-INCLUDE-INST                          
               WHEN 'XX'                                                
                   MOVE 'Y' TO WS-INCLUDE-INST                          
               WHEN 'UT'                                                
                   MOVE 'N' TO WS-INCLUDE-INST                          
               WHEN OTHER                                               
                   MOVE 'N' TO WS-INCLUDE-INST                          
           END-EVALUATE,                                                
                                                                        
           MOVE WS-INCLUDE-INST TO ORDER-INST-PRESEN-0073               
                                   INCLUDE-INST-0073.                   
           MOVE 'Y' TO WS-UTIL-ENV-EXISTS                               
                       UTIL-ENV-PRESEN-0073.                            
           MOVE T3-ACCT-STATUS (T3-INDEX) TO OLD-ACCT-STAT-0073         
                                             ACCT-STATUS-0073.          
           MOVE T3-RG-LAST-READD (T3-INDEX) TO MN-LAST-READ-DT-0073.    
           MOVE T3-RG-REG-ID-NO (T3-INDEX) TO MN-REG-ID-NO-0073.        
           MOVE T3-SUBDIV-LIGHT (T3-INDEX) TO PRICE-PER-SERV-0073.      
           MOVE T3-ACCT-TYPE-CODE (T3-INDEX) TO ACCOUNT-TYPE-CODE-0073. 
           IF T3-RLSE-REQUIRED (T3-INDEX) = ' '                         
               MOVE 'N' TO T3-RLSE-REQUIRED (T3-INDEX)
           END-IF.                 
           MOVE T3-RLSE-REQUIRED (T3-INDEX) TO RLSE-IND-0073            
                                               HOLD-RELEASE-0073.       
                                                                        
       4055-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA TO ADD A NEW ORDER.                   **          
      ****************************************************************          
                                                                        
       4060-LOAD-APPLIANCE-DATA.                                        
                                                                        
           MOVE 'Y' TO WS-EQUIPMENT-EXISTS.                             
           SET T5-INDEX TO WS-II-CTR.                                   
           MOVE T5-APPLIANCE-CD (T5-INDEX) TO APPLIANCE-CD-0073.        
           MOVE 0 TO APPLIANCE-SEQ-NO-0073.                             
           MOVE SPACES TO EQUIP-OWNER-0073                              
                          LEAK-IND-0073                                 
                          REPAIR-IND-0073.                              
           MOVE 'G' TO MKT-CODE-UTIL-TYPE-0073.                         
           IF WS-UNBLOCK-GAS-FL = 'Y'                                   
               MOVE 'Y' TO LIGHT-IND-0073                               
           ELSE                                                         
               MOVE 'N' TO LIGHT-IND-0073
           END-IF.                              
           MOVE T5-CUT-IND (T5-INDEX) TO CUTOFF-IND-0073.               
           MOVE T5-CAUTION-TAG-IND (T5-INDEX) TO CAUTION-TAG-IND-0073.  
           MOVE T5-CONDITION-DESC (T5-INDEX) TO IMPROPER-REASON-0073.   
           MOVE T5-EQUIPMENT-NO (T5-INDEX) TO EQUIPMENT-UNQ-0073.       
           MOVE 'Y' TO EQUIPMENT-PRESEN-0073.                           
           MOVE SPACES TO INSTALL-DT-0073.                              
           MOVE 'N' TO REPLACE-APP-FL-0073.                             
           MOVE T5-APPLIANCE-DESC (T5-INDEX) TO PRD-SRV-TYPE-DESC-0073. 
           MOVE 'N' TO INSTALL-IND-0073.                                
                                                                        
       4060-EXIT.                                                       
            EXIT.                                                       
P00718                                                                  
P00718 4065-GET-WORK-DISTRICT.                                          
P00718                                                                  
P00718     INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     EVALUATE TRUE                                                
P00718        WHEN LINK-BUSINESS-UNIT = 'EOP'                           
P00718         AND PR-FM-ELEC-SVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-ELEC-SVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'GOP'                           
P00718         AND PR-FM-GAS-OPS-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-GAS-OPS-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'FSV'                           
P00718         AND PR-FM-FLD-SVCS-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-FLD-SVCS-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'RVP'                           
P00718         AND PR-FM-REV-PRT-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-REV-PRT-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN LINK-BUSINESS-UNIT = 'DSM'                           
P00718         AND PR-FM-DSM-ESVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-DSM-ESVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718     PERFORM 7980-GET-PRINT-LOC                THRU 7980-EXIT.    
P00718     MOVE LINK-CURR-ACCOUNT-NO                 TO RG-ACCOUNT-NO.  
P00718     PERFORM 7985-GET-REGISTER-DTLS            THRU 7985-EXIT.    
P00718     IF (C4-CAD-WORKAREA-FL = 'Y' AND WS-MULTI-REG-MTR = 'N')     
P00718        MOVE WS-WORK-DISTRICT                  TO RS-WORK-DISTRICT
P00718     ELSE                                                         
P00718        MOVE SPACES                            TO RS-WORK-DISTRICT
P00718     END-IF.                                                      
P00718                                                                  
P00718 4065-EXIT.                                                       
P00718      EXIT.                                                       
P00718                                                                  
      ****************************************************************          
      **  CALL CSR02054 TO CREATE THE NEW ACCOUNT.                  **          
      ****************************************************************          
                                                                        
       4100-CALL-CSR02054.                                              
                                                                        
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2054.                     
           MOVE LINK-NEW-CUSTOMER-NO TO CUSTOMER-NO-2054.               
           MOVE LINK-ORDER-RECVED-BY TO USERID-2054.                    
           MOVE PR-COMPANY-NO TO COMPANY-NO-2054.                       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02054                                             
      *           (:PREMISE-NO-2054,                                    
      *            :CUSTOMER-NO-2054,                                   
      *            :USERID-2054,                                        
      *            :COMPANY-NO-2054)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2054
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2054
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2054 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02054'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-NEW-CUSTOMER-NO  TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2054)                                                
      *       WITH PROCEDURE CSR02054                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2054 CURSOR FOR RESULT SET        
      *       :LOC2054                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2054 INTO                            
                 :RETURN-CODE-2054,                                     
                 :ACCOUNT-NO-2054,                                      
                 :COMPANY-ACCT-2054                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2054 NOT = 0                          
                       MOVE RETURN-CODE-2054  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02054'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
                       MOVE LINK-PREMISE-NO   TO HOSTVAR-ELEMENT-1      
                       MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-2        
                       MOVE LINK-NEW-CUSTOMER-NO TO HOSTVAR-ELEMENT-2   
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02054'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE LINK-PREMISE-NO       TO HOSTVAR-ELEMENT-1      
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2        
                   MOVE LINK-NEW-CUSTOMER-NO  TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  DETERMINE THE WORK TYPE(S) BASED ON THE WORK TYPES FROM   **          
      **  THE EXISTING ORDER.  DETERMINE IF THE ORDER/WORK TYPE     **          
      **  COMBINATION REQUIRES A RELEASE.  IF SO, RETURN RELEASE    **          
      **  INFORMATION AND DETERMINE IF A RELEASE EXISTS FOR THE     **          
      **  PREMISE.                                                  **          
      ****************************************************************          
                                                                        
       4110-ORDER-RELEASE.                                              
                                                                        
           EVALUATE T2-OLD-WORK-TYPE-CD (T2-INDEX)                      
               WHEN 'BLK'                                               
P01176         WHEN 'MCB'                                               
                   MOVE 'UNB' TO WS-WORK-TYPE-CD                        
               WHEN 'VRB'                                               
                   MOVE 'UNB' TO WS-WORK-TYPE-CD                        
               WHEN 'RDO'                                               
                   MOVE 'RDO' TO WS-WORK-TYPE-CD                        
               WHEN 'UNB'                                               
P01176         WHEN 'MCU'                                               
                   MOVE 'RDO' TO WS-WORK-TYPE-CD                        
           END-EVALUATE.                                                
                                                                        
           MOVE WS-WORK-TYPE-CD TO T2-WORK-TYPE-CD (T2-INDEX).          
           IF T2-CODE-UTIL-TYPE (T2-INDEX) = 'E'                        
               MOVE WS-WORK-TYPE-CD TO WS-WORK-TYPE-CD-E                
           ELSE                                                         
               MOVE WS-WORK-TYPE-CD TO WS-WORK-TYPE-CD-G
           END-IF.               
           IF T2-CODE-UTIL-TYPE (T2-INDEX) = 'G'                        
               EVALUATE T2-WORK-TYPE-CD (T2-INDEX)                      
                   WHEN 'UNB'                                           
P01176             WHEN 'MCU'                                           
                       MOVE 'Y' TO WS-UNBLOCK-GAS-FL                    
                   WHEN 'RDO'                                           
                       MOVE 'Y' TO WS-READ-GAS-MTR-FL                   
               END-EVALUATE
           END-IF.                                            
P01176     IF WS-WORK-TYPE-CD = ('UNB' OR 'MCU') AND                    
              WS-DEPOSIT-AMT-DEC > 0                                    
                  MOVE 'Y' TO WS-HOLD-STATE-FL
           END-IF.                         
           IF WS-WORK-TYPE-CD NOT = 'UNB' AND                           
P01176        WS-WORK-TYPE-CD NOT = 'MCU' AND                           
              WS-DEPOSIT-AMT-DEC > 0                                    
                  MOVE 'Y' TO WS-ACTIVE-STATE-FL
           END-IF.                       
                                                                        
           PERFORM 7110-RELEASE-RQMT THRU 7110-EXIT.                    
           IF L3-RLSE-CHECK-CD = 'C'                                    
               PERFORM 4130-CALL-CSR04012 THRU 4130-EXIT                
               MOVE RLSE-REQUIRED-FL-4012 TO                            
                    T2-RLSE-REQUIRED (T2-INDEX)                         
               IF RLSE-REQUIRED-FL-4012 = 'Y'                           
                   MOVE 'Y' TO WS-RELEASE-REQUIRED                      
                   IF RLSE-EXISTS-4012 = 'Y'                            
                       MOVE RLSE-NO-4012 TO T2-RLSE-NO (T2-INDEX)       
                   ELSE                                                 
                       IF CODE-UTIL-TYPE-4012 = 'E'                     
                           MOVE 'Y' TO RS-ELEC-RLSE-REQ-FL              
                           MOVE MESSAGE-4012 TO RS-ELEC-MESSAGE         
                           MOVE ADTL-MESSAGE-4012 TO                    
                                RS-ELEC-ADTL-MESSAGE                    
                           MOVE PHONE-4012 TO RS-ELEC-PHONE             
                           MOVE ALT-PHONE-4012 TO RS-ELEC-ALT-PHONE     
                           MOVE REV-DIST-DESC-4012 TO                   
                                RS-ELEC-REV-DIST-DESC                   
                       ELSE                                             
                           MOVE 'Y' TO RS-GAS-RLSE-REQ-FL               
                           MOVE MESSAGE-4012 TO RS-GAS-MESSAGE          
                           MOVE ADTL-MESSAGE-4012 TO RS-GAS-ADTL-MESSAGE
                           MOVE PHONE-4012 TO RS-GAS-PHONE              
                           MOVE ALT-PHONE-4012 TO RS-GAS-ALT-PHONE      
                           MOVE REV-DIST-DESC-4012 TO                   
                                RS-GAS-REV-DIST-DESC
                       END-IF
                   END-IF
               END-IF
           END-IF.                   
                                                                        
       4110-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  DETERMINE THE WORK TYPE(S) BASED ON THE METER STATUS      **          
      **  FROM THE ACCOUNT.  DETERMINE IF THE ORDER/WORK TYPE       **          
      **  COMBINATION REQUIRES A RELEASE,  IF SO, RETURN RELEASE    **          
      **  INFORMATION AND DETERMINE IF A RELEASE EXISTS FOR THE     **          
      **  PREMISE.                                                  **          
      ****************************************************************          
                                                                        
       4120-ACCOUNT-RELEASE.                                            
                                                                        
           IF T3-TABLE-ID (T3-INDEX) = 'MN'                             
               IF LINK-REVERT-FL = 'Y'                                  
                   EVALUATE T3-MN-CODE-METER-S (T3-INDEX)               
                       WHEN 'A'                                         
                       WHEN 'I'                                         
                           MOVE 'RDO' TO WS-WORK-TYPE-CD                
                       WHEN 'J'                                         
                           MOVE 'VRB' TO WS-WORK-TYPE-CD                
                       WHEN OTHER                                       
                           MOVE '   ' TO WS-WORK-TYPE-CD                
                   END-EVALUATE                                         
               ELSE                                                     
                   IF T3-MN-CODE-METER-S (T3-INDEX) = 'A'               
                       MOVE 'RDO' TO WS-WORK-TYPE-CD                    
                   ELSE                                                 
                       MOVE 'UNB' TO WS-WORK-TYPE-CD                    
                   END-IF                                               
               END-IF                                                   
               MOVE WS-WORK-TYPE-CD TO T3-WORK-TYPE-CD (T3-INDEX)       
P01176         IF WS-WORK-TYPE-CD = ('UNB' OR 'MCU') AND                
                  WS-DEPOSIT-AMT-DEC > 0                                
                      MOVE 'Y' TO WS-HOLD-STATE-FL                      
               END-IF                                                   
               IF WS-WORK-TYPE-CD NOT = 'UNB' AND                       
P01176            WS-WORK-TYPE-CD NOT = 'MCU' AND                       
                  WS-DEPOSIT-AMT-DEC > 0                                
                      MOVE 'Y' TO WS-ACTIVE-STATE-FL                    
               END-IF                                                   
               EVALUATE T3-UT-CODE-UTIL-TYPE (T3-INDEX)                 
                   WHEN 'E'                                             
                      MOVE WS-WORK-TYPE-CD TO WS-WORK-TYPE-CD-E         
                   WHEN 'G'                                             
                      MOVE WS-WORK-TYPE-CD TO WS-WORK-TYPE-CD-G         
                   WHEN OTHER                                           
                      CONTINUE                                          
               END-EVALUATE                                             
               IF T3-UT-CODE-UTIL-TYPE (T3-INDEX) = 'G'                 
                   EVALUATE T3-WORK-TYPE-CD (T3-INDEX)                  
                       WHEN 'UNB'                                       
P01176                 WHEN 'MCU'                                       
                           MOVE 'Y' TO WS-UNBLOCK-GAS-FL                
                       WHEN 'RDO'                                       
                           MOVE 'Y' TO WS-READ-GAS-MTR-FL               
                   END-EVALUATE                                         
               END-IF                                                   
               PERFORM 7110-RELEASE-RQMT THRU 7110-EXIT                 
               IF L3-RLSE-CHECK-CD = 'C'                                
                   PERFORM 4130-CALL-CSR04012 THRU 4130-EXIT            
                   MOVE RLSE-REQUIRED-FL-4012 TO                        
                        T3-RLSE-REQUIRED (T3-INDEX)                     
                   IF RLSE-REQUIRED-FL-4012 = 'Y'                       
                       MOVE 'Y' TO WS-RELEASE-REQUIRED                  
                       IF RLSE-EXISTS-4012 = 'Y'                        
                           MOVE RLSE-NO-4012 TO T3-RLSE-NO (T3-INDEX)   
                       ELSE                                             
                           IF CODE-UTIL-TYPE-4012 = 'E'                 
                               MOVE 'Y' TO RS-ELEC-RLSE-REQ-FL          
                               MOVE MESSAGE-4012 TO RS-ELEC-MESSAGE     
                               MOVE ADTL-MESSAGE-4012 TO                
                                    RS-ELEC-ADTL-MESSAGE                
                               MOVE PHONE-4012 TO RS-ELEC-PHONE         
                               MOVE ALT-PHONE-4012 TO RS-ELEC-ALT-PHONE 
                               MOVE REV-DIST-DESC-4012 TO               
                                    RS-ELEC-REV-DIST-DESC               
                           ELSE                                         
                               MOVE 'Y' TO RS-GAS-RLSE-REQ-FL           
                               MOVE MESSAGE-4012 TO RS-GAS-MESSAGE      
                               MOVE ADTL-MESSAGE-4012 TO                
                                    RS-GAS-ADTL-MESSAGE                 
                               MOVE PHONE-4012 TO RS-GAS-PHONE          
                               MOVE ALT-PHONE-4012 TO RS-GAS-ALT-PHONE  
                               MOVE REV-DIST-DESC-4012 TO               
                                    RS-GAS-REV-DIST-DESC
                           END-IF
                       END-IF
                   END-IF
               END-IF
           END-IF.               
                                                                        
       4120-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR04012 TO DETERMINE THE RELEASE REQUIREMENT AND    **          
      **  GET RELEASE CONTACT INFORMATION.  METER SUPPLYING LITERAL **          
      **  MUST BE CONVERTED TO A CODE VALUE.                        **          
      ****************************************************************          
                                                                        
       4130-CALL-CSR04012.                                              
                                                                        
           MOVE PR-COMPANY-NO TO COMPANY-NO-4012.                       
           MOVE PR-REV-DISTRICT-CD TO REV-DISTRICT-CD-4012.             
           MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-4012.                 
           MOVE WS-WORK-TYPE-CD TO WORK-TYPE-CD-4012.                   
           MOVE L3-RLSE-CHECK-CD TO RLSE-CHECK-CD-4012.                 
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-4012.                
           MOVE 'WEB' TO CALLING-SYSTEM-4012.                           
           MOVE LINK-NEW-SCHEDULED-DT(1:10) TO WANTED-BY-DATE-4012.     
                                                                        
           IF WS-ACCT-WK-TYPE-FL = 'O'                                  
               MOVE T2-CODE-UTIL-TYPE (T2-INDEX) TO CODE-UTIL-TYPE-4012 
               MOVE T2-METER-SUPPLYING (T2-INDEX) TO                    
                    WS-METER-SUPPLYING                                  
               MOVE T2-CODE-STATUS-REA-WS (T2-INDEX) TO                 
                    CODE-STATUS-REAS-4012                               
               MOVE T2-IC-NO (T2-INDEX) TO WS-IC-NO-NUM                 
               MOVE WS-IC-NO-CHAR TO IC-NO-4012                         
               MOVE T2-MTR-REF-NO (T2-INDEX) TO WS-MTR-REF-NO-NUM       
               MOVE WS-MTR-REF-NO-CHAR TO MTR-REF-NO-4012               
           ELSE                                                         
               MOVE T3-UT-CODE-UTIL-TYPE (T3-INDEX) TO                  
                    CODE-UTIL-TYPE-4012                                 
               MOVE T3-MN-METER-SUPPLY (T3-INDEX) TO                    
                    WS-METER-SUPPLYING                                  
               MOVE T3-MN-CD-STAT-REAS (T3-INDEX) TO                    
                    CODE-STATUS-REAS-4012                               
               MOVE T3-UT-IC-NO (T3-INDEX) TO WS-IC-NO-NUM              
               MOVE WS-IC-NO-CHAR TO IC-NO-4012                         
               MOVE T3-MN-MTR-REF-NO (T3-INDEX) TO WS-MTR-REF-NO-NUM    
               MOVE WS-MTR-REF-NO-CHAR TO MTR-REF-NO-4012
           END-IF.              
                                                                        
           SET WS-SUPPLYING-INDEX TO +1                                 
           SEARCH WS-SUPPLYING-LINE                                     
               AT END                                                   
                   MOVE SPACES TO METER-SUPPLYING-CD-4012               
               WHEN WS-METER-SUPPLYING =                                
                    WS-SUPPLYING-DESC (WS-SUPPLYING-INDEX)              
                        MOVE WS-SUPPLYING-CD (WS-SUPPLYING-INDEX) TO    
                             METER-SUPPLYING-CD-4012                    
           END-SEARCH.                                                  
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04012                                             
      *           (:COMPANY-NO-4012,                                    
      *            :REV-DISTRICT-CD-4012,                               
      *            :CODE-UTIL-TYPE-4012,                                
      *            :ORDER-TYPE-CD-4012,                                 
      *            :WORK-TYPE-CD-4012,                                  
      *            :RLSE-CHECK-CD-4012,                                 
      *            :ACCOUNT-NO-4012,                                    
      *            :IC-NO-4012,                                         
      *            :MTR-REF-NO-4012,                                    
      *            :METER-SUPPLYING-CD-4012,                            
      *            :CODE-STATUS-REAS-4012,                              
      *            :CALLING-SYSTEM-4012,                                
      *            :WANTED-BY-DATE-4012,                                
      *            :PREMISE-NO-4012,                                    
      *            :RLSE-TYPE-4012,                                     
      *            :RLSE-SUPPLIES-4012)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4012
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4012
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4012 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4130'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04012'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4012       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE REV-DISTRICT-CD-4012  TO HOSTVAR-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE CODE-UTIL-TYPE-4012   TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4012)                                                
      *       WITH PROCEDURE CSR04012                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4012 CURSOR FOR RESULT SET        
      *       :LOC4012                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4012 INTO                            
                 :RETURN-CODE-4012,                                     
                 :RLSE-REQUIRED-FL-4012,                                
                 :MESSAGE-4012,                                         
                 :ADTL-MESSAGE-4012,                                    
                 :PHONE-4012,                                           
                 :ALT-PHONE-4012,                                       
                 :UTIL-TYPE-4012,                                       
                 :REV-DIST-DESC-4012,                                   
                 :RLSE-EXISTS-4012,                                     
                 :RLSE-NO-4012                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4012 NOT = 0 AND                      
                      RETURN-CODE-4012 NOT = 100                        
                         MOVE RETURN-CODE-4012 TO WS-ACTIVE-RETURN-CODE 
                                                    RS-STATUS-CODE      
                          MOVE PROGRAM-NAME   TO ABEND-PROGRAM          
                          MOVE '4130'         TO ACTIVE-PARAGRAPH       
                          MOVE 'FETCH'        TO ABEND-FUNCTION         
                          MOVE 'CSR04012'     TO TABLE-1                
                          MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1        
                          MOVE ACCOUNT-NO-4012 TO HOSTVAR-ELEMENT-1     
                          MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2     
                          MOVE REV-DISTRICT-CD-4012 TO                  
                               HOSTVAR-ELEMENT-2                        
                          MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-3      
                          MOVE CODE-UTIL-TYPE-4012 TO HOSTVAR-ELEMENT-3 
                          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT 
                          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT 
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4130'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04012'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-4012       TO HOSTVAR-ELEMENT-1      
                   MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2        
                   MOVE REV-DISTRICT-CD-4012  TO HOSTVAR-ELEMENT-2      
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3        
                   MOVE CODE-UTIL-TYPE-4012   TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF RLSE-REQUIRED-FL-4012 = 'E'                               
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE +999                      TO WS-ACTIVE-RETURN-CODE  
               MOVE '4130'                    TO ACTIVE-PARAGRAPH       
               MOVE 'ERROR'                   TO ABEND-FUNCTION         
               MOVE 'CSR04012'                TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE ACCOUNT-NO-4012           TO HOSTVAR-ELEMENT-1      
               MOVE 'REV_DISTRICT_CD'         TO TABLE-ELEMENT-2        
               MOVE REV-DISTRICT-CD-4012      TO HOSTVAR-ELEMENT-2      
               MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3        
               MOVE CODE-UTIL-TYPE-4012       TO HOSTVAR-ELEMENT-3      
               MOVE 'MESSAGE'                 TO TABLE-ELEMENT-4        
               MOVE MESSAGE-4012              TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       4130-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR01297 TO ADD A DUCT FURNACE TO CSS_APPLIANCE.     **          
      ****************************************************************          
                                                                        
       4140-CALL-CSR01297.                                              
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 'I' TO UPDATE-TYPE-1297.                                
           MOVE WS-PREMISE-NO-CHAR TO PREMISE-NO-1297.                  
           MOVE WS-CURRENT-TIMESTAMP(1:4) TO EQUIPMENT-NO-1297(1:4).    
           MOVE WS-CURRENT-TIMESTAMP(6:2) TO EQUIPMENT-NO-1297(5:2).    
           MOVE WS-CURRENT-TIMESTAMP(9:2) TO EQUIPMENT-NO-1297(7:2).    
           MOVE WS-CURRENT-TIMESTAMP(12:2) TO EQUIPMENT-NO-1297(9:2).   
           MOVE WS-CURRENT-TIMESTAMP(15:2) TO EQUIPMENT-NO-1297(11:2).  
           MOVE WS-CURRENT-TIMESTAMP(18:2) TO EQUIPMENT-NO-1297(13:2).  
           MOVE WS-CURRENT-TIMESTAMP(21:6) TO EQUIPMENT-NO-1297(15:6).  
           MOVE PR-COMPANY-NO TO COMPANY-NO-1297.                       
           MOVE 'DF' TO APPLIANCE-CD-1297.                              
           MOVE 'N' TO CAUTION-TAG-IND-1297                             
                       CUT-IND-1297.                                    
           MOVE 'NA-GAS' TO PRIMARY-FUEL-CD-1297.                       
           MOVE WS-CURRENT-DATE TO UPDATE-DT-1297.                      
           MOVE LINK-ORDER-RECVED-BY TO UPDATE-ID-1297.                 
           MOVE SPACES TO TAG-NO-1297                                   
                          LOCATION-CD-1297                              
                          CONDITION-CD-1297                             
                          APPL-CMNT-TXT-1297                            
                          CAUTION-TAG-DT-1297.                          
           MOVE 'APPLIANCE ADDED BY WEB DUE TO UNBLOCK GAS ORDER.' TO   
                 CMNT-TXT-1297                                          
           MOVE 0 TO APPL-CMNT-LEN-1297.                                
           MOVE 50 TO CMNT-TXT-LEN-1297.                                
           MOVE 'WEB' TO SOURCE-SYSTEM-CD-1297.                         
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01297                                             
      *           (:UPDATE-TYPE-1297,                                   
      *            :PREMISE-NO-1297,                                    
      *            :EQUIPMENT-NO-1297,                                  
      *            :COMPANY-NO-1297,                                    
      *            :APPLIANCE-CD-1297,                                  
      *            :CAUTION-TAG-IND-1297,                               
      *            :CUT-IND-1297,                                       
      *            :PRIMARY-FUEL-CD-1297,                               
      *            :UPDATE-DT-1297,                                     
      *            :UPDATE-ID-1297,                                     
      *            :TAG-NO-1297,                                        
      *            :CONDITION-CD-1297,                                  
      *            :LOCATION-CD-1297,                                   
      *            :APPL-CMNT-LEN-1297,                                 
      *            :APPL-CMNT-TXT-1297,                                 
      *            :CAUTION-TAG-DT-1297,                                
      *            :SOURCE-SYSTEM-CD-1297,                              
      *            :CMNT-TXT-LEN-1297,                                  
      *            :CMNT-TXT-1297)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1297
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1297
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1297 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4040'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01297'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-PREMISE-NO-CHAR    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1297)                                                
      *       WITH PROCEDURE CSR01297                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1297 CURSOR FOR RESULT SET        
      *       :LOC1297                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1297 INTO                            
                 :RETURN-CODE-1297,                                     
                 :WQ-FLAG-1297                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1297 NOT = 0                          
                       MOVE RETURN-CODE-1297  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4040'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01297'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
                       MOVE WS-PREMISE-NO-CHAR TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4040'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01297'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE WS-PREMISE-NO-CHAR    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4140-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR01105 TO GET DATA FOR THE EXISTING ORDER.         **          
      ****************************************************************          
                                                                        
       4150-CALL-CSR01105.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-1105.               
           MOVE 'C' TO HISTORY-FL-1105.                                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01105                                             
      *           (:SERV-ORDER-NO-1105,                                 
      *            :HISTORY-FL-1105)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1105
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1105
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1105 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4050'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01105'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1105)                                                
      *       WITH PROCEDURE CSR01105                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1105 CURSOR FOR RESULT SET        
      *       :LOC1105                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1105 INTO                            
                   :RETURN-CODE-1105,                                   
                   :ORDER-TYPE-CD-1105,                                 
                   :ORDER-REASON-1105,                                  
                   :STATUS-TX-1105,                                     
                   :ORDER-STATE-CD-1105,                                
                   :ORDER-PLACED-BY-1105,                               
                   :PHONE-NO-1105,                                      
                   :PHONE-NO-EXT-1105,                                  
                   :WANTED-BY-DATETIME-1105,                            
                   :ASSIGNED-DATETIME-1105,                             
                   :CALL-BEFORE-MINUTS-1105,                            
                   :WORK-AREA-ID-1105,                                  
                   :BREAKERS-OFF-IND-1105,                              
                   :INIT-BY-CNTRCT-IND-1105,                            
                   :NOTIFY-CSR-IND-1105,                                
                   :NOTIFY-CUST-IND-1105,                               
                   :ORDER-PRIORITY-CD-1105,                             
                   :STD-LABOR-CHRG-1105,                                
                   :WORK-TYPE-CD-1105,                                  
                   :BACK-DATED-IND-1105,                                
                   :DEPOSIT-AMT-1105,                                   
                   :ORDER-RECVED-BY-1105,                               
                   :VERIFY-RATE-1105,                                   
                   :PREMISE-NO-1105,                                    
                   :ACCOUNT-NO-1105,                                    
                   :ACCOUNT-NO-PRIOR-1105,                              
                   :BEGIN-APPT-DATE-1105 :WS-NULL-APPT-DT,               
                   :SO-EST-LABOR-HR-1105,                               
                   :CUSTCHG-ORD-TYPE-FL-1105,                           
                   :AMOUNT-DISC-BAL-1105,                               
                   :FILLER-1105,                                        
                   :CURRENT-DATE-1105,                                  
                   :CODE-UTIL-TYPE-1105,                                
                   :PRICE-PER-SERV-1105,                                
                   :ACCOUNT-TYPE-DESC-1105,                             
                   :ORDER-CHARGE-AMT-1105,                              
                   :TOTAL-CHARGES-AMT-1105,                             
                   :CUST-CNT-ID-1105,                                   
                   :FILLER-A-1105,                                      
                   :FILLER-B-1105,                                      
                   :FILLER-C-1105,                                      
                   :FILLER-D-1105,                                      
                   :FILLER-E-1105,                                      
                   :MTR-ACCESSIBLE-CD-1105,                             
                   :MTR-ACCESSIBLE-DT-1105 :WS-NULL-ACCESS-DT,           
                   :MTR-ACCESSIBLE-RSN-1105,                            
                   :SOURCE-SYSTEM-CD-1105,                              
                   :ALT-PHONE-NO-1105,                                  
                   :ALT-PHONE-NO-EXT-1105,                              
                   :HOME-ALL-DAY-FL-1105,                               
P00718             :BUSINESS-UNIT-1105,                                 
P00718             :OPTIMIZE-ORDER-1105                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1105 NOT = 0                          
                       MOVE RETURN-CODE-1105  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4050'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01105'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE LINK-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   IF WS-NULL-ACCESS-DT < 0                             
                       MOVE SPACES TO MTR-ACCESSIBLE-DT-1105            
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4050'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01105'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4150-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  GET APPLIANCES FOR EXISTING ORDER FROM CSS_SO_APPLIANCE.  **          
      ****************************************************************          
                                                                        
       4160-GET-SO-APPLIANCES.                                          
                                                                        
           PERFORM 7140-OPEN-SO-APP-CURSOR THRU 7140-EXIT.              
           PERFORM 4165-BUILD-TABLE THRU 4165-EXIT VARYING              
                T4-INDEX FROM 1 BY 1 UNTIL                              
                T4-INDEX > 20  OR                                       
                WS-ACTIVE-RETURN-CODE = NOT-FOUND.                      
           PERFORM 7150-CLOSE-SO-APP-CURSOR THRU 7150-EXIT.             
                                                                        
       4160-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA FOR EXISTING ORDER INTO               **          
      **  T4-SO-APPLIANCES WORKING STORAGE TABLE.  THE ROWCOUNT FOR **          
      **  THIS TABLE IS IN WS-T4-ROWCOUNT.                          **          
      ****************************************************************          
                                                                        
       4165-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH SO_APP_CURSOR                                      
               INTO :VQ-APPLIANCE-CD,                                   
                    :VQ-EQUIP-OWNER :WS-NULL-EQUIP-OWNER,                
                    :VQ-CODE-UTIL-TYPE,                                 
                    :VQ-LEAK-IND,                                       
                    :VQ-LIGHT-IND,                                      
                    :VQ-REPAIR-IND,                                     
                    :VQ-CUTOFF-IND,                                     
                    :VQ-CAUTION-TAG-IND,                                
                    :VQ-IMPROPER-REASON :WS-NULL-IMPROPER-REASON,        
                    :VQ-APPLIANCE-SEQ-NO,                               
                    :VQ-EQUIPMENT-UNQ,                                  
                    :VO-CATHODIC-PROTECT,                               
                    :VQ-INSTALL-DT :WS-NULL-INSTALL-DT,                  
                    :VQ-REPLACE-APP-FL,                                 
                    :VQ-PRD-SRV-TYP-DESC,                               
                    :VQ-INSTALL-IND                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-APPLIANCE-FL                          
                   IF WS-NULL-EQUIP-OWNER < 0                           
                       MOVE SPACES TO VQ-EQUIP-OWNER                    
                   END-IF                                               
                   IF WS-NULL-INSTALL-DT < 0                            
                       MOVE SPACES TO VQ-INSTALL-DT                     
                   END-IF                                               
                   IF WS-NULL-IMPROPER-REASON < 0                       
                       MOVE SPACES TO VQ-IMPROPER-REASON                
                   END-IF                                               
                   MOVE VQ-APPLIANCE-CD TO                              
                        T4-APPLIANCE-CD (T4-INDEX)                      
                   MOVE VQ-EQUIP-OWNER TO                               
                        T4-EQUIP-OWNER (T4-INDEX)                       
                   MOVE VQ-CODE-UTIL-TYPE TO                            
                        T4-CODE-UTIL-TYPE (T4-INDEX)                    
                   MOVE VQ-LEAK-IND TO                                  
                        T4-LEAK-IND (T4-INDEX)                          
                   MOVE VQ-LIGHT-IND TO                                 
                        T4-LIGHT-IND (T4-INDEX)                         
                   MOVE VQ-REPAIR-IND TO                                
                        T4-REPAIR-IND (T4-INDEX)                        
                   MOVE VQ-CUTOFF-IND TO                                
                        T4-CUTOFF-IND (T4-INDEX)                        
                   MOVE VQ-CAUTION-TAG-IND TO                           
                        T4-CAUTION-TAG-IND (T4-INDEX)                   
                   MOVE VQ-IMPROPER-REASON TO                           
                        T4-IMPROPER-REASON (T4-INDEX)                   
                   MOVE VQ-APPLIANCE-SEQ-NO TO                          
                        T4-APPLIANCE-SEQ-NO (T4-INDEX)                  
                   MOVE VQ-EQUIPMENT-UNQ TO                             
                        T4-EQUIPMENT-UNQ (T4-INDEX)                     
                   MOVE VO-CATHODIC-PROTECT TO                          
                        T4-CATHODIC-PROTECT (T4-INDEX)                  
                   MOVE VQ-INSTALL-DT TO                                
                        T4-INSTALL-DT (T4-INDEX)                        
                   MOVE VQ-REPLACE-APP-FL TO                            
                        T4-REPLACE-APP-FL (T4-INDEX)                    
                   MOVE VQ-PRD-SRV-TYP-DESC TO                          
                        T4-PRD-SRV-TYP-DESC (T4-INDEX)                  
                   MOVE VQ-INSTALL-IND TO                               
                        T4-INSTALL-IND (T4-INDEX)                       
                   ADD 1 TO WS-T4-ROWCOUNT                              
               WHEN NOT-FOUND                                           
                   GO TO 4165-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '4065'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'FETCH'                  TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_SO_APPLIANCE'       TO TABLE-1             
                   MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-1     
                   MOVE VQ-SERV-ORDER-NO         TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4165-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  GET APPLIANCES FOR THE PREMISE FROM CSS_APPLIANCE.        **          
      ****************************************************************          
                                                                        
       4170-GET-APPLIANCES.                                             
                                                                        
           PERFORM 7160-OPEN-APP-CURSOR THRU 7160-EXIT.                 
           PERFORM 4175-BUILD-TABLE THRU 4175-EXIT VARYING              
                T5-INDEX FROM 1 BY 1 UNTIL                              
                T5-INDEX > 20  OR                                       
                WS-ACTIVE-RETURN-CODE = NOT-FOUND.                      
           PERFORM 7170-CLOSE-APP-CURSOR THRU 7170-EXIT.                
                                                                        
       4170-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  LOAD APPLIANCE DATA FOR PREMISE INTO T5-APPLIANCES        **          
      **  WORKING STORAGE TABLE.  THE ROWCOUNT FOR THIS TABLE IS    **          
      **  IN WS-T5-ROWCOUNT.                                        **          
      ****************************************************************          
                                                                        
       4175-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH APP_CURSOR                                         
               INTO :LA-APPLIANCE-CD,                                   
                    :LA-PRIMARY-FUEL-CD,                                
                    :LA-EQUIPMENT-NO,                                   
                    :LA-CAUTION-TAG-IND,                                
                    :A7-CONDITION-DESC,                                 
                    :LA-CUT-IND,                                        
                    :JA-APPLIANCE-DESC,                                 
                    :JA-CRAWL-FL,                                       
A01114              :JA-SEASONAL-RT-FL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-APPLIANCE-FL                          
                   MOVE LA-APPLIANCE-CD TO                              
                        T5-APPLIANCE-CD (T5-INDEX)                      
                   MOVE LA-PRIMARY-FUEL-CD TO                           
                        T5-PRIMARY-FUEL-CD (T5-INDEX)                   
                   MOVE LA-EQUIPMENT-NO TO                              
                        T5-EQUIPMENT-NO (T5-INDEX)                      
                   MOVE LA-CAUTION-TAG-IND TO                           
                        T5-CAUTION-TAG-IND (T5-INDEX)                   
                   MOVE A7-CONDITION-DESC TO                            
                        T5-CONDITION-DESC (T5-INDEX)                    
                   MOVE LA-CUT-IND TO                                   
                        T5-CUT-IND (T5-INDEX)                           
                   MOVE JA-APPLIANCE-DESC TO                            
                        T5-APPLIANCE-DESC (T5-INDEX)                    
                   MOVE JA-CRAWL-FL TO                                  
                        T5-CRAWL-FL (T5-INDEX)                          
A01114             IF JA-SEASONAL-RT-FL = 'Y'                           
A01114                 MOVE 'Y' TO WS-SEASONAL-APP-FL                   
A01114             END-IF                                               
                   MOVE SPACES TO                                       
                        T5-EQUIP-OWNER (T5-INDEX)                       
                        T5-INSTALL-DT (T5-INDEX)                        
                   MOVE 'N' TO T5-REPLACE-APP-FL (T5-INDEX)             
                   ADD 1 TO WS-T5-ROWCOUNT                              
               WHEN NOT-FOUND                                           
                   GO TO 4175-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
                   MOVE '4075'                   TO ACTIVE-PARAGRAPH    
                   MOVE 'FETCH'                  TO ABEND-FUNCTION      
                   MOVE SPACES                   TO ABEND-SQL-PREDICATES
                                                   ABEND-TABLES         
                   MOVE 'CSS_APPLIANCE'          TO TABLE-1             
                   MOVE 'PREMISE_NO'             TO TABLE-ELEMENT-1     
                   MOVE LA-PREMISE-NO            TO HOSTVAR-ELEMENT-1   
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4175-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  BUILD THE CHANGE LOG REMARKS FOR WORK TYPE CHANGES.       **          
      ****************************************************************          
                                                                        
       4180-BUILD-CHANGE-REMARKS.                                       
                                                                        
           MOVE 'E' TO VI-CODE-UTIL-TYPE.                               
           PERFORM 7190-GET-WORK-TYPE THRU 7190-EXIT.                   
           MOVE VI-WORK-TYPE-CD TO WS-EXISTING-WORK-TYPE-E.             
           MOVE 'G' TO VI-CODE-UTIL-TYPE.                               
           PERFORM 7190-GET-WORK-TYPE THRU 7190-EXIT.                   
           MOVE VI-WORK-TYPE-CD TO WS-EXISTING-WORK-TYPE-G.             
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           IF WS-EXISTING-WORK-TYPE-E > ' ' AND                         
             (WS-EXISTING-WORK-TYPE-E NOT = WS-WORK-TYPE-CD-E)          
                 MOVE WS-ELEC-WORK-TYPE-REMARKS TO WS-EMB-INPUT(1:25)   
                 MOVE 'Y' TO WS-E-REMARKS-EXIST                         
           ELSE                                                         
               MOVE 'N' TO WS-E-REMARKS-EXIST                           
               MOVE SPACES TO WS-EMB-INPUT(1:25)
           END-IF.                       
           IF WS-EXISTING-WORK-TYPE-G > ' ' AND                         
             (WS-EXISTING-WORK-TYPE-G NOT = WS-WORK-TYPE-CD-G)          
                 MOVE WS-GAS-WORK-TYPE-REMARKS TO WS-EMB-INPUT(27:25)   
                 MOVE 'Y' TO WS-G-REMARKS-EXIST                         
           ELSE                                                         
               MOVE 'N' TO WS-G-REMARKS-EXIST                           
               MOVE SPACES TO WS-EMB-INPUT(27:25)
           END-IF.                      
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           MOVE WS-CMP-TABLE TO WS-CHANGE-LOG-REMARKS.                  
                                                                        
       4180-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00073 TO ADD/UPDATE AN ORDER.  MULTIPLE CALLS ARE **          
      **  REQUIRED.  THE LAST CALL HAS A 0 ROW-COUNT.               **          
      ****************************************************************          
                                                                        
       4200-CALL-CSR00073.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00073                                             
      *           (:ROW-NO-0073,                                        
      *            :PREMISE-NO-0073,                                    
      *            :ACCOUNT-NO-0073,                                    
      *            :ACCOUNT-NO-PRIOR-0073,                              
      *            :SERV-ORDER-NO-0073,                                 
      *            :ORDER-TYPE-CD-0073,                                 
      *            :LOCAL-OFFICE-0073,                                  
      *            :PHONE-NO-EXT-0073,                                  
      *            :PHONE-NO-0073,                                      
      *            :ORDER-PLACED-BY-0073,                               
      *            :ORDER-RECVED-BY-0073,                               
      *            :WANTED-BY-DATE-0073,                                
      *            :ASSIGNED-DATETIME-0073,                             
      *            :ORDER-REASON-0073,                                  
      *            :BACK-DATED-IND-0073,                                
      *            :RESP-AREA-ID-0073,                                  
      *            :CALL-BEFORE-MIN-0073,                               
      *            :NOTIFY-CUST-IND-0073,                               
      *            :NOTIFY-CSR-IND-0073,                                
      *            :BREAKERS-OFF-0073,                                  
      *            :DEPOSIT-AMT-0073,                                   
      *            :INIT-BY-CNTRCT-0073,                                
      *            :WORK-AREA-ID-0073,                                  
      *            :ORDER-PRIORITY-0073,                                
      *            :ORDER-STATE-CD-0073,                                
      *            :WORK-TYPE-CD-0073,                                  
      *            :CODE-UTIL-TYPE-0073,                                
      *            :STD-CHG-AMT-0073,                                   
      *            :HOLD-RELEASE-0073,                                  
      *            :RLSE-IND-0073,                                      
      *            :PER-TEMP-IND-0073,                                  
      *            :RLSE-NO-0073,                                       
      *            :RLSE-DATE-0073,                                     
      *            :SO-INST-SEQ-NO-0073,                                
      *            :TABLE-ID-0073,                                      
      *            :UT-CODE-UTIL-TYPE-0073,                             
      *            :IC-NO-0073,                                         
      *            :UT-READ-ROUTE-0073,                                 
      *            :RATE-PLAN-NO-0073,                                  
      *            :UT-CODE-REV-CLASS-0073,                             
      *            :UT-READ-CYCLE-0073,                                 
      *            :UT-CODE-SIC-NO-0073,                                
      *            :METER-NO-0073,                                      
      *            :MN-MTR-REF-NO-0073,                                 
      *            :MN-CODE-TIME-PER-0073,                              
      *            :MN-LAST-READ-VAL-0073,                              
      *            :MN-CODE-STATUS-REA-0073,                            
      *            :MN-CODE-USAGE-TYPE-0073,                            
      *            :MN-CODE-USAGE-ID-0073,                              
      *            :MN-CODE-USAGE-SO-0073,                              
      *            :CODE-METER-STATUS-0073,                             
      *            :METER-SUPPLYING-0073,                               
      *            :CODE-MTR-LOC-0073,                                  
      *            :MN-CONSTANT-0073,                                   
      *            :MN-NO-DIALS-0073,                                   
      *            :MN-POINT-ID-0073,                                   
      *            :MN-SEAL-CODE-ID-0073,                               
      *            :MN-HEX-LOCATION-0073,                               
      *            :MN-INSULATED-IND-0073,                              
      *            :MN-LOCK-TYPE-ID-0073,                               
      *            :MN-DELV-LEVEL-CD-0073,                              
      *            :MN-UTILITY-SOURCE-0073,                             
      *            :MN-IDR-RECIPIENT-0073,                              
      *            :MN-PROGRAM-ID-0073,                                 
      *            :READ-SOURCE-CD-0073,                                
      *            :RG-CODE-REG-STAT-0073,                              
      *            :RG-CODE-STATUS-REA-0073,                            
      *            :RG-CODE-TIME-PER-0073,                              
      *            :RG-CODE-USAGE-ID-0073,                              
      *            :RG-CODE-USAGE-SO-0073,                              
      *            :RG-CODE-USAGE-TY-0073,                              
      *            :RG-LAST-READ-DT-0073,                               
      *            :RG-LAST-READ-VAL-0073,                              
      *            :RG-REG-ID-NO-0073,                                  
      *            :CP-NO-UNITS-0073,                                   
      *            :CP-CODE-PLAN-STA-0073,                              
      *            :CP-CODE-STAT-REA-0073,                              
      *            :CP-CODE-SERVICEZ-0073,                              
      *            :CP-MNTHLY-AMT-FI-0073,                              
      *            :CP-RATE-ITEM-CD-0073,                               
      *            :CP-LIGHT-NO-0073,                                   
      *            :CP-POLE-NO-0073,                                    
      *            :CP-DIST-NO-0073,                                    
      *            :CP-USAGE-FIXED-0073,                                
      *            :CP-EQUIP-ID-0073,                                   
      *            :APPLIANCE-CD-0073,                                  
      *            :APPLIANCE-SEQ-NO-0073,                              
      *            :EQUIP-OWNER-0073,                                   
      *            :MKT-CODE-UTIL-TYPE-0073,                            
      *            :LEAK-IND-0073,                                      
      *            :LIGHT-IND-0073,                                     
      *            :REPAIR-IND-0073,                                    
      *            :CUTOFF-IND-0073,                                    
      *            :CAUTION-TAG-IND-0073,                               
      *            :IMPROPER-REASON-0073,                               
      *            :EQUIPMENT-UNQ-0073,                                 
      *            :VERIFY-RATE-0073,                                   
      *            :ORDER-INST-PRESEN-0073,                             
      *            :EQUIPMENT-PRESEN-0073,                              
      *            :UTIL-ENV-PRESEN-0073,                               
      *            :NEW-ORDER-0073,                                     
      *            :PANEL-NO-0073,                                      
      *            :INCLUDE-INST-0073,                                  
      *            :REV-DIST-CD-0073,                                   
      *            :USER-ID-0073,                                       
      *            :SO-EST-LABOR-HR-0073,                               
      *            :ACCT-STATUS-0073,                                   
      *            :REORDER-FLAG-0073,                                  
      *            :COMPANY-NO-0073,                                    
      *            :INSTALL-DT-0073,                                    
      *            :REPLACE-APP-FL-0073,                                
      *            :PRD-SRV-TYPE-DESC-0073,                             
      *            :OLD-ACCT-STAT-0073,                                 
      *            :CODE-KEY-FIELD-0073,                                
      *            :RCC-CODE-0073,                                      
      *            :MN-LAST-READ-DT-0073,                               
      *            :MN-REG-ID-NO-0073,                                  
      *            :DATE-FORECAST-DNP-0073,                             
      *            :AMT-DNP-AT-BILLING-0073,                            
      *            :PRICE-PER-SERV-0073,                                
      *            :ACCOUNT-TYPE-CODE-0073,                             
      *            :INSTALL-IND-0073,                                   
      *            :CP-ITEM-SEQ-NO-0073,                                
      *            :CUST-CNT-ID-0073,                                   
      *            :WORK-PERIOD-CD-0073,                                
      *            :WAIVER-TYPE-CD-0073,                                
      *            :MN-METER-PRESSURE-0073,                             
P00718*            :BUSINESS-UNIT-0073,                                 
P00718*            :OPTIMIZE-ORDER-0073)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0073
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0073
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0073 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00073'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-0073       TO HOSTVAR-ELEMENT-1           
              MOVE 'ROW_NO'              TO TABLE-ELEMENT-2             
              MOVE ROW-NO-0073           TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0073)                                                
      *       WITH PROCEDURE CSR00073                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0073 CURSOR FOR RESULT SET        
      *       :LOC0073                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0073 INTO                            
                 :NO-ERROR-0073,                                        
                 :NEW-SERV-ORDER-NO-0073,                               
                 :WORK-QUEUE-0073,                                      
                 :RLSE-NO-NEW-0073                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00073'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
                   MOVE PREMISE-NO-0073       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ROW_NO'              TO TABLE-ELEMENT-2        
                   MOVE ROW-NO-0073           TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF NO-ERROR-0073 NOT = 0                                     
               MOVE NO-ERROR-0073             TO RS-STATUS-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '4200'                    TO ACTIVE-PARAGRAPH       
               MOVE 'FETCH'                   TO ABEND-FUNCTION         
               MOVE 'CSR00073'                TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE PREMISE-NO-0073           TO HOSTVAR-ELEMENT-1      
               MOVE 'ROW_NO'                  TO TABLE-ELEMENT-2        
               MOVE ROW-NO-0073               TO HOSTVAR-ELEMENT-2      
               MOVE 'ERROR_NO'                TO TABLE-ELEMENT-2        
               MOVE NO-ERROR-0073             TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
ACT233**  CALL CSR04675 TO INSERT A RELEASE MISMATCH WORK QUEUE.    **          
      ****************************************************************          
                                                                        
ACT233 4210-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT233     MOVE PR-LOCAL-OFFICE TO LOCAL-OFFICE-4675.                   
ACT233     MOVE LINK-ORDER-RECVED-BY TO USER-ID-ORIG-4675.              
ACT233     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT233                    RESP-AREA-ID-4675                             
ACT233                    DATE-REQUIRED-4675                            
ACT233                    DATE-CREATED-4675                             
ACT233                    FREE-FORM-DATA-4675-TEXT.                     
ACT233     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT233     MOVE PR-PREMISE-NO TO PREMISE-NO-4675.                       
ACT233     MOVE NEW-SERV-ORDER-NO-0073 TO SERV-ORDER-NO-4675            
                                          WS-WQ-SERV-ORDER-NO.          
ACT233     MOVE 'CSR04105' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
ACT233        MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
ACT233        MOVE ACCOUNT-NO-4675       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1        
ACT233                 MOVE PREMISE-NO-4675   TO HOSTVAR-ELEMENT-1      
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2        
                       MOVE ACCOUNT-NO-0073   TO HOSTVAR-ELEMENT-2      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1        
ACT233             MOVE PREMISE-NO-4675       TO HOSTVAR-ELEMENT-1      
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
                   MOVE ACCOUNT-NO-0073       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4220-CALL-CSR04747.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-4747.               
           MOVE '1' TO PRIORITY-4747.                                   
           MOVE 'Z' TO ACTION-CD-4747.                                  
           MOVE 'SYSTEM' TO USER-ID-4747.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04747                                             
      *           (:SERV-ORDER-NO-4747,                                 
      *            :PRIORITY-4747,                                      
      *            :ACTION-CD-4747,                                     
      *            :USER-ID-4747,                                       
      *            :IN-WORK-DISTRICT-4747)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4220'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04747'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-4747    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747)                                                
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4747 CURSOR FOR RESULT SET        
      *       :LOC4747                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4747 INTO                            
                 :RETURN-CODE-4747,                                     
                 :OUT-WORK-DISTRICT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4747 NOT = 0                          
                       MOVE RETURN-CODE-4747  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4220'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04747'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-4747 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4220'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-4747    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4300-CHECK-FOR-SPLIT.                                            
                                                                        
           MOVE PR-COMPANY-NO TO SR-COMPANY-NO.                         
           MOVE PR-LOCAL-OFFICE TO SR-LOCAL-OFFICE-CD.                  
           MOVE WS-ORDER-TYPE-CD TO SR-ORIG-ORDER-TYPE-CD.              
           MOVE WS-WORK-TYPE-CD-E TO SR-ORIG-ELE-WKTYPE-CD.             
           MOVE WS-WORK-TYPE-CD-G TO SR-ORIG-GAS-WKTYPE-CD.             
           IF RS-GAS-RLSE-REQ-FL = 'Y'                                  
               MOVE 'G' TO SR-RELEASE-CD                                
           ELSE                                                         
               MOVE 'N' TO SR-RELEASE-CD
           END-IF.                               
           PERFORM 7800-SELECT-SPLIT-ORIG THRU 7800-EXIT.               
           IF WS-SPLIT-ORDER-FL = 'N'                                   
               MOVE 'B' TO SR-LOCAL-OFFICE-CD(1:1)                      
               MOVE PR-COMPANY-NO TO SR-LOCAL-OFFICE-CD(2:2)            
               PERFORM 7800-SELECT-SPLIT-ORIG THRU 7800-EXIT
           END-IF.           
                                                                        
       4300-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00425 TO INSERT NEW CHANGE LOG REMARKS.           **          
      ****************************************************************          
                                                                        
       5000-CALL-CSR00425.                                              
                                                                        
           MOVE WS-SERV-ORDER-NO-CHAR TO SERV-ORDER-NO-0425.            
           MOVE 'E' TO REMARK-TYPE-CD-0425.                             
           MOVE WS-CHANGE-LOG-REMARKS TO REMARKS-0425-TEXT.             
           IF WS-E-REMARKS-EXIST = 'Y' AND WS-G-REMARKS-EXIST = 'Y'     
               MOVE 51 TO REMARKS-0425-LEN                              
           ELSE                                                         
               MOVE 25 TO REMARKS-0425-LEN
           END-IF.                             
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-0425.                   
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00425                                             
      *           (:SERV-ORDER-NO-0425,                                 
      *            :REMARK-TYPE-CD-0425,                                
      *            :REMARKS-0425,                                       
      *            :USER-ID-0425)                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0425
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0425
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0425 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00425'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0425    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0425)                                                
      *       WITH PROCEDURE CSR00425                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0425 CURSOR FOR RESULT SET        
      *       :LOC0425                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0425 INTO                            
                 :RETURN-CODE-0425                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0425 NOT = 0                          
                       MOVE RETURN-CODE-0425  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5000'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00425'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0425 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00425'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0425    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  BUILD AND INSERT SERVICE ORDER REMARKS.                   **          
      ****************************************************************          
                                                                        
       5010-ORDER-COMMENTS.                                             
                                                                        
           MOVE SPACES TO WS-SO-REMARKS                                 
                          WS-EMB-INPUT                                  
                          WS-CMP-TABLE.                                 
           EVALUATE LINK-ARRANGEMENT-FL                                 
               WHEN 'C'                                                 
                   IF LINK-ALT-CONTACT > ' ' OR                         
                      LINK-ALT-PHONE > ' '                              
                          STRING 'CALL '                                
                                 LINK-CALL-BEFORE-MM                    
                                 ' MINS B4// ALT CONTACT '              
                                 LINK-ALT-CONTACT                       
                                 ' ALT PHONE # '                        
                                 LINK-ALT-PHONE                         
                                 '// '                                  
                          DELIMITED BY SIZE INTO WS-ARRANGEMENT-REMARKS 
                   ELSE                                                 
                      STRING 'CALL '                                    
                             LINK-CALL-BEFORE-MM                        
                             ' MINS B4'                                 
                             '// '                                      
                      DELIMITED BY SIZE INTO WS-ARRANGEMENT-REMARKS     
                   END-IF                                               
               WHEN 'X'                                                 
                   MOVE 'AT PREMISES ALL DAY//' TO                      
                        WS-ARRANGEMENT-REMARKS                          
               WHEN 'A'                                                 
                   MOVE 'AM APPT//' TO WS-ARRANGEMENT-REMARKS           
               WHEN 'P'                                                 
                   MOVE 'PM APPT//' TO WS-ARRANGEMENT-REMARKS           
           END-EVALUATE.                                                
           IF LINK-EW-FL = 'Y'                                          
               MOVE ' E&W//' TO WS-EW-REMARKS
           END-IF.                          
           IF WS-RELEASE-REQUIRED = 'Y'                                 
               MOVE ' TLD ABT RELEASE//' TO WS-RELEASE-REMARKS
           END-IF.         
                                                                        
           STRING WS-ARRANGEMENT-REMARKS                                
                  WS-EW-REMARKS                                         
                  WS-RELEASE-REMARKS                                    
                  DELIMITED BY SIZE INTO WS-EMB-INPUT.                  
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           MOVE WS-CMP-TABLE TO WS-SO-REMARKS.                          
           IF WS-SO-REMARKS > ' '                                       
               MOVE NEW-SERV-ORDER-NO-0073 TO EF-SERV-ORDER-NO          
               MOVE 'G' TO EF-REMARK-TYPE-CD                            
               MOVE WS-SO-REMARKS TO EF-REMARK-TX-TEXT                  
               MOVE +120 TO EF-REMARK-TX-LEN                            
               MOVE LINK-ORDER-RECVED-BY TO EF-CHANGED-BY-USER-ID       
               PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT
           END-IF.              
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02072 TO CREATE A DEPOSIT.                        **          
      ****************************************************************          
                                                                        
       5020-CALL-CSR02072.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-LINK-SCHEDULED-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-LINK-SCHEDULED-DT
              ) <> 0) OR (LEN(:WS-LINK-SCHEDULED-DT
              ) <> 10), CIS.CHAR2DATE(:WS-LINK-SCHEDULED-DT
              ), CONVERT(DATE, :WS-LINK-SCHEDULED-DT) )) -              
                      CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))
            INTO
              :WS-NO-OF-DAYS-DEP                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES (DAYS(DATE(:WS-LINK-SCHEDULED-DT)) -                      
MFA-TR*               DAYS(DATE(:WS-CURRENT-DATE)))                             
MFA-TR*          INTO :WS-NO-OF-DAYS-DEP                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE 'I' TO ACTION-CODE-2072.                                
           MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-2072.                     
           MOVE WS-DEPOSIT-AMT-DEC TO WS-DEPOSIT-AMT-NUM.               
           MOVE '00' TO AMT-ORIG-ENTERED-2072(1:2).                     
           MOVE WS-DEPOSIT-AMT-CHAR TO AMT-ORIG-ENTERED-2072(3:9)       
           MOVE 'A' TO DEPOSIT-STATUS-CD-2072.                          
           MOVE 'U' TO SERVICE-TYPE-CD-2072.                            
           MOVE '000000001' TO DEPOSIT-CERT-NO-2072.                    
           MOVE SPACES TO DEP-ACTION-CODE-2072                          
                          ORIG-BILL-OPT-CD-2072                         
                          AUTODEP-LTR-DT-2072                           
                          AUTODEP-LTR-IND-2072.                         
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-UPDT-BY-2072.           
           MOVE 'INITIAL DEPOSIT' TO COMMENTS-2072                      
                                     PANEL-COMMENTS-2072.               
           MOVE 15 TO COMMENTS-LEN-2072                                 
                      PANEL-COMMENTS-LEN-2072.                          
           IF WS-NO-OF-DAYS-DEP < 6                                     
               MOVE 'I' TO BILL-OPTION-CD-2072                          
           ELSE                                                         
               MOVE 'N' TO BILL-OPTION-CD-2072
           END-IF.                         
           MOVE '001' TO NO-SCHED-PYMTS-2072.                           
           MOVE AMT-ORIG-ENTERED-2072 TO AMT-MO-PYMT-2072.              
           MOVE 'I' TO CODE-DEP-TYPE-2072.                              
           MOVE 'PANEL141C' TO PROGRAM-NAME-2072.                       
           MOVE WS-CURRENT-TIMESTAMP TO LAST-UPDATE-TS-2072.            
           MOVE '0' TO CODE-REFUND-ELIG-2072.                           
           MOVE 'Y' TO ERROR-SWITCH-2072.                               
           MOVE 0.0 TO AUTODEP-NOT-AM-2072                              
                       AUTODEP-RECAL-AM-2072.                           
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO INPUT-DATE-1416.                
           MOVE +10 TO BUSINESS-DAYS-1416.                              
           PERFORM 5100-CALL-CSR01416 THRU 5100-EXIT.                   
           MOVE OUTPUT-DATE-1416(1:10) TO CUT-DATE-2072.                
                                                                        
           MOVE WS-CURRENT-TIMESTAMP TO INPUT-DATE-1416.                
           MOVE +9 TO BUSINESS-DAYS-1416.                               
           PERFORM 5100-CALL-CSR01416 THRU 5100-EXIT.                   
           MOVE OUTPUT-DATE-1416(1:10) TO DUE-DATE-2072.                
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, 395, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :PROJECT-CR-DT-2072                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) + 395 DAYS)                      
MFA-TR*          INTO :PROJECT-CR-DT-2072                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02072                                             
      *           (:ACTION-CODE-2072,                                   
      *            :ACCOUNT-NO-2072,                                    
      *            :AMT-ORIG-ENTERED-2072,                              
      *            :DEPOSIT-STATUS-CD-2072,                             
      *            :SERVICE-TYPE-CD-2072,                               
      *            :DEPOSIT-CERT-NO-2072,                               
      *            :DEP-ACTION-CODE-2072,                               
      *            :USER-ID-UPDT-BY-2072,                               
      *            :COMMENTS-2072,                                      
      *            :COMMENTS-LEN-2072,                                  
      *            :PANEL-COMMENTS-2072,                                
      *            :PANEL-COMMENTS-LEN-2072,                            
      *            :BILL-OPTION-CD-2072,                                
      *            :ORIG-BILL-OPT-CD-2072,                              
      *            :NO-SCHED-PYMTS-2072,                                
      *            :AMT-MO-PYMT-2072,                                   
      *            :CODE-DEP-TYPE-2072,                                 
      *            :CUT-DATE-2072,                                      
      *            :PROJECT-CR-DT-2072,                                 
      *            :DUE-DATE-2072,                                      
      *            :PROGRAM-NAME-2072,                                  
      *            :LAST-UPDATE-TS-2072,                                
      *            :CODE-REFUND-ELIG-2072,                              
      *            :ERROR-SWITCH-2072,                                  
      *            :AUTODEP-LTR-DT-2072,                                
      *            :AUTODEP-LTR-IND-2072,                               
      *            :AUTODEP-NOT-AM-2072,                                
      *            :AUTODEP-RECAL-AM-2072)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2072
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2072
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2072 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5020'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02072'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2072       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2072)                                                
      *       WITH PROCEDURE CSR02072                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2072 CURSOR FOR RESULT SET        
      *       :LOC2072                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2072 INTO                            
                   :ERROR-CODE-2072,                                    
                   :RETURN-CODE-2072,                                   
                   :AR-LOCKOUT-IND-2072,                                
                   :ACCT-XFER-TO-2072,                                  
                   :ABEND-PROGRAM-2072,                                 
                   :ACTIVE-PARA-2072,                                   
                   :ABEND-FUNCTION-2072,                                
                   :ABEND-TABLE-2072,                                   
                   :TABLE-ELMT-1-2072,                                  
                   :TABLE-ELMT-2-2072,                                  
                   :TABLE-ELMT-3-2072,                                  
                   :TABLE-ELMT-4-2072,                                  
                   :HOSTVAR-ELMT-1-2072,                                
                   :HOSTVAR-ELMT-2-2072,                                
                   :HOSTVAR-ELMT-3-2072,                                
                   :HOSTVAR-ELMT-4-2072                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2072 NOT = 0                          
                       MOVE RETURN-CODE-2072  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5020'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02072'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2072   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5020'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02072'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2072       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02165 TO CREATE A WAIVER.                         **          
      ****************************************************************          
                                                                        
       5030-CALL-CSR02165.                                              
                                                                        
           MOVE 'I' TO ACTION-CODE-2165.                                
           MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-2165.                     
           EVALUATE LINK-WAIVER-FL                                      
               WHEN 'P'                                                 
                   MOVE 'B' TO WAIVER-TYPE-CD-2165                      
                   MOVE 'WAIVED DEP PER PRIOR CREDIT//WEB' TO           
                        COMMENTS-TEXT-2165                              
                   MOVE '0033' TO COMMENTS-LEN-2165                     
                   MOVE LINK-WAIVER-ACCT TO WAIVER-SRCE-DESC-2165       
               WHEN 'L'                                                 
                   MOVE 'L' TO WAIVER-TYPE-CD-2165                      
                   MOVE 'WAIVER ADDED BY THE SYSTEM//WEB' TO            
                        COMMENTS-TEXT-2165                              
                   MOVE '0033' TO COMMENTS-LEN-2165                     
                   MOVE SPACES TO WAIVER-SRCE-DESC-2165                 
               WHEN OTHER                                               
                   MOVE 'D' TO WAIVER-TYPE-CD-2165                      
                   MOVE 'WAIVED DEP PER EQUIFAX//WEB' TO                
                        COMMENTS-TEXT-2165                              
                   MOVE '0028' TO COMMENTS-LEN-2165                     
                   MOVE SPACES TO WAIVER-SRCE-DESC-2165                 
           END-EVALUATE.                                                
           MOVE 'A' TO CODE-STATUS-2165.                                
           MOVE SPACES TO CODE-STATUS-REAS-2165                         
                          TRIGGER-DATE-2165                             
                          TRAN-COMMENT-TXT-2165.                        
           MOVE ZEROES TO BOND-ITEM-ID-2165                             
                          TRAN-COMMENT-LEN-2165.                        
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-2165.                   
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02165                                             
      *           (:ACTION-CODE-2165,                                   
      *            :ACCOUNT-NO-2165,                                    
      *            :WAIVER-TYPE-CD-2165,                                
      *            :CODE-STATUS-2165,                                   
      *            :COMMENTS-LEN-2165,                                  
      *            :COMMENTS-TEXT-2165,                                 
      *            :CODE-STATUS-REAS-2165,                              
      *            :WAIVER-SRCE-DESC-2165,                              
      *            :TRIGGER-DATE-2165,                                  
      *            :BOND-ITEM-ID-2165,                                  
      *            :USER-ID-2165,                                       
      *            :TRAN-COMMENT-LEN-2165,                              
      *            :TRAN-COMMENT-TXT-2165)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2165
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2165
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2165 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5030'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02165'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2165       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2165)                                                
      *       WITH PROCEDURE CSR02165                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2165 CURSOR FOR RESULT SET        
      *       :LOC2165                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2165 INTO                            
                 :RETURN-CODE-2165                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2165 NOT = 0                          
                       MOVE RETURN-CODE-2165  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5030'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02165'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2165   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5030'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02165'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2165       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  BUILD SERVICE CHARGES WHEN A PSNC CUSTOMER TURNS ON AT A  **          
      **  PREMISE WITHIN A YEAR OF TURNING OFF AT THAT PREMISE.     **          
      ****************************************************************          
                                                                        
       5040-PSNC-SERVICE-CHARGES.                                       
                                                                        
           SET T3-INDEX TO +1.                                          
           SEARCH T3-CSR02210                                           
               AT END                                                   
                   MOVE SPACES TO WS-LAST-READ-DATE                     
               WHEN T3-TABLE-ID (T3-INDEX) = 'MN' AND                   
                    T3-UT-CODE-UTIL-TYPE (T3-INDEX) = 'G' AND           
                    T3-MN-CODE-METER-S (T3-INDEX) = 'J'                 
                        MOVE T3-RG-LAST-READD (T3-INDEX) TO             
                             WS-LAST-READ-DATE                          
           END-SEARCH.                                                  
           IF WS-LAST-READ-DATE > SPACES AND                            
              WS-LAST-READ-DATE > WS-DATE-LAST-YEAR                     
                  MOVE 'Y' TO RS-SERVICE-CHG-FL                         
                  PERFORM 7300-GET-LABOR-CHARGE THRU 7300-EXIT          
                  PERFORM 5050-CALL-CSR00151 THRU 5050-EXIT
           END-IF.            
                                                                        
       5040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00151 TO INSERT SERVICE CHARGES.                  **          
      ****************************************************************          
                                                                        
       5050-CALL-CSR00151.                                              
                                                                        
           MOVE SERV-ORDER-NO-0073 TO SERV-ORDER-NO-0151.               
           MOVE 'G' TO CODE-UTIL-TYPE-0151.                             
           MOVE 0 TO OT-CHARGEABLE-HR-0151                              
                     REG-CHARGEABLE-HR-0151.                            
           MOVE 0.0 TO MATERIAL-CHRG-0151                               
                       OTHER-CHRG-0151                                  
                       CALC-LABOR-CHRG-0151.                            
           MOVE SPACES TO COMMENTS-0151                                 
                          WAIVER-TYPE-CD-0151.                          
           MOVE SV-STD-LABOR-CHRG TO STD-LABOR-CHRG-0151.               
           MOVE 'R' TO ACCOUNT-TYPE-CD-0151.                            
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-0151.                   
           MOVE 'X' TO WORK-PERIOD-CD-0151.                             
           MOVE '015' TO PANEL-NO-0151.                                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00151                                             
      *           (:SERV-ORDER-NO-0151,                                 
      *            :CODE-UTIL-TYPE-0151,                                
      *            :OT-CHARGEABLE-HR-0151,                              
      *            :REG-CHARGEABLE-HR-0151,                             
      *            :MATERIAL-CHRG-0151,                                 
      *            :OTHER-CHRG-0151,                                    
      *            :CALC-LABOR-CHRG-0151,                               
      *            :COMMENTS-0151,                                      
      *            :STD-LABOR-CHRG-0151,                                
      *            :ACCOUNT-TYPE-CD-0151,                               
      *            :USER-ID-0151,                                       
      *            :PANEL-NO-0151,                                      
      *            :WORK-PERIOD-CD-0151,                                
      *            :WAIVER-TYPE-CD-0151)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0151
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0151
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0151 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5050'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00151'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0151    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0151)                                                
      *       WITH PROCEDURE CSR00151                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0151 CURSOR FOR RESULT SET        
      *       :LOC0151                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0151 INTO                            
                 :RETURN-CODE-0151                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0151 NOT = 0                          
                       MOVE RETURN-CODE-0151  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5050'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00151'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0151 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5050'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00151'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0151    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5050-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  BUILD HOLD REMARKS WHEN AN ORDER IS ON HOLD FOR DEPOSIT.  **          
      ****************************************************************          
                                                                        
       5060-HOLD-REMARKS.                                               
                                                                        
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           COMPUTE WS-TOTAL-CHARGES =                                   
                   WS-DEPOSIT-AMT-DEC +                                 
                   SV-STD-LABOR-CHRG.                                   
           MOVE WS-TOTAL-CHARGES TO WS-DISPLAY-CHARGES                  
                                    WS-CHARGE-AMT.                      
           STRING 'HOLD FOR TOTAL = '                                   
                  WS-DISPLAY-CHARGES                                    
           DELIMITED BY SIZE INTO WS-EMB-INPUT.                         
                                                                        
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           MOVE WS-CMP-TABLE TO EF-REMARK-TX-TEXT.                      
           MOVE +30 TO EF-REMARK-TX-LEN.                                
           MOVE NEW-SERV-ORDER-NO-0073 TO EF-SERV-ORDER-NO.             
           MOVE 'H' TO EF-REMARK-TYPE-CD.                               
           MOVE LINK-ORDER-RECVED-BY TO EF-CHANGED-BY-USER-ID.          
           PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT.                  
                                                                        
       5060-EXIT.                                                       
            EXIT.                                                       
                                                                        
A05189****************************************************************          
A05189**  BUILD HOLD REMARKS FOR AN AROP ORDER.                     **          
A05189****************************************************************          
A05189                                                                  
A05189 5065-AROP-REMARKS.                                               
A05189                                                                  
A05189     MOVE 'HOLD FOR AROP IN CYCLE' TO EF-REMARK-TX-TEXT.          
A05189     MOVE +35 TO EF-REMARK-TX-LEN.                                
A05189     MOVE NEW-SERV-ORDER-NO-0073 TO EF-SERV-ORDER-NO.             
A05189     MOVE 'H' TO EF-REMARK-TYPE-CD.                               
A05189     MOVE LINK-ORDER-RECVED-BY TO EF-CHANGED-BY-USER-ID.          
A05189     PERFORM 8200-INSERT-REMARKS THRU 8200-EXIT.                  
A05189                                                                  
A05189 5065-EXIT.                                                       
A05189      EXIT.                                                       
                                                                        
      ****************************************************************          
      **  UPDATE PREMISE SPECIAL INSTRUCTIONS TO INDICATE THE       **          
      **  METER IS ACCESSIBLE.                                      **          
      ****************************************************************          
                                                                        
       5070-SPECIAL-INST.                                               
                                                                        
           MOVE SPACES TO WS-EMB-INPUT WS-CMP-TABLE.                    
           MOVE PR-SPCL-INSTRUCTIONS-LEN TO WS-SPCL-INST-LEN.           
           IF WS-SPCL-INST-LEN > +230                                   
               MOVE +230 TO WS-SPCL-INST-LEN
           END-IF.                           
           STRING PR-SPCL-INSTRUCTIONS-TEXT (1:WS-SPCL-INST-LEN)        
                  ' M/A '                                               
                  WS-CURRENT-DATE-USA                                   
                  DELIMITED BY SIZE INTO WS-EMB-INPUT.                  
           PERFORM 6000-REDUCE-EMBEDDED-SPACES THRU 6000-EXIT.          
           MOVE WS-CMP-TABLE TO PR-SPCL-INSTRUCTIONS-TEXT.              
           COMPUTE PR-SPCL-INSTRUCTIONS-LEN =                           
                   WS-SPCL-INST-LEN + 15.                               
           PERFORM 8500-UPDATE-INSTRUCTIONS THRU 8500-EXIT.             
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO.                     
           MOVE 'SPCL INSTR     '  TO MI-COLUMN-DESC.                   
           MOVE WS-SPCL-INST-TEXT(1:75) TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE PR-SPCL-INSTRUCTIONS-TEXT(1:75) TO                      
                MI-CHG-COLUMN-VALUE-TEXT.                               
           MOVE +75 TO MI-CHG-COLUMN-VALUE-LEN                          
                       MI-PRV-COLUMN-VALUE-LEN.                         
           MOVE SPACES TO MI-TABLE-ID.                                  
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02049 TO INSERT A BILLING ADDRESS.                **          
      ****************************************************************          
                                                                        
       5080-CALL-CSR02049.                                              
                                                                        
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-2049.                   
           MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-2049.                     
           MOVE 'U' TO BILL-ADDR-ENTRED-2049.                           
           MOVE ZEROES TO AT-NAME-ID-2049                               
                          NB-NAME-ID-2049                               
                          ADDRESS-ID-2049.                              
           MOVE 'I' TO AT-NAME-FORMAT-2049                              
                       NB-NAME-FORMAT-2049.                             
           MOVE 'ALL' TO FO-UPDATE-FLG-2049.                            
           MOVE SPACES TO COMMENTS-TEXT-2049.                           
           MOVE 0 TO COMMENT-TXT-LEN-2049.                              
           IF LINK-ADDRESS-FORMAT = 'A'                                 
               MOVE 'A' TO ADDRESS-FORMAT-2049                          
               MOVE LINK-HOUSE-NO TO FO-HOUSE-NO-2049                   
               MOVE LINK-ADDR-PREFIX-1 TO FO-ADDR-PREFIX-1-2049         
               MOVE LINK-ADDR-PREFIX-2 TO FO-ADDR-PREFIX-2-2049         
               MOVE LINK-STREET-NAME TO FO-STREET-NAME-2049             
               MOVE LINK-STREET-SUFFIX TO FO-STREET-SUFFIX-2049         
               MOVE LINK-STREET-LOC-1 TO FO-STRT-LOCTN-1-2049           
               MOVE LINK-STREET-LOC-2 TO FO-STRT-LOCTN-2-2049           
               MOVE LINK-ZIP-CODE TO FO-ZIP-CODE-2049                   
               MOVE LINK-ZIP-CODE-PLUS-4 TO FO-ZIP-CDE-PL-FR-2049       
               MOVE SPACES TO FO-ADDS-OVRFLOW-2049                      
               PERFORM 7400-GET-TOKEN THRU 7400-EXIT                    
               MOVE A4-ZIP-CODE-TOKEN TO FO-ZIP-CODE-TKN-2049           
               MOVE LINK-ADDR-SUFFIX TO FO-ADDR-SUFFIX-2049             
           ELSE                                                         
               MOVE 'B' TO ADDRESS-FORMAT-2049                          
               MOVE LINK-ADDR-STREET TO FR-ADDR-STREET-2049             
               MOVE LINK-ADDRESS-OVERFLOW TO FR-ADDR-OVRFLOW-2049       
               MOVE LINK-ADDR-CITY-STATE TO FR-CITY-STATE-2049          
               MOVE LINK-FR-ZIP-CODE TO FR-ZIP-CODE-2049                
               MOVE LINK-COUNTRY TO FR-COUNTRY-2049
           END-IF.                    
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02049                                             
      *           (:USER-ID-2049,                                       
      *            :ACCOUNT-NO-2049,                                    
      *            :BILL-ADDR-ENTRED-2049,                              
      *            :BILL-NME-ENTERED-2049,                              
      *            :BILL-HDR-ENTERED-2049,                              
      *            :ADDRESS-FORMAT-2049,                                
      *            :AT-NAME-ID-2049,                                    
      *            :AT-NAME-FORMAT-2049,                                
      *            :AT-NAME-TYPE-2049,                                  
      *            :AT-FIRST-NAME-2049,                                 
      *            :AT-MIDDLE-NAME-2049,                                
      *            :AT-LAST-NAME-2049,                                  
      *            :AT-TITLE-PREFIX-2049,                               
      *            :AT-TITLE-SUFIX-1-2049,                              
      *            :AT-TITLE-SUFIX-2-2049,                              
      *            :AT-FULL-NAME-2049,                                  
      *            :NB-NAME-ID-2049,                                    
      *            :NB-NAME-FORMAT-2049,                                
      *            :NB-NAME-TYPE-2049,                                  
      *            :NB-FIRST-NAME-2049,                                 
      *            :NB-MIDDLE-NAME-2049,                                
      *            :NB-LAST-NAME-2049,                                  
      *            :NB-TITLE-PREFIX-2049,                               
      *            :NB-TITLE-SUFIX-1-2049,                              
      *            :NB-TITLE-SUFIX-2-2049,                              
      *            :NB-FULL-NAME-2049,                                  
      *            :ADDRESS-ID-2049,                                    
      *            :FO-UPDATE-FLG-2049,                                 
      *            :FO-HOUSE-NO-2049,                                   
      *            :FO-ADDR-PREFIX-1-2049,                              
      *            :FO-ADDR-PREFIX-2-2049,                              
      *            :FO-STREET-NAME-2049,                                
      *            :FO-STREET-SUFFIX-2049,                              
      *            :FO-STRT-LOCTN-1-2049,                               
      *            :FO-STRT-LOCTN-2-2049,                               
      *            :FO-ADDS-OVRFLOW-2049,                               
      *            :FO-ZIP-CODE-2049,                                   
      *            :FO-ZIP-CDE-PL-FR-2049,                              
      *            :FO-ZIP-CODE-TKN-2049,                               
      *            :FR-ADDR-STREET-2049,                                
      *            :FR-ADDR-OVRFLOW-2049,                               
      *            :FR-CITY-STATE-2049,                                 
      *            :FR-ZIP-CODE-2049,                                   
      *            :FR-COUNTRY-2049,                                    
      *            :FO-ADDR-SUFFIX-2049,                                
      *            :COMMENTS-TEXT-2049,                                 
      *            :COMMENT-TXT-LEN-2049)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2049
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2049
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2049 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5080'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02049'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2049       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2049)                                                
      *       WITH PROCEDURE CSR02049                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2049 CURSOR FOR RESULT SET        
      *       :LOC2049                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2049 INTO                            
                 :RETURN-CODE-2049,                                     
                 :ADDRESS-ID-2049                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2049 NOT = 0                          
                       MOVE RETURN-CODE-2049  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5080'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02049'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2049   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5080'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02049'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2049       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5080-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02517 TO INSERT A COMMUNICATION RECORD.           **          
      ****************************************************************          
                                                                        
       5090-CALL-CSR02517.                                              
                                                                        
           MOVE 'I' TO ACTION-CD-2517.                                  
           MOVE LINK-NEW-CUSTOMER-NO TO CUSTOMER-NO-2517.               
           MOVE LINK-PREMISE-NO TO PREMISE-NO-2517.                     
           IF WS-SPLIT-ORDER-FL = 'Y'                                   
               MOVE '0000000000000' TO ACCOUNT-NO-2517                  
               MOVE 'C' TO COMM-ASSOC-CD-2517                           
           ELSE                                                         
               MOVE 'A' TO COMM-ASSOC-CD-2517                           
               IF LINK-REVERT-FL = 'Y'                                  
                   MOVE WS-CURR-CUSTOMER-NO-CHAR TO CUSTOMER-NO-2517    
                   MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2517         
               ELSE                                                     
                   MOVE ACCOUNT-NO-2054 TO ACCOUNT-NO-2517
               END-IF
           END-IF.             
           MOVE SPACES TO COMMUNICATION-ID-2517                         
                          RED-FLAG-EXP-DT-2517                          
                          PROMOTION-ID-2517                             
                          CALL-END-TIME-2517                            
                          SCREEN-POP-IND-2517                           
                          RESPONSE-RESN-CD-2517                         
                          RESPONSE-TYPE-CD-2517                         
                          SOLICITATION-CD-2517.                         
           MOVE PR-COMPANY-NO TO COMPANY-NO-2517.                       
           MOVE 'N' TO RED-FLAG-IND-2517                                
                       PSC-COMPLAINT-IND-2517                           
                       COMPLAINT-FL-2517.                               
           MOVE 'Z' TO COMM-METHOD-2517.                                
           MOVE 'I' TO COMM-DIRECTION-2517.                             
           MOVE '41' TO COMM-TYPE-CD-2517.                              
           IF LINK-XFER-FL = 'Y'                                        
               MOVE '11' TO COMM-SUBTYPE-CD-2517                        
           ELSE                                                         
               MOVE '10' TO COMM-SUBTYPE-CD-2517
           END-IF.                       
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-ORIG-2517.              
           MOVE LINK-ORDER-PLACED-BY TO CONTACT-NAME-2517.              
           MOVE ZEROES TO CALL-ORIGIN-ID-2517                           
                          NUMBER-TRANSFERS-2517                         
                          HOLD-TIME-2517                                
                          QUEUE-TIME-2517                               
                          TOTAL-CALL-TIME-2517.                         
           IF LINK-REVERT-FL = 'Y'                                      
               STRING 'CC/REVERT ORDER SCHEDULED '                      
                      WS-LINK-SCHEDULED-DT                              
                      ' SEE EMAIL IMAGE FOR ADDL DETAILS'               
                      DELIMITED BY SIZE INTO COMMENT-TEXT-2517          
           ELSE                                                         
               IF WS-SPLIT-ORDER-FL = 'Y'                               
                   MOVE WS-SPLIT-COMMENTS TO COMMENT-TEXT-2517          
               ELSE                                                     
                   STRING 'TURN ON ORDER SCHEDULED '                    
                          WS-LINK-SCHEDULED-DT                          
                          ' SEE EMAIL IMAGE FOR ADDL DETAILS'           
                          DELIMITED BY SIZE INTO COMMENT-TEXT-2517
               END-IF
           END-IF.     
           MOVE LENGTH OF COMMENT-TEXT-2517 TO COMMENT-LEN-2517.        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02517                                             
      *           (:ACTION-CD-2517,                                     
      *            :ACCOUNT-NO-2517,                                    
      *            :CUSTOMER-NO-2517,                                   
      *            :PREMISE-NO-2517,                                    
      *            :COMMUNICATION-ID-2517,                              
      *            :COMPANY-NO-2517,                                    
      *            :RED-FLAG-IND-2517,                                  
      *            :RED-FLAG-EXP-DT-2517,                               
      *            :COMM-METHOD-2517,                                   
      *            :COMM-DIRECTION-2517,                                
      *            :COMM-TYPE-CD-2517,                                  
      *            :COMM-SUBTYPE-CD-2517,                               
      *            :USER-ID-ORIG-2517,                                  
      *            :CONTACT-NAME-2517,                                  
      *            :PROMOTION-ID-2517,                                  
      *            :PSC-COMPLAINT-IND-2517,                             
      *            :CALL-ORIGIN-ID-2517,                                
      *            :CALL-END-TIME-2517,                                 
      *            :NUMBER-TRANSFERS-2517,                              
      *            :HOLD-TIME-2517,                                     
      *            :QUEUE-TIME-2517,                                    
      *            :SCREEN-POP-IND-2517,                                
      *            :TOTAL-CALL-TIME-2517,                               
      *            :COMMENT-LEN-2517,                                   
      *            :COMMENT-TEXT-2517,                                  
      *            :COMM-ASSOC-CD-2517,                                 
      *            :COMPLAINT-FL-2517,                                  
      *            :RESPONSE-RESN-CD-2517,                              
      *            :RESPONSE-TYPE-CD-2517,                              
      *            :SOLICITATION-CD-2517)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2517
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2517 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5090'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02517'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2517)                                                
      *       WITH PROCEDURE CSR02517                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2517 CURSOR FOR RESULT SET        
      *       :LOC2517                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2517 INTO                            
                 :RETURN-CODE-2517                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2517 NOT = 0                          
                       MOVE RETURN-CODE-2517  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5090'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02517'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2517   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5090'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02517'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2517       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5090-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR01416 TO GET THE DATE THAT IS X NUMBER OF         **          
      **  BUSINESS DAYS IN THE FUTURE.                              **          
      ****************************************************************          
                                                                        
       5100-CALL-CSR01416.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01416                                             
      *           (:INPUT-DATE-1416,                                    
      *            :BUSINESS-DAYS-1416)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1416
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1416 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01416'            TO TABLE-1                     
              MOVE 'INPUT_DATE'          TO TABLE-ELEMENT-1             
              MOVE INPUT-DATE-1416       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1416)                                                
      *       WITH PROCEDURE CSR01416                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1416 CURSOR FOR RESULT SET        
      *       :LOC1416                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1416 INTO                            
                 :OUTPUT-DATE-1416                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5100'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01416'            TO TABLE-1                
                   MOVE 'INPUT_DATE'          TO TABLE-ELEMENT-1        
                   MOVE INPUT-DATE-1416       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  DETERMINE IF THE OLD PENDING ACCOUNT CAN BE DELETED       **          
      ****************************************************************          
                                                                        
       5200-DELETE-PENDING-ACCOUNT.                                     
                                                                        
           MOVE 'Y' TO WS-DELETE-FLAG.                                  
           PERFORM 7500-CHECK-ORDERS THRU 7500-EXIT.                    
           IF WS-DELETE-FLAG = 'Y'                                      
               PERFORM 7600-SELECT-ACCOUNT THRU 7600-EXIT               
               IF WS-DELETE-FLAG = 'Y'                                  
A05317             PERFORM 5300-CALL-CSR04291 THRU 5300-EXIT
               END-IF
           END-IF.           
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
A05317**  CALL CSR04291 TO DELETE THE OLD PENDING ACCOUNT           **          
      ****************************************************************          
                                                                        
A05317 5300-CALL-CSR04291.                                              
                                                                        
A05317     MOVE LINK-ORDER-RECVED-BY TO USER-ID-4291.                   
A05317     MOVE AT-ACCOUNT-NO TO WS-ACCT-NO-NUM.                        
A05317     MOVE WS-ACCT-NO-CHAR TO ACCOUNT-NO-4291.                     
                                                                        
      *    EXEC SQL                                                     
A05317*       CALL CSR04291                                             
A05317*           (:ACCOUNT-NO-4291,                                    
A05317*            :USER-ID-4291,                                       
A05317*            :COMMENTS-4291)                                      
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4291
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4291
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4291 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
A05317        MOVE 'CSR04291'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A05317        MOVE ACCOUNT-NO-4291       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
A05317*       (:LOC4291)                                                
A05317*       WITH PROCEDURE CSR04291                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
A05317*       ALLOCATE RESULT_SET_CSR_4291 CURSOR FOR RESULT SET        
A05317*       :LOC4291                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
A05317        FETCH RESULT_SET_CSR_4291 INTO                            
A05317           :RETURN-CODE-4291,                                     
A05317           :STATUS-CODE-4291                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A05317             IF RETURN-CODE-4291 NOT = 0                          
A05317                 MOVE RETURN-CODE-4291  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5300'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
A05317                 MOVE 'CSR04291'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
A05317                 MOVE ACCOUNT-NO-4291   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
A05317             MOVE 'CSR04291'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
A05317             MOVE ACCOUNT-NO-4291       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5400-FORMAT-SERVICE-ADDRESS.                                     
                                                                        
           MOVE 'Y' TO LINK-ADD-BILL-ADDR-FL.                           
           MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID.                         
           PERFORM 7950-FORMATTED-ADDRESS THRU 7950-EXIT.               
           MOVE 'A' TO LINK-ADDRESS-FORMAT.                             
           MOVE DY-HOUSE-NO TO LINK-HOUSE-NO.                           
           MOVE DY-ADDR-PREFIX-1 TO LINK-ADDR-PREFIX-1.                 
           MOVE DY-ADDR-PREFIX-2 TO LINK-ADDR-PREFIX-2.                 
           MOVE DY-STREET-NAME TO LINK-STREET-NAME.                     
           MOVE DY-STREET-SUFFIX TO LINK-STREET-SUFFIX.                 
           MOVE DY-ADDR-SUFFIX TO LINK-ADDR-SUFFIX.                     
           MOVE DY-STREET-LOCATION-1 TO LINK-STREET-LOC-1.              
           MOVE DY-STREET-LOCATION-2 TO LINK-STREET-LOC-2.              
           MOVE DY-ZIP-CODE TO LINK-ZIP-CODE.                           
           MOVE DY-ZIP-CODE-PLUS-FOUR TO LINK-ZIP-CODE-PLUS-4.          
           MOVE A4-TOWN TO LINK-TOWN.                                   
           MOVE A4-STATE TO LINK-STATE.                                 
                                                                        
       5400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5450-COMPARE-ADDRESSES.                                          
                                                                        
           MOVE AT-ADDRESS-ID TO DY-ADDRESS-ID.                         
           PERFORM 7950-FORMATTED-ADDRESS THRU 7950-EXIT.               
           IF LINK-HOUSE-NO = DY-HOUSE-NO AND                           
              LINK-ADDR-PREFIX-1 = DY-ADDR-PREFIX-1 AND                 
              LINK-ADDR-PREFIX-2 = DY-ADDR-PREFIX-2 AND                 
              LINK-STREET-NAME = DY-STREET-NAME AND                     
              LINK-STREET-SUFFIX = DY-STREET-SUFFIX AND                 
              LINK-ADDR-SUFFIX = DY-ADDR-SUFFIX AND                     
              LINK-STREET-LOC-1 = DY-STREET-LOCATION-1 AND              
              LINK-STREET-LOC-2 = DY-STREET-LOCATION-2 AND              
              LINK-TOWN = A4-TOWN AND                                   
              LINK-STATE = A4-STATE AND                                 
              LINK-ZIP-CODE = DY-ZIP-CODE                               
                  MOVE 'N' TO LINK-ADD-BILL-ADDR-FL
           END-IF.                    
                                                                        
       5450-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  TRANSFER PROCESSING.  THE ONLY TIME A TRANSFER WILL BE    **          
      **  DONE IN THIS PROGRAM IS WHEN THE OFF ORDER FOR THE XFER   **          
      **  CONVERTS TO A CC/REVERT.  WAIVER PROCESSING WILL BE DONE  **          
      **  HERE IN THIS SITUATION ONLY.                              **          
      ****************************************************************          
                                                                        
       5500-XFER-PROCESSING.                                            
                                                                        
           PERFORM 5510-CALL-CSR02142 THRU 5510-EXIT.                   
           PERFORM 5515-CALL-CSR00178 THRU 5515-EXIT.                   
           PERFORM 5520-CALL-CSR02146 THRU 5520-EXIT.                   
           PERFORM 5530-CALL-CSR02165 THRU 5530-EXIT.                   
           IF LINK-ADD-BILL-ADDR-FL = 'N'                               
               PERFORM 5550-DEFAULT-FB-ADDRESS THRU 5550-EXIT
           END-IF.          
           MOVE '038' TO VW-PANEL-NO.                                   
           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                
                                                                        
       5500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02142 TO GET TRANSFER INFORMATION.                **          
      ****************************************************************          
                                                                        
       5510-CALL-CSR02142.                                              
                                                                        
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2142.                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02142                                             
      *           (:ACCOUNT-NO-2142)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2142
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2142
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2142 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5510'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02142'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2142       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2142)                                                
      *       WITH PROCEDURE CSR02142                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2142 CURSOR FOR RESULT SET        
      *       :LOC2142                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2142 INTO                            
                 :DNP-DATE-2142,                                        
                 :PAST-DUE-BAL-2142,                                    
                 :BILL-DATE-2142,                                       
                 :CREDIT-GROUP-2142,                                    
                 :ACCT-XFER-FROM-LST-2142,                              
                 :STA-IND-2142,                                         
                 :UTL-IND-2142,                                         
                 :BANK-DRAFT-IND-2142,                                  
                 :EPP-IND-2142,                                         
                 :DEPOSIT-IND-2142,                                     
                 :OTHER-RECV-IND-2142,                                  
                 :PROJ-SHARE-IND-2142,                                  
                 :WRITE-OFF-IND-2142,                                   
                 :IN-LIEU-DEP-IND-2142,                                 
                 :ROOMMATE-IND-2142,                                    
                 :CO-APP-IND-2142,                                      
                 :MEDICAL-IND-2142,                                     
                 :WHITE-CROSS-IND-2142,                                 
                 :RETURN-CODE-2142,                                     
                 :EPP-TRAN-BALANCE-2142,                                
                 :CONTRACT-FLAG-2142,                                   
                 :CODE-ACCT-STAT-2142,                                  
                 :ADDRESS-FORMAT-2142,                                  
                 :HOUSE-NO-2142,                                        
                 :ADDR-PREFIX-1-2142,                                   
                 :ADDR-PREFIX-2-2142,                                   
                 :STREET-NAME-2142,                                     
                 :STREET-SUFFIX-2142,                                   
                 :ADDR-SUFFIX-2142,                                     
                 :STREET-LOCATION-1-2142,                               
                 :STREET-LOCATION-2-2142,                               
                 :ZIP-CODE-2142,                                        
                 :ZIP-CODE-PLUS-FOUR-2142,                              
                 :ZIP-CODE-TOKEN-2142,                                  
                 :ADDRESS-OVERFLOW-2142,                                
                 :ADDR-STREET-2142,                                     
                 :ADDR-CITY-STATE-2142,                                 
                 :ADDR-ZIP-CODE-2142,                                   
                 :ADDR-COUNTRY-2142,                                    
                 :ADDR-OVERFLOW-2142                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2142 NOT = 0                          
                       MOVE RETURN-CODE-2142  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5510'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02142'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2142   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5510'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02142'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2142       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5510-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00178 TO UPDATE SO ACCOUNT TRANSFER.              **          
      ****************************************************************          
                                                                        
       5515-CALL-CSR00178.                                              
                                                                        
           MOVE 'U' TO UPDATE-TYPE-0178.                                
           MOVE WS-ACCOUNT-XFER-NUM TO TO-ACCT-NO-0178.                 
           MOVE RS-SERV-ORDER-NO TO SERV-ORDER-NO-0178.                 
           IF ROOMMATE-IND-2142 = 'A'                                   
               MOVE 'Y' TO ROOMMATE-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO ROOMMATE-XFER-IND-0178
           END-IF.                      
           IF EPP-IND-2142 = 'A'                                        
               MOVE 'Y' TO EPP-XFER-IND-0178                            
           ELSE                                                         
               MOVE 'N' TO EPP-XFER-IND-0178
           END-IF.                           
           IF DEPOSIT-IND-2142 = 'A'                                    
               MOVE 'Y' TO DEPOSIT-XFER-IND-0178                        
           ELSE                                                         
               MOVE 'N' TO DEPOSIT-XFER-IND-0178
           END-IF.                       
           IF OTHER-RECV-IND-2142 = 'A'                                 
               MOVE 'Y' TO OTHER-AR-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO OTHER-AR-XFER-IND-0178
           END-IF.                      
           IF PROJ-SHARE-IND-2142 = 'A'                                 
               MOVE 'Y' TO PROJ-SHR-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO PROJ-SHR-XFER-IND-0178
           END-IF.                      
           MOVE 'N' TO WRITE-OFF-XFER-IND-0178.                         
           IF IN-LIEU-DEP-IND-2142 = 'A'                                
               MOVE 'Y' TO IN-LIEU-XFER-IND-0178                        
           ELSE                                                         
               MOVE 'N' TO IN-LIEU-XFER-IND-0178
           END-IF.                       
           IF WHITE-CROSS-IND-2142 = 'A'                                
               MOVE 'Y' TO WHT-CROSS-XFER-IND-0178                      
           ELSE                                                         
               MOVE 'N' TO WHT-CROSS-XFER-IND-0178
           END-IF.                     
           IF CO-APP-IND-2142 = 'A'                                     
               MOVE 'Y' TO COAPPL-XFER-IND-0178                         
           ELSE                                                         
               MOVE 'N' TO COAPPL-XFER-IND-0178
           END-IF.                        
           IF MEDICAL-IND-2142 = 'A'                                    
               MOVE 'Y' TO MED-CERT-XFER-IND-0178                       
           ELSE                                                         
               MOVE 'N' TO MED-CERT-XFER-IND-0178
           END-IF.                      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00178                                             
      *          (:UPDATE-TYPE-0178,                                    
      *           :TO-ACCT-NO-0178,                                     
      *           :SERV-ORDER-NO-0178,                                  
      *           :ROOMMATE-XFER-IND-0178,                              
      *           :EPP-XFER-IND-0178,                                   
      *           :DEPOSIT-XFER-IND-0178,                               
      *           :OTHER-AR-XFER-IND-0178,                              
      *           :PROJ-SHR-XFER-IND-0178,                              
      *           :WRITE-OFF-XFER-IND-0178,                             
      *           :IN-LIEU-XFER-IND-0178,                               
      *           :WHT-CROSS-XFER-IND-0178,                             
      *           :COAPPL-XFER-IND-0178,                                
      *           :MED-CERT-XFER-IND-0178)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0178
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0178
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0178 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5515'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00178'            TO TABLE-1                     
              MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1             
              MOVE TO-ACCT-NO-0178       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0178)                                                
      *       WITH PROCEDURE CSR00178                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0178 CURSOR FOR RESULT SET        
      *       :LOC0178                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0178 INTO                            
                 :RETURN-CODE-0178                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0178 NOT = 0                          
                       MOVE RETURN-CODE-0178  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5515'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00178'        TO TABLE-1                
                       MOVE 'TO_ACCT_NO'      TO TABLE-ELEMENT-1        
                       MOVE TO-ACCT-NO-0178   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5515'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00178'            TO TABLE-1                
                   MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1        
                   MOVE TO-ACCT-NO-0178       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5515-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02146 TO GET CONTRACT INFORMATION.  FOR EACH      **          
      **  CONTRACT, CALL CSR00179 TO UPDATE SO TABLE FOR XFER.      **          
      ****************************************************************          
                                                                        
       5520-CALL-CSR02146.                                              
                                                                        
           MOVE LINK-CURR-ACCOUNT-NO TO ACCOUNT-NO-2146.                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02146                                             
      *           (:ACCOUNT-NO-2146)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2146
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2146
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2146 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5520'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02146'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2146       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2146)                                                
      *       WITH PROCEDURE CSR02146                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2146 CURSOR FOR RESULT SET        
      *       :LOC2146                                                  
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y' TO SW-FETCH.                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
               EXEC SQL                                                 
                  FETCH RESULT_SET_CSR_2146 INTO                        
                     :CONTRACT-ID-2146,                                 
                     :CONTRACT-NAME-ABBR-2146,                          
                     :AR-TRAN-BAL-2146,                                 
                     :LIEN-CD-2146,                                     
P00795               :TRANSFER-FL-2146,                                 
P00795               :CNT-NAME-DESC-2146,                               
                     :RETURN-CODE-2146                                  
               END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       IF RETURN-CODE-2146 NOT = 0 AND                  
                          RETURN-CODE-2146 NOT = 100                    
                             MOVE RETURN-CODE-2146 TO RS-STATUS-CODE    
                                                WS-ACTIVE-RETURN-CODE   
                             MOVE PROGRAM-NAME  TO ABEND-PROGRAM        
                             MOVE '5520'        TO ACTIVE-PARAGRAPH     
                             MOVE 'FETCH'       TO ABEND-FUNCTION       
                             MOVE 'CSR02146'    TO TABLE-1              
                             MOVE 'ACCOUNT_NO'  TO TABLE-ELEMENT-1      
                             MOVE ACCOUNT-NO-2146 TO HOSTVAR-ELEMENT-1  
                             PERFORM 9000-SEND-ERROR-RESULT THRU        
                                     9000-EXIT                          
                             PERFORM 9900-SQL-ERROR-ROUTINE THRU        
                                     9900-EXIT                          
                       END-IF                                           
                       IF RETURN-CODE-2146 = 100                        
                           SET NO-MORE-ROWS TO TRUE                     
                           MOVE 0 TO WS-ACTIVE-RETURN-CODE              
                       END-IF                                           
                       IF RETURN-CODE-2146 = 0 AND                      
                          LIEN-CD-2146 NOT = 'Y' AND                    
D06358                    TRANSFER-FL-2146 = 'Y'                        
                             PERFORM 5525-CALL-CSR00179 THRU 5525-EXIT  
                       END-IF                                           
                   WHEN NOT-FOUND                                       
                       SET NO-MORE-ROWS TO TRUE                         
                       MOVE 0 TO WS-ACTIVE-RETURN-CODE                  
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5520'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02146'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2146   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE                                             
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5520-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00179 TO UPDATE SO TABLE FOR XFER.                **          
      ****************************************************************          
                                                                        
       5525-CALL-CSR00179.                                              
                                                                        
           MOVE 'U' TO UPDATE-TYPE-0179.                                
           MOVE WS-ACCOUNT-XFER-NUM TO TO-ACCT-NO-0179.                 
           MOVE CONTRACT-ID-2146 TO CNT-ITEM-ID-0179.                   
           MOVE RS-SERV-ORDER-NO TO SERV-ORDER-NO-0179.                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00179                                             
      *           (:UPDATE-TYPE-0179,                                   
      *            :TO-ACCT-NO-0179,                                    
      *            :CNT-ITEM-ID-0179,                                   
      *            :SERV-ORDER-NO-0179)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0179
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0179
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0179 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5525'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00179'            TO TABLE-1                     
              MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1             
              MOVE TO-ACCT-NO-0179       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0179)                                                
      *       WITH PROCEDURE CSR00179                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0179 CURSOR FOR RESULT SET        
      *       :LOC0179                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0179 INTO                            
                 :RETURN-CODE-0179                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0179 NOT = 0                          
                       MOVE RETURN-CODE-0179  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5525'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00179'        TO TABLE-1                
                       MOVE 'TO_ACCT_NO'      TO TABLE-ELEMENT-1        
                       MOVE TO-ACCT-NO-0179   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5525'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00179'            TO TABLE-1                
                   MOVE 'TO_ACCT_NO'          TO TABLE-ELEMENT-1        
                   MOVE TO-ACCT-NO-0179       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5525-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR02165 TO CREATE A WAIVER.                         **          
      ****************************************************************          
                                                                        
       5530-CALL-CSR02165.                                              
                                                                        
           MOVE 'I' TO ACTION-CODE-2165.                                
           MOVE LINK-XFER-ACCOUNT-NO TO ACCOUNT-NO-2165                 
                                        WS-DISP-XFER-ACCT.              
           MOVE 'K' TO WAIVER-TYPE-CD-2165.                             
           MOVE 'A' TO CODE-STATUS-2165.                                
           MOVE SPACES TO CODE-STATUS-REAS-2165                         
                          TRIGGER-DATE-2165                             
                          WAIVER-SRCE-DESC-2165.                        
           MOVE ZEROES TO BOND-ITEM-ID-2165.                            
           MOVE 'WAIVER ADDED BY SYSTEM' TO COMMENTS-TEXT-2165.         
           MOVE '0022' TO COMMENTS-LEN-2165.                            
           MOVE LINK-ORDER-RECVED-BY TO USER-ID-2165                    
                                        WS-DISP-XFER-USER.              
           MOVE RS-SERV-ORDER-NO TO WS-DISP-XFER-SO.                    
           MOVE WS-WAIVER-COMMENTS TO TRAN-COMMENT-TXT-2165.            
           MOVE '0090' TO TRAN-COMMENT-LEN-2165.                        
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02165                                             
      *           (:ACTION-CODE-2165,                                   
      *            :ACCOUNT-NO-2165,                                    
      *            :WAIVER-TYPE-CD-2165,                                
      *            :CODE-STATUS-2165,                                   
      *            :COMMENTS-LEN-2165,                                  
      *            :COMMENTS-TEXT-2165,                                 
      *            :CODE-STATUS-REAS-2165,                              
      *            :WAIVER-SRCE-DESC-2165,                              
      *            :TRIGGER-DATE-2165,                                  
      *            :BOND-ITEM-ID-2165,                                  
      *            :USER-ID-2165,                                       
      *            :TRAN-COMMENT-LEN-2165,                              
      *            :TRAN-COMMENT-TXT-2165)                              
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2165_2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2165_2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2165_2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5530'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02165'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2165       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2165)                                                
      *       WITH PROCEDURE CSR02165                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2165_2 CURSOR FOR RESULT SET      
      *       :LOC2165                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_2165_2 INTO                          
                 :RETURN-CODE-2165                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-2165 NOT = 0                          
                       MOVE RETURN-CODE-2165  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5530'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR02165'        TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-2165   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5530'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR02165'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-2165       TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       5530-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR00148 TO ADD A FINAL BILL ADDRESS.                **          
      ****************************************************************          
                                                                        
       5540-CALL-CSR00148.                                              
                                                                        
           INITIALIZE CSR00148-CALL-DATA.                               
           MOVE RS-SERV-ORDER-NO TO SERV-ORDER-NO-0148.                 
           MOVE 'N' TO CREDIT-LETTER-IND-0148                           
                       SEND-TO-LOCOFF-IND-0148.                         
           IF LINK-ADDRESS-FORMAT = 'A'                                 
               MOVE 'A' TO ADDRESS-FORMAT-0148                          
               MOVE LINK-HOUSE-NO TO HOUSE-NO-0148                      
               MOVE LINK-ADDR-PREFIX-1 TO ADDR-PREFIX-1-0148            
               MOVE LINK-ADDR-PREFIX-2 TO ADDR-PREFIX-2-0148            
               MOVE LINK-STREET-NAME TO STREET-NAME-0148                
               MOVE LINK-STREET-SUFFIX TO STREET-SUFFIX-0148            
               MOVE LINK-STREET-LOC-1 TO STREET-LOC-1-0148              
               MOVE LINK-STREET-LOC-2 TO STREET-LOC-2-0148              
               MOVE LINK-ZIP-CODE TO ZIP-CODE-0148                      
               MOVE LINK-ZIP-CODE-PLUS-4 TO ZIP-CODE-PLUS-FOUR-0148     
               MOVE SPACES TO ADDRESS-OVERFLOW-0148                     
                              CARRIER-ROUTE-0148                        
               PERFORM 7400-GET-TOKEN THRU 7400-EXIT                    
               MOVE A4-ZIP-CODE-TOKEN TO ZIP-CODE-TOKEN-0148            
               MOVE LINK-ADDR-SUFFIX TO ADDR-SUFFIX-0148                
           ELSE                                                         
               MOVE 'B' TO ADDRESS-FORMAT-0148                          
               MOVE LINK-ADDR-STREET TO ADDR-ST-0148                    
               MOVE LINK-ADDR-CITY-STATE TO FINAL-BILL-CY-ST-0148       
               MOVE LINK-FR-ZIP-CODE TO ADDR-ZIP-CODE-0148              
               MOVE LINK-COUNTRY TO ADDR-COUNTRY-0148                   
               MOVE LINK-ADDRESS-OVERFLOW TO FINAL-BILL-OVFL-0148
           END-IF.      
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00148                                             
      *           (:SERV-ORDER-NO-0148,                                 
      *            :ADDRESS-FORMAT-0148,                                
      *            :CREDIT-LETTER-IND-0148,                             
      *            :SEND-TO-LOCOFF-IND-0148,                            
      *            :HOUSE-NO-0148,                                      
      *            :ADDR-PREFIX-1-0148,                                 
      *            :ADDR-PREFIX-2-0148,                                 
      *            :STREET-NAME-0148,                                   
      *            :STREET-SUFFIX-0148,                                 
      *            :ADDR-SUFFIX-0148,                                   
      *            :STREET-LOC-1-0148,                                  
      *            :STREET-LOC-2-0148,                                  
      *            :ZIP-CODE-0148,                                      
      *            :ZIP-CODE-PLUS-FOUR-0148,                            
      *            :ZIP-CODE-TOKEN-0148,                                
      *            :ADDRESS-OVERFLOW-0148,                              
      *            :ADDR-ST-0148,                                       
      *            :FINAL-BILL-CY-ST-0148,                              
      *            :ADDR-ZIP-CODE-0148,                                 
      *            :ADDR-COUNTRY-0148,                                  
      *            :FINAL-BILL-OVFL-0148,                               
      *            :CARRIER-ROUTE-0148)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0148
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0148
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0148 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5540'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00148'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-0148    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0148)                                                
      *       WITH PROCEDURE CSR00148                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0148 CURSOR FOR RESULT SET        
      *       :LOC0148                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_0148 INTO                            
                 :RETURN-CODE-0148                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-0148 NOT = 0                          
                       MOVE RETURN-CODE-0148  TO RS-STATUS-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5540'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR00148'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-0148 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5540'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR00148'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE SERV-ORDER-NO-0148    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
A01648     PERFORM 8800-UPDATE-CDP THRU 8800-EXIT.                      
                                                                        
       5540-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5550-DEFAULT-FB-ADDRESS.                                         
                                                                        
           IF ADDRESS-FORMAT-2142 = 'A'                                 
               MOVE 'A' TO LINK-ADDRESS-FORMAT                          
               MOVE HOUSE-NO-2142 TO LINK-HOUSE-NO                      
               MOVE ADDR-PREFIX-1-2142 TO LINK-ADDR-PREFIX-1            
               MOVE ADDR-PREFIX-2-2142 TO LINK-ADDR-PREFIX-2            
               MOVE STREET-NAME-2142 TO LINK-STREET-NAME                
               MOVE STREET-SUFFIX-2142 TO LINK-STREET-SUFFIX            
               MOVE ADDR-SUFFIX-2142 TO LINK-ADDR-SUFFIX                
               MOVE STREET-LOCATION-1-2142 TO LINK-STREET-LOC-1         
               MOVE STREET-LOCATION-2-2142 TO LINK-STREET-LOC-2         
               MOVE ZIP-CODE-2142 TO LINK-ZIP-CODE                      
               MOVE ZIP-CODE-PLUS-FOUR-2142 TO LINK-ZIP-CODE-PLUS-4     
           ELSE                                                         
               MOVE 'B' TO LINK-ADDRESS-FORMAT                          
               MOVE ADDR-OVERFLOW-2142 TO LINK-ADDRESS-OVERFLOW         
               MOVE ADDR-STREET-2142 TO LINK-ADDR-STREET                
               MOVE ADDR-CITY-STATE-2142 TO LINK-ADDR-CITY-STATE        
               MOVE ADDR-ZIP-CODE-2142 TO LINK-FR-ZIP-CODE              
               MOVE ADDR-COUNTRY-2142 TO LINK-COUNTRY
           END-IF.                  
                                                                        
           PERFORM 5540-CALL-CSR00148 THRU 5540-EXIT.                   
           MOVE '046' TO VW-PANEL-NO.                                   
           PERFORM 8700-INSERT-AUDIT-ROW THRU 8700-EXIT.                
                                                                        
       5550-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  COMPRESSION ROUTINE TO ELIMINATE SPACES.                  **          
      ****************************************************************          
                                                                        
       6000-REDUCE-EMBEDDED-SPACES.                                     
                                                                        
           MOVE 255 TO WS-EMB-TBL-LENG.                                 
           SET WS-EMB-INDX TO 1.                                        
           SET WS-CMP-INDX TO 1.                                        
           MOVE SPACE TO WS-EMB-LAST-CHAR.                              
           IF WS-EMB-LENG NUMERIC AND                                   
              WS-EMB-LENG > ZERO AND                                    
              WS-EMB-LENG < WS-EMB-TBL-LENG                             
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-TBL-LENG TO WS-EMB-LENG
           END-IF.                     
           PERFORM 6010-COMPRESSION-ROUTINE THRU 6010-EXIT              
               VARYING WS-EMB-INDX FROM WS-EMB-INDX BY 1                
               UNTIL WS-EMB-INDX > WS-EMB-LENG.                         
           MOVE ZERO TO WS-EMB-LENG.                                    
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6010-COMPRESSION-ROUTINE.                                        
                                                                        
           IF WS-EMB-CHAR (WS-EMB-INDX) EQUAL SPACE AND                 
              WS-EMB-LAST-CHAR                                          
                  NEXT SENTENCE                                         
           ELSE                                                         
               MOVE WS-EMB-CHAR (WS-EMB-INDX) TO                        
                    WS-CMP-CHAR (WS-CMP-INDX)                           
                    WS-EMB-LAST-CHAR                                    
                SET WS-CMP-INDX UP BY 1
           END-IF.                                
                                                                        
       6010-EXIT.                                                       
            EXIT.                                                       
                                                                        
            EXEC SQL                                                            
                INCLUDE CPD00067                                                
            END-EXEC.                                                           
                                                                        
       6700-WRITE-WEB-EVENT.                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-WEB-EVENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-WEB-EVENT-TS = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE LINK-NEW-CUSTOMER-NO TO WS-LINK-CUSTOMER-NO-CHAR.       
           MOVE WS-LINK-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO.              
           IF WS-DEPOSIT-AMT-DEC > 0                                    
               MOVE 'Y' TO WS-DEPOSIT-FL                                
               MOVE WS-DEPOSIT-AMT-DEC TO WS-AMT-DEPOSIT                
           ELSE                                                         
               MOVE 0.00 TO WS-AMT-DEPOSIT                              
               MOVE 'N' TO WS-DEPOSIT-FL
           END-IF.                               
           IF LINK-XFER-FL = 'Y' OR                                     
              LINK-WAIVER-FL NOT = 'N'                                  
                  MOVE 'Y' TO WS-WAIVER-FL                              
           ELSE                                                         
               MOVE 'N' TO WS-WAIVER-FL
           END-IF.                                
           MOVE ZEROES TO WS-ON-ORDER-NO                                
                          WS-OFF-ORDER-NO.                              
                                                                        
           IF LINK-UPDATE-ORDER-FL = 'Y'                                
               MOVE 'STRT' TO WS-WEB-EVENT-TYPE-CD                      
               MOVE WS-HOLD-SERV-ORDER-NO TO WS-ON-ORDER-NO             
           ELSE                                                         
               IF WS-MISSING-STRT-EVENT = 'Y'                           
                   MOVE 'XFER' TO WS-WEB-EVENT-TYPE-CD                  
                   MOVE NEW-SERV-ORDER-NO-0073 TO WS-OFF-ORDER-NO       
               ELSE                                                     
                   IF LINK-REVERT-FL = 'Y'                              
                       MOVE 'STOP' TO WS-WEB-EVENT-TYPE-CD              
                       MOVE NEW-SERV-ORDER-NO-0073 TO WS-OFF-ORDER-NO   
                   ELSE                                                 
                       MOVE 'STRT' TO WS-WEB-EVENT-TYPE-CD              
                       MOVE NEW-SERV-ORDER-NO-0073 TO WS-ON-ORDER-NO
                   END-IF
               END-IF
           END-IF.   
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_WEB_EVENT                             
                   (WEB_EVENT_TS,                                       
                    WEB_EVENT_TYPE_CD,                                  
                    ON_ORDER_NO,                                        
                    OFF_ORDER_NO,                                       
                    WAIVER_FL,                                          
                    DEPOSIT_FL,                                         
                    ON_STATE_EMAIL_FL,                                  
                    OFF_STATE_EMAIL_FL,                                 
                    ON_SCHED_EMAIL_FL,                                  
                    OFF_SCHED_EMAIL_FL,                                 
                    ON_PAST_EMAIL_FL,                                   
                    OFF_PAST_EMAIL_FL,                                  
                    CUSTOMER_NO,                                        
                    AMT_DEPOSIT)                                        
               VALUES                                                   
                   ( CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS),                      
                     :WS-WEB-EVENT-TYPE-CD,                             
                     :WS-ON-ORDER-NO,                                   
                     :WS-OFF-ORDER-NO,                                  
                     :WS-WAIVER-FL,                                     
                     :WS-DEPOSIT-FL,                                    
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     :WS-CUSTOMER-NO,                                   
                     :WS-AMT-DEPOSIT)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_WEB_EVENT                                     
MFA-TR*            (WEB_EVENT_TS,                                               
MFA-TR*             WEB_EVENT_TYPE_CD,                                          
MFA-TR*             ON_ORDER_NO,                                                
MFA-TR*             OFF_ORDER_NO,                                               
MFA-TR*             WAIVER_FL,                                                  
MFA-TR*             DEPOSIT_FL,                                                 
MFA-TR*             ON_STATE_EMAIL_FL,                                          
MFA-TR*             OFF_STATE_EMAIL_FL,                                         
MFA-TR*             ON_SCHED_EMAIL_FL,                                          
MFA-TR*             OFF_SCHED_EMAIL_FL,                                         
MFA-TR*             ON_PAST_EMAIL_FL,                                           
MFA-TR*             OFF_PAST_EMAIL_FL,                                          
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             AMT_DEPOSIT)                                                
MFA-TR*        VALUES                                                           
MFA-TR*            ( :WS-WEB-EVENT-TS,                                          
MFA-TR*              :WS-WEB-EVENT-TYPE-CD,                                     
MFA-TR*              :WS-ON-ORDER-NO,                                           
MFA-TR*              :WS-OFF-ORDER-NO,                                          
MFA-TR*              :WS-WAIVER-FL,                                             
MFA-TR*              :WS-DEPOSIT-FL,                                            
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              :WS-CUSTOMER-NO,                                           
MFA-TR*              :WS-AMT-DEPOSIT)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '6700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_WEB_EVENT'   TO TABLE-1                 
                   MOVE 'ON_ORDER_NO'        TO TABLE-ELEMENT-1         
                   MOVE WS-ON-ORDER-NO       TO HOSTVAR-ELEMENT-1       
                   MOVE 'OFF_ORDER_NO'       TO TABLE-ELEMENT-2         
                   MOVE WS-OFF-ORDER-NO      TO HOSTVAR-ELEMENT-2       
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3         
                   MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-3       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       6700-EXIT.                                                       
            EXIT.                                                       
                                                                        
       6800-UPDATE-WEB-EVENT.                                           
                                                                        
           MOVE WS-CURR-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO.              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           WEB_EVENT_TS, 121), ' ', '-'), ':', '.') WEB_EVENT_TS               
                 INTO :WS-WEB-EVENT-TS                                  
                 FROM CSS_SO_WEB_EVENT                                  
                WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                     
                  AND WEB_EVENT_TYPE_CD = 'STRT'                        
                  AND WEB_EVENT_TS > DATEADD( MINUTE, -10, 
           CIS.CURRENT$TIMESTAMP() )     
                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WEB_EVENT_TS                                              
MFA-TR*          INTO :WS-WEB-EVENT-TS                                          
MFA-TR*          FROM CSS_SO_WEB_EVENT                                          
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                             
MFA-TR*           AND WEB_EVENT_TYPE_CD = 'STRT'                                
MFA-TR*           AND WEB_EVENT_TS > CURRENT TIMESTAMP - 10 MINUTES             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 6800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO WS-MISSING-STRT-EVENT                    
                   PERFORM 6700-WRITE-WEB-EVENT THRU 6700-EXIT          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '6800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_WEB_EVENT'   TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           MOVE NEW-SERV-ORDER-NO-0073 TO WS-OFF-ORDER-NO.              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_WEB_EVENT                                  
                  SET WEB_EVENT_TYPE_CD = 'XFER',                       
                      OFF_ORDER_NO = :WS-OFF-ORDER-NO,                  
                      WAIVER_FL    = 'Y'                                
                WHERE WEB_EVENT_TS = CIS.CHAR2TIMESTAMP(:WS-WEB-EVENT-TS
              )                   
                  AND CUSTOMER_NO  = :WS-CUSTOMER-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_WEB_EVENT                                          
MFA-TR*           SET WEB_EVENT_TYPE_CD = 'XFER',                               
MFA-TR*               OFF_ORDER_NO = :WS-OFF-ORDER-NO,                          
MFA-TR*               WAIVER_FL    = 'Y'                                        
MFA-TR*         WHERE WEB_EVENT_TS = :WS-WEB-EVENT-TS                           
MFA-TR*           AND CUSTOMER_NO  = :WS-CUSTOMER-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '6800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_WEB_EVENT'   TO TABLE-1                 
                   MOVE 'WEB_EVENT_TS'       TO TABLE-ELEMENT-1         
                   MOVE WS-WEB-EVENT-TS      TO HOSTVAR-ELEMENT-1       
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2         
                   MOVE WS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       6800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  COUNT THE NUMBER OF OFF01 AND CC001 ORDERS FOR THE        **          
      **  PREMISE.                                                  **          
      ****************************************************************          
                                                                        
       7000-COUNT-ORDERS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-ORDERS                                  
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :VO-PREMISE-NO                   
A04336            AND ORDER_TYPE_CD  IN ('CC001', 'OFF01', 'CC002')     
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-ORDERS                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO     = :VO-PREMISE-NO                           
MFA-TR*           AND ORDER_TYPE_CD  IN ('CC001', 'OFF01', 'CC002')             
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT-ORDERS                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  SELECT THE EXSTING ORDER AT THE PREMISE IF ONE EXISTS.    **          
      **  SET THE EXISTING ORDER FLAG. PERFORM EDITS.               **          
      ****************************************************************          
                                                                        
       7010-SELECT-ORDER.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO,
              ORDER_TYPE_CD,
              ORDER_STATE_CD,
              ORDER_REASON,
              REPLACE(REPLACE(CONVERT(CHAR(26), ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              ACCOUNT_NO,
              SO_BUSINESS_UNIT                                  
                 INTO :VO-SERV-ORDER-NO,                                
                      :VO-ORDER-TYPE-CD,                                
                      :VO-ORDER-STATE-CD,                               
                      :VO-ORDER-REASON,                                 
                      :VO-ASSIGNED-DATETIME,                            
                      :VO-ACCOUNT-NO,                                   
A05189                :VO-SO-BUSINESS-UNIT                              
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :VO-PREMISE-NO                   
                  AND ORDER_TYPE_CD  IN ('CC001', 'OFF01')              
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ORDER_TYPE_CD,                                            
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               ORDER_REASON,                                             
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               SO_BUSINESS_UNIT                                          
MFA-TR*          INTO :VO-SERV-ORDER-NO,                                        
MFA-TR*               :VO-ORDER-TYPE-CD,                                        
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-ORDER-REASON,                                         
MFA-TR*               :VO-ASSIGNED-DATETIME,                                    
MFA-TR*               :VO-ACCOUNT-NO,                                           
MFA-TR*               :VO-SO-BUSINESS-UNIT                                      
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO     = :VO-PREMISE-NO                           
MFA-TR*           AND ORDER_TYPE_CD  IN ('CC001', 'OFF01')                      
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-EXISTING-ORDER-FL                     
                   IF VO-ORDER-STATE-CD NOT = 'A'                       
                       MOVE +300 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF VO-ORDER-TYPE-CD = 'CC001' AND                    
                      VO-ORDER-REASON NOT = 'R'                         
                       MOVE +400 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF LINK-REVERT-FL = 'Y'                              
                       MOVE +800 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF LINK-UPDATE-ORDER-FL = 'Y'                        
                       IF VO-ASSIGNED-DATETIME NOT =                    
                          LINK-CURR-SCHEDULED-DT                        
                              MOVE +500 TO RS-STATUS-CODE               
                       END-IF                                           
                       IF VO-SERV-ORDER-NO NOT =                        
                          WS-SERV-ORDER-NO-NUM                          
                              MOVE +600 TO RS-STATUS-CODE               
                       END-IF                                           
                       IF VO-ORDER-TYPE-CD NOT =                        
                          LINK-CURR-ORDER-TYPE                          
                              MOVE +700 TO RS-STATUS-CODE               
                       END-IF                                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO VO-ACCOUNT-NO                              
                             VO-SERV-ORDER-NO                           
                   MOVE 'N' TO WS-EXISTING-ORDER-FL                     
                   IF LINK-UPDATE-ORDER-FL = 'Y'                        
                       MOVE +200 TO RS-STATUS-CODE                      
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7010'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET PREMISE INFORMATION.                                  **          
      ****************************************************************          
                                                                        
       7100-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COMPANY_NO,
              REV_DISTRICT_CD,
              LOCAL_OFFICE,
              SPCL_INSTRUCTIONS,
              ADDRESS_ID,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST                                
                 INTO :PR-COMPANY-NO,                                   
                      :PR-REV-DISTRICT-CD,                              
                      :PR-LOCAL-OFFICE,                                 
                      :PR-SPCL-INSTRUCTIONS,                            
                      :PR-ADDRESS-ID,                                   
P00718                :PR-FM-ELEC-SVC-WKDIST,                           
P00718                :PR-FM-GAS-OPS-WKDIST,                            
P00718                :PR-FM-FLD-SVCS-WKDIST,                           
P00718                :PR-FM-REV-PRT-WKDIST,                            
P00718                :PR-FM-DSM-ESVC-WKDIST                            
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO     = :PR-PREMISE-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO,                                               
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               SPCL_INSTRUCTIONS,                                        
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*          INTO :PR-COMPANY-NO,                                           
MFA-TR*               :PR-REV-DISTRICT-CD,                                      
MFA-TR*               :PR-LOCAL-OFFICE,                                         
MFA-TR*               :PR-SPCL-INSTRUCTIONS,                                    
MFA-TR*               :PR-ADDRESS-ID,                                           
MFA-TR*               :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST,                                    
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST,                                    
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST                                    
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO     = :PR-PREMISE-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF PR-SPCL-INSTRUCTIONS-LEN <= 0                     
                       MOVE SPACES TO WS-SPCL-INST-TEXT                 
                   ELSE                                                 
                       MOVE PR-SPCL-INSTRUCTIONS-TEXT TO                
                            WS-SPCL-INST-TEXT                           
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'CSS_REV_DISTRICT' TO TABLE-2                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  DETERMINE IF THE NEW ORDER/WORK TYPE COMBINATION REQUIRES **          
      **  A RELEASE.                                                **          
      ****************************************************************          
                                                                        
       7110-RELEASE-RQMT.                                               
                                                                        
           MOVE SPACES TO L3-RLSE-CHECK-CD.                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RLSE_CHECK_CD                                     
                 INTO :L3-RLSE-CHECK-CD                                 
                 FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
                WHERE ORDER_TYPE_CD = :WS-ORDER-TYPE-CD                 
                  AND WORK_TYPE_CD  = :WS-WORK-TYPE-CD                  
                  AND COMPANY_NO    = :PR-COMPANY-NO                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RLSE_CHECK_CD                                             
MFA-TR*          INTO :L3-RLSE-CHECK-CD                                         
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE ORDER_TYPE_CD = :WS-ORDER-TYPE-CD                         
MFA-TR*           AND WORK_TYPE_CD  = :WS-WORK-TYPE-CD                          
MFA-TR*           AND COMPANY_NO    = :PR-COMPANY-NO                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO L3-RLSE-CHECK-CD                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_WK_TYPE'  TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'      TO TABLE-ELEMENT-1         
                   MOVE WS-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
                   MOVE 'WORK_TYPE_CD'       TO TABLE-ELEMENT-2         
                   MOVE WS-WORK-TYPE-CD      TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  SEE IF ANY APPLIANCES EXIST AT THE PREMISE.               **          
      ****************************************************************          
                                                                        
       7120-GET-APPLIANCES.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) EQUIPMENT_NO                                      
                 INTO :LA-EQUIPMENT-NO                                  
                 FROM CSS_APPLIANCE WITH(READUNCOMMITTED)                       
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EQUIPMENT_NO                                              
MFA-TR*          INTO :LA-EQUIPMENT-NO                                          
MFA-TR*          FROM CSS_APPLIANCE                                             
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7120'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE LA-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  SEE IF ANY APPLIANCES EXIST FOR THE SERVICE ORDER.        **          
      ****************************************************************          
                                                                        
       7130-GET-SO-APPLIANCES.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) EQUIPMENT_UNQ                                     
                 INTO :VQ-EQUIPMENT-UNQ                                 
                 FROM CSS_SO_APPLIANCE WITH(READUNCOMMITTED)                    
                WHERE SERV_ORDER_NO = :VQ-SERV-ORDER-NO                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EQUIPMENT_UNQ                                             
MFA-TR*          INTO :VQ-EQUIPMENT-UNQ                                         
MFA-TR*          FROM CSS_SO_APPLIANCE                                          
MFA-TR*         WHERE SERV_ORDER_NO = :VQ-SERV-ORDER-NO                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7130                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7130'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CURSOR PROCESSING TO READ CSS_SO_APPLIANCE.               **          
      ****************************************************************          
                                                                        
       7140-OPEN-SO-APP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               OPEN SO_APP_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7140'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_APPLIANCE'      TO TABLE-1                  
               MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1          
               MOVE VQ-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-CLOSE-SO-APP-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE SO_APP_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7150'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_APPLIANCE'      TO TABLE-1                  
               MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1          
               MOVE VQ-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CURSOR PROCESSING TO READ CSS_APPLIANCE.                  **          
      ****************************************************************          
                                                                        
       7160-OPEN-APP-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               OPEN APP_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7160'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_APPLIANCE'         TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE LA-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-CLOSE-APP-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE APP_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7170'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_APPLIANCE'         TO TABLE-1                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE LA-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE RESPONSIBLE AREA FOR THE USERID.  IT WILL BE      **          
      **  PASSED INTO CSR00073 WHEN THE ORDER IS CREATED.           **          
      ****************************************************************          
                                                                        
       7180-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :LINK-ORDER-RECVED-BY                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :LINK-ORDER-RECVED-BY                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7180                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-RESP-AREA-ID                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7180'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_USER_PROFILE'   TO TABLE-1                 
                   MOVE 'USER_ID'            TO TABLE-ELEMENT-1         
                   MOVE LINK-ORDER-RECVED-BY TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE WORK TYPE FOR THE EXISTING ORDER BY UTILITY.      **          
      ****************************************************************          
                                                                        
       7190-GET-WORK-TYPE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) WORK_TYPE_CD                                      
                 INTO :VI-WORK-TYPE-CD                                  
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                 
                  AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_TYPE_CD                                              
MFA-TR*          INTO :VI-WORK-TYPE-CD                                          
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                         
MFA-TR*           AND CODE_UTIL_TYPE = :VI-CODE-UTIL-TYPE                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7190                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO VI-WORK-TYPE-CD                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7190'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_ORDER_INST'  TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VI-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2         
                   MOVE VI-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET EXISTING RELEASE INFORMATION FOR THE PREMISE.         **          
      ****************************************************************          
                                                                        
       7200-GET-RELEASE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RE.REV_DISTRICT_CD,
              RLSE_TYPE,
              RLSE_SUPPLIES                                     
                 INTO :RE-REV-DISTRICT-CD,                              
                      :RE-RLSE-TYPE,                                    
                      :RE-RLSE-SUPPLIES                                 
                 FROM CSS_PREM_RLSE_DATA RP WITH(READUNCOMMITTED),              
                      CSS_PREM_RLSE RE WITH(READUNCOMMITTED)                    
                WHERE PREMISE_NO = :RP-PREMISE-NO                       
                  AND RP.RLSE_NO = RE.RLSE_NO                           
                  AND RLSE_EXP_DATE >= CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RE.REV_DISTRICT_CD,                                       
MFA-TR*               RLSE_TYPE,                                                
MFA-TR*               RLSE_SUPPLIES                                             
MFA-TR*          INTO :RE-REV-DISTRICT-CD,                                      
MFA-TR*               :RE-RLSE-TYPE,                                            
MFA-TR*               :RE-RLSE-SUPPLIES                                         
MFA-TR*          FROM CSS_PREM_RLSE_DATA RP,                                    
MFA-TR*               CSS_PREM_RLSE RE                                          
MFA-TR*         WHERE PREMISE_NO = :RP-PREMISE-NO                               
MFA-TR*           AND RP.RLSE_NO = RE.RLSE_NO                                   
MFA-TR*           AND RLSE_EXP_DATE >= :WS-CURRENT-TIMESTAMP                    
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RE-REV-DISTRICT-CD                    
                                  RE-RLSE-TYPE                          
                                  RE-RLSE-SUPPLIES                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREM_RLSE_DATA' TO TABLE-1                 
                   MOVE 'CSS_PREM_RLSE'      TO TABLE-2                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE RP-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01114****************************************************************          
A01114**  GET LOCAL OFFICE INFORMATION FOR THE PREMISE.             **          
A01114****************************************************************          
A01114                                                                  
A01114 7210-GET-LOCAL-OFFICE.                                           
A01114                                                                  
A01114     EXEC SQL                                                     
A01114         SELECT TOP(1) 'Y'                                               
A01114           INTO :WS-COMBO-DIST-LO-FL                              
A01114           FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                    
A01114          WHERE COMPANY_NO   = :PR-COMPANY-NO                     
A01114            AND LOCAL_OFFICE = :PR-LOCAL-OFFICE                   
A01114            AND SERV_ORDER_WORK_CD IN ('METRO', 'DISTR', 'DISTC') 
A01114                                           
A01114                                                           
A01114                                                      
A01114     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-COMBO-DIST-LO-FL                                      
MFA-TR*          FROM CSS_LOCAL_OFFICE                                          
MFA-TR*         WHERE COMPANY_NO   = :PR-COMPANY-NO                             
MFA-TR*           AND LOCAL_OFFICE = :PR-LOCAL-OFFICE                           
MFA-TR*           AND SERV_ORDER_WORK_CD IN ('METRO', 'DISTR', 'DISTC')         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7210                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01114                                                                  
A01114     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01114                                                                  
A01114     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01114         WHEN SUCCESSFUL-CALL                                     
A01114             MOVE 'Y' TO WS-COMBO-DIST-LO-FL                      
A01114         WHEN NOT-FOUND                                           
A01114             MOVE 'N' TO WS-COMBO-DIST-LO-FL                      
A01114         WHEN OTHER                                               
A01114             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A01114             MOVE '7210'           TO ACTIVE-PARAGRAPH            
A01114             MOVE 'SELECT'         TO ABEND-FUNCTION              
A01114             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A01114                                           ABEND-TABLES           
A01114             MOVE 'CSS_LOCAL_OFFICE'   TO TABLE-1                 
A01114             MOVE 'LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
A01114             MOVE PR-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
A01114             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01114             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01114     END-EVALUATE.                                                
A01114                                                                  
A01114 7210-EXIT.                                                       
A01114     EXIT.                                                        
A01114                                                                  
A01114****************************************************************          
A01114**  GET DESCRIPTION FOR WORK AREA.                            **          
A01114****************************************************************          
A01114                                                                  
A01114 7220-GET-WORK-AREA.                                              
A01114                                                                  
A01114     EXEC SQL                                                     
A01114         SELECT TOP(1) 'Y'                                               
A01114           INTO :WS-GAS-WORK-AREA-FL                              
A01114           FROM CSS_WORK_AREA WITH(READUNCOMMITTED)                       
A01114          WHERE WORK_AREA_ID = :LINK-WORK-AREA                    
A01114            AND WORK_AREA_TX LIKE '%GAS%'                         
A01114                                           
A01114                                                           
A01114                                                      
A01114     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-GAS-WORK-AREA-FL                                      
MFA-TR*          FROM CSS_WORK_AREA                                             
MFA-TR*         WHERE WORK_AREA_ID = :LINK-WORK-AREA                            
MFA-TR*           AND WORK_AREA_TX LIKE '%GAS%'                                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7220                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01114                                                                  
A01114     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01114                                                                  
A01114     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01114         WHEN SUCCESSFUL-CALL                                     
A01114             MOVE 'Y' TO WS-GAS-WORK-AREA-FL                      
A01114         WHEN NOT-FOUND                                           
A01114             MOVE 'N' TO WS-GAS-WORK-AREA-FL                      
A01114         WHEN OTHER                                               
A01114             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A01114             MOVE '7220'           TO ACTIVE-PARAGRAPH            
A01114             MOVE 'SELECT'         TO ABEND-FUNCTION              
A01114             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A01114                                           ABEND-TABLES           
A01114             MOVE 'CSS_WORK_AREA'      TO TABLE-1                 
A01114             MOVE 'WORK_AREA_ID'       TO TABLE-ELEMENT-1         
A01114             MOVE LINK-WORK-AREA       TO HOSTVAR-ELEMENT-1       
A01114             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01114             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01114     END-EVALUATE.                                                
A01114                                                                  
A01114 7220-EXIT.                                                       
A01114     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE STANDARD LABOR CHARGE FOR PSNC.                   **          
      ****************************************************************          
                                                                        
       7300-GET-LABOR-CHARGE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) STD_LABOR_CHRG                                    
                 INTO :SV-STD-LABOR-CHRG                                
                 FROM CSS_SO_SERVICE_CHG WITH(READUNCOMMITTED)                  
                WHERE COMPANY_NO = '26'                                 
                  AND ORDER_TYPE_CD = 'CC001'                           
                  AND WORK_PERIOD_CD = 'X'                              
                  AND ACCOUNT_TYPE_CODE = 'R'                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT STD_LABOR_CHRG                                            
MFA-TR*          INTO :SV-STD-LABOR-CHRG                                        
MFA-TR*          FROM CSS_SO_SERVICE_CHG                                        
MFA-TR*         WHERE COMPANY_NO = '26'                                         
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*           AND WORK_PERIOD_CD = 'X'                                      
MFA-TR*           AND ACCOUNT_TYPE_CODE = 'R'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO SV-STD-LABOR-CHRG                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_SERVICE_CHG' TO TABLE-1                 
                   MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1         
                   MOVE '26'                 TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET THE ZIP CODE TOKEN.                                   **          
      ****************************************************************          
                                                                        
       7400-GET-TOKEN.                                                  
                                                                        
           MOVE LINK-TOWN TO A4-TOWN.                                   
           MOVE LINK-STATE TO A4-STATE.                                 
           MOVE LINK-ZIP-CODE TO A4-ZIP-CODE.                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-2         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  ACCOUNT CANNOT BE DELETED IF ORDERS EXIST                 **          
      ****************************************************************          
                                                                        
       7500-CHECK-ORDERS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :WS-SO-NUMBER-DELETE                              
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                       
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :WS-SO-NUMBER-DELETE                                      
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO = :VO-ACCOUNT-NO                               
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 75001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO WS-DELETE-FLAG                           
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO WS-DELETE-FLAG                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE VO-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           IF WS-DELETE-FLAG = 'Y'                                      
               EXEC SQL                                                 
                   SELECT TOP(1) SERV_ORDER_NO                                 
                     INTO :WS-SO-NUMBER-DELETE                          
                     FROM CSS_SO_DATA WITH(READUNCOMMITTED)                     
                    WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO             
                      AND ORDER_STATE_CD NOT IN ('C', 'Z')              
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SELECT SERV_ORDER_NO                                         
MFA-TR*              INTO :WS-SO-NUMBER-DELETE                                  
MFA-TR*              FROM CSS_SO_DATA                                           
MFA-TR*             WHERE ACCOUNT_NO_PRIOR = :VO-ACCOUNT-NO                     
MFA-TR*               AND ORDER_STATE_CD NOT IN ('C', 'Z')                      
MFA-TR*             FETCH FIRST 1 ROWS ONLY                                     
MFA-TR*             WITH UR                                                     
MFA-TR*         QUERYNO 75002                                                   
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'N' TO WS-DELETE-FLAG                       
                   WHEN NOT-FOUND                                       
                       MOVE 'Y' TO WS-DELETE-FLAG                       
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME TO ABEND-PROGRAM               
                       MOVE '7500'       TO ACTIVE-PARAGRAPH            
                       MOVE 'SELECT2'    TO ABEND-FUNCTION              
                       MOVE SPACES       TO ABEND-SQL-PREDICATES        
                                                     ABEND-TABLES       
                       MOVE 'CSS_SO_DATA' TO TABLE-1                    
                       MOVE 'ACCOUNT_NO_PRIOR' TO TABLE-ELEMENT-1       
                       MOVE VO-ACCOUNT-NO TO HOSTVAR-ELEMENT-1          
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE
           END-IF.                                            
                                                                        
           IF WS-DELETE-FLAG = 'Y'                                      
               EXEC SQL                                                 
                   SELECT TOP(1) VO.SERV_ORDER_NO                              
                     INTO :WS-SO-NUMBER-DELETE                          
                     FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                 
                          CSS_SO_ACCT_XFER VY WITH(READUNCOMMITTED)             
                    WHERE TO_ACCT_NO = :VO-ACCOUNT-NO                   
                      AND ORDER_STATE_CD NOT IN ('C', 'Z')              
                      AND VO.SERV_ORDER_NO = VY.SERV_ORDER_NO           
                                                 
                                                                 
                                                           
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*            SELECT VO.SERV_ORDER_NO                                      
MFA-TR*              INTO :WS-SO-NUMBER-DELETE                                  
MFA-TR*              FROM CSS_SO_DATA VO,                                       
MFA-TR*                   CSS_SO_ACCT_XFER VY                                   
MFA-TR*             WHERE TO_ACCT_NO = :VO-ACCOUNT-NO                           
MFA-TR*               AND ORDER_STATE_CD NOT IN ('C', 'Z')                      
MFA-TR*               AND VO.SERV_ORDER_NO = VY.SERV_ORDER_NO                   
MFA-TR*             FETCH FIRST 1 ROWS ONLY                                     
MFA-TR*             WITH UR                                                     
MFA-TR*             QUERYNO 75003                                               
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                                                                        
               EVALUATE WS-ACTIVE-RETURN-CODE                           
                   WHEN SUCCESSFUL-CALL                                 
                       MOVE 'N' TO WS-DELETE-FLAG                       
                   WHEN NOT-FOUND                                       
                       MOVE 'Y' TO WS-DELETE-FLAG                       
                   WHEN OTHER                                           
                       MOVE PROGRAM-NAME TO ABEND-PROGRAM               
                       MOVE '7500'       TO ACTIVE-PARAGRAPH            
                       MOVE 'SELECT3'    TO ABEND-FUNCTION              
                       MOVE SPACES       TO ABEND-SQL-PREDICATES        
                                                     ABEND-TABLES       
                       MOVE 'CSS_SO_DATA' TO TABLE-1                    
                       MOVE 'CSS_SO_ACCT_XFER' TO TABLE-2               
                       MOVE 'TO_ACCT_NO' TO TABLE-ELEMENT-1             
                       MOVE VO-ACCOUNT-NO TO HOSTVAR-ELEMENT-1          
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
               END-EVALUATE
           END-IF.                                            
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET ACCOUNT INFORMATION                                   **          
      ****************************************************************          
                                                                        
       7600-SELECT-ACCOUNT.                                             
                                                                        
           MOVE VO-ACCOUNT-NO TO AT-ACCOUNT-NO.                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO,
              PREMISE_NO,
              BILL_CYCLE,
              CODE_BILL_FREQ,
              NO_BILL_COPIES,
              CODE_GROUP_ACCT                                   
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-PREMISE-NO,                                   
                      :AT-BILL-CYCLE,                                   
                      :AT-CODE-BILL-FREQ,                               
                      :AT-NO-BILL-COPIES,                               
                      :AT-CODE-GROUP-ACCT                               
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               BILL_CYCLE,                                               
MFA-TR*               CODE_BILL_FREQ,                                           
MFA-TR*               NO_BILL_COPIES,                                           
MFA-TR*               CODE_GROUP_ACCT                                           
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-BILL-CYCLE,                                           
MFA-TR*               :AT-CODE-BILL-FREQ,                                       
MFA-TR*               :AT-NO-BILL-COPIES,                                       
MFA-TR*               :AT-CODE-GROUP-ACCT                                       
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-DELETE-FLAG                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET CURRENT ACCOUNT                                       **          
      ****************************************************************          
                                                                        
       7700-SELECT-CURR-ACCOUNT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AT.CUSTOMER_NO,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              CODE_ACCT_STAT,
              RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1)) + 
           ', ' + RTRIM(TITLE_PREFIX) + ' ' + RTRIM(FIRST_NAME) + 
           ' ' + RTRIM(MIDDLE_NAME),
              FULL_NAME,
              NAME_FORMAT                                       
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-ADDRESS-ID,                                   
                      :AT-ADDRESS-FORMAT,                               
                      :AT-CODE-ACCT-STAT,                               
P00836                :WS-CUST-NAME,                                    
P00836                :DQ-FULL-NAME,                                    
P00836                :DQ-NAME-FORMAT                                   
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
P00836                CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
P00836                CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
P00836            AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                   
P00836            AND CU.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CUSTOMER_NO,                                           
MFA-TR*               ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT,                                           
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(TITLE_PREFIX) ||                                    
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT                                               
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :WS-CUST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT                                           
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*           AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CUSTOMER-NO TO WS-CURR-CUSTOMER-NO-NUM       
                   IF AT-ADDRESS-ID > 0                                 
                       MOVE 'Y' TO WS-BILL-ADDRESS-EXISTS               
                   END-IF                                               
P00836             IF DQ-NAME-FORMAT = 'B'                              
P00836                 MOVE DQ-FULL-NAME TO WS-CUST-NAME                
P00836             END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-CURR-CUSTOMER-NO-NUM               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET SPLIT ORIG                                            **          
      ****************************************************************          
                                                                        
       7800-SELECT-SPLIT-ORIG.                                          
                                                                        
           MOVE 'N' TO WS-SPLIT-ORDER-FL.                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CREATE_SCENARIO_CD                                
                 INTO :SR-CREATE-SCENARIO-CD                            
                 FROM CSS_SO_SPLT_ORIG WITH(READUNCOMMITTED)                    
                WHERE COMPANY_NO = :SR-COMPANY-NO                       
                  AND LOCAL_OFFICE_CD = :SR-LOCAL-OFFICE-CD             
                  AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD       
                  AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD       
                  AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD       
                  AND TOU_RATE_FL IN ('X', 'N')                         
                  AND RELEASE_CD         = :SR-RELEASE-CD               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CREATE_SCENARIO_CD                                        
MFA-TR*          INTO :SR-CREATE-SCENARIO-CD                                    
MFA-TR*          FROM CSS_SO_SPLT_ORIG                                          
MFA-TR*         WHERE COMPANY_NO = :SR-COMPANY-NO                               
MFA-TR*           AND LOCAL_OFFICE_CD = :SR-LOCAL-OFFICE-CD                     
MFA-TR*           AND ORIG_ORDER_TYPE_CD = :SR-ORIG-ORDER-TYPE-CD               
MFA-TR*           AND ORIG_ELE_WKTYPE_CD = :SR-ORIG-ELE-WKTYPE-CD               
MFA-TR*           AND ORIG_GAS_WKTYPE_CD = :SR-ORIG-GAS-WKTYPE-CD               
MFA-TR*           AND TOU_RATE_FL IN ('X', 'N')                                 
MFA-TR*           AND RELEASE_CD         = :SR-RELEASE-CD                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SPLIT-ORDER-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SPLIT-ORDER-FL                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_SPLT_ORIG' TO TABLE-1                   
                   MOVE 'COMPANY_NO'     TO TABLE-ELEMENT-1             
                   MOVE SR-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'LOCAL_OFFICE'   TO TABLE-ELEMENT-2             
                   MOVE SR-LOCAL-OFFICE-CD  TO HOSTVAR-ELEMENT-2        
                   MOVE 'ORDER_TYPE'     TO TABLE-ELEMENT-3             
                   MOVE SR-ORIG-ORDER-TYPE-CD TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET LANDLORD                                              **          
      ****************************************************************          
                                                                        
       7900-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO                                       
                 INTO :SI-CUSTOMER-NO                                   
                 FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
                WHERE PREMISE_NO = :SI-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE PREMISE_NO = :SI-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE SI-CUSTOMER-NO TO WS-LLRD-CUSTOMER-NO-NUM       
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-LLRD-CUSTOMER-NO-NUM               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7900'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE SI-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7950-FORMATTED-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      DY.ZIP_CODE,                                      
                      ZIP_CODE_PLUS_FOUR,                               
                      DY.ZIP_CODE_TOKEN,                                
                      ADDR_USAGE_CD,                                    
                      ADDR_SUFFIX,                                      
                      USPS_DELIV_PT_CD,                                 
                      TOWN,                                             
                      STATE                                             
                 INTO :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-USAGE-CD,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-USPS-DELIV-PT-CD,                             
                      :A4-TOWN,                                         
                      :A4-STATE                                         
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               CARRIER_ROUTE,                                            
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               USPS_DELIV_PT_CD,                                         
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*          INTO :DY-ADDRESS-ID,                                           
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-CARRIER-ROUTE,                                        
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-USPS-DELIV-PT-CD,                                     
MFA-TR*               :A4-TOWN,                                                 
MFA-TR*               :A4-STATE                                                 
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4                                           
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7950                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO LINK-ADD-BILL-ADDR-FL                    
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                              DCLCSS-ZIP-CODE                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7950'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00196 7960-ORDER-PRIORITY.                                             
P00196                                                                  
P00196     EXEC SQL                                                     
P00196         SELECT PRIORITY_CD                                       
P00196           INTO :OY-PRIORITY-CD                                   
P00196           FROM CSS_ORDER_PRIORITY WITH(READUNCOMMITTED)                  
P00196          WHERE PRIORITY_DESC = :OY-PRIORITY-DESC                 
P00196                                                           
P00196                                                     
P00196     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRIORITY_CD                                               
MFA-TR*          INTO :OY-PRIORITY-CD                                           
MFA-TR*          FROM CSS_ORDER_PRIORITY                                        
MFA-TR*         WHERE PRIORITY_DESC = :OY-PRIORITY-DESC                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7960                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00196                                                                  
P00196     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00196                                                                  
P00196     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00196         WHEN SUCCESSFUL-CALL                                     
P00196             CONTINUE                                             
P00196         WHEN NOT-FOUND                                           
P00196             MOVE 7 TO OY-PRIORITY-CD                             
P00196         WHEN OTHER                                               
P00196             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00196             MOVE '7960'           TO ACTIVE-PARAGRAPH            
P00196             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00196             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00196                                           ABEND-TABLES           
P00196             MOVE 'CSS_ORDER_PRIORITY' TO TABLE-1                 
P00196             MOVE OY-PRIORITY-DESC     TO HOSTVAR-ELEMENT-1       
P00196             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00196             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00196     END-EVALUATE.                                                
P00196                                                                  
P00196 7960-EXIT.                                                       
P00196     EXIT.                                                        
                                                                        
P00465 7970-SELECT-CUST.                                                
P00465                                                                  
P00465     EXEC SQL                                                     
P00465         SELECT WELCOME_KIT_CD                                    
P00465           INTO :CU-WELCOME-KIT-CD                                
P00465           FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
P00465          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
P00465                                                           
P00465                                                     
P00465     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WELCOME_KIT_CD                                            
MFA-TR*          INTO :CU-WELCOME-KIT-CD                                        
MFA-TR*          FROM CSS_CUSTOMER                                              
MFA-TR*         WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7970                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00465                                                                  
P00465     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00465                                                                  
P00465     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00465         WHEN SUCCESSFUL-CALL                                     
P00465             CONTINUE                                             
P00465         WHEN NOT-FOUND                                           
P00465             MOVE SPACES TO CU-WELCOME-KIT-CD                     
P00465         WHEN OTHER                                               
P00465             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00465             MOVE '7970'           TO ACTIVE-PARAGRAPH            
P00465             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00465             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00465                                           ABEND-TABLES           
P00465             MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
P00465             MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00465             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00465             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00465     END-EVALUATE.                                                
P00465                                                                  
P00465 7970-EXIT.                                                       
P00465     EXIT.                                                        
                                                                        
P00718 7980-GET-PRINT-LOC.                                              
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT CAD_WORKAREA_FL                                   
P00718           INTO :C4-CAD-WORKAREA-FL                               
P00718           FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
P00718          WHERE WORK_AREA_ID = :LINK-WORK-AREA                    
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CAD_WORKAREA_FL                                           
MFA-TR*          INTO :C4-CAD-WORKAREA-FL                                       
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID = :LINK-WORK-AREA                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7980                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN NOT-FOUND                                           
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7980'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_SO_PRINT_LOC' TO TABLE-1                   
P00718             MOVE LINK-WORK-AREA   TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7980-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718 7985-GET-REGISTER-DTLS.                                          
P00718                                                                  
P00718     EXEC SQL                                                     
P00718        SELECT TOP(1) 'Y'                                                
P00718          INTO :WS-MULTI-REG-MTR                                  
P00718          FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED),                
P00718               CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
P00718         WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO               
P00718           AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                
P00718           AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE            
P00718           AND MN.METER_NO         = RG.METER_NO                  
P00718           AND MN.IC_NO            = RG.IC_NO                     
P00718           AND MN.MTR_REF_NO       = RG.MTR_REF_NO                
P00718                                            
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MULTI-REG-MTR                                          
MFA-TR*         FROM CSS_REGISTER_READ RG,                                      
MFA-TR*              CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO                       
MFA-TR*          AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                        
MFA-TR*          AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE                    
MFA-TR*          AND MN.METER_NO         = RG.METER_NO                          
MFA-TR*          AND MN.IC_NO            = RG.IC_NO                             
MFA-TR*          AND MN.MTR_REF_NO       = RG.MTR_REF_NO                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7985                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN -811                                                
P00718             CONTINUE                                             
P00718         WHEN NOT-FOUND                                           
P00718             MOVE 'N'              TO WS-MULTI-REG-MTR            
P00718             MOVE 0                TO WS-ACTIVE-RETURN-CODE       
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7985'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
P00718             MOVE RG-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00718             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7985-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00836 7990-EMAIL-ADDRESS.                                              
P00836                                                                  
P00836     MOVE SPACES TO NE-EMAIL-ADDRESS-TX.                          
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT TOP(1) EMAIL_ADDRESS_TX                                  
P00836           INTO :NE-EMAIL-ADDRESS-TX                              
P00836           FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
P00836          WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
P00836            AND EMAIL_TYPE_CD = 'P1'                              
P00836                                           
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EMAIL_ADDRESS_TX                                          
MFA-TR*          INTO :NE-EMAIL-ADDRESS-TX                                      
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD = 'P1'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7990                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN NOT-FOUND                                           
P00836             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00836         WHEN OTHER                                               
P00836             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00836             MOVE '7990'           TO ACTIVE-PARAGRAPH            
P00836             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00836             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00836                                           ABEND-TABLES           
P00836             MOVE 'CSS_CUST_EMAIL'   TO TABLE-1                   
P00836             MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
P00836             MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00836             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00836             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7990-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  INSERT A DUCT FURNACE INTO CSS_SO_APPLIANCE.              **          
      ****************************************************************          
                                                                        
       8000-INSERT-SO-APPLIANCE.                                        
                                                                        
           MOVE -1 TO WS-NULL-INSTALL-DT.                               
           MOVE SPACES TO VQ-INSTALL-DT.                                
           MOVE EQUIPMENT-NO-1297 TO VQ-EQUIPMENT-UNQ.                  
           EXEC SQL                                                     
               INSERT INTO CSS_SO_APPLIANCE                             
                   (SERV_ORDER_NO,                                      
                    APPLIANCE_CD,                                       
                    APPLIANCE_SEQ_NO,                                   
                    EQUIP_OWNER,                                        
                    CODE_UTIL_TYPE,                                     
                    LEAK_IND,                                           
                    LIGHT_IND,                                          
                    REPAIR_IND,                                         
                    CUTOFF_IND,                                         
                    CAUTION_TAG_IND,                                    
                    IMPROPER_REASON,                                    
                    EQUIPMENT_UNQ,                                      
                    INSTALL_DT,                                         
                    REPLACE_APP_FL,                                     
                    PRD_SRV_TYP_DESC,                                   
                    INSTALL_IND)                                        
               VALUES                                                   
                   ( :VQ-SERV-ORDER-NO,                                 
                     'DF',                                              
                     1,                                                 
                     ' ',                                               
                     'G',                                               
                     'N',                                               
                     'Y',                                               
                     'N',                                               
                     'N',                                               
                     'N',                                               
                     ' ',                                               
                     :VQ-EQUIPMENT-UNQ,                                 
                     CIS.CHAR2TIMESTAMP(:VQ-INSTALL-DT 
                                        :WS-NULL-INSTALL-DT),                 
                     'N',                                               
                     'DUCT FURNACE',                                    
                     'N')                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_APPLIANCE                                     
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             APPLIANCE_CD,                                               
MFA-TR*             APPLIANCE_SEQ_NO,                                           
MFA-TR*             EQUIP_OWNER,                                                
MFA-TR*             CODE_UTIL_TYPE,                                             
MFA-TR*             LEAK_IND,                                                   
MFA-TR*             LIGHT_IND,                                                  
MFA-TR*             REPAIR_IND,                                                 
MFA-TR*             CUTOFF_IND,                                                 
MFA-TR*             CAUTION_TAG_IND,                                            
MFA-TR*             IMPROPER_REASON,                                            
MFA-TR*             EQUIPMENT_UNQ,                                              
MFA-TR*             INSTALL_DT,                                                 
MFA-TR*             REPLACE_APP_FL,                                             
MFA-TR*             PRD_SRV_TYP_DESC,                                           
MFA-TR*             INSTALL_IND)                                                
MFA-TR*        VALUES                                                           
MFA-TR*            ( :VQ-SERV-ORDER-NO,                                         
MFA-TR*              'DF',                                                      
MFA-TR*              1,                                                         
MFA-TR*              ' ',                                                       
MFA-TR*              'G',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'Y',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              'N',                                                       
MFA-TR*              ' ',                                                       
MFA-TR*              :VQ-EQUIPMENT-UNQ,                                         
MFA-TR*              :VQ-INSTALL-DT:WS-NULL-INSTALL-DT,                         
MFA-TR*              'N',                                                       
MFA-TR*              'DUCT FURNACE',                                            
MFA-TR*              'N')                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   MOVE 'EQUIPMENT_NO'       TO TABLE-ELEMENT-2         
                   MOVE LA-EQUIPMENT-NO      TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  INSERT A LIGHTING REQUIREMENT.                            **          
      ****************************************************************          
                                                                        
       8100-INSERT-LIGHT-RQMT.                                          
                                                                        
           MOVE NEW-SERV-ORDER-NO-0073 TO EG-SERV-ORDER-NO.             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REQUIREMENT                           
                   (SERV_ORDER_NO,                                      
                    REQUIREMENT_CD,                                     
                    RESOURCE_CD,                                        
                    REQMNT_STAGE_CD,                                    
                    SERV_ORDER_STATUS)                                  
               VALUES                                                   
                   ( :EG-SERV-ORDER-NO,                                 
                     '2',                                               
                     '0',                                               
                     'R',                                               
                     '40')                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REQUIREMENT' TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EG-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  INSERT REMARKS.                                           **          
      ****************************************************************          
                                                                        
       8200-INSERT-REMARKS.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_REMARKS                               
                   (SERV_ORDER_NO,                                      
                    REMARK_TYPE_CD,                                     
                    REMARK_DATETIME,                                    
                    CHANGED_BY_USER_ID,                                 
                    REMARK_TX)                                          
               VALUES                                                   
                   ( :EF-SERV-ORDER-NO,                                 
                     :EF-REMARK-TYPE-CD,                                
                     CIS.CURRENT$TIMESTAMP(),                                 
                     :EF-CHANGED-BY-USER-ID,                            
                     :EF-REMARK-TX)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_REMARKS                                       
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             REMARK_TYPE_CD,                                             
MFA-TR*             REMARK_DATETIME,                                            
MFA-TR*             CHANGED_BY_USER_ID,                                         
MFA-TR*             REMARK_TX)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*            ( :EF-SERV-ORDER-NO,                                         
MFA-TR*              :EF-REMARK-TYPE-CD,                                        
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              :EF-CHANGED-BY-USER-ID,                                    
MFA-TR*              :EF-REMARK-TX)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_REMARKS'     TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE EF-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE THE PREMISE RECORD.                                **          
      ****************************************************************          
                                                                        
       8300-UPDATE-PREMISE.                                             
                                                                        
           MOVE LINK-NEW-SCHEDULED-DT TO PR-PEND-OFF-ORD-DT.            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET SERV_ORDER_PEND = 'Y',                            
                      PEND_OFF_ORD_DT = IIF(TRY_CONVERT(DATE, 
                                                    :PR-PEND-OFF-ORD-DT
              ) IS NULL OR (PATINDEX('%.%', :PR-PEND-OFF-ORD-DT
              ) <> 0) OR (LEN(:PR-PEND-OFF-ORD-DT
              ) <> 10), CIS.CHAR2DATE(:PR-PEND-OFF-ORD-DT
              ), CONVERT(DATE, :PR-PEND-OFF-ORD-DT) )             
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET SERV_ORDER_PEND = 'Y',                                    
MFA-TR*               PEND_OFF_ORD_DT = :PR-PEND-OFF-ORD-DT                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*        QUERYNO 8300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'        TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  ADD AN APPOINTMENT.                                       **          
      ****************************************************************          
                                                                        
       8400-ADD-APPOINTMENT.                                            
                                                                        
           MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
           MOVE LINK-START-TS TO VO-BEGIN-APPT-DT.                      
           MOVE LINK-STOP-TS TO VO-END-APPT-DT.                         
           MOVE LINK-ARRANGEMENT-FL TO VO-APPT-AM-PM-CD.                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET BEGIN_APPT_DT = CIS.CHAR2TIMESTAMP(
                                                      :VO-BEGIN-APPT-DT
              ),                
                      END_APPT_DT   = CIS.CHAR2TIMESTAMP(:VO-END-APPT-DT
              ),                  
                      APPT_AM_PM_CD = :VO-APPT-AM-PM-CD                 
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET BEGIN_APPT_DT = :VO-BEGIN-APPT-DT,                        
MFA-TR*               END_APPT_DT   = :VO-END-APPT-DT,                          
MFA-TR*               APPT_AM_PM_CD = :VO-APPT-AM-PM-CD                         
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*        QUERYNO 8400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04670****************************************************************          
A04670**  UPDATE SOURCE SYSTEM.                                     **          
A04670****************************************************************          
A04670                                                                  
A04670 8450-UPDATE-SOURCE-SYSTEM.                                       
A04670                                                                  
A04670     MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
A04670                                                                  
A04670     EXEC SQL                                                     
A04670         UPDATE CSS_SO_DATA                                       
A04670            SET SOURCE_SYSTEM_CD = 'WEB',                         
P00836                MTR_ACCESSIBLE_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ),             
P00836                MTR_ACCESSIBLE_CD = 'Y',                          
P00836                MTR_ACCESSIBLE_RSN = 'Y'                          
A04670          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A04670                                                      
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET SOURCE_SYSTEM_CD = 'WEB',                                 
MFA-TR*               MTR_ACCESSIBLE_DT = :WS-CURRENT-DATE,                     
MFA-TR*               MTR_ACCESSIBLE_CD = 'Y',                                  
MFA-TR*               MTR_ACCESSIBLE_RSN = 'Y'                                  
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*        QUERYNO 8450                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04670                                                                  
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             CONTINUE                                             
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A04670             MOVE '8450'           TO ACTIVE-PARAGRAPH            
A04670             MOVE 'UPDATE'         TO ABEND-FUNCTION              
A04670             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A04670                                           ABEND-TABLES           
A04670             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
A04670             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A04670             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A04670             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A04670             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A04670     END-EVALUATE.                                                
A04670                                                                  
A04670 8450-EXIT.                                                       
A04670     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE PREMISE SPECIAL INSTRUCTIONS.                      **          
      ****************************************************************          
                                                                        
       8500-UPDATE-INSTRUCTIONS.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PREMISE                                       
                  SET SPCL_INSTRUCTIONS = :PR-SPCL-INSTRUCTIONS         
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREMISE                                               
MFA-TR*           SET SPCL_INSTRUCTIONS = :PR-SPCL-INSTRUCTIONS                 
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*        QUERYNO 8500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'UPDATE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_PREMISE'        TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  UPDATE AN AUDIT ROW.                                      **          
      ****************************************************************          
                                                                        
       8700-INSERT-AUDIT-ROW.                                           
                                                                        
           MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
           MOVE LINK-ORDER-RECVED-BY TO VW-USER-ID-UPDT-BY.             
           MOVE ASSIGNED-DATETIME-0073 TO VO-ASSIGNED-DATETIME          
                                          VO-WANTED-BY-DATETIME.        
           MOVE ORDER-TYPE-CD-0073 TO VO-ORDER-TYPE-CD.                 
           MOVE ORDER-STATE-CD-0073 TO VO-ORDER-STATE-CD.               
           MOVE '10' TO VO-SERV-ORDER-STATUS.                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                   (SERV_ORDER_NO,                                      
                    USER_ID_UPDT_BY,                                    
                    UPDATE_DATETIME,                                    
                    PANEL_NO,                                           
                    ASSIGNED_DATETIME,                                  
                    ORDER_TYPE_CD,                                      
                    SERV_ORDER_STATUS,                                  
                    ORDER_STATE_CD,                                     
                    WANTED_BY_DATETIME)                                 
               VALUES                                                   
                   (:VO-SERV-ORDER-NO,                                  
                    :VW-USER-ID-UPDT-BY,                                
                    CIS.CURRENT$TIMESTAMP(),                                  
                    :VW-PANEL-NO,                                       
                    CIS.CHAR2TIMESTAMP(:VO-ASSIGNED-DATETIME),                  
                    :VO-ORDER-TYPE-CD,                                  
                    :VO-SERV-ORDER-STATUS,                              
                    :VO-ORDER-STATE-CD,                                 
                    CIS.CHAR2TIMESTAMP(:VO-WANTED-BY-DATETIME))                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*            (SERV_ORDER_NO,                                              
MFA-TR*             USER_ID_UPDT_BY,                                            
MFA-TR*             UPDATE_DATETIME,                                            
MFA-TR*             PANEL_NO,                                                   
MFA-TR*             ASSIGNED_DATETIME,                                          
MFA-TR*             ORDER_TYPE_CD,                                              
MFA-TR*             SERV_ORDER_STATUS,                                          
MFA-TR*             ORDER_STATE_CD,                                             
MFA-TR*             WANTED_BY_DATETIME)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (:VO-SERV-ORDER-NO,                                          
MFA-TR*             :VW-USER-ID-UPDT-BY,                                        
MFA-TR*             CURRENT TIMESTAMP,                                          
MFA-TR*             :VW-PANEL-NO,                                               
MFA-TR*             :VO-ASSIGNED-DATETIME,                                      
MFA-TR*             :VO-ORDER-TYPE-CD,                                          
MFA-TR*             :VO-SERV-ORDER-STATUS,                                      
MFA-TR*             :VO-ORDER-STATE-CD,                                         
MFA-TR*             :VO-WANTED-BY-DATETIME)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '8700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'INSERT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_UPDATE'      TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01648****************************************************************          
A01648**  UPDATE CODES_DATA_PRESENT FOR FB ADDRESSES                **          
A01648****************************************************************          
A01648                                                                  
A01648 8800-UPDATE-CDP.                                                 
A01648                                                                  
A01648     MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
A01648                                                                  
A01648     EXEC SQL                                                     
A01648         UPDATE CSS_SO_DATA                                       
A01648            SET CODES_DATA_PRESENT =                              
A01648            (CIS.SUBSTR3(CODES_DATA_PRESENT,1,5) + 'A' + 
           CIS.SUBSTR3(CODES_DATA_PRESENT,7,29))                     
A01648          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A01648                                                      
A01648     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT =                                      
MFA-TR*           (SUBSTR(CODES_DATA_PRESENT,1,5) || 'A' ||                     
MFA-TR*            SUBSTR(CODES_DATA_PRESENT,7,29))                             
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*        QUERYNO 8800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01648                                                                  
A01648     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01648                                                                  
A01648     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01648         WHEN SUCCESSFUL-CALL                                     
A01648             CONTINUE                                             
A01648         WHEN OTHER                                               
A01648             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A01648             MOVE '8800'           TO ACTIVE-PARAGRAPH            
A01648             MOVE 'UPDATE'         TO ABEND-FUNCTION              
A01648             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A01648                                           ABEND-TABLES           
A01648             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
A01648             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A01648             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A01648             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01648             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01648     END-EVALUATE.                                                
A01648                                                                  
A01648 8800-EXIT.                                                       
A01648     EXIT.                                                        
                                                                        
A01114****************************************************************          
A01114**  UPDATE CODES_DATA_PRESENT FOR GAS WITH NO SEASONAL APP    **          
A01114****************************************************************          
A01114                                                                  
A01114 8810-UPDATE-APPL-CDP.                                            
A01114                                                                  
A01114     MOVE NEW-SERV-ORDER-NO-0073 TO VO-SERV-ORDER-NO.             
A01114                                                                  
A01114     EXEC SQL                                                     
A01114         UPDATE CSS_SO_DATA                                       
A01114            SET CODES_DATA_PRESENT =                              
A01114            (CIS.SUBSTR3(CODES_DATA_PRESENT,1,11) + 'A' + 
           CIS.SUBSTR3(CODES_DATA_PRESENT,7,23))                     
A01114          WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
A01114                                                      
A01114     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SO_DATA                                               
MFA-TR*           SET CODES_DATA_PRESENT =                                      
MFA-TR*           (SUBSTR(CODES_DATA_PRESENT,1,11) || 'A' ||                    
MFA-TR*            SUBSTR(CODES_DATA_PRESENT,7,23))                             
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*        QUERYNO 8810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01114                                                                  
A01114     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01114                                                                  
A01114     EVALUATE WS-ACTIVE-RETURN-CODE                               
A01114         WHEN SUCCESSFUL-CALL                                     
A01114             CONTINUE                                             
A01114         WHEN OTHER                                               
A01114             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A01114             MOVE '8810'           TO ACTIVE-PARAGRAPH            
A01114             MOVE 'UPDATE'         TO ABEND-FUNCTION              
A01114             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A01114                                           ABEND-TABLES           
A01114             MOVE 'CSS_SO_DATA'        TO TABLE-1                 
A01114             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
A01114             MOVE VO-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
A01114             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A01114             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A01114     END-EVALUATE.                                                
A01114                                                                  
A01114 8810-EXIT.                                                       
A01114     EXIT.                                                        
                                                                        
P00465****************************************************************          
P00465**  UPDATE CSS_CUSTOMER WITH WELCOME KIT CODE                 **          
P00465****************************************************************          
P00465                                                                  
P00465 8820-UPDATE-CUST.                                                
P00465                                                                  
P00465     EXEC SQL                                                     
P00465         UPDATE CSS_CUSTOMER                                      
P00465            SET WELCOME_KIT_CD = :LINK-WELCOME-KIT-CD             
P00465          WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                  
P00465                                                      
P00465     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUSTOMER                                              
MFA-TR*           SET WELCOME_KIT_CD = :LINK-WELCOME-KIT-CD                     
MFA-TR*         WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                          
MFA-TR*        QUERYNO 8820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00465                                                                  
P00465     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00465                                                                  
P00465     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00465         WHEN SUCCESSFUL-CALL                                     
P00465             CONTINUE                                             
P00465         WHEN OTHER                                               
P00465             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00465             MOVE '8820'           TO ACTIVE-PARAGRAPH            
P00465             MOVE 'UPDATE'         TO ABEND-FUNCTION              
P00465             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00465                                           ABEND-TABLES           
P00465             MOVE 'CSS_CUSTOMER'       TO TABLE-1                 
P00465             MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
P00465             MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
P00465             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00465             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00465     END-EVALUATE.                                                
P00465                                                                  
P00465     MOVE ZEROES TO MH-PREMISE-NO                                 
P00465                    MH-ACCOUNT-NO.                                
P00465     MOVE CU-CUSTOMER-NO TO MH-CUSTOMER-NO.                       
P00465     EXEC SQL                                                     
P00465          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
P00465     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00465     MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO            
P00465                                  MI-TRANS-HIST-SEQ-NO.           
P00465     MOVE 1 TO MI-TRAN-APPL-NO.                                   
P00465     MOVE 'WELCOME KIT CD'  TO MI-COLUMN-DESC.                    
P00465     IF CU-WELCOME-KIT-CD = ' '                                   
P00465         MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT                 
P00465     ELSE                                                         
P00465         EVALUATE CU-WELCOME-KIT-CD                               
P00465            WHEN 'E'                                              
P00465                MOVE 'EMAIL' TO MI-PRV-COLUMN-VALUE-TEXT          
P00465            WHEN 'P'                                              
P00465                MOVE 'PAPER' TO MI-PRV-COLUMN-VALUE-TEXT          
P00465         END-EVALUATE
           END-IF.                                            
P00465     MOVE +5 TO MI-PRV-COLUMN-VALUE-LEN.                          
P00465     MOVE +5 TO MI-CHG-COLUMN-VALUE-LEN.                          
P00465     EVALUATE LINK-WELCOME-KIT-CD                                 
P00465        WHEN 'E'                                                  
P00465            MOVE 'EMAIL' TO MI-CHG-COLUMN-VALUE-TEXT              
P00465        WHEN 'P'                                                  
P00465            MOVE 'PAPER' TO MI-CHG-COLUMN-VALUE-TEXT              
P00465     END-EVALUATE.                                                
P00465     MOVE SPACES TO MI-TABLE-ID.                                  
P00465     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
P00465                                                                  
P00465 8820-EXIT.                                                       
P00465     EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
