       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04104.                                          
COB303 DATE-WRITTEN.      APRIL 9, 2008.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ACCOUNT INFORMATION FOR THE WEB        *        
      *  STOP PROCESS.                                                 *        
      *  STATUS CODE VALUES ARE:                                       *        
      *       025         CC/REASON NOT FORCED                         *        
      *       050         ACCOUNT NOT ACTIVE                           *        
      *       075         FINAL BILL ADDRESS EXISTS                    *        
A05317*       200         MULTIPLE REGISTER METERS EXIST               *        
      *       400         INVALID METER STATUS                         *        
A02193*       500         INVALID METER STATUS REASON                  *        
      *       600         DNPFB EXISTS                                 *        
      *       700         METERED ORDER EXISTS                         *        
      *       800         ACCOUNT NOT RESIDENTIAL                      *        
      *       900         MULTIPLE METERS WITHIN UTILITY TYPE          *        
      *       925         LIGHTING ONLY ACCOUNT                        *        
      *       960         SCHEDULED DATE PRIOR TO TODAY                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/09/08    FMB      NEW PROGRAM.                                      
A02193*  03/01/10    FMB      SET RETURN STATUS CODE WHEN METER STATUS          
A02193*                       REASON IS 1 (FIRE).                               
A05317*  06/10/15    FMB      SET RETURN STATUS CODE FOR MULTIPLE               
A05317*                       REGISTER METERS IF REVERT                         
P00836*  04/08/16    FMB      TREAT ORDERS ON HOLD FOR AROP AS IF THEY          
P00836*                       WERE ACTIVE.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04104'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04104 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOFIN                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
A05317     EXEC SQL                                                             
A05317        INCLUDE TBRGREAD                                                  
A05317     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04104_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-SERV-ORDER-NO        PIC X(13) VALUE SPACES.          
           05  RS-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.          
           05  RS-ASSIGNED-TS          PIC X(26) VALUE SPACES.          
           05  RS-CODE-RENTAL-PROP     PIC X(01) VALUE SPACES.          
           05  RS-LL-CUSTOMER-NO       PIC X(10) VALUE SPACES.          
           05  RS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  RS-GAS-ONLY-FL          PIC X(01) VALUE SPACES.          
           05  RS-BLOCK-GAS-FL         PIC X(01) VALUE SPACES.          
           05  RS-ORDER-STATE-CD       PIC X(01) VALUE SPACES.          
           05  RS-ACCOUNT-TYPE-CODE    PIC X(01) VALUE SPACES.          
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-SERV-ORDER-NO        PIC X(13) VALUE SPACES.           
           05  S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.           
           05  S-ASSIGNED-TS          PIC X(26) VALUE SPACES.           
           05  S-CODE-RENTAL-PROP     PIC X(01) VALUE SPACES.           
           05  S-LL-CUSTOMER-NO       PIC X(10) VALUE SPACES.           
           05  S-COMPANY-NO           PIC X(02) VALUE SPACES.           
           05  S-GAS-ONLY-FL          PIC X(01) VALUE SPACES.           
           05  S-BLOCK-GAS-FL         PIC X(01) VALUE SPACES.           
           05  S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.           
           05  S-ACCOUNT-TYPE-CODE    PIC X(01) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-NUM        PIC 9(13).                      
           05  WS-ACCOUNT-NO-CHAR       REDEFINES WS-ACCOUNT-NO-NUM     
                                        PIC X(13).                      
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-NUM    
                                        PIC X(10).                      
           05  WS-SERV-ORDER-NO-NUM     PIC 9(13).                      
           05  WS-SERV-ORDER-NO-CHAR    REDEFINES WS-SERV-ORDER-NO-NUM  
                                        PIC X(13).                      
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04104'.     
           05  WS-COUNT-GAS-METERS      PIC S9(4) COMP VALUE 0.         
           05  WS-COUNT-ELEC-METERS     PIC S9(4) COMP VALUE 0.         
           05  WS-ELEC-FL               PIC X(01) VALUE SPACES.         
           05  WS-GAS-FL                PIC X(01) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO.                              
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE   AS RETURN_CODE,                  
                      :S-STATUS-CODE   AS STATUS_CODE,                  
                      :S-SERV-ORDER-NO AS SERV_ORDER_NO,                
                      :S-ORDER-TYPE-CD AS ORDER_TYPE_CD,                
                      :S-ASSIGNED-TS   AS ASSIGNED_TS,                  
                      :S-CODE-RENTAL-PROP  AS CODE_RENTAL_PROP,         
                      :S-LL-CUSTOMER-NO    AS LL_CUSTOMER_NO,           
                      :S-COMPANY-NO        AS COMPANY_NO,               
                      :S-GAS-ONLY-FL       AS GAS_ONLY_FL,              
                      :S-BLOCK-GAS-FL      AS BLOCK_GAS_FL,             
                      :S-ORDER-STATE-CD    AS ORDER_STATE_CD,           
                      :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE         
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE   AS RETURN_CODE,                          
MFA-TR*               :S-STATUS-CODE   AS STATUS_CODE,                          
MFA-TR*               :S-SERV-ORDER-NO AS SERV_ORDER_NO,                        
MFA-TR*               :S-ORDER-TYPE-CD AS ORDER_TYPE_CD,                        
MFA-TR*               :S-ASSIGNED-TS   AS ASSIGNED_TS,                          
MFA-TR*               :S-CODE-RENTAL-PROP  AS CODE_RENTAL_PROP,                 
MFA-TR*               :S-LL-CUSTOMER-NO    AS LL_CUSTOMER_NO,                   
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO,                       
MFA-TR*               :S-GAS-ONLY-FL       AS GAS_ONLY_FL,                      
MFA-TR*               :S-BLOCK-GAS-FL      AS BLOCK_GAS_FL,                     
MFA-TR*               :S-ORDER-STATE-CD    AS ORDER_STATE_CD,                   
MFA-TR*               :S-ACCOUNT-TYPE-CODE AS ACCOUNT_TYPE_CODE                 
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET   :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 0 TO RS-STATUS-CODE.                                    
           PERFORM 7000-GET-ACCOUNT THRU 7000-EXIT.                     
           IF RS-STATUS-CODE = 0 AND                                    
              AT-ACCOUNT-TYPE-CODE NOT = 'R'                            
                 MOVE +800 TO RS-STATUS-CODE
           END-IF.                           
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7200-DNPFB-CHECK THRU 7200-EXIT
           END-IF.                 
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7300-METERED-ORDER-CHECK THRU 7300-EXIT
           END-IF.         
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7400-METER-STATUS-CHECK THRU 7400-EXIT
           END-IF.          
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7500-MULTIPLE-METER-CHECK THRU 7500-EXIT
           END-IF.        
           IF RS-STATUS-CODE = 0 AND                                    
              WS-ELEC-FL = 'N' AND                                      
              WS-GAS-FL = 'N'                                           
                  MOVE +925 TO RS-STATUS-CODE
           END-IF.                          
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7600-CALLED-IN-OFF-CHECK THRU 7600-EXIT
           END-IF.         
A02193     IF RS-STATUS-CODE = 0                                        
A02193         PERFORM 7130-METER-REASON-CHECK THRU 7130-EXIT
           END-IF.          
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7410-GAS-ONLY-CHECK THRU 7410-EXIT               
               PERFORM 7420-BLOCK-GAS-CHECK THRU 7420-EXIT              
               PERFORM 7700-GET-ORDER THRU 7700-EXIT
           END-IF.                   
           IF RS-STATUS-CODE = 0                                        
               PERFORM 7800-CODE-RENTAL-PROP THRU 7800-EXIT             
               IF RS-CODE-RENTAL-PROP = 'D' OR 'S'                      
                   PERFORM 7900-LL-CUSTOMER THRU 7900-EXIT
               END-IF
           END-IF.             
A05317     IF RS-STATUS-CODE = 0 AND                                    
A05317        RS-CODE-RENTAL-PROP = 'D' OR 'S'                          
A05317            PERFORM 7100-MULTI-REG-CHECK THRU 7100-EXIT
           END-IF.          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD 1                           TO  CTR-ROWS.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
             MOVE RS-RETURN-CODE      TO S-RETURN-CODE.                 
             MOVE RS-STATUS-CODE      TO S-STATUS-CODE.                 
             MOVE RS-SERV-ORDER-NO    TO S-SERV-ORDER-NO.               
             MOVE RS-ORDER-TYPE-CD    TO S-ORDER-TYPE-CD.               
             MOVE RS-ASSIGNED-TS      TO S-ASSIGNED-TS.                 
             MOVE RS-CODE-RENTAL-PROP TO S-CODE-RENTAL-PROP.            
             MOVE RS-LL-CUSTOMER-NO   TO S-LL-CUSTOMER-NO.              
             MOVE RS-GAS-ONLY-FL      TO S-GAS-ONLY-FL.                 
             MOVE RS-BLOCK-GAS-FL     TO S-BLOCK-GAS-FL.                
             MOVE RS-ORDER-STATE-CD   TO S-ORDER-STATE-CD.              
             MOVE RS-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.          
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
       7000-GET-ACCOUNT.                                                
                                                                        
           EXEC SQL                                                     
               SELECT CODE_ACCT_STAT,                                   
                      PREMISE_NO,                                       
                      ACCOUNT_TYPE_CODE                                 
                 INTO :AT-CODE-ACCT-STAT,                               
                      :AT-PREMISE-NO,                                   
                      :AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_STAT,                                           
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ACCOUNT_TYPE_CODE                                         
MFA-TR*          INTO :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AT-ACCOUNT-TYPE-CODE TO RS-ACCOUNT-TYPE-CODE        
               IF AT-CODE-ACCT-STAT NOT = 'A'                           
                   MOVE +050 TO RS-STATUS-CODE                          
               END-IF                                                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7100-MULTI-REG-CHECK.                                            
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         SELECT TOP(1) ACCOUNT_NO                                        
A05317           INTO :RG-ACCOUNT-NO                                    
A05317           FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
A05317          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A05317                                           
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :RG-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05317         WHEN SUCCESSFUL-CALL                                     
A05317             MOVE +200 TO RS-STATUS-CODE                          
A05317         WHEN NOT-FOUND                                           
A05317             MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
A05317         WHEN OTHER                                               
A05317             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A05317             MOVE '7100'           TO ACTIVE-PARAGRAPH            
A05317             MOVE 'SELECT'         TO ABEND-FUNCTION              
A05317             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A05317                                      ABEND-TABLES                
A05317             MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
A05317             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
A05317             MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
A05317             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05317             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05317     END-EVALUATE.                                                
A05317                                                                  
A05317 7100-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
A02193 7130-METER-REASON-CHECK.                                         
A02193                                                                  
A02193     EXEC SQL                                                     
A02193         SELECT TOP(1) ACCOUNT_NO                                        
A02193           INTO :MN-ACCOUNT-NO                                    
A02193           FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
A02193          WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
A02193            AND CODE_STATUS_REAS IN ('1')                         
A02193                                           
A02193                                                           
A02193                                                      
A02193     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_STATUS_REAS IN ('1')                                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7130                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02193                                                                  
A02193     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02193                                                                  
A02193     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02193         WHEN SUCCESSFUL-CALL                                     
A02193             MOVE +500 TO RS-STATUS-CODE                          
A02193         WHEN NOT-FOUND                                           
A02193             MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
A02193         WHEN OTHER                                               
A02193             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A02193             MOVE '7130'           TO ACTIVE-PARAGRAPH            
A02193             MOVE 'SELECT'         TO ABEND-FUNCTION              
A02193             MOVE SPACES           TO ABEND-SQL-PREDICATES        
A02193                                      ABEND-TABLES                
A02193             MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
A02193             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
A02193             MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
A02193             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A02193             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A02193     END-EVALUATE.                                                
A02193                                                                  
A02193 7130-EXIT.                                                       
A02193     EXIT.                                                        
                                                                        
       7200-DNPFB-CHECK.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND ORDER_TYPE_CD = 'DNPFB'                           
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND ORDER_TYPE_CD = 'DNPFB'                                   
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +600 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-METERED-ORDER-CHECK.                                        
                                                                        
      * CHECK FOR SET, DNP, MARKETING, METER CHANGE ORDERS                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ORDER_TYPE FO WITH(READUNCOMMITTED)                   
                WHERE PREMISE_NO   = :AT-PREMISE-NO                     
                  AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = FO.COMPANY_NO                     
                  AND FO.ORDER_GROUP_CD IN ('B', 'C', 'E', 'G')         
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE FO                                         
MFA-TR*         WHERE PREMISE_NO   = :AT-PREMISE-NO                             
MFA-TR*           AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = FO.COMPANY_NO                             
MFA-TR*           AND FO.ORDER_GROUP_CD IN ('B', 'C', 'E', 'G')                 
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 73001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
      * CHECK FOR METER-RELATED ORDERS NOT CC001 OR OFF01                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_ORDER_TYPE FO WITH(READUNCOMMITTED)                   
                WHERE PREMISE_NO   = :AT-PREMISE-NO                     
                  AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD               
                  AND VO.COMPANY_NO = FO.COMPANY_NO                     
                  AND FO.ORDER_GROUP_CD = 'D'                           
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND VO.ORDER_TYPE_CD NOT IN ('CC001')                 
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_ORDER_TYPE FO                                         
MFA-TR*         WHERE PREMISE_NO   = :AT-PREMISE-NO                             
MFA-TR*           AND VO.ORDER_TYPE_CD = FO.ORDER_TYPE_CD                       
MFA-TR*           AND VO.COMPANY_NO = FO.COMPANY_NO                             
MFA-TR*           AND FO.ORDER_GROUP_CD = 'D'                                   
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND VO.ORDER_TYPE_CD NOT IN ('CC001')                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 73002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
      * CHECK FOR NEW SERVICE, ENDV, RETIRE SERVICE                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE PREMISE_NO   = :AT-PREMISE-NO                     
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD IN ('FW009', 'FW021', 'FW010',      
                                        'FW023')                        
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE PREMISE_NO   = :AT-PREMISE-NO                             
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD IN ('FW009', 'FW021', 'FW010',              
MFA-TR*                                 'FW023')                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 73003                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +700 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT3'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-METER-STATUS-CHECK.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_METER_STATUS NOT IN ('A','J', 'K')           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_METER_STATUS NOT IN ('A','J', 'K')                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +400 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-GAS-ONLY-CHECK.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_UTIL_TYPE = 'E'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7410                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO RS-GAS-ONLY-FL                           
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE 'Y' TO RS-GAS-ONLY-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7410'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7420-BLOCK-GAS-CHECK.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :MN-ACCOUNT-NO                                    
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND CODE_METER_STATUS = 'A'                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :MN-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND CODE_METER_STATUS = 'A'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7420                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO RS-BLOCK-GAS-FL                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE 'N' TO RS-BLOCK-GAS-FL                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7420'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-MULTIPLE-METER-CHECK.                                       
                                                                        
           MOVE 'N' TO WS-ELEC-FL                                       
                       WS-GAS-FL.                                       
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-ELEC-METERS                             
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_UTIL_TYPE = 'E'                              
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-ELEC-METERS                                     
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 75001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-COUNT-ELEC-METERS > 1                          
                       MOVE +900 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF WS-COUNT-ELEC-METERS > 0                          
                       MOVE 'Y' TO WS-ELEC-FL                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT-ELEC-METERS                       
                             WS-ACTIVE-RETURN-CODE                      
                   MOVE 'N' TO WS-ELEC-FL                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-COUNT-GAS-METERS                              
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
                  AND CODE_UTIL_TYPE = 'G'                              
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-COUNT-GAS-METERS                                      
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 75002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-COUNT-GAS-METERS > 1                           
                       MOVE +900 TO RS-STATUS-CODE                      
                   END-IF                                               
                   IF WS-COUNT-GAS-METERS > 0                           
                       MOVE 'Y' TO WS-GAS-FL                            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT-GAS-METERS                        
                             WS-ACTIVE-RETURN-CODE                      
                   MOVE 'N' TO WS-GAS-FL                                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-CALLED-IN-OFF-CHECK.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO       = :AT-PREMISE-NO                 
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD = 'CC001'                           
                  AND ORDER_REASON IN (' ', 'R', 'B')                   
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO       = :AT-PREMISE-NO                         
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*           AND ORDER_REASON IN (' ', 'R', 'B')                           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 76001                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +025 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT1'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) VO.SERV_ORDER_NO                                  
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                     
                      CSS_SO_FINAL_BILL XD WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO   = :AT-PREMISE-NO                     
                  AND VO.SERV_ORDER_NO = XD.SERV_ORDER_NO               
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD = 'CC001'                           
                                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.SERV_ORDER_NO                                          
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA VO,                                           
MFA-TR*               CSS_SO_FINAL_BILL XD                                      
MFA-TR*         WHERE PREMISE_NO   = :AT-PREMISE-NO                             
MFA-TR*           AND VO.SERV_ORDER_NO = XD.SERV_ORDER_NO                       
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 76002                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE +075 TO RS-STATUS-CODE                          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT2'        TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-GET-ORDER.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO,
              ORDER_TYPE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              ORDER_STATE_CD,
              WORK_AREA_ID                                      
                 INTO :VO-SERV-ORDER-NO,                                
                      :VO-ORDER-TYPE-CD,                                
                      :VO-ASSIGNED-DATETIME,                            
                      :VO-ORDER-STATE-CD,                               
P00836                :VO-WORK-AREA-ID                                  
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO       = :AT-PREMISE-NO                 
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                  AND ORDER_TYPE_CD = 'CC001'                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               ORDER_TYPE_CD,                                            
MFA-TR*               ASSIGNED_DATETIME,                                        
MFA-TR*               ORDER_STATE_CD,                                           
MFA-TR*               WORK_AREA_ID                                              
MFA-TR*          INTO :VO-SERV-ORDER-NO,                                        
MFA-TR*               :VO-ORDER-TYPE-CD,                                        
MFA-TR*               :VO-ASSIGNED-DATETIME,                                    
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-WORK-AREA-ID                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO       = :AT-PREMISE-NO                         
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*           AND ORDER_TYPE_CD = 'CC001'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF VO-ASSIGNED-DATETIME(1:10) < WS-CURRENT-DATE      
                       MOVE +960 TO RS-STATUS-CODE                      
                   END-IF                                               
P00836             IF VO-ORDER-STATE-CD = 'H' AND                       
P00836                VO-WORK-AREA-ID(1:4) = 'AROP'                     
P00836                    MOVE 'A' TO VO-ORDER-STATE-CD                 
P00836             END-IF                                               
                   MOVE VO-SERV-ORDER-NO TO WS-SERV-ORDER-NO-NUM        
                   MOVE WS-SERV-ORDER-NO-CHAR TO RS-SERV-ORDER-NO       
                   MOVE VO-ORDER-TYPE-CD TO RS-ORDER-TYPE-CD            
                   MOVE VO-ASSIGNED-DATETIME TO RS-ASSIGNED-TS          
                   MOVE VO-ORDER-STATE-CD TO RS-ORDER-STATE-CD          
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE SPACES TO RS-SERV-ORDER-NO                      
                                  RS-ORDER-TYPE-CD                      
                                  RS-ASSIGNED-TS                        
                                  RS-ORDER-STATE-CD                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7700'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-CODE-RENTAL-PROP.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_RENTAL_PROP,
              COMPANY_NO                                        
                 INTO :PR-CODE-RENTAL-PROP,                             
                      :PR-COMPANY-NO                                    
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO  = :AT-PREMISE-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_RENTAL_PROP,                                         
MFA-TR*               COMPANY_NO                                                
MFA-TR*          INTO :PR-CODE-RENTAL-PROP,                                     
MFA-TR*               :PR-COMPANY-NO                                            
MFA-TR*          FROM CSS_PREMISE                                               
MFA-TR*         WHERE PREMISE_NO  = :AT-PREMISE-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE PR-CODE-RENTAL-PROP TO RS-CODE-RENTAL-PROP      
                   MOVE PR-COMPANY-NO TO RS-COMPANY-NO                  
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE SPACES TO RS-CODE-RENTAL-PROP                   
                                  RS-COMPANY-NO                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_PREMISE'    TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7900-LL-CUSTOMER.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO                                       
                 INTO :SI-CUSTOMER-NO                                   
                 FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
                WHERE PREMISE_NO  = :AT-PREMISE-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE PREMISE_NO  = :AT-PREMISE-NO                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7900                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE SI-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM            
                   MOVE WS-CUSTOMER-NO-CHAR TO RS-LL-CUSTOMER-NO        
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE SPACES TO RS-LL-CUSTOMER-NO                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7900'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00331                                                 
           END-EXEC.                                                            
