                                                                        
       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04101.                                            
       DATE-WRITTEN. 01/23/08.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CRYSTAL  *        
      *  REPORTS                                                       *        
      *                                                                *        
      *  THIS PROGRAM SELECTS RECORDS FOR REPORTS LIGHT MAINTENANCE    *        
      *  ELECTRIC ORDERS NOT COMPLETED WITHIN 10 DAYS OF WANTED DATE   *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/23/08  GV97034    INITIAL VERSION                          *        
C37253*  06/16/08  FMB        CREATED BINDO CARD FOR REOPT(VARS)       *        
C37261*  06/16/08  FMB        CORRECTED DCLGEN NAMES                   *        
A02983*  01/18/11  SC         CHANGES TO SCHEDULE THE REPORTS MONTHLY  *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04101'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR04101 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPREGN                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWKAREA                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
C37261        INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
C37261        INCLUDE TBWKAR                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ADDRESS FORMATTING COPY BOOK                                *        
      ******************************************************************        
                                                                        
           COPY CWS00074.                                                       
           COPY CWS00011.                                                       
                                                                        
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-SVC-OUT.                                                 
            05  GTT-NAME                PIC X(26)                       
                    VALUE 'SESSION.CSR04101_R1'.                        
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
            05  MSG-TYPE                     PIC S9(9) COMP.            
            05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.   
            05  MSG-NR                       PIC S9(9) COMP VALUE  2.   
            05  MSG-RPC                      PIC X(4)  VALUE 'S200'.    
            05  MSG-RPC                      PIC X(8)  VALUE 'CSR04101'.
            05  MSG-RPC-L                    PIC S9(9) COMP.            
            05  MSG-TEXT                     PIC X(100).                
            05  MSG-TEXT-L                   PIC S9(9) COMP.            
            05  MSG-SQL-ERROR.                                          
                10  FILLER                   PIC X(10)                  
                                             VALUE 'SQLCODE = '.        
                10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.         
                10  FILLER                   PIC X(16)                  
                                             VALUE ', ERROR TOKENS: '.  
                10  MSG-SQL-ERROR-K          PIC X(70).                 
                10  MSG-SQL-ERROR-K-CHARS                               
                                             REDEFINES MSG-SQL-ERROR-K  
                                             OCCURS 70 TIMES            
                                             PIC X.                     
            05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
            05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.         
            05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
            05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.            
                88 SEND-DONE-ERROR                VALUE 'N'.            
                88 SEND-DONE-OK                   VALUE 'Y'.            
                                                                        
       01  WS-SERVICE-ADDRESS.                                          
            05 WS-SERV-ADDR-STR         PIC X(55).                      
            05 WS-SERV-ADDR-FILLER      PIC X(1).                       
            05 WS-SERV-CITY-ST-ZIP      PIC X(41).                      
                                                                        
       01  WS-COMPANY-NO                PIC X(2).                       
       01  WS-BEGIN-DT                  PIC X(26).                      
       01  WS-END-DT                    PIC X(26).                      
       01  WS-REGION-ID                 PIC X(3).                       
       01  WS-MIN-DATE                  PIC X(10).                      
       01  WS-MAX-DATE                  PIC X(10).                      
       01  WS-CF-MIN-COMP-DT            PIC X(26).                      
       01  WS-CF-MIN-DT                 PIC X(26).                      
       01  WS-CF-MIN-DT-NULL-IND        PIC S9(4) USAGE COMP VALUE +0.  
       01  WS-CF-MAX-DT                 PIC X(26).                      
       01  WS-HOLIDAY-DT                PIC X(10).                      
       01  WS-HOLIDAY-TS                PIC X(26).                      
       01  WS-TIMESTAMP                 PIC X(16)                       
                                        VALUE '-00.00.00.000000'.       
A02983 01  WS-CURRENT-DATETIME          PIC X(26) VALUE SPACES.         
       01  WS-SERV-ADDRESS              PIC X(130) VALUE SPACES.        
A02983 01  WS-TEMP-MONTH                PIC X(2).                       
A02983 01  WS-TEMP-MNTH        REDEFINES WS-TEMP-MONTH                  
A02983                                  PIC S9(2).                      
A02983 01  WS-TEMP-YEAR                 PIC X(4).                       
A02983 01  WS-TEMP-YR          REDEFINES WS-TEMP-YEAR                   
A02983                                  PIC S9(4).                      
A02983 01  WS-QUOTIENT                  PIC 9(04).                      
A02983 01  WS-REMAINDER                 PIC 9(04).                      
       01  WS-OVERHEAD                  PIC X(2).                       
       01  WS-SQLSTATE                  PIC X(05) VALUE SPACES.         
       01  CTR-ROWS                     PIC S9(9) COMP VALUE 0.         
       01  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.            
          88 NO-MORE-ROWS               VALUE 'Y'.                      
       01  S-CURR-VALUE                 PIC X(20) VALUE SPACE.          
       01  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04101'.     
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE HOLIDAY_CUR CURSOR FOR                            
                 SELECT HOLIDAY_DT                                      
                   FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                       
                  WHERE COMPANY_NO LIKE :WS-COMPANY-NO                  
                    AND HOLIDAY_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                           :WS-MIN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE
              ) <> 0) OR (LEN(:WS-MIN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MIN-DATE
              ), CONVERT(DATE, :WS-MIN-DATE) ) AND 
              IIF(TRY_CONVERT(DATE, :WS-MAX-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-DATE
              ) <> 0) OR (LEN(:WS-MAX-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-MAX-DATE
              ), CONVERT(DATE, :WS-MAX-DATE) )
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE HOLIDAY_CUR CURSOR FOR                                    
MFA-TR*          SELECT HOLIDAY_DT                                              
MFA-TR*            FROM CSS_HOLIDAY                                             
MFA-TR*           WHERE COMPANY_NO LIKE :WS-COMPANY-NO                          
MFA-TR*             AND HOLIDAY_DT BETWEEN :WS-MIN-DATE AND :WS-MAX-DATE        
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ADDRESS_CUR CURSOR FOR                            
                 SELECT SES.SERV_ORDER_NO, SES.PREMISE_NO,              
                        PRM.ADDRESS_ID                                  
                   FROM #CSR04101_R1 SES
                           WITH(READUNCOMMITTED), CSS_PREMISE PRM
                           WITH(READUNCOMMITTED)        
                  WHERE SES.PREMISE_NO = PRM.PREMISE_NO                 
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ADDRESS_CUR CURSOR FOR                                    
MFA-TR*          SELECT SES.SERV_ORDER_NO, SES.PREMISE_NO,                      
MFA-TR*                 PRM.ADDRESS_ID                                          
MFA-TR*            FROM SESSION.CSR04101_R1 SES, CSS_PREMISE PRM                
MFA-TR*           WHERE SES.PREMISE_NO = PRM.PREMISE_NO                         
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
A02983 01  PARM-FREQUENCY       PIC X(1).                               
       01  PARM-COMPANY-NO      PIC X(2).                               
       01  PARM-BEGIN-DT        PIC X(26).                              
       01  PARM-END-DT          PIC X(26).                              
       01  PARM-REGION-ID       PIC X(3).                               
                                                                        
A02983 PROCEDURE DIVISION USING PARM-FREQUENCY                          
                                PARM-COMPANY-NO                         
                                PARM-BEGIN-DT                           
                                PARM-END-DT                             
                                PARM-REGION-ID.                         
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL                                                    
                WHENEVER SQLWARNING CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER SQLERROR   CONTINUE                            
            END-EXEC.                                                   
            EXEC SQL                                                    
                WHENEVER NOT FOUND  CONTINUE                            
            END-EXEC.                                                   
                                                                        
            PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                  
                                                                        
            EXEC SQL                                                    
               DECLARE C1 CURSOR  FOR                        
                  SELECT                                                
                         REGION_TX                                      
                        ,WORK_AREA_TX                                   
                        ,SERV_ORDER_NO                                  
                        ,SERVICE_ADDRESS                                
                        ,RECEIVED_DATE                                  
                        ,WANTED_DATE                                    
                        ,HOLADJ                                         
                        ,CF_DATEDIFF                                    
                        ,CF_DOWADJ                                      
                        ,CF_WKENDADJ                                    
                        ,CF_NBD                                         
                    FROM #CSR04101_R1                            
                   WHERE CF_NBD > 10                                    
                    ORDER BY REGION_TX,  WORK_AREA_TX, SERV_ORDER_NO,   
                             WANTED_DATE                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*           SELECT                                                        
MFA-TR*                  REGION_TX                                              
MFA-TR*                 ,WORK_AREA_TX                                           
MFA-TR*                 ,SERV_ORDER_NO                                          
MFA-TR*                 ,SERVICE_ADDRESS                                        
MFA-TR*                 ,RECEIVED_DATE                                          
MFA-TR*                 ,WANTED_DATE                                            
MFA-TR*                 ,HOLADJ                                                 
MFA-TR*                 ,CF_DATEDIFF                                            
MFA-TR*                 ,CF_DOWADJ                                              
MFA-TR*                 ,CF_WKENDADJ                                            
MFA-TR*                 ,CF_NBD                                                 
MFA-TR*             FROM SESSION.CSR04101_R1                                    
MFA-TR*            WHERE CF_NBD > 10                                            
MFA-TR*             ORDER BY REGION_TX,  WORK_AREA_TX, SERV_ORDER_NO,           
MFA-TR*                      WANTED_DATE                                        
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04101_R1'            
                                      TO S-SQL-STATEMENT-V.             
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04101_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04101_R1
              (                                                         
                 SERV_ORDER_NO           DECIMAL(13,0)                  
                ,REGION_ID CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,REGION_TX CHAR(32)  COLLATE LATIN1_GENERAL_100_BIN2            
                ,WORK_AREA_ID CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,WORK_AREA_TX CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,ORDER_TYPE_CD CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,ORDER_TYPE_DESC CHAR(15)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                       
                ,WORK_TYPE_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,WORK_TYPE_DESC CHAR(25)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                       
                ,SERVICE_ADDRESS CHAR(130)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                      
                ,PREMISE_NO              DECIMAL(10,0)                  
                ,RECEIVED_DATE           DATETIME2(6)                      
                ,WANTED_DATE             DATETIME2(6)                      
                ,HOLADJ                  INT                        
                ,CF_DATEDIFF             INT                        
                ,CF_DOWADJ               INT                        
                ,CF_WKENDADJ             INT                        
                ,CF_NBD                  INT                        
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE SQLCODE            TO ABEND-SQLCODE                  
              MOVE SQLSTATE           TO ABEND-SQLSTATE                 
              MOVE '0100A'            TO ACTIVE-PARAGRAPH               
              MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
              MOVE SPACES             TO ABEND-SQL-PREDICATES           
                                         ABEND-TABLES                   
              MOVE 'CSR04101_R1'      TO TABLE-1                        
              MOVE SPACES             TO TABLE-ELEMENT-1                
              MOVE SPACES             TO HOSTVAR-ELEMENT-1              
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                      THRU  9900-EXIT                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO.              
A02983      IF PARM-FREQUENCY = 'O' THEN                                
            MOVE PARM-BEGIN-DT           TO WS-BEGIN-DT                 
            MOVE PARM-END-DT             TO WS-END-DT                   
A02983      ELSE                                                        
A02983       EXEC SQL                                                   
A02983          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATETIME           
A02983       END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-CURRENT-DATETIME  = CURRENT TIMESTAMP                   
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02983        MOVE '0000-00-00-00.00.00.000000' TO PARM-BEGIN-DT        
A02983                                             PARM-END-DT          
A02983        MOVE WS-CURRENT-DATETIME(1:10)    TO PARM-BEGIN-DT(1:10)  
A02983                                             PARM-END-DT(1:10)    
A02983        MOVE WS-CURRENT-DATETIME(6:2)    TO WS-TEMP-MONTH         
A02983        MOVE WS-CURRENT-DATETIME(1:4)    TO WS-TEMP-YEAR          
A02983        IF WS-TEMP-MONTH = '01' THEN                              
A02983           MOVE  '12'                   TO PARM-BEGIN-DT(6:2)     
A02983                                           PARM-END-DT(6:2)       
A02983                                           WS-TEMP-MONTH          
A02983           SUBTRACT      1     FROM WS-TEMP-YR                    
A02983           MOVE  WS-TEMP-YR       TO PARM-BEGIN-DT(1:4)           
A02983                                     PARM-END-DT(1:4)             
A02983         ELSE                                                     
A02983            SUBTRACT     1 FROM WS-TEMP-MNTH                      
A02983            MOVE WS-TEMP-MNTH            TO PARM-BEGIN-DT(6:2)    
A02983                                            PARM-END-DT(6:2)      
A02983          END-IF                                                  
A02983        IF WS-TEMP-MNTH = 2 THEN                                  
A02983            PERFORM 5130-CHECK-LEAP-YEAR      THRU 5130-EXIT      
A02983         ELSE                                                     
A02983           IF WS-TEMP-MNTH = 4 OR WS-TEMP-MNTH = 6 OR             
A02983             WS-TEMP-MNTH = 9 OR WS-TEMP-MNTH = 11 THEN           
A02983         MOVE '30'                 TO PARM-END-DT(9:2)            
A02983        ELSE                                                      
A02983         MOVE '31'                 TO PARM-END-DT(9:2)            
A02983         END-IF                                                   
A02983       END-IF                                                     
A02983         MOVE '01'                 TO PARM-BEGIN-DT(9:2)          
A02983         MOVE PARM-BEGIN-DT        TO WS-BEGIN-DT                 
A02983         MOVE PARM-END-DT          TO WS-END-DT                   
A02983       END-IF                                                     
                                                                        
            MOVE PARM-REGION-ID          TO WS-REGION-ID.               
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
            IF WS-REGION-ID = SPACES                                    
               MOVE '%%%'                 TO WS-REGION-ID               
            END-IF.                                                     
            PERFORM 5000-INSERT-CSR04101-R1        THRU 5000-EXIT       
            PERFORM 5010-UPDATE-CSR04101-R1        THRU 5010-EXIT.      
            PERFORM 5015-UPDATE-CSR04101-R1-WKEND  THRU 5015-EXIT.      
            PERFORM 5020-SELECT-CSR04101-R1        THRU 5020-EXIT.      
            MOVE WS-CF-MIN-DT(1:10)                TO WS-MIN-DATE       
            MOVE WS-CF-MAX-DT(1:10)                TO WS-MAX-DATE.      
            PERFORM 7000-OPEN-HOLIDAY-CUR          THRU 7000-EXIT.      
            PERFORM 7010-FETCH-HOLIDAY-CUR         THRU 7010-EXIT.      
            PERFORM 5030-PROCESS-HOLIDAY-CUR       THRU 5030-EXIT       
                                                   UNTIL NO-MORE-ROWS.  
            PERFORM 7020-CLOSE-HOLIDAY-CUR         THRU 7020-EXIT.      
            PERFORM 5040-UPDATE-CSR04101-R1-NBD    THRU 5040-EXIT.      
            MOVE    'N'                            TO WS-NO-MORE-ROWS.  
            PERFORM 7030-OPEN-ADDRESS-CUR          THRU 7030-EXIT.      
            PERFORM 7040-FETCH-ADDRESS-CUR         THRU 7040-EXIT.      
            PERFORM 5050-PROCESS-ADDRESS-CUR       THRU 5050-EXIT       
                                                   UNTIL NO-MORE-ROWS.  
            PERFORM 7050-CLOSE-ADDRESS-CUR         THRU 7050-EXIT.      
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5000-INSERT-CSR04101-R1.                                       *        
      ******************************************************************        
       5000-INSERT-CSR04101-R1.                                         
            EXEC SQL                                                    
               INSERT INTO #CSR04101_R1                          
                   SELECT CSO.SERV_ORDER_NO                             
                         ,OOR.REGION_ID                                 
                         ,OOR.REGION_TX                                 
                         ,CWA.WORK_AREA_ID                              
                         ,CWA.WORK_AREA_TX                              
                         ,CSO.ORDER_TYPE_CD                             
                         ,COT.ORDER_TYPE_DESC                           
                         ,SOI.WORK_TYPE_CD                              
                         ,CWT.WORK_TYPE_DESC                            
                         ,' '                                           
                         ,CSO.PREMISE_NO                                
                         ,CSO.DATE_RECVED                               
                         ,WANTED_BY_DATETIME                            
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                     FROM CSS_WORK_AREA_MATL     WAM                    
                         ,CSS_SO_DATA            CSO                    
                         ,CSS_SO_ORDER_INST      SOI                    
                         ,CSS_WORK_AREA          CWA                    
                         ,CSS_ORDER_TYPE         COT                    
                         ,CSS_WORK_TYPE          CWT                    
                         ,CSS_OP_REGION          OOR                    
                    WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)        
                      AND (WAM.REGION_ID    LIKE :WS-REGION-ID)         
                      AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CSO.COMPLETED_DATETIME IS NULL)              
                      AND ((CSO.WANTED_BY_DATETIME                      
                  BETWEEN CIS.CHAR2TIMESTAMP(:WS-BEGIN-DT) AND 
              CIS.CHAR2TIMESTAMP(:WS-END-DT))                  
                      AND (CSO.ORDER_STATE_CD = 'A'))                   
                      AND (CSO.ORDER_TYPE_CD = 'FW003')                 
                      AND (CSO.SERV_ORDER_STATUS IN ('10','20','26',    
                           '23','30','70'))                             
                      AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)       
                      AND (SOI.CODE_UTIL_TYPE = 'E')                    
                      AND (SOI.WORK_TYPE_CD IN                          
                          ('LAL', 'LRL', 'LXL'))                        
                      AND NOT (CSO.DATE_RECVED IS NULL                  
                      AND CSO.WANTED_BY_DATETIME IS NULL)               
                      AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CWA.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)       
                      AND (CWT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)         
                      AND (OOR.REGION_ID = WAM.REGION_ID)               
                   UNION                                                
                   SELECT CSO.SERV_ORDER_NO                             
                         ,OOR.REGION_ID                                 
                         ,OOR.REGION_TX                                 
                         ,CWA.WORK_AREA_ID                              
                         ,CWA.WORK_AREA_TX                              
                         ,CSO.ORDER_TYPE_CD                             
                         ,COT.ORDER_TYPE_DESC                           
                         ,SOI.WORK_TYPE_CD                              
                         ,CWT.WORK_TYPE_DESC                            
                         ,' '                                           
                         ,CSO.PREMISE_NO                                
                         ,CSO.DATE_RECVED                               
                         ,WANTED_BY_DATETIME                            
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                         ,0                                             
                     FROM CSS_WORK_AREA_MATL         WAM                
                         ,HST_SO_DATA                CSO                
                         ,HST_SO_ORDER_INST          SOI                
                         ,CSS_WORK_AREA              CWA                
                         ,CSS_ORDER_TYPE             COT                
                         ,CSS_WORK_TYPE              CWT                
                         ,CSS_OP_REGION              OOR                
                    WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)        
                      AND (WAM.REGION_ID    LIKE :WS-REGION-ID)         
                      AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CSO.COMPLETED_DATETIME IS NULL)              
                      AND ((CSO.WANTED_BY_DATETIME                      
                  BETWEEN CIS.CHAR2TIMESTAMP(:WS-BEGIN-DT) AND 
              CIS.CHAR2TIMESTAMP(:WS-END-DT))                  
                      AND (CSO.ORDER_STATE_CD = 'A'))                   
                      AND (CSO.ORDER_TYPE_CD = 'FW003')                 
                      AND (CSO.SERV_ORDER_STATUS IN ('10','20','26',    
                           '23','30','70'))                             
                      AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)       
                      AND (SOI.CODE_UTIL_TYPE = 'E')                    
                      AND (SOI.WORK_TYPE_CD IN                          
                          ('LAL', 'LRL', 'LXL'))                        
                      AND NOT (CSO.DATE_RECVED IS NULL                  
                      AND CSO.WANTED_BY_DATETIME IS NULL)               
                      AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)         
                      AND (CWA.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)       
                      AND (CWT.COMPANY_NO = CSO.COMPANY_NO)             
                      AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)         
                      AND (OOR.REGION_ID = WAM.REGION_ID)               
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR04101_R1                                  
MFA-TR*            SELECT CSO.SERV_ORDER_NO                                     
MFA-TR*                  ,OOR.REGION_ID                                         
MFA-TR*                  ,OOR.REGION_TX                                         
MFA-TR*                  ,CWA.WORK_AREA_ID                                      
MFA-TR*                  ,CWA.WORK_AREA_TX                                      
MFA-TR*                  ,CSO.ORDER_TYPE_CD                                     
MFA-TR*                  ,COT.ORDER_TYPE_DESC                                   
MFA-TR*                  ,SOI.WORK_TYPE_CD                                      
MFA-TR*                  ,CWT.WORK_TYPE_DESC                                    
MFA-TR*                  ,' '                                                   
MFA-TR*                  ,CSO.PREMISE_NO                                        
MFA-TR*                  ,CSO.DATE_RECVED                                       
MFA-TR*                  ,WANTED_BY_DATETIME                                    
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*              FROM CSS_WORK_AREA_MATL     WAM                            
MFA-TR*                  ,CSS_SO_DATA            CSO                            
MFA-TR*                  ,CSS_SO_ORDER_INST      SOI                            
MFA-TR*                  ,CSS_WORK_AREA          CWA                            
MFA-TR*                  ,CSS_ORDER_TYPE         COT                            
MFA-TR*                  ,CSS_WORK_TYPE          CWT                            
MFA-TR*                  ,CSS_OP_REGION          OOR                            
MFA-TR*             WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)                
MFA-TR*               AND (WAM.REGION_ID    LIKE :WS-REGION-ID)                 
MFA-TR*               AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CSO.COMPLETED_DATETIME IS NULL)                      
MFA-TR*               AND ((CSO.WANTED_BY_DATETIME                              
MFA-TR*           BETWEEN :WS-BEGIN-DT AND :WS-END-DT)                          
MFA-TR*               AND (CSO.ORDER_STATE_CD = 'A'))                           
MFA-TR*               AND (CSO.ORDER_TYPE_CD = 'FW003')                         
MFA-TR*               AND (CSO.SERV_ORDER_STATUS IN ('10','20','26',            
MFA-TR*                    '23','30','70'))                                     
MFA-TR*               AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)               
MFA-TR*               AND (SOI.CODE_UTIL_TYPE = 'E')                            
MFA-TR*               AND (SOI.WORK_TYPE_CD IN                                  
MFA-TR*                   ('LAL', 'LRL', 'LXL'))                                
MFA-TR*               AND NOT (CSO.DATE_RECVED IS NULL                          
MFA-TR*               AND CSO.WANTED_BY_DATETIME IS NULL)                       
MFA-TR*               AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CWA.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)               
MFA-TR*               AND (CWT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)                 
MFA-TR*               AND (OOR.REGION_ID = WAM.REGION_ID)                       
MFA-TR*            UNION                                                        
MFA-TR*            SELECT CSO.SERV_ORDER_NO                                     
MFA-TR*                  ,OOR.REGION_ID                                         
MFA-TR*                  ,OOR.REGION_TX                                         
MFA-TR*                  ,CWA.WORK_AREA_ID                                      
MFA-TR*                  ,CWA.WORK_AREA_TX                                      
MFA-TR*                  ,CSO.ORDER_TYPE_CD                                     
MFA-TR*                  ,COT.ORDER_TYPE_DESC                                   
MFA-TR*                  ,SOI.WORK_TYPE_CD                                      
MFA-TR*                  ,CWT.WORK_TYPE_DESC                                    
MFA-TR*                  ,' '                                                   
MFA-TR*                  ,CSO.PREMISE_NO                                        
MFA-TR*                  ,CSO.DATE_RECVED                                       
MFA-TR*                  ,WANTED_BY_DATETIME                                    
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*                  ,0                                                     
MFA-TR*              FROM CSS_WORK_AREA_MATL         WAM                        
MFA-TR*                  ,HST_SO_DATA                CSO                        
MFA-TR*                  ,HST_SO_ORDER_INST          SOI                        
MFA-TR*                  ,CSS_WORK_AREA              CWA                        
MFA-TR*                  ,CSS_ORDER_TYPE             COT                        
MFA-TR*                  ,CSS_WORK_TYPE              CWT                        
MFA-TR*                  ,CSS_OP_REGION              OOR                        
MFA-TR*             WHERE (CSO.COMPANY_NO   =    :WS-COMPANY-NO)                
MFA-TR*               AND (WAM.REGION_ID    LIKE :WS-REGION-ID)                 
MFA-TR*               AND (CSO.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CSO.COMPLETED_DATETIME IS NULL)                      
MFA-TR*               AND ((CSO.WANTED_BY_DATETIME                              
MFA-TR*           BETWEEN :WS-BEGIN-DT AND :WS-END-DT)                          
MFA-TR*               AND (CSO.ORDER_STATE_CD = 'A'))                           
MFA-TR*               AND (CSO.ORDER_TYPE_CD = 'FW003')                         
MFA-TR*               AND (CSO.SERV_ORDER_STATUS IN ('10','20','26',            
MFA-TR*                    '23','30','70'))                                     
MFA-TR*               AND (SOI.SERV_ORDER_NO = CSO.SERV_ORDER_NO)               
MFA-TR*               AND (SOI.CODE_UTIL_TYPE = 'E')                            
MFA-TR*               AND (SOI.WORK_TYPE_CD IN                                  
MFA-TR*                   ('LAL', 'LRL', 'LXL'))                                
MFA-TR*               AND NOT (CSO.DATE_RECVED IS NULL                          
MFA-TR*               AND CSO.WANTED_BY_DATETIME IS NULL)                       
MFA-TR*               AND (CWA.WORK_AREA_ID = WAM.WORK_AREA_ID)                 
MFA-TR*               AND (CWA.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (COT.ORDER_TYPE_CD = CSO.ORDER_TYPE_CD)               
MFA-TR*               AND (CWT.COMPANY_NO = CSO.COMPANY_NO)                     
MFA-TR*               AND (CWT.WORK_TYPE_CD = SOI.WORK_TYPE_CD)                 
MFA-TR*               AND (OOR.REGION_ID = WAM.REGION_ID)                       
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  ADD +1                      TO CTR-ROWS               
               END-IF                                                   
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE '5000'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04101_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
            EXEC SQL                                                            
               INCLUDE CPD00074                                                 
            END-EXEC.                                                           
                                                                        
            EXEC SQL                                                            
               INCLUDE CPD00004                                                 
            END-EXEC.                                                           
                                                                        
      ******************************************************************        
      * 5010-UPDATE-CSR04101-R1.                                       *        
      ******************************************************************        
       5010-UPDATE-CSR04101-R1.                                         
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04101_R1                             
                    SET CF_DATEDIFF  = (CIS.DAYS(
           CAST(SYSDATETIMEOFFSET() AS DATE)) -            
                        CIS.DAYS(WANTED_DATE)),                             
                        CF_DOWADJ    = (CASE                            
                        WHEN CIS.DAYOFWEEK(WANTED_DATE) = 7 THEN 1          
                        ELSE 0 END)                                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04101_R1                                     
MFA-TR*             SET CF_DATEDIFF  = (DAYS(CURRENT DATE) -                    
MFA-TR*                 DAYS(WANTED_DATE)),                                     
MFA-TR*                 CF_DOWADJ    = (CASE                                    
MFA-TR*                 WHEN DAYOFWEEK(WANTED_DATE) = 7 THEN 1                  
MFA-TR*                 ELSE 0 END)                                             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5010'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04101_R1'         TO TABLE-1                    
               MOVE 'CF_WANTED_FL'        TO TABLE-ELEMENT-1            
               MOVE 'DATEDIFF'            TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5015-UPDATE-CSR04101-R1-WKEND.                                 *        
      ******************************************************************        
       5015-UPDATE-CSR04101-R1-WKEND.                                   
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04101_R1                             
                    SET CF_WKENDADJ  = ((CIS.DAYOFWEEK(WANTED_DATE) + 
           CF_DATEDIFF) / 7 )  
                        * 2                                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR* MSQ051
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04101_R1                                     
MFA-TR*             SET CF_WKENDADJ  = CAST(                                    
MFA-TR*                 (((DAYOFWEEK(WANTED_DATE) + CF_DATEDIFF) / 7 )          
MFA-TR*                 * 2) AS INTEGER)                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5015'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04101_R1'         TO TABLE-1                    
               MOVE 'CF_WKENDADJ'         TO TABLE-ELEMENT-1            
               MOVE 'CF_WKENDADJ'         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5015-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 5020-SELECT-CSR04101-R1.                                       *        
      ******************************************************************        
       5020-SELECT-CSR04101-R1.                                         
                                                                        
            EXEC SQL                                                    
                 SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MIN(
           WANTED_DATE), 121), ' ', '-'), ':', '.'),                           
                        REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                   INTO :WS-CF-MIN-DT,                                  
                        :WS-CF-MAX-DT                                   
                   FROM #CSR04101_R1                             
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ049
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SELECT MIN(WANTED_DATE),                                       
MFA-TR*                 CURRENT TIMESTAMP                                       
MFA-TR*            INTO :WS-CF-MIN-DT,                                          
MFA-TR*                 :WS-CF-MAX-DT                                           
MFA-TR*            FROM SESSION.CSR04101_R1                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5020'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSR04101_R1'         TO TABLE-1                    
               MOVE 'CF_MIN_MAX_DT'       TO TABLE-ELEMENT-1            
               MOVE 'CF-MIN-MAX-DT'       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5020-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 7000-OPEN-HOLIDAY-CUR.                                        *         
      *****************************************************************         
       7000-OPEN-HOLIDAY-CUR.                                           
                                                                        
            EXEC SQL                                                    
                 OPEN HOLIDAY_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7000'                      TO ACTIVE-PARAGRAPH     
               MOVE 'OPEN'                      TO ABEND-FUNCTION       
               MOVE 'CSS_HOLIDAY'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7010-FETCH-HOLIDAY-CUR.                                       *         
      *****************************************************************         
       7010-FETCH-HOLIDAY-CUR.                                          
                                                                        
            EXEC SQL                                                    
                 FETCH HOLIDAY_CUR                                      
                  INTO :WS-HOLIDAY-DT                                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE 'Y'                       TO WS-NO-MORE-ROWS     
               END-IF                                                   
            ELSE                                                        
                MOVE PROGRAM-NAME                TO ABEND-PROGRAM       
                MOVE '7010'                      TO ACTIVE-PARAGRAPH    
                MOVE 'FETCH'                     TO ABEND-FUNCTION      
                MOVE 'CSS_HOLIDAY'               TO TABLE-1             
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7010-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7020-CLOSE-HOLIDAY-CUR.                                       *         
      *****************************************************************         
       7020-CLOSE-HOLIDAY-CUR.                                          
                                                                        
            EXEC SQL                                                    
                 CLOSE HOLIDAY_CUR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7020'                      TO ACTIVE-PARAGRAPH     
               MOVE 'CLOSE'                     TO ABEND-FUNCTION       
               MOVE 'CSS_HOLIDAY'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7020-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5030-PROCESS-HOLIDAY-CUR.                                      *        
      ******************************************************************        
       5030-PROCESS-HOLIDAY-CUR.                                        
                                                                        
           STRING WS-HOLIDAY-DT, WS-TIMESTAMP DELIMITED BY SIZE         
                  INTO WS-HOLIDAY-TS.                                   
            EXEC SQL                                                    
                 UPDATE #CSR04101_R1                             
                    SET HOLADJ = HOLADJ + 1                             
                  WHERE WANTED_DATE    <=                               
                        CIS.CHAR2TIMESTAMP(:WS-HOLIDAY-TS)                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04101_R1                                     
MFA-TR*             SET HOLADJ = HOLADJ + 1                                     
MFA-TR*           WHERE WANTED_DATE    <=                                       
MFA-TR*                 TIMESTAMP(:WS-HOLIDAY-TS)                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5030'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04101_R1'         TO TABLE-1                    
               MOVE 'HOLADJ'              TO TABLE-ELEMENT-1            
               MOVE 'HOLADJ'              TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
            PERFORM 7010-FETCH-HOLIDAY-CUR   THRU 7010-EXIT.            
                                                                        
       5030-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5040-UPDATE-CSR04101-R1-NBD.                                   *        
      ******************************************************************        
       5040-UPDATE-CSR04101-R1-NBD.                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04101_R1                             
                    SET CF_NBD = CF_DATEDIFF + CF_DOWADJ -              
                        CF_WKENDADJ - HOLADJ                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04101_R1                                     
MFA-TR*             SET CF_NBD = CF_DATEDIFF + CF_DOWADJ -                      
MFA-TR*                 CF_WKENDADJ - HOLADJ                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5040'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04101_R1-NBD'     TO TABLE-1                    
               MOVE 'CF_NBD'              TO TABLE-ELEMENT-1            
               MOVE 'CF_NBD'              TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       5040-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 7030-OPEN-ADDRESS-CUR.                                        *         
      *****************************************************************         
       7030-OPEN-ADDRESS-CUR.                                           
                                                                        
            EXEC SQL                                                    
                 OPEN ADDRESS_CUR                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7030'                      TO ACTIVE-PARAGRAPH     
               MOVE 'OPEN'                      TO ABEND-FUNCTION       
               MOVE 'CSR04101_R1'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7040-FETCH-ADDRESS-CUR.                                       *         
      *****************************************************************         
       7040-FETCH-ADDRESS-CUR.                                          
                                                                        
            EXEC SQL                                                    
                 FETCH ADDRESS_CUR                                      
                  INTO :VO-SERV-ORDER-NO, :PR-PREMISE-NO,               
                       :PR-ADDRESS-ID                                   
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE. 
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  MOVE PR-ADDRESS-ID             TO DY-ADDRESS-ID       
               ELSE                                                     
                  IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND              
                     MOVE 'Y'                    TO WS-NO-MORE-ROWS     
                  END-IF                                                
               END-IF                                                   
            ELSE                                                        
                MOVE ZERO                        TO DY-ADDRESS-ID       
                MOVE PROGRAM-NAME                TO ABEND-PROGRAM       
                MOVE '7040'                      TO ACTIVE-PARAGRAPH    
                MOVE 'FETCH'                     TO ABEND-FUNCTION      
                MOVE 'CSR04101_R1'               TO TABLE-1             
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 7050-CLOSE-ADDRESS-CUR.                                       *         
      *****************************************************************         
       7050-CLOSE-ADDRESS-CUR.                                          
                                                                        
            EXEC SQL                                                    
                 CLOSE ADDRESS_CUR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO  WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7050'                      TO ACTIVE-PARAGRAPH     
               MOVE 'CLOSE'                     TO ABEND-FUNCTION       
               MOVE 'CSR04101_R1'               TO TABLE-1              
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
            END-IF.                                                     
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5050-PROCESS-ADDRESS-CUR.                                      *        
      ******************************************************************        
       5050-PROCESS-ADDRESS-CUR.                                        
                                                                        
            IF DY-ADDRESS-ID > 0                                        
              PERFORM 4050-GET-FORMATTED-ADDRESS THRU 4050-EXIT         
              IF WS-FMT-ADDR-STREET > SPACES                            
                 MOVE WS-FMT-ADDR-STREET    TO WS-SERV-ADDR-STR         
                 MOVE WS-FMT-CITY-STATE-ZIP TO WS-SERV-CITY-ST-ZIP      
                 MOVE SPACE                 TO WS-SERV-ADDR-FILLER      
                 MOVE WS-SERVICE-ADDRESS    TO WS-SERV-ADDRESS          
              END-IF                                                    
            END-IF.                                                     
                                                                        
            EXEC SQL                                                    
                 UPDATE #CSR04101_R1                             
                    SET SERVICE_ADDRESS = :WS-SERV-ADDRESS              
                  WHERE SERV_ORDER_NO   = :VO-SERV-ORDER-NO             
                    AND PREMISE_NO      = :PR-PREMISE-NO                
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          UPDATE SESSION.CSR04101_R1                                     
MFA-TR*             SET SERVICE_ADDRESS = :WS-SERV-ADDRESS                      
MFA-TR*           WHERE SERV_ORDER_NO   = :VO-SERV-ORDER-NO                     
MFA-TR*             AND PREMISE_NO      = :PR-PREMISE-NO                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '5050'                TO ACTIVE-PARAGRAPH           
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE 'CSR04101_R1'         TO TABLE-1                    
               MOVE 'SERVICE_ADDRESS'     TO TABLE-ELEMENT-1            
               MOVE WS-SERV-ADDRESS       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
            PERFORM 7040-FETCH-ADDRESS-CUR   THRU 7040-EXIT.            
                                                                        
       5050-EXIT.                                                       
            EXIT.                                                       
                                                                        
A02983******************************************************************        
A02983* 5130-CHECK-LEAP-YEAR                                                    
A02983******************************************************************        
A02983 5130-CHECK-LEAP-YEAR.                                            
                                                                        
                                                                        
A02983           DIVIDE WS-TEMP-YR BY 4                                 
A02983             GIVING WS-QUOTIENT                                   
A02983             REMAINDER WS-REMAINDER                               
A02983           IF  WS-REMAINDER = 0                                   
A02983               MOVE '29'                     TO PARM-END-DT(9:2)  
A02983               DIVIDE WS-TEMP-YR   BY 100                         
A02983               GIVING WS-QUOTIENT                                 
A02983               REMAINDER WS-REMAINDER                             
A02983               IF  WS-REMAINDER = 0                               
A02983                    MOVE '28'                 TO PARM-END-DT(9:2) 
A02983                    DIVIDE WS-TEMP-YR BY 400                      
A02983                    GIVING WS-QUOTIENT                            
A02983                    REMAINDER WS-REMAINDER                        
A02983                    IF  WS-REMAINDER = 0                          
A02983                        MOVE '29'             TO PARM-END-DT(9:2) 
A02983                    END-IF                                        
A02983                END-IF                                            
A02983            ELSE                                                  
A02983                MOVE '28'                     TO PARM-END-DT(9:2) 
A02983            END-IF.                                               
                                                                        
A02983 5130-EXIT.                                                       
A02983     EXIT.                                                        
                                                                        
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
                                                                        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
                                                                        
