       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04099.                                         
       DATE-WRITTEN. FEB 04, 2008.                                      
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00060000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00080000
      *--                   STORED PROCEDURE:  CSR04099              -- 00090000
      *---------------------------------------------------------------- 00100000
      *--                         S U M M A R Y                      -- 00110000
      *--                                                            -- 00120000
      *--  CSR04099:                                                 -- 00130000
      *--                                                            -- 00140000
      *--  # RETURNS OPTION CODE DETAIL                              -- 00150000
      *--                                                            -- 00160000
      *---------------------------------------------------------------- 00170000
      *--                                                            -- 00180000
      *--  PARAMETERS                                                -- 00190000
      *--                                                            -- 00200000
      *--      IN                                                    -- 00210000
      *--            OPTION_CD             CHAR(12)                  -- 00220000
      *--            ACCOUNT_NO            CHAR(13)                  -- 00230000
      *--            CODE_UTIL_TYPE        CHAR(01)                  -- 00240000
      *--            IC_NO                 CHAR(04)                  -- 00250000
      *--            THERM_CSC_ACCT_FL     CHAR(01)                  -- 00260000
      *--                                                            -- 00270000
      *--      OUT                                                   -- 00280000
      *--            THERM_PRICE           DECIMAL(11,6)             -- 00290000
      *--            OPTN_VALID_MNTHS      SMALLINT                  -- 00300000
      *--            PRIM_FACTOR_ID        CHAR(09)                  -- 00310000
      *--            CORE_RATE_PLAN_NO     CHAR(03)                  -- 00320000
      *--            RATE_CALC_TYPE_CD     CHAR(02)                  -- 00330000
      *--            CSC_AMT               DECIMAL(11,6)             -- 00340000
      *--            CSC_REFND_FL          CHAR(01)                  -- 00350000
      *--            CSC_MNTHS             SMALLINT                  -- 00360000
      *--            DURATION_REM_MO       SMALLINT                  -- 00370000
      *--            TIER_ACCT_TYPE_CD     CHAR(01)                  -- 00380000
      *--            WEB_RENEWAL_FL        CHAR(01)                  -- 00390000
      *--            RATE_DEFINITION_CD    CHAR(01)                  -- 00400000
P00836*--            CURR_EXT_DESC_LONG    VARCHAR(255)              -- 00410000
P00211*--            PEND_OPT_EXIST_FL     CHAR(01)                  -- 00420000
P00211*--            SHOW_RENEWAL_OPT      CHAR(01)                  -- 00421000
P00836*--            PEND_EXT_DESC_LONG    VARCHAR(255)              -- 00422000
P00680*--            ADJUSTABLE_FLAG       CHAR(01)                  -- 00423000
P00680*--            CURRENT_THERM_PRICE   DECIMAL(11,6)             -- 00424000
P00805*--            CURR_OPT_EFF_DATE     CHAR(10)                  -- 00425003
P00805*--            PEND_OPT_EFF_DATE     CHAR(10)                  -- 00426003
P00805*--            SENIOR_RATE_FL        CHAR(01)                  -- 00427004
P00805*--            IS_CURR_OPTN_FLEX     CHAR(01)                  -- 00428006
A05037*--            CORE_RATE_PLAN_DDDC   DECIMAL(5,2)              -- 00428007
A05043*--            PRINT_SR_DSC_MSG_CD   CHAR(02)                  -- 00428008
P00836*--            CURR_OPT_ROR_END_DT   CHAR(10)                  --         
P00836*--            CUSTOMER_DOB          CHAR(10)                  --         
P00836*--            SENIOR_BY_DOB_FLAG    CHAR(01)                  --         
P00836*--            TIER_CUST_STAT_CD     CHAR(01)                  --         
P00836*--            CODE_REVENUE_CLASS    CHAR(03)                  --         
P00836*--            SPCL_OFFER_TYPE_CD    CHAR(02)                  --         
P00892*--            PEND_OPT_THRM_PRC     DECIMAL(11,6)             -- 00420000
P00892*--            PEND_OPT_CSC_AMT      DECIMAL(11,6)             -- 00420000
P00892*--            PEND_OPT_EXT_FEE      DECIMAL(11,6)             -- 00420000
P00892*--            PEND_OPT_ARMSG_FL     CHAR(01)                  --         
P00892*--            CURR_OPT_ARMSG_FL     CHAR(01)                  --         
P00892*--            SEASONAL_FL           CHAR(01)                  --         
P00892*--            PEND_OPT_ROR_END_DT   CHAR(10)                  --         
P00892*--            PEND_WEB_DESC_LONG    VARCHAR(255)              -- 00422000
P00836*--            PEND_WMKT_DESC_LONG   VARCHAR(1024)             -- 00422000
P836MS*--            CURR_WMKT_DESC_LONG   VARCHAR(1024)             -- 00422000
P836MS*--            CURR_OPT_EXT_FEE      DECIMAL(11,6)             -- 00430000
P836MS*--            CURR_RATE_EXP_DT      CHAR(10)                  -- 00430000
P836MS*--            CURR_RATE_EXP_TXT     CHAR(14)                  -- 00430000
P836MS*--            PEND_RATE_EFF_TXT     CHAR(14)                  -- 00430000
P00892*--            CURR_OPT_AR_ELGBL     CHAR(01)                  --         
P892NW*--            AR_CALL_BY_DATE       CHAR(10)                  --         
P836TR*--            XFER_RATE_TITLE_1     CHAR(50)                  --         
P836TR*--            XFER_RATE_TITLE_2     CHAR(50)                  --         
      *--                                                            -- 00430000
P00836*--            BUSINESS RULES                                  --         
      *--                                                            -- 00430000
      *--      INOUT                                                 -- 00440000
      *--                                                            -- 00450000
      *--            NONE                                            -- 00460000
      *--                                                            -- 00470000
      *--  RESULT SET                                                -- 00480000
      *--                                                            -- 00490000
      *--     1                                                      -- 00500000
      *--                                                            -- 00510000
      *---------------------------------------------------------------- 00520000
      *--                        MODIFICATION LOG                    -- 00530000
      *--                                                            -- 00540000
      *--  DATE          INITIALS    COMMENTS                        -- 00550000
      *--  -----------   --------    ---------------------------------- 00560000
      *--  04/02/2008    VY95550     PROGRAM INITIALLY WRITTEN.      -- 00570000
A01339*--  06/29/2009    VY95550     VARCHAR FIELD INITIALIZATION.   -- 00580000
P00211*--  08/31/2009    VY95550     ADDED PEND_OPT_EXIST_FL IN      -- 00590000
P00211*--                            RESULT SET                      -- 00600000
P00473*--  02/21/2012    HA7A338     ADDED VERSIONING LOGIC TO THE   -- 00601000
P00473*--                            SQLS USING CRM TABLES TO RETRIEVE- 00602000
P00473*--                            ACTIVE APPROVED VERSION         -- 00603000
P00680*--  05/12/2012    MS93554     PASS ONE TIME ADJUSTABLE OPTION -- 00604000
P00680*--                            FLAG & THERM PRICE TO WEB/ECS   -- 00605000
P00680*--                            FOR SECURED ACCOUNT PROFILE.    -- 00606000
P00805*--  03/04/2014    SS97726     EXTENDED EARLY RENEWAL WEB MSG  -- 00607000
P00805*--                            CHANGES. PASS ADDITIONAL INFO.  -- 00608000
A05037*--  10/09/2014    SS97726     PASS DDDC VALUE.                -- 00608100
A05043*--  11/19/2014    SS97726     LOWER SR. DISCOUNT.             -- 00608200
P00836*--  04/09/2015    SS97726     WEB CHANNEL MODERNIZATION.      --         
P00892*--  05/21/2015    HA7A338     ADDING 2 NEW MESSAGE FOR ACCTS  --         
P00892*--                            OPT FOR AUTO RENEWAL OPTION.    --         
P00892*--                            ALSO ADDED PENDING OPTION THERM --         
P00892*--                            PRICE, CSC AMT, EXIT FEE, AR MSG--         
P00892*--                            FLAG, SEASONAL FLG IN RS1.      --         
P00892*--  10/02/2015    HA7A338     ADDING ROR END DATE AND WEB LONG--         
P00892*--                            DESC OF PENDING OPTION.         --         
P00836*--  12/08/2015    VV7M728     ADD WEB MARKET DESCRIPTION.     --         
P836MS*--  02/05/2016    SS45239     ADD COLUMNS - MANAGE SERVICE.   --         
P00892*--  03/01/2016    VV7M728     AUTO RENEWAL, FAR - AUTORENEWED --         
P892NW*--  03/16/2016    SS45239     ADD MCSCB328 CALL TO GET DETAILS--         
P892NW*--                            FOR AUTO-RENEW-60-DAY WEB PAGE  --         
OTPOOL*--  07/19/2016    SS45239     OUTER POOL GROUP CHANGES.       --         
OTPMSG*--  08/17/2016    SS45239     OUTER POOL GROUP WEB MESSAGING. --         
I02262*--  08/23/2016    SS45239     SMALL COMM OUTER POOL CHANGES.  --         
      *---------------------------------------------------------------- 00610000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04099'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR04099 STARTS HERE'.            
                                                                        
      ******************************************************************00700000
      *    WORK AREAS                                                  *00710000
      ******************************************************************00720000
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC  S9(9) COMP.               
           05  PARM-OPTION-CD            PIC  X(12).                    
           05  PARM-ACCOUNT-NO           PIC  X(13) VALUE SPACES.       
           05  PARM-ACCOUNT-NO-NUM       PIC  9(13).                    
COB305     05 PARM-ACCOUNT-NO-DEC        PIC  S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
           05  PARM-CODE-UTIL-TYPE       PIC  X(01).                    
           05  PARM-IC-NO                PIC  X(04) VALUE SPACES.       
           05  PARM-IC-NO-NUM            PIC  9(04).                    
           05  PARM-IC-NO-DEC            PIC  S9(04) USAGE COMP.        
           05  PARM-THERM-CSC-ACCT-FL    PIC  X(01).                    
      *                                                                 00840000
       01  GTT-RETURN-FIELDS.                                           
P00836     05  GTT-RETURN-FIELDS-1.                                     
               10  S-RETURN-CODE-1       PIC S9(09) COMP VALUE 0.       
               10  S-THERM-PRICE         PIC S9(5)V9(6) USAGE COMP-3    
P00892                                                   VALUE 0.       
               10  S-OPTN-VALID-MNTHS    PIC S9(04) COMP VALUE 0.       
               10  S-PRIM-FACTOR-ID      PIC X(9)        VALUE SPACES.  
               10  S-CORE-RATE-PLAN-NO   PIC X(3)        VALUE SPACES.  
               10  S-RATE-CALC-TYPE-CD   PIC X(2)        VALUE SPACES.  
               10  S-CSC-AMT             PIC S9(5)V9(6) USAGE COMP-3    
P00892                                                   VALUE 0.       
               10  S-CSC-REFND-FL        PIC X(1)        VALUE SPACES.  
               10  S-CSC-MNTHS           PIC S9(4) COMP  VALUE 0.       
               10  S-FF-DURATION-REM     PIC S9(4) COMP  VALUE 0.       
               10  S-TIER-ACCT-TYPE-CD   PIC X(1)        VALUE SPACES.  
               10  S-WEB-RENEWAL-FL      PIC X(1)        VALUE SPACES.  
               10  S-RATE-DEFINITION-CD  PIC X(1)        VALUE SPACES.  
P00836         10  S-CURR-EXT-DESC-LONG.                                
P00836             49 S-CURR-EXT-DESC-LONG-LEN                          
P00836                                   PIC S9(4) COMP SYNC VALUE +0.  
P00836             49 S-CURR-EXT-DESC-LONG-TEXT                         
P00836                                   PIC X(255)      VALUE SPACES.  
P00211         10  S-PEND-OPT-EXIST-FL   PIC X(1)        VALUE SPACES.  
P00211         10  S-SHOW-RENEWAL-OPT    PIC X(1)        VALUE SPACES.  
P00836         10  S-PEND-EXT-DESC-LONG.                                
P00836             49 S-PEND-EXT-DESC-LONG-LEN                          
P00836                                   PIC S9(4) COMP SYNC VALUE +0.  
P00836             49 S-PEND-EXT-DESC-LONG-TEXT                         
P00836                                   PIC X(255)      VALUE SPACES.  
P00680         10  S-ADJUSTABLE-FLAG     PIC X(01)       VALUE SPACES.  
P00680         10  S-CURRENT-THERM-PRICE PIC S9(5)V9(6) USAGE COMP-3    
P00680                                                   VALUE 0.       
P00805         10  S-CURR-OPT-EFF-DATE   PIC X(10)       VALUE SPACES.  
P00805         10  S-PEND-OPT-EFF-DATE   PIC X(10)       VALUE SPACES.  
P00805         10  S-SENIOR-RATE-FL      PIC X(01)       VALUE SPACES.  
P00805         10  S-IS-CURR-OPTN-FLEX   PIC X(01)       VALUE SPACES.  
A05037         10  S-CORE-RATE-PLAN-DDDC PIC S9(3)V9(2) USAGE COMP-3    
P00892                                                   VALUE 0.       
A05043         10  S-PRINT-SR-DSC-MSG-CD PIC X(02)       VALUE SPACES.  
P00836         10  S-CURR-OPT-ROR-END-DT PIC X(10)       VALUE SPACES.  
P00836         10  S-CUSTOMER-DOB        PIC X(10)       VALUE SPACES.  
P00836         10  S-SENIOR-BY-DOB-FLAG  PIC X(01)       VALUE SPACES.  
P00836         10  S-TIER-CUST-STAT-CD   PIC X(01)       VALUE SPACES.  
P00836         10  S-CODE-REVENUE-CLASS  PIC X(03)       VALUE SPACES.  
P00836         10  S-SPCL-OFFER-TYPE-CD  PIC X(02)       VALUE SPACES.  
P00892         10  S-PEND-OPT-THRM-PRC   PIC S9(5)V9(6) USAGE COMP-3    
P00892                                                   VALUE 0.       
P00892         10  S-PEND-OPT-CSC-AMT    PIC S9(5)V9(6) USAGE COMP-3    
P00892                                                   VALUE 0.       
P00892         10  S-PEND-OPT-EXT-FEE    PIC S9(5)V9(6) USAGE COMP-3    
P00892                                                   VALUE 0.       
P00892         10  S-PEND-OPT-ARMSG-FL   PIC X(01)       VALUE 'N'.     
P00892         10  S-CURR-OPT-ARMSG-FL   PIC X(01)       VALUE 'N'.     
P00892         10  S-SEASONAL-FL         PIC X(01)       VALUE ' '.     
P00892         10  S-PEND-OPT-ROR-END-DT PIC X(10)       VALUE SPACES.  
P00892         10  S-PEND-WEB-DESC-LONG.                                
P00892             49 S-PEND-WEB-DESC-LONG-LEN                          
P00892                                   PIC S9(4) COMP SYNC VALUE +0.  
P00892             49 S-PEND-WEB-DESC-LONG-TXT                          
P00892                                   PIC X(255)      VALUE SPACES.  
P00836         10  S-PEND-WMKT-DESC-LONG.                               
P00836             49 S-PEND-WMKT-DESC-LONG-LEN                         
P00836                                   PIC S9(4) COMP SYNC VALUE +0.  
P00836             49 S-PEND-WMKT-DESC-LONG-TEXT                        
P00836                                   PIC X(1024)     VALUE SPACES.  
P836MS         10  S-CURR-WMKT-DESC-LONG.                               
P836MS             49 S-CURR-WMKT-DESC-LONG-LEN                         
P836MS                                   PIC S9(4) COMP SYNC VALUE +0.  
P836MS             49 S-CURR-WMKT-DESC-LONG-TEXT                        
P836MS                                   PIC X(1024)     VALUE SPACES.  
P836MS         10  S-CURR-OPT-EXT-FEE    PIC S9(5)V9(6) USAGE COMP-3    
P836MS                                                   VALUE 0.       
P836MS         10  S-CURR-RATE-EXP-DT    PIC X(10)       VALUE SPACES.  
P836MS         10  S-CURR-RATE-EXP-TXT   PIC X(14)       VALUE SPACES.  
P836MS         10  S-PEND-RATE-EFF-TXT   PIC X(14)       VALUE SPACES.  
P892NW         10  S-CURR-OPT-AR-ELGBL   PIC X(01)       VALUE 'N'.     
P892NW         10  S-AR-CALL-BY-DATE     PIC X(10)       VALUE SPACES.  
P836TR         10  S-XFER-RATE-TITLE-1   PIC X(50)       VALUE SPACES.  
P836TR         10  S-XFER-RATE-TITLE-2   PIC X(50)       VALUE SPACES.  
                                                                        
P00836     05  GTT-RETURN-FIELDS-2.                                     
P00836         10 S-RETURN-CODE-2        PIC S9(9) COMP  VALUE 0.       
P00836         10 S-BUS-RULE-MSG-ID      PIC X(10)       VALUE SPACES.  
P00836         10 S-BUS-RULE-RESULT-CD   PIC X(10)       VALUE SPACES.  
P00836         10 S-BUS-RULE-XREF-ID     PIC X(26)       VALUE SPACES.  
P00836         10 S-MESSAGE-PARMS.                                      
P00836            49 S-MESSAGE-PARMS-LEN PIC S9(4) COMP SYNC VALUE +0.  
P00836            49 S-MESSAGE-PARMS-TEXT                               
P00836                                   PIC X(300)      VALUE SPACES.  
P00836         10 S-LINK-PARMS           PIC X(200)      VALUE SPACES.  
                                                                        
       01  WS-GENERAL-WORKING-STORAGE.                                  
P892NW**** MCSCB063 ALSO DEFINED IN CWS00328, SO COMMENTING THIS ONE.           
P892NW**** 05  MCSCB063                  PIC X(08) VALUE 'MCSCB063'.    01030000
P892NW     05  MCSCB328                  PIC X(08) VALUE 'MCSCB328'.    
P892NW     05  RETURN-CODE-328           PIC S9(04) COMP VALUE 0.       
           05  RS-RETURN-CODE-1          PIC S9(04) COMP VALUE 0.       
P00836     05  RS-RETURN-CODE-2          PIC S9(04) COMP VALUE 0.       
P00836     05  WS-GTT01-DECLARED         PIC X(01) VALUE 'N'.           
P00836     05  WS-GTT02-DECLARED         PIC X(01) VALUE 'N'.           
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           05  WS-ACCOUNT-NO-JST         PIC X(13) JUSTIFIED RIGHT.     
           05  WS-IC-NO-JST              PIC X(04) JUSTIFIED RIGHT.     
P00836     05  WS-CURR-EXT-DESC-LONG.                                   
P00836         49 WS-CURR-EXT-DESC-LONG-LEN                             
P00836                                   PIC S9(4) COMP SYNC VALUE +0.  
P00836         49 WS-CURR-EXT-DESC-LONG-TEXT                            
P00836                                   PIC X(255) VALUE SPACES.       
           05  WS-TIER-ACCT-TYPE-CD      PIC  X(1) VALUE SPACES.        
           05  WS-WEB-RENEWAL-FL         PIC  X(1) VALUE SPACES.        
           05  WS-RATE-DEFINITION-CD     PIC  X(1) VALUE SPACES.        
P00211     05  WS-PEND-OPT-EXIST-FL      PIC  X(1) VALUE SPACES.        
P00211     05  WS-SHOW-RENEWAL-OPT       PIC  X(1) VALUE SPACES.        
P00836     05  WS-PEND-EXT-DESC-LONG.                                   
P00836         49 WS-PEND-EXT-DESC-LONG-LEN                             
P00836                                   PIC S9(4) COMP SYNC VALUE +0.  
P00836         49 WS-PEND-EXT-DESC-LONG-TEXT                            
P00836                                   PIC X(255) VALUE SPACES.       
P00892     05  WS-PEND-WEB-DESC-LONG.                                   
P00892         49 WS-PEND-WEB-DESC-LONG-LEN                             
P00892                                   PIC S9(4) COMP SYNC VALUE +0.  
P00892         49 WS-PEND-WEB-DESC-LONG-TXT                             
P00892                                   PIC X(255) VALUE SPACES.       
P00836     05  WS-PEND-WMKT-DESC-LONG.                                  
P00836         49 WS-PEND-WMKT-DESC-LONG-LEN                            
P00836                                   PIC S9(4) COMP SYNC VALUE +0.  
P00836         49 WS-PEND-WMKT-DESC-LONG-TEXT                           
P00836                                   PIC X(1024) VALUE SPACES.      
P836MS     05  WS-CURR-WMKT-DESC-LONG.                                  
P836MS         49 WS-CURR-WMKT-DESC-LONG-LEN                            
P836MS                                   PIC S9(4) COMP SYNC VALUE +0.  
P836MS         49 WS-CURR-WMKT-DESC-LONG-TEXT                           
P836MS                                   PIC X(1024) VALUE SPACES.      
P836MS     05  WS-CURR-OPT-EXT-FEE       PIC S9(5)V9(6) USAGE COMP-3    
P836MS                                             VALUE 0.             
P836MS     05  WS-PEND-RATE-EFF-TXT      PIC X(14) VALUE SPACES.        
P00680     05  WS-ADJUSTABLE-FLAG        PIC X(01) VALUE SPACES.        
P00680     05  WS-CURRENT-THERM-PRICE    PIC S9(5)V9(6) USAGE COMP-3    
                                                   VALUE 0.             
P00805     05  WS-REV-MONTH-NUM          PIC 9(06) VALUE ZEROES.        
P00805     05  WS-REV-MONTH-CHAR         REDEFINES WS-REV-MONTH-NUM     
P00805                                   PIC X(06).                     
P00805     05  WS-CURR-OPT-EFF-DATE      PIC X(10) VALUE SPACES.        
P00805     05  WS-PEND-OPT-EFF-DATE      PIC X(10) VALUE SPACES.        
P00805     05  WS-SENIOR-RATE-FL         PIC X(01) VALUE SPACES.        
P00805     05  WS-IS-CURR-OPTN-FLEX      PIC X(01) VALUE SPACES.        
P00805     05  WS-SENIOR-RATE            PIC X(01).                     
P00805         88 SENIOR-RATE                      VALUE 'Y' 'S'.       
A05037     05  WS-CORE-RATE-PLAN-DDDC    PIC S9(3)V9(2) USAGE COMP-3    
A05037                                             VALUE 0.             
A05043     05  WS-PRINT-SR-DSC-MSG-CD    PIC X(02) VALUE SPACES.        
P00836     05  WS-CURR-OPT-ROR-END-DT    PIC X(10) VALUE SPACES.        
P00892     05  WS-PEND-OPT-ROR-END-DT    PIC X(10) VALUE SPACES.        
P00836     05  WS-NO-OF-YEARS            PIC S9(4) USAGE COMP VALUE 0.  
P00836     05  WS-CUSTOMER-DOB           PIC X(10) VALUE SPACES.        
P00836     05  WS-CUSTOMER-DOB-YYYY      PIC 9(04) VALUE ZEROS.         
P00836     05  WS-CUSTOMER-DOB-MM        PIC 9(02) VALUE ZEROS.         
P00836     05  WS-CUSTOMER-DOB-DD        PIC 9(02) VALUE ZEROS.         
P00836     05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
P00836     05  WS-CURRENT-DATE-YYYY      PIC 9(04) VALUE ZEROS.         
P00836     05  WS-CURRENT-DATE-MM        PIC 9(02) VALUE ZEROS.         
P00836     05  WS-CURRENT-DATE-DD        PIC 9(02) VALUE ZEROS.         
P00836     05  WS-SENIOR-BY-DOB-FLAG     PIC X(01) VALUE SPACES.        
P00836     05  WS-3DAY-ROR-DAYS          PIC S9(4) USAGE COMP VALUE +0. 
P00892     05  WS-90DAY-GRACE-PERIOD     PIC S9(4) USAGE COMP VALUE +0. 
P00836     05  WS-SCANA-SENIOR-AGE       PIC S9(4) USAGE COMP VALUE +0. 
P00836     05  WS-ROR-RESULT-DATE        PIC X(10) VALUE SPACES.        
P00836     05  WS-RULE-XREF-ID           PIC X(26) VALUE SPACES.        
P00836     05  WS-RULE-RESULT-CD         PIC X(10) VALUE SPACES.        
P00836     05  WS-RULE-ID                PIC X(10) VALUE SPACES.        
P00836     05  WS-RULE-MESSAGE-ID        PIC X(10) VALUE SPACES.        
P00836     05  WS-COMP-NO                PIC X(02) VALUE SPACES.        
P00836     05  WS-FORMAT-DUR-REM         PIC Z9    VALUE ZEROS.         
P00836     05  WS-RENEW-BY-DATE          PIC X(10) VALUE SPACES.        
P00836     05  WS-MM                     PIC X(02) VALUE SPACES.        
P00836     05  WS-MONTH                  PIC X(11) VALUE SPACES.        
P00836     05  WS-REV-MONTH-DT           PIC X(10) VALUE SPACES.        
P00836     05  WS-REV-MONTH-PLUS-DT      PIC X(10) VALUE SPACES.        
P00836     05  WS-REV-MONTH-PLUS-NUM     PIC 9(06) VALUE ZEROES.        
P00836     05  WS-DURATION-REM-NUM       PIC S9(9) COMP VALUE 0.        
P00836     05  WS-NULL-01                PIC S9(4) COMP VALUE +0.       
P00836     05  WS-NULL-02                PIC S9(4) COMP VALUE +0.       
P00836     05  WS-NULL-03                PIC S9(4) COMP VALUE +0.       
P836MS     05  WS-NULL-04                PIC S9(4) COMP VALUE +0.       
P00836     05  WS-PARM-DT                PIC X(10) VALUE SPACES.        
P00836     05  WS-FMT-THERM-PRICE        PIC $9.9(4)  VALUE ZEROS.      
P00836     05  WS-FMT-DDDC               PIC Z9.9(2)  VALUE ZEROS.      
P00836     05  WS-FACTOR                 PIC S9(09)V9(06) USAGE COMP-3  
P00836                                                VALUE +0.         
P836MS     05  WS-FF-EFF-DATE-TO         PIC X(10)    VALUE SPACES.     
P892NW     05  WS-CTR                    PIC S9(3)    VALUE 0.          
P892NW     05  WS-AR-CALL-BY-DATE.                                      
P892NW         10 WS-AR-CDATE-MM         PIC X(02).                     
P892NW         10 WS-AR-CDATE-F01        PIC X(01) VALUE '/'.           
P892NW         10 WS-AR-CDATE-DD         PIC X(02).                     
P892NW         10 WS-AR-CDATE-F02        PIC X(01) VALUE '/'.           
P892NW         10 WS-AR-CDATE-YYYY       PIC X(04).                     
OTPMSG     05  WS-POOL-GO-DATE           PIC X(10) VALUE SPACES.        
OTPMSG     05  WS-OUTER-POOL-MSG-FL      PIC X(01) VALUE SPACES.        
                                                                        
P00836 01  COUNTER-FIELDS.                                              
P00836     05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
P00836     05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
P00836     05  BUS-RULE-SW               PIC X(01) VALUE 'Y'.           
P00836         88 BUS-RULE-NOT-FOUND               VALUE 'N'.           
P00836         88 BUS-RULE-FOUND                   VALUE 'Y'.           
P00836     05  END-SEARCH-SW             PIC X(01) VALUE 'Y'.           
P00836         88 NOT-END-OF-SEARCH                VALUE 'N'.           
P00836         88 END-OF-SEARCH                    VALUE 'Y'.           
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04099'.    
P00836     05  3DAY-ROR-DAYS             PIC X(07) VALUE '3DAYROR'.     
P00892     05  90-DAY-GRACE-PERIOD       PIC X(16)                      
P00892                                      VALUE '90DAYGRACEPERIOD'.   
P00836     05  SCANA-SR-AGE              PIC X(17) VALUE                
P00836                                            'SCANA SENIOR AGE'.   
P00211     05  WS-PENDING-OPTION         PIC X(01) VALUE 'P'.           
P00892     05  WS-EXIT-FEE-FCTR          PIC X(09) VALUE 'EXIT FEE'.    
P00680     05  WS-ACTIVE                 PIC X(01) VALUE 'A'.           
P00836     05  WS-PENDING                PIC X(01) VALUE 'P'.           
P00680     05  WS-ZERO                   PIC S9(4) COMP VALUE 0.        
P00680     05  WS-YES                    PIC X(01) VALUE 'Y'.           
P00680     05  WS-NO                     PIC X(01) VALUE 'N'.           
                                                                        
P00836 01  WS-RULES-TABLE.                                              
P00836     05  BUS-RULES                 OCCURS 300                     
P00836                                   INDEXED BY BUS-RULE-INDX.      
P00836         10  BUS-RULE-ID           PIC X(10).                     
P00836         10  BUS-RULE-XREF-ID      PIC X(26).                     
P00836         10  BUS-RULE-COMPANY-NO   PIC X(02).                     
P00836         10  BUS-RULE-MESSAGE-ID   PIC X(10).                     
P00836         10  BUS-RULE-RESULT-CD    PIC X(10).                     
                                                                        
      ******************************************************************01260000
      *    DB2 INCLUDES                                                *01270000
      ******************************************************************01280000
           EXEC SQL                                                     01290000
              INCLUDE SQLCA                                             01300000
           END-EXEC.                                                    01310000
                                                                        
OTPMSG******************************************************************01330000
OTPMSG* CSS_JOB_PARM, G6                                               *01340000
OTPMSG******************************************************************01350000
OTPMSG     EXEC SQL                                                     01360000
OTPMSG        INCLUDE TBJBPARM                                          01370000
OTPMSG     END-EXEC.                                                    01380000
                                                                        
      ******************************************************************01330000
      * CRM_RT_PKG_OPTION , FI                                         *01340000
      ******************************************************************01350000
           EXEC SQL                                                     01360000
              INCLUDE TBRTPKGO                                          01370000
           END-EXEC.                                                    01380000
                                                                        
      ******************************************************************01400000
      * CRM_TIER_ACCT_TYPE, TT                                         *01410000
      ******************************************************************01420000
           EXEC SQL                                                     01430000
              INCLUDE TBTIACTP                                          01440000
           END-EXEC.                                                    01450000
                                                                        
      ******************************************************************01470000
      * CSS_ACCT_MKT_TIER, DD                                          *01480000
      ******************************************************************01490000
           EXEC SQL                                                     01500000
              INCLUDE TBMKTIER                                          01510000
           END-EXEC.                                                    01520000
                                                                        
      ******************************************************************01540000
P00211* CSS_ACCT_RTPK_AGR, DF                                          *01550000
P00211******************************************************************01560000
P00211     EXEC SQL                                                     01570000
P00211        INCLUDE TBACCTRG                                          01580000
P00211     END-EXEC.                                                    01590000
P00211                                                                  
      ******************************************************************01610000
      * CSS_RATE_PLAN_DESC, RD                                         *01620000
      ******************************************************************01630000
           EXEC SQL                                                     01640000
              INCLUDE TBRTDESC                                          01650000
           END-EXEC.                                                    01660000
                                                                        
P00836******************************************************************01610000
P00836* CSS_BUS_RULE_XREF, 1T                                          *01620000
P00836******************************************************************01630000
P00836     EXEC SQL                                                             
P00836        INCLUDE TBRULXRF                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836******************************************************************01610000
P00836* CSS_BUS_RULE_ACTN, 1S                                          *01620000
P00836******************************************************************01630000
P00836     EXEC SQL                                                             
P00836        INCLUDE TBRULACT                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836******************************************************************00882512
P00836* CSS_ACCOUNT, AT                                                *00882612
P00836******************************************************************00882712
P00836     EXEC SQL                                                     00882812
P00836        INCLUDE TBACCT                                            00882912
P00836     END-EXEC.                                                    00883012
                                                                        
OTPOOL******************************************************************02620000
OTPOOL*    CSS_LOCAL_OFFICE - B1                                       *02630000
OTPOOL******************************************************************02640000
OTPOOL     EXEC SQL                                                     02660000
OTPOOL        INCLUDE TBLOCOFC                                          02670000
OTPOOL     END-EXEC.                                                    02680000
                                                                        
P00836******************************************************************        
P00836*    CSS_UTIL_ENVRNMT   UT                                       *        
P00836******************************************************************        
P00836     EXEC SQL                                                             
P00836        INCLUDE TBUTLENV                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836******************************************************************        
P00836*    CSS_BILL_WINDOW    BN                                       *        
P00836******************************************************************        
P00836     EXEC SQL                                                             
P00836        INCLUDE TBBILWDW                                                  
P00836     END-EXEC.                                                            
                                                                        
P00836*****************************************************************         
P00836* CSS_DELINQUENCY, C8                                           *         
P00836*****************************************************************         
P00836      EXEC SQL                                                            
P00836        INCLUDE TBDELQ                                                    
P00836      END-EXEC.                                                           
                                                                        
P00836*****************************************************************         
P00836* CRM_RT_PKG_OFFER, FG                                          *         
P00836*****************************************************************         
P00836      EXEC SQL                                                            
P00836        INCLUDE TBRTPOFF                                                  
P00836      END-EXEC.                                                           
                                                                        
P00892*****************************************************************         
P00892* CRM_OPT_ATTR_INCTV, HQ                                        *         
P00892*****************************************************************         
P00892      EXEC SQL                                                            
P00892        INCLUDE TBOPTATT                                                  
P00892      END-EXEC.                                                           
                                                                        
P00892*****************************************************************         
P00892* CSS_ACCT_MISC_INFO, TA                                        *         
P00892*****************************************************************         
P00892      EXEC SQL                                                            
P00892          INCLUDE TBATMISC                                                
P00892      END-EXEC.                                                           
P00892                                                                  
      ******************************************************************01680000
      *    ERROR HANDLING COPY BOOK                                    *01690000
      ******************************************************************01700000
           EXEC SQL                                                     01710000
               INCLUDE CWSX0010                                         01720000
           END-EXEC.                                                    01730000
                                                                        
      ******************************************************************01750000
      *    SQL ERROR CHECKING COPYBOOK                                 *01760000
      ******************************************************************01770000
           COPY CWS00303.                                               01780000
                                                                        
      ******************************************************************01800000
      *    DB2 ERRROR PROCESSING COPYBOOK                              *01810000
      ******************************************************************01820000
           COPY CWSSP001.                                               01830000
                                                                        
      ******************************************************************01850000
      *    COPY BOOK TO GET OPTION CODE DETAILS                        *01860000
      ******************************************************************01870000
            EXEC SQL                                                    01880000
              INCLUDE CWS00063                                          01890000
            END-EXEC.                                                   01900000
                                                                        
P892NW******************************************************************        
P892NW*    WORKING STORAGE COPYBOOK FOR MCSCB328                       *        
P892NW******************************************************************        
P892NW     EXEC SQL                                                             
P892NW        INCLUDE CWS00328                                                  
P892NW     END-EXEC.                                                            
                                                                        
P836NW******************************************************************        
P836NW*    CODES DATA PRESENT LAYOUT                                   *        
P836NW******************************************************************        
P836NW     COPY CWS00056.                                                       
                                                                        
P00836******************************************************************01260000
P00836*    CURSOR DECLARATIONS                                         *01270000
P00836******************************************************************01280000
P00836     EXEC SQL                                                     
P00836          DECLARE RULE-CURSOR CURSOR FOR                          
P00836           SELECT [1T].BUS_RULE_ID                                  
P00836                 ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1T].BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                             
P00836                 ,[1T].COMPANY_NO                                   
P00836                 ,[1S].RULE_MESSAGE_ID                              
P00836                 ,[1S].RULE_RESULT_CD                               
P00836             FROM CSS_BUS_RULE_XREF [1T] WITH(READUNCOMMITTED)            
P00836             JOIN CSS_BUS_RULE_ACTN [1S] WITH(READUNCOMMITTED)            
P00836               ON [1S].BUS_RULE_XREF_ID = [1T].BUS_RULE_XREF_ID       
P00836            WHERE BUS_PROCESS_ID = 'RATERENEW'                    
P00836              AND APPLICATION_ID = 'WEB'                          
P00836                                                           
P00836              FOR READ ONLY                                      
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE RULE-CURSOR CURSOR FOR                                  
MFA-TR*          SELECT 1T.BUS_RULE_ID                                          
MFA-TR*                ,1T.BUS_RULE_XREF_ID                                     
MFA-TR*                ,1T.COMPANY_NO                                           
MFA-TR*                ,1S.RULE_MESSAGE_ID                                      
MFA-TR*                ,1S.RULE_RESULT_CD                                       
MFA-TR*            FROM CSS_BUS_RULE_XREF 1T                                    
MFA-TR*            JOIN CSS_BUS_RULE_ACTN 1S                                    
MFA-TR*              ON 1S.BUS_RULE_XREF_ID = 1T.BUS_RULE_XREF_ID               
MFA-TR*           WHERE BUS_PROCESS_ID = 'RATERENEW'                            
MFA-TR*             AND APPLICATION_ID = 'WEB'                                  
MFA-TR*            WITH UR                                                      
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*           QUERYNO 7000                                                  
MFA-TR*    END-EXEC.                                                            
P00836                                                                  
       LINKAGE SECTION.                                                 
       01  LINK-OPTION-CD                PIC X(12).                     
       01  LINK-ACCOUNT-NO               PIC X(13).                     
       01  LINK-CODE-UTIL-TYPE           PIC X(01).                     
       01  LINK-IC-NO                    PIC X(04).                     
       01  LINK-THERM-CSC-ACCT-FL        PIC X(01).                     
                                                                        
       PROCEDURE DIVISION USING LINK-OPTION-CD                          
                                LINK-ACCOUNT-NO                         
                                LINK-CODE-UTIL-TYPE                     
                                LINK-IC-NO                              
                                LINK-THERM-CSC-ACCT-FL.                 
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************02190000
      **                                                              **02200000
      **    0000-MAINLINE                                             **02210000
      **                                                              **02220000
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **02230000
      **                                                              **02240000
      ******************************************************************02250000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER    THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INIT-SERVER.                                                
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
               SELECT                                                   
                  RETURN_CODE                 AS RETURN_CODE            
                 ,THERM_PRICE                 AS THERM_PRICE            
                 ,OPTN_VALID_MNTHS            AS OPTN_VALID_MNTHS       
                 ,LTRIM(RTRIM(PRIM_FACTOR_ID))       AS PRIM_FACTOR_ID         
                 ,LTRIM(RTRIM(CORE_RATE_PLAN_NO))    AS 
           CORE_RATE_PLAN_NO      
                 ,LTRIM(RTRIM(RATE_CALC_TYPE_CD))    AS 
           RATE_CALC_TYPE_CD      
                 ,CSC_AMT                     AS CSC_AMT                
                 ,CSC_REFND_FL                AS CSC_REFND_FL           
                 ,CSC_MNTHS                   AS CSC_MNTHS              
                 ,DURATION_REM_MO             AS DURATION_REM_MO        
                 ,TIER_ACCT_TYPE_CD           AS TIER_ACCT_TYPE_CD      
                 ,WEB_RENEWAL_FL              AS WEB_RENEWAL_FL         
                 ,RATE_DEFINITION_CD          AS RATE_DEFINITION_CD     
                 ,LTRIM(RTRIM(CURR_EXT_DESC_LONG))   AS 
           CURR_EXT_DESC_LONG     
P00211           ,PEND_OPT_EXIST_FL           AS PEND_OPT_EXIST_FL      
P00211           ,SHOW_RENEWAL_OPT            AS SHOW_RENEWAL_OPT       
P00211           ,LTRIM(RTRIM(PEND_EXT_DESC_LONG))   AS 
           PEND_EXT_DESC_LONG     
P00680           ,ADJUSTABLE_FLAG             AS ADJUSTABLE_FLAG        
P00680           ,CURRENT_THERM_PRICE         AS CURRENT_THERM_PRICE    
P00805           ,LTRIM(RTRIM(CURR_OPT_EFF_DATE))    AS 
           CURR_OPT_EFF_DATE      
P00805           ,LTRIM(RTRIM(PEND_OPT_EFF_DATE))    AS 
           PEND_OPT_EFF_DATE      
P00805           ,LTRIM(RTRIM(SENIOR_RATE_FL))       AS SENIOR_RATE_FL         
P00805           ,LTRIM(RTRIM(IS_CURR_OPTN_FLEX))    AS 
           IS_CURR_OPTN_FLEX      
A05037           ,CORE_RATE_PLAN_DDDC         AS CORE_RATE_PLAN_DDDC    
A05043           ,LTRIM(RTRIM(PRINT_SR_DSC_MSG_CD))  AS 
           PRINT_SR_DSC_MSG_CD    
P00836           ,LTRIM(RTRIM(CURR_OPT_ROR_END_DT))  AS 
           CURR_OPT_ROR_END_DT    
P00836           ,LTRIM(RTRIM(CUSTOMER_DOB))         AS CUSTOMER_DOB           
P00836           ,LTRIM(RTRIM(SENIOR_BY_DOB_FLAG))   AS 
           SENIOR_BY_DOB_FLAG     
P00836           ,LTRIM(RTRIM(TIER_CUST_STAT_CD))    AS 
           TIER_CUST_STAT_CD      
P00836           ,LTRIM(RTRIM(CODE_REVENUE_CLASS))   AS 
           CODE_REVENUE_CLASS     
P00836           ,LTRIM(RTRIM(SPCL_OFFER_TYPE_CD))   AS 
           SPCL_OFFER_TYPE_CD     
P00892           ,PEND_OPT_THRM_PRC           AS PEND_OPT_THRM_PRC      
P00892           ,PEND_OPT_CSC_AMT            AS PEND_OPT_CSC_AMT       
P00892           ,PEND_OPT_EXT_FEE            AS PEND_OPT_EXT_FEE       
P00892           ,LTRIM(RTRIM(PEND_OPT_ARMSG_FL))    AS 
           PEND_OPT_ARMSG_FL      
P00892           ,LTRIM(RTRIM(CURR_OPT_ARMSG_FL))    AS 
           CURR_OPT_ARMSG_FL      
P00892           ,LTRIM(RTRIM(SEASONAL_FL))          AS SEASONAL_FL            
P00892           ,LTRIM(RTRIM(PEND_OPT_ROR_END_DT))  AS 
           PEND_OPT_ROR_END_DT    
P00892           ,LTRIM(RTRIM(PEND_WEB_DESC_LONG))   AS 
           PEND_WEB_DESC_LONG     
P00836           ,LTRIM(RTRIM(PEND_WMKT_DESC_LONG))  AS 
           PEND_WMKT_DESC_LONG    
P836MS           ,LTRIM(RTRIM(CURR_WMKT_DESC_LONG))  AS 
           CURR_WMKT_DESC_LONG    
P836MS           ,CURR_OPT_EXT_FEE            AS CURR_OPT_EXT_FEE       
P836MS           ,LTRIM(RTRIM(CURR_RATE_EXP_DT))     AS CURR_RATE_EXP_DT       
P836MS           ,LTRIM(RTRIM(CURR_RATE_EXP_TXT))    AS 
           CURR_RATE_EXP_TXT      
P836MS           ,LTRIM(RTRIM(PEND_RATE_EFF_TXT))    AS 
           PEND_RATE_EFF_TXT      
P892NW           ,LTRIM(RTRIM(CURR_OPT_AR_ELGBL))    AS 
           CURR_OPT_AR_ELGBL      
P892NW           ,LTRIM(RTRIM(AR_CALL_BY_DATE))      AS AR_CALL_BY_DATE        
P836TR           ,LTRIM(RTRIM(XFER_RATE_TITLE_1))    AS 
           XFER_RATE_TITLE_1      
P836TR           ,LTRIM(RTRIM(XFER_RATE_TITLE_2))    AS 
           XFER_RATE_TITLE_2      
                FROM #CSR04099_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     02380000
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                          02390000
MFA-TR*        SELECT                                                   02400000
MFA-TR*           RETURN_CODE                 AS RETURN_CODE            02410000
MFA-TR*          ,THERM_PRICE                 AS THERM_PRICE            02420000
MFA-TR*          ,OPTN_VALID_MNTHS            AS OPTN_VALID_MNTHS       02430000
MFA-TR*          ,STRIP(PRIM_FACTOR_ID)       AS PRIM_FACTOR_ID         02440000
MFA-TR*          ,STRIP(CORE_RATE_PLAN_NO)    AS CORE_RATE_PLAN_NO      02450000
MFA-TR*          ,STRIP(RATE_CALC_TYPE_CD)    AS RATE_CALC_TYPE_CD      02460000
MFA-TR*          ,CSC_AMT                     AS CSC_AMT                02470000
MFA-TR*          ,CSC_REFND_FL                AS CSC_REFND_FL           02480000
MFA-TR*          ,CSC_MNTHS                   AS CSC_MNTHS              02490000
MFA-TR*          ,DURATION_REM_MO             AS DURATION_REM_MO        02500000
MFA-TR*          ,TIER_ACCT_TYPE_CD           AS TIER_ACCT_TYPE_CD      02510000
MFA-TR*          ,WEB_RENEWAL_FL              AS WEB_RENEWAL_FL         02520000
MFA-TR*          ,RATE_DEFINITION_CD          AS RATE_DEFINITION_CD     02530000
MFA-TR*          ,STRIP(CURR_EXT_DESC_LONG)   AS CURR_EXT_DESC_LONG     02540000
MFA-TR*          ,PEND_OPT_EXIST_FL           AS PEND_OPT_EXIST_FL      02550000
MFA-TR*          ,SHOW_RENEWAL_OPT            AS SHOW_RENEWAL_OPT       02551000
MFA-TR*          ,STRIP(PEND_EXT_DESC_LONG)   AS PEND_EXT_DESC_LONG     02552000
MFA-TR*          ,ADJUSTABLE_FLAG             AS ADJUSTABLE_FLAG        02553000
MFA-TR*          ,CURRENT_THERM_PRICE         AS CURRENT_THERM_PRICE    02554000
MFA-TR*          ,STRIP(CURR_OPT_EFF_DATE)    AS CURR_OPT_EFF_DATE      02555003
MFA-TR*          ,STRIP(PEND_OPT_EFF_DATE)    AS PEND_OPT_EFF_DATE      02556003
MFA-TR*          ,STRIP(SENIOR_RATE_FL)       AS SENIOR_RATE_FL         02557004
MFA-TR*          ,STRIP(IS_CURR_OPTN_FLEX)    AS IS_CURR_OPTN_FLEX      02558006
MFA-TR*          ,CORE_RATE_PLAN_DDDC         AS CORE_RATE_PLAN_DDDC    02558007
MFA-TR*          ,STRIP(PRINT_SR_DSC_MSG_CD)  AS PRINT_SR_DSC_MSG_CD    02558008
MFA-TR*          ,STRIP(CURR_OPT_ROR_END_DT)  AS CURR_OPT_ROR_END_DT            
MFA-TR*          ,STRIP(CUSTOMER_DOB)         AS CUSTOMER_DOB                   
MFA-TR*          ,STRIP(SENIOR_BY_DOB_FLAG)   AS SENIOR_BY_DOB_FLAG             
MFA-TR*          ,STRIP(TIER_CUST_STAT_CD)    AS TIER_CUST_STAT_CD              
MFA-TR*          ,STRIP(CODE_REVENUE_CLASS)   AS CODE_REVENUE_CLASS             
MFA-TR*          ,STRIP(SPCL_OFFER_TYPE_CD)   AS SPCL_OFFER_TYPE_CD             
MFA-TR*          ,PEND_OPT_THRM_PRC           AS PEND_OPT_THRM_PRC      02550000
MFA-TR*          ,PEND_OPT_CSC_AMT            AS PEND_OPT_CSC_AMT       02550000
MFA-TR*          ,PEND_OPT_EXT_FEE            AS PEND_OPT_EXT_FEE       02550000
MFA-TR*          ,STRIP(PEND_OPT_ARMSG_FL)    AS PEND_OPT_ARMSG_FL              
MFA-TR*          ,STRIP(CURR_OPT_ARMSG_FL)    AS CURR_OPT_ARMSG_FL              
MFA-TR*          ,STRIP(SEASONAL_FL)          AS SEASONAL_FL                    
MFA-TR*          ,STRIP(PEND_OPT_ROR_END_DT)  AS PEND_OPT_ROR_END_DT            
MFA-TR*          ,STRIP(PEND_WEB_DESC_LONG)   AS PEND_WEB_DESC_LONG     06222000
MFA-TR*          ,STRIP(PEND_WMKT_DESC_LONG)  AS PEND_WMKT_DESC_LONG            
MFA-TR*          ,STRIP(CURR_WMKT_DESC_LONG)  AS CURR_WMKT_DESC_LONG            
MFA-TR*          ,CURR_OPT_EXT_FEE            AS CURR_OPT_EXT_FEE       02550000
MFA-TR*          ,STRIP(CURR_RATE_EXP_DT)     AS CURR_RATE_EXP_DT               
MFA-TR*          ,STRIP(CURR_RATE_EXP_TXT)    AS CURR_RATE_EXP_TXT              
MFA-TR*          ,STRIP(PEND_RATE_EFF_TXT)    AS PEND_RATE_EFF_TXT              
MFA-TR*          ,STRIP(CURR_OPT_AR_ELGBL)    AS CURR_OPT_AR_ELGBL              
MFA-TR*          ,STRIP(AR_CALL_BY_DATE)      AS AR_CALL_BY_DATE                
MFA-TR*          ,STRIP(XFER_RATE_TITLE_1)    AS XFER_RATE_TITLE_1              
MFA-TR*          ,STRIP(XFER_RATE_TITLE_2)    AS XFER_RATE_TITLE_2              
MFA-TR*         FROM SESSION.CSR04099_R1                                02560000
MFA-TR*    END-EXEC.                                                    02570000
                                                                        
P00836     EXEC SQL                                                     
P00836        DECLARE C2 CURSOR  FOR                         
P00836         SELECT RETURN_CODE             AS RETURN_CODE            
P00836               ,LTRIM(RTRIM(BUS_RULE_MSG_ID))  AS BUS_RULE_MSG_ID        
P00836               ,LTRIM(RTRIM(RULE_RESULT_CD))   AS RULE_RESULT_CD         
P00836               ,LTRIM(RTRIM(BUS_RULE_XREF_ID)) AS BUS_RULE_XREF_ID       
P00836               ,LTRIM(RTRIM(MESSAGE_PARMS))    AS MESSAGE_PARMS          
P00836               ,LTRIM(RTRIM(LINK_PARMS))       AS LINK_PARMS             
P00836          FROM #CSR04099_R2                                
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT RETURN_CODE             AS RETURN_CODE                    
MFA-TR*              ,STRIP(BUS_RULE_MSG_ID)  AS BUS_RULE_MSG_ID                
MFA-TR*              ,STRIP(RULE_RESULT_CD)   AS RULE_RESULT_CD                 
MFA-TR*              ,STRIP(BUS_RULE_XREF_ID) AS BUS_RULE_XREF_ID               
MFA-TR*              ,STRIP(MESSAGE_PARMS)    AS MESSAGE_PARMS                  
MFA-TR*              ,STRIP(LINK_PARMS)       AS LINK_PARMS                     
MFA-TR*         FROM SESSION.CSR04099_R2                                02560000
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE LINK-OPTION-CD           TO PARM-OPTION-CD              
           MOVE LINK-ACCOUNT-NO          TO PARM-ACCOUNT-NO             
           MOVE LINK-CODE-UTIL-TYPE      TO PARM-CODE-UTIL-TYPE         
           MOVE LINK-IC-NO               TO PARM-IC-NO                  
           MOVE LINK-THERM-CSC-ACCT-FL   TO PARM-THERM-CSC-ACCT-FL      
                                                                        
           PERFORM 0100A-DECLARE-GTT                                    
              THRU 0100A-EXIT                                           
P00836     PERFORM 0100B-DECLARE-GTT                                    
P00836        THRU 0100B-EXIT                                           
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04099_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04099_R1
              (                                                          
               RETURN_CODE         INT                              
              ,THERM_PRICE         DECIMAL(11,6)                        
              ,OPTN_VALID_MNTHS    SMALLINT                             
              ,PRIM_FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CORE_RATE_PLAN_NO CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,RATE_CALC_TYPE_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,CSC_AMT             DECIMAL(11,6)                        
              ,CSC_REFND_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CSC_MNTHS           SMALLINT                             
              ,DURATION_REM_MO     SMALLINT                             
              ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
              ,WEB_RENEWAL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,RATE_DEFINITION_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,CURR_EXT_DESC_LONG VARCHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
P00211        ,PEND_OPT_EXIST_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00211        ,SHOW_RENEWAL_OPT CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,PEND_EXT_DESC_LONG VARCHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
P00680        ,ADJUSTABLE_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00680        ,CURRENT_THERM_PRICE DECIMAL(11,6)                        
P00805        ,CURR_OPT_EFF_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00805        ,PEND_OPT_EFF_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00805        ,SENIOR_RATE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
P00805        ,IS_CURR_OPTN_FLEX CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
A05037        ,CORE_RATE_PLAN_DDDC DECIMAL(5,2)                         
A05043        ,PRINT_SR_DSC_MSG_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,CURR_OPT_ROR_END_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,CUSTOMER_DOB CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
P00836        ,SENIOR_BY_DOB_FLAG CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,SPCL_OFFER_TYPE_CD CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00892        ,PEND_OPT_THRM_PRC   DECIMAL(11,6)                        
P00892        ,PEND_OPT_CSC_AMT    DECIMAL(11,6)                        
P00892        ,PEND_OPT_EXT_FEE    DECIMAL(11,6)                        
P00892        ,PEND_OPT_ARMSG_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00892        ,CURR_OPT_ARMSG_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00892        ,SEASONAL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
P00892        ,PEND_OPT_ROR_END_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00892        ,PEND_WEB_DESC_LONG VARCHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
P00836        ,PEND_WMKT_DESC_LONG VARCHAR(1024)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
P836MS        ,CURR_WMKT_DESC_LONG VARCHAR(1024)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
P836MS        ,CURR_OPT_EXT_FEE    DECIMAL(11,6)                        
P836MS        ,CURR_RATE_EXP_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P836MS        ,CURR_RATE_EXP_TXT CHAR(14)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P836MS        ,PEND_RATE_EFF_TXT CHAR(14)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P892NW        ,CURR_OPT_AR_ELGBL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P892NW        ,AR_CALL_BY_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
P836TR        ,XFER_RATE_TITLE_1 CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P836TR        ,XFER_RATE_TITLE_2 CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00836            MOVE 'Y'                  TO WS-GTT01-DECLARED        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04099_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
P00836            PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT          
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
               EXIT.                                                    
                                                                        
P00836 0100B-DECLARE-GTT.                                               
P00836                                                                  
P00836     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04099_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04099_R2
              (                                                          
P00836         RETURN_CODE         INT                              
P00836        ,BUS_RULE_MSG_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
P00836        ,RULE_RESULT_CD CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
P00836        ,BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00836        ,MESSAGE_PARMS VARCHAR(300)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
P00836        ,LINK_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2            
P00836       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLSTATE TO WS-SQLSTATE.                                
P00836     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
P00836                                                                  
P00836     IF WS-SQLSTATE = '42710'                                     
P00836        PERFORM 8000B-DELETE-GTT-ROWS      THRU 8000B-EXIT        
P00836     ELSE                                                         
P00836        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00836           MOVE 'Y'                  TO WS-GTT02-DECLARED         
P00836        ELSE                                                      
P00836           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
P00836           MOVE SQLCODE              TO ABEND-SQLCODE             
P00836           MOVE SQLSTATE             TO ABEND-SQLSTATE            
P00836           MOVE '0100B'              TO ACTIVE-PARAGRAPH          
P00836           MOVE 'DECLARE GTT'        TO ABEND-FUNCTION            
P00836           MOVE SPACES               TO ABEND-SQL-PREDICATES      
P00836                                        ABEND-TABLES              
P00836           MOVE 'CSR04099_R2'        TO TABLE-1                   
P00836           MOVE SPACES               TO TABLE-ELEMENT-1           
P00836           MOVE SPACES               TO HOSTVAR-ELEMENT-1         
P00836           PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT           
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836                                                                  
P00836 0100B-EXIT.                                                      
P00836         EXIT.                                                    
P00836                                                                  
       1000-PROCESS-INPUT.                                              
                                                                        
           UNSTRING PARM-ACCOUNT-NO DELIMITED BY ' '                    
                                    INTO WS-ACCOUNT-NO-JST              
                                                                        
           MOVE WS-ACCOUNT-NO-JST      TO PARM-ACCOUNT-NO-NUM           
           MOVE PARM-ACCOUNT-NO-NUM    TO PARM-ACCOUNT-NO-DEC           
                                                                        
           UNSTRING PARM-IC-NO DELIMITED BY ' '                         
                                    INTO WS-IC-NO-JST                   
           MOVE WS-IC-NO-JST           TO PARM-IC-NO-NUM                
           MOVE PARM-IC-NO-NUM         TO PARM-IC-NO-DEC                
                                                                        
P00836     EXEC SQL                                                     
P00836        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00836     MOVE WS-CURRENT-DATE(1:4)   TO WS-CURRENT-DATE-YYYY.         
P00836     MOVE WS-CURRENT-DATE(6:2)   TO WS-CURRENT-DATE-MM.           
P00836     MOVE WS-CURRENT-DATE(9:2)   TO WS-CURRENT-DATE-DD.           
                                                                        
P00836     SET BUS-RULE-INDX TO 1.                                      
P00836     PERFORM 7000-OPEN-RULE-CURSOR  THRU 7000-EXIT                
P00836     PERFORM 7001-FETCH-RULE-CURSOR THRU 7001-EXIT                
P00836     PERFORM 1010-LOAD-BUS-RULES    THRU 1010-EXIT                
P00836       UNTIL WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND               
P00836     PERFORM 7002-CLOSE-RULE-CURSOR THRU 7002-EXIT                
                                                                        
P00836     MOVE 3DAY-ROR-DAYS          TO C8-DELINQ-CD                  
P00836     MOVE '01'                   TO C8-COMPANY-NO                 
P00836     PERFORM 7007-SELECT-DELINQENCY THRU 7007-EXIT                
P00836     MOVE C8-DELINQ-VALUE        TO WS-3DAY-ROR-DAYS              
                                                                        
P00892     MOVE 90-DAY-GRACE-PERIOD    TO C8-DELINQ-CD.                 
P00892     MOVE '01'                   TO C8-COMPANY-NO.                
P00892     PERFORM 7007-SELECT-DELINQENCY THRU 7007-EXIT.               
P00892     MOVE C8-DELINQ-VALUE        TO WS-90DAY-GRACE-PERIOD.        
                                                                        
P00836     MOVE SCANA-SR-AGE           TO C8-DELINQ-CD.                 
P00836     MOVE '01'                   TO C8-COMPANY-NO.                
P00836     PERFORM 7007-SELECT-DELINQENCY THRU 7007-EXIT.               
P00836     MOVE C8-DELINQ-VALUE        TO WS-SCANA-SENIOR-AGE.          
                                                                        
OTPMSG     MOVE 2                      TO G6-SEQ-NO.                    
OTPMSG     PERFORM 7012-GET-POOL-GO-DATE  THRU 7012-EXIT.               
OTPMSG     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
OTPMSG        MOVE G6-PARM-DATA(14:10) TO WS-POOL-GO-DATE               
OTPMSG     END-IF.                                                      
                                                                        
P00836     INITIALIZE GTT-RETURN-FIELDS-1                               
P00836                GTT-RETURN-FIELDS-2                               
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 1010-LOAD-BUS-RULES.                                             
P00836                                                                  
P00836     MOVE 1T-BUS-RULE-ID      TO BUS-RULE-ID      (BUS-RULE-INDX).
P00836     MOVE 1T-BUS-RULE-XREF-ID TO BUS-RULE-XREF-ID (BUS-RULE-INDX).
P00836     MOVE 1T-COMPANY-NO       TO BUS-RULE-COMPANY-NO              
P00836                                                  (BUS-RULE-INDX).
P00836     MOVE 1S-RULE-MESSAGE-ID  TO BUS-RULE-MESSAGE-ID              
P00836                                                  (BUS-RULE-INDX).
P00836     MOVE 1S-RULE-RESULT-CD   TO BUS-RULE-RESULT-CD               
P00836                                                  (BUS-RULE-INDX).
P00836     SET BUS-RULE-INDX UP BY 1.                                   
P00836     PERFORM 7001-FETCH-RULE-CURSOR THRU 7001-EXIT.               
P00836                                                                  
P00836 1010-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-BUILD-RESULT         THRU 2100-EXIT             
P00836     PERFORM 2200-BUILD-BUS-RULES      THRU 2200-EXIT             
P836TR     MOVE SPACES                       TO S-XFER-RATE-TITLE-1     
P836TR                                          S-XFER-RATE-TITLE-2.    
P836TR**** TRANSFER CURRENT AND PENDING RATE TO NEW ACCOUNT                     
P836TR     IF S-PEND-OPT-EXIST-FL EQUAL 'Y'                             
P836TR        MOVE 'Current Rate Plan'       TO S-XFER-RATE-TITLE-1     
P836TR        MOVE 'Renewal Rate Plan'       TO S-XFER-RATE-TITLE-2     
P836TR     ELSE                                                         
P836TR**** INTROVARIABLE RATE EXPIRED, TRANSFER VARIABLE RATE                   
P836TR        IF S-OPTN-VALID-MNTHS EQUAL 1 AND                         
P836TR           S-FF-DURATION-REM  EQUAL 0                             
P836TR           MOVE 'Current Rate Plan'    TO S-XFER-RATE-TITLE-1     
P836TR        ELSE                                                      
P836TR**** RATE RENEWED, ACCOUNT NOT YET BILLED ON NEW RATE                     
P836TR           IF ((DF-AGREEMNT-SOURCE-CD  = 'FRN' OR 'FAR' OR 'VRN') 
P836TR                AND S-OPTN-VALID-MNTHS =  S-FF-DURATION-REM)      
P836TR              MOVE 'Renewal Rate Plan' TO S-XFER-RATE-TITLE-1     
P836TR           ELSE                                                   
P836TR              MOVE 'Current Rate Plan' TO S-XFER-RATE-TITLE-1     
P836TR           END-IF                                                 
P836TR        END-IF                                                    
P836TR     END-IF.                                                      
                                                                        
P00680     PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            
A01339     INITIALIZE GTT-RETURN-FIELDS-1.                              
P00836     INITIALIZE GTT-RETURN-FIELDS-2.                              
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE WS-THERM-PRICE                 TO S-THERM-PRICE         
           MOVE WS-OPTN-VALID-MNTHS            TO S-OPTN-VALID-MNTHS    
           MOVE WS-PRIM-FACTOR-ID              TO S-PRIM-FACTOR-ID      
           MOVE WS-CORE-RATE-PLAN-NO           TO S-CORE-RATE-PLAN-NO   
           MOVE WS-RATE-CALC-TYPE-CD           TO S-RATE-CALC-TYPE-CD   
           MOVE WS-CSC-AMT                     TO S-CSC-AMT             
           MOVE WS-CSC-REFND-FL                TO S-CSC-REFND-FL        
           MOVE WS-CSC-MNTHS                   TO S-CSC-MNTHS           
           MOVE WS-FF-DURATION-REM             TO S-FF-DURATION-REM     
           MOVE WS-TIER-ACCT-TYPE-CD           TO S-TIER-ACCT-TYPE-CD   
           MOVE WS-WEB-RENEWAL-FL              TO S-WEB-RENEWAL-FL      
P00211     MOVE WS-PEND-OPT-EXIST-FL           TO S-PEND-OPT-EXIST-FL.  
P00211     MOVE WS-SHOW-RENEWAL-OPT            TO S-SHOW-RENEWAL-OPT.   
OTPOOL**** OUTER POOL CUSTOMERS CANNOT CHANGE THEIR RATE ON WEB                 
OTPOOL     IF B1-DIVISION-NO         EQUAL 'OUT' AND                    
OTPOOL        S-WEB-RENEWAL-FL   NOT EQUAL 'N'   AND                    
OTPOOL        S-SHOW-RENEWAL-OPT NOT EQUAL 'Y'                          
I02262        IF ( ( S-TIER-ACCT-TYPE-CD  EQUAL 'D' OR 'A' OR 'B') OR   
I02262**** SMALL COMMERCIAL OUTER POOL GROUP OFFER                              
I02262             ( S-TIER-ACCT-TYPE-CD  EQUAL 'S' AND                 
I02262               S-SPCL-OFFER-TYPE-CD NOT EQUAL 'OP' ) )            
OTPOOL           MOVE 'N'                      TO S-WEB-RENEWAL-FL      
OTPOOL        END-IF                                                    
OTPOOL     END-IF.                                                      
           MOVE WS-RATE-DEFINITION-CD          TO S-RATE-DEFINITION-CD  
P00836     MOVE WS-CURR-EXT-DESC-LONG-TEXT (1:WS-CURR-EXT-DESC-LONG-LEN)
P00836          TO S-CURR-EXT-DESC-LONG-TEXT.                           
P00836     MOVE LENGTH OF S-CURR-EXT-DESC-LONG-TEXT                     
P00836          TO S-CURR-EXT-DESC-LONG-LEN.                            
P00836     MOVE WS-PEND-EXT-DESC-LONG-TEXT (1:WS-PEND-EXT-DESC-LONG-LEN)
P00836          TO S-PEND-EXT-DESC-LONG-TEXT.                           
P00836     MOVE LENGTH OF S-PEND-EXT-DESC-LONG-TEXT                     
P00836          TO S-PEND-EXT-DESC-LONG-LEN.                            
P00805     MOVE WS-CURR-OPT-EFF-DATE           TO S-CURR-OPT-EFF-DATE.  
P00805     MOVE WS-PEND-OPT-EFF-DATE           TO S-PEND-OPT-EFF-DATE.  
P00805     MOVE WS-SENIOR-RATE-FL              TO S-SENIOR-RATE-FL.     
A05037     MOVE WS-CORE-RATE-PLAN-DDDC         TO S-CORE-RATE-PLAN-DDDC.
A05043     MOVE WS-PRINT-SR-DSC-MSG-CD         TO S-PRINT-SR-DSC-MSG-CD.
P00836     MOVE WS-CURR-OPT-ROR-END-DT         TO S-CURR-OPT-ROR-END-DT.
P00836     MOVE WS-CUSTOMER-DOB                TO S-CUSTOMER-DOB.       
P00836     MOVE WS-SENIOR-BY-DOB-FLAG          TO S-SENIOR-BY-DOB-FLAG. 
P00892     MOVE WS-PEND-OPT-ROR-END-DT         TO S-PEND-OPT-ROR-END-DT.
P00892     MOVE WS-PEND-WEB-DESC-LONG-LEN      TO                       
P00892                                         S-PEND-WEB-DESC-LONG-LEN.
P00892     MOVE WS-PEND-WEB-DESC-LONG-TXT(1:S-PEND-WEB-DESC-LONG-LEN)   
P00892                                         TO                       
P00892                                         S-PEND-WEB-DESC-LONG-TXT.
P836MS     MOVE WS-PEND-WMKT-DESC-LONG-LEN                              
P836MS          TO S-PEND-WMKT-DESC-LONG-LEN.                           
P836MS     MOVE WS-PEND-WMKT-DESC-LONG-TEXT(1:S-PEND-WMKT-DESC-LONG-LEN)
P836MS          TO S-PEND-WMKT-DESC-LONG-TEXT.                          
P836MS     MOVE WS-CURR-WMKT-DESC-LONG-LEN                              
P836MS          TO S-CURR-WMKT-DESC-LONG-LEN.                           
P836MS     MOVE WS-CURR-WMKT-DESC-LONG-TEXT(1:S-CURR-WMKT-DESC-LONG-LEN)
P836MS          TO S-CURR-WMKT-DESC-LONG-TEXT.                          
P836MS     MOVE WS-CURR-OPT-EXT-FEE            TO S-CURR-OPT-EXT-FEE.   
P836MS     MOVE WS-PEND-RATE-EFF-TXT           TO S-PEND-RATE-EFF-TXT.  
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
P00680******************************************************************03660000
P00680* 2000B-MOVE-RESULT.                                             *03660100
P00680******************************************************************03661000
P00680 2000B-MOVE-RESULT.                                               
P00680                                                                  
P00680     MOVE RS-RETURN-CODE-1            TO S-RETURN-CODE-1.         
P00680     MOVE WS-ADJUSTABLE-FLAG          TO S-ADJUSTABLE-FLAG.       
P00680     MOVE WS-CURRENT-THERM-PRICE      TO S-CURRENT-THERM-PRICE.   
P00805     MOVE WS-IS-CURR-OPTN-FLEX        TO S-IS-CURR-OPTN-FLEX.     
P00680                                                                  
P00680 2000B-EXIT.                                                      
P00680      EXIT.                                                       
                                                                        
P00680******************************************************************03671000
P00680* 2100-BUILD-RESULT.                                             *03671100
P00680******************************************************************03671200
       2100-BUILD-RESULT.                                               
                                                                        
           MOVE PROGRAM-NAME                TO WS-CPD063-CALLING-PGM.   
           MOVE PARM-OPTION-CD              TO WS-OPTION-CD             
           MOVE PARM-ACCOUNT-NO-DEC         TO WS-ACCOUNT-NO-063        
                                               DD-ACCOUNT-NO            
P00892                                         TA-ACCOUNT-NO            
P00211                                         DF-ACCOUNT-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE-063    
                                               RD-CODE-UTIL-TYPE        
P00211                                         DF-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO-DEC              TO WS-IC-NO-063             
P00211                                         DF-IC-NO.                
P00836     PERFORM 7003-GET-ACCOUNT-DETAIL     THRU 7003-EXIT           
           PERFORM 7200-SELECT-WEB-RENEWAL     THRU 7200-EXIT           
P00836     MOVE DD-TIER-CUST-STAT-CD        TO S-TIER-CUST-STAT-CD      
                                                                        
P00211     MOVE WS-PENDING-OPTION           TO DF-STATUS-CD.            
           MOVE PARM-THERM-CSC-ACCT-FL      TO WS-THERM-CSC-ACCT-FL     
P00892     MOVE 'Y'                         TO WS-PENDING-OPTION-FL-063 
                                                                        
P00680     PERFORM 6000-CALL-MCSCB063-PGM      THRU 6000-EXIT           
P00836**0 MONTH REMAINING MCSCB063 ROUTINE DOES RETURN ACCOUNT THERM PRC        
P00836     IF PARM-THERM-CSC-ACCT-FL EQUAL WS-YES                       
P00836                           AND WS-FF-DURATION-REM EQUAL ZEROES    
P00836                           AND WS-RATE-CALC-TYPE-CD EQUAL '02'    
P836MS        IF WS-THERM-PRICE > 0  AND                                
P836MS          (WS-TIER-ACCT-TYPE-CD = 'I' OR 'L' OR 'R')              
P836MS           CONTINUE                                               
P836MS        ELSE                                                      
P00836           MOVE ZEROES                TO WS-FACTOR                
P00836           PERFORM 7510-SEL-THERM-PRICE  THRU 7510-EXIT           
P00836           MOVE WS-FACTOR             TO WS-THERM-PRICE           
P836MS        END-IF                                                    
P00836     END-IF                                                       
P836MS     MOVE WS-EXIT-FEE-AMT-063         TO WS-CURR-OPT-EXT-FEE      
                                                                        
A01339     INITIALIZE               WS-CURR-EXT-DESC-LONG               
A01339                              FI-CURR-EXT-DESC-LONG               
P00211                              WS-PEND-EXT-DESC-LONG               
           PERFORM 7100-SELECT-OPTION-DESC     THRU 7100-EXIT           
           MOVE WS-CORE-RATE-PLAN-NO        TO RD-RATE-PLAN-NO          
P00805     MOVE SPACES                      TO WS-SENIOR-RATE-FL        
                                                                        
A05037     MOVE ZEROS                       TO WS-CORE-RATE-PLAN-DDDC   
A05037     PERFORM 7500-GET-CORE-RATE-PLAN-DDDC                         
A05037                                         THRU 7500-EXIT           
                                                                        
           PERFORM 7300-SELECT-RATE-DEF-CD     THRU 7300-EXIT           
                                                                        
P00805     MOVE RD-SENIOR-RATE-FL           TO WS-SENIOR-RATE           
P00805     IF SENIOR-RATE                                               
P00805        MOVE 'Y'                      TO WS-SENIOR-RATE-FL        
P00805     END-IF                                                       
                                                                        
P00211     MOVE SPACES                      TO FI-CURR-EXT-DESC-LONG    
P00805                                         WS-CURR-OPT-EFF-DATE     
P00805                                         WS-PEND-OPT-EFF-DATE     
P00211     PERFORM 7400-SELECT-PEND-OPTION     THRU 7400-EXIT           
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00211        MOVE FI-CURR-EXT-DESC-LONG-TEXT                           
P00211                   (1:FI-CURR-EXT-DESC-LONG-LEN)                  
P00836             TO WS-PEND-EXT-DESC-LONG-TEXT                        
P00836        MOVE LENGTH OF WS-PEND-EXT-DESC-LONG-TEXT                 
P00836             TO WS-PEND-EXT-DESC-LONG-LEN                         
P00892        MOVE FI-WEB-DESC-LONG-LEN     TO WS-PEND-WEB-DESC-LONG-LEN
P00892        MOVE FI-WEB-DESC-LONG-TEXT(1:FI-WEB-DESC-LONG-LEN)        
P00892                                      TO WS-PEND-WEB-DESC-LONG-TXT
P00836        MOVE FI-WEB-MKT-DESC-LONG-LEN                             
P00836             TO WS-PEND-WMKT-DESC-LONG-LEN                        
P00836        MOVE FI-WEB-MKT-DESC-LONG-TEXT(1:FI-WEB-MKT-DESC-LONG-LEN)
P00836             TO WS-PEND-WMKT-DESC-LONG-TEXT                       
P00892        PERFORM 7008-ADD-DAYS            THRU 7008-EXIT           
P00892        MOVE WS-ROR-RESULT-DATE       TO WS-PEND-OPT-ROR-END-DT   
                                                                        
P00892****   I - OPTED-IN FOR AUTO RENEWAL, FAR - AUTORENEWED                   
P00892        IF DF-AUTO-REN-OPT-IN-FL = 'I' AND                        
P00892           DF-AGREEMNT-SOURCE-CD = 'FAR'                          
P00892           PERFORM 7076-ADD-DAYS-GRACE-PERIOD THRU 7076-EXIT      
P00892           MOVE WS-ROR-RESULT-DATE    TO WS-PEND-OPT-ROR-END-DT   
P00892        END-IF                                                    
                                                                        
P00805        IF DF-STATUS-EFF-REV-MTH > 0                              
P00805           MOVE DF-STATUS-EFF-REV-MTH TO WS-REV-MONTH-NUM         
P00805           MOVE WS-REV-MONTH-CHAR(1:4)                            
P00805                                      TO WS-PEND-OPT-EFF-DATE(1:4)
P00805           MOVE '-'                   TO WS-PEND-OPT-EFF-DATE(5:1)
P00805                                         WS-PEND-OPT-EFF-DATE(8:1)
P00805           MOVE WS-REV-MONTH-CHAR(5:2)                            
P00805                                      TO WS-PEND-OPT-EFF-DATE(6:2)
P00805           MOVE '01'                  TO WS-PEND-OPT-EFF-DATE(9:2)
P836MS           MOVE WS-REV-MONTH-CHAR(5:2)                            
P836MS                                      TO WS-MM                    
P836MS           PERFORM 2400-GET-MONTH        THRU 2400-EXIT           
P836MS           STRING  WS-MONTH                                       
P836MS                   ' '                                            
P836MS                   WS-REV-MONTH-CHAR(1:4)                         
P836MS                   DELIMITED BY '  '                              
P836MS                   INTO WS-PEND-RATE-EFF-TXT                      
P836MS           END-STRING                                             
P00805        END-IF                                                    
P00892        IF DF-AGREEMNT-SOURCE-CD = 'FAR'                          
P00892           MOVE 'Y'                   TO S-PEND-OPT-ARMSG-FL      
P00892        ELSE                                                      
P00892           MOVE 'N'                   TO S-PEND-OPT-ARMSG-FL      
P00892        END-IF                                                    
                                                                        
P00892        IF FI-OPT-CALC-TYPE-CD = 'FP'                             
P00892           PERFORM 7550-GET-PEND-OPT-VLD-MNT-DUR                  
P00892                                         THRU 7550-EXIT           
P00892        END-IF                                                    
P00892        IF WS-PEND063-CALC-TYPE-CD EQUAL '02'                     
P00892           MOVE DF-OPTION-CD          TO HQ-OPTION-CD             
P00892           MOVE WS-EXIT-FEE-FCTR      TO HQ-FACTOR-ID             
P00892           PERFORM 7560-GET-PEND-OPT-EXIT-FEE                     
P00892                                         THRU 7560-EXIT           
P00892           MOVE HQ-ATTR-INCTV-VALUE   TO S-PEND-OPT-EXT-FEE       
P00892        END-IF                                                    
P00892        MOVE WS-PEND063-THERM-PRICE   TO S-PEND-OPT-THRM-PRC      
P00892        MOVE WS-PEND063-CSC-AMT       TO S-PEND-OPT-CSC-AMT       
P00211     END-IF                                                       
                                                                        
OTPMSG     MOVE 'N'                         TO WS-OUTER-POOL-MSG-FL     
P00211     PERFORM 7410-SELECT-CURR-OPTION     THRU 7410-EXIT           
P836FX     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00836        PERFORM 7008-ADD-DAYS            THRU 7008-EXIT           
P00836        MOVE WS-ROR-RESULT-DATE       TO WS-CURR-OPT-ROR-END-DT   
OTPMSG        IF B1-DIVISION-NO        = 'OUT'             AND          
OTPMSG           WS-POOL-GO-DATE       > ' '               AND          
OTPMSG           DF-STATUS-CHANGE-DT   > '1900-01-01'      AND          
OTPMSG           DF-STATUS-CHANGE-DT  >=  WS-POOL-GO-DATE  AND          
OTPMSG          (WS-TIER-ACCT-TYPE-CD  = 'D' OR 'A' OR 'B')             
OTPMSG           MOVE 'Y'                   TO WS-OUTER-POOL-MSG-FL     
OTPMSG        END-IF                                                    
P836FX     END-IF                                                       
P00836     MOVE UT-CODE-REVENUE-CLASS       TO S-CODE-REVENUE-CLASS     
P00892     IF DF-AUTO-REN-OPT-IN-FL EQUAL 'I'                           
P00892        MOVE 'Y'                      TO S-CURR-OPT-ARMSG-FL      
P00892     ELSE                                                         
P00892        MOVE 'N'                      TO S-CURR-OPT-ARMSG-FL      
P00892     END-IF                                                       
                                                                        
P892NW*****This flag will be used to determine if EXIT FEE can be               
P892NW*****waived for a rate change on WEB. EXIT FEE will be waived             
P892NW*****only when moving from a non-eligible rate to an eligible             
P892NW*****rate and opting-in.                                                  
P892NW     IF DF-AUTO-REN-OPT-IN-FL EQUAL 'N'                           
P892NW        MOVE 'Y'                      TO S-CURR-OPT-AR-ELGBL      
P892NW     ELSE                                                         
P892NW        MOVE 'N'                      TO S-CURR-OPT-AR-ELGBL      
P892NW     END-IF                                                       
                                                                        
P00211     IF DF-STATUS-CD EQUAL 'O'                                    
P00211        MOVE 'Y'                      TO WS-SHOW-RENEWAL-OPT      
P00211     ELSE                                                         
P00211        MOVE 'N'                      TO WS-SHOW-RENEWAL-OPT      
P00211     END-IF                                                       
P00836     MOVE DF-OFFER-CD                 TO FG-OFFER-CD              
P00836     PERFORM 7420-SELECT-SPCL-OFFER-TYPE THRU 7420-EXIT           
P00836     MOVE FG-SPCL-OFFER-TYPE-CD       TO S-SPCL-OFFER-TYPE-CD     
                                                                        
P00892****   I - OPTED-IN FOR AUTO RENEWAL, FAR - AUTORENEWED                   
P00892     IF DF-AUTO-REN-OPT-IN-FL = 'I' AND                           
P00892       DF-AGREEMNT-SOURCE-CD  = 'FAR'                             
P00892        PERFORM 7076-ADD-DAYS-GRACE-PERIOD THRU 7076-EXIT         
P00892        MOVE WS-ROR-RESULT-DATE       TO WS-CURR-OPT-ROR-END-DT   
P00892     END-IF                                                       
                                                                        
P00836     PERFORM 7009-GET-CUSTOMER-DOB       THRU 7009-EXIT.          
P00836     MOVE 'N'                         TO WS-SENIOR-BY-DOB-FLAG.   
P00836     IF WS-CUSTOMER-DOB > SPACES AND WS-CURRENT-DATE > SPACES     
P00836        PERFORM 7010-GET-YEARS           THRU 7010-EXIT           
P00836        IF WS-NO-OF-YEARS >= WS-SCANA-SENIOR-AGE                  
P00836           MOVE 'Y'                   TO WS-SENIOR-BY-DOB-FLAG    
P00836        END-IF                                                    
P00836     END-IF.                                                      
P00836                                                                  
P00892     PERFORM 7011-GET-SEASONAL-FL        THRU 7011-EXIT.          
P00892     MOVE TA-SEASONAL-FL              TO S-SEASONAL-FL.           
P00892                                                                  
A05043*****REVENUE MONTH CHECK IS TO ENSURE MESSAGE PRINTS ONLY ONCE.   04015020
A05043     IF DF-STATUS-EFF-REV-MTH < 201411                            
A05043        EVALUATE WS-CORE-RATE-PLAN-NO                             
A05043            WHEN '149'                                            
A05043               MOVE 'SR'              TO WS-PRINT-SR-DSC-MSG-CD   
A05043            WHEN '152'                                            
A05043               MOVE 'SA'              TO WS-PRINT-SR-DSC-MSG-CD   
A05043        END-EVALUATE                                              
A05043     ELSE                                                         
A05043        MOVE SPACES                   TO WS-PRINT-SR-DSC-MSG-CD   
A05043     END-IF                                                       
                                                                        
P00805     IF DF-STATUS-EFF-REV-MTH > 0                                 
P00805        MOVE DF-STATUS-EFF-REV-MTH    TO WS-REV-MONTH-NUM         
P00805        MOVE WS-REV-MONTH-CHAR(1:4)   TO WS-CURR-OPT-EFF-DATE(1:4)
P00805        MOVE '-'                      TO WS-CURR-OPT-EFF-DATE(5:1)
P00805                                         WS-CURR-OPT-EFF-DATE(8:1)
P00805        MOVE WS-REV-MONTH-CHAR(5:2)   TO WS-CURR-OPT-EFF-DATE(6:2)
P00805        MOVE '01'                     TO WS-CURR-OPT-EFF-DATE(9:2)
P00805     END-IF.                                                      
                                                                        
P892NW     IF (WS-SHOW-RENEWAL-OPT      EQUAL 'Y'                       
P892NW         AND WS-PEND-OPT-EXIST-FL EQUAL 'N'                       
P892NW         AND S-CURR-OPT-ARMSG-FL  EQUAL 'Y'                       
P892NW         AND WS-FF-DURATION-REM   EQUAL 2                         
P892NW         AND WS-WEB-RENEWAL-FL    EQUAL 'Y'                       
P892NW         AND WS-RATE-CALC-TYPE-CD EQUAL '02'                      
P892NW         AND AT-CODE-ACCT-STAT    EQUAL WS-ACTIVE)                
P892NW        PERFORM 6500-CALL-MCSCB328       THRU 6500-EXIT           
P892NW        IF WS-SUB-CTR > 0                                         
P892NW           MOVE +1                       TO WS-CTR                
P892NW           MOVE WS-RET-THERM-PRICE (WS-CTR)                       
P892NW                                         TO S-PEND-OPT-THRM-PRC   
P892NW           MOVE WS-RET-CSC-AMT (WS-CTR)  TO S-PEND-OPT-CSC-AMT    
P892NW           MOVE WS-RET-EXIT-FEE (WS-CTR) TO S-PEND-OPT-EXT-FEE    
P892NW           MOVE WS-RET-CURR-EXT-DESC-LONG (WS-CTR)                
P892NW                TO WS-PEND-EXT-DESC-LONG-TEXT                     
P892NW           MOVE LENGTH OF WS-PEND-EXT-DESC-LONG-TEXT              
P892NW                TO WS-PEND-EXT-DESC-LONG-LEN                      
P892NW           MOVE WS-RET-WEB-MKT-DESC-LONG-LEN (WS-CTR)             
P892NW             TO WS-PEND-WMKT-DESC-LONG-LEN                        
P892NW           MOVE WS-RET-WEB-MKT-DESC-LONG-TEXT (WS-CTR)            
P892NW                 (1:WS-RET-WEB-MKT-DESC-LONG-LEN (WS-CTR))        
P892NW             TO WS-PEND-WMKT-DESC-LONG-TEXT                       
P892NW        END-IF                                                    
P892NW     END-IF.                                                      
                                                                        
P00680     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT          
P00680                                                                  
P00680*    SET ADJUSTABLE FLAG                                          04020200
P00680     IF WS-FF-DURATION-REM > WS-ZERO AND                          
P00680        DF-STAT-ADJUSTABLE-CD EQUAL WS-ACTIVE                     
P00680        MOVE WS-YES                   TO WS-ADJUSTABLE-FLAG       
P00680     ELSE                                                         
P00680        MOVE WS-NO                    TO WS-ADJUSTABLE-FLAG       
P00680     END-IF                                                       
P00680                                                                  
P00805     IF DF-STAT-ADJUSTABLE-CD EQUAL 'A' OR 'E'                    
P00805        MOVE 'Y'                      TO WS-IS-CURR-OPTN-FLEX     
P00805     ELSE                                                         
P00805        MOVE 'N'                      TO WS-IS-CURR-OPTN-FLEX     
P00805     END-IF                                                       
                                                                        
P00680*    IF THERM_CSC_ACCT_FL IS PASSED AS 'N' WE CAN MOVE  DIRECTLY  04026900
P00680*    THERM PRICE ( RETURNED FROM FIRST CALL ) TO CURR THERM PRICE.04027000
P00680*    ELSE WE HAVE TO CALL SECOND CALL TO GET THERM PRICE.         04027100
P00680     IF WS-THERM-CSC-ACCT-FL  EQUAL WS-NO                         
P00680        MOVE WS-THERM-PRICE           TO WS-CURRENT-THERM-PRICE   
P00680     ELSE                                                         
P00680        IF WS-ADJUSTABLE-FLAG EQUAL WS-YES                        
P00680           MOVE WS-NO                 TO WS-THERM-CSC-ACCT-FL     
P00680           PERFORM 6000-CALL-MCSCB063-PGM                         
P00680                                         THRU 6000-EXIT           
P00680           MOVE WS-THERM-PRICE        TO WS-CURRENT-THERM-PRICE   
P00680        END-IF                                                    
P00680     END-IF                                                       
P00680                                                                  
P00680     PERFORM 2000B-MOVE-RESULT           THRU 2000B-EXIT.         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00836 2200-BUILD-BUS-RULES.                                            
P00836                                                                  
P00836     INITIALIZE GTT-RETURN-FIELDS-2.                              
P00836     MOVE 0      TO S-RETURN-CODE-2.                              
P00836     MOVE SPACES TO S-BUS-RULE-MSG-ID                             
P00836                    S-BUS-RULE-RESULT-CD                          
P00836                    S-BUS-RULE-XREF-ID                            
P00836                    S-LINK-PARMS                                  
P00836                    WS-RULE-ID.                                   
P00836     MOVE '00'   TO WS-COMP-NO.                                   
P00836                                                                  
P00836     SET BUS-RULE-NOT-FOUND                                       
P00836         NOT-END-OF-SEARCH  TO TRUE.                              
P00836                                                                  
P00836*ACCOUNT IS ON FIXED RATE AND CAN RENEW THROUGH WEB CHANNEL               
P00836     IF S-RATE-CALC-TYPE-CD EQUAL '02' AND                        
OTPOOL        WS-WEB-RENEWAL-FL   EQUAL 'Y'  AND                        
P836FX       (AT-CODE-ACCT-STAT   EQUAL WS-ACTIVE OR WS-PENDING)        
P00892        EVALUATE TRUE                                             
P00892           WHEN S-SHOW-RENEWAL-OPT    = 'Y'                       
P00892            AND S-PEND-OPT-EXIST-FL   = 'N'                       
P00892            AND DF-AUTO-REN-OPT-IN-FL = 'I'                       
P00892            AND S-FF-DURATION-REM     = 2                         
P00892              MOVE 'WCM0000020'           TO WS-RULE-ID           
P00892              PERFORM 2300-RULE-XREF         THRU 2300-EXIT       
P00892                UNTIL BUS-RULE-FOUND OR END-OF-SEARCH             
P00892              MOVE S-FF-DURATION-REM      TO WS-FORMAT-DUR-REM    
P00892              MOVE WS-FORMAT-DUR-REM      TO S-MESSAGE-PARMS-TEXT 
P00892              MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                 
P00892                                          TO S-MESSAGE-PARMS-LEN  
P00892              PERFORM 8200-SEND-BUS-RULES    THRU 8200-EXIT       
P00892           WHEN S-SHOW-RENEWAL-OPT  = 'Y'                         
P00892            AND S-PEND-OPT-EXIST-FL = 'N'                         
P00836              PERFORM 2500-GET-RENEW-BY-DATE THRU 2500-EXIT       
P00836              MOVE WS-RENEW-BY-DATE(6:2)  TO WS-MM                
P00836              PERFORM 2400-GET-MONTH         THRU 2400-EXIT       
P00836              MOVE S-FF-DURATION-REM      TO WS-FORMAT-DUR-REM    
P00836              EVALUATE S-FF-DURATION-REM                          
P00836                 WHEN 2                                           
P00836                 WHEN 1                                           
OTPMSG                    IF WS-OUTER-POOL-MSG-FL EQUAL 'Y'             
OTPMSG                       MOVE 'WCM0000031' TO WS-RULE-ID            
OTPMSG                    ELSE                                          
P00836                       MOVE 'WCM0000001' TO WS-RULE-ID            
OTPMSG                    END-IF                                        
P00836                    PERFORM 2300-RULE-XREF  THRU 2300-EXIT        
P00836                      UNTIL BUS-RULE-FOUND OR END-OF-SEARCH       
P00836                    STRING WS-FORMAT-DUR-REM                      
P00836                           ';'                                    
P00836                           WS-MONTH                               
P00836                           ' '                                    
P00836                           WS-RENEW-BY-DATE(9:2)                  
P00836                           ', '                                   
P00836                           WS-RENEW-BY-DATE(1:4)                  
P00836                           DELIMITED BY '  '                      
P00836                           INTO S-MESSAGE-PARMS-TEXT              
P00836                    END-STRING                                    
P00836                    MOVE LENGTH OF S-MESSAGE-PARMS-TEXT           
P00836                                         TO S-MESSAGE-PARMS-LEN   
P00836                    PERFORM 8200-SEND-BUS-RULES THRU 8200-EXIT    
P00836                 WHEN 0                                           
OTPMSG                    IF WS-OUTER-POOL-MSG-FL EQUAL 'Y'             
OTPMSG                       MOVE 'WCM0000034'    TO WS-RULE-ID         
OTPMSG                    ELSE                                          
P00836                       MOVE 'WCM0000002'    TO WS-RULE-ID         
OTPMSG                    END-IF                                        
P00836                    PERFORM 2300-RULE-XREF  THRU 2300-EXIT        
P00836                      UNTIL BUS-RULE-FOUND OR END-OF-SEARCH       
P00836                    STRING WS-MONTH                               
P00836                           ' '                                    
P00836                           WS-RENEW-BY-DATE(9:2)                  
P00836                           ', '                                   
P00836                           WS-RENEW-BY-DATE(1:4)                  
P00836                           DELIMITED BY '  '                      
P00836                           INTO S-MESSAGE-PARMS-TEXT              
P00836                    END-STRING                                    
P00836                    MOVE LENGTH OF S-MESSAGE-PARMS-TEXT           
P00836                                         TO S-MESSAGE-PARMS-LEN   
P00836                    PERFORM 8200-SEND-BUS-RULES THRU 8200-EXIT    
P00836              END-EVALUATE                                        
P00892           WHEN S-SHOW-RENEWAL-OPT  = 'N'                         
P00892            AND S-PEND-OPT-EXIST-FL = 'Y'                         
P00892            AND DF-AUTO-REN-OPT-IN-FL NOT = 'I'                   
P00892            AND DF-AUTO-REN-OPT-IN-FL NOT = 'A'                   
OTPMSG              IF WS-OUTER-POOL-MSG-FL EQUAL 'Y'                   
OTPMSG                 MOVE 'WCM0000035'        TO WS-RULE-ID           
OTPMSG              ELSE                                                
P00892                 MOVE 'WCM0000003'        TO WS-RULE-ID           
OTPMSG              END-IF                                              
P00836              PERFORM 2300-RULE-XREF         THRU 2300-EXIT       
P00836                UNTIL BUS-RULE-FOUND OR END-OF-SEARCH             
P00836              MOVE S-PEND-OPT-EFF-DATE(6:2)                       
P00836                                          TO WS-MM                
P00836              PERFORM 2400-GET-MONTH         THRU 2400-EXIT       
P00836              STRING S-PEND-EXT-DESC-LONG-TEXT                    
P00836                         (1:S-PEND-EXT-DESC-LONG-LEN)             
P00836                     ';'                                          
P00836                     WS-MONTH                                     
P00836                     ', '                                         
P00836                     S-PEND-OPT-EFF-DATE(1:4)                     
P00836                     DELIMITED BY '  '                            
P00836                     INTO S-MESSAGE-PARMS-TEXT                    
P00836              END-STRING                                          
P00836              MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                 
P00836                                          TO S-MESSAGE-PARMS-LEN  
P00836              PERFORM 8200-SEND-BUS-RULES    THRU 8200-EXIT       
P00892           WHEN S-SHOW-RENEWAL-OPT    = 'N'                       
P00892            AND S-PEND-OPT-EXIST-FL   = 'Y'                       
P00892            AND DF-AUTO-REN-OPT-IN-FL = 'A'                       
P00892              IF S-FF-DURATION-REM = 1 OR                         
P00892                 S-FF-DURATION-REM = 0                            
P00892                 MOVE 'WCM0000021'     TO WS-RULE-ID              
P00892                 PERFORM 2300-RULE-XREF      THRU 2300-EXIT       
P00892                   UNTIL BUS-RULE-FOUND OR END-OF-SEARCH          
P00892                 MOVE S-PEND-OPT-EFF-DATE(6:2)                    
P00892                                             TO WS-MM             
P00892                 PERFORM 2400-GET-MONTH         THRU 2400-EXIT    
P00892                 MOVE HQ-DURATION-NO         TO WS-FORMAT-DUR-REM 
P00892                 STRING S-PEND-EXT-DESC-LONG-TEXT                 
P00892                            (1:S-PEND-EXT-DESC-LONG-LEN)          
P00892                        ';'                                       
P00892                        WS-MONTH                                  
P00892                        ', '                                      
P00892                        S-PEND-OPT-EFF-DATE(1:4)                  
P00892                        DELIMITED BY '  '                         
P00892                        INTO S-MESSAGE-PARMS-TEXT                 
P00892                 END-STRING                                       
P00892                 MOVE LENGTH OF S-MESSAGE-PARMS-TEXT              
P00892                                          TO S-MESSAGE-PARMS-LEN  
P00892                 PERFORM 8200-SEND-BUS-RULES    THRU 8200-EXIT    
P00892              END-IF                                              
P00836           WHEN OTHER                                             
P00836              EVALUATE TRUE                                       
P00836                 WHEN S-FF-DURATION-REM EQUAL                     
P00836                      S-OPTN-VALID-MNTHS                          
P00836                    IF DF-AGREEMNT-SOURCE-CD EQUAL 'FRN'          
P00836                       MOVE 'WCM0000003'   TO WS-RULE-ID          
P00836                       PERFORM 2300-RULE-XREF THRU 2300-EXIT      
P00836                         UNTIL BUS-RULE-FOUND OR END-OF-SEARCH    
P00836                       MOVE S-CURR-OPT-EFF-DATE(6:2)              
P00836                                           TO WS-MM               
P00836                       PERFORM 2400-GET-MONTH THRU 2400-EXIT      
P00836                       STRING S-CURR-EXT-DESC-LONG-TEXT           
P00836                                  (1:S-CURR-EXT-DESC-LONG-LEN)    
P00836                              ';'                                 
P00836                              WS-MONTH                            
P00836                              ', '                                
P00836                              S-CURR-OPT-EFF-DATE(1:4)            
P00836                              DELIMITED BY '  '                   
P00836                              INTO S-MESSAGE-PARMS-TEXT           
P00836                       END-STRING                                 
P00836                       MOVE LENGTH OF S-MESSAGE-PARMS-TEXT        
P00836                                   TO S-MESSAGE-PARMS-LEN         
P00836                       PERFORM 8200-SEND-BUS-RULES                
P00836                                              THRU 8200-EXIT      
P00836                    END-IF                                        
P00892                    IF DF-AGREEMNT-SOURCE-CD EQUAL 'FAR'          
P00892                       MOVE 'WCM0000030'   TO WS-RULE-ID          
P00892                       PERFORM 2300-RULE-XREF THRU 2300-EXIT      
P00892                         UNTIL BUS-RULE-FOUND OR END-OF-SEARCH    
P00892                       MOVE S-OPTN-VALID-MNTHS                    
P00892                                           TO WS-FORMAT-DUR-REM   
P00892                       MOVE S-CURR-OPT-EFF-DATE(6:2)              
P00892                                           TO WS-MM               
P00892                       PERFORM 2400-GET-MONTH THRU 2400-EXIT      
P00892                       STRING S-CURR-EXT-DESC-LONG-TEXT           
P00892                                  (1:S-CURR-EXT-DESC-LONG-LEN)    
P00892                              ';'                                 
P00892                              WS-MONTH                            
P00892                              ', '                                
P00892                              S-CURR-OPT-EFF-DATE(1:4)            
P00892                              DELIMITED BY '  '                   
P00892                              INTO S-MESSAGE-PARMS-TEXT           
P00892                       END-STRING                                 
P00892                       MOVE LENGTH OF S-MESSAGE-PARMS-TEXT        
P00892                                   TO S-MESSAGE-PARMS-LEN         
P00892                       PERFORM 8200-SEND-BUS-RULES                
P00892                                              THRU 8200-EXIT      
P00892                    END-IF                                        
P00836                 WHEN S-FF-DURATION-REM EQUAL                     
P00836                     (S-OPTN-VALID-MNTHS - 1)                     
P00836                    MOVE 'WCM0000004'    TO WS-RULE-ID            
P00836                    PERFORM 2300-RULE-XREF  THRU 2300-EXIT        
P00836                      UNTIL BUS-RULE-FOUND OR END-OF-SEARCH       
P00836                    MOVE LENGTH OF S-MESSAGE-PARMS-TEXT           
P00836                                         TO S-MESSAGE-PARMS-LEN   
P00836                    PERFORM 8200-SEND-BUS-RULES THRU 8200-EXIT    
P00836              END-EVALUATE                                        
P00836        END-EVALUATE                                              
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF S-ADJUSTABLE-FLAG EQUAL WS-YES                            
P00836        INITIALIZE S-MESSAGE-PARMS                                
P00836        SET BUS-RULE-NOT-FOUND                                    
P00836            NOT-END-OF-SEARCH            TO TRUE                  
P00836        MOVE 'WCM0000016'                TO WS-RULE-ID            
P00836        PERFORM 2300-RULE-XREF              THRU 2300-EXIT        
P00836                UNTIL BUS-RULE-FOUND OR END-OF-SEARCH             
P00836        MOVE S-CURRENT-THERM-PRICE       TO WS-FMT-THERM-PRICE    
P00836        MOVE S-CORE-RATE-PLAN-DDDC       TO WS-FMT-DDDC           
P00836        IF S-RATE-DEFINITION-CD EQUAL '2'                         
P00836           STRING WS-FMT-THERM-PRICE                              
P00836                 ' + ('                                           
P00836                  WS-FMT-DDDC                                     
P00836                 ' X DDDC )'                                      
P00836                  DELIMITED BY '  '                               
P00836                  INTO S-MESSAGE-PARMS-TEXT                       
P00836           END-STRING                                             
P00836        ELSE                                                      
P00836           STRING WS-FMT-THERM-PRICE                              
P00836                  DELIMITED BY '  '                               
P00836                  INTO S-MESSAGE-PARMS-TEXT                       
P00836           END-STRING                                             
P00836        END-IF                                                    
P00836        MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                       
P00836                                         TO S-MESSAGE-PARMS-LEN   
P00836        PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT        
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF S-RATE-CALC-TYPE-CD EQUAL '02' OR                         
P836TR       (S-OPTN-VALID-MNTHS  EQUAL 1 AND S-FF-DURATION-REM EQUAL 1)
P00836        IF WS-RENEW-BY-DATE EQUAL SPACES                          
P836MS           IF S-TIER-ACCT-TYPE-CD = 'I' OR 'L' OR 'R'             
P836MS              PERFORM 7520-GET-FCTR-END-DT  THRU 7520-EXIT        
P836MS              MOVE WS-FF-EFF-DATE-TO     TO WS-RENEW-BY-DATE      
P836MS           END-IF                                                 
P836MS           IF WS-RENEW-BY-DATE EQUAL SPACES                       
P00836              PERFORM 2500-GET-RENEW-BY-DATE                      
P00836                                            THRU 2500-EXIT        
P00836              IF WS-RENEW-BY-DATE EQUAL SPACES                    
P00836                 MOVE WS-REV-MONTH-PLUS-DT                        
P00836                                         TO WS-RENEW-BY-DATE      
P00836              END-IF                                              
P836MS           END-IF                                                 
P00836           MOVE WS-RENEW-BY-DATE(6:2)    TO WS-MM                 
P00836           PERFORM 2400-GET-MONTH           THRU 2400-EXIT        
P00836        END-IF                                                    
P00836****    INITIALIZE S-MESSAGE-PARMS                                        
P00836****    SET BUS-RULE-NOT-FOUND                                            
P00836****        NOT-END-OF-SEARCH            TO TRUE                          
P00836****    MOVE 'WCM0000017'                TO WS-RULE-ID                    
P00836****    PERFORM 2300-RULE-XREF              THRU 2300-EXIT                
P00836****            UNTIL BUS-RULE-FOUND OR END-OF-SEARCH                     
P00836****    STRING  WS-MONTH                                                  
P00836****            ', '                                                      
P00836****            WS-RENEW-BY-DATE(1:4)                                     
P00836****            DELIMITED BY '  '                                         
P00836****            INTO S-MESSAGE-PARMS-TEXT                                 
P00836****    END-STRING                                                        
P00836****    MOVE LENGTH OF S-MESSAGE-PARMS-TEXT                               
P00836****                                     TO S-MESSAGE-PARMS-LEN           
P836MS        MOVE WS-RENEW-BY-DATE            TO S-CURR-RATE-EXP-DT    
P892NW        MOVE WS-RENEW-BY-DATE(1:4)       TO WS-AR-CDATE-YYYY      
P892NW        MOVE WS-RENEW-BY-DATE(6:2)       TO WS-AR-CDATE-MM        
P892NW        MOVE '28'                        TO WS-AR-CDATE-DD        
P892NW        MOVE WS-AR-CALL-BY-DATE          TO S-AR-CALL-BY-DATE     
P836MS        STRING  WS-MONTH                                          
P836MS                ' '                                               
P836MS                WS-RENEW-BY-DATE(1:4)                             
P836MS                DELIMITED BY '  '                                 
P836MS                INTO S-CURR-RATE-EXP-TXT                          
P836MS        END-STRING                                                
P892NW        IF (S-SHOW-RENEWAL-OPT        EQUAL 'Y'                   
OTPOOL            AND WS-WEB-RENEWAL-FL     EQUAL 'Y'                   
P892NW            AND S-PEND-OPT-EXIST-FL   EQUAL 'N'                   
P892NW            AND DF-AUTO-REN-OPT-IN-FL EQUAL 'I'                   
P892NW            AND S-FF-DURATION-REM     EQUAL 2                     
P892NW            AND AT-CODE-ACCT-STAT     EQUAL WS-ACTIVE)            
P892NW           IF S-CURR-RATE-EXP-DT NOT EQUAL SPACES                 
P892NW              EXEC SQL                                            
P892NW                 SELECT
              DATEADD(MONTH, 1, IIF(TRY_CONVERT(DATE, 
                                                    :S-CURR-RATE-EXP-DT
              ) IS NULL OR (PATINDEX('%.%', :S-CURR-RATE-EXP-DT
              ) <> 0) OR (LEN(:S-CURR-RATE-EXP-DT
              ) <> 10), CIS.CHAR2DATE(:S-CURR-RATE-EXP-DT
              ), CONVERT(DATE, :S-CURR-RATE-EXP-DT) ))
            INTO
              :WS-REV-MONTH-PLUS-DT                     
P892NW              END-EXEC                                            

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*             EXEC SQL                                                    
MFA-TR*                VALUES ADD_MONTHS(:S-CURR-RATE-EXP-DT,1)                 
MFA-TR*                  INTO :WS-REV-MONTH-PLUS-DT                             
MFA-TR*             END-EXEC                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P892NW              MOVE WS-REV-MONTH-PLUS-DT(6:2)                      
P892NW                                         TO WS-MM                 
P892NW              PERFORM 2400-GET-MONTH        THRU 2400-EXIT        
P892NW              STRING  WS-MONTH                                    
P892NW                      ' '                                         
P892NW                      WS-REV-MONTH-PLUS-DT(1:4)                   
P892NW                      DELIMITED BY '  '                           
P892NW                      INTO S-PEND-RATE-EFF-TXT                    
P892NW              END-STRING                                          
P892NW           END-IF                                                 
P892NW        END-IF                                                    
P00836****    PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT                
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF WS-RULE-ID EQUAL SPACES                                   
P00836        PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT        
P00836     END-IF.                                                      
P00836                                                                  
P00836 2200-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 2300-RULE-XREF.                                                  
P00836                                                                  
P00836     MOVE SPACES                         TO WS-RULE-XREF-ID.      
P00836     SET BUS-RULE-INDX TO +1.                                     
P00836     SEARCH BUS-RULES                                             
P00836        AT END                                                    
P00836           MOVE SPACES                   TO WS-RULE-XREF-ID       
P00836         WHEN BUS-RULE-ID (BUS-RULE-INDX) = LOW-VALUES OR SPACES  
P00836              SET END-OF-SEARCH          TO TRUE                  
P00836         WHEN BUS-RULE-ID             (BUS-RULE-INDX) = WS-RULE-ID
P00836          AND BUS-RULE-COMPANY-NO     (BUS-RULE-INDX) = WS-COMP-NO
P00836              MOVE BUS-RULE-XREF-ID   (BUS-RULE-INDX)             
P00836                                         TO WS-RULE-XREF-ID       
P00836              MOVE BUS-RULE-MESSAGE-ID(BUS-RULE-INDX)             
P00836                                         TO WS-RULE-MESSAGE-ID    
P00836              MOVE BUS-RULE-RESULT-CD (BUS-RULE-INDX)             
P00836                                         TO WS-RULE-RESULT-CD     
P00836              SET  BUS-RULE-FOUND        TO TRUE                  
P00836     END-SEARCH.                                                  
P00836                                                                  
P00836     MOVE WS-RULE-MESSAGE-ID             TO S-BUS-RULE-MSG-ID.    
P00836     MOVE WS-RULE-XREF-ID                TO S-BUS-RULE-XREF-ID.   
P00836     MOVE WS-RULE-RESULT-CD              TO S-BUS-RULE-RESULT-CD. 
P00836                                                                  
P00836 2300-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 2400-GET-MONTH.                                                  
P00836                                                                  
P00836     MOVE SPACES TO WS-MONTH.                                     
P00836                                                                  
P00836     EVALUATE WS-MM                                               
P00836         WHEN '01'                                                
P00836            MOVE 'January'   TO WS-MONTH                          
P00836         WHEN '02'                                                
P00836            MOVE 'February'  TO WS-MONTH                          
P00836         WHEN '03'                                                
P00836            MOVE 'March'     TO WS-MONTH                          
P00836         WHEN '04'                                                
P00836            MOVE 'April'     TO WS-MONTH                          
P00836         WHEN '05'                                                
P00836            MOVE 'May'       TO WS-MONTH                          
P00836         WHEN '06'                                                
P00836            MOVE 'June'      TO WS-MONTH                          
P00836         WHEN '07'                                                
P00836            MOVE 'July'      TO WS-MONTH                          
P00836         WHEN '08'                                                
P00836            MOVE 'August'    TO WS-MONTH                          
P00836         WHEN '09'                                                
P00836            MOVE 'September' TO WS-MONTH                          
P00836         WHEN '10'                                                
P00836            MOVE 'October'   TO WS-MONTH                          
P00836         WHEN '11'                                                
P00836            MOVE 'November'  TO WS-MONTH                          
P00836         WHEN '12'                                                
P00836            MOVE 'December'  TO WS-MONTH                          
P00836         WHEN OTHER                                               
P00836            MOVE 'Unknown'   TO WS-MONTH                          
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 2400-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 2500-GET-RENEW-BY-DATE.                                          
P00836                                                                  
P00836     MOVE SPACES                     TO WS-RENEW-BY-DATE.         
P00836                                                                  
P00836     IF AT-REV-MTH-LST-NRML = ZEROES                              
P00836        PERFORM 2600-NO-REV-MONTH       THRU 2600-EXIT            
P00836        MOVE BN-REVENUE-MONTH        TO WS-REV-MONTH-NUM          
P00836     ELSE                                                         
P00836        MOVE AT-REV-MTH-LST-NRML     TO WS-REV-MONTH-NUM          
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF WS-REV-MONTH-NUM > 0                                      
P00836        PERFORM 2700-DETERMINE-DATES    THRU 2700-EXIT            
P00836     END-IF.                                                      
P00836                                                                  
P00836 2500-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 2600-NO-REV-MONTH.                                               
P00836                                                                  
P00836     PERFORM 7004-GET-CURRENT-DATE      THRU 7004-EXIT.           
P00836     MOVE WS-PARM-DT                 TO BN-DATE-EXTRACT.          
P00836                                                                  
P00836     MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE.            
P00836     PERFORM 7005-BILL-WINDOW           THRU 7005-EXIT.           
P00836                                                                  
P00836     IF BN-REVENUE-MONTH = ZEROES AND AT-CODE-ACCT-STAT = 'P'     
P00836        MOVE UT-READ-CYCLE           TO BN-BILL-CYCLE             
P00836        PERFORM 7005-BILL-WINDOW        THRU 7005-EXIT            
P00836     END-IF.                                                      
P00836                                                                  
P00836 2600-EXIT.                                                       
P00836     EXIT.                                                        
P00836                                                                  
P00836 2700-DETERMINE-DATES.                                            
P00836                                                                  
P00836****CALCULATE THE RENEW BY DATE FOR THE FIXED RATE                        
P00836     MOVE WS-REV-MONTH-CHAR(1:4)     TO WS-REV-MONTH-DT(1:4).     
P00836     MOVE WS-REV-MONTH-CHAR(5:2)     TO WS-REV-MONTH-DT(6:2).     
P00836     MOVE '01'                       TO WS-REV-MONTH-DT(9:2).     
P00836     MOVE '-'                        TO WS-REV-MONTH-DT(5:1)      
P00836                                        WS-REV-MONTH-DT(8:1).     
P00836     MOVE S-FF-DURATION-REM          TO WS-DURATION-REM-NUM.      
P00836                                                                  
P00836     IF AT-REV-MTH-LST-NRML = ZEROES AND WS-DURATION-REM-NUM > 0  
P00836        COMPUTE WS-DURATION-REM-NUM  EQUAL WS-DURATION-REM-NUM - 1
P00836     END-IF.                                                      
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT
              DATEADD(MONTH, :WS-DURATION-REM-NUM, 
              IIF(TRY_CONVERT(DATE, :WS-REV-MONTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REV-MONTH-DT
              ) <> 0) OR (LEN(:WS-REV-MONTH-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-REV-MONTH-DT
              ), CONVERT(DATE, :WS-REV-MONTH-DT) ))
            INTO
              :WS-REV-MONTH-PLUS-DT                              
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES ADD_MONTHS(:WS-REV-MONTH-DT,:WS-DURATION-REM-NUM)          
MFA-TR*         INTO :WS-REV-MONTH-PLUS-DT                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     IF WS-REV-MONTH-PLUS-DT(1:4) NUMERIC AND                     
P00836           WS-REV-MONTH-PLUS-DT(6:2) NUMERIC                      
P00836        MOVE WS-REV-MONTH-PLUS-DT(1:4)                            
P00836                                     TO WS-REV-MONTH-PLUS-NUM(1:4)
P00836        MOVE WS-REV-MONTH-PLUS-DT(6:2)                            
P00836                                     TO WS-REV-MONTH-PLUS-NUM(5:2)
P00836        MOVE WS-REV-MONTH-PLUS-NUM   TO BN-REVENUE-MONTH          
P00836        MOVE AT-BILL-CYCLE           TO BN-BILL-CYCLE             
P00836        PERFORM 7006-BILL-WINDOW        THRU 7006-EXIT            
P00836        MOVE BN-DATE-EXTRACT         TO WS-RENEW-BY-DATE          
P00836     END-IF.                                                      
P00836                                                                  
P00836 2700-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00680***************************************************************** 04130000
P00680* 6000-CALL-MCSCB063-PGM                                        * 04130100
P00680***************************************************************** 04130200
P00680 6000-CALL-MCSCB063-PGM.                                          
P00680                                                                  
P00680     MOVE SPACES                      TO ABEND-FUNCTION.          
P00680     INITIALIZE  LS-CWS063-RETURN-FIELDS.                         
P00680*                                                                 04131500
P00680     CALL MCSCB063  USING   CWS00063-FIELDS,                      
P00680                            ABEND-FILE,                           
P00680                            RS-RETURN-CODE-1.                     
P00680                                                                  
P00680     MOVE RS-RETURN-CODE-1            TO WS-ACTIVE-RETURN-CODE.   
P00680     IF WS-ACTIVE-RETURN-CODE EQUAL WS-ZERO AND                   
P00680        ABEND-FUNCTION EQUAL SPACES                               
P00680        CONTINUE                                                  
P00680     ELSE                                                         
P00680        INITIALIZE GTT-RETURN-FIELDS                              
P00680        MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE-1          
P00836                                         S-RETURN-CODE-2          
P00836        PERFORM 9700-PROCESS-ABEND       THRU  9700-EXIT          
P00680     END-IF.                                                      
P00680                                                                  
P00680 6000-EXIT.                                                       
P00680     EXIT.                                                        
                                                                        
P892NW******************************************************************        
P892NW* 6500-CALL-MCSCB328.                                            *        
P892NW*      GET RENEWAL OPTIONS.                                      *        
P892NW******************************************************************        
P892NW 6500-CALL-MCSCB328.                                              
P892NW                                                                  
P892NW**** GET RENEWAL OPTIONS FOR THE CURRENT RATE.                            
P892NW     MOVE PROGRAM-NAME                TO WS-CPD00328-CALLING-PGM. 
P892NW     MOVE PARM-ACCOUNT-NO-DEC         TO WS-IN-ACCOUNT-NO.        
P892NW     MOVE PARM-OPTION-CD              TO WS-IN-OPTION-CD.         
P892NW     MOVE PARM-CODE-UTIL-TYPE         TO WS-IN-CODE-UTIL-TYPE.    
P892NW     MOVE PARM-IC-NO-DEC              TO WS-IN-IC-NO.             
P892NW                                                                  
P892NW     MOVE SPACES                      TO ABEND-FUNCTION.          
P892NW     INITIALIZE WS-RESULT-TABLE.                                  
P892NW                                                                  
P892NW     CALL MCSCB328  USING   CWS00328-FIELDS,                      
P892NW                            WS-RESULT-TABLE,                      
P892NW                            ABEND-FILE,                           
P892NW                            RETURN-CODE-328.                      
P892NW                                                                  
P892NW     MOVE RETURN-CODE-328             TO  WS-ACTIVE-RETURN-CODE.  
P892NW                                                                  
P892NW     IF WS-SUB-CTR = 0 OR ABEND-FUNCTION > SPACES                 
P892NW        INITIALIZE WS-RESULT-TABLE                                
P892NW                   GTT-RETURN-FIELDS                              
P892NW        MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE-1          
P892NW                                         S-RETURN-CODE-2          
P892NW        PERFORM 9700-PROCESS-ABEND       THRU  9700-EXIT          
P892NW     END-IF.                                                      
P892NW                                                                  
P892NW 6500-EXIT.                                                       
P892NW     EXIT.                                                        
P892NW                                                                  
      *                                                                 04140000
P00836 7000-OPEN-RULE-CURSOR.                                           
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN RULE-CURSOR                                         
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7000'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'OPEN'                 TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7000-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7001-FETCH-RULE-CURSOR.                                          
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         FETCH RULE-CURSOR                                        
P00836          INTO :1T-BUS-RULE-ID                                    
P00836              ,:1T-BUS-RULE-XREF-ID                               
P00836              ,:1T-COMPANY-NO                                     
P00836              ,:1S-RULE-MESSAGE-ID                                
P00836              ,:1S-RULE-RESULT-CD                                 
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836         WHEN NOT-FOUND                                           
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7001'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'FETCH'                TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7001-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7002-CLOSE-RULE-CURSOR.                                          
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         CLOSE RULE-CURSOR                                        
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7002'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'CLOSE'                TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BUS_RULE_XREF'    TO TABLE-1               
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7002-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7003-GET-ACCOUNT-DETAIL.                                         
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT TOP(1) AT.BILL_CYCLE,
              AT.CODE_ACCT_STAT,
              AT.REV_MTH_LST_NRML,
              AT.CODES_DATA_PRESENT,
              UT.READ_CYCLE,
              COALESCE(B1.DIVISION_NO,'   ')                     
P00836           INTO :AT-BILL-CYCLE                                    
P00836               ,:AT-CODE-ACCT-STAT                                
P00836               ,:AT-REV-MTH-LST-NRML                              
P836NW               ,:AT-CODES-DATA-PRESENT                            
P00836               ,:UT-READ-CYCLE                                    
OTPOOL               ,:B1-DIVISION-NO                                   
P00836           FROM  CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                
P00836               , CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
OTPOOL               , CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                
P00836          WHERE  AT.ACCOUNT_NO   =  UT.ACCOUNT_NO                 
P00836            AND  AT.ACCOUNT_NO   = :PARM-ACCOUNT-NO-DEC           
OTPOOL            AND  B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE               
OTPOOL            AND  B1.COMPANY_NO   =  AT.COMPANY_NO                 
OTPOOL                                              
OTPOOL                                                           
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  AT.BILL_CYCLE                                            
MFA-TR*              , AT.CODE_ACCT_STAT                                        
MFA-TR*              , AT.REV_MTH_LST_NRML                                      
MFA-TR*              , AT.CODES_DATA_PRESENT                                    
MFA-TR*              , UT.READ_CYCLE                                            
MFA-TR*              , IFNULL(B1.DIVISION_NO,'   ')                             
MFA-TR*          INTO :AT-BILL-CYCLE                                            
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-CODES-DATA-PRESENT                                    
MFA-TR*              ,:UT-READ-CYCLE                                            
MFA-TR*              ,:B1-DIVISION-NO                                           
MFA-TR*          FROM  CSS_ACCOUNT      AT                                      
MFA-TR*              , CSS_UTIL_ENVRNMT UT                                      
MFA-TR*              , CSS_LOCAL_OFFICE B1                                      
MFA-TR*         WHERE  AT.ACCOUNT_NO   =  UT.ACCOUNT_NO                         
MFA-TR*           AND  AT.ACCOUNT_NO   = :PARM-ACCOUNT-NO-DEC                   
MFA-TR*           AND  B1.LOCAL_OFFICE =  AT.LOCAL_OFFICE                       
MFA-TR*           AND  B1.COMPANY_NO   =  AT.COMPANY_NO                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT 
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7003'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_ACCOUNT'          TO TABLE-1               
P00836             MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-2               
P00836             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00836             MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7003-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7004-GET-CURRENT-DATE.                                           
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-PARM-DT                            
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-PARM-DT = CURRENT DATE                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7004'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_MODEL_SQL'        TO TABLE-1               
P00836             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00836             MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7004-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7005-BILL-WINDOW.                                                
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT  MIN(BN.REVENUE_MONTH)                            
P00836           INTO :BN-REVENUE-MONTH :WS-NULL-01                      
P00836           FROM  CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
P00836          WHERE  BN.DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )              
P00836            AND  BN.BILL_CYCLE    = :BN-BILL-CYCLE                
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MIN(BN.REVENUE_MONTH)                                    
MFA-TR*          INTO :BN-REVENUE-MONTH:WS-NULL-01                              
MFA-TR*          FROM  CSS_BILL_WINDOW BN                                       
MFA-TR*         WHERE  BN.DATE_EXTRACT >= :BN-DATE-EXTRACT                      
MFA-TR*           AND  BN.BILL_CYCLE    = :BN-BILL-CYCLE                        
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7005                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             IF WS-NULL-01 < 0                                    
P00836                MOVE ZEROES              TO BN-REVENUE-MONTH      
P00836             END-IF                                               
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7005'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BILL_WINDOW'      TO TABLE-1               
P00836             MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1       
P00836             MOVE AT-BILL-CYCLE          TO HOSTVAR-ELEMENT-1     
P00836             MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-2       
P00836             MOVE BN-REVENUE-MONTH       TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7005-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7006-BILL-WINDOW.                                                
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT MIN(DATE_EXTRACT)                                  
P00836          INTO :BN-DATE-EXTRACT :WS-NULL-02                        
P00836          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
P00836         WHERE BILL_CYCLE    = :BN-BILL-CYCLE                     
P00836           AND REVENUE_MONTH = :BN-REVENUE-MONTH                  
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(DATE_EXTRACT)                                          
MFA-TR*         INTO :BN-DATE-EXTRACT:WS-NULL-02                                
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :BN-BILL-CYCLE                             
MFA-TR*          AND REVENUE_MONTH = :BN-REVENUE-MONTH                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7006                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             IF WS-NULL-02 < 0                                    
P00836                MOVE SPACES              TO BN-DATE-EXTRACT       
P00836             END-IF                                               
P00836         WHEN NOT-FOUND                                           
P00836             MOVE ZEROES                 TO WS-ACTIVE-RETURN-CODE 
P00836             MOVE SPACES                 TO BN-DATE-EXTRACT       
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7006'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_BILL_WINDOW'      TO TABLE-1               
P00836             MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1       
P00836             MOVE BN-BILL-CYCLE          TO HOSTVAR-ELEMENT-1     
P00836             MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-2       
P00836             MOVE BN-REVENUE-MONTH       TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7006-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7007-SELECT-DELINQENCY.                                          
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT  DELINQ_VALUE                                      
P00836          INTO :C8-DELINQ-VALUE                                   
P00836          FROM  CSS_DELINQUENCY  C8 WITH(READUNCOMMITTED)                 
P00836         WHERE  C8.DELINQ_CD  = :C8-DELINQ-CD                     
P00836           AND  C8.COMPANY_NO = :C8-COMPANY-NO                    
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY  C8                                       
MFA-TR*        WHERE  C8.DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*          AND  C8.COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7007                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7007'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_DELINQUENCY'      TO TABLE-1               
P00836             MOVE 'DELINQ_CD'            TO TABLE-ELEMENT-1       
P00836             MOVE C8-DELINQ-CD           TO HOSTVAR-ELEMENT-1     
P00836             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-2       
P00836             MOVE C8-COMPANY-NO          TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7007-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7008-ADD-DAYS.                                                   
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT
              DATEADD( DAY, -1, DATEADD( DAY, :WS-3DAY-ROR-DAYS, 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) ) ) )
            INTO
              :WS-ROR-RESULT-DATE                 
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-ROR-RESULT-DATE =                                        
MFA-TR*                DATE(DATE(:DF-OPT-AGRMT-EFF-DT)                          
MFA-TR*             + (:WS-3DAY-ROR-DAYS DAYS) - 1 DAY)                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7008'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_MODEL_SQL'        TO TABLE-1               
P00836             MOVE 'OPTION EFF_DT'        TO TABLE-ELEMENT-1       
P00836             MOVE DF-OPT-AGRMT-EFF-DT    TO HOSTVAR-ELEMENT-1     
P00836             MOVE 'ROR END DATE'         TO TABLE-ELEMENT-2       
P00836             MOVE WS-ROR-RESULT-DATE     TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7008-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7009-GET-CUSTOMER-DOB.                                           
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT  CE.DATE_OF_BIRTH                                  
P00836          INTO :WS-CUSTOMER-DOB :WS-NULL-03                        
P00836          FROM  CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                   
P00836               ,CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
P00836         WHERE  AT.ACCOUNT_NO     = :PARM-ACCOUNT-NO-DEC          
P00836           AND  CE.CUSTOMER_NO    =  AT.CUSTOMER_NO               
P00836           AND  CE.CUSTOMER_TYPE  = 'C'                           
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CE.DATE_OF_BIRTH                                          
MFA-TR*         INTO :WS-CUSTOMER-DOB:WS-NULL-03                                
MFA-TR*         FROM  CSS_ACCOUNT    AT                                         
MFA-TR*              ,CSS_CUST_STATS CE                                         
MFA-TR*        WHERE  AT.ACCOUNT_NO     = :PARM-ACCOUNT-NO-DEC                  
MFA-TR*          AND  CE.CUSTOMER_NO    =  AT.CUSTOMER_NO                       
MFA-TR*          AND  CE.CUSTOMER_TYPE  = 'C'                                   
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7009                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             IF WS-NULL-03 < 0                                    
P00836                MOVE SPACES              TO WS-CUSTOMER-DOB       
P00836             END-IF                                               
P00836         WHEN NOT-FOUND                                           
P00836             MOVE SPACES                 TO WS-CUSTOMER-DOB       
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7009'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00836             MOVE 'CSS_ACCOUNT'          TO TABLE-1               
P00836             MOVE 'CSS_CUST_STATS'       TO TABLE-2               
P00836             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00836             MOVE PARM-ACCOUNT-NO-DEC    TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7009-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836 7010-GET-YEARS.                                                  
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT
              ( 12 *                             
P00836                                  CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-CUSTOMER-DOB
              ) IS NULL OR (PATINDEX('%.%', :WS-CUSTOMER-DOB
              ) <> 0) OR (LEN(:WS-CUSTOMER-DOB) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUSTOMER-DOB
              ), CONVERT(DATE, :WS-CUSTOMER-DOB) ) ))       
P00836                                  + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-CUSTOMER-DOB
              ) IS NULL OR (PATINDEX('%.%', :WS-CUSTOMER-DOB
              ) <> 0) OR (LEN(:WS-CUSTOMER-DOB) <> 10), CIS.CHAR2DATE(
                                                       :WS-CUSTOMER-DOB
              ), CONVERT(DATE, :WS-CUSTOMER-DOB) ) ))       
P00836                               ) / 12
            INTO
              :WS-NO-OF-YEARS                             
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-OF-YEARS =  ( 12 *                                     
MFA-TR*                                 YEAR(DATE(:WS-CURRENT-DATE)             
MFA-TR*                                 - DATE(:WS-CUSTOMER-DOB))               
MFA-TR*                                 + MONTH(DATE(:WS-CURRENT-DATE)          
MFA-TR*                                 - DATE(:WS-CUSTOMER-DOB))               
MFA-TR*                              ) / 12                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836             CONTINUE                                             
P00836         WHEN OTHER                                               
P00836             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00836             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00836             MOVE SQLCODE                TO ABEND-SQLCODE         
P00836             MOVE '7010'                 TO ACTIVE-PARAGRAPH      
P00836             MOVE 'SET'                  TO ABEND-FUNCTION        
P00836             MOVE 'CSS_MODEL_SQL'        TO TABLE-1               
P00836             MOVE 'DATE_OF_BIRTH'        TO TABLE-ELEMENT-1       
P00836             MOVE WS-CUSTOMER-DOB        TO HOSTVAR-ELEMENT-1     
P00836             MOVE 'CURRENT_DATE'         TO TABLE-ELEMENT-2       
P00836             MOVE WS-CURRENT-DATE        TO HOSTVAR-ELEMENT-2     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7010-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00892                                                                  
P00892 7011-GET-SEASONAL-FL.                                            
P00892                                                                  
P00892     EXEC SQL                                                     
P00892        SELECT  TA.SEASONAL_FL                                    
P00892          INTO :TA-SEASONAL-FL                                    
P00892          FROM  CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
P00892         WHERE  TA.ACCOUNT_NO       = :TA-ACCOUNT-NO              
P00892                                                           
P00892                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TA.SEASONAL_FL                                            
MFA-TR*         INTO :TA-SEASONAL-FL                                            
MFA-TR*         FROM  CSS_ACCT_MISC_INFO TA                                     
MFA-TR*        WHERE  TA.ACCOUNT_NO       = :TA-ACCOUNT-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7011                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00892                                                                  
P00892     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00892         WHEN SUCCESSFUL-CALL                                     
P00892             CONTINUE                                             
P00892         WHEN NOT-FOUND                                           
P00892             MOVE SPACES                 TO TA-SEASONAL-FL        
P00892         WHEN OTHER                                               
P00892             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
P00892             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00892             MOVE SQLCODE                TO ABEND-SQLCODE         
P00892             MOVE '7011'                 TO ACTIVE-PARAGRAPH      
P00892             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00892             MOVE 'CSS_ACCT_MISC_INFO'   TO TABLE-1               
P00892             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00892             MOVE TA-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00892             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00892     END-EVALUATE.                                                
P00892                                                                  
P00892 7011-EXIT.                                                       
P00892     EXIT.                                                        
                                                                        
OTPMSG 7012-GET-POOL-GO-DATE.                                           
OTPMSG                                                                  
OTPMSG     EXEC SQL                                                     
OTPMSG        SELECT  G6.PARM_DATA                                      
OTPMSG          INTO :G6-PARM-DATA                                      
OTPMSG          FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                    
OTPMSG         WHERE  G6.PROGRAM_NAME        = 'CPD00328'               
OTPMSG           AND  G6.COMPANY_NO          = '01'                     
OTPMSG           AND  G6.CMND_CODE           = 'DATE'                   
OTPMSG           AND  G6.SEQ_NO              = :G6-SEQ-NO               
OTPMSG           AND  G6.STATUS              = 'A'                      
OTPMSG           AND  CIS.SUBSTR3(PARM_DATA,1,13) = 'POOL_GO_DATE='          
OTPMSG                                                           
OTPMSG                                                      
OTPMSG     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  G6.PARM_DATA                                              
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM  CSS_JOB_PARM  G6                                          
MFA-TR*        WHERE  G6.PROGRAM_NAME        = 'CPD00328'                       
MFA-TR*          AND  G6.COMPANY_NO          = '01'                             
MFA-TR*          AND  G6.CMND_CODE           = 'DATE'                           
MFA-TR*          AND  G6.SEQ_NO              = :G6-SEQ-NO                       
MFA-TR*          AND  G6.STATUS              = 'A'                              
MFA-TR*          AND  SUBSTR(PARM_DATA,1,13) = 'POOL_GO_DATE='                  
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7012                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPMSG                                                                  
OTPMSG     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
OTPMSG                                                                  
OTPMSG     EVALUATE WS-ACTIVE-RETURN-CODE                               
OTPMSG         WHEN SUCCESSFUL-CALL                                     
OTPMSG         WHEN NOT-FOUND                                           
OTPMSG             CONTINUE                                             
OTPMSG         WHEN OTHER                                               
OTPMSG             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-2      
OTPMSG             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
OTPMSG             MOVE SQLCODE                TO ABEND-SQLCODE         
OTPMSG             MOVE '7012'                 TO ACTIVE-PARAGRAPH      
OTPMSG             MOVE 'SELECT'               TO ABEND-FUNCTION        
OTPMSG             MOVE 'CSS_JOB_PARM'         TO TABLE-1               
OTPMSG             MOVE 'PROGRAM_NAME'         TO TABLE-ELEMENT-1       
OTPMSG             MOVE 'CPD00328'             TO HOSTVAR-ELEMENT-1     
OTPMSG             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
OTPMSG     END-EVALUATE.                                                
OTPMSG                                                                  
OTPMSG 7012-EXIT.                                                       
OTPMSG     EXIT.                                                        
                                                                        
P00892                                                                  
P00892 7076-ADD-DAYS-GRACE-PERIOD.                                      
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         SELECT
              DATEADD( DAY, :WS-90DAY-GRACE-PERIOD, 
              IIF(TRY_CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) ) )
            INTO
              :WS-ROR-RESULT-DATE 
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-ROR-RESULT-DATE = DATE(DATE(:DF-OPT-AGRMT-EFF-DT)        
MFA-TR*                                + (:WS-90DAY-GRACE-PERIOD DAYS))         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00892                                                                  
P00892     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00892        NEXT SENTENCE                                             
P00892     ELSE                                                         
P00892        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00892        MOVE '7076'                    TO ACTIVE-PARAGRAPH        
P00892        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00892        MOVE 'SET '                    TO TABLE-1                 
P00892        MOVE 'OPTION EFF_DT'           TO TABLE-ELEMENT-1         
P00892        MOVE '90 DAY GRACE'            TO TABLE-ELEMENT-2         
P00892        MOVE DF-OPT-AGRMT-EFF-DT       TO HOSTVAR-ELEMENT-1       
P00892        MOVE WS-ROR-RESULT-DATE        TO HOSTVAR-ELEMENT-2       
P00892        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
P00892        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
P00892     END-IF.                                                      
P00892                                                                  
P00892 7076-EXIT.                                                       
P00892     EXIT.                                                        
P00892                                                                  
       7100-SELECT-OPTION-DESC.                                         
                                                                        
           EXEC SQL                                                     
P00836        SELECT LTRIM(RTRIM(FI.CURR_EXT_DESC_LONG))                        
P836MS              ,LTRIM(RTRIM(FI.WEB_MKT_DESC_LONG))                         
                INTO :FI-CURR-EXT-DESC-LONG                             
P836MS              ,:FI-WEB-MKT-DESC-LONG                              
                FROM CRM_RT_PKG_OPTION FI                               
               WHERE FI.OPTION_CD      = :WS-OPTION-CD                  
P00473           AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()              
P00473           AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()              
P00473           AND FI.PROC_STATUS_CD = 'AC'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04170000
MFA-TR*       SELECT TRIM(FI.CURR_EXT_DESC_LONG)                        04180000
MFA-TR*             ,TRIM(FI.WEB_MKT_DESC_LONG)                                 
MFA-TR*         INTO :FI-CURR-EXT-DESC-LONG                             04190000
MFA-TR*             ,:FI-WEB-MKT-DESC-LONG                                      
MFA-TR*         FROM CRM_RT_PKG_OPTION FI                               04200000
MFA-TR*        WHERE FI.OPTION_CD      = :WS-OPTION-CD                  04210000
MFA-TR*          AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP              04211000
MFA-TR*          AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP              04212000
MFA-TR*          AND FI.PROC_STATUS_CD = 'AC'                           04213000
MFA-TR*    END-EXEC.                                                    04220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE FI-CURR-EXT-DESC-LONG-TEXT                      
A01339                       (1:FI-CURR-EXT-DESC-LONG-LEN)              
P00836               TO WS-CURR-EXT-DESC-LONG-TEXT                      
P00836             MOVE LENGTH OF WS-CURR-EXT-DESC-LONG-TEXT            
P00836               TO WS-CURR-EXT-DESC-LONG-LEN                       
P836MS             MOVE FI-WEB-MKT-DESC-LONG-TEXT                       
P836MS                       (1:FI-WEB-MKT-DESC-LONG-LEN)               
P836MS               TO WS-CURR-WMKT-DESC-LONG-TEXT                     
P836MS             MOVE LENGTH OF WS-CURR-WMKT-DESC-LONG-TEXT           
P836MS               TO WS-CURR-WMKT-DESC-LONG-LEN                      
              WHEN NOT-FOUND                                            
P00836             INITIALIZE WS-CURR-EXT-DESC-LONG                     
              WHEN OTHER                                                
                   MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE '7100'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CRM_RT_PKG_OPTION'    TO TABLE-1               
                   MOVE 'OPTION_CD'            TO TABLE-ELEMENT-1       
                   MOVE WS-OPTION-CD           TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 04480000
       7200-SELECT-WEB-RENEWAL.                                         
      *                                                                 04500000
           EXEC SQL                                                     
              SELECT TOP(1) TT.TIER_ACCT_TYPE_CD,
              TT.WEB_RENEWAL_FL,
              DD.TIER_CUST_STAT_CD                               
                INTO :TT-TIER-ACCT-TYPE-CD                              
                    ,:TT-WEB-RENEWAL-FL                                 
P00836              ,:DD-TIER-CUST-STAT-CD                              
                FROM CSS_ACCT_MKT_TIER  DD WITH(READUNCOMMITTED)                
                    ,CRM_TIER_ACCT_TYPE TT WITH(READUNCOMMITTED)                
               WHERE DD.ACCOUNT_NO = :DD-ACCOUNT-NO                     
                 AND DD.TIER_ACCT_TYPE_CD = TT.TIER_ACCT_TYPE_CD        
                 AND DD.COMPANY_NO   = TT.COMPANY_NO                    
                 AND DD.EFF_START_DT = (                                
                          SELECT MAX(DD1.EFF_START_DT)                  
                            FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                  
                           WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)        
                                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04510000
MFA-TR*       SELECT TT.TIER_ACCT_TYPE_CD                               04520000
MFA-TR*             ,TT.WEB_RENEWAL_FL                                  04530000
MFA-TR*             ,DD.TIER_CUST_STAT_CD                                       
MFA-TR*         INTO :TT-TIER-ACCT-TYPE-CD                              04540000
MFA-TR*             ,:TT-WEB-RENEWAL-FL                                 04550000
MFA-TR*             ,:DD-TIER-CUST-STAT-CD                                      
MFA-TR*         FROM CSS_ACCT_MKT_TIER  DD                              04560000
MFA-TR*             ,CRM_TIER_ACCT_TYPE TT                              04570000
MFA-TR*        WHERE DD.ACCOUNT_NO = :DD-ACCOUNT-NO                     04580000
MFA-TR*          AND DD.TIER_ACCT_TYPE_CD = TT.TIER_ACCT_TYPE_CD        04590000
MFA-TR*          AND DD.COMPANY_NO   = TT.COMPANY_NO                    04600000
MFA-TR*          AND DD.EFF_START_DT = (                                04610000
MFA-TR*                   SELECT MAX(DD1.EFF_START_DT)                  04620000
MFA-TR*                     FROM CSS_ACCT_MKT_TIER DD1                  04630000
MFA-TR*                    WHERE DD1.ACCOUNT_NO = DD.ACCOUNT_NO)        04640000
MFA-TR*        FETCH FIRST 1 ROW ONLY                                   04650000
MFA-TR*         WITH UR                                                 04660000
MFA-TR*    END-EXEC.                                                    04670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE TT-TIER-ACCT-TYPE-CD   TO WS-TIER-ACCT-TYPE-CD  
                   MOVE TT-WEB-RENEWAL-FL      TO WS-WEB-RENEWAL-FL     
P836NW**** PRE PAY CUSTOMERS CANNOT CHANGE THEIR RATE ON WEB                    
P836NW             IF WS-CODE-PRE-PAY-PLAN = 'A'                        
P836NM                MOVE 'N'                 TO WS-WEB-RENEWAL-FL     
P836NW             END-IF                                               
              WHEN NOT-FOUND                                            
                   MOVE SPACES                 TO WS-TIER-ACCT-TYPE-CD  
                                                  WS-WEB-RENEWAL-FL     
              WHEN OTHER                                                
                   MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE '7200'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ACCT_MKT_TIER'    TO TABLE-1               
                   MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
                   MOVE DD-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04920000
       7300-SELECT-RATE-DEF-CD.                                         
      *                                                                 04940000
           EXEC SQL                                                     
              SELECT RD.RATE_DEFINITION_CD                              
P00805              ,RD.SENIOR_RATE_FL                                  
                INTO :RD-RATE-DEFINITION-CD                             
P00805              ,:RD-SENIOR-RATE-FL                                 
                FROM CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)               
               WHERE RD.RATE_PLAN_NO    = :RD-RATE-PLAN-NO              
                 AND RD.CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT RD.RATE_DEFINITION_CD                              04960000
MFA-TR*             ,RD.SENIOR_RATE_FL                                  04961004
MFA-TR*         INTO :RD-RATE-DEFINITION-CD                             04970000
MFA-TR*             ,:RD-SENIOR-RATE-FL                                 04971004
MFA-TR*         FROM CSS_RATE_PLAN_DESC  RD                             04980000
MFA-TR*        WHERE RD.RATE_PLAN_NO    = :RD-RATE-PLAN-NO              04990000
MFA-TR*          AND RD.CODE_UTIL_TYPE  = :RD-CODE-UTIL-TYPE            05000000
MFA-TR*         WITH UR                                                 05010000
MFA-TR*    END-EXEC.                                                    05020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   MOVE RD-RATE-DEFINITION-CD  TO WS-RATE-DEFINITION-CD 
              WHEN NOT-FOUND                                            
                   MOVE SPACES                 TO WS-RATE-DEFINITION-CD 
P00805                                            RD-SENIOR-RATE-FL     
              WHEN OTHER                                                
                   MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE SQLCODE                TO ABEND-SQLCODE         
                   MOVE '7300'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_RATE_PLAN_DESC'   TO TABLE-1               
                   MOVE 'RATE_PLAN_NO'         TO TABLE-ELEMENT-1       
                   MOVE RD-RATE-PLAN-NO        TO HOSTVAR-ELEMENT-1     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05250000
P00211 7400-SELECT-PEND-OPTION.                                         
P00211                                                                  
P00211     EXEC SQL                                                     
P00211         SELECT 'Y'                                               
P00836               ,LTRIM(RTRIM(FI.CURR_EXT_DESC_LONG))                       
P00892               ,LTRIM(RTRIM(FI.WEB_DESC_LONG))                            
P00892               ,DF.OPT_AGRMT_EFF_DT                               
P00805               ,DF.STATUS_EFF_REV_MTH                             
P00892               ,DF.OPTION_CD                                      
P00892               ,FI.OPT_CALC_TYPE_CD                               
P00836               ,FI.WEB_MKT_DESC_LONG                              
P00892               ,DF.AGREEMNT_SOURCE_CD                             
P00892               ,DF.AUTO_REN_OPT_IN_FL                             
P00211           INTO :WS-PEND-OPT-EXIST-FL                             
P00211               ,:FI-CURR-EXT-DESC-LONG                            
P00892               ,:FI-WEB-DESC-LONG                                 
P00892               ,:DF-OPT-AGRMT-EFF-DT                              
P00805               ,:DF-STATUS-EFF-REV-MTH                            
P00892               ,:DF-OPTION-CD                                     
P00892               ,:FI-OPT-CALC-TYPE-CD                              
P00836               ,:FI-WEB-MKT-DESC-LONG                             
P00892               ,:DF-AGREEMNT-SOURCE-CD                            
P00892               ,:DF-AUTO-REN-OPT-IN-FL                            
P00211           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
P00211               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
P00211          WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                
P00211            AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE            
P00211            AND DF.IC_NO          = :DF-IC-NO                     
P00211            AND DF.STATUS_CD      = :DF-STATUS-CD                 
P00211            AND FI.OPTION_CD      = DF.OPTION_CD                  
P00473            AND FI.OPT_VSTART_TS <= CIS.CURRENT$TIMESTAMP()             
P00473            AND FI.OPT_VEND_TS   >= CIS.CURRENT$TIMESTAMP()             
P00473            AND FI.PROC_STATUS_CD = 'AC'                          
P00211                                                           
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     05280000
MFA-TR*        SELECT 'Y'                                               05290000
MFA-TR*              ,TRIM(FI.CURR_EXT_DESC_LONG)                       05291000
MFA-TR*              ,TRIM(FI.WEB_DESC_LONG)                            05291000
MFA-TR*              ,DF.OPT_AGRMT_EFF_DT                               05291000
MFA-TR*              ,DF.STATUS_EFF_REV_MTH                             05292000
MFA-TR*              ,DF.OPTION_CD                                      05292000
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                               05292000
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                              05292000
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                             05292000
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*          INTO :WS-PEND-OPT-EXIST-FL                             05300000
MFA-TR*              ,:FI-CURR-EXT-DESC-LONG                            05301000
MFA-TR*              ,:FI-WEB-DESC-LONG                                 05301000
MFA-TR*              ,:DF-OPT-AGRMT-EFF-DT                              05301000
MFA-TR*              ,:DF-STATUS-EFF-REV-MTH                            05302000
MFA-TR*              ,:DF-OPTION-CD                                     05302000
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                              05302000
MFA-TR*              ,:FI-WEB-MKT-DESC-LONG                             05302000
MFA-TR*              ,:DF-AGREEMNT-SOURCE-CD                            05302000
MFA-TR*              ,:DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                              05310000
MFA-TR*              ,CRM_RT_PKG_OPTION FI                              05311000
MFA-TR*         WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                05320000
MFA-TR*           AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE            05330000
MFA-TR*           AND DF.IC_NO          = :DF-IC-NO                     05340000
MFA-TR*           AND DF.STATUS_CD      = :DF-STATUS-CD                 05350000
MFA-TR*           AND FI.OPTION_CD      = DF.OPTION_CD                  05351000
MFA-TR*           AND FI.OPT_VSTART_TS <= CURRENT TIMESTAMP             05352000
MFA-TR*           AND FI.OPT_VEND_TS   >= CURRENT TIMESTAMP             05353000
MFA-TR*           AND FI.PROC_STATUS_CD = 'AC'                          05354000
MFA-TR*          WITH UR                                                05360000
MFA-TR*    END-EXEC.                                                    05370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00211                                                                  
P00211     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00211        WHEN SUCCESSFUL-CALL                                      
P00211             CONTINUE                                             
P00211        WHEN NOT-FOUND                                            
P00836             MOVE 'N'                    TO WS-PEND-OPT-EXIST-FL  
P00805             MOVE ZEROS                  TO DF-STATUS-EFF-REV-MTH 
P00211        WHEN OTHER                                                
P00211             MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1      
P00211             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00211             MOVE SQLCODE                TO ABEND-SQLCODE         
P00211             MOVE '7400'                 TO ACTIVE-PARAGRAPH      
P00211             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00211             MOVE 'CSS_ACCT_RTPK_AGR'    TO TABLE-1               
P00211             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00211             MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2       
P00211             MOVE 'IC_NO'                TO TABLE-ELEMENT-3       
P00211             MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00211             MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2     
P00211             MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3     
P00836             PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT       
P00211     END-EVALUATE.                                                
P00211                                                                  
P00211 7400-EXIT.                                                       
P00211     EXIT.                                                        
P00211*                                                                 05640000
P00211 7410-SELECT-CURR-OPTION.                                         
P00211                                                                  
P00211     EXEC SQL                                                     
P00211         SELECT DF.STATUS_CD                                      
P00680               ,DF.STAT_ADJUSTABLE_CD                             
P00805               ,DF.STATUS_EFF_REV_MTH                             
P00836               ,DF.OPT_AGRMT_EFF_DT                               
P00836               ,UT.CODE_REVENUE_CLASS                             
P00836               ,DF.AGREEMNT_SOURCE_CD                             
P00836               ,DF.OFFER_CD                                       
P00892               ,DF.AUTO_REN_OPT_IN_FL                             
OTPMSG               ,COALESCE(DF.STATUS_CHANGE_DT,
              IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))          
P00211           INTO :DF-STATUS-CD                                     
P00680               ,:DF-STAT-ADJUSTABLE-CD                            
P00805               ,:DF-STATUS-EFF-REV-MTH                            
P00836               ,:DF-OPT-AGRMT-EFF-DT                              
P00836               ,:UT-CODE-REVENUE-CLASS                            
P00836               ,:DF-AGREEMNT-SOURCE-CD                            
P00836               ,:DF-OFFER-CD                                      
P00892               ,:DF-AUTO-REN-OPT-IN-FL                            
OTPMSG               ,:DF-STATUS-CHANGE-DT                              
P00211           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
P00211               ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                
P00211          WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             
P00211            AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         
P00211            AND DF.IC_NO             = :DF-IC-NO                  
P00211            AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              
P00211            AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          
P00211            AND DF.IC_NO             = UT.IC_NO                   
P00211            AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       
P00211                                                           
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05643000
MFA-TR*        SELECT DF.STATUS_CD                                      05644000
MFA-TR*              ,DF.STAT_ADJUSTABLE_CD                             05644100
MFA-TR*              ,DF.STATUS_EFF_REV_MTH                             05644203
MFA-TR*              ,DF.OPT_AGRMT_EFF_DT                                       
MFA-TR*              ,UT.CODE_REVENUE_CLASS                                     
MFA-TR*              ,DF.AGREEMNT_SOURCE_CD                                     
MFA-TR*              ,DF.OFFER_CD                                               
MFA-TR*              ,DF.AUTO_REN_OPT_IN_FL                                     
MFA-TR*              ,IFNULL(DF.STATUS_CHANGE_DT,'1900-01-01')                  
MFA-TR*          INTO :DF-STATUS-CD                                     05645000
MFA-TR*              ,:DF-STAT-ADJUSTABLE-CD                            05645100
MFA-TR*              ,:DF-STATUS-EFF-REV-MTH                            05645203
MFA-TR*              ,:DF-OPT-AGRMT-EFF-DT                                      
MFA-TR*              ,:UT-CODE-REVENUE-CLASS                                    
MFA-TR*              ,:DF-AGREEMNT-SOURCE-CD                                    
MFA-TR*              ,:DF-OFFER-CD                                              
MFA-TR*              ,:DF-AUTO-REN-OPT-IN-FL                                    
MFA-TR*              ,:DF-STATUS-CHANGE-DT                                      
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                              05646000
MFA-TR*              ,CSS_UTIL_ENVRNMT  UT                              05646100
MFA-TR*         WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO             05647000
MFA-TR*           AND DF.CODE_UTIL_TYPE    = :DF-CODE-UTIL-TYPE         05648000
MFA-TR*           AND DF.IC_NO             = :DF-IC-NO                  05649000
MFA-TR*           AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO              05649100
MFA-TR*           AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE          05649200
MFA-TR*           AND DF.IC_NO             = UT.IC_NO                   05649300
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO       05649400
MFA-TR*          WITH UR                                                05649500
MFA-TR*    END-EXEC.                                                    05649600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00211                                                                  
P00211     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00211         WHEN SUCCESSFUL-CALL                                     
P00211            CONTINUE                                              
P00211         WHEN NOT-FOUND                                           
P00805            MOVE ZEROS                  TO DF-STATUS-EFF-REV-MTH  
P00211         WHEN OTHER                                               
P00211            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
P00211            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
P00211            MOVE SQLCODE                TO ABEND-SQLCODE          
P00211            MOVE '7410'                 TO ACTIVE-PARAGRAPH       
P00211            MOVE 'SELECT'               TO ABEND-FUNCTION         
P00211            MOVE 'CSS_ACCT_RTPK_AGR'    TO TABLE-1                
P00211            MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
P00211            MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2        
P00211            MOVE 'IC_NO'                TO TABLE-ELEMENT-3        
P00211            MOVE DF-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
P00211            MOVE DF-CODE-UTIL-TYPE      TO HOSTVAR-ELEMENT-2      
P00211            MOVE DF-IC-NO               TO HOSTVAR-ELEMENT-3      
P00836            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
P00805     END-EVALUATE.                                                
P00211                                                                  
P00211 7410-EXIT.                                                       
P00211     EXIT.                                                        
P00211*                                                                 05652900
P00836 7420-SELECT-SPCL-OFFER-TYPE.                                     
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         SELECT  FG.SPCL_OFFER_TYPE_CD                            
P00836           INTO :FG-SPCL-OFFER-TYPE-CD                            
P00836           FROM  CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                
P00836          WHERE  FG.OFFER_CD       = :FG-OFFER-CD                 
P00836            AND  FG.OFF_VSTART_TS <= CIS.CURRENT$TIMESTAMP()            
P00836            AND  FG.OFF_VEND_TS   >= CIS.CURRENT$TIMESTAMP()            
P00836            AND  FG.PROC_STATUS_CD = 'AC'                         
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  FG.SPCL_OFFER_TYPE_CD                                    
MFA-TR*          INTO :FG-SPCL-OFFER-TYPE-CD                                    
MFA-TR*          FROM  CRM_RT_PKG_OFFER FG                                      
MFA-TR*         WHERE  FG.OFFER_CD       = :FG-OFFER-CD                         
MFA-TR*           AND  FG.OFF_VSTART_TS <= CURRENT TIMESTAMP                    
MFA-TR*           AND  FG.OFF_VEND_TS   >= CURRENT TIMESTAMP                    
MFA-TR*           AND  FG.PROC_STATUS_CD = 'AC'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7420                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836            CONTINUE                                              
P00836         WHEN NOT-FOUND                                           
P00836            MOVE SPACES                 TO FG-SPCL-OFFER-TYPE-CD  
P00836         WHEN OTHER                                               
P00836            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
P00836            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
P00836            MOVE SQLCODE                TO ABEND-SQLCODE          
P00836            MOVE '7420'                 TO ACTIVE-PARAGRAPH       
P00836            MOVE 'SELECT'               TO ABEND-FUNCTION         
P00836            MOVE 'CRM_RT_PKG_OFFER'     TO TABLE-1                
P00836            MOVE 'OFFER_CD'             TO TABLE-ELEMENT-1        
P00836            MOVE FG-OFFER-CD            TO HOSTVAR-ELEMENT-1      
P00836            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7420-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 05652900
A05037 7500-GET-CORE-RATE-PLAN-DDDC.                                    
A05037                                                                  
A05037     EXEC SQL                                                     
A05037         SELECT TOP(1) SA.FACTOR                                        
A05037           INTO :WS-CORE-RATE-PLAN-DDDC                           
A05037           FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
A05037               , CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
A05037          WHERE  SA.RATE_PLAN_NO    = :WS-CORE-RATE-PLAN-NO       
A05037            AND  SA.CODE_UTIL_TYPE  = 'G'                         
A05037            AND  SA.CODE_STATUS     = 'A'                         
A05037            AND  SA.DATE_TO        >=  CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
A05037            AND  SA.FACTOR_ID       =  SF.FACTOR_ID               
A05037            AND  SF.SPCL_GROUP_CD   = 'DD'                        
A05037          ORDER BY SA.DATE_FROM DESC                              
A05037                                              
A05037                                                           
A05037                                                      
A05037     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     05652930
MFA-TR*        SELECT  SA.FACTOR                                        05652950
MFA-TR*          INTO :WS-CORE-RATE-PLAN-DDDC                           05652951
MFA-TR*          FROM  CSS_SPCL_FCTR_APPL SA                            05652960
MFA-TR*              , CSS_SPCL_FCTR      SF                            05652970
MFA-TR*         WHERE  SA.RATE_PLAN_NO    = :WS-CORE-RATE-PLAN-NO       05652980
MFA-TR*           AND  SA.CODE_UTIL_TYPE  = 'G'                         05652981
MFA-TR*           AND  SA.CODE_STATUS     = 'A'                         05652990
MFA-TR*           AND  SA.DATE_TO        >=  CURRENT DATE               05652991
MFA-TR*           AND  SA.FACTOR_ID       =  SF.FACTOR_ID               05652992
MFA-TR*           AND  SF.SPCL_GROUP_CD   = 'DD'                        05652993
MFA-TR*         ORDER BY SA.DATE_FROM DESC                              05653001
MFA-TR*         FETCH FIRST ROW ONLY                                    05653002
MFA-TR*          WITH UR                                                05653003
MFA-TR*         QUERYNO 7500                                            05653004
MFA-TR*    END-EXEC.                                                    05653010

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05037                                                                  
A05037     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
A05037                                                                  
A05037     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05037         WHEN SUCCESSFUL-CALL                                     
A05037            CONTINUE                                              
A05037         WHEN NOT-FOUND                                           
A05037            MOVE ZEROS                  TO WS-CORE-RATE-PLAN-DDDC 
A05037         WHEN OTHER                                               
A05037            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
A05037            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
A05037            MOVE SQLCODE                TO ABEND-SQLCODE          
A05037            MOVE '7500'                 TO ACTIVE-PARAGRAPH       
A05037            MOVE 'SELECT'               TO ABEND-FUNCTION         
A05037            MOVE 'CSS_SPCL_FCTR_APPL'   TO TABLE-1                
A05037            MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
A05037            MOVE 'RATE_PLAN_NO'         TO TABLE-ELEMENT-2        
A05037            MOVE PARM-ACCOUNT-NO-DEC    TO HOSTVAR-ELEMENT-1      
A05037            MOVE WS-CORE-RATE-PLAN-NO   TO HOSTVAR-ELEMENT-2      
P00836            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
A05037     END-EVALUATE.                                                
A05037                                                                  
A05037 7500-EXIT.                                                       
A05037     EXIT.                                                        
A05037*                                                                 05653190
P00836 7510-SEL-THERM-PRICE.                                            
P00836                                                                  
P00836     EXEC SQL                                                     
P00836        SELECT TOP(1) (CIS.DECIMAL2DECIMAL3(
           FF.FACTOR * POWER(10.0,SF.FCTR_POWER_10),13,6))
P00836          INTO :WS-FACTOR                                         
P00836          FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
P00836              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
P00836              ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
P00836              ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
P00836              ,CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                    
P00836         WHERE FF.ACCOUNT_NO         = :PARM-ACCOUNT-NO-DEC       
P00836           AND FF.CODE_UTIL_TYPE     = :PARM-CODE-UTIL-TYPE       
P00836           AND FF.IC_NO              = :PARM-IC-NO-DEC            
P00836           AND UT.ACCOUNT_NO         = FF.ACCOUNT_NO              
P00836           AND UT.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE          
P00836           AND UT.IC_NO              = FF.IC_NO                   
P00836           AND UT.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO       
P00836           AND DF.ACCOUNT_NO         = FF.ACCOUNT_NO              
P00836           AND DF.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE          
P00836           AND DF.IC_NO              = FF.IC_NO                   
P00836           AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO       
P00836           AND FF.FACTOR_ID          = HQ.FACTOR_ID               
P00836           AND FF.FACTOR_ID          = SF.FACTOR_ID               
P00836           AND HQ.OPTION_CD          = DF.OPTION_CD               
P00836           AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'              
P00836           AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
P00836           AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
P00836           AND HQ.PROC_STATUS_CD      = 'AC'                      
P00836           AND ATTR_INCTV_STRT_DT    <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00836           AND ATTR_INCTV_END_DT     >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00836         ORDER BY FF.EFF_DATE_FROM DESC                           
P00836                                              
P00836                                                           
P00836                                                      
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         (DECIMAL(FF.FACTOR * POWER(10.0,SF.FCTR_POWER_10),13,6))        
MFA-TR*         INTO :WS-FACTOR                                                 
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*             ,CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CSS_SPCL_FCTR  SF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO         = :PARM-ACCOUNT-NO-DEC               
MFA-TR*          AND FF.CODE_UTIL_TYPE     = :PARM-CODE-UTIL-TYPE               
MFA-TR*          AND FF.IC_NO              = :PARM-IC-NO-DEC                    
MFA-TR*          AND UT.ACCOUNT_NO         = FF.ACCOUNT_NO                      
MFA-TR*          AND UT.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE                  
MFA-TR*          AND UT.IC_NO              = FF.IC_NO                           
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO               
MFA-TR*          AND DF.ACCOUNT_NO         = FF.ACCOUNT_NO                      
MFA-TR*          AND DF.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE                  
MFA-TR*          AND DF.IC_NO              = FF.IC_NO                           
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO               
MFA-TR*          AND FF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND FF.FACTOR_ID          = SF.FACTOR_ID                       
MFA-TR*          AND HQ.OPTION_CD          = DF.OPTION_CD                       
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND ATTR_INCTV_STRT_DT    <= CURRENT DATE                      
MFA-TR*          AND ATTR_INCTV_END_DT     >= CURRENT DATE                      
MFA-TR*        ORDER BY FF.EFF_DATE_FROM DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00836                                                                  
P00836     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00836         WHEN SUCCESSFUL-CALL                                     
P00836         WHEN NOT-FOUND                                           
P00836            CONTINUE                                              
P00836         WHEN OTHER                                               
P00836            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
P00836            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
P00836            MOVE SQLCODE                TO ABEND-SQLCODE          
P00836            MOVE '7510'                 TO ACTIVE-PARAGRAPH       
P00836            MOVE 'SELECT'               TO ABEND-FUNCTION         
P00836            MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
P00836            MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2        
P00836            MOVE 'IC_NO'                TO TABLE-ELEMENT-3        
P00836            MOVE PARM-ACCOUNT-NO-DEC    TO HOSTVAR-ELEMENT-1      
P00836            MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2      
P00836            MOVE PARM-IC-NO-DEC         TO HOSTVAR-ELEMENT-3      
P00836            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
P00836     END-EVALUATE.                                                
P00836                                                                  
P00836 7510-EXIT.                                                       
P00836     EXIT.                                                        
P00836*                                                                 05653190
P836MS 7520-GET-FCTR-END-DT.                                            
P836MS                                                                  
P836MS     EXEC SQL                                                     
P836MS        SELECT TOP(1) FF.EFF_DATE_TO                                    
P836MS          INTO :WS-FF-EFF-DATE-TO :WS-NULL-04                      
P836MS          FROM  CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
P836MS         WHERE  FF.ACCOUNT_NO         = :PARM-ACCOUNT-NO-DEC      
P836MS           AND  FF.CODE_UTIL_TYPE     = :PARM-CODE-UTIL-TYPE      
P836MS           AND  FF.IC_NO              = :PARM-IC-NO-DEC           
P836MS           AND  FF.FACTOR_ID          = 'BASIS'                   
P836MS           AND  FF.EFF_DATE_FROM     <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P836MS           AND  FF.EFF_DATE_TO       >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P836MS         ORDER BY FF.EFF_DATE_FROM                                
P836MS                                              
P836MS                                                           
P836MS                                                      
P836MS     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  FF.EFF_DATE_TO                                            
MFA-TR*         INTO :WS-FF-EFF-DATE-TO:WS-NULL-04                              
MFA-TR*         FROM  CSS_FIXED_FCTR FF                                         
MFA-TR*        WHERE  FF.ACCOUNT_NO         = :PARM-ACCOUNT-NO-DEC              
MFA-TR*          AND  FF.CODE_UTIL_TYPE     = :PARM-CODE-UTIL-TYPE              
MFA-TR*          AND  FF.IC_NO              = :PARM-IC-NO-DEC                   
MFA-TR*          AND  FF.FACTOR_ID          = 'BASIS'                           
MFA-TR*          AND  FF.EFF_DATE_FROM     <= CURRENT DATE                      
MFA-TR*          AND  FF.EFF_DATE_TO       >= CURRENT DATE                      
MFA-TR*        ORDER BY FF.EFF_DATE_FROM                                        
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7520                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P836MS                                                                  
P836MS     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P836MS                                                                  
P836MS     EVALUATE WS-ACTIVE-RETURN-CODE                               
P836MS         WHEN SUCCESSFUL-CALL                                     
P836MS            IF WS-NULL-04 EQUAL -1                                
P836MS               MOVE SPACES              TO WS-FF-EFF-DATE-TO      
P836MS            END-IF                                                
P836MS         WHEN NOT-FOUND                                           
P836MS            MOVE SPACES                 TO WS-FF-EFF-DATE-TO      
P836MS         WHEN OTHER                                               
P836MS            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
P836MS            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
P836MS            MOVE SQLCODE                TO ABEND-SQLCODE          
P836MS            MOVE '7520'                 TO ACTIVE-PARAGRAPH       
P836MS            MOVE 'SELECT'               TO ABEND-FUNCTION         
P836MS            MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1        
P836MS            MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-2        
P836MS            MOVE 'IC_NO'                TO TABLE-ELEMENT-3        
P836MS            MOVE PARM-ACCOUNT-NO-DEC    TO HOSTVAR-ELEMENT-1      
P836MS            MOVE PARM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2      
P836MS            MOVE PARM-IC-NO-DEC         TO HOSTVAR-ELEMENT-3      
P836MS            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
P836MS     END-EVALUATE.                                                
P836MS                                                                  
P836MS 7520-EXIT.                                                       
P836MS     EXIT.                                                        
P836MS*                                                                 05653190
P00892 7550-GET-PEND-OPT-VLD-MNT-DUR.                                   
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         SELECT TOP(1) HQ.OPTION_CD,
              HQ.FACTOR_ID,
              HQ.DURATION_NO                                   
P00892           INTO :HQ-OPTION-CD                                     
P00892               ,:HQ-FACTOR-ID                                     
P00892               ,:HQ-DURATION-NO                                   
P00892           FROM  CRM_RT_PKG_OPTION  FI WITH(READUNCOMMITTED)              
P00892                ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)              
P00892          WHERE  FI.OPTION_CD           = :DF-OPTION-CD           
P00892            AND  FI.OPTION_START_DT    <=  
           CAST(SYSDATETIMEOFFSET() AS DATE)           
P00892            AND  FI.OPTION_END_DT      >=  
           CAST(SYSDATETIMEOFFSET() AS DATE)           
P00892            AND  FI.OPT_VSTART_TS      <=  CIS.CURRENT$TIMESTAMP()      
P00892            AND  FI.OPT_VEND_TS        >=  CIS.CURRENT$TIMESTAMP()      
P00892            AND  FI.PROC_STATUS_CD      = 'AC'                    
P00892            AND  HQ.OPTION_CD           =  FI.OPTION_CD           
P00892            AND  HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'           
P00892            AND  HQ.ATTR_INCTV_STRT_DT <=  
           CAST(SYSDATETIMEOFFSET() AS DATE)           
P00892            AND  HQ.ATTR_INCTV_END_DT  >=  
           CAST(SYSDATETIMEOFFSET() AS DATE)           
P00892            AND  HQ.OPT_ATTR_VSTART_TS <=  CIS.CURRENT$TIMESTAMP()      
P00892            AND  HQ.OPT_ATTR_VEND_TS   >=  CIS.CURRENT$TIMESTAMP()      
P00892            AND  HQ.PROC_STATUS_CD      = 'AC'                    
P00892          ORDER BY HQ.OPT_ATTR_VRSN_NO DESC                       
P00892                                              
P00892                                                           
P00892                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     05652930
MFA-TR*        SELECT  HQ.OPTION_CD                                     05652950
MFA-TR*               ,HQ.FACTOR_ID                                     05652950
MFA-TR*               ,HQ.DURATION_NO                                   05652950
MFA-TR*          INTO :HQ-OPTION-CD                                     05652951
MFA-TR*              ,:HQ-FACTOR-ID                                     05652951
MFA-TR*              ,:HQ-DURATION-NO                                   05652951
MFA-TR*          FROM  CRM_RT_PKG_OPTION  FI                            05652960
MFA-TR*               ,CRM_OPT_ATTR_INCTV HQ                            05652970
MFA-TR*         WHERE  FI.OPTION_CD           = :DF-OPTION-CD           05652980
MFA-TR*           AND  FI.OPTION_START_DT    <=  CURRENT DATE           05652981
MFA-TR*           AND  FI.OPTION_END_DT      >=  CURRENT DATE           05652990
MFA-TR*           AND  FI.OPT_VSTART_TS      <=  CURRENT TIMESTAMP      05652991
MFA-TR*           AND  FI.OPT_VEND_TS        >=  CURRENT TIMESTAMP      05652992
MFA-TR*           AND  FI.PROC_STATUS_CD      = 'AC'                    05652993
MFA-TR*           AND  HQ.OPTION_CD           =  FI.OPTION_CD           05652993
MFA-TR*           AND  HQ.RT_ATTR_INCTV_TYPE  = 'FIXED PRICE'           05652993
MFA-TR*           AND  HQ.ATTR_INCTV_STRT_DT <=  CURRENT DATE           05652993
MFA-TR*           AND  HQ.ATTR_INCTV_END_DT  >=  CURRENT DATE           05652993
MFA-TR*           AND  HQ.OPT_ATTR_VSTART_TS <=  CURRENT TIMESTAMP      05652993
MFA-TR*           AND  HQ.OPT_ATTR_VEND_TS   >=  CURRENT TIMESTAMP      05652993
MFA-TR*           AND  HQ.PROC_STATUS_CD      = 'AC'                    05652993
MFA-TR*         ORDER BY HQ.OPT_ATTR_VRSN_NO DESC                       05653001
MFA-TR*         FETCH FIRST ROW ONLY                                    05653002
MFA-TR*          WITH UR                                                05653003
MFA-TR*         QUERYNO 7550                                            05653004
MFA-TR*    END-EXEC.                                                    05653010

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00892                                                                  
P00892     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00892         WHEN SUCCESSFUL-CALL                                     
P00892            CONTINUE                                              
P00892         WHEN OTHER                                               
P00892            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
P00892            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
P00892            MOVE SQLCODE                TO ABEND-SQLCODE          
P00892            MOVE '7550'                 TO ACTIVE-PARAGRAPH       
P00892            MOVE 'SELECT'               TO ABEND-FUNCTION         
P00892            MOVE 'CRM_OPT_ATTR_INCTV'   TO TABLE-1                
P00892            MOVE 'OPTION_CD'            TO TABLE-ELEMENT-1        
P00892            MOVE DF-OPTION-CD           TO HOSTVAR-ELEMENT-1      
P00892            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
P00892     END-EVALUATE.                                                
P00892                                                                  
P00892 7550-EXIT.                                                       
P00892     EXIT.                                                        
P00892*                                                                 05653190
P00892 7560-GET-PEND-OPT-EXIT-FEE.                                      
P00892                                                                  
P00892     EXEC SQL                                                     
P00892         SELECT TOP(1) HQ.ATTR_INCTV_VALUE                              
P00892           INTO :HQ-ATTR-INCTV-VALUE                              
P00892           FROM  CRM_OPT_ATTR_INCTV    HQ WITH(READUNCOMMITTED)           
P00892          WHERE  HQ.OPTION_CD           = :HQ-OPTION-CD           
P00892            AND  HQ.FACTOR_ID           = :HQ-FACTOR-ID           
P00892            AND  HQ.ATTR_INCTV_STRT_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
P00892            AND  HQ.ATTR_INCTV_END_DT  >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)            
P00892            AND  HQ.OPT_ATTR_VSTART_TS <=  CIS.CURRENT$TIMESTAMP()      
P00892            AND  HQ.OPT_ATTR_VEND_TS   >=  CIS.CURRENT$TIMESTAMP()      
P00892            AND  HQ.PROC_STATUS_CD      = 'AC'                    
P00892            AND  HQ.OPT_ATTR_VSTART_TS  = (                       
P00892              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                   
P00892                FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)          
P00892               WHERE H1.OPTION_CD                 = HQ.OPTION_CD  
P00892                 AND H1.FACTOR_ID                 = HQ.FACTOR_ID  
P00892                 AND H1.PROC_STATUS_CD            = 'AC'          
P00892                 AND H1.ATTR_INCTV_STRT_DT       <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)  
P00892                 AND H1.ATTR_INCTV_END_DT        >= 
           CAST(SYSDATETIMEOFFSET() AS DATE)  
P00892                 AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE) <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)  
P00892                 AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)   >= 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
P00892          ORDER BY HQ.ATTR_INCTV_STRT_DT                          
P00892                                       
P00892                                                      
P00892     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     05652930
MFA-TR*        SELECT  HQ.ATTR_INCTV_VALUE                                      
MFA-TR*          INTO :HQ-ATTR-INCTV-VALUE                                      
MFA-TR*          FROM  CRM_OPT_ATTR_INCTV    HQ                                 
MFA-TR*         WHERE  HQ.OPTION_CD           = :HQ-OPTION-CD                   
MFA-TR*           AND  HQ.FACTOR_ID           = :HQ-FACTOR-ID                   
MFA-TR*           AND  HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                    
MFA-TR*           AND  HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                    
MFA-TR*           AND  HQ.OPT_ATTR_VSTART_TS <=  CURRENT TIMESTAMP      05652993
MFA-TR*           AND  HQ.OPT_ATTR_VEND_TS   >=  CURRENT TIMESTAMP      05652993
MFA-TR*           AND  HQ.PROC_STATUS_CD      = 'AC'                    05652993
MFA-TR*           AND  HQ.OPT_ATTR_VSTART_TS  = (                               
MFA-TR*             SELECT MAX(H1.OPT_ATTR_VSTART_TS)                           
MFA-TR*               FROM CRM_OPT_ATTR_INCTV H1                                
MFA-TR*              WHERE H1.OPTION_CD                 = HQ.OPTION_CD          
MFA-TR*                AND H1.FACTOR_ID                 = HQ.FACTOR_ID          
MFA-TR*                AND H1.PROC_STATUS_CD            = 'AC'                  
MFA-TR*                AND H1.ATTR_INCTV_STRT_DT       <= CURRENT DATE          
MFA-TR*                AND H1.ATTR_INCTV_END_DT        >= CURRENT DATE          
MFA-TR*                AND DATE(H1.OPT_ATTR_VSTART_TS) <= CURRENT DATE          
MFA-TR*                AND DATE(H1.OPT_ATTR_VEND_TS)   >= CURRENT DATE )        
MFA-TR*         ORDER BY HQ.ATTR_INCTV_STRT_DT                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7560                                                    
MFA-TR*    END-EXEC.                                                    05653010

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00892                                                                  
P00892     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00892                                                                  
P00892     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00892         WHEN SUCCESSFUL-CALL                                     
P00892            CONTINUE                                              
P00892         WHEN NOT-FOUND                                           
P00892            MOVE 0                      TO HQ-ATTR-INCTV-VALUE    
P00892         WHEN OTHER                                               
P00892            MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE-1       
P00892            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
P00892            MOVE SQLCODE                TO ABEND-SQLCODE          
P00892            MOVE '7560'                 TO ACTIVE-PARAGRAPH       
P00892            MOVE 'SELECT'               TO ABEND-FUNCTION         
P00892            MOVE 'CRM_OPT_ATTR_INCTV'   TO TABLE-1                
P00892            MOVE 'OPTION_CD'            TO TABLE-ELEMENT-1        
P00892            MOVE HQ-OPTION-CD           TO HOSTVAR-ELEMENT-1      
P00892            PERFORM 9700-PROCESS-ABEND     THRU  9700-EXIT        
P00892     END-EVALUATE.                                                
P00892                                                                  
P00892 7560-EXIT.                                                       
P00892     EXIT.                                                        
P00892*                                                                 05653190
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                 05660000
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                 05700000
            EXEC SQL                                                    
                DELETE FROM #CSR04099_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    05710000
MFA-TR*         DELETE FROM SESSION.CSR04099_R1                         05720000
MFA-TR*     END-EXEC.                                                   05730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05740000
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                 05760000
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04099_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00836         PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT             
           END-IF.                                                      
      *                                                                 05920000
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 05950000
P00836 8000B-DELETE-GTT-ROWS.                                           
P00836*                                                                 05660000
P00836     MOVE                                                         
P00836     'DELETE ROWS'                                                
P00836         TO S-SQL-STATEMENT-V.                                    
P00836*                                                                 05700000
P00836      EXEC SQL                                                    
P00836          DELETE FROM #CSR04099_R2                         
P00836      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    05710000
MFA-TR*         DELETE FROM SESSION.CSR04099_R2                         05720000
MFA-TR*     END-EXEC.                                                   05730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836*                                                                 05740000
P00836      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
P00836*                                                                 05760000
P00836      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00836         NEXT SENTENCE                                            
P00836      ELSE                                                        
P00836         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00836         MOVE SQLCODE              TO ABEND-SQLCODE               
P00836         MOVE SQLSTATE             TO ABEND-SQLSTATE              
P00836         MOVE '8000B'              TO ACTIVE-PARAGRAPH            
P00836         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00836         MOVE SPACES               TO ABEND-SQL-PREDICATES        
P00836                                      ABEND-TABLES                
P00836         MOVE 'CSR04099_R2'        TO TABLE-1                     
P00836         MOVE SPACES               TO TABLE-ELEMENT-1             
P00836         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
P00836         PERFORM 9700-PROCESS-ABEND   THRU  9700-EXIT             
P00836     END-IF.                                                      
P00836*                                                                 05920000
P00836 8000B-EXIT.                                                      
P00836     EXIT.                                                        
P00836*                                                                 05950000
P00680******************************************************************05960000
P00680* 8100-SEND-RESULT.                                             * 05970000
P00680******************************************************************05980000
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04099_R1                            
             (                                                          
              RETURN_CODE                                               
             ,THERM_PRICE                                               
             ,OPTN_VALID_MNTHS                                          
             ,PRIM_FACTOR_ID                                            
             ,CORE_RATE_PLAN_NO                                         
             ,RATE_CALC_TYPE_CD                                         
             ,CSC_AMT                                                   
             ,CSC_REFND_FL                                              
             ,CSC_MNTHS                                                 
             ,DURATION_REM_MO                                           
             ,TIER_ACCT_TYPE_CD                                         
             ,WEB_RENEWAL_FL                                            
             ,RATE_DEFINITION_CD                                        
             ,CURR_EXT_DESC_LONG                                        
P00211       ,PEND_OPT_EXIST_FL                                         
P00211       ,SHOW_RENEWAL_OPT                                          
P00211       ,PEND_EXT_DESC_LONG                                        
P00680       ,ADJUSTABLE_FLAG                                           
P00680       ,CURRENT_THERM_PRICE                                       
P00805       ,CURR_OPT_EFF_DATE                                         
P00805       ,PEND_OPT_EFF_DATE                                         
P00805       ,SENIOR_RATE_FL                                            
P00805       ,IS_CURR_OPTN_FLEX                                         
A05037       ,CORE_RATE_PLAN_DDDC                                       
A05043       ,PRINT_SR_DSC_MSG_CD                                       
P00836       ,CURR_OPT_ROR_END_DT                                       
P00836       ,CUSTOMER_DOB                                              
P00836       ,SENIOR_BY_DOB_FLAG                                        
P00836       ,TIER_CUST_STAT_CD                                         
P00836       ,CODE_REVENUE_CLASS                                        
P00836       ,SPCL_OFFER_TYPE_CD                                        
P00892       ,PEND_OPT_THRM_PRC                                         
P00892       ,PEND_OPT_CSC_AMT                                          
P00892       ,PEND_OPT_EXT_FEE                                          
P00892       ,PEND_OPT_ARMSG_FL                                         
P00892       ,CURR_OPT_ARMSG_FL                                         
P00892       ,SEASONAL_FL                                               
P00892       ,PEND_OPT_ROR_END_DT                                       
P00892       ,PEND_WEB_DESC_LONG                                        
P00836       ,PEND_WMKT_DESC_LONG                                       
P836MS       ,CURR_WMKT_DESC_LONG                                       
P836MS       ,CURR_OPT_EXT_FEE                                          
P836MS       ,CURR_RATE_EXP_DT                                          
P836MS       ,CURR_RATE_EXP_TXT                                         
P836MS       ,PEND_RATE_EFF_TXT                                         
P892NW       ,CURR_OPT_AR_ELGBL                                         
P892NW       ,AR_CALL_BY_DATE                                           
P836TR       ,XFER_RATE_TITLE_1                                         
P836TR       ,XFER_RATE_TITLE_2                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-1                                          
             ,:S-THERM-PRICE                                            
             ,:S-OPTN-VALID-MNTHS                                       
             ,:S-PRIM-FACTOR-ID                                         
             ,:S-CORE-RATE-PLAN-NO                                      
             ,:S-RATE-CALC-TYPE-CD                                      
             ,:S-CSC-AMT                                                
             ,:S-CSC-REFND-FL                                           
             ,:S-CSC-MNTHS                                              
             ,:S-FF-DURATION-REM                                        
             ,:S-TIER-ACCT-TYPE-CD                                      
             ,:S-WEB-RENEWAL-FL                                         
             ,:S-RATE-DEFINITION-CD                                     
             ,:S-CURR-EXT-DESC-LONG                                     
P00211       ,:S-PEND-OPT-EXIST-FL                                      
P00211       ,:S-SHOW-RENEWAL-OPT                                       
P00211       ,:S-PEND-EXT-DESC-LONG                                     
P00680       ,:S-ADJUSTABLE-FLAG                                        
P00680       ,:S-CURRENT-THERM-PRICE                                    
P00805       ,:S-CURR-OPT-EFF-DATE                                      
P00805       ,:S-PEND-OPT-EFF-DATE                                      
P00805       ,:S-SENIOR-RATE-FL                                         
P00805       ,:S-IS-CURR-OPTN-FLEX                                      
A05037       ,:S-CORE-RATE-PLAN-DDDC                                    
A05043       ,:S-PRINT-SR-DSC-MSG-CD                                    
P00836       ,:S-CURR-OPT-ROR-END-DT                                    
P00836       ,:S-CUSTOMER-DOB                                           
P00836       ,:S-SENIOR-BY-DOB-FLAG                                     
P00836       ,:S-TIER-CUST-STAT-CD                                      
P00836       ,:S-CODE-REVENUE-CLASS                                     
P00836       ,:S-SPCL-OFFER-TYPE-CD                                     
P00892       ,:S-PEND-OPT-THRM-PRC                                      
P00892       ,:S-PEND-OPT-CSC-AMT                                       
P00892       ,:S-PEND-OPT-EXT-FEE                                       
P00892       ,:S-PEND-OPT-ARMSG-FL                                      
P00892       ,:S-CURR-OPT-ARMSG-FL                                      
P00892       ,:S-SEASONAL-FL                                            
P00892       ,:S-PEND-OPT-ROR-END-DT                                    
P00892       ,:S-PEND-WEB-DESC-LONG                                     
P00836       ,:S-PEND-WMKT-DESC-LONG                                    
P836MS       ,:S-CURR-WMKT-DESC-LONG                                    
P836MS       ,:S-CURR-OPT-EXT-FEE                                       
P836MS       ,:S-CURR-RATE-EXP-DT                                       
P836MS       ,:S-CURR-RATE-EXP-TXT                                      
P836MS       ,:S-PEND-RATE-EFF-TXT                                      
P892NW       ,:S-CURR-OPT-AR-ELGBL                                      
P892NW       ,:S-AR-CALL-BY-DATE                                        
P836TR       ,:S-XFER-RATE-TITLE-1                                      
P836TR       ,:S-XFER-RATE-TITLE-2                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     06050000
MFA-TR*      INSERT INTO SESSION.CSR04099_R1                            06060000
MFA-TR*      (                                                          06070000
MFA-TR*       RETURN_CODE                                               06080000
MFA-TR*      ,THERM_PRICE                                               06090000
MFA-TR*      ,OPTN_VALID_MNTHS                                          06100000
MFA-TR*      ,PRIM_FACTOR_ID                                            06110000
MFA-TR*      ,CORE_RATE_PLAN_NO                                         06120000
MFA-TR*      ,RATE_CALC_TYPE_CD                                         06130000
MFA-TR*      ,CSC_AMT                                                   06140000
MFA-TR*      ,CSC_REFND_FL                                              06150000
MFA-TR*      ,CSC_MNTHS                                                 06160000
MFA-TR*      ,DURATION_REM_MO                                           06170000
MFA-TR*      ,TIER_ACCT_TYPE_CD                                         06180000
MFA-TR*      ,WEB_RENEWAL_FL                                            06190000
MFA-TR*      ,RATE_DEFINITION_CD                                        06200000
MFA-TR*      ,CURR_EXT_DESC_LONG                                        06210000
MFA-TR*      ,PEND_OPT_EXIST_FL                                         06220000
MFA-TR*      ,SHOW_RENEWAL_OPT                                          06221000
MFA-TR*      ,PEND_EXT_DESC_LONG                                        06222000
MFA-TR*      ,ADJUSTABLE_FLAG                                           06223000
MFA-TR*      ,CURRENT_THERM_PRICE                                       06224000
MFA-TR*      ,CURR_OPT_EFF_DATE                                         06225003
MFA-TR*      ,PEND_OPT_EFF_DATE                                         06226003
MFA-TR*      ,SENIOR_RATE_FL                                            06227004
MFA-TR*      ,IS_CURR_OPTN_FLEX                                         06228006
MFA-TR*      ,CORE_RATE_PLAN_DDDC                                       06228007
MFA-TR*      ,PRINT_SR_DSC_MSG_CD                                       06228008
MFA-TR*      ,CURR_OPT_ROR_END_DT                                               
MFA-TR*      ,CUSTOMER_DOB                                                      
MFA-TR*      ,SENIOR_BY_DOB_FLAG                                                
MFA-TR*      ,TIER_CUST_STAT_CD                                                 
MFA-TR*      ,CODE_REVENUE_CLASS                                                
MFA-TR*      ,SPCL_OFFER_TYPE_CD                                                
MFA-TR*      ,PEND_OPT_THRM_PRC                                         06220000
MFA-TR*      ,PEND_OPT_CSC_AMT                                          06220000
MFA-TR*      ,PEND_OPT_EXT_FEE                                          06220000
MFA-TR*      ,PEND_OPT_ARMSG_FL                                         06220000
MFA-TR*      ,CURR_OPT_ARMSG_FL                                         06220000
MFA-TR*      ,SEASONAL_FL                                               06220000
MFA-TR*      ,PEND_OPT_ROR_END_DT                                               
MFA-TR*      ,PEND_WEB_DESC_LONG                                        06222000
MFA-TR*      ,PEND_WMKT_DESC_LONG                                       06220000
MFA-TR*      ,CURR_WMKT_DESC_LONG                                       06220000
MFA-TR*      ,CURR_OPT_EXT_FEE                                                  
MFA-TR*      ,CURR_RATE_EXP_DT                                                  
MFA-TR*      ,CURR_RATE_EXP_TXT                                                 
MFA-TR*      ,PEND_RATE_EFF_TXT                                                 
MFA-TR*      ,CURR_OPT_AR_ELGBL                                                 
MFA-TR*      ,AR_CALL_BY_DATE                                                   
MFA-TR*      ,XFER_RATE_TITLE_1                                                 
MFA-TR*      ,XFER_RATE_TITLE_2                                                 
MFA-TR*      )                                                          06230000
MFA-TR*      VALUES                                                     06240000
MFA-TR*      (                                                          06250000
MFA-TR*       :S-RETURN-CODE-1                                          06260000
MFA-TR*      ,:S-THERM-PRICE                                            06270000
MFA-TR*      ,:S-OPTN-VALID-MNTHS                                       06280000
MFA-TR*      ,:S-PRIM-FACTOR-ID                                         06290000
MFA-TR*      ,:S-CORE-RATE-PLAN-NO                                      06300000
MFA-TR*      ,:S-RATE-CALC-TYPE-CD                                      06310000
MFA-TR*      ,:S-CSC-AMT                                                06320000
MFA-TR*      ,:S-CSC-REFND-FL                                           06330000
MFA-TR*      ,:S-CSC-MNTHS                                              06340000
MFA-TR*      ,:S-FF-DURATION-REM                                        06350000
MFA-TR*      ,:S-TIER-ACCT-TYPE-CD                                      06360000
MFA-TR*      ,:S-WEB-RENEWAL-FL                                         06370000
MFA-TR*      ,:S-RATE-DEFINITION-CD                                     06380000
MFA-TR*      ,:S-CURR-EXT-DESC-LONG                                     06390000
MFA-TR*      ,:S-PEND-OPT-EXIST-FL                                      06400000
MFA-TR*      ,:S-SHOW-RENEWAL-OPT                                       06401000
MFA-TR*      ,:S-PEND-EXT-DESC-LONG                                     06402000
MFA-TR*      ,:S-ADJUSTABLE-FLAG                                        06403000
MFA-TR*      ,:S-CURRENT-THERM-PRICE                                    06404000
MFA-TR*      ,:S-CURR-OPT-EFF-DATE                                      06405003
MFA-TR*      ,:S-PEND-OPT-EFF-DATE                                      06406003
MFA-TR*      ,:S-SENIOR-RATE-FL                                         06407004
MFA-TR*      ,:S-IS-CURR-OPTN-FLEX                                      06408006
MFA-TR*      ,:S-CORE-RATE-PLAN-DDDC                                    06408007
MFA-TR*      ,:S-PRINT-SR-DSC-MSG-CD                                    06408008
MFA-TR*      ,:S-CURR-OPT-ROR-END-DT                                    06408008
MFA-TR*      ,:S-CUSTOMER-DOB                                           06408008
MFA-TR*      ,:S-SENIOR-BY-DOB-FLAG                                     06408008
MFA-TR*      ,:S-TIER-CUST-STAT-CD                                      06408008
MFA-TR*      ,:S-CODE-REVENUE-CLASS                                     06408008
MFA-TR*      ,:S-SPCL-OFFER-TYPE-CD                                     06408008
MFA-TR*      ,:S-PEND-OPT-THRM-PRC                                      06400000
MFA-TR*      ,:S-PEND-OPT-CSC-AMT                                       06400000
MFA-TR*      ,:S-PEND-OPT-EXT-FEE                                       06400000
MFA-TR*      ,:S-PEND-OPT-ARMSG-FL                                      06400000
MFA-TR*      ,:S-CURR-OPT-ARMSG-FL                                      06400000
MFA-TR*      ,:S-SEASONAL-FL                                            06400000
MFA-TR*      ,:S-PEND-OPT-ROR-END-DT                                    06400000
MFA-TR*      ,:S-PEND-WEB-DESC-LONG                                     06400000
MFA-TR*      ,:S-PEND-WMKT-DESC-LONG                                    06400000
MFA-TR*      ,:S-CURR-WMKT-DESC-LONG                                    06220000
MFA-TR*      ,:S-CURR-OPT-EXT-FEE                                               
MFA-TR*      ,:S-CURR-RATE-EXP-DT                                               
MFA-TR*      ,:S-CURR-RATE-EXP-TXT                                              
MFA-TR*      ,:S-PEND-RATE-EFF-TXT                                              
MFA-TR*      ,:S-CURR-OPT-AR-ELGBL                                              
MFA-TR*      ,:S-AR-CALL-BY-DATE                                                
MFA-TR*      ,:S-XFER-RATE-TITLE-1                                              
MFA-TR*      ,:S-XFER-RATE-TITLE-2                                              
MFA-TR*      )                                                          06410000
MFA-TR*    END-EXEC.                                                    06420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE SQLCODE             TO ABEND-SQLCODE                 
              MOVE SQLSTATE            TO ABEND-SQLSTATE                
              MOVE '8100'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSR04099_R1'       TO TABLE-1                       
P00836        PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
           END-IF.                                                      
                                                                        
P00836     ADD 1 TO CTR-ROWS-RS1.                                       
      *                                                                 06600000
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 06630000
P00836******************************************************************05960000
P00836* 8200-SEND-BUS-RULES.                                           *05970000
P00836******************************************************************05980000
P00836 8200-SEND-BUS-RULES.                                             
P00836                                                                  
P00836     EXEC SQL                                                     
P00836       INSERT INTO #CSR04099_R2                            
P00836       (                                                          
P00836        RETURN_CODE                                               
P00836       ,BUS_RULE_MSG_ID                                           
P00836       ,RULE_RESULT_CD                                            
P00836       ,BUS_RULE_XREF_ID                                          
P00836       ,MESSAGE_PARMS                                             
P00836       ,LINK_PARMS                                                
P00836       )                                                          
P00836       VALUES                                                     
P00836       (                                                          
P00836        :S-RETURN-CODE-2                                          
P00836       ,:S-BUS-RULE-MSG-ID                                        
P00836       ,:S-BUS-RULE-RESULT-CD                                     
P00836       ,:S-BUS-RULE-XREF-ID                                       
P00836       ,:S-MESSAGE-PARMS                                          
P00836       ,:S-LINK-PARMS                                             
P00836       )                                                          
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     06050000
MFA-TR*      INSERT INTO SESSION.CSR04099_R2                            06060000
MFA-TR*      (                                                          06070000
MFA-TR*       RETURN_CODE                                               06080000
MFA-TR*      ,BUS_RULE_MSG_ID                                           06090000
MFA-TR*      ,RULE_RESULT_CD                                            06100000
MFA-TR*      ,BUS_RULE_XREF_ID                                          06110000
MFA-TR*      ,MESSAGE_PARMS                                             06120000
MFA-TR*      ,LINK_PARMS                                                06130000
MFA-TR*      )                                                          06230000
MFA-TR*      VALUES                                                     06240000
MFA-TR*      (                                                          06250000
MFA-TR*       :S-RETURN-CODE-2                                          06260000
MFA-TR*      ,:S-BUS-RULE-MSG-ID                                        06270000
MFA-TR*      ,:S-BUS-RULE-RESULT-CD                                     06280000
MFA-TR*      ,:S-BUS-RULE-XREF-ID                                       06290000
MFA-TR*      ,:S-MESSAGE-PARMS                                          06300000
MFA-TR*      ,:S-LINK-PARMS                                             06310000
MFA-TR*      )                                                          06410000
MFA-TR*    END-EXEC.                                                    06420000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00836                                                                  
P00836     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00836        NEXT SENTENCE                                             
P00836     ELSE                                                         
P00836        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00836        MOVE SQLCODE             TO ABEND-SQLCODE                 
P00836        MOVE SQLSTATE            TO ABEND-SQLSTATE                
P00836        MOVE '8200'              TO ACTIVE-PARAGRAPH              
P00836        MOVE 'INSERT'            TO ABEND-FUNCTION                
P00836        MOVE 'CSR04099_R2'       TO TABLE-1                       
P00836        PERFORM 9700-PROCESS-ABEND  THRU  9700-EXIT               
P00836     END-IF.                                                      
P00836                                                                  
P00836     ADD 1 TO CTR-ROWS-RS2.                                       
P00836*                                                                 06600000
P00836 8200-EXIT.                                                       
P00836      EXIT.                                                       
      *                                                                 06630000
P00836*****************************************************************         
P00836* 8800-CHECK-RESULTS.                                           *         
P00836*****************************************************************         
P00836 8800-CHECK-RESULTS.                                              
P00836                                                                  
P00836     IF CTR-ROWS-RS1 <= 0                                         
P00836        INITIALIZE                       GTT-RETURN-FIELDS-1      
P00836        MOVE   100                    TO S-RETURN-CODE-1          
P00836        PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF CTR-ROWS-RS2 <= 0                                         
P00836        INITIALIZE                       GTT-RETURN-FIELDS-2      
P00836        MOVE   100                    TO S-RETURN-CODE-2          
P00836        PERFORM 8200-SEND-BUS-RULES      THRU 8200-EXIT           
P00836     END-IF.                                                      
P00836                                                                  
P00836 8800-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 8900-SEND-DONE.                                               *         
P00836*****************************************************************         
P00836 8900-SEND-DONE.                                                  
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN C1                                                  
P00836     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         OPEN C2                                                  
P00836     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
P00836                                                                  
P00836 8900-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9000-SEND-ERROR-RESULT.                                       *         
P00836*****************************************************************         
P00836 9000-SEND-ERROR-RESULT.                                          
P00836                                                                  
P00836     MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
P00836                                         S-RETURN-CODE-1          
P00836                                         S-RETURN-CODE-2.         
P00836                                                                  
P00836     MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
P00836                                                                  
P00836     IF WS-GTT01-DECLARED = 'N'                                   
P00836        PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT          
P00836     END-IF.                                                      
P00836                                                                  
P00836     IF WS-GTT02-DECLARED = 'N'                                   
P00836        PERFORM 0100B-DECLARE-GTT        THRU 0100B-EXIT          
P00836     END-IF.                                                      
P00836                                                                  
P00836     PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
P00836     PERFORM 8200-SEND-BUS-RULES         THRU 8200-EXIT.          
P00836                                                                  
P00836 9000-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9700-PROCESS-ABEND.                                           *         
P00836*****************************************************************         
P00836 9700-PROCESS-ABEND.                                              
P00836                                                                  
P00836     PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
P00836     PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
P00836                                                                  
P00836 9700-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9900-SQL-ERROR-ROUTINE.                                       *         
P00836*****************************************************************         
P00836 9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
P00836                  WHEN :TABLE-ELEMENT-1 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END + CASE                                               
P00836                  WHEN :TABLE-ELEMENT-2 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END + CASE                                               
P00836                  WHEN :TABLE-ELEMENT-3 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END + CASE                                               
P00836                  WHEN :TABLE-ELEMENT-4 > ' ' THEN                
P00836                     LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
P00836                  ELSE                                            
P00836                     ''                                           
P00836               END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
P00836                                                                  
P00836     EXEC SQL                                                     
P00836         CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
P00836     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00836                                                                  
P00836     PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
P00836     
MSQ016        GOBACK.                                                    
P00836                                                                  
P00836 9900-EXIT.                                                       
P00836     EXIT.                                                        
                                                                        
P00836*****************************************************************         
P00836* 9999-END-PROGRAM.                                             *         
P00836*****************************************************************         
P00836 9999-END-PROGRAM.                                                
P00836                                                                  
P00836     PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
P00836     PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
P00836                                                                  
P00836     
MSQ016        GOBACK.                                                    
P00836                                                                  
P00836 9999-EXIT.                                                       
P00836     EXIT.                                                        
