       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04098.                                     
COB303 DATE-WRITTEN.     FEB 01, 2008.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE PERFORMS AN UPDATE, INSERT                     *        
      *  INFORMATION IN THE CSS_FIXED_FCT ,CSS_ACCT_MKT_TIER           *        
      *  AND CSS_ACCT_ATTRIBUTE                                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
T34569* 01/02/08     PC97415  NEW                                      *        
I00113* 02/20/09     JC91900  GRP 1 SCANA SR. CHANGES.                 *        
P00172* 07/21/09     VY95550  REGULATED TRANSITION CHANGES TO AVOID    *        
P00172*                       -811 ON CRM_MKT_TIER_ADJ TABLE           *        
P00172* 07/31/09     VY95550  DHR PHASE OUT CHANGES                    *        
A37061* 09/17/09     SJ97149  REMOVE THE LOGIC OF UPDATES FOR          *        
A37061*                       ACCOUNT_TYPE_CODE FROM MKT-TIER-RANKING  *        
A03303* 06/09/11     SV95326  FIXED FACTOR PRECISION CHANGES FROM 4 TO *        
A03303*                       6 DECIMAL POINTS FOR INDUSTRIAL BILLING. *        
P00677* 06/19/12     DB18339  ADDED SENIOR FL FOR SEB ICON UPDATE      *        
P00738* 03/18/14     AD7F921  CHANGE THE DELETE FILTER BASED ON        *        
P00738*                       BASED ON EFF_START_DT INSTEAD OF         *        
P00738*                       MKT_TIER_START_DT IN 8410-DEL-MKT-TIER   *        
A04880* 07/17/14     AS7C117  HANDLED NULL INDICATOR IN PARA 7500-     *        
A04880* #ACT221                                                        *        
P00740* 08/28/14     VP43661  APPEND TRANS COMMENTS RATHER OVERRIDE    *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04098'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04098 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCT_MKT_TIER, DD                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CRM_MKT_TIER_ADJ, 1B                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMKTTAD                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CRM_MKT_TIER, IG                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCOUNT, AT                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
P00172* CSS_CUSTOMER, CU                                              *         
      *****************************************************************         
            EXEC SQL                                                            
P00172        INCLUDE TBCUST                                                    
            END-EXEC.                                                           
      *                                                                         
      *****************************************************************         
      * CSS_FIXED_FACTOR, FF                                          *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_ACCT_ATTRIBUTE, YP                                        *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_JOB_PARM                                                  *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_REG_PROFILE                                               *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_MNT_TRANS_HIST - MH                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_MT_TRN_HST_DET  -MI                                      *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  CSS_USER_PROFILE, PF                                         *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_CODE_VALUE, UV                                            *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
I00113*****************************************************************         
I00113* CSS_DELINQUENCY, C8                                           *         
I00113*****************************************************************         
I00113      EXEC SQL                                                            
I00113           INCLUDE TBDELQ                                                 
I00113      END-EXEC.                                                           
I00113                                                                  
I00113*****************************************************************         
I00113* CSS_CUST_STATS, CE                                            *         
I00113*****************************************************************         
I00113      EXEC SQL                                                            
I00113           INCLUDE TBCSTSTS                                               
I00113      END-EXEC.                                                           
I00113                                                                  
A03303******************************************************************        
A03303* CSS_SPCL_FCTR,  SF                                             *        
A03303******************************************************************        
A03303                                                                  
A03303     EXEC SQL                                                             
A03303        INCLUDE TBSPLFTR                                                  
A03303     END-EXEC.                                                            
A03303                                                                  
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
P00740     05  WS-DELIMITER            PIC X(01)  VALUE '!'.            
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
P00677     05  RS-SENIOR-FL            PIC X(01) VALUE ' '.             
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
P00677     05  S-SENIOR-FL             PIC X(01) VALUE ' '.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
           05  WS-MKT-TIER-FOUND       PIC X(01) VALUE 'N'.             
               88 MKT-TIER-FOUND                 VALUE 'Y'.             
I00113     05  WS-CUSTOMER-ON-SR-TIER  PIC X(01) VALUE 'N'.             
I00113         88 CUSTOMER-ON-SR-TIER            VALUE 'Y'.             
      *                                                                         
       01 WS-WORKING-STORAGE.                                           
           05 WS-UPDATE-IND            PIC X(01) VALUE SPACES.          
           05 WS-ACCOUNT-NO            PIC 9(13) VALUE ZEROES.          
           05 WS-ACCOUNT-ATTRIB        PIC X(15) VALUE SPACES.          
           05 WS-ATTRIBUTE-STATUS      PIC X(01) VALUE SPACES.          
           05 WS-TIER-CUST-STAT-CD     PIC X(01) VALUE SPACES.          
           05 WS-TIER-ACCT-TYPE-CD     PIC X(01) VALUE SPACES.          
           05 WS-MKT-TIER-RANKING      PIC 9(04) VALUE ZEROES.          
           05 WS-EFF-START-DT          PIC X(10) VALUE SPACES.          
           05 WS-TIER-SOURCE-CD        PIC X(02) VALUE SPACES.          
           05 WS-ADJ-TIER-SEQ-NO       PIC 9(04) VALUE ZEROES.          
           05 WS-COMPANY-NO            PIC X(02) VALUE SPACES.          
           05 WS-USER-ID               PIC X(07) VALUE SPACES.          
           05 WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.          
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-MKT-TIER-START-DT     PIC X(10) VALUE SPACES.          
           05 WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE 0.         
           05 WS-REG-GROUP-CD          PIC X(03) VALUE SPACES.          
           05 WS-ACCT-ATTR-FOUND       PIC X(01) VALUE 'N'.             
           05 WS-FIXED-FCTR-FOUND      PIC X(01) VALUE 'N'.             
           05 WS-DHR-CUSTOMER          PIC X(01) VALUE 'N'.             
           05 WS-FIXED-FCTR-SEQ-NO     PIC S9(4) COMP VALUE 0.          
           05 WS-FIXED-FCTR-SEQ-NO-PIC PIC 9(03) VALUE 0.               
           05 WS-ATTRIBUTE-VALUE-CD    PIC X(05) VALUE SPACES.          
           05 WS-CODE-SHORT-DESC       PIC X(15) VALUE SPACES.          
           05 WS-CODE-VALUE            PIC X(10) VALUE SPACES.          
           05 WS-STATUS                PIC X(15) VALUE SPACES.          
           05 WS-PREV-STATUS           PIC X(15) VALUE SPACES.          
           05 WS-COLUMN-NA             PIC X(18) VALUE SPACES.          
           05 WS-PROGRAM-ID            PIC X(08) VALUE 'ALL'.           
           05 WS-TABLE-NA              PIC X(18) VALUE SPACES.          
           05 WS-CURR-MKT-TIER-DESC    PIC X(50) VALUE SPACES.          
           05 WS-PREV-MKT-TIER-DESC    PIC X(50) VALUE SPACES.          
           05 WS-CURR-TIER-ADJ-DESC    PIC X(80) VALUE SPACES.          
           05 WS-PREV-TIER-ADJ-DESC    PIC X(80) VALUE SPACES.          
           05 WS-TRANS-HIST-COMMENT    PIC X(210) VALUE SPACES.         
           05 WS-REV-MTH-LST-NRML      PIC 9(6)  VALUE ZEROES.          
           05 WS-REV-MTH-LST-NRML-C    PIC X(06) VALUE SPACES.          
           05 WS-COM-REV-MONTH         PIC X(06) VALUE SPACES.          
           05 WS-COM-REV-MONTH-01      PIC X(10) VALUE SPACES.          
           05 WS-RESULT-DATE           PIC X(10) VALUE SPACES.          
           05 WS-DATE-TO               PIC X(10) VALUE SPACES.          
           05 WS-FACTOR-START-DT       PIC X(10) VALUE SPACES.          
           05 WS-FACTOR-XPIRE-DT       PIC X(10) VALUE SPACES.          
           05 WS-DUMMY-DATE            PIC X(10) VALUE SPACES.          
           05 WS-TIER-RANK-Z           PIC Z(04).                       
           05 WS-FACT-VAL-Z            PIC -Z(09).9(06).                
           05 WS-HOLD-FACT-VAL         PIC X(15) VALUE SPACES.          
           05 WS-HOLD-FACT-VAL-RED     REDEFINES WS-HOLD-FACT-VAL       
                                       PIC 999999999V999999.            
           05 WS-FACTOR-TEXT           PIC 9(9).9(6).                   
           05 WS-FACTOR-VALUE          PIC 9(15).                       
           05 WS-FACTOR-VALUE-RED      REDEFINES WS-FACTOR-VALUE        
                                       PIC 999999999V999999.            
A03303     05 WS-FACTOR-FF             PIC S9(09)V9(06) USAGE COMP-3    
A03303                                                    VALUE 0.      
           05 WS-START-DATE.                                            
               10 WS-START-YR         PIC X(04).                        
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-START-MT         PIC X(02).                        
               10 FILLER              PIC X(01) VALUE '-'.              
               10 WS-START-DY         PIC X(02).                        
I00113     05 WS-DUMMY-DATE-ST        PIC X(10) VALUE SPACES.           
I00113     05 WS-DUMMY-DATE-END       PIC X(10) VALUE SPACES.           
I00113     05 WS-RESULT-YEAR          PIC S9(04) COMP.                  
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-UPDATE-ATTRIBUTES    PIC X(01) VALUE 'A'.              
           05 WS-UPDATE-ACCT-TIER     PIC X(01) VALUE 'M'.              
           05 WS-AGL-SR-ATTRIBUTE     PIC X(15) VALUE 'AGL DISCOUNT SR'.
           05 WS-MKT-TIER-UPD         PIC X(08) VALUE 'CSR0409M'.       
           05 WS-ACT-ATTR-UPD         PIC X(08) VALUE 'CSR0409A'.       
           05 SCANA-SR-DEFLT-FLAG     PIC X(01) VALUE 'S'.              
I00113     05 SCANA-SR-AGE            PIC X(17)                         
I00113                                      VALUE 'SCANA SENIOR AGE'.   
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01          PIC S9(4) COMP.                   
           05 WS-NULL-IND-02          PIC S9(4) COMP.                   
A04880     05 WS-NULL-IND-03          PIC S9(4) COMP.                   
      *                                                                         
       01  PROGRAM-NAME-FIELD.                                          
           05  PROGRAM-NAME           PIC X(08) VALUE 'CSR04098'.       
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-UPDATE-IND            PIC X(01).                        
       01  PARM-ACCOUNT-NO            PIC X(13).                        
       01  PARM-ACCOUNT-ATTRIB        PIC X(15).                        
       01  PARM-ATTRIBUTE-STATUS      PIC X(01).                        
       01  PARM-TIER-CUST-STAT-CD     PIC X(01).                        
       01  PARM-TIER-ACCT-TYPE-CD     PIC X(01).                        
       01  PARM-MKT-TIER-RANKING      PIC S9(4) COMP.                   
       01  PARM-COMPANY-NO            PIC X(02).                        
       01  PARM-USER-ID               PIC X(07).                        
       01  PARM-TRANS-HIST-COMMENT    PIC X(210).                       
      *                                                                         
           EXEC SQL                                                     
              DECLARE FACTOR_CSR CURSOR WITH HOLD FOR                   
                 SELECT FF.FACTOR_ID                                    
                       ,FF.FACTOR                                       
                       ,FF.EFF_DATE_FROM                                
                       ,FF.EFF_DATE_TO                                  
                       ,FF.CODE_SEASON                                  
                       ,FF.CODE_TIME_PERIOD                             
                       ,FF.INSTR_USE_TYPE_CD                            
                       ,FF.CMPNT_ID_CD                                  
                       ,FF.FIXED_FCTR_TYP_CD                            
                       ,FF.CODE_UTIL_TYPE                               
                       ,FF.IC_NO                                        
                       ,FF.FIXED_FCTR_SEQ_NO                            
A03303                 ,SF.FCTR_POWER_10                                
                   FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
A03303                 ,CSS_SPCL_FCTR  SF WITH(READUNCOMMITTED)                 
                  WHERE FF.ACCOUNT_NO = :FF-ACCOUNT-NO                  
                    AND FF.FACTOR_ID  IN ('AGLSR SOC', 'AGLSR CUS')     
A03303              AND FF.FACTOR_ID  = SF.FACTOR_ID                    
                 ORDER BY FF.FACTOR_ID DESC                             
A03303           FOR READ ONLY                                  
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE FACTOR_CSR CURSOR WITH HOLD FOR                           
MFA-TR*          SELECT FF.FACTOR_ID                                            
MFA-TR*                ,FF.FACTOR                                               
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.CODE_SEASON                                          
MFA-TR*                ,FF.CODE_TIME_PERIOD                                     
MFA-TR*                ,FF.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,FF.CMPNT_ID_CD                                          
MFA-TR*                ,FF.FIXED_FCTR_TYP_CD                                    
MFA-TR*                ,FF.CODE_UTIL_TYPE                                       
MFA-TR*                ,FF.IC_NO                                                
MFA-TR*                ,FF.FIXED_FCTR_SEQ_NO                                    
MFA-TR*                ,SF.FCTR_POWER_10                                        
MFA-TR*            FROM CSS_FIXED_FCTR FF                                       
MFA-TR*                ,CSS_SPCL_FCTR  SF                                       
MFA-TR*           WHERE FF.ACCOUNT_NO = :FF-ACCOUNT-NO                          
MFA-TR*             AND FF.FACTOR_ID  IN ('AGLSR SOC', 'AGLSR CUS')             
MFA-TR*             AND FF.FACTOR_ID  = SF.FACTOR_ID                            
MFA-TR*          ORDER BY FF.FACTOR_ID DESC                                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION USING PARM-UPDATE-IND                         
                                PARM-ACCOUNT-NO                         
                                PARM-ACCOUNT-ATTRIB                     
                                PARM-ATTRIBUTE-STATUS                   
                                PARM-TIER-CUST-STAT-CD                  
                                PARM-TIER-ACCT-TYPE-CD                  
                                PARM-MKT-TIER-RANKING                   
                                PARM-COMPANY-NO                         
                                PARM-USER-ID                            
                                PARM-TRANS-HIST-COMMENT.                
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     RESET DB2 ERROR HANDLERS                                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE      AS  RETURN_CODE,                 
P00677             :S-SENIOR-FL        AS  SENIOR_FL                    
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE      AS  RETURN_CODE,                         
MFA-TR*            :S-SENIOR-FL        AS  SENIOR_FL                            
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-UPDATE-IND              TO WS-UPDATE-IND           
           MOVE PARM-ACCOUNT-NO              TO WS-ACCOUNT-NO           
           MOVE PARM-ACCOUNT-ATTRIB          TO WS-ACCOUNT-ATTRIB       
           MOVE PARM-ATTRIBUTE-STATUS        TO WS-ATTRIBUTE-STATUS     
           MOVE PARM-TIER-CUST-STAT-CD       TO WS-TIER-CUST-STAT-CD    
           MOVE PARM-TIER-ACCT-TYPE-CD       TO WS-TIER-ACCT-TYPE-CD    
           MOVE PARM-MKT-TIER-RANKING        TO WS-MKT-TIER-RANKING     
           MOVE PARM-COMPANY-NO              TO WS-COMPANY-NO           
                                                UV-COMPANY-NO           
           MOVE PARM-USER-ID                 TO WS-USER-ID.             
           MOVE PARM-TRANS-HIST-COMMENT      TO WS-TRANS-HIST-COMMENT.  
                                                                        
           MOVE WS-USER-ID                   TO PF-USER-ID.             
           PERFORM 7800-SELECT-RESP-AREA        THRU 7800-EXIT.         
                                                                        
           MOVE WS-ACCOUNT-NO             TO AT-ACCOUNT-NO              
                                             LR-ACCOUNT-NO              
                                             YP-ACCOUNT-NO              
                                             FF-ACCOUNT-NO              
                                             DD-ACCOUNT-NO.             
      * GET REVENUE MONTH                                                       
           PERFORM 7260-SEL-ACCOUNT-DET         THRU 7260-EXIT.         
           IF AT-REV-MTH-LST-NRML > ZEROES                              
             MOVE AT-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML     
             MOVE WS-REV-MTH-LST-NRML        TO WS-REV-MTH-LST-NRML-C   
             MOVE WS-REV-MTH-LST-NRML-C(1:4) TO WS-START-YR             
             MOVE WS-REV-MTH-LST-NRML-C(5:2) TO WS-START-MT             
             MOVE '01'                       TO WS-START-DY             
             MOVE WS-START-DATE              TO WS-DUMMY-DATE           
             MOVE WS-START-DATE              TO WS-FACTOR-XPIRE-DT      
             MOVE '28'                       TO WS-FACTOR-XPIRE-DT(9:2) 
             PERFORM 7230-ADD-ONE-MONTH         THRU 7230-EXIT          
             MOVE WS-RESULT-DATE             TO WS-FACTOR-START-DT      
           ELSE                                                         
             MOVE  20                        TO G6-SEQ-NO               
             MOVE '01'                       TO G6-COMPANY-NO           
             MOVE 'DATE'                     TO G6-CMND-CODE            
             MOVE 'COMMON'                   TO G6-PROGRAM-NAME         
             PERFORM 7400-SELECT-JOB-PARM       THRU 7400-EXIT          
             MOVE G6-PARM-DATA(15:6)         TO WS-COM-REV-MONTH        
             MOVE WS-COM-REV-MONTH(1:4)      TO WS-START-YR             
             MOVE WS-COM-REV-MONTH(5:2)      TO WS-START-MT             
             MOVE '01'                       TO WS-START-DY             
             MOVE WS-START-DATE              TO WS-FACTOR-START-DT      
           END-IF.                                                      
                                                                        
           PERFORM 7000-SET-TIMESTAMP           THRU 7000-EXIT.         
           MOVE WS-CURRENT-TIMESTAMP         TO FF-LAST-UPDATE-TS       
                                                YP-CREATED-TS           
                                                DD-CREATED-TS           
           MOVE WS-CURRENT-DATE              TO YP-ATTRIBUTE-VALUE-DT   
                                                WS-EFF-START-DT         
                                                DD-EFF-START-DT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE WS-UPDATE-IND                                       
             WHEN WS-UPDATE-ATTRIBUTES                                  
              PERFORM 5100-UPDATE-ACCT-ATTR  THRU 5100-EXIT             
             WHEN WS-UPDATE-ACCT-TIER                                   
              PERFORM 5200-UPDATE-ACCT-TIER  THRU 5200-EXIT             
           END-EVALUATE.                                                
                                                                        
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
           PERFORM 8990-SEND-RESULT             THRU 8990-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *2000A-MOVE-RESULT.                                                       
      *****************************************************************         
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
P00677     MOVE RS-SENIOR-FL           TO S-SENIOR-FL.                  
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5100-UPDATE-ACCT-ATTR.                                                  
      ******************************************************************        
       5100-UPDATE-ACCT-ATTR.                                           
                                                                        
           IF WS-ATTRIBUTE-STATUS EQUAL 'A'                             
              MOVE 'ACTIVE'                  TO WS-STATUS               
           ELSE                                                         
              MOVE 'INACTIVE'                TO WS-STATUS               
           END-IF.                                                      
                                                                        
           EVALUATE WS-ACCOUNT-ATTRIB                                   
             WHEN WS-AGL-SR-ATTRIBUTE                                   
P00677         PERFORM 5150-PROCESS-AGL-SR-ATTR  THRU 5150-EXIT         
             WHEN OTHER                                                 
               PERFORM 5170-UPD-INS-ACCT-ATTR   THRU 5170-EXIT          
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5150-PROCESS-AGL-SR-ATTR.                                      *        
      ******************************************************************        
       5150-PROCESS-AGL-SR-ATTR.                                        
                                                                        
            MOVE 'N'                         TO WS-FIXED-FCTR-FOUND     
                                                WS-ACCT-ATTR-FOUND.     
            MOVE SPACES                      TO YP-ATTRIBUTE-VALUE-CD.  
            PERFORM 7600-CHECK-ACCT-ATTR        THRU 7600-EXIT          
            IF WS-ATTRIBUTE-STATUS EQUAL 'A'                            
               MOVE 'N'                      TO WS-FIXED-FCTR-FOUND     
                                                WS-ACCT-ATTR-FOUND      
               MOVE WS-AGL-SR-ATTRIBUTE      TO YP-ATTRIBUTE-DESC       
               PERFORM 7200-CHECK-FIXED-FCTR    THRU 7200-EXIT          
               IF YP-ATTRIBUTE-VALUE-CD EQUAL 'YES'                     
                                  OR WS-FIXED-FCTR-FOUND EQUAL 'Y'      
                  MOVE 500                   TO RS-RETURN-CODE          
P00677            MOVE SPACES                TO RS-SENIOR-FL            
               ELSE                                                     
                  MOVE 'Y'                   TO LR-SENIOR-FL            
P00677            MOVE 'Y'                   TO RS-SENIOR-FL            
                  PERFORM 8440-UPD-SENIOR-FLAG     THRU 8440-EXIT       
                  PERFORM 5180-INS-AGL-SR-FACTORS  THRU 5180-EXIT       
                  PERFORM 5170-UPD-INS-ACCT-ATTR   THRU 5170-EXIT       
               END-IF                                                   
            ELSE                                                        
               MOVE 'N'                      TO WS-NO-MORE-ROWS         
               PERFORM 7300-OPEN-FIXED-FCTR     THRU 7300-EXIT          
               PERFORM 7310-FETCH-FIXED-FCTR    THRU 7310-EXIT          
               PERFORM 5190-PROCESS-SR-FACTORS  THRU 5190-EXIT          
                                                UNTIL NO-MORE-ROWS      
               PERFORM 7320-CLOSE-FIXED-FCTR    THRU 7320-EXIT          
               MOVE 'N'                         TO LR-SENIOR-FL         
P00677         MOVE 'N'                         TO RS-SENIOR-FL         
               PERFORM 8440-UPD-SENIOR-FLAG     THRU 8440-EXIT          
               PERFORM 5170-UPD-INS-ACCT-ATTR   THRU 5170-EXIT          
            END-IF.                                                     
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5160-MOVE-FF-VALUES.                                           *        
      ******************************************************************        
       5160-MOVE-FF-VALUES.                                             
                                                                        
            PERFORM 7500-GET-MAX-SEQ-NO      THRU 7500-EXIT.            
            IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE +0001                 TO FF-FIXED-FCTR-SEQ-NO       
            ELSE                                                        
               COMPUTE FF-FIXED-FCTR-SEQ-NO = FF-FIXED-FCTR-SEQ-NO + 1  
            END-IF                                                      
            MOVE 'G'                      TO FF-CODE-UTIL-TYPE.         
            MOVE +0001                    TO FF-IC-NO.                  
            MOVE '10'                     TO FF-CMPNT-ID-CD.            
            MOVE 'B'                      TO FF-CODE-SEASON.            
            MOVE 'R'                      TO FF-INSTR-USE-TYPE-CD.      
            MOVE WS-FACTOR-START-DT       TO FF-EFF-DATE-FROM.          
            MOVE '2999-12-31'             TO FF-EFF-DATE-TO.            
            MOVE '00'                     TO FF-FIXED-FCTR-TYP-CD.      
            MOVE ZEROES                   TO FF-CODE-TIME-PERIOD        
                                             FF-FACTOR                  
A03303                                       WS-FACTOR-FF               
                                             FF-FAC-CHRG-BASE-AM        
                                             FF-DURATION-REMAIN-NO      
                                             FF-RT-PKG-OPT-SEQ-NO.      
            MOVE -1                       TO WS-NULL-IND-02.            
                                                                        
       5160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5170-UPD-INS-ACCT-ATTR.                                                 
      ******************************************************************        
       5170-UPD-INS-ACCT-ATTR.                                          
                                                                        
            MOVE 'N'                         TO WS-ACCT-ATTR-FOUND.     
                                                                        
            MOVE SPACES                      TO YP-ATTRIBUTE-VALUE-CD.  
            MOVE WS-ACCOUNT-ATTRIB           TO YP-ATTRIBUTE-DESC.      
            PERFORM 7600-CHECK-ACCT-ATTR        THRU 7600-EXIT          
            IF WS-ACCT-ATTR-FOUND EQUAL 'Y'                             
               MOVE 'STATUS_CD'              TO UV-COLUMN-NA-TEXT       
               MOVE LENGTH OF UV-COLUMN-NA-TEXT                         
                                             TO UV-COLUMN-NA-LEN        
               MOVE 'CSS_ACCT_ATTRIBUTE'     TO UV-TABLE-NA-TEXT        
               MOVE LENGTH OF UV-TABLE-NA-TEXT                          
                                             TO UV-TABLE-NA-LEN         
               MOVE 'ALL'                    TO UV-PROGRAM-ID           
               MOVE YP-STATUS-CD             TO UV-CODE-VALUE-TEXT      
               MOVE LENGTH OF UV-CODE-VALUE-TEXT                        
                                             TO UV-CODE-VALUE-LEN       
               PERFORM 7700-SEL-CODE-VALUE-DESC THRU 7700-EXIT          
               MOVE UV-CODE-SHORT-DESC-TEXT  TO WS-PREV-STATUS          
               PERFORM 5500-UPD-ATTR-TRNS-HIST  THRU 5500-EXIT          
                                                                        
               IF WS-ATTRIBUTE-STATUS EQUAL 'A'                         
                  MOVE 'YES'                 TO YP-ATTRIBUTE-VALUE-CD   
               ELSE                                                     
                  MOVE 'NO'                  TO YP-ATTRIBUTE-VALUE-CD   
               END-IF                                                   
                                                                        
               MOVE WS-ATTRIBUTE-STATUS      TO YP-STATUS-CD            
               MOVE WS-CURRENT-DATE          TO YP-ATTRIBUTE-VALUE-DT   
               PERFORM 8300-UPDATE-ACCT-ATTR    THRU 8300-EXIT          
            ELSE                                                        
               PERFORM 5500-UPD-ATTR-TRNS-HIST  THRU 5500-EXIT          
               IF WS-ATTRIBUTE-STATUS EQUAL 'A'                         
                  MOVE 'YES'                 TO YP-ATTRIBUTE-VALUE-CD   
               ELSE                                                     
                  MOVE 'NO'                  TO YP-ATTRIBUTE-VALUE-CD   
               END-IF                                                   
               MOVE WS-ATTRIBUTE-STATUS      TO YP-STATUS-CD            
               MOVE WS-CURRENT-TIMESTAMP     TO YP-CREATED-TS           
               MOVE WS-CURRENT-DATE          TO YP-ATTRIBUTE-VALUE-DT   
               PERFORM 8200-INSERT-ACCT-ATTR    THRU 8200-EXIT          
            END-IF.                                                     
                                                                        
       5170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5180-INS-AGL-SR-FACTORS.                                       *        
      ******************************************************************        
       5180-INS-AGL-SR-FACTORS.                                         
                                                                        
            PERFORM 5160-MOVE-FF-VALUES         THRU 5160-EXIT.         
            MOVE 'AGLSR CUS'                 TO FF-FACTOR-ID            
            PERFORM 5550-INS-FCTR-TRNS-HIST     THRU 5550-EXIT          
            PERFORM 8100-INSERT-FIXED-FACTOR    THRU 8100-EXIT.         
            COMPUTE FF-FIXED-FCTR-SEQ-NO = FF-FIXED-FCTR-SEQ-NO + 1     
            MOVE 'AGLSR SOC'                 TO FF-FACTOR-ID            
            PERFORM 5550-INS-FCTR-TRNS-HIST     THRU 5550-EXIT          
            PERFORM 8100-INSERT-FIXED-FACTOR    THRU 8100-EXIT.         
                                                                        
       5180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5190-PROCESS-SR-FACTORS.                                       *        
      ******************************************************************        
       5190-PROCESS-SR-FACTORS.                                         
                                                                        
            IF AT-REV-MTH-LST-NRML > ZEROES                             
               IF FF-EFF-DATE-FROM >= WS-FACTOR-XPIRE-DT                
                  PERFORM 5570-DEL-FCTR-TRNS-HIST THRU 5570-EXIT        
                  PERFORM 8420-DEL-FF-FCTR        THRU 8420-EXIT        
               ELSE                                                     
                  PERFORM 5560-UPD-FCTR-TRNS-HIST THRU 5560-EXIT        
                  MOVE WS-FACTOR-XPIRE-DT      TO FF-EFF-DATE-TO        
                  PERFORM 8430-UPD-FF-FCTR        THRU 8430-EXIT        
               END-IF                                                   
            ELSE                                                        
               PERFORM 5570-DEL-FCTR-TRNS-HIST    THRU 5570-EXIT        
               PERFORM 8420-DEL-FF-FCTR           THRU 8420-EXIT        
            END-IF                                                      
            PERFORM 7310-FETCH-FIXED-FCTR         THRU 7310-EXIT.       
                                                                        
       5190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-UPDATE-ACCT-TIER                                          *        
      ******************************************************************        
       5200-UPDATE-ACCT-TIER.                                           
                                                                        
            MOVE 'ON'                     TO WS-TIER-SOURCE-CD.         
                                                                        
            MOVE WS-TIER-CUST-STAT-CD     TO IG-TIER-CUST-STAT-CD.      
            MOVE WS-TIER-ACCT-TYPE-CD     TO IG-TIER-ACCT-TYPE-CD.      
            MOVE WS-MKT-TIER-RANKING      TO IG-MKT-TIER-RANKING        
                                             1B-MKT-TIER-RANKING        
                                             1B-ADJ-TIER-RANKING.       
            MOVE WS-COMPANY-NO            TO IG-COMPANY-NO.             
                                                                        
            PERFORM 7620-SEL-MKT-EFF-DT      THRU 7620-EXIT             
            MOVE IG-MKT-TIER-START-DT     TO WS-MKT-TIER-START-DT       
            MOVE IG-MKT-TIER-DESC         TO WS-CURR-MKT-TIER-DESC      
I00113     IF IG-CUST-ACCT-DEFLT-FL EQUAL SCANA-SR-DEFLT-FLAG           
I00113        SET CUSTOMER-ON-SR-TIER TO TRUE                           
I00113     END-IF                                                       
                                                                        
            MOVE 'N'                      TO WS-DHR-CUSTOMER.           
P00172      MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO.            
            PERFORM 7840-SEL-DHR-HIST        THRU 7840-EXIT.            
            MOVE WS-DHR-CUSTOMER          TO 1B-DHR-QUALIFIED-FL        
                                                                        
            MOVE ZEROES                   TO 1B-ADJ-TIER-SEQ-NO.        
I00113      IF CUSTOMER-ON-SR-TIER                                      
I00113         MOVE AT-CUSTOMER-NO        TO CE-CUSTOMER-NO             
I00113         MOVE 'C'                   TO CE-CUSTOMER-TYPE           
I00113         MOVE SPACES                TO CE-DOB-VERIFIED-CD         
I00113                                       CE-DATE-OF-BIRTH           
I00113        PERFORM 7080-SELECT-CUST-STATS    THRU 7080-EXIT          
I00113        IF CE-DOB-VERIFIED-CD NOT EQUAL SPACES                    
I00113                      AND CE-DATE-OF-BIRTH NOT EQUAL SPACES       
I00113           MOVE WS-CURRENT-DATE        TO WS-DUMMY-DATE-ST        
I00113           MOVE CE-DATE-OF-BIRTH       TO WS-DUMMY-DATE-END       
I00113           MOVE SCANA-SR-AGE           TO C8-DELINQ-CD            
I00113           MOVE '01'                   TO C8-COMPANY-NO           
I00113           PERFORM 7060-SELECT-DELINQNCY  THRU 7060-EXIT          
I00113           PERFORM 7070-GET-YEAR-BETWEEN  THRU 7070-EXIT          
I00113           IF WS-RESULT-YEAR >= C8-DELINQ-VALUE                   
I00113              MOVE 'S'                 TO 1B-AGL-LOW-INCM-SR-FL   
I00113              PERFORM 7860-SEL-TIER-ADJ-SEQ-NO-SR THRU 7860-EXIT  
I00113           ELSE                                                   
I00113              MOVE 'Y'                 TO 1B-AGL-LOW-INCM-SR-FL   
I00113              PERFORM 7860-SEL-TIER-ADJ-SEQ-NO-SR THRU 7860-EXIT  
I00113           END-IF                                                 
I00113        ELSE                                                      
I00113           MOVE 'Y'                    TO 1B-AGL-LOW-INCM-SR-FL   
I00113           PERFORM 7860-SEL-TIER-ADJ-SEQ-NO-SR THRU 7860-EXIT     
I00113        END-IF                                                    
I00113      ELSE                                                        
I00113         PERFORM 7810-SEL-TIER-ADJ-SEQ-NO THRU 7810-EXIT          
I00113      END-IF                                                      
            MOVE 1B-ADJ-TIER-SEQ-NO       TO WS-ADJ-TIER-SEQ-NO         
            MOVE 1B-TIER-ADJ-DESC         TO WS-CURR-TIER-ADJ-DESC      
                                                                        
            MOVE 'N'                      TO WS-MKT-TIER-FOUND          
            PERFORM 7630-SEL-MKT-TIER-DET    THRU 7630-EXIT             
                                                                        
            IF MKT-TIER-FOUND                                           
               MOVE DD-TIER-CUST-STAT-CD  TO IG-TIER-CUST-STAT-CD       
               MOVE DD-TIER-ACCT-TYPE-CD  TO IG-TIER-ACCT-TYPE-CD       
               MOVE DD-MKT-TIER-RANKING   TO IG-MKT-TIER-RANKING        
               MOVE DD-COMPANY-NO         TO IG-COMPANY-NO              
               MOVE DD-MKT-TIER-START-DT  TO IG-MKT-TIER-START-DT       
               PERFORM 7820-SEL-MKT-TIER-DESC THRU 7820-EXIT            
               MOVE IG-MKT-TIER-DESC         TO WS-PREV-MKT-TIER-DESC   
                                                                        
               MOVE DD-ADJ-TIER-SEQ-NO       TO 1B-ADJ-TIER-SEQ-NO      
               MOVE SPACES                   TO 1B-TIER-ADJ-DESC        
               PERFORM 7830-SEL-TIER-ADJ-DESC THRU 7830-EXIT            
               MOVE 1B-TIER-ADJ-DESC         TO WS-PREV-TIER-ADJ-DESC   
            END-IF                                                      
                                                                        
            IF MKT-TIER-FOUND                                           
               IF WS-EFF-START-DT EQUAL DD-EFF-START-DT                 
                  PERFORM 5595-DEL-INS-TIER-TANS THRU 5595-EXIT         
                  PERFORM 8410-DEL-MKT-TIER      THRU 8410-EXIT         
                  PERFORM 5210-MOVE-TIER-VALUES  THRU 5210-EXIT         
                  PERFORM 8000-INSERT-MKT-TIER   THRU 8000-EXIT         
A04880            PERFORM 5585-PROCESS-REG-GROUP THRU 5585-EXIT         
               ELSE                                                     
                  PERFORM 5580-INS-TIER-TRNS-HIST   THRU 5580-EXIT      
                  PERFORM 5210-MOVE-TIER-VALUES     THRU 5210-EXIT      
                  PERFORM 8000-INSERT-MKT-TIER      THRU 8000-EXIT      
A04880            PERFORM 5585-PROCESS-REG-GROUP    THRU 5585-EXIT      
               END-IF                                                   
            ELSE                                                        
               PERFORM 5580-INS-TIER-TRNS-HIST  THRU 5580-EXIT          
               PERFORM 5210-MOVE-TIER-VALUES    THRU 5210-EXIT          
               PERFORM 8000-INSERT-MKT-TIER     THRU 8000-EXIT          
A04880         PERFORM 5585-PROCESS-REG-GROUP   THRU 5585-EXIT          
            END-IF.                                                     
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5210-MOVE-TIER-VALUES.                                         *        
      ******************************************************************        
       5210-MOVE-TIER-VALUES.                                           
                                                                        
            MOVE WS-TIER-CUST-STAT-CD     TO DD-TIER-CUST-STAT-CD       
            MOVE WS-TIER-ACCT-TYPE-CD     TO DD-TIER-ACCT-TYPE-CD       
            MOVE WS-MKT-TIER-RANKING      TO DD-MKT-TIER-RANKING        
            MOVE WS-COMPANY-NO            TO DD-COMPANY-NO              
            MOVE WS-USER-ID               TO DD-LAST-UPDATE-USERID.     
            MOVE WS-CURRENT-DATE          TO DD-LAST-EVALUATED-DT       
            MOVE WS-CURRENT-TIMESTAMP     TO DD-LAST-UPDATE-TS          
                                             DD-CREATED-TS.             
            MOVE WS-TIER-SOURCE-CD        TO DD-TIER-SOURCE-CD.         
            MOVE WS-ADJ-TIER-SEQ-NO       TO DD-ADJ-TIER-SEQ-NO.        
            MOVE WS-CURRENT-DATE          TO DD-EFF-START-DT.           
            MOVE WS-MKT-TIER-START-DT     TO DD-MKT-TIER-START-DT.      
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5220-SELECT-CODE-VALUE.                                        *        
      ******************************************************************        
       5220-SELECT-CODE-VALUE.                                          
                                                                        
           MOVE SPACES                       TO UV-CODE-SHORT-DESC-TEXT 
           MOVE LENGTH OF UV-CODE-VALUE-TEXT TO UV-CODE-VALUE-LEN       
           MOVE LENGTH OF UV-COLUMN-NA-TEXT  TO UV-COLUMN-NA-LEN        
           MOVE LENGTH OF UV-TABLE-NA-TEXT   TO UV-TABLE-NA-LEN         
           PERFORM 7700-SEL-CODE-VALUE-DESC THRU 7700-EXIT.             
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5500-UPD-ATTR-TRNS-HIST.                                       *        
      ******************************************************************        
       5500-UPD-ATTR-TRNS-HIST.                                         
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST        THRU 5800-EXIT.           
           STRING 'ATTRIBUTE: '     DELIMITED BY SIZE                   
                  WS-ACCOUNT-ATTRIB DELIMITED BY SIZE                   
                  WS-DELIMITER      DELIMITED BY SIZE                   
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING                                                   
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                          TO MH-TRAN-COMMENT-LEN.       
P00740     PERFORM 5810-APPEND-COMMENTS       THRU 5810-EXIT.           
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
           MOVE +01                     TO WS-TRAN-APPL-NO              
                                                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO             
           MOVE SPACES                   TO MI-TABLE-ID                 
                                                                        
           IF WS-ACCT-ATTR-FOUND EQUAL 'Y'                              
              MOVE WS-STATUS             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-STATUS                                  
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-PREV-STATUS        TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-PREV-STATUS                             
                                         TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 'STATUS'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
                                                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE YP-ATTRIBUTE-VALUE-DT TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ATTR VALUE DT'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           ELSE                                                         
              MOVE WS-STATUS             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE LENGTH OF WS-STATUS                                  
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATUS'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                      TO WS-TRAN-APPL-NO             
                                                                        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-CURRENT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ATTR VALUE DT'          TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5550-INS-FCTR-TRNS-HIST.                                       *        
      ******************************************************************        
       5550-INS-FCTR-TRNS-HIST.                                         
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST       THRU 5800-EXIT.            
                                                                        
           STRING 'FACTOR ID: '     DELIMITED BY SIZE                   
                  FF-FACTOR-ID      DELIMITED BY SIZE                   
                  WS-DELIMITER      DELIMITED BY SIZE                   
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING                                                   
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                          TO MH-TRAN-COMMENT-LEN.       
P00740     PERFORM 5810-APPEND-COMMENTS       THRU 5810-EXIT.           
                                                                        
           MOVE SPACES                    TO MI-TABLE-ID                
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +01                       TO WS-TRAN-APPL-NO            
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE WS-FACTOR-VALUE-RED       TO WS-HOLD-FACT-VAL-RED.      
           MOVE WS-HOLD-FACT-VAL-RED      TO WS-FACTOR-TEXT.            
           MOVE WS-FACTOR-TEXT            TO WS-FACT-VAL-Z              
           MOVE WS-FACT-VAL-Z             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
           MOVE 'FACTOR-VALUE   '         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE FF-EFF-DATE-FROM          TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'DATE FROM      '         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE FF-EFF-DATE-TO            TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'DATE TO        '         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE FF-CODE-SEASON            TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'SEASON CODE    '         TO MI-COLUMN-DESC.            
           MOVE '42'                      TO MI-TABLE-ID.               
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE FF-INSTR-USE-TYPE-CD      TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'INSTR USE    '           TO MI-COLUMN-DESC.            
           MOVE '43'                      TO MI-TABLE-ID.               
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE FF-CODE-TIME-PERIOD       TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'TIME PERIOD  '           TO MI-COLUMN-DESC.            
           MOVE '44'                      TO MI-TABLE-ID.               
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +2                        TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE FF-CMPNT-ID-CD            TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'COMPONENT ID '           TO MI-COLUMN-DESC.            
           MOVE 'N6'                      TO MI-TABLE-ID.               
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 5560-UPD-FCTR-TRNS-HIST.                                    *           
      ***************************************************************           
       5560-UPD-FCTR-TRNS-HIST.                                         
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST       THRU 5800-EXIT.            
                                                                        
           STRING 'FACTOR ID: '     DELIMITED BY SIZE                   
                  FF-FACTOR-ID      DELIMITED BY SIZE                   
                  WS-DELIMITER      DELIMITED BY SIZE                   
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING                                                   
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                          TO MH-TRAN-COMMENT-LEN.       
P00740     PERFORM 5810-APPEND-COMMENTS       THRU 5810-EXIT.           
                                                                        
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +01                       TO WS-TRAN-APPL-NO            
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
           MOVE WS-FACTOR-XPIRE-DT        TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE FF-EFF-DATE-TO            TO MI-PRV-COLUMN-VALUE-TEXT   
           MOVE 'DATE TO        '         TO MI-COLUMN-DESC             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       5560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 5570-DEL-FCTR-TRNS-HIST.                                    *           
      ***************************************************************           
       5570-DEL-FCTR-TRNS-HIST.                                         
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST       THRU 5800-EXIT.            
                                                                        
           STRING 'FACTOR ID: '     DELIMITED BY SIZE                   
                  FF-FACTOR-ID      DELIMITED BY SIZE                   
                  WS-DELIMITER      DELIMITED BY SIZE                   
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING                                                   
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                          TO MH-TRAN-COMMENT-LEN.       
P00740     PERFORM 5810-APPEND-COMMENTS       THRU 5810-EXIT.           
                                                                        
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +01                       TO WS-TRAN-APPL-NO            
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
A03303     IF SF-FCTR-POWER-10 NOT EQUAL 0                              
A03303        COMPUTE WS-FACTOR-FF = FF-FACTOR * 10** SF-FCTR-POWER-10  
A03303        MOVE WS-FACTOR-FF              TO WS-HOLD-FACT-VAL-RED    
A03303     ELSE                                                         
              MOVE FF-FACTOR                 TO WS-HOLD-FACT-VAL-RED    
A03303     END-IF.                                                      
           MOVE WS-HOLD-FACT-VAL-RED      TO WS-FACTOR-TEXT.            
           MOVE WS-FACTOR-TEXT            TO WS-FACT-VAL-Z              
           MOVE WS-FACT-VAL-Z             TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'FACTOR-VALUE   '         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE FF-EFF-DATE-FROM          TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'DATE FROM      '         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE FF-EFF-DATE-TO            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'DATE TO        '         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE FF-CODE-SEASON            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'SEASON CODE    '         TO MI-COLUMN-DESC.            
           MOVE '42'                      TO MI-TABLE-ID                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE FF-INSTR-USE-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'INSTR CODE'              TO MI-COLUMN-DESC.            
           MOVE '43'                      TO MI-TABLE-ID                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE FF-CODE-TIME-PERIOD       TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'TIME PERIOD'             TO MI-COLUMN-DESC.            
           MOVE '44'                      TO MI-TABLE-ID                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD 1                          TO WS-TRAN-APPL-NO.           
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +11                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE '**DELETED**'             TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE FF-CMPNT-ID-CD            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE 'COMPONENT ID'            TO MI-COLUMN-DESC.            
           MOVE 'N6'                      TO MI-TABLE-ID                
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                          TO WS-TRAN-APPL-NO.           
                                                                        
       5570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      *                                                             *           
      * 5580-INS-TIER-TRNS-HIST.                                    *           
      ***************************************************************           
       5580-INS-TIER-TRNS-HIST.                                         
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST      THRU 5800-EXIT.             
P00740     PERFORM 5810-APPEND-COMMENTS     THRU 5810-EXIT.             
                                                                        
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +01                       TO WS-TRAN-APPL-NO            
                                                                        
           MOVE 'TIER_CUST_STAT_CD'          TO UV-COLUMN-NA-TEXT       
           MOVE LENGTH OF UV-COLUMN-NA-TEXT  TO UV-COLUMN-NA-LEN        
           MOVE 'CRM_MKT_TIER'               TO UV-TABLE-NA-TEXT        
           MOVE LENGTH OF UV-TABLE-NA-TEXT   TO UV-TABLE-NA-LEN         
           MOVE 'ALL'                        TO UV-PROGRAM-ID           
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           IF DD-TIER-CUST-STAT-CD > SPACES                             
              MOVE DD-TIER-CUST-STAT-CD                                 
                                             TO UV-CODE-VALUE-TEXT      
              MOVE LENGTH OF UV-CODE-VALUE-TEXT                         
                                             TO UV-CODE-VALUE-LEN       
              PERFORM 7700-SEL-CODE-VALUE-DESC  THRU 7700-EXIT          
              MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                          TO MI-PRV-COLUMN-VALUE-LEN    
           ELSE                                                         
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
           END-IF                                                       
                                                                        
           MOVE SPACES                       TO UV-CODE-SHORT-DESC      
           MOVE WS-TIER-CUST-STAT-CD         TO UV-CODE-VALUE-TEXT      
           MOVE LENGTH OF UV-CODE-VALUE-TEXT TO UV-CODE-VALUE-LEN       
           PERFORM 7700-SEL-CODE-VALUE-DESC     THRU 7700-EXIT.         
           MOVE UV-CODE-SHORT-DESC-TEXT                                 
                                             TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN.
           MOVE 'ACCOUNT TYPE'               TO MI-COLUMN-DESC.         
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  +1                           TO WS-TRAN-APPL-NO.        
                                                                        
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           MOVE 'TT'                         TO MI-TABLE-ID.            
           IF DD-TIER-ACCT-TYPE-CD > SPACES                             
              MOVE +01                       TO MI-PRV-COLUMN-VALUE-LEN 
              MOVE DD-TIER-ACCT-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT
           ELSE                                                         
              MOVE '*NEW*'                   TO MI-PRV-COLUMN-VALUE-TEXT
              MOVE +5                        TO MI-PRV-COLUMN-VALUE-LEN 
           END-IF                                                       
           MOVE +01                          TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE WS-TIER-ACCT-TYPE-CD         TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE 'ACCOUNT SUB TYPE'           TO MI-COLUMN-DESC.         
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  +1                           TO WS-TRAN-APPL-NO.        
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE SPACES                    TO MI-TABLE-ID.               
           IF WS-PREV-MKT-TIER-DESC > SPACES                            
              MOVE WS-PREV-MKT-TIER-DESC  TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                          TO MI-PRV-COLUMN-VALUE-LEN    
           ELSE                                                         
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
           END-IF                                                       
           MOVE WS-CURR-MKT-TIER-DESC     TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'TIER RANKING'            TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           IF DD-EFF-START-DT > SPACES                                  
              MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE DD-EFF-START-DT        TO MI-PRV-COLUMN-VALUE-TEXT   
           ELSE                                                         
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
           END-IF                                                       
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN    
           MOVE WS-EFF-START-DT           TO MI-CHG-COLUMN-VALUE-TEXT   
           MOVE 'START DATE'              TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE 'TIER_SOURCE_CD'          TO UV-COLUMN-NA-TEXT          
           MOVE LENGTH OF UV-COLUMN-NA-TEXT                             
                                          TO UV-COLUMN-NA-LEN           
           MOVE 'CSS_ACCT_MKT_TIER'       TO UV-TABLE-NA-TEXT           
           MOVE LENGTH OF UV-TABLE-NA-TEXT                              
                                          TO UV-TABLE-NA-LEN            
           MOVE LENGTH OF UV-CODE-VALUE-TEXT                            
                                          TO UV-CODE-VALUE-LEN          
           MOVE 'ALL'                     TO UV-PROGRAM-ID              
           PERFORM 7700-SEL-CODE-VALUE-DESC THRU 7700-EXIT.             
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           IF DD-TIER-SOURCE-CD > SPACES                                
              MOVE DD-TIER-SOURCE-CD      TO UV-CODE-VALUE-TEXT         
              PERFORM 7700-SEL-CODE-VALUE-DESC THRU 7700-EXIT           
              MOVE UV-CODE-SHORT-DESC-TEXT                              
                                          TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                          TO MI-PRV-COLUMN-VALUE-LEN    
           ELSE                                                         
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
           END-IF                                                       
           MOVE WS-TIER-SOURCE-CD         TO UV-CODE-VALUE-TEXT         
           PERFORM 7700-SEL-CODE-VALUE-DESC THRU 7700-EXIT.             
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'SOURCE CODE'             TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           IF WS-ADJ-TIER-SEQ-NO EQUAL ZEROES                           
                             AND DD-ADJ-TIER-SEQ-NO EQUAL ZEROES        
              GO TO 5580-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE 'TIER ADJ REASON'         TO MI-COLUMN-DESC.            
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           IF WS-PREV-TIER-ADJ-DESC > SPACES                            
              MOVE WS-PREV-TIER-ADJ-DESC                                
                                          TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                          TO MI-PRV-COLUMN-VALUE-LEN    
           ELSE                                                         
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                          TO MI-PRV-COLUMN-VALUE-LEN    
           END-IF                                                       
           MOVE WS-CURR-TIER-ADJ-DESC     TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'ADJ TIER SEQ NO'         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       5580-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04880******************************************************************        
A04880*                                                                *        
A04880* 5585-PROCESS-REG-GROUP.                                        *        
A04880******************************************************************        
A04880 5585-PROCESS-REG-GROUP.                                          
A04880                                                                  
A04880     IF WS-TIER-ACCT-TYPE-CD  = '1' OR '2'                        
A04880        IF DD-TIER-ACCT-TYPE-CD NOT= WS-TIER-ACCT-TYPE-CD         
A04880           IF WS-TIER-ACCT-TYPE-CD = '1'                          
A04880              MOVE '100'  TO  WS-REG-GROUP-CD                     
A04880           END-IF                                                 
A04880           IF WS-TIER-ACCT-TYPE-CD = '2'                          
A04880              MOVE '200'  TO  WS-REG-GROUP-CD                     
A04880           END-IF                                                 
A04880           PERFORM 7900-SEL-REG-GROUP     THRU 7900-EXIT          
A04880           PERFORM 5590-UPD-REG-TRNS-HIST THRU 5590-EXIT          
A04880           PERFORM 8450-UPD-REG-GROUP-CD  THRU 8450-EXIT          
A04880        END-IF                                                    
A04880     END-IF.                                                      
A04880                                                                  
A04880 5585-EXIT.                                                       
A04880     EXIT.                                                        
A04880                                                                  
A04880***************************************************************           
A04880*                                                             *           
A04880* 5590-UPD-REG-TRNS-HIST.                                     *           
A04880***************************************************************           
A04880 5590-UPD-REG-TRNS-HIST.                                          
A04880                                                                  
A04880     PERFORM 5800-LOAD-TRAN-HIST       THRU 5800-EXIT.            
A04880                                                                  
A04880     STRING 'REG GROUP CD : ' DELIMITED BY SIZE                   
A04880            LR-REG-GROUP-CD   DELIMITED BY SIZE                   
                  WS-DELIMITER      DELIMITED BY SIZE                   
A04880       INTO MH-TRAN-COMMENT-TEXT                                  
A04880     END-STRING                                                   
A04880     MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
A04880                                    TO MH-TRAN-COMMENT-LEN.       
P00740     PERFORM 5810-APPEND-COMMENTS     THRU 5810-EXIT.             
A04880                                                                  
A04880     MOVE SPACES                    TO MI-TABLE-ID.               
A04880     MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
A04880     MOVE +01                       TO WS-TRAN-APPL-NO            
A04880                                                                  
A04880     MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
A04880     MOVE +03                       TO MI-PRV-COLUMN-VALUE-LEN    
A04880                                       MI-CHG-COLUMN-VALUE-LEN    
A04880     MOVE WS-REG-GROUP-CD           TO MI-CHG-COLUMN-VALUE-TEXT   
A04880     MOVE LR-REG-GROUP-CD           TO MI-PRV-COLUMN-VALUE-TEXT   
A04880     MOVE 'REG GROUP CD   '         TO MI-COLUMN-DESC             
A04880     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A04880                                                                  
A04880 5590-EXIT.                                                       
A04880     EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      * 5595-DEL-INS-TIER-TANS.                                     *           
      ***************************************************************           
       5595-DEL-INS-TIER-TANS.                                          
                                                                        
           PERFORM 5800-LOAD-TRAN-HIST      THRU 5800-EXIT.             
P00740     PERFORM 5810-APPEND-COMMENTS     THRU 5810-EXIT.             
                                                                        
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +01                       TO WS-TRAN-APPL-NO            
                                                                        
           MOVE DD-TIER-CUST-STAT-CD      TO UV-CODE-VALUE-TEXT         
           MOVE 'TIER_CUST_STAT_CD'       TO UV-COLUMN-NA-TEXT          
           MOVE 'CRM_MKT_TIER'            TO UV-TABLE-NA-TEXT           
           MOVE 'ALL'                     TO UV-PROGRAM-ID              
           PERFORM 5220-SELECT-CODE-VALUE   THRU 5220-EXIT.             
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-TIER-CUST-STAT-CD      TO UV-CODE-VALUE-TEXT         
           PERFORM 5220-SELECT-CODE-VALUE   THRU 5220-EXIT.             
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'ACCOUNT TYPE'            TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE 'TT'                      TO MI-TABLE-ID.               
           MOVE DD-TIER-ACCT-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +01                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE +01                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE WS-TIER-ACCT-TYPE-CD      TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE 'ACCOUNT SUB TYPE'        TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE WS-PREV-MKT-TIER-DESC     TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-CURR-MKT-TIER-DESC     TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'TIER RANKING'            TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE +10                       TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE DD-EFF-START-DT           TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE +10                       TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE WS-EFF-START-DT           TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE 'START DATE'              TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE 'TIER_SOURCE_CD'          TO UV-COLUMN-NA-TEXT          
           MOVE 'CSS_ACCT_MKT_TIER'       TO UV-TABLE-NA-TEXT           
           MOVE 'ALL'                     TO UV-PROGRAM-ID              
           MOVE DD-TIER-SOURCE-CD         TO UV-CODE-VALUE-TEXT         
           PERFORM 5220-SELECT-CODE-VALUE   THRU 5220-EXIT.             
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-TIER-SOURCE-CD         TO UV-CODE-VALUE-TEXT         
           PERFORM 5220-SELECT-CODE-VALUE   THRU 5220-EXIT.             
           MOVE UV-CODE-SHORT-DESC-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'SOURCE CODE'             TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD  +1                        TO WS-TRAN-APPL-NO.           
                                                                        
           IF WS-ADJ-TIER-SEQ-NO EQUAL ZEROES                           
                                   AND DD-ADJ-TIER-SEQ-NO EQUAL ZEROES  
              GO TO 5595-EXIT                                           
           END-IF                                                       
                                                                        
           MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.           
           MOVE WS-PREV-TIER-ADJ-DESC     TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-CURR-TIER-ADJ-DESC     TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                          TO MI-CHG-COLUMN-VALUE-LEN.   
           MOVE 'TIER ADJ REASON'         TO MI-COLUMN-DESC.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       5595-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5800-LOAD-TRAN-HIST.                                           *        
      ******************************************************************        
       5800-LOAD-TRAN-HIST.                                             
                                                                        
           PERFORM 7000-SET-TIMESTAMP         THRU 7000-EXIT.           
                                                                        
           MOVE WS-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO              TO MH-ACCOUNT-NO.            
           IF WS-UPDATE-IND EQUAL 'A'                                   
              MOVE WS-ACT-ATTR-UPD         TO MH-APPL-PROGRAM-ID        
           ELSE                                                         
              MOVE WS-MKT-TIER-UPD         TO MH-APPL-PROGRAM-ID        
           END-IF.                                                      
           MOVE 'F'                        TO MH-CODE-TRAN-TYPE.        
           MOVE WS-CURRENT-DATE            TO MH-DATE-TRANS.            
           MOVE ZEROES                     TO MH-CUSTOMER-NO            
                                              MH-PREMISE-NO.            
           MOVE PF-RESP-AREA-ID            TO MH-RESP-AREA-ID.          
           MOVE WS-CURRENT-TIMESTAMP       TO MH-TRANS-HIST-SEQ-NO.     
           MOVE WS-USER-ID                 TO MH-USER-ID.               
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740******************************************************************        
P00740* 5810-APPEND-COMMENTS.                                          *        
P00740******************************************************************        
P00740 5810-APPEND-COMMENTS.                                            
P00740                                                                  
P00740     IF WS-TRANS-HIST-COMMENT > SPACES                            
P00740        STRING MH-TRAN-COMMENT-TEXT  DELIMITED WS-DELIMITER       
P00740               '  '                 DELIMITED SIZE               
P00740               WS-TRANS-HIST-COMMENT DELIMITED WS-DELIMITER       
P00740          INTO MH-TRAN-COMMENT-TEXT                               
P00740        END-STRING                                                
P00740        MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                       
P00740                                    TO MH-TRAN-COMMENT-LEN        
P00740     END-IF.                                                      
P00740 5810-EXIT.                                                       
P00740     EXIT.                                                        
P00740                                                                  
I00113******************************************************************        
I00113*                                                                *        
I00113* 7060-SELECT-DELINQNCY                                          *        
I00113******************************************************************        
I00113 7060-SELECT-DELINQNCY.                                           
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT DELINQ_VALUE                                      
I00113           INTO :C8-DELINQ-VALUE                                  
I00113           FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
I00113          WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                     
I00113            AND C8.COMPANY_NO = :C8-COMPANY-NO                    
A03303                                                           
A03303                                                      
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY C8                                        
MFA-TR*         WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                             
MFA-TR*           AND C8.COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7060                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7060'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00113        MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
I00113        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
I00113        MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-2         
I00113        MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
I00113        MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-2       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7060-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
I00113******************************************************************        
I00113*                                                                *        
I00113* 7070-GET-YEAR-BETWEEN.                                         *        
I00113******************************************************************        
I00113 7070-GET-YEAR-BETWEEN.                                           
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT
              ( 12 *                            
I00113                                  CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))     
I00113                                  + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                      :WS-DUMMY-DATE-ST
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-ST
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-ST) <> 10), CIS.CHAR2DATE(
                                                      :WS-DUMMY-DATE-ST
              ), CONVERT(DATE, :WS-DUMMY-DATE-ST) ), 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-END
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-END
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-END
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-END
              ), CONVERT(DATE, :WS-DUMMY-DATE-END) ) ))     
I00113                                 ) / 12
            INTO
              :WS-RESULT-YEAR                           
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-YEAR =  ( 12 *                                    
MFA-TR*                                 YEAR(DATE(:WS-DUMMY-DATE-ST)            
MFA-TR*                                 - DATE(:WS-DUMMY-DATE-END))             
MFA-TR*                                 + MONTH(DATE(:WS-DUMMY-DATE-ST)         
MFA-TR*                                 - DATE(:WS-DUMMY-DATE-END))             
MFA-TR*                                ) / 12                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7070'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00113        MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
I00113        MOVE 'START DATE'              TO TABLE-ELEMENT-1         
I00113        MOVE 'END DATE'                TO TABLE-ELEMENT-2         
I00113        MOVE WS-DUMMY-DATE-ST          TO HOSTVAR-ELEMENT-1       
I00113        MOVE WS-DUMMY-DATE-END         TO HOSTVAR-ELEMENT-2       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7070-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
I00113******************************************************************        
I00113*                                                                *        
I00113* 7080-SELECT-CUST-STATS.                                        *        
I00113******************************************************************        
I00113 7080-SELECT-CUST-STATS.                                          
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT CE.DOB_VERIFIED_CD                                
I00113               ,CE.DATE_OF_BIRTH                                  
I00113           INTO :CE-DOB-VERIFIED-CD                               
I00113               ,:CE-DATE-OF-BIRTH :WS-NULL-IND-01                  
I00113           FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
I00113          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                
I00113            AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE              
A03303                                                           
A03303                                                      
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CE.DOB_VERIFIED_CD                                        
MFA-TR*              ,CE.DATE_OF_BIRTH                                          
MFA-TR*          INTO :CE-DOB-VERIFIED-CD                                       
MFA-TR*              ,:CE-DATE-OF-BIRTH:WS-NULL-IND-01                          
MFA-TR*          FROM CSS_CUST_STATS CE                                         
MFA-TR*         WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                        
MFA-TR*           AND CE.CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                      
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7080                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
I00113        NEXT SENTENCE                                             
I00113     ELSE                                                         
I00113        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
I00113        MOVE '7080'                    TO ACTIVE-PARAGRAPH        
I00113        MOVE 'SELECT'                  TO ABEND-FUNCTION          
I00113        MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
I00113        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1         
I00113        MOVE 'CUSTOMER_TYPE'           TO TABLE-ELEMENT-2         
I00113        MOVE CE-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
I00113        MOVE CE-CUSTOMER-TYPE          TO HOSTVAR-ELEMENT-2       
I00113        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
I00113        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7080-EXIT.                                                       
I00113     EXIT.                                                        
I00113                                                                  
      ******************************************************************        
      * 7000-SET-TIMESTAMP                                             *        
      ******************************************************************        
       7000-SET-TIMESTAMP.                                              
      *                                                                         
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP      = CURRENT TIMESTAMP                
MFA-TR*          ,:WS-CURRENT-DATE           = CURRENT DATE                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SET'                     TO ABEND-FUNCTION          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7230-ADD-ONE-MONTH.                                           *         
      *****************************************************************         
       7230-ADD-ONE-MONTH.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, 1, IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE
              ) <> 0) OR (LEN(:WS-DUMMY-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-DUMMY-DATE
              ), CONVERT(DATE, :WS-DUMMY-DATE) ) )
            INTO
              :WS-RESULT-DATE     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-RESULT-DATE = DATE(:WS-DUMMY-DATE)  + 1 MONTH             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'DUMMY_DATE'              TO TABLE-ELEMENT-2         
              MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE WS-DUMMY-DATE             TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CHECK-FIXED-FCTR.                                         *        
      ******************************************************************        
       7200-CHECK-FIXED-FCTR.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                   INTO :WS-FIXED-FCTR-FOUND                            
                   FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                    
                  WHERE ACCOUNT_NO = :FF-ACCOUNT-NO                     
                    AND FACTOR_ID  IN ('AGLSR CUS', 'AGLSR SOC')        
P00677              AND EFF_DATE_TO > IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                  
                                             
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*            INTO :WS-FIXED-FCTR-FOUND                                    
MFA-TR*            FROM CSS_FIXED_FCTR                                          
MFA-TR*           WHERE ACCOUNT_NO = :FF-ACCOUNT-NO                             
MFA-TR*             AND FACTOR_ID  IN ('AGLSR CUS', 'AGLSR SOC')                
MFA-TR*             AND EFF_DATE_TO > :WS-CURRENT-DATE                          
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE FF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7260-SEL-ACCOUNT-DET.                                          *        
      ******************************************************************        
       7260-SEL-ACCOUNT-DET.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT REV_MTH_LST_NRML                                  
I00113               ,CUSTOMER_NO                                       
                 INTO :AT-REV-MTH-LST-NRML                              
I00113               ,:AT-CUSTOMER-NO                                   
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REV_MTH_LST_NRML                                          
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*          INTO :AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7260                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7260'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-OPEN-FIXED-FCTR.                                          *        
      ******************************************************************        
       7300-OPEN-FIXED-FCTR.                                            
                                                                        
           EXEC SQL                                                     
                OPEN FACTOR_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FACTOR'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7310-FETCH-FIXED-FCTR.                                         *        
      ******************************************************************        
                                                                        
       7310-FETCH-FIXED-FCTR.                                           
           EXEC SQL                                                     
               FETCH FACTOR_CSR                                         
                INTO :FF-FACTOR-ID                                      
                    ,:FF-FACTOR                                         
                    ,:FF-EFF-DATE-FROM                                  
                    ,:FF-EFF-DATE-TO                                    
                    ,:FF-CODE-SEASON                                    
                    ,:FF-CODE-TIME-PERIOD                               
                    ,:FF-INSTR-USE-TYPE-CD                              
                    ,:FF-CMPNT-ID-CD                                    
                    ,:FF-FIXED-FCTR-TYP-CD                              
                    ,:FF-CODE-UTIL-TYPE                                 
                    ,:FF-IC-NO                                          
                    ,:FF-FIXED-FCTR-SEQ-NO                              
A03303              ,:SF-FCTR-POWER-10                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-NO-MORE-ROWS         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FACTOR'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7320-CLOSE-FIXED-FCTR.                                         *        
      ******************************************************************        
       7320-CLOSE-FIXED-FCTR.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE FACTOR_CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FACTOR'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-JOB-PARM.                                          *        
      ******************************************************************        
       7400-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME               
                 AND G6.CMND_CODE      = :G6-CMND-CODE                  
                 AND G6.COMPANY_NO     = :G6-COMPANY-NO                 
                 AND G6.SEQ_NO         = :G6-SEQ-NO                     
                 AND G6.STATUS         = 'A'                            
                                                                 
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME   = :G6-PROGRAM-NAME                       
MFA-TR*          AND G6.CMND_CODE      = :G6-CMND-CODE                          
MFA-TR*          AND G6.COMPANY_NO     = :G6-COMPANY-NO                         
MFA-TR*          AND G6.SEQ_NO         = :G6-SEQ-NO                             
MFA-TR*          AND G6.STATUS         = 'A'                                    
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7400                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_JOB_PARM'          TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE WS-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-MAX-SEQ-NO.                                           *        
      ******************************************************************        
       7500-GET-MAX-SEQ-NO.                                             
                                                                        
           EXEC SQL                                                     
               SELECT MAX(FIXED_FCTR_SEQ_NO)                            
A04880           INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-03              
                 FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO  = :FF-ACCOUNT-NO                      
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FIXED_FCTR_SEQ_NO)                                    
MFA-TR*          INTO :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND-03                      
MFA-TR*          FROM CSS_FIXED_FCTR                                            
MFA-TR*         WHERE ACCOUNT_NO  = :FF-ACCOUNT-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A04880     IF WS-NULL-IND-03 < 0                                        
A04880        MOVE +0000                 TO FF-FIXED-FCTR-SEQ-NO        
A04880     END-IF.                                                      
                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE FF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7600-CHECK-ACCT-ATTR                                           *        
      ******************************************************************        
       7600-CHECK-ACCT-ATTR.                                            
                                                                        
           EXEC SQL                                                     
               SELECT ATTRIBUTE_VALUE_CD                                
                     ,ATTRIBUTE_VALUE_DT                                
                     ,STATUS_CD                                         
                     ,'Y'                                               
                 INTO :YP-ATTRIBUTE-VALUE-CD                            
                     ,:YP-ATTRIBUTE-VALUE-DT                            
                     ,:YP-STATUS-CD                                     
                     ,:WS-ACCT-ATTR-FOUND                               
                 FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
                  AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,STATUS_CD                                                 
MFA-TR*              ,'Y'                                                       
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-DT                                    
MFA-TR*              ,:YP-STATUS-CD                                             
MFA-TR*              ,:WS-ACCT-ATTR-FOUND                                       
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7600                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'ATTRIBUTE_DESC'        TO TABLE-ELEMENT-2          
               MOVE YP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE YP-ATTRIBUTE-DESC       TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7620-SEL-MKT-EFF-DT.                                           *        
      ******************************************************************        
       7620-SEL-MKT-EFF-DT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) IG.MKT_TIER_START_DT,
              IG.MKT_TIER_DESC,
              IG.CUST_ACCT_DEFLT_FL                             
                 INTO :IG-MKT-TIER-START-DT :WS-NULL-IND-01              
                     ,:IG-MKT-TIER-DESC                                 
                     ,:IG-CUST-ACCT-DEFLT-FL                            
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
                ORDER BY IG.MKT_TIER_START_DT DESC                      
                                             
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_START_DT                                      
MFA-TR*              ,IG.MKT_TIER_DESC                                          
MFA-TR*              ,IG.CUST_ACCT_DEFLT_FL                                     
MFA-TR*          INTO :IG-MKT-TIER-START-DT:WS-NULL-IND-01                      
MFA-TR*              ,:IG-MKT-TIER-DESC                                         
MFA-TR*              ,:IG-CUST-ACCT-DEFLT-FL                                    
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*         ORDER BY IG.MKT_TIER_START_DT DESC                              
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7620                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7620'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER'          TO TABLE-1                  
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-1          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-2          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-3          
               MOVE IG-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-1        
               MOVE IG-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE IG-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7630-SEL-MKT-TIER-DET.                                         *        
      ******************************************************************        
       7630-SEL-MKT-TIER-DET.                                           
                                                                        
           EXEC SQL                                                     
               SELECT DD.TIER_CUST_STAT_CD                              
                     ,DD.TIER_ACCT_TYPE_CD                              
                     ,DD.MKT_TIER_RANKING                               
                     ,DD.MKT_TIER_START_DT                              
                     ,DD.COMPANY_NO                                     
                     ,DD.TIER_SOURCE_CD                                 
                     ,DD.ADJ_TIER_SEQ_NO                                
                     ,DD.EFF_START_DT                                   
                 INTO :DD-TIER-CUST-STAT-CD                             
                     ,:DD-TIER-ACCT-TYPE-CD                             
                     ,:DD-MKT-TIER-RANKING                              
                     ,:DD-MKT-TIER-START-DT                             
                     ,:DD-COMPANY-NO                                    
                     ,:DD-TIER-SOURCE-CD                                
                     ,:DD-ADJ-TIER-SEQ-NO                               
                     ,:DD-EFF-START-DT                                  
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                  
                  AND DD.EFF_START_DT =                                 
                          ( SELECT MAX(DD1.EFF_START_DT)                
                              FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                
                             WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )    
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DD.TIER_CUST_STAT_CD                                      
MFA-TR*              ,DD.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,DD.MKT_TIER_RANKING                                       
MFA-TR*              ,DD.MKT_TIER_START_DT                                      
MFA-TR*              ,DD.COMPANY_NO                                             
MFA-TR*              ,DD.TIER_SOURCE_CD                                         
MFA-TR*              ,DD.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,DD.EFF_START_DT                                           
MFA-TR*          INTO :DD-TIER-CUST-STAT-CD                                     
MFA-TR*              ,:DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:DD-MKT-TIER-RANKING                                      
MFA-TR*              ,:DD-MKT-TIER-START-DT                                     
MFA-TR*              ,:DD-COMPANY-NO                                            
MFA-TR*              ,:DD-TIER-SOURCE-CD                                        
MFA-TR*              ,:DD-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:DD-EFF-START-DT                                          
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*         WHERE DD.ACCOUNT_NO   = :DD-ACCOUNT-NO                          
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                   ( SELECT MAX(DD1.EFF_START_DT)                        
MFA-TR*                       FROM CSS_ACCT_MKT_TIER DD1                        
MFA-TR*                      WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7630                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y'                      TO WS-MKT-TIER-FOUND     
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7630'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'EFF_START_DT'          TO TABLE-ELEMENT-2          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-EFF-START-DT         TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SEL-CODE-VALUE-DESC                                       *        
      ******************************************************************        
       7700-SEL-CODE-VALUE-DESC.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_SHORT_DESC                                    
               INTO :UV-CODE-SHORT-DESC                                 
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE CODE_VALUE     = :UV-CODE-VALUE                     
                AND COLUMN_NA      = :UV-COLUMN-NA                      
                AND COMPANY_NO     = :UV-COMPANY-NO                     
                AND PROGRAM_ID     = :UV-PROGRAM-ID                     
                AND TABLE_NA       = :UV-TABLE-NA                       
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_SHORT_DESC                                            
MFA-TR*        INTO :UV-CODE-SHORT-DESC                                         
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE CODE_VALUE     = :UV-CODE-VALUE                             
MFA-TR*         AND COLUMN_NA      = :UV-COLUMN-NA                              
MFA-TR*         AND COMPANY_NO     = :UV-COMPANY-NO                             
MFA-TR*         AND PROGRAM_ID     = :UV-PROGRAM-ID                             
MFA-TR*         AND TABLE_NA       = :UV-TABLE-NA                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CODE_VALUE'         TO TABLE-1                  
              MOVE 'CODE_VALUE'             TO TABLE-ELEMENT-1          
              MOVE WS-CODE-VALUE            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7800-SELECT-RESP-AREA                                         *         
      *     SELECTS CSS_USER_PROFILE                                  *         
      *****************************************************************         
       7800-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID  = :WS-USER-ID                             
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID  = :WS-USER-ID                                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-1      
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7810-SEL-TIER-ADJ-SEQ-NO.                                      *        
      ******************************************************************        
       7810-SEL-TIER-ADJ-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) [1B].ADJ_TIER_SEQ_NO,
              [1B].TIER_ADJ_DESC                                  
                 INTO :1B-ADJ-TIER-SEQ-NO                               
                     ,:1B-TIER-ADJ-DESC                                 
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
                     ,CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
                WHERE DD.ACCOUNT_NO        = :DD-ACCOUNT-NO             
                  AND [1B].ADJ_TIER_RANKING  = :1B-ADJ-TIER-RANKING       
                  AND [1B].DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL       
                  AND DD.TIER_CUST_STAT_CD = [1B].TIER_CUST_STAT_CD       
                  AND DD.TIER_ACCT_TYPE_CD = [1B].TIER_ACCT_TYPE_CD       
                  AND DD.MKT_TIER_RANKING  = [1B].MKT_TIER_RANKING        
                  AND DD.MKT_TIER_START_DT = [1B].MKT_TIER_START_DT       
                  AND DD.COMPANY_NO        = [1B].COMPANY_NO              
                  AND [1B].DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL       
P00172            AND [1B].APPLICATION_CD    <> 'RT'                      
P00172            AND [1B].ADJ_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
P00172            AND [1B].ADJ_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
                  AND DD.EFF_START_DT =                                 
                          ( SELECT MAX(DD1.EFF_START_DT)                
                              FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                
                             WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )    
P00172                                       
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*              ,CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE DD.ACCOUNT_NO        = :DD-ACCOUNT-NO                     
MFA-TR*           AND 1B.ADJ_TIER_RANKING  = :1B-ADJ-TIER-RANKING               
MFA-TR*           AND 1B.DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL               
MFA-TR*           AND DD.TIER_CUST_STAT_CD = 1B.TIER_CUST_STAT_CD               
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD = 1B.TIER_ACCT_TYPE_CD               
MFA-TR*           AND DD.MKT_TIER_RANKING  = 1B.MKT_TIER_RANKING                
MFA-TR*           AND DD.MKT_TIER_START_DT = 1B.MKT_TIER_START_DT               
MFA-TR*           AND DD.COMPANY_NO        = 1B.COMPANY_NO                      
MFA-TR*           AND 1B.DHR_QUALIFIED_FL  = :1B-DHR-QUALIFIED-FL               
MFA-TR*           AND 1B.APPLICATION_CD    <> 'RT'                              
MFA-TR*           AND 1B.ADJ_START_DT      <= :WS-CURRENT-DATE                  
MFA-TR*           AND 1B.ADJ_END_DT        >= :WS-CURRENT-DATE                  
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                   ( SELECT MAX(DD1.EFF_START_DT)                        
MFA-TR*                       FROM CSS_ACCT_MKT_TIER DD1                        
MFA-TR*                      WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7810                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7810'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_RANKING'          TO TABLE-ELEMENT-2          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 1B-ADJ-TIER-RANKING     TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7820-SEL-MKT-TIER-DESC.                                        *        
      ******************************************************************        
       7820-SEL-MKT-TIER-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT IG.MKT_TIER_DESC                                  
                 INTO :IG-MKT-TIER-DESC                                 
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD     
                  AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD     
                  AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING      
                  AND IG.MKT_TIER_START_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :IG-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :IG-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:IG-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:IG-MKT-TIER-START-DT
              ), CONVERT(DATE, :IG-MKT-TIER-START-DT) )     
                  AND IG.COMPANY_NO         = :IG-COMPANY-NO            
A03303                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.MKT_TIER_DESC                                          
MFA-TR*          INTO :IG-MKT-TIER-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.TIER_CUST_STAT_CD  = :IG-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :IG-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.MKT_TIER_RANKING   = :IG-MKT-TIER-RANKING              
MFA-TR*           AND IG.MKT_TIER_START_DT  = :IG-MKT-TIER-START-DT             
MFA-TR*           AND IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7820                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7820'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER'          TO TABLE-1                  
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-1          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-2          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_START_DT'     TO TABLE-ELEMENT-4          
               MOVE IG-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-1        
               MOVE IG-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE IG-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-3        
               MOVE IG-MKT-TIER-START-DT    TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7830-SEL-TIER-ADJ-DESC.                                        *        
      ******************************************************************        
       7830-SEL-TIER-ADJ-DESC.                                          
                                                                        
           EXEC SQL                                                     
               SELECT [1B].TIER_ADJ_DESC                                  
                 INTO :1B-TIER-ADJ-DESC                                 
                 FROM CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
                WHERE [1B].ADJ_TIER_SEQ_NO = :1B-ADJ-TIER-SEQ-NO          
                                                                 
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE 1B.ADJ_TIER_SEQ_NO = :1B-ADJ-TIER-SEQ-NO                  
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7830                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7830'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CRM_MKT_TIER_ADJ'      TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'ADJ_TIER_SEQ_NO'       TO TABLE-ELEMENT-2          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 1B-ADJ-TIER-SEQ-NO      TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7840-SEL-DHR-HIST.                                             *        
      ******************************************************************        
       7840-SEL-DHR-HIST.                                               
                                                                        
           EXEC SQL                                                     
P00172          SELECT CU.DHR_FL                                        
                  INTO :WS-DHR-CUSTOMER                                 
P00172            FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED)                    
P00172           WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                
P00172                                                           
A03303                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CU.DHR_FL                                                
MFA-TR*           INTO :WS-DHR-CUSTOMER                                         
MFA-TR*           FROM CSS_CUSTOMER CU                                          
MFA-TR*          WHERE CU.CUSTOMER_NO  = :CU-CUSTOMER-NO                        
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7840                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7840'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
P00172         MOVE 'CSS_CUSTOMER'          TO TABLE-1                  
P00172         MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
P00172         MOVE CU-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7840-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00113******************************************************************        
I00113*                                                                *        
I00113* 7860-SEL-TIER-ADJ-SEQ-NO-SR.                                   *        
I00113******************************************************************        
I00113 7860-SEL-TIER-ADJ-SEQ-NO-SR.                                     
I00113                                                                  
I00113     EXEC SQL                                                     
I00113         SELECT TOP(1) [1B].ADJ_TIER_SEQ_NO,
              [1B].TIER_ADJ_DESC                                  
I00113           INTO :1B-ADJ-TIER-SEQ-NO                               
I00113               ,:1B-TIER-ADJ-DESC                                 
I00113           FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)                
I00113               ,CRM_MKT_TIER_ADJ [1B] WITH(READUNCOMMITTED)               
I00113          WHERE DD.ACCOUNT_NO         = :DD-ACCOUNT-NO            
I00113            AND [1B].ADJ_TIER_RANKING   = :1B-ADJ-TIER-RANKING      
I00113            AND [1B].DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL      
I00113            AND DD.TIER_CUST_STAT_CD  = [1B].TIER_CUST_STAT_CD      
I00113            AND DD.TIER_ACCT_TYPE_CD  = [1B].TIER_ACCT_TYPE_CD      
I00113            AND DD.MKT_TIER_RANKING   = [1B].MKT_TIER_RANKING       
I00113            AND DD.MKT_TIER_START_DT  = [1B].MKT_TIER_START_DT      
I00113            AND DD.COMPANY_NO         = [1B].COMPANY_NO             
I00113            AND [1B].DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL      
I00113            AND [1B].AGL_LOW_INCM_SR_FL = :1B-AGL-LOW-INCM-SR-FL    
P00172            AND [1B].ADJ_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
P00172            AND [1B].ADJ_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )          
I00113            AND DD.EFF_START_DT =                                 
I00113                    ( SELECT MAX(DD1.EFF_START_DT)                
I00113                        FROM CSS_ACCT_MKT_TIER DD1
                           WITH(READUNCOMMITTED)                
I00113                       WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )    
P00172                                       
A03303                                                      
I00113     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1B.ADJ_TIER_SEQ_NO                                        
MFA-TR*              ,1B.TIER_ADJ_DESC                                          
MFA-TR*          INTO :1B-ADJ-TIER-SEQ-NO                                       
MFA-TR*              ,:1B-TIER-ADJ-DESC                                         
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD                                      
MFA-TR*              ,CRM_MKT_TIER_ADJ 1B                                       
MFA-TR*         WHERE DD.ACCOUNT_NO         = :DD-ACCOUNT-NO                    
MFA-TR*           AND 1B.ADJ_TIER_RANKING   = :1B-ADJ-TIER-RANKING              
MFA-TR*           AND 1B.DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL              
MFA-TR*           AND DD.TIER_CUST_STAT_CD  = 1B.TIER_CUST_STAT_CD              
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD  = 1B.TIER_ACCT_TYPE_CD              
MFA-TR*           AND DD.MKT_TIER_RANKING   = 1B.MKT_TIER_RANKING               
MFA-TR*           AND DD.MKT_TIER_START_DT  = 1B.MKT_TIER_START_DT              
MFA-TR*           AND DD.COMPANY_NO         = 1B.COMPANY_NO                     
MFA-TR*           AND 1B.DHR_QUALIFIED_FL   = :1B-DHR-QUALIFIED-FL              
MFA-TR*           AND 1B.AGL_LOW_INCM_SR_FL = :1B-AGL-LOW-INCM-SR-FL            
MFA-TR*           AND 1B.ADJ_START_DT      <= :WS-CURRENT-DATE                  
MFA-TR*           AND 1B.ADJ_END_DT        >= :WS-CURRENT-DATE                  
MFA-TR*           AND DD.EFF_START_DT =                                         
MFA-TR*                   ( SELECT MAX(DD1.EFF_START_DT)                        
MFA-TR*                       FROM CSS_ACCT_MKT_TIER DD1                        
MFA-TR*                      WHERE DD1.ACCOUNT_NO = :DD-ACCOUNT-NO )            
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7860                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00113                                                                  
I00113     MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
I00113                                                                  
I00113     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I00113         NEXT SENTENCE                                            
I00113     ELSE                                                         
I00113         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
I00113         MOVE '7860'                  TO ACTIVE-PARAGRAPH         
I00113         MOVE 'SELECT'                TO ABEND-FUNCTION           
I00113         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
I00113                                         ABEND-TABLES             
I00113         MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
I00113         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
I00113         MOVE 'TIER_RANKING'          TO TABLE-ELEMENT-2          
I00113         MOVE 'AGL_LOW_INCM_SR_FL'    TO TABLE-ELEMENT-3          
I00113         MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
I00113         MOVE 1B-ADJ-TIER-RANKING     TO HOSTVAR-ELEMENT-2        
I00113         MOVE 1B-AGL-LOW-INCM-SR-FL   TO HOSTVAR-ELEMENT-3        
I00113         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
I00113         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
I00113     END-IF.                                                      
I00113                                                                  
I00113 7860-EXIT.                                                       
I00113     EXIT.                                                        
A04880******************************************************************        
A04880*                                                                *        
A04880* 7900-SEL-REG-GROUP.                                            *        
A04880******************************************************************        
A04880 7900-SEL-REG-GROUP.                                              
A04880                                                                  
A04880     EXEC SQL                                                     
A04880          SELECT LR.REG_GROUP_CD                                  
A04880            INTO :LR-REG-GROUP-CD                                 
A04880            FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                 
A04880           WHERE ACCOUNT_NO     = :LR-ACCOUNT-NO                  
A04880                                                           
A04880                                                      
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LR.REG_GROUP_CD                                          
MFA-TR*           INTO :LR-REG-GROUP-CD                                         
MFA-TR*           FROM CSS_REG_PROFILE LR                                       
MFA-TR*          WHERE ACCOUNT_NO     = :LR-ACCOUNT-NO                          
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7900                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04880                                                                  
A04880     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04880                                                                  
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04880         NEXT SENTENCE                                            
A04880     ELSE                                                         
A04880         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A04880         MOVE '7900'                  TO ACTIVE-PARAGRAPH         
A04880         MOVE 'SELECT'                TO ABEND-FUNCTION           
A04880         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
A04880                                         ABEND-TABLES             
A04880         MOVE 'CSS_REG_PROFILE'       TO TABLE-1                  
A04880         MOVE 'ACCOUNT_NO '           TO TABLE-ELEMENT-1          
A04880         MOVE LR-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
A04880         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A04880         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A04880     END-IF.                                                      
A04880                                                                  
A04880 7900-EXIT.                                                       
A04880     EXIT.                                                        
A04880                                                                  
                                                                        
      ******************************************************************        
      * 8000-INSERT-MKT-TIER                                           *        
      *       THIS MODULE INSERTS A NEW ROW  INTO THE TABLE            *        
      *       CSS_ACCT_MKT_TIER                                        *        
      ******************************************************************        
       8000-INSERT-MKT-TIER.                                            
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_MKT_TIER                            
                    ( ACCOUNT_NO                                        
                     ,TIER_CUST_STAT_CD                                 
                     ,TIER_ACCT_TYPE_CD                                 
                     ,MKT_TIER_RANKING                                  
                     ,MKT_TIER_START_DT                                 
                     ,COMPANY_NO                                        
                     ,CREATED_TS                                        
                     ,LAST_UPDATE_USERID                                
                     ,EFF_START_DT                                      
                     ,LAST_UPDATE_TS                                    
                     ,LAST_EVALUATED_DT                                 
                     ,TIER_SOURCE_CD                                    
                     ,ADJ_TIER_SEQ_NO)                                  
               VALUES                                                   
                    (:DD-ACCOUNT-NO                                     
                    ,:DD-TIER-CUST-STAT-CD                              
                    ,:DD-TIER-ACCT-TYPE-CD                              
                    ,:DD-MKT-TIER-RANKING                               
                    ,IIF(TRY_CONVERT(DATE, :DD-MKT-TIER-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-MKT-TIER-START-DT
              ) <> 0) OR (LEN(:DD-MKT-TIER-START-DT
              ) <> 10), CIS.CHAR2DATE(:DD-MKT-TIER-START-DT
              ), CONVERT(DATE, :DD-MKT-TIER-START-DT) )                        
                    ,:DD-COMPANY-NO                                     
                    ,CIS.CHAR2TIMESTAMP(:DD-CREATED-TS)                         
                    ,:DD-LAST-UPDATE-USERID                             
                    ,IIF(TRY_CONVERT(DATE, :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )                             
                    ,CIS.CHAR2TIMESTAMP(:DD-LAST-UPDATE-TS)                     
                    ,IIF(TRY_CONVERT(DATE, :DD-LAST-EVALUATED-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-LAST-EVALUATED-DT
              ) <> 0) OR (LEN(:DD-LAST-EVALUATED-DT
              ) <> 10), CIS.CHAR2DATE(:DD-LAST-EVALUATED-DT
              ), CONVERT(DATE, :DD-LAST-EVALUATED-DT) )                        
                    ,:DD-TIER-SOURCE-CD                                 
                    ,:DD-ADJ-TIER-SEQ-NO)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_MKT_TIER                                    
MFA-TR*             ( ACCOUNT_NO                                                
MFA-TR*              ,TIER_CUST_STAT_CD                                         
MFA-TR*              ,TIER_ACCT_TYPE_CD                                         
MFA-TR*              ,MKT_TIER_RANKING                                          
MFA-TR*              ,MKT_TIER_START_DT                                         
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,EFF_START_DT                                              
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_EVALUATED_DT                                         
MFA-TR*              ,TIER_SOURCE_CD                                            
MFA-TR*              ,ADJ_TIER_SEQ_NO)                                          
MFA-TR*        VALUES                                                           
MFA-TR*             (:DD-ACCOUNT-NO                                             
MFA-TR*             ,:DD-TIER-CUST-STAT-CD                                      
MFA-TR*             ,:DD-TIER-ACCT-TYPE-CD                                      
MFA-TR*             ,:DD-MKT-TIER-RANKING                                       
MFA-TR*             ,:DD-MKT-TIER-START-DT                                      
MFA-TR*             ,:DD-COMPANY-NO                                             
MFA-TR*             ,:DD-CREATED-TS                                             
MFA-TR*             ,:DD-LAST-UPDATE-USERID                                     
MFA-TR*             ,:DD-EFF-START-DT                                           
MFA-TR*             ,:DD-LAST-UPDATE-TS                                         
MFA-TR*             ,:DD-LAST-EVALUATED-DT                                      
MFA-TR*             ,:DD-TIER-SOURCE-CD                                         
MFA-TR*             ,:DD-ADJ-TIER-SEQ-NO)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '8000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-2          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-4          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-2        
               MOVE DD-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-3        
               MOVE DD-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-INSERT-FIXED-FACTOR                                       *        
      ******************************************************************        
       8100-INSERT-FIXED-FACTOR.                                        
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_FIXED_FCTR                               
                     ( ACCOUNT_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,FIXED_FCTR_SEQ_NO                                
                      ,FACTOR_ID                                        
                      ,EFF_DATE_FROM                                    
                      ,CMPNT_ID_CD                                      
                      ,CODE_SEASON                                      
                      ,INSTR_USE_TYPE_CD                                
                      ,CODE_TIME_PERIOD                                 
                      ,EFF_DATE_TO                                      
                      ,FIXED_FCTR_TYP_CD                                
                      ,FACTOR                                           
                      ,FAC_CHRG_BASE_AM                                 
                      ,LAST_UPDATE_TS                                   
                      ,DURATION_REMAIN_NO                               
                      ,RT_PKG_OPT_SEQ_NO)                               
               VALUES                                                   
                     (:FF-ACCOUNT-NO                                    
                     ,:FF-CODE-UTIL-TYPE                                
                     ,:FF-IC-NO                                         
                     ,:FF-FIXED-FCTR-SEQ-NO                             
                     ,:FF-FACTOR-ID                                     
                     ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
                     ,:FF-CMPNT-ID-CD                                   
                     ,:FF-CODE-SEASON                                   
                     ,:FF-INSTR-USE-TYPE-CD                             
                     ,:FF-CODE-TIME-PERIOD                              
                     ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
                     ,:FF-FIXED-FCTR-TYP-CD                             
                     ,:FF-FACTOR                                        
                     ,:FF-FAC-CHRG-BASE-AM                              
                     ,CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS)                    
                     ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-02             
                     ,:FF-RT-PKG-OPT-SEQ-NO)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCTR                                       
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,FIXED_FCTR_SEQ_NO                                        
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,EFF_DATE_FROM                                            
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,CODE_SEASON                                              
MFA-TR*               ,INSTR_USE_TYPE_CD                                        
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,EFF_DATE_TO                                              
MFA-TR*               ,FIXED_FCTR_TYP_CD                                        
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,FAC_CHRG_BASE_AM                                         
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,DURATION_REMAIN_NO                                       
MFA-TR*               ,RT_PKG_OPT_SEQ_NO)                                       
MFA-TR*        VALUES                                                           
MFA-TR*              (:FF-ACCOUNT-NO                                            
MFA-TR*              ,:FF-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FF-IC-NO                                                 
MFA-TR*              ,:FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*              ,:FF-FACTOR-ID                                             
MFA-TR*              ,:FF-EFF-DATE-FROM                                         
MFA-TR*              ,:FF-CMPNT-ID-CD                                           
MFA-TR*              ,:FF-CODE-SEASON                                           
MFA-TR*              ,:FF-INSTR-USE-TYPE-CD                                     
MFA-TR*              ,:FF-CODE-TIME-PERIOD                                      
MFA-TR*              ,:FF-EFF-DATE-TO                                           
MFA-TR*              ,:FF-FIXED-FCTR-TYP-CD                                     
MFA-TR*              ,:FF-FACTOR                                                
MFA-TR*              ,:FF-FAC-CHRG-BASE-AM                                      
MFA-TR*              ,:FF-LAST-UPDATE-TS                                        
MFA-TR*              ,:FF-DURATION-REMAIN-NO:WS-NULL-IND-02                     
MFA-TR*              ,:FF-RT-PKG-OPT-SEQ-NO)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT-ROW'            TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_FIXED_FCTR'       TO TABLE-1                   
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-4          
               MOVE FF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE FF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE FF-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE FF-FACTOR-ID            TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8200-INSERT-ACCT-ATTR                                          *        
      ******************************************************************        
       8200-INSERT-ACCT-ATTR.                                           
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_ACCT_ATTRIBUTE                           
                     (ACCOUNT_NO                                        
                      ,ATTRIBUTE_DESC                                   
                      ,ATTRIBUTE_VALUE_CD                               
                      ,ATTRIBUTE_VALUE_DT                               
                      ,STATUS_CD                                        
                      ,CREATED_TS)                                      
               VALUES                                                   
                      (:YP-ACCOUNT-NO                                   
                      ,:YP-ATTRIBUTE-DESC                               
                      ,:YP-ATTRIBUTE-VALUE-CD                           
                      ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                      ,:YP-STATUS-CD                                    
                      ,CIS.CHAR2TIMESTAMP(:YP-CREATED-TS))                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*               ,ATTRIBUTE_DESC                                           
MFA-TR*               ,ATTRIBUTE_VALUE_CD                                       
MFA-TR*               ,ATTRIBUTE_VALUE_DT                                       
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,CREATED_TS)                                              
MFA-TR*        VALUES                                                           
MFA-TR*               (:YP-ACCOUNT-NO                                           
MFA-TR*               ,:YP-ATTRIBUTE-DESC                                       
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-CD                                   
MFA-TR*               ,:YP-ATTRIBUTE-VALUE-DT                                   
MFA-TR*               ,:YP-STATUS-CD                                            
MFA-TR*               ,:YP-CREATED-TS)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE YP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'ATTRIBUTE_DESC'        TO TABLE-ELEMENT-2          
               MOVE YP-ATTRIBUTE-DESC       TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 8300-UPDATE-ACCT-ATTR                                          *        
      ******************************************************************        
       8300-UPDATE-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCT_ATTRIBUTE                                
                     SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD    
                        ,ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                 :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )    
                        ,STATUS_CD          = :YP-STATUS-CD             
                   WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO            
                     AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCT_ATTRIBUTE                                        
MFA-TR*              SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD            
MFA-TR*                 ,ATTRIBUTE_VALUE_DT = :YP-ATTRIBUTE-VALUE-DT            
MFA-TR*                 ,STATUS_CD          = :YP-STATUS-CD                     
MFA-TR*            WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                    
MFA-TR*              AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE YP-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE 'ATTRIBUTE_DESC'        TO TABLE-ELEMENT-2          
               MOVE YP-ATTRIBUTE-DESC       TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 8410-DEL-MKT-TIER.                                             *        
      ******************************************************************        
       8410-DEL-MKT-TIER.                                               
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_MKT_TIER                            
                WHERE ACCOUNT_NO         = :DD-ACCOUNT-NO               
                  AND TIER_CUST_STAT_CD  = :DD-TIER-CUST-STAT-CD        
                  AND TIER_ACCT_TYPE_CD  = :DD-TIER-ACCT-TYPE-CD        
                  AND MKT_TIER_RANKING   = :DD-MKT-TIER-RANKING         
P00738            AND EFF_START_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :DD-EFF-START-DT
              ) IS NULL OR (PATINDEX('%.%', :DD-EFF-START-DT
              ) <> 0) OR (LEN(:DD-EFF-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :DD-EFF-START-DT
              ), CONVERT(DATE, :DD-EFF-START-DT) )             
                  AND COMPANY_NO         = :DD-COMPANY-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_MKT_TIER                                    
MFA-TR*         WHERE ACCOUNT_NO         = :DD-ACCOUNT-NO                       
MFA-TR*           AND TIER_CUST_STAT_CD  = :DD-TIER-CUST-STAT-CD                
MFA-TR*           AND TIER_ACCT_TYPE_CD  = :DD-TIER-ACCT-TYPE-CD                
MFA-TR*           AND MKT_TIER_RANKING   = :DD-MKT-TIER-RANKING                 
MFA-TR*           AND EFF_START_DT       = :DD-EFF-START-DT                     
MFA-TR*           AND COMPANY_NO         = :DD-COMPANY-NO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8410'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCT_MKT_TIER'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'TIER_CUST_STAT_CD'     TO TABLE-ELEMENT-2          
               MOVE 'TIER_ACCT_TYPE_CD'     TO TABLE-ELEMENT-3          
               MOVE 'MKT_TIER_RANKING'      TO TABLE-ELEMENT-4          
               MOVE DD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE DD-TIER-CUST-STAT-CD    TO HOSTVAR-ELEMENT-2        
               MOVE DD-TIER-ACCT-TYPE-CD    TO HOSTVAR-ELEMENT-3        
               MOVE DD-MKT-TIER-RANKING     TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8420-DEL-FF-FCTR.                                              *        
      ******************************************************************        
       8420-DEL-FF-FCTR.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_FIXED_FCTR                               
                WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE            
                  AND IC_NO             = :FF-IC-NO                     
                  AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO         
                  AND FACTOR_ID         = :FF-FACTOR-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8420'                  TO ACTIVE-PARAGRAPH         
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'FIXED_FCTR_SEQ_NO'     TO TABLE-ELEMENT-4          
               MOVE FF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE FF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE FF-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE FF-FIXED-FCTR-SEQ-NO    TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8410-UPD-FF-FCTR.                                              *        
      ******************************************************************        
       8430-UPD-FF-FCTR.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_FIXED_FCTR                                    
                  SET EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )               
                WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                
                  AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE            
                  AND IC_NO             = :FF-IC-NO                     
                  AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_FIXED_FCTR                                            
MFA-TR*           SET EFF_DATE_TO       = :FF-EFF-DATE-TO                       
MFA-TR*         WHERE ACCOUNT_NO        = :FF-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = :FF-CODE-UTIL-TYPE                    
MFA-TR*           AND IC_NO             = :FF-IC-NO                             
MFA-TR*           AND FIXED_FCTR_SEQ_NO = :FF-FIXED-FCTR-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8430'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-2          
               MOVE 'IC_NO'                 TO TABLE-ELEMENT-3          
               MOVE 'FIXED_FCTR_SEQ_NO'     TO TABLE-ELEMENT-4          
               MOVE FF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE FF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2        
               MOVE FF-IC-NO                TO HOSTVAR-ELEMENT-3        
               MOVE FF-FIXED-FCTR-SEQ-NO    TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8440-UPD-SENIOR-FLAG.                                          *        
      ******************************************************************        
       8440-UPD-SENIOR-FLAG.                                            
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_REG_PROFILE                                   
                  SET SENIOR_FL      = :LR-SENIOR-FL                    
                     ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                
                WHERE ACCOUNT_NO     = :LR-ACCOUNT-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REG_PROFILE                                           
MFA-TR*           SET SENIOR_FL      = :LR-SENIOR-FL                            
MFA-TR*              ,LAST_UPDATE_TS = CURRENT TIMESTAMP                        
MFA-TR*         WHERE ACCOUNT_NO     = :LR-ACCOUNT-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '8440'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE 'CSS_REG_PROFILE'       TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE LR-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8440-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04880******************************************************************        
A04880*                                                                *        
A04880* 8450-UPD-REG-GROUP-CD.                                         *        
A04880******************************************************************        
A04880 8450-UPD-REG-GROUP-CD.                                           
A04880                                                                  
A04880     EXEC SQL                                                     
A04880         UPDATE CSS_REG_PROFILE                                   
A04880            SET REG_GROUP_CD   = :WS-REG-GROUP-CD                 
A04880               ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                
A04880          WHERE ACCOUNT_NO     = :LR-ACCOUNT-NO                   
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REG_PROFILE                                           
MFA-TR*           SET REG_GROUP_CD   = :WS-REG-GROUP-CD                         
MFA-TR*              ,LAST_UPDATE_TS = CURRENT TIMESTAMP                        
MFA-TR*         WHERE ACCOUNT_NO     = :LR-ACCOUNT-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04880                                                                  
A04880     MOVE SQLCODE         TO WS-ACTIVE-RETURN-CODE.               
A04880                                                                  
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04880         NEXT SENTENCE                                            
A04880     ELSE                                                         
A04880         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
A04880         MOVE '8450'                  TO ACTIVE-PARAGRAPH         
A04880         MOVE 'UPDATE'                TO ABEND-FUNCTION           
A04880         MOVE 'CSS_REG_PROFILE'       TO TABLE-1                  
A04880         MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
A04880         MOVE LR-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
A04880         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A04880         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A04880     END-IF.                                                      
A04880                                                                  
A04880 8450-EXIT.                                                       
A04880     EXIT.                                                        
A04880                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 8990-SEND-RESULT.                                              *        
      ******************************************************************        
       8990-SEND-RESULT.                                                
             ADD 1                           TO CTR-ROWS.               
                                                                        
       8990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * TRANS HIST COPYBOOK.                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
