       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04093.                                            
       DATE-WRITTEN. 02/11/08.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE GETS ALL THE SERVICE LINE DATA FOR A PREMISE.  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/11/08  MA96833  PROCEDURE ORIGINALLY CODED.              *          
A04501*  01/30/13  FMB      ADDED CSS_BLDR_NAME_TMP TABLE.           *          
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04093'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-FLG-OPT                        PIC X(1).                  
       01  WS-FLG-TB                         PIC X(2).                  
COB305 01 WS-CUST-NO        PIC S9(10)V COMP-3 VALUE 0.        
COB305 01 WS-ADDRS-ID        PIC S9(13)V COMP-3 VALUE 0.        
COB305 01 WS-ADDR-ID        PIC S9(13)V COMP-3 VALUE 0.        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                     00980000
              INCLUDE TBADDRID                                          00990000
           END-EXEC.                                                    01000000
           EXEC SQL                                                     01451000
              INCLUDE TBUSRPRF                                          01440000
           END-EXEC.                                                    01450000
           EXEC SQL                                                             
              INCLUDE TBBLDADX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     01151000
              INCLUDE TBMNHIST                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01180000
              INCLUDE TBMNHDT                                           01190000
           END-EXEC.                                                    01200000
A04501     EXEC SQL                                                     01180000
A04501        INCLUDE TBCUST                                            01190000
A04501     END-EXEC.                                                    01200000
A04501     EXEC SQL                                                     01180000
A04501        INCLUDE TBNAME                                            01190000
A04501     END-EXEC.                                                    01200000
A04501     EXEC SQL                                                     01180000
A04501        INCLUDE TBBLDNAM                                          01190000
A04501     END-EXEC.                                                    01200000
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00011.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     01632000
              INCLUDE CWS00071                                          01635100
           END-EXEC.                                                    01634000
           EXEC SQL                                                     01636000
              INCLUDE CWS0090A                                          01637000
           END-EXEC.                                                    01638000
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR04093'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-ID1                     PIC S9(9) COMP VALUE 1.     
COB305     05 PARM-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10  RS-RETURN-CODE                PIC S9(9)      COMP.       
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X(1) VALUE 'Y'.         
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-MISC-FIELDS.                                              
           10  S-RETURN-CODE             PIC S9(9)      COMP.           
           10  PROGRAM-NAME              PIC X(08) VALUE 'CSR04093'.    
           10  WS-USER-ID                PIC X(07) VALUE SPACES.        
           05  WS-ADDRESS-ID-I           PIC S9(13)  USAGE COMP         
                                                     VALUE ZERO.        
           05  WS-ADDRESS-ID-S           PIC X(13)   VALUE SPACES.      
           05  WS-TRANS-HIST-SEQ-NO      PIC X(26)   VALUE SPACES.      
           05  WS-DATE-TRANS             PIC X(10)   VALUE SPACES.      
           05  WS-RESP-AREA-ID           PIC X(03)   VALUE SPACES.      
           05  WS-TRAN-APPL-NO-4093      PIC S9(4)   USAGE COMP.        
A04501     05  WS-BLDR-DELETE-FL         PIC X(01) VALUE 'N'.           
A04501     05  WS-FORMATTED-NAME         PIC X(100) VALUE SPACES.       
A04501     05  WS-CUSTOMER-NO-NUM        PIC 9(10).                     
A04501     05  WS-CUSTOMER-NO-CHAR       REDEFINES WS-CUSTOMER-NO-NUM   
A04501                                   PIC X(10).                     
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-FLG-OPT            PIC X(1).                             
       01 PARM-FLG-TB             PIC X(2).                             
       01 PARM-ADDR-STREET        PIC X(55).                            
COB305 01 PARM-CUST-NO        PIC S9(10)V COMP-3 VALUE 0.                  
COB305 01 PARM-ADDR-ID        PIC S9(13)V COMP-3 VALUE 0.                  
       01 PARM-ADDR-CITY-STATE    PIC X(30).                            
       01 PARM-ADDR-STREET-NAME   PIC X(30).                            
       01 PARM-ADDR-ZIP-CODE      PIC X(9).                             
       01 PARM-ZIP-CODE           PIC X(9).                             
       01 PARM-ADDR-COUNTRY       PIC X(35).                            
       01 PARM-ADDRESS-OVERFLOW   PIC X(35).                            
       01 PARM-CARRIER-ROUTE      PIC X(5).                             
       01 PARM-ADDR-STREET-2      PIC X(55).                            
       01 PARM-ADDR-HOUSE-NO      PIC X(15).                            
       01 PARM-ADDR-PREFIX-1      PIC X(3).                             
       01 PARM-ADDR-PREFIX-2      PIC X(2).                             
       01 PARM-ADDR-STREET-LOC-1  PIC X(4).                             
       01 PARM-ADDR-STREET-LOC-2  PIC X(11).                            
       01 PARM-STREET-SUFFIX      PIC X(4).                             
       01 PARM-ZIP-FOUR           PIC X(4).                             
       01 PARM-ADDR-SUFFIX        PIC X(2).                             
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-FLG-OPT,                                           
                PARM-FLG-TB,                                            
                PARM-ADDR-STREET,                                       
                PARM-CUST-NO,                                           
                PARM-ADDR-ID,                                           
                PARM-ADDR-CITY-STATE,                                   
                PARM-ADDR-STREET-NAME,                                  
                PARM-ADDR-ZIP-CODE,                                     
                PARM-ZIP-CODE,                                          
                PARM-ADDR-COUNTRY,                                      
                PARM-ADDRESS-OVERFLOW,                                  
                PARM-CARRIER-ROUTE,                                     
                PARM-ADDR-STREET-2,                                     
                PARM-ADDR-HOUSE-NO,                                     
                PARM-ADDR-PREFIX-1,                                     
                PARM-ADDR-PREFIX-2,                                     
                PARM-ADDR-STREET-LOC-1,                                 
                PARM-ADDR-STREET-LOC-2,                                 
                PARM-STREET-SUFFIX,                                     
                PARM-ZIP-FOUR,                                          
                PARM-ADDR-SUFFIX.                                       
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL SELECT
              LTRIM(RTRIM(CIS.SESSION$USER()))
            INTO
              :WS-USER-ID         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL VALUES (STRIP(CHAR(USER))) INTO :WS-USER-ID                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :RS-RETURN-CODE AS [RETURN-CODE]                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :RS-RETURN-CODE AS RETURN-CODE                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-FLG-OPT               TO WS-FLG-OPT.              
            MOVE PARM-FLG-TB                TO WS-FLG-TB.               
            MOVE PARM-CUST-NO               TO WS-CUST-NO               
A04501                                         WS-CUSTOMER-NO-NUM.      
            MOVE PARM-ADDR-ID               TO WS-ADDRS-ID.             
            MOVE PARM-ADDR-STREET           TO DZ-ADDR-STREET.          
            MOVE PARM-ADDR-STREET-NAME      TO DY-STREET-NAME.          
            MOVE PARM-ADDR-CITY-STATE       TO DZ-ADDR-CITY-STATE.      
            MOVE PARM-ZIP-CODE              TO DZ-ADDR-ZIP-CODE.        
            MOVE PARM-ADDR-ZIP-CODE(1:5)    TO DY-ZIP-CODE.             
            MOVE PARM-ADDR-ZIP-CODE(6:1)    TO DY-ZIP-CODE-TOKEN.       
            MOVE PARM-ADDR-COUNTRY          TO DZ-ADDR-COUNTRY.         
            MOVE PARM-ADDRESS-OVERFLOW      TO DZ-ADDRESS-OVERFLOW.     
            MOVE PARM-ADDRESS-OVERFLOW      TO DY-ADDRESS-OVERFLOW.     
            MOVE PARM-CARRIER-ROUTE         TO DZ-CARRIER-ROUTE.        
            MOVE PARM-CARRIER-ROUTE         TO DY-CARRIER-ROUTE.        
            MOVE PARM-ADDR-STREET-2         TO DZ-ADDR-STREET-2.        
            MOVE PARM-ADDR-HOUSE-NO         TO DY-HOUSE-NO.             
            MOVE PARM-ADDR-PREFIX-1         TO DY-ADDR-PREFIX-1.        
            MOVE PARM-ADDR-PREFIX-2         TO DY-ADDR-PREFIX-2.        
            MOVE PARM-ADDR-STREET-LOC-1     TO DY-STREET-LOCATION-1.    
            MOVE PARM-ADDR-STREET-LOC-2     TO DY-STREET-LOCATION-2.    
            MOVE PARM-STREET-SUFFIX         TO DY-STREET-SUFFIX.        
            MOVE PARM-ZIP-FOUR              TO DY-ZIP-CODE-PLUS-FOUR.   
            MOVE PARM-ADDR-SUFFIX           TO DY-ADDR-SUFFIX.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EXEC SQL                                                     
C32615        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANS-HIST-SEQ-NO                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     23140000
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-TRANS-HIST-SEQ-NO                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
C32615        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-DATE-TRANS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     23140000
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-DATE-TRANS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7040-SELECT-RESP-AREA-ID     THRU 7040-EXIT.         
A04501     PERFORM 7010-SELECT-CUSTOMER         THRU 7010-EXIT.         
A04501     STRING DQ-FULL-NAME                                          
A04501            '-'                                                   
A04501            WS-CUSTOMER-NO-CHAR                                   
A04501            DELIMITED BY SIZE                                     
A04501            INTO WS-EMB-INPUT.                                    
A04501     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
A04501     MOVE WS-CMP-TABLE TO WS-FORMATTED-NAME.                      
A04501     INSPECT WS-FORMATTED-NAME REPLACING ALL LOW-VALUES BY ' '.   
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO     TO MH-TRANS-HIST-SEQ-NO.       
           MOVE WS-DATE-TRANS            TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE WS-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROS                    TO MH-ACCOUNT-NO.              
           MOVE PARM-CUST-NO             TO MH-CUSTOMER-NO.             
           MOVE ZEROS                    TO MH-PREMISE-NO.              
           MOVE WS-USER-ID               TO MH-USER-ID.                 
           MOVE 'PANEL521'               TO MH-APPL-PROGRAM-ID.         
                                                                        
           IF WS-FLG-OPT = 'I'                                          
               MOVE 'PANEL521'             TO WS-90-PANEL-NO            
               MOVE WS-USER-ID             TO WS-90-USERID              
               MOVE 0                      TO WS-90-ACCOUNT-NO          
               MOVE PARM-CUST-NO           TO WS-90-CUSTOMER-NO         
               MOVE ZEROES                 TO WS-90-PREMISE-NO          
               PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT           
               MOVE WS-90-NEW-ADDRESS-ID   TO WS-ADDR-ID                
               IF WS-FLG-TB = 'FO'                                      
                   MOVE WS-ADDR-ID TO DY-ADDRESS-ID                     
                   PERFORM 8000-INSERT-ADDR-FMT THRU 8000-EXIT          
               ELSE                                                     
                   MOVE WS-ADDR-ID TO DZ-ADDRESS-ID                     
                   PERFORM 8200-INSERT-ADDR-FREE THRU 8200-EXIT         
               END-IF                                                   
               PERFORM 8300-INSERT-BLDR-ADDR-XREF THRU 8300-EXIT        
A04501         PERFORM 8310-INSERT-BLDR-NAME-TMP THRU 8310-EXIT         
               MOVE 1 TO WS-TRAN-APPL-NO-4093                           
               PERFORM 7500-INSERT-NEWADDR-TRAN-HIST THRU 7500-EXIT     
                                                                        
      *        MOVE WS-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO      11570000
      *        MOVE 1               TO MI-TRAN-APPL-NO                  12110000
      *        MOVE 'BUILDER BILL ADDR' TO MI-COLUMN-DESC               12120000
      *        MOVE +17             TO MI-CHG-COLUMN-VALUE-LEN          12150000
      *        MOVE DY-ADDRESS-ID   TO WS-ADDRESS-ID-I                  12160000
      *        MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S                  12170000
T21717*        MOVE WS-ADDRESS-ID-S TO MI-CHG-COLUMN-VALUE-TEXT         12140000
      *        MOVE +13             TO MI-PRV-COLUMN-VALUE-LEN          12150000
      *        MOVE 'BLDR ADDR ADD' TO MI-PRV-COLUMN-VALUE-TEXT         12180000
      *        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          12190000
           ELSE                                                         
A04501         PERFORM 7020-CHECK-BLDR-NAME THRU 7020-EXIT              
               PERFORM 8400-DELETE-BLDR-ADDR-XREF  THRU 8400-EXIT       
               MOVE 1 TO WS-TRAN-APPL-NO-4093                           
               PERFORM 7600-INSERT-DELADDR-TRAN-HIST THRU 7600-EXIT     
A04501         IF WS-BLDR-DELETE-FL = 'Y'                               
A04501             PERFORM 8410-DELETE-BLDR-NAME THRU 8410-EXIT         
A04501         END-IF                                                   
                                                                        
      *        MOVE WS-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO      11570000
      *        MOVE 1               TO MI-TRAN-APPL-NO                  12110000
      *        MOVE 'BUILDER ADDR DEL' TO MI-COLUMN-DESC                12120000
      *        MOVE +16             TO MI-PRV-COLUMN-VALUE-LEN          12150000
      *        MOVE WS-ADDRS-ID     TO WS-ADDRESS-ID-I                  12160000
      *        MOVE WS-ADDRESS-ID-I TO WS-ADDRESS-ID-S                  12170000
T21717*        MOVE WS-ADDRESS-ID-S TO MI-PRV-COLUMN-VALUE-TEXT         12140000
      *        MOVE +13             TO MI-CHG-COLUMN-VALUE-LEN          12150000
      *        MOVE 'BLDR ADDR DEL' TO MI-CHG-COLUMN-VALUE-TEXT         12180000
      *        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          12190000
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
                                                                        
A04501 7010-SELECT-CUSTOMER.                                            
A04501                                                                  
A04501     MOVE '7010' TO ACTIVE-PARAGRAPH.                             
A04501                                                                  
A04501     EXEC SQL                                                     
A04501        SELECT COMPANY_NO_ORIG,                                   
A04501               FULL_NAME                                          
A04501          INTO :CU-COMPANY-NO-ORIG,                               
A04501               :DQ-FULL-NAME                                      
A04501          FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
A04501               CSS_NAME DQ WITH(READUNCOMMITTED)                          
A04501         WHERE CUSTOMER_NO = :WS-CUST-NO                          
A04501           AND CU.NAME_ID = DQ.NAME_ID                            
A04501                                                           
A04501                                                      
A04501     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO_ORIG,                                           
MFA-TR*              FULL_NAME                                                  
MFA-TR*         INTO :CU-COMPANY-NO-ORIG,                                       
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*         FROM CSS_CUSTOMER CU,                                           
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUST-NO                                  
MFA-TR*          AND CU.NAME_ID = DQ.NAME_ID                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04501                                                                  
A04501     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04501                                                                  
A04501     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04501        CONTINUE                                                  
A04501     ELSE                                                         
A04501        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
A04501        MOVE 'SELECT'                     TO ABEND-FUNCTION       
A04501        MOVE SPACES                       TO ABEND-SQL-PREDICATES 
A04501                                             ABEND-TABLES         
A04501        MOVE 'CSS_CUSTOMER'               TO TABLE-1              
A04501        MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1      
A04501        MOVE WS-CUST-NO                   TO HOSTVAR-ELEMENT-1    
A04501        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
A04501        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
A04501     END-IF.                                                      
A04501                                                                  
A04501 7010-EXIT.                                                       
A04501     EXIT.                                                        
                                                                        
A04501 7020-CHECK-BLDR-NAME.                                            
A04501                                                                  
A04501     MOVE '7020' TO ACTIVE-PARAGRAPH.                             
A04501                                                                  
A04501     EXEC SQL                                                     
A04501        SELECT TOP(1) BLDR_CUST_NO                                       
A04501          INTO :X0-BLDR-CUST-NO                                   
A04501          FROM CSS_BLDR_ADDR_XREF WITH(READUNCOMMITTED)                   
A04501         WHERE BLDR_CUST_NO = :WS-CUST-NO                         
A04501           AND ADDRESS_ID <> :WS-ADDRS-ID                         
A04501                                           
A04501                                                           
A04501                                                      
A04501     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BLDR_CUST_NO                                               
MFA-TR*         INTO :X0-BLDR-CUST-NO                                           
MFA-TR*         FROM CSS_BLDR_ADDR_XREF                                         
MFA-TR*        WHERE BLDR_CUST_NO = :WS-CUST-NO                                 
MFA-TR*          AND ADDRESS_ID <> :WS-ADDRS-ID                                 
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04501                                                                  
A04501     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04501                                                                  
A04501     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04501         WHEN SUCCESSFUL-CALL                                     
A04501             MOVE 'N' TO WS-BLDR-DELETE-FL                        
A04501         WHEN NOT-FOUND                                           
A04501             MOVE 'Y' TO WS-BLDR-DELETE-FL                        
A04501             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A04501         WHEN OTHER                                               
A04501             MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
A04501             MOVE 'SELECT'                TO ABEND-FUNCTION       
A04501             MOVE SPACES                  TO ABEND-SQL-PREDICATES 
A04501                                                  ABEND-TABLES    
A04501             MOVE 'CSS_BLDR_ADDR_XREF'    TO TABLE-1              
A04501             MOVE 'BLDR_CUST_NO'          TO TABLE-ELEMENT-1      
A04501             MOVE WS-CUST-NO              TO HOSTVAR-ELEMENT-1    
A04501             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A04501             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A04501     END-EVALUATE.                                                
A04501                                                                  
A04501 7020-EXIT.                                                       
A04501     EXIT.                                                        
                                                                        
       7040-SELECT-RESP-AREA-ID.                                        
                                                                        
           MOVE '7040' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :WS-USER-ID                              
C32615                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23500000
MFA-TR*       SELECT RESP_AREA_ID                                       23510000
MFA-TR*         INTO :WS-RESP-AREA-ID                                   23520000
MFA-TR*         FROM CSS_USER_PROFILE                                   23551000
MFA-TR*        WHERE USER_ID = :WS-USER-ID                              23540000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                    23550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
CBSI          MOVE SPACES                       TO ABEND-SQL-PREDICATES 
CBSI                                               ABEND-TABLES         
              MOVE 'CSS_USER_PROFILE'           TO TABLE-1              
              MOVE 'USER_ID'                    TO TABLE-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2      
              MOVE WS-USER-ID                   TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-INSERT-NEWADDR-TRAN-HIST.                                   
                                                                        
            MOVE WS-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.        
            MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO.               
            MOVE SPACES               TO MI-TABLE-ID                    
            MOVE 'ADDRESS-FORMAT'  TO MI-COLUMN-DESC.                   
            MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN.          
            MOVE '*NEW*'           TO MI-PRV-COLUMN-VALUE-TEXT.         
            MOVE +1                TO MI-CHG-COLUMN-VALUE-LEN.          
            MOVE 'A'               TO MI-CHG-COLUMN-VALUE-TEXT.         
            PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.            
            ADD 1 TO WS-TRAN-APPL-NO-4093.                              
                                                                        
            IF PARM-ADDR-HOUSE-NO > SPACES                              
                MOVE SPACES               TO MI-TABLE-ID                
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +5                  TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-ADDR-HOUSE-NO  TO MI-CHG-COLUMN-VALUE-TEXT    
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'HOUSE NUMBER   '   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-PREFIX-1 > SPACES                              
                MOVE SPACES               TO MI-TABLE-ID                
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +3                  TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-ADDR-PREFIX-1  TO MI-CHG-COLUMN-VALUE-TEXT    
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'ADDRESS PREFX 1'   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-PREFIX-2 > SPACES                              
                MOVE SPACES               TO MI-TABLE-ID                
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-ADDR-PREFIX-2  TO MI-CHG-COLUMN-VALUE-TEXT    
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'ADDRESS PREFX 2'   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-STREET-NAME > SPACES                           
                MOVE SPACES               TO MI-TABLE-ID                
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +16                 TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-ADDR-STREET-NAME TO MI-CHG-COLUMN-VALUE-TEXT  
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'STREET NAME    '   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-STREET-LOC-1 > SPACES                          
                MOVE SPACES               TO MI-TABLE-ID                
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN    
                MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN    
                MOVE PARM-ADDR-STREET-LOC-1 TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT   
                MOVE 'STREET LOC 1   '    TO MI-COLUMN-DESC             
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-STREET-LOC-2    > SPACES                       
                MOVE SPACES               TO MI-TABLE-ID                
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN    
                MOVE +6                   TO MI-CHG-COLUMN-VALUE-LEN    
                MOVE PARM-ADDR-STREET-LOC-2 TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT   
                MOVE 'STREET LOC 2   '    TO MI-COLUMN-DESC             
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-STREET-SUFFIX > SPACES                              
                MOVE '22'                TO MI-TABLE-ID                 
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +4                  TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-STREET-SUFFIX  TO MI-CHG-COLUMN-VALUE-TEXT    
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'STREET SUFFIX  '   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-SUFFIX    > SPACES                             
                MOVE SPACES              TO MI-TABLE-ID                 
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-ADDR-SUFFIX    TO MI-CHG-COLUMN-VALUE-TEXT    
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'ADDR SUFFIX    '   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDRESS-OVERFLOW     > SPACES                       
                MOVE SPACES              TO MI-TABLE-ID                 
                MOVE WS-TRAN-APPL-NO-4093 TO MI-TRAN-APPL-NO            
                MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN     
                MOVE +35                 TO MI-CHG-COLUMN-VALUE-LEN     
                MOVE PARM-ADDRESS-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT  
                MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT    
                MOVE 'ADDR. OVERFLOW '   TO MI-COLUMN-DESC              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-ZIP-CODE(1:5)  > SPACES                        
                MOVE SPACES              TO MI-TABLE-ID                 
                MOVE WS-TRAN-APPL-NO-4093  TO MI-TRAN-APPL-NO           
                MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN   
                MOVE +5                    TO MI-CHG-COLUMN-VALUE-LEN   
                MOVE PARM-ADDR-ZIP-CODE(1:5) TO                         
                     MI-CHG-COLUMN-VALUE-TEXT                           
                MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT  
                MOVE 'ZIP CODE '           TO MI-COLUMN-DESC            
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ZIP-FOUR            > SPACES                        
                MOVE SPACES                TO MI-TABLE-ID               
                MOVE WS-TRAN-APPL-NO-4093  TO MI-TRAN-APPL-NO           
                MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN   
                MOVE +4                    TO MI-CHG-COLUMN-VALUE-LEN   
                MOVE PARM-ZIP-FOUR         TO MI-CHG-COLUMN-VALUE-TEXT  
                MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT  
                MOVE 'ZIP PLUS FOUR '      TO MI-COLUMN-DESC            
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
            IF PARM-ADDR-ZIP-CODE(6:1)  > SPACES                        
                MOVE SPACES                TO MI-TABLE-ID               
                MOVE WS-TRAN-APPL-NO-4093  TO MI-TRAN-APPL-NO           
                MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN   
                MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN   
                MOVE PARM-ADDR-ZIP-CODE(6:1) TO                         
                      MI-CHG-COLUMN-VALUE-TEXT                          
                MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT  
                MOVE 'ZIP TOKEN   '        TO MI-COLUMN-DESC            
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                    TO WS-TRAN-APPL-NO-4093        
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7600-INSERT-DELADDR-TRAN-HIST.                                   
                                                                        
            MOVE WS-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO         
            MOVE WS-TRAN-APPL-NO-4093    TO MI-TRAN-APPL-NO             
            MOVE SPACES                  TO MI-TABLE-ID                 
            MOVE 'ADDR FORMATTED  ' TO MI-COLUMN-DESC                   
            MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN          
            MOVE WS-ADDRS-ID        TO WS-ADDRESS-ID-I                  
            MOVE WS-ADDRESS-ID-I    TO WS-ADDRESS-ID-S                  
            MOVE WS-ADDRESS-ID-S    TO MI-PRV-COLUMN-VALUE-TEXT         
            MOVE +12                TO MI-CHG-COLUMN-VALUE-LEN          
            MOVE 'ADDR DELETED'     TO MI-CHG-COLUMN-VALUE-TEXT         
            ADD 1                   TO WS-TRAN-APPL-NO-4093             
            PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT             
                                                                        
            MOVE WS-TRAN-APPL-NO-4093    TO MI-TRAN-APPL-NO.            
            MOVE SPACES                  TO MI-TABLE-ID                 
            MOVE 'ADDRESS-FORMAT  ' TO MI-COLUMN-DESC.                  
            MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN.         
            MOVE 'A'                TO MI-PRV-COLUMN-VALUE-TEXT.        
            MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN.         
            MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.        
            ADD 1                   TO WS-TRAN-APPL-NO-4093.            
            PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.            
                                                                        
            MOVE WS-TRAN-APPL-NO-4093    TO MI-TRAN-APPL-NO.            
            MOVE SPACES                  TO MI-TABLE-ID                 
            MOVE 'ADDRESS ID      ' TO MI-COLUMN-DESC.                  
            MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN.         
            MOVE WS-ADDRS-ID        TO WS-ADDRESS-ID-I.                 
            MOVE WS-ADDRESS-ID-I    TO WS-ADDRESS-ID-S.                 
            MOVE WS-ADDRESS-ID-S    TO MI-PRV-COLUMN-VALUE-TEXT.        
            MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN.         
            MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT.        
            ADD 1                   TO WS-TRAN-APPL-NO-4093.            
            PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.            
                                                                        
       7600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8000-INSERT-ADDR-FMT.                                            
                                                                        
            EXEC SQL                                                    
                 INSERT INTO CSS_ADDR_FORMATTED(                        
                             ADDRESS_ID,                                
                             HOUSE_NO,                                  
                             ADDR_PREFIX_1,                             
                             ADDR_PREFIX_2,                             
                             STREET_NAME,                               
                             STREET_LOCATION_1,                         
                             STREET_LOCATION_2,                         
                             STREET_SUFFIX,                             
                             ADDRESS_OVERFLOW,                          
                             CARRIER_ROUTE,                             
                             ZIP_CODE,                                  
                             ZIP_CODE_PLUS_FOUR,                        
                             ADDR_USAGE_CD,                             
                             ADDR_SUFFIX,                               
                             ZIP_CODE_TOKEN)                            
                       VALUES(                                          
                             :WS-ADDR-ID,                               
                             :DY-HOUSE-NO,                              
                             :DY-ADDR-PREFIX-1,                         
                             :DY-ADDR-PREFIX-2,                         
                             :DY-STREET-NAME,                           
                             :DY-STREET-LOCATION-1,                     
                             :DY-STREET-LOCATION-2,                     
                             :DY-STREET-SUFFIX,                         
                             :DY-ADDRESS-OVERFLOW,                      
                             :DY-CARRIER-ROUTE,                         
                             :DY-ZIP-CODE,                              
                             :DY-ZIP-CODE-PLUS-FOUR,                    
                             'F',                                       
                             :DY-ADDR-SUFFIX,                           
                             :DY-ZIP-CODE-TOKEN)                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            RS-RETURN-CODE.                             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE 'CSR04093'            TO ABEND-PROGRAM              
               MOVE '8000'                TO ACTIVE-PARAGRAPH           
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                    
               MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
               MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
            ADD 1 TO CTR-ROWS.                                          
                                                                        
       8100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8200-INSERT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_ADDR_FREEFORM                           
                     (ADDRESS_ID,                                       
                      ADDR_STREET,                                      
                      ADDR_CITY_STATE,                                  
                      ADDR_ZIP_CODE,                                    
                      ADDR_COUNTRY,                                     
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      ADDR_STREET_2)                                    
                VALUES                                                  
                     (:WS-ADDR-ID,                                      
                      :DZ-ADDR-STREET,                                  
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDR-COUNTRY,                                 
                      :DZ-ADDRESS-OVERFLOW,                             
                      :DZ-CARRIER-ROUTE,                                
                      :DZ-ADDR-STREET-2)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'CSR04093'            TO ABEND-PROGRAM              
               MOVE '8200'                TO ACTIVE-PARAGRAPH           
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                    
               MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1            
               MOVE DY-ADDRESS-ID         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       8300-INSERT-BLDR-ADDR-XREF.                                      
                                                                        
            EXEC SQL                                                    
                 INSERT INTO CSS_BLDR_ADDR_XREF                         
                      (BLDR_CUST_NO,                                    
                       ADDRESS_ID,                                      
                       LAST_UPDATE_USERID)                              
                 VALUES                                                 
                      (:WS-CUST-NO,                                     
                       :WS-ADDR-ID,                                     
                        CIS.SESSION$USER())                                     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO CSS_BLDR_ADDR_XREF                                 
MFA-TR*               (BLDR_CUST_NO,                                            
MFA-TR*                ADDRESS_ID,                                              
MFA-TR*                LAST_UPDATE_USERID)                                      
MFA-TR*          VALUES                                                         
MFA-TR*               (:WS-CUST-NO,                                             
MFA-TR*                :WS-ADDR-ID,                                             
MFA-TR*                 USER)                                                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            RS-RETURN-CODE.                             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
                MOVE 'CSR04093'            TO ABEND-PROGRAM             
                MOVE '8300'                TO ACTIVE-PARAGRAPH          
                MOVE 'INSERT'              TO ABEND-FUNCTION            
                MOVE 'CSS_BLDR_ADDR_XREF'  TO TABLE-1                   
                MOVE 'BLDR_CUST_NO'        TO TABLE-ELEMENT-1           
                MOVE  WS-CUST-NO           TO HOSTVAR-ELEMENT-1         
                MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-2           
                MOVE  DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-2         
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       8300-EXIT.                                                       
            EXIT.                                                       
                                                                        
A04501 8310-INSERT-BLDR-NAME-TMP.                                       
A04501                                                                  
A04501      EXEC SQL                                                    
A04501           INSERT INTO CSS_BLDR_NAME_TMP                          
A04501                (BLDR_CUST_NO,                                    
A04501                 BLDR_NAME,                                       
A04501                 COMPANY_NO)                                      
A04501           VALUES                                                 
A04501                (:WS-CUST-NO,                                     
A04501                 :WS-FORMATTED-NAME,                              
A04501                 :CU-COMPANY-NO-ORIG)                             
A04501      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04501                                                                  
A04501      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
A04501                      RS-RETURN-CODE.                             
A04501                                                                  
A04501      EVALUATE WS-ACTIVE-RETURN-CODE                              
A04501          WHEN SUCCESSFUL-CALL                                    
A04501              CONTINUE                                            
A04501          WHEN ALREADY-EXISTS                                     
A04501              MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                
A04501                             RS-RETURN-CODE                       
A04501          WHEN OTHER                                              
A04501              MOVE 'CSR04093'        TO ABEND-PROGRAM             
A04501              MOVE '8310'            TO ACTIVE-PARAGRAPH          
A04501              MOVE 'INSERT'          TO ABEND-FUNCTION            
A04501              MOVE 'CSS_BLDR_NAME_TMP' TO TABLE-1                 
A04501              MOVE 'BLDR_CUST_NO'    TO TABLE-ELEMENT-1           
A04501              MOVE WS-CUST-NO        TO HOSTVAR-ELEMENT-1         
A04501              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
A04501              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
A04501      END-EVALUATE.                                               
A04501                                                                  
A04501 8310-EXIT.                                                       
A04501      EXIT.                                                       
                                                                        
       8400-DELETE-BLDR-ADDR-XREF.                                      
                                                                        
            EXEC SQL                                                    
                DELETE  FROM CSS_BLDR_ADDR_XREF                         
                 WHERE  ADDRESS_ID   = :WS-ADDRS-ID                     
                   AND  BLDR_CUST_NO = :WS-CUST-NO                      
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE  FROM CSS_BLDR_ADDR_XREF                                 
MFA-TR*          WHERE  ADDRESS_ID   = :WS-ADDRS-ID                             
MFA-TR*            AND  BLDR_CUST_NO = :WS-CUST-NO                              
MFA-TR*         QUERYNO 8400                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                            RS-RETURN-CODE.                             
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
                MOVE 'CSR04093'            TO ABEND-PROGRAM             
                MOVE '8400'                TO ACTIVE-PARAGRAPH          
                MOVE 'DELETE'              TO ABEND-FUNCTION            
                MOVE 'CSS_BLDR_ADDR_XREF'  TO TABLE-1                   
                MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1           
                MOVE  WS-ADDRS-ID          TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       8400-EXIT.                                                       
            EXIT.                                                       
                                                                        
A04501 8410-DELETE-BLDR-NAME.                                           
A04501                                                                  
A04501      EXEC SQL                                                    
A04501          DELETE  FROM CSS_BLDR_NAME_TMP                          
A04501           WHERE  BLDR_CUST_NO = :WS-CUST-NO                      
A04501                                                      
A04501      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE  FROM CSS_BLDR_NAME_TMP                                  
MFA-TR*          WHERE  BLDR_CUST_NO = :WS-CUST-NO                              
MFA-TR*         QUERYNO 8410                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04501                                                                  
A04501      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
A04501                      RS-RETURN-CODE.                             
A04501                                                                  
A04501      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A04501          NEXT SENTENCE                                           
A04501      ELSE                                                        
A04501          MOVE 'CSR04093'            TO ABEND-PROGRAM             
A04501          MOVE '8410'                TO ACTIVE-PARAGRAPH          
A04501          MOVE 'DELETE'              TO ABEND-FUNCTION            
A04501          MOVE 'CSS_BLDR_NAME_TMP'   TO TABLE-1                   
A04501          MOVE 'BLDR_CUST_NO'        TO TABLE-ELEMENT-1           
A04501          MOVE  WS-CUST-NO           TO HOSTVAR-ELEMENT-1         
A04501          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
A04501          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
A04501      END-IF.                                                     
A04501                                                                  
A04501 8410-EXIT.                                                       
A04501      EXIT.                                                       
                                                                        
A04501     EXEC SQL                                                     22991509
A04501        INCLUDE CPD00004                                          22991609
A04501     END-EXEC.                                                    22991709
           EXEC SQL                                                     22991509
              INCLUDE CPD00067                                          22991609
           END-EXEC.                                                    22991709
           EXEC SQL                                                     22989709
              INCLUDE CPD00071                                          22989809
           END-EXEC.                                                    22989909
           EXEC SQL                                                     22990109
              INCLUDE CPD00090                                          22990209
           END-EXEC.                                                    22990309
           EXEC SQL                                                             
             INCLUDE CPDSP300                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
