       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04077.                                            
       DATE-WRITTEN. 02/11/08.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE GETS ALL THE SERVICE LINE DATA FOR A PREMISE.  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/11/08    PD       PROCEDURE ORIGINALLY CODED.              *        
      *  12/09/08    PK       ADDED FIELDS FOR PARTIAL RETIREMENT      *        
      *  01/29/09    PK       INCREASE LENGTH OF ADDRESS FIELD FOR     *        
      *              PK       BUILDER ADDRESS DROP DOWN                *        
PR104 *  08/27/09    MA       ADDED INSTALL_PREM_FL  AS INSTALL FLG    *        
      *                                                                *        
PR104 *  09/02/09    MA       INSTALL ORDER FOR MULTIMETER PREMISE     *        
PR104 *  10/07/09    PK       PROJ104-MULTIMETER CHANGES. TOTAL_BTU &  *        
      *                       METER_PRESSURE MOVED TO CSS_PREM_GAS_LINE*        
PR104 *  01/12/10   PK98692   TO CORRECT THE ERROR WHERE FOR MULTIMETER*        
      *                       SVCS, THE SO# IS NOT DISPLAYED IN NON-INS*        
      *                       TALL PREMISE WHEN SO IN HST_* TABLE      *        
P0104 *  02/18/10   PK98692   TO INCLUDE ORDER STATES, HOLD(H), TURNED *        
      *                       DOWN CO(B),TURNED DOWN CU(D),PYMT REQD(R)*        
      *                       WHILE POPULATING SET_PENDING_FL          *        
A2096 *  03/10/10   PK98692   TO GET THE WORK TYPE FOR SERVICE ORDERS  *        
      *                       FROM GASLINE_SO_XRF TABLE INSTEAD OF THE *        
      *                       SO TABLES.                                        
A0432 *  04/20/10   MA96833  APPL432 ADDED VIEW ORDER FLG TO RESULT SET*        
A3355 *  05/05/11   PK98692  CHANGED REFERENCES TO XO-TOTAL-BTU AND    *        
A3355 *                      XO-METER-PRESSURE TO THE CORRESPONDING    *        
A3355 *                      Y0- DCLGEN VARS FOR DCR963 TO BE WORKED   *        
I01400*  12/29/11   VV90387  TRACK FUEL TYPE CONVERSIONS               *        
A04527*  06/07/13   MR7E794  REMOVED UNUSED COPYBOOK CWS00056.         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04077'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DQ - CSS_NAME                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    DY - CSS_ADDR_FORMATTED                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    PR - CSS_PREMISE                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    CU - CSS_CUSTOMER                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    Y0 - CSS_PREM_GAS_LINE                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    Y0 - CSS_GAS_SERV_LINE                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASSRV                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    DZ - CSS_ADDR_FREEFORM                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    A9 - CSS_REV_DISTRICT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    YV - HST_SO_DATA                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    XV - CSS_LINE_WORK_TYPE                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBLINEWK                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    XX - CSS_GASLINE_SO_XREF                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGASSO                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *    CH - CSS_CUST_PREM_HIST                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *****************************************************************         
      *    CSS_JOB_PARM         (PREFIX = G6)   *                               
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR04077'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-ID1                     PIC S9(9) COMP VALUE 1.     
*********  05  PARM-PREMISE-NO              PIC S9(10)V USAGE COMP-3.           
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE               PIC S9(9) COMP.              
           05 RS-PREMISE-NO                PIC S9(10)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-CITY-GATE-ID              PIC X(07) VALUE SPACES.      
           05 RS-CROSS-STREET-1            PIC X(35) VALUE SPACES.      
           05 RS-CROSS-STREET-2            PIC X(35) VALUE SPACES.      
           05 RS-LOCATOR-ID                PIC X(09) VALUE SPACES.      
           05 RS-SERVICE-NO                PIC S9(10)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-STRUCTURE-TYPE-CD         PIC X(1) VALUE SPACES.       
           05 RS-STRUCTURE-CD              PIC X(1) VALUE SPACES.       
           05 RS-SALES-REP-ID              PIC X(7) VALUE SPACES.       
           05 RS-BUILDER-ADDR-ID           PIC S9(13)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-CUSTOMER-NO               PIC S9(10)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-BUILDER-CUST-NO           PIC S9(10)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-SERV-AGREE-AMT            PIC S9(9)V99 USAGE COMP-3    
                                           VALUE 0.                     
           05 RS-SERV-AGREE-DT             PIC X(10) VALUE SPACES.      
           05 RS-SERV-OWNER-CD             PIC X(1)  VALUE SPACES.      
           05 RS-METER-PRESSURE            PIC S9(8) COMP               
                                           VALUE 0.                     
           05 RS-SERV-LINE-TYPE            PIC X(1)  VALUE SPACES.      
           05 RS-SERV-LINE-SIZE            PIC X(3)  VALUE SPACES.      
           05 RS-SERV-LINE-LENGTH          PIC S9(8) COMP               
                                           VALUE 0.                     
           05 RS-INSTALL-TYPE-CD           PIC X(1)  VALUE SPACES.      
           05 RS-TOTAL-BTU                 PIC S9(9) COMP               
                                           VALUE 0.                     
           05 RS-SPLIT-SERV-FL             PIC X(1)  VALUE SPACES.      
           05 RS-XS-FLOW-VALVE-FL          PIC X(1)  VALUE SPACES.      
           05 RS-FARM-TAP-IND              PIC X(1)  VALUE SPACES.      
           05 RS-SVC-LINE-INSTALL-DT       PIC X(10) VALUE SPACES.      
           05 RS-SVC-LINE-RETIRE-DT        PIC X(10) VALUE SPACES.      
           05 RS-SERV-LINE-STAT-FL         PIC X(1)  VALUE SPACES.      
           05 RS-CUSTOMER-NAME             PIC X(50) VALUE SPACES.      
           05 RS-BUILDER-NAME              PIC X(50) VALUE SPACES.      
           05 RS-MUNICIPALITY-IND          PIC X(01) VALUE SPACES.      
           05 RS-ADDRESS                   PIC X(100) VALUE SPACES.     
           05 RS-LOCAL-OFFICE              PIC X(03) VALUE SPACES.      
           05 RS-ZIP-CODE                  PIC X(05) VALUE SPACES.      
           05 RS-SERV-ORDER-NO             PIC S9(13)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-RETIRE-ORDER-NO           PIC S9(13)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-REVERSE-ORDER-NO          PIC S9(13)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-ACTIVE-ACCT-NO            PIC S9(13)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-ACTIVE-CUST-NO            PIC S9(10)V USAGE COMP-3     
                                           VALUE 0.                     
           05 RS-ACTIVE-CUST-NAME          PIC X(50) VALUE SPACES.      
           05 RS-ORDER-BY-SEQ              PIC X(1)  VALUE SPACES.      
           05 RS-IS-MULTIBAR               PIC X(1)  VALUE SPACES.      
           05 RS-IS-SET-PENDING            PIC X(1)  VALUE SPACES.      
           05 RS-MATL-POSTED-FL            PIC X(1)  VALUE SPACES.      
           05 RS-LAST-UPDATE-TS            PIC X(26) VALUE SPACES.      
           05 RS-SERV-LINE-TYPE-RTD        PIC X(1)  VALUE SPACES.      
           05 RS-SERV-LINE-SIZE-RTD        PIC X(3)  VALUE SPACES.      
           05 RS-SERV-LINE-LEN-RTD         PIC S9(8) COMP               
                                           VALUE 0.                     
           05 RS-INSTALL-PREM-FL           PIC X(1) VALUE SPACES.       
A0432      05 RS-VIEW-ORDER-FL             PIC X(1) VALUE SPACES.       
I01400     05 RS-FUEL-CONV-TYPE-CD         PIC X(1) VALUE SPACES.       
I01400     05 RS-FUEL-CONV-COMMENT         PIC X(20) VALUE SPACES.      
I01400     05 RS-FUEL-UPDATE-FL            PIC X(1) VALUE 'N'.          
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
                                                                        
       01  WS-MISC-FIELDS.                                              
           05  WS-UTIL-TYPE                 PIC X(1) VALUE SPACES.      
           05  WS-PREMISE-NO                PIC S9(10)V USAGE COMP-3    
                                            VALUE 0.                    
PR104      05  WS-PREMISE-BF                PIC S9(10)V USAGE COMP-3    
PR104                                       VALUE 0.                    
           05  WS-PCOUNT                    PIC S9(02) COMP VALUE 0.    
           05  WS-ADDRESS                   PIC X(100) VALUE SPACES.    
           05  WS-CUSTOMER-NAME             PIC X(50) VALUE SPACES.     
           05  WS-FULL-NAME                 PIC X(50) VALUE SPACES.     
           05  WS-NAME                      PIC X(50) VALUE SPACES.     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04077'. 
           05  S-RETURN-CODE                PIC S9(9) COMP.             
           05  WS-BUILDER-ADDR-ID-NI        PIC S9(04) COMP VALUE 0.    
           05  WS-CUSTOMER-NO-NI            PIC S9(04) COMP VALUE 0.    
           05  WS-BUILDER-CUST-NO-NI        PIC S9(04) COMP VALUE 0.    
           05  WS-SERV-AGREE-AMT-NI         PIC S9(04) COMP VALUE 0.    
           05  WS-SERV-AGREE-DT-NI          PIC S9(04) COMP VALUE 0.    
           05  WS-SERV-LINE-LENGTH-NI       PIC S9(04) COMP VALUE 0.    
           05  WS-SERV-LINE-LEN-RTD-NI      PIC S9(04) COMP VALUE 0.    
           05  WS-TOTAL-BTU-NI              PIC S9(04) COMP VALUE 0.    
           05  WS-SVC-LINE-INSTALL-DT-NI    PIC S9(04) COMP VALUE 0.    
           05  WS-SVC-LINE-RETIRE-DT-NI     PIC S9(04) COMP VALUE 0.    
           05  WS-METER-PRESSURE-NI         PIC S9(04) COMP VALUE 0.    
           05  WS-INSTALL-TYPE-CD           PIC X(01) VALUE SPACES.     
           05  WS-IS-MULTIBAR               PIC X(01) VALUE 'N'.        
           05  WS-MULTIMETER-COUNT          PIC S9(04) COMP VALUE 0.    
           05  WS-IS-SET-PENDING            PIC X(01) VALUE 'N'.        
           05  WS-SET-ORDER-COUNT           PIC S9(04) COMP VALUE 0.    
           05  WS-MATL-POSTED-FL            PIC X(01) VALUE ' '.        
A0432      05  WS-FLG-ORDER-NO              PIC X(01) VALUE ' '.        
I01400     05  WS-PARM-DATE                 PIC X(10) VALUE SPACES.     
                                                                        
       LINKAGE SECTION.                                                 
COB305 01 PARM-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
      ******************************************************************        
      *    SERV_LINE_CUR IS USED TO SEARCH SERVICE LINE DETAILS        *        
      ******************************************************************        
           EXEC SQL DECLARE SERV_LINE_CUR CURSOR FOR                    
               SELECT Y0.SERVICE_NO                                     
                     ,Y0.STRUCTURE_TYPE_CD                              
                     ,Y0.STRUCTURE_CD                                   
                     ,Y0.SALES_REP_ID                                   
                     ,Y0.BUILDER_ADDR_ID                                
                     ,Y0.CUSTOMER_NO                                    
                     ,Y0.BUILDER_CUST_NO                                
                     ,Y0.SERV_AGREE_AMT                                 
                     ,Y0.SERV_AGREE_DT                                  
                     ,Y0.SERV_OWNER_CD                                  
                     ,Y0.INSTALL_PREM_FL                                
PR104 *              ,XO.METER_PRESSURE                                         
PR104                ,Y0.METER_PRESSURE                                 
                     ,XO.SERV_LINE_TYPE                                 
                     ,XO.SERV_LINE_SIZE                                 
                     ,XO.SERV_LINE_LENGTH                               
                     ,XO.INSTALL_TYPE_CD                                
PR104 *              ,XO.TOTAL_BTU                                              
PR104                ,Y0.TOTAL_BTU                                      
                     ,XO.SPLIT_SERV_FL                                  
                     ,XO.XS_FLOW_VALVE_FL                               
                     ,XO.FARM_TAP_IND                                   
                     ,XO.SVC_LINE_INSTALL_DT                            
                     ,XO.SVC_LINE_RETIRE_DT                             
                     ,XO.SERV_LINE_STAT_FL                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           XO.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,XO.SERV_LINE_TYPE_RTD                             
                     ,XO.SERV_LINE_SIZE_RTD                             
                     ,XO.SERV_LINE_LEN_RTD                              
I01400               ,Y0.FUEL_CONV_TYPE_CD                              
I01400               ,Y0.FUEL_CONV_COMMENT                              
                 FROM CSS_PREM_GAS_LINE  Y0 WITH(READUNCOMMITTED),              
                      CSS_GAS_SERV_LINE  XO WITH(READUNCOMMITTED)               
                WHERE Y0.PREMISE_NO  = :Y0-PREMISE-NO                   
                  AND Y0.SERVICE_NO  = XO.SERVICE_NO                    
                ORDER BY XO.SERV_LINE_STAT_FL                           
             FOR READ ONLY                                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE SERV_LINE_CUR CURSOR FOR                            
MFA-TR*        SELECT Y0.SERVICE_NO                                             
MFA-TR*              ,Y0.STRUCTURE_TYPE_CD                                      
MFA-TR*              ,Y0.STRUCTURE_CD                                           
MFA-TR*              ,Y0.SALES_REP_ID                                           
MFA-TR*              ,Y0.BUILDER_ADDR_ID                                        
MFA-TR*              ,Y0.CUSTOMER_NO                                            
MFA-TR*              ,Y0.BUILDER_CUST_NO                                        
MFA-TR*              ,Y0.SERV_AGREE_AMT                                         
MFA-TR*              ,Y0.SERV_AGREE_DT                                          
MFA-TR*              ,Y0.SERV_OWNER_CD                                          
MFA-TR*              ,Y0.INSTALL_PREM_FL                                        
MFA-TR*              ,XO.METER_PRESSURE                                         
MFA-TR*              ,Y0.METER_PRESSURE                                         
MFA-TR*              ,XO.SERV_LINE_TYPE                                         
MFA-TR*              ,XO.SERV_LINE_SIZE                                         
MFA-TR*              ,XO.SERV_LINE_LENGTH                                       
MFA-TR*              ,XO.INSTALL_TYPE_CD                                        
MFA-TR*              ,XO.TOTAL_BTU                                              
MFA-TR*              ,Y0.TOTAL_BTU                                              
MFA-TR*              ,XO.SPLIT_SERV_FL                                          
MFA-TR*              ,XO.XS_FLOW_VALVE_FL                                       
MFA-TR*              ,XO.FARM_TAP_IND                                           
MFA-TR*              ,XO.SVC_LINE_INSTALL_DT                                    
MFA-TR*              ,XO.SVC_LINE_RETIRE_DT                                     
MFA-TR*              ,XO.SERV_LINE_STAT_FL                                      
MFA-TR*              ,XO.LAST_UPDATE_TS                                         
MFA-TR*              ,XO.SERV_LINE_TYPE_RTD                                     
MFA-TR*              ,XO.SERV_LINE_SIZE_RTD                                     
MFA-TR*              ,XO.SERV_LINE_LEN_RTD                                      
MFA-TR*              ,Y0.FUEL_CONV_TYPE_CD                                      
MFA-TR*              ,Y0.FUEL_CONV_COMMENT                                      
MFA-TR*          FROM CSS_PREM_GAS_LINE  Y0,                                    
MFA-TR*               CSS_GAS_SERV_LINE  XO                                     
MFA-TR*         WHERE Y0.PREMISE_NO  = :Y0-PREMISE-NO                           
MFA-TR*           AND Y0.SERVICE_NO  = XO.SERVICE_NO                            
MFA-TR*         ORDER BY XO.SERV_LINE_STAT_FL                                   
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       PROCEDURE DIVISION USING PARM-PREMISE-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
                                                                        
               EXEC SQL                                                 
                   DECLARE C1 CURSOR  FOR                    
                   SELECT                                               
                 RETURN_CODE             AS     RETURN_CODE             
                ,PREMISE_NO              AS     PREMISE_NO              
                ,LTRIM(RTRIM(CITY_GATE_ID))     AS     CITY_GATE_ID            
                ,LTRIM(RTRIM(CROSS_STREET_1))   AS     CROSS_STREET_1          
                ,LTRIM(RTRIM(CROSS_STREET_2))   AS     CROSS_STREET_2          
                ,LTRIM(RTRIM(LOCATOR_ID))       AS     LOCATOR_ID              
                ,SERVICE_NO              AS     SERVICE_NO              
                ,LTRIM(RTRIM(STRUCTURE_TYPE_CD)) AS    STRUCTURE_TYPE_CD       
                ,LTRIM(RTRIM(STRUCTURE_CD))     AS     STRUCTURE_CD            
                ,LTRIM(RTRIM(SALES_REP_ID))     AS     SALES_REP_ID            
                ,BUILDER_ADDR_ID         AS     BUILDER_ADDR_ID         
                ,CUSTOMER_NO             AS     CUSTOMER_NO             
                ,BUILDER_CUST_NO         AS     BUILDER_CUST_NO         
                ,SERV_AGREE_AMT          AS     SERV_AGREE_AMT          
      *         ,STRIP(SERV_AGREE_DT)    AS     SERV_AGREE_DT                   
                ,CASE (LTRIM(RTRIM(SERV_AGREE_DT)))                            
                     WHEN '' THEN '1900-01-01'                          
                     ELSE LTRIM(RTRIM(SERV_AGREE_DT)) END                      
                                         AS     SERV_AGREE_DT           
                ,LTRIM(RTRIM(SERV_OWNER_CD))    AS     SERV_OWNER_CD           
                ,METER_PRESSURE          AS     METER_PRESSURE          
                ,LTRIM(RTRIM(SERV_LINE_TYPE))   AS     SERV_LINE_TYPE          
                ,LTRIM(RTRIM(SERV_LINE_SIZE))   AS     SERV_LINE_SIZE          
                ,SERV_LINE_LENGTH        AS     SERV_LINE_LENGTH        
                ,LTRIM(RTRIM(INSTALL_TYPE_CD))  AS     INSTALL_TYPE_CD         
                ,TOTAL_BTU               AS     TOTAL_BTU               
                ,LTRIM(RTRIM(SPLIT_SERVICE))    AS     SPLIT_SERVICE           
                ,LTRIM(RTRIM(XS_FLOW_VALVE_FL)) AS     XS_FLOW_VALVE_FL        
                ,FARM_TAP_IND            AS     FARM_TAP_IND            
                ,SVC_LINE_INSTALL_DT     AS     SVC_LINE_INSTALL_DT     
      *         ,STRIP(SVC_LINE_RETIRE_DT) AS   SVC_LINE_RETIRE_DT              
                ,CASE (LTRIM(RTRIM(SVC_LINE_RETIRE_DT)))                       
                    WHEN '' THEN '1900-01-01'                           
                    ELSE LTRIM(RTRIM(SVC_LINE_RETIRE_DT)) END                  
                                         AS    SVC_LINE_RETIRE_DT       
                ,LTRIM(RTRIM(SERV_LINE_STAT_FL)) AS    SERV_LINE_STAT_FL       
                ,RTRIM(ADDRESS)          AS     ADDRESS                 
                ,RTRIM(CUSTOMER_NAME)    AS     CUSTOMER_NAME           
                ,LTRIM(RTRIM(MUNICIPALITY_IND)) AS     MUNICIPALITY_IND        
                ,SERV_ORDER_NO           AS     SERV_ORDER_NO           
                ,LOCAL_OFFICE            AS     LOCAL_OFFICE            
                ,ZIP_CODE                AS     ZIP_CODE                
                ,RETIRE_ORDER_NO         AS     RETIRE_ORDER_NO         
                ,REVERSE_ORDER_NO        AS     REVERSE_ORDER_NO        
                ,ACTIVE_ACCT_NO          AS     ACTIVE_ACCT_NO          
                ,ACTIVE_CUST_NO          AS     ACTIVE_CUST_NO          
                ,ACTIVE_CUST_NAME        AS     ACTIVE_CUST_NAME        
                ,IS_MULTIBAR             AS     IS_MULTIBAR             
                ,IS_SET_PENDING          AS     IS_SET_PENDING          
                ,MATL_POSTED_FL          AS     MATL_POSTED_FL          
                ,LAST_UPDATE_TS          AS     LAST_UPDATE_TS          
                ,LTRIM(RTRIM(SERV_LINE_TYPE_RTD)) AS     
           SERV_LINE_TYPE_RTD    
                ,LTRIM(RTRIM(SERV_LINE_SIZE_RTD)) AS     
           SERV_LINE_SIZE_RTD    
                ,SERV_LINE_LEN_RTD       AS     SERV_LINE_LEN_RTD       
                ,INSTALL_PREM_FL         AS     INSTALL_PREM_FL         
A0432           ,VIEW_ORDER_FL           AS     VIEW_ORDER_FL           
I01400          ,FUEL_CONV_TYPE_CD        AS     FUEL_CONV_TYPE_CD      
I01400          ,LTRIM(RTRIM(FUEL_CONV_COMMENT)) AS     
           FUEL_CONV_COMMENT      
I01400          ,FUEL_UPDATE_FL           AS     FUEL_UPDATE_FL         
                   FROM                                                 
                       #CSR04077_R1                              
                       ORDER BY ORDER_BY_SEQ ASC, SERVICE_NO DESC       
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*        EXEC SQL                                                         
MFA-TR*            DECLARE C1 CURSOR WITH RETURN FOR                            
MFA-TR*            SELECT                                                       
MFA-TR*          RETURN_CODE             AS     RETURN_CODE                     
MFA-TR*         ,PREMISE_NO              AS     PREMISE_NO                      
MFA-TR*         ,STRIP(CITY_GATE_ID)     AS     CITY_GATE_ID                    
MFA-TR*         ,STRIP(CROSS_STREET_1)   AS     CROSS_STREET_1                  
MFA-TR*         ,STRIP(CROSS_STREET_2)   AS     CROSS_STREET_2                  
MFA-TR*         ,STRIP(LOCATOR_ID)       AS     LOCATOR_ID                      
MFA-TR*         ,SERVICE_NO              AS     SERVICE_NO                      
MFA-TR*         ,STRIP(STRUCTURE_TYPE_CD) AS    STRUCTURE_TYPE_CD               
MFA-TR*         ,STRIP(STRUCTURE_CD)     AS     STRUCTURE_CD                    
MFA-TR*         ,STRIP(SALES_REP_ID)     AS     SALES_REP_ID                    
MFA-TR*         ,BUILDER_ADDR_ID         AS     BUILDER_ADDR_ID                 
MFA-TR*         ,CUSTOMER_NO             AS     CUSTOMER_NO                     
MFA-TR*         ,BUILDER_CUST_NO         AS     BUILDER_CUST_NO                 
MFA-TR*         ,SERV_AGREE_AMT          AS     SERV_AGREE_AMT                  
MFA-TR*         ,STRIP(SERV_AGREE_DT)    AS     SERV_AGREE_DT                   
MFA-TR*         ,CASE (STRIP(SERV_AGREE_DT))                                    
MFA-TR*              WHEN '' THEN '1900-01-01'                                  
MFA-TR*              ELSE STRIP(SERV_AGREE_DT) END                              
MFA-TR*                                  AS     SERV_AGREE_DT                   
MFA-TR*         ,STRIP(SERV_OWNER_CD)    AS     SERV_OWNER_CD                   
MFA-TR*         ,METER_PRESSURE          AS     METER_PRESSURE                  
MFA-TR*         ,STRIP(SERV_LINE_TYPE)   AS     SERV_LINE_TYPE                  
MFA-TR*         ,STRIP(SERV_LINE_SIZE)   AS     SERV_LINE_SIZE                  
MFA-TR*         ,SERV_LINE_LENGTH        AS     SERV_LINE_LENGTH                
MFA-TR*         ,STRIP(INSTALL_TYPE_CD)  AS     INSTALL_TYPE_CD                 
MFA-TR*         ,TOTAL_BTU               AS     TOTAL_BTU                       
MFA-TR*         ,STRIP(SPLIT_SERVICE)    AS     SPLIT_SERVICE                   
MFA-TR*         ,STRIP(XS_FLOW_VALVE_FL) AS     XS_FLOW_VALVE_FL                
MFA-TR*         ,FARM_TAP_IND            AS     FARM_TAP_IND                    
MFA-TR*         ,SVC_LINE_INSTALL_DT     AS     SVC_LINE_INSTALL_DT             
MFA-TR*         ,STRIP(SVC_LINE_RETIRE_DT) AS   SVC_LINE_RETIRE_DT              
MFA-TR*         ,CASE (STRIP(SVC_LINE_RETIRE_DT))                               
MFA-TR*             WHEN '' THEN '1900-01-01'                                   
MFA-TR*             ELSE STRIP(SVC_LINE_RETIRE_DT) END                          
MFA-TR*                                  AS    SVC_LINE_RETIRE_DT               
MFA-TR*         ,STRIP(SERV_LINE_STAT_FL) AS    SERV_LINE_STAT_FL               
MFA-TR*         ,RTRIM(ADDRESS)          AS     ADDRESS                         
MFA-TR*         ,RTRIM(CUSTOMER_NAME)    AS     CUSTOMER_NAME                   
MFA-TR*         ,STRIP(MUNICIPALITY_IND) AS     MUNICIPALITY_IND                
MFA-TR*         ,SERV_ORDER_NO           AS     SERV_ORDER_NO                   
MFA-TR*         ,LOCAL_OFFICE            AS     LOCAL_OFFICE                    
MFA-TR*         ,ZIP_CODE                AS     ZIP_CODE                        
MFA-TR*         ,RETIRE_ORDER_NO         AS     RETIRE_ORDER_NO                 
MFA-TR*         ,REVERSE_ORDER_NO        AS     REVERSE_ORDER_NO                
MFA-TR*         ,ACTIVE_ACCT_NO          AS     ACTIVE_ACCT_NO                  
MFA-TR*         ,ACTIVE_CUST_NO          AS     ACTIVE_CUST_NO                  
MFA-TR*         ,ACTIVE_CUST_NAME        AS     ACTIVE_CUST_NAME                
MFA-TR*         ,IS_MULTIBAR             AS     IS_MULTIBAR                     
MFA-TR*         ,IS_SET_PENDING          AS     IS_SET_PENDING                  
MFA-TR*         ,MATL_POSTED_FL          AS     MATL_POSTED_FL                  
MFA-TR*         ,LAST_UPDATE_TS          AS     LAST_UPDATE_TS                  
MFA-TR*         ,STRIP(SERV_LINE_TYPE_RTD) AS     SERV_LINE_TYPE_RTD            
MFA-TR*         ,STRIP(SERV_LINE_SIZE_RTD) AS     SERV_LINE_SIZE_RTD            
MFA-TR*         ,SERV_LINE_LEN_RTD       AS     SERV_LINE_LEN_RTD               
MFA-TR*         ,INSTALL_PREM_FL         AS     INSTALL_PREM_FL                 
MFA-TR*         ,VIEW_ORDER_FL           AS     VIEW_ORDER_FL                   
MFA-TR*         ,FUEL_CONV_TYPE_CD        AS     FUEL_CONV_TYPE_CD              
MFA-TR*         ,STRIP(FUEL_CONV_COMMENT) AS     FUEL_CONV_COMMENT              
MFA-TR*         ,FUEL_UPDATE_FL           AS     FUEL_UPDATE_FL                 
MFA-TR*            FROM                                                         
MFA-TR*                SESSION.CSR04077_R1                                      
MFA-TR*                ORDER BY ORDER_BY_SEQ ASC, SERVICE_NO DESC               
MFA-TR*        END-EXEC.                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT************************************************        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04077_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04077_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04077_R1
               (                                                       
                 RETURN_CODE               INT                      
                ,PREMISE_NO                DECIMAL(10,0)                
                ,CITY_GATE_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,CROSS_STREET_1 CHAR(35)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                ,CROSS_STREET_2 CHAR(35)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                ,LOCATOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,MUNICIPALITY_IND CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                ,SERVICE_NO                DECIMAL(10,0)                
                ,STRUCTURE_TYPE_CD CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                ,STRUCTURE_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,SALES_REP_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,BUILDER_ADDR_ID           DECIMAL(13,0)                
                ,CUSTOMER_NO               DECIMAL(10,0)                
                ,BUILDER_CUST_NO           DECIMAL(10,0)                
                ,SERV_AGREE_AMT            DECIMAL(11,2)                
                ,SERV_AGREE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,SERV_OWNER_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,METER_PRESSURE            INT                      
                ,SERV_LINE_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,SERV_LINE_SIZE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,SERV_LINE_LENGTH          INT                      
                ,INSTALL_TYPE_CD CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                ,TOTAL_BTU                 INT                      
                ,SPLIT_SERVICE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,XS_FLOW_VALVE_FL CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                ,FARM_TAP_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,SVC_LINE_INSTALL_DT       DATE                         
                ,SVC_LINE_RETIRE_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                ,SERV_LINE_STAT_FL CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                ,CUSTOMER_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,BUILDER_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,ADDRESS CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,SERV_ORDER_NO             DECIMAL(13,0)                
                ,RETIRE_ORDER_NO           DECIMAL(13,0)                
                ,REVERSE_ORDER_NO          DECIMAL(13,0)                
                ,LOCAL_OFFICE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2             
                ,ACTIVE_ACCT_NO            DECIMAL(13,0)                
                ,ACTIVE_CUST_NO            DECIMAL(10,0)                
                ,ACTIVE_CUST_NAME CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                ,ORDER_BY_SEQ CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
                ,IS_MULTIBAR CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,IS_SET_PENDING CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,MATL_POSTED_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                ,SERV_LINE_TYPE_RTD CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                ,SERV_LINE_SIZE_RTD CHAR(3)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
                ,SERV_LINE_LEN_RTD         INT                      
                ,INSTALL_PREM_FL CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
A0432           ,VIEW_ORDER_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
I01400          ,FUEL_CONV_TYPE_CD CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                      
I01400          ,FUEL_CONV_COMMENT CHAR(20)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
I01400          ,FUEL_UPDATE_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

 *                                                                      
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
 *                                                                      
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
                                          THRU 8000A-EXIT               
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR04077_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *     2. SPLIT OUT PARM STRING INFORMATION                       *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-PREMISE-NO            TO Y0-PREMISE-NO.            
           MOVE PARM-PREMISE-NO            TO PR-PREMISE-NO.            
           MOVE PARM-PREMISE-NO            TO VO-PREMISE-NO.            
           MOVE PARM-PREMISE-NO            TO YV-PREMISE-NO.            
           MOVE PARM-PREMISE-NO            TO RS-PREMISE-NO.            
           MOVE PARM-PREMISE-NO            TO CH-PREMISE-NO.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7600-SELECT-PREMISE                  THRU 7600-EXIT. 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE    5000                      TO RS-RETURN-CODE       
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
              PERFORM 9999-END-PROGRAM          THRU 9999-EXIT          
           END-IF                                                       
           MOVE PR-CITY-GATE-ID            TO RS-CITY-GATE-ID           
           MOVE PR-CROSS-STREET-1          TO RS-CROSS-STREET-1         
           MOVE PR-CROSS-STREET-2          TO RS-CROSS-STREET-2         
           MOVE PR-LOCATOR-ID              TO RS-LOCATOR-ID             
           MOVE PR-LOCAL-OFFICE            TO RS-LOCAL-OFFICE           
           MOVE A9-MUNICIPALITY-IND        TO RS-MUNICIPALITY-IND       
           MOVE DY-ZIP-CODE                TO RS-ZIP-CODE               
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :RS-SVC-LINE-INSTALL-DT                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :RS-SVC-LINE-INSTALL-DT = CURRENT DATE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           PERFORM 7630-SELECT-ACTIVE-CUSTOMER          THRU 7630-EXIT. 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE CH-PREMISE-NO                TO AT-PREMISE-NO        
              PERFORM 7635-LATEST-PENDING-ACCT THRU 7635-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                MOVE    0                       TO RS-ACTIVE-CUST-NO    
                MOVE    0                       TO RS-ACTIVE-ACCT-NO    
              ELSE                                                      
                MOVE  0                         TO RS-ACTIVE-CUST-NO    
                MOVE  AT-ACCOUNT-NO             TO RS-ACTIVE-ACCT-NO    
                IF AT-CUSTOMER-NO NOT NUMERIC                           
                   MOVE 0 TO RS-ACTIVE-CUST-NO                          
                   MOVE 0 TO RS-ACTIVE-ACCT-NO                          
                END-IF                                                  
              END-IF                                                    
           ELSE                                                         
              MOVE    CH-CUSTOMER-NO            TO RS-ACTIVE-CUST-NO    
              MOVE    CH-ACCOUNT-NO             TO RS-ACTIVE-ACCT-NO    
              IF CH-CUSTOMER-NO NOT NUMERIC                             
                 MOVE 0 TO RS-ACTIVE-CUST-NO                            
                 MOVE 0 TO RS-ACTIVE-ACCT-NO                            
              END-IF                                                    
           END-IF.                                                      
           MOVE SPACES TO RS-ACTIVE-CUST-NAME                           
           IF RS-ACTIVE-CUST-NO > 0  THEN                               
              MOVE RS-ACTIVE-CUST-NO    TO CU-CUSTOMER-NO               
              PERFORM 7300-GET-NAME     THRU 7300-EXIT                  
              MOVE WS-CUSTOMER-NAME     TO RS-ACTIVE-CUST-NAME          
           END-IF                                                       
                                                                        
           MOVE  0  TO  WS-SET-ORDER-COUNT.                             
           MOVE 'N' TO  WS-IS-SET-PENDING.                              
           MOVE 'N' TO RS-IS-SET-PENDING.                               
           PERFORM 7650-SELECT-PENDING-SET      THRU 7650-EXIT.         
           IF WS-SET-ORDER-COUNT > 0                                    
              MOVE    'Y'                       TO RS-IS-SET-PENDING    
              MOVE    'Y'                       TO WS-IS-SET-PENDING    
           END-IF.                                                      
                                                                        
           PERFORM 7000-OPEN-SERV-LINE-CUR              THRU 7000-EXIT. 
           PERFORM 7100-FETCH-SERV-LINE-CUR             THRU 7100-EXIT. 
                                                                        
           PERFORM                                                      
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
                                                                        
              MOVE Y0-SERVICE-NO              TO XX-SERVICE-NO          
              MOVE 'I'                        TO WS-INSTALL-TYPE-CD     
              IF Y0-SERVICE-NO < 1000000000 OR Y0-SERVICE-NO>2000000000 
PR104 *          *PERFORM 7666-CHECK-MULTIBAR-PREMISE THRU 7666-EXIT            
PR104 *          *IF WS-PREMISE-NO > 0                                          
PR104 *          *   MOVE VO-PREMISE-NO TO WS-PREMISE-BF                        
PR104 *          *   MOVE WS-PREMISE-NO TO VO-PREMISE-NO                        
PR104 *          *   MOVE WS-PREMISE-NO TO YV-PREMISE-NO                        
PR104 *          *   MOVE 0             TO WS-PREMISE-NO                        
PR104 *          *END-IF                                                        
A2096 *          *PERFORM 7610-SELECT-SO-DATA         THRU 7610-EXIT            
A2096             PERFORM 7670-SELECT-SO-NO-INS       THRU 7670-EXIT    
                  IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
A2096                MOVE 0                      TO RS-SERV-ORDER-NO    
A2096 *             *PERFORM 7620-SELECT-SO-DATA-HST THRU 7620-EXIT             
A2096 *             *IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
A2096 *             *   MOVE 0                      TO RS-SERV-ORDER-NO         
A2096 *             *ELSE                                                       
A2096 *             *   MOVE YV-SERV-ORDER-NO       TO RS-SERV-ORDER-NO         
A2096 *             *END-IF                                                     
                  ELSE                                                  
A2096 *             *MOVE VO-SERV-ORDER-NO          TO RS-SERV-ORDER-NO         
A2096                MOVE XX-SERV-ORDER-NO          TO RS-SERV-ORDER-NO 
A0432                IF WS-FLG-ORDER-NO = ' '                           
A0432                 MOVE XX-SERV-ORDER-NO          TO VO-SERV-ORDER-NO
A0432                 PERFORM 7675-SELECT-VW-CSS-ORD-FLG THRU 7675-EXIT 
A0432                END-IF                                             
A0432                IF WS-FLG-ORDER-NO = ' '                           
A0432                 MOVE XX-SERV-ORDER-NO          TO YV-SERV-ORDER-NO
A0432                 PERFORM 7676-SELECT-VW-HST-ORD-FLG THRU 7676-EXIT 
A0432                END-IF                                             
                  END-IF                                                
PR104 *          * IF WS-PREMISE-BF > 0                                         
PR104 *          *    MOVE WS-PREMISE-BF TO VO-PREMISE-NO                       
PR104 *          *    MOVE WS-PREMISE-BF TO YV-PREMISE-NO                       
PR104 *          *    MOVE 0             TO WS-PREMISE-BF                       
PR104 *          * END-IF                                                       
              ELSE                                                      
                  MOVE 0                            TO RS-SERV-ORDER-NO 
              END-IF                                                    
              MOVE 'R'                            TO WS-INSTALL-TYPE-CD 
PR104 *       *PERFORM 7666-CHECK-MULTIBAR-PREMISE THRU 7666-EXIT               
PR104 *       *IF WS-PREMISE-NO > 0                                             
PR104 *       *   MOVE VO-PREMISE-NO TO WS-PREMISE-BF                           
PR104 *       *   MOVE WS-PREMISE-NO TO VO-PREMISE-NO                           
PR104 *       *   MOVE WS-PREMISE-NO TO YV-PREMISE-NO                           
PR104 *       *   MOVE 0             TO WS-PREMISE-NO                           
PR104 *       *END-IF                                                           
A2096 *       *PERFORM 7615-SELECT-SO-DATA-RET     THRU 7615-EXIT               
A2096         PERFORM 7672-SELECT-SO-NO-RET       THRU 7672-EXIT        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A2096             MOVE 0                      TO RS-RETIRE-ORDER-NO     
A2096 *      *    PERFORM 7625-SELECT-SO-DATA-HST-RET THRU 7625-EXIT            
A2096 *      *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                          
A2096 *      *       MOVE 0                      TO RS-RETIRE-ORDER-NO          
A2096 *      *    ELSE                                                          
A2096 *      *       MOVE YV-SERV-ORDER-NO       TO RS-RETIRE-ORDER-NO          
A2096 *      *    END-IF                                                        
              ELSE                                                      
A2096 *           MOVE VO-SERV-ORDER-NO          TO RS-RETIRE-ORDER-NO          
                  MOVE XX-SERV-ORDER-NO          TO RS-RETIRE-ORDER-NO  
A0432             IF WS-FLG-ORDER-NO = ' '                              
A0432                MOVE XX-SERV-ORDER-NO          TO VO-SERV-ORDER-NO 
A0432                PERFORM 7675-SELECT-VW-CSS-ORD-FLG THRU 7675-EXIT  
A0432             END-IF                                                
A0432             IF WS-FLG-ORDER-NO = ' '                              
A0432                MOVE XX-SERV-ORDER-NO          TO YV-SERV-ORDER-NO 
A0432                PERFORM 7676-SELECT-VW-HST-ORD-FLG THRU 7676-EXIT  
A0432             END-IF                                                
              END-IF                                                    
PR104 *       *IF WS-PREMISE-BF > 0                                             
PR104 *       *   MOVE WS-PREMISE-BF TO VO-PREMISE-NO                           
PR104 *       *   MOVE WS-PREMISE-BF TO YV-PREMISE-NO                           
PR104 *       *   MOVE 0             TO WS-PREMISE-BF                           
PR104 *       *END-IF                                                           
              MOVE 'V'                            TO WS-INSTALL-TYPE-CD 
A2096 *      *PERFORM 7616-SELECT-SO-DATA-REV     THRU 7616-EXIT                
A2096         PERFORM 7674-SELECT-SO-NO-REV       THRU 7674-EXIT        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
A2096             MOVE 0                      TO RS-REVERSE-ORDER-NO    
A2096 *        *  PERFORM 7626-SELECT-SO-DATA-HST-REV THRU 7626-EXIT            
A2096 *        *  IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                          
A2096 *        *     MOVE 0                      TO RS-REVERSE-ORDER-NO         
A2096 *        *  ELSE                                                          
A2096 *        *     MOVE YV-SERV-ORDER-NO       TO RS-REVERSE-ORDER-NO         
A2096 *        *  END-IF                                                        
              ELSE                                                      
A2096 *       *   MOVE VO-SERV-ORDER-NO          TO RS-REVERSE-ORDER-NO         
A2096             MOVE XX-SERV-ORDER-NO          TO RS-REVERSE-ORDER-NO 
A0432             IF WS-FLG-ORDER-NO = ' '                              
A0432                MOVE XX-SERV-ORDER-NO          TO VO-SERV-ORDER-NO 
A0432                PERFORM 7675-SELECT-VW-CSS-ORD-FLG THRU 7675-EXIT  
A0432             END-IF                                                
A0432             IF WS-FLG-ORDER-NO = ' '                              
A0432                MOVE XX-SERV-ORDER-NO          TO YV-SERV-ORDER-NO 
A0432                PERFORM 7676-SELECT-VW-HST-ORD-FLG THRU 7676-EXIT  
A0432             END-IF                                                
              END-IF                                                    
              MOVE ' ' TO  WS-MATL-POSTED-FL                            
              MOVE ' ' TO  RS-MATL-POSTED-FL                            
              IF (RS-SERV-ORDER-NO > 0) AND (XO-SERV-LINE-STAT-FL = 'P')
                  PERFORM 7660-SELECT-MATL-POSTED-FL  THRU 7660-EXIT    
                  IF WS-MATL-POSTED-FL = 'Y'                            
                       MOVE    'Y'               TO RS-MATL-POSTED-FL   
                  END-IF                                                
              END-IF                                                    
              IF WS-BUILDER-ADDR-ID-NI < 0                              
                 MOVE 0 TO Y0-BUILDER-ADDR-ID                           
              END-IF                                                    
              IF WS-CUSTOMER-NO-NI < 0                                  
                 MOVE 0 TO Y0-CUSTOMER-NO                               
              END-IF                                                    
              IF WS-BUILDER-CUST-NO-NI < 0                              
                 MOVE 0 TO Y0-BUILDER-CUST-NO                           
              END-IF                                                    
              IF WS-SERV-AGREE-AMT-NI < 0                               
                 MOVE 0 TO Y0-SERV-AGREE-AMT                            
              END-IF                                                    
              IF WS-SERV-AGREE-DT-NI < 0                                
                 MOVE SPACES TO Y0-SERV-AGREE-DT                        
              END-IF                                                    
              IF WS-SERV-LINE-LENGTH-NI < 0                             
                 MOVE 0 TO XO-SERV-LINE-LENGTH                          
              END-IF                                                    
              IF WS-SERV-LINE-LEN-RTD-NI < 0                            
                 MOVE 0 TO XO-SERV-LINE-LEN-RTD                         
              END-IF                                                    
              IF WS-TOTAL-BTU-NI < 0                                    
A3355            MOVE 0 TO Y0-TOTAL-BTU                                 
              END-IF                                                    
***********   IF WS-SVC-LINE-INSTALL-DT-NI < 0                                  
***********      MOVE 0 TO XO-SVC-LINE-INSTALL-DT                               
***********   END-IF                                                            
              IF WS-SVC-LINE-RETIRE-DT-NI < 0                           
                 MOVE SPACES TO XO-SVC-LINE-RETIRE-DT                   
               END-IF                                                   
              IF WS-METER-PRESSURE-NI < 0                               
A3355            MOVE 0 TO Y0-METER-PRESSURE                            
               END-IF                                                   
               MOVE 'N'  TO  WS-IS-MULTIBAR                             
               MOVE  0   TO  WS-MULTIMETER-COUNT                        
               PERFORM 7640-CHECK-MULTIBAR              THRU 7640-EXIT  
               IF WS-MULTIMETER-COUNT > 1                               
                  MOVE 'Y' TO WS-IS-MULTIBAR                            
               END-IF                                                   
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7100-FETCH-SERV-LINE-CUR         THRU 7100-EXIT  
           END-PERFORM.                                                 
           PERFORM 7200-CLOSE-SERV-LINE-CUR             THRU 7200-EXIT. 
           IF CTR-ROWS = 0 THEN                                         
              MOVE    100                       TO RS-RETURN-CODE       
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-PROCESS-ROW                                               *        
      *     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *        
      *     FORMAT RESULT SET AND SEND DATA.                           *        
      ******************************************************************        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           IF Y0-CUSTOMER-NO NOT NUMERIC                                
              MOVE 0 TO Y0-CUSTOMER-NO                                  
           END-IF                                                       
           MOVE SPACES TO RS-CUSTOMER-NAME                              
           IF Y0-CUSTOMER-NO > 0  THEN                                  
              MOVE Y0-CUSTOMER-NO       TO CU-CUSTOMER-NO               
              PERFORM 7300-GET-NAME     THRU 7300-EXIT                  
              MOVE WS-CUSTOMER-NAME     TO RS-CUSTOMER-NAME             
           END-IF                                                       
           IF Y0-BUILDER-CUST-NO NOT NUMERIC                            
              MOVE 0 TO Y0-BUILDER-CUST-NO                              
           END-IF                                                       
           MOVE SPACES TO RS-BUILDER-NAME                               
           IF Y0-BUILDER-CUST-NO > 0  THEN                              
              MOVE Y0-BUILDER-CUST-NO   TO CU-CUSTOMER-NO               
              PERFORM 7300-GET-NAME     THRU 7300-EXIT                  
              MOVE WS-CUSTOMER-NAME     TO RS-BUILDER-NAME              
           END-IF                                                       
           IF Y0-BUILDER-ADDR-ID NOT NUMERIC                            
              MOVE 0 TO Y0-BUILDER-ADDR-ID                              
           END-IF                                                       
           MOVE SPACES TO RS-ADDRESS                                    
           IF Y0-BUILDER-ADDR-ID > 0                                    
              MOVE Y0-BUILDER-ADDR-ID TO DY-ADDRESS-ID                  
              PERFORM 7400-GET-ADDRESS THRU 7400-EXIT                   
              MOVE WS-ADDRESS          TO RS-ADDRESS                    
           END-IF                                                       
           MOVE   A9-MUNICIPALITY-IND     TO RS-MUNICIPALITY-IND        
           MOVE   Y0-SERVICE-NO           TO RS-SERVICE-NO              
           MOVE   Y0-STRUCTURE-TYPE-CD    TO RS-STRUCTURE-TYPE-CD       
           MOVE   Y0-STRUCTURE-CD         TO RS-STRUCTURE-CD            
           MOVE   Y0-SALES-REP-ID         TO RS-SALES-REP-ID            
           MOVE   Y0-BUILDER-ADDR-ID      TO RS-BUILDER-ADDR-ID         
           MOVE   Y0-CUSTOMER-NO          TO RS-CUSTOMER-NO             
           MOVE   Y0-BUILDER-CUST-NO      TO RS-BUILDER-CUST-NO         
           MOVE   Y0-SERV-AGREE-AMT       TO RS-SERV-AGREE-AMT          
           MOVE   Y0-SERV-AGREE-DT        TO RS-SERV-AGREE-DT           
           MOVE   Y0-SERV-OWNER-CD        TO RS-SERV-OWNER-CD           
           MOVE   Y0-INSTALL-PREM-FL      TO RS-INSTALL-PREM-FL         
A3355      MOVE   Y0-METER-PRESSURE       TO RS-METER-PRESSURE          
           MOVE   XO-SERV-LINE-TYPE       TO RS-SERV-LINE-TYPE          
           MOVE   XO-SERV-LINE-SIZE       TO RS-SERV-LINE-SIZE          
           MOVE   XO-SERV-LINE-LENGTH     TO RS-SERV-LINE-LENGTH        
           MOVE   XO-SERV-LINE-TYPE-RTD   TO RS-SERV-LINE-TYPE-RTD      
           MOVE   XO-SERV-LINE-SIZE-RTD   TO RS-SERV-LINE-SIZE-RTD      
           MOVE   XO-SERV-LINE-LEN-RTD    TO RS-SERV-LINE-LEN-RTD       
           MOVE   XO-INSTALL-TYPE-CD      TO RS-INSTALL-TYPE-CD         
A3355      MOVE   Y0-TOTAL-BTU            TO RS-TOTAL-BTU               
           MOVE   XO-SPLIT-SERV-FL        TO RS-SPLIT-SERV-FL           
           MOVE   XO-XS-FLOW-VALVE-FL     TO RS-XS-FLOW-VALVE-FL        
           MOVE   XO-FARM-TAP-IND         TO RS-FARM-TAP-IND            
           MOVE   XO-SVC-LINE-INSTALL-DT  TO RS-SVC-LINE-INSTALL-DT     
           MOVE   XO-SVC-LINE-RETIRE-DT   TO RS-SVC-LINE-RETIRE-DT      
           MOVE   XO-SERV-LINE-STAT-FL    TO RS-SERV-LINE-STAT-FL       
           MOVE   XO-LAST-UPDATE-TS       TO RS-LAST-UPDATE-TS          
           MOVE   WS-IS-MULTIBAR          TO RS-IS-MULTIBAR             
           MOVE   WS-IS-SET-PENDING       TO RS-IS-SET-PENDING          
           MOVE   WS-MATL-POSTED-FL       TO RS-MATL-POSTED-FL          
           MOVE   0                       TO RS-RETURN-CODE             
           EVALUATE     XO-SERV-LINE-STAT-FL                            
             WHEN ' '   MOVE '0'          TO RS-ORDER-BY-SEQ            
             WHEN 'U'   MOVE '1'          TO RS-ORDER-BY-SEQ            
             WHEN 'I'   MOVE '1'          TO RS-ORDER-BY-SEQ            
             WHEN 'P'   MOVE '2'          TO RS-ORDER-BY-SEQ            
             WHEN 'A'   MOVE '3'          TO RS-ORDER-BY-SEQ            
             WHEN 'T'   MOVE '4'          TO RS-ORDER-BY-SEQ            
             WHEN 'V'   MOVE '5'          TO RS-ORDER-BY-SEQ            
             WHEN 'R'   MOVE '6'          TO RS-ORDER-BY-SEQ            
             WHEN OTHER MOVE '9'          TO RS-ORDER-BY-SEQ            
           END-EVALUATE                                                 
A0432         MOVE WS-FLG-ORDER-NO TO  RS-VIEW-ORDER-FL                 
I01400        MOVE Y0-FUEL-CONV-TYPE-CD   TO RS-FUEL-CONV-TYPE-CD       
I01400        MOVE Y0-FUEL-CONV-COMMENT   TO RS-FUEL-CONV-COMMENT       
I01400        PERFORM 7677-GET-UPDATE-DT  THRU 7677-EXIT                
I01400        MOVE 'N'                    TO RS-FUEL-UPDATE-FL          
I01400        IF (XO-SERV-LINE-STAT-FL = 'A' AND                        
I01400           XO-SVC-LINE-INSTALL-DT > WS-PARM-DATE) OR              
I01400           XO-SERV-LINE-STAT-FL = 'P' OR                          
I01400           XO-SERV-LINE-STAT-FL = ' '                             
I01400           MOVE 'Y'                 TO RS-FUEL-UPDATE-FL          
I01400        END-IF                                                    
           PERFORM 8100-SEND-RESULT    THRU 8100-EXIT.                  
A0432         MOVE ' '             TO  RS-VIEW-ORDER-FL.                
A0432         MOVE ' '             TO  WS-FLG-ORDER-NO.                 
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE.                                      *        
      ******************************************************************        
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME               TO ABEND-PROGRAM.            
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-DETERMINE-REGION.                                         *        
      ******************************************************************        
                                                                        
       7000-OPEN-SERV-LINE-CUR.                                         
                                                                        
           EXEC SQL                                                     
              OPEN SERV_LINE_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'OPEN SERV_LINE_CUR'      TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE Y0-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SET-RED-FLAG.                                                      
      ******************************************************************        
                                                                        
       7100-FETCH-SERV-LINE-CUR.                                        
                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EXEC SQL                                                     
               FETCH SERV_LINE_CUR                                      
                INTO  :Y0-SERVICE-NO                                    
                     ,:Y0-STRUCTURE-TYPE-CD                             
                     ,:Y0-STRUCTURE-CD                                  
                     ,:Y0-SALES-REP-ID                                  
                     ,:Y0-BUILDER-ADDR-ID :WS-BUILDER-ADDR-ID-NI     
                     ,:Y0-CUSTOMER-NO :WS-CUSTOMER-NO-NI         
                     ,:Y0-BUILDER-CUST-NO :WS-BUILDER-CUST-NO-NI     
                     ,:Y0-SERV-AGREE-AMT :WS-SERV-AGREE-AMT-NI      
                     ,:Y0-SERV-AGREE-DT :WS-SERV-AGREE-DT-NI       
                     ,:Y0-SERV-OWNER-CD                                 
                     ,:Y0-INSTALL-PREM-FL                               
A3355                ,:Y0-METER-PRESSURE :WS-METER-PRESSURE-NI      
                     ,:XO-SERV-LINE-TYPE                                
                     ,:XO-SERV-LINE-SIZE                                
                     ,:XO-SERV-LINE-LENGTH :WS-SERV-LINE-LENGTH-NI    
                     ,:XO-INSTALL-TYPE-CD                               
A3355                ,:Y0-TOTAL-BTU :WS-TOTAL-BTU-NI           
                     ,:XO-SPLIT-SERV-FL                                 
                     ,:XO-XS-FLOW-VALVE-FL                              
                     ,:XO-FARM-TAP-IND                                  
                     ,:XO-SVC-LINE-INSTALL-DT :WS-SVC-LINE-INSTALL-DT-NI
                     ,:XO-SVC-LINE-RETIRE-DT :WS-SVC-LINE-RETIRE-DT-NI  
                     ,:XO-SERV-LINE-STAT-FL                             
                     ,:XO-LAST-UPDATE-TS                                
                     ,:XO-SERV-LINE-TYPE-RTD                            
                     ,:XO-SERV-LINE-SIZE-RTD                            
                     ,:XO-SERV-LINE-LEN-RTD :WS-SERV-LINE-LEN-RTD-NI   
I01400               ,:Y0-FUEL-CONV-TYPE-CD                             
I01400               ,:Y0-FUEL-CONV-COMMENT                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7100'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_GAS_SERV_LINE'   TO TABLE-1                    
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1            
               MOVE Y0-PREMISE-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CLOSE-SERV-LINE-CUR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE SERV_LINE_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7200'                    TO ACTIVE-PARAGRAPH       
               MOVE 'CLOSE '                  TO ABEND-FUNCTION         
               MOVE 'CSS_GAS_SERV_LINE'       TO TABLE-1                
               MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
               MOVE Y0-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-NAME.                                                          
      ******************************************************************        
                                                                        
       7300-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(LAST_NAME)) + ', ' + 
           LTRIM(RTRIM(FIRST_NAME)) + ' ' + LTRIM(RTRIM(MIDDLE_NAME
           )) + ' ' + LTRIM(RTRIM(TITLE_SUFFIX_1))),
              FULL_NAME                                         
                 INTO :WS-CUSTOMER-NAME                                 
                     ,:WS-FULL-NAME                                     
                 FROM CSS_CUSTOMER CU                                   
                     ,CSS_NAME DQ                                       
                 WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                 
                   AND CU.NAME_ID     = DQ.NAME_ID                      
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM( STRIP(LAST_NAME)   || ', ' ||                      
MFA-TR*                      STRIP(FIRST_NAME)  || ' '  ||                      
MFA-TR*                      STRIP(MIDDLE_NAME) || ' '  ||                      
MFA-TR*                      STRIP(TITLE_SUFFIX_1))                             
MFA-TR*              ,FULL_NAME                                                 
MFA-TR*          INTO :WS-CUSTOMER-NAME                                         
MFA-TR*              ,:WS-FULL-NAME                                             
MFA-TR*          FROM CSS_CUSTOMER CU                                           
MFA-TR*              ,CSS_NAME DQ                                               
MFA-TR*          WHERE CU.CUSTOMER_NO = :CU-CUSTOMER-NO                         
MFA-TR*            AND CU.NAME_ID     = DQ.NAME_ID                              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-CUSTOMER-NAME = ','                                
                  MOVE WS-FULL-NAME TO WS-CUSTOMER-NAME                 
               END-IF                                                   
           ELSE                                                         
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7300'               TO ACTIVE-PARAGRAPH       
                    MOVE 'SELECT'             TO ABEND-FUNCTION         
                    MOVE 'CSS_CUSTOMER   '    TO TABLE-1                
                    MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1        
                    MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-ADDRESS                                                        
      ******************************************************************        
                                                                        
       7400-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(A.HOUSE_NO) + ' ' + RTRIM(
           A.ADDR_PREFIX_1) + ' ' + RTRIM(A.ADDR_PREFIX_2) + ' ' + 
           RTRIM(A.STREET_NAME) + ' ' + RTRIM(A.STREET_SUFFIX) + ' ' + 
           RTRIM(A.STREET_LOCATION_1) + ' ' + RTRIM(A.STREET_LOCATION_2
           ) + ' ' + RTRIM(A.ADDR_SUFFIX) + ' ' + RTRIM(Z.TOWN) + 
           ' ' + RTRIM(Z.STATE) + ' ' + RTRIM(Z.ZIP_CODE) + '-' + 
           RTRIM(A.ZIP_CODE_PLUS_FOUR)                       
                 INTO :WS-ADDRESS                                       
                 FROM CSS_ADDR_FORMATTED  A,                            
                      CSS_ZIP_CODE        Z                             
                 WHERE A.ADDRESS_ID      = :DY-ADDRESS-ID   AND         
                       Z.ZIP_CODE        = A.ZIP_CODE       AND         
                       Z.ZIP_CODE_TOKEN  = A.ZIP_CODE_TOKEN             
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(A.HOUSE_NO) || ' ' ||                               
MFA-TR*               RTRIM(A.ADDR_PREFIX_1) || ' ' ||                          
MFA-TR*               RTRIM(A.ADDR_PREFIX_2) || ' ' ||                          
MFA-TR*               RTRIM(A.STREET_NAME) ||  ' ' ||                           
MFA-TR*               RTRIM(A.STREET_SUFFIX) || ' ' ||                          
MFA-TR*               RTRIM(A.STREET_LOCATION_1) || ' ' ||                      
MFA-TR*               RTRIM(A.STREET_LOCATION_2) || ' ' ||                      
MFA-TR*               RTRIM(A.ADDR_SUFFIX) || ' ' ||                            
MFA-TR*               RTRIM(Z.TOWN) || ' ' ||                                   
MFA-TR*               RTRIM(Z.STATE) || ' ' ||                                  
MFA-TR*               RTRIM(Z.ZIP_CODE) || '-' ||                               
MFA-TR*               RTRIM(A.ZIP_CODE_PLUS_FOUR)                               
MFA-TR*          INTO :WS-ADDRESS                                               
MFA-TR*          FROM CSS_ADDR_FORMATTED  A,                                    
MFA-TR*               CSS_ZIP_CODE        Z                                     
MFA-TR*          WHERE A.ADDRESS_ID      = :DY-ADDRESS-ID   AND                 
MFA-TR*                Z.ZIP_CODE        = A.ZIP_CODE       AND                 
MFA-TR*                Z.ZIP_CODE_TOKEN  = A.ZIP_CODE_TOKEN                     
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7400'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                     
               MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1             
               MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-ADDRESS-FREEFORM                                               
      ******************************************************************        
                                                                        
       7500-GET-ADDRESS-FREEFORM.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(ADDR_STREET) + ' ' + RTRIM(
           ADDR_CITY_STATE)                            
                 INTO :WS-ADDRESS                                       
                 FROM CSS_ADDR_FREEFORM                                 
                 WHERE ADDRESS_ID  = :DZ-ADDRESS-ID                     
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(ADDR_STREET) || ' ' ||                              
MFA-TR*               RTRIM(ADDR_CITY_STATE)                                    
MFA-TR*          INTO :WS-ADDRESS                                               
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*          WHERE ADDRESS_ID  = :DZ-ADDRESS-ID                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7500'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_ADDR_FREEFORM ' TO TABLE-1                     
               MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1             
               MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-SELECT-PREMISE                                                     
      ******************************************************************        
                                                                        
       7600-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CITY_GATE_ID,
              CROSS_STREET_1,
              CROSS_STREET_2,
              LOCATOR_ID,
              LOCAL_OFFICE,
              ZIP_CODE,
              MUNICIPALITY_IND                                  
                 INTO :PR-CITY-GATE-ID                                  
                     ,:PR-CROSS-STREET-1                                
                     ,:PR-CROSS-STREET-2                                
                     ,:PR-LOCATOR-ID                                    
                     ,:PR-LOCAL-OFFICE                                  
                     ,:DY-ZIP-CODE                                      
                     ,:A9-MUNICIPALITY-IND                              
                 FROM CSS_PREMISE      PR                               
                     ,CSS_REV_DISTRICT A9                               
                     ,CSS_ADDR_FORMATTED DY                             
                 WHERE PREMISE_NO         = :PR-PREMISE-NO              
                   AND PR.ADDRESS_ID      = DY.ADDRESS_ID               
                   AND PR.REV_DISTRICT_CD = A9.REV_DISTRICT_CD          
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CITY_GATE_ID                                              
MFA-TR*              ,CROSS_STREET_1                                            
MFA-TR*              ,CROSS_STREET_2                                            
MFA-TR*              ,LOCATOR_ID                                                
MFA-TR*              ,LOCAL_OFFICE                                              
MFA-TR*              ,ZIP_CODE                                                  
MFA-TR*              ,MUNICIPALITY_IND                                          
MFA-TR*          INTO :PR-CITY-GATE-ID                                          
MFA-TR*              ,:PR-CROSS-STREET-1                                        
MFA-TR*              ,:PR-CROSS-STREET-2                                        
MFA-TR*              ,:PR-LOCATOR-ID                                            
MFA-TR*              ,:PR-LOCAL-OFFICE                                          
MFA-TR*              ,:DY-ZIP-CODE                                              
MFA-TR*              ,:A9-MUNICIPALITY-IND                                      
MFA-TR*          FROM CSS_PREMISE      PR                                       
MFA-TR*              ,CSS_REV_DISTRICT A9                                       
MFA-TR*              ,CSS_ADDR_FORMATTED DY                                     
MFA-TR*          WHERE PREMISE_NO         = :PR-PREMISE-NO                      
MFA-TR*            AND PR.ADDRESS_ID      = DY.ADDRESS_ID                       
MFA-TR*            AND PR.REV_DISTRICT_CD = A9.REV_DISTRICT_CD                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 5000                 TO WS-ACTIVE-RETURN-CODE       
               MOVE 5000                 TO RS-RETURN-CODE              
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7600'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_PREMISE'        TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
               MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
A2096 ******************************************************************        
A2096 * 7610-SELECT-SO-DATA                                                     
A2096 ******************************************************************        
A2096 *                                                                         
A2096 *7610-SELECT-SO-DATA.                                                     
A2096 *                                                                         
A2096 *    EXEC SQL                                                             
A2096 *        SELECT VO.SERV_ORDER_NO                                          
A2096 *          INTO :VO-SERV-ORDER-NO                                         
A2096 *          FROM CSS_SO_DATA         VO                                    
A2096 *              ,CSS_SO_ORDER_INST   OI                                    
A2096 *              ,CSS_LINE_WORK_TYPE  XV                                    
A2096 *              ,CSS_GASLINE_SO_XRF  XX                                    
A2096 *          WHERE VO.PREMISE_NO         = :VO-PREMISE-NO                   
A2096 *            AND XX.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND VO.SERV_ORDER_NO      = XX.SERV_ORDER_NO                 
A2096 *            AND VO.ORDER_TYPE_CD      = XV.ORDER_TYPE_CD                 
A2096 *            AND VO.SERV_ORDER_NO      = OI.SERV_ORDER_NO                 
A2096 *            AND OI.WORK_TYPE_CD       = XV.WORK_TYPE_CD                  
A2096 *            AND OI.WORK_TYPE_CD       <> 'G67'                           
A2096 *            AND XV.INSTALL_TYPE_CD   IN ('I','P','S','T')                
A2096 *            AND XV.COMPANY_NO         = VO.COMPANY_NO                    
A2096 *            AND VO.ORDER_STATE_CD     <> 'C'                             
A2096 *         ORDER BY XV.INSTALL_TYPE_CD, VO.SERV_ORDER_NO ASC               
A2096 *         FETCH FIRST 1 ROWS ONLY                                         
A2096 *    END-EXEC.                                                            
A2096 *                                                                         
A2096 *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A2096 *    MOVE SQLCODE TO RS-RETURN-CODE.                                      
A2096 *                                                                         
A2096 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
A2096 *        NEXT SENTENCE                                                    
A2096 *    ELSE                                                                 
A2096 *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
A2096 *        MOVE '7610'               TO ACTIVE-PARAGRAPH                    
A2096 *        MOVE 'SELECT'             TO ABEND-FUNCTION                      
A2096 *        MOVE 'CSS_SO_DATA'        TO TABLE-1                             
A2096 *        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                     
A2096 *        MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1                   
A2096 *        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                    
A2096 *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                    
A2096 *    END-IF.                                                              
A2096 *                                                                         
A2096 *7610-EXIT.                                                               
A2096 *    EXIT.                                                                
A2096 *                                                                         
A2096 ******************************************************************        
A2096 * 7615-SELECT-SO-DATA-RET.                                                
A2096 ******************************************************************        
A2096 *                                                                         
A2096 *7615-SELECT-SO-DATA-RET.                                                 
A2096 *                                                                         
A2096 *    EXEC SQL                                                             
A2096 *        SELECT VO.SERV_ORDER_NO                                          
A2096 *          INTO :VO-SERV-ORDER-NO                                         
A2096 *          FROM CSS_SO_DATA         VO                                    
A2096 *              ,CSS_SO_ORDER_INST   OI                                    
A2096 *              ,CSS_LINE_WORK_TYPE  XV                                    
A2096 *              ,CSS_GASLINE_SO_XRF  XX                                    
A2096 *              ,CSS_GAS_SERV_LINE   GL                                    
A2096 *          WHERE VO.PREMISE_NO         = :VO-PREMISE-NO                   
A2096 *            AND XX.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERV_LINE_STAT_FL  IN ('T','R')                       
A2096 *            AND VO.SERV_ORDER_NO      = XX.SERV_ORDER_NO                 
A2096 *            AND VO.ORDER_TYPE_CD      = XV.ORDER_TYPE_CD                 
A2096 *            AND VO.SERV_ORDER_NO      = OI.SERV_ORDER_NO                 
A2096 *            AND OI.WORK_TYPE_CD       = XV.WORK_TYPE_CD                  
A2096 *            AND OI.WORK_TYPE_CD       <> 'G67'                           
A2096 *            AND XV.INSTALL_TYPE_CD    IN ('A','E','P')                   
A2096 *            AND XV.COMPANY_NO         = VO.COMPANY_NO                    
A2096 *            AND VO.ORDER_STATE_CD     <> 'C'                             
A2096 *         ORDER BY XV.INSTALL_TYPE_CD ASC, VO.SERV_ORDER_NO DESC          
A2096 *         FETCH FIRST 1 ROWS ONLY                                         
A2096 *    END-EXEC.                                                            
A2096 *                                                                         
A2096 *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A2096 *    MOVE SQLCODE TO RS-RETURN-CODE.                                      
A2096 *                                                                         
A2096 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
A2096 *        NEXT SENTENCE                                                    
A2096 *    ELSE                                                                 
A2096 *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
A2096 *        MOVE '7615'               TO ACTIVE-PARAGRAPH                    
A2096 *        MOVE 'SELECT'             TO ABEND-FUNCTION                      
A2096 *        MOVE 'CSS_SO_DATA'        TO TABLE-1                             
A2096 *        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                     
A2096 *        MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1                   
A2096 *        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                    
A2096 *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                    
A2096 *    END-IF.                                                              
A2096 *                                                                         
A2096 *7615-EXIT.                                                               
A2096 *    EXIT.                                                                
A2096 *                                                                         
A2096 ******************************************************************        
A2096 * 7616-SELECT-SO-DATA-REV.                                                
A2096 ******************************************************************        
A2096 *                                                                         
A2096 *7616-SELECT-SO-DATA-REV.                                                 
A2096 *                                                                         
A2096 *    EXEC SQL                                                             
A2096 *        SELECT VO.SERV_ORDER_NO                                          
A2096 *          INTO :VO-SERV-ORDER-NO                                         
A2096 *          FROM CSS_SO_DATA         VO                                    
A2096 *              ,CSS_SO_ORDER_INST   OI                                    
A2096 *              ,CSS_GASLINE_SO_XRF  XX                                    
A2096 *              ,CSS_GAS_SERV_LINE   GL                                    
A2096 *          WHERE VO.PREMISE_NO         = :VO-PREMISE-NO                   
A2096 *            AND XX.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERV_LINE_STAT_FL  = 'V'                              
A2096 *            AND VO.SERV_ORDER_NO      = XX.SERV_ORDER_NO                 
A2096 *            AND VO.SERV_ORDER_NO      = OI.SERV_ORDER_NO                 
A2096 *            AND OI.WORK_TYPE_CD       = 'G67'                            
A2096 *            AND VO.ORDER_STATE_CD     <> 'C'                             
A2096 *         FETCH FIRST 1 ROWS ONLY                                         
A2096 *    END-EXEC.                                                            
A2096 *                                                                         
A2096 *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A2096 *    MOVE SQLCODE TO RS-RETURN-CODE.                                      
A2096 *                                                                         
A2096 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
A2096 *        NEXT SENTENCE                                                    
A2096 *    ELSE                                                                 
A2096 *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
A2096 *        MOVE '7616'               TO ACTIVE-PARAGRAPH                    
A2096 *        MOVE 'SELECT'             TO ABEND-FUNCTION                      
A2096 *        MOVE 'CSS_SO_DATA'        TO TABLE-1                             
A2096 *        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                     
A2096 *        MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1                   
A2096 *        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                    
A2096 *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                    
A2096 *    END-IF.                                                              
A2096 *                                                                         
A2096 *7616-EXIT.                                                               
A2096 *    EXIT.                                                                
A2096 *                                                                         
A2096 ******************************************************************        
A2096 * 7620-SELECT-SO-DATA-HST.                                                
A2096 ******************************************************************        
A2096 *                                                                         
A2096 *7620-SELECT-SO-DATA-HST.                                                 
A2096 *                                                                         
A2096 *    EXEC SQL                                                             
A2096 *        SELECT YV.SERV_ORDER_NO                                          
A2096 *          INTO :YV-SERV-ORDER-NO                                         
A2096 *          FROM HST_SO_DATA         YV                                    
A2096 *              ,CSS_LINE_WORK_TYPE  XV                                    
A2096 *              ,HST_SO_ORDER_INST   OI                                    
A2096 *              ,CSS_GASLINE_SO_XRF  XX                                    
A2096 *          WHERE YV.PREMISE_NO         = :YV-PREMISE-NO                   
A2096 *            AND XX.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND YV.SERV_ORDER_NO      = XX.SERV_ORDER_NO                 
A2096 *            AND YV.ORDER_TYPE_CD      = XV.ORDER_TYPE_CD                 
A2096 *            AND YV.SERV_ORDER_NO      = OI.SERV_ORDER_NO                 
A2096 *            AND OI.WORK_TYPE_CD       = XV.WORK_TYPE_CD                  
A2096 *            AND OI.WORK_TYPE_CD       <> 'G67'                           
A2096 *            AND XV.INSTALL_TYPE_CD    IN ('I','P','S','T')               
A2096 *            AND XV.COMPANY_NO         = YV.COMPANY_NO                    
A2096 *            AND YV.ORDER_STATE_CD     <> 'C'                             
A2096 *         ORDER BY XV.INSTALL_TYPE_CD, YV.SERV_ORDER_NO ASC               
A2096 *         FETCH FIRST 1 ROWS ONLY                                         
A2096 *    END-EXEC.                                                            
A2096 *                                                                         
A2096 *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A2096 *    MOVE SQLCODE TO RS-RETURN-CODE.                                      
A2096 *                                                                         
A2096 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
A2096 *        NEXT SENTENCE                                                    
A2096 *    ELSE                                                                 
A2096 *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
A2096 *        MOVE '7620'               TO ACTIVE-PARAGRAPH                    
A2096 *        MOVE 'SELECT'             TO ABEND-FUNCTION                      
A2096 *        MOVE 'HST_SO_DATA'        TO TABLE-1                             
A2096 *        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                     
A2096 *        MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1                   
A2096 *        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                    
A2096 **       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                    
A2096 *    END-IF.                                                              
A2096 **                                                                        
A2096 *7620-EXIT.                                                               
A2096 *    EXIT.                                                                
A2096 *                                                                         
A2096 ******************************************************************        
A2096 * 7625-SELECT-SO-DATA-HST-RET.                                            
A2096 ******************************************************************        
A2096 *                                                                         
A2096 *7625-SELECT-SO-DATA-HST-RET.                                             
A2096 *                                                                         
A2096 *    EXEC SQL                                                             
A2096 *        SELECT YV.SERV_ORDER_NO                                          
A2096 *          INTO :YV-SERV-ORDER-NO                                         
A2096 *          FROM HST_SO_DATA         YV                                    
A2096 *              ,CSS_LINE_WORK_TYPE  XV                                    
A2096 *              ,HST_SO_ORDER_INST   OI                                    
A2096 *              ,CSS_GASLINE_SO_XRF  XX                                    
A2096 *              ,CSS_GAS_SERV_LINE   GL                                    
A2096 *          WHERE YV.PREMISE_NO         = :YV-PREMISE-NO                   
A2096 *            AND XX.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERV_LINE_STAT_FL  IN ('T','R')                       
A2096 *            AND YV.SERV_ORDER_NO      = XX.SERV_ORDER_NO                 
A2096 *            AND YV.ORDER_TYPE_CD      = XV.ORDER_TYPE_CD                 
A2096 *            AND YV.SERV_ORDER_NO      = OI.SERV_ORDER_NO                 
A2096 *            AND OI.WORK_TYPE_CD       = XV.WORK_TYPE_CD                  
A2096 *            AND OI.WORK_TYPE_CD       <> 'G67'                           
A2096 *            AND XV.INSTALL_TYPE_CD    IN ('A','E','P')                   
A2096 *            AND XV.COMPANY_NO         = YV.COMPANY_NO                    
A2096 *            AND YV.ORDER_STATE_CD     <> 'C'                             
A2096 *         ORDER BY XV.INSTALL_TYPE_CD ASC, YV.SERV_ORDER_NO DESC          
A2096 *         FETCH FIRST 1 ROWS ONLY                                         
A2096 *    END-EXEC.                                                            
A2096 *                                                                         
A2096 *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A2096 *    MOVE SQLCODE TO RS-RETURN-CODE.                                      
A2096 *                                                                         
A2096 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
A2096 *        NEXT SENTENCE                                                    
A2096 *    ELSE                                                                 
A2096 *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
A2096 *        MOVE '7625'               TO ACTIVE-PARAGRAPH                    
A2096 *        MOVE 'SELECT'             TO ABEND-FUNCTION                      
A2096 *        MOVE 'HST_SO_DATA'        TO TABLE-1                             
A2096 *        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                     
A2096 *        MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1                   
A2096 *        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                    
A2096 *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                    
A2096 *    END-IF.                                                              
A2096 *                                                                         
A2096 *7625-EXIT.                                                               
A2096 *    EXIT.                                                                
A2096 *                                                                         
A2096 *                                                                         
A2096 ******************************************************************        
A2096 * 7626-SELECT-SO-DATA-HST-REV.                                            
A2096 ******************************************************************        
A2096 *                                                                         
A2096 *7626-SELECT-SO-DATA-HST-REV.                                             
A2096 *                                                                         
A2096 *    EXEC SQL                                                             
A2096 *        SELECT YV.SERV_ORDER_NO                                          
A2096 *          INTO :YV-SERV-ORDER-NO                                         
A2096 *          FROM HST_SO_DATA         YV                                    
A2096 *              ,HST_SO_ORDER_INST   OI                                    
A2096 *              ,CSS_GASLINE_SO_XRF  XX                                    
A2096 *              ,CSS_GAS_SERV_LINE   GL                                    
A2096 *          WHERE YV.PREMISE_NO         = :YV-PREMISE-NO                   
A2096 *            AND XX.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERVICE_NO         = :XX-SERVICE-NO                   
A2096 *            AND GL.SERV_LINE_STAT_FL  = 'V'                              
A2096 *            AND OI.WORK_TYPE_CD       = 'G67'                            
A2096 *            AND YV.SERV_ORDER_NO      = XX.SERV_ORDER_NO                 
A2096 *            AND YV.SERV_ORDER_NO      = OI.SERV_ORDER_NO                 
A2096 *            AND YV.ORDER_STATE_CD     <> 'C'                             
A2096 *         FETCH FIRST 1 ROWS ONLY                                         
A2096 *    END-EXEC.                                                            
A2096 *                                                                         
A2096 *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A2096 *    MOVE SQLCODE TO RS-RETURN-CODE.                                      
A2096 *                                                                         
A2096 *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
A2096 *        NEXT SENTENCE                                                    
A2096 *    ELSE                                                                 
A2096 *        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
A2096 *        MOVE '7626'               TO ACTIVE-PARAGRAPH                    
A2096 *        MOVE 'SELECT'             TO ABEND-FUNCTION                      
A2096 *        MOVE 'HST_SO_DATA'        TO TABLE-1                             
A2096 *        MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                     
A2096 *        MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1                   
A2096 *        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT                    
A2096 *        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT                    
A2096 *    END-IF.                                                              
A2096 *                                                                         
A2096 *7626-EXIT.                                                               
A2096 *    EXIT.                                                                
A2096 *                                                                         
     *******************************************************************        
      * 7630-SELECT-ACTIVE-CUSTOMER.                                            
      ******************************************************************        
                                                                        
       7630-SELECT-ACTIVE-CUSTOMER.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CH.CUSTOMER_NO,
              CH.ACCOUNT_NO                                     
                 INTO :CH-CUSTOMER-NO,                                  
                      :CH-ACCOUNT-NO                                    
                 FROM CSS_CUST_PREM_HIST  CH                            
                 WHERE CH.PREMISE_NO         = :CH-PREMISE-NO           
                   AND CH.DATE_UTIL_SVC_END  IS NULL                    
                 ORDER BY DATE_UTIL_SVC_STRT DESC                       
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CH.CUSTOMER_NO,                                           
MFA-TR*               CH.ACCOUNT_NO                                             
MFA-TR*          INTO :CH-CUSTOMER-NO,                                          
MFA-TR*               :CH-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_CUST_PREM_HIST  CH                                    
MFA-TR*          WHERE CH.PREMISE_NO         = :CH-PREMISE-NO                   
MFA-TR*            AND CH.DATE_UTIL_SVC_END  IS NULL                            
MFA-TR*          ORDER BY DATE_UTIL_SVC_STRT DESC                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7630'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
               MOVE CH-PREMISE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7635-LATEST-PENDING-ACCT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AT.CUSTOMER_NO,
              AT.ACCOUNT_NO                                     
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-ACCOUNT-NO                                    
                 FROM CSS_ACCOUNT AT                                    
                 WHERE AT.PREMISE_NO         = :AT-PREMISE-NO           
                 ORDER BY ACCT_CREATE_DT DESC                           
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CUSTOMER_NO,                                           
MFA-TR*               AT.ACCOUNT_NO                                             
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*          WHERE AT.PREMISE_NO         = :AT-PREMISE-NO                   
MFA-TR*          ORDER BY ACCT_CREATE_DT DESC                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7635'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
               MOVE AT-PREMISE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7635-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7640-CHECK-MULTIBAR.                                                    
      ******************************************************************        
                                                                        
       7640-CHECK-MULTIBAR.                                             
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(PREMISE_NO)                                 
                 INTO :WS-MULTIMETER-COUNT                              
                 FROM CSS_PREM_GAS_LINE                                 
                 WHERE SERVICE_NO         = :XX-SERVICE-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7640'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
PR104 ******************************************************************        
PR104 * 7666-CHECK-MULTIBAR-PREMISE.                                            
PR104 ******************************************************************        
PR104  7666-CHECK-MULTIBAR-PREMISE.                                     
PR104          PERFORM 7667-CHECK-MULTIBAR-PREMISE1 THRU 7667-EXIT      
PR104      IF WS-PCOUNT > 1                                             
PR104          PERFORM 7668-CHECK-MULTIBAR-PREMISE2 THRU 7668-EXIT      
PR104      END-IF                                                       
PR104      IF WS-PREMISE-NO > 0                                         
PR104          PERFORM 7669-CHECK-MULTIBAR-PREMISE3 THRU 7669-EXIT      
PR104      END-IF                                                       
PR104          MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                   
PR104          MOVE SQLCODE TO RS-RETURN-CODE.                          
PR104                                                                   
PR104      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PR104         NEXT SENTENCE                                             
PR104      ELSE                                                         
PR104          MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PR104          MOVE '7666'               TO ACTIVE-PARAGRAPH            
PR104          MOVE 'SELECT'             TO ABEND-FUNCTION              
PR104          MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-1                     
PR104          MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
PR104          MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
PR104          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PR104          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PR104      END-IF.                                                      
PR104                                                                   
PR104  7666-EXIT.                                                       
PR104      EXIT.                                                        
PR104 ******************************************************************        
PR104 * 7669-CHECK-MULTIBAR-PREMISE3.                                           
PR104 ******************************************************************        
PR104                                                                   
PR104  7669-CHECK-MULTIBAR-PREMISE3.                                    
PR104       EXEC SQL                                                    
PR104           SELECT TOP(1) PREMISE_NO INTO :WS-PREMISE-NO                  
PR104           FROM  CSS_PREM_GAS_LINE                                 
PR104           WHERE  SERVICE_NO = :XX-SERVICE-NO                      
PR104           AND  INSTALL_PREM_FL='Y'                                
PR104                                            
PR104       END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT  PREMISE_NO INTO :WS-PREMISE-NO                          
MFA-TR*         FROM  CSS_PREM_GAS_LINE                                         
MFA-TR*         WHERE  SERVICE_NO = :XX-SERVICE-NO                              
MFA-TR*         AND  INSTALL_PREM_FL='Y'                                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PR104      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PR104      MOVE SQLCODE TO RS-RETURN-CODE.                              
PR104                                                                   
PR104      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PR104          NEXT SENTENCE                                            
PR104      ELSE                                                         
PR104          MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PR104          MOVE '7669'               TO ACTIVE-PARAGRAPH            
PR104          MOVE 'SELECT'             TO ABEND-FUNCTION              
PR104          MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-1                     
PR104          MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
PR104          MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
PR104          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PR104          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PR104      END-IF.                                                      
PR104                                                                   
PR104  7669-EXIT.                                                       
PR104      EXIT.                                                        
PR104 ******************************************************************        
PR104 * 7668-CHECK-MULTIBAR-PREMISE2.                                           
PR104 ******************************************************************        
PR104  7668-CHECK-MULTIBAR-PREMISE2.                                    
PR104       EXEC SQL                                                    
PR104          SELECT  PREMISE_NO INTO :WS-PREMISE-NO                   
PR104            FROM  CSS_PREM_GAS_LINE                                
PR104            WHERE SERVICE_NO=:XX-SERVICE-NO                        
PR104              AND PREMISE_NO=:VO-PREMISE-NO                        
PR104              AND INSTALL_PREM_FL=''                               
PR104       END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PR104      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PR104      MOVE SQLCODE TO RS-RETURN-CODE.                              
PR104                                                                   
PR104      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PR104          NEXT SENTENCE                                            
PR104      ELSE                                                         
PR104          MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PR104          MOVE '7668'               TO ACTIVE-PARAGRAPH            
PR104          MOVE 'SELECT'             TO ABEND-FUNCTION              
PR104          MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-1                     
PR104          MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
PR104          MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
PR104          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PR104          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PR104      END-IF.                                                      
PR104                                                                   
PR104  7668-EXIT.                                                       
PR104      EXIT.                                                        
PR104 ******************************************************************        
PR104 * 7667-CHECK-MULTIBAR-PREMISE1.                                           
PR104 ******************************************************************        
PR104                                                                   
PR104  7667-CHECK-MULTIBAR-PREMISE1.                                    
PR104                                                                   
PR104      EXEC SQL                                                     
PR104           SELECT COUNT(PREMISE_NO)                                
PR104            INTO :WS-PCOUNT                                        
PR104            FROM CSS_PREM_GAS_LINE                                 
PR104           WHERE SERVICE_NO = :XX-SERVICE-NO                       
PR104      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PR104                                                                   
PR104      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PR104      MOVE SQLCODE TO RS-RETURN-CODE.                              
PR104                                                                   
PR104      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PR104        NEXT SENTENCE                                              
PR104      ELSE                                                         
PR104          MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
PR104          MOVE '7667'               TO ACTIVE-PARAGRAPH            
PR104          MOVE 'SELECT'             TO ABEND-FUNCTION              
PR104          MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-1                     
PR104          MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
PR104          MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
PR104          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PR104          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PR104      END-IF.                                                      
PR104                                                                   
PR104  7667-EXIT.                                                       
PR104      EXIT.                                                        
PR104                                                                   
      ******************************************************************        
      * 7650-SELECT-PENDING-SET                                                 
      ******************************************************************        
                                                                        
       7650-SELECT-PENDING-SET.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) COUNT(VO.SERV_ORDER_NO)                           
                 INTO :WS-SET-ORDER-COUNT                               
                 FROM CSS_SO_DATA         VO                            
                     ,CSS_SO_ORDER_INST   OI                            
                 WHERE VO.PREMISE_NO         = :YV-PREMISE-NO           
                   AND VO.ORDER_TYPE_CD      = 'FM002'                  
                   AND OI.SERV_ORDER_NO      = VO.SERV_ORDER_NO         
                   AND OI.WORK_TYPE_CD       = 'SET'                    
                   AND OI.CODE_UTIL_TYPE     = 'G'                      
P0104              AND VO.ORDER_STATE_CD     IN ('A','H','B','D','R')   
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(VO.SERV_ORDER_NO)                                   
MFA-TR*          INTO :WS-SET-ORDER-COUNT                                       
MFA-TR*          FROM CSS_SO_DATA         VO                                    
MFA-TR*              ,CSS_SO_ORDER_INST   OI                                    
MFA-TR*          WHERE VO.PREMISE_NO         = :YV-PREMISE-NO                   
MFA-TR*            AND VO.ORDER_TYPE_CD      = 'FM002'                          
MFA-TR*            AND OI.SERV_ORDER_NO      = VO.SERV_ORDER_NO                 
MFA-TR*            AND OI.WORK_TYPE_CD       = 'SET'                            
MFA-TR*            AND OI.CODE_UTIL_TYPE     = 'G'                              
MFA-TR*            AND VO.ORDER_STATE_CD     IN ('A','H','B','D','R')           
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7650'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_DATA'        TO TABLE-1                     
               MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1             
               MOVE YV-PREMISE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7660-SELECT-MATL-POSTED-FL                                              
      ******************************************************************        
                                                                        
       7660-SELECT-MATL-POSTED-FL.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) WU.MATL_POSTED_FL                                 
                 INTO :WS-MATL-POSTED-FL                                
                 FROM CSS_SO_MATL_TRAN    WU                            
                 WHERE WU.SERV_ORDER_NO      = :RS-SERV-ORDER-NO        
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WU.MATL_POSTED_FL                                         
MFA-TR*          INTO :WS-MATL-POSTED-FL                                        
MFA-TR*          FROM CSS_SO_MATL_TRAN    WU                                    
MFA-TR*          WHERE WU.SERV_ORDER_NO      = :RS-SERV-ORDER-NO                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7660'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_SO_MATL_TRAN'   TO TABLE-1                     
               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1             
               MOVE RS-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7670-SELECT-SO-NO-INS.  -A2096 CHANGES START                            
      ******************************************************************        
                                                                        
       7670-SELECT-SO-NO-INS.                                           
                                                                        
           MOVE 0 TO XX-SERV-ORDER-NO.                                  
           EXEC SQL                                                     
               SELECT TOP(1) XX.SERV_ORDER_NO                                  
                 INTO :XX-SERV-ORDER-NO                                 
                 FROM CSS_GASLINE_SO_XRF  XX                            
                 WHERE XX.SERVICE_NO         = :XX-SERVICE-NO           
                   AND XX.INSTALL_TYPE_CD   IN ('I','P','S','T')        
                ORDER BY XX.INSTALL_TYPE_CD, XX.SERV_ORDER_NO ASC       
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XX.SERV_ORDER_NO                                          
MFA-TR*          INTO :XX-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_GASLINE_SO_XRF  XX                                    
MFA-TR*          WHERE XX.SERVICE_NO         = :XX-SERVICE-NO                   
MFA-TR*            AND XX.INSTALL_TYPE_CD   IN ('I','P','S','T')                
MFA-TR*         ORDER BY XX.INSTALL_TYPE_CD, XX.SERV_ORDER_NO ASC               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7670'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_GASLINE_SO_XRF' TO TABLE-1                     
               MOVE 'SERVICE-NO'         TO TABLE-ELEMENT-1             
               MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7672-SELECT-SO-NO-RET.                                                  
      ******************************************************************        
                                                                        
       7672-SELECT-SO-NO-RET.                                           
                                                                        
           MOVE 0 TO XX-SERV-ORDER-NO.                                  
           EXEC SQL                                                     
               SELECT TOP(1) XX.SERV_ORDER_NO                                  
                 INTO :XX-SERV-ORDER-NO                                 
                 FROM CSS_GASLINE_SO_XRF  XX                            
                 WHERE XX.SERVICE_NO         = :XX-SERVICE-NO           
                   AND XX.INSTALL_TYPE_CD    IN ('A','E')               
                ORDER BY XX.INSTALL_TYPE_CD, XX.SERV_ORDER_NO ASC       
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XX.SERV_ORDER_NO                                          
MFA-TR*          INTO :XX-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_GASLINE_SO_XRF  XX                                    
MFA-TR*          WHERE XX.SERVICE_NO         = :XX-SERVICE-NO                   
MFA-TR*            AND XX.INSTALL_TYPE_CD    IN ('A','E')                       
MFA-TR*         ORDER BY XX.INSTALL_TYPE_CD, XX.SERV_ORDER_NO ASC               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7672'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_GASLINE_SO_XRF' TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7672-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7674-SELECT-SO-NO-REV.                                                  
      ******************************************************************        
                                                                        
       7674-SELECT-SO-NO-REV.                                           
                                                                        
           MOVE 0 TO XX-SERV-ORDER-NO.                                  
           EXEC SQL                                                     
               SELECT TOP(1) XX.SERV_ORDER_NO                                  
                 INTO :XX-SERV-ORDER-NO                                 
                 FROM CSS_GASLINE_SO_XRF  XX                            
                 WHERE XX.SERVICE_NO         = :XX-SERVICE-NO           
                   AND XX.INSTALL_TYPE_CD    = 'V'                      
                ORDER BY XX.INSTALL_TYPE_CD, XX.SERV_ORDER_NO ASC       
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XX.SERV_ORDER_NO                                          
MFA-TR*          INTO :XX-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_GASLINE_SO_XRF  XX                                    
MFA-TR*          WHERE XX.SERVICE_NO         = :XX-SERVICE-NO                   
MFA-TR*            AND XX.INSTALL_TYPE_CD    = 'V'                              
MFA-TR*         ORDER BY XX.INSTALL_TYPE_CD, XX.SERV_ORDER_NO ASC               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7674'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_GASLINE_SO_XRF' TO TABLE-1                     
               MOVE 'SERVICE_NO'         TO TABLE-ELEMENT-1             
               MOVE XX-SERVICE-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7674-EXIT.                                                       
           EXIT.                                                        
      ******************************************                                
      * A2096 CHANGES END                                                       
      ******************************************                                
                                                                        
      ******************************************************************        
A0432 * 7675-SELECT-VW-CSS-ORD-FLG. APPL0000432                                 
      ******************************************************************        
A0432                                                                   
A0432  7675-SELECT-VW-CSS-ORD-FLG.                                      
A0432                                                                   
A0432         EXEC SQL                                                  
A0432             SELECT 'Y'                                            
A0432               INTO :WS-FLG-ORDER-NO                               
A0432               FROM  CSS_SO_DATA                                   
A0432             WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO               
A0432               AND PREMISE_NO    = :VO-PREMISE-NO                  
A0432         END-EXEC.                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A0432         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
A0432         MOVE SQLCODE TO RS-RETURN-CODE                            
A0432         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
A0432               NEXT SENTENCE                                       
A0432         ELSE                                                      
A0432               MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
A0432               MOVE '7675'               TO ACTIVE-PARAGRAPH       
A0432               MOVE 'SELECT'             TO ABEND-FUNCTION         
A0432               MOVE 'CSS_SO_DATA'        TO TABLE-1                
A0432               MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1        
A0432               MOVE XX-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1      
A0432               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
A0432               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
A0432         END-IF.                                                   
A0432                                                                   
A0432  7675-EXIT.                                                       
A0432      EXIT.                                                        
      ******************************************************************        
A0432 * 7676-SELECT-VW-HST-ORD-FLG. APPL000432                                  
      ******************************************************************        
                                                                        
A0432  7676-SELECT-VW-HST-ORD-FLG.                                      
A0432          EXEC SQL                                                 
A0432             SELECT 'Y'                                            
A0432              INTO :WS-FLG-ORDER-NO                                
A0432              FROM HST_SO_DATA                                     
A0432              WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO              
A0432                AND PREMISE_NO    = :YV-PREMISE-NO                 
A0432          END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A0432          MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
A0432          MOVE SQLCODE TO RS-RETURN-CODE                           
                                                                        
A0432          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
A0432                NEXT SENTENCE                                      
A0432          ELSE                                                     
A0432                MOVE PROGRAM-NAME         TO ABEND-PROGRAM         
A0432                MOVE '7676'               TO ACTIVE-PARAGRAPH      
A0432                MOVE 'SELECT'             TO ABEND-FUNCTION        
A0432                MOVE 'HST_SO_DATA'        TO TABLE-1               
A0432                MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1       
A0432                MOVE XX-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1     
A0432                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
A0432                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
A0432         END-IF.                                                   
                                                                        
A0432  7676-EXIT.                                                       
A0432      EXIT.                                                        
      ******************************************************************        
I01400* 7677-GET-UPDATE-DT                                                      
I01400******************************************************************        
I01400                                                                  
I01400 7677-GET-UPDATE-DT.                                              
I01400      EXEC SQL                                                    
I01400             SELECT PARM_DATA                                     
I01400               INTO :G6-PARM-DATA                                 
I01400               FROM CSS_JOB_PARM                                  
I01400              WHERE PROGRAM_NAME = 'CSR04077'                     
I01400                AND COMPANY_NO   = '01'                           
I01400                AND CMND_CODE    = 'DATE'                         
I01400                AND SEQ_NO       = 10                             
I01400                AND STATUS       = 'A'                            
I01400      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01400      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
I01400      MOVE SQLCODE TO RS-RETURN-CODE                              
I01400                                                                  
I01400      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
I01400          MOVE G6-PARM-DATA(10:10) TO WS-PARM-DATE                
I01400      ELSE                                                        
I01400          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
I01400          MOVE '7677'               TO ACTIVE-PARAGRAPH           
I01400          MOVE 'SELECT'             TO ABEND-FUNCTION             
I01400          MOVE 'CSS_JOB_PARM'       TO TABLE-1                    
I01400          MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1            
I01400          MOVE XX-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1          
I01400          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
I01400          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
I01400      END-IF.                                                     
I01400                                                                  
I01400 7677-EXIT.                                                       
I01400     EXIT.                                                        
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                                    
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04077_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04077_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR04077_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT                                                         
      *************************************************************             
       8100-SEND-RESULT.                                                
 *                                                                      
            EXEC SQL                                                    
                 INSERT INTO #CSR04077_R1                        
                 (                                                      
                 RETURN_CODE                                            
                ,PREMISE_NO                                             
                ,CITY_GATE_ID                                           
                ,CROSS_STREET_1                                         
                ,CROSS_STREET_2                                         
                ,LOCATOR_ID                                             
                ,MUNICIPALITY_IND                                       
                ,SERVICE_NO                                             
                ,STRUCTURE_TYPE_CD                                      
                ,STRUCTURE_CD                                           
                ,SALES_REP_ID                                           
                ,BUILDER_ADDR_ID                                        
                ,CUSTOMER_NO                                            
                ,BUILDER_CUST_NO                                        
                ,SERV_AGREE_AMT                                         
                ,SERV_AGREE_DT                                          
                ,SERV_OWNER_CD                                          
                ,METER_PRESSURE                                         
                ,SERV_LINE_TYPE                                         
                ,SERV_LINE_SIZE                                         
                ,SERV_LINE_LENGTH                                       
                ,INSTALL_TYPE_CD                                        
                ,TOTAL_BTU                                              
                ,SPLIT_SERVICE                                          
                ,XS_FLOW_VALVE_FL                                       
                ,FARM_TAP_IND                                           
                ,SVC_LINE_INSTALL_DT                                    
                ,SVC_LINE_RETIRE_DT                                     
                ,SERV_LINE_STAT_FL                                      
                ,CUSTOMER_NAME                                          
                ,BUILDER_NAME                                           
                ,ADDRESS                                                
                ,LOCAL_OFFICE                                           
                ,ZIP_CODE                                               
                ,SERV_ORDER_NO                                          
                ,RETIRE_ORDER_NO                                        
                ,REVERSE_ORDER_NO                                       
                ,ACTIVE_ACCT_NO                                         
                ,ACTIVE_CUST_NO                                         
                ,ACTIVE_CUST_NAME                                       
                ,ORDER_BY_SEQ                                           
                ,IS_MULTIBAR                                            
                ,IS_SET_PENDING                                         
                ,MATL_POSTED_FL                                         
                ,LAST_UPDATE_TS                                         
                ,SERV_LINE_TYPE_RTD                                     
                ,SERV_LINE_SIZE_RTD                                     
                ,SERV_LINE_LEN_RTD                                      
PR104           ,INSTALL_PREM_FL                                        
                ,VIEW_ORDER_FL                                          
I01400          ,FUEL_CONV_TYPE_CD                                      
I01400          ,FUEL_CONV_COMMENT                                      
I01400          ,FUEL_UPDATE_FL                                         
                 )                                                      
                 VALUES                                                 
                 (                                                      
                 :RS-RETURN-CODE                                        
                ,:RS-PREMISE-NO                                         
                ,:RS-CITY-GATE-ID                                       
                ,:RS-CROSS-STREET-1                                     
                ,:RS-CROSS-STREET-2                                     
                ,:RS-LOCATOR-ID                                         
                ,:RS-MUNICIPALITY-IND                                   
                ,:RS-SERVICE-NO                                         
                ,:RS-STRUCTURE-TYPE-CD                                  
                ,:RS-STRUCTURE-CD                                       
                ,:RS-SALES-REP-ID                                       
                ,:RS-BUILDER-ADDR-ID                                    
                ,:RS-CUSTOMER-NO                                        
                ,:RS-BUILDER-CUST-NO                                    
                ,:RS-SERV-AGREE-AMT                                     
                ,:RS-SERV-AGREE-DT                                      
                ,:RS-SERV-OWNER-CD                                      
                ,:RS-METER-PRESSURE                                     
                ,:RS-SERV-LINE-TYPE                                     
                ,:RS-SERV-LINE-SIZE                                     
                ,:RS-SERV-LINE-LENGTH                                   
                ,:RS-INSTALL-TYPE-CD                                    
                ,:RS-TOTAL-BTU                                          
                ,:RS-SPLIT-SERV-FL                                      
                ,:RS-XS-FLOW-VALVE-FL                                   
                ,:RS-FARM-TAP-IND                                       
                ,IIF(TRY_CONVERT(DATE, :RS-SVC-LINE-INSTALL-DT
              ) IS NULL OR (PATINDEX('%.%', :RS-SVC-LINE-INSTALL-DT
              ) <> 0) OR (LEN(:RS-SVC-LINE-INSTALL-DT
              ) <> 10), CIS.CHAR2DATE(:RS-SVC-LINE-INSTALL-DT
              ), CONVERT(DATE, :RS-SVC-LINE-INSTALL-DT) )                      
                ,:RS-SVC-LINE-RETIRE-DT                                 
                ,:RS-SERV-LINE-STAT-FL                                  
                ,:RS-CUSTOMER-NAME                                      
                ,:RS-BUILDER-NAME                                       
                ,:RS-ADDRESS                                            
                ,:RS-LOCAL-OFFICE                                       
                ,:RS-ZIP-CODE                                           
                ,:RS-SERV-ORDER-NO                                      
                ,:RS-RETIRE-ORDER-NO                                    
                ,:RS-REVERSE-ORDER-NO                                   
                ,:RS-ACTIVE-ACCT-NO                                     
                ,:RS-ACTIVE-CUST-NO                                     
                ,:RS-ACTIVE-CUST-NAME                                   
                ,:RS-ORDER-BY-SEQ                                       
                ,:RS-IS-MULTIBAR                                        
                ,:RS-IS-SET-PENDING                                     
                ,:RS-MATL-POSTED-FL                                     
                ,:RS-LAST-UPDATE-TS                                     
                ,:RS-SERV-LINE-TYPE-RTD                                 
                ,:RS-SERV-LINE-SIZE-RTD                                 
                ,:RS-SERV-LINE-LEN-RTD                                  
PR104           ,:RS-INSTALL-PREM-FL                                    
                ,:RS-VIEW-ORDER-FL                                      
I01400          ,:RS-FUEL-CONV-TYPE-CD                                  
I01400          ,:RS-FUEL-CONV-COMMENT                                  
I01400          ,:RS-FUEL-UPDATE-FL                                     
                 )                                                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR04077_R1                                
MFA-TR*          (                                                              
MFA-TR*          RETURN_CODE                                                    
MFA-TR*         ,PREMISE_NO                                                     
MFA-TR*         ,CITY_GATE_ID                                                   
MFA-TR*         ,CROSS_STREET_1                                                 
MFA-TR*         ,CROSS_STREET_2                                                 
MFA-TR*         ,LOCATOR_ID                                                     
MFA-TR*         ,MUNICIPALITY_IND                                               
MFA-TR*         ,SERVICE_NO                                                     
MFA-TR*         ,STRUCTURE_TYPE_CD                                              
MFA-TR*         ,STRUCTURE_CD                                                   
MFA-TR*         ,SALES_REP_ID                                                   
MFA-TR*         ,BUILDER_ADDR_ID                                                
MFA-TR*         ,CUSTOMER_NO                                                    
MFA-TR*         ,BUILDER_CUST_NO                                                
MFA-TR*         ,SERV_AGREE_AMT                                                 
MFA-TR*         ,SERV_AGREE_DT                                                  
MFA-TR*         ,SERV_OWNER_CD                                                  
MFA-TR*         ,METER_PRESSURE                                                 
MFA-TR*         ,SERV_LINE_TYPE                                                 
MFA-TR*         ,SERV_LINE_SIZE                                                 
MFA-TR*         ,SERV_LINE_LENGTH                                               
MFA-TR*         ,INSTALL_TYPE_CD                                                
MFA-TR*         ,TOTAL_BTU                                                      
MFA-TR*         ,SPLIT_SERVICE                                                  
MFA-TR*         ,XS_FLOW_VALVE_FL                                               
MFA-TR*         ,FARM_TAP_IND                                                   
MFA-TR*         ,SVC_LINE_INSTALL_DT                                            
MFA-TR*         ,SVC_LINE_RETIRE_DT                                             
MFA-TR*         ,SERV_LINE_STAT_FL                                              
MFA-TR*         ,CUSTOMER_NAME                                                  
MFA-TR*         ,BUILDER_NAME                                                   
MFA-TR*         ,ADDRESS                                                        
MFA-TR*         ,LOCAL_OFFICE                                                   
MFA-TR*         ,ZIP_CODE                                                       
MFA-TR*         ,SERV_ORDER_NO                                                  
MFA-TR*         ,RETIRE_ORDER_NO                                                
MFA-TR*         ,REVERSE_ORDER_NO                                               
MFA-TR*         ,ACTIVE_ACCT_NO                                                 
MFA-TR*         ,ACTIVE_CUST_NO                                                 
MFA-TR*         ,ACTIVE_CUST_NAME                                               
MFA-TR*         ,ORDER_BY_SEQ                                                   
MFA-TR*         ,IS_MULTIBAR                                                    
MFA-TR*         ,IS_SET_PENDING                                                 
MFA-TR*         ,MATL_POSTED_FL                                                 
MFA-TR*         ,LAST_UPDATE_TS                                                 
MFA-TR*         ,SERV_LINE_TYPE_RTD                                             
MFA-TR*         ,SERV_LINE_SIZE_RTD                                             
MFA-TR*         ,SERV_LINE_LEN_RTD                                              
MFA-TR*         ,INSTALL_PREM_FL                                                
MFA-TR*         ,VIEW_ORDER_FL                                                  
MFA-TR*         ,FUEL_CONV_TYPE_CD                                              
MFA-TR*         ,FUEL_CONV_COMMENT                                              
MFA-TR*         ,FUEL_UPDATE_FL                                                 
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*          :RS-RETURN-CODE                                                
MFA-TR*         ,:RS-PREMISE-NO                                                 
MFA-TR*         ,:RS-CITY-GATE-ID                                               
MFA-TR*         ,:RS-CROSS-STREET-1                                             
MFA-TR*         ,:RS-CROSS-STREET-2                                             
MFA-TR*         ,:RS-LOCATOR-ID                                                 
MFA-TR*         ,:RS-MUNICIPALITY-IND                                           
MFA-TR*         ,:RS-SERVICE-NO                                                 
MFA-TR*         ,:RS-STRUCTURE-TYPE-CD                                          
MFA-TR*         ,:RS-STRUCTURE-CD                                               
MFA-TR*         ,:RS-SALES-REP-ID                                               
MFA-TR*         ,:RS-BUILDER-ADDR-ID                                            
MFA-TR*         ,:RS-CUSTOMER-NO                                                
MFA-TR*         ,:RS-BUILDER-CUST-NO                                            
MFA-TR*         ,:RS-SERV-AGREE-AMT                                             
MFA-TR*         ,:RS-SERV-AGREE-DT                                              
MFA-TR*         ,:RS-SERV-OWNER-CD                                              
MFA-TR*         ,:RS-METER-PRESSURE                                             
MFA-TR*         ,:RS-SERV-LINE-TYPE                                             
MFA-TR*         ,:RS-SERV-LINE-SIZE                                             
MFA-TR*         ,:RS-SERV-LINE-LENGTH                                           
MFA-TR*         ,:RS-INSTALL-TYPE-CD                                            
MFA-TR*         ,:RS-TOTAL-BTU                                                  
MFA-TR*         ,:RS-SPLIT-SERV-FL                                              
MFA-TR*         ,:RS-XS-FLOW-VALVE-FL                                           
MFA-TR*         ,:RS-FARM-TAP-IND                                               
MFA-TR*         ,:RS-SVC-LINE-INSTALL-DT                                        
MFA-TR*         ,:RS-SVC-LINE-RETIRE-DT                                         
MFA-TR*         ,:RS-SERV-LINE-STAT-FL                                          
MFA-TR*         ,:RS-CUSTOMER-NAME                                              
MFA-TR*         ,:RS-BUILDER-NAME                                               
MFA-TR*         ,:RS-ADDRESS                                                    
MFA-TR*         ,:RS-LOCAL-OFFICE                                               
MFA-TR*         ,:RS-ZIP-CODE                                                   
MFA-TR*         ,:RS-SERV-ORDER-NO                                              
MFA-TR*         ,:RS-RETIRE-ORDER-NO                                            
MFA-TR*         ,:RS-REVERSE-ORDER-NO                                           
MFA-TR*         ,:RS-ACTIVE-ACCT-NO                                             
MFA-TR*         ,:RS-ACTIVE-CUST-NO                                             
MFA-TR*         ,:RS-ACTIVE-CUST-NAME                                           
MFA-TR*         ,:RS-ORDER-BY-SEQ                                               
MFA-TR*         ,:RS-IS-MULTIBAR                                                
MFA-TR*         ,:RS-IS-SET-PENDING                                             
MFA-TR*         ,:RS-MATL-POSTED-FL                                             
MFA-TR*         ,:RS-LAST-UPDATE-TS                                             
MFA-TR*         ,:RS-SERV-LINE-TYPE-RTD                                         
MFA-TR*         ,:RS-SERV-LINE-SIZE-RTD                                         
MFA-TR*         ,:RS-SERV-LINE-LEN-RTD                                          
MFA-TR*         ,:RS-INSTALL-PREM-FL                                            
MFA-TR*         ,:RS-VIEW-ORDER-FL                                              
MFA-TR*         ,:RS-FUEL-CONV-TYPE-CD                                          
MFA-TR*         ,:RS-FUEL-CONV-COMMENT                                          
MFA-TR*         ,:RS-FUEL-UPDATE-FL                                             
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

 *                                                                      
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
 *                                                                      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR04077_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
 *                                                                      
        8100-EXIT.                                                      
            EXIT.                                                       
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00320                                                  
           END-EXEC.                                                            
