       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04074.                                          
       DATE-WRITTEN. DEC 12, 2007.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS CALLED BY THE CSR DESKTOP.                    *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL DB2 STORED PROCEDURE THAT RETRIVES    *        
      *  FORECAST DATES FOR ACTION ROWS IN PANEL 273                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  12/21/07  COVANSYS   INITIAL VERSION                          *        
P00799*  04/29/15  RC41079    CHANGE RETURN-CODE TO INTEGER DUE TO MOD *        
P00799*                       GIVING EXCEPTION WITH IT AS SMALLINT     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04074'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04074 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_HOLIDAY - J8 >                                                  
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_REG_PROFILE - LR >                                              
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_FW_FCST_ACTION - F8 >                                           
           EXEC SQL                                                             
              INCLUDE TBFWPDTL                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_FIN_WO_COLLECT - IZ >                                           
           EXEC SQL                                                             
              INCLUDE TBFWCLAG                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_FIN_WO_ACTION - KD >                                            
           EXEC SQL                                                             
              INCLUDE TBFWACTN                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_FINAL_WO - FW >                                                 
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
                                                                        
      *----< ERROR HANDLING >                                                   
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
                                                                        
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                             'SESSION.CSR04074_R1'.     
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-IS-RSP-AREA-NULL     PIC X(01) VALUE 'Y'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-ACTION-TYPE           PIC X(05)  VALUE SPACE.          
           05  S-FW-SEQ-NO             PIC S9(04) COMP VALUE 0.         
           05  S-ACTION-DATE           PIC X(10)  VALUE SPACE.          
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04074'.    
           05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           05  WS-ACCOUNT-NO-JST         PIC X(13) JUSTIFIED RIGHT.     
COB305     05 WS-ACCOUNT-NO-DEC        PIC S9(13) USAGE COMP-3 VALUE 0.       
           05  WS-ACTION-TYPE            PIC X(05).                     
           05  WS-PATH-TYPE-CD           PIC X(02).                     
           05  WS-FCST-PATH-TYPE-CD      PIC X(02).                     
           05  WS-IZ-ACTION-TYPE-CD      PIC X(05).                     
           05  WS-FW-SEQ-NO              PIC S9(04) COMP.               
           05  WS-ACTION-DATE            PIC X(10) VALUE SPACES.        
C30169     05  WS-PREV-ACTION-DATE       PIC X(10) VALUE SPACES.        
C30169     05  WS-DAY-COLLEC-NO-DAYS     PIC S9(4)V9(5) COMP-3 VALUE 0. 
C30169     05  WS-DAY                    PIC S9(04) COMP VALUE 0.       
C30169     05  WS-NO                     PIC X(01) VALUE 'N'.           
C30169     05  WS-YES                    PIC X(01) VALUE 'Y'.           
C30169     05  WS-EXISTS-FL              PIC X(01) VALUE ' '.           
C30169     05  WS-GOOD-COUNT             PIC S9(3) VALUE 0.             
C30169     05  WS-GOOD-WORKING-DAY       PIC X(01) VALUE 'N'.           
           05  WS-ORIG-ACTION-DT         PIC X(10) VALUE SPACES.        
           05  WS-WRITE-OFF-DATE         PIC X(10) VALUE SPACES.        
           05  WS-IZ-WITHDRAW-DT         PIC X(10) VALUE SPACES.        
           05  WS-FW-FINAL-BILL-DT       PIC X(10) VALUE SPACES.        
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  WS-WORK-DATE              PIC X(10) VALUE SPACES.        
           05  WS-COMPANY-NO             PIC X(02) VALUE SPACES.        
           05  WS-REG-GROUP-CD           PIC X(03) VALUE SPACES.        
           05  WS-FW-FINAL-BILL-DT-NULL  PIC S9(04) COMP VALUE 0.       
           05  WS-IZ-WITHDRAW-DT-NULL    PIC S9(04) COMP VALUE 0.       
           05  WS-IZ-ACTION-TYPE-CD-NULL PIC S9(04) COMP VALUE 0.       
           05  WS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
                                                                        
       01  WS-FORECAST-TB.                                              
           05 WS-FORECAST-ENTRIES                                       
                OCCURS 50 TIMES                                         
                  INDEXED BY WS-FCST-INDEX.                             
              10  WS-FW-PATH-TYPE-CD     PIC X(02).                     
COB305        10 WS-FW-ACTION-SEQ-NO        PIC S9(05)V USAGE COMP-3 
COB305           VALUE 0.      
              10  WS-FW-ACTION-TYPE-CD   PIC X(05).                     
COB305        10 WS-FW-FCST-DAYS-NM        PIC S9(05) USAGE COMP-3 
COB305           VALUE 0.       
              10  WS-FW-FCST-SOURCE-CD   PIC X(01).                     
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-END-FLAG               PIC X(01) VALUE 'N'.           
               88 WS-END-LOAD                      VALUE 'Y'.           
                                                                        
      *****************************************************************         
      **       CURSOR DECLARATIONS                                    *         
      *****************************************************************         
           EXEC SQL                                                     
               DECLARE FRCST_CUR CURSOR FOR                             
               SELECT                                                   
                    F8.FW_PATH_TYPE_CD                                  
                   ,F8.FW_ACTION_SEQ_NO                                 
                   ,F8.FW_ACTION_TYPE_CD                                
                   ,F8.FW_FCST_DAYS_NM                                  
                   ,F8.FW_FCST_SOURCE_CD                                
               FROM                                                     
                  CSS_FW_FCST_ACTION F8 WITH(READUNCOMMITTED)                   
               WHERE                                                    
                   F8.EFFECTIVE_DT   <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
               AND F8.EXPIRATION_DT  >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
               AND ( F8.FW_PATH_TYPE_CD = :FW-FW-PATH-TYPE-CD           
                   OR ( F8.FW_PATH_TYPE_CD = 'DE' AND                   
                        F8.FW_FCST_TIME_CD <> 'R' ) )                   
               AND F8.COMPANY_NO      = :WS-COMPANY-NO                  
               AND F8.REG_GROUP_CD    = :WS-REG-GROUP-CD                
               ORDER BY F8.FW_PATH_TYPE_CD, F8.FW_ACTION_SEQ_NO         
               FOR READ ONLY                                    
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FRCST_CUR CURSOR FOR                                     
MFA-TR*        SELECT                                                           
MFA-TR*             F8.FW_PATH_TYPE_CD                                          
MFA-TR*            ,F8.FW_ACTION_SEQ_NO                                         
MFA-TR*            ,F8.FW_ACTION_TYPE_CD                                        
MFA-TR*            ,F8.FW_FCST_DAYS_NM                                          
MFA-TR*            ,F8.FW_FCST_SOURCE_CD                                        
MFA-TR*        FROM                                                             
MFA-TR*           CSS_FW_FCST_ACTION F8                                         
MFA-TR*        WHERE                                                            
MFA-TR*            F8.EFFECTIVE_DT   <= :WS-CURRENT-DATE                        
MFA-TR*        AND F8.EXPIRATION_DT  >= :WS-CURRENT-DATE                        
MFA-TR*        AND ( F8.FW_PATH_TYPE_CD = :FW-FW-PATH-TYPE-CD                   
MFA-TR*            OR ( F8.FW_PATH_TYPE_CD = 'DE' AND                           
MFA-TR*                 F8.FW_FCST_TIME_CD <> 'R' ) )                           
MFA-TR*        AND F8.COMPANY_NO      = :WS-COMPANY-NO                          
MFA-TR*        AND F8.REG_GROUP_CD    = :WS-REG-GROUP-CD                        
MFA-TR*        ORDER BY F8.FW_PATH_TYPE_CD, F8.FW_ACTION_SEQ_NO                 
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     
               DECLARE FIN_WO_ACTN CURSOR FOR                           
               SELECT                                                   
                    KD.FW_SEQ_NO                                        
                   ,KD.FW_ACTION_TYPE_CD                                
                   ,KD.FW_ACTION_DT                                     
                   ,KD.FW_MANUAL_FL                                     
                   ,IZ.FW_ACTION_TYPE_CD                                
                   ,IZ.WITHDRAW_DT                                      
               FROM                                                     
                   CSS_FIN_WO_ACTION  KD WITH(READUNCOMMITTED)                  
               LEFT OUTER JOIN                                          
                   CSS_FIN_WO_COLLECT IZ WITH(READUNCOMMITTED)                  
               ON                                                       
                   KD.ACCOUNT_NO        = IZ.ACCOUNT_NO                 
               AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD          
               AND KD.FW_SEQ_NO = IZ.FW_COLL_SEQ_NO                     
               WHERE                                                    
                   KD.ACCOUNT_NO = :WS-ACCOUNT-NO-DEC                   
      *  KD SEQ NO SHOULD BE GREATER THAN PASSED SEQ NO, SO THAT QRY            
      *  DOESN'T PICK THE ACTION WHICH IS CHANGED IN CALLING PROGRAMS           
               AND((KD.FW_SEQ_NO  > :WS-FW-SEQ-NO                       
                    AND KD.FW_ACTION_DT >= IIF(TRY_CONVERT(DATE, 
                                                     :WS-ORIG-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ORIG-ACTION-DT
              ) <> 0) OR (LEN(:WS-ORIG-ACTION-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ORIG-ACTION-DT
              ), CONVERT(DATE, :WS-ORIG-ACTION-DT) ))          
      *  IZ SEQ NO SHOULD BE GREATER THAN EQUAL TO SEQ NO, SO THAT QRY          
      *  PICKS THE WITHDRAW ACTION FROM IZ                                      
                OR (IZ.FW_COLL_SEQ_NO >= :WS-FW-SEQ-NO                  
                    AND IZ.WITHDRAW_DT  >  IIF(TRY_CONVERT(DATE, 
                                                     :WS-ORIG-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ORIG-ACTION-DT
              ) <> 0) OR (LEN(:WS-ORIG-ACTION-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ORIG-ACTION-DT
              ), CONVERT(DATE, :WS-ORIG-ACTION-DT) )))         
               ORDER BY KD.FW_SEQ_NO                                    
               FOR READ ONLY                                    
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FIN_WO_ACTN CURSOR FOR                                   
MFA-TR*        SELECT                                                           
MFA-TR*             KD.FW_SEQ_NO                                                
MFA-TR*            ,KD.FW_ACTION_TYPE_CD                                        
MFA-TR*            ,KD.FW_ACTION_DT                                             
MFA-TR*            ,KD.FW_MANUAL_FL                                             
MFA-TR*            ,IZ.FW_ACTION_TYPE_CD                                        
MFA-TR*            ,IZ.WITHDRAW_DT                                              
MFA-TR*        FROM                                                             
MFA-TR*            CSS_FIN_WO_ACTION  KD                                        
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*            CSS_FIN_WO_COLLECT IZ                                        
MFA-TR*        ON                                                               
MFA-TR*            KD.ACCOUNT_NO        = IZ.ACCOUNT_NO                         
MFA-TR*        AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD                  
MFA-TR*        AND KD.FW_SEQ_NO = IZ.FW_COLL_SEQ_NO                             
MFA-TR*        WHERE                                                            
MFA-TR*            KD.ACCOUNT_NO = :WS-ACCOUNT-NO-DEC                           
MFA-TR*  KD SEQ NO SHOULD BE GREATER THAN PASSED SEQ NO, SO THAT QRY            
MFA-TR*  DOESN'T PICK THE ACTION WHICH IS CHANGED IN CALLING PROGRAMS           
MFA-TR*        AND((KD.FW_SEQ_NO  > :WS-FW-SEQ-NO                               
MFA-TR*             AND KD.FW_ACTION_DT >= :WS-ORIG-ACTION-DT)                  
MFA-TR*  IZ SEQ NO SHOULD BE GREATER THAN EQUAL TO SEQ NO, SO THAT QRY          
MFA-TR*  PICKS THE WITHDRAW ACTION FROM IZ                                      
MFA-TR*         OR (IZ.FW_COLL_SEQ_NO >= :WS-FW-SEQ-NO                          
MFA-TR*             AND IZ.WITHDRAW_DT  >  :WS-ORIG-ACTION-DT))                 
MFA-TR*        ORDER BY KD.FW_SEQ_NO                                            
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC X(13).                  
       01  PARM-ACTION-TYPE                 PIC X(05).                  
       01  PARM-SEQ-NO                      PIC S9(4) COMP.             
       01  PARM-ORIG-ACTION-DATE            PIC X(10).                  
       01  PARM-NEW-ACTION-DATE             PIC X(10).                  
       01  PARM-COMPANY-NO                  PIC X(02).                  
      *                                                                         
      *                                                                         
       PROCEDURE DIVISION USING                                         
                          PARM-ACCOUNT-NO                               
                         ,PARM-ACTION-TYPE                              
                         ,PARM-SEQ-NO                                   
                         ,PARM-ORIG-ACTION-DATE                         
                         ,PARM-NEW-ACTION-DATE                          
                         ,PARM-COMPANY-NO.                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
      *                                                                         
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
                 SELECT                                                 
                     RETURN_CODE                                        
                    ,ACTION_TYPE                                        
                    ,FW_SEQ_NO                                          
                    ,ACTION_DATE                                        
                 FROM                                                   
                     #CSR04074_R1                                
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*          SELECT                                                         
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ACTION_TYPE                                                
MFA-TR*             ,FW_SEQ_NO                                                  
MFA-TR*             ,ACTION_DATE                                                
MFA-TR*          FROM                                                           
MFA-TR*              SESSION.CSR04074_R1                                        
MFA-TR*      END-EXEC.                                                          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR04074_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04074_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04074_R1
              (                                                       
                    RETURN_CODE       INT                           
                   ,ACTION_TYPE CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,FW_SEQ_NO         SMALLINT                          
                   ,ACTION_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-SQLSTATE = '42710'                                     
               PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
                  MOVE SQLCODE            TO ABEND-SQLCODE              
                  MOVE SQLSTATE           TO ABEND-SQLSTATE             
                  MOVE '0100A'            TO ACTIVE-PARAGRAPH           
                  MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
                  MOVE SPACES             TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                  MOVE 'CSR04074_R1'      TO TABLE-1                    
                  MOVE SPACES             TO TABLE-ELEMENT-1            
                  MOVE SPACES             TO HOSTVAR-ELEMENT-1          
                  PERFORM 9900-SQL-ERROR-ROUTINE                        
                                          THRU  9900-EXIT               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO-JST.       
           MOVE WS-ACCOUNT-NO-JST           TO WS-ACCOUNT-NO-DEC.       
           MOVE PARM-ACTION-TYPE            TO WS-ACTION-TYPE.          
           MOVE PARM-SEQ-NO                 TO WS-FW-SEQ-NO.            
           MOVE PARM-ORIG-ACTION-DATE       TO WS-ORIG-ACTION-DT        
           MOVE PARM-NEW-ACTION-DATE        TO WS-ACTION-DATE.          
           MOVE PARM-COMPANY-NO             TO WS-COMPANY-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *           2300-BUILD-RESULT                                    *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 2300-BUILD-RESULT        THRU 2300-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2300-BUILD-RESULT.                                               
                                                                        
           PERFORM 7010-SELECT-CURRT-DT     THRU 7010-EXIT              
                                                                        
           PERFORM 7020-SELECT-FIN-BILL-DT  THRU 7020-EXIT.             
                                                                        
           PERFORM 2400-LOAD-FORECAST-ROWS  THRU 2400-EXIT.             
                                                                        
           IF WS-ACTION-TYPE = 'WO'                                     
C30169        MOVE WS-ACTION-DATE           TO  WS-WRITE-OFF-DATE       
           ELSE                                                         
              PERFORM 7040-SELECT-WRITEOFF-DT   THRU 7040-EXIT          
           END-IF.                                                      
                                                                        
C30169     MOVE WS-ACTION-DATE           TO WS-PREV-ACTION-DATE         
           PERFORM 2470-PROCESS-FORECAST-DATES THRU 2470-EXIT.          
                                                                        
           IF WS-RETURN-CODE = 300 AND CTR-ROWS = 0                     
              MOVE SPACES                   TO S-ACTION-TYPE            
              MOVE WS-RETURN-CODE           TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           ELSE                                                         
              IF S-RETURN-CODE = 0 AND CTR-ROWS = 0                     
                 MOVE 100                   TO S-RETURN-CODE            
                 PERFORM 8100-SEND-RESULT   THRU 8100-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-LOAD-FORECAST-ROWS                                        *        
      * LOAD FORECAST ROW PROCESS                                      *        
      ******************************************************************        
      *                                                                         
       2400-LOAD-FORECAST-ROWS.                                         
                                                                        
           INITIALIZE WS-FORECAST-TB.                                   
           SET WS-FCST-INDEX                TO 1.                       
                                                                        
           PERFORM 7100-OPEN-FRCST-CURSOR   THRU 7100-EXIT.             
           PERFORM 7120-FETCH-FRCST-CURSOR  THRU 7120-EXIT              
                             UNTIL WS-END-LOAD.                         
           PERFORM 7130-CLOSE-FRCST-CURSOR  THRU 7130-EXIT.             
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2420-LOAD-FORECAST-WS-TABLE                                    *        
      *     LOAD FORECAST TABLE                                        *        
      ******************************************************************        
      *                                                                         
       2420-MOVE-FORECAST-WS-TABLE.                                     
                                                                        
           MOVE '2420'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           MOVE F8-FW-PATH-TYPE-CD     TO                               
                                    WS-FW-PATH-TYPE-CD(WS-FCST-INDEX).  
           MOVE F8-FW-ACTION-SEQ-NO    TO                               
                                    WS-FW-ACTION-SEQ-NO(WS-FCST-INDEX). 
           MOVE F8-FW-ACTION-TYPE-CD   TO                               
                                    WS-FW-ACTION-TYPE-CD(WS-FCST-INDEX).
           MOVE F8-FW-FCST-DAYS-NM     TO                               
                                    WS-FW-FCST-DAYS-NM(WS-FCST-INDEX).  
           MOVE F8-FW-FCST-SOURCE-CD   TO                               
                                    WS-FW-FCST-SOURCE-CD(WS-FCST-INDEX).
                                                                        
           SET WS-FCST-INDEX           UP BY 1.                         
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2470-PROCESS-FORECAST-DATES                                    *         
      *****************************************************************         
      *                                                                         
       2470-PROCESS-FORECAST-DATES.                                     
                                                                        
           PERFORM 7200-OPEN-FIN-WO-ACTN-CURSOR  THRU 7200-EXIT.        
           PERFORM 7220-FETCH-FIN-WO-ACTN-CURSOR THRU 7220-EXIT.        
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
              MOVE WS-PATH-TYPE-CD          TO WS-FCST-PATH-TYPE-CD     
                                                                        
C30169        IF KD-FW-ACTION-DT >= WS-ORIG-ACTION-DT AND               
                 KD-FW-SEQ-NO > WS-FW-SEQ-NO                            
                                                                        
                 IF KD-FW-ACTION-TYPE-CD = 'CREDB'                      
C30169              IF WS-WRITE-OFF-DATE   < WS-CURRENT-DATE            
                       MOVE 'DE'            TO WS-FCST-PATH-TYPE-CD     
                    END-IF                                              
                    PERFORM 2560-FORECAST-ACTION-DATE THRU 2560-EXIT    
                 ELSE                                                   
                    PERFORM 2560-FORECAST-ACTION-DATE THRU 2560-EXIT    
                    PERFORM 2550-FORECAST-WITHDRAW-DT THRU 2550-EXIT    
                 END-IF                                                 
                                                                        
              ELSE                                                      
                 IF WS-IZ-WITHDRAW-DT >= WS-ORIG-ACTION-DT AND          
                    KD-FW-SEQ-NO >= WS-FW-SEQ-NO                        
                    PERFORM 2550-FORECAST-WITHDRAW-DT THRU 2550-EXIT    
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 7220-FETCH-FIN-WO-ACTN-CURSOR THRU 7220-EXIT      
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7230-CLOSE-FIN-WO-ACTN-CURSOR THRU 7230-EXIT.        
      *                                                                         
       2470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2550-FORECAST-WITHDRAW-DT                                      *         
      *****************************************************************         
      *                                                                         
       2550-FORECAST-WITHDRAW-DT.                                       
                                                                        
           IF KD-FW-ACTION-TYPE-CD = WS-IZ-ACTION-TYPE-CD AND           
              WS-IZ-WITHDRAW-DT NOT = SPACES                            
                                                                        
              EVALUATE  KD-FW-ACTION-TYPE-CD                            
                WHEN '1PLMT'                                            
                  MOVE '1PLWD'              TO KD-FW-ACTION-TYPE-CD     
                WHEN '2PLMT'                                            
                  MOVE '2PLWD'              TO KD-FW-ACTION-TYPE-CD     
                WHEN '3PLMT'                                            
                  MOVE '3PLWD'              TO KD-FW-ACTION-TYPE-CD     
              END-EVALUATE                                              
                                                                        
              MOVE WS-IZ-WITHDRAW-DT        TO KD-FW-ACTION-DT          
              PERFORM 2560-FORECAST-ACTION-DATE THRU 2560-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *2560-FORECAST-ACTION-DATE                                      *         
      *****************************************************************         
      *                                                                         
       2560-FORECAST-ACTION-DATE.                                       
                                                                        
           IF KD-FW-MANUAL-FL = 'Y'                                     
              MOVE 'DE'                  TO WS-FCST-PATH-TYPE-CD        
           END-IF                                                       
                                                                        
           SET WS-FCST-INDEX TO 1.                                      
           SEARCH WS-FORECAST-ENTRIES                                   
               AT END                                                   
                    MOVE 300                TO WS-RETURN-CODE           
               WHEN WS-FW-ACTION-TYPE-CD (WS-FCST-INDEX)                
                                   = KD-FW-ACTION-TYPE-CD               
                AND WS-FW-PATH-TYPE-CD(WS-FCST-INDEX)                   
                                   = WS-FCST-PATH-TYPE-CD               
                    EVALUATE WS-FW-FCST-SOURCE-CD(WS-FCST-INDEX)        
                        WHEN 'F'                                        
C30169                      MOVE WS-FW-FINAL-BILL-DT TO WS-WORK-DATE    
C30169                      MOVE WS-FW-FCST-DAYS-NM(WS-FCST-INDEX) TO   
C30169                                             WS-DAY-COLLEC-NO-DAYS
C30169                      IF WS-DAY-COLLEC-NO-DAYS > 0                
C30169                         PERFORM 5080-GET-WORKING-DAYS  THRU      
C30169                                                         5080-EXIT
C30169                      END-IF                                      
                        WHEN 'W'                                        
C30169                     MOVE WS-WRITE-OFF-DATE TO WS-WORK-DATE       
C30169                     MOVE WS-FW-FCST-DAYS-NM(WS-FCST-INDEX) TO    
C30169                                             WS-DAY-COLLEC-NO-DAYS
C30169                      IF WS-DAY-COLLEC-NO-DAYS > 0                
C30169                         PERFORM 5080-GET-WORKING-DAYS  THRU      
C30169                                                        5080-EXIT 
C30169                      END-IF                                      
                        WHEN 'P'                                        
C30169                     MOVE WS-PREV-ACTION-DATE TO WS-WORK-DATE     
C30169                     MOVE WS-FW-FCST-DAYS-NM(WS-FCST-INDEX) TO    
C30169                                             WS-DAY-COLLEC-NO-DAYS
C30169                      IF WS-DAY-COLLEC-NO-DAYS > 0                
C30169                         PERFORM 5080-GET-WORKING-DAYS  THRU      
C30169                                                        5080-EXIT 
C30169                      END-IF                                      
C30169                          IF KD-FW-ACTION-TYPE-CD = 'WO'          
C30169                             MOVE WS-WORK-DATE          TO        
C30169                                                 WS-WRITE-OFF-DATE
C30169                          END-IF                                  
                    END-EVALUATE                                        
                    MOVE WS-WORK-DATE         TO S-ACTION-DATE          
                                                 WS-PREV-ACTION-DATE    
                    MOVE 0                    TO S-RETURN-CODE          
                    MOVE KD-FW-SEQ-NO         TO S-FW-SEQ-NO            
                    MOVE KD-FW-ACTION-TYPE-CD TO S-ACTION-TYPE          
                    PERFORM 8100-SEND-RESULT  THRU 8100-EXIT            
           END-SEARCH.                                                  
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30169*************************************************************             
C30169*                                                                         
C30169*  5080-GET-WORKING-DAYS                                                  
C30169*                                                                         
C30169*  THIS PARAGRAPH GETS THE NEXT CURRENT DAY FROM THE NUMBER               
C30169*  OF DAYS SENT DOWN.                                                     
C30169*                                                                         
C30169* RETURNS WS-WORK-DATE                                                    
C30169*                                                                         
C30169*************************************************************             
C30169*                                                                         
C30169 5080-GET-WORKING-DAYS.                                           
C30169*                                                                         
C30169     MOVE 0                       TO WS-GOOD-COUNT.               
C30169     MOVE WS-NO                   TO WS-GOOD-WORKING-DAY.         
C30169     PERFORM UNTIL (WS-GOOD-WORKING-DAY = WS-YES)                 
C30169             AND (WS-GOOD-COUNT = WS-DAY-COLLEC-NO-DAYS)          
C30169        PERFORM 7025-GET-NEXT-BUS-DAY       THRU 7025-EXIT        
C30169        IF WS-DAY > 0                                             
C30169              AND WS-DAY < 6                                      
C30169           PERFORM 7030-SELECT-HOLIDAY      THRU 7030-EXIT        
C30169           IF WS-EXISTS-FL NOT EQUAL 'Y'                          
C30169              MOVE WS-YES          TO WS-GOOD-WORKING-DAY         
C30169              ADD 1                TO WS-GOOD-COUNT               
C30169           END-IF                                                 
C30169        END-IF                                                    
C30169     END-PERFORM.                                                 
C30169*                                                                         
C30169 5080-EXIT.                                                       
C30169     EXIT.                                                        
      *****************************************************************         
      *7010-SELECT-CURRT-DT                                           *         
      *****************************************************************         
      *                                                                         
       7010-SELECT-CURRT-DT.                                            
                                                                        
           MOVE '7010'                        TO ACTIVE-PARAGRAPH.      
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE  = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7020-SELECT-FIN-BILL-DT                                        *         
      *****************************************************************         
      *                                                                         
       7020-SELECT-FIN-BILL-DT.                                         
                                                                        
           MOVE '7020'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    FINAL_BILL_DT                                       
                   ,FW_PATH_TYPE_CD                                     
               INTO                                                     
                    :FW-FINAL-BILL-DT :WS-FW-FINAL-BILL-DT-NULL          
                   ,:FW-FW-PATH-TYPE-CD                                 
               FROM                                                     
                    CSS_FINAL_WO                                        
               WHERE                                                    
                    ACCOUNT_NO = :WS-ACCOUNT-NO-DEC                     
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             FINAL_BILL_DT                                               
MFA-TR*            ,FW_PATH_TYPE_CD                                             
MFA-TR*        INTO                                                             
MFA-TR*             :FW-FINAL-BILL-DT:WS-FW-FINAL-BILL-DT-NULL                  
MFA-TR*            ,:FW-FW-PATH-TYPE-CD                                         
MFA-TR*        FROM                                                             
MFA-TR*             CSS_FINAL_WO                                                
MFA-TR*        WHERE                                                            
MFA-TR*             ACCOUNT_NO = :WS-ACCOUNT-NO-DEC                             
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                MOVE FW-FINAL-BILL-DT       TO WS-FW-FINAL-BILL-DT      
                MOVE FW-FW-PATH-TYPE-CD     TO WS-PATH-TYPE-CD          
                IF WS-FW-FINAL-BILL-DT-NULL < 0                         
                   MOVE SPACES              TO WS-FW-FINAL-BILL-DT      
                   MOVE ZERO                TO WS-FW-FINAL-BILL-DT-NULL 
                END-IF                                                  
             WHEN OTHER                                                 
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE SQLCODE               TO ABEND-SQLCODE             
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'FINAL_BILL_DT'       TO TABLE-ELEMENT-1           
                MOVE WS-ACCOUNT-NO-DEC     TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT                          
                                           THRU 9000-EXIT               
                PERFORM 9900-SQL-ERROR-ROUTINE                          
                                           THRU 9900-EXIT               
           END-EVALUATE.                                                
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30169*****************************************************************         
C30169* 7025-GET-NEXT-BUS-DAY                                         *         
C30169*          GETS NEXT WORKING DAY                                *         
C30169*****************************************************************         
C30169 7025-GET-NEXT-BUS-DAY.                                           
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))         
C30169                      - (CIS.DAYS(DATEADD( DAY, 1, 
              IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-DAY                           
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE = DATE(:WS-WORK-DATE) + 1 DAYS                  
MFA-TR*          ,:WS-DAY = DAYS (DATE(:WS-WORK-DATE) + 1 DAYS)                 
MFA-TR*                     - (INTEGER(DAYS(DATE(:WS-WORK-DATE)                 
MFA-TR*                     + 1 DAYS)/7) * 7)                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
C30169        CONTINUE                                                  
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '7025'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'SELECT'              TO ABEND-FUNCTION              
C30169        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C30169                                      ABEND-TABLES                
C30169        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C30169        MOVE WS-ACCOUNT-NO-DEC     TO HOSTVAR-ELEMENT-1           
C30169        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
C30169        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7025-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169* 7030-SELECT-HOLIDAY                                           *         
C30169*          GETS HOLIDAY FROM THE TABLE                          *         
C30169*****************************************************************         
C30169 7030-SELECT-HOLIDAY.                                             
C30169                                                                  
C30169     MOVE SPACES         TO WS-EXISTS-FL.                         
C30169     MOVE WS-WORK-DATE   TO J8-HOLIDAY-DT.                        
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        SELECT 'Y'                                                
C30169        INTO   :WS-EXISTS-FL                                      
C30169        FROM   CSS_HOLIDAY                                        
C30169        WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                        
P00799                                                      
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :WS-EXISTS-FL                                              
MFA-TR*       FROM   CSS_HOLIDAY                                                
MFA-TR*       WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                                
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
C30169                                  OR  NOT-FOUND                   
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '7030'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'SELECT'              TO ABEND-FUNCTION              
C30169        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C30169                                      ABEND-TABLES                
C30169        MOVE 'CSS_HOLIDAY'         TO TABLE-1                     
C30169        MOVE 'HOLIDAY_DT'          TO TABLE-ELEMENT-1             
C30169        MOVE J8-HOLIDAY-DT         TO HOSTVAR-ELEMENT-1           
C30169        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
C30169        MOVE WS-ACCOUNT-NO-DEC     TO HOSTVAR-ELEMENT-3           
C30169        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
C30169        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7030-EXIT.                                                       
C30169     EXIT.                                                        
      *****************************************************************         
      *7040-SELECT-WRITEOFF-DT                                        *         
      *****************************************************************         
      *                                                                         
       7040-SELECT-WRITEOFF-DT.                                         
                                                                        
           MOVE '7040'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FW_ACTION_DT                                       
               INTO                                                     
                   :WS-WRITE-OFF-DATE                                   
               FROM                                                     
                   CSS_FIN_WO_ACTION                                    
               WHERE                                                    
                   ACCOUNT_NO        = :WS-ACCOUNT-NO-DEC               
               AND FW_ACTION_TYPE_CD = 'WO'                             
               ORDER BY FW_SEQ_NO DESC                                  
                                                  
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*            FW_ACTION_DT                                                 
MFA-TR*        INTO                                                             
MFA-TR*            :WS-WRITE-OFF-DATE                                           
MFA-TR*        FROM                                                             
MFA-TR*            CSS_FIN_WO_ACTION                                            
MFA-TR*        WHERE                                                            
MFA-TR*            ACCOUNT_NO        = :WS-ACCOUNT-NO-DEC                       
MFA-TR*        AND FW_ACTION_TYPE_CD = 'WO'                                     
MFA-TR*        ORDER BY FW_SEQ_NO DESC                                          
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-DEC     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7050-SELECT-REG-GROUP-CD                                       *         
      *****************************************************************         
      *                                                                         
       7050-SELECT-REG-GROUP-CD.                                        
                                                                        
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    REG_GROUP_CD                                        
               INTO                                                     
                    :LR-REG-GROUP-CD                                    
               FROM                                                     
                    CSS_REG_PROFILE                                     
               WHERE                                                    
                    ACCOUNT_NO = :WS-ACCOUNT-NO-DEC                     
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             REG_GROUP_CD                                                
MFA-TR*        INTO                                                             
MFA-TR*             :LR-REG-GROUP-CD                                            
MFA-TR*        FROM                                                             
MFA-TR*             CSS_REG_PROFILE                                             
MFA-TR*        WHERE                                                            
MFA-TR*             ACCOUNT_NO = :WS-ACCOUNT-NO-DEC                             
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE LR-REG-GROUP-CD       TO WS-REG-GROUP-CD             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              MOVE SPACES                TO WS-REG-GROUP-CD             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-DEC     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-FRCST-CURSOR                                         *        
      * THIS PARA OPEN THE FORECAST CURSOR                             *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-FRCST-CURSOR.                                          
           MOVE '7100'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 7050-SELECT-REG-GROUP-CD THRU 7050-EXIT              
                                                                        
           EXEC SQL                                                     
              OPEN FRCST_CUR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FRCST_CUR'                TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7120-FETCH-FRCST-CURSOR                                        *        
      * FETCH THE FORECAST CURSOR                                      *        
      ******************************************************************        
      *                                                                         
       7120-FETCH-FRCST-CURSOR.                                         
                                                                        
           MOVE '7120'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH                                                     
                  FRCST_CUR                                             
              INTO                                                      
                  :F8-FW-PATH-TYPE-CD                                   
                 ,:F8-FW-ACTION-SEQ-NO                                  
                 ,:F8-FW-ACTION-TYPE-CD                                 
                 ,:F8-FW-FCST-DAYS-NM                                   
                 ,:F8-FW-FCST-SOURCE-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2420-MOVE-FORECAST-WS-TABLE                       
                                            THRU 2420-EXIT              
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              SET WS-END-LOAD               TO TRUE                     
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FW_FCST_ACTION'     TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-CLOSE-FRCST-CURSOR                                        *        
      * THIS PARA CLOSE THE FORECAST CURSOR                            *        
      ******************************************************************        
                                                                        
       7130-CLOSE-FRCST-CURSOR.                                         
                                                                        
           MOVE '7130'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE FRCST_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FRCST_CUR'                TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7200-OPEN-FIN-WO-ACTN-CURSOR                                   *         
      *****************************************************************         
      *                                                                         
       7200-OPEN-FIN-WO-ACTN-CURSOR.                                    
           MOVE '7200'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              OPEN FIN_WO_ACTN                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FIN_WO_ACTN'              TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *7220-FETCH-FIN-WO-ACTN-CURSOR                                  *         
      *****************************************************************         
      *                                                                         
       7220-FETCH-FIN-WO-ACTN-CURSOR.                                   
                                                                        
           MOVE '7220'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH FIN_WO_ACTN                                         
              INTO                                                      
                  :KD-FW-SEQ-NO                                         
                 ,:KD-FW-ACTION-TYPE-CD                                 
                 ,:KD-FW-ACTION-DT                                      
                 ,:KD-FW-MANUAL-FL                                      
                 ,:IZ-FW-ACTION-TYPE-CD :WS-IZ-ACTION-TYPE-CD-NULL       
                 ,:IZ-WITHDRAW-DT :WS-IZ-WITHDRAW-DT-NULL                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-IZ-ACTION-TYPE-CD-NULL < 0 THEN                     
                 MOVE SPACE                 TO WS-IZ-ACTION-TYPE-CD     
                 MOVE ZERO                  TO WS-IZ-ACTION-TYPE-CD-NULL
              ELSE                                                      
                 MOVE IZ-FW-ACTION-TYPE-CD  TO WS-IZ-ACTION-TYPE-CD     
              END-IF                                                    
              IF WS-IZ-WITHDRAW-DT-NULL < 0 THEN                        
                 MOVE SPACE                 TO WS-IZ-WITHDRAW-DT        
                 MOVE ZERO                  TO WS-IZ-WITHDRAW-DT-NULL   
              ELSE                                                      
                 MOVE IZ-WITHDRAW-DT        TO WS-IZ-WITHDRAW-DT        
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIN_WO_ACTION'      TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7230-CLOSE-FIN-WO-ACTN-CURSOR.                                 *        
      ******************************************************************        
      *                                                                         
       7230-CLOSE-FIN-WO-ACTN-CURSOR.                                   
                                                                        
           MOVE '7230'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE FIN_WO_ACTN                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'FIN_WO_ACTN'              TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS                                           *        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
      *                                                                         
           EXEC SQL                                                     
                DELETE FROM #CSR04074_R1                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR04074_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '8000A'               TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04074_R1'         TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT                            
                                         THRU 9000-EXIT                 
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                         THRU 9900-EXIT                 
           END-IF.                                                      
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8100-SEND-RESULT                                                *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO #CSR04074_R1                         
                (                                                       
                     RETURN_CODE                                        
                    ,ACTION_TYPE                                        
                    ,FW_SEQ_NO                                          
                    ,ACTION_DATE                                        
                )                                                       
                VALUES                                                  
                (                                                       
                     :S-RETURN-CODE                                     
                    ,:S-ACTION-TYPE                                     
                    ,:S-FW-SEQ-NO                                       
                    ,:S-ACTION-DATE                                     
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR04074_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                        01670000
MFA-TR*             ,ACTION_TYPE                                                
MFA-TR*             ,FW_SEQ_NO                                                  
MFA-TR*             ,ACTION_DATE                                                
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-ACTION-TYPE                                             
MFA-TR*             ,:S-FW-SEQ-NO                                               
MFA-TR*             ,:S-ACTION-DATE                                             
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                ADD +1                    TO CTR-ROWS                   
           ELSE                                                         
                MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
                MOVE SQLCODE              TO ABEND-SQLCODE              
                MOVE '8100'               TO ACTIVE-PARAGRAPH           
                MOVE 'INSERT'             TO ABEND-FUNCTION             
                MOVE SPACES               TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                MOVE 'CSR04074_R2'        TO TABLE-1                    
                MOVE SPACES               TO TABLE-ELEMENT-1            
                MOVE SPACES               TO HOSTVAR-ELEMENT-1          
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                 12700000
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
