       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04072.                                         
COB303 DATE-WRITTEN.      JANUARY 28, 2008.                             
       DATE-COMPILED.                                                   
      ***************************************************************** 00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                  * 00080000
      ***************************************************************** 00160000
      *                P R O G R A M  S U M M A R Y                   * 00170000
      *                                                               * 00180000
      *  THIS PROGRAM RETRIEVES CUSTOMER DETAILS FROM CSS_NAME AND    * 00190000
      *  CSS_CUST_STATS TABLES FOR A SPECIFIED CUSTOMER NUMBER.       * 00200000
      *  DELINQ VALUES FOR NO-SCORES-ALLOWED & NO-HOURS-RANGE FOR A   * 00210000
      *  GIVEN COMPANY NO.                                            * 00210000
      *  RETRIEVED FROM PANEL059 SCORE BUTTON.                        * 00210000
      ***************************************************************** 00230000
      *                                                               * 00240000
      *                     PROGRAM MODIFICATION LOG                  * 00250000
      *    DATE    USER ID    COMMENTS                                * 00270000
      *  --------  --------   --------------------------------------- * 00280000
      *  01/28/08  VV94890    STORED PROCEDURE ORIGINALLY CODED.      * 00290000
      *  11/16/11  RC41079    FOR SERVICE CARE CREDIT SCORING ADDED   * 00290000
      *                       CHECK WS-COMPANY-NO = '30' MOVE '01' TO * 00290000
      *                       C8-COMPANY-NO WHEN GETTING NO-SCORES-   * 00290000
      *                       ALLOWED AND NO-HOURS-RANGE FROM CSS_    * 00290000
      *                       DELINQUENCY IN PARA 2100-BUILD-RESULT.  * 00290000
      ***************************************************************** 00310000
      ***************************************************************** 00320000
      *                                                               * 00330000
      *                ---- BASIC SEQUENCE STRUCTURE ----             * 00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            * 00360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   * 00370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  * 00380000
      *  3000 - 4999  NOT USED                                        * 00390000
      *  5000 - 5999  COMMON PROGRAM MODULES                          * 00400000
      *  6000 - 6999  COMMON SYSTEM MODULES                           * 00410000
      *  7000 - 7999  INPUT MODULES                                   * 00420000
      *  8000 - 8999  OUTPUT MODULES                                  * 00430000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES           * 00440000
      *                                                               * 00450000
      ***************************************************************** 00460000
      *                                                                 00470000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04072'.
MSQ017     COPY MFASQLM.
      *                                                                 00510000
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04072 STARTS HERE'.                  
      *                                                                 00540000
      ******************************************************************00550000
      *    DB2 INCLUDES                                                *00560000
      ******************************************************************00570000
      *                                                                 00580000
           EXEC SQL                                                     00590000
              INCLUDE SQLCA                                             00600000
           END-EXEC.                                                    00610000
      *                                                                 00651000
      ******************************************************************00550000
      *    C8 - CSS_DELINQUENCY                                        *00560000
      ******************************************************************00570000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE TBDELQ                                            00640000
           END-EXEC.                                                    00650000
      *                                                                 00651000
      ******************************************************************00550000
      *    DQ - CSS_NAME                                               *00560000
      ******************************************************************00570000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE TBNAME                                            00640000
           END-EXEC.                                                    00650000
      *                                                                 00620000
      ******************************************************************00550000
      *    CE - CSS_CUST_STATS                                         *00560000
      ******************************************************************00570000
      *                                                                 00620000
           EXEC SQL                                                     00630000
              INCLUDE TBCSTSTS                                          00640000
           END-EXEC.                                                    00650000
      *                                                                 00651000
      ******************************************************************00830000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00840000
      ******************************************************************00850000
      *                                                                 00860000
      ******************************************************************00830000
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     **00840000
      ******************************************************************00850000
      *                                                                 00860000
           COPY CWS00303.                                               00920000
      *                                                                 00930000
      ******************************************************************00940000
      *    WORK AREAS                                                  *00950000
      ******************************************************************00960000
      *                                                                 00970000
       01  PARM-FIELDS.                                                 
           05  PARM-CUSTOMER-NO        PIC X(10)      VALUE SPACES.     
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
           05  PARM-COMPANY-NO         PIC X(02)      VALUE SPACES.     
      *                                                                 01151000
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 01691000
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-NAME-FORMAT            PIC X(01) VALUE SPACE.          
           05  S-FIRST-NAME             PIC X(15) VALUE SPACE.          
           05  S-MIDDLE-NAME            PIC X(15) VALUE SPACE.          
           05  S-LAST-NAME              PIC X(40) VALUE SPACE.          
           05  S-TITLE-SUFFIX-1         PIC X(03) VALUE SPACE.          
           05  S-SSN                    PIC X(09) VALUE SPACE.          
           05  S-DRIVERS-LICENSE-NO     PIC X(20) VALUE SPACE.          
           05  S-CODE-STATE-ID          PIC X(02) VALUE SPACE.          
           05  S-DATE-OF-BIRTH          PIC X(10) VALUE SPACE.          
           05  S-NO-SCORES              PIC S9(9) COMP VALUE 0.         
           05  S-NO-HOURS               PIC S9(9) COMP VALUE 0.         
      *                                                                 02430000
       01  SWITCHES.                                                    
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
      *                                                                 02510000
       01  WS-MISCELLANEOUS.                                            
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04072'.     
           05  WS-CUSTOMER-NO           PIC 9(10) .                     
           05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.         
      *                                                                 02700000
       01  NULL-INDICATORS.                                             
           05  WS-NULL-IND-DOB          PIC S9(4) COMP  VALUE 0.        
      *                                                                 02700000
      ******************************************************************00830000
      *  THIS COPYBOOK IS USED FOR ERROR HANDLING - ABENDS.           **00840000
      ******************************************************************00850000
      *                                                                 00860000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
      *                                                                         
       01  WS-END                      PIC X(40)                        
               VALUE 'WORKING STORAGE FOR CSR04072 ENDS HERE '.         
HPCCDM*EJECT                                                            01940000
      *                                                                         
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
HPCCDM*EJECT                                                            01940000
      *                                                                         
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO                                        
                LINK-COMPANY-NO.                                        
HPCCDM*EJECT                                                            01940000
      *                                                                 02720000
      ******************************************************************02730000
      * 0000-MAINLINE                                                  *02740000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02750000
      ******************************************************************02760000
       0000-MAINLINE.                                                   
      *                                                                 02790000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 02840000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02870000
      ******************************************************************02880000
      * 0100-INITIALIZE                                                *02890000
      *                                                                *02900000
      *     1. INITIALIZE WS FIELD                                     *02910000
      *     2. DECLARE TEMP TABLE USED TO SEND DATA                    *02920000
      *                                                                *02950000
      ******************************************************************02960000
       0100-INITIALIZE.                                                 
      *                                                                 03200000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 03200000
           MOVE LINK-CUSTOMER-NO TO PARM-CUSTOMER-NO.                   
           MOVE LINK-COMPANY-NO  TO PARM-COMPANY-NO.                    
      *                                                                 03200000
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
              :S-RETURN-CODE          AS    RETURN_CODE                 
             ,:S-NAME-FORMAT          AS    NAME_FORMAT                 
             ,:S-FIRST-NAME           AS    FIRST_NAME                  
             ,:S-MIDDLE-NAME          AS    MIDDLE_NAME                 
             ,:S-LAST-NAME            AS    LAST_NAME                   
             ,:S-TITLE-SUFFIX-1       AS    TITLE_SUFFIX_1              
             ,:S-SSN                  AS    SSN                         
             ,:S-DRIVERS-LICENSE-NO   AS    DRIVERS_LICENSE_NO          
             ,:S-CODE-STATE-ID        AS    CODE_STATE_ID               
             ,:S-DATE-OF-BIRTH        AS    DATE_OF_BIRTH               
             ,:S-NO-SCORES            AS    NO_SCORES                   
             ,:S-NO-HOURS             AS    NO_HOURS                    
             FROM CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE          AS    RETURN_CODE                         
MFA-TR*      ,:S-NAME-FORMAT          AS    NAME_FORMAT                         
MFA-TR*      ,:S-FIRST-NAME           AS    FIRST_NAME                          
MFA-TR*      ,:S-MIDDLE-NAME          AS    MIDDLE_NAME                         
MFA-TR*      ,:S-LAST-NAME            AS    LAST_NAME                           
MFA-TR*      ,:S-TITLE-SUFFIX-1       AS    TITLE_SUFFIX_1                      
MFA-TR*      ,:S-SSN                  AS    SSN                                 
MFA-TR*      ,:S-DRIVERS-LICENSE-NO   AS    DRIVERS_LICENSE_NO                  
MFA-TR*      ,:S-CODE-STATE-ID        AS    CODE_STATE_ID                       
MFA-TR*      ,:S-DATE-OF-BIRTH        AS    DATE_OF_BIRTH                       
MFA-TR*      ,:S-NO-SCORES            AS    NO_SCORES                           
MFA-TR*      ,:S-NO-HOURS             AS    NO_HOURS                            
MFA-TR*      FROM SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03230000
      ******************************************************************03240000
      * 1000-PROCESS-INPUT                                             *03250000
      *                                                                *03260000
      *     MOVE PARM VALUE/S TO WS FIELDS.                            *03270000
      *                                                                *03280000
      ******************************************************************03290000
       1000-PROCESS-INPUT.                                              
      *                                                                 03680000
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03320000
           MOVE PARM-CUSTOMER-NO-RED TO WS-CUSTOMER-NO.                 
           MOVE PARM-COMPANY-NO      TO WS-COMPANY-NO .                 
      *                                                                 03343000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03370000
      ************************************************************      03580000
      *   2000-PROCESS-OUTPUT                                    *      03590000
      *                                                          *      03600000
      *   1. RETRIEVE DB2 DATA AND BUILD RESULT SET              *      03620000
      *   2. SEND RESULT SET                                     *      03630000
      *                                                          *      03640000
      ************************************************************      03650000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 03680000
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03680000
           PERFORM 2100-BUILD-RESULT THRU 2100-EXIT.                    
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
      *                                                                 03730000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03760000
      ******************************************************************11460000
      *   2100-BUILD-RESULT                                            *11470000
      *                                                                *11480000
      *   1.  SELECT AND FORMAT ALL CUSTOMER DETAIL INFORMATION        *11500000
      *       TO BE RETURNED.                                          *11512000
      *                                                                *11520000
      ******************************************************************11530000
       2100-BUILD-RESULT.                                               
      *                                                                 03680000
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 11560000
           MOVE WS-CUSTOMER-NO         TO CE-CUSTOMER-NO.               
           PERFORM 7000-SELECT-CUSTOMER-DATA   THRU 7000-EXIT.          
           MOVE DQ-NAME-FORMAT         TO S-NAME-FORMAT.                
           MOVE DQ-FIRST-NAME          TO S-FIRST-NAME.                 
           MOVE DQ-MIDDLE-NAME         TO S-MIDDLE-NAME.                
           MOVE DQ-LAST-NAME           TO S-LAST-NAME.                  
           MOVE DQ-TITLE-SUFFIX-1      TO S-TITLE-SUFFIX-1.             
           MOVE CE-SSN                 TO S-SSN.                        
           MOVE CE-DRIVERS-LICENSE-NO  TO S-DRIVERS-LICENSE-NO.         
           MOVE CE-CODE-STATE-ID       TO S-CODE-STATE-ID.              
           MOVE CE-DATE-OF-BIRTH       TO S-DATE-OF-BIRTH.              
      *                                                                 11560000
P00551     IF WS-COMPANY-NO = '30'                                      
P00551        MOVE '01'                   TO C8-COMPANY-NO              
P00551     ELSE                                                         
              MOVE WS-COMPANY-NO          TO C8-COMPANY-NO              
P00551     END-IF.                                                      
           MOVE 'NO-SCORES-ALLOWED'    TO C8-DELINQ-CD.                 
           PERFORM 7100-GET-DELIQUENCY-VALUES THRU 7100-EXIT.           
           MOVE C8-DELINQ-VALUE        TO S-NO-SCORES.                  
      *                                                                 03200000
           MOVE 'NO-HOURS-RANGE'       TO C8-DELINQ-CD.                 
           PERFORM 7100-GET-DELIQUENCY-VALUES THRU 7100-EXIT.           
           MOVE C8-DELINQ-VALUE        TO S-NO-HOURS.                   
      *                                                                 11801000
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14130000
      ******************************************************************13260000
      *   7000-SELECT-CUSTOMER-DATA.                                   *13270000
      *                                                                *13271000
      *   1.  GETS CUSTOMER DETAILS                                    *13272000
      *                                                                *13271000
      ******************************************************************13280000
       7000-SELECT-CUSTOMER-DATA.                                       
      *                                                                 13310000
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           IF CE-DATE-OF-BIRTH = SPACES OR LOW-VALUES                   
               MOVE -1         TO WS-NULL-IND-DOB                       
           ELSE                                                         
               MOVE 0          TO WS-NULL-IND-DOB                       
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) DQ.NAME_FORMAT,
              DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.TITLE_SUFFIX_1,
              CE.SSN,
              CE.DRIVERS_LICENSE_NO,
              CE.CODE_STATE_ID,
              CIS.CHAR2$DATE(CE.DATE_OF_BIRTH,'USA')                  
              INTO    :DQ-NAME-FORMAT                                   
                     ,:DQ-FIRST-NAME                                    
                     ,:DQ-MIDDLE-NAME                                   
                     ,:DQ-LAST-NAME                                     
                     ,:DQ-TITLE-SUFFIX-1                                
                     ,:CE-SSN                                           
                     ,:CE-DRIVERS-LICENSE-NO                            
                     ,:CE-CODE-STATE-ID                                 
                     ,:CE-DATE-OF-BIRTH :WS-NULL-IND-DOB                 
              FROM   CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
                    ,CSS_NAME DQ WITH(READUNCOMMITTED)                          
              WHERE  CE.CUSTOMER_NO     = :CE-CUSTOMER-NO               
               AND   CE.CUSTOMER_TYPE   = 'C'                           
               AND   DQ.NAME_ID         = CE.NAME_ID                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT  DQ.NAME_FORMAT                                            
MFA-TR*              ,DQ.FIRST_NAME                                             
MFA-TR*              ,DQ.MIDDLE_NAME                                            
MFA-TR*              ,DQ.LAST_NAME                                              
MFA-TR*              ,DQ.TITLE_SUFFIX_1                                         
MFA-TR*              ,CE.SSN                                                    
MFA-TR*              ,CE.DRIVERS_LICENSE_NO                                     
MFA-TR*              ,CE.CODE_STATE_ID                                          
MFA-TR*              ,CHAR(DATE(CE.DATE_OF_BIRTH),USA)                          
MFA-TR*       INTO    :DQ-NAME-FORMAT                                           
MFA-TR*              ,:DQ-FIRST-NAME                                            
MFA-TR*              ,:DQ-MIDDLE-NAME                                           
MFA-TR*              ,:DQ-LAST-NAME                                             
MFA-TR*              ,:DQ-TITLE-SUFFIX-1                                        
MFA-TR*              ,:CE-SSN                                                   
MFA-TR*              ,:CE-DRIVERS-LICENSE-NO                                    
MFA-TR*              ,:CE-CODE-STATE-ID                                         
MFA-TR*              ,:CE-DATE-OF-BIRTH:WS-NULL-IND-DOB                         
MFA-TR*       FROM   CSS_CUST_STATS CE                                          
MFA-TR*             ,CSS_NAME DQ                                                
MFA-TR*       WHERE  CE.CUSTOMER_NO     = :CE-CUSTOMER-NO                       
MFA-TR*        AND   CE.CUSTOMER_TYPE   = 'C'                                   
MFA-TR*        AND   DQ.NAME_ID         = CE.NAME_ID                            
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                   13560000
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13581000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13600000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CE-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 13600000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13600000
      ******************************************************************13260000
      *   7100-GET-DELIQUENCY-VALUES                                   *13270000
      *                                                                *13271000
      *   1.  GETS THE DELIQUENCY VALUES FOR ESTABLISHED NUMBER OF     *13272000
      *       HOURS AND NUMBER OF SCORES BASED ON COMPANY NUMBER       *13272100
      *                                                                *13271000
      ******************************************************************13280000
       7100-GET-DELIQUENCY-VALUES.                                      
      *                                                                 13310000
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
      *                                                                 03760000
           EXEC SQL                                                     
              SELECT TOP(1) C8.DELINQ_VALUE                                    
              INTO  :C8-DELINQ-VALUE                                    
              FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                    
              WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                      
               AND  C8.COMPANY_NO  = :C8-COMPANY-NO                     
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*       SELECT C8.DELINQ_VALUE                                    13330000
MFA-TR*       INTO  :C8-DELINQ-VALUE                                    13440101
MFA-TR*       FROM  CSS_DELINQUENCY C8                                  13550000
MFA-TR*       WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                      13560000
MFA-TR*        AND  C8.COMPANY_NO  = :C8-COMPANY-NO                     13560000
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                   13560000
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 13581000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 13600000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZERO   TO C8-DELINQ-VALUE                       
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE 'SELECT'          TO ABEND-FUNCTION              
                  MOVE 'CSS_DELINQUENCY' TO TABLE-1                     
                  MOVE 'C8.DELINQ_CD'    TO TABLE-ELEMENT-1             
                  MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
      *                                                                 13600000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14130000
      ************************************************************      03580000
      *   8100-SEND-RESULT                                       *      03590000
      *      SEND RESULT SET                                     *      03630000
      ************************************************************      03650000
      *                                                                 14760000
       8100-SEND-RESULT.                                                
           ADD 1 TO CTR-ROWS.                                           
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14760000
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD00321                                                
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
