       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04071.                                       
COB303 DATE-WRITTEN.  JANUARY 2007.                                     
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      *  THIS PROGRAM IS CALLED WHEN CREDIT SCORE IS RECEIVED FROM    *         
      *  FROM EQUIFAX (CSR02329) OR ITPA IS CHANGED TO RESOLVE THRU  *          
      *  NEW ADMIN PANEL (CSR02271).                                  *         
      *                                                               *         
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
T36013*  12/10/07   CVNS      PROCEDURE ORIGINALLY CODED.             *         
      *             CHENNAI                                           *         
C36013*  09/15/08   MJ13662   DO NOT CREATE WQ 460 WHEN MATCH CODE,   *         
C36013*                       SAFE SCAN OR HIT CODE IS SENT AS A      *         
C36013*                       SPACE FROM EQUIFAX.                     *         
IDEA68*  02/09/09   MJ13662   ONLY MOVE CUSTOMER NO TO COMMENTS WHEN  *         
IDEA68*                       CREATING WQ 449.                        *         
P00342*  03/05/10   MJ13662   IF FINAL DECISION IS MATCH CODE 0,      *         
P00342*                       GENERATE NEW WQ 499 FOR NAME MISMATCH.  *         
P00342*                       ONLY CSR WILL RECEIVE THIS WQ.          *         
P00551*  08/31/11   RC41079   REMOVED PARM-COMPANY-NO CHECK IN PARA-  *         
P00551*                       2200-. ALSO ADDED WHEN  PARM-COMPANY-NO *         
P00551*                       = '30' MOVE '01' TO C8-COMPANY-NO WHEN  *         
P00551*                       GETTING DATABASE IN PARA- 0100-.        *         
A03119*  02/24/11   MJ13662   WHEN OBTAINING DEFAULT VALUES, ADDITIONAL         
A03119*                       CREDIT REQUEST REASON OF 'H' (HVAC)     *         
A03119*                       NEEDS TO BE TREATED SAME AS 'M'         *         
A03119*                       MERCHANDISE.                            *         
A04527*  11/19/13   MJ13662   SAVE HDR-RETURN-CODE IN WQ FOR RESEARCH *         
A04527*                       WHEN 0000 IS NOT SENT IN HDR-RETURN-CODE*         
I01701*  7/09/14    MJ13662   ADDED ADDITIONAL PARM (SPECIAL OFFER CD)*         
I01701*                       THAT WILL BE USED FOR HVAC TO MAKE      *         
I01701*                       DECISIONS FROM CSS_DEP_REQUIREMNT TABLE.*         
A04880*  8/20/14    MJ13662   IF SAFESCAN 'O' IS RETURNED AND IS THE  *         
A04880*                       FINAL DECISION, GENERATE WQ 449.        *         
A05007*  9/04/14    MC95456   STORE CRED-BUR-TXT FROM CSS_CRED_BUR_TXT*         
A05007*                       IN COMMENTS ON CSS_CREDIT_HIST.         *         
ACT191*  10/01/15   MJ13662   IN CALL TO CSS_DEP_REQUIREMNT, FOR SEB  *         
                              DO NOT USE SELECTION CRITERIA SPECIAL-  * 
                              OFFER-CD.                               * 
                              APPL 5136.                              * 
A05198*  11/04/15   MJ13662   RECEIVE 2 SCORES (BEACON AND AEP)       *         
A05198*                       AND NEW DELINQUENCY VALUE FROM          *         
A05198*                       CSR02329/CSR03495 FOR CALL              *         
A05198*                       IN CSS_DEP_REQUIREMNT.                  *         
A05198*                       RETURN SCORE-MODEL-CD IN RESULT.        *         
ACT084*  04/14/16   SS7F226   REPLACE CSS_WQ_ITEMS_MF WITH            *         
ACT084*              A04860   CSS_WQ_ITEMS BY CALLING MCSCB077        *         
AP5655*  10/18/16   MJ13662   FOR REG-GROUP-CD 200 WHEN DEFAULT ERROR *         
AP5655*                       IS DETERMINED FOR FINAL DECISION, DO NOT*         
AP5655*                       SET CREDIT-ACTION = WAIVE, KEEP AS      *         
AP5655*                       COLLECT, LIKE ALL THE OTHERS.           *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04071'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR CSR02026 STARTS HERE'.            
      *                                                                         
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ** DCLGEN FOR CSS_DEP_REQUIREMENT(D6)                                     
           EXEC SQL                                                             
                INCLUDE TBDEPRQ                                                 
           END-EXEC.                                                            
      *                                                                         
      ** DCLGEN FOR CSS_APPL_RESPONSE(KE)                                       
           EXEC SQL                                                             
                INCLUDE TBAPSRES                                                
           END-EXEC.                                                            
      *                                                                         
      ** DCLGEN FOR CSS_CRED_APPL_STAT(IW)                                      
           EXEC SQL                                                             
                INCLUDE TBCRAPST                                                
           END-EXEC.                                                            
      *                                                                         
      ** DCLGEN FOR CSS_CRED_BUR_MATRX(DG)                                      
           EXEC SQL                                                             
                INCLUDE TBCRBUMX                                                
           END-EXEC.                                                            
      *                                                                         
      ** DCLGEN FOR CSS_CRED_MSG_HIER(CW)                                       
           EXEC SQL                                                             
              INCLUDE TBCRHIE                                                   
           END-EXEC.                                                            
      *                                                                         
      ** DCLGEN FOR CSS_DELINQUENCY(C8)                                         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
A05007** DCLGEN FOR CSS_CRED_BUR_TXT                                            
A05007     EXEC SQL                                                             
A05007          INCLUDE TBCBUTXT                                                
A05007     END-EXEC.                                                            
      *                                                                         
ACT084**************************************************************            
ACT084*    WORKING STORAGE COPYBOOK FOR MCSCB077                                
ACT084**************************************************************            
ACT084     EXEC SQL                                                             
ACT084        INCLUDE CWS00077                                                  
ACT084     END-EXEC.                                                            
ACT084*                                                                         
      *****************************************************************         
      * COBOL WORKING STORAGE COPY BOOKS                              *         
      *****************************************************************         
      *                                                                         
      ** USED FOR SQL ERROR CHECKING *                                          
           COPY CWS00303.                                                       
      *                                                                         
      ** USED FOR ERROR HANDLING *                                              
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  PROGRAM-NAME                     PIC X(08) VALUE 'CSR04071'. 
                                                                        
       01  WS-MISC.                                                     
           05  WS-END-OF-TABLE              PIC X(01)  VALUE 'N'.       
               88 END-OF-TABLE                         VALUE 'Y'.       
           05  WS-ITPA-EXISTS               PIC X(01)  VALUE 'N'.       
               88 ITPA-EXISTS                          VALUE 'Y'.       
           05  END-OF-MATRIX-TABLE          PIC X(01)  VALUE 'N'.       
           05  WS-DENY-EXISTS               PIC X(01)  VALUE 'N'.       
               88 DENY-EXISTS                          VALUE 'Y'.       
           05  WS-ONHOLD-EXISTS             PIC X(01)  VALUE 'N'.       
               88 ONHOLD-EXISTS                        VALUE 'Y'.       
           05  WS-DATABASE                  PIC 9(01)  VALUE 1.         
               88  CSR-DATABASE                        VALUE 1.         
               88  SEB-DATABASE                        VALUE 2.         
           05 WS-ROW-FOUND-SW               PIC X(01)  VALUE 'N'.       
              88 ROW-FOUND                             VALUE 'Y'.       
           05  WS-ACTION-FL                 PIC X(01) VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP         PIC X(26).                  
           05  WS-CREDIT-ACTION-FL          PIC X(01).                  
           05  WS-CR-RQST-REASON-CD         PIC X(01).                  
           05  WS-SCEG                      PIC X(2)  VALUE '01'.       
           05  WS-PSNC                      PIC X(2)  VALUE '26'.       
           05  WS-CUSTOMER-N                PIC X(10) VALUE SPACES.     
           05  WS-CUSTOMER-NUM REDEFINES  WS-CUSTOMER-N                 
                                            PIC 9(10).                  
           05  WS-CUSTOMER-NO               PIC S9(10)V USAGE COMP-3    
                                                      VALUE +0.         
           05  WS-4071-WQ-RET-CODE          PIC S9(09) COMP VALUE 0.    
      *                                                                 02580000
           05  WS-CURRENT-DATE             PIC X(10)  VALUE SPACES.     
A05198     05  WS-CR-ACTION-FL-A           PIC X(05)  VALUE SPACES.     
A05198     05  WS-CR-ACTION-FL-B           PIC X(05)  VALUE SPACES.     
A05198     05  WS-SPECIAL-OFFER-A          PIC X(01)  VALUE SPACES.     
A05198     05  WS-SPECIAL-OFFER-B          PIC X(01)  VALUE SPACES.     
ACT084     05  MCSCB077                    PIC X(08)  VALUE 'MCSCB077'. 
ACT084     05  WS-MCSCB077-RET-CODE        PIC S9(04) COMP VALUE 0.     
      *                                                                 02580000
A05198 01 WS-SCORE-REDEFINITION.                                        
A05198     05  WS-SCORE-ALPHA              PIC X(05).                   
A05198     05  WS-SCORE-DEC REDEFINES WS-SCORE-ALPHA                    
                                           PIC 9(05).                   
A05198     05  WS-SCORE                    PIC S9(9) USAGE COMP         
                                                      VALUE +0.         
      *                                                                 02580000
       01 WS-WQ-VARS.                                                   
           05 WS-WQ-CATEGORY-ID            PIC S9(04) USAGE COMP.       
           05 WS-WQ-COMMENTS.                                           
              49 WS-WQ-COMMENTS-LEN        PIC S9(04) USAGE COMP.       
              49 WS-WQ-COMMENTS-TEXT       PIC X(250).                  
P00342     05 WS-WQ-PRIORITY               PIC X(01).                   
      *                                                                         
           05 WS-ERR-COMMENT.                                           
              10  FILLER                   PIC X(44)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE '. 
              10  FILLER                   PIC X(39)                    
                  VALUE 'PROCESSING CSS_CRED_MSG_HIER USER TABLE'.      
           05 WS-ERR-COMMENT1.                                          
              10  FILLER                   PIC X(45)                    
                  VALUE 'DATA ERROR - INVALID SOURCE CALLING CSR04071'. 
              10  FILLER                   PIC X(14)                    
                  VALUE ',WS-PROGRAM = '.                               
              10  WS-PROGRAM               PIC X(08).                   
           05 WS-ERR-COMMENT2.                                          
              10  FILLER                   PIC X(44)                    
                  VALUE 'DATA ERROR - HIER-SCORE-TYPE-CD NOT FOUND IN'. 
              10  FILLER                   PIC X(21)                    
                  VALUE 'WORKING STORAGE TABLE'.                        
           05 WS-ERR-COMMENT3.                                          
              10  FILLER                   PIC X(45)                    
                  VALUE 'DATA ERROR - ERROR CODE ON ERROR SEGMENT  IS '.
              10  FILLER                   PIC X(08)                    
                  VALUE 'INVALID '.                                     
A04527        10  FILLER                   PIC X(22)                    
A04527            VALUE 'EQUIFAX RETURN CODE = '.                       
A04527        10  WS-HDR-RETURN-CODE       PIC X(04).                   
           05 WS-ERR-COMMENT6.                                          
              10  FILLER                   PIC X(33)                    
                  VALUE 'DATA ERROR - VALUE NOT FOUND ON  '.            
              10  FILLER                   PIC X(29)                    
                  VALUE 'CSS_CRED_BUR_MATRX USER TABLE'.                
           05 WS-ERR-COMMENT7.                                          
              10  FILLER                   PIC X(44)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE '. 
              10  FILLER                   PIC X(40)                    
                  VALUE 'RETRIEVING DATA FROM CSS_CRED_BUR_MATRX '.     
              10  FILLER                   PIC X(10)                    
                  VALUE 'USER TABLE'.                                   
           05 WS-ERR-COMMENT8.                                          
              10  FILLER                   PIC X(46)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE '. 
              10  FILLER                   PIC X(30)                    
                  VALUE 'RETRIEVING DEFAULT DATA FROM '.                
              10  FILLER                   PIC X(25)                    
                  VALUE 'CSS_CRED_BUR_MATRX  TABLE'.                    
           05 WS-ERR-COMMENT9.                                          
              10  FILLER                   PIC X(43)                    
                  VALUE 'DATA ERROR - DENY APPLICATION STATUS VALUE '.  
              10  FILLER                   PIC X(34)                    
                  VALUE 'NOT FOUND IN WORKING STORAGE TABLE'.           
           05 WS-ERR-COMMENT10.                                         
              10  FILLER                   PIC X(46)                    
                  VALUE 'DATA ERROR - ONHOLD APPLICATION STATUS VALUE '.
              10  FILLER                   PIC X(34)                    
                  VALUE 'NOT FOUND IN WORKING STORAGE TABLE'.           
           05 WS-ERR-COMMENT11.                                         
              10  FILLER                   PIC X(45)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE  '.
              10  FILLER                   PIC X(40)                    
                  VALUE 'RETRIEVING DATA FROM CSS_DEP_REQUIREMNT '.     
              10  FILLER                   PIC X(10)                    
                  VALUE 'USER TABLE'.                                   
           05 WS-ERR-COMMENT12.                                         
              10  FILLER                   PIC X(45)                    
                  VALUE 'DATA ERROR - DEPOSIT ACTION VALUE NOT FOUND  '.
              10  FILLER                   PIC X(24)                    
                  VALUE 'IN WORKING STORAGE TABLE'.                     
           05 WS-ERR-COMMENT13.                                         
              10  FILLER                   PIC X(41)                    
                  VALUE 'DATA ERROR - DEFAULT VALUE NOT FOUND IN  '.    
              10  FILLER                   PIC X(21)                    
                  VALUE 'WORKING STORAGE TABLE'.                        
           05 WS-ERR-COMMENT14.                                         
              10  FILLER                   PIC X(45)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE  '.
              10  FILLER                   PIC X(45)                    
                  VALUE 'RETRIEVING DATA FROM CSS_CRED_BUR_TXT USER   '.
              10  FILLER                   PIC X(05)                    
                  VALUE 'TABLE'.                                        
           05 WS-ERR-COMMENT15.                                         
              10  FILLER                   PIC X(37)                    
                  VALUE 'DATA ERROR - ITPA VALUE NOT FOUND IN '.        
              10  FILLER                   PIC X(21)                    
                  VALUE 'WORKING STORAGE TABLE'.                        
           05 WS-ERR-COMMENT16.                                         
              10  FILLER                   PIC X(44)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE '. 
              10  FILLER                   PIC X(20)                    
                  VALUE 'RETRIEVING TIMESTAMP'.                         
           05 WS-ERR-COMMENT17.                                         
              10  FILLER                   PIC X(44)                    
                  VALUE 'DATA ERROR - UNSUCCESSFUL RETURN CODE WHILE '. 
              10  FILLER                   PIC X(42)                    
                  VALUE 'RETRIEVING DATA FROM CSS_DELINQUENCY USER '.   
              10  FILLER                   PIC X(05)                    
                  VALUE 'TABLE'.                                        
           05 WS-WQ-HIT-COMMENTS.                                       
              10  FILLER                   PIC X(13)                    
                  VALUE 'CODE VALUE = '.                                
              10  WS-HIT-SCORE-CD          PIC X(04) VALUE SPACES.      
              10  FILLER                   PIC X(17)                    
                  VALUE ', CODE TYPE = HIT'.                            
           05 WS-WQ-SAFE-COMMENTS.                                      
              10  FILLER                   PIC X(13)                    
                  VALUE 'CODE VALUE = '.                                
              10  WS-SAFE-SCORE-CD         PIC X(04) VALUE SPACES.      
              10  FILLER                   PIC X(22)                    
                  VALUE ', CODE TYPE = SAFESCAN'.                       
           05 WS-WQ-MATCH-COMMENTS.                                     
              10  FILLER                   PIC X(13)                    
                  VALUE 'CODE VALUE = '.                                
              10  WS-MATCH-SCORE-CD        PIC X(04) VALUE SPACES.      
              10  FILLER                   PIC X(19)                    
                  VALUE ', CODE TYPE = MATCH'.                          
           05 WS-WQ-CRED-BUR-COMMENTS.                                  
              10  FILLER                   PIC X(13)                    
                  VALUE 'CODE VALUE = '.                                
              10  WS-WQ-CR-SCORE-CD        PIC X(05).                   
              10  FILLER                   PIC X(15)                    
                  VALUE ', CODE TYPE = '.                               
              10  WS-WQ-CR-SCORE-TYPE-CD   PIC X(02).                   
                                                                        
           05 WS-WQ-APPL-STAT-COMMENTS.                                 
              10  FILLER                   PIC X(13)                    
                  VALUE 'CUSTOMER # = '.                                
              10  WS-WQ-APPL-CUST          PIC X(10) VALUE SPACES.      
                                                                        
           05 WS-WQ-ONHOLD-COMMENTS.                                    
              10  FILLER                   PIC X(13)                    
                  VALUE 'CUSTOMER # = '.                                
              10  WS-WQ-ONHOLD-CUST        PIC X(10) VALUE SPACES.      
              10  FILLER                   PIC X(30)                    
                  VALUE '. CREDIT BUREAU INFO RETURNED '.               
              10  FILLER                   PIC X(28)                    
                  VALUE 'FROM EQUIFAX DRIVING ON HOLD'.                 
                                                                        
           05 WS-WQ-DATABASE-ERR-COMMENTS.                              
              10  FILLER                   PIC X(45)                    
                  VALUE 'DATABASE ERROR.PLEASE SUBMIT TO THE HELP DESK'.
              10  FILLER                   PIC X(16)                    
                  VALUE 'ERROR MESSAGE = '.                             
              10  WS-ERR-COMMENTS          PIC X(100).                  
              10  WS-ABEND-FUNCTION        PIC X(08).                   
              10  WS-TABLE-1               PIC X(20).                   
              10  WS-TABLE-ELEMENT-1       PIC X(20).                   
              10  WS-HOSTVAR-ELEMENT-1     PIC X(20).                   
                                                                        
P00342     05 WS-WQ-POSID-COMMENTS.                                     
P00342        10  FILLER                   PIC X(19)                    
P00342            VALUE 'POSID NAME MISMATCH'.                          
                                                                        
       01  WS-CSR00028-OUTPUT.                                          
           05  WS-CSR00028-RET-CODE        PIC S9(09) COMP VALUE 0.     
                                                                        
       01  WS-CRED-MSG-TABLE.                                           
           05  WS-CRED-MSG-DATA OCCURS 50 TIMES                         
               INDEXED BY WS-INDEX3.                                    
               10  WS-CR-SCORE-TYPE-CD      PIC X(02).                  
COB305         10 WS-CRED-MSG-PRIORITY        PIC S9(3)V USAGE COMP-3 
COB305           VALUE 0.    
       01  WS-MATRIX-TABLE.                                             
           05  WS-MATRIX-DATA OCCURS 50 TIMES                           
               INDEXED BY WS-INDEX1.                                    
               10  TAB-CR-RQST-REASON-CD     PIC X(1).                  
               10  TAB-CR-SCORE-TYPE-CD      PIC X(2).                  
               10  TAB-CR-SCORE-CD           PIC X(5).                  
               10  TAB-CREDIT-ACTION-FL      PIC X(1).                  
               10  TAB-APPL-STATUS-CD        PIC X(1).                  
               10  TAB-APPL-RESULT-CD        PIC X(1).                  
               10  TAB-APPL-RESPONSE-CD      PIC X(2).                  
       01  WS-DEFAULT-TABLE.                                            
           05  WS-DEFAULT-DATA OCCURS 50 TIMES                          
               INDEXED BY WS-INDEX2.                                    
               10  DEF-CR-RQST-REASON-CD     PIC X(1).                  
               10  DEF-CR-SCORE-TYPE-CD      PIC X(2).                  
               10  DEF-CR-SCORE-CD           PIC X(5).                  
               10  DEF-CREDIT-ACTION-FL      PIC X(1).                  
               10  DEF-APPL-STATUS-CD        PIC X(1).                  
               10  DEF-APPL-RESULT-CD        PIC X(1).                  
               10  DEF-APPL-RESPONSE-CD      PIC X(2).                  
                                                                        
      *01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                      PIC S9(9) COMP VALUE 0.    
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE                PIC S9(9) COMP VALUE 0.    
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.    
           05  S-APPL-STATUS-CD              PIC X(02) VALUE SPACE.     
           05  S-CR-SCORE-TYPE-CD            PIC X(02) VALUE SPACE.     
           05  S-CR-SCORE-CD                 PIC X(05) VALUE SPACE.     
           05  S-CR-ACTION-FL                PIC X(01) VALUE SPACE.     
           05  S-APPL-RESULT-CD              PIC X(01) VALUE SPACE.     
           05  S-APPL-RESPONSE-CD            PIC X(02) VALUE SPACE.     
           05  S-CR-COMMENTS                 PIC X(210) VALUE SPACE.    
A05198     05  S-SCORE-MODEL-CD              PIC X(1)  VALUE SPACE.     
                                                                        
       01  WS-END                            PIC X(40)                  
           VALUE 'WORKING STORAGE FOR CSR04071 ENDS HERE  '.            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-PROGRAM-ID                    PIC  X(08).                
       01 PARM-HDR-RETURN-CODE               PIC  X(04).                
       01 PARM-ITPA-EXISTS-CD                PIC  X(01).                
       01 PARM-COMPANY-NO                    PIC  X(02).                
       01 PARM-HIT-CD                        PIC  X(01).                
       01 PARM-SAFESCAN-CD                   PIC  X(01).                
       01 PARM-MATCH-CD                      PIC  X(01).                
A05198 01 PARM-REJ-CD                        PIC  X(04).                
       01 PARM-FORMAT-ERR                    PIC  X(03).                
       01 PARM-VALID-ERR                     PIC  X(03).                
       01 PARM-PROCESS-ERR                   PIC  X(03).                
       01 PARM-RQST-REASON-CD                PIC  X(01).                
       01 PARM-SENIOR-FL                     PIC  X(01).                
       01 PARM-REG-GROUP-CD                  PIC  X(03).                
       01 PARM-BEACON-SCORE                  PIC  X(05).                
       01 PARM-CUSTOMER-NO                   PIC  X(10).                
       01 PARM-USER-ID                       PIC  X(07).                
I01701 01 PARM-SPECIAL-OFFER-CD              PIC  X(01).                
A05198 01 PARM-ADDL-SCORE                    PIC  X(05).                
A05198 01 PARM-ADDL-SCORE-IND                PIC  X(01).                
                                                                        
      ******************************************************************        
      *    DB2 CURSOR DECLARATIONS                                     *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * FETCHES ALL THE ROWS FROM THE CSS_CRED_MSG_HIER TABLE          *        
      * FOR SPECIFIED COMPANY NO.                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE CRED-MSG-CSR CURSOR FOR                           
               SELECT CR_SCORE_TYPE_CD                                  
                     ,CRED_MSG_PRIORITY                                 
                 FROM CSS_CRED_MSG_HIER WITH(READUNCOMMITTED)                   
                WHERE COMPANY_NO       = :PARM-COMPANY-NO               
             ORDER BY CRED_MSG_PRIORITY ASC                             
           FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CRED-MSG-CSR CURSOR FOR                                   
MFA-TR*        SELECT CR_SCORE_TYPE_CD                                          
MFA-TR*              ,CRED_MSG_PRIORITY                                         
MFA-TR*          FROM CSS_CRED_MSG_HIER                                         
MFA-TR*         WHERE COMPANY_NO       = :PARM-COMPANY-NO                       
MFA-TR*      ORDER BY CRED_MSG_PRIORITY ASC                                     
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * FETCHES ALL THE ROWS FROM THE CSS_CRED_BUR_MATRX  TABLE        *        
      * FOR SPECIFIED CR_SCORE_TYPE_CD.                                *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE DEFAULT-CSR  CURSOR FOR                           
               SELECT CR_SCORE_TYPE_CD                                  
                     ,CR_SCORE_CD                                       
                     ,CREDIT_ACTION_FL                                  
                     ,APPL_STATUS_CD                                    
                     ,APPL_RESULT_CD                                    
                     ,APPL_RESPONSE_CD                                  
                     ,CR_RQST_REASON_CD                                 
                 FROM CSS_CRED_BUR_MATRX WITH(READUNCOMMITTED)                  
                WHERE EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
                  AND EXPIRATION_DT    >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
                  AND COMPANY_NO        = :PARM-COMPANY-NO              
                  AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD          
                  AND SENIOR_FL         = :PARM-SENIOR-FL               
                  AND REG_GROUP_CD      = :PARM-REG-GROUP-CD            
                  AND CR_SCORE_TYPE_CD  LIKE :DG-CR-SCORE-TYPE-CD       
           FOR READ ONLY                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DEFAULT-CSR  CURSOR FOR                                   
MFA-TR*        SELECT CR_SCORE_TYPE_CD                                          
MFA-TR*              ,CR_SCORE_CD                                               
MFA-TR*              ,CREDIT_ACTION_FL                                          
MFA-TR*              ,APPL_STATUS_CD                                            
MFA-TR*              ,APPL_RESULT_CD                                            
MFA-TR*              ,APPL_RESPONSE_CD                                          
MFA-TR*              ,CR_RQST_REASON_CD                                         
MFA-TR*          FROM CSS_CRED_BUR_MATRX                                        
MFA-TR*         WHERE EFFECTIVE_DT     <= :WS-CURRENT-DATE                      
MFA-TR*           AND EXPIRATION_DT    >= :WS-CURRENT-DATE                      
MFA-TR*           AND COMPANY_NO        = :PARM-COMPANY-NO                      
MFA-TR*           AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD                  
MFA-TR*           AND SENIOR_FL         = :PARM-SENIOR-FL                       
MFA-TR*           AND REG_GROUP_CD      = :PARM-REG-GROUP-CD                    
MFA-TR*           AND CR_SCORE_TYPE_CD  LIKE :DG-CR-SCORE-TYPE-CD               
MFA-TR*    FOR FETCH ONLY WITH UR                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
       PROCEDURE DIVISION USING PARM-PROGRAM-ID                         
                              , PARM-HDR-RETURN-CODE                    
                              , PARM-ITPA-EXISTS-CD                     
                              , PARM-COMPANY-NO                         
                              , PARM-HIT-CD                             
                              , PARM-SAFESCAN-CD                        
                              , PARM-MATCH-CD                           
A05198                        , PARM-REJ-CD                             
                              , PARM-FORMAT-ERR                         
                              , PARM-VALID-ERR                          
                              , PARM-PROCESS-ERR                        
                              , PARM-RQST-REASON-CD                     
                              , PARM-SENIOR-FL                          
                              , PARM-REG-GROUP-CD                       
                              , PARM-BEACON-SCORE                       
                              , PARM-CUSTOMER-NO                        
                              , PARM-USER-ID                            
I01701                        , PARM-SPECIAL-OFFER-CD                   
A05198                        , PARM-ADDL-SCORE                         
A05198                        , PARM-ADDL-SCORE-IND                     
                               .                                        
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION            THRU 0100-EXIT.       
           PERFORM 1000-CRED-MSG-HIER             THRU 1000-EXIT.       
           PERFORM 1500-CRED-BUR-MATRX            THRU 1500-EXIT.       
           PERFORM 2000-MAIN-PROCESS              THRU 2000-EXIT.       
           PERFORM 9999-END-PROGRAM               THRU 9999-EXIT.       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE '0100'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 7000-SELECT-CURRENT-TIMESTAMP     THRU 7000-EXIT     
      *                                                                         
P00551     IF PARM-COMPANY-NO = '30'                                    
P00551        MOVE '01'                      TO C8-COMPANY-NO           
P00551     ELSE                                                         
              MOVE PARM-COMPANY-NO           TO C8-COMPANY-NO           
P00551     END-IF.                                                      
      *                                                                         
           MOVE PARM-CUSTOMER-NO          TO WS-CUSTOMER-N              
                                             WS-WQ-APPL-CUST            
                                             WS-WQ-ONHOLD-CUST          
           MOVE WS-CUSTOMER-NUM           TO WS-CUSTOMER-NO             
      *                                                                         
           PERFORM 7100-GET-DATABASE                 THRU 7100-EXIT     
           MOVE C8-DELINQ-VALUE           TO   WS-DATABASE.             
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                :S-RETURN-CODE        AS RETURN_CODE                    
               ,:S-APPL-STATUS-CD     AS APPL_STATUS_CD                 
               ,:S-CR-SCORE-TYPE-CD   AS CR_SCORE_TYPE_CD               
               ,:S-CR-SCORE-CD        AS CR_SCORE_CD                    
               ,:S-CR-ACTION-FL       AS CR_ACTION_FL                   
               ,:S-APPL-RESULT-CD     AS APPL_RESULT_CD                 
               ,:S-APPL-RESPONSE-CD   AS APPL_RESPONSE_CD               
               ,:S-CR-COMMENTS        AS CR_COMMENTS                    
               ,:S-SCORE-MODEL-CD     AS SCORE_MODEL_CD                 
              FROM                                                      
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*         :S-RETURN-CODE        AS RETURN_CODE                            
MFA-TR*        ,:S-APPL-STATUS-CD     AS APPL_STATUS_CD                         
MFA-TR*        ,:S-CR-SCORE-TYPE-CD   AS CR_SCORE_TYPE_CD                       
MFA-TR*        ,:S-CR-SCORE-CD        AS CR_SCORE_CD                            
MFA-TR*        ,:S-CR-ACTION-FL       AS CR_ACTION_FL                           
MFA-TR*        ,:S-APPL-RESULT-CD     AS APPL_RESULT_CD                         
MFA-TR*        ,:S-APPL-RESPONSE-CD   AS APPL_RESPONSE_CD                       
MFA-TR*        ,:S-CR-COMMENTS        AS CR_COMMENTS                            
MFA-TR*        ,:S-SCORE-MODEL-CD     AS SCORE_MODEL_CD                         
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1000-CRED-MSG-HIER.                                           *         
      * CURSOR TO EXTRACT  CREDIT PRIORITY VALUES.                    *         
      *****************************************************************         
      *                                                                         
       1000-CRED-MSG-HIER.                                              
                                                                        
           PERFORM 7200-OPEN-CRED-MSG-CSR            THRU 7200-EXIT     
           PERFORM 7250-FETCH-CRED-MSG-CSR           THRU 7250-EXIT     
      *                                                                         
           INITIALIZE  WS-CRED-MSG-TABLE                                
      *                                                                         
           SET WS-INDEX3     TO  1                                      
           PERFORM 2400-LOAD-CURR-CRED-MSG-TBL       THRU 2400-EXIT     
             UNTIL WS-INDEX3 > 20  OR WS-ACTIVE-RETURN-CODE = NOT-FOUND 
           PERFORM 7300-CLOSE-CRED-MSG-CSR           THRU 7300-EXIT.    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1500-CRED-BUR-MATRX.                                          *         
      *    PROCESS THE CREDIT BUREAU MTRIX DATA                       *         
      *****************************************************************         
      *                                                                         
       1500-CRED-BUR-MATRX.                                             
      *                                                                         
           MOVE PARM-PROGRAM-ID              TO WS-PROGRAM              
           PERFORM 1650-DEFAULT-CURSOR       THRU 1650-EXIT             
      *                                                                         
           INITIALIZE  WS-MATRIX-TABLE                                  
      *                                                                         
           SET  WS-INDEX1 TO 1                                          
           IF WS-PROGRAM = 'CSR02329'                                   
              IF PARM-HDR-RETURN-CODE = '0000'                          
                  SET WS-INDEX3     TO  1                               
                  PERFORM 1550-HIER-TABLE VARYING WS-INDEX3 FROM 1 BY 1 
                                             UNTIL END-OF-TABLE         
              ELSE                                                      
                  PERFORM 1560-ERR-PROCESS         THRU 1560-EXIT       
              END-IF                                                    
           ELSE                                                         
               IF WS-PROGRAM = 'CSR03495'                               
                  IF (PARM-HIT-CD > SPACE)                              
                      OR (PARM-SAFESCAN-CD   > SPACE)                   
                      OR (PARM-MATCH-CD      > SPACE)                   
A05198                OR (PARM-REJ-CD > SPACE)                          
                      SET WS-INDEX3     TO  1                           
                      PERFORM 1570-HIER-TABLE-NOITPA                    
                        VARYING WS-INDEX3 FROM 1 BY 1 UNTIL END-OF-TABLE
                  ELSE                                                  
                      PERFORM 1560-ERR-PROCESS    THRU 1560-EXIT        
                  END-IF                                                
               ELSE                                                     
                  MOVE WS-ERR-COMMENT1    TO S-CR-COMMENTS              
                  MOVE '1500'             TO ACTIVE-PARAGRAPH           
                  MOVE SPACES             TO ABEND-FUNCTION             
                  MOVE SPACES             TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                  MOVE SPACES             TO TABLE-1                    
                  MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1            
                  MOVE WS-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1          
                                                                        
                  IF  CSR-DATABASE                                      
                      PERFORM 7900-CSR-MISSING-DATA  THRU 7900-EXIT     
                  ELSE                                                  
                      PERFORM 7950-SEB-MISSING-DATA  THRU 7950-EXIT     
                  END-IF                                                
                  PERFORM 9950-ERROR-LOG             THRU 9950-EXIT     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1550-HIER-TABLE.                                              *         
      *  LOADS THE  WS-MATRIX-TABLE IN PRIORITY ORDER.                *         
      *****************************************************************         
      *                                                                         
       1550-HIER-TABLE.                                                 
                                                                        
           MOVE WS-CR-SCORE-TYPE-CD(WS-INDEX3)                          
                                          TO DG-CR-SCORE-TYPE-CD        
           EVALUATE DG-CR-SCORE-TYPE-CD                                 
              WHEN 'I '                                                 
                    IF PARM-ITPA-EXISTS-CD > SPACE                      
                       MOVE PARM-ITPA-EXISTS-CD                         
                                          TO DG-CR-SCORE-CD             
                       PERFORM 7350-CRED-BUR-MATRX   THRU 7350-EXIT     
                       PERFORM 2500-LOAD-MATRX-TABLE THRU 2500-EXIT     
                       SET WS-INDEX1 UP BY 1                            
                    END-IF                                              
              WHEN 'H '                                                 
                    MOVE PARM-HIT-CD      TO DG-CR-SCORE-CD             
                    PERFORM 7350-CRED-BUR-MATRX      THRU 7350-EXIT     
                    PERFORM 2500-LOAD-MATRX-TABLE    THRU 2500-EXIT     
                    SET WS-INDEX1 UP BY 1                               
              WHEN 'S '                                                 
                    MOVE PARM-SAFESCAN-CD TO DG-CR-SCORE-CD             
                    PERFORM 7350-CRED-BUR-MATRX      THRU 7350-EXIT     
                    PERFORM 2500-LOAD-MATRX-TABLE    THRU 2500-EXIT     
                    SET WS-INDEX1 UP BY 1                               
              WHEN 'M '                                                 
                    MOVE PARM-MATCH-CD    TO DG-CR-SCORE-CD             
                    PERFORM 7350-CRED-BUR-MATRX      THRU 7350-EXIT     
                    PERFORM 2500-LOAD-MATRX-TABLE    THRU 2500-EXIT     
                    SET WS-INDEX1 UP BY 1                               
              WHEN 'R '                                                 
A05198              IF PARM-REJ-CD > SPACE                              
A05198                 MOVE PARM-REJ-CD                                 
                                          TO DG-CR-SCORE-CD             
                       PERFORM 7350-CRED-BUR-MATRX   THRU 7350-EXIT     
                       PERFORM 2500-LOAD-MATRX-TABLE THRU 2500-EXIT     
                       SET WS-INDEX1 UP BY 1                            
                    END-IF                                              
              WHEN SPACE                                                
                       MOVE 'Y'           TO WS-END-OF-TABLE            
              WHEN OTHER                                                
                       MOVE WS-ERR-COMMENT2 TO S-CR-COMMENTS            
                       MOVE '1550'          TO ACTIVE-PARAGRAPH         
                       MOVE SPACES          TO ABEND-FUNCTION           
                       MOVE SPACES          TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                       MOVE SPACES          TO TABLE-1                  
                       MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1          
                       MOVE WS-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1        
                                                                        
                       IF CSR-DATABASE                                  
                          PERFORM 7900-CSR-MISSING-DATA                 
                                                     THRU 7900-EXIT     
                       ELSE                                             
                          PERFORM 7950-SEB-MISSING-DATA                 
                                                     THRU 7950-EXIT     
                       END-IF                                           
                       PERFORM 9950-ERROR-LOG        THRU 9950-EXIT     
                                                                        
           END-EVALUATE.                                                
      *                                                                         
       1550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1560-ERR-PROCESS.                                             *         
      *     PROCESS THE ERROR.                                        *         
      *****************************************************************         
      *                                                                         
       1560-ERR-PROCESS.                                                
                                                                        
           IF PARM-FORMAT-ERR > SPACE                                   
              MOVE PARM-FORMAT-ERR        TO DG-CR-SCORE-CD             
              MOVE 'FE'                   TO DG-CR-SCORE-TYPE-CD        
           ELSE                                                         
              IF PARM-VALID-ERR > SPACE                                 
                 MOVE PARM-VALID-ERR      TO DG-CR-SCORE-CD             
                 MOVE 'VE'                TO DG-CR-SCORE-TYPE-CD        
              ELSE                                                      
                 IF PARM-PROCESS-ERR > SPACE                            
                    MOVE PARM-PROCESS-ERR TO DG-CR-SCORE-CD             
                    MOVE 'PE'             TO DG-CR-SCORE-TYPE-CD        
A05007           END-IF                                                 
A05007        END-IF                                                    
A05007     END-IF.                                                      
                                                                        
A05007     IF DG-CR-SCORE-TYPE-CD EQUAL 'FE' OR 'VE' OR 'PE'            
A05007        MOVE    DG-CR-SCORE-TYPE-CD    TO KG-CR-SCORE-TYPE-CD     
A05007        MOVE    DG-CR-SCORE-CD         TO KG-CR-SCORE-CD          
A05007        PERFORM 7600-SELECT-TXT-DESC   THRU 7600-EXIT             
           ELSE                                                         
A05007        MOVE WS-ERR-COMMENT3                   TO S-CR-COMMENTS   
A05007        IF CSR-DATABASE                                           
A05007           PERFORM 7900-CSR-MISSING-DATA       THRU 7900-EXIT     
A05007        ELSE                                                      
A05007           PERFORM 7950-SEB-MISSING-DATA       THRU 7950-EXIT     
A05007        END-IF                                                    
A05007           PERFORM 9950-ERROR-LOG              THRU 9950-EXIT     
           END-IF.                                                      
A04527     MOVE PARM-HDR-RETURN-CODE    TO WS-HDR-RETURN-CODE.          
           MOVE '1560'                  TO ACTIVE-PARAGRAPH.            
           MOVE SPACES                  TO ABEND-FUNCTION.              
           MOVE SPACES                  TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES.                
           MOVE SPACES                  TO TABLE-1.                     
           MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1.             
           MOVE WS-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1.           
           PERFORM 7350-CRED-BUR-MATRX               THRU 7350-EXIT     
           PERFORM 2500-LOAD-MATRX-TABLE             THRU 2500-EXIT.    
      *                                                                         
       1560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1570-HIER-TABLE-NOITPA.                                       *         
      * USE THE WS-CRED-MSG-TABLE TO LOAD THE WS-MATRIX-TABLE WHEN    *         
      * ITPA HAS BEEN UPDATED TO RESOLVE.                             *         
      *****************************************************************         
      *                                                                         
       1570-HIER-TABLE-NOITPA.                                          
                                                                        
           MOVE WS-CR-SCORE-TYPE-CD(WS-INDEX3)                          
                                          TO DG-CR-SCORE-TYPE-CD        
           EVALUATE  DG-CR-SCORE-TYPE-CD                                
              WHEN 'I '                                                 
                    CONTINUE                                            
              WHEN 'H '                                                 
                    IF PARM-HIT-CD > SPACE                              
                       MOVE PARM-HIT-CD   TO DG-CR-SCORE-CD             
                       PERFORM 7350-CRED-BUR-MATRX   THRU 7350-EXIT     
                       PERFORM 2500-LOAD-MATRX-TABLE THRU 2500-EXIT     
                       SET WS-INDEX1 UP BY 1                            
                    END-IF                                              
              WHEN 'S '                                                 
                    IF PARM-SAFESCAN-CD > SPACE                         
                       MOVE PARM-SAFESCAN-CD                            
                                          TO DG-CR-SCORE-CD             
                       PERFORM 7350-CRED-BUR-MATRX   THRU 7350-EXIT     
                       PERFORM 2500-LOAD-MATRX-TABLE THRU 2500-EXIT     
                       SET WS-INDEX1 UP BY 1                            
                    END-IF                                              
              WHEN 'M '                                                 
                    IF PARM-MATCH-CD > SPACE                            
                       MOVE PARM-MATCH-CD TO DG-CR-SCORE-CD             
                       PERFORM 7350-CRED-BUR-MATRX   THRU 7350-EXIT     
                       PERFORM 2500-LOAD-MATRX-TABLE THRU 2500-EXIT     
                       SET WS-INDEX1 UP BY 1                            
                    END-IF                                              
              WHEN 'R '                                                 
A05198              IF PARM-REJ-CD > SPACE                              
A05198                 MOVE PARM-REJ-CD                                 
                                          TO DG-CR-SCORE-CD             
                       PERFORM 7350-CRED-BUR-MATRX   THRU 7350-EXIT     
                       PERFORM 2500-LOAD-MATRX-TABLE THRU 2500-EXIT     
                       SET WS-INDEX1 UP BY 1                            
                    END-IF                                              
              WHEN SPACE                                                
                       MOVE 'Y' TO WS-END-OF-TABLE                      
              WHEN OTHER                                                
                       MOVE WS-ERR-COMMENT2 TO S-CR-COMMENTS            
                       MOVE '1570'          TO ACTIVE-PARAGRAPH         
                       MOVE SPACES          TO ABEND-FUNCTION           
                       MOVE SPACES          TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                       MOVE SPACES          TO TABLE-1                  
                       MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1          
                       MOVE WS-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1        
                                                                        
                       IF CSR-DATABASE                                  
                          PERFORM 7900-CSR-MISSING-DATA                 
                                                     THRU 7900-EXIT     
                       ELSE                                             
                          PERFORM 7950-SEB-MISSING-DATA                 
                                                     THRU 7950-EXIT     
                       END-IF                                           
                       PERFORM 9950-ERROR-LOG        THRU 9950-EXIT     
           END-EVALUATE.                                                
      *                                                                         
       1570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1650-DEFAULT-CURSOR.                                                    
      *  PROCESS THE DEFAULT CURSOR                                             
      *****************************************************************         
      *                                                                         
       1650-DEFAULT-CURSOR.                                             
                                                                        
           MOVE 'D%'         TO DG-CR-SCORE-TYPE-CD                     
           PERFORM 7400-OPEN-DEFAULT-CSR             THRU 7400-EXIT     
           PERFORM 7450-FETCH-DEFAULT-CSR            THRU 7450-EXIT     
      *                                                                         
           INITIALIZE  WS-DEFAULT-TABLE                                 
      *                                                                         
           SET WS-INDEX2     TO  1                                      
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
           PERFORM 2450-LOAD-DEFAULT-TABLE           THRU 2450-EXIT     
           PERFORM 7450-FETCH-DEFAULT-CSR            THRU 7450-EXIT     
           END-PERFORM                                                  
           PERFORM 7500-CLOSE-DEFAULT-CSR            THRU 7500-EXIT.    
                                                                        
       1650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2000-MAIN-PROCESS.                                      *              
      *                                                          *      00109720
      ************************************************************      00109730
       2000-MAIN-PROCESS.                                               
      *                                                                         
           MOVE 'N'                       TO WS-ITPA-EXISTS             
           IF WS-PROGRAM = 'CSR02329'                                   
              IF PARM-ITPA-EXISTS-CD > SPACE                            
                 PERFORM 2100-CHECK-ITPA-MATRIX        THRU 2100-EXIT   
                 UNTIL ITPA-EXISTS  OR END-OF-MATRIX-TABLE = 'Y'        
                 IF NOT ITPA-EXISTS                                     
                    MOVE WS-ERR-COMMENT15 TO S-CR-COMMENTS              
                    MOVE '2000'           TO ACTIVE-PARAGRAPH           
                    MOVE SPACES           TO ABEND-FUNCTION             
                    MOVE SPACES           TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                    MOVE 'WS-MATRIX-DATA' TO TABLE-1                    
                    MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1            
                    MOVE WS-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1          
                                                                        
                   IF CSR-DATABASE                                      
                      PERFORM 7900-CSR-MISSING-DATA  THRU 7900-EXIT     
                   ELSE                                                 
                      PERFORM 7950-SEB-MISSING-DATA  THRU 7950-EXIT     
                   END-IF                                               
                   PERFORM 9950-ERROR-LOG            THRU 9950-EXIT     
                 END-IF                                                 
      *                                                                 24200000
              ELSE                                                      
                 PERFORM 2200-CHECK-APPL-STATUS     THRU 2200-EXIT      
              END-IF                                                    
      *                                                                 24200000
           ELSE                                                         
              PERFORM 2200-CHECK-APPL-STATUS        THRU 2200-EXIT      
           END-IF.                                                      
      *                                                                 24200000
           IF CTR-ROWS < 1                                              
      *                                                                 24200000
              IF WS-ACTIVE-RETURN-CODE  EQUAL ZEROES                    
                 IF WS-4071-WQ-RET-CODE EQUAL 290                       
                    MOVE WS-4071-WQ-RET-CODE   TO RS-RETURN-CODE        
                 ELSE                                                   
                    MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE        
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE    TO  RS-RETURN-CODE       
              END-IF                                                    
      *                                                                 24370000
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
      *                                                                 24370000
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************     00109710
      *  2100-CHECK-ITPA-MATRIX.                                  *             
      *   CHECK FOR ITPA EXISTANCE IN MATRIX WORKING STORAGE TABLE*     00109720
      *************************************************************     00109730
       2100-CHECK-ITPA-MATRIX.                                          
      *                                                                         
           SET WS-INDEX1 TO 1                                           
           SEARCH WS-MATRIX-DATA                                        
              WHEN TAB-CR-SCORE-TYPE-CD(WS-INDEX1) = SPACE              
                   MOVE   'Y'             TO END-OF-MATRIX-TABLE        
              WHEN TAB-CR-SCORE-TYPE-CD(WS-INDEX1) = 'I'                
                   MOVE   'Y'             TO WS-ITPA-EXISTS             
                   MOVE TAB-CR-SCORE-TYPE-CD(WS-INDEX1)                 
                                          TO S-CR-SCORE-TYPE-CD         
                   MOVE TAB-CR-SCORE-CD(WS-INDEX1)                      
                                          TO S-CR-SCORE-CD              
                   MOVE TAB-APPL-STATUS-CD(WS-INDEX1)                   
                                          TO S-APPL-STATUS-CD           
                   MOVE TAB-APPL-RESULT-CD(WS-INDEX1)                   
                                          TO S-APPL-RESULT-CD           
                   MOVE TAB-APPL-RESPONSE-CD(WS-INDEX1)                 
                                          TO S-APPL-RESPONSE-CD         
                   MOVE TAB-CREDIT-ACTION-FL(WS-INDEX1)                 
                                          TO WS-CREDIT-ACTION-FL        
                   EVALUATE  WS-CREDIT-ACTION-FL                        
                         WHEN 'S '                                      
A05198                         PERFORM 2760-SCORE-COMPARE THRU 2760-EXIT
                         WHEN OTHER                                     
                               MOVE TAB-CREDIT-ACTION-FL(WS-INDEX1)     
                                          TO S-CR-ACTION-FL             
                   END-EVALUATE                                         
           END-SEARCH.                                                  
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2200-CHECK-APPL-STATUS.                                 *              
      *  CHECKS FOR APPL-STATUS.                                 *      00109720
      ************************************************************      00109730
       2200-CHECK-APPL-STATUS.                                          
      *                                                                         
           IF DENY-EXISTS                                               
              SET WS-INDEX1 TO 1                                        
              SEARCH WS-MATRIX-DATA                                     
                 AT END                                                 
                    MOVE WS-ERR-COMMENT9  TO S-CR-COMMENTS              
                    MOVE '2200'           TO ACTIVE-PARAGRAPH           
                    MOVE SPACES           TO ABEND-FUNCTION             
                    MOVE SPACES           TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                    MOVE 'WS-MATRIX-DATA' TO TABLE-1                    
                    MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1            
                    MOVE WS-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1          
                    IF CSR-DATABASE                                     
                       PERFORM 7900-CSR-MISSING-DATA  THRU 7900-EXIT    
                    ELSE                                                
                       PERFORM 7950-SEB-MISSING-DATA  THRU 7950-EXIT    
                    END-IF                                              
                    PERFORM 9950-ERROR-LOG            THRU 9950-EXIT    
      *                                                                         
                 WHEN TAB-APPL-STATUS-CD(WS-INDEX1) = 'D'               
                      PERFORM 2600-REG-PROCESS       THRU 2600-EXIT     
      *                                                                         
                 WHEN TAB-APPL-STATUS-CD(WS-INDEX1) = SPACES            
                      MOVE WS-ERR-COMMENT9  TO S-CR-COMMENTS            
                      MOVE '2200'           TO ACTIVE-PARAGRAPH         
                      MOVE SPACES           TO ABEND-FUNCTION           
                      MOVE SPACES           TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                      MOVE 'WS-MATRIX-DATA' TO TABLE-1                  
                      MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1          
                      MOVE WS-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1        
                      IF CSR-DATABASE                                   
                         PERFORM 7900-CSR-MISSING-DATA  THRU 7900-EXIT  
                      ELSE                                              
                         PERFORM 7950-SEB-MISSING-DATA  THRU 7950-EXIT  
                      END-IF                                            
                      PERFORM 9950-ERROR-LOG            THRU 9950-EXIT  
              END-SEARCH                                                
      *                                                                         
           ELSE                                                         
              IF ONHOLD-EXISTS                                          
                 SET WS-INDEX1 TO 1                                     
                 SEARCH WS-MATRIX-DATA                                  
                   AT END                                               
                      MOVE WS-ERR-COMMENT10 TO S-CR-COMMENTS            
                      MOVE '2200'           TO ACTIVE-PARAGRAPH         
                      MOVE 'ONHOLD-EXISTS'  TO ABEND-FUNCTION           
                      MOVE SPACES           TO ABEND-SQL-PREDICATES     
                                             ABEND-TABLES               
                      MOVE 'WS-MATRIX-DATA'                             
                                            TO TABLE-1                  
                      MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1          
                      MOVE WS-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1        
                      IF CSR-DATABASE                                   
                         PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT   
                      ELSE                                              
                         PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT   
                      END-IF                                            
                      PERFORM 9950-ERROR-LOG          THRU 9950-EXIT    
      *                                                                         
                    WHEN TAB-APPL-STATUS-CD(WS-INDEX1) = 'O'            
                        IF CSR-DATABASE                                 
                           MOVE '448'        TO WS-WQ-CATEGORY-ID       
P00342                     MOVE 'N'          TO WS-WQ-PRIORITY          
                           MOVE WS-WQ-ONHOLD-COMMENTS                   
                                             TO WS-WQ-COMMENTS-TEXT     
                           MOVE LENGTH OF WS-WQ-ONHOLD-COMMENTS         
                                             TO  WS-WQ-COMMENTS-LEN     
                           PERFORM 2800-CREATE-WQ      THRU 2800-EXIT   
                        END-IF                                          
                        PERFORM 2600-REG-PROCESS    THRU 2600-EXIT      
      *                                                                         
                    WHEN TAB-APPL-STATUS-CD(WS-INDEX1) = SPACES         
                        MOVE WS-ERR-COMMENT10 TO S-CR-COMMENTS          
                        MOVE '2200'           TO ACTIVE-PARAGRAPH       
                        MOVE 'ONHOLD-EXISTS'  TO ABEND-FUNCTION         
                        MOVE SPACES           TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                        MOVE 'WS-MATRIX-DATA' TO TABLE-1                
                        MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1        
                        MOVE WS-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1      
                        IF CSR-DATABASE                                 
                           PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT 
                        ELSE                                            
                           PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT 
                        END-IF                                          
                        PERFORM 9950-ERROR-LOG          THRU 9950-EXIT  
                 END-SEARCH                                             
      *                                                                         
              ELSE                                                      
                 SET WS-INDEX1 TO 1                                     
                 SEARCH WS-MATRIX-DATA                                  
                   AT END                                               
                        PERFORM 2700-DEFAULT-PROCESS THRU 2700-EXIT     
                    WHEN TAB-APPL-RESULT-CD(WS-INDEX1) NOT = SPACES     
                        PERFORM 2600-REG-PROCESS     THRU 2600-EXIT     
                    WHEN TAB-APPL-STATUS-CD(WS-INDEX1) = SPACES         
                        PERFORM 2700-DEFAULT-PROCESS THRU 2700-EXIT     
                 END-SEARCH                                             
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           IF ( CSR-DATABASE AND S-CR-SCORE-TYPE-CD = 'S' )             
              EVALUATE S-CR-SCORE-CD                                    
                       WHEN 'A '                                        
                       WHEN 'I '                                        
                       WHEN 'M '                                        
A04880                 WHEN 'O'                                         
                             MOVE '449'        TO WS-WQ-CATEGORY-ID     
P00342                       MOVE 'N'          TO WS-WQ-PRIORITY        
                             MOVE  WS-WQ-APPL-STAT-COMMENTS             
                                               TO  WS-WQ-COMMENTS-TEXT  
                             MOVE  LENGTH OF WS-WQ-APPL-STAT-COMMENTS   
                                               TO  WS-WQ-COMMENTS-LEN   
                             PERFORM 2800-CREATE-WQ     THRU 2800-EXIT  
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
P00342     IF CSR-DATABASE                                              
P00342        IF S-CR-SCORE-TYPE-CD = 'M' AND S-CR-SCORE-CD = '0'       
P00342           MOVE '499'                 TO WS-WQ-CATEGORY-ID        
P00342           MOVE 'H'                   TO WS-WQ-PRIORITY           
P00342           MOVE  WS-WQ-POSID-COMMENTS TO WS-WQ-COMMENTS-TEXT      
P00342           MOVE  LENGTH OF WS-WQ-POSID-COMMENTS                   
P00342                                      TO  WS-WQ-COMMENTS-LEN      
P00342           PERFORM 2800-CREATE-WQ     THRU 2800-EXIT              
P00342        END-IF                                                    
P00342     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2400-LOAD-CURR-CRED-MSG-TBL.                            *              
      *     LOAD WS-CRED-MSG-TABLE.                              *      00109720
      ************************************************************      00109730
       2400-LOAD-CURR-CRED-MSG-TBL.                                     
      *                                                                         
           MOVE CW-CR-SCORE-TYPE-CD       TO                            
                                         WS-CR-SCORE-TYPE-CD(WS-INDEX3) 
           MOVE CW-CRED-MSG-PRIORITY      TO                            
                                         WS-CRED-MSG-PRIORITY(WS-INDEX3)
           PERFORM 7250-FETCH-CRED-MSG-CSR           THRU 7250-EXIT     
                                                                        
           SET WS-INDEX3 UP BY 1.                                       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2450-LOAD-DEFAULT-TABLE.                                *              
      *     LOAD WS-DEFAULT-TABLE.                               *      00109720
      ************************************************************      00109730
       2450-LOAD-DEFAULT-TABLE.                                         
      *                                                                         
           MOVE DG-CR-SCORE-TYPE-CD       TO                            
                                      DEF-CR-SCORE-TYPE-CD(WS-INDEX2).  
           MOVE DG-CR-SCORE-CD            TO                            
                                      DEF-CR-SCORE-CD(WS-INDEX2).       
           MOVE DG-CREDIT-ACTION-FL       TO                            
                                      DEF-CREDIT-ACTION-FL(WS-INDEX2).  
           MOVE DG-APPL-STATUS-CD         TO                            
                                      DEF-APPL-STATUS-CD(WS-INDEX2).    
           MOVE DG-APPL-RESULT-CD         TO                            
                                      DEF-APPL-RESULT-CD(WS-INDEX2).    
           MOVE DG-APPL-RESPONSE-CD       TO                            
                                      DEF-APPL-RESPONSE-CD(WS-INDEX2).  
           MOVE DG-CR-RQST-REASON-CD      TO                            
                                      DEF-CR-RQST-REASON-CD(WS-INDEX2). 
           SET  WS-INDEX2 UP BY 1.                                      
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2500-LOAD-MATRX-TABLE                                   *              
      *     LOAD WS-MATRIX-TABLE.                                *      00109720
      ************************************************************      00109730
       2500-LOAD-MATRX-TABLE.                                           
      *                                                                         
           MOVE DG-CR-RQST-REASON-CD      TO                            
                                     TAB-CR-RQST-REASON-CD(WS-INDEX1).  
           MOVE DG-CR-SCORE-TYPE-CD       TO                            
                                     TAB-CR-SCORE-TYPE-CD(WS-INDEX1).   
           MOVE DG-CR-SCORE-CD            TO                            
                                     TAB-CR-SCORE-CD(WS-INDEX1).        
           MOVE DG-CREDIT-ACTION-FL       TO                            
                                     TAB-CREDIT-ACTION-FL(WS-INDEX1).   
           MOVE DG-APPL-STATUS-CD         TO                            
                                     TAB-APPL-STATUS-CD(WS-INDEX1).     
           MOVE DG-APPL-RESULT-CD         TO                            
                                     TAB-APPL-RESULT-CD(WS-INDEX1).     
           MOVE DG-APPL-RESPONSE-CD    TO                               
                                     TAB-APPL-RESPONSE-CD(WS-INDEX1).   
           EVALUATE DG-APPL-STATUS-CD                                   
                   WHEN 'D '                                            
                       MOVE 'Y' TO WS-DENY-EXISTS                       
                   WHEN 'O '                                            
                       MOVE 'Y' TO WS-ONHOLD-EXISTS                     
           END-EVALUATE.                                                
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2600-REG-PROCESS.                                       *              
      *  CHECKS FOR CREDIT ACTION FLAG  AND MOVES THE VALUE TO   *      00109720
      *  OUT PUT PARAMETER.                                      *      00109720
      ************************************************************      00109730
       2600-REG-PROCESS.                                                
      *                                                                         
           MOVE TAB-CR-SCORE-TYPE-CD(WS-INDEX1)                         
                                          TO S-CR-SCORE-TYPE-CD         
           MOVE TAB-CR-SCORE-CD(WS-INDEX1)                              
                                          TO S-CR-SCORE-CD              
           MOVE TAB-APPL-STATUS-CD(WS-INDEX1)                           
                                          TO S-APPL-STATUS-CD           
           MOVE TAB-APPL-RESULT-CD(WS-INDEX1)                           
                                          TO S-APPL-RESULT-CD           
           MOVE TAB-APPL-RESPONSE-CD(WS-INDEX1)                         
                                          TO S-APPL-RESPONSE-CD         
           MOVE TAB-CREDIT-ACTION-FL(WS-INDEX1)                         
                                          TO WS-CREDIT-ACTION-FL        
           EVALUATE WS-CREDIT-ACTION-FL                                 
                 WHEN 'S '                                              
A05198                 PERFORM 2760-SCORE-COMPARE THRU 2760-EXIT        
                 WHEN OTHER                                             
                       MOVE TAB-CREDIT-ACTION-FL(WS-INDEX1)             
                                          TO S-CR-ACTION-FL             
           END-EVALUATE.                                                
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  2700-DEFAULT-PROCESS.                                   *              
      *   PROCESS THE DEFAULT TABLE.                             *      00109720
A03119*   NEW RQST-REASON OF 'H' (HVAC) NEES TO BE TREATED LIKE  *              
A03119*   MERCHANDISE.                                           *              
      ************************************************************      00109730
      *                                                                         
       2700-DEFAULT-PROCESS.                                            
      *                                                                         
           SET WS-INDEX1 TO 1                                           
           MOVE SPACES   TO WS-ACTION-FL                                
      *                                                                         
           EVALUATE TAB-CR-RQST-REASON-CD(WS-INDEX1)                    
      *                                                                         
              WHEN 'M '                                                 
A03119        WHEN 'H '                                                 
                 MOVE 'O' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE '1' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE '5' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE 'W' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE 'S' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 ELSE                                                   
                    MOVE WS-ERR-COMMENT12  TO S-CR-COMMENTS             
                    MOVE '2700'            TO ACTIVE-PARAGRAPH          
                    MOVE 'TAB-CR-RQST-REASON-CD'                        
                                           TO ABEND-FUNCTION            
                    MOVE SPACES            TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                    MOVE 'WS-MATRIX-DATA'  TO TABLE-1                   
                    MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1           
                    MOVE WS-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1         
                    IF CSR-DATABASE                                     
                       PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT     
                    ELSE                                                
                       PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT     
                    END-IF                                              
                    PERFORM 9950-ERROR-LOG  THRU 9950-EXIT              
                 END-IF                                                 
      *                                                                         
              WHEN OTHER                                                
                 MOVE 'C' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE 'B' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE 'W' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 END-IF                                                 
                 MOVE 'S' TO WS-ACTION-FL                               
                 PERFORM 2750-SEARCH-MAT-TABL    THRU 2750-EXIT         
                 IF ROW-FOUND                                           
                    GO TO 2700-EXIT                                     
                 ELSE                                                   
                    MOVE WS-ERR-COMMENT12  TO S-CR-COMMENTS             
                    MOVE '2700'            TO ACTIVE-PARAGRAPH          
                    MOVE 'TAB-CR-RQST-REASON-CD'                        
                                           TO ABEND-FUNCTION            
                    MOVE SPACES            TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                    MOVE 'WS-MATRIX-DATA'  TO TABLE-1                   
                    MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1           
                    MOVE WS-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1         
                    IF CSR-DATABASE                                     
                       PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT     
                    ELSE                                                
                       PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT     
                    END-IF                                              
                    PERFORM 9950-ERROR-LOG  THRU 9950-EXIT              
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      * 2750-SEARCH-MAT-TABL                                     *              
      * PROCESS TO SEARCH THE MATRIX TABLE                       *              
      ************************************************************      00109730
      *                                                                         
       2750-SEARCH-MAT-TABL.                                            
      *                                                                         
           SET WS-INDEX1 TO 1                                           
      *                                                                         
           SEARCH WS-MATRIX-DATA                                        
           AT END                                                       
              CONTINUE                                                  
           WHEN TAB-CREDIT-ACTION-FL(WS-INDEX1) = WS-ACTION-FL          
                IF WS-ACTION-FL  = 'S'                                  
A05198             PERFORM 2760-SCORE-COMPARE   THRU 2760-EXIT          
A05198             MOVE S-CR-ACTION-FL          TO                      
                                        TAB-CREDIT-ACTION-FL(WS-INDEX1) 
                   IF S-CR-ACTION-FL = 'R'                              
                      MOVE 'D'                  TO                      
                                        TAB-APPL-STATUS-CD(WS-INDEX1)   
                                        S-APPL-STATUS-CD                
                   END-IF                                               
                   PERFORM 2900-SEARCH-DEF-TABL THRU 2900-EXIT          
                ELSE                                                    
                   PERFORM 2900-SEARCH-DEF-TABL THRU 2900-EXIT          
                   MOVE DEF-CREDIT-ACTION-FL(WS-INDEX2)                 
                                                TO S-CR-ACTION-FL       
                END-IF                                                  
      *                                                                         
           WHEN TAB-CREDIT-ACTION-FL(WS-INDEX1) = SPACES                
              CONTINUE                                                  
           END-SEARCH.                                                  
      *                                                                         
       2750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A05198 2760-SCORE-COMPARE.                                              
A05198     MOVE PARM-BEACON-SCORE                TO WS-SCORE-ALPHA.     
A05198     MOVE WS-SCORE-ALPHA                   TO WS-SCORE-DEC.       
A05198     MOVE WS-SCORE-DEC                     TO WS-SCORE.           
A05198     MOVE 'B'                              TO D6-SCORE-MODEL-CD.  
A05198     PERFORM 7550-DEP-REQUIREMENT          THRU 7550-EXIT.        
A05198     MOVE D6-CREDIT-ACTION-FL              TO WS-CR-ACTION-FL-B.  
A05198     MOVE D6-SPECIAL-OFFER-CD              TO WS-SPECIAL-OFFER-B. 
A05198     IF PARM-ADDL-SCORE-IND = '1'                                 
A05198        MOVE PARM-ADDL-SCORE               TO WS-SCORE-ALPHA      
A05198        MOVE WS-SCORE-ALPHA                TO WS-SCORE-DEC        
A05198        MOVE WS-SCORE-DEC                  TO WS-SCORE            
A05198        MOVE 'A'                           TO D6-SCORE-MODEL-CD   
A05198        PERFORM 7550-DEP-REQUIREMENT       THRU 7550-EXIT         
A05198        MOVE D6-CREDIT-ACTION-FL           TO WS-CR-ACTION-FL-A   
A05198        MOVE D6-SPECIAL-OFFER-CD           TO WS-SPECIAL-OFFER-A  
A05198***********   COMPARE A TO B AND MOVE BEST TO S-CR-ACTION-FL              
A05198*CREDIT_ACTION_FL    R        DENY                                        
A05198*CREDIT_ACTION_FL    C        COLLECT                                     
A05198*CREDIT_ACTION_FL    B        BILL                                        
A05198*CREDIT_ACTION_FL    W        WAIVE                                       
A05198*CREDIT_ACTION_FL    W  AND SPECIAL-OFFER-CD = 'P' = PREPAY               
A05198        EVALUATE TRUE                                             
A05198          WHEN (WS-CR-ACTION-FL-B           = 'W' AND             
A05198                WS-SPECIAL-OFFER-B          = ' ')                
A05198               MOVE WS-CR-ACTION-FL-B      TO S-CR-ACTION-FL      
A05198               MOVE 'B'                    TO S-SCORE-MODEL-CD    
A05198          WHEN (WS-CR-ACTION-FL-A           = 'W' AND             
A05198                WS-SPECIAL-OFFER-A          = ' ')                
A05198               MOVE WS-CR-ACTION-FL-A      TO S-CR-ACTION-FL      
A05198               MOVE 'A'                    TO S-SCORE-MODEL-CD    
A05198          WHEN WS-CR-ACTION-FL-B           = 'B'                  
A05198               MOVE WS-CR-ACTION-FL-B      TO S-CR-ACTION-FL      
A05198               MOVE 'B'                    TO S-SCORE-MODEL-CD    
A05198          WHEN WS-CR-ACTION-FL-A           = 'B'                  
A05198               MOVE WS-CR-ACTION-FL-A      TO S-CR-ACTION-FL      
A05198               MOVE 'A'                    TO S-SCORE-MODEL-CD    
A05198          WHEN (WS-CR-ACTION-FL-B           = 'W' AND             
A05198                WS-SPECIAL-OFFER-B          = 'P')                
A05198               MOVE WS-CR-ACTION-FL-B      TO S-CR-ACTION-FL      
A05198               MOVE 'B'                    TO S-SCORE-MODEL-CD    
A05198          WHEN (WS-CR-ACTION-FL-A           = 'W' AND             
A05198                WS-SPECIAL-OFFER-A          = 'P')                
A05198               MOVE WS-CR-ACTION-FL-A      TO S-CR-ACTION-FL      
A05198               MOVE 'A'                    TO S-SCORE-MODEL-CD    
A05198          WHEN WS-CR-ACTION-FL-B           = 'C'                  
A05198               MOVE WS-CR-ACTION-FL-B      TO S-CR-ACTION-FL      
A05198               MOVE 'B'                    TO S-SCORE-MODEL-CD    
A05198          WHEN WS-CR-ACTION-FL-A           = 'C'                  
A05198               MOVE WS-CR-ACTION-FL-A      TO S-CR-ACTION-FL      
A05198               MOVE 'A'                    TO S-SCORE-MODEL-CD    
A05198          WHEN WS-CR-ACTION-FL-B           = 'R'                  
A05198               MOVE WS-CR-ACTION-FL-B      TO S-CR-ACTION-FL      
A05198               MOVE 'B'                    TO S-SCORE-MODEL-CD    
A05198          WHEN WS-CR-ACTION-FL-A           = 'R'                  
A05198               MOVE WS-CR-ACTION-FL-A      TO S-CR-ACTION-FL      
A05198               MOVE 'A'                    TO S-SCORE-MODEL-CD    
A05198     ELSE                                                         
A05198        MOVE D6-CREDIT-ACTION-FL           TO S-CR-ACTION-FL      
A05198        MOVE 'B'                           TO S-SCORE-MODEL-CD    
A05198     END-IF.                                                      
A05198*                                                                         
A05198     IF ((PARM-BEACON-SCORE    = SPACES OR ZEROES) AND            
A05198         (PARM-ADDL-SCORE      = SPACES OR ZEROES))               
A05198         MOVE SPACES                       TO S-SCORE-MODEL-CD    
A05198     END-IF.                                                      
A05198*                                                                         
A05198 2760-EXIT.                                                       
A05598     EXIT.                                                        
      ******************************************************************        
      *   2800-CREATE-WQ                                               *        
      *                                                                *        
      *   1.  CREATE WQ                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2800-CREATE-WQ.                                                  
      *                                                                         
ACT084     INITIALIZE                         CWS00077-FIELDS.          
      *                                                                         
ACT084     MOVE ZERO                       TO WS-77-SERV-ORDER-NO.      
ACT084     MOVE WS-WQ-CATEGORY-ID          TO WS-77-CATEGORY-ID.        
ACT084     MOVE ZERO                       TO WS-77-ACCOUNT-NO.         
ACT084     MOVE ZERO                       TO WS-77-PREMISE-NO.         
ACT084     MOVE WS-CUSTOMER-NO             TO WS-77-CUSTOMER-NO.        
ACT084     MOVE PARM-USER-ID               TO WS-77-USER-ID-ORIG.       
ACT084     MOVE ' '                        TO WS-77-RESP-AREA-ID.       
ACT084     MOVE ' '                        TO WS-77-LOCAL-OFFICE.       
ACT084     MOVE '5'                        TO WS-77-ROUTE-CATEGORY.     
ACT084     MOVE WS-WQ-PRIORITY             TO WS-77-PRIORITY.           
ACT084     MOVE WS-WQ-COMMENTS-TEXT        TO WS-77-COMMENTS-TEXT.      
ACT084     MOVE WS-WQ-COMMENTS-LEN         TO WS-77-COMMENTS-LEN.       
ACT084     MOVE SPACE                      TO WS-77-FREE-FORM-TXT.      
ACT084     MOVE ZERO                       TO WS-77-FREE-FORM-LEN.      
ACT084     MOVE PROGRAM-NAME               TO WS-77-CREATED-BY.         
      *                                                                         
           PERFORM 8000-INSERT-WQ          THRU 8000-EXIT.              
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2900-SEARCH-DEF-TABL.                                         *         
      * SEARCH THE DEFAULT TABLE AND MOVE THE VALUE TO THE O/P PARM.  *         
      *****************************************************************         
       2900-SEARCH-DEF-TABL.                                            
      *                                                                         
           SET WS-INDEX2 TO 1.                                          
      *                                                                         
           SEARCH WS-DEFAULT-DATA                                       
              AT END                                                    
                 MOVE WS-ERR-COMMENT13    TO S-CR-COMMENTS              
                 MOVE '2900'              TO ACTIVE-PARAGRAPH           
                 MOVE 'SEARCH-DEF-TABL'   TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'WS-DEFAULT-TABLE'  TO TABLE-1                    
                 MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1            
                 MOVE WS-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1          
                 IF CSR-DATABASE                                        
                    PERFORM 7900-CSR-MISSING-DATA    THRU 7900-EXIT     
                 ELSE                                                   
                    PERFORM 7950-SEB-MISSING-DATA    THRU 7950-EXIT     
                 END-IF                                                 
                 PERFORM 9950-ERROR-LOG              THRU 9950-EXIT     
                                                                        
              WHEN DEF-CR-SCORE-TYPE-CD(WS-INDEX2) (2:1)                
                                  = TAB-APPL-STATUS-CD(WS-INDEX1) AND   
                   DEF-CR-SCORE-CD(WS-INDEX2)                           
                                  = TAB-CREDIT-ACTION-FL(WS-INDEX1)     
                   MOVE 'Y'               TO WS-ROW-FOUND-SW            
                   MOVE DEF-CR-SCORE-TYPE-CD (WS-INDEX2)                
                                          TO S-CR-SCORE-TYPE-CD         
                   MOVE DEF-CR-SCORE-CD (WS-INDEX2)                     
                                          TO S-CR-SCORE-CD              
                   MOVE DEF-APPL-STATUS-CD(WS-INDEX2)                   
                                          TO S-APPL-STATUS-CD           
                   MOVE DEF-APPL-RESULT-CD(WS-INDEX2)                   
                                          TO S-APPL-RESULT-CD           
                   MOVE DEF-APPL-RESPONSE-CD(WS-INDEX2)                 
                                          TO S-APPL-RESPONSE-CD         
              WHEN DEF-CR-SCORE-TYPE-CD(WS-INDEX2) (2:1) = SPACES AND   
                   DEF-CR-SCORE-CD(WS-INDEX2) = SPACES                  
                 MOVE WS-ERR-COMMENT13    TO S-CR-COMMENTS              
                 MOVE '2900'              TO ACTIVE-PARAGRAPH           
                 MOVE 'SEARCH-DEF-TABL'   TO ABEND-FUNCTION             
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                 MOVE 'WS-DEFAULT-TABLE'  TO TABLE-1                    
                 MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1            
                 MOVE WS-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1          
                                                                        
                 IF CSR-DATABASE                                        
                    PERFORM 7900-CSR-MISSING-DATA    THRU 7900-EXIT     
                 ELSE                                                   
                    PERFORM 7950-SEB-MISSING-DATA    THRU 7950-EXIT     
                 END-IF                                                 
                 PERFORM 9950-ERROR-LOG              THRU 9950-EXIT     
           END-SEARCH.                                                  
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16560000
      ******************************************************************16570000
      * 7000-SELECT-CURRENT-TIMESTAMP.                                 *16580000
      *     - THIS MODULE SELECTS THE CURRENT TIMESTAMP                *16590000
      ******************************************************************16600000
       7000-SELECT-CURRENT-TIMESTAMP.                                   
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16620000
MFA-TR*       SET  :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP            16640003
MFA-TR*           ,:WS-CURRENT-DATE      = CURRENT DATE                 16650003
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                    16660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                RS-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ERR-COMMENT16       TO S-CR-COMMENTS              
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE '7000'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SET'                  TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              IF CSR-DATABASE                                           
                 PERFORM 7900-CSR-MISSING-DATA       THRU 7900-EXIT     
              ELSE                                                      
                 PERFORM 7950-SEB-MISSING-DATA       THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7100-GET-DATABASE.                                            *         
      * CHECK DATABASE TO DETERMINE WHICH REGION THE TRANSACTION      *         
      * IS BEING EXECUTED ON.                                         *         
      *****************************************************************         
                                                                        
       7100-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD = 'DATABASE'                            
                AND  COMPANY_NO = :C8-COMPANY-NO                        
A05007                                                           
A05007                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD = 'DATABASE'                                    
MFA-TR*         AND  COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ERR-COMMENT17      TO S-CR-COMMENTS              
               MOVE 1                     TO WS-DATABASE                
               MOVE '7100'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_DELIQUENCY'      TO TABLE-1                    
               MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1            
               MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2            
               MOVE 'DATABASE'            TO HOSTVAR-ELEMENT-1          
               MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2          
               IF CSR-DATABASE                                          
                  PERFORM 7900-CSR-MISSING-DATA      THRU 7900-EXIT     
               ELSE                                                     
                  PERFORM 7950-SEB-MISSING-DATA      THRU 7950-EXIT     
               END-IF                                                   
               PERFORM 9950-ERROR-LOG                THRU 9950-EXIT     
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-OPEN-CRED-MSG-CSR                                        *         
      * CURSOR TO EXTRACT  CREDIT PRIORITY VALUES.                    *         
      *****************************************************************         
      *                                                                         
       7200-OPEN-CRED-MSG-CSR.                                          
      *                                                                         
           EXEC SQL                                                     
               OPEN CRED-MSG-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT         TO S-CR-COMMENTS              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_MSG_HIER'    TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF  CSR-DATABASE                                          
                  PERFORM 7900-CSR-MISSING-DATA      THRU 7900-EXIT     
              ELSE                                                      
                  PERFORM 7950-SEB-MISSING-DATA      THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                  THRU 9950-EXIT    
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7250-FETCH-CRED-MSG-CSR                                       *         
      *    FETCH CREDIT MSG CURSOR.                                   *         
      *****************************************************************         
      *                                                                         
       7250-FETCH-CRED-MSG-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               FETCH CRED-MSG-CSR                                       
                INTO :CW-CR-SCORE-TYPE-CD                               
                    ,:CW-CRED-MSG-PRIORITY                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT         TO S-CR-COMMENTS              
              MOVE '7250'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_MSG_HIER'    TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF  CSR-DATABASE                                          
                  PERFORM 7900-CSR-MISSING-DATA      THRU 7900-EXIT     
              ELSE                                                      
                  PERFORM 7950-SEB-MISSING-DATA      THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7300-CLOSE-CRED-MSG-CSR                                       *         
      *    CLOSE CREDIT MSG CURSOR.                                   *         
      *****************************************************************         
      *                                                                         
       7300-CLOSE-CRED-MSG-CSR.                                         
      *                                                                         
           EXEC SQL                                                     
               CLOSE CRED-MSG-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT         TO S-CR-COMMENTS              
              MOVE '7300'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_MSG_HIER'    TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF  CSR-DATABASE                                          
                  PERFORM 7900-CSR-MISSING-DATA      THRU 7900-EXIT     
              ELSE                                                      
                  PERFORM 7950-SEB-MISSING-DATA      THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7350-CRED-BUR-MATRX.                                                   
      *    SELECT FIELDS FROM CSS_CRED_BUR_MATRX.                               
      *****************************************************************         
      *                                                                         
       7350-CRED-BUR-MATRX.                                             
      *                                                                         
           MOVE '7350'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
               SELECT CREDIT_ACTION_FL                                  
                     ,APPL_STATUS_CD                                    
                     ,APPL_RESULT_CD                                    
                     ,APPL_RESPONSE_CD                                  
                     ,CR_RQST_REASON_CD                                 
                     ,CR_SCORE_TYPE_CD                                  
                     ,CR_SCORE_CD                                       
                 INTO :DG-CREDIT-ACTION-FL                              
                     ,:DG-APPL-STATUS-CD                                
                     ,:DG-APPL-RESULT-CD                                
                     ,:DG-APPL-RESPONSE-CD                              
                     ,:DG-CR-RQST-REASON-CD                             
                     ,:DG-CR-SCORE-TYPE-CD                              
                     ,:DG-CR-SCORE-CD                                   
                 FROM CSS_CRED_BUR_MATRX WITH(READUNCOMMITTED)                  
                 WHERE EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
                   AND EXPIRATION_DT    >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
                   AND COMPANY_NO        = :PARM-COMPANY-NO             
                   AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD         
                   AND SENIOR_FL         = :PARM-SENIOR-FL              
                   AND REG_GROUP_CD      = :PARM-REG-GROUP-CD           
                   AND CR_SCORE_TYPE_CD  = :DG-CR-SCORE-TYPE-CD         
                   AND CR_SCORE_CD       = :DG-CR-SCORE-CD              
A05007                                                           
A05007                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CREDIT_ACTION_FL                                          
MFA-TR*              ,APPL_STATUS_CD                                            
MFA-TR*              ,APPL_RESULT_CD                                            
MFA-TR*              ,APPL_RESPONSE_CD                                          
MFA-TR*              ,CR_RQST_REASON_CD                                         
MFA-TR*              ,CR_SCORE_TYPE_CD                                          
MFA-TR*              ,CR_SCORE_CD                                               
MFA-TR*          INTO :DG-CREDIT-ACTION-FL                                      
MFA-TR*              ,:DG-APPL-STATUS-CD                                        
MFA-TR*              ,:DG-APPL-RESULT-CD                                        
MFA-TR*              ,:DG-APPL-RESPONSE-CD                                      
MFA-TR*              ,:DG-CR-RQST-REASON-CD                                     
MFA-TR*              ,:DG-CR-SCORE-TYPE-CD                                      
MFA-TR*              ,:DG-CR-SCORE-CD                                           
MFA-TR*          FROM CSS_CRED_BUR_MATRX                                        
MFA-TR*          WHERE EFFECTIVE_DT     <= :WS-CURRENT-DATE                     
MFA-TR*            AND EXPIRATION_DT    >= :WS-CURRENT-DATE                     
MFA-TR*            AND COMPANY_NO        = :PARM-COMPANY-NO                     
MFA-TR*            AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD                 
MFA-TR*            AND SENIOR_FL         = :PARM-SENIOR-FL                      
MFA-TR*            AND REG_GROUP_CD      = :PARM-REG-GROUP-CD                   
MFA-TR*            AND CR_SCORE_TYPE_CD  = :DG-CR-SCORE-TYPE-CD                 
MFA-TR*            AND CR_SCORE_CD       = :DG-CR-SCORE-CD                      
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 IF DG-CR-SCORE-CD = SPACE                              
                    MOVE WS-ERR-COMMENT6  TO S-CR-COMMENTS              
                    MOVE '7350'           TO ACTIVE-PARAGRAPH           
                    MOVE SPACES           TO ABEND-FUNCTION             
                    MOVE SPACES           TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
                    MOVE SPACES           TO TABLE-1                    
                    MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1            
                    MOVE WS-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1          
                                                                        
                    IF CSR-DATABASE                                     
                       PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT     
                    ELSE                                                
                       PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT     
                    END-IF                                              
                    PERFORM 9950-ERROR-LOG           THRU 9950-EXIT     
                 ELSE                                                   
                    MOVE '460'         TO WS-WQ-CATEGORY-ID             
P00342              MOVE 'N'           TO WS-WQ-PRIORITY                
                    MOVE DG-CR-SCORE-TYPE-CD                            
                                       TO WS-WQ-CR-SCORE-TYPE-CD        
                    MOVE DG-CR-SCORE-CD                                 
                                       TO WS-WQ-CR-SCORE-CD             
                    MOVE  WS-WQ-CRED-BUR-COMMENTS                       
                                          TO WS-WQ-COMMENTS-TEXT        
                    MOVE  LENGTH OF WS-WQ-CRED-BUR-COMMENTS             
                                          TO WS-WQ-COMMENTS-LEN         
                   PERFORM 2800-CREATE-WQ            THRU 2800-EXIT     
                   MOVE SPACE             TO DG-CR-SCORE-CD             
                   PERFORM 7350-CRED-BUR-MATRX       THRU 7350-EXIT     
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-ERR-COMMENT7        TO S-CR-COMMENTS           
                 MOVE '7350'                 TO ACTIVE-PARAGRAPH        
                 MOVE SPACES                 TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE SPACES                 TO TABLE-1                 
                 MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1         
                 MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1       
                                                                        
                 IF CSR-DATABASE                                        
                    PERFORM 7900-CSR-MISSING-DATA       THRU 7900-EXIT  
                 ELSE                                                   
                    PERFORM 7950-SEB-MISSING-DATA       THRU 7950-EXIT  
                 END-IF                                                 
                 PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7400-OPEN-DEFAULT-CSR                                                   
      * CURSOR TO EXTRACT  CREDIT BUREAU MATRIX VALUES.                         
      *****************************************************************         
      *                                                                         
       7400-OPEN-DEFAULT-CSR.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN DEFAULT-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT8        TO S-CR-COMMENTS              
              MOVE 7400                   TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_BUR_MATRX'   TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF CSR-DATABASE                                           
                 PERFORM 7900-CSR-MISSING-DATA       THRU 7900-EXIT     
              ELSE                                                      
                 PERFORM 7950-SEB-MISSING-DATA       THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7450-FETCH-DEFAULT-CSR                                                  
      *    FETCH DEFAULT CURSOR.                                                
      *****************************************************************         
      *                                                                         
       7450-FETCH-DEFAULT-CSR.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH DEFAULT-CSR                                        
                INTO :DG-CR-SCORE-TYPE-CD                               
                    ,:DG-CR-SCORE-CD                                    
                    ,:DG-CREDIT-ACTION-FL                               
                    ,:DG-APPL-STATUS-CD                                 
                    ,:DG-APPL-RESULT-CD                                 
                    ,:DG-APPL-RESPONSE-CD                               
                    ,:DG-CR-RQST-REASON-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT8        TO S-CR-COMMENTS              
              MOVE '7450'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_BUR_MATRX'   TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF CSR-DATABASE                                           
                 PERFORM 7900-CSR-MISSING-DATA       THRU 7900-EXIT     
              ELSE                                                      
                 PERFORM 7950-SEB-MISSING-DATA       THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-CLOSE-DEFAULT-CSR                                        *         
      *    CLOSE DEFAULT CURSOR.                                      *         
      *****************************************************************         
      *                                                                         
       7500-CLOSE-DEFAULT-CSR.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE DEFAULT-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT8        TO S-CR-COMMENTS              
              MOVE '7500'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_CRED_BUR_MATRX'   TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF CSR-DATABASE                                           
                 PERFORM 7900-CSR-MISSING-DATA       THRU 7900-EXIT     
              ELSE                                                      
                 PERFORM 7950-SEB-MISSING-DATA       THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *  7550-DEP-REQUIREMENT.                                        *         
      *    SELECT FIELDS FROM CSS_DEP_REQUIREMNT.                     *         
      *****************************************************************         
      *                                                                         
       7550-DEP-REQUIREMENT.                                            
      *                                                                         
           MOVE '7550'          TO ACTIVE-PARAGRAPH.                    
                                                                        
ACT191     IF  CSR-DATABASE                                             
           EXEC SQL                                                     
               SELECT TOP(1) CREDIT_ACTION_FL                                  
                 INTO :D6-CREDIT-ACTION-FL                              
                 FROM CSS_DEP_REQUIREMNT WITH(READUNCOMMITTED)                  
                 WHERE COMPANY_NO        = :PARM-COMPANY-NO             
                   AND REG_GROUP_CD      = :PARM-REG-GROUP-CD           
                   AND SENIOR_FL         = :PARM-SENIOR-FL              
A05198             AND MIN_SCORE_NO     <= :WS-SCORE                    
A05198             AND MAX_SCORE_NO     >= :WS-SCORE                    
                   AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD         
                   AND EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
A05198             AND SCORE_MODEL_CD    = :D6-SCORE-MODEL-CD           
                  ORDER BY EFFECTIVE_DT DESC                            
                                                  
A05007                                                           
A05007                                                      
           END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CREDIT_ACTION_FL                                          
MFA-TR*          INTO :D6-CREDIT-ACTION-FL                                      
MFA-TR*          FROM CSS_DEP_REQUIREMNT                                        
MFA-TR*          WHERE COMPANY_NO        = :PARM-COMPANY-NO                     
MFA-TR*            AND REG_GROUP_CD      = :PARM-REG-GROUP-CD                   
MFA-TR*            AND SENIOR_FL         = :PARM-SENIOR-FL                      
MFA-TR*            AND MIN_SCORE_NO     <= :WS-SCORE                            
MFA-TR*            AND MAX_SCORE_NO     >= :WS-SCORE                            
MFA-TR*            AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD                 
MFA-TR*            AND EFFECTIVE_DT     <= :WS-CURRENT-DATE                     
MFA-TR*            AND SCORE_MODEL_CD    = :D6-SCORE-MODEL-CD                   
MFA-TR*           ORDER BY EFFECTIVE_DT DESC                                    
MFA-TR*           FETCH FIRST 1 ROW ONLY                                        
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC                                                             
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                     
ACT191     ELSE                                                         
           EXEC SQL                                                     
               SELECT TOP(1) CREDIT_ACTION_FL,
              SPECIAL_OFFER_CD                                  
                 INTO :D6-CREDIT-ACTION-FL,                             
A05198                :D6-SPECIAL-OFFER-CD                              
                 FROM CSS_DEP_REQUIREMNT WITH(READUNCOMMITTED)                  
                 WHERE COMPANY_NO        = :PARM-COMPANY-NO             
                   AND REG_GROUP_CD      = :PARM-REG-GROUP-CD           
                   AND SENIOR_FL         = :PARM-SENIOR-FL              
A05198             AND MIN_SCORE_NO     <= :WS-SCORE                    
A05198             AND MAX_SCORE_NO     >= :WS-SCORE                    
                   AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD         
                   AND EFFECTIVE_DT     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
A05198             AND SCORE_MODEL_CD    = :D6-SCORE-MODEL-CD           
                  ORDER BY EFFECTIVE_DT DESC                            
                                                  
A05007                                                           
A05007                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CREDIT_ACTION_FL,                                         
MFA-TR*               SPECIAL_OFFER_CD                                          
MFA-TR*          INTO :D6-CREDIT-ACTION-FL,                                     
MFA-TR*               :D6-SPECIAL-OFFER-CD                                      
MFA-TR*          FROM CSS_DEP_REQUIREMNT                                        
MFA-TR*          WHERE COMPANY_NO        = :PARM-COMPANY-NO                     
MFA-TR*            AND REG_GROUP_CD      = :PARM-REG-GROUP-CD                   
MFA-TR*            AND SENIOR_FL         = :PARM-SENIOR-FL                      
MFA-TR*            AND MIN_SCORE_NO     <= :WS-SCORE                            
MFA-TR*            AND MAX_SCORE_NO     >= :WS-SCORE                            
MFA-TR*            AND CR_RQST_REASON_CD = :PARM-RQST-REASON-CD                 
MFA-TR*            AND EFFECTIVE_DT     <= :WS-CURRENT-DATE                     
MFA-TR*            AND SCORE_MODEL_CD    = :D6-SCORE-MODEL-CD                   
MFA-TR*           ORDER BY EFFECTIVE_DT DESC                                    
MFA-TR*           FETCH FIRST 1 ROW ONLY                                        
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE
           END-IF.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ERR-COMMENT11       TO S-CR-COMMENTS              
              MOVE '7550'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DEP_REQUIREMNT'   TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
                                                                        
              IF  CSR-DATABASE                                          
                  PERFORM 7900-CSR-MISSING-DATA      THRU 7900-EXIT     
              ELSE                                                      
                  PERFORM 7950-SEB-MISSING-DATA      THRU 7950-EXIT     
              END-IF                                                    
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
A05007*****************************************************************         
A05007*  7600-SELECT-TXT-DESC.                                        *         
A05007*    SELECT FIELDS FROM CSS_CRED_BUR_TXT                        *         
      *****************************************************************         
      *                                                                         
A05007 7600-SELECT-TXT-DESC.                                            
      *                                                                         
A05007     MOVE '7600'          TO ACTIVE-PARAGRAPH.                    
                                                                        
A05007     EXEC SQL                                                     
A05007         SELECT CRED_BUR_TXT                                      
A05007           INTO :KG-CRED-BUR-TXT                                  
A05007           FROM CSS_CRED_BUR_TXT WITH(READUNCOMMITTED)                    
A05007          WHERE CR_SCORE_TYPE_CD  = :KG-CR-SCORE-TYPE-CD          
A05007            AND CR_SCORE_CD       = :KG-CR-SCORE-CD               
A05007                                                           
A05007                                                      
A05007     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CRED_BUR_TXT                                              
MFA-TR*          INTO :KG-CRED-BUR-TXT                                          
MFA-TR*          FROM CSS_CRED_BUR_TXT                                          
MFA-TR*         WHERE CR_SCORE_TYPE_CD  = :KG-CR-SCORE-TYPE-CD                  
MFA-TR*           AND CR_SCORE_CD       = :KG-CR-SCORE-CD                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A05007     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
A05007     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05007         WHEN SUCCESSFUL-CALL                                     
A05007           MOVE KG-CRED-BUR-TXT             TO S-CR-COMMENTS      
A05007         WHEN NOT-FOUND                                           
A05007           MOVE PARM-HDR-RETURN-CODE        TO WS-HDR-RETURN-CODE 
A05007           MOVE WS-ERR-COMMENT3             TO S-CR-COMMENTS      
A05007           IF CSR-DATABASE                                        
A05007              PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT        
A05007           ELSE                                                   
A05007              PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT        
A05007           END-IF                                                 
A05007           PERFORM 9950-ERROR-LOG           THRU 9950-EXIT        
A05007         WHEN OTHER                                               
A05007           MOVE WS-ERR-COMMENT14            TO S-CR-COMMENTS      
A05007           IF CSR-DATABASE                                        
A05007              PERFORM 7900-CSR-MISSING-DATA THRU 7900-EXIT        
A05007           ELSE                                                   
A05007              PERFORM 7950-SEB-MISSING-DATA THRU 7950-EXIT        
A05007           END-IF                                                 
A05007           PERFORM 9950-ERROR-LOG           THRU 9950-EXIT        
A05007     END-EVALUATE.                                                
                                                                        
A05007 7600-EXIT.                                                       
A05007      EXIT.                                                       
      ************************************************************      00109710
      *  7900-CSR-MISSING-DATA.                                  *              
      *   MISSING DATA FOR SCEG & PSNC                           *      00109720
      ************************************************************      00109730
       7900-CSR-MISSING-DATA.                                           
      *                                                                         
           MOVE   'C'                     TO S-APPL-STATUS-CD           
           MOVE   'C'                     TO S-CR-ACTION-FL             
           MOVE   'DE'                    TO S-CR-SCORE-TYPE-CD         
           MOVE   'E'                     TO S-APPL-RESULT-CD           
           MOVE   'E'                     TO S-APPL-RESPONSE-CD         
           MOVE   'E'                     TO S-CR-SCORE-CD.             
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  7950-SEB-MISSING-DATA.                                  *              
      *   MISSING DATA FOR SEB.                                  *      00109720
      ************************************************************      00109730
       7950-SEB-MISSING-DATA.                                           
      *                                                                         
           MOVE  'C'                      TO S-APPL-STATUS-CD           
AP5655     MOVE  'C'                      TO S-CR-ACTION-FL             
           MOVE  'DE'                     TO S-CR-SCORE-TYPE-CD         
           MOVE  'E'                      TO S-CR-SCORE-CD              
           MOVE  'E'                      TO S-APPL-RESULT-CD           
           MOVE  'E'                      TO S-APPL-RESPONSE-CD         
           MOVE ACTIVE-PARAGRAPH          TO WS-ACTIVE-PARAGRAPH        
           MOVE ABEND-FUNCTION            TO WS-ABEND-FUNCTION          
           MOVE TABLE-1                   TO WS-TABLE-1                 
           MOVE TABLE-ELEMENT-1           TO WS-TABLE-ELEMENT-1         
           MOVE HOSTVAR-ELEMENT-1         TO WS-HOSTVAR-ELEMENT-1       
           MOVE '450'                     TO WS-WQ-CATEGORY-ID          
P00342     MOVE 'N'                       TO WS-WQ-PRIORITY             
           MOVE S-CR-COMMENTS(1:100)      TO WS-ERR-COMMENTS            
           MOVE WS-WQ-DATABASE-ERR-COMMENTS                             
                                          TO WS-WQ-COMMENTS-TEXT        
           MOVE  LENGTH OF WS-WQ-DATABASE-ERR-COMMENTS                  
                                          TO WS-WQ-COMMENTS-LEN         
           PERFORM 2800-CREATE-WQ                    THRU 2800-EXIT.    
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      00109710
      *  9950-ERROR-LOG.                                         *              
      *  PROCESS THE ERROR LOG.                                  *      00109720
      ************************************************************      00109730
       9950-ERROR-LOG.                                                  
      *                                                                         
           MOVE PROGRAM-NAME              TO ABEND-PROGRAM.             
           PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT.    
                                                                        
       9950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  8000-INSERT-WQ                                        **              
      **      INSERTS INTO THE TABLE CSS_WQ_ITEMS_MF            **              
      ************************************************************              
      *                                                                         
       8000-INSERT-WQ.                                                  
                                                                        
ACT084     INITIALIZE   WS-MCSCB077-RET-CODE                            
ACT084                  ABEND-FUNCTION.                                 
ACT084                                                                  
ACT084     CALL MCSCB077 USING CWS00077-FIELDS                          
ACT084                        ,ABEND-FILE                               
ACT084                        ,WS-MCSCB077-RET-CODE.                    
ACT084                                                                  
ACT084     IF WS-MCSCB077-RET-CODE  =  SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              MOVE 290                    TO WS-4071-WQ-RET-CODE        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
      *                                                                         
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *8900-SEND-DONE.                                                *         
      *   OPEN THE RESULT SET CURSOR                                  *         
      *****************************************************************         
       8900-SEND-DONE.                                                  
      *                                                                         
           IF RS-RETURN-CODE = 0  OR 290                                
              MOVE RS-RETURN-CODE         TO S-RETURN-CODE              
           ELSE                                                         
              MOVE ZERO                   TO RS-RETURN-CODE             
                                             S-RETURN-CODE              
           END-IF                                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9999-END-PROGRAM                                               *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
      *                                                                         
           IF CTR-ROWS < 1                                              
      *****************************************************************         
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!    *         
      *****************************************************************         
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9950-ERROR-LOG                 THRU 9950-EXIT     
           ELSE                                                         
              PERFORM 8900-SEND-DONE                 THRU 8900-EXIT     
           END-IF                                                       
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALLING/ ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
