       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04070.                                          
       AUTHOR.       COVANSYS.                                          
       DATE-WRITTEN. Oct 2007.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  START/STOP/TRANSFER SERVICE VIA WEB CUSTOMER FILTERING.       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     Program Modification Log                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  10/16/2007 CVNS      INITIAL VERSION                          *        
      *             CHENNAI                                            *        
      *  02/04/2010 SRIDHAR   APPL00002122 - DO NOT PROCESS SPOUSE     *        
      *                       ACTIVE ACCTS                             *        
A03007*  01/06/2011 FMB       EXCLUDE NON-UTILITY ACCOUNTS FROM LOGIC  *        
A03007*                       DETERMINING IF CUSTOMER HAS AN ACTIVE    *        
A03007*                       ACCOUNT                                  *        
A05317*  10/13/2015 FMB       CIA AMOUNT DOUBLING IN CUSTOMER AS SPOUSE*        
A05317*                       SITUATION                                *        
A05317*  06/29/2016 FMB       INCREATE MAX ARRAY SIZE.                 *        
      ******************************************************************        
      *                                                                *        
      *                ---- Basic Sequence Structure ----              *        
      *                                                                *        
      *         0000 - 0999     Main Control Path and Initialization   *        
      *         1000 - 1999     Input Processing Control Path          *        
      *         2000 - 2999     Output Processing Control Path         *        
      *         5000 - 5999     Common Modules                         *        
      *         7000 - 7999     Database Access / Input Modules        *        
      *         8000 - 8999     Output Modules                         *        
      *         9000 - 9799     Termination Modules                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04070'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04070 STARTS HERE'.                  
      *                                                                         
      *****************************************************************         
      *   RETURN FIELD AREA                                           *         
      *****************************************************************         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE               PIC S9(9) COMP VALUE ZERO.     
          05 S-TOTAL-PAST-DUE            PIC S9(09)V99 COMP-3 VALUE +0. 
          05 S-STD-LABR-CHRG             PIC S9(07)V99 COMP-3 VALUE +0. 
          05 S-CIA                       PIC S9(09)V99 COMP-3 VALUE +0. 
          05 S-RELEASE-FLAG              PIC X(01) VALUE  SPACES.       
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE              PIC S9(9) COMP VALUE ZERO.     
          05 RS-TOTAL-PAST-DUE           PIC S9(09)V99 COMP-3 VALUE +0. 
          05 RS-STD-LABR-CHRG            PIC S9(07)V99 COMP-3 VALUE +0. 
          05 RS-CIA                      PIC S9(09)V99 COMP-3 VALUE +0. 
          05 RS-RELEASE-FLAG             PIC X(01) VALUE  SPACES.       
      *                                                                         
       01 WS-ACCT-ARRAY.                                                
          05 WS-ACCT-ARRAY-CNT           PIC S9(7) COMP-3 VALUE +0.     
          05 WS-ACCT-ARRAY-PTR           PIC S9(7) COMP-3 VALUE +0.     
A05317    05 WS-ACCT-ARRAY-ELEMENTS      OCCURS 5000 TIMES              
                                         INDEXED BY WS-INDEX.           
             10 WS-ACCT-ACCOUNT-NO       PIC S9(13)V COMP-3 VALUE +0.   
             10 WS-ACCT-PREMISE-NO       PIC S9(10)V COMP-3 VALUE +0.   
             10 WS-ACCT-CODE-ACCT-STAT   PIC X(1).                      
             10 WS-ACCT-CODE-STAT-REASON PIC X(1).                      
             10 WS-ACCT-CODES-DATA-PRESENT                              
                                         PIC X(32).                     
A05317       10 WS-ACCT-PROCESSED-FL     PIC X(1).                      
      *                                                                         
       01 WS-MISC.                                                      
          05 PROGRAM-NAME                PIC X(08) VALUE 'CSR04070'.    
          05 WS-MCSCB068                 PIC X(08) VALUE 'MCSCB068'.    
          05 WS-RETURN-CODE              PIC S9(01) USAGE COMP.         
          05 WS-TOT-PAST-DUE-UTIL        PIC S9(09)V99 COMP-3           
                                                       VALUE 0.         
          05 WS-TOT-PAST-DUE-NONUTIL     PIC S9(09)V99 COMP-3           
                                                       VALUE 0.         
          05 WS-TOTAL-PAST-DUE           PIC S9(09)V99 COMP-3           
                                                          VALUE 0.      
          05 WS-STD-LABR-CHRG            PIC S9(07)V99 COMP-3           
                                                          VALUE 0.      
          05 WS-RELEASE-FLAG             PIC X(01) VALUE 'Y'.           
          05 WS-AMT-UNUSED-CRR           PIC S9(09)V99 COMP-3           
                                                          VALUE +0.     
          05 WS-TOTAL-AMT-CIA            PIC S9(09)V99 COMP-3           
                                                          VALUE +0.     
          05 WS-TOTAL-PAST-DUE-CHRG      PIC S9(09)V99 COMP-3           
                                                          VALUE 0.      
          05 WS-DIFF-PAST-DUE-CHRG-CIA   PIC S9(09)V99 COMP-3           
                                                          VALUE 0.      
          05 WS-TOT-PAST-DUE-CHRG        PIC S9(09)V99 COMP-3           
                                                          VALUE 0.      
          05 WS-PENDING-ACCT-NO          PIC X(13) VALUE SPACES.        
          05 WS-PENDING-ACCT-NO-NUM      REDEFINES WS-PENDING-ACCT-NO   
                                         PIC 9(13).                     
          05 WS-PENDING-ACCT-NO-COMP3    PIC S9(13)V COMP-3 VALUE +0.   
          05 WS-ACCOUNT-NO               PIC X(13) VALUE SPACES.        
                                                                        
          05 WS-CUSTOMER-NO              PIC X(10) VALUE SPACES.        
          05 WS-CUSTOMER-NO-JST          PIC X(10) JUSTIFIED RIGHT.     
          05 WS-CUSTOMER-NO-NUM          REDEFINES WS-CUSTOMER-NO-JST   
                                         PIC 9(10).                     
          05 WS-CUSTOMER-NO-COMP3        PIC S9(10) COMP-3 VALUE +0.    
          05 WS-COMPANY-NO               PIC X(02) VALUE SPACES.        
          05 WS-ACTIVE-ACCT-CNT          PIC S9(4) COMP-3 VALUE +0.     
          05 WS-NONACT-ACCT-CNT          PIC S9(4) COMP-3 VALUE +0.     
          05 WS-AMT-STARTUP-TRESHOLD     PIC                            
                                             S9(4)V9(5) COMP-3 VALUE +0.
          05 WS-CUTOFF-DELINQ-VALUE      PIC                            
                                             S9(4)V9(5) COMP-3 VALUE +0.
          05 WS-CUT-OFF-DATE             PIC X(10) VALUE SPACES.        
          05 WS-WRITE-OFF-DT             PIC X(10) VALUE SPACES.        
          05 WS-CUTOFF-ACCT              PIC S9(13)V COMP-3 VALUE +0.   
          05 WS-SQLSTATE                 PIC X(05) VALUE '     '.       
          05 WS-MULTIPLE-ROWS            PIC S9(9) VALUE -811 COMP.     
          05 WS-ACCT-CODE-STATUS         PIC X(1).                      
          05 WS-ACCT-CUST                PIC X(01) VALUE ' '.           
          05 WS-SPOUSE                   PIC X(01) VALUE ' '.           
          05 WS-CUST-AS-SPOUSE           PIC X(01) VALUE ' '.           
          05 WS-ACCT-EXISTS              PIC X(01) VALUE 'N'.           
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
          05 WS-NO-MORE-DATA-ACCTCUR     PIC X(01) VALUE 'N'.           
             88 NO-MORE-DATA-ACCTCUR               VALUE 'Y'.           
          05 WS-NO-MORE-DATA-SPOUSECUR   PIC X(01) VALUE 'N'.           
             88 NO-MORE-DATA-SPOUSECUR             VALUE 'Y'.           
                                                                        
      ******************************************************************        
      * INDICATOR VARIABLES.                                           *        
      ******************************************************************        
      *                                                                         
       01 IND-VARIABLES.                                                
          05 WS-NULL-INDICATOR-1         PIC S9(04) COMP.               
          05 WS-NULL-INDICATOR-2         PIC S9(04) COMP.               
          05 WS-NULL-INDICATOR-3         PIC S9(04) COMP.               
          05 WS-NULL-INDICATOR-4         PIC S9(04) COMP.               
          05 WS-NULL-IND                 PIC S9(04) COMP.               
      *                                                                         
      ******************************************************************        
      * SQL ERROR CHECKING COPY BOOKS.                                 *        
      ******************************************************************        
                                                                        
      *01  WS-WARNING-DATA-ELEMENTS.                                            
           COPY CWS00303.                                                       
                                                                        
      *01  CSRERLOG-P.                                                          
           COPY CWSSP001.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR PROCEDURE DIVISION COPY BOOKS              *        
      ******************************************************************        
                                                                        
      *01  WS-CPD68-LINK-RECORD.                                                
      *USED WHILE IN  MCSCB068 MODULE.                                          
           COPY CWS0068L.                                                       
                                                                        
      *01  WS-11-TABLES.                                                        
      *Used in reducing embdded blanks.                                         
           COPY CWS00011.                                                       
                                                                        
      ******************************************************************        
      * DB2 Includes                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CE - CSS_CUST_STATS                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AT - CSS_ACCOUNT                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    AC - CSS_AR_CNTL                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    VO - CSS_SO_DATA                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    V8 - CSS_SO_CHARGES                                                  
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOCHR                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING COPY BOOK.                                      *        
      ******************************************************************        
      *                                                                         
      *01  ABEND-FILE.                                                          
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE TO SUPPORT CPD00068.                           *        
      ******************************************************************        
      *                                                                         
      *01  CWS00068-FIELDS.                                                     
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
      *01  WS-CODES-DATA-PRESENT.                                               
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO POPULATE ACCOUNT TABLE ARRAY.                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE ACCT_CURSOR CURSOR FOR                            
              SELECT                                                    
                     AT.ACCOUNT_NO                                      
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CODE_STATUS_REASON                              
A03007              ,AT.ACCOUNT_TYPE_CODE                               
                FROM                                                    
                     CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                      
               WHERE                                                    
                     AT.CUSTOMER_NO    = :AT-CUSTOMER-NO                
                 AND AT.COMPANY_NO     = :WS-COMPANY-NO                 
                 AND AT.BANKRUPTCY_IND <> 'B'                           
                 AND AT.JUDGEMENT_IND  <> 'J'                           
                 FOR READ ONLY                                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT_CURSOR CURSOR FOR                                    
MFA-TR*       SELECT                                                            
MFA-TR*              AT.ACCOUNT_NO                                              
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CODE_STATUS_REASON                                      
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*         FROM                                                            
MFA-TR*              CSS_ACCOUNT  AT                                            
MFA-TR*        WHERE                                                            
MFA-TR*              AT.CUSTOMER_NO    = :AT-CUSTOMER-NO                        
MFA-TR*          AND AT.COMPANY_NO     = :WS-COMPANY-NO                         
MFA-TR*          AND AT.BANKRUPTCY_IND <> 'B'                                   
MFA-TR*          AND AT.JUDGEMENT_IND  <> 'J'                                   
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO IDENTFY ALL OTHER CUSTOMER NOS FOR CUSTOMER          *        
      * AS A SPOUSE TO COMPUTE PAST DUES FOR THOSE ACCTS.              *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE CUST_CURSOR CURSOR FOR                            
              SELECT                                                    
                     CE.CUSTOMER_NO                                     
                FROM                                                    
                     CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
                    ,CSS_CUST_STATS CE1 WITH(READUNCOMMITTED)                   
               WHERE                                                    
                 CE.CUSTOMER_TYPE = 'S'                                 
                 AND CE.SSN = CE1.SSN                                   
                 AND CE1.CUSTOMER_NO    = :AT-CUSTOMER-NO               
                 AND CE1.CUSTOMER_TYPE   = 'C'                          
                 AND CE1.SSN <> ' '                                     
                 AND CE.CUSTOMER_NO <> CE1.CUSTOMER_NO                  
                 FOR READ ONLY                                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CUST_CURSOR CURSOR FOR                                    
MFA-TR*       SELECT                                                            
MFA-TR*              CE.CUSTOMER_NO                                             
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CUST_STATS CE                                          
MFA-TR*             ,CSS_CUST_STATS CE1                                         
MFA-TR*        WHERE                                                            
MFA-TR*          CE.CUSTOMER_TYPE = 'S'                                         
MFA-TR*          AND CE.SSN = CE1.SSN                                           
MFA-TR*          AND CE1.CUSTOMER_NO    = :AT-CUSTOMER-NO                       
MFA-TR*          AND CE1.CUSTOMER_TYPE   = 'C'                                  
MFA-TR*          AND CE1.SSN <> ' '                                             
MFA-TR*          AND CE.CUSTOMER_NO <> CE1.CUSTOMER_NO                          
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  I-CUSTOMER-NO            PIC X(10).                          
       01  I-PENDING-ACCT-NO        PIC X(13).                          
       01  I-COMPANY-NO             PIC X(02).                          
      *                                                                         
       PROCEDURE DIVISION USING  I-CUSTOMER-NO                          
                               , I-PENDING-ACCT-NO                      
                               , I-COMPANY-NO.                          
      *                                                                         
      ******************************************************************        
      *0000-MAINLINE                                                   *        
      * CONTROLS THE MAIN PROCESSING OF THE PROGRAM.                   *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT.                 
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *0100-INITIALIZATION.                                            *        
      * Initialize Return Fields, Declare GTT and Result Set Cursor.   *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE                AS RETURN_CODE           
                ,:S-TOTAL-PAST-DUE             AS TOTAL_PAST_DUE        
                ,:S-STD-LABR-CHRG              AS STD_LABR_CHRG         
                ,:S-CIA                        AS CIA                   
                ,:S-RELEASE-FLAG               AS RELEASE_FLAG          
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          :S-RETURN-CODE                AS RETURN_CODE                   
MFA-TR*         ,:S-TOTAL-PAST-DUE             AS TOTAL_PAST_DUE                
MFA-TR*         ,:S-STD-LABR-CHRG              AS STD_LABR_CHRG                 
MFA-TR*         ,:S-CIA                        AS CIA                           
MFA-TR*         ,:S-RELEASE-FLAG               AS RELEASE_FLAG                  
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE I-CUSTOMER-NO            TO WS-CUSTOMER-NO.             
           MOVE I-PENDING-ACCT-NO        TO WS-PENDING-ACCT-NO.         
           MOVE I-COMPANY-NO             TO WS-COMPANY-NO.              
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2010-PROCESS-CUST-CURSOR THRU 2010-EXIT.             
           IF WS-ACTIVE-ACCT-CNT = 0 AND WS-NONACT-ACCT-CNT >=1         
             PERFORM 2008-PROCESS-SPOUSE THRU 2008-EXIT                 
             MOVE WS-CUSTOMER-NO-COMP3      TO AT-CUSTOMER-NO           
             PERFORM 2009-PROCESS-CUST-SPOUSE THRU 2009-EXIT            
           END-IF.                                                      
                                                                        
           ADD +1                            TO CTR-ROWS.               
                                                                        
NDSCN1     MOVE WS-TOT-PAST-DUE-UTIL         TO WS-TOT-PAST-DUE-CHRG.   
                                                                        
           IF WS-COMPANY-NO = '26'                                      
              MOVE WS-PENDING-ACCT-NO-COMP3     TO VO-ACCOUNT-NO        
              PERFORM 7110-SEL-STD-LABR-CHRG THRU 7110-EXIT             
              COMPUTE WS-TOT-PAST-DUE-CHRG = WS-TOT-PAST-DUE-UTIL       
                                          + WS-STD-LABR-CHRG            
           END-IF.                                                      
                                                                        
      * SINCE WS-TOTAL-AMT-CIA IS A NEGATIVE VALUE MULTIPLY BY -1               
                                                                        
           IF WS-TOT-PAST-DUE-CHRG <=(-1 * WS-TOTAL-AMT-CIA)            
              MOVE 'Y'                       TO WS-RELEASE-FLAG         
           ELSE                                                         
              COMPUTE WS-DIFF-PAST-DUE-CHRG-CIA =                       
                          WS-TOT-PAST-DUE-CHRG + WS-TOTAL-AMT-CIA       
              PERFORM 7016-SEL-THRESHOLD-AMT THRU 7016-EXIT             
              IF WS-DIFF-PAST-DUE-CHRG-CIA <=                           
                                   WS-AMT-STARTUP-TRESHOLD              
                  MOVE 'Y'                   TO WS-RELEASE-FLAG         
              ELSE                                                      
                  MOVE 'N'                   TO WS-RELEASE-FLAG         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-RETURN-CODE               TO RS-RETURN-CODE.         
           MOVE WS-TOT-PAST-DUE-CHRG         TO RS-TOTAL-PAST-DUE.      
           MOVE WS-STD-LABR-CHRG             TO RS-STD-LABR-CHRG.       
           MOVE WS-TOTAL-AMT-CIA             TO RS-CIA.                 
           MOVE WS-RELEASE-FLAG              TO RS-RELEASE-FLAG.        
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      * PREPARES RESULT SET ROW.                                       *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
           MOVE RS-TOTAL-PAST-DUE         TO S-TOTAL-PAST-DUE.          
           MOVE RS-STD-LABR-CHRG          TO S-STD-LABR-CHRG.           
           MOVE RS-CIA                    TO S-CIA.                     
           MOVE RS-RELEASE-FLAG           TO S-RELEASE-FLAG.            
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2001-PROCESS-ACCT-DUES.                                                 
      * DO NOT PROCESS OTHER DUES IF CUSTOMER HAS ACTIVE ACCTS                  
      * DO NOT PROCESS SPOUSE ACTIVE ACCT FOR DUES                              
      ******************************************************************        
       2001-PROCESS-ACCT-DUES.                                          
      *                                                                         
           MOVE 'N'             TO WS-NO-MORE-DATA-ACCTCUR.             
           PERFORM 7020-OPEN-ACCT-CURSOR     THRU 7020-EXIT.            
           PERFORM 7030-FETCH-ACCT-CURSOR    THRU 7030-EXIT.            
           IF WS-NO-MORE-DATA-ACCTCUR = 'N' THEN                        
             MOVE WS-ACCT-ARRAY-CNT     TO WS-ACCT-ARRAY-PTR            
             PERFORM 2002-PROCESS-ACCT-CURSOR  THRU 2002-EXIT           
                                UNTIL NO-MORE-DATA-ACCTCUR              
           END-IF.                                                      
           PERFORM 7040-CLOSE-ACCT-CURSOR    THRU 7040-EXIT.            
           ADD  +1                TO WS-ACCT-ARRAY-PTR.                 
           IF WS-ACTIVE-ACCT-CNT >= 1 AND WS-ACCT-CUST = 'Y'            
              PERFORM 2004-ACTIVE-PASTDUE    THRU 2004-EXIT             
                VARYING WS-INDEX FROM WS-ACCT-ARRAY-PTR BY 1            
                          UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT            
           ELSE                                                         
              PERFORM 2005-PAST-DUE          THRU 2005-EXIT             
                VARYING WS-INDEX FROM WS-ACCT-ARRAY-PTR BY 1            
                          UNTIL WS-INDEX > WS-ACCT-ARRAY-CNT            
           END-IF.                                                      
                                                                        
       2001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2002-PROCESS-ACCT-CURSOR.                                      *        
      * DO NOT PROCESS ACTIVE ACCTS OF SPOUSE PER MTG & MAIL FROM               
      * TIFFANY NETTLES AND PAT MILLER ON 020110 AND 020310                     
      ******************************************************************        
       2002-PROCESS-ACCT-CURSOR.                                        
            SET WS-INDEX                  TO 1.                         
            SEARCH WS-ACCT-ARRAY-ELEMENTS VARYING WS-INDEX              
            WHEN WS-ACCT-ACCOUNT-NO(WS-INDEX) = AT-ACCOUNT-NO           
                  MOVE 'Y'                TO WS-ACCT-EXISTS             
            END-SEARCH.                                                 
           IF (                                                         
                (WS-SPOUSE NOT EQUAL 'Y'                                
                  OR                                                    
                  AT-CODE-ACCT-STAT NOT EQUAL 'A')                      
               AND                                                      
                 (WS-CUST-AS-SPOUSE NOT EQUAL 'Y'                       
                  OR                                                    
                  AT-CODE-ACCT-STAT NOT EQUAL 'A')                      
               )                                                        
               AND                                                      
               WS-ACCT-EXISTS = 'N' THEN                                
             ADD +1                        TO WS-ACCT-ARRAY-CNT         
             SET WS-INDEX                  TO WS-ACCT-ARRAY-CNT         
             MOVE AT-ACCOUNT-NO            TO WS-ACCT-ACCOUNT-NO        
                                               (WS-INDEX)               
             MOVE AT-CODE-ACCT-STAT     TO WS-ACCT-CODE-ACCT-STAT       
                                               (WS-INDEX)               
             MOVE AT-CODE-STATUS-REASON TO                              
                               WS-ACCT-CODE-STAT-REASON(WS-INDEX)       
             IF AT-CODE-ACCT-STAT = 'A' AND WS-ACCT-CUST = 'Y' AND      
A03007          AT-ACCOUNT-TYPE-CODE NOT = 'N'                          
                     ADD +1                   TO WS-ACTIVE-ACCT-CNT     
             ELSE                                                       
               IF  WS-ACCT-CUST = 'Y'                                   
                  ADD +1                TO WS-NONACT-ACCT-CNT           
               END-IF                                                   
             END-IF                                                     
           END-IF                                                       
           PERFORM 7030-FETCH-ACCT-CURSOR   THRU 7030-EXIT.             
      *                                                                         
       2002-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2004-ACTIVE-PASTDUE.                                           *        
      ******************************************************************        
       2004-ACTIVE-PASTDUE.                                             
      *                                                                         
           IF WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                    
                 OR WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'P'              
              PERFORM 2005-PAST-DUE   THRU 2005-EXIT                    
           END-IF.                                                      
      *                                                                         
       2004-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2005-PAST-DUE.                                                 *        
      ******************************************************************        
       2005-PAST-DUE.                                                   
                                                                        
A05317     IF WS-ACCT-PROCESSED-FL(WS-INDEX) NOT = 'Y'                  
               MOVE WS-ACCT-ACCOUNT-NO(WS-INDEX)                        
                                            TO AT-ACCOUNT-NO            
                                               AC-ACCOUNT-NO            
                                               WS-CUTOFF-ACCT           
               EVALUATE                                                 
                        WS-ACCT-CODE-ACCT-STAT(WS-INDEX)                
               WHEN 'A'                                                 
                  PERFORM 2006-ACTV-OR-FB-ACCT THRU 2006-EXIT           
               WHEN 'B'                                                 
                  PERFORM 2006-ACTV-OR-FB-ACCT THRU 2006-EXIT           
               WHEN 'P'                                                 
                  MOVE 0 TO WS-AMT-UNUSED-CRR                           
                  PERFORM 7015-SEL-ACCT-CIA   THRU 7015-EXIT            
                  ADD WS-AMT-UNUSED-CRR       TO WS-TOTAL-AMT-CIA       
               WHEN 'S'                                                 
                  PERFORM 2007-WRITEOFF-ACCT  THRU 2007-EXIT            
               END-EVALUATE                                             
A05317         MOVE 'Y' TO WS-ACCT-PROCESSED-FL(WS-INDEX)
           END-IF.              
                                                                        
       2005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2006-ACTV-OR-FB-ACCT.                                          *        
      ******************************************************************        
       2006-ACTV-OR-FB-ACCT.                                            
      *                                                                         
           MOVE 0                           TO WS-AMT-UNUSED-CRR        
           PERFORM 7015-SEL-ACCT-CIA        THRU 7015-EXIT              
           ADD WS-AMT-UNUSED-CRR            TO WS-TOTAL-AMT-CIA         
                                                                        
           PERFORM 2011-GET-DUES-FROM-CPD68 THRU 2011-EXIT              
           ADD +1                           TO CTR-ROWS                 
           IF WS-ACCT-CODE-STAT-REASON(WS-INDEX) = 'C'                  
      *     OR WS-ACCT-CODE-ACCT-STAT(WS-INDEX) = 'A'                           
              ADD WS-AMT-FULL-BAL-UTL       TO WS-TOT-PAST-DUE-UTIL     
              ADD WS-AMT-FULL-BAL-NONUTL    TO WS-TOT-PAST-DUE-NONUTIL  
           ELSE                                                         
              ADD WS-AMT-PAST-DUE-UTL       TO WS-TOT-PAST-DUE-UTIL     
                                                                        
              ADD WS-AMT-PAST-DUE-NONUTL    TO WS-TOT-PAST-DUE-NONUTIL  
           END-IF.                                                      
      *                                                                         
       2006-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2007-WRITEOFF-ACCT.                                            *        
      ******************************************************************        
       2007-WRITEOFF-ACCT.                                              
                                                                        
           MOVE 0                           TO WS-AMT-UNUSED-CRR        
           PERFORM 7015-SEL-ACCT-CIA        THRU 7015-EXIT              
           ADD WS-AMT-UNUSED-CRR            TO WS-TOTAL-AMT-CIA         
                                                                        
           PERFORM 7150-SEL-WO-CUTOFF-DT    THRU 7150-EXIT              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7180-SET-CUT-OFF-DT   THRU 7180-EXIT              
           ELSE                                                         
              PERFORM 7190-SET-CUT-OFF-DT   THRU 7190-EXIT              
           END-IF                                                       
                                                                        
           PERFORM 7170-SEL-WRITE-OFF-DT    THRU 7170-EXIT              
           IF WS-WRITE-OFF-DT >= WS-CUT-OFF-DATE                        
              PERFORM 2011-GET-DUES-FROM-CPD68                          
                                            THRU 2011-EXIT              
                                                                        
              ADD +1                        TO CTR-ROWS                 
              ADD WS-AMT-PAST-DUE-UTL       TO WS-TOT-PAST-DUE-UTIL     
                                                                        
              ADD WS-AMT-PAST-DUE-NONUTL    TO WS-TOT-PAST-DUE-NONUTIL  
           END-IF.                                                      
      *                                                                         
       2007-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2008-PROCESS-SPOUSE.                                           *        
      * DO NOT PROCESS SPOUSE ACTIVE ACCTS FOR PAST DUES                        
      * PER MTG AND EMAIL FROM TIFFANY, PAT AND NAKEEAH ON 020110               
      ******************************************************************        
       2008-PROCESS-SPOUSE.                                             
           MOVE 'Y' TO WS-SPOUSE.                                       
           PERFORM 7000-SELECT-SPOUSE-SSN THRU 7000-EXIT.               
           IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
              PERFORM 7010-SELECT-SPOUSE-CUSTNO                         
                                             THRU 7010-EXIT             
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
                 PERFORM 2001-PROCESS-ACCT-DUES THRU 2001-EXIT          
              END-IF                                                    
           END-IF.                                                      
           MOVE ' ' TO WS-SPOUSE.                                       
      *                                                                         
       2008-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2009-PROCESS-CUST-SPOUSE.                                  *            
      ******************************************************************        
       2009-PROCESS-CUST-SPOUSE.                                        
      *                                                                         
           MOVE 'Y' TO WS-CUST-AS-SPOUSE.                               
           PERFORM 7050-OPEN-CUST-CURSOR     THRU 7050-EXIT.            
           PERFORM 7060-FETCH-CUST-CURSOR    THRU 7060-EXIT.            
           PERFORM 2012-PROCESS-CUSTSP-CURSOR  THRU 2012-EXIT           
                                UNTIL NO-MORE-DATA-SPOUSECUR.           
           PERFORM 7070-CLOSE-CUST-CURSOR    THRU 7070-EXIT.            
           MOVE ' ' TO WS-CUST-AS-SPOUSE.                               
       2009-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2010-PROCESS-CUST-CURSOR.                                      *        
      ******************************************************************        
       2010-PROCESS-CUST-CURSOR.                                        
           MOVE WS-PENDING-ACCT-NO-NUM       TO WS-PENDING-ACCT-NO-COMP3
           UNSTRING WS-CUSTOMER-NO DELIMITED BY SPACES INTO             
                                   WS-CUSTOMER-NO-JST.                  
           MOVE WS-CUSTOMER-NO-NUM           TO WS-CUSTOMER-NO-COMP3.   
           MOVE WS-CUSTOMER-NO-COMP3         TO AT-CUSTOMER-NO.         
           MOVE 'Y' TO WS-ACCT-CUST.                                    
           PERFORM 2001-PROCESS-ACCT-DUES    THRU 2001-EXIT.            
           MOVE ' ' TO WS-ACCT-CUST.                                    
      *                                                                         
       2010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 2011-GET-DUES-FROM-CPD68.                                      *        
      ******************************************************************        
       2011-GET-DUES-FROM-CPD68.                                        
      *                                                                         
           PERFORM 7300-GET-ACCT-DET-CPD68 THRU 7300-EXIT               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-CODES-DATA-PRESENT    TO                          
                                        WS-CODES-DATA-PRESENT           
              MOVE SPACES                   TO WS-HOLD-DATE             
              IF WS-NULL-INDICATOR-1 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-00      
              END-IF                                                    
              IF WS-NULL-INDICATOR-2 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-30      
              END-IF                                                    
              IF WS-NULL-INDICATOR-3 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-60      
              END-IF                                                    
              IF WS-NULL-INDICATOR-4 < 0                                
                MOVE SPACES                 TO AT-DATE-BILL-DAY-90      
              END-IF                                                    
              MOVE 'Y' TO CALC-BALANCE-SW                               
                          CALC-ARREARS-SW                               
                          CALC-PAST-DUE-SW                              
                          LOAD-DNP-DATE-SW                              
              PERFORM 9500-CALL-CPD00068    THRU 9500-EXIT              
           END-IF.                                                      
      *                                                                         
       2011-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2012-PROCESS-CUSTSP-CURSOR.                                    *        
      ******************************************************************        
       2012-PROCESS-CUSTSP-CURSOR.                                      
           MOVE CE-CUSTOMER-NO TO AT-CUSTOMER-NO                        
           PERFORM 2001-PROCESS-ACCT-DUES THRU 2001-EXIT.               
           PERFORM 7060-FETCH-CUST-CURSOR    THRU 7060-EXIT.            
      *                                                                         
       2012-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7000-SELECT-SPOUSE-SSN                                         *        
      * SELECTS SPOUSE SSN NO.                                         *        
      ******************************************************************        
      *                                                                         
       7000-SELECT-SPOUSE-SSN.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CE.SSN                                             
                INTO                                                    
                     :CE-SSN                                            
                FROM                                                    
                     CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE                                                    
                     CE.CUSTOMER_NO     = :AT-CUSTOMER-NO               
                 AND CE.CUSTOMER_TYPE   = 'S'                           
                 AND CE.SSN <> ' '                                      
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              CE.SSN                                                     
MFA-TR*         INTO                                                            
MFA-TR*              :CE-SSN                                                    
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CUST_STATS CE                                          
MFA-TR*        WHERE                                                            
MFA-TR*              CE.CUSTOMER_NO     = :AT-CUSTOMER-NO                       
MFA-TR*          AND CE.CUSTOMER_TYPE   = 'S'                                   
MFA-TR*          AND CE.SSN <> ' '                                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_STATS'         TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE CE-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-SELECT-SPOUSE-CUSTNO.                                     *        
      * SELECTS SPOUSE CUSTOMER NO                                     *        
      ******************************************************************        
       7010-SELECT-SPOUSE-CUSTNO.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CE.CUSTOMER_NO                                     
                INTO                                                    
                     :AT-CUSTOMER-NO                                    
                FROM                                                    
                     CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE                                                    
                     CE.SSN             = :CE-SSN                       
                 AND CE.CUSTOMER_TYPE   = 'C'                           
                                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              CE.CUSTOMER_NO                                             
MFA-TR*         INTO                                                            
MFA-TR*              :AT-CUSTOMER-NO                                            
MFA-TR*         FROM                                                            
MFA-TR*              CSS_CUST_STATS CE                                          
MFA-TR*        WHERE                                                            
MFA-TR*              CE.SSN             = :CE-SSN                               
MFA-TR*          AND CE.CUSTOMER_TYPE   = 'C'                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7010'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_STATS'         TO TABLE-1                  
              MOVE 'SSN'                    TO TABLE-ELEMENT-1          
              MOVE CE-SSN                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7015-SEL-ACCT-CIA.                                             *        
      * SELECTS CIA VALUE FOR AN ACCOUNT                               *        
      ******************************************************************        
       7015-SEL-ACCT-CIA.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(AC.AMT_UNUSED_CR)                              
                INTO :WS-AMT-UNUSED-CRR :WS-NULL-INDICATOR-1             
                FROM CSS_AR_CNTL AC WITH(READUNCOMMITTED)                       
               WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO              
                 AND AC.PYMT_PRIORITY_LVL = 70                          
                 AND AC.ITEM_ID           IN(1,2)                       
                 AND AC.AMT_UNUSED_CR     <> 0                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AC.AMT_UNUSED_CR)                                      
MFA-TR*         INTO :WS-AMT-UNUSED-CRR:WS-NULL-INDICATOR-1                     
MFA-TR*         FROM CSS_AR_CNTL AC                                             
MFA-TR*        WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO                      
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = 70                                  
MFA-TR*          AND AC.ITEM_ID           IN(1,2)                               
MFA-TR*          AND AC.AMT_UNUSED_CR     <> 0                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7015'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_AR_CNTL'            TO TABLE-1                  
              MOVE 'AC-ACCOUNT-NO'          TO TABLE-ELEMENT-1          
              MOVE AC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7016-SEL-THRESHOLD-AMT.                                        *        
      * SELECTS TRESHOLD AMT FROM THE DELINQUENCY TABLE                *        
      ******************************************************************        
       7016-SEL-THRESHOLD-AMT.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     C8.DELINQ_VALUE                                    
                INTO                                                    
                     :WS-AMT-STARTUP-TRESHOLD                           
                FROM                                                    
                     CSS_DELINQUENCY C8                                 
               WHERE                                                    
                     C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'            
                 AND C8.COMPANY_NO  = :WS-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '7016'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'SELECT'               TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                               ABEND-TABLES             
                 MOVE 'CSS_DELINQUENCY'      TO TABLE-1                 
                 MOVE 'DELINQ_CD'            TO TABLE-ELEMENT-1         
                 MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-2         
                 MOVE 'AMT-STRTUP-THRESHOLD' TO HOSTVAR-ELEMENT-1       
                 MOVE WS-COMPANY-NO          TO HOSTVAR-ELEMENT-2       
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       7016-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-OPEN-ACCT-CURSOR.                                         *        
      * OPENS ACCT_CURSOR CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       7020-OPEN-ACCT-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              OPEN ACCT_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-FETCH-ACCT-CURSOR.                                        *        
      * FETCHES ACCT_CURSOR CURSOR.                                    *        
      ******************************************************************        
       7030-FETCH-ACCT-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT_CURSOR                                         
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-CODE-ACCT-STAT                                  
                   ,:AT-CODE-STATUS-REASON                              
A03007             ,:AT-ACCOUNT-TYPE-CODE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'Y'                  TO WS-NO-MORE-DATA-ACCTCUR   
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                                                  RS-RETURN-CODE        
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '7030'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1           
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2           
                 MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
                 MOVE WS-COMPANY-NO        TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7040-CLOSE-ACCT-CURSOR.                                        *        
      * CLOSES ACCT_CURSOR CURSOR.                                     *        
      ******************************************************************        
       7040-CLOSE-ACCT-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7040'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7050-OPEN-CUST-CURSOR.                                         *        
      * OPENS ACCT_CURSOR CURSOR.                                      *        
      ******************************************************************        
      *                                                                         
       7050-OPEN-CUST-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
              OPEN CUST_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_CUST_STATS'         TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'SSN'                    TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7060-FETCH-CUST-CURSOR.                                        *        
      * FETCHES CUST_CURSOR CURSOR.                                    *        
      ******************************************************************        
       7060-FETCH-CUST-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              FETCH CUST_CURSOR                                         
               INTO :CE-CUSTOMER-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'Y'                 TO WS-NO-MORE-DATA-SPOUSECUR  
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE SQLCODE              TO ABEND-SQLCODE             
                                                  RS-RETURN-CODE        
                 MOVE SQLSTATE             TO ABEND-SQLSTATE            
                 MOVE '7060'               TO ACTIVE-PARAGRAPH          
                 MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_ACCOUNT'        TO TABLE-1                   
                 MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1           
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2           
                 MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1         
                 MOVE WS-COMPANY-NO        TO HOSTVAR-ELEMENT-2         
                 PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7070-CLOSE-CUST-CURSOR.                                        *        
      * CLOSES CUST_CURSOR CURSOR.                                     *        
      ******************************************************************        
       7070-CLOSE-CUST-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              CLOSE CUST_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
                                               RS-RETURN-CODE           
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
              MOVE 'CUSTOMER_NO'            TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE AT-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1        
              MOVE WS-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7070-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                         
      * 7110-SEL-STD-LABR-CHRG.                                        *        
      * SELECTS STD-LABOR CHARGES                                      *        
      ******************************************************************        
       7110-SEL-STD-LABR-CHRG.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT SUM(VG.STD_LABOR_CHRG)                             
                INTO :WS-STD-LABR-CHRG :WS-NULL-IND                      
                FROM                                                    
                     CSS_SO_DATA    VO WITH(READUNCOMMITTED)                    
                    ,CSS_SO_CHARGES VG WITH(READUNCOMMITTED)                    
               WHERE                                                    
                     VO.ACCOUNT_NO     = :VO-ACCOUNT-NO                 
                 AND VO.SERV_ORDER_NO  = VG.SERV_ORDER_NO               
                 AND VO.ORDER_TYPE_CD  IN ('CC001', 'CC002', 'CC003'    
                                                ,'NC001' )              
                 AND VG.CODE_UTIL_TYPE = 'G'                            
                 AND VO.ORDER_STATE_CD = 'R'                            
                 AND VG.WORK_PERIOD_CD IN ('X', 'Y')                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(VG.STD_LABOR_CHRG)                                     
MFA-TR*         INTO :WS-STD-LABR-CHRG:WS-NULL-IND                              
MFA-TR*         FROM                                                            
MFA-TR*              CSS_SO_DATA    VO                                          
MFA-TR*             ,CSS_SO_CHARGES VG                                          
MFA-TR*        WHERE                                                            
MFA-TR*              VO.ACCOUNT_NO     = :VO-ACCOUNT-NO                         
MFA-TR*          AND VO.SERV_ORDER_NO  = VG.SERV_ORDER_NO                       
MFA-TR*          AND VO.ORDER_TYPE_CD  IN ('CC001', 'CC002', 'CC003'            
MFA-TR*                                         ,'NC001' )                      
MFA-TR*          AND VG.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*          AND VO.ORDER_STATE_CD = 'R'                                    
MFA-TR*          AND VG.WORK_PERIOD_CD IN ('X', 'Y')                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE         =  SUCCESSFUL-CALL OR       
                                               NOT-FOUND OR             
                                               WS-MULTIPLE-ROWS         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7110'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SO_DATA'            TO TABLE-1                  
              MOVE 'CSS_SO_CHARGES'         TO TABLE-2                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'SERV_ORDER_NO'          TO TABLE-ELEMENT-2          
              MOVE VO-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-SEL-WO-CUTOFF-DT.                                         *        
      * SELECT WO-CUTOFF-DT FROM DELINQUENCY TABLE.                    *        
      ******************************************************************        
       7150-SEL-WO-CUTOFF-DT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     C8.DELINQ_VALUE                                    
                INTO                                                    
                     :WS-CUTOFF-DELINQ-VALUE                            
                FROM                                                    
                     CSS_DELINQUENCY C8                                 
               WHERE                                                    
                     C8.DELINQ_CD   = 'WO-CUTOFF-DT'                    
                AND  C8.COMPANY_NO  = :WS-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7150'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_DELINQUENCY'     TO TABLE-1                  
                 MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1          
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2          
                 MOVE 'WO-CUTOFF-DT'        TO HOSTVAR-ELEMENT-1        
                 MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7170-SEL-WRITE-OFF-DT.                                         *        
      * SELECT WRITE_OFF_DT FROM CSS_FINAL_WO TABLE.                   *        
      ******************************************************************        
       7170-SEL-WRITE-OFF-DT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT CAST(AT.ACCT_FINALED_DT AS DATE)                           
                INTO                                                    
                     :WS-WRITE-OFF-DT :WS-NULL-INDICATOR-2               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE                                                    
                     AT.ACCOUNT_NO        = :WS-CUTOFF-ACCT             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(AT.ACCT_FINALED_DT)                                   
MFA-TR*         INTO                                                            
MFA-TR*              :WS-WRITE-OFF-DT:WS-NULL-INDICATOR-2                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE                                                            
MFA-TR*              AT.ACCOUNT_NO        = :WS-CUTOFF-ACCT                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *    EXEC SQL                                                             
      *       SELECT KD.FW_ACTION_DT                                            
      *         INTO                                                            
      *              :WS-WRITE-OFF-DT:WS-NULL-INDICATOR-2                       
      *         FROM CSS_FIN_WO_ACTION KD                                       
      *        WHERE                                                            
      *              KD.ACCOUNT_NO        = :WS-CUTOFF-ACCT                     
      *          AND KD.FW_SEQ_NO         >= 0                                  
      *          AND KD.FW_ACTION_TYPE_CD = 'WO'                                
      *          AND KD.FW_ACTION_AM      > 0                                   
      *          AND KD.FW_ACTION_DT      < CURRENT_DATE                        
      *          AND KD.FW_SEQ_NO         =                                     
      *              (SELECT MAX(KD1.FW_SEQ_NO)                                 
      *                FROM CSS_FIN_WO_ACTION KD1                               
      *                WHERE                                                    
      *                    KD1.ACCOUNT_NO        = KD.ACCOUNT_NO                
      *                AND KD1.FW_ACTION_TYPE_CD = 'WO'                         
      *                AND KD1.FW_ACTION_AM      > 0                            
      *                AND KD1.FW_ACTION_DT      < CURRENT_DATE)                
      *    END-EXEC.                                                            
      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
              WHEN NOT-FOUND                                            
                 CONTINUE                                               
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE '7170'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_FINAL_WO'        TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
                 MOVE WS-CUTOFF-ACCT        TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7180-SET-CUT-OFF-DT - SETS DATE WHEN ROW EXISTS IN              *        
      *                      CSS_DELINQUENCY TABLE                     *        
      ******************************************************************        
       7180-SET-CUT-OFF-DT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( YEAR, -:WS-CUTOFF-DELINQ-VALUE, 
           CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CUT-OFF-DATE      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CUT-OFF-DATE =                                            
MFA-TR*               CURRENT DATE - :WS-CUTOFF-DELINQ-VALUE YEARS              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7180'             TO ACTIVE-PARAGRAPH               
              MOVE 'SET'              TO ABEND-FUNCTION                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7190-SET-CUT-OFF-DT - SETS DATE WHEN NO ROW EXISTS IN           *        
      *                      CSS_DELINQUENCY TABLE                     *        
      ******************************************************************        
       7190-SET-CUT-OFF-DT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CUT-OFF-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CUT-OFF-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7190'             TO ACTIVE-PARAGRAPH               
              MOVE 'SET'              TO ABEND-FUNCTION                 
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7190-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7300-GET-ACCT-DET-CPD68 - GETS ACCT VALUES NEEDED TO CALL       *        
      *                      CPD00068 COPYBOOK                         *        
      ******************************************************************        
       7300-GET-ACCT-DET-CPD68.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT COMPANY_NO,                                         
                   TOTAL_AR_BALANCE,                                    
                   CODE_COMPANY_ACCT,                                   
                   CODE_ACCT_STAT,                                      
                   CODE_STATUS_REASON,                                  
                   PREMISE_NO,                                          
                   CUSTOMER_NO,                                         
                   DATE_LAST_ACTION,                                    
                   LOCAL_OFFICE,                                        
                   CODES_DATA_PRESENT,                                  
                   CREDIT_GROUP,                                        
                   TOTAL_AR_BALANCE,                                    
                   NOTICE_EXEMPT_CD,                                    
                   CODE_DISC_OK,                                        
                   DATE_BILL_DAY_00,                                    
                   DATE_BILL_DAY_30,                                    
                   DATE_BILL_DAY_60,                                    
                   DATE_BILL_DAY_90,                                    
                   BANKRUPTCY_IND,                                      
                   IVR_EXEMPT_CD                                        
            INTO :AT-COMPANY-NO,                                        
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-CODE-COMPANY-ACCT,                                 
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-CODE-STATUS-REASON,                                
                 :AT-PREMISE-NO,                                        
                 :AT-CUSTOMER-NO,                                       
                 :AT-DATE-LAST-ACTION,                                  
                 :AT-LOCAL-OFFICE,                                      
                 :AT-CODES-DATA-PRESENT,                                
                 :AT-CREDIT-GROUP,                                      
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-NOTICE-EXEMPT-CD,                                  
                 :AT-CODE-DISC-OK,                                      
                 :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,              
                 :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,              
                 :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,              
                 :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,              
                 :AT-BANKRUPTCY-IND,                                    
                 :AT-IVR-EXEMPT-CD                                      
              FROM                                                      
                    CSS_ACCOUNT    AT                                   
             WHERE                                                      
                    ACCOUNT_NO  = :AT-ACCOUNT-NO                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7300'             TO ACTIVE-PARAGRAPH               
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
              MOVE 'CSS_ACCOUNT'      TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9500-CALL-CPD00068.                                            *        
      * Calls WS-MCSCB068 as part of CPD00068 process.                 *        
      ******************************************************************        
      *                                                                         
       9500-CALL-CPD00068.                                              
      *                                                                         
           CALL WS-MCSCB068  USING CWS00068-FIELDS                      
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 RS-RETURN-CODE.                        
                                                                        
           MOVE RS-RETURN-CODE        TO WS-ACTIVE-RETURN-CODE          
                                               S-RETURN-CODE            
                                               SQLCODE.                 
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1              TO RS-RETURN-CODE                 
                                               WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                       Program Copy Books                       *        
      ******************************************************************        
      *9700-PROCESS-ABEND                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                  SQL Error Processing Copy Book                *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *9975-ABEND-CONTROL-TRANSFER / 9900-SQL-ERROR-ROUTINE            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *8900-SEND-DONE / 9000-SEND-ERROR-RESULT / 9999-END-PROGRAM      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
      ************************ End of Program **************************        
