       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04060.                                            
       DATE-WRITTEN. 01/09/08.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE CALLED FROM CSR      *        
      *  DESKTOP - PANEL 265                                           *        
      *                                                                *        
      *  THIS PROGRAM UPDATES CSS_FIN_WO_COLLECT                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/09/08  CVNS       INITIAL VERSION                          *        
      *            CHENNAI                                             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04060'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(45) VALUE   
           'WORKING STORAGE FOR SP CSR04060 STARTS HERE'.               
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * AT - CSS_ACCOUNT                                               *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * IZ - CSS_FIN_WO_COLLECT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBFWCLAG                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * MH - CSS_MNT_TRANS_HIST                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * MI - CSS_MT_TRN_HST_DET                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * PF - CSS_REG_PROFILE                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * KV - CSS_FW_ATTRIB_DESC                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBATTDES                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * Q7 - CSS_COLLECT_AGENCY                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCLAGNY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * G6 - CSS_JOB_PARM                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * LR - CSS_REG_PROFILE                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * C8 - CSS-DELINQUENCY                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(8)  VALUE 'CSR04060'.   
           05  WS-CMNT-TXT-LEN            PIC 9(04) COMP.               
           05  WS-CMNT-TXT                PIC X(255).                   
           05  WS-TRANS-COMMENTS-LEN      PIC 9(4) COMP.                
           05  WS-TRANS-COMMENTS          PIC X(255).                   
           05  WS-CHG-APPLIANCE-DESC      PIC X(020).                   
           05  WS-CHG-CONDITION-DESC      PIC X(050).                   
           05  WS-CHG-LOCATION-DESC       PIC X(050).                   
           05  WS-PRV-APPLIANCE-DESC      PIC X(020).                   
           05  WS-PRV-CONDITION-DESC      PIC X(050).                   
           05  WS-PRV-LOCATION-DESC       PIC X(050).                   
           05  WS-COMPANY-NO              PIC X(02).                    
           05  WS-REG-GROUP-CD            PIC X(03).                    
           05  WS-PARM-DATA               PIC X(80).                    
           05  WS-LAST-RUN-DATE-PARM.                                   
               10 FILLER                  PIC X(14)                     
                                              VALUE 'LAST RUN DATE='.   
               10 WS-LAST-RUN-DATE        PIC X(10) VALUE SPACES.       
               10 FILLER                  PIC X(56) VALUE SPACES.       
           05  WS-FINAL-RUN-DATE          PIC X(10) VALUE SPACES.       
           05  WS-SEQ-NO                  PIC S9(9) COMP VALUE 0.       
           05  WS-DATABASE                PIC 9(01) VALUE ZERO.         
               88  CSR-DATABASE                     VALUE 1.            
               88  SEB-DATABASE                     VALUE 2.            
           05  WS-COUNT-FLAG              PIC X(01) VALUE SPACE.        
           05  WS-COUNT                   PIC S9(4) VALUE 0.            
           05  WS-DATE-CHK                PIC S9(2) VALUE 0.            
           05  WS-PRV-COLL-AGY-SUB        PIC X(03).                    
           05  WS-PRV-COLLEC-AGNCY-DESC   PIC X(25).                    
           05  WS-PRV-COLLEC-AGNCY        PIC X(03).                    
           05  WS-CHG-COLLEC-AGNCY-DESC   PIC X(25).                    
           05  WS-ACTION-TYPE-DESC        PIC X(75).                    
           05  WS-UPDATE-ID               PIC X(07).                    
           05  WS-CA-SUB-NULL-IND         PIC S9(04) COMP VALUE 0.      
           05  WS-COLL-AGN-NULL-IND       PIC S9(04) COMP VALUE 0.      
      *                                                                         
       01  WS-MNT-TRANS-HIST.                                           
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-PANEL-NO                PIC X(09)  VALUE 'PANEL265 '. 
      *                                                                         
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-CODE-TRAN-TYPE          PIC X(01)   VALUE 'F'.        
           05  WS-TRAN-APPL-NO            PIC S9(02)  VALUE 0.          
           05  WS-TABLE-ID                PIC X(02).                    
           05  WS-COLUMN-DESC             PIC X(15).                    
           05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(255).                   
           05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(4) USAGE COMP.         
           05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(255).                   
           05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(4) USAGE COMP.         
      *                                                                         
       01  WS-COLLECT-TABLE.                                            
           05  WS-ACCT-NO                 PIC X(13).                    
           05  WS-ACCT-NO-NUM             REDEFINES WS-ACCT-NO          
                                          PIC 9(13).                    
COB305     05 WS-ACCT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.           
           05  WS-ACTION-TYPE             PIC X(05).                    
           05  WS-ACTION-DT               PIC X(10).                    
           05  WS-CODE-COLL-AGY           PIC X(03).                    
           05  WS-COLL-AGY-SUB            PIC X(03).                    
           05  WS-COLL-SEQ-NO             PIC S9(4) USAGE COMP.         
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      *01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
      *                          RESULT-SET-LOCATOR VARYING.            
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-ACCT-NO       PIC X(13).                                
       01  PARM-ACTION-TYPE   PIC X(05).                                
       01  PARM-ACTION-DT     PIC X(10).                                
       01  PARM-CODE-COLL-AGY PIC X(03).                                
       01  PARM-COLL-AGY-SUB  PIC X(03).                                
       01  PARM-CMNT-TXT-LEN  PIC 9(04) COMP.                           
       01  PARM-CMNT-TXT      PIC X(255).                               
       01  PARM-COMPANY-NO    PIC X(02).                                
       01  PARM-SEQ-NO        PIC S9(4) USAGE COMP.                     
       01  PARM-UPDATE-ID     PIC X(07).                                
                                                                        
       PROCEDURE DIVISION USING PARM-ACCT-NO                            
                                PARM-COMPANY-NO                         
                                PARM-SEQ-NO                             
                                PARM-ACTION-TYPE                        
                                PARM-ACTION-DT                          
                                PARM-CODE-COLL-AGY                      
                                PARM-COLL-AGY-SUB                       
                                PARM-CMNT-TXT-LEN                       
                                PARM-CMNT-TXT                           
                                PARM-UPDATE-ID.                         
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                 
            PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                 
            PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                 
            PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                 
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
            EXEC SQL                                                    
                WHENEVER SQLWARNING CONTINUE                            
            END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
                WHENEVER SQLERROR   CONTINUE                            
            END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
                WHENEVER NOT FOUND  CONTINUE                            
            END-EXEC.                                                   
                                                                        
            EXEC SQL                                                    
                DECLARE C1 CURSOR  FOR                       
                SELECT                                                  
                    :S-RETURN-CODE                                      
                FROM CIS.SYSDUMMY1                                   
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*     END-EXEC.                                                           
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
            MOVE PARM-ACCT-NO            TO WS-ACCT-NO.                 
            MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO.              
            MOVE PARM-SEQ-NO             TO WS-COLL-SEQ-NO.             
            MOVE PARM-ACTION-TYPE        TO WS-ACTION-TYPE.             
            MOVE PARM-ACTION-DT          TO WS-ACTION-DT.               
            MOVE PARM-CODE-COLL-AGY      TO WS-CODE-COLL-AGY.           
            MOVE PARM-COLL-AGY-SUB       TO WS-COLL-AGY-SUB.            
            MOVE PARM-CMNT-TXT-LEN       TO WS-CMNT-TXT-LEN.            
            MOVE PARM-CMNT-TXT           TO WS-CMNT-TXT.                
            MOVE PARM-UPDATE-ID          TO WS-UPDATE-ID.               
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
            MOVE WS-ACCT-NO-NUM          TO WS-ACCT-NO-COMP3            
                                            AT-ACCOUNT-NO.              
            MOVE SPACES                  TO WS-TABLE-ID.                
            MOVE WS-CMNT-TXT-LEN         TO WS-TRANS-COMMENTS-LEN.      
            MOVE WS-CMNT-TXT             TO WS-TRANS-COMMENTS.          
            MOVE WS-UPDATE-ID            TO PF-USER-ID.                 
            MOVE '01'                    TO C8-COMPANY-NO.              
            MOVE 'DATABASE'              TO C8-DELINQ-CD.               
            PERFORM 7000-GET-RESP-AREA-ID          THRU 7000-EXIT.      
            PERFORM 7160-SELECT-DELINQ-VALUE       THRU 7160-EXIT.      
            PERFORM 5000-GET-LAST-RUN-DT           THRU 5000-EXIT.      
            PERFORM 7030-GET-CURRENT-DATE          THRU 7030-EXIT.      
                                                                        
            IF WS-ACTION-DT > WS-CURRENT-DATE OR                        
               WS-ACTION-DT > WS-FINAL-RUN-DATE                         
               PERFORM 5200-UPDATE-PREPROCESS      THRU 5200-EXIT       
               PERFORM 8000-UPD-COLLEC-AGENCY      THRU 8000-EXIT       
            ELSE                                                        
               MOVE 300                            TO S-RETURN-CODE     
               ADD  +1                             TO CTR-ROWS          
            END-IF.                                                     
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 5000-GET-LAST-RUN-DT.                                          *        
      ******************************************************************        
       5000-GET-LAST-RUN-DT.                                            
      *                                                                         
           IF SEB-DATABASE                                              
              PERFORM 7100-GET-REG-PROFILE  THRU 7100-EXIT              
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE LR-REG-GROUP-CD TO WS-REG-GROUP-CD                
              ELSE                                                      
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                   MOVE SPACES TO WS-REG-GROUP-CD                       
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES TO WS-REG-GROUP-CD                            
              MOVE +10                      TO WS-SEQ-NO                
           END-IF                                                       
                                                                        
           IF WS-REG-GROUP-CD = '100' THEN                              
               MOVE +100                    TO WS-SEQ-NO                
           ELSE                                                         
              IF WS-REG-GROUP-CD = '200' THEN                           
                 MOVE +200                  TO WS-SEQ-NO                
              ELSE                                                      
                 MOVE +10                   TO WS-SEQ-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7040-SELECT-LAST-RUN-DT  THRU 7040-EXIT.             
                                                                        
           MOVE WS-PARM-DATA                TO WS-LAST-RUN-DATE-PARM.   
                                                                        
           MOVE WS-LAST-RUN-DATE            TO WS-FINAL-RUN-DATE.       
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 5200-UPDATE-PREPROCESS.                                        *        
      ******************************************************************        
       5200-UPDATE-PREPROCESS.                                          
                                                                        
           PERFORM 7050-GET-COLLEC-AGNCY-DET THRU 7050-EXIT.            
           PERFORM 7060-GET-PRV-ACTION-TYPE  THRU 7060-EXIT.            
           PERFORM 7070-GET-PRV-COLLEC-AGNCY THRU 7070-EXIT.            
           PERFORM 7080-GET-CHG-COLLEC-AGNCY THRU 7080-EXIT.            
                                                                        
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'ACTION TYPE'               TO WS-COLUMN-DESC.          
           MOVE 75                          TO WS-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-ACTION-TYPE-DESC         TO WS-PRV-COLUMN-VALUE-TEXT.
           MOVE 75                          TO WS-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-ACTION-TYPE-DESC         TO WS-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'COLLECTION AGENCY'         TO WS-COLUMN-DESC.          
           MOVE 25                          TO WS-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-PRV-COLLEC-AGNCY-DESC    TO WS-PRV-COLUMN-VALUE-TEXT.
           MOVE 25                          TO WS-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLLEC-AGNCY-DESC    TO WS-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
           ADD +1                           TO WS-TRAN-APPL-NO.         
           MOVE 'SUB COLLECTION AGENCY'     TO WS-COLUMN-DESC.          
           MOVE 25                          TO WS-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-PRV-COLL-AGY-SUB         TO WS-PRV-COLUMN-VALUE-TEXT.
           MOVE 25                          TO WS-CHG-COLUMN-VALUE-LEN. 
           MOVE WS-COLL-AGY-SUB             TO WS-CHG-COLUMN-VALUE-TEXT.
           PERFORM 5950-SET-MNT-TRANS-VARS  THRU 5950-EXIT.             
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *    TRANSACTION HISTORY COPY BOOK                               *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5950 SET MNT TRANS VARS                                        *        
      *      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
      *         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
      *         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
      *         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
      *         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
      ******************************************************************        
       5950-SET-MNT-TRANS-VARS.                                         
           MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE WS-CODE-TRAN-TYPE           TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE WS-ACCT-NO-COMP3            TO MH-ACCOUNT-NO.           
           MOVE 0                           TO MH-CUSTOMER-NO.          
           MOVE 0                           TO MH-PREMISE-NO.           
           MOVE WS-UPDATE-ID                TO MH-USER-ID.              
           MOVE WS-PANEL-NO                 TO MH-APPL-PROGRAM-ID.      
           IF WS-TRANS-COMMENTS-LEN > 0                                 
              MOVE WS-TRANS-COMMENTS        TO MH-TRAN-COMMENT-TEXT     
              MOVE WS-TRANS-COMMENTS-LEN    TO MH-TRAN-COMMENT-LEN      
           ELSE                                                         
              MOVE SPACES                   TO MH-TRAN-COMMENT-TEXT     
              MOVE 0                        TO MH-TRAN-COMMENT-LEN      
           END-IF                                                       
      *                                                                         
           MOVE WS-TABLE-ID                 TO MI-TABLE-ID.             
           MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
           MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
           IF WS-PRV-COLUMN-VALUE-LEN > 75                              
              MOVE +75 TO WS-PRV-COLUMN-VALUE-LEN                       
           END-IF.                                                      
           MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
           IF WS-CHG-COLUMN-VALUE-LEN > 75                              
              MOVE +75 TO WS-CHG-COLUMN-VALUE-LEN                       
           END-IF.                                                      
           MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
       5950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000 GET RESP AREA ID                                          *        
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *        
      *         ACCORDING TO A USERS ID.                               *        
      ******************************************************************        
       7000-GET-RESP-AREA-ID.                                           
           MOVE '7000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PF-USER-ID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_USER_PROFILE  '     TO TABLE-1                  
              MOVE 'RESP_AREA_ID'           TO TABLE-ELEMENT-1          
              MOVE PF-USER-ID               TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
       7030-GET-CURRENT-DATE.                                           
                                                                        
            EXEC SQL                                                    
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP           
            END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE,                           
MFA-TR*              :WS-CURRENT-TIMESTAMP= CURRENT TIMESTAMP                   
MFA-TR*     END-EXEC.                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                   
                                                                        
                                                                        
       7030-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7040-SELECT-LAST-RUN-DT.                                       *        
      ******************************************************************        
       7040-SELECT-LAST-RUN-DT.                                         
      *                                                                         
            EXEC SQL                                                    
                SELECT TOP(1) PARM_DATA                                         
                INTO                                                    
                     :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    PROGRAM_NAME = 'PCSCA206'                           
                AND COMPANY_NO   = :WS-COMPANY-NO                       
                AND CMND_CODE    = 'PARM'                               
                AND STATUS       = 'A'                                  
                AND SEQ_NO       = :WS-SEQ-NO                           
                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*              PARM_DATA                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*         WHERE                                                           
MFA-TR*             PROGRAM_NAME = 'PCSCA206'                                   
MFA-TR*         AND COMPANY_NO   = :WS-COMPANY-NO                               
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SEQ_NO       = :WS-SEQ-NO                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7040'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_JOB_PARM'        TO TABLE-1                   
                MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'SEQ-NO'              TO TABLE-ELEMENT-3           
                MOVE 'PCSCA206'            TO HOSTVAR-ELEMENT-1         
                MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE WS-SEQ-NO             TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7050-GET-COLLEC-AGNCY-DET.                                     *        
      ******************************************************************        
       7050-GET-COLLEC-AGNCY-DET.                                       
                                                                        
            EXEC SQL                                                    
                 SELECT COLL_AGY_SUB_CD,                                
                        CODE_COLLEC_AGNCY                               
                   INTO :WS-PRV-COLL-AGY-SUB :WS-CA-SUB-NULL-IND,       
                        :WS-PRV-COLLEC-AGNCY :WS-COLL-AGN-NULL-IND      
                   FROM CSS_FIN_WO_COLLECT                              
                  WHERE ACCOUNT_NO        = :WS-ACCT-NO-COMP3           
                    AND FW_ACTION_TYPE_CD = :WS-ACTION-TYPE             
                    AND FW_COLL_SEQ_NO    = :WS-COLL-SEQ-NO             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF WS-COLL-AGN-NULL-IND = -1                             
                  MOVE SPACES TO WS-PRV-COLLEC-AGNCY                    
               END-IF                                                   
               IF WS-CA-SUB-NULL-IND   = -1                             
                  MOVE SPACES TO WS-PRV-COLL-AGY-SUB                    
               END-IF                                                   
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7050'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                   
                MOVE 'ACTION_TYPE'         TO TABLE-ELEMENT-1           
                MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2           
                MOVE WS-ACTION-TYPE        TO HOSTVAR-ELEMENT-1         
                MOVE WS-ACCT-NO            TO HOSTVAR-ELEMENT-2         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7050-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7060-GET-PRV-ACTION-TYPE.                                      *        
      ******************************************************************        
       7060-GET-PRV-ACTION-TYPE.                                        
      *                                                                         
            EXEC SQL                                                    
                 SELECT FW_ATTR_VALUE_DESC                              
                   INTO :WS-ACTION-TYPE-DESC                            
                   FROM CSS_FW_ATTRIB_DESC                              
                  WHERE FW_ATTRIB_TYPE_CD = 'PL'                        
                    AND FW_ATTR_VALUE_CD  = :WS-ACTION-TYPE             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7060'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_FW_ATTRIB_DESC'  TO TABLE-1                   
                MOVE 'FW_ATTRIB_TYPE_CD'   TO TABLE-ELEMENT-1           
                MOVE 'FW_ATTR_VALUE_CD'    TO TABLE-ELEMENT-2           
                MOVE 'PL'                  TO HOSTVAR-ELEMENT-1         
                MOVE WS-ACTION-TYPE        TO HOSTVAR-ELEMENT-2         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7060-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7070-GET-PRV-COLLEC-AGNCY.                                     *        
      ******************************************************************        
       7070-GET-PRV-COLLEC-AGNCY.                                       
                                                                        
            EXEC SQL                                                    
                 SELECT COLLEC_AGNCY_NAME                               
                   INTO :WS-PRV-COLLEC-AGNCY-DESC                       
                   FROM CSS_COLLECT_AGENCY                              
                  WHERE CODE_COLLEC_AGNCY = :WS-PRV-COLLEC-AGNCY        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7070'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_COLLECT_AGENCY'  TO TABLE-1                   
                MOVE 'CODE_COLLEC_AGNCY'   TO TABLE-ELEMENT-1           
                MOVE WS-PRV-COLLEC-AGNCY   TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7080-GET-CHG-COLLEC-AGNCY.                                     *        
      ******************************************************************        
       7080-GET-CHG-COLLEC-AGNCY.                                       
                                                                        
            EXEC SQL                                                    
                 SELECT COLLEC_AGNCY_NAME                               
                   INTO :WS-CHG-COLLEC-AGNCY-DESC                       
                   FROM CSS_COLLECT_AGENCY                              
                  WHERE CODE_COLLEC_AGNCY = :WS-CODE-COLL-AGY           
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7080'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_COLLECT_AGENCY'  TO TABLE-1                   
                MOVE 'CODE_COLLEC_AGNCY'   TO TABLE-ELEMENT-1           
                MOVE WS-CODE-COLL-AGY      TO HOSTVAR-ELEMENT-1         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7080-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * GET THE REG-PROFILE FORM CSS_REG_PROFILE TABLE.                *        
      ******************************************************************        
       7100-GET-REG-PROFILE.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE                                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7100'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_REG_PROFILE'     TO TABLE-1                    
               MOVE 'REG_GROUP_CD'        TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7160-SELECT-DELINQ-VALUE.                                    *        
      *   SELECT DELINQUENCY VALUE.                                    *        
      ******************************************************************        
       7160-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
              INTO   :C8-DELINQ-VALUE                                   
              FROM   CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE  DELINQ_CD  = :C8-DELINQ-CD                         
              AND    COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*       INTO   :C8-DELINQ-VALUE                                           
MFA-TR*       FROM   CSS_DELINQUENCY                                            
MFA-TR*       WHERE  DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*       AND    COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7160'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_DELINQUENCY'     TO TABLE-1                    
               MOVE 'DELINQ_VALUE'        TO TABLE-ELEMENT-1            
               MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1          
               MOVE C8-COMPANY-NO         TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-UPD-COLLEC-AGENCY.                                        *        
      ******************************************************************        
       8000-UPD-COLLEC-AGENCY.                                          
                                                                        
            EXEC SQL                                                    
                 UPDATE CSS_FIN_WO_COLLECT                              
                    SET COLL_AGY_SUB_CD   = :WS-COLL-AGY-SUB,           
                        CODE_COLLEC_AGNCY = :WS-CODE-COLL-AGY           
                  WHERE ACCOUNT_NO        = :WS-ACCT-NO-COMP3           
                    AND FW_ACTION_TYPE_CD = :WS-ACTION-TYPE             
                    AND FW_COLL_SEQ_NO    = :WS-COLL-SEQ-NO             
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1                     TO CTR-ROWS                   
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '8000'                TO ACTIVE-PARAGRAPH          
                MOVE 'UPDATE'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                   
                MOVE 'CODE_COLLEC_AGNCY'   TO TABLE-ELEMENT-1           
                MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2           
                MOVE WS-CODE-COLL-AGY      TO HOSTVAR-ELEMENT-1         
                MOVE WS-ACCT-NO            TO HOSTVAR-ELEMENT-2         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
